
<?php
    session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Contact | Scoris International Junior School Uganda (SIJSU) &copy;</title>

<!-- Stylesheets -->
<link href="../css/style.css" rel="stylesheet">
<link href="../css/responsive.css" rel="stylesheet">
<link rel="icon" href="../images/logo/ico4.png" type="image/x-icon">

</head>

<!-- page wrapper -->
<body class="boxed_wrapper">


    <!-- search-box-layout -->
    <div class="wraper_flyout_search">
        <div class="table">
            <div class="table-cell">
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-close">
                    <span class="flyout-search-close-line"></span>
                    <span class="flyout-search-close-line"></span>
                </div>
                <div class="flyout_search">
                    <div class="flyout-search-title">
                        <h4>Search</h4>
                    </div>
                    <div class="flyout-search-bar">
                        <form role="search" method="post" action="../search/index.php">
                            <div class="form-row">
                                <input type="search"name="valueToSearch"  placeholder="Search classes, activities or events" required="">
                                <button type="submit" name="search" value="Search"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search-box-layout end -->


    <!-- Main Header -->
    <header class="main-header style-two">

        <div class="header-top">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="header-info pull-left">
                        <ul class="info-list">
                            <li>
                                <i class="fas fa-mobile"></i>
                                <a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a>
                            </li>
                        </ul>
                    </div>
                    <div class="outer-content pull-right">
                        <div class="login-box">
                            <i class="fas fa-user"></i>
                            <a href="../soon">Log in or Register</a>
                        </div>
                        <ul class="clearfix">
                            <li class="header-flyout-searchbar">
                                <i class="fa fa-search"></i>
                            </li>
                            <li><a href="../soon"><i class="fas fa-shopping-cart"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-bottom">
            <div class="container">
                <div class="inner-container">
                    <div class="nav-outer">
                        <div class="menu-area">
                            <nav class="main-menu navbar-expand-lg">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->      
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    </button>
                                </div>
                                <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li><a href="../">Home</a></li>
                                        <li class="dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="../about">About Us</a></li>
                                                <li><a href="../uniforms">About Uniforms</a></li>
                                                <li><a href="../faqs">Faq Page</a></li>
                                                <li><a href="../testimonials">Testimonials</a></li>
                                            </ul>
                                        </li> 
                                        <li class="dropdown"><a href="#">Classes</a>
                                            <ul>
                                                <li><a href="../class">Our Classes</a></li>
                                                <li><a href="../activities">Our Activities</a></li></li>
                                            </ul>
                                        </li> 
                                        <li class="logo-box">
                                            <figure class="logo"><a href="../"><img src="../images/logo/ico4.png" alt="Scoris International"></a></figure>
                                        </li>
                                        <li class="dropdown"><a href="#">Pages</a>
                                            <ul>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../events">Our Events</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="../blog">Blog</a></li>                              
                                        <li class="current"><a href="../contact">Contact</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Sticky Header-->
        <div class="sticky-header">
            <div class="container clearfix">
                <figure class="logo-box"><a href="../"><img src="../images/logo/logo.png" alt="Scoris International"></a></figure>
                <div class="menu-area">
                    <nav class="main-menu navbar-expand-lg">
                        <div class="navbar-header">
                            <!-- Toggle Button -->      
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            </button>
                        </div>
                        <div class="navbar-collapse collapse clearfix">
                            <ul class="navigation clearfix">
                                <li><a href="../">Home</a></li>
                                <li class="dropdown"><a href="#">About</a>
                                    <ul>
                                        <li><a href="../about">About Us</a></li>
                                        <li><a href="../uniforms">About Uniforms</a></li>
                                        <li><a href="../faqs">Faq Page</a></li>
                                        <li><a href="../testimonials">Testimonials</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Classes</a>
                                    <ul>
                                        <li><a href="../class">Our Classes</a></li>
                                        <li><a href="../activities">Our Activities</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Pages</a>
                                    <ul>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                        <li><a href="../events">Our Events</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a href="../blog">Blog</a>
                                </li>                              
                                <li class="current"><a href="../contact">Contact</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div><!-- sticky-header end -->
    </header>
    <!-- End Main Header -->


    <!--Page Title-->
    <section class="page-title centred" style="background-image: url(../images/stock/bg/2.png);background-attachment: fixed;">
        <div class="container">
            <div class="content-box">
                <h1>Contact Us</h1>
                <ul class="bread-crumb clearfix">
                    <li><a href="../">Home</a></li>
                    <li>Contact</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->


    <?php
                if(isset($_SESSION['error'])){
                    echo
                    "
                    <div class='alert alert-danger text-center'>
                        <button class='close'>&times;</button>
                        ".$_SESSION['error']."
                    </div>
                    ";
                    unset($_SESSION['error']);
                }
                if(isset($_SESSION['success'])){
                    echo
                    "
                    <div class='alert alert-success text-center'>
                        <button class='close'>&times;</button>
                        ".$_SESSION['success']."
                    </div>
                    ";
                    unset($_SESSION['success']);
                }
            ?>


    <!-- contact-info-section -->
    <section class="contact-info-section sec-pad centred">
        <div class="container">
            <div class="sec-title">
                <h5>Contact</h5>
                <h1>Get In Touch</h1>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-12 info-column">
                    <div class="single-info-box wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="icon-box"><i class="flaticon-address"></i></div>
                            <h3>Our Location</h3>
                            <div class="text">Makindye Division: Kansanga, Kiwafu Road<br>Opposite Rwizi Arch Hotel</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 info-column">
                    <div class="single-info-box wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="icon-box"><i class="flaticon-vintage-hand-phone"></i></div>
                            <h3>Phone Number</h3>
                            <div class="text">
                                <a href="tel:+256393256880">+256 393 256880</a> <br> <a href="tel:+256700110828">+256 700 110828</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 info-column">
                    <div class="single-info-box wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="icon-box"><i class="flaticon-mail"></i></div>
                            <h3>Email Address</h3>
                            <div class="text">
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a><br />
                                <a href="mailto:help@scorisinternationaljunior.com">help@scorisinternationaljunior.com</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-info-section end -->


    <!-- contact-form-section -->
    <section class="contact-form-section sec-pad">
        <div class="container">
            <div class="sec-title centred">
                <h5>Inquiry</h5>
                <h1>Leave a Message</h1>
            </div>
            <div class="row">
                <div class="col-lg-8 col-md-12 col-sm-12 offset-lg-2 form-column">
                    <div class="contact-form">
                        <form method="post" action="">
                            <div class="row">

                                <div class="col-lg-12 col-md-12 col-sm-12 form-group username"><input type="text" name="username" id="contact_username" placeholder="Username" value=""></div>

                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="text" name="name" id="contact_name" placeholder="Your Name" required>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="email" name="email" id="contact_email" placeholder="Your Email" required>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="number" name="phone" id="contact_phone" placeholder="Your Phone Number" required>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="text" name="subject" id="contact_subject" placeholder="Subject" required>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                    <textarea name="message" id="contact_message" placeholder="Your Message" required></textarea>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group" align="center">
                                    <div class="message-btn"><button type="submit" id="message_btn" class="theme-btn" name="message_btn">Send Message</button></div>
                                </div>
                            </div>

                            <div align="center" id="message_box" style="margin:10px 0px;"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-form-section end -->


    <!-- google-map-section -->
    <section class="google-map-section">
        <div class="map-column">
            <div class="google-map-area">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.7676178281804!2d32.608857199999996!3d0.2888525999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177dbd431f92a227%3A0x57b490184adaf84b!2sScoris%20International%20Junior%20School!5e0!3m2!1sen!2sug!4v1667001802887!5m2!1sen!2sug" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </section>
    <!-- google-map-section end -->


    <!-- main-footer -->
    <footer class="main-footer">
        <div class="footer-top">
            <div class="parallax-scene parallax-scene-4 parallax-icon">
                <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            </div>
            <div class="container">
                <div class="widget-section">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="about-widget footer-widget">
                                <h3 class="widget-title">Our Focus</h3>
                                <div class="widget-content">
                                    <div class="text">
                                        <p>At Scoris international Junior school, every learner is cherished daily. With the Cambridge curriculum and a holistic approach, we inspire both academic excellence and personal growth, ensuring each child feels valued and empowered to thrive.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="link-widget footer-widget">
                                <h3 class="widget-title">Useful Links</h3>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="../about">About Us</a></li>
                                        <li><a href="../contact">Contact Us</a></li>
                                        <li><a href="../class">Classes</a></li>
                                        <li><a href="../activities">Activities</a></li>
                                        <li><a href="../events">Events</a></li>
                                        <li><a href="../gallery">Our Gallery</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                            <div class="contact-widget footer-widget">
                                <h3 class="widget-title">Get in Touch</h3>
                                <div class="widget-content">
                                    <div class="text">Open for enrolment, contact us & join the scoris family</div>
                                    <ul class="info-list">
                                        <li><i class="fas fa-home"></i>Makindye Division, Kansanga Kiwafu Road</li>
                                        <li><i class="fas fa-mobile"></i><a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:registration@scorisinternationaljunior.com">registration@scorisinternationaljunior.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-12 footer-column">
                            <div class="subscribe-widget footer-widget">
                                <h3 class="widget-title">Newsletter</h3>
                                <div class="widget-content">
                                    <div class="text">Receive important scoris updates.</div>
                                    <div class="subscribe-inner">
                                        <form method="POST" name="ContactForm" method="post" action="" class="subscribe-form">
                                            <div class="form-group" align="center">
                                              <div class="username"><input type="text" id="username" name="username" value=""></div>
                                              <input type="hidden" name="subject" id="subject" value="Scoris Newsletter Subscription">
                                                <input type="email" name="email" id="email" placeholder="Email Address" required="">
                                                <button type="submit" name="newsletter" id="newsletter" class="theme-btn" style="border-radius: 10px;">Submit</button>
                                            </div>

                                            <div align="center" class="message_box" style="margin:10px 0px;"></div>

                                        </form>
         
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="left-content pull-left">
                        <div class="copyright">Copyright &copy; <script>document.write(new Date().getFullYear());</script>, <a href="#">Scoris International Junior School</a>. All Rights Reserved</div>

                    </div> <br>
              
                    <div class="right-content pull-right">
                        <figure class="footer-logo"><a href="#"><img src="../images/logo/footer-logo.png" alt="Scoris International"></a></figure>
                        <ul class="social-style-one footer-social clearfix">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="https://instagram.com/ScorisJuniors"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                        </ul>
                    </div>


                    <div class="copyright power-bottom">Powered by <a rel="sponsored" class="text-decoration-none" href="https://customassistinc.com/" target="_blank"><strong>Custom Assist Inc.</strong></a></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- main-footer end -->



<!--Scroll to top-->
<button class="scroll-top scroll-to-target" data-target="html">
    <i class="fa fa-arrow-up"></i>
</button>


<script src="../js/js/jquery.min.js"></script>

<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var subject = $('#subject').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "https://scorisinternationaljunior.com/contact/newsletters/index.php",
             data: "email="+email+"&username="+username+"&subject="+subject+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box').html(
       '<div align="center"><img src="../images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>


<script>
$(document).ready(function() {
  var delay = 500;
  $('#message_btn').click(function(e){
    e.preventDefault();
    
    var contact_username = $('#contact_username').val();
    
    var contact_name = $('#contact_name').val();
    
    var contact_phone = $('#contact_phone').val();
    
    var contact_message = $('#contact_message').val();

    var contact_subject = $('#contact_subject').val();

    var message_btn = $('#message_btn').val();

    var contact_email = $('#contact_email').val();
        if(contact_email == ''){
      $('#message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#contact_email').focus();
            return false;
      }
    if( $("#contact_email").val()!='' ){
      if( !isValidEmailAddress( $("#contact_email").val() ) ){
      $('#message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#contact_email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "contact/index.php",
             data: "contact_name="+contact_name+"&contact_email="+contact_email+"&contact_phone="+contact_phone+"&contact_username="+contact_username+"&contact_subject="+contact_subject+"&contact_message="+contact_message+"&message_btn="+message_btn,
       beforeSend: function() {
       $('#message_box').html(
       '<div align="center"><img src="../images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('#message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});


</script>

<!-- jequery plugins -->
<script src="../js/jquery.js"></script>
<script src="../js/popper.min.js"></script>
<script src="../js/bootstrap.min.js"></script>

<script src="../js/owl.js"></script>
<script src="../js/wow.js"></script>
<script src="../js/validation.js"></script>
<script src="../js/jquery.fancybox.js"></script>
<script src="../js/appear.js"></script>
<script src="../js/parallax.min.js"></script>
<script src="../js/isotope.js"></script>
<script src="../js/jquery-ui.js"></script>  
<script src="../js/jquery.bootstrap-touchspin.js"></script> 

<!-- map script -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA-CE0deH3Jhj6GN4YvdCFZS7DpbXexzGU"></script>
<script src="../js/gmaps.js"></script>
<script src="../js/map-helper.js"></script>

<!-- main-js -->
<script src="../js/script.js"></script>

</body><!-- End of .page_wrapper -->
</html>
