<?php
// Initialize the session
session_start();

include_once("accounts/profile/db/config.php");

// Define variables and initialize with empty values
$fname = $lname = $email = $phone = $status = $address = $occupation = $company = $image = $profile = $user_id = $password = $confirm_password = "";
$fname_err = $lname_err = $email_err = $phone_err = $status_err = $address_err = $occupation_err = $company_err = $image_err = $profile_err = $user_id_err = $password_err = $confirm_password_err = "";
 
?>

<!DOCTYPE html>
<html class="no-js" lang="en-US" itemscope="" itemtype="https://schema.org/WebPage" xmlns:og="http://ogp.me/ns#">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<title>Scoris International Junior School Uganda (SIJSU) &copy;</title>

<meta name="description" content="Every Learner Everyday">
    
<meta name="keywords" content="Scoris International Junior School, Scoris Junior School, Scoris Junior School Uganda, International School, International School, International School Uganda, Junior School, Elementary School">

<meta name="author" content="Custom Webs">


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

    <meta property="og:image" content="https://scorisinternationaljunior.com/images/logo/ico4.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="Scoris International Junior School Uganda (SIJSU) &copy;">

    <meta property="og:url" content="https://scorisinternationaljunior.com/">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="Every Learner Everyday">

    <meta property="og:site_name" content="Scoris International Junior School Uganda (SIJSU) &copy;">
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://scorisinternationaljunior.com/">

    <meta name="twitter:title" content="Scoris International Junior School Uganda (SIJSU) &copy;">

    <meta name="twitter:description" content="Every Learner Everyday">

    <meta name="twitter:image" content="https://scorisinternationaljunior.com/images/logo/ico4.png">

    <meta name="twitter:site" content="@ScorisJuniors">

    <meta name="twitter:creator" content="@iann_thecreator">


<!-- Stylesheets -->
<link href="css/style.css" rel="stylesheet">
<link href="css/responsive.css" rel="stylesheet">

<!-- Favicon -->
<link rel="icon" href="images/logo/ico4.png" type="image/x-icon">

<!-- Canonical -->
<link rel="canonical" href="https://scorisinternationaljunior.com/">


<!--Animations-->
    <link rel="stylesheet" type="text/css" href="css/attention/style.css">  

    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="css/animations/style.css"> 

    <!--Fontawesome 6-->
    <link href="css/fontawesome/css/all.css" rel="stylesheet">


    <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-Q94TVM309B"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-Q94TVM309B');
</script>


<style type="text/css">
    

    .image-box video {
        width: 100%;
        border-radius: 20px;
    }



    /* If the screen size is 770px wide or more */
@media screen and (min-width: 770px) {
    .single-item-img {
        display: none;
    }
 }



/* If the screen size is 601px wide or more */
@media screen and (min-width: 601px) {
    .single-item-img {
        display: none;
    }
 }



/* If the screen size is 600px wide or less */
@media screen and (max-width: 600px) {
    .single-item-img img{
        border-top-left-radius: 5px;
        border-top-right-radius: 5px;
        margin-bottom: 10px;
    }
 }



/*Auto Pop Up*/

.popup{
    position: fixed;
    right: 0;
    bottom: 0;
    width: 350px;
    height: 350px;
    padding: 20px 30px;
    transform: translate(-50%,-50%);
    border-radius: 8px;
    font-family: "Poppins",sans-serif;
    display: none; 
    text-align: center;
    z-index: 9999999;
    background: #253b70;
  background-size: cover;
}


.popup .date {
  color: #86ca50;
}


.popup h2{
  font-weight: bold;
  text-align: center;
  text-transform: uppercase;
  font-size: 16px;
  color: #fbb419;
  text-decoration: underline;
  margin-top: 10px;
  margin-bottom: 20px;
}

.popup h3{
  font-weight: bold;
  text-align: center;
  text-transform: uppercase;
  font-size: 12px;
  color: #fbb419;
  margin-top: -20px;
}

.popup p{
    font-size: 14px;
    margin-top: 60px;
    line-height: 25px;
    text-align: left;
}



.popup a{
  color: #ff7162;
  text-decoration: underline;
}


.popup form {

}


.popup form input {
  margin-top: 10px;
  padding: 5px;
  border: 1px solid #fbb419;
  border-radius: 5px;
  background: none;
}



.popup form input {
  float: left;
  width: 48%;
}



.popup form input[type=submit] {
  display: block;
    position: absolute;
    bottom: 120px;
    right: 30px;
  width: 40%;
  font-size: 15px;
  background: #fbb419;
  color: white;
}



.popup button{
    display: block;
    font-size: 15px;
    color: #fbb419;
    width: 30%;
    padding: 5px;
    border-radius: 5px;
    border: none;
    outline: none;
    cursor: pointer;
    background: black;
    z-index: 9999999;
    margin-bottom: 20px;
}


/* If the screen size is 601px wide or more, set the font-size of <div> to 80px */
@media screen and (min-width: 601px) {
  .popup{
    right: -160px;
    bottom: -160px;
}

.popup h2{
  font-weight: bold;
  font-size: 18px;
  color: #ff7162;
  text-decoration: underline;
}


.popup form input[type=submit] {
    bottom: 90px;
}



.popup button{
    bottom: 90px;
}

 }

/* If the screen size is 600px wide or less, set the font-size of <div> to 30px */
@media screen and (max-width: 600px) {

  .popup{
    width: 300px;
    padding: 5px 0;
    right: -145px;
    bottom: -170px;
}

 }


.countdown-box{
  position: relative;
  display: block;
  background: url();
  width: 100%;
  background-size: cover;
  background-repeat: no-repeat;
  background-position: center;
  border-radius: 20px;
  padding: 30px 40px 30px 40px;
  margin-bottom: 10px;
}

.countdown-timer .counter-column:last-child{
  border-right: none;
}

.countdown-timer .counter-column{
  position: relative;
  text-align: center;
  display: inline-block;
  width: 40px;
  height: 40px;
  background: #fbb419;
  font-family: 'M PLUS Rounded 1c', sans-serif;
  border-radius: 50%;
  margin-right: 10px;
  color: #fff;
  font-size: 12px;
  line-height: 25px;
  font-weight: 500;
}

.countdown-timer .counter-column:nth-child(2){
  background: #43b8e0;
}

.countdown-timer .counter-column:nth-child(3){
  background: #e84174;
}

.countdown-timer .counter-column:last-child{
  margin-right: 0px;
  background: #86ca50;
}

.countdown-timer .counter-column span{
  position: relative;
  display: block;
  color: #fff;
  font-weight: 700;
  font-size: 16px;
  line-height: 15px;
  top: 13px;
  font-family: 'M PLUS Rounded 1c', sans-serif;
}


</style>

</head>

<!-- page wrapper -->
<body class="boxed_wrapper">


    <!-- search-box-layout -->
    <div class="wraper_flyout_search">
        <div class="table">
            <div class="table-cell">
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-close">
                    <span class="flyout-search-close-line"></span>
                    <span class="flyout-search-close-line"></span>
                </div>
                <div class="flyout_search">
                    <div class="flyout-search-title">
                        <h4>Search</h4>
                    </div>
                    <div class="flyout-search-bar">
                        <form role="search" method="post" action="search/index.php">
                            <div class="form-row">
                                <input type="search"name="valueToSearch"  placeholder="Search classes, activities or events" required>
                                <button type="submit" name="search" value="Search"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search-box-layout end -->


    <!-- Main Header -->
    <header class="main-header">

        <div class="header-top">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="social-links pull-left">
                        <ul class="social-list">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-x-twitter"></i></a></li>
                            <li><a href="https://instagram.com/scorisjunior"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                            <li><a href="https://youtube.com"><i class="fab fa-youtube"></i></a></li>
                        </ul>
                    </div>
                    <div class="header-info pull-right">
                        <ul class="info-list">
                            <li>
                                <i class="fas fa-mobile"></i>
                                <a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a>
                            </li>
                            <li>
                                <i class="fas fa-user"></i>
                                <?php echo $email; ?>
                                <a href="accounts">Log in or Register</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-bottom">
            <div class="container">
                <div class="clearfix">
                    <div class="logo-box pull-left">
                        <figure class="logo"><a href="./"><img src="images/logo/ico4.png" alt="Scoris International"></a></figure>
                    </div>
                    <div class="nav-outer pull-right clearfix">
                        <div class="menu-area">
                            <nav class="main-menu navbar-expand-lg">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->      
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    </button>
                                </div>
                                <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li class="current"><a href="#">Home</a></li>
                                        <li><a href="class">Classes</a></li> 
                                        <li><a href="activities">Activities</a></li>
                                        <li><a href="events">Events</a></li>
                                        <li><a href="gallery">Gallery</a></li>
                                        <li><a href="blog">Blog</a></li>  
                                        <li class="dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="about">About Us</a></li>
                                                <li><a href="uniforms">About Uniforms</a></li>
                                                <li><a href="faqs">Faq Page</a></li>
                                                <li><a href="testimonials">Testimonials</a></li>
                                            </ul>
                                        </li>                             
                                        <li><a href="contact">Contact</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                        <div class="outer-box">
                            <ul class="outer-content">
                                <li class="header-flyout-searchbar">
                                    <i class="fa fa-search"></i>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Sticky Header-->
        <div class="sticky-header">
            <div class="container clearfix">
                <figure class="logo-box"><a href=""><img src="images/logo/logo.png" alt="Scoris International"></a></figure>
                <div class="menu-area">
                    <nav class="main-menu navbar-expand-lg">
                        <div class="navbar-header">
                            <!-- Toggle Button -->      
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            </button>
                        </div>
                        <div class="navbar-collapse collapse clearfix">
                            <ul class="navigation clearfix">
                                        <li class="current"><a href="#">Home</a></li>
                                        <li><a href="class">Classes</a></li> 
                                        <li><a href="activities">Activities</a></li>
                                        <li><a href="events">Events</a></li>
                                        <li><a href="gallery">Gallery</a></li>
                                        <li><a href="blog">Blog</a></li>  
                                        <li class="dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="about">About Us</a></li>
                                                <li><a href="uniforms">About Uniforms</a></li>
                                                <li><a href="faqs">Faq Page</a></li>
                                                <li><a href="testimonials">Testimonials</a></li>
                                            </ul>
                                        </li>                             
                                        <li><a href="contact">Contact</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div><!-- sticky-header end -->
    </header>
    <!-- End Main Header -->


<?php
        if(isset($_SESSION['error'])){

          echo
          "
          <div id='msg' class='alert alert-danger text-center'>
            <button onclick='closeConsult()' class='close'>&times;</button>
            ".$_SESSION['error']."
          </div>
          ";
          unset($_SESSION['error']);
        }else{
          echo "";
        }
        if(isset($_SESSION['success'])){
          echo
          "
          <div class='alert alert-success text-center'>
            <button onclick='closeConsult()' class='close'>&times;</button>
            ".$_SESSION['success']."
          </div>
          ";
          unset($_SESSION['success']);
        }else{
          echo "";
        }
      ?>


    <!-- main-slider -->
    <section class="main-slider style-two">
        <div class="main-slider-carousel owl-carousel owl-theme nav-style-two">
            <div class="slide" style="background-image:url(images/stock/bg/2.png)">
                <div class="container">
                    <div class="content-box">
                        <h3>Creating Future Innovators</h3>
                        <h1>Who change the world for the better<span class="flash">.</span></h1>
                        <div class="btn-box"><a href="enrol" class="theme-btn">Join Our Family</a></div>
                    </div>
                </div>
            </div>
            <div class="slide" style="background-image:url(images/stock/bg/3.png)">
                <div class="container">
                    <div class="content-box">
                        <h3>A Child Friendly </h3>
                        <h1>Family Environment</h1>
                        <div class="btn-box"><a href="contact" class="theme-btn">Reach us</a></div>
                    </div>
                </div>
            </div>
            <div class="slide" style="background-image:url(images/stock/bg/12.png)">
                <div class="container">
                    <div class="content-box">
                        <h3>Nurturing curiosity</h3>
                        <h1>In every child</h1>
                        <div class="btn-box"><a href="enrol" class="theme-btn">Enrol Today</a></div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- main-slider end -->


    <!--Start Auto Pop-->

<?php 

     //$result = mysql_query("SELECT * FROM users ORDER BY id DESC"); // mysql_query is deprecated
$result = mysqli_query($mysqli, "SELECT COUNT(*) FROM events WHERE DATE(start) > CURDATE() AND activate=1");

while($row = mysqli_fetch_array($result)) { 

  $pop_count = $row['COUNT(*)'];

  }

  if ($pop_count>0) {

echo '<div class="popup">

        <div class="parallax-scene parallax-scene-3 parallax-icon">
            <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-8"></span>
        </div>';

        echo '<div class="anim-icon">
            <div class="icon icon-1 float-bob-x"></div>
            <div class="icon icon-2 float-bob-y"></div>
        </div>';

        echo '<br>';

        echo '<h2>Coming Next</h2>';

        

     //$result = mysql_query("SELECT * FROM users ORDER BY id DESC"); // mysql_query is deprecated
$result = mysqli_query($mysqli, "SELECT * FROM events WHERE DATE(start) > CURDATE() AND activate=1 ORDER BY start ASC LIMIT 1"); // using mysqli_query instead

    //while($res = mysql_fetch_array($result)) { // mysql_fetch_array is deprecated, we need to use mysqli_fetch_array 
    while($row = mysqli_fetch_array($result)) {

        date_default_timezone_set('Africa/Kampala');

        $start_count = strtotime($row['start']);

    echo "<div class='date' align='center'>".date("jS F Y", strtotime($row['start']))."</div>";
                            
                            echo "<div class='countdown-box'>";
                                echo "<h3>". $row['title'] ."</h3>";
                                echo "<div class='countdown-timer'>";
                                    echo "<div class='countdown-container'>";
                                        echo "<div class='default-coundown'>";
                                            echo "<div class='countdown time-countdown'></div>";
                                        echo "</div>";                       
                                    echo "</div>";                         
                                echo "</div>"; 
                            echo "</div>";
   
    }



    echo '<div align="center">

        <button id="close">Close</button>

    </div>';

        
    echo '</div>';

}

?>

<!--End Auto Pop Up-->



    <!-- testimonial-video -->
    <section class="testimonial-video">
        <div class="anim-icon">
            <div class="icon icon-1 float-bob-y"></div>
        </div>
        <div class="outer-container clearfix">
            <div class="testimonial-column">
                <div class="testimonial-content">
                    <div class="sec-title style-two">
                        <h5>Why Choose Us?</h5>
                        <p>A community school, rich in tradition and dedication to excellence. Our dear ones are working towards academic, artistic and athletic/sport achievements and our dedicated teachers challenge them to do their best everyday opportunities.</p>
                    </div>
                    <div class="inner-content">
                        <div class="client-testimonial-carousel owl-carousel owl-theme">
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="author">Vision</span></div>
                                    <ul class="rating">
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                    </ul>
                                    <div class="text">A center of excellence preparing all learners for global success.</div>
                                </div>
                            </div>
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="author">Mission</div>
                                    <ul class="rating">
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                    </ul>
                                    <div class="text">Inspiring young minds to explore, learn and lead internationally.</div>
                                </div>
                            </div>
                            <div class="testimonial-block">
                                <div class="inner-box">
                                    <div class="author">Core Values</div>
                                    <ul class="rating">
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                        <li><i class="fas fa-star"></i></li>
                                    </ul>
                                    <div class="text">Our pillars of Education, that define who we are. "Play, Learn, Grow, Explore".</div>
                                </div>
                            </div>
                            
                        </div>
                        
                        <!--Client Thumbs Carousel-->
                        <div class="client-thumb-outer">
                            <div class="client-thumbs-carousel owl-carousel owl-theme">
                                <div class="thumb-item">
                                    <figure class="thumb-box"><img src="images/icons/ico/1.png" alt=""></figure>
                                </div>
                                <div class="thumb-item">
                                    <figure class="thumb-box"><img src="images/icons/ico/2.png" alt=""></figure>
                                </div>
                                <div class="thumb-item">
                                    <figure class="thumb-box"><img src="images/icons/ico/3.png" alt=""></figure>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="video-column">
                <div class="video-inner" style="background-image: url(images/stock/about-core/1.png);">
                    <a href="images/stock/video/2.mp4" class="overlay-link lightbox-image" data-caption=""><i class="flaticon-play-button"></i></a>
                </div>    
            </div>
        </div>
    </section>
    <!-- testimonial-video end -->


    <!-- service-section -->
    <section class="service-style-two sec-pad">
        <div class="container">
            <div class="inner-content">
            <div class="sec-title centred">
                <h5>Our Pillars of Education</h5>
                <h1>That Define Who We Are</h1>
            </div>
                <div class="row">
                    <div class="col-lg-3 col-md-6 col-sm-6 service-column">
                        <div class="service-block-one">
                            <div class="inner-box">
                                <div class="top-img"><img src="images/stock/objectives/1.png" alt="SIJSU"></div>
                                <h3>Eager to Learn</h3>
                                <div class="text mb-3">Open minded curiosity fuels a love for learning.</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 service-column">
                        <div class="service-block-one">
                            <div class="inner-box">
                                <div class="top-img"><img src="images/stock/objectives/3.png" alt="SIJSU"></div>
                                <h3>One Team</h3>
                                <div class="text mb-3">We put our team's interest ahead of our own.</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 service-column">
                        <div class="service-block-one">
                            <div class="inner-box">
                                <div class="top-img"><img src="images/stock/objectives/6.png" alt="SIJSU"></div>
                                <h3>Respect</h3>
                                <div class="text mb-3">Setting ambitious goals and aiming to exceed expectations.</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 service-column">
                        <div class="service-block-one">
                            <div class="inner-box">
                                <div class="top-img"><img src="images/stock/objectives/11.png" alt="SIJSU"></div>
                                <h3>Excellence</h3>
                                <div class="text mb-3">Aiming for the best we can at everything we do.</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- service-section end -->


    <!-- about-style-two -->
    <section class="about-style-two centred pb-5">
        <div class="anim-icon">
            <div class="icon icon-1 wow zoomIn animated"></div>
        </div>
        <div class="container">
            <div class="inner-box">
                <div class="title-box">
                    <div class="sec-title">
                        <h5>About Us</h5>
                        <h1>Welcome to Scoris International School Uganda</h1>
                    </div>

                    <div class="text">At Scoris International Junior school, every learner is cherished daily. With the Cambridge curriculum and a holistic approach, we inspire both academic excellence and personal growth, ensuring each child feels valued and empowered to thrive.</div>
                </div>
                <div class="image-inner">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-12 image-column">
                            <figure class="image-box">

                                <video autoplay loop muted>
                                    
                                    <source src="images/stock/video/1.mp4" type="video/mp4">

                                </video>

                            </figure>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 image-column">
                            <figure class="image-box">

                                <video autoplay loop muted>
                                    
                                    <source src="images/stock/video/2.mp4" type="video/mp4">

                                </video>

                            </figure>
                        </div>
                    </div>
                </div>
                <div class="lower-content">
                    <div class="text">
                        <p>We offer an integrated approach towards learning all about helping every child reach their full potential. Leading provider in early childhood development foundation.</p>
                    </div>
                    <div class="btn-box"><a href="enrol" class="theme-btn">Join Our Family</a></div>
                </div>
            </div>
        </div>
    </section>
    <!-- about-style-two end -->


<!-- service-section -->
    <section class="service-section sec-pad" style="background-image: url(images/stock/bg/1.png);">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-12 col-sm-12 inner-column">
                    <div class="inner-content"> <br>
                        <div class="sec-title style-two">
                            <h5>Our class</h5>
                            <h1>Schedule</h1>
                        </div> <br>
                        <div class="text">A Cambridge International Curriculum registered by the British Cambridge Assessment International Education.</div> <br>

                        <div class="text">This is our updated & approved weekly schedule.</div>
                    </div>
                </div>
                <div class="col-lg-8 col-md-12 col-sm-12 carousel-column">
                    <div class="carousel-content">
                        <div class="services-carousel owl-carousel owl-theme">

  <?php 

     //including the database connection file
include_once("admin/class/db/config.php");

//fetching data in descending order (lastest entry first)
//$result = mysql_query("SELECT * FROM users ORDER BY id DESC"); // mysql_query is deprecated
$result = mysqli_query($mysqli, "SELECT * FROM classes"); // using mysqli_query instead

    //while($res = mysql_fetch_array($result)) { // mysql_fetch_array is deprecated, we need to use mysqli_fetch_array 
    while($res = mysqli_fetch_array($result)) {

        $start_diff = new DateTimeImmutable($res['start']); 

                $endd_diff = new DateTimeImmutable($res['endd']);

                $duration = $start_diff->diff($endd_diff);

                date_default_timezone_set('Africa/Kampala');

                $today = date("Y-m-d H:i:s",time()); 

                $today_diff = new DateTimeImmutable($today);

                $days_diff = $today_diff->diff($start_diff);

                            echo "<div class='service-block-one'>";
                                echo "<div class='inner-box'>";
                                    echo "<div class='icon-box'><img src='admin/class/images/".$res['image']."' alt='$res[title]'></div>";
                                    echo "<h3><a href='#'>".$res['title']."</a></h3>";
                                    echo "<div class='price'>".$res['day']."</div>";

                                     echo "<div class='text'>".$res['description']."</div>";

                                     echo "<ul class='info-box'>";

                                echo "<li>Start: <span>".date("H:i", strtotime($res['start']))."</span></li>";

                                echo "<li>End: <span>".date("H:i", strtotime($res['endd']))."</li>";

                            echo "</ul>";

                                echo "</div>";                               

                            echo "</div>";

}
  ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- service-section end -->


    <!-- about-section -->
    <section class="about-section">
        <div class="anim-icon">
            <div class="icon icon-2 wow zoomIn animated"></div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                    <div class="image-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <figure class="image image-1"><img src="images/stock/active/1.png" alt="Activity" class="float-bounce"></figure>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                    <div class="content-box">
                        <div class="sec-title style-two">
                            <h5>At Scoris International Junior School</h5>
                            <h1>We believe that education goes far beyond textbooks.</h1>
                        </div>
                        <div class="bold-text">Co-curricular activities play a crucial role in shaping a well-rounded child, complementing academic learning with vital life skills and character development.</div>
                        <div class="text">
                            <p>Co-curricular activities are programs and learning experiences that fall outside the realm of the traditional academic curriculum, yet are an integral part of a child’s education. These include sports, arts, music, debate, drama, clubs, student leadership roles, and community service initiatives.</p>
                        </div>
                        <div class="btn-box"><a href="activities" class="theme-btn">See Activities <i class="fa fa-arrow-right float-bounce-right ml-2"></i></a></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about-section end -->

    
<!-- service-section -->
    <section class="service-section sec-pad" style="background-image: url(images/stock/bg/2.png);">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 inner-column">
                    <div class="inner-content"> <br>
                        <div class="sec-title style-two" align="center">
                            <h5>Our class</h5>
                            <h1>Timetable</h1>
                        </div> <br>
                        <div align="center"> 
                            <a href="class" class="theme-btn mr-2 mb-3">View Timetable</a> 
                            <a href="doc/fees-structure.pdf" download="Scoris Fees Structure" class="theme-btn ml-2">Download Fees Structure</a> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- service-section end -->


    

    <!-- classes-section -->
    <section class="classes-section style-two style-three">
        <div class="parallax-scene parallax-scene-1 parallax-icon">
            <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
        </div>
        <div class="anim-icon">
            <div class="icon icon-2 float-bob-y"></div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-md-12 col-sm-12 inner-column">
                    <div class="inner-content">
                        <div class="sec-title style-two">
                            <h5>Extra</h5>
                            <h1>Co-Curriculum Activities</h1>
                        </div>
                        <div class="text">Creating and maintaining a high quality and safe learning environment enabling our dear ones to succeed 100%. All our premises are controlled with 24hrs CCTV.</div>
                    </div>
                </div>
                <div class="col-lg-7 col-md-12 col-sm-12 carousel-column">
                    <div class="carousel-content">
                        <div class="classes-carousel owl-carousel owl-theme">

<?php
              include_once('admin/activities/db/connection.php');
              $sql = "SELECT * FROM activities ORDER BY id DESC";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){

                            echo "<div class='inner-block wow fadeInUp' data-wow-delay='0ms' data-wow-duration='1500ms'>";
                                echo "<figure class='image-box'><a href=\"activities/details/index.php?id=$row[id]\"><img src='admin/activities/images/".$row['image']."' alt='$row[title]'></a></figure>";
                                echo "<div class='lower-content'>";
                                  
                            echo "<div class='link-btn'><a href=\"activities/details/index.php?id=$row[id]\"><i class='flaticon-next'></i></a></div>";
                            echo "<h3><a href=\"activities/details/index.php?id=$row[id]\">".$row['title']."</a></h3>";
                            echo "<div class='price'>".$row['day']."</div>";
                            echo "<div class='text'>";
                            if ($row['type']==1) { echo "Activity"; } elseif ($row['type']==2) { echo "Expressive Activity"; }
                            echo "</div>";
                            echo "<ul class='info-box'>";
                                echo "<li>Start: <span>".date("h:ia", strtotime($row['start']))."</span></li>";
                                echo "<li>End: <span>".date("h:ia", strtotime($row['endd']))."</span></li>";
                            echo "</ul>";

                                echo "</div>";
                            echo "</div>";


 }
    ?>        


                            
                    <div class="inner-block wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms" style="margin-top: 150px;background: none;">
                        <div class="lower-content"> <br> <br> <br>
                            <div class="price">
                            <div class="link-btn wobble"><a href="activities"><i class="flaticon-next"></i></a></div>
                          </div>
                        </div>
                    </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- classes-section end -->


    <!-- service-section -->
    <section class="service-section sec-pad" style="background-image: url(images/stock/bg/8.png);">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-12 col-sm-12 inner-column">
                    <div class="inner-content">
                        <div class="sec-title style-two">
                            <h5>Key Benefits Of</h5>
                            <h1>Co-Curricular Involvement</h1>
                        </div>
                        <div class="text">Our aim is to nurture every aspect of a child’s development—academic, physical, emotional, and social so they grow into confident, capable, and compassionate individuals.</div>
                    </div>
                        <div class="btn-box mt-5"><a href="activities" class="theme-btn">See Activities <i class="fa fa-arrow-right float-bounce-right ml-2"></i></a></div>
                </div>
                <div class="col-lg-8 col-md-12 col-sm-12 carousel-column">
                    <div class="carousel-content">
                        <div class="services-carousel owl-carousel owl-theme">
                            <div class="service-block-one">
                                <div class="inner-box">
                                    <div class="icon-box"><i class="flaticon-bus-1"></i></div>
                                    <h3><a href="#">Enhancing Social Skills</a></h3>
                                    <div class="text">Children learn teamwork, communication, empathy, and conflict resolution by interacting with peers in a collaborative setting. These skills are essential for both personal and professional success.</div>
                                </div>
                            </div>
                            <div class="service-block-one">
                                <div class="inner-box">
                                    <div class="icon-box"><i class="flaticon-running"></i></div>
                                    <h3><a href="#">Building Confidence and Self-Esteem</a></h3>
                                    <div class="text">Trying something new and succeeding at it can give a tremendous boost to a child’s self-belief. Whether it's scoring a goal, performing on stage, or leading a club, each accomplishment builds confidence.</div>
                                </div>
                            </div>
                            <div class="service-block-one">
                                <div class="inner-box">
                                    <div class="icon-box"><i class="flaticon-drum"></i></div>
                                    <h3><a href="#">Encouraging Discipline and Time Management</a></h3>
                                    <div class="text">Balancing academics with extra-curricular commitments teaches children how to manage their time effectively, set priorities, and stay organized with skills they’ll carry into adulthood.</div>
                                </div>
                            </div>
                            <div class="service-block-one">
                                <div class="inner-box">
                                    <div class="icon-box"><i class="flaticon-drum"></i></div>
                                    <h3><a href="#">Discovering Interests and Talents</a></h3>
                                    <div class="text">Co-curricular activities give children the opportunity to explore their interests and discover hidden talents. This can lead to lifelong passions and even career paths.</div>
                                </div>
                            </div>
                            <div class="service-block-one">
                                <div class="inner-box">
                                    <div class="icon-box"><i class="flaticon-drum"></i></div>
                                    <h3><a href="#">Fostering Emotional and Physical Well-being</a></h3>
                                    <div class="text">Physical activities promote health and fitness, while creative outlets like music, drama, and art support emotional expression and mental wellness.</div>
                                </div>
                            </div>
                            <div class="service-block-one">
                                <div class="inner-box">
                                    <div class="icon-box"><i class="flaticon-drum"></i></div>
                                    <h3><a href="#">Cultivating Leadership and Responsibility</a></h3>
                                    <div class="text">Roles such as team captain, club president, or event organizer help children learn responsibility, strategic thinking, and how to lead by example.</div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- service-section end -->


    <!-- activities-section -->
    <section class="activities-section style-two">
        <div class="anim-icon">
            <div class="icon icon-2 float-bob-x"></div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                    <div class="image-box clearfix">
                        <figure class="image"><img src="images/stock/long/5.png" alt=""></figure>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                    <div class="content-box">
                        <div class="title-box">
                            <div class="sec-title style-two">
                                <h5>Doing More</h5>
                                <h1>In A Nutshell</h1>
                            </div>
                            <div class="text"></div>
                        </div> <br> <br>
                        <div class="inner-box">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInLeft" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-teddy-bear"></i></div>
                                        <h3>Play</h3>
                                        <div class="text">Improves the cognitive, physical, social, and emotional well-being of children</div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInRight" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-abc-block"></i></div>
                                        <h3>Learn</h3>
                                        <div class="text">Observe, listen, experiment and asking questions.</div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInLeft" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-playground"></i></div>
                                        <h3>Grow</h3>
                                        <div class="text">Respond, cuddle, relax, play & talk to nourish a child’s growing brain.</div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 column">
                                    <div class="single-item wow fadeInRight" data-wow-delay="00ms" data-wow-duration="1500ms">
                                        <div class="icon-box"><i class="flaticon-earth-globe"></i></div>
                                        <h3>Explore</h3>
                                        <div class="text">An active learning approach that gives the learner a sense that anything is possible.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- activities-section end -->


    <!-- event-section -->
    <section class="event-section" style="background-image: url(images/stock/bg/1.png);">
        <div class="anim-icon">
            <div class="icon icon-1 float-bob-x"></div>
        </div>
        <div class="container">
            <div class="sec-title centred">
                <h5>Events</h5>
                <h1>Our Events</h1>
            </div>
            <div class="row">


<?php 

     //including the database connection file
include_once("admin/events/db/config.php");

//fetching data in descending order (lastest entry first)
//$result = mysql_query("SELECT * FROM users ORDER BY id DESC"); // mysql_query is deprecated
$result = mysqli_query($mysqli, "SELECT * FROM events WHERE activate='1' ORDER BY start DESC LIMIT 4"); // using mysqli_query instead

    //while($res = mysql_fetch_array($result)) { // mysql_fetch_array is deprecated, we need to use mysqli_fetch_array 
    while($res = mysqli_fetch_array($result)) {

        $start_diff = new DateTimeImmutable($res['start'] .  "+1 days"); 

                $endd_diff = new DateTimeImmutable($res['endd'] .  "+1 days");

                $duration = $start_diff->diff($endd_diff);

                date_default_timezone_set('Africa/Kampala');

                $today = date("Y-m-d H:i:s",time()); 

                $today_diff = new DateTimeImmutable($today);

                $days_diff = $today_diff->diff($start_diff);

                $event_duration = "".$duration->format("%d")."";

                if ($event_duration == 0) {
                    $event_duration_main = "1 day";
                } else {
                    $event_duration_main = "".$event_duration." days";
                }

                if ($res['start'] == $res['endd']) {
                    $event_date = "".date("jS M, Y", strtotime($res['start']))."";
                } elseif ($res['start'] != $res['endd']) {
                    $event_date = "".date("jS M", strtotime($res['start']))." - ".date("jS M, Y", strtotime($res['endd']))."";
                }


                echo "<div class='col-xl-6 col-lg-12 col-md-12 event-block'>";

                    echo "<div class='event-block-one wow fadeInLeft' data-wow-delay='00ms' data-wow-duration='1500ms'>";

                        echo "<div class='inner-box'>";

                            if ($res['image']) { echo "<figure class='image-box'><img src='admin/events/images/".$res['image']."' alt='$res[title]'></figure>";} 

                            elseif ($res['image']=="") { echo "<figure class='image-box'><img src='admin/events/images/default.png'></figure>";}

                            echo "<div class='content-box'>";

                                echo "<div class='date'>".date("M jS, Y", strtotime($res['start']))."</div>";

                                echo "<h3>".$res['title']."</h3>";

                                echo "<div class='text'>".$res['description']."</div>";

                                echo "<div class='location'>Date: <span>".$event_date."</span></div>";

                                echo "<div class='location'>Duration: <span>".$event_duration_main."</span></div>";

                                echo "<div class='location'>";

                                if ($res['start']<date('Y-m-d H:i:s',time())) { echo "No Days Left: "; }

                                elseif ($res['start']>date('Y-m-d H:i:s',time())) { echo "Time Left: "; }

                               elseif ($res['start']=date('Y-m-d H:i:s',time()) || $res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')==0 & $days_diff->format('%d')==1) { echo "Yay! It's: "; }

                               echo "<span>";

                               if ($res['start']<date('Y-m-d H:i:s',time())) { echo "Passed"; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')==0 & $days_diff->format('%d')>1) { echo "".$days_diff->format("%d days").""; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')==0 & $days_diff->format('%d')==1) { echo "Tomorrow"; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')==1 & $days_diff->format('%d')==1) { echo "".$days_diff->format("%m month & %d day").""; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')==1 & $days_diff->format('%d')==0) { echo "".$days_diff->format("%m month").""; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')>1 & $days_diff->format('%d')==0) { echo "".$days_diff->format("%m months").""; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time()) & $days_diff->format('%m')==1 & $days_diff->format('%d')>1) { echo "".$days_diff->format("%m month & %d days").""; }

                               elseif ($res['start']>date('Y-m-d H:i:s',time())) { echo "".$days_diff->format("%m months & %d days").""; }

                               elseif ($res['start']=date('Y-m-d H:i:s',time())) { echo "Today"; }

                               echo "</span>";

                            echo "</div>";

                         echo "</div>";

                      echo "</div>";

                    echo "</div>";

                echo "</div>";

}
  ?>

            </div> <br>
        <div align="center"> <a href="events" class="theme-btn">View All <i class="fa fa-arrow-right float-bounce-right" style="margin-left: 20px;"></i></a> </div>
        </div>
    </section>
    <!-- event-section end -->


    <!-- portfolio-section -->
    <section class="testimonial-faq gallery-page-section">
        <div class="anim-icon d-none d-lg-block">
            <div class="icon icon-1"></div>
        </div>
        <div class="container">
            <div class="sec-title centred">
                <h5>Scoris International Junior</h5>
                <h1>School Fess Structure</h1>
            </div>
            <div class="sortable-masonry mt-5">
                <div class="items-container row clearfix">
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/stock/fees/1.png" alt="Fees Structure"></figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/stock/fees/2.png" alt="Fees Structure"></figure>
                            </div>
                        </div>
                    </div>

                </div>
            </div> <br>
        <div align="center">
         <a href="doc/fees-structure.pdf" target="_blank" class="theme-btn ml-2 mb-3"><i class="fa fa-eye mr-2"></i> View Fees Structure</a> 
         <a href="doc/fees-structure.pdf" download="Scoris Fees Structure" class="theme-btn ml-2"><i class="fa fa-download mr-2 float-bounce"></i> Download Fees Structure</a> 
        </div>
        </div>
    </section>
    <!-- portfolio-section end -->


    <!-- testimonial-faq -->
    <section class="testimonial-faq">
        <div class="anim-icon d-none d-lg-block">
            <div class="icon icon-1"></div>
        </div>
        <div class="anim-icon">
            <div class="icon icon-2 float-bob-y"></div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 testimonial-column">
                    <div class="testimonial-content">
                        <div class="sec-title style-two">
                            <h5>Testimonials</h5>
                            <h1>Happy Parents Say</h1>
                        </div>
                        <div class="inner-content">
                            <div class="client-testimonial-carousel owl-carousel owl-theme">

                                
                
                <?php
              include_once('admin/testimonials/db/connection.php');
              $sql = "SELECT * FROM testimonials WHERE approve=1";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){

                echo '<div class="testimonial-block">';
                                    echo '<div class="inner-box">';
                                        echo '<div class="author">';

                            if ($row['title']=="") { echo "$row[name]"; } elseif ($row['title']=="1") { echo "$row[name]"; } elseif ($row['title']==2) { echo "Mr. $row[name]"; } elseif ($row['title']==3) { echo "Miss. $row[name]"; } elseif ($row['title']==4) { echo "Mrs. $row[name]"; } elseif ($row['title']==5) { echo "Mr & Mrs. $row[name]"; }

                            echo ' <span>/ ';

                            if ($row['title']=="") { echo "$row[child]"; } elseif ($row['title']=="1") { echo "$row[child]'s Parent"; } elseif ($row['title']==2) { echo "$row[child]'s Father"; } elseif ($row['title']==3) { echo "$row[child]'s Mother"; } elseif ($row['title']==4) { echo "$row[child]'s Mother"; } elseif ($row['title']==5) { echo "$row[child]'s Parents"; }

                            echo '</span>';

                            echo '</div>';
                                        echo '<ul class="rating">
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                        </ul>';
                                        echo '<div class="text-white">'.$row['testimonial'].'</div>';
                                    echo '</div>';
                                echo '</div>';


 }
    ?>

                                
                            </div>
                            
                            <!--Client Thumbs Carousel-->
                            <div class="client-thumb-outer">
                                <div class="client-thumbs-carousel owl-carousel owl-theme">

                                      
                
<?php
              include_once('admin/testimonials/db/connection.php');
              $sql = "SELECT * FROM testimonials WHERE approve=1";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){

                echo '<div class="thumb-item">';
                echo '<figure class="thumb-box">';

                            if ($row['image']) { echo "<img src='admin/testimonials/images/".$row['image']."' alt='$row[name]' style='object-fit: cover;object-position: top;'>";} 
                                    elseif ($row['image']=="") { echo "<img src='admin/testimonials/images/default.png'>";}

                            echo '</figure>';
                echo '</div>';


 }
    ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12 faq-column">
                    <div class="faq-content">
                        <ul class="accordion-box active-block">
                            <li class="accordion block">
                                <div class="acc-btn active">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>What extra curriculum activities do you offer?</h4>
                                </div>
                                <div class="acc-content current">
                                    <div class="content">
                                        <div class="text">Outdoor activities, building blocks, reading story books, gluing, collage, painting, drawing, tearing, swimming, cutting, story telling & so much more. 
                                        <a href="activities" style="color: #43b3d9;">See More</a>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>What classes do you offer?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">We follow the Cambridge curriculum which includes classes like mathematics, comprehension, expressive art, english, global studies, personal social & emotional development, literacy, physical development.
                                        <a href="class" style="color: #fbb419;">See More</a>
                                    </div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                 <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>Is Outdoor Play Supervised?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">All our premises arecontrolled with 24hrs CCTV cameras.</div>
                                        <div class="text">We will unite to create and maintain a high quality and safe learning environment" enabling our dear ones to succeed 100%.</div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                 <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>What's the uniform schedule?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                    <div class="text" style="color: #b350ff;font-weight: bold;">Please take note of the uniform days.</div>

                                     <div class="text">

                                        <b>Monday</b>: Tie and dye T Shirt with Grey Shorts, Grey Socks and black shoes. <br>
                                        <b>Tuesday & Thursday</b>: White T. Shirt with Red Sports Shorts, red socks and canvas shoes. <br>
                                        <b>Wednesday & Friday</b>: Blue and White Dress, White Shirt with Blue Shorts, Blue Socks and Black Shoes.

                                        <a href="uniforms" style="color: #b350ff;">Checkout uniform page</a>

                                     </div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                 <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>Do you have events for the students?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">Yes, each term we organize events for the students & some require parent involvement. Checkout our events page & stay uptodate. 

                                        <a href="events" style="color: #7379fe;">See Events</a></div>

                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <br>
        <div align="center"> <a href="#testimonial" onclick="openTestimonial()" class="theme-btn">Review Us <i class="fa fa-star" style="margin-left: 20px;"></i></a> </div>
    </section>
    <!-- testimonial-faq end -->


    <!-- fact-counter -->
    <section class="fact-counter style-two">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-two-users"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="2500" data-stop="50">0</span>
                        </div>
                        <div class="text">Teachers & Staff</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-calendar"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="1500" data-stop="125">0</span>
                        </div>
                        <div class="text">Total Sessions</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-boy"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="1500" data-stop="150">0</span>
                        </div>
                        <div class="text">Students +</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-6 counter-column">
                    <div class="counter-block wow slideInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="flaticon-flask"></i></div>
                        <div class="count-outer count-box">
                            <span class="count-text" data-speed="1500" data-stop="80">0</span>
                        </div>
                        <div class="text">Events & Activities</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- fact-counter end -->


    <!-- feature-section -->
    <section class="feature-section">
        <div class="anim-icon">
            <div class="icon icon-1"></div>
            <div class="icon icon-2"></div>
        </div>
        <div class="image-column" style="background-image: url(images/new/sara-lule.jpeg);background-position: top;"></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-5 col-lg-12 col-md-12 offset-xl-7 inner-column">
                    <div class="inner-content">
                        <div class="sec-title style-two">
                            <h5>A word from the</h5>
                            <h1>PRINCIPAL</h1>
                        </div>
                       
                            <div class="single-item wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">

                                <div class="single-item-img wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms"><img src="images/img/1/principal.jpg" alt="scorisinternationaljunior"></div>

                                <div class="text">"We are an extra-ordinary school that offers outstanding care, guidance and support from a highly committed pastoral network.
                                </div>
                            </div> <br>

                            <div class="single-item wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                                <div class="text">I am proud to be heading this wonderful school with staff that are focused, enthusiastic, hardworking and passionate about what they do while considering the needs of the learners.
                            </div>
                            </div> <br>

                            <div class="single-item wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                                <div class="text">Our learners at Scoris are always so exciting to work alongside with. They are at all times polite and very positive towards success. They are the heart of the school."
                            </div>
                            </div>

                        <div class="sec-title style-two">
                            <h5>A word from the</h5>
                        </div>
                           
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- feature-section end -->


    <!-- cta-section -->
    <section class="cta-section centred">
        <div class="parallax-scene parallax-scene-3 parallax-icon">
            <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
        </div>
        <div class="anim-icon">
            <div class="icon icon-1 float-bob-x"></div>
            <div class="icon icon-2 rotate-me"></div>
        </div>
        <div class="container">
            <div class="content-box">
                <h3>Join the Scoris Family</h3>
                <h1>Open For Enrolment</h1>
                <div class="text">Unlock the world of words with fun and interactive practice. Give us a try!</div>
                <div class="btn-box"><a href="enrol" class="theme-btn">Enrol Today</a></div>
            </div>
        </div>
    </section>
    <!-- cta-section end -->


    <!-- portfolio-section -->
    <section class="gallery-page-section">
        <div class="container">
            <div class="sec-title centred">
                <h5>Blogs From Our</h5>
                <h1>Little Geniuses</h1>
            </div>
            <div class="sortable-masonry mt-5">
                <div class="items-container row clearfix">
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/articles/1.jpg" alt="Article"></figure>
                                <div class="overlay-box"><a href="images/articles/1.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/articles/2.jpg" alt="Article"></figure>
                                <div class="overlay-box"><a href="images/articles/2.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/articles/3.jpg" alt="Article"></figure>
                                <div class="overlay-box"><a href="images/articles/3.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/articles/4.jpg" alt="Article"></figure>
                                <div class="overlay-box"><a href="images/articles/4.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/articles/5.jpg" alt="Article"></figure>
                                <div class="overlay-box"><a href="images/articles/5.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="images/articles/6.jpg" alt="Article"></figure>
                                <div class="overlay-box"><a href="images/articles/6.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div> <br>
        <div align="center"> <a href="blog" class="theme-btn">View All <i class="fa fa-arrow-right float-bounce-right" style="margin-left: 20px;"></i></a> </div>
        </div>
    </section>
    <!-- portfolio-section end -->


    <!-- gallery-section -->
    <section class="gallery-section sec-pad centred">
        <div class="container-fluid">
            <div class="sec-title">
                <h5>Gallery</h5>
                <h1>Photo Gallery</h1>
            </div>
            <div class="gallery-carousel owl-carousel owl-theme">

                

    <?php

              $sql = "SELECT * FROM gallery ORDER BY rand() LIMIT 20";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){


                echo '<div class="gallery-block">';
                    echo '<div class="image-box">';
                        echo '<figure class="image"><img src="admin/gallery/'.$row["target"].'" alt="'.$row["title"].'"></figure>';
                        echo '<div class="overlay-box"><a href="admin/gallery/'.$row["target"].'" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>';
                    echo '</div>';
                echo '</div>';

     

     }
    ?>

            </div>
        </div> <br> <br>
        <div align="center"> <a href="gallery" class="theme-btn">View All <i class="fa fa-arrow-right float-bounce-right" style="margin-left: 20px;"></i></a> </div>
    </section>
    <!-- gallery-section end -->


    <!-- news-section --
    <section class="news-section style-two">
        <div class="anim-icon">
            <div class="icon icon-2 wow zoomIn" data-wow-delay="00ms" data-wow-duration="1500ms"></div>
        </div>
        <div class="container">
            <div class="sec-title centred">
                <h5>Our Blog</h5>
                <h1>News & Article</h1>
            </div>
            <div class="row">
                <div class="col-xl-6 col-lg-12 col-md-12 news-block">
                    <div class="news-block-two wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <figure class="image-box">
                                <video autoplay loop muted width="100%" height="100%" style="border-bottom-right-radius: 0;border-bottom-left-radius: 0;">
                                    <source src="images/footage/1/3.mp4" type="video/mp4">
                                </video>
                            </figure>
                            <div class="lower-content">
                                <ul class="info-box">
                                    <li>15 July, 2022</li>
                                    <li>Activities</li>
                                </ul>
                                <h3>Engaging infants in extra activities</h3>
                                <div class="text">Learning piano has been shown to amazingly improve memory particularly verbal memory & build good habits like focus and perseverance, diligence and creativity. Children who had a few years of piano study under their belts could remember twenty percent more vocabulary words than their peers...</div>
                                <div class="link-btn"><a href="#" class="theme-btn">Read More</a></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-12 col-md-12 news-block">
                    <div class="news-block-two wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="lower-content">
                                <ul class="info-box">
                                    <li>20 March, 2022</li>
                                    <li>Scoris</li>
                                </ul>
                                <h3><a href="blog-details.html">New Activities</a></h3>
                                <div class="text">Scoris International Junior School introduces new activities on the curriculum. For more details, checkout <a href="#" style="color: #212f54;">Activities Page</a>.</div>
                            </div>
                        </div>
                    </div>
                    <div class="news-block-two wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="lower-content">
                                <ul class="info-box">
                                    <li>2 Jan, 2022</li>
                                    <li>Schools</li>
                                </ul>
                                <h3>Schools Re-Open</h3>
                                <div class="text">Pre-primary, primary and secondary schools re-open on Jan 10th, 2022. – The minister said. Uganda breaks world record for longest school...</div>
                            </div>
                        </div>
                    </div>
                    <div class="news-block-two wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <div class="inner-box">
                            <div class="lower-content">
                                <ul class="info-box">
                                    <li>17 Oct, 2021</li>
                                    <li>COVID Updates</li>
                                </ul>
                                <h3>How COVID 19 affected infants</h3>
                                <div class="text">Since March 2020, schools in Uganda have been closed due to national lockdowns. These lockdowns have severely affected education...</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    -- news-section end -->


    <!-- contact-section -->
    <section class="contact-section">
        <div class="outer-container clearfix">
            <div class="map-column">
                <div class="google-map-area">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.7676178281804!2d32.608857199999996!3d0.2888525999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177dbd431f92a227%3A0x57b490184adaf84b!2sScoris%20International%20Junior%20School!5e0!3m2!1sen!2sug!4v1667001802887!5m2!1sen!2sug" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
            <div class="contact-column">
                <div class="content-box">
                    <div class="sec-title style-two home-contact">
                        <h5>Contact</h5>
                        <h1>Quick Contact</h1>
                    </div>
                    <div class="form-box">
                        <form method="post" action="">
                            <div class="row">

                                <div class="col-lg-12 col-md-12 col-sm-12 form-group username">
                                  <input type="text" name="username" id="contact_username" placeholder="Username" value="">
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="text" name="name" id="contact_name" placeholder="Your Name" required>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="email" name="email" id="contact_email" placeholder="Your Email" required>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="number" name="phone" id="contact_phone" placeholder="Your Phone Number" required>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                    <input type="text" name="subject" id="contact_subject" placeholder="Subject" required>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                    <textarea name="message" id="contact_message" placeholder="Your Message" required></textarea>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                    <div class="message-btn"><button type="submit" id="message_btn" class="theme-btn" name="message_btn">Send Message</button></div>
                                </div>
                            </div>

                            <div align="center" id="message_box" style="margin:10px 0px;"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-section end -->


    <!-- main-footer -->
    <footer class="main-footer">
        <div class="footer-top">
            <div class="parallax-scene parallax-scene-4 parallax-icon">
                <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            </div>
            <div class="container">
                <div class="widget-section">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="about-widget footer-widget">
                                <h3 class="widget-title">Our Focus</h3>
                                <div class="widget-content">
                                    <div class="text">
                                        <p>At Scoris international Junior school, every learner is cherished daily. With the Cambridge curriculum and a holistic approach, we inspire both academic excellence and personal growth, ensuring each child feels valued and empowered to thrive.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="link-widget footer-widget">
                                <h3 class="widget-title">Useful Links</h3>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="about">About Us</a></li>
                                        <li><a href="contact">Contact Us</a></li>
                                        <li><a href="class">Classes</a></li>
                                        <li><a href="activities">Activities</a></li>
                                        <li><a href="events">Events</a></li>
                                        <li><a href="gallery">Our Gallery</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                            <div class="contact-widget footer-widget">
                                <h3 class="widget-title">Get in Touch</h3>
                                <div class="widget-content">
                                    <div class="text">Open for enrolment, contact us & join the scoris family</div>
                                    <ul class="info-list">
                                        <li><i class="fas fa-home"></i>Makindye Division, Kansanga Kiwafu Road</li>
                                        <li><i class="fas fa-mobile"></i><a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:registration@scorisinternationaljunior.com">registration@scorisinternationaljunior.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-12 footer-column">
                            <div class="subscribe-widget footer-widget">
                                <h3 class="widget-title">Newsletter</h3>
                                <div class="widget-content">
                                    <div class="text">Receive important scoris updates.</div>
                                    <div class="subscribe-inner">
                                        <form method="POST" name="ContactForm" action="" class="subscribe-form">
                                            <div class="form-group" align="center">
                                              <div class="username"><input type="text" id="username" name="username" value=""></div>
                                              <input type="hidden" name="subject" id="subject" value="Scoris Newsletter Subscription">
                                                <input type="email" name="email" id="email" placeholder="Email Address" required="">
                                                <button type="submit" name="newsletter" id="newsletter" class="theme-btn" style="border-radius: 10px;">Submit</button>
                                            </div>

                                            <div align="center" class="message_box" style="margin:10px 0px;"></div>

                                        </form>
         
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="left-content pull-left">
                        <div class="copyright"><a href="#">Scoris International Junior School &copy; <script>document.write(new Date().getFullYear());</script></a></div>

                    </div> <br>
              
                    <div class="right-content pull-right">
                        <figure class="footer-logo"><a href="#"><img src="images/logo/footer-logo.png" alt="Scoris International"></a></figure>
                        <ul class="social-style-one footer-social clearfix">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-x-twitter"></i></a></li>
                            <li><a href="https://instagram.com/scorisjunior"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://youtube.com"><i class="fab fa-youtube"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                        </ul>
                    </div>


                    <div class="copyright power-bottom">Powered by <a rel="sponsored" class="text-decoration-none" href="https://customassist.net/" target="_blank"><strong>Custom Assist Inc<span class="flash">.</span></strong></a></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- main-footer end -->



<!--Scroll to top-->
<button class="scroll-top scroll-to-target" data-target="html">
    <i class="fa fa-arrow-up"></i>
</button>


<script src="js/js/jquery.min.js"></script>

<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var subject = $('#subject').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "https://scorisinternationaljunior.com/contact/newsletters/index.php",
             data: "email="+email+"&username="+username+"&subject="+subject+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box').html(
       '<div align="center"><img src="images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>


<script>
$(document).ready(function() {
  var delay = 500;
  $('#message_btn').click(function(e){
    e.preventDefault();
    
    var contact_username = $('#contact_username').val();
    
    var contact_name = $('#contact_name').val();
    
    var contact_phone = $('#contact_phone').val();
    
    var contact_message = $('#contact_message').val();

    var contact_subject = $('#contact_subject').val();

    var message_btn = $('#message_btn').val();

    var contact_email = $('#contact_email').val();
        if(contact_email == ''){
      $('#message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#contact_email').focus();
            return false;
      }
    if( $("#contact_email").val()!='' ){
      if( !isValidEmailAddress( $("#contact_email").val() ) ){
      $('#message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#contact_email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "https://scorisinternationaljunior.com/contact/contact/index.php",
             data: "contact_name="+contact_name+"&contact_email="+contact_email+"&contact_phone="+contact_phone+"&contact_username="+contact_username+"&contact_subject="+contact_subject+"&contact_message="+contact_message+"&message_btn="+message_btn,
       beforeSend: function() {
       $('#message_box').html(
       '<div align="center"><img src="images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('#message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});


</script>


<!--Start Review Pop Up-->

    <div id="testimonial" class="overlay overlay_modal overlay_testimonial" align="center">

  <button class="closebtn" onclick="closeTestimonial()">x</button>
  
    <div class="overlay-content review">

    <div class="parallax-scene parallax-scene-3 parallax-icon">
            <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
            <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
            <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
            <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
        </div>

        <div class="anim-icon">
            <div class="icon icon-1 float-bob-x"></div>
            <div class="icon icon-2 float-bob-y"></div>
        </div>
  

    <h5>Give A Review</h5>

    <form method="post" action="modal/index.php" id="contact-form" class="default-form" enctype="multipart/form-data"> 
                            <div class="row">

                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group">


                                     <div class="upload-btn-wrapper" align="center">
                                        <div class="upload-wrapper">
                                        <div class="btn"> <img src="images/icons/user/light.png"> </div>
                                        <input type="file" id="myFile" accept="image/*" onchange="preview_image1(event)" name ="image">

                                    <img id="output_image1" class="output_image1">
                                        </div> </div>
                                </div>

                                </div>

                    <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group radio-check">

                    <input type="radio" name="title" value="1"> <b>Mr.</b>

                    <input type="radio" name="title" value="2"> <b>Miss.</b>

                    <input type="radio" name="title" value="3"> <b>Mrs.</b>

                    <input type="radio" name="title" value="4"> <b>Mr & Mrs.</b>

                   </div>

                    <div class="username"><input type="text" name="username" value=""></div>


                   <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group">
                                    <input type="text" name="name" id="name" class="form-control" placeholder="Full Names" value="" required>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group">
                                    <input type="text" name="child" id="child" class="form-control" placeholder="Child/ Children" value="" required>
                                    <div align="left"><span>(Please punctuate with "<i style="color: #ff7162">, or &</i>" e.g Child1, Child2 & Child3)</span></div>
                                </div>
                            
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group">
                                    <textarea name="testimonial" id="testimonial" class="form-control" value="" placeholder="Type review here.." required></textarea>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 form-group message-btn centred">
                                    <button type="submit" name="submit">Submit</button>

                                </div>
                            </div>
                        </form>

  </div>
</div>



<script>
function openTestimonial() {
  document.getElementById("testimonial").style.display = "block";
}

function closeTestimonial() {
  document.getElementById("testimonial").style.display = "none";
}


function closeMsg() {
  document.getElementById("msg").style.display = "none";
}
</script>



<!--Auto Popup Script-->
    <script type="text/javascript">
window.addEventListener("load", function(){
    setTimeout(
        function open(event){
            document.querySelector(".popup").style.display = "block";
        },
        50000000
    )
});


document.querySelector("#close").addEventListener("click", function(){
    document.querySelector(".popup").style.display = "none";
});
    </script>


<!-- jequery plugins -->
<script src="js/jquery.js"></script>
<script src="js/popper.min.js"></script>
<script src="js/bootstrap.min.js"></script>

<script src="js/owl.js"></script>
<script src="js/wow.js"></script>
<script src="js/validation.js"></script>
<script src="js/jquery.fancybox.js"></script>
<script src="js/appear.js"></script>
<script src="js/parallax.min.js"></script>   

<!-- map script -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA-CE0deH3Jhj6GN4YvdCFZS7DpbXexzGU"></script>
<script src="js/gmaps.js"></script>
<script src="js/map-helper.js"></script>

<!-- main-js -->
<script src="js/script.js"></script>


<!-- Upload Image JS -->
<script src="js/upload_img_script.js"></script>



<!-- Countdown-jquery -->
<script src="js/jquery.countdown.js"></script> 
<script src="js/jquery.countdown1.js"></script> 
<script src="js/jquery.countdown2.js"></script> 
<script src="js/jquery.countdown3.js"></script> 
<script src="js/jquery.countdown4.js"></script> 
<script src="js/jquery.countdown5.js"></script> 
<script src="js/jquery.countdown6.js"></script> 
<script src="js/jquery.countdown7.js"></script> 
<script src="js/jquery.countdown8.js"></script> 
<script src="js/jquery.countdown9.js"></script> 
<script src="js/jquery.countdown10.js"></script> 
<script src="js/jquery.countdown11.js"></script> 
<script src="js/jquery.countdown12.js"></script> 


<script type="text/javascript">
  

(function($) {
  
  
  //Countdown Timer

  if ($('.countdown').length) {
      $('.countdown').countdown('<?php echo date('Y/m/d', $start_count); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);


</script> 


<script type="text/javascript">
  

(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown1').length) {
      $('.countdown1').countdown1('<?php echo date('Y/m/d', $start_count1); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown2').length) {
      $('.countdown2').countdown2('<?php echo date('Y/m/d', $start_count2); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown3').length) {
      $('.countdown3').countdown3('<?php echo date('Y/m/d', $start_count3); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown4').length) {
      $('.countdown4').countdown4('<?php echo date('Y/m/d', $start_count4); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown5').length) {
      $('.countdown5').countdown5('<?php echo date('Y/m/d', $start_count5); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown6').length) {
      $('.countdown6').countdown6('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 


<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown7').length) {
      $('.countdown7').countdown7('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown8').length) {
      $('.countdown8').countdown8('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown9').length) {
      $('.countdown9').countdown9('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown10').length) {
      $('.countdown10').countdown10('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown11').length) {
      $('.countdown11').countdown11('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 



<script type="text/javascript">
  
(function($) {
  
  
  //13. Countdown Timer
  if ($('.countdown12').length) {
      $('.countdown12').countdown12('<?php echo date('Y/m/d', $start_count6); ?>', function (event) {
          var $this = $(this).html(event.strftime('' + '<div class="counter-column"><span class="count">%D</span><br>Days</div> ' + '<div class="counter-column"><span class="count">%H</span><span class="colon"></span><br>Hours</div>  ' + '<div class="counter-column"><span class="count">%M</span><span class="colon"></span><br>Minutes</div>  ' + '<div class="counter-column"><span class="count">%S</span><span class="colon"></span><br>Seconds</div>'));
      });
  }




})(window.jQuery);

</script> 


</body><!-- End of .page_wrapper -->
</html>
