
<?php
    session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>FAQs | SIJSU &copy;</title>

<!-- Stylesheets -->
<link href="../../css/style.css" rel="stylesheet">
<link href="../../css/responsive.css" rel="stylesheet">
<link rel="icon" href="../../images/logo/ico4.png" type="image/x-icon">

</head>

<!-- page wrapper -->
<body class="boxed_wrapper">

    <!-- search-box-layout -->
    <div class="wraper_flyout_search">
        <div class="table">
            <div class="table-cell">
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-close">
                    <span class="flyout-search-close-line"></span>
                    <span class="flyout-search-close-line"></span>
                </div>
                <div class="flyout_search">
                    <div class="flyout-search-title">
                        <h4>Search</h4>
                    </div>
                    <div class="flyout-search-bar">
                        <form role="search" method="post" action="../search/index.php">
                            <div class="form-row">
                                <input type="search"name="valueToSearch"  placeholder="Search classes, activities or events" required="">
                                <button type="submit" name="search" value="Search"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search-box-layout end -->


    <!-- Main Header -->
    <header class="main-header style-two">

        <div class="header-top">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="header-info pull-left">
                        <ul class="info-list">
                            <li>
                                <i class="fas fa-phone"></i>
                                <a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a>
                            </li>
                        </ul>
                    </div>
                    <div class="outer-content pull-right">
                        <div class="login-box">
                            <i class="fas fa-user"></i>
                            <a href="../soon">Log in or Register</a>
                        </div>
                        <ul class="clearfix">
                            <li class="header-flyout-searchbar">
                                <i class="fa fa-search"></i>
                            </li>
                            <li><a href="../soon"><i class="fas fa-shopping-cart"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-bottom">
            <div class="container">
                <div class="inner-container">
                    <div class="nav-outer">
                        <div class="menu-area">
                            <nav class="main-menu navbar-expand-lg">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->      
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    </button>
                                </div>
                               <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li><a href="../../">Home</a></li>
                                        <li class="dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="../../pages/about">About Us</a></li>
                                                <li><a href="../../pages/uniforms">About Uniforms</a></li>
                                                <li><a href="../../pages/faqs">Faq Page</a></li>
                                                <li><a href="../../pages/testimonials">Testimonials</a></li>
                                            </ul>
                                        </li> 
                                        <li class="dropdown"><a href="#">Classes</a>
                                            <ul>
                                                <li><a href="../../pages/class">Our Classes</a></li>
                                                <li><a href="../../pages/activities">Our Activities</a></li></li>
                                            </ul>
                                        </li> 
                                        <li class="logo-box">
                                            <figure class="logo"><a href="../../"><img src="../../images/logo/ico4.png" alt="Scoris International"></a></figure>
                                        </li>
                                        <li class="dropdown"><a href="#">Pages</a>
                                            <ul>
                                        <li><a href="../../pages/gallery">Our Gallery</a></li>
                                        <li><a href="../../pages/events">Our Events</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="../../pages/blog">Blog</a></li>                              
                                        <li><a href="../../contact">Contact</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Sticky Header-->
        <div class="sticky-header">
            <div class="container clearfix">
                <figure class="logo-box"><a href="../../"><img src="../../images/logo/logo.png" alt="Scoris International"></a></figure>
                <div class="menu-area">
                    <nav class="main-menu navbar-expand-lg">
                        <div class="navbar-header">
                            <!-- Toggle Button -->      
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            </button>
                        </div>
                        <div class="navbar-collapse collapse clearfix">
                            <ul class="navigation clearfix">
                                <li><a href="../../">Home</a></li>
                                <li class="dropdown"><a href="#">About</a>
                                    <ul>
                                        <li><a href="../../pages/about">About Us</a></li>
                                        <li><a href="../../pages/uniforms">About Uniforms</a></li>
                                        <li><a href="../../pages/faqs">Faq Page</a></li>
                                        <li><a href="../../pages/testimonials">Testimonials</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Classes</a>
                                    <ul>
                                        <li><a href="../../pages/class">Our Classes</a></li>
                                        <li><a href="../../pages/activities">Our Activities</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Pages</a>
                                    <ul>
                                        <li><a href="../../pages/gallery">Our Gallery</a></li>
                                        <li><a href="../../pages/events">Our Events</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a href="../../pages/blog">Blog</a>
                                </li>                              
                                <li><a href="../../contact">Contact</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div><!-- sticky-header end -->
    </header>
    <!-- End Main Header -->


    <!--Page Title-->
    <section class="page-title centred" style="background-image: url(../../images/img/1/IMG_9041.webp);background-attachment: fixed;">
        <div class="container">
            <div class="content-box">
                <h1>FAQ’S</h1>
                <ul class="bread-crumb clearfix">
                    <li><a href="../../">Home</a></li>
                    <li>About</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->


    <?php
                if(isset($_SESSION['error'])){
                    echo
                    "
                    <div class='alert alert-danger text-center'>
                        <button class='close'>&times;</button>
                        ".$_SESSION['error']."
                    </div>
                    ";
                    unset($_SESSION['error']);
                }
                if(isset($_SESSION['success'])){
                    echo
                    "
                    <div class='alert alert-success text-center'>
                        <button class='close'>&times;</button>
                        ".$_SESSION['success']."
                    </div>
                    ";
                    unset($_SESSION['success']);
                }
            ?>


    <!-- faq-page-section -->
    <section class="faq-page-section">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-12 col-md-12 content-column">
                    <div class="content-box">
                        <div class="sec-title style-two">
                            <h5>Faq’s</h5>
                            <h1>Frequntly Ask Questions</h1>
                        </div>
                        <div class="text">
                            <p>We strictly follow the Cambridge curriculum which requires strict follow up on our young ones' progress through monthly assessments. We always have a one on one basis to evaluate and assess learners according to their abilities.</p>

                            <p>We offer an integrated approach towards learning all about helping every child reach their full potential. Leading provider in early childhood development foundation.</p>

                            <p>Putting quality education within reach of every child is our sole purpose and delivering an international learning experience in a clear, safe and child friendly environment is our every day.</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-12 col-md-12 faq-column">
                    <div class="faq-content">
                        <ul class="accordion-box active-block">
                            <li class="accordion block">
                                <div class="acc-btn active">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>What extra curriculum activities do you offer?</h4>
                                </div>
                                <div class="acc-content current">
                                    <div class="content">
                                        <div class="text">Outdoor activities, building blocks, reading story books, gluing, collage, painting, drawing, tearing, swimming, cutting, story telling & so much more. 
                                        <a href="../activities" style="color: #43b3d9;">See More</a>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>What classes do you offer?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">We follow the Cambridge curriculum which includes classes like mathematics, comprehension, expressive art, english, global studies, personal social & emotional development, literacy, physical development.
                                        <a href="../class" style="color: #fbb419;">See More</a>
                                    </div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                 <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>Is Outdoor Play Supervised?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">All our premises arecontrolled with 24hrs CCTV cameras.</div>
                                        <div class="text">We will unite to create and maintain a high quality and safe learning environment" enabling our dear ones to succeed 100%.</div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                 <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>What's the uniform schedule?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                    <div class="text" style="color: #b350ff;font-weight: bold;">Please take note of the uniform days.</div>

                                     <div class="text">

                                        <b>Monday</b>: Tie and dye T Shirt with Grey Shorts, Grey Socks and black shoes. <br>
                                        <b>Tuesday & Thursday</b>: White T. Shirt with Red Sports Shorts, red socks and canvas shoes. <br>
                                        <b>Wednesday & Friday</b>: Blue and White Dress, White Shirt with Blue Shorts, Blue Socks and Black Shoes.

                                        <a href="../class" style="color: #b350ff;">Checkout uniform page</a>

                                     </div>
                                    </div>
                                </div>
                            </li>
                            <li class="accordion block">
                                 <div class="acc-btn">
                                    <div class="icon-outer"><i class="fas fa-angle-down"></i></div>
                                    <h4>Do you have events for the students?</h4>
                                </div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">Yes, each term we organize events for the students & some require parent involvement. Checkout our events page & stay uptodate. 

                                        <a href="../class" style="color: #7379fe;">See Events</a></div>

                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- faq-page-section end -->


    <!-- contact-style-two -->
    <section class="contact-style-two centred sec-pad">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-md-12 col-sm-12 offset-lg-2 inner-column">
                    <div class="inner-box">
                        <div class="sec-title">
                            <h5>Contact</h5>
                            <h1>Ask A Question</h1>
                        </div>
                        <div class="form-area">
                            <form name="myform" action="submit/index.php" method="post" onsubmit="return validateform()">
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <input type="text" name="name" placeholder="Your Name" class="required">
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <input type="email" name="email" placeholder="Your Email" class="required">
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <textarea name="message" placeholder="Your Question" class="required"></textarea>
                                    </div>
                                     <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <div class="message-btn"><button type="submit" name="submit" class="theme-btn">Submit Question</button></div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-style-two -->


    <script type="text/javascript">
        
    function validateform(){  
var name=document.myform.name.value;  
var email=document.myform.email.value; 
var message=document.myform.message.value;  
  
if (name==null || name==""){  
  alert("Name field can't be blank");  
  return false;  

}else if(email==null || email==""){  
  alert("No Email Address Detected! Make sure you've provided a valid email!");  
  return false;  

}else if(message==null || message==""){  
  alert("No Question Detected! Make sure you've typed a question!");  
  return false;  
  }  
}  

    </script>


    <!-- main-footer -->
    <footer class="main-footer">
        <div class="footer-top">
            <div class="parallax-scene parallax-scene-4 parallax-icon">
                <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            </div>
            <div class="container">
                <div class="widget-section">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="about-widget footer-widget">
                                <h3 class="widget-title">Our Focus</h3>
                                <div class="widget-content">
                                    <div class="text">
                                        <p>At Scoris International Junior School our focus is providing an academic environment with the highest student achievement possible. In an engaging and safe learning environment, Children and teachers alike must become master learners, problem solvers and world communicators in order to be effective and successful</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="link-widget footer-widget">
                                <h3 class="widget-title">Useful Links</h3>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="../../pages/about">About Us</a></li>
                                        <li><a href="../../contact">Contact Us</a></li>
                                        <li><a href="../../pages/class">Classes</a></li>
                                        <li><a href="../../pages/activities">Activities</a></li>
                                        <li><a href="../../pages/events">Events</a></li>
                                        <li><a href="../../pages/gallery">Our Gallery</a></li>
                                        <li><a href="../../pages/faqs">FAQs</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                            <div class="contact-widget footer-widget">
                                <h3 class="widget-title">Get in Touch</h3>
                                <div class="widget-content">
                                    <div class="text">Open for enrolment, contact us & join the scoris family</div>
                                    <ul class="info-list">
                                        <li><i class="fas fa-home"></i>Makindye Division, Kansanga Kiwafu Road</li>
                                        <li><i class="fas fa-phone"></i><a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:academics@scorisinternationaljunior.com">academics@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:registration@scorisinternationaljunior.com">registration@scorisinternationaljunior.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-12 footer-column">
                            <div class="subscribe-widget footer-widget">
                                <h3 class="widget-title">Newsletter</h3>
                                <div class="widget-content">
                                    <div class="text">Receive important scoris updates.</div>
                                    <div class="subscribe-inner">
                                        <form method="POST" name="ContactForm" method="post" action="" class="subscribe-form">
                                            <div class="form-group" align="center">
                                              <div class="username"><input type="text" id="username" name="username" value=""></div>
                                              <input type="hidden" name="subject" id="subject" value="Scoris Newsletter Subscription">
                                                <input type="email" name="email" id="email" placeholder="Email Address" required="">
                                                <button type="submit" name="newsletter" id="newsletter" class="theme-btn" style="border-radius: 10px;">Submit</button>
                                            </div>

                                            <div align="center" class="message_box" style="margin:10px 0px;"></div>

                                        </form>
         
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="left-content pull-left">
                        <div class="copyright">Copyright &copy; <script>document.write(new Date().getFullYear());</script>, <a href="#">Scoris International Junior School</a>. All Rights Reserved</div>

                    </div> <br>
              
                    <div class="right-content pull-right">
                        <figure class="footer-logo"><a href="#"><img src="../../images/logo/footer-logo.png" alt="Scoris International"></a></figure>
                        <ul class="social-style-one footer-social clearfix">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="https://instagram.com/ScorisJuniors"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                        </ul>
                    </div>


                    <div class="copyright power-bottom">Powered by <a rel="sponsored" class="text-decoration-none" href="https://customassistinc.com/" target="_blank"><strong>Custom Assist Inc.</strong></a></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- main-footer end -->



<!--Scroll to top-->
<button class="scroll-top scroll-to-target" data-target="html">
    <i class="fa fa-arrow-up"></i>
</button>


<script src="../../js/js/jquery.min.js"></script>

<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var subject = $('#subject').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "https://scorisinternationaljunior.com/contact/newsletters/index.php",
             data: "email="+email+"&username="+username+"&subject="+subject+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box').html(
       '<div align="center"><img src="../../images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>



<!-- jequery plugins -->
<script src="../../js/jquery.js"></script>
<script src="../../js/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>

<script src="../../js/owl.js"></script>
<script src="../../js/wow.js"></script>
<script src="../../js/validation.js"></script>
<script src="../../js/jquery.fancybox.js"></script>
<script src="../../js/appear.js"></script>
<script src="../../js/parallax.min.js"></script>
<script src="../../js/isotope.js"></script>

<!-- map script -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA-CE0deH3Jhj6GN4YvdCFZS7DpbXexzGU"></script>
<script src="../../js/gmaps.js"></script>
<script src="../../js/map-helper.js"></script>

<!-- main-js -->
<script src="../../js/script.js"></script>

</body><!-- End of .page_wrapper -->
</html>
