<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Gallery | SIJSU &copy;</title>

<!-- Stylesheets -->
<link href="../../css/style.css" rel="stylesheet">
<link href="../../css/responsive.css" rel="stylesheet">
<link rel="icon" href="../../images/logo/ico4.png" type="image/x-icon">

</head>

<!-- page wrapper -->
<body class="boxed_wrapper">

    <!-- search-box-layout -->
    <div class="wraper_flyout_search">
        <div class="table">
            <div class="table-cell">
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-layer"></div>
                <div class="flyout-search-close">
                    <span class="flyout-search-close-line"></span>
                    <span class="flyout-search-close-line"></span>
                </div>
                <div class="flyout_search">
                    <div class="flyout-search-title">
                        <h4>Search</h4>
                    </div>
                    <div class="flyout-search-bar">
                        <form role="search" method="post" action="../search/index.php">
                            <div class="form-row">
                                <input type="search"name="valueToSearch"  placeholder="Search classes, activities or events" required="">
                                <button type="submit" name="search" value="Search"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search-box-layout end -->


    <!-- Main Header -->
    <header class="main-header style-two">

        <div class="header-top">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="header-info pull-left">
                        <ul class="info-list">
                            <li>
                                <i class="fas fa-phone"></i>
                                <a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a>
                            </li>
                        </ul>
                    </div>
                    <div class="outer-content pull-right">
                        <div class="login-box">
                            <i class="fas fa-user"></i>
                            <a href="../soon">Log in or Register</a>
                        </div>
                        <ul class="clearfix">
                            <li class="header-flyout-searchbar">
                                <i class="fa fa-search"></i>
                            </li>
                            <li><a href="../soon"><i class="fas fa-shopping-cart"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-bottom">
            <div class="container">
                <div class="inner-container">
                    <div class="nav-outer">
                        <div class="menu-area">
                            <nav class="main-menu navbar-expand-lg">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->      
                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    </button>
                                </div>
                               <div class="navbar-collapse collapse clearfix">
                                    <ul class="navigation clearfix">
                                        <li><a href="../../">Home</a></li>
                                        <li class="dropdown"><a href="#">About</a>
                                            <ul>
                                                <li><a href="../../pages/about">About Us</a></li>
                                                <li><a href="../../pages/uniforms">About Uniforms</a></li>
                                                <li><a href="../../pages/faqs">Faq Page</a></li>
                                                <li><a href="../../pages/testimonials">Testimonials</a></li>
                                            </ul>
                                        </li> 
                                        <li class="dropdown"><a href="#">Classes</a>
                                            <ul>
                                                <li><a href="../../pages/class">Our Classes</a></li>
                                                <li><a href="../../pages/activities">Our Activities</a></li></li>
                                            </ul>
                                        </li> 
                                        <li class="logo-box">
                                            <figure class="logo"><a href="../../"><img src="../../images/logo/ico4.png" alt="Scoris International"></a></figure>
                                        </li>
                                        <li class="dropdown"><a href="#">Pages</a>
                                            <ul>
                                        <li><a href="../../pages/gallery">Our Gallery</a></li>
                                        <li><a href="../../pages/events">Our Events</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="../../pages/blog">Blog</a></li>                              
                                        <li><a href="../../contact">Contact</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--Sticky Header-->
        <div class="sticky-header">
            <div class="container clearfix">
                <figure class="logo-box"><a href="../../"><img src="../../images/logo/logo.png" alt="Scoris International"></a></figure>
                <div class="menu-area">
                    <nav class="main-menu navbar-expand-lg">
                        <div class="navbar-header">
                            <!-- Toggle Button -->      
                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            </button>
                        </div>
                        <div class="navbar-collapse collapse clearfix">
                            <ul class="navigation clearfix">
                                <li><a href="../../">Home</a></li>
                                <li class="dropdown"><a href="#">About</a>
                                    <ul>
                                        <li><a href="../../pages/about">About Us</a></li>
                                        <li><a href="../../pages/uniforms">About Uniforms</a></li>
                                        <li><a href="../../pages/faqs">Faq Page</a></li>
                                        <li><a href="../../pages/testimonials">Testimonials</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Classes</a>
                                    <ul>
                                        <li><a href="../../pages/class">Our Classes</a></li>
                                        <li><a href="../../pages/activities">Our Activities</a></li>
                                    </ul>
                                </li> 
                                <li class="dropdown"><a href="#">Pages</a>
                                    <ul>
                                        <li><a href="../../pages/gallery">Our Gallery</a></li>
                                        <li><a href="../../pages/events">Our Events</a></li>
                                    </ul>
                                </li>
                                <li class="dropdown"><a href="../../pages/blog">Blog</a>
                                </li>                              
                                <li><a href="../../contact">Contact</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div><!-- sticky-header end -->
    </header>
    <!-- End Main Header -->


    <!--Page Title-->
    <section class="page-title centred" style="background-image: url(../../images/img/IMG_9398.jpg);background-attachment: fixed;">
        <div class="container">
            <div class="content-box">
                <h1>Our Gallery</h1>
                <ul class="bread-crumb clearfix">
                    <li><a href="../../">Home</a></li>
                    <li>Pages</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->


    <!-- portfolio-section -->
    <section class="gallery-page-section">
        <div class="container">
            <div class="sortable-masonry">
                <div class="filters">
                    <ul class="filter-tabs filter-btns centred clearfix">
                        <li class="active filter" data-role="button" data-filter=".all">All</li>
                        <li class="filter" data-role="button" data-filter=".children">Children</li>
                        <li class="filter" data-role="button" data-filter=".outdoor">Outdoor</li>
                        <li class="filter" data-role="button" data-filter=".staff">Staff</li>
                        <li class="filter" data-role="button" data-filter=".nature">Nature</li>
                        <li class="filter" data-role="button" data-filter=".activities">Activities</li>
                        <li class="filter" data-role="button" data-filter=".interior">Interior</li>
                    </ul>
                </div>
                <div class="items-container row clearfix">
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children outdoor staff activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9332.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9332.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children outdoor activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9181.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9181.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all nature">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_8994.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_8994.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children outdoor activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9207.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9207.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9041.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9041.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9144.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9144.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children outdoor activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9176.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9176.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children outdoor activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9192.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9192.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9064.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9064.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children outdoor">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9295.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9295.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all staff">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9278.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9278.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all children">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9261.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9261.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all interior">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9016.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9016.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all outdoor nature">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9398.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9398.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all activities outdoor">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_8991.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_8991.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all activities staff">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9153.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9153.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all outdoor activities staff">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9208.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9208.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6 masonry-item small-column all activities">
                        <div class="gallery-block">
                            <div class="image-box">
                                <figure class="image"><img src="../../images/img/IMG_9227.jpg" alt=""></figure>
                                <div class="overlay-box"><a href="../../images/img/IMG_9227.jpg" class="lightbox-image" data-fancybox="gallery"><i class="flaticon-add"></i></a></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- portfolio-section end -->


    <!-- main-footer -->
    <footer class="main-footer">
        <div class="footer-top">
            <div class="parallax-scene parallax-scene-4 parallax-icon">
                <span data-depth="0.40" class="parallax-layer icon icon-1"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-2"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-3"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-4"></span>
                <span data-depth="0.50" class="parallax-layer icon icon-5"></span>
                <span data-depth="0.30" class="parallax-layer icon icon-6"></span>
                <span data-depth="0.40" class="parallax-layer icon icon-7"></span>
            </div>
            <div class="container">
                <div class="widget-section">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="about-widget footer-widget">
                                <h3 class="widget-title">Our Focus</h3>
                                <div class="widget-content">
                                    <div class="text">
                                        <p>At Scoris International Junior School our focus is providing an academic environment with the highest student achievement possible. In an engaging and safe learning environment, Children and teachers alike must become master learners, problem solvers and world communicators in order to be effective and successful</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 col-sm-12 footer-column">
                            <div class="link-widget footer-widget">
                                <h3 class="widget-title">Useful Links</h3>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="../../pages/about">About Us</a></li>
                                        <li><a href="../../contact">Contact Us</a></li>
                                        <li><a href="../../pages/class">Classes</a></li>
                                        <li><a href="../../pages/activities">Activities</a></li>
                                        <li><a href="../../pages/events">Events</a></li>
                                        <li><a href="../../pages/gallery">Our Gallery</a></li>
                                        <li><a href="../../pages/faqs">FAQs</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                            <div class="contact-widget footer-widget">
                                <h3 class="widget-title">Get in Touch</h3>
                                <div class="widget-content">
                                    <div class="text">Open for enrolment, contact us & join the scoris family</div>
                                    <ul class="info-list">
                                        <li><i class="fas fa-home"></i>Makindye Division, Kansanga Kiwafu Road</li>
                                        <li><i class="fas fa-phone"></i><a href="tel:+256393256880">+256 393 256880</a> | <a href="tel:+256700110828">+256 700 110828</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:info@scorisinternationaljunior.com">info@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:academics@scorisinternationaljunior.com">academics@scorisinternationaljunior.com</a></li>
                                        <li><i class="fas fa-envelope"></i><a href="mailto:registration@scorisinternationaljunior.com">registration@scorisinternationaljunior.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-sm-12 footer-column">
                            <div class="subscribe-widget footer-widget">
                                <h3 class="widget-title">Newsletter</h3>
                                <div class="widget-content">
                                    <div class="text">Receive important scoris updates.</div>
                                    <div class="subscribe-inner">
                                        <form method="POST" name="ContactForm" method="post" action="" class="subscribe-form">
                                            <div class="form-group" align="center">
                                              <div class="username"><input type="text" id="username" name="username" value=""></div>
                                              <input type="hidden" name="subject" id="subject" value="Scoris Newsletter Subscription">
                                                <input type="email" name="email" id="email" placeholder="Email Address" required="">
                                                <button type="submit" name="newsletter" id="newsletter" class="theme-btn" style="border-radius: 10px;">Submit</button>
                                            </div>

                                            <div align="center" class="message_box" style="margin:10px 0px;"></div>

                                        </form>
         
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="inner-container clearfix">
                    <div class="left-content pull-left">
                        <div class="copyright">Copyright &copy; <script>document.write(new Date().getFullYear());</script>, <a href="#">Scoris International Junior School</a>. All Rights Reserved</div>

                    </div> <br>
              
                    <div class="right-content pull-right">
                        <figure class="footer-logo"><a href="#"><img src="../../images/logo/footer-logo.png" alt="Scoris International"></a></figure>
                        <ul class="social-style-one footer-social clearfix">
                            <li><a href="https://facebook.com/ScorisJuniors"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="https://twitter.com/ScorisJuniors"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="https://instagram.com/ScorisJuniors"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://wa.me/256700110828"><i class="fab fa-whatsapp"></i></a></li>
                        </ul>
                    </div>


                    <div class="copyright power-bottom">Powered by <a rel="sponsored" class="text-decoration-none" href="https://customassistinc.com/" target="_blank"><strong>Custom Assist Inc.</strong></a></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- main-footer end -->



<!--Scroll to top-->
<button class="scroll-top scroll-to-target" data-target="html">
    <i class="fa fa-arrow-up"></i>
</button>


<script src="../../js/js/jquery.min.js"></script>

<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var subject = $('#subject').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:red;">Enter Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:red;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "https://scorisinternationaljunior.com/contact/newsletters/index.php",
             data: "email="+email+"&username="+username+"&subject="+subject+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box').html(
       '<div align="center"><img src="../../images/ajax.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>



<!-- jequery plugins -->
<script src="../../js/jquery.js"></script>
<script src="../../js/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>

<script src="../../js/owl.js"></script>
<script src="../../js/wow.js"></script>
<script src="../../js/validation.js"></script>
<script src="../../js/jquery.fancybox.js"></script>
<script src="../../js/appear.js"></script>
<script src="../../js/parallax.min.js"></script>
<script src="../../js/isotope.js"></script>

<!-- map script -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA-CE0deH3Jhj6GN4YvdCFZS7DpbXexzGU"></script>
<script src="../../js/gmaps.js"></script>
<script src="../../js/map-helper.js"></script>

<!-- main-js -->
<script src="../../js/script.js"></script>

</body><!-- End of .page_wrapper -->
</html>
