<?php echo showSectionHead($spTextPanel['About Us']); ?>

<div style="max-width: 1200px; margin: 0 auto;">
    <!-- Hero Section -->
    <div style="background: linear-gradient(135deg, #10b981 0%, #059669 50%, #047857 100%); padding: 40px; border-radius: 12px; margin-bottom: 30px; box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);">
        <div style="text-align: center; color: #ffffff;">
            <i class="fa fa-book" style="font-size: 48px; margin-bottom: 15px; opacity: 0.9;"></i>
            <h2 style="font-size: 32px; font-weight: 700; margin: 0 0 12px 0; text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);">SEO Diary</h2>
            <p style="font-size: 18px; margin: 0; opacity: 0.95; line-height: 1.6;">Your Complete Project Management & SEO Documentation Tool</p>
        </div>
    </div>

    <!-- What is SEO Diary -->
    <div style="background: #ffffff; padding: 30px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08); border-left: 4px solid #10b981;">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 20px 0; display: flex; align-items: center;">
            <i class="fa fa-info-circle" style="color: #10b981; margin-right: 12px; font-size: 28px;"></i>
            What is SEO Diary?
        </h3>
        <p style="color: #4a5568; font-size: 16px; line-height: 1.8; margin: 0 0 15px 0;">
            SEO Diary is a powerful project management and documentation plugin designed specifically for SEO professionals.
            It helps you organize your SEO projects, track tasks, document your work, and collaborate with team members effectively.
        </p>
        <p style="color: #4a5568; font-size: 16px; line-height: 1.8; margin: 0;">
            Whether you're managing multiple client projects or keeping detailed records of your SEO campaigns, SEO Diary
            provides you with all the tools you need to stay organized, productive, and successful.
        </p>
    </div>

    <!-- Key Features -->
    <div style="background: #ffffff; padding: 30px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 25px 0; display: flex; align-items: center;">
            <i class="fa fa-star" style="color: #10b981; margin-right: 12px; font-size: 28px;"></i>
            Key Features
        </h3>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px;">
            <!-- Feature 1 -->
            <div style="padding: 20px; background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-radius: 10px; border: 1px solid #cbd5e0;">
                <div style="display: flex; align-items: center; margin-bottom: 12px;">
                    <i class="fa fa-project-diagram" style="color: #10b981; font-size: 24px; margin-right: 12px;"></i>
                    <h4 style="margin: 0; color: #2d3748; font-size: 18px;">Project Management</h4>
                </div>
                <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                    Create and manage multiple SEO projects with ease. Organize clients, campaigns, and workflows efficiently.
                </p>
            </div>

            <!-- Feature 2 -->
            <div style="padding: 20px; background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-radius: 10px; border: 1px solid #cbd5e0;">
                <div style="display: flex; align-items: center; margin-bottom: 12px;">
                    <i class="fa fa-tasks" style="color: #3b82f6; font-size: 24px; margin-right: 12px;"></i>
                    <h4 style="margin: 0; color: #2d3748; font-size: 18px;">Task Tracking</h4>
                </div>
                <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                    Keep track of all your SEO tasks, set priorities, and monitor progress with detailed task management.
                </p>
            </div>

            <!-- Feature 3 -->
            <div style="padding: 20px; background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-radius: 10px; border: 1px solid #cbd5e0;">
                <div style="display: flex; align-items: center; margin-bottom: 12px;">
                    <i class="fa fa-edit" style="color: #f59e0b; font-size: 24px; margin-right: 12px;"></i>
                    <h4 style="margin: 0; color: #2d3748; font-size: 18px;">Diary Entries</h4>
                </div>
                <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                    Document your daily SEO activities, notes, and insights. Maintain a complete history of your work.
                </p>
            </div>

            <!-- Feature 4 -->
            <div style="padding: 20px; background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-radius: 10px; border: 1px solid #cbd5e0;">
                <div style="display: flex; align-items: center; margin-bottom: 12px;">
                    <i class="fa fa-comments" style="color: #8b5cf6; font-size: 24px; margin-right: 12px;"></i>
                    <h4 style="margin: 0; color: #2d3748; font-size: 18px;">Team Collaboration</h4>
                </div>
                <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                    Add comments, discuss strategies, and collaborate with team members on diary entries.
                </p>
            </div>

            <!-- Feature 5 -->
            <div style="padding: 20px; background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-radius: 10px; border: 1px solid #cbd5e0;">
                <div style="display: flex; align-items: center; margin-bottom: 12px;">
                    <i class="fa fa-bell" style="color: #ef4444; font-size: 24px; margin-right: 12px;"></i>
                    <h4 style="margin: 0; color: #2d3748; font-size: 18px;">Notifications</h4>
                </div>
                <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                    Stay updated with email notifications for important diary entries and project updates.
                </p>
            </div>

            <!-- Feature 6 -->
            <div style="padding: 20px; background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); border-radius: 10px; border: 1px solid #cbd5e0;">
                <div style="display: flex; align-items: center; margin-bottom: 12px;">
                    <i class="fa fa-chart-line" style="color: #06b6d4; font-size: 24px; margin-right: 12px;"></i>
                    <h4 style="margin: 0; color: #2d3748; font-size: 18px;">Project Summary</h4>
                </div>
                <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                    Get comprehensive project summaries and reports to track overall progress and achievements.
                </p>
            </div>
        </div>
    </div>

    <!-- Benefits -->
    <div style="background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%); padding: 30px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08); border-left: 4px solid #3b82f6;">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 20px 0; display: flex; align-items: center;">
            <i class="fa fa-trophy" style="color: #3b82f6; margin-right: 12px; font-size: 28px;"></i>
            Benefits for SEO Professionals
        </h3>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            <div style="display: flex; align-items: start; gap: 15px;">
                <i class="fa fa-check-circle" style="color: #10b981; font-size: 24px; margin-top: 2px; flex-shrink: 0;"></i>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: #1e40af; font-size: 16px;">Better Organization</h4>
                    <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                        Keep all your SEO projects, tasks, and notes organized in one central location.
                    </p>
                </div>
            </div>

            <div style="display: flex; align-items: start; gap: 15px;">
                <i class="fa fa-check-circle" style="color: #10b981; font-size: 24px; margin-top: 2px; flex-shrink: 0;"></i>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: #1e40af; font-size: 16px;">Improved Productivity</h4>
                    <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                        Stay focused and productive with clear task lists and project timelines.
                    </p>
                </div>
            </div>

            <div style="display: flex; align-items: start; gap: 15px;">
                <i class="fa fa-check-circle" style="color: #10b981; font-size: 24px; margin-top: 2px; flex-shrink: 0;"></i>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: #1e40af; font-size: 16px;">Complete Documentation</h4>
                    <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                        Maintain detailed records of all SEO activities for accountability and reference.
                    </p>
                </div>
            </div>

            <div style="display: flex; align-items: start; gap: 15px;">
                <i class="fa fa-check-circle" style="color: #10b981; font-size: 24px; margin-top: 2px; flex-shrink: 0;"></i>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: #1e40af; font-size: 16px;">Enhanced Collaboration</h4>
                    <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                        Work seamlessly with team members through shared projects and comments.
                    </p>
                </div>
            </div>

            <div style="display: flex; align-items: start; gap: 15px;">
                <i class="fa fa-check-circle" style="color: #10b981; font-size: 24px; margin-top: 2px; flex-shrink: 0;"></i>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: #1e40af; font-size: 16px;">Client Transparency</h4>
                    <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                        Show clients exactly what work has been done with detailed project logs.
                    </p>
                </div>
            </div>

            <div style="display: flex; align-items: start; gap: 15px;">
                <i class="fa fa-check-circle" style="color: #10b981; font-size: 24px; margin-top: 2px; flex-shrink: 0;"></i>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: #1e40af; font-size: 16px;">Historical Insights</h4>
                    <p style="color: #4a5568; font-size: 14px; line-height: 1.6; margin: 0;">
                        Review past activities to learn from successes and avoid repeating mistakes.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Use Cases -->
    <div style="background: #ffffff; padding: 30px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 20px 0; display: flex; align-items: center;">
            <i class="fa fa-lightbulb" style="color: #f59e0b; margin-right: 12px; font-size: 28px;"></i>
            Perfect For
        </h3>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 18px;">
            <div style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); padding: 18px; border-radius: 8px; border-left: 3px solid #f59e0b;">
                <h4 style="margin: 0 0 8px 0; color: #92400e; font-size: 16px; display: flex; align-items: center;">
                    <i class="fa fa-user-tie" style="margin-right: 8px;"></i>
                    SEO Agencies
                </h4>
                <p style="color: #78350f; font-size: 14px; line-height: 1.5; margin: 0;">
                    Managing multiple client projects with detailed documentation
                </p>
            </div>

            <div style="background: linear-gradient(135deg, #ddd6fe 0%, #c4b5fd 100%); padding: 18px; border-radius: 8px; border-left: 3px solid #8b5cf6;">
                <h4 style="margin: 0 0 8px 0; color: #5b21b6; font-size: 16px; display: flex; align-items: center;">
                    <i class="fa fa-user" style="margin-right: 8px;"></i>
                    Freelancers
                </h4>
                <p style="color: #6b21a8; font-size: 14px; line-height: 1.5; margin: 0;">
                    Organizing personal SEO projects and client work
                </p>
            </div>

            <div style="background: linear-gradient(135deg, #ccfbf1 0%, #99f6e4 100%); padding: 18px; border-radius: 8px; border-left: 3px solid #14b8a6;">
                <h4 style="margin: 0 0 8px 0; color: #115e59; font-size: 16px; display: flex; align-items: center;">
                    <i class="fa fa-users" style="margin-right: 8px;"></i>
                    SEO Teams
                </h4>
                <p style="color: #134e4a; font-size: 14px; line-height: 1.5; margin: 0;">
                    Collaborating on campaigns with shared project access
                </p>
            </div>

            <div style="background: linear-gradient(135deg, #fecdd3 0%, #fda4af 100%); padding: 18px; border-radius: 8px; border-left: 3px solid #f43f5e;">
                <h4 style="margin: 0 0 8px 0; color: #881337; font-size: 16px; display: flex; align-items: center;">
                    <i class="fa fa-building" style="margin-right: 8px;"></i>
                    In-House SEO
                </h4>
                <p style="color: #9f1239; font-size: 14px; line-height: 1.5; margin: 0;">
                    Tracking internal SEO initiatives and reporting progress
                </p>
            </div>
        </div>
    </div>

    <!-- Core Functionality -->
    <div style="background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); padding: 30px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08); border-left: 4px solid #10b981;">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 20px 0; display: flex; align-items: center;">
            <i class="fa fa-cog" style="color: #10b981; margin-right: 12px; font-size: 28px;"></i>
            Core Functionality
        </h3>
        <ul style="color: #4a5568; font-size: 16px; line-height: 2; margin: 0; padding-left: 25px;">
            <li><strong>Project Creation:</strong> Create unlimited SEO projects linked to specific websites</li>
            <li><strong>Diary Management:</strong> Write detailed diary entries for each project with rich text formatting</li>
            <li><strong>Task Assignment:</strong> Assign and track tasks within each project</li>
            <li><strong>Comment System:</strong> Add comments to diary entries for team discussions</li>
            <li><strong>Email Notifications:</strong> Automated notifications for important diary updates</li>
            <li><strong>Project Summary:</strong> View comprehensive summaries of all project activities</li>
            <li><strong>Settings Control:</strong> Customize notification preferences and display options</li>
            <li><strong>Search & Filter:</strong> Quickly find diary entries and projects with advanced filters</li>
        </ul>
    </div>

    <!-- Technology Stack -->
    <div style="background: #ffffff; padding: 30px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 25px 0; display: flex; align-items: center;">
            <i class="fa fa-code" style="color: #10b981; margin-right: 12px; font-size: 28px;"></i>
            Built With Modern Technology
        </h3>
        <div style="display: flex; flex-wrap: wrap; gap: 12px;">
            <span style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #ffffff; padding: 10px 20px; border-radius: 25px; font-weight: 600; font-size: 14px; box-shadow: 0 2px 6px rgba(102, 126, 234, 0.3);">
                <i class="fab fa-php"></i> PHP
            </span>
            <span style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: #ffffff; padding: 10px 20px; border-radius: 25px; font-weight: 600; font-size: 14px; box-shadow: 0 2px 6px rgba(240, 147, 251, 0.3);">
                <i class="fa fa-database"></i> MySQL
            </span>
            <span style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: #ffffff; padding: 10px 20px; border-radius: 25px; font-weight: 600; font-size: 14px; box-shadow: 0 2px 6px rgba(79, 172, 254, 0.3);">
                <i class="fab fa-html5"></i> HTML5
            </span>
            <span style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); color: #ffffff; padding: 10px 20px; border-radius: 25px; font-weight: 600; font-size: 14px; box-shadow: 0 2px 6px rgba(67, 233, 123, 0.3);">
                <i class="fab fa-css3-alt"></i> CSS3
            </span>
            <span style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); color: #ffffff; padding: 10px 20px; border-radius: 25px; font-weight: 600; font-size: 14px; box-shadow: 0 2px 6px rgba(250, 112, 154, 0.3);">
                <i class="fab fa-js"></i> JavaScript
            </span>
            <span style="background: linear-gradient(135deg, #30cfd0 0%, #330867 100%); color: #ffffff; padding: 10px 20px; border-radius: 25px; font-weight: 600; font-size: 14px; box-shadow: 0 2px 6px rgba(48, 207, 208, 0.3);">
                <i class="fa fa-sync"></i> AJAX
            </span>
        </div>
    </div>

    <!-- Developers -->
    <div style="background: #ffffff; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08); text-align: center;">
        <h3 style="color: #2d3748; font-size: 24px; margin: 0 0 20px 0; display: flex; align-items: center; justify-content: center;">
            <i class="fa fa-users" style="color: #10b981; margin-right: 12px; font-size: 28px;"></i>
            <?php echo $spText['label']['Developers']?>
        </h3>
        <p style="color: #4a5568; font-size: 16px; margin: 0 0 20px 0; line-height: 1.6;">
            SEO Diary is proudly developed and maintained by the SEO Panel Team
        </p>
        <div style="display: inline-flex; align-items: center; background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 15px 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
            <i class="fa fa-globe" style="color: #ffffff; font-size: 24px; margin-right: 12px;"></i>
            <a href="https://www.seopanel.org/" target="_blank" style="color: #ffffff; font-size: 18px; font-weight: 600; text-decoration: none;">
                www.seopanel.org
            </a>
        </div>
        <p style="color: #718096; font-size: 14px; margin: 20px 0 0 0;">
            <i class="fa fa-heart" style="color: #ef4444;"></i> Built with dedication for SEO professionals worldwide
        </p>
    </div>
</div>
