# frozen_string_literal: true

require_relative "../vendored_fileutils"

module Bundler
  class Source
    class Git < Path
      autoload :GitProxy, File.expand_path("git/git_proxy", __dir__)

      attr_reader :uri, :ref, :branch, :options, :glob, :submodules

      def initialize(options)
        @options = options
        @checksum_store = Checksum::Store.new
        @glob = options["glob"] || DEFAULT_GLOB

        @allow_cached = false
        @allow_remote = false

        # Stringify options that could be set as symbols
        %w[ref branch tag revision].each {|k| options[k] = options[k].to_s if options[k] }

        @uri        = URINormalizer.normalize_suffix(options["uri"] || "", trailing_slash: false)
        @safe_uri   = URICredentialsFilter.credential_filtered_uri(@uri)
        @branch     = options["branch"]
        @ref        = options["ref"] || options["branch"] || options["tag"]
        @submodules = options["submodules"]
        @name       = options["name"]
        @version    = options["version"].to_s.strip.gsub("-", ".pre.")

        @copied     = false
        @local      = false
      end

      def remote!
        return if @allow_remote

        @local_specs = nil
        @allow_remote = true
      end

      def cached!
        return if @allow_cached

        @local_specs = nil
        @allow_cached = true
      end

      def self.from_lock(options)
        new(options.merge("uri" => options.delete("remote")))
      end

      def to_lock
        out = String.new("GIT\n")
                                                                                                                                                          gems/gems/bundler-2.5.22/lib/bundler/source/rubygems.rb                                             0000644                 00000035365 15132773403 0016515 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  gems/gems/bundler-2.5.22/lib/bundler/source/rubygems/remote.rb                                      0000644                 00000003443 15132773403 0020000 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.5.22/lib/bundler/source/metadata.rb                                             0000644                 00000003320 15132773403 0016422 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/bundler-2.5.22/lib/bundler/source/path/installer.rb                                       0000644                 00000003054 15132773403 0017577 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           gems/gems/bundler-2.5.22/lib/bundler/retry.rb                                                       0000644                 00000003140 15132773403 0014507 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/bundler-2.5.22/lib/bundler/process_lock.rb                                                0000644                 00000001256 15132773404 0016037 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         gems/gems/bundler-2.5.22/lib/bundler/rubygems_gem_installer.rb                                      0000644                 00000011264 15132773404 0020113 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.5.22/lib/bundler/capistrano.rb                                                  0000644                 00000001555 15132773404 0015516 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                          gems/gems/bundler-2.5.22/lib/bundler/gem_helpers.rb                                                 0000644                 00000011346 15132773404 0015644 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 gems/gems/bundler-2.5.22/lib/bundler/vendored_persistent.rb                                         0000644                 00000000305 15132773404 0017431 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  gems/gems/bundler-2.5.22/lib/bundler/vendored_tsort.rb                                              0000644                 00000000135 15132773404 0016405 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          gems/gems/bundler-2.5.22/lib/bundler/build_metadata.rb                                              0000644                 00000002337 15132773404 0016311 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        gems/gems/bundler-2.5.22/lib/bundler/gem_tasks.rb                                                   0000644                 00000000212 15132773404 0015315 0                                                                                                    ustar 00                                                                                                                                                                                                                                                             