
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `shopware6761`
--


-- --------------------------------------------------------

--
-- Table structure for table `acl_role`
--

CREATE TABLE `acl_role` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `privileges` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_user_role`
--

CREATE TABLE `acl_user_role` (
  `user_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`acl_role_id`),
  KEY `fk.acl_user_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app`
--

CREATE TABLE `app` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(4096) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_app_url` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `allow_disable` tinyint(1) NOT NULL DEFAULT '1',
  `configurable` tinyint(1) NOT NULL DEFAULT '0',
  `icon` mediumblob,
  `app_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modules` json DEFAULT NULL,
  `main_module` json DEFAULT NULL,
  `cookies` json DEFAULT NULL,
  `allowed_hosts` json DEFAULT NULL,
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_load_priority` int DEFAULT '0',
  `checkout_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `self_managed` tinyint(1) NOT NULL DEFAULT '0',
  `source_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `source_config` json NOT NULL DEFAULT (json_object()),
  `in_app_purchases_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `requested_privileges` json NOT NULL DEFAULT (json_array()),
  `context_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.name` (`name`),
  KEY `fk.app.integration_id` (`integration_id`),
  KEY `fk.app.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button`
--

CREATE TABLE `app_action_button` (
  `id` binary(16) NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `view` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_action_button.action` (`action`,`app_id`),
  KEY `fk.app_action_button.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button_translation`
--

CREATE TABLE `app_action_button_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_action_button_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  PRIMARY KEY (`app_action_button_id`,`language_id`),
  KEY `fk.app_action_button_translation.app_action_button_id` (`app_action_button_id`),
  KEY `fk.app_action_button_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_administration_snippet`
--

CREATE TABLE `app_administration_snippet` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `locale_id` binary(16) NOT NULL,
  `value` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_id` (`app_id`),
  KEY `fk.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block`
--

CREATE TABLE `app_cms_block` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `block` json NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `styles` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_cms_block.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block_translation`
--

CREATE TABLE `app_cms_block_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_cms_block_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_cms_block_id`,`language_id`),
  KEY `fk.app_cms_block_translation.app_cms_block_id` (`app_cms_block_id`),
  KEY `fk.app_cms_block_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_config`
--

CREATE TABLE `app_config` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action`
--

CREATE TABLE `app_flow_action` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `badge` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delayable` tinyint(1) NOT NULL DEFAULT '0',
  `parameters` json DEFAULT NULL,
  `config` json DEFAULT NULL,
  `headers` json DEFAULT NULL,
  `requirements` json DEFAULT NULL,
  `icon` mediumblob,
  `sw_icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_flow_action.name` (`name`),
  KEY `fk.app_flow_action.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action_translation`
--

CREATE TABLE `app_flow_action_translation` (
  `app_flow_action_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_flow_action_id`,`language_id`),
  KEY `fk.app_flow_action_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_event`
--

CREATE TABLE `app_flow_event` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aware` json NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uniq.app_flow_event.name` (`name`),
  KEY `fk.app_flow_event.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_payment_method`
--

CREATE TABLE `app_payment_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `payment_method_id` binary(16) NOT NULL,
  `app_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `finalize_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validate_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `capture_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refund_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `recurring_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_payment_method.payment_method_id` (`payment_method_id`),
  KEY `fk.app_payment_method.app_id` (`app_id`),
  KEY `fk.app_payment_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition`
--

CREATE TABLE `app_script_condition` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `script` longtext COLLATE utf8mb4_unicode_ci,
  `constraints` longblob,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_script_condition.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition_translation`
--

CREATE TABLE `app_script_condition_translation` (
  `app_script_condition_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_script_condition_id`,`language_id`),
  KEY `fk.app_script_condition_translation.app_script_condition_id` (`app_script_condition_id`),
  KEY `fk.app_script_condition_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_shipping_method`
--

CREATE TABLE `app_shipping_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `app_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_method_id` binary(16) NOT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `identifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_shipping_method.shipping_method_id` (`shipping_method_id`),
  KEY `fk.app_shipping_method.app_id` (`app_id`),
  KEY `fk.app_shipping_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_template`
--

CREATE TABLE `app_template` (
  `id` binary(16) NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.template.path` (`path`(256)),
  KEY `fk.template.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_translation`
--

CREATE TABLE `app_translation` (
  `app_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `privacy_policy_extensions` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_id`,`language_id`),
  KEY `fk.app_translation.app_id` (`app_id`),
  KEY `fk.app_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cart`
--

CREATE TABLE `cart` (
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule_ids` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `auto_increment` bigint NOT NULL AUTO_INCREMENT,
  `compressed` tinyint(1) NOT NULL DEFAULT '0',
  `payload` longblob,
  PRIMARY KEY (`token`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.cart.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `auto_increment` int NOT NULL AUTO_INCREMENT,
  `parent_id` binary(16) DEFAULT NULL,
  `parent_version_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) DEFAULT NULL,
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `product_stream_id` binary(16) DEFAULT NULL,
  `product_assignment_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `after_category_id` binary(16) DEFAULT NULL,
  `after_category_version_id` binary(16) DEFAULT NULL,
  `level` int unsigned NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `child_count` int unsigned NOT NULL DEFAULT '0',
  `display_nested_products` tinyint unsigned NOT NULL DEFAULT '1',
  `visible` tinyint unsigned NOT NULL DEFAULT '1',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `custom_entity_type_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.level` (`level`),
  KEY `fk.category.media_id` (`media_id`),
  KEY `fk.category.parent_id` (`parent_id`,`parent_version_id`),
  KEY `fk.category.after_category_id` (`after_category_id`,`after_category_version_id`),
  KEY `fk.category.product_stream_id` (`product_stream_id`),
  KEY `fk.category.cms_page_id` (`cms_page_id`,`cms_page_version_id`),
  KEY `fk.category.custom_entity_type_id` (`custom_entity_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `category`
--

INSERT INTO `category` VALUES
('Z\\rۚ葉x''', 'jK¾Ku,4%', 1, NULL, NULL, NULL, NULL, 'jK¾Ku,4%', NULL, 'product', NULL, NULL, NULL, 1, 1, 0, 1, 1, 'page', '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `category_tag`
--

CREATE TABLE `category_tag` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`tag_id`),
  KEY `fk.category_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category_translation`
--

CREATE TABLE `category_translation` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb` json DEFAULT NULL,
  `internal_link` binary(16) DEFAULT NULL,
  `link_new_tab` tinyint DEFAULT NULL,
  `link_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`language_id`),
  KEY `fk.category_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `category_translation`
--

INSERT INTO `category_translation` VALUES
('Z\\rۚ葉x''', 'jK¾Ku,4%', 'ZMp?X}', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL),
('Z\\rۚ葉x''', 'jK¾Ku,4%', '/_MpXT|', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_block`
--

CREATE TABLE `cms_block` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_section_id` binary(16) DEFAULT NULL,
  `cms_section_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `section_position` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'main',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `margin_top` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_bottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_left` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_right` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_block.background_media_id` (`background_media_id`),
  KEY `fk.cms_block.cms_section_id` (`cms_section_id`,`cms_section_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_block`
--

INSERT INTO `cms_block` VALUES
('Z`s©1Yk', 'jK¾Ku,4%', 'ZssRA.(J', 'jK¾Ku,4%', 3, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z`s©1Y', 'jK¾Ku,4%', 'ZssRA.(J', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zur)/', 'jK¾Ku,4%', 'ZssRA.(J', 'jK¾Ku,4%', 2, 'main', 'sidebar-filter', 'Filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zvp"A$~', 'jK¾Ku,4%', 'ZvpO`g\Z', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zvp"AfH', 'jK¾Ku,4%', 'ZvpO`', 'jK¾Ku,4%', 1, 'sidebar', 'category-navigation', 'Sidebar navigation', 1, NULL, '30px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zvp"AS:', 'jK¾Ku,4%', 'ZvpO`', 'jK¾Ku,4%', 2, 'sidebar', 'sidebar-filter', 'Sidebar filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zvp"B*', 'jK¾Ku,4%', 'ZvpO`', 'jK¾Ku,4%', 2, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z=q%a', 'jK¾Ku,4%', 'Z;qh,_', 'jK¾Ku,4%', 1, 'main', 'form', 'Contact form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZXr*>\\"', 'jK¾Ku,4%', 'ZUs̿k', 'jK¾Ku,4%', 1, 'main', 'form', 'Newsletter form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZrŎ	A F', 'jK¾Ku,4%', 'ZrŎ	@|', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zr-hۥ', 'jK¾Ku,4%', 'Zr-hm2', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zpߟڼ߈', 'jK¾Ku,4%', 'Zpߟڼ', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zpڋ:', 'jK¾Ku,4%', 'Zpڋ:BE', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zypd*2σ', 'jK¾Ku,4%', 'Zypd)9p', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z&rI^\0En', 'jK¾Ku,4%', 'Z#p&!', 'jK¾Ku,4%', 0, 'main', 'product-heading', 'Product heading', 1, '0', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z&rI^1+', 'jK¾Ku,4%', 'Z#p&!', 'jK¾Ku,4%', 1, 'main', 'gallery-buybox', 'Gallery buy box', 1, '20px', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z&rI_8', 'jK¾Ku,4%', 'Z#p&!', 'jK¾Ku,4%', 2, 'main', 'product-description-reviews', 'Product description and reviews', 1, '20px', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z&rI_', 'jK¾Ku,4%', 'Z#p&!', 'jK¾Ku,4%', 3, 'main', 'cross-selling', 'Cross selling', 1, '0', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('[r֣ckg4', 'jK¾Ku,4%', 'ZssRA.(J', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('[p߹ЈśA', 'jK¾Ku,4%', 'ZvpO`g\Z', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page`
--

CREATE TABLE `cms_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preview_media_id` binary(16) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_page.preview_media_id` (`preview_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page`
--

INSERT INTO `cms_page` VALUES
('Z`pPkI5', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('Zv	sɓ4N', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('Z-s8KCn&', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('ZKr(_g', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('ZrŎ	@M!', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('Zr-hn', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('ZpߟڼC/', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('Zpڋ:7^', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('Zypd)7[', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'product_detail', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page_translation`
--

CREATE TABLE `cms_page_translation` (
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`,`language_id`,`cms_page_version_id`),
  KEY `fk.cms_page_translation.language_id` (`language_id`),
  KEY `fk.cms_page_translation.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page_translation`
--

INSERT INTO `cms_page_translation` VALUES
('Z`pPkI5', 'jK¾Ku,4%', 'ZMp?X}', 'Standard Kategorie-Layout', NULL, '[[regtime_]]', NULL),
('Z`pPkI5', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout', NULL, '[[regtime_]]', NULL),
('Zv	sɓ4N', 'jK¾Ku,4%', 'ZMp?X}', 'Standard Kategorie-Layout mit Sidebar', NULL, '[[regtime_]]', NULL),
('Zv	sɓ4N', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout with sidebar', NULL, '[[regtime_]]', NULL),
('Z-s8KCn&', 'jK¾Ku,4%', 'ZMp?X}', 'Standard Shopseiten-Layout mit Kontaktformular', NULL, '[[regtime_]]', NULL),
('Z-s8KCn&', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with contact form', NULL, '[[regtime_]]', NULL),
('ZKr(_g', 'jK¾Ku,4%', 'ZMp?X}', 'Standard Shopseiten-Layout mit Newsletterformular', NULL, '[[regtime_]]', NULL),
('ZKr(_g', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with newsletter form', NULL, '[[regtime_]]', NULL),
('ZrŎ	@M!', 'jK¾Ku,4%', 'ZMp?X}', 'Versand und Zahlung', NULL, '[[regtime_]]', NULL),
('ZrŎ	@M!', 'jK¾Ku,4%', '/_MpXT|', 'Payment / Shipping', NULL, '[[regtime_]]', NULL),
('Zr-hn', 'jK¾Ku,4%', 'ZMp?X}', 'AGB', NULL, '[[regtime_]]', NULL),
('Zr-hn', 'jK¾Ku,4%', '/_MpXT|', 'Terms of service', NULL, '[[regtime_]]', NULL),
('ZpߟڼC/', 'jK¾Ku,4%', 'ZMp?X}', 'Widerrufsbelehrungen', NULL, '[[regtime_]]', NULL),
('ZpߟڼC/', 'jK¾Ku,4%', '/_MpXT|', 'Right of rescission', NULL, '[[regtime_]]', NULL),
('Zpڋ:7^', 'jK¾Ku,4%', 'ZMp?X}', 'Datenschutz', NULL, '[[regtime_]]', NULL),
('Zpڋ:7^', 'jK¾Ku,4%', '/_MpXT|', 'Privacy', NULL, '[[regtime_]]', NULL),
('Zypd)7[', 'jK¾Ku,4%', 'ZMp?X}', 'Impressum', NULL, '[[regtime_]]', NULL),
('Zypd)7[', 'jK¾Ku,4%', '/_MpXT|', 'Imprint', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'ZMp?X}', 'Standard Produktseite-Layout', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', '/_MpXT|', 'Default product page Layout', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_section`
--

CREATE TABLE `cms_section` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `sizing_mode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'boxed',
  `mobile_behavior` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'wrap',
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_section.background_media_id` (`background_media_id`),
  KEY `fk.cms_section.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_section`
--

INSERT INTO `cms_section` VALUES
('ZssRA.(J', 'jK¾Ku,4%', 'Z`pPkI5', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZvpO`g\Z', 'jK¾Ku,4%', 'Zv	sɓ4N', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZvpO`', 'jK¾Ku,4%', 'Zv	sɓ4N', 'jK¾Ku,4%', 1, 'sidebar', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z;qh,_', 'jK¾Ku,4%', 'Z-s8KCn&', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZUs̿k', 'jK¾Ku,4%', 'ZKr(_g', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZrŎ	@|', 'jK¾Ku,4%', 'ZrŎ	@M!', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zr-hm2', 'jK¾Ku,4%', 'Zr-hn', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zpߟڼ', 'jK¾Ku,4%', 'ZpߟڼC/', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zpڋ:BE', 'jK¾Ku,4%', 'Zpڋ:7^', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Zypd)9p', 'jK¾Ku,4%', 'Zypd)7[', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Z#p&!', 'jK¾Ku,4%', 'zm%:g @7oB', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot`
--

CREATE TABLE `cms_slot` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `cms_block_id` binary(16) NOT NULL,
  `cms_block_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slot` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_slot.cms_block_id` (`cms_block_id`,`cms_block_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot`
--

INSERT INTO `cms_slot` VALUES
('Z`pe]\0', 'jK¾Ku,4%', 'Z`s©1Yk', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('Z`pe]Tf', 'jK¾Ku,4%', 'Z`s©1Y', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('Z`pe]gO', 'jK¾Ku,4%', 'Z`s©1Y', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('Zv\0s!+)s#?', 'jK¾Ku,4%', 'Zur)/', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('Zv2s- E', 'jK¾Ku,4%', 'Zvp"A$~', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('Zv2s- E4x', 'jK¾Ku,4%', 'Zvp"A$~', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('Zv2s- ES', 'jK¾Ku,4%', 'Zvp"AfH', 'jK¾Ku,4%', 'category-navigation', 'content', 1, '[[regtime_]]', NULL),
('Zv2s- F~R', 'jK¾Ku,4%', 'Zvp"AS:', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('Zv2s- G2¯', 'jK¾Ku,4%', 'Zvp"AS:', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('Zv2s- Gy', 'jK¾Ku,4%', 'Zvp"B*', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('ZAs<ޮ\Z', 'jK¾Ku,4%', 'Z=q%a', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('Z]q=K	\rT', 'jK¾Ku,4%', 'ZXr*>\\"', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('ZrŎ	At~', 'jK¾Ku,4%', 'ZrŎ	A F', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Zr-hG', 'jK¾Ku,4%', 'Zr-hۥ', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Zpߟڼh', 'jK¾Ku,4%', 'Zpߟڼ߈', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Zpڋ:i', 'jK¾Ku,4%', 'Zpڋ:', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Zypd*c', 'jK¾Ku,4%', 'Zypd*2σ', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('Z;rK=', 'jK¾Ku,4%', 'Z&rI^\0En', 'jK¾Ku,4%', 'product-name', 'left', 1, '[[regtime_]]', NULL),
('Z;r; ', 'jK¾Ku,4%', 'Z&rI^\0En', 'jK¾Ku,4%', 'manufacturer-logo', 'right', 1, '[[regtime_]]', NULL),
('Z;r', 'jK¾Ku,4%', 'Z&rI^1+', 'jK¾Ku,4%', 'image-gallery', 'left', 1, '[[regtime_]]', NULL),
('Z;r"}', 'jK¾Ku,4%', 'Z&rI^1+', 'jK¾Ku,4%', 'buy-box', 'right', 1, '[[regtime_]]', NULL),
('Z;r2ZD', 'jK¾Ku,4%', 'Z&rI_8', 'jK¾Ku,4%', 'product-description-reviews', 'content', 1, '[[regtime_]]', NULL),
('Z;r]\\', 'jK¾Ku,4%', 'Z&rI_', 'jK¾Ku,4%', 'cross-selling', 'content', 1, '[[regtime_]]', NULL),
('[s3[O', 'jK¾Ku,4%', '[r֣ckg4', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL),
('[rJ \n', 'jK¾Ku,4%', '[p߹ЈśA', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot_translation`
--

CREATE TABLE `cms_slot_translation` (
  `cms_slot_id` binary(16) NOT NULL,
  `cms_slot_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_slot_id`,`cms_slot_version_id`,`language_id`),
  KEY `fk.cms_slot_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot_translation`
--

INSERT INTO `cms_slot_translation` VALUES
('Z`pe]\0', 'jK¾Ku,4%', 'ZMp?X}', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z`pe]\0', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z`pe]Tf', 'jK¾Ku,4%', 'ZMp?X}', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z`pe]Tf', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z`pe]gO', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('Z`pe]gO', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('Zv\0s!+)s#?', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('Zv2s- E', 'jK¾Ku,4%', 'ZMp?X}', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zv2s- E', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zv2s- E4x', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('Zv2s- E4x', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('Zv2s- ES', 'jK¾Ku,4%', 'ZMp?X}', NULL, NULL, '[[regtime_]]', NULL),
('Zv2s- ES', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('Zv2s- F~R', 'jK¾Ku,4%', 'ZMp?X}', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zv2s- F~R', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('ZAs<ޮ\Z', 'jK¾Ku,4%', 'ZMp?X}', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('ZAs<ޮ\Z', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z]q=K	\rT', 'jK¾Ku,4%', 'ZMp?X}', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z]q=K	\rT', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('ZrŎ	At~', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "<h2>Versand und Zahlung</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('ZrŎ	At~', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Payment / Shipping</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zr-hG', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "<h2>AGB</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zr-hG', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Terms of service</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zpߟڼh', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "<h2>Widerrufsbelehrungen</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zpߟڼh', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Right of rescission</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zpڋ:i', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "<h2>Datenschutz</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zpڋ:i', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Privacy</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zypd*c', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "<h2>Impressum</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Zypd*c', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Imprint</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;rK=', 'jK¾Ku,4%', 'ZMp?X}', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;rK=', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r; ', 'jK¾Ku,4%', 'ZMp?X}', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r; ', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r', 'jK¾Ku,4%', 'ZMp?X}', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r', 'jK¾Ku,4%', '/_MpXT|', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r"}', 'jK¾Ku,4%', 'ZMp?X}', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r"}', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r2ZD', 'jK¾Ku,4%', 'ZMp?X}', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r2ZD', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r]\\', 'jK¾Ku,4%', 'ZMp?X}', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Z;r]\\', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('[s3[O', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('[rJ \n', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` binary(16) NOT NULL,
  `iso` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `iso3` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `force_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `check_vat_id_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `vat_id_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_id_required` tinyint(1) NOT NULL DEFAULT '0',
  `customer_tax` json DEFAULT NULL,
  `company_tax` json DEFAULT NULL,
  `advanced_postal_code_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_advanced_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `check_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `default_postal_code_pattern` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code_required` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `shipping_available` tinyint(1) NOT NULL DEFAULT '1',
  `is_eu` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
('ZNqn/c', 'DE', 1, 1, 'DEU', 0, 0, 0, 'DE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('ZOrj7', 'GR', 10, 1, 'GRC', 0, 0, 0, '(EL|GR)\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('ZPr(.L3', 'GB', 5, 1, 'GBR', 0, 0, 0, '(GB)?([0-9]{9}([0-9]{3})?|[A-Z]{2}[0-9]{3})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^GIR ?0AA$|^(?:(?:AB|AL|B|BA|BB|BD|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(?:\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}))$|^BFPO ?\\d{1,4}$', 1, '[[regtime_]]', NULL, 1, 0),
('ZWr5w\Z', 'IE', 10, 1, 'IRL', 0, 0, 0, 'IE(\\d{7}[A-Z]{1,2}|(\\d{1}[A-Z]{1}\\d{5}[A-Z]{1}))', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[\\dA-Z]{3}( ?[\\dA-Z]{4})?', 1, '[[regtime_]]', NULL, 1, 1),
('ZWqM<', 'IS', 10, 1, 'ISL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ZWrH~k', 'IT', 10, 1, 'ITA', 0, 0, 0, 'IT\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('ZWrFơ', 'JP', 10, 1, 'JPN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}-?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZWraoD', 'CA', 10, 1, 'CAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[ABCEGHJKLMNPRSTVXY]\\d[ABCEGHJ-NPRSTV-Z] ?\\d[ABCEGHJ-NPRSTV-Z]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('ZWq	G''様', 'LU', 10, 1, 'LUX', 0, 0, 0, 'LU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('ZWrI3h', 'NA', 10, 1, 'NAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZWpcPQ', 'NL', 10, 1, 'NLD', 0, 0, 0, 'NL\\d{9}B\\d{2}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]{1}\\d{3}([ ]?[A-Z]{2})', 1, '[[regtime_]]', NULL, 1, 1),
('ZWsu@ܽ', 'NO', 10, 1, 'NOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZWp JBZRz', 'AT', 10, 1, 'AUT', 0, 0, 0, 'ATU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('ZWs''Xg', 'PT', 10, 1, 'PRT', 0, 0, 0, 'PT\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('ZWq֦@2', 'SE', 10, 1, 'SWE', 0, 0, 0, 'SE\\d{12}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('ZX	rM\ZCUo', 'CH', 10, 1, 'CHE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 1, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ZXmsxOٻ', 'ES', 10, 1, 'ESP', 0, 0, 0, 'ES[A-Z]\\d{7}[A-Z]$|^ES[A-Z][0-9]{7}[0-9A-Z]$|^ES[0-9]{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^([0-4]\\d{4}|5[0-2]\\d{3})$', 1, '[[regtime_]]', NULL, 1, 1),
('ZXqn(8X', 'US', 10, 1, 'USA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(\\d{5})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('ZZq顭|d', 'LI', 10, 1, 'LIE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '948[5-9]|949[0-7]', 1, '[[regtime_]]', NULL, 1, 0),
('ZZp?#U\r', 'AE', 10, 1, 'ARE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZZpMM+y', 'PL', 10, 1, 'POL', 0, 0, 0, 'PL\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('ZZr~8vlJ', 'HU', 10, 1, 'HUN', 0, 0, 0, 'HU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('ZZsfU', 'TR', 10, 1, 'TUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZZqrYp', 'CZ', 10, 1, 'CZE', 0, 0, 0, 'CZ\\d{8,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('Z[\0r$\0$', 'SK', 10, 1, 'SVK', 0, 0, 0, 'SK\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('Z[	sU\n|\0', 'RO', 10, 1, 'ROU', 0, 0, 0, 'RO(?!0)\\d{1,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 1),
('Z[s.R2', 'BR', 10, 1, 'BRA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Z[pA1ͻf\Z', 'IL', 10, 1, 'ISR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('Z[''p]m	X{', 'AU', 10, 1, 'AUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z[0q\r/T', 'BE', 10, 1, 'BEL', 0, 0, 0, 'BE\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('Z[:qPmI$', 'DK', 10, 1, 'DNK', 0, 0, 0, 'DK\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('Z[Cs`=', 'FI', 10, 1, 'FIN', 0, 0, 0, 'FI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('Z[Lq<>y', 'FR', 10, 1, 'FRA', 0, 0, 0, 'FR[A-HJ-NP-Z0-9]{2}\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{1}(?:A|B|\\d{1}) ?\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('ZrG}:]a', 'BG', 10, 1, 'BGR', 0, 0, 0, 'BG\\d{9,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('Zst@', 'EE', 10, 1, 'EST', 0, 0, 0, 'EE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('ZpUP{', 'HR', 10, 1, 'HRV', 0, 0, 0, 'HR\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('Zr5*Nn', 'LV', 10, 1, 'LVA', 0, 0, 0, 'LV\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LV-)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('ZsO', 'LT', 10, 1, 'LTU', 0, 0, 0, 'LT(\\d{12}|\\d{9})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LT-)?\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('Zr屣!+W7', 'MT', 10, 1, 'MLT', 0, 0, 0, 'MT\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{3} ?\\d{2,4}', 1, '[[regtime_]]', NULL, 1, 1),
('Zp9', 'SI', 10, 1, 'SVN', 0, 0, 0, 'SI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('Zs', 'CY', 10, 1, 'CYP', 0, 0, 0, 'CY\\d{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('Zp$F', 'AF', 10, 1, 'AFG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZqDN+,', 'AX', 10, 1, 'ALA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '22\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ZrAGى&', 'AL', 10, 1, 'ALB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq;WTW', 'DZ', 10, 1, 'DZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr6', 'AS', 10, 1, 'ASM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(96799)(?  :[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Zr50\\0', 'AD', 10, 1, 'AND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'AD[1-7]0\\d', 1, '[[regtime_]]', NULL, 1, 0),
('Zq;', 'AO', 10, 1, 'AGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZpQ', 'AI', 10, 1, 'AIA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:AI-)?2640', 1, '[[regtime_]]', NULL, 1, 0),
('Z!s5֮*', 'AQ', 10, 1, 'ATA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z,sMY;z', 'AG', 10, 1, 'ATG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z9r`tchj', 'AR', 10, 1, 'ARG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '((?:[A-HJ-NP-Z])?\\d{4})([A-Z]{3})?', 1, '[[regtime_]]', NULL, 1, 0),
('ZBsvXv', 'AM', 10, 1, 'ARM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:37)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZKsb[LY', 'AW', 10, 1, 'ABW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZTs)x*s\0', 'AZ', 10, 1, 'AZE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z^sMr', 'BS', 10, 1, 'BHS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zgr}-0w', 'BH', 10, 1, 'BHR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d|1[0-2])\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zpp!>', 'BD', 10, 1, 'BGD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zyr9[T3', 'BB', 10, 1, 'BRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'BB\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZpZ~?tt', 'BY', 10, 1, 'BLR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr\\v6', 'BZ', 10, 1, 'BLZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zqv+Ex', 'BJ', 10, 1, 'BEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZrAa<', 'BM', 10, 1, 'BMU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?[A-Z0-9]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr5P~ö', 'BT', 10, 1, 'BTN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zpw', 'BO', 10, 1, 'BOL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZrAKL', 'BQ', 10, 1, 'BES', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zq:zKhoӮ', 'BA', 10, 1, 'BIH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr9ϲ7', 'BW', 10, 1, 'BWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zp#N\\f', 'BV', 10, 1, 'BVT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zr,J5I', 'IO', 10, 1, 'IOT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Bb]{2}[Nn][Dd]\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr''Phx#', 'UM', 10, 1, 'UMI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '96898', 1, '[[regtime_]]', NULL, 1, 0),
('Zs\r7*', 'VG', 10, 1, 'VGB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VG\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsW,P', 'VI', 10, 1, 'VIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(008(?:(?:[0-4]\\d)|(?:5[01])))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Zp5Й.z''', 'BN', 10, 1, 'BRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr8ʰ|', 'BF', 10, 1, 'BFA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z&r.3?', 'BI', 10, 1, 'BDI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z0r"sA''', 'KH', 10, 1, 'KHM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Z:rs)', 'CM', 10, 1, 'CMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZDr&o*n', 'CV', 10, 1, 'CPV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZNpՁcgj\n{\Z[', 'KY', 10, 1, 'CYM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'KY\\d-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZXrG6', 'CF', 10, 1, 'CAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zer JRJ=', 'TD', 10, 1, 'TCD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zpr_:g', 'CL', 10, 1, 'CHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{7}', 1, '[[regtime_]]', NULL, 1, 0),
('ZzpQB(P', 'CN', 10, 1, 'CHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsGbHcn#', 'CX', 10, 1, 'CXR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6798', 1, '[[regtime_]]', NULL, 1, 0),
('ZsHAה', 'CC', 10, 1, 'CCK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6799', 1, '[[regtime_]]', NULL, 1, 0),
('ZrJ*G', 'CO', 10, 1, 'COL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zpјg', 'KM', 10, 1, 'COM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zs,m', 'CG', 10, 1, 'COG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zs,k', 'CD', 10, 1, 'COD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Cc][Dd]', 1, '[[regtime_]]', NULL, 1, 0),
('Z/qG"vuf', 'CK', 10, 1, 'COK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZCpOq:Z', 'CR', 10, 1, 'CRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}|\\d{3}-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z[r7i', 'CU', 10, 1, 'CUB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zmp;\ni7', 'CW', 10, 1, 'CUW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zwsnq>:|	', 'DJ', 10, 1, 'DJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZpV\\h', 'DM', 10, 1, 'DMA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zsj+', 'DO', 10, 1, 'DOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq:HV?Q', 'EC', 10, 1, 'ECU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp	k~w', 'EG', 10, 1, 'EGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp+<89', 'SV', 10, 1, 'SLV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'CP [1-3][1-7][0-2]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('Zr!>b', 'GQ', 10, 1, 'GNQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zrm:_Wv', 'ER', 10, 1, 'ERI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zpf<H', 'ET', 10, 1, 'ETH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZrbN>\ZX', 'FK', 10, 1, 'FLK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ff][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zsk98*j', 'FO', 10, 1, 'FRO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr`[4} \r', 'FJ', 10, 1, 'FJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZpT̠PX|', 'GF', 10, 1, 'GUF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]3\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zsk~Z*', 'PF', 10, 1, 'PYF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '987\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp` e5', 'TF', 10, 1, 'ATF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zpc', 'GA', 10, 1, 'GAB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}\\s[a-zA-Z-_ ]\\s\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZpL^JY', 'GM', 10, 1, 'GMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z+s5`H', 'GE', 10, 1, 'GEO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z4sx8Jt', 'GH', 10, 1, 'GHA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z=qNh1f', 'GI', 10, 1, 'GIB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Gg][Xx][1]{2}\\s{0,1}[1][Aa]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZGs9A', 'GL', 10, 1, 'GRL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '39\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZPs?qT.', 'GD', 10, 1, 'GRD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z]qHɘN\Z', 'GP', 10, 1, 'GLP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZfqՎcj8', 'GU', 10, 1, 'GUM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:[12]\\d|3[12]))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Zps7', 'GT', 10, 1, 'GTM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zzqqф1', 'GG', 10, 1, 'GGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'GY\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsLճ', 'GN', 10, 1, 'GIN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsM+YgI', 'GW', 10, 1, 'GNB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zru*e', 'GY', 10, 1, 'GUY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zq$m_', 'HT', 10, 1, 'HTI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs9b=', 'HM', 10, 1, 'HMD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs217I	.q', 'VA', 10, 1, 'VAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '00120', 1, '[[regtime_]]', NULL, 1, 0),
('ZpyCł', 'HN', 10, 1, 'HND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZpUP2', 'HK', 10, 1, 'HKG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999077', 1, '[[regtime_]]', NULL, 1, 0),
('Zr{g', 'IN', 10, 1, 'IND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs\0', 'ID', 10, 1, 'IDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq*/܁C6', 'CI', 10, 1, 'CIV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zr٣aq*', 'IR', 10, 1, 'IRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zqtc7xf', 'IQ', 10, 1, 'IRQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp$I', 'IM', 10, 1, 'IMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'IM\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Z\ZsFr)z', 'JM', 10, 1, 'JAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[a-zA-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Z&r9Sk#', 'JE', 10, 1, 'JEY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'JE\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Z0rekJcA', 'JO', 10, 1, 'JOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Z9r<IR', 'KZ', 10, 1, 'KAZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('ZCp+Sн', 'KE', 10, 1, 'KEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZKq#-Al', 'KI', 10, 1, 'KIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZUp,j	de', 'KW', 10, 1, 'KWT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Z^q<,rI&|', 'KG', 10, 1, 'KGZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('ZhpZS*S', 'LA', 10, 1, 'LAO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZqrدEzé', 'LB', 10, 1, 'LBN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d{4})(?: ?(?:\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Z{r_ؙ', 'LS', 10, 1, 'LSO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs\n_9#Z', 'LR', 10, 1, 'LBR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr8V\n', 'LY', 10, 1, 'LBY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq:W\\$', 'MO', 10, 1, 'MAC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999078', 1, '[[regtime_]]', NULL, 1, 0),
('Zph)tY', 'MK', 10, 1, 'MKD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq7n\Z?', 'MG', 10, 1, 'MDG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq/,0', 'MW', 10, 1, 'MWI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZqÞs%9', 'MY', 10, 1, 'MYS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp\Z', 'MV', 10, 1, 'MDV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr	t5O', 'ML', 10, 1, 'MLI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zp(\ZVA', 'MH', 10, 1, 'MHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969[67]\\d)(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Zq9M+', 'MQ', 10, 1, 'MTQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]2\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs''SAd', 'MR', 10, 1, 'MRT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z\0sE&0\\y', 'MU', 10, 1, 'MUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|[A-Z]{2}\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('Z	ră6\0ZX', 'YT', 10, 1, 'MYT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '976\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsJ-G"', 'MX', 10, 1, 'MEX', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zre*p', 'FM', 10, 1, 'FSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9694[1-4])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Z&q~ӟ8', 'MD', 10, 1, 'MDA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z3pl', 'MC', 10, 1, 'MCO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '980\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Z<qV?', 'MN', 10, 1, 'MNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZEqت~\Z', 'ME', 10, 1, 'MNE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '8\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZPqޔ4tp', 'MS', 10, 1, 'MSR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Mm][Ss][Rr]\\s{0,1}\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZYquFgU', 'MA', 10, 1, 'MAR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zgs{/Y', 'MZ', 10, 1, 'MOZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z~r|\n', 'MM', 10, 1, 'MMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zst1b-o', 'NR', 10, 1, 'NRU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);
INSERT INTO `country` VALUES
('Zsòq/', 'NP', 10, 1, 'NPL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs׀ҏ', 'NC', 10, 1, 'NCL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '988\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs`">xk\Z', 'NZ', 10, 1, 'NZL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq]K@z', 'NI', 10, 1, 'NIC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZraV\Zw7', 'NE', 10, 1, 'NER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z"sh/C-', 'NG', 10, 1, 'NGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Z7q hۡg', 'NU', 10, 1, 'NIU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZArw5oF6', 'NF', 10, 1, 'NFK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '2899', 1, '[[regtime_]]', NULL, 1, 0),
('ZJq\n:,l', 'KP', 10, 1, 'PRK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZSqCto$', 'MP', 10, 1, 'MNP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9695[012])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('Z\\pgam\0;', 'OM', 10, 1, 'OMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:PC )?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ZepMF=+O', 'PK', 10, 1, 'PAK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Znr<e%H', 'PW', 10, 1, 'PLW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:39|40))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('ZwpפAk>', 'PS', 10, 1, 'PSE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zsś%e', 'PA', 10, 1, 'PAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZqÅ@Tβ', 'PG', 10, 1, 'PNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Zsk:', 'PY', 10, 1, 'PRY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZrDvy', 'PE', 10, 1, 'PER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:LIMA \\d{1,2}|CALLAO 0?\\d)|[0-2]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZqU{}', 'PH', 10, 1, 'PHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zsؤ8ܓ', 'PN', 10, 1, 'PCN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'PCRN 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('ZqW]F!', 'PR', 10, 1, 'PRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(00[679]\\d{2})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('ZrA ', 'QA', 10, 1, 'QAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zr|=[l', 'XK', 10, 1, 'KOS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-7]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs=Y[MOVn', 'RE', 10, 1, 'REU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]4\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZrS\r	M', 'RU', 10, 1, 'RUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq#-Uʈ9', 'RW', 10, 1, 'RWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zqz͍\\', 'BL', 10, 1, 'BLM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsDIJ[', 'SH', 10, 1, 'SHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:ASCN|STHL) 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('ZpɣXdl', 'KN', 10, 1, 'KNA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZrrOn.', 'LC', 10, 1, 'LCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zs\Z', 'MF', 10, 1, 'MAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Z$s={Zuo', 'PM', 10, 1, 'SPM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]5\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Z,rFI@Y7', 'VC', 10, 1, 'VCT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VC\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Z6r)sSiY)', 'WS', 10, 1, 'WSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z?pk^Y', 'SM', 10, 1, 'SMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '4789\\d', 1, '[[regtime_]]', NULL, 1, 0),
('ZJqּcb!!', 'ST', 10, 1, 'STP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZTq٪4q\\f', 'SA', 10, 1, 'SAU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Z]s\ZBh', 'SN', 10, 1, 'SEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zfp(>2_', 'RS', 10, 1, 'SRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5,6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zppböz', 'SC', 10, 1, 'SYC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZysI+L', 'SL', 10, 1, 'SLE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zq3Xp*o', 'SG', 10, 1, 'SGP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('ZpUK	', 'SX', 10, 1, 'SXM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZrbY', 'SB', 10, 1, 'SLB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zp=z;Yl', 'SO', 10, 1, 'SOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs)e9', 'ZA', 10, 1, 'ZAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ZpMUN', 'GS', 10, 1, 'SGS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ss][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zqඌ', 'KR', 10, 1, 'KOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|-\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('ZrH8h', 'SS', 10, 1, 'SSD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zs35\0', 'LK', 10, 1, 'LKA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zr*녡', 'SD', 10, 1, 'SDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZsÊJa', 'SR', 10, 1, 'SUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZsʏC', 'SJ', 10, 1, 'SJM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs=ݏ', 'SZ', 10, 1, 'SWZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[HLMS]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp֐y3K', 'SY', 10, 1, 'SYR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Z p+MR', 'TW', 10, 1, 'TWN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('Z*rό', 'TJ', 10, 1, 'TJK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Z4p4@]dP', 'TZ', 10, 1, 'TZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}', 1, '[[regtime_]]', NULL, 1, 0),
('Z>pɛr+', 'TH', 10, 1, 'THA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ZGsއ`', 'TL', 10, 1, 'TLS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZOsXm~~Cc', 'TG', 10, 1, 'TGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZZp/YFt', 'TK', 10, 1, 'TKL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZcrmZz0', 'TO', 10, 1, 'TON', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zos?h$', 'TT', 10, 1, 'TTO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Z{pI', 'TN', 10, 1, 'TUN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp ,0', 'TM', 10, 1, 'TKM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp_h;', 'TC', 10, 1, 'TCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'TKCA 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('Zsh==', 'TV', 10, 1, 'TUV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZsZ.', 'UG', 10, 1, 'UGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZsoeT²', 'UA', 10, 1, 'UKR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zsy-', 'UY', 10, 1, 'URY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zpm`;', 'UZ', 10, 1, 'UZB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('ZrkIC', 'VU', 10, 1, 'VUT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ZpoTT', 'VE', 10, 1, 'VEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Zsj\n66', 'VN', 10, 1, 'VNM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('Zqӳ@zNn', 'WF', 10, 1, 'WLF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '986\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Zq\rS', 'EH', 10, 1, 'ESH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zp\\Sta', 'YE', 10, 1, 'YEM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zrck"/', 'ZM', 10, 1, 'ZMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Zs''P', 'ZW', 10, 1, 'ZWE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `country_state`
--

CREATE TABLE `country_state` (
  `id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `short_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.country_state.country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state`
--

INSERT INTO `country_state` VALUES
('ZNqF$ \nV{', 'ZNqn/c', 'DE-BW', 1, 1, '[[regtime_]]', NULL),
('ZNrc5lGj', 'ZNqn/c', 'DE-BY', 1, 1, '[[regtime_]]', NULL),
('ZNqe', 'ZNqn/c', 'DE-BE', 1, 1, '[[regtime_]]', NULL),
('ZNrB''C|', 'ZNqn/c', 'DE-BB', 1, 1, '[[regtime_]]', NULL),
('ZNp*4', 'ZNqn/c', 'DE-HB', 1, 1, '[[regtime_]]', NULL),
('ZNrur{', 'ZNqn/c', 'DE-HH', 1, 1, '[[regtime_]]', NULL),
('ZNs\ng7', 'ZNqn/c', 'DE-HE', 1, 1, '[[regtime_]]', NULL),
('ZNrۢ''\\U', 'ZNqn/c', 'DE-NI', 1, 1, '[[regtime_]]', NULL),
('ZNrL5ba', 'ZNqn/c', 'DE-MV', 1, 1, '[[regtime_]]', NULL),
('ZOpKs,k', 'ZNqn/c', 'DE-NW', 1, 1, '[[regtime_]]', NULL),
('ZOrVl=$>2', 'ZNqn/c', 'DE-RP', 1, 1, '[[regtime_]]', NULL),
('ZOs9TT', 'ZNqn/c', 'DE-SL', 1, 1, '[[regtime_]]', NULL),
('ZOsYK8aS', 'ZNqn/c', 'DE-SN', 1, 1, '[[regtime_]]', NULL),
('ZO(qT', 'ZNqn/c', 'DE-ST', 1, 1, '[[regtime_]]', NULL),
('ZO1q\Zm-Gq\\', 'ZNqn/c', 'DE-SH', 1, 1, '[[regtime_]]', NULL),
('ZO;s&', 'ZNqn/c', 'DE-TH', 1, 1, '[[regtime_]]', NULL),
('ZPpE U', 'ZPr(.L3', 'GB-ENG', 1, 1, '[[regtime_]]', NULL),
('ZPr̍@g/', 'ZPr(.L3', 'GB-NIR', 1, 1, '[[regtime_]]', NULL),
('ZPs̈́S Z^', 'ZPr(.L3', 'GB-SCT', 1, 1, '[[regtime_]]', NULL),
('ZP"q[`8i', 'ZPr(.L3', 'GB-WLS', 1, 1, '[[regtime_]]', NULL),
('ZP(s`M''W', 'ZPr(.L3', 'GB-EAW', 1, 1, '[[regtime_]]', NULL),
('ZP.rށ1', 'ZPr(.L3', 'GB-GBN', 1, 1, '[[regtime_]]', NULL),
('ZP3s"ybe', 'ZPr(.L3', 'GB-UKM', 1, 1, '[[regtime_]]', NULL),
('ZP9q.[\r', 'ZPr(.L3', 'GB-BKM', 1, 1, '[[regtime_]]', NULL),
('ZP@p׸', 'ZPr(.L3', 'GB-CAM', 1, 1, '[[regtime_]]', NULL),
('ZPFr)ͳS:', 'ZPr(.L3', 'GB-CMA', 1, 1, '[[regtime_]]', NULL),
('ZPLrڷW0|g', 'ZPr(.L3', 'GB-DBY', 1, 1, '[[regtime_]]', NULL),
('ZPQp&WԒ', 'ZPr(.L3', 'GB-DEV', 1, 1, '[[regtime_]]', NULL),
('ZPWql^t', 'ZPr(.L3', 'GB-DOR', 1, 1, '[[regtime_]]', NULL),
('ZP`sLB^', 'ZPr(.L3', 'GB-ESX', 1, 1, '[[regtime_]]', NULL),
('ZPgr9n', 'ZPr(.L3', 'GB-ESS', 1, 1, '[[regtime_]]', NULL),
('ZPmp0ސ', 'ZPr(.L3', 'GB-GLS', 1, 1, '[[regtime_]]', NULL),
('ZPsrn1^(', 'ZPr(.L3', 'GB-HAM', 1, 1, '[[regtime_]]', NULL),
('ZPyp	CH$4', 'ZPr(.L3', 'GB-HRT', 1, 1, '[[regtime_]]', NULL),
('ZPrɐR', 'ZPr(.L3', 'GB-KEN', 1, 1, '[[regtime_]]', NULL),
('ZPr0\rp', 'ZPr(.L3', 'GB-LAN', 1, 1, '[[regtime_]]', NULL),
('ZPr/>\n', 'ZPr(.L3', 'GB-LEC', 1, 1, '[[regtime_]]', NULL),
('ZPr$ߥ%:1', 'ZPr(.L3', 'GB-LIN', 1, 1, '[[regtime_]]', NULL),
('ZPrPt', 'ZPr(.L3', 'GB-NFK', 1, 1, '[[regtime_]]', NULL),
('ZPr Gr', 'ZPr(.L3', 'GB-NYK', 1, 1, '[[regtime_]]', NULL),
('ZPqhaeh', 'ZPr(.L3', 'GB-NTH', 1, 1, '[[regtime_]]', NULL),
('ZPq*', 'ZPr(.L3', 'GB-NTT', 1, 1, '[[regtime_]]', NULL),
('ZPrē~', 'ZPr(.L3', 'GB-OXF', 1, 1, '[[regtime_]]', NULL),
('ZPru=YTE', 'ZPr(.L3', 'GB-SOM', 1, 1, '[[regtime_]]', NULL),
('ZPsXɈ', 'ZPr(.L3', 'GB-STS', 1, 1, '[[regtime_]]', NULL),
('ZPs', 'ZPr(.L3', 'GB-SFK', 1, 1, '[[regtime_]]', NULL),
('ZPr{PA', 'ZPr(.L3', 'GB-SRY', 1, 1, '[[regtime_]]', NULL),
('ZPsa', 'ZPr(.L3', 'GB-WAR', 1, 1, '[[regtime_]]', NULL),
('ZPru4ϗG0', 'ZPr(.L3', 'GB-WSX', 1, 1, '[[regtime_]]', NULL),
('ZPpx*ˌ', 'ZPr(.L3', 'GB-WOR', 1, 1, '[[regtime_]]', NULL),
('ZPqȃ4p""', 'ZPr(.L3', 'GB-LND', 1, 1, '[[regtime_]]', NULL),
('ZPr̶;жݚ', 'ZPr(.L3', 'GB-BDG', 1, 1, '[[regtime_]]', NULL),
('ZPs6m', 'ZPr(.L3', 'GB-BNE', 1, 1, '[[regtime_]]', NULL),
('ZPpUˀ', 'ZPr(.L3', 'GB-BEX', 1, 1, '[[regtime_]]', NULL),
('ZPsӅ~3v', 'ZPr(.L3', 'GB-BEN', 1, 1, '[[regtime_]]', NULL),
('ZQr.Dr`', 'ZPr(.L3', 'GB-BRY', 1, 1, '[[regtime_]]', NULL),
('ZQ	spWV2^', 'ZPr(.L3', 'GB-CMD', 1, 1, '[[regtime_]]', NULL),
('ZQp׀=엒ns', 'ZPr(.L3', 'GB-CRY', 1, 1, '[[regtime_]]', NULL),
('ZQp4(', 'ZPr(.L3', 'GB-EAL', 1, 1, '[[regtime_]]', NULL),
('ZQqJ', 'ZPr(.L3', 'GB-ENF', 1, 1, '[[regtime_]]', NULL),
('ZQ"rӠ-1t', 'ZPr(.L3', 'GB-GRE', 1, 1, '[[regtime_]]', NULL),
('ZQiq#r', 'ZPr(.L3', 'GB-HCK', 1, 1, '[[regtime_]]', NULL),
('ZQsL3p7', 'ZPr(.L3', 'GB-HMF', 1, 1, '[[regtime_]]', NULL),
('ZQp>', 'ZPr(.L3', 'GB-HRY', 1, 1, '[[regtime_]]', NULL),
('ZQr_9M', 'ZPr(.L3', 'GB-HRW', 1, 1, '[[regtime_]]', NULL),
('ZQqhp', 'ZPr(.L3', 'GB-HAV', 1, 1, '[[regtime_]]', NULL),
('ZQqݭ	(TW', 'ZPr(.L3', 'GB-HIL', 1, 1, '[[regtime_]]', NULL),
('ZQsِn*Ő', 'ZPr(.L3', 'GB-HNS', 1, 1, '[[regtime_]]', NULL),
('ZQr''>d8', 'ZPr(.L3', 'GB-ISL', 1, 1, '[[regtime_]]', NULL),
('ZQsF[f', 'ZPr(.L3', 'GB-KEC', 1, 1, '[[regtime_]]', NULL),
('ZQp2UHD~8', 'ZPr(.L3', 'GB-KTT', 1, 1, '[[regtime_]]', NULL),
('ZQpR/Y', 'ZPr(.L3', 'GB-LBH', 1, 1, '[[regtime_]]', NULL),
('ZQr-p', 'ZPr(.L3', 'GB-LEW', 1, 1, '[[regtime_]]', NULL),
('ZRs?In', 'ZPr(.L3', 'GB-MRT', 1, 1, '[[regtime_]]', NULL),
('ZR\npAqՇ', 'ZPr(.L3', 'GB-NWM', 1, 1, '[[regtime_]]', NULL),
('ZRp5\Zƒ', 'ZPr(.L3', 'GB-RDB', 1, 1, '[[regtime_]]', NULL),
('ZRs+U', 'ZPr(.L3', 'GB-RIC', 1, 1, '[[regtime_]]', NULL),
('ZRr''$', 'ZPr(.L3', 'GB-SWK', 1, 1, '[[regtime_]]', NULL),
('ZR"q;:', 'ZPr(.L3', 'GB-STN', 1, 1, '[[regtime_]]', NULL),
('ZR+pIp', 'ZPr(.L3', 'GB-TWH', 1, 1, '[[regtime_]]', NULL),
('ZR1qφg', 'ZPr(.L3', 'GB-WFT', 1, 1, '[[regtime_]]', NULL),
('ZR7r\n|1', 'ZPr(.L3', 'GB-WND', 1, 1, '[[regtime_]]', NULL),
('ZR=r͎|Ƕ#', 'ZPr(.L3', 'GB-WSM', 1, 1, '[[regtime_]]', NULL),
('ZRBq{7{', 'ZPr(.L3', 'GB-BNS', 1, 1, '[[regtime_]]', NULL),
('ZRHpwYZp', 'ZPr(.L3', 'GB-BIR', 1, 1, '[[regtime_]]', NULL),
('ZROq"5ER9', 'ZPr(.L3', 'GB-BOL', 1, 1, '[[regtime_]]', NULL),
('ZRUqo[UFNi', 'ZPr(.L3', 'GB-BRD', 1, 1, '[[regtime_]]', NULL),
('ZR[rA'':', 'ZPr(.L3', 'GB-BUR', 1, 1, '[[regtime_]]', NULL),
('ZRar3', 'ZPr(.L3', 'GB-CLD', 1, 1, '[[regtime_]]', NULL),
('ZRfpK*@', 'ZPr(.L3', 'GB-COV', 1, 1, '[[regtime_]]', NULL),
('ZRmsg/', 'ZPr(.L3', 'GB-DNC', 1, 1, '[[regtime_]]', NULL),
('ZRtp+''_', 'ZPr(.L3', 'GB-DUD', 1, 1, '[[regtime_]]', NULL),
('ZRzqF^9', 'ZPr(.L3', 'GB-GAT', 1, 1, '[[regtime_]]', NULL),
('ZRpU54', 'ZPr(.L3', 'GB-KIR', 1, 1, '[[regtime_]]', NULL),
('ZRrz	68e', 'ZPr(.L3', 'GB-KWL', 1, 1, '[[regtime_]]', NULL),
('ZRr؁d$HW(|', 'ZPr(.L3', 'GB-LDS', 1, 1, '[[regtime_]]', NULL),
('ZRsW', 'ZPr(.L3', 'GB-LIV', 1, 1, '[[regtime_]]', NULL),
('ZRp;5n', 'ZPr(.L3', 'GB-MAN', 1, 1, '[[regtime_]]', NULL),
('ZRqDhCf)-U', 'ZPr(.L3', 'GB-NET', 1, 1, '[[regtime_]]', NULL),
('ZRrѠӽB]', 'ZPr(.L3', 'GB-NTY', 1, 1, '[[regtime_]]', NULL),
('ZRr\Z', 'ZPr(.L3', 'GB-OLD', 1, 1, '[[regtime_]]', NULL),
('ZRpݣ2` ]', 'ZPr(.L3', 'GB-RCH', 1, 1, '[[regtime_]]', NULL),
('ZRpǇ`]', 'ZPr(.L3', 'GB-ROT', 1, 1, '[[regtime_]]', NULL),
('ZRq/[l', 'ZPr(.L3', 'GB-SHN', 1, 1, '[[regtime_]]', NULL),
('ZRreѼ', 'ZPr(.L3', 'GB-SLF', 1, 1, '[[regtime_]]', NULL),
('ZRr¼''N', 'ZPr(.L3', 'GB-SAW', 1, 1, '[[regtime_]]', NULL),
('ZRq}鱕u', 'ZPr(.L3', 'GB-SFT', 1, 1, '[[regtime_]]', NULL),
('ZRq1Z/J"', 'ZPr(.L3', 'GB-SHF', 1, 1, '[[regtime_]]', NULL),
('ZRqH0Z', 'ZPr(.L3', 'GB-SOL', 1, 1, '[[regtime_]]', NULL),
('ZRq<1>X', 'ZPr(.L3', 'GB-STY', 1, 1, '[[regtime_]]', NULL),
('ZRsv', 'ZPr(.L3', 'GB-SKP', 1, 1, '[[regtime_]]', NULL),
('ZRqVon', 'ZPr(.L3', 'GB-SND', 1, 1, '[[regtime_]]', NULL),
('ZRr3e}', 'ZPr(.L3', 'GB-TAM', 1, 1, '[[regtime_]]', NULL),
('ZSph!k', 'ZPr(.L3', 'GB-TRF', 1, 1, '[[regtime_]]', NULL),
('ZS\nqn', 'ZPr(.L3', 'GB-WKF', 1, 1, '[[regtime_]]', NULL),
('ZSq쇸g;%z', 'ZPr(.L3', 'GB-WLL', 1, 1, '[[regtime_]]', NULL),
('ZSpMHO.(r', 'ZPr(.L3', 'GB-WGN', 1, 1, '[[regtime_]]', NULL),
('ZSp''$', 'ZPr(.L3', 'GB-WRL', 1, 1, '[[regtime_]]', NULL),
('ZS$rvb)', 'ZPr(.L3', 'GB-WLV', 1, 1, '[[regtime_]]', NULL),
('ZS*pS\r$%', 'ZPr(.L3', 'GB-BAS', 1, 1, '[[regtime_]]', NULL),
('ZS0q@NM^', 'ZPr(.L3', 'GB-BDF', 1, 1, '[[regtime_]]', NULL),
('ZS6qz\\', 'ZPr(.L3', 'GB-BBD', 1, 1, '[[regtime_]]', NULL),
('ZS=p', 'ZPr(.L3', 'GB-BPL', 1, 1, '[[regtime_]]', NULL),
('ZSCr#׊d_1', 'ZPr(.L3', 'GB-BMH', 1, 1, '[[regtime_]]', NULL),
('ZSIsu䣮', 'ZPr(.L3', 'GB-BRC', 1, 1, '[[regtime_]]', NULL),
('ZSNrߧCeux\n!', 'ZPr(.L3', 'GB-BNH', 1, 1, '[[regtime_]]', NULL),
('ZSUsP01+}', 'ZPr(.L3', 'GB-BST', 1, 1, '[[regtime_]]', NULL),
('ZS[pMDUn', 'ZPr(.L3', 'GB-CBF', 1, 1, '[[regtime_]]', NULL),
('ZSarK\nO"', 'ZPr(.L3', 'GB-CHE', 1, 1, '[[regtime_]]', NULL),
('ZSgsu9', 'ZPr(.L3', 'GB-CHW', 1, 1, '[[regtime_]]', NULL),
('ZSlrzZ"0', 'ZPr(.L3', 'GB-CON', 1, 1, '[[regtime_]]', NULL),
('ZSssd ;', 'ZPr(.L3', 'GB-DAL', 1, 1, '[[regtime_]]', NULL),
('ZSyqo>.', 'ZPr(.L3', 'GB-DER', 1, 1, '[[regtime_]]', NULL),
('ZSp}W/1R', 'ZPr(.L3', 'GB-DUR', 1, 1, '[[regtime_]]', NULL),
('ZSqydij', 'ZPr(.L3', 'GB-ERY', 1, 1, '[[regtime_]]', NULL),
('ZSsm', 'ZPr(.L3', 'GB-HAL', 1, 1, '[[regtime_]]', NULL),
('ZSrw$&	y', 'ZPr(.L3', 'GB-HPL', 1, 1, '[[regtime_]]', NULL),
('ZT/r,d', 'ZPr(.L3', 'GB-HEF', 1, 1, '[[regtime_]]', NULL),
('ZT_q6n毯HQ', 'ZPr(.L3', 'GB-IOW', 1, 1, '[[regtime_]]', NULL),
('ZTruiQ׆', 'ZPr(.L3', 'GB-IOS', 1, 1, '[[regtime_]]', NULL),
('ZTqӮI٪', 'ZPr(.L3', 'GB-KHL', 1, 1, '[[regtime_]]', NULL),
('ZTs', 'ZPr(.L3', 'GB-LCE', 1, 1, '[[regtime_]]', NULL),
('ZTqߋ', 'ZPr(.L3', 'GB-LUT', 1, 1, '[[regtime_]]', NULL),
('ZTpsV3x', 'ZPr(.L3', 'GB-MDW', 1, 1, '[[regtime_]]', NULL),
('ZTsrժ\\', 'ZPr(.L3', 'GB-MDB', 1, 1, '[[regtime_]]', NULL),
('ZTrL7й:', 'ZPr(.L3', 'GB-MIK', 1, 1, '[[regtime_]]', NULL),
('ZTsBV\npl', 'ZPr(.L3', 'GB-NEL', 1, 1, '[[regtime_]]', NULL),
('ZTrPihN', 'ZPr(.L3', 'GB-NLN', 1, 1, '[[regtime_]]', NULL),
('ZTsl{jb', 'ZPr(.L3', 'GB-NSM', 1, 1, '[[regtime_]]', NULL),
('ZTr$Uz	', 'ZPr(.L3', 'GB-NBL', 1, 1, '[[regtime_]]', NULL),
('ZUsEZڴ\0', 'ZPr(.L3', 'GB-NGM', 1, 1, '[[regtime_]]', NULL),
('ZU\npb[1', 'ZPr(.L3', 'GB-PTE', 1, 1, '[[regtime_]]', NULL),
('ZUrNJW', 'ZPr(.L3', 'GB-PLY', 1, 1, '[[regtime_]]', NULL),
('ZUr濗3)Y', 'ZPr(.L3', 'GB-POL', 1, 1, '[[regtime_]]', NULL),
('ZU%q/g', 'ZPr(.L3', 'GB-POR', 1, 1, '[[regtime_]]', NULL),
('ZU,pĺѺ+', 'ZPr(.L3', 'GB-RDG', 1, 1, '[[regtime_]]', NULL),
('ZU3qn+mT2vK', 'ZPr(.L3', 'GB-RCC', 1, 1, '[[regtime_]]', NULL),
('ZU9pW~', 'ZPr(.L3', 'GB-RUT', 1, 1, '[[regtime_]]', NULL),
('ZU?rb', 'ZPr(.L3', 'GB-SHR', 1, 1, '[[regtime_]]', NULL),
('ZUErw@', 'ZPr(.L3', 'GB-SLG', 1, 1, '[[regtime_]]', NULL),
('ZULq->eR', 'ZPr(.L3', 'GB-SGC', 1, 1, '[[regtime_]]', NULL),
('ZURr⯊\Z^\r', 'ZPr(.L3', 'GB-STH', 1, 1, '[[regtime_]]', NULL),
('ZUXqߐ\\W', 'ZPr(.L3', 'GB-SOS', 1, 1, '[[regtime_]]', NULL),
('ZU^r:×', 'ZPr(.L3', 'GB-STT', 1, 1, '[[regtime_]]', NULL),
('ZUdq8{XY', 'ZPr(.L3', 'GB-STE', 1, 1, '[[regtime_]]', NULL),
('ZUjqд\\^', 'ZPr(.L3', 'GB-SWD', 1, 1, '[[regtime_]]', NULL),
('ZUpq)uD', 'ZPr(.L3', 'GB-TFW', 1, 1, '[[regtime_]]', NULL),
('ZUxq]wrɟ', 'ZPr(.L3', 'GB-THR', 1, 1, '[[regtime_]]', NULL),
('ZUpcf', 'ZPr(.L3', 'GB-TOB', 1, 1, '[[regtime_]]', NULL),
('ZUpU:', 'ZPr(.L3', 'GB-WRT', 1, 1, '[[regtime_]]', NULL),
('ZUpVS"\\', 'ZPr(.L3', 'GB-WBK', 1, 1, '[[regtime_]]', NULL),
('ZUsm0', 'ZPr(.L3', 'GB-WIL', 1, 1, '[[regtime_]]', NULL),
('ZUs`=HS+', 'ZPr(.L3', 'GB-WNM', 1, 1, '[[regtime_]]', NULL),
('ZUsI3x4]', 'ZPr(.L3', 'GB-WOK', 1, 1, '[[regtime_]]', NULL),
('ZUqFQZ', 'ZPr(.L3', 'GB-YOR', 1, 1, '[[regtime_]]', NULL),
('ZUr\rBdU', 'ZPr(.L3', 'GB-ANN', 1, 1, '[[regtime_]]', NULL),
('ZUr%|a1֏ʑ', 'ZPr(.L3', 'GB-AND', 1, 1, '[[regtime_]]', NULL),
('ZUp9#`bRSJ', 'ZPr(.L3', 'GB-ABC', 1, 1, '[[regtime_]]', NULL),
('ZUrUhU', 'ZPr(.L3', 'GB-BFS', 1, 1, '[[regtime_]]', NULL),
('ZUpYT0L', 'ZPr(.L3', 'GB-CCG', 1, 1, '[[regtime_]]', NULL),
('ZUrD9fE', 'ZPr(.L3', 'GB-DRS', 1, 1, '[[regtime_]]', NULL),
('ZVqWd~Ow', 'ZPr(.L3', 'GB-FMO', 1, 1, '[[regtime_]]', NULL),
('ZVpжN}P3', 'ZPr(.L3', 'GB-LBC', 1, 1, '[[regtime_]]', NULL),
('ZVpL;I', 'ZPr(.L3', 'GB-MEA', 1, 1, '[[regtime_]]', NULL),
('ZVq,{\rnء', 'ZPr(.L3', 'GB-MUL', 1, 1, '[[regtime_]]', NULL),
('ZVp왈[K', 'ZPr(.L3', 'GB-NMD', 1, 1, '[[regtime_]]', NULL),
('ZVs<+c;	', 'ZPr(.L3', 'GB-ABE', 1, 1, '[[regtime_]]', NULL),
('ZV%q╤)ulB', 'ZPr(.L3', 'GB-ABD', 1, 1, '[[regtime_]]', NULL),
('ZV,sܙ\ZV\Z*', 'ZPr(.L3', 'GB-ANS', 1, 1, '[[regtime_]]', NULL),
('ZV3p\nG', 'ZPr(.L3', 'GB-AGB', 1, 1, '[[regtime_]]', NULL),
('ZV9s_%', 'ZPr(.L3', 'GB-CLK', 1, 1, '[[regtime_]]', NULL),
('ZV?qZK', 'ZPr(.L3', 'GB-DGY', 1, 1, '[[regtime_]]', NULL),
('ZVEr׈7', 'ZPr(.L3', 'GB-DND', 1, 1, '[[regtime_]]', NULL),
('ZVLqYr,\n1', 'ZPr(.L3', 'GB-EAY', 1, 1, '[[regtime_]]', NULL),
('ZVTrpNN', 'ZPr(.L3', 'GB-EDU', 1, 1, '[[regtime_]]', NULL),
('ZVZp3i0', 'ZPr(.L3', 'GB-ELN', 1, 1, '[[regtime_]]', NULL),
('ZV_pqtzT&', 'ZPr(.L3', 'GB-ERW', 1, 1, '[[regtime_]]', NULL),
('ZVfrBK΍', 'ZPr(.L3', 'GB-EDH', 1, 1, '[[regtime_]]', NULL),
('ZVrsԶVP $', 'ZPr(.L3', 'GB-ELS', 1, 1, '[[regtime_]]', NULL),
('ZVxqv[2>', 'ZPr(.L3', 'GB-FAL', 1, 1, '[[regtime_]]', NULL),
('ZV~rĴ6?', 'ZPr(.L3', 'GB-FIF', 1, 1, '[[regtime_]]', NULL),
('ZVqW\Z@Kl', 'ZPr(.L3', 'GB-GLG', 1, 1, '[[regtime_]]', NULL),
('ZVp*Zp', 'ZPr(.L3', 'GB-HLD', 1, 1, '[[regtime_]]', NULL),
('ZVsLH', 'ZPr(.L3', 'GB-IVC', 1, 1, '[[regtime_]]', NULL),
('ZVq<', 'ZPr(.L3', 'GB-MLN', 1, 1, '[[regtime_]]', NULL),
('ZVpϗ''x', 'ZPr(.L3', 'GB-MRY', 1, 1, '[[regtime_]]', NULL),
('ZVrd cB', 'ZPr(.L3', 'GB-NAY', 1, 1, '[[regtime_]]', NULL),
('ZVpՔP*<g', 'ZPr(.L3', 'GB-NLK', 1, 1, '[[regtime_]]', NULL),
('ZVrX(XI', 'ZPr(.L3', 'GB-ORK', 1, 1, '[[regtime_]]', NULL),
('ZVqsx˩%6', 'ZPr(.L3', 'GB-PKN', 1, 1, '[[regtime_]]', NULL),
('ZVq4^~A', 'ZPr(.L3', 'GB-RFW', 1, 1, '[[regtime_]]', NULL),
('ZVq@Ao{', 'ZPr(.L3', 'GB-SCB', 1, 1, '[[regtime_]]', NULL),
('ZVr)9!', 'ZPr(.L3', 'GB-ZET', 1, 1, '[[regtime_]]', NULL),
('ZVrEg', 'ZPr(.L3', 'GB-SAY', 1, 1, '[[regtime_]]', NULL),
('ZVr?Eg(', 'ZPr(.L3', 'GB-SLK', 1, 1, '[[regtime_]]', NULL),
('ZVs՝X(/V', 'ZPr(.L3', 'GB-STG', 1, 1, '[[regtime_]]', NULL),
('ZVs0f7', 'ZPr(.L3', 'GB-WDU', 1, 1, '[[regtime_]]', NULL),
('ZVrNN~hlN', 'ZPr(.L3', 'GB-WLN', 1, 1, '[[regtime_]]', NULL),
('ZVs?oB', 'ZPr(.L3', 'GB-BGW', 1, 1, '[[regtime_]]', NULL),
('ZVpf/Xn', 'ZPr(.L3', 'GB-BGE', 1, 1, '[[regtime_]]', NULL),
('ZWpqrٲ\r', 'ZPr(.L3', 'GB-CAY', 1, 1, '[[regtime_]]', NULL),
('ZWpŌ', 'ZPr(.L3', 'GB-CRF', 1, 1, '[[regtime_]]', NULL),
('ZW\rqģ/ W\0S', 'ZPr(.L3', 'GB-CMN', 1, 1, '[[regtime_]]', NULL),
('ZWs^>-<', 'ZPr(.L3', 'GB-CGN', 1, 1, '[[regtime_]]', NULL),
('ZWpЈ\r-', 'ZPr(.L3', 'GB-CWY', 1, 1, '[[regtime_]]', NULL),
('ZW"qKMw', 'ZPr(.L3', 'GB-DEN', 1, 1, '[[regtime_]]', NULL),
('ZW)s"Ϲ\\', 'ZPr(.L3', 'GB-FLN', 1, 1, '[[regtime_]]', NULL),
('ZW/r^N[=;', 'ZPr(.L3', 'GB-GWN', 1, 1, '[[regtime_]]', NULL),
('ZW5r3T&', 'ZPr(.L3', 'GB-AGY', 1, 1, '[[regtime_]]', NULL),
('ZW<qݰ\\#}', 'ZPr(.L3', 'GB-MTY', 1, 1, '[[regtime_]]', NULL),
('ZWCr0V(u', 'ZPr(.L3', 'GB-MON', 1, 1, '[[regtime_]]', NULL),
('ZWIpݻʐWD>', 'ZPr(.L3', 'GB-NTL', 1, 1, '[[regtime_]]', NULL),
('ZWOpX>8C', 'ZPr(.L3', 'GB-NWP', 1, 1, '[[regtime_]]', NULL),
('ZWUsb(', 'ZPr(.L3', 'GB-PEM', 1, 1, '[[regtime_]]', NULL),
('ZW\\r~v(n', 'ZPr(.L3', 'GB-POW', 1, 1, '[[regtime_]]', NULL),
('ZWbrHQ,x', 'ZPr(.L3', 'GB-RCT', 1, 1, '[[regtime_]]', NULL),
('ZWiqB2', 'ZPr(.L3', 'GB-SWA', 1, 1, '[[regtime_]]', NULL),
('ZWor\ZbM?', 'ZPr(.L3', 'GB-TOF', 1, 1, '[[regtime_]]', NULL),
('ZWvqi^#?', 'ZPr(.L3', 'GB-VGL', 1, 1, '[[regtime_]]', NULL),
('ZW~qEaۯ9', 'ZPr(.L3', 'GB-WRX', 1, 1, '[[regtime_]]', NULL),
('ZY	qh', 'ZXqn(8X', 'US-AL', 1, 1, '[[regtime_]]', NULL),
('ZYPrJs', 'ZXqn(8X', 'US-AK', 1, 1, '[[regtime_]]', NULL),
('ZY^qu'';', 'ZXqn(8X', 'US-AZ', 1, 1, '[[regtime_]]', NULL),
('ZYiq%ou^}', 'ZXqn(8X', 'US-AR', 1, 1, '[[regtime_]]', NULL),
('ZYvs*;WϦ', 'ZXqn(8X', 'US-CA', 1, 1, '[[regtime_]]', NULL),
('ZYqdG>Sez', 'ZXqn(8X', 'US-CO', 1, 1, '[[regtime_]]', NULL),
('ZYs"%d', 'ZXqn(8X', 'US-CT', 1, 1, '[[regtime_]]', NULL),
('ZYq싡I2%B', 'ZXqn(8X', 'US-DE', 1, 1, '[[regtime_]]', NULL),
('ZYr\nW', 'ZXqn(8X', 'US-FL', 1, 1, '[[regtime_]]', NULL),
('ZYrK`rl', 'ZXqn(8X', 'US-GA', 1, 1, '[[regtime_]]', NULL),
('ZYq2', 'ZXqn(8X', 'US-HI', 1, 1, '[[regtime_]]', NULL),
('ZYpXbQ5`', 'ZXqn(8X', 'US-ID', 1, 1, '[[regtime_]]', NULL),
('ZYp/5c', 'ZXqn(8X', 'US-IL', 1, 1, '[[regtime_]]', NULL),
('ZYr0\r;', 'ZXqn(8X', 'US-IN', 1, 1, '[[regtime_]]', NULL),
('ZYs	', 'ZXqn(8X', 'US-IA', 1, 1, '[[regtime_]]', NULL),
('ZYrF`	d', 'ZXqn(8X', 'US-KS', 1, 1, '[[regtime_]]', NULL),
('ZYsBc<', 'ZXqn(8X', 'US-KY', 1, 1, '[[regtime_]]', NULL),
('ZYrثL^', 'ZXqn(8X', 'US-LA', 1, 1, '[[regtime_]]', NULL),
('ZYs㙿=$', 'ZXqn(8X', 'US-ME', 1, 1, '[[regtime_]]', NULL),
('ZYq6n', 'ZXqn(8X', 'US-MD', 1, 1, '[[regtime_]]', NULL),
('ZYqi|u\Z', 'ZXqn(8X', 'US-MA', 1, 1, '[[regtime_]]', NULL),
('ZYqCrQ', 'ZXqn(8X', 'US-MI', 1, 1, '[[regtime_]]', NULL),
('ZYrbr', 'ZXqn(8X', 'US-MN', 1, 1, '[[regtime_]]', NULL),
('ZZr@;', 'ZXqn(8X', 'US-MS', 1, 1, '[[regtime_]]', NULL),
('ZZ\nq{Nlf', 'ZXqn(8X', 'US-MO', 1, 1, '[[regtime_]]', NULL),
('ZZqXrԣ1', 'ZXqn(8X', 'US-MT', 1, 1, '[[regtime_]]', NULL),
('ZZrʋkYG', 'ZXqn(8X', 'US-NE', 1, 1, '[[regtime_]]', NULL),
('ZZ1s̡!3GQ', 'ZXqn(8X', 'US-NV', 1, 1, '[[regtime_]]', NULL),
('ZZ7qq P%', 'ZXqn(8X', 'US-NH', 1, 1, '[[regtime_]]', NULL),
('ZZ=r=', 'ZXqn(8X', 'US-NJ', 1, 1, '[[regtime_]]', NULL),
('ZZDrNN', 'ZXqn(8X', 'US-NM', 1, 1, '[[regtime_]]', NULL),
('ZZMs?DG3', 'ZXqn(8X', 'US-NY', 1, 1, '[[regtime_]]', NULL),
('ZZSqX^%u', 'ZXqn(8X', 'US-NC', 1, 1, '[[regtime_]]', NULL),
('ZZZpO|v', 'ZXqn(8X', 'US-ND', 1, 1, '[[regtime_]]', NULL),
('ZZ_rcPJ', 'ZXqn(8X', 'US-OH', 1, 1, '[[regtime_]]', NULL),
('ZZfq6\\/V', 'ZXqn(8X', 'US-OK', 1, 1, '[[regtime_]]', NULL),
('ZZlr!nl', 'ZXqn(8X', 'US-OR', 1, 1, '[[regtime_]]', NULL),
('ZZrp!`', 'ZXqn(8X', 'US-PA', 1, 1, '[[regtime_]]', NULL),
('ZZxs~', 'ZXqn(8X', 'US-RI', 1, 1, '[[regtime_]]', NULL),
('ZZ}q1', 'ZXqn(8X', 'US-SC', 1, 1, '[[regtime_]]', NULL),
('ZZsᴹuV', 'ZXqn(8X', 'US-SD', 1, 1, '[[regtime_]]', NULL),
('ZZs׉0TIW', 'ZXqn(8X', 'US-TN', 1, 1, '[[regtime_]]', NULL),
('ZZr/~', 'ZXqn(8X', 'US-TX', 1, 1, '[[regtime_]]', NULL),
('ZZreeb4', 'ZXqn(8X', 'US-UT', 1, 1, '[[regtime_]]', NULL),
('ZZsѨ&-', 'ZXqn(8X', 'US-VT', 1, 1, '[[regtime_]]', NULL),
('ZZqG77', 'ZXqn(8X', 'US-VA', 1, 1, '[[regtime_]]', NULL),
('ZZs2v\r;"', 'ZXqn(8X', 'US-WA', 1, 1, '[[regtime_]]', NULL),
('ZZpta%h', 'ZXqn(8X', 'US-WV', 1, 1, '[[regtime_]]', NULL),
('ZZr6#=', 'ZXqn(8X', 'US-WI', 1, 1, '[[regtime_]]', NULL),
('ZZr}D/M', 'ZXqn(8X', 'US-WY', 1, 1, '[[regtime_]]', NULL),
('ZZp<,@	', 'ZXqn(8X', 'US-DC', 1, 1, '[[regtime_]]', NULL),
('[rֆ^Կ''v', 'ZWraoD', 'CA-ON', 1, 1, '[[regtime_]]', NULL),
('[rֆ^Կλ', 'ZWraoD', 'CA-QC', 1, 1, '[[regtime_]]', NULL),
('[rWjo', 'ZWraoD', 'CA-NS', 1, 1, '[[regtime_]]', NULL),
('[rWjX', 'ZWraoD', 'CA-NB', 1, 1, '[[regtime_]]', NULL),
('[rWkd', 'ZWraoD', 'CA-MB', 1, 1, '[[regtime_]]', NULL),
('[rWl6*', 'ZWraoD', 'CA-BC', 1, 1, '[[regtime_]]', NULL),
('[rWl2', 'ZWraoD', 'CA-PE', 1, 1, '[[regtime_]]', NULL),
('[rWmg', 'ZWraoD', 'CA-SK', 1, 1, '[[regtime_]]', NULL),
('[rWn'';', 'ZWraoD', 'CA-AB', 1, 1, '[[regtime_]]', NULL),
('[rWnS', 'ZWraoD', 'CA-NL', 1, 1, '[[regtime_]]', NULL),
('[rWnn', 'ZWraoD', 'CA-NT', 1, 1, '[[regtime_]]', NULL),
('[rWnz\n', 'ZWraoD', 'CA-YT', 1, 1, '[[regtime_]]', NULL),
('[rWnW', 'ZWraoD', 'CA-NU', 1, 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_state_translation`
--

CREATE TABLE `country_state_translation` (
  `country_state_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_state_id`,`language_id`),
  KEY `fk.country_state_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state_translation`
--

INSERT INTO `country_state_translation` VALUES
('ZNqF$ \nV{', 'ZMp?X}', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('ZNqF$ \nV{', '/_MpXT|', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('ZNrc5lGj', 'ZMp?X}', 'Bayern', NULL, '[[regtime_]]', NULL),
('ZNrc5lGj', '/_MpXT|', 'Bavaria', NULL, '[[regtime_]]', NULL),
('ZNqe', 'ZMp?X}', 'Berlin', NULL, '[[regtime_]]', NULL),
('ZNqe', '/_MpXT|', 'Berlin', NULL, '[[regtime_]]', NULL),
('ZNrB''C|', 'ZMp?X}', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('ZNrB''C|', '/_MpXT|', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('ZNp*4', 'ZMp?X}', 'Bremen', NULL, '[[regtime_]]', NULL),
('ZNp*4', '/_MpXT|', 'Bremen', NULL, '[[regtime_]]', NULL),
('ZNrur{', 'ZMp?X}', 'Hamburg', NULL, '[[regtime_]]', NULL),
('ZNrur{', '/_MpXT|', 'Hamburg', NULL, '[[regtime_]]', NULL),
('ZNs\ng7', 'ZMp?X}', 'Hessen', NULL, '[[regtime_]]', NULL),
('ZNs\ng7', '/_MpXT|', 'Hesse', NULL, '[[regtime_]]', NULL),
('ZNrۢ''\\U', 'ZMp?X}', 'Niedersachsen', NULL, '[[regtime_]]', NULL),
('ZNrۢ''\\U', '/_MpXT|', 'Lower Saxony', NULL, '[[regtime_]]', NULL),
('ZNrL5ba', 'ZMp?X}', 'Mecklenburg-Vorpommern', NULL, '[[regtime_]]', NULL),
('ZNrL5ba', '/_MpXT|', 'Mecklenburg-Western Pomerania', NULL, '[[regtime_]]', NULL),
('ZOpKs,k', 'ZMp?X}', 'Nordrhein-Westfalen', NULL, '[[regtime_]]', NULL),
('ZOpKs,k', '/_MpXT|', 'North Rhine-Westphalia', NULL, '[[regtime_]]', NULL),
('ZOrVl=$>2', 'ZMp?X}', 'Rheinland-Pfalz', NULL, '[[regtime_]]', NULL),
('ZOrVl=$>2', '/_MpXT|', 'Rhineland-Palatinate', NULL, '[[regtime_]]', NULL),
('ZOs9TT', 'ZMp?X}', 'Saarland', NULL, '[[regtime_]]', NULL),
('ZOs9TT', '/_MpXT|', 'Saarland', NULL, '[[regtime_]]', NULL),
('ZOsYK8aS', 'ZMp?X}', 'Sachsen', NULL, '[[regtime_]]', NULL),
('ZOsYK8aS', '/_MpXT|', 'Saxony', NULL, '[[regtime_]]', NULL),
('ZO(qT', 'ZMp?X}', 'Sachsen-Anhalt', NULL, '[[regtime_]]', NULL),
('ZO(qT', '/_MpXT|', 'Saxony-Anhalt', NULL, '[[regtime_]]', NULL),
('ZO1q\Zm-Gq\\', 'ZMp?X}', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('ZO1q\Zm-Gq\\', '/_MpXT|', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('ZO;s&', 'ZMp?X}', 'Thüringen', NULL, '[[regtime_]]', NULL),
('ZO;s&', '/_MpXT|', 'Thuringia', NULL, '[[regtime_]]', NULL),
('ZPpE U', '/_MpXT|', 'England', NULL, '[[regtime_]]', NULL),
('ZPr̍@g/', '/_MpXT|', 'Northern Ireland', NULL, '[[regtime_]]', NULL),
('ZPs̈́S Z^', '/_MpXT|', 'Scotland', NULL, '[[regtime_]]', NULL),
('ZP"q[`8i', '/_MpXT|', 'Wales', NULL, '[[regtime_]]', NULL),
('ZP(s`M''W', '/_MpXT|', 'England and Wales', NULL, '[[regtime_]]', NULL),
('ZP.rށ1', '/_MpXT|', 'Great Britain', NULL, '[[regtime_]]', NULL),
('ZP3s"ybe', '/_MpXT|', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('ZP9q.[\r', '/_MpXT|', 'Buckinghamshire', NULL, '[[regtime_]]', NULL),
('ZP@p׸', '/_MpXT|', 'Cambridgeshire', NULL, '[[regtime_]]', NULL),
('ZPFr)ͳS:', '/_MpXT|', 'Cumbria', NULL, '[[regtime_]]', NULL),
('ZPLrڷW0|g', '/_MpXT|', 'Derbyshire', NULL, '[[regtime_]]', NULL),
('ZPQp&WԒ', '/_MpXT|', 'Devon', NULL, '[[regtime_]]', NULL),
('ZPWql^t', '/_MpXT|', 'Dorset', NULL, '[[regtime_]]', NULL),
('ZP`sLB^', '/_MpXT|', 'East Sussex', NULL, '[[regtime_]]', NULL),
('ZPgr9n', '/_MpXT|', 'Essex', NULL, '[[regtime_]]', NULL),
('ZPmp0ސ', '/_MpXT|', 'Gloucestershire', NULL, '[[regtime_]]', NULL),
('ZPsrn1^(', '/_MpXT|', 'Hampshire', NULL, '[[regtime_]]', NULL),
('ZPyp	CH$4', '/_MpXT|', 'Hertfordshire', NULL, '[[regtime_]]', NULL),
('ZPrɐR', '/_MpXT|', 'Kent', NULL, '[[regtime_]]', NULL),
('ZPr0\rp', '/_MpXT|', 'Lancashire', NULL, '[[regtime_]]', NULL),
('ZPr/>\n', '/_MpXT|', 'Leicestershire', NULL, '[[regtime_]]', NULL),
('ZPr$ߥ%:1', '/_MpXT|', 'Lincolnshire', NULL, '[[regtime_]]', NULL),
('ZPrPt', '/_MpXT|', 'Norfolk', NULL, '[[regtime_]]', NULL),
('ZPr Gr', '/_MpXT|', 'North Yorkshire', NULL, '[[regtime_]]', NULL),
('ZPqhaeh', '/_MpXT|', 'Northamptonshire', NULL, '[[regtime_]]', NULL),
('ZPq*', '/_MpXT|', 'Nottinghamshire', NULL, '[[regtime_]]', NULL),
('ZPrē~', '/_MpXT|', 'Oxfordshire', NULL, '[[regtime_]]', NULL),
('ZPru=YTE', '/_MpXT|', 'Somerset', NULL, '[[regtime_]]', NULL),
('ZPsXɈ', '/_MpXT|', 'Staffordshire', NULL, '[[regtime_]]', NULL),
('ZPs', '/_MpXT|', 'Suffolk', NULL, '[[regtime_]]', NULL),
('ZPr{PA', '/_MpXT|', 'Surrey', NULL, '[[regtime_]]', NULL),
('ZPsa', '/_MpXT|', 'Warwickshire', NULL, '[[regtime_]]', NULL),
('ZPru4ϗG0', '/_MpXT|', 'West Sussex', NULL, '[[regtime_]]', NULL),
('ZPpx*ˌ', '/_MpXT|', 'Worcestershire', NULL, '[[regtime_]]', NULL),
('ZPqȃ4p""', '/_MpXT|', 'London, City of', NULL, '[[regtime_]]', NULL),
('ZPr̶;жݚ', '/_MpXT|', 'Barking and Dagenham', NULL, '[[regtime_]]', NULL),
('ZPs6m', '/_MpXT|', 'Barnet', NULL, '[[regtime_]]', NULL),
('ZPpUˀ', '/_MpXT|', 'Bexley', NULL, '[[regtime_]]', NULL),
('ZPsӅ~3v', '/_MpXT|', 'Brent', NULL, '[[regtime_]]', NULL),
('ZQr.Dr`', '/_MpXT|', 'Bromley', NULL, '[[regtime_]]', NULL),
('ZQ	spWV2^', '/_MpXT|', 'Camden', NULL, '[[regtime_]]', NULL),
('ZQp׀=엒ns', '/_MpXT|', 'Croydon', NULL, '[[regtime_]]', NULL),
('ZQp4(', '/_MpXT|', 'Ealing', NULL, '[[regtime_]]', NULL),
('ZQqJ', '/_MpXT|', 'Enfield', NULL, '[[regtime_]]', NULL),
('ZQ"rӠ-1t', '/_MpXT|', 'Greenwich', NULL, '[[regtime_]]', NULL),
('ZQiq#r', '/_MpXT|', 'Hackney', NULL, '[[regtime_]]', NULL),
('ZQsL3p7', '/_MpXT|', 'Hammersmith and Fulham', NULL, '[[regtime_]]', NULL),
('ZQp>', '/_MpXT|', 'Haringey', NULL, '[[regtime_]]', NULL),
('ZQr_9M', '/_MpXT|', 'Harrow', NULL, '[[regtime_]]', NULL),
('ZQqhp', '/_MpXT|', 'Havering', NULL, '[[regtime_]]', NULL),
('ZQqݭ	(TW', '/_MpXT|', 'Hillingdon', NULL, '[[regtime_]]', NULL),
('ZQsِn*Ő', '/_MpXT|', 'Hounslow', NULL, '[[regtime_]]', NULL),
('ZQr''>d8', '/_MpXT|', 'Islington', NULL, '[[regtime_]]', NULL),
('ZQsF[f', '/_MpXT|', 'Kensington and Chelsea', NULL, '[[regtime_]]', NULL),
('ZQp2UHD~8', '/_MpXT|', 'Kingston upon Thames', NULL, '[[regtime_]]', NULL),
('ZQpR/Y', '/_MpXT|', 'Lambeth', NULL, '[[regtime_]]', NULL),
('ZQr-p', '/_MpXT|', 'Lewisham', NULL, '[[regtime_]]', NULL),
('ZRs?In', '/_MpXT|', 'Merton', NULL, '[[regtime_]]', NULL),
('ZR\npAqՇ', '/_MpXT|', 'Newham', NULL, '[[regtime_]]', NULL),
('ZRp5\Zƒ', '/_MpXT|', 'Redbridge', NULL, '[[regtime_]]', NULL),
('ZRs+U', '/_MpXT|', 'Richmond upon Thames', NULL, '[[regtime_]]', NULL),
('ZRr''$', '/_MpXT|', 'Southwark', NULL, '[[regtime_]]', NULL),
('ZR"q;:', '/_MpXT|', 'Sutton', NULL, '[[regtime_]]', NULL),
('ZR+pIp', '/_MpXT|', 'Tower Hamlets', NULL, '[[regtime_]]', NULL),
('ZR1qφg', '/_MpXT|', 'Waltham Forest', NULL, '[[regtime_]]', NULL),
('ZR7r\n|1', '/_MpXT|', 'Wandsworth', NULL, '[[regtime_]]', NULL),
('ZR=r͎|Ƕ#', '/_MpXT|', 'Westminster', NULL, '[[regtime_]]', NULL),
('ZRBq{7{', '/_MpXT|', 'Barnsley', NULL, '[[regtime_]]', NULL),
('ZRHpwYZp', '/_MpXT|', 'Birmingham', NULL, '[[regtime_]]', NULL),
('ZROq"5ER9', '/_MpXT|', 'Bolton', NULL, '[[regtime_]]', NULL),
('ZRUqo[UFNi', '/_MpXT|', 'Bradford', NULL, '[[regtime_]]', NULL),
('ZR[rA'':', '/_MpXT|', 'Bury', NULL, '[[regtime_]]', NULL),
('ZRar3', '/_MpXT|', 'Calderdale', NULL, '[[regtime_]]', NULL),
('ZRfpK*@', '/_MpXT|', 'Coventry', NULL, '[[regtime_]]', NULL),
('ZRmsg/', '/_MpXT|', 'Doncaster', NULL, '[[regtime_]]', NULL),
('ZRtp+''_', '/_MpXT|', 'Dudley', NULL, '[[regtime_]]', NULL),
('ZRzqF^9', '/_MpXT|', 'Gateshead', NULL, '[[regtime_]]', NULL),
('ZRpU54', '/_MpXT|', 'Kirklees', NULL, '[[regtime_]]', NULL),
('ZRrz	68e', '/_MpXT|', 'Knowsley', NULL, '[[regtime_]]', NULL),
('ZRr؁d$HW(|', '/_MpXT|', 'Leeds', NULL, '[[regtime_]]', NULL),
('ZRsW', '/_MpXT|', 'Liverpool', NULL, '[[regtime_]]', NULL),
('ZRp;5n', '/_MpXT|', 'Manchester', NULL, '[[regtime_]]', NULL),
('ZRqDhCf)-U', '/_MpXT|', 'Newcastle upon Tyne', NULL, '[[regtime_]]', NULL),
('ZRrѠӽB]', '/_MpXT|', 'North Tyneside', NULL, '[[regtime_]]', NULL),
('ZRr\Z', '/_MpXT|', 'Oldham', NULL, '[[regtime_]]', NULL),
('ZRpݣ2` ]', '/_MpXT|', 'Rochdale', NULL, '[[regtime_]]', NULL),
('ZRpǇ`]', '/_MpXT|', 'Rotherham', NULL, '[[regtime_]]', NULL),
('ZRq/[l', '/_MpXT|', 'St. Helens', NULL, '[[regtime_]]', NULL),
('ZRreѼ', '/_MpXT|', 'Salford', NULL, '[[regtime_]]', NULL),
('ZRr¼''N', '/_MpXT|', 'Sandwell', NULL, '[[regtime_]]', NULL),
('ZRq}鱕u', '/_MpXT|', 'Sefton', NULL, '[[regtime_]]', NULL),
('ZRq1Z/J"', '/_MpXT|', 'Sheffield', NULL, '[[regtime_]]', NULL),
('ZRqH0Z', '/_MpXT|', 'Solihull', NULL, '[[regtime_]]', NULL),
('ZRq<1>X', '/_MpXT|', 'South Tyneside', NULL, '[[regtime_]]', NULL),
('ZRsv', '/_MpXT|', 'Stockport', NULL, '[[regtime_]]', NULL),
('ZRqVon', '/_MpXT|', 'Sunderland', NULL, '[[regtime_]]', NULL),
('ZRr3e}', '/_MpXT|', 'Tameside', NULL, '[[regtime_]]', NULL),
('ZSph!k', '/_MpXT|', 'Trafford', NULL, '[[regtime_]]', NULL),
('ZS\nqn', '/_MpXT|', 'Wakefield', NULL, '[[regtime_]]', NULL),
('ZSq쇸g;%z', '/_MpXT|', 'Walsall', NULL, '[[regtime_]]', NULL),
('ZSpMHO.(r', '/_MpXT|', 'Wigan', NULL, '[[regtime_]]', NULL),
('ZSp''$', '/_MpXT|', 'Wirral', NULL, '[[regtime_]]', NULL),
('ZS$rvb)', '/_MpXT|', 'Wolverhampton', NULL, '[[regtime_]]', NULL),
('ZS*pS\r$%', '/_MpXT|', 'Bath and North East Somerset', NULL, '[[regtime_]]', NULL),
('ZS0q@NM^', '/_MpXT|', 'Bedford', NULL, '[[regtime_]]', NULL),
('ZS6qz\\', '/_MpXT|', 'Blackburn with Darwen', NULL, '[[regtime_]]', NULL),
('ZS=p', '/_MpXT|', 'Blackpool', NULL, '[[regtime_]]', NULL),
('ZSCr#׊d_1', '/_MpXT|', 'Bournemouth', NULL, '[[regtime_]]', NULL),
('ZSIsu䣮', '/_MpXT|', 'Bracknell Forest', NULL, '[[regtime_]]', NULL),
('ZSNrߧCeux\n!', '/_MpXT|', 'Brighton and Hove', NULL, '[[regtime_]]', NULL),
('ZSUsP01+}', '/_MpXT|', 'Bristol, City of', NULL, '[[regtime_]]', NULL),
('ZS[pMDUn', '/_MpXT|', 'Central Bedfordshire', NULL, '[[regtime_]]', NULL),
('ZSarK\nO"', '/_MpXT|', 'Cheshire East', NULL, '[[regtime_]]', NULL),
('ZSgsu9', '/_MpXT|', 'Cheshire West and Chester', NULL, '[[regtime_]]', NULL),
('ZSlrzZ"0', '/_MpXT|', 'Cornwall', NULL, '[[regtime_]]', NULL),
('ZSssd ;', '/_MpXT|', 'Darlington', NULL, '[[regtime_]]', NULL),
('ZSyqo>.', '/_MpXT|', 'Derby', NULL, '[[regtime_]]', NULL),
('ZSp}W/1R', '/_MpXT|', 'Durham County', NULL, '[[regtime_]]', NULL),
('ZSqydij', '/_MpXT|', 'East Riding of Yorkshire', NULL, '[[regtime_]]', NULL),
('ZSsm', '/_MpXT|', 'Halton', NULL, '[[regtime_]]', NULL),
('ZSrw$&	y', '/_MpXT|', 'Hartlepool', NULL, '[[regtime_]]', NULL),
('ZT/r,d', '/_MpXT|', 'Herefordshire', NULL, '[[regtime_]]', NULL),
('ZT_q6n毯HQ', '/_MpXT|', 'Isle of Wight', NULL, '[[regtime_]]', NULL),
('ZTruiQ׆', '/_MpXT|', 'Isles of Scilly', NULL, '[[regtime_]]', NULL),
('ZTqӮI٪', '/_MpXT|', 'Kingston upon Hull', NULL, '[[regtime_]]', NULL),
('ZTs', '/_MpXT|', 'Leicester', NULL, '[[regtime_]]', NULL),
('ZTqߋ', '/_MpXT|', 'Luton', NULL, '[[regtime_]]', NULL),
('ZTpsV3x', '/_MpXT|', 'Medway', NULL, '[[regtime_]]', NULL),
('ZTsrժ\\', '/_MpXT|', 'Middlesbrough', NULL, '[[regtime_]]', NULL),
('ZTrL7й:', '/_MpXT|', 'Milton Keynes', NULL, '[[regtime_]]', NULL),
('ZTsBV\npl', '/_MpXT|', 'North East Lincolnshire', NULL, '[[regtime_]]', NULL),
('ZTrPihN', '/_MpXT|', 'North Lincolnshire', NULL, '[[regtime_]]', NULL),
('ZTsl{jb', '/_MpXT|', 'North Somerset', NULL, '[[regtime_]]', NULL),
('ZTr$Uz	', '/_MpXT|', 'Northumberland', NULL, '[[regtime_]]', NULL),
('ZUsEZڴ\0', '/_MpXT|', 'Nottingham', NULL, '[[regtime_]]', NULL),
('ZU\npb[1', '/_MpXT|', 'Peterborough', NULL, '[[regtime_]]', NULL),
('ZUrNJW', '/_MpXT|', 'Plymouth', NULL, '[[regtime_]]', NULL),
('ZUr濗3)Y', '/_MpXT|', 'Poole', NULL, '[[regtime_]]', NULL),
('ZU%q/g', '/_MpXT|', 'Portsmouth', NULL, '[[regtime_]]', NULL),
('ZU,pĺѺ+', '/_MpXT|', 'Reading', NULL, '[[regtime_]]', NULL),
('ZU3qn+mT2vK', '/_MpXT|', 'Redcar and Cleveland', NULL, '[[regtime_]]', NULL),
('ZU9pW~', '/_MpXT|', 'Rutland', NULL, '[[regtime_]]', NULL),
('ZU?rb', '/_MpXT|', 'Shropshire', NULL, '[[regtime_]]', NULL),
('ZUErw@', '/_MpXT|', 'Slough', NULL, '[[regtime_]]', NULL),
('ZULq->eR', '/_MpXT|', 'South Gloucestershire', NULL, '[[regtime_]]', NULL),
('ZURr⯊\Z^\r', '/_MpXT|', 'Southampton', NULL, '[[regtime_]]', NULL),
('ZUXqߐ\\W', '/_MpXT|', 'Southend-on-Sea', NULL, '[[regtime_]]', NULL),
('ZU^r:×', '/_MpXT|', 'Stockton-on-Tees', NULL, '[[regtime_]]', NULL),
('ZUdq8{XY', '/_MpXT|', 'Stoke-on-Trent', NULL, '[[regtime_]]', NULL),
('ZUjqд\\^', '/_MpXT|', 'Swindon', NULL, '[[regtime_]]', NULL),
('ZUpq)uD', '/_MpXT|', 'Telford and Wrekin', NULL, '[[regtime_]]', NULL),
('ZUxq]wrɟ', '/_MpXT|', 'Thurrock', NULL, '[[regtime_]]', NULL),
('ZUpcf', '/_MpXT|', 'Torbay', NULL, '[[regtime_]]', NULL),
('ZUpU:', '/_MpXT|', 'Warrington', NULL, '[[regtime_]]', NULL),
('ZUpVS"\\', '/_MpXT|', 'West Berkshire', NULL, '[[regtime_]]', NULL),
('ZUsm0', '/_MpXT|', 'Wiltshire', NULL, '[[regtime_]]', NULL),
('ZUs`=HS+', '/_MpXT|', 'Windsor and Maidenhead', NULL, '[[regtime_]]', NULL),
('ZUsI3x4]', '/_MpXT|', 'Wokingham', NULL, '[[regtime_]]', NULL),
('ZUqFQZ', '/_MpXT|', 'York', NULL, '[[regtime_]]', NULL),
('ZUr\rBdU', '/_MpXT|', 'Antrim and Newtownabbey', NULL, '[[regtime_]]', NULL),
('ZUr%|a1֏ʑ', '/_MpXT|', 'Ards and North Down', NULL, '[[regtime_]]', NULL),
('ZUp9#`bRSJ', '/_MpXT|', 'Armagh, Banbridge and Craigavon', NULL, '[[regtime_]]', NULL),
('ZUrUhU', '/_MpXT|', 'Belfast', NULL, '[[regtime_]]', NULL),
('ZUpYT0L', '/_MpXT|', 'Causeway Coast and Glens', NULL, '[[regtime_]]', NULL),
('ZUrD9fE', '/_MpXT|', 'Derry and Strabane', NULL, '[[regtime_]]', NULL),
('ZVqWd~Ow', '/_MpXT|', 'Fermanagh and Omagh', NULL, '[[regtime_]]', NULL),
('ZVpжN}P3', '/_MpXT|', 'Lisburn and Castlereagh', NULL, '[[regtime_]]', NULL),
('ZVpL;I', '/_MpXT|', 'Mid and East Antrim', NULL, '[[regtime_]]', NULL),
('ZVq,{\rnء', '/_MpXT|', 'Mid Ulster', NULL, '[[regtime_]]', NULL),
('ZVp왈[K', '/_MpXT|', 'Newry, Mourne and Down', NULL, '[[regtime_]]', NULL),
('ZVs<+c;	', '/_MpXT|', 'Aberdeen City', NULL, '[[regtime_]]', NULL),
('ZV%q╤)ulB', '/_MpXT|', 'Aberdeenshire', NULL, '[[regtime_]]', NULL),
('ZV,sܙ\ZV\Z*', '/_MpXT|', 'Angus', NULL, '[[regtime_]]', NULL),
('ZV3p\nG', '/_MpXT|', 'Argyll and Bute', NULL, '[[regtime_]]', NULL),
('ZV9s_%', '/_MpXT|', 'Clackmannanshire', NULL, '[[regtime_]]', NULL),
('ZV?qZK', '/_MpXT|', 'Dumfries and Galloway', NULL, '[[regtime_]]', NULL),
('ZVEr׈7', '/_MpXT|', 'Dundee City', NULL, '[[regtime_]]', NULL),
('ZVLqYr,\n1', '/_MpXT|', 'East Ayrshire', NULL, '[[regtime_]]', NULL),
('ZVTrpNN', '/_MpXT|', 'East Dunbartonshire', NULL, '[[regtime_]]', NULL),
('ZVZp3i0', '/_MpXT|', 'East Lothian', NULL, '[[regtime_]]', NULL),
('ZV_pqtzT&', '/_MpXT|', 'East Renfrewshire', NULL, '[[regtime_]]', NULL),
('ZVfrBK΍', '/_MpXT|', 'Edinburgh, City of', NULL, '[[regtime_]]', NULL),
('ZVrsԶVP $', '/_MpXT|', 'Eilean Siar', NULL, '[[regtime_]]', NULL),
('ZVxqv[2>', '/_MpXT|', 'Falkirk', NULL, '[[regtime_]]', NULL),
('ZV~rĴ6?', '/_MpXT|', 'Fife', NULL, '[[regtime_]]', NULL),
('ZVqW\Z@Kl', '/_MpXT|', 'Glasgow City', NULL, '[[regtime_]]', NULL),
('ZVp*Zp', '/_MpXT|', 'Highland', NULL, '[[regtime_]]', NULL),
('ZVsLH', '/_MpXT|', 'Inverclyde', NULL, '[[regtime_]]', NULL),
('ZVq<', '/_MpXT|', 'Midlothian', NULL, '[[regtime_]]', NULL),
('ZVpϗ''x', '/_MpXT|', 'Moray', NULL, '[[regtime_]]', NULL),
('ZVrd cB', '/_MpXT|', 'North Ayrshire', NULL, '[[regtime_]]', NULL),
('ZVpՔP*<g', '/_MpXT|', 'North Lanarkshire', NULL, '[[regtime_]]', NULL),
('ZVrX(XI', '/_MpXT|', 'Orkney Islands', NULL, '[[regtime_]]', NULL),
('ZVqsx˩%6', '/_MpXT|', 'Perth and Kinross', NULL, '[[regtime_]]', NULL),
('ZVq4^~A', '/_MpXT|', 'Renfrewshire', NULL, '[[regtime_]]', NULL),
('ZVq@Ao{', '/_MpXT|', 'Scottish Borders, The', NULL, '[[regtime_]]', NULL),
('ZVr)9!', '/_MpXT|', 'Shetland Islands', NULL, '[[regtime_]]', NULL),
('ZVrEg', '/_MpXT|', 'South Ayrshire', NULL, '[[regtime_]]', NULL),
('ZVr?Eg(', '/_MpXT|', 'South Lanarkshire', NULL, '[[regtime_]]', NULL),
('ZVs՝X(/V', '/_MpXT|', 'Stirling', NULL, '[[regtime_]]', NULL),
('ZVs0f7', '/_MpXT|', 'West Dunbartonshire', NULL, '[[regtime_]]', NULL),
('ZVrNN~hlN', '/_MpXT|', 'West Lothian', NULL, '[[regtime_]]', NULL),
('ZVs?oB', '/_MpXT|', 'Blaenau Gwent', NULL, '[[regtime_]]', NULL),
('ZVpf/Xn', '/_MpXT|', 'Bridgend', NULL, '[[regtime_]]', NULL),
('ZWpqrٲ\r', '/_MpXT|', 'Caerphilly', NULL, '[[regtime_]]', NULL),
('ZWpŌ', '/_MpXT|', 'Cardiff', NULL, '[[regtime_]]', NULL),
('ZW\rqģ/ W\0S', '/_MpXT|', 'Carmarthenshire', NULL, '[[regtime_]]', NULL),
('ZWs^>-<', '/_MpXT|', 'Ceredigion', NULL, '[[regtime_]]', NULL),
('ZWpЈ\r-', '/_MpXT|', 'Conwy', NULL, '[[regtime_]]', NULL),
('ZW"qKMw', '/_MpXT|', 'Denbighshire', NULL, '[[regtime_]]', NULL),
('ZW)s"Ϲ\\', '/_MpXT|', 'Flintshire', NULL, '[[regtime_]]', NULL),
('ZW/r^N[=;', '/_MpXT|', 'Gwynedd', NULL, '[[regtime_]]', NULL),
('ZW5r3T&', '/_MpXT|', 'Isle of Anglesey', NULL, '[[regtime_]]', NULL),
('ZW<qݰ\\#}', '/_MpXT|', 'Merthyr Tydfil', NULL, '[[regtime_]]', NULL),
('ZWCr0V(u', '/_MpXT|', 'Monmouthshire', NULL, '[[regtime_]]', NULL),
('ZWIpݻʐWD>', '/_MpXT|', 'Neath Port Talbot', NULL, '[[regtime_]]', NULL),
('ZWOpX>8C', '/_MpXT|', 'Newport', NULL, '[[regtime_]]', NULL),
('ZWUsb(', '/_MpXT|', 'Pembrokeshire', NULL, '[[regtime_]]', NULL),
('ZW\\r~v(n', '/_MpXT|', 'Powys', NULL, '[[regtime_]]', NULL),
('ZWbrHQ,x', '/_MpXT|', 'Rhondda, Cynon, Taff', NULL, '[[regtime_]]', NULL),
('ZWiqB2', '/_MpXT|', 'Swansea', NULL, '[[regtime_]]', NULL),
('ZWor\ZbM?', '/_MpXT|', 'Torfaen', NULL, '[[regtime_]]', NULL),
('ZWvqi^#?', '/_MpXT|', 'Vale of Glamorgan, The', NULL, '[[regtime_]]', NULL),
('ZW~qEaۯ9', '/_MpXT|', 'Wrexham', NULL, '[[regtime_]]', NULL),
('ZY	qh', '/_MpXT|', 'Alabama', NULL, '[[regtime_]]', NULL),
('ZYPrJs', '/_MpXT|', 'Alaska', NULL, '[[regtime_]]', NULL),
('ZY^qu'';', '/_MpXT|', 'Arizona', NULL, '[[regtime_]]', NULL),
('ZYiq%ou^}', '/_MpXT|', 'Arkansas', NULL, '[[regtime_]]', NULL),
('ZYvs*;WϦ', '/_MpXT|', 'California', NULL, '[[regtime_]]', NULL),
('ZYqdG>Sez', '/_MpXT|', 'Colorado', NULL, '[[regtime_]]', NULL),
('ZYs"%d', '/_MpXT|', 'Connecticut', NULL, '[[regtime_]]', NULL),
('ZYq싡I2%B', '/_MpXT|', 'Delaware', NULL, '[[regtime_]]', NULL),
('ZYr\nW', '/_MpXT|', 'Florida', NULL, '[[regtime_]]', NULL),
('ZYrK`rl', '/_MpXT|', 'Georgia', NULL, '[[regtime_]]', NULL),
('ZYq2', '/_MpXT|', 'Hawaii', NULL, '[[regtime_]]', NULL),
('ZYpXbQ5`', '/_MpXT|', 'Idaho', NULL, '[[regtime_]]', NULL),
('ZYp/5c', '/_MpXT|', 'Illinois', NULL, '[[regtime_]]', NULL),
('ZYr0\r;', '/_MpXT|', 'Indiana', NULL, '[[regtime_]]', NULL),
('ZYs	', '/_MpXT|', 'Iowa', NULL, '[[regtime_]]', NULL),
('ZYrF`	d', '/_MpXT|', 'Kansas', NULL, '[[regtime_]]', NULL),
('ZYsBc<', '/_MpXT|', 'Kentucky', NULL, '[[regtime_]]', NULL),
('ZYrثL^', '/_MpXT|', 'Louisiana', NULL, '[[regtime_]]', NULL),
('ZYs㙿=$', '/_MpXT|', 'Maine', NULL, '[[regtime_]]', NULL),
('ZYq6n', '/_MpXT|', 'Maryland', NULL, '[[regtime_]]', NULL),
('ZYqi|u\Z', '/_MpXT|', 'Massachusetts', NULL, '[[regtime_]]', NULL),
('ZYqCrQ', '/_MpXT|', 'Michigan', NULL, '[[regtime_]]', NULL),
('ZYrbr', '/_MpXT|', 'Minnesota', NULL, '[[regtime_]]', NULL),
('ZZr@;', '/_MpXT|', 'Mississippi', NULL, '[[regtime_]]', NULL),
('ZZ\nq{Nlf', '/_MpXT|', 'Missouri', NULL, '[[regtime_]]', NULL),
('ZZqXrԣ1', '/_MpXT|', 'Montana', NULL, '[[regtime_]]', NULL),
('ZZrʋkYG', '/_MpXT|', 'Nebraska', NULL, '[[regtime_]]', NULL),
('ZZ1s̡!3GQ', '/_MpXT|', 'Nevada', NULL, '[[regtime_]]', NULL),
('ZZ7qq P%', '/_MpXT|', 'New Hampshire', NULL, '[[regtime_]]', NULL),
('ZZ=r=', '/_MpXT|', 'New Jersey', NULL, '[[regtime_]]', NULL),
('ZZDrNN', '/_MpXT|', 'New Mexico', NULL, '[[regtime_]]', NULL),
('ZZMs?DG3', '/_MpXT|', 'New York', NULL, '[[regtime_]]', NULL),
('ZZSqX^%u', '/_MpXT|', 'North Carolina', NULL, '[[regtime_]]', NULL),
('ZZZpO|v', '/_MpXT|', 'North Dakota', NULL, '[[regtime_]]', NULL),
('ZZ_rcPJ', '/_MpXT|', 'Ohio', NULL, '[[regtime_]]', NULL),
('ZZfq6\\/V', '/_MpXT|', 'Oklahoma', NULL, '[[regtime_]]', NULL),
('ZZlr!nl', '/_MpXT|', 'Oregon', NULL, '[[regtime_]]', NULL),
('ZZrp!`', '/_MpXT|', 'Pennsylvania', NULL, '[[regtime_]]', NULL),
('ZZxs~', '/_MpXT|', 'Rhode Island', NULL, '[[regtime_]]', NULL),
('ZZ}q1', '/_MpXT|', 'South Carolina', NULL, '[[regtime_]]', NULL),
('ZZsᴹuV', '/_MpXT|', 'South Dakota', NULL, '[[regtime_]]', NULL),
('ZZs׉0TIW', '/_MpXT|', 'Tennessee', NULL, '[[regtime_]]', NULL),
('ZZr/~', '/_MpXT|', 'Texas', NULL, '[[regtime_]]', NULL),
('ZZreeb4', '/_MpXT|', 'Utah', NULL, '[[regtime_]]', NULL),
('ZZsѨ&-', '/_MpXT|', 'Vermont', NULL, '[[regtime_]]', NULL),
('ZZqG77', '/_MpXT|', 'Virginia', NULL, '[[regtime_]]', NULL),
('ZZs2v\r;"', '/_MpXT|', 'Washington', NULL, '[[regtime_]]', NULL),
('ZZpta%h', '/_MpXT|', 'West Virginia', NULL, '[[regtime_]]', NULL),
('ZZr6#=', '/_MpXT|', 'Wisconsin', NULL, '[[regtime_]]', NULL),
('ZZr}D/M', '/_MpXT|', 'Wyoming', NULL, '[[regtime_]]', NULL),
('ZZp<,@	', '/_MpXT|', 'District of Columbia', NULL, '[[regtime_]]', NULL),
('[rֆ^Կ''v', 'ZMp?X}', 'Ontario', NULL, '[[regtime_]]', NULL),
('[rֆ^Կ''v', '/_MpXT|', 'Ontario', NULL, '[[regtime_]]', NULL),
('[rֆ^Կλ', 'ZMp?X}', 'Québec', NULL, '[[regtime_]]', NULL),
('[rֆ^Կλ', '/_MpXT|', 'Quebec', NULL, '[[regtime_]]', NULL),
('[rWjo', 'ZMp?X}', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('[rWjo', '/_MpXT|', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('[rWjX', 'ZMp?X}', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('[rWjX', '/_MpXT|', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('[rWkd', 'ZMp?X}', 'Manitoba', NULL, '[[regtime_]]', NULL),
('[rWkd', '/_MpXT|', 'Manitoba', NULL, '[[regtime_]]', NULL),
('[rWl6*', 'ZMp?X}', 'British Columbia', NULL, '[[regtime_]]', NULL),
('[rWl6*', '/_MpXT|', 'British Columbia', NULL, '[[regtime_]]', NULL),
('[rWl2', 'ZMp?X}', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('[rWl2', '/_MpXT|', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('[rWmg', 'ZMp?X}', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('[rWmg', '/_MpXT|', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('[rWn'';', 'ZMp?X}', 'Alberta', NULL, '[[regtime_]]', NULL),
('[rWn'';', '/_MpXT|', 'Alberta', NULL, '[[regtime_]]', NULL),
('[rWnS', 'ZMp?X}', 'Neufundland und Labrador', NULL, '[[regtime_]]', NULL),
('[rWnS', '/_MpXT|', 'Newfoundland and Labrador', NULL, '[[regtime_]]', NULL),
('[rWnn', 'ZMp?X}', 'Nordwest-Territorien', NULL, '[[regtime_]]', NULL),
('[rWnn', '/_MpXT|', 'Northwest Territories', NULL, '[[regtime_]]', NULL),
('[rWnz\n', 'ZMp?X}', 'Yukon', NULL, '[[regtime_]]', NULL),
('[rWnz\n', '/_MpXT|', 'Yukon', NULL, '[[regtime_]]', NULL),
('[rWnW', 'ZMp?X}', 'Nunavut', NULL, '[[regtime_]]', NULL),
('[rWnW', '/_MpXT|', 'Nunavut', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_translation`
--

CREATE TABLE `country_translation` (
  `country_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_format` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_id`,`language_id`),
  KEY `fk.country_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_translation`
--

INSERT INTO `country_translation` VALUES
('ZNqn/c', 'ZMp?X}', 'Deutschland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZNqn/c', '/_MpXT|', 'Germany', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZOrj7', 'ZMp?X}', 'Griechenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZOrj7', '/_MpXT|', 'Greece', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZPr(.L3', 'ZMp?X}', 'Vereinigtes Königreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZPr(.L3', '/_MpXT|', 'United Kingdom', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWr5w\Z', 'ZMp?X}', 'Irland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWr5w\Z', '/_MpXT|', 'Ireland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWqM<', 'ZMp?X}', 'Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWqM<', '/_MpXT|', 'Iceland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWrH~k', 'ZMp?X}', 'Italien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWrH~k', '/_MpXT|', 'Italy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWrFơ', 'ZMp?X}', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWrFơ', '/_MpXT|', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWraoD', 'ZMp?X}', 'Kanada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWraoD', '/_MpXT|', 'Canada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWq	G''様', 'ZMp?X}', 'Luxemburg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWq	G''様', '/_MpXT|', 'Luxembourg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWrI3h', 'ZMp?X}', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWrI3h', '/_MpXT|', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWpcPQ', 'ZMp?X}', 'Niederlande', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWpcPQ', '/_MpXT|', 'Netherlands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWsu@ܽ', 'ZMp?X}', 'Norwegen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWsu@ܽ', '/_MpXT|', 'Norway', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWp JBZRz', 'ZMp?X}', 'Österreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWp JBZRz', '/_MpXT|', 'Austria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWs''Xg', 'ZMp?X}', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWs''Xg', '/_MpXT|', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWq֦@2', 'ZMp?X}', 'Schweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZWq֦@2', '/_MpXT|', 'Sweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZX	rM\ZCUo', 'ZMp?X}', 'Schweiz', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZX	rM\ZCUo', '/_MpXT|', 'Switzerland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZXmsxOٻ', 'ZMp?X}', 'Spanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZXmsxOٻ', '/_MpXT|', 'Spain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZXqn(8X', 'ZMp?X}', 'Vereinigte Staaten von Amerika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('ZXqn(8X', '/_MpXT|', 'United States of America', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('ZZq顭|d', 'ZMp?X}', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZq顭|d', '/_MpXT|', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZp?#U\r', 'ZMp?X}', 'Arabische Emirate', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZp?#U\r', '/_MpXT|', 'Arab Emirates', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZpMM+y', 'ZMp?X}', 'Polen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZpMM+y', '/_MpXT|', 'Poland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZr~8vlJ', 'ZMp?X}', 'Ungarn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZr~8vlJ', '/_MpXT|', 'Hungary', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZsfU', 'ZMp?X}', 'Türkei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZsfU', '/_MpXT|', 'Turkey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZqrYp', 'ZMp?X}', 'Tschechische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZqrYp', '/_MpXT|', 'Czech Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[\0r$\0$', 'ZMp?X}', 'Slowakei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('Z[\0r$\0$', '/_MpXT|', 'Slovakia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('Z[	sU\n|\0', 'ZMp?X}', 'Rumänien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[	sU\n|\0', '/_MpXT|', 'Romania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[s.R2', 'ZMp?X}', 'Brasilien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[s.R2', '/_MpXT|', 'Brazil', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[pA1ͻf\Z', 'ZMp?X}', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[pA1ͻf\Z', '/_MpXT|', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[''p]m	X{', 'ZMp?X}', 'Australien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[''p]m	X{', '/_MpXT|', 'Australia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[0q\r/T', 'ZMp?X}', 'Belgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[0q\r/T', '/_MpXT|', 'Belgium', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[:qPmI$', 'ZMp?X}', 'Dänemark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[:qPmI$', '/_MpXT|', 'Denmark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[Cs`=', 'ZMp?X}', 'Finnland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[Cs`=', '/_MpXT|', 'Finland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[Lq<>y', 'ZMp?X}', 'Frankreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[Lq<>y', '/_MpXT|', 'France', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrG}:]a', 'ZMp?X}', 'Bulgarien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrG}:]a', '/_MpXT|', 'Bulgaria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zst@', 'ZMp?X}', 'Estland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zst@', '/_MpXT|', 'Estonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpUP{', 'ZMp?X}', 'Kroatien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpUP{', '/_MpXT|', 'Croatia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr5*Nn', 'ZMp?X}', 'Lettland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr5*Nn', '/_MpXT|', 'Latvia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsO', 'ZMp?X}', 'Litauen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsO', '/_MpXT|', 'Lithuania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr屣!+W7', 'ZMp?X}', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr屣!+W7', '/_MpXT|', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp9', 'ZMp?X}', 'Slowenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp9', '/_MpXT|', 'Slovenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs', 'ZMp?X}', 'Zypern', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs', '/_MpXT|', 'Cyprus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp$F', 'ZMp?X}', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp$F', '/_MpXT|', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqDN+,', 'ZMp?X}', 'Åland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqDN+,', '/_MpXT|', 'Åland Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrAGى&', 'ZMp?X}', 'Albanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrAGى&', '/_MpXT|', 'Albania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq;WTW', 'ZMp?X}', 'Algerien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq;WTW', '/_MpXT|', 'Algeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr6', 'ZMp?X}', 'Amerikanisch-Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr6', '/_MpXT|', 'American Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr50\\0', 'ZMp?X}', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr50\\0', '/_MpXT|', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq;', 'ZMp?X}', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq;', '/_MpXT|', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpQ', 'ZMp?X}', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpQ', '/_MpXT|', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z!s5֮*', 'ZMp?X}', 'Antarktika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z!s5֮*', '/_MpXT|', 'Antarctica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z,sMY;z', 'ZMp?X}', 'Antigua und Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z,sMY;z', '/_MpXT|', 'Antigua and Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z9r`tchj', 'ZMp?X}', 'Argentinien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z9r`tchj', '/_MpXT|', 'Argentina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZBsvXv', 'ZMp?X}', 'Armenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZBsvXv', '/_MpXT|', 'Armenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZKsb[LY', 'ZMp?X}', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZKsb[LY', '/_MpXT|', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZTs)x*s\0', 'ZMp?X}', 'Aserbaidschan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZTs)x*s\0', '/_MpXT|', 'Azerbaijan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z^sMr', 'ZMp?X}', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z^sMr', '/_MpXT|', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zgr}-0w', 'ZMp?X}', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zgr}-0w', '/_MpXT|', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpp!>', 'ZMp?X}', 'Bangladesch', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpp!>', '/_MpXT|', 'Bangladesh', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zyr9[T3', 'ZMp?X}', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zyr9[T3', '/_MpXT|', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpZ~?tt', 'ZMp?X}', 'Weißrussland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpZ~?tt', '/_MpXT|', 'Belarus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr\\v6', 'ZMp?X}', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr\\v6', '/_MpXT|', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqv+Ex', 'ZMp?X}', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqv+Ex', '/_MpXT|', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrAa<', 'ZMp?X}', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrAa<', '/_MpXT|', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr5P~ö', 'ZMp?X}', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr5P~ö', '/_MpXT|', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpw', 'ZMp?X}', 'Bolivien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpw', '/_MpXT|', 'Bolivia (Plurinational State of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrAKL', 'ZMp?X}', 'Bonaire, Sint Eustatius und Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrAKL', '/_MpXT|', 'Bonaire, Sint Eustatius and Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq:zKhoӮ', 'ZMp?X}', 'Bosnien und Herzegowina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq:zKhoӮ', '/_MpXT|', 'Bosnia and Herzegovina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr9ϲ7', 'ZMp?X}', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr9ϲ7', '/_MpXT|', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp#N\\f', 'ZMp?X}', 'Bouvetinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp#N\\f', '/_MpXT|', 'Bouvet Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr,J5I', 'ZMp?X}', 'Britisches Territorium im Indischen Ozean', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr,J5I', '/_MpXT|', 'British Indian Ocean Territory', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr''Phx#', 'ZMp?X}', 'Kleinere Inselbesitzungen der Vereinigten Staaten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr''Phx#', '/_MpXT|', 'United States Minor Outlying Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\r7*', 'ZMp?X}', 'Britische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\r7*', '/_MpXT|', 'Virgin Islands (British)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsW,P', 'ZMp?X}', 'Amerikanische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsW,P', '/_MpXT|', 'Virgin Islands (U.S.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp5Й.z''', 'ZMp?X}', 'Brunei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp5Й.z''', '/_MpXT|', 'Brunei Darussalam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr8ʰ|', 'ZMp?X}', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr8ʰ|', '/_MpXT|', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z&r.3?', 'ZMp?X}', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z&r.3?', '/_MpXT|', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z0r"sA''', 'ZMp?X}', 'Kambodscha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z0r"sA''', '/_MpXT|', 'Cambodia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z:rs)', 'ZMp?X}', 'Kamerun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z:rs)', '/_MpXT|', 'Cameroon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZDr&o*n', 'ZMp?X}', 'Kap Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZDr&o*n', '/_MpXT|', 'Cabo Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZNpՁcgj\n{\Z[', 'ZMp?X}', 'Kaimaninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZNpՁcgj\n{\Z[', '/_MpXT|', 'Cayman Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZXrG6', 'ZMp?X}', 'Zentralafrikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZXrG6', '/_MpXT|', 'Central African Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zer JRJ=', 'ZMp?X}', 'Tschad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zer JRJ=', '/_MpXT|', 'Chad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpr_:g', 'ZMp?X}', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpr_:g', '/_MpXT|', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZzpQB(P', 'ZMp?X}', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZzpQB(P', '/_MpXT|', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsGbHcn#', 'ZMp?X}', 'Weihnachtsinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsGbHcn#', '/_MpXT|', 'Christmas Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsHAה', 'ZMp?X}', 'Kokosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsHAה', '/_MpXT|', 'Cocos (Keeling) Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrJ*G', 'ZMp?X}', 'Kolumbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrJ*G', '/_MpXT|', 'Colombia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpјg', 'ZMp?X}', 'Union der Komoren', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpјg', '/_MpXT|', 'Comoros', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs,m', 'ZMp?X}', 'Kongo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs,m', '/_MpXT|', 'Congo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('Zs,k', 'ZMp?X}', 'Kongo (Dem. Rep.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs,k', '/_MpXT|', 'Congo (Democratic Republic of the)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z/qG"vuf', 'ZMp?X}', 'Cookinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z/qG"vuf', '/_MpXT|', 'Cook Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZCpOq:Z', 'ZMp?X}', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZCpOq:Z', '/_MpXT|', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[r7i', 'ZMp?X}', 'Kuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z[r7i', '/_MpXT|', 'Cuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zmp;\ni7', 'ZMp?X}', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zmp;\ni7', '/_MpXT|', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zwsnq>:|	', 'ZMp?X}', 'Dschibuti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zwsnq>:|	', '/_MpXT|', 'Djibouti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpV\\h', 'ZMp?X}', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpV\\h', '/_MpXT|', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsj+', 'ZMp?X}', 'Dominikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsj+', '/_MpXT|', 'Dominican Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq:HV?Q', 'ZMp?X}', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq:HV?Q', '/_MpXT|', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp	k~w', 'ZMp?X}', 'Ägypten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp	k~w', '/_MpXT|', 'Egypt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp+<89', 'ZMp?X}', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp+<89', '/_MpXT|', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr!>b', 'ZMp?X}', 'Äquatorial-Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr!>b', '/_MpXT|', 'Equatorial Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zrm:_Wv', 'ZMp?X}', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zrm:_Wv', '/_MpXT|', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpf<H', 'ZMp?X}', 'Äthiopien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpf<H', '/_MpXT|', 'Ethiopia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrbN>\ZX', 'ZMp?X}', 'Falklandinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrbN>\ZX', '/_MpXT|', 'Falkland Islands (Malvinas)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsk98*j', 'ZMp?X}', 'Färöer-Inseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsk98*j', '/_MpXT|', 'Faroe Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr`[4} \r', 'ZMp?X}', 'Fidschi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr`[4} \r', '/_MpXT|', 'Fiji', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpT̠PX|', 'ZMp?X}', 'Französisch Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpT̠PX|', '/_MpXT|', 'French Guiana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsk~Z*', 'ZMp?X}', 'Französisch-Polynesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsk~Z*', '/_MpXT|', 'French Polynesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp` e5', 'ZMp?X}', 'Französische Süd- und Antarktisgebiete', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp` e5', '/_MpXT|', 'French Southern Territories', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpc', 'ZMp?X}', 'Gabun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpc', '/_MpXT|', 'Gabon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpL^JY', 'ZMp?X}', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpL^JY', '/_MpXT|', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z+s5`H', 'ZMp?X}', 'Georgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z+s5`H', '/_MpXT|', 'Georgia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z4sx8Jt', 'ZMp?X}', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z4sx8Jt', '/_MpXT|', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z=qNh1f', 'ZMp?X}', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z=qNh1f', '/_MpXT|', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZGs9A', 'ZMp?X}', 'Grönland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZGs9A', '/_MpXT|', 'Greenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZPs?qT.', 'ZMp?X}', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZPs?qT.', '/_MpXT|', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z]qHɘN\Z', 'ZMp?X}', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z]qHɘN\Z', '/_MpXT|', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZfqՎcj8', 'ZMp?X}', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZfqՎcj8', '/_MpXT|', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zps7', 'ZMp?X}', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zps7', '/_MpXT|', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zzqqф1', 'ZMp?X}', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zzqqф1', '/_MpXT|', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsLճ', 'ZMp?X}', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsLճ', '/_MpXT|', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsM+YgI', 'ZMp?X}', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsM+YgI', '/_MpXT|', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zru*e', 'ZMp?X}', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zru*e', '/_MpXT|', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq$m_', 'ZMp?X}', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq$m_', '/_MpXT|', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs9b=', 'ZMp?X}', 'Heard und die McDonaldinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs9b=', '/_MpXT|', 'Heard Island and McDonald Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs217I	.q', 'ZMp?X}', 'Staat Vatikanstadt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs217I	.q', '/_MpXT|', 'Vatican City', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpyCł', 'ZMp?X}', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpyCł', '/_MpXT|', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpUP2', 'ZMp?X}', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpUP2', '/_MpXT|', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr{g', 'ZMp?X}', 'Indien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr{g', '/_MpXT|', 'India', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\0', 'ZMp?X}', 'Indonesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\0', '/_MpXT|', 'Indonesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq*/܁C6', 'ZMp?X}', 'Elfenbeinküste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq*/܁C6', '/_MpXT|', 'Côte d''Ivoire', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr٣aq*', 'ZMp?X}', 'Iran', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr٣aq*', '/_MpXT|', 'Iran (Islamic Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqtc7xf', 'ZMp?X}', 'Irak', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqtc7xf', '/_MpXT|', 'Iraq', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp$I', 'ZMp?X}', 'Insel Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp$I', '/_MpXT|', 'Isle of Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z\ZsFr)z', 'ZMp?X}', 'Jamaika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z\ZsFr)z', '/_MpXT|', 'Jamaica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z&r9Sk#', 'ZMp?X}', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z&r9Sk#', '/_MpXT|', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z0rekJcA', 'ZMp?X}', 'Jordanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z0rekJcA', '/_MpXT|', 'Jordan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z9r<IR', 'ZMp?X}', 'Kasachstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z9r<IR', '/_MpXT|', 'Kazakhstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZCp+Sн', 'ZMp?X}', 'Kenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZCp+Sн', '/_MpXT|', 'Kenya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZKq#-Al', 'ZMp?X}', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZKq#-Al', '/_MpXT|', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZUp,j	de', 'ZMp?X}', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZUp,j	de', '/_MpXT|', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z^q<,rI&|', 'ZMp?X}', 'Kirgisistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z^q<,rI&|', '/_MpXT|', 'Kyrgyzstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZhpZS*S', 'ZMp?X}', 'Laos', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZhpZS*S', '/_MpXT|', 'Lao People''s Democratic Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqrدEzé', 'ZMp?X}', 'Libanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqrدEzé', '/_MpXT|', 'Lebanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z{r_ؙ', 'ZMp?X}', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z{r_ؙ', '/_MpXT|', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\n_9#Z', 'ZMp?X}', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\n_9#Z', '/_MpXT|', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr8V\n', 'ZMp?X}', 'Libyen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr8V\n', '/_MpXT|', 'Libya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq:W\\$', 'ZMp?X}', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq:W\\$', '/_MpXT|', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zph)tY', 'ZMp?X}', 'Mazedonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zph)tY', '/_MpXT|', 'Macedonia (the former Yugoslav Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq7n\Z?', 'ZMp?X}', 'Madagaskar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq7n\Z?', '/_MpXT|', 'Madagascar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq/,0', 'ZMp?X}', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq/,0', '/_MpXT|', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqÞs%9', 'ZMp?X}', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqÞs%9', '/_MpXT|', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp\Z', 'ZMp?X}', 'Malediven', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp\Z', '/_MpXT|', 'Maldives', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr	t5O', 'ZMp?X}', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr	t5O', '/_MpXT|', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp(\ZVA', 'ZMp?X}', 'Marshallinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp(\ZVA', '/_MpXT|', 'Marshall Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq9M+', 'ZMp?X}', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq9M+', '/_MpXT|', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs''SAd', 'ZMp?X}', 'Mauretanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs''SAd', '/_MpXT|', 'Mauritania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z\0sE&0\\y', 'ZMp?X}', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z\0sE&0\\y', '/_MpXT|', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z	ră6\0ZX', 'ZMp?X}', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z	ră6\0ZX', '/_MpXT|', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsJ-G"', 'ZMp?X}', 'Mexiko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsJ-G"', '/_MpXT|', 'Mexico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zre*p', 'ZMp?X}', 'Mikronesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zre*p', '/_MpXT|', 'Micronesia (Federated States of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z&q~ӟ8', 'ZMp?X}', 'Moldawie', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z&q~ӟ8', '/_MpXT|', 'Moldova (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z3pl', 'ZMp?X}', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z3pl', '/_MpXT|', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z<qV?', 'ZMp?X}', 'Mongolei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z<qV?', '/_MpXT|', 'Mongolia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZEqت~\Z', 'ZMp?X}', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZEqت~\Z', '/_MpXT|', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZPqޔ4tp', 'ZMp?X}', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZPqޔ4tp', '/_MpXT|', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZYquFgU', 'ZMp?X}', 'Marokko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZYquFgU', '/_MpXT|', 'Morocco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zgs{/Y', 'ZMp?X}', 'Mosambik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zgs{/Y', '/_MpXT|', 'Mozambique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z~r|\n', 'ZMp?X}', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z~r|\n', '/_MpXT|', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zst1b-o', 'ZMp?X}', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zst1b-o', '/_MpXT|', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsòq/', 'ZMp?X}', 'Népal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsòq/', '/_MpXT|', 'Nepal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs׀ҏ', 'ZMp?X}', 'Neukaledonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs׀ҏ', '/_MpXT|', 'New Caledonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs`">xk\Z', 'ZMp?X}', 'Neuseeland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs`">xk\Z', '/_MpXT|', 'New Zealand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq]K@z', 'ZMp?X}', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq]K@z', '/_MpXT|', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZraV\Zw7', 'ZMp?X}', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZraV\Zw7', '/_MpXT|', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z"sh/C-', 'ZMp?X}', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z"sh/C-', '/_MpXT|', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z7q hۡg', 'ZMp?X}', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z7q hۡg', '/_MpXT|', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZArw5oF6', 'ZMp?X}', 'Norfolkinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZArw5oF6', '/_MpXT|', 'Norfolk Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZJq\n:,l', 'ZMp?X}', 'Nordkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('ZJq\n:,l', '/_MpXT|', 'Korea (Democratic People''s Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZSqCto$', 'ZMp?X}', 'Nördliche Marianen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZSqCto$', '/_MpXT|', 'Northern Mariana Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z\\pgam\0;', 'ZMp?X}', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z\\pgam\0;', '/_MpXT|', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZepMF=+O', 'ZMp?X}', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZepMF=+O', '/_MpXT|', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Znr<e%H', 'ZMp?X}', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Znr<e%H', '/_MpXT|', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZwpפAk>', 'ZMp?X}', 'Palästina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZwpפAk>', '/_MpXT|', 'Palestine, State of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsś%e', 'ZMp?X}', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsś%e', '/_MpXT|', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqÅ@Tβ', 'ZMp?X}', 'Papua-Neuguinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqÅ@Tβ', '/_MpXT|', 'Papua New Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsk:', 'ZMp?X}', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsk:', '/_MpXT|', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrDvy', 'ZMp?X}', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrDvy', '/_MpXT|', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqU{}', 'ZMp?X}', 'Philippinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqU{}', '/_MpXT|', 'Philippines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsؤ8ܓ', 'ZMp?X}', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsؤ8ܓ', '/_MpXT|', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqW]F!', 'ZMp?X}', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZqW]F!', '/_MpXT|', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrA ', 'ZMp?X}', 'Katar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrA ', '/_MpXT|', 'Qatar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr|=[l', 'ZMp?X}', 'Republik Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr|=[l', '/_MpXT|', 'Republic of Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs=Y[MOVn', 'ZMp?X}', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs=Y[MOVn', '/_MpXT|', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrS\r	M', 'ZMp?X}', 'Russland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrS\r	M', '/_MpXT|', 'Russian Federation', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq#-Uʈ9', 'ZMp?X}', 'Ruanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq#-Uʈ9', '/_MpXT|', 'Rwanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqz͍\\', 'ZMp?X}', 'Saint-Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqz͍\\', '/_MpXT|', 'Saint Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsDIJ[', 'ZMp?X}', 'Sankt Helena', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsDIJ[', '/_MpXT|', 'Saint Helena, Ascension and Tristan da Cunha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpɣXdl', 'ZMp?X}', 'St. Kitts und Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpɣXdl', '/_MpXT|', 'Saint Kitts and Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrrOn.', 'ZMp?X}', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrrOn.', '/_MpXT|', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\Z', 'ZMp?X}', 'Saint Martin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs\Z', '/_MpXT|', 'Saint Martin (French part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z$s={Zuo', 'ZMp?X}', 'Saint-Pierre und Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z$s={Zuo', '/_MpXT|', 'Saint Pierre and Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z,rFI@Y7', 'ZMp?X}', 'Saint Vincent und die Grenadinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z,rFI@Y7', '/_MpXT|', 'Saint Vincent and the Grenadines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z6r)sSiY)', 'ZMp?X}', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z6r)sSiY)', '/_MpXT|', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z?pk^Y', 'ZMp?X}', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z?pk^Y', '/_MpXT|', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZJqּcb!!', 'ZMp?X}', 'São Tomé und Príncipe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZJqּcb!!', '/_MpXT|', 'Sao Tome and Principe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZTq٪4q\\f', 'ZMp?X}', 'Saudi-Arabien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZTq٪4q\\f', '/_MpXT|', 'Saudi Arabia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z]s\ZBh', 'ZMp?X}', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z]s\ZBh', '/_MpXT|', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zfp(>2_', 'ZMp?X}', 'Serbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zfp(>2_', '/_MpXT|', 'Serbia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zppböz', 'ZMp?X}', 'Seychellen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zppböz', '/_MpXT|', 'Seychelles', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZysI+L', 'ZMp?X}', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZysI+L', '/_MpXT|', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq3Xp*o', 'ZMp?X}', 'Singapur', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq3Xp*o', '/_MpXT|', 'Singapore', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpUK	', 'ZMp?X}', 'Sint Maarten (niederl. Teil)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpUK	', '/_MpXT|', 'Sint Maarten (Dutch part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrbY', 'ZMp?X}', 'Salomonen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrbY', '/_MpXT|', 'Solomon Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp=z;Yl', 'ZMp?X}', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp=z;Yl', '/_MpXT|', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs)e9', 'ZMp?X}', 'Republik Südafrika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs)e9', '/_MpXT|', 'South Africa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpMUN', 'ZMp?X}', 'Südgeorgien und die Südlichen Sandwichinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpMUN', '/_MpXT|', 'South Georgia and the South Sandwich Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqඌ', 'ZMp?X}', 'Südkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqඌ', '/_MpXT|', 'Korea (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrH8h', 'ZMp?X}', 'Südsudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrH8h', '/_MpXT|', 'South Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs35\0', 'ZMp?X}', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs35\0', '/_MpXT|', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr*녡', 'ZMp?X}', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zr*녡', '/_MpXT|', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsÊJa', 'ZMp?X}', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsÊJa', '/_MpXT|', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsʏC', 'ZMp?X}', 'Svalbard und Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsʏC', '/_MpXT|', 'Svalbard and Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs=ݏ', 'ZMp?X}', 'Swasiland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs=ݏ', '/_MpXT|', 'Swaziland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp֐y3K', 'ZMp?X}', 'Syrien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp֐y3K', '/_MpXT|', 'Syrian Arab Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z p+MR', 'ZMp?X}', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z p+MR', '/_MpXT|', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z*rό', 'ZMp?X}', 'Tadschikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z*rό', '/_MpXT|', 'Tajikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z4p4@]dP', 'ZMp?X}', 'Tansania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z4p4@]dP', '/_MpXT|', 'Tanzania, United Republic of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z>pɛr+', 'ZMp?X}', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z>pɛr+', '/_MpXT|', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZGsއ`', 'ZMp?X}', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZGsއ`', '/_MpXT|', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZOsXm~~Cc', 'ZMp?X}', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZOsXm~~Cc', '/_MpXT|', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZp/YFt', 'ZMp?X}', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZZp/YFt', '/_MpXT|', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZcrmZz0', 'ZMp?X}', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZcrmZz0', '/_MpXT|', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zos?h$', 'ZMp?X}', 'Trinidad und Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zos?h$', '/_MpXT|', 'Trinidad and Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z{pI', 'ZMp?X}', 'Tunesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Z{pI', '/_MpXT|', 'Tunisia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp ,0', 'ZMp?X}', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp ,0', '/_MpXT|', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp_h;', 'ZMp?X}', 'Turks- und Caicosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp_h;', '/_MpXT|', 'Turks and Caicos Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsh==', 'ZMp?X}', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsh==', '/_MpXT|', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsZ.', 'ZMp?X}', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsZ.', '/_MpXT|', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsoeT²', 'ZMp?X}', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZsoeT²', '/_MpXT|', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsy-', 'ZMp?X}', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsy-', '/_MpXT|', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpm`;', 'ZMp?X}', 'Usbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpm`;', '/_MpXT|', 'Uzbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrkIC', 'ZMp?X}', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZrkIC', '/_MpXT|', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpoTT', 'ZMp?X}', 'Venezuela', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ZpoTT', '/_MpXT|', 'Venezuela (Bolivarian Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsj\n66', 'ZMp?X}', 'Vietnam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zsj\n66', '/_MpXT|', 'Viet Nam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqӳ@zNn', 'ZMp?X}', 'Wallis und Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zqӳ@zNn', '/_MpXT|', 'Wallis and Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq\rS', 'ZMp?X}', 'Westsahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zq\rS', '/_MpXT|', 'Western Sahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp\\Sta', 'ZMp?X}', 'Jemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zp\\Sta', '/_MpXT|', 'Yemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zrck"/', 'ZMp?X}', 'Sambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zrck"/', '/_MpXT|', 'Zambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs''P', 'ZMp?X}', 'Simbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zs''P', '/_MpXT|', 'Zimbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `id` binary(16) NOT NULL,
  `iso_code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `factor` double NOT NULL,
  `symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `item_rounding` json DEFAULT NULL,
  `total_rounding` json DEFAULT NULL,
  `tax_free_from` double DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.currency.iso_code` (`iso_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
('UKG͂', 'USD', 1, '$', 1, '[[regtime_]]', NULL, '{"decimals": "2", "interval": 0.01, "roundForNet": true}', '{"decimals": "2", "interval": 0.01, "roundForNet": true}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `currency_country_rounding`
--

CREATE TABLE `currency_country_rounding` (
  `id` binary(16) NOT NULL,
  `currency_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `item_rounding` json NOT NULL,
  `total_rounding` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currency_translation`
--

CREATE TABLE `currency_translation` (
  `currency_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`currency_id`,`language_id`),
  KEY `fk.currency_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency_translation`
--

INSERT INTO `currency_translation` VALUES
('UKG͂', 'ZMp?X}', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL),
('UKG͂', '/_MpXT|', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` binary(16) NOT NULL,
  `auto_increment` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` binary(16) NOT NULL,
  `requested_customer_group_id` binary(16) DEFAULT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `last_payment_method_id` binary(16) DEFAULT NULL,
  `default_billing_address_id` binary(16) NOT NULL,
  `default_shipping_address_id` binary(16) NOT NULL,
  `customer_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_encoder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_ids` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `double_opt_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `double_opt_in_email_sent_date` datetime(3) DEFAULT NULL,
  `double_opt_in_confirm_date` datetime(3) DEFAULT NULL,
  `hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guest` tinyint(1) NOT NULL DEFAULT '0',
  `first_login` datetime(3) DEFAULT NULL,
  `last_login` datetime(3) DEFAULT NULL,
  `newsletter_sales_channel_ids` json DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `last_order_date` datetime(3) DEFAULT NULL,
  `order_count` int NOT NULL DEFAULT '0',
  `order_total_amount` double DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `affiliate_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `remote_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag_ids` json DEFAULT NULL,
  `bound_sales_channel_id` binary(16) DEFAULT NULL,
  `created_by_id` binary(16) DEFAULT NULL,
  `updated_by_id` binary(16) DEFAULT NULL,
  `account_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'private',
  `review_count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.auto_increment` (`auto_increment`),
  UNIQUE KEY `hash` (`hash`),
  KEY `idx.firstlogin` (`first_login`),
  KEY `idx.lastlogin` (`last_login`),
  KEY `idx.customer.default_billing_address_id` (`default_billing_address_id`),
  KEY `idx.customer.default_shipping_address_id` (`default_shipping_address_id`),
  KEY `fk.customer.customer_group_id` (`customer_group_id`),
  KEY `fk.customer.last_payment_method_id` (`last_payment_method_id`),
  KEY `fk.customer.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer.requested_customer_group_id` (`requested_customer_group_id`),
  KEY `fk.customer.bound_sales_channel_id` (`bound_sales_channel_id`),
  KEY `idx.email` (`email`),
  KEY `fk.customer.salutation_id` (`salutation_id`),
  KEY `fk.customer.created_by_id` (`created_by_id`),
  KEY `fk.customer.updated_by_id` (`updated_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customer_address`
--

CREATE TABLE `customer_address` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `country_state_id` binary(16) DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zipcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(70) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.customer_address.country_id` (`country_id`),
  KEY `fk.customer_address.country_state_id` (`country_state_id`),
  KEY `fk.customer_address.customer_id` (`customer_id`),
  KEY `fk.customer_address.salutation_id` (`salutation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group`
--

CREATE TABLE `customer_group` (
  `id` binary(16) NOT NULL,
  `display_gross` tinyint(1) NOT NULL DEFAULT '1',
  `registration_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group`
--

INSERT INTO `customer_group` VALUES
('ϽPӍAحOȽ', 1, 0, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_registration_sales_channels`
--

CREATE TABLE `customer_group_registration_sales_channels` (
  `customer_group_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  PRIMARY KEY (`customer_group_id`,`sales_channel_id`),
  KEY `fk.customer_group_registration_sales_channels.customer_group_id` (`customer_group_id`),
  KEY `fk.customer_group_registration_sales_channels.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_translation`
--

CREATE TABLE `customer_group_translation` (
  `customer_group_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `registration_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_introduction` longtext COLLATE utf8mb4_unicode_ci,
  `registration_only_company_registration` tinyint(1) DEFAULT NULL,
  `registration_seo_meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`,`language_id`),
  KEY `fk.customer_group_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group_translation`
--

INSERT INTO `customer_group_translation` VALUES
('ϽPӍAحOȽ', 'ZMp?X}', 'Standard-Kundengruppe', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ϽPӍAحOȽ', '/_MpXT|', 'Standard customer group', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_recovery`
--

CREATE TABLE `customer_recovery` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_recovery.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_tag`
--

CREATE TABLE `customer_tag` (
  `customer_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`customer_id`,`tag_id`),
  KEY `fk.customer_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist`
--

CREATE TABLE `customer_wishlist` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist` (`sales_channel_id`,`customer_id`),
  KEY `fk.customer_wishlist.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer_wishlist.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist_product`
--

CREATE TABLE `customer_wishlist_product` (
  `id` binary(16) NOT NULL,
  `customer_wishlist_id` binary(16) NOT NULL,
  `product_id` binary(16) NOT NULL,
  `product_version_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist.sales_channel_id__customer_id` (`customer_wishlist_id`,`product_id`),
  KEY `fk.customer_wishlist_product.product_id` (`product_id`,`product_version_id`),
  KEY `fk.customer_wishlist_product.customer_wishlist_id` (`customer_wishlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_entity`
--

CREATE TABLE `custom_entity` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` json NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `flags` json DEFAULT NULL,
  `plugin_id` binary(16) DEFAULT NULL,
  `custom_fields_aware` tinyint(1) NOT NULL DEFAULT '0',
  `label_property` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `app_id` (`app_id`),
  KEY `fk.custom_entity.plugin_id` (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field`
--

CREATE TABLE `custom_field` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `set_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `allow_customer_write` tinyint NOT NULL DEFAULT '0',
  `allow_cart_expose` tinyint(1) NOT NULL DEFAULT '0',
  `store_api_aware` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field.name` (`name`),
  KEY `fk.custom_field.set_id` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set`
--

CREATE TABLE `custom_field_set` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `app_id` binary(16) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `global` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.custom_field_set.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set_relation`
--

CREATE TABLE `custom_field_set_relation` (
  `id` binary(16) NOT NULL,
  `set_id` binary(16) NOT NULL,
  `entity_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field_set_relation.entity_name` (`set_id`,`entity_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time`
--

CREATE TABLE `delivery_time` (
  `id` binary(16) NOT NULL,
  `min` int NOT NULL,
  `max` int NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time`
--

INSERT INTO `delivery_time` VALUES
('Z[p$$i', 1, 3, 'day', '[[regtime_]]', NULL),
('Z[p$$iq	', 2, 5, 'day', '[[regtime_]]', NULL),
('Z[p$$iȎ', 1, 2, 'week', '[[regtime_]]', NULL),
('Z[p$$i*', 3, 4, 'week', '[[regtime_]]', NULL),
('[fpur(', 0, 0, 'hour', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time_translation`
--

CREATE TABLE `delivery_time_translation` (
  `delivery_time_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`delivery_time_id`,`language_id`),
  KEY `fk.delivery_time_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time_translation`
--

INSERT INTO `delivery_time_translation` VALUES
('Z[p$$i', 'ZMp?X}', '1-3 Tage', NULL, '[[regtime_]]', NULL),
('Z[p$$i', '/_MpXT|', '1-3 days', NULL, '[[regtime_]]', NULL),
('Z[p$$iq	', 'ZMp?X}', '2-5 Tage', NULL, '[[regtime_]]', NULL),
('Z[p$$iq	', '/_MpXT|', '2-5 days', NULL, '[[regtime_]]', NULL),
('Z[p$$iȎ', 'ZMp?X}', '1-2 Wochen', NULL, '[[regtime_]]', NULL),
('Z[p$$iȎ', '/_MpXT|', '1-2 weeks', NULL, '[[regtime_]]', NULL),
('Z[p$$i*', 'ZMp?X}', '3-4 Wochen', NULL, '[[regtime_]]', NULL),
('Z[p$$i*', '/_MpXT|', '3-4 weeks', NULL, '[[regtime_]]', NULL),
('[fpur(', 'ZMp?X}', 'Sofort verfügbar', NULL, '[[regtime_]]', NULL),
('[fpur(', '/_MpXT|', 'Instant download', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

CREATE TABLE `document` (
  `id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `referenced_document_id` binary(16) DEFAULT NULL,
  `order_id` binary(16) NOT NULL,
  `order_version_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `static` tinyint(1) NOT NULL DEFAULT '0',
  `deep_link_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_media_file_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `document_number` varchar(255) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS (json_unquote(json_extract(`config`,_utf8mb4'$.documentNumber'))) STORED,
  `document_a11y_media_file_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.deep_link_code` (`deep_link_code`),
  KEY `fk.document.document_type_id` (`document_type_id`),
  KEY `fk.document.referenced_document_id` (`referenced_document_id`),
  KEY `fk.document.order_id` (`order_id`,`order_version_id`),
  KEY `fk.document.document_media_file_id` (`document_media_file_id`),
  KEY `idx.document.document_number` (`document_number`),
  KEY `fk.document.document_a11y_media_file_id` (`document_a11y_media_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config`
--

CREATE TABLE `document_base_config` (
  `id` binary(16) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename_prefix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `filename_suffix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `document_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `global` tinyint(1) DEFAULT '0',
  `document_type_id` binary(16) NOT NULL,
  `logo_id` binary(16) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.document_base_config.type_id` (`document_type_id`),
  KEY `fk.document_base_config.logo_id` (`logo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config`
--

INSERT INTO `document_base_config` VALUES
('Z]p*<#L', 'cancellation_invoice', 'cancellation_invoice_', '', '', 1, 'Z]sl:4', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true, "referencedDocumentType": "invoice", "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL),
('Z]p*<s', 'invoice', 'invoice_', '', '', 1, 'ZNZpH-5 ', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "deliveryCountries": ["019bc65a4e9b716eb00ed1182f63a9d5", "019bc65a4ffa72a4adda6ab237981180", "019bc65a500672ada2288c2efde44c33", "019bc65a57857235b31bb782f777bd1a", "019bc65a5798729199974810e17e6bc6", "019bc65a57b37109b347271be6a798a9", "019bc65a57c870efb0c963865013a951", "019bc65a57e47020bbae4a42ea5a527a", "019bc65a57ef73159f27d2c5e88f5867", "019bc65a57fb71d6a68040edaa0e9232", "019bc65a586d73b681aff1784fd9bb17", "019bc65a5ada701ebb4da74d1f2b8579", "019bc65a5ae472f8aae97e38c5766c4a", "019bc65a5af671899687f9e483725970", "019bc65a5b0072248600f1b6b7f924bb", "019bc65a5b0973b49255079c0a7c000f", "019bc65a5b30711f940d2f105402dbd6", "019bc65a5b3a7150b50e6db74924d1da", "019bc65a5b437314b880b21594e4603d", "019bc65a5b4c711785ca3cb61b3e7f79", "019bc65aa6857247977d3a5d92611fbe", "019bc65aa691731d87c874951f40c302", "019bc65aa69b7055beccce50db147bd5", "019bc65aa6a572ae81eac5352a4eff6e", "019bc65aa6af7305a1070cf24f989615", "019bc65aa6bb72e5b1a3212bed5737a9", "019bc65aa6c470eb9ae7bce7add839a2", "019bc65aa6d073f598d20698b5b481e0"], "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('Z]p*<', 'delivery_note', 'delivery_note_', '', '', 1, 'ZNZpH-t', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": false, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('Z]p*<.G', 'credit_note', 'credit_note_', '', '', 1, 'ZNZpH-', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true, "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config_sales_channel`
--

CREATE TABLE `document_base_config_sales_channel` (
  `id` binary(16) NOT NULL,
  `document_base_config_id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_base_configuration_id__sales_channel_id` (`document_type_id`,`sales_channel_id`),
  KEY `fk.document_base_config_sales_channel.document_base_config_id` (`document_base_config_id`),
  KEY `fk.document_base_config_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config_sales_channel`
--

INSERT INTO `document_base_config_sales_channel` VALUES
('Z^s@S', 'Z]p*<#L', 'Z]sl:4', NULL, '[[regtime_]]', NULL),
('Z^s+4/ڊ', 'Z]p*<s', 'ZNZpH-5 ', NULL, '[[regtime_]]', NULL),
('Z^q,+E', 'Z]p*<', 'ZNZpH-t', NULL, '[[regtime_]]', NULL),
('Z^p:X{^', 'Z]p*<.G', 'ZNZpH-', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type`
--

CREATE TABLE `document_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type`
--

INSERT INTO `document_type` VALUES
('ZNZpH-5 ', 'invoice', '[[regtime_]]', NULL),
('ZNZpH-t', 'delivery_note', '[[regtime_]]', NULL),
('ZNZpH-', 'credit_note', '[[regtime_]]', NULL),
('Z]sl:4', 'storno', '[[regtime_]]', NULL),
('[sQ)?', 'zugferd_invoice', '[[regtime_]]', NULL),
('[sQ)׸2S', 'zugferd_embedded_invoice', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type_translation`
--

CREATE TABLE `document_type_translation` (
  `document_type_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`document_type_id`,`language_id`),
  KEY `fk.document_type_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type_translation`
--

INSERT INTO `document_type_translation` VALUES
('ZNZpH-5 ', 'ZMp?X}', 'Rechnung', NULL, '[[regtime_]]', NULL),
('ZNZpH-5 ', '/_MpXT|', 'Invoice', NULL, '[[regtime_]]', NULL),
('ZNZpH-t', 'ZMp?X}', 'Lieferschein', NULL, '[[regtime_]]', NULL),
('ZNZpH-t', '/_MpXT|', 'Delivery note', NULL, '[[regtime_]]', NULL),
('ZNZpH-', 'ZMp?X}', 'Gutschrift', NULL, '[[regtime_]]', NULL),
('ZNZpH-', '/_MpXT|', 'Credit note', NULL, '[[regtime_]]', NULL),
('Z]sl:4', 'ZMp?X}', 'Stornorechnung', NULL, '[[regtime_]]', NULL),
('Z]sl:4', '/_MpXT|', 'Cancellation invoice', NULL, '[[regtime_]]', NULL),
('[sQ)?', 'ZMp?X}', 'Rechnung: ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('[sQ)?', '/_MpXT|', 'Invoice: ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL),
('[sQ)׸2S', 'ZMp?X}', 'Rechnung: PDF mit eingebetteter ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('[sQ)׸2S', '/_MpXT|', 'Invoice: PDF with embedded ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow`
--

CREATE TABLE `flow` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '1',
  `payload` longblob,
  `invalid` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_flow_event_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.flow.event_name` (`event_name`,`priority`),
  KEY `fk.flow.app_flow_event_id` (`app_flow_event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow`
--

INSERT INTO `flow` VALUES
('[DsLl_', 'Order placed', NULL, 'checkout.order.placed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLmC\r', 'Customer account registered', NULL, 'checkout.customer.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLmRd', 'Newsletter sign-up registered', NULL, 'newsletter.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLo', 'Newsletter sign-up confirmed', NULL, 'newsletter.confirm', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLo', 'User recovery request sent', NULL, 'user.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLpb', 'Contact form sent', NULL, 'contact_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLq:', 'Customer requests new password', NULL, 'customer.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLrxI', 'Customer account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_registration', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLsj*', 'Guest account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_guest_order', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLtO!', 'Customer group registration request accepted', NULL, 'customer.group.registration.accepted', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLv ', 'Customer group registration request declined', NULL, 'customer.group.registration.declined', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLwob', 'Shipment enters status partially returned', NULL, 'state_enter.order_delivery.state.returned_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLx}#', 'Shipment enters status partially shipped', NULL, 'state_enter.order_delivery.state.shipped_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLyr', 'Shipment enters status returned', NULL, 'state_enter.order_delivery.state.returned', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLzӌ', 'Shipment enters status shipped', NULL, 'state_enter.order_delivery.state.shipped', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL|pK', 'Shipment enters status cancelled', NULL, 'state_enter.order_delivery.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL}d4', 'Payment enters status reminder sent', NULL, 'state_enter.order_transaction.state.reminded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL~gjd', 'Payment enters status partially refunded', NULL, 'state_enter.order_transaction.state.refunded_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL', 'Payment enters status cancelled', NULL, 'state_enter.order_transaction.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL', 'Payment enters status paid', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL\Z', 'Payment enters status refunded', NULL, 'state_enter.order_transaction.state.refunded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLҫ', 'Payment enters status partially paid', NULL, 'state_enter.order_transaction.state.paid_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsLC', 'Payment enters status open', NULL, 'state_enter.order_transaction.state.open', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL', 'Order enters status in progress', NULL, 'state_enter.order.state.in_progress', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL~h', 'Order enters status cancelled', NULL, 'state_enter.order.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[DsL', 'Order enters status completed', NULL, 'state_enter.order.state.completed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[lpΗ=۱;`u', 'Deliver ordered product downloads', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[wqp7no(', 'Review form sent', NULL, 'review_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[q٦z', 'Order enters status authorized', NULL, 'state_enter.order_transaction.state.authorized', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[pUʖ', 'Order enters status chargeback', NULL, 'state_enter.order_transaction.state.chargeback', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[r)g1', 'Order enters status unconfirmed', NULL, 'state_enter.order_transaction.state.unconfirmed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('[Br]S"', 'Customer password changed', NULL, 'customer.password.changed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_sequence`
--

CREATE TABLE `flow_sequence` (
  `id` binary(16) NOT NULL,
  `flow_id` binary(16) NOT NULL,
  `app_flow_action_id` binary(16) DEFAULT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `rule_id` binary(16) DEFAULT NULL,
  `action_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `display_group` int NOT NULL DEFAULT '1',
  `true_case` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.flow_sequence.flow_id` (`flow_id`),
  KEY `fk.flow_sequence.rule_id` (`rule_id`),
  KEY `fk.flow_sequence.parent_id` (`parent_id`),
  KEY `fk.flow_sequence.app_flow_action_id` (`app_flow_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_sequence`
--

INSERT INTO `flow_sequence` VALUES
('[DsLl{N', '[DsLl_', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5e8372c1b6c6f65e420cd338", "mailTemplateTypeId": "019bc65ac86e7062beed3c3bc3e5acf5"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLmEN', '[DsLmC\r', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5e9272f581cf8e2d69b0e1d2", "mailTemplateTypeId": "019bc65ac878730f8e750ab3e910178f"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLn6eb', '[DsLmRd', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5dd972f3a588a591d043cf6d", "mailTemplateTypeId": "019bc65ac8807344bc84e557ebac48c6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLo_f', '[DsLo', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5dd972f3a588a591d04a8ef9", "mailTemplateTypeId": "019bc65ac88673a3b886b51b0dfe8d8d"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLp''', '[DsLo', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a68a570bdbc569311ab876305", "mailTemplateTypeId": "019bc65ac8907040852d626b0c78b2ab"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLpC2', '[DsLpb', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a733773db91cb5e4af51016e5", "mailTemplateTypeId": "019bc65ac8967151aa798e5aa2a6914e"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLr', '[DsLq:', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a76dc73aa863e4a121b87a2ec", "mailTemplateTypeId": "019bc65ac89d7231b860c8b229587acf"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLs ', '[DsLrxI', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7fe67238b2bd3502b388f58e", "mailTemplateTypeId": "019bc65ac8ae71c1a7aa0f06872b8cec"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLsb', '[DsLsj*', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a80ab738eb730d0ce43ab3785", "mailTemplateTypeId": "019bc65ac8b1739fbfb253e022dcd376"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLu0B', '[DsLtO!', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65ac2c27176899fba6affda0faf", "mailTemplateTypeId": "019bc65ac8b572f68154d00e82c5e1be"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLv]', '[DsLv ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65ac2de73cf90fe1a11f9e61ec6", "mailTemplateTypeId": "019bc65ac8b87320acb0b696eab671f3"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLxK', '[DsLwob', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7aef7107ad4867eb4140459e", "mailTemplateTypeId": "019bc65ac8bc731c97f072a31f636a08"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLx!', '[DsLx}#', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7ad172c682777e3d0ca46e56", "mailTemplateTypeId": "019bc65ac8c072d5a37f59f84d896811"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLzt>', '[DsLyr', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b0270b28b0d780b29bd4ade", "mailTemplateTypeId": "019bc65ac8c370c1b1c14a96d8f75fc4"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsL{I', '[DsLzӌ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b1f711b809f81af2e591735", "mailTemplateTypeId": "019bc65ac8c67011b5a505d0236655d9"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsL}D', '[DsL|pK', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b1271bca4dacbb96063c28f", "mailTemplateTypeId": "019bc65ac8c971d5891d3e4f11c702bb"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsL~''<', '[DsL}d4', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b7d739dbc457e6e8b5e71f6", "mailTemplateTypeId": "019bc65ac8cc71b4b0dbb4a0a7f649b6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLB3', '[DsL~gjd', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b6e732d9afbd44c59dd639a", "mailTemplateTypeId": "019bc65ac8cf711786664d2915d29fc6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLA@', '[DsL', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7baa71ae8bbf6ac7b778f898", "mailTemplateTypeId": "019bc65ac8d37057801026750846bf2b"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsL}', '[DsL', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b9870dbb1594b73478159e9", "mailTemplateTypeId": "019bc65ac8d673f4863863e50fdc9733"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLȠ=', '[DsL\Z', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7bb6723c86426181eb48abbd", "mailTemplateTypeId": "019bc65ac8d9702aa06333f18a01f850"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLt', '[DsLҫ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7bc673698b5b0e7cb1ad4980", "mailTemplateTypeId": "019bc65ac8dc7057b15eed18a99cc208"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsL2', '[DsLC', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b8b7374906c01fdf6f66ccd", "mailTemplateTypeId": "019bc65ac8df71caa9a433f792ed46a1"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsL?', '[DsL', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b3f7257813d01f6f1e17589", "mailTemplateTypeId": "019bc65ac8e2730991f4a4d4b1edfee0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLI', '[DsL~h', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b5a71abb2d466912dcbecc2", "mailTemplateTypeId": "019bc65ac8e5738ca3ba2ec9f78b2013"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[DsLO{', '[DsL', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b4d7313b22066b94e8394d0", "mailTemplateTypeId": "019bc65ac8e9711fa8590fdb03255249"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[lqH0Tӯ', '[lpΗ=۱;`u', NULL, NULL, '[lr	4]', NULL, '[]', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[lq\nR ', '[lpΗ=۱;`u', NULL, '[lqH0Tӯ', NULL, 'action.grant.download.access', '{"value": true}', 1, 1, 1, NULL, '[[regtime_]]', NULL),
('[ls>r', '[lpΗ=۱;`u', NULL, '[lqH0Tӯ', NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65b698671baaa4a1c9cf338e556", "documentTypeIds": []}', 2, 1, 1, NULL, '[[regtime_]]', NULL),
('[wr׮Դ', '[wqp7no(', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "admin"}, "mailTemplateId": "019bc65b7787737099f4c7ef64ce5727", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[sؚ\r', '[q٦z', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65b8aa9711882606f1d71308092", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[s&', '[pUʖ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65b8aef7203b76c86ffa9eccacc", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[qvLV#z', '[r)g1', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65b8b10711a8ff245e600c27dd1", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('[Cqjf-s:E', '[Br]S"', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65bdf3270d9bda84f47e0dcfcf9", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_template`
--

CREATE TABLE `flow_template` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_template`
--

INSERT INTO `flow_template` VALUES
('[lr\\x_', 'Contact form sent', '{"eventName": "contact_form.send", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd1de7087", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a733773db91cb5e4af51016e5", "mailTemplateTypeId": "019bc65a6d69738092ecbb97e21db57b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\k', 'Newsletter sign-up registered', '{"eventName": "newsletter.register", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd32b7b77", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5dd972f3a588a591d04a8ef9", "mailTemplateTypeId": "019bc65a5cca7044b75679a1d9084add"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\.,', 'User recovery request sent', '{"eventName": "user.recovery.request", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd3437fe3", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a68a570bdbc569311ab876305", "mailTemplateTypeId": "019bc65a68997039928d8b637f3c606f"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\	y', 'Guest account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_guest_order", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd4feff18", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a80ab738eb730d0ce43ab3785", "mailTemplateTypeId": "019bc65a80ab738eb730d0ce44948847"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\', 'Customer account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_registration", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd6d0230f", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7fe67238b2bd3502b388f58e", "mailTemplateTypeId": "019bc65a7fe67238b2bd3502b3cbee16"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\o', 'Order placed', '{"eventName": "checkout.order.placed", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd7d8538d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5e8372c1b6c6f65e420cd338", "mailTemplateTypeId": "019bc65a5cca7044b75679a1d9ff50ff"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\؄', 'Customer group registration request declined', '{"eventName": "customer.group.registration.declined", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cd91e104c", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65ac2de73cf90fe1a11f9e61ec6", "mailTemplateTypeId": "019bc65ac2d471f2ab98aa8837a23c6e"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\M', 'Customer group registration request accepted', '{"eventName": "customer.group.registration.accepted", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cda061d70", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65ac2c27176899fba6affda0faf", "mailTemplateTypeId": "019bc65ac2b871b2adbced10b89fcd89"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\hA0', 'Newsletter sign-up confirmed', '{"eventName": "newsletter.confirm", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cdad2eeb7", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5dd972f3a588a591d04a8ef9", "mailTemplateTypeId": "019bc65a5cca7044b75679a1d9084add"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\ۙ&I', 'Customer requests new password', '{"eventName": "customer.recovery.request", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cdc2d2225", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a76dc73aa863e4a121b87a2ec", "mailTemplateTypeId": "019bc65a76d171cdbfe44d2a9317610e"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\H', 'Customer account registered', '{"eventName": "checkout.customer.register", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cddd4b2e7", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a5e9272f581cf8e2d69b0e1d2", "mailTemplateTypeId": "019bc65a5cca7044b75679a1d8c516fb"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\5', 'Payment enters status partially paid', '{"eventName": "state_enter.order_transaction.state.paid_partially", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cdf21627e", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7bc673698b5b0e7cb1ad4980", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e1f057f8"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\߫6', 'Shipment enters status returned', '{"eventName": "state_enter.order_delivery.state.returned", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce02a37a3", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b0270b28b0d780b29bd4ade", "mailTemplateTypeId": "019bc65a5cca7044b75679a1ddac9e0a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\Uy', 'Shipment enters status partially returned', '{"eventName": "state_enter.order_delivery.state.returned_partially", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce12b7aad", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7aef7107ad4867eb4140459e", "mailTemplateTypeId": "019bc65a5cca7044b75679a1dcdab7ed"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\', 'Payment enters status refunded', '{"eventName": "state_enter.order_transaction.state.refunded", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce22a8862", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7bb6723c86426181eb48abbd", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e1adb440"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\V', 'Payment enters status paid', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce388a951", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b9870dbb1594b73478159e9", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e14d984a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\S.', 'Order enters status in progress', '{"eventName": "state_enter.order.state.in_progress", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce520b750", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b3f7257813d01f6f1e17589", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e35c6cfe"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\\rZ', 'Payment enters status partially refunded', '{"eventName": "state_enter.order_transaction.state.refunded_partially", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce697b5f1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b6e732d9afbd44c59dd639a", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e0506518"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\yg', 'Payment enters status open', '{"eventName": "state_enter.order_transaction.state.open", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce83b8946", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b8b7374906c01fdf6f66ccd", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e2833cb6"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\BF', 'Shipment enters status shipped', '{"eventName": "state_enter.order_delivery.state.shipped", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ce92ee508", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b1f711b809f81af2e591735", "mailTemplateTypeId": "019bc65a5cca7044b75679a1de14c1ae"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\', 'Shipment enters status partially shipped', '{"eventName": "state_enter.order_delivery.state.shipped_partially", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ceac97604", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7ad172c682777e3d0ca46e56", "mailTemplateTypeId": "019bc65a5cca7044b75679a1dd31b9c8"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\f', 'Shipment enters status cancelled', '{"eventName": "state_enter.order_delivery.state.cancelled", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cebdab2dc", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b1271bca4dacbb96063c28f", "mailTemplateTypeId": "019bc65a5cca7044b75679a1dea1697f"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\}Y', 'Payment enters status cancelled', '{"eventName": "state_enter.order_transaction.state.cancelled", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cececb248", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7baa71ae8bbf6ac7b778f898", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e0d9b4af"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\~:', 'Order enters status cancelled', '{"eventName": "state_enter.order.state.cancelled", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cee16c348", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b5a71abb2d466912dcbecc2", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e4160985"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\4', 'Payment enters status reminder sent', '{"eventName": "state_enter.order_transaction.state.reminded", "sequences": [{"id": "019bc65b6ccb72169bc1ee5ceeabb4b3", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b7d739dbc457e6e8b5e71f6", "mailTemplateTypeId": "019bc65a5cca7044b75679a1df7316fc"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lr\\WG', 'Order enters status completed', '{"eventName": "state_enter.order.state.completed", "sequences": [{"id": "019bc65b6ccb72169bc1ee5cef8f34d1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65a7b4d7313b22066b94e8394d0", "mailTemplateTypeId": "019bc65a5cca7044b75679a1e49970cb"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[lq_~.', 'Deliver ordered product downloads', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "019bc65b846e738483aa42db6ad1ea10", "config": [], "ruleId": "019bc65b6cd772099ff983ef345db992", "parentId": null, "position": 1, "trueCase": 0, "actionName": null, "displayGroup": 1}, {"id": "019bc65b846e738483aa42db6b5bde4b", "config": {"value": true}, "ruleId": null, "parentId": "019bc65b846e738483aa42db6ad1ea10", "position": 1, "trueCase": 1, "actionName": "action.grant.download.access", "displayGroup": 1}, {"id": "019bc65b846e738483aa42db6b832a47", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65b698671baaa4a1c9cf338e556", "documentTypeIds": [], "mailTemplateTypeId": "019bc65b69757274b6fcdd8c394a69a1"}, "ruleId": null, "parentId": "019bc65b846e738483aa42db6ad1ea10", "position": 2, "trueCase": 1, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[qf9', 'Order enters status authorized', '{"eventName": "state_enter.order_transaction.state.authorized", "sequences": [{"id": "019bc65b90bb7114b9e01b6639bf8a19", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019bc65b8aa9711882606f1d71308092\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[rȹ.\ZX', 'Order enters status chargeback', '{"eventName": "state_enter.order_transaction.state.chargeback", "sequences": [{"id": "019bc65b90cb72c8b9bd811f82723dcc", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019bc65b8aef7203b76c86ffa9eccacc\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[r(or*', 'Order enters status unconfirmed', '{"eventName": "state_enter.order_transaction.state.unconfirmed", "sequences": [{"id": "019bc65b90d97215b4286f720fc27a46", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019bc65b8b10711a8ff245e600c27dd1\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('[GrBJQP0', 'Customer password changed', '{"eventName": "customer.password.changed", "sequences": [{"id": "019bc65bdf43719ea36a662d733ace45", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019bc65bdf3270d9bda84f47e0dcfcf9", "mailTemplateTypeId": "019bc65bdf31720099a86cf0cad4f226"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `import_export_file`
--

CREATE TABLE `import_export_file` (
  `id` binary(16) NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` datetime(3) NOT NULL,
  `size` int DEFAULT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_log`
--

CREATE TABLE `import_export_log` (
  `id` binary(16) NOT NULL,
  `activity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `records` int NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` binary(16) DEFAULT NULL,
  `profile_id` binary(16) DEFAULT NULL,
  `file_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `result` json DEFAULT NULL,
  `invalid_records_log_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.import_export_log.user_id` (`user_id`),
  KEY `fk.import_export_log.profile_id` (`profile_id`),
  KEY `fk.import_export_log.invalid_records_log_id` (`invalid_records_log_id`),
  KEY `fk.import_export_log.file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile`
--

CREATE TABLE `import_export_profile` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `source_entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delimiter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enclosure` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'import-export',
  `mapping` longtext COLLATE utf8mb4_unicode_ci,
  `update_by` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.import_export_profile.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile`
--

INSERT INTO `import_export_profile` VALUES
('Zqh`', 1, 'category', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"active","mappedKey":"active","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"visible","mappedKey":"visible","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.externalLink","mappedKey":"external_link","position":6},{"key":"translations.DEFAULT.description","mappedKey":"description","position":7},{"key":"translations.DEFAULT.metaTitle","mappedKey":"meta_title","position":8},{"key":"translations.DEFAULT.metaDescription","mappedKey":"meta_description","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15},{"key":"cmsPageId","mappedKey":"cms_page_id","position":16}]', NULL, '[[regtime_]]', NULL, NULL, 'default_category'),
('ZpKS', 1, 'media', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"mediaFolderId","mappedKey":"folder_id","position":1},{"key":"url","mappedKey":"url","position":2},{"key":"private","mappedKey":"private","position":3},{"key":"mediaType","mappedKey":"type","position":4},{"key":"translations.DEFAULT.title","mappedKey":"title","position":5},{"key":"translations.DEFAULT.alt","mappedKey":"alt","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_media'),
('Zs]MQc', 1, 'product', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"productNumber","mappedKey":"product_number","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"stock","mappedKey":"stock","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.description","mappedKey":"description","position":6},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":7},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":8},{"key":"purchasePrices.DEFAULT.net","mappedKey":"purchase_prices_net","position":9},{"key":"purchasePrices.DEFAULT.gross","mappedKey":"purchase_prices_gross","position":10},{"key":"tax.id","mappedKey":"tax_id","position":11},{"key":"tax.taxRate","mappedKey":"tax_rate","position":12},{"key":"tax.name","mappedKey":"tax_name","position":13},{"key":"cover.media.id","mappedKey":"cover_media_id","position":14},{"key":"cover.media.url","mappedKey":"cover_media_url","position":15},{"key":"cover.media.translations.DEFAULT.title","mappedKey":"cover_media_title","position":16},{"key":"cover.media.translations.DEFAULT.alt","mappedKey":"cover_media_alt","position":17},{"key":"manufacturer.id","mappedKey":"manufacturer_id","position":18},{"key":"manufacturer.translations.DEFAULT.name","mappedKey":"manufacturer_name","position":19},{"key":"categories","mappedKey":"categories","position":20},{"key":"visibilities.all","mappedKey":"sales_channel","position":21},{"key":"properties","mappedKey":"propertyIds","position":22},{"key":"options","mappedKey":"optionIds","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_product'),
('Z5sN"G>', 1, 'newsletter_recipient', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"email","mappedKey":"email","position":1},{"key":"title","mappedKey":"title","position":2},{"key":"salutation.salutationKey","mappedKey":"salutation","position":3},{"key":"firstName","mappedKey":"first_name","position":4},{"key":"lastName","mappedKey":"last_name","position":5},{"key":"zipCode","mappedKey":"zip_code","position":6},{"key":"city","mappedKey":"city","position":7},{"key":"street","mappedKey":"street","position":8},{"key":"status","mappedKey":"status","position":9},{"key":"hash","mappedKey":"hash","position":10},{"key":"salesChannel.id","mappedKey":"sales_channel_id","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_newsletter_recipient'),
('Z:pDEg	E', 1, 'product_configurator_setting', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"optionId","mappedKey":"option_id","position":2},{"key":"position","mappedKey":"position","position":3},{"key":"media.id","mappedKey":"media_id","position":4},{"key":"media.url","mappedKey":"media_url","position":5},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":6},{"key":"media.mediaType","mappedKey":"media_type","position":7},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":8},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":9},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":10},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_variant_configuration_settings'),
('Z>q둡Mi', 1, 'property_group_option', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"colorHexCode","mappedKey":"color_hex_code","position":1},{"key":"translations.DEFAULT.name","mappedKey":"name","position":2},{"key":"translations.DEFAULT.position","mappedKey":"position","position":3},{"key":"group.id","mappedKey":"group_id","position":4},{"key":"group.displayType","mappedKey":"group_display_type","position":5},{"key":"group.sortingType","mappedKey":"group_sorting_type","position":6},{"key":"group.translations.DEFAULT.name","mappedKey":"group_name","position":7},{"key":"group.translations.DEFAULT.description","mappedKey":"group_description","position":8},{"key":"group.translations.DEFAULT.position","mappedKey":"group_position","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15}]', NULL, '[[regtime_]]', NULL, NULL, 'default_properties'),
('[9q''ٞ', 1, 'product_cross_selling', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"translations.DEFAULT.name","mappedKey":"name","position":1},{"key":"productId","mappedKey":"product_id","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"position","mappedKey":"position","position":4},{"key":"limit","mappedKey":"limit","position":5},{"key":"type","mappedKey":"type","position":6},{"key":"sortBy","mappedKey":"sort_by","position":7},{"key":"sortDirection","mappedKey":"sort_direction","position":8},{"key":"assignedProducts","mappedKey":"assigned_products","position":9}]', NULL, '[[regtime_]]', NULL, NULL, 'default_cross_selling'),
('[:Kpޙw4', 1, 'customer', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"salutation.salutationKey","mappedKey":"salutation","position":1},{"key":"customerNumber","mappedKey":"customer_number","position":2},{"key":"firstName","mappedKey":"first_name","position":3},{"key":"lastName","mappedKey":"last_name","position":4},{"key":"email","mappedKey":"email","position":5},{"key":"active","mappedKey":"active","position":6},{"key":"guest","mappedKey":"guest","position":7},{"key":"group.translations.DEFAULT.name","mappedKey":"customer_group","position":8},{"key":"language.locale.code","mappedKey":"language","position":9},{"key":"salesChannel.translations.DEFAULT.name","mappedKey":"sales_channel","position":10},{"key":"defaultPaymentMethod.translations.DEFAULT.name","mappedKey":"payment_method","position":11},{"key":"defaultBillingAddress.id","mappedKey":"billing_id","position":12},{"key":"defaultBillingAddress.salutation.salutationKey","mappedKey":"billing_salutation","position":13},{"key":"defaultBillingAddress.title","mappedKey":"billing_title","position":14},{"key":"defaultBillingAddress.firstName","mappedKey":"billing_first_name","position":15},{"key":"defaultBillingAddress.lastName","mappedKey":"billing_last_name","position":16},{"key":"defaultBillingAddress.company","mappedKey":"billing_company","position":17},{"key":"defaultBillingAddress.street","mappedKey":"billing_street","position":18},{"key":"defaultBillingAddress.zipcode","mappedKey":"billing_zipcode","position":19},{"key":"defaultBillingAddress.city","mappedKey":"billing_city","position":20},{"key":"defaultBillingAddress.country.iso","mappedKey":"billing_country","position":21},{"key":"defaultBillingAddress.phoneNumber","mappedKey":"billing_phone_number","position":22},{"key":"defaultShippingAddress.id","mappedKey":"shipping_id","position":23},{"key":"defaultShippingAddress.salutation.salutationKey","mappedKey":"shipping_salutation","position":24},{"key":"defaultShippingAddress.title","mappedKey":"shipping_title","position":25},{"key":"defaultShippingAddress.firstName","mappedKey":"shipping_first_name","position":26},{"key":"defaultShippingAddress.lastName","mappedKey":"shipping_last_name","position":27},{"key":"defaultShippingAddress.company","mappedKey":"shipping_company","position":28},{"key":"defaultShippingAddress.street","mappedKey":"shipping_street","position":29},{"key":"defaultShippingAddress.zipcode","mappedKey":"shipping_zipcode","position":30},{"key":"defaultShippingAddress.city","mappedKey":"shipping_city","position":31},{"key":"defaultShippingAddress.country.iso","mappedKey":"shipping_country","position":32},{"key":"defaultShippingAddress.phoneNumber","mappedKey":"shipping_phone_number","position":33},{"key":"accountType","mappedKey":"account_type"}]', NULL, '[[regtime_]]', NULL, NULL, 'default_customer'),
('[=q*;y', 1, 'promotion_individual_code', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"code","mappedKey":"code","position":2}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_codes'),
('[>"qFv', 1, 'order', 'text/csv', ';', '"', 'export', '[{"key":"id","mappedKey":"id","position":0},{"key":"orderNumber","mappedKey":"order_number","position":1},{"key":"salesChannelId","mappedKey":"sales_channel_id","position":2},{"key":"orderCustomer.firstName","mappedKey":"customer_firstname","position":3},{"key":"orderCustomer.lastName","mappedKey":"customer_lastname","position":4},{"key":"orderCustomer.email","mappedKey":"customer_email","position":5},{"key":"billingAddress.street","mappedKey":"billing_address_street","position":6},{"key":"billingAddress.zipcode","mappedKey":"billing_address_zipcode","position":7},{"key":"billingAddress.city","mappedKey":"billing_address_city","position":8},{"key":"billingAddress.company","mappedKey":"billing_address_company","position":9},{"key":"billingAddress.department","mappedKey":"billing_address_department","position":10},{"key":"billingAddress.countryId","mappedKey":"billing_address_country_id","position":11},{"key":"billingAddress.countryStateId","mappedKey":"billing_address_country_state_id","position":12},{"key":"deliveries.shippingOrderAddress.street","mappedKey":"shipping_address_street","position":13},{"key":"deliveries.shippingOrderAddress.zipcode","mappedKey":"shipping_address_zipcode","position":14},{"key":"deliveries.shippingOrderAddress.city","mappedKey":"shipping_address_city","position":15},{"key":"deliveries.shippingOrderAddress.company","mappedKey":"shipping_address_company","position":16},{"key":"deliveries.shippingOrderAddress.department","mappedKey":"shipping_address_department","position":17},{"key":"deliveries.shippingOrderAddress.countryId","mappedKey":"shipping_address_country_id","position":18},{"key":"deliveries.shippingOrderAddress.countryStateId","mappedKey":"shipping_address_country_state_id","position":19},{"key":"amountTotal","mappedKey":"amount_total","position":20},{"key":"stateId","mappedKey":"order_state_id","position":21},{"key":"lineItems","mappedKey":"line_items","position":22},{"key":"orderDateTime","mappedKey":"order_date_time","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_orders'),
('[Pp#ᣯ5', 1, 'product_price', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"ruleId","mappedKey":"rule_id","position":2},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":3},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":4},{"key":"quantityStart","mappedKey":"quantity_start","position":5},{"key":"quantityEnd","mappedKey":"quantity_end","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_advanced_prices'),
('[P0q]d', 1, 'promotion_discount', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"scope","mappedKey":"scope","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"value","mappedKey":"value","position":4},{"key":"considerAdvancedRules","mappedKey":"consider_advanced_rules","position":5},{"key":"maxValue","mappedKey":"max_value","position":6},{"key":"sorterKey","mappedKey":"sorter_key","position":7,"useDefaultValue":true,"defaultValue":"PRICE_ASC"},{"key":"applierKey","mappedKey":"applier_key","position":8,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"usageKey","mappedKey":"usage_key","position":9,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"pickerKey","mappedKey":"picker_key","position":10},{"key":"discountRules","mappedKey":"discount_rules","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_discounts');

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile_translation`
--

CREATE TABLE `import_export_profile_translation` (
  `import_export_profile_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`import_export_profile_id`,`language_id`),
  KEY `fk.import_export_profile_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile_translation`
--

INSERT INTO `import_export_profile_translation` VALUES
('Zqh`', 'ZMp?X}', 'Standardprofil Kategorie', '[[regtime_]]', NULL),
('Zqh`', '/_MpXT|', 'Default category', '[[regtime_]]', NULL),
('ZpKS', 'ZMp?X}', 'Standardprofil Medien', '[[regtime_]]', NULL),
('ZpKS', '/_MpXT|', 'Default media', '[[regtime_]]', NULL),
('Zs]MQc', 'ZMp?X}', 'Standardprofil Produkt', '[[regtime_]]', NULL),
('Zs]MQc', '/_MpXT|', 'Default product', '[[regtime_]]', NULL),
('Z5sN"G>', 'ZMp?X}', 'Standardprofil Newsletter-Empfänger', '[[regtime_]]', NULL),
('Z5sN"G>', '/_MpXT|', 'Default newsletter recipient', '[[regtime_]]', NULL),
('Z:pDEg	E', 'ZMp?X}', 'Standardprofil Variantenkonfiguration', '[[regtime_]]', NULL),
('Z:pDEg	E', '/_MpXT|', 'Default variant configuration settings', '[[regtime_]]', NULL),
('Z>q둡Mi', 'ZMp?X}', 'Standardprofil Eigenschaften', '[[regtime_]]', NULL),
('Z>q둡Mi', '/_MpXT|', 'Default properties', '[[regtime_]]', NULL),
('[9q''ٞ', 'ZMp?X}', 'Standardprofil Cross-Selling', '[[regtime_]]', NULL),
('[9q''ٞ', '/_MpXT|', 'Default cross-selling', '[[regtime_]]', NULL),
('[:Kpޙw4', 'ZMp?X}', 'Standardprofil Kunde', '[[regtime_]]', NULL),
('[:Kpޙw4', '/_MpXT|', 'Default customer', '[[regtime_]]', NULL),
('[=q*;y', 'ZMp?X}', 'Standardprofil Aktionscodes', '[[regtime_]]', NULL),
('[=q*;y', '/_MpXT|', 'Default promotion codes', '[[regtime_]]', NULL),
('[>"qFv', 'ZMp?X}', 'Standardprofil Bestellungen', '[[regtime_]]', NULL),
('[>"qFv', '/_MpXT|', 'Default orders', '[[regtime_]]', NULL),
('[Pp#ᣯ5', 'ZMp?X}', 'Standardprofil Erweiterte Preise', '[[regtime_]]', NULL),
('[Pp#ᣯ5', '/_MpXT|', 'Default advanced prices', '[[regtime_]]', NULL),
('[P0q]d', 'ZMp?X}', 'Standardprofil Aktionsrabatte', '[[regtime_]]', NULL),
('[P0q]d', '/_MpXT|', 'Default promotion discounts', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `increment`
--

CREATE TABLE `increment` (
  `pool` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cluster` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`pool`,`cluster`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration`
--

CREATE TABLE `integration` (
  `id` binary(16) NOT NULL,
  `access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret_access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '1',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `last_usage_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.access_key` (`access_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration_role`
--

CREATE TABLE `integration_role` (
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  PRIMARY KEY (`integration_id`,`acl_role_id`),
  KEY `fk.integration_acl_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invalidation_tags`
--

CREATE TABLE `invalidation_tags` (
  `id` binary(16) NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page`
--

CREATE TABLE `landing_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.landing_page.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_sales_channel`
--

CREATE TABLE `landing_page_sales_channel` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`sales_channel_id`),
  KEY `fk.landing_page_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_tag`
--

CREATE TABLE `landing_page_tag` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`tag_id`),
  KEY `fk.landing_page_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_translation`
--

CREATE TABLE `landing_page_translation` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`language_id`),
  KEY `fk.landing_page_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` binary(16) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `locale_id` binary(16) NOT NULL,
  `translation_code_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx.language.translation_code_id` (`translation_code_id`),
  KEY `idx.language.language_id_parent_language_id` (`id`,`parent_id`),
  KEY `fk.language.parent_id` (`parent_id`),
  KEY `fk.language.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
('ZMp?X}', 'Deutsch', NULL, 'ZMp?X-:', 'ZMp?X-:', NULL, '[[regtime_]]', NULL, 1),
('/_MpXT|', 'English', NULL, 'ZMp?X', 'ZMp?X', NULL, '[[regtime_]]', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `locale`
--

CREATE TABLE `locale` (
  `id` binary(16) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale`
--

INSERT INTO `locale` VALUES
('ZMp?X', 'en-GB', '[[regtime_]]', NULL),
('ZMp?X-:', 'de-DE', '[[regtime_]]', NULL),
('ZN(qz`\n', 'aa-DJ', '[[regtime_]]', NULL),
('ZN(qz', 'aa-ER', '[[regtime_]]', NULL),
('ZN(qz;', 'aa-ET', '[[regtime_]]', NULL),
('ZN(q{d', 'af-NA', '[[regtime_]]', NULL),
('ZN(q{?m', 'af-ZA', '[[regtime_]]', NULL),
('ZN(q{s', 'ak-GH', '[[regtime_]]', NULL),
('ZN(q|', 'am-ET', '[[regtime_]]', NULL),
('ZN(q|0#', 'ar-AE', '[[regtime_]]', NULL),
('ZN(q}q', 'ar-BH', '[[regtime_]]', NULL),
('ZN(q~R', 'ar-DZ', '[[regtime_]]', NULL),
('ZN(q~', 'ar-EG', '[[regtime_]]', NULL),
('ZN(q''S', 'ar-IQ', '[[regtime_]]', NULL),
('ZN(q', 'ar-JO', '[[regtime_]]', NULL),
('ZN(qး', 'ar-KW', '[[regtime_]]', NULL),
('ZN(qy', 'ar-LB', '[[regtime_]]', NULL),
('ZN(qၩJ', 'ar-LY', '[[regtime_]]', NULL),
('ZN(q7N', 'ar-MA', '[[regtime_]]', NULL),
('ZN(q{D', 'ar-OM', '[[regtime_]]', NULL),
('ZN(qf', 'ar-QA', '[[regtime_]]', NULL),
('ZN(q{6', 'ar-SA', '[[regtime_]]', NULL),
('ZN(q܁', 'ar-SD', '[[regtime_]]', NULL),
('ZN(q', 'ar-SY', '[[regtime_]]', NULL),
('ZN(qWt', 'ar-TN', '[[regtime_]]', NULL),
('ZN(qi8', 'ar-YE', '[[regtime_]]', NULL),
('ZN(qᅍ,', 'as-IN', '[[regtime_]]', NULL),
('ZN(qᅥy', 'az-AZ', '[[regtime_]]', NULL),
('ZN(qm', 'be-BY', '[[regtime_]]', NULL),
('ZN(qWSb', 'bg-BG', '[[regtime_]]', NULL),
('ZN(qkj', 'bn-BD', '[[regtime_]]', NULL),
('ZN(q:b%', 'bn-IN', '[[regtime_]]', NULL),
('ZN(q', 'bo-CN', '[[regtime_]]', NULL),
('ZN(qQ', 'bo-IN', '[[regtime_]]', NULL),
('ZN(q[', 'bs-BA', '[[regtime_]]', NULL),
('ZN(q3', 'byn-ER', '[[regtime_]]', NULL),
('ZN(q', 'ca-ES', '[[regtime_]]', NULL),
('ZN(qዯg', 'cch-NG', '[[regtime_]]', NULL),
('ZN(qጎe', 'cs-CZ', '[[regtime_]]', NULL),
('ZN(qE', 'cy-GB', '[[regtime_]]', NULL),
('ZN(q:', 'da-DK', '[[regtime_]]', NULL),
('ZN(qthE', 'de-AT', '[[regtime_]]', NULL),
('ZN(q\0\Z', 'de-BE', '[[regtime_]]', NULL),
('ZN(q᎑', 'de-CH', '[[regtime_]]', NULL),
('ZN(q', 'de-LI', '[[regtime_]]', NULL),
('ZN(q', 'de-LU', '[[regtime_]]', NULL),
('ZN(qg', 'dv-MV', '[[regtime_]]', NULL),
('ZN(qᐎu-', 'dz-BT', '[[regtime_]]', NULL),
('ZN(q8', 'ee-GH', '[[regtime_]]', NULL),
('ZN(q0n', 'ee-TG', '[[regtime_]]', NULL),
('ZN(qIX', 'el-CY', '[[regtime_]]', NULL),
('ZN(qxՌ', 'el-GR', '[[regtime_]]', NULL),
('ZN(qJ', 'en-AS', '[[regtime_]]', NULL),
('ZN(qU', 'en-AU', '[[regtime_]]', NULL),
('ZN(q6', 'en-BE', '[[regtime_]]', NULL),
('ZN(qᔂ', 'en-BW', '[[regtime_]]', NULL),
('ZN(qw', 'en-BZ', '[[regtime_]]', NULL),
('ZN(qᕵ ', 'en-CA', '[[regtime_]]', NULL),
('ZN(q^[', 'en-GU', '[[regtime_]]', NULL),
('ZN(q', 'en-HK', '[[regtime_]]', NULL),
('ZN(qᗧk', 'en-IE', '[[regtime_]]', NULL),
('ZN(qᘇQ', 'en-IN', '[[regtime_]]', NULL),
('ZN(qᘩ', 'en-JM', '[[regtime_]]', NULL),
('ZN(q+', 'en-MH', '[[regtime_]]', NULL),
('ZN(q<', 'en-MP', '[[regtime_]]', NULL),
('ZN(qN', 'en-MT', '[[regtime_]]', NULL),
('ZN(qN', 'en-NA', '[[regtime_]]', NULL),
('ZN(qe', 'en-NZ', '[[regtime_]]', NULL),
('ZN(qћJ', 'en-PH', '[[regtime_]]', NULL),
('ZN(qᜓ', 'en-PK', '[[regtime_]]', NULL),
('ZN(q&', 'en-SG', '[[regtime_]]', NULL),
('ZN(qᝧF', 'en-TT', '[[regtime_]]', NULL),
('ZN(q\0#-', 'en-UM', '[[regtime_]]', NULL),
('ZN(qS', 'en-US', '[[regtime_]]', NULL),
('ZN(qJa', 'en-VI', '[[regtime_]]', NULL),
('ZN(qՍJ', 'en-ZA', '[[regtime_]]', NULL),
('ZN(q\r`', 'en-ZW', '[[regtime_]]', NULL),
('ZN(q"x', 'es-AR', '[[regtime_]]', NULL),
('ZN(qᡟ', 'es-BO', '[[regtime_]]', NULL),
('ZN(qc', 'es-CL', '[[regtime_]]', NULL),
('ZN(qT', 'es-CO', '[[regtime_]]', NULL),
('ZN(qfe', 'es-CR', '[[regtime_]]', NULL),
('ZN(qiQ', 'es-DO', '[[regtime_]]', NULL),
('ZN(qᢲ1`', 'es-EC', '[[regtime_]]', NULL),
('ZN(qᣱ*', 'es-ES', '[[regtime_]]', NULL),
('ZN(q''<', 'es-GT', '[[regtime_]]', NULL),
('ZN(qD', 'es-HN', '[[regtime_]]', NULL),
('ZN(qld', 'es-MX', '[[regtime_]]', NULL),
('ZN(q0V', 'es-NI', '[[regtime_]]', NULL),
('ZN)pdF', 'es-PA', '[[regtime_]]', NULL),
('ZN)pe', 'es-PE', '[[regtime_]]', NULL),
('ZN)peoF', 'es-PR', '[[regtime_]]', NULL),
('ZN)pe', 'es-PY', '[[regtime_]]', NULL),
('ZN)pe@', 'es-SV', '[[regtime_]]', NULL),
('ZN)pf?', 'es-US', '[[regtime_]]', NULL),
('ZN)pg', 'es-UY', '[[regtime_]]', NULL),
('ZN)pgvz', 'es-VE', '[[regtime_]]', NULL),
('ZN)phd', 'et-EE', '[[regtime_]]', NULL),
('ZN)ph`', 'eu-ES', '[[regtime_]]', NULL),
('ZN)pi~', 'fa-AF', '[[regtime_]]', NULL),
('ZN)piÅ', 'fa-IR', '[[regtime_]]', NULL),
('ZN)pj', 'fi-FI', '[[regtime_]]', NULL),
('ZN)pja)', 'fil-PH', '[[regtime_]]', NULL),
('ZN)pk', 'fo-FO', '[[regtime_]]', NULL),
('ZN)pk-', 'fr-BE', '[[regtime_]]', NULL),
('ZN)plj!', 'fr-CA', '[[regtime_]]', NULL),
('ZN)pl;\r', 'fr-CH', '[[regtime_]]', NULL),
('ZN)pmx', 'fr-FR', '[[regtime_]]', NULL),
('ZN)pm}', 'fr-LU', '[[regtime_]]', NULL),
('ZN)pmh', 'fr-MC', '[[regtime_]]', NULL),
('ZN)pm', 'fr-SN', '[[regtime_]]', NULL),
('ZN)pnU', 'fur-IT', '[[regtime_]]', NULL),
('ZN)pn|', 'ga-IE', '[[regtime_]]', NULL),
('ZN)pn&', 'gaa-GH', '[[regtime_]]', NULL),
('ZN)poT` ', 'gez-ER', '[[regtime_]]', NULL),
('ZN)po%', 'gez-ET', '[[regtime_]]', NULL),
('ZN)poچZ', 'gl-ES', '[[regtime_]]', NULL),
('ZN)po', 'gsw-CH', '[[regtime_]]', NULL),
('ZN)ppDt', 'gu-IN', '[[regtime_]]', NULL),
('ZN)pp', 'gv-GB', '[[regtime_]]', NULL),
('ZN)pq/', 'ha-GH', '[[regtime_]]', NULL),
('ZN)pqo-', 'ha-NE', '[[regtime_]]', NULL),
('ZN)pq]', 'ha-NG', '[[regtime_]]', NULL),
('ZN)prS', 'ha-SD', '[[regtime_]]', NULL),
('ZN)prb-', 'haw-US', '[[regtime_]]', NULL),
('ZN)prby*', 'he-IL', '[[regtime_]]', NULL),
('ZN)pr9', 'hi-IN', '[[regtime_]]', NULL),
('ZN)prg', 'hr-HR', '[[regtime_]]', NULL),
('ZN)ps7u', 'hu-HU', '[[regtime_]]', NULL),
('ZN)ps', 'hy-AM', '[[regtime_]]', NULL),
('ZN)ptd', 'id-ID', '[[regtime_]]', NULL),
('ZN)ptw', 'ig-NG', '[[regtime_]]', NULL),
('ZN)pt~Ri', 'ii-CN', '[[regtime_]]', NULL),
('ZN)pu0d', 'is-IS', '[[regtime_]]', NULL),
('ZN)puC', 'it-CH', '[[regtime_]]', NULL),
('ZN)pv+X', 'it-IT', '[[regtime_]]', NULL),
('ZN)pv|', 'ja-JP', '[[regtime_]]', NULL),
('ZN)pw', 'ka-GE', '[[regtime_]]', NULL),
('ZN)px\n', 'kaj-NG', '[[regtime_]]', NULL),
('ZN)px;', 'kam-KE', '[[regtime_]]', NULL),
('ZN)px:', 'kcg-NG', '[[regtime_]]', NULL),
('ZN)pxt', 'kfo-CI', '[[regtime_]]', NULL),
('ZN)py', 'kk-KZ', '[[regtime_]]', NULL),
('ZN)pyb', 'kl-GL', '[[regtime_]]', NULL),
('ZN)py', 'km-KH', '[[regtime_]]', NULL),
('ZN)pzk', 'kn-IN', '[[regtime_]]', NULL),
('ZN)p{X7', 'ko-KR', '[[regtime_]]', NULL),
('ZN)p|,', 'kok-IN', '[[regtime_]]', NULL),
('ZN)p|', 'kpe-GN', '[[regtime_]]', NULL),
('ZN)p}K', 'kpe-LR', '[[regtime_]]', NULL),
('ZN)p~s', 'ku-IQ', '[[regtime_]]', NULL),
('ZN)pV', 'ku-IR', '[[regtime_]]', NULL),
('ZN)p"T\\', 'ku-SY', '[[regtime_]]', NULL),
('ZN)p', 'ku-TR', '[[regtime_]]', NULL),
('ZN)pf|', 'kw-GB', '[[regtime_]]', NULL),
('ZN)pk', 'ky-KG', '[[regtime_]]', NULL),
('ZN)p ]', 'ln-CD', '[[regtime_]]', NULL),
('ZN)p''', 'ln-CG', '[[regtime_]]', NULL),
('ZN)p󂣻,', 'lo-LA', '[[regtime_]]', NULL),
('ZN)p(v', 'lt-LT', '[[regtime_]]', NULL),
('ZN)p^''', 'lv-LV', '[[regtime_]]', NULL),
('ZN)p', 'mk-MK', '[[regtime_]]', NULL),
('ZN)p-', 'ml-IN', '[[regtime_]]', NULL),
('ZN)pK', 'mn-CN', '[[regtime_]]', NULL),
('ZN)px', 'mn-MN', '[[regtime_]]', NULL),
('ZN)p:', 'mr-IN', '[[regtime_]]', NULL),
('ZN)pa', 'ms-BN', '[[regtime_]]', NULL),
('ZN)pA', 'ms-MY', '[[regtime_]]', NULL),
('ZN)pҷ', 'mt-MT', '[[regtime_]]', NULL),
('ZN)ph)', 'my-MM', '[[regtime_]]', NULL),
('ZN)p,_', 'nb-NO', '[[regtime_]]', NULL),
('ZN)p|', 'nds-DE', '[[regtime_]]', NULL),
('ZN)p/H', 'ne-IN', '[[regtime_]]', NULL),
('ZN)p|N', 'ne-NP', '[[regtime_]]', NULL),
('ZN)p\0', 'nl-BE', '[[regtime_]]', NULL),
('ZN)pH', 'nl-NL', '[[regtime_]]', NULL),
('ZN)p`', 'nn-NO', '[[regtime_]]', NULL),
('ZN)p2', 'nr-ZA', '[[regtime_]]', NULL),
('ZN)p', 'nso-ZA', '[[regtime_]]', NULL),
('ZN)p''a', 'ny-MW', '[[regtime_]]', NULL),
('ZN)p0̳', 'oc-FR', '[[regtime_]]', NULL),
('ZN)p,', 'om-ET', '[[regtime_]]', NULL),
('ZN)pH', 'om-KE', '[[regtime_]]', NULL),
('ZN)p=#/', 'or-IN', '[[regtime_]]', NULL),
('ZN)pR', 'pa-IN', '[[regtime_]]', NULL),
('ZN)pFA', 'pa-PK', '[[regtime_]]', NULL),
('ZN)p''I', 'pl-PL', '[[regtime_]]', NULL),
('ZN)p', 'ps-AF', '[[regtime_]]', NULL),
('ZN)p', 'pt-BR', '[[regtime_]]', NULL),
('ZN)p', 'pt-PT', '[[regtime_]]', NULL),
('ZN)p', 'ro-MD', '[[regtime_]]', NULL),
('ZN)p{', 'ro-RO', '[[regtime_]]', NULL),
('ZN)p1', 'ru-RU', '[[regtime_]]', NULL),
('ZN)pu', 'ru-UA', '[[regtime_]]', NULL),
('ZN)pcE', 'rw-RW', '[[regtime_]]', NULL),
('ZN)p]x', 'sa-IN', '[[regtime_]]', NULL),
('ZN)pK', 'se-FI', '[[regtime_]]', NULL),
('ZN)pɧ', 'se-NO', '[[regtime_]]', NULL),
('ZN)pi', 'sh-BA', '[[regtime_]]', NULL),
('ZN)p9', 'sh-CS', '[[regtime_]]', NULL),
('ZN)p,', 'si-LK', '[[regtime_]]', NULL),
('ZN)pj', 'sid-ET', '[[regtime_]]', NULL),
('ZN)pK', 'sk-SK', '[[regtime_]]', NULL),
('ZN)p', 'sl-SI', '[[regtime_]]', NULL),
('ZN)p3', 'so-DJ', '[[regtime_]]', NULL),
('ZN)pf', 'so-ET', '[[regtime_]]', NULL),
('ZN)p', 'so-KE', '[[regtime_]]', NULL),
('ZN)pX/', 'so-SO', '[[regtime_]]', NULL),
('ZN)pb', 'sq-AL', '[[regtime_]]', NULL),
('ZN)pv', 'sr-BA', '[[regtime_]]', NULL),
('ZN)p󝪓H', 'sr-CS', '[[regtime_]]', NULL),
('ZN)pG', 'sr-ME', '[[regtime_]]', NULL),
('ZN)p\r', 'sr-RS', '[[regtime_]]', NULL),
('ZN)p', 'ss-SZ', '[[regtime_]]', NULL),
('ZN)ps', 'ss-ZA', '[[regtime_]]', NULL),
('ZN)p2', 'st-LS', '[[regtime_]]', NULL),
('ZN)p|n', 'st-ZA', '[[regtime_]]', NULL),
('ZN)p3', 'sv-FI', '[[regtime_]]', NULL),
('ZN)p', 'sv-SE', '[[regtime_]]', NULL),
('ZN)p_', 'sw-KE', '[[regtime_]]', NULL),
('ZN)p.&', 'sw-TZ', '[[regtime_]]', NULL),
('ZN)pyi', 'syr-SY', '[[regtime_]]', NULL),
('ZN)p=L', 'ta-IN', '[[regtime_]]', NULL),
('ZN)p-', 'te-IN', '[[regtime_]]', NULL),
('ZN)p>E', 'tg-TJ', '[[regtime_]]', NULL),
('ZN)p>', 'th-TH', '[[regtime_]]', NULL),
('ZN)pb>', 'ti-ER', '[[regtime_]]', NULL),
('ZN)p9<', 'ti-ET', '[[regtime_]]', NULL),
('ZN)p"', 'tig-ER', '[[regtime_]]', NULL),
('ZN)p*', 'tn-ZA', '[[regtime_]]', NULL),
('ZN)p\Z', 'to-TO', '[[regtime_]]', NULL),
('ZN)p.', 'tr-TR', '[[regtime_]]', NULL),
('ZN)pUr', 'ts-ZA', '[[regtime_]]', NULL),
('ZN)p_', 'tt-RU', '[[regtime_]]', NULL),
('ZN)p>', 'ug-CN', '[[regtime_]]', NULL),
('ZN)p\r{', 'uk-UA', '[[regtime_]]', NULL),
('ZN)pM', 'ur-IN', '[[regtime_]]', NULL),
('ZN)p', 'ur-PK', '[[regtime_]]', NULL),
('ZN)pok', 'uz-AF', '[[regtime_]]', NULL),
('ZN)pz_', 'uz-UZ', '[[regtime_]]', NULL),
('ZN)pg2', 've-ZA', '[[regtime_]]', NULL),
('ZN)pC', 'vi-VN', '[[regtime_]]', NULL),
('ZN)pֆ', 'wal-ET', '[[regtime_]]', NULL),
('ZN)pkZ', 'wo-SN', '[[regtime_]]', NULL),
('ZN)p1', 'xh-ZA', '[[regtime_]]', NULL),
('ZN)p,%', 'yo-NG', '[[regtime_]]', NULL),
('ZN)p9', 'zh-CN', '[[regtime_]]', NULL),
('ZN*s2?', 'zh-HK', '[[regtime_]]', NULL),
('ZN*s2ʴ', 'zh-MO', '[[regtime_]]', NULL),
('ZN*s2ˀwe', 'zh-SG', '[[regtime_]]', NULL),
('ZN*s2\rȨ', 'zh-TW', '[[regtime_]]', NULL),
('ZN*s2̿g', 'zu-ZA', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale_translation`
--

CREATE TABLE `locale_translation` (
  `locale_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `territory` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`locale_id`,`language_id`),
  KEY `fk.locale_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale_translation`
--

INSERT INTO `locale_translation` VALUES
('ZMp?X', 'ZMp?X}', 'Englisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('ZMp?X', '/_MpXT|', 'English', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('ZMp?X-:', 'ZMp?X}', 'Deutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('ZMp?X-:', '/_MpXT|', 'German', 'Germany', NULL, '[[regtime_]]', NULL),
('ZN(qz`\n', 'ZMp?X}', 'Afar', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('ZN(qz`\n', '/_MpXT|', 'Afar', 'Djibouti', NULL, '[[regtime_]]', NULL),
('ZN(qz', 'ZMp?X}', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN(qz', '/_MpXT|', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN(qz;', 'ZMp?X}', 'Afar', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN(qz;', '/_MpXT|', 'Afar', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN(q{d', 'ZMp?X}', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('ZN(q{d', '/_MpXT|', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('ZN(q{?m', 'ZMp?X}', 'Afrikaans', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN(q{?m', '/_MpXT|', 'Afrikaans', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN(q{s', 'ZMp?X}', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN(q{s', '/_MpXT|', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN(q|', 'ZMp?X}', 'Amharisch', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN(q|', '/_MpXT|', 'Amharic', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN(q|0#', 'ZMp?X}', 'Arabisch', 'Vereinigte Arabische Emirate', NULL, '[[regtime_]]', NULL),
('ZN(q|0#', '/_MpXT|', 'Arabic', 'United Arab Emirates', NULL, '[[regtime_]]', NULL),
('ZN(q}q', 'ZMp?X}', 'Arabisch', 'Bahrain', NULL, '[[regtime_]]', NULL),
('ZN(q}q', '/_MpXT|', 'Arabic', 'Bahrain', NULL, '[[regtime_]]', NULL),
('ZN(q~R', 'ZMp?X}', 'Arabisch', 'Algerien', NULL, '[[regtime_]]', NULL),
('ZN(q~R', '/_MpXT|', 'Arabic', 'Algeria', NULL, '[[regtime_]]', NULL),
('ZN(q~', 'ZMp?X}', 'Arabisch', 'Ägypten', NULL, '[[regtime_]]', NULL),
('ZN(q~', '/_MpXT|', 'Arabic', 'Egypt', NULL, '[[regtime_]]', NULL),
('ZN(q''S', 'ZMp?X}', 'Arabisch', 'Irak', NULL, '[[regtime_]]', NULL),
('ZN(q''S', '/_MpXT|', 'Arabic', 'Iraq', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Arabisch', 'Jordanien', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'Arabic', 'Jordan', NULL, '[[regtime_]]', NULL),
('ZN(qး', 'ZMp?X}', 'Arabisch', 'Kuwait', NULL, '[[regtime_]]', NULL),
('ZN(qး', '/_MpXT|', 'Arabic', 'Kuwait', NULL, '[[regtime_]]', NULL),
('ZN(qy', 'ZMp?X}', 'Arabisch', 'Libanon', NULL, '[[regtime_]]', NULL),
('ZN(qy', '/_MpXT|', 'Arabic', 'Lebanon', NULL, '[[regtime_]]', NULL),
('ZN(qၩJ', 'ZMp?X}', 'Arabisch', 'Libyen', NULL, '[[regtime_]]', NULL),
('ZN(qၩJ', '/_MpXT|', 'Arabic', 'Libya', NULL, '[[regtime_]]', NULL),
('ZN(q7N', 'ZMp?X}', 'Arabisch', 'Marokko', NULL, '[[regtime_]]', NULL),
('ZN(q7N', '/_MpXT|', 'Arabic', 'Morocco', NULL, '[[regtime_]]', NULL),
('ZN(q{D', 'ZMp?X}', 'Arabisch', 'Oman', NULL, '[[regtime_]]', NULL),
('ZN(q{D', '/_MpXT|', 'Arabic', 'Oman', NULL, '[[regtime_]]', NULL),
('ZN(qf', 'ZMp?X}', 'Arabisch', 'Katar', NULL, '[[regtime_]]', NULL),
('ZN(qf', '/_MpXT|', 'Arabic', 'Qatar', NULL, '[[regtime_]]', NULL),
('ZN(q{6', 'ZMp?X}', 'Arabisch', 'Saudi-Arabien', NULL, '[[regtime_]]', NULL),
('ZN(q{6', '/_MpXT|', 'Arabic', 'Saudi Arabia', NULL, '[[regtime_]]', NULL),
('ZN(q܁', 'ZMp?X}', 'Arabisch', 'Sudan', NULL, '[[regtime_]]', NULL),
('ZN(q܁', '/_MpXT|', 'Arabic', 'Sudan', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Arabisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'Arabic', 'Syria', NULL, '[[regtime_]]', NULL),
('ZN(qWt', 'ZMp?X}', 'Arabisch', 'Tunesien', NULL, '[[regtime_]]', NULL),
('ZN(qWt', '/_MpXT|', 'Arabic', 'Tunisia', NULL, '[[regtime_]]', NULL),
('ZN(qi8', 'ZMp?X}', 'Arabisch', 'Jemen', NULL, '[[regtime_]]', NULL),
('ZN(qi8', '/_MpXT|', 'Arabic', 'Yemen', NULL, '[[regtime_]]', NULL),
('ZN(qᅍ,', 'ZMp?X}', 'Assamesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN(qᅍ,', '/_MpXT|', 'Assamese', 'India', NULL, '[[regtime_]]', NULL),
('ZN(qᅥy', 'ZMp?X}', 'Aserbaidschanisch', 'Aserbaidschan', NULL, '[[regtime_]]', NULL),
('ZN(qᅥy', '/_MpXT|', 'Azerbaijani', 'Azerbaijan', NULL, '[[regtime_]]', NULL),
('ZN(qm', 'ZMp?X}', 'Weißrussisch', 'Belarus', NULL, '[[regtime_]]', NULL),
('ZN(qm', '/_MpXT|', 'Belarusian', 'Belarus', NULL, '[[regtime_]]', NULL),
('ZN(qWSb', 'ZMp?X}', 'Bulgarisch', 'Bulgarien', NULL, '[[regtime_]]', NULL),
('ZN(qWSb', '/_MpXT|', 'Bulgarian', 'Bulgaria', NULL, '[[regtime_]]', NULL),
('ZN(qkj', 'ZMp?X}', 'Bengalisch', 'Bangladesch', NULL, '[[regtime_]]', NULL),
('ZN(qkj', '/_MpXT|', 'Bengali', 'Bangladesh', NULL, '[[regtime_]]', NULL),
('ZN(q:b%', 'ZMp?X}', 'Bengalisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN(q:b%', '/_MpXT|', 'Bengali', 'India', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Tibetisch', 'China', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'Tibetan', 'China', NULL, '[[regtime_]]', NULL),
('ZN(qQ', 'ZMp?X}', 'Tibetisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN(qQ', '/_MpXT|', 'Tibetan', 'India', NULL, '[[regtime_]]', NULL),
('ZN(q[', 'ZMp?X}', 'Bosnisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('ZN(q[', '/_MpXT|', 'Bosnian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('ZN(q3', 'ZMp?X}', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN(q3', '/_MpXT|', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Katalanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'Catalan', 'Spain', NULL, '[[regtime_]]', NULL),
('ZN(qዯg', 'ZMp?X}', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN(qዯg', '/_MpXT|', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN(qጎe', 'ZMp?X}', 'Tschechisch', 'Tschechische Republik', NULL, '[[regtime_]]', NULL),
('ZN(qጎe', '/_MpXT|', 'Czech', 'Czech Republic', NULL, '[[regtime_]]', NULL),
('ZN(qE', 'ZMp?X}', 'Walisisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('ZN(qE', '/_MpXT|', 'Welsh', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('ZN(q:', 'ZMp?X}', 'Dänisch', 'Dänemark', NULL, '[[regtime_]]', NULL),
('ZN(q:', '/_MpXT|', 'Danish', 'Denmark', NULL, '[[regtime_]]', NULL),
('ZN(qthE', 'ZMp?X}', 'Deutsch', 'Österreich', NULL, '[[regtime_]]', NULL),
('ZN(qthE', '/_MpXT|', 'German', 'Austria', NULL, '[[regtime_]]', NULL),
('ZN(q\0\Z', 'ZMp?X}', 'Deutsch', 'Belgien', NULL, '[[regtime_]]', NULL),
('ZN(q\0\Z', '/_MpXT|', 'German', 'Belgium', NULL, '[[regtime_]]', NULL),
('ZN(q᎑', 'ZMp?X}', 'Deutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('ZN(q᎑', '/_MpXT|', 'German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Deutsch', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'German', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Deutsch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'German', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('ZN(qg', 'ZMp?X}', 'Maledivisch', 'Malediven', NULL, '[[regtime_]]', NULL),
('ZN(qg', '/_MpXT|', 'Maldivian', 'Maldive Islands', NULL, '[[regtime_]]', NULL),
('ZN(qᐎu-', 'ZMp?X}', 'Bhutanisch', 'Bhutan', NULL, '[[regtime_]]', NULL),
('ZN(qᐎu-', '/_MpXT|', 'Bhutanese', 'Bhutan', NULL, '[[regtime_]]', NULL),
('ZN(q8', 'ZMp?X}', 'Ewe-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN(q8', '/_MpXT|', 'Ewe', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN(q0n', 'ZMp?X}', 'Ewe-Sprache', 'Togo', NULL, '[[regtime_]]', NULL),
('ZN(q0n', '/_MpXT|', 'Ewe', 'Togo', NULL, '[[regtime_]]', NULL),
('ZN(qIX', 'ZMp?X}', 'Griechisch', 'Zypern', NULL, '[[regtime_]]', NULL),
('ZN(qIX', '/_MpXT|', 'Greek', 'Cyprus', NULL, '[[regtime_]]', NULL),
('ZN(qxՌ', 'ZMp?X}', 'Griechisch', 'Griechenland', NULL, '[[regtime_]]', NULL),
('ZN(qxՌ', '/_MpXT|', 'Greek', 'Greece', NULL, '[[regtime_]]', NULL),
('ZN(qJ', 'ZMp?X}', 'Englisch', 'Amerikanisch-Samoa', NULL, '[[regtime_]]', NULL),
('ZN(qJ', '/_MpXT|', 'English', 'American Samoa', NULL, '[[regtime_]]', NULL),
('ZN(qU', 'ZMp?X}', 'Englisch', 'Australien', NULL, '[[regtime_]]', NULL),
('ZN(qU', '/_MpXT|', 'English', 'Australia', NULL, '[[regtime_]]', NULL),
('ZN(q6', 'ZMp?X}', 'Englisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('ZN(q6', '/_MpXT|', 'English', 'Belgium', NULL, '[[regtime_]]', NULL),
('ZN(qᔂ', 'ZMp?X}', 'Englisch', 'Botsuana', NULL, '[[regtime_]]', NULL),
('ZN(qᔂ', '/_MpXT|', 'English', 'Botswana', NULL, '[[regtime_]]', NULL),
('ZN(qw', 'ZMp?X}', 'Englisch', 'Belize', NULL, '[[regtime_]]', NULL),
('ZN(qw', '/_MpXT|', 'English', 'Belize', NULL, '[[regtime_]]', NULL),
('ZN(qᕵ ', 'ZMp?X}', 'Englisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('ZN(qᕵ ', '/_MpXT|', 'English', 'Canada', NULL, '[[regtime_]]', NULL),
('ZN(q^[', 'ZMp?X}', 'Englisch', 'Guam', NULL, '[[regtime_]]', NULL),
('ZN(q^[', '/_MpXT|', 'English', 'Guam', NULL, '[[regtime_]]', NULL),
('ZN(q', 'ZMp?X}', 'Englisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('ZN(q', '/_MpXT|', 'English', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('ZN(qᗧk', 'ZMp?X}', 'Englisch', 'Irland', NULL, '[[regtime_]]', NULL),
('ZN(qᗧk', '/_MpXT|', 'English', 'Ireland', NULL, '[[regtime_]]', NULL),
('ZN(qᘇQ', 'ZMp?X}', 'Englisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN(qᘇQ', '/_MpXT|', 'English', 'India', NULL, '[[regtime_]]', NULL),
('ZN(qᘩ', 'ZMp?X}', 'Englisch', 'Jamaika', NULL, '[[regtime_]]', NULL),
('ZN(qᘩ', '/_MpXT|', 'English', 'Jamaica', NULL, '[[regtime_]]', NULL),
('ZN(q+', 'ZMp?X}', 'Englisch', 'Marshallinseln', NULL, '[[regtime_]]', NULL),
('ZN(q+', '/_MpXT|', 'English', 'Marshall Islands', NULL, '[[regtime_]]', NULL),
('ZN(q<', 'ZMp?X}', 'Englisch', 'Nördliche Marianen', NULL, '[[regtime_]]', NULL),
('ZN(q<', '/_MpXT|', 'English', 'Northern Mariana Islands', NULL, '[[regtime_]]', NULL),
('ZN(qN', 'ZMp?X}', 'Englisch', 'Malta', NULL, '[[regtime_]]', NULL),
('ZN(qN', '/_MpXT|', 'English', 'Malta', NULL, '[[regtime_]]', NULL),
('ZN(qN', 'ZMp?X}', 'Englisch', 'Namibia', NULL, '[[regtime_]]', NULL),
('ZN(qN', '/_MpXT|', 'English', 'Namibia', NULL, '[[regtime_]]', NULL),
('ZN(qe', 'ZMp?X}', 'Englisch', 'Neuseeland', NULL, '[[regtime_]]', NULL),
('ZN(qe', '/_MpXT|', 'English', 'New Zealand', NULL, '[[regtime_]]', NULL),
('ZN(qћJ', 'ZMp?X}', 'Englisch', 'Philippinen', NULL, '[[regtime_]]', NULL),
('ZN(qћJ', '/_MpXT|', 'English', 'Philippines', NULL, '[[regtime_]]', NULL),
('ZN(qᜓ', 'ZMp?X}', 'Englisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('ZN(qᜓ', '/_MpXT|', 'English', 'Pakistan', NULL, '[[regtime_]]', NULL),
('ZN(q&', 'ZMp?X}', 'Englisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('ZN(q&', '/_MpXT|', 'English', 'Singapore', NULL, '[[regtime_]]', NULL),
('ZN(qᝧF', 'ZMp?X}', 'Englisch', 'Trinidad und Tobago', NULL, '[[regtime_]]', NULL),
('ZN(qᝧF', '/_MpXT|', 'English', 'Trinidad and Tobago', NULL, '[[regtime_]]', NULL),
('ZN(q\0#-', 'ZMp?X}', 'Englisch', 'Amerikanisch-Ozeanien', NULL, '[[regtime_]]', NULL),
('ZN(q\0#-', '/_MpXT|', 'English', 'U.S. Minor Outlying Islands', NULL, '[[regtime_]]', NULL),
('ZN(qS', 'ZMp?X}', 'Englisch (US)', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('ZN(qS', '/_MpXT|', 'English (US)', 'United States', NULL, '[[regtime_]]', NULL),
('ZN(qJa', 'ZMp?X}', 'Englisch', 'Amerikanische Jungferninseln', NULL, '[[regtime_]]', NULL),
('ZN(qJa', '/_MpXT|', 'English', 'American Virgin Islands', NULL, '[[regtime_]]', NULL),
('ZN(qՍJ', 'ZMp?X}', 'Englisch', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN(qՍJ', '/_MpXT|', 'English', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN(q\r`', 'ZMp?X}', 'Englisch', 'Simbabwe', NULL, '[[regtime_]]', NULL),
('ZN(q\r`', '/_MpXT|', 'English', 'Zimbabwe', NULL, '[[regtime_]]', NULL),
('ZN(q"x', 'ZMp?X}', 'Spanisch', 'Argentinien', NULL, '[[regtime_]]', NULL),
('ZN(q"x', '/_MpXT|', 'Spanish', 'Argentina', NULL, '[[regtime_]]', NULL),
('ZN(qᡟ', 'ZMp?X}', 'Spanisch', 'Bolivien', NULL, '[[regtime_]]', NULL),
('ZN(qᡟ', '/_MpXT|', 'Spanish', 'Bolivia', NULL, '[[regtime_]]', NULL),
('ZN(qc', 'ZMp?X}', 'Spanisch', 'Chile', NULL, '[[regtime_]]', NULL),
('ZN(qc', '/_MpXT|', 'Spanish', 'Chile', NULL, '[[regtime_]]', NULL),
('ZN(qT', 'ZMp?X}', 'Spanisch', 'Kolumbien', NULL, '[[regtime_]]', NULL),
('ZN(qT', '/_MpXT|', 'Spanish', 'Colombia', NULL, '[[regtime_]]', NULL),
('ZN(qfe', 'ZMp?X}', 'Spanisch', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('ZN(qfe', '/_MpXT|', 'Spanish', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('ZN(qiQ', 'ZMp?X}', 'Spanisch', 'Dominikanische Republik', NULL, '[[regtime_]]', NULL),
('ZN(qiQ', '/_MpXT|', 'Spanish', 'Dominican Republic', NULL, '[[regtime_]]', NULL),
('ZN(qᢲ1`', 'ZMp?X}', 'Spanisch', 'Ecuador', NULL, '[[regtime_]]', NULL),
('ZN(qᢲ1`', '/_MpXT|', 'Spanish', 'Ecuador', NULL, '[[regtime_]]', NULL),
('ZN(qᣱ*', 'ZMp?X}', 'Spanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('ZN(qᣱ*', '/_MpXT|', 'Spanish', 'Spain', NULL, '[[regtime_]]', NULL),
('ZN(q''<', 'ZMp?X}', 'Spanisch', 'Guatemala', NULL, '[[regtime_]]', NULL),
('ZN(q''<', '/_MpXT|', 'Spanish', 'Guatemala', NULL, '[[regtime_]]', NULL),
('ZN(qD', 'ZMp?X}', 'Spanisch', 'Honduras', NULL, '[[regtime_]]', NULL),
('ZN(qD', '/_MpXT|', 'Spanish', 'Honduras', NULL, '[[regtime_]]', NULL),
('ZN(qld', 'ZMp?X}', 'Spanisch', 'Mexiko', NULL, '[[regtime_]]', NULL),
('ZN(qld', '/_MpXT|', 'Spanish', 'Mexico', NULL, '[[regtime_]]', NULL),
('ZN(q0V', 'ZMp?X}', 'Spanisch', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('ZN(q0V', '/_MpXT|', 'Spanish', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('ZN)pdF', 'ZMp?X}', 'Spanisch', 'Panama', NULL, '[[regtime_]]', NULL),
('ZN)pdF', '/_MpXT|', 'Spanish', 'Panama', NULL, '[[regtime_]]', NULL),
('ZN)pe', 'ZMp?X}', 'Spanisch', 'Peru', NULL, '[[regtime_]]', NULL),
('ZN)pe', '/_MpXT|', 'Spanish', 'Peru', NULL, '[[regtime_]]', NULL),
('ZN)peoF', 'ZMp?X}', 'Spanisch', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('ZN)peoF', '/_MpXT|', 'Spanish', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('ZN)pe', 'ZMp?X}', 'Spanisch', 'Paraguay', NULL, '[[regtime_]]', NULL),
('ZN)pe', '/_MpXT|', 'Spanish', 'Paraguay', NULL, '[[regtime_]]', NULL),
('ZN)pe@', 'ZMp?X}', 'Spanisch', 'El Salvador', NULL, '[[regtime_]]', NULL),
('ZN)pe@', '/_MpXT|', 'Spanish', 'El Salvador', NULL, '[[regtime_]]', NULL),
('ZN)pf?', 'ZMp?X}', 'Spanisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('ZN)pf?', '/_MpXT|', 'Spanish', 'United States', NULL, '[[regtime_]]', NULL),
('ZN)pg', 'ZMp?X}', 'Spanisch', 'Uruguay', NULL, '[[regtime_]]', NULL),
('ZN)pg', '/_MpXT|', 'Spanish', 'Uruguay', NULL, '[[regtime_]]', NULL),
('ZN)pgvz', 'ZMp?X}', 'Spanisch', 'Venezuela', NULL, '[[regtime_]]', NULL),
('ZN)pgvz', '/_MpXT|', 'Spanish', 'Venezuela', NULL, '[[regtime_]]', NULL),
('ZN)phd', 'ZMp?X}', 'Estnisch', 'Estland', NULL, '[[regtime_]]', NULL),
('ZN)phd', '/_MpXT|', 'Estonian', 'Estonia', NULL, '[[regtime_]]', NULL),
('ZN)ph`', 'ZMp?X}', 'Baskisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('ZN)ph`', '/_MpXT|', 'Basque', 'Spain', NULL, '[[regtime_]]', NULL),
('ZN)pi~', 'ZMp?X}', 'Persisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('ZN)pi~', '/_MpXT|', 'Persian', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('ZN)piÅ', 'ZMp?X}', 'Persisch', 'Iran', NULL, '[[regtime_]]', NULL),
('ZN)piÅ', '/_MpXT|', 'Persian', 'Iran', NULL, '[[regtime_]]', NULL),
('ZN)pj', 'ZMp?X}', 'Finnisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('ZN)pj', '/_MpXT|', 'Finnish', 'Finland', NULL, '[[regtime_]]', NULL),
('ZN)pja)', 'ZMp?X}', 'Filipino', 'Philippinen', NULL, '[[regtime_]]', NULL),
('ZN)pja)', '/_MpXT|', 'Filipino', 'Philippines', NULL, '[[regtime_]]', NULL),
('ZN)pk', 'ZMp?X}', 'Färöisch', 'Färöer', NULL, '[[regtime_]]', NULL),
('ZN)pk', '/_MpXT|', 'Faeroese', 'Faeroe Islands', NULL, '[[regtime_]]', NULL),
('ZN)pk-', 'ZMp?X}', 'Französisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('ZN)pk-', '/_MpXT|', 'French', 'Belgium', NULL, '[[regtime_]]', NULL),
('ZN)plj!', 'ZMp?X}', 'Französisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('ZN)plj!', '/_MpXT|', 'French', 'Canada', NULL, '[[regtime_]]', NULL),
('ZN)pl;\r', 'ZMp?X}', 'Französisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('ZN)pl;\r', '/_MpXT|', 'French', 'Switzerland', NULL, '[[regtime_]]', NULL),
('ZN)pmx', 'ZMp?X}', 'Französisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('ZN)pmx', '/_MpXT|', 'French', 'France', NULL, '[[regtime_]]', NULL),
('ZN)pm}', 'ZMp?X}', 'Französisch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('ZN)pm}', '/_MpXT|', 'French', 'Luxembourg', NULL, '[[regtime_]]', NULL),
('ZN)pmh', 'ZMp?X}', 'Französisch', 'Monaco', NULL, '[[regtime_]]', NULL),
('ZN)pmh', '/_MpXT|', 'French', 'Monaco', NULL, '[[regtime_]]', NULL),
('ZN)pm', 'ZMp?X}', 'Französisch', 'Senegal', NULL, '[[regtime_]]', NULL),
('ZN)pm', '/_MpXT|', 'French', 'Senegal', NULL, '[[regtime_]]', NULL),
('ZN)pnU', 'ZMp?X}', 'Friulisch', 'Italien', NULL, '[[regtime_]]', NULL),
('ZN)pnU', '/_MpXT|', 'Friulian', 'Italy', NULL, '[[regtime_]]', NULL),
('ZN)pn|', 'ZMp?X}', 'Irisch', 'Irland', NULL, '[[regtime_]]', NULL),
('ZN)pn|', '/_MpXT|', 'Irish', 'Ireland', NULL, '[[regtime_]]', NULL),
('ZN)pn&', 'ZMp?X}', 'Ga-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN)pn&', '/_MpXT|', 'Ga', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN)poT` ', 'ZMp?X}', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN)poT` ', '/_MpXT|', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN)po%', 'ZMp?X}', 'Geez', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN)po%', '/_MpXT|', 'Geez', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN)poچZ', 'ZMp?X}', 'Galizisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('ZN)poچZ', '/_MpXT|', 'Galician', 'Spain', NULL, '[[regtime_]]', NULL),
('ZN)po', 'ZMp?X}', 'Schweizerdeutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('ZN)po', '/_MpXT|', 'Swiss German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('ZN)ppDt', 'ZMp?X}', 'Gujarati', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)ppDt', '/_MpXT|', 'Gujarati', 'India', NULL, '[[regtime_]]', NULL),
('ZN)pp', 'ZMp?X}', 'Manx', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('ZN)pp', '/_MpXT|', 'Manx', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('ZN)pq/', 'ZMp?X}', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN)pq/', '/_MpXT|', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('ZN)pqo-', 'ZMp?X}', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('ZN)pqo-', '/_MpXT|', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('ZN)pq]', 'ZMp?X}', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)pq]', '/_MpXT|', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)prS', 'ZMp?X}', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('ZN)prS', '/_MpXT|', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('ZN)prb-', 'ZMp?X}', 'Hawaiisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('ZN)prb-', '/_MpXT|', 'Hawaiian', 'United States', NULL, '[[regtime_]]', NULL),
('ZN)prby*', 'ZMp?X}', 'Hebräisch', 'Israel', NULL, '[[regtime_]]', NULL),
('ZN)prby*', '/_MpXT|', 'Hebrew', 'Israel', NULL, '[[regtime_]]', NULL),
('ZN)pr9', 'ZMp?X}', 'Hindi', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)pr9', '/_MpXT|', 'Hindi', 'India', NULL, '[[regtime_]]', NULL),
('ZN)prg', 'ZMp?X}', 'Kroatisch', 'Kroatien', NULL, '[[regtime_]]', NULL),
('ZN)prg', '/_MpXT|', 'Croatian', 'Croatia', NULL, '[[regtime_]]', NULL),
('ZN)ps7u', 'ZMp?X}', 'Ungarisch', 'Ungarn', NULL, '[[regtime_]]', NULL),
('ZN)ps7u', '/_MpXT|', 'Hungarian', 'Hungary', NULL, '[[regtime_]]', NULL),
('ZN)ps', 'ZMp?X}', 'Armenisch', 'Armenien', NULL, '[[regtime_]]', NULL),
('ZN)ps', '/_MpXT|', 'Armenian', 'Armenia', NULL, '[[regtime_]]', NULL),
('ZN)ptd', 'ZMp?X}', 'Indonesisch', 'Indonesien', NULL, '[[regtime_]]', NULL),
('ZN)ptd', '/_MpXT|', 'Indonesian', 'Indonesia', NULL, '[[regtime_]]', NULL),
('ZN)ptw', 'ZMp?X}', 'Igbo-Sprache', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)ptw', '/_MpXT|', 'Igbo', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)pt~Ri', 'ZMp?X}', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('ZN)pt~Ri', '/_MpXT|', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('ZN)pu0d', 'ZMp?X}', 'Isländisch', 'Island', NULL, '[[regtime_]]', NULL),
('ZN)pu0d', '/_MpXT|', 'Icelandic', 'Iceland', NULL, '[[regtime_]]', NULL),
('ZN)puC', 'ZMp?X}', 'Italienisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('ZN)puC', '/_MpXT|', 'Italian', 'Switzerland', NULL, '[[regtime_]]', NULL),
('ZN)pv+X', 'ZMp?X}', 'Italienisch', 'Italien', NULL, '[[regtime_]]', NULL),
('ZN)pv+X', '/_MpXT|', 'Italian', 'Italy', NULL, '[[regtime_]]', NULL),
('ZN)pv|', 'ZMp?X}', 'Japanisch', 'Japan', NULL, '[[regtime_]]', NULL),
('ZN)pv|', '/_MpXT|', 'Japanese', 'Japan', NULL, '[[regtime_]]', NULL),
('ZN)pw', 'ZMp?X}', 'Georgisch', 'Georgien', NULL, '[[regtime_]]', NULL),
('ZN)pw', '/_MpXT|', 'Georgian', 'Georgia', NULL, '[[regtime_]]', NULL),
('ZN)px\n', 'ZMp?X}', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)px\n', '/_MpXT|', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)px;', 'ZMp?X}', 'Kamba', 'Kenia', NULL, '[[regtime_]]', NULL),
('ZN)px;', '/_MpXT|', 'Kamba', 'Kenya', NULL, '[[regtime_]]', NULL),
('ZN)px:', 'ZMp?X}', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)px:', '/_MpXT|', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)pxt', 'ZMp?X}', 'Koro', 'Elfenbeinküste', NULL, '[[regtime_]]', NULL),
('ZN)pxt', '/_MpXT|', 'Koro', 'Ivory Coast', NULL, '[[regtime_]]', NULL),
('ZN)py', 'ZMp?X}', 'Kasachisch', 'Kasachstan', NULL, '[[regtime_]]', NULL),
('ZN)py', '/_MpXT|', 'Kazakh', 'Kazakhstan', NULL, '[[regtime_]]', NULL),
('ZN)pyb', 'ZMp?X}', 'Grönländisch', 'Grönland', NULL, '[[regtime_]]', NULL),
('ZN)pyb', '/_MpXT|', 'Greenlandic', 'Greenland', NULL, '[[regtime_]]', NULL),
('ZN)py', 'ZMp?X}', 'Kambodschanisch', 'Kambodscha', NULL, '[[regtime_]]', NULL),
('ZN)py', '/_MpXT|', 'Cambodian', 'Cambodia', NULL, '[[regtime_]]', NULL),
('ZN)pzk', 'ZMp?X}', 'Kannada', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)pzk', '/_MpXT|', 'Kannada', 'India', NULL, '[[regtime_]]', NULL),
('ZN)p{X7', 'ZMp?X}', 'Koreanisch', 'Republik Korea', NULL, '[[regtime_]]', NULL),
('ZN)p{X7', '/_MpXT|', 'Korean', 'Republic of Korea', NULL, '[[regtime_]]', NULL),
('ZN)p|,', 'ZMp?X}', 'Konkani', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p|,', '/_MpXT|', 'Konkani', 'India', NULL, '[[regtime_]]', NULL),
('ZN)p|', 'ZMp?X}', 'Kpelle-Sprache', 'Guinea', NULL, '[[regtime_]]', NULL),
('ZN)p|', '/_MpXT|', 'Kpelle', 'Guinea', NULL, '[[regtime_]]', NULL),
('ZN)p}K', 'ZMp?X}', 'Kpelle-Sprache', 'Liberia', NULL, '[[regtime_]]', NULL),
('ZN)p}K', '/_MpXT|', 'Kpelle', 'Liberia', NULL, '[[regtime_]]', NULL),
('ZN)p~s', 'ZMp?X}', 'Kurdisch', 'Irak', NULL, '[[regtime_]]', NULL),
('ZN)p~s', '/_MpXT|', 'Kurdish', 'Iraq', NULL, '[[regtime_]]', NULL),
('ZN)pV', 'ZMp?X}', 'Kurdisch', 'Iran', NULL, '[[regtime_]]', NULL),
('ZN)pV', '/_MpXT|', 'Kurdish', 'Iran', NULL, '[[regtime_]]', NULL),
('ZN)p"T\\', 'ZMp?X}', 'Kurdisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('ZN)p"T\\', '/_MpXT|', 'Kurdish', 'Syria', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Kurdisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Kurdish', 'Turkey', NULL, '[[regtime_]]', NULL),
('ZN)pf|', 'ZMp?X}', 'Kornisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('ZN)pf|', '/_MpXT|', 'Cornish', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('ZN)pk', 'ZMp?X}', 'Kirgisisch', 'Kirgisistan', NULL, '[[regtime_]]', NULL),
('ZN)pk', '/_MpXT|', 'Kirghiz', 'Kyrgyzstan', NULL, '[[regtime_]]', NULL),
('ZN)p ]', 'ZMp?X}', 'Lingala', 'Demokratische Republik Kongo', NULL, '[[regtime_]]', NULL),
('ZN)p ]', '/_MpXT|', 'Lingala', 'Democratic Republic of the Congo', NULL, '[[regtime_]]', NULL),
('ZN)p''', 'ZMp?X}', 'Lingala', 'Kongo', NULL, '[[regtime_]]', NULL),
('ZN)p''', '/_MpXT|', 'Lingala', 'Congo', NULL, '[[regtime_]]', NULL),
('ZN)p󂣻,', 'ZMp?X}', 'Laotisch', 'Laos', NULL, '[[regtime_]]', NULL),
('ZN)p󂣻,', '/_MpXT|', 'Lao', 'Laos', NULL, '[[regtime_]]', NULL),
('ZN)p(v', 'ZMp?X}', 'Litauisch', 'Litauen', NULL, '[[regtime_]]', NULL),
('ZN)p(v', '/_MpXT|', 'Lithuanian', 'Lithuania', NULL, '[[regtime_]]', NULL),
('ZN)p^''', 'ZMp?X}', 'Lettisch', 'Lettland', NULL, '[[regtime_]]', NULL),
('ZN)p^''', '/_MpXT|', 'Latvian', 'Latvia', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Mazedonisch', 'Mazedonien', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Macedonian', 'Macedonia', NULL, '[[regtime_]]', NULL),
('ZN)p-', 'ZMp?X}', 'Malayalam', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p-', '/_MpXT|', 'Malayalam', 'India', NULL, '[[regtime_]]', NULL),
('ZN)pK', 'ZMp?X}', 'Mongolisch', 'China', NULL, '[[regtime_]]', NULL),
('ZN)pK', '/_MpXT|', 'Mongol', 'China', NULL, '[[regtime_]]', NULL),
('ZN)px', 'ZMp?X}', 'Mongolisch', 'Mongolei', NULL, '[[regtime_]]', NULL),
('ZN)px', '/_MpXT|', 'Mongol', 'Mongolia', NULL, '[[regtime_]]', NULL),
('ZN)p:', 'ZMp?X}', 'Marathi', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p:', '/_MpXT|', 'Marathi', 'India', NULL, '[[regtime_]]', NULL),
('ZN)pa', 'ZMp?X}', 'Malaiisch', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('ZN)pa', '/_MpXT|', 'Malay', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('ZN)pA', 'ZMp?X}', 'Malaiisch', 'Malaysia', NULL, '[[regtime_]]', NULL),
('ZN)pA', '/_MpXT|', 'Malay', 'Malaysia', NULL, '[[regtime_]]', NULL),
('ZN)pҷ', 'ZMp?X}', 'Maltesisch', 'Malta', NULL, '[[regtime_]]', NULL),
('ZN)pҷ', '/_MpXT|', 'Maltese', 'Malta', NULL, '[[regtime_]]', NULL),
('ZN)ph)', 'ZMp?X}', 'Birmanisch', 'Myanmar', NULL, '[[regtime_]]', NULL),
('ZN)ph)', '/_MpXT|', 'Burmese', 'Myanmar', NULL, '[[regtime_]]', NULL),
('ZN)p,_', 'ZMp?X}', 'Norwegisch Bokmål', 'Norwegen', NULL, '[[regtime_]]', NULL),
('ZN)p,_', '/_MpXT|', 'Norwegian Bokmål', 'Norway', NULL, '[[regtime_]]', NULL),
('ZN)p|', 'ZMp?X}', 'Niederdeutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('ZN)p|', '/_MpXT|', 'Low German', 'Germany', NULL, '[[regtime_]]', NULL),
('ZN)p/H', 'ZMp?X}', 'Nepalesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p/H', '/_MpXT|', 'Nepalese', 'India', NULL, '[[regtime_]]', NULL),
('ZN)p|N', 'ZMp?X}', 'Nepalesisch', 'Nepal', NULL, '[[regtime_]]', NULL),
('ZN)p|N', '/_MpXT|', 'Nepalese', 'Nepal', NULL, '[[regtime_]]', NULL),
('ZN)p\0', 'ZMp?X}', 'Niederländisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('ZN)p\0', '/_MpXT|', 'Dutch', 'Belgium', NULL, '[[regtime_]]', NULL),
('ZN)pH', 'ZMp?X}', 'Niederländisch', 'Niederlande', NULL, '[[regtime_]]', NULL),
('ZN)pH', '/_MpXT|', 'Dutch', 'Netherlands', NULL, '[[regtime_]]', NULL),
('ZN)p`', 'ZMp?X}', 'Norwegisch Nynorsk', 'Norwegen', NULL, '[[regtime_]]', NULL),
('ZN)p`', '/_MpXT|', 'Norwegian Nynorsk', 'Norway', NULL, '[[regtime_]]', NULL),
('ZN)p2', 'ZMp?X}', 'Süd-Ndebele-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)p2', '/_MpXT|', 'Southern Ndebele', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Nord-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Northern Sotho language', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p''a', 'ZMp?X}', 'Nyanja-Sprache', 'Malawi', NULL, '[[regtime_]]', NULL),
('ZN)p''a', '/_MpXT|', 'Nyanja', 'Malawi', NULL, '[[regtime_]]', NULL),
('ZN)p0̳', 'ZMp?X}', 'Okzitanisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('ZN)p0̳', '/_MpXT|', 'Occitan', 'France', NULL, '[[regtime_]]', NULL),
('ZN)p,', 'ZMp?X}', 'Oromo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN)p,', '/_MpXT|', 'Oromo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN)pH', 'ZMp?X}', 'Oromo', 'Kenia', NULL, '[[regtime_]]', NULL),
('ZN)pH', '/_MpXT|', 'Oromo', 'Kenya', NULL, '[[regtime_]]', NULL),
('ZN)p=#/', 'ZMp?X}', 'Orija', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p=#/', '/_MpXT|', 'Orija', 'India', NULL, '[[regtime_]]', NULL),
('ZN)pR', 'ZMp?X}', 'Pandschabisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)pR', '/_MpXT|', 'Punjabi', 'India', NULL, '[[regtime_]]', NULL),
('ZN)pFA', 'ZMp?X}', 'Pandschabisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('ZN)pFA', '/_MpXT|', 'Punjabi', 'Pakistan', NULL, '[[regtime_]]', NULL),
('ZN)p''I', 'ZMp?X}', 'Polnisch', 'Polen', NULL, '[[regtime_]]', NULL),
('ZN)p''I', '/_MpXT|', 'Polish', 'Poland', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Paschtu', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Pashto', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Portugiesisch', 'Brasilien', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Portuguese', 'Brazil', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Portugiesisch', 'Portugal', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Portuguese', 'Portugal', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Rumänisch', 'Republik Moldau', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Romanian', 'Republic of Moldova', NULL, '[[regtime_]]', NULL),
('ZN)p{', 'ZMp?X}', 'Rumänisch', 'Rumänien', NULL, '[[regtime_]]', NULL),
('ZN)p{', '/_MpXT|', 'Romanian', 'Romania', NULL, '[[regtime_]]', NULL),
('ZN)p1', 'ZMp?X}', 'Russisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('ZN)p1', '/_MpXT|', 'Russian', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('ZN)pu', 'ZMp?X}', 'Russisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('ZN)pu', '/_MpXT|', 'Russian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('ZN)pcE', 'ZMp?X}', 'Ruandisch', 'Ruanda', NULL, '[[regtime_]]', NULL),
('ZN)pcE', '/_MpXT|', 'Rwandan', 'Rwanda', NULL, '[[regtime_]]', NULL),
('ZN)p]x', 'ZMp?X}', 'Sanskrit', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p]x', '/_MpXT|', 'Sanskrit', 'India', NULL, '[[regtime_]]', NULL),
('ZN)pK', 'ZMp?X}', 'Nord-Samisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('ZN)pK', '/_MpXT|', 'Northen Samian', 'Finland', NULL, '[[regtime_]]', NULL),
('ZN)pɧ', 'ZMp?X}', 'Nord-Samisch', 'Norwegen', NULL, '[[regtime_]]', NULL),
('ZN)pɧ', '/_MpXT|', 'Northen Samian', 'Norway', NULL, '[[regtime_]]', NULL),
('ZN)pi', 'ZMp?X}', 'Serbo-Kroatisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('ZN)pi', '/_MpXT|', 'Serbo-Croat', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('ZN)p9', 'ZMp?X}', 'Serbo-Kroatisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('ZN)p9', '/_MpXT|', 'Serbo-Croat', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('ZN)p,', 'ZMp?X}', 'Singhalesisch', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('ZN)p,', '/_MpXT|', 'Singhalese', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('ZN)pj', 'ZMp?X}', 'Sidamo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN)pj', '/_MpXT|', 'Sidamo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN)pK', 'ZMp?X}', 'Slowakisch', 'Slowakei', NULL, '[[regtime_]]', NULL),
('ZN)pK', '/_MpXT|', 'Slovak', 'Slovakia', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Slowenisch', 'Slowenien', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Slovene', 'Slovenia', NULL, '[[regtime_]]', NULL),
('ZN)p3', 'ZMp?X}', 'Somali', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('ZN)p3', '/_MpXT|', 'Somali', 'Djibouti', NULL, '[[regtime_]]', NULL),
('ZN)pf', 'ZMp?X}', 'Somali', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN)pf', '/_MpXT|', 'Somali', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Somali', 'Kenia', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Somali', 'Kenya', NULL, '[[regtime_]]', NULL),
('ZN)pX/', 'ZMp?X}', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('ZN)pX/', '/_MpXT|', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('ZN)pb', 'ZMp?X}', 'Albanisch', 'Albanien', NULL, '[[regtime_]]', NULL),
('ZN)pb', '/_MpXT|', 'Albanian', 'Albania', NULL, '[[regtime_]]', NULL),
('ZN)pv', 'ZMp?X}', 'Serbisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('ZN)pv', '/_MpXT|', 'Serbian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('ZN)p󝪓H', 'ZMp?X}', 'Serbisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('ZN)p󝪓H', '/_MpXT|', 'Serbian', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('ZN)pG', 'ZMp?X}', 'Serbisch', 'Montenegro', NULL, '[[regtime_]]', NULL),
('ZN)pG', '/_MpXT|', 'Serbian', 'Montenegro', NULL, '[[regtime_]]', NULL),
('ZN)p\r', 'ZMp?X}', 'Serbisch', 'Serbien', NULL, '[[regtime_]]', NULL),
('ZN)p\r', '/_MpXT|', 'Serbian', 'Serbia', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Swazi', 'Swasiland', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Swazi', 'Swaziland', NULL, '[[regtime_]]', NULL),
('ZN)ps', 'ZMp?X}', 'Swazi', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)ps', '/_MpXT|', 'Swazi', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p2', 'ZMp?X}', 'Süd-Sotho-Sprache', 'Lesotho', NULL, '[[regtime_]]', NULL),
('ZN)p2', '/_MpXT|', 'Southern Sotho Language', 'Lesotho', NULL, '[[regtime_]]', NULL),
('ZN)p|n', 'ZMp?X}', 'Süd-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)p|n', '/_MpXT|', 'Southern Sotho Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p3', 'ZMp?X}', 'Schwedisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('ZN)p3', '/_MpXT|', 'Swedish', 'Finland', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Schwedisch', 'Schweden', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Swedish', 'Sweden', NULL, '[[regtime_]]', NULL),
('ZN)p_', 'ZMp?X}', 'Suaheli', 'Kenia', NULL, '[[regtime_]]', NULL),
('ZN)p_', '/_MpXT|', 'Swahili', 'Kenya', NULL, '[[regtime_]]', NULL),
('ZN)p.&', 'ZMp?X}', 'Suaheli', 'Tansania', NULL, '[[regtime_]]', NULL),
('ZN)p.&', '/_MpXT|', 'Swahili', 'Tanzania', NULL, '[[regtime_]]', NULL),
('ZN)pyi', 'ZMp?X}', 'Syrisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('ZN)pyi', '/_MpXT|', 'Syriac', 'Syria', NULL, '[[regtime_]]', NULL),
('ZN)p=L', 'ZMp?X}', 'Tamilisch', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p=L', '/_MpXT|', 'Tamil', 'India', NULL, '[[regtime_]]', NULL),
('ZN)p-', 'ZMp?X}', 'Telugu', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)p-', '/_MpXT|', 'Telugu', 'India', NULL, '[[regtime_]]', NULL),
('ZN)p>E', 'ZMp?X}', 'Tadschikisch', 'Tadschikistan', NULL, '[[regtime_]]', NULL),
('ZN)p>E', '/_MpXT|', 'Tadjik', 'Tajikistan', NULL, '[[regtime_]]', NULL),
('ZN)p>', 'ZMp?X}', 'Thailändisch', 'Thailand', NULL, '[[regtime_]]', NULL),
('ZN)p>', '/_MpXT|', 'Thai', 'Thailand', NULL, '[[regtime_]]', NULL),
('ZN)pb>', 'ZMp?X}', 'Tigrinja', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN)pb>', '/_MpXT|', 'Tigrinya', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN)p9<', 'ZMp?X}', 'Tigrinja', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN)p9<', '/_MpXT|', 'Tigrinya', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN)p"', 'ZMp?X}', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN)p"', '/_MpXT|', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('ZN)p*', 'ZMp?X}', 'Tswana-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)p*', '/_MpXT|', 'Tswana Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p\Z', 'ZMp?X}', 'Tongaisch', 'Tonga', NULL, '[[regtime_]]', NULL),
('ZN)p\Z', '/_MpXT|', 'Tongan', 'Tonga', NULL, '[[regtime_]]', NULL),
('ZN)p.', 'ZMp?X}', 'Türkisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('ZN)p.', '/_MpXT|', 'Turkish', 'Turkey', NULL, '[[regtime_]]', NULL),
('ZN)pUr', 'ZMp?X}', 'Tsonga', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)pUr', '/_MpXT|', 'Tsonga', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p_', 'ZMp?X}', 'Tatarisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('ZN)p_', '/_MpXT|', 'Tartar', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('ZN)p>', 'ZMp?X}', 'Uigurisch', 'China', NULL, '[[regtime_]]', NULL),
('ZN)p>', '/_MpXT|', 'Uighur', 'China', NULL, '[[regtime_]]', NULL),
('ZN)p\r{', 'ZMp?X}', 'Ukrainisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('ZN)p\r{', '/_MpXT|', 'Ukrainian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('ZN)pM', 'ZMp?X}', 'Urdu', 'Indien', NULL, '[[regtime_]]', NULL),
('ZN)pM', '/_MpXT|', 'Urdu', 'India', NULL, '[[regtime_]]', NULL),
('ZN)p', 'ZMp?X}', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('ZN)p', '/_MpXT|', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('ZN)pok', 'ZMp?X}', 'Usbekisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('ZN)pok', '/_MpXT|', 'Uzbek', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('ZN)pz_', 'ZMp?X}', 'Usbekisch', 'Usbekistan', NULL, '[[regtime_]]', NULL),
('ZN)pz_', '/_MpXT|', 'Uzbek', 'Uzbekistan', NULL, '[[regtime_]]', NULL);
INSERT INTO `locale_translation` VALUES
('ZN)pg2', 'ZMp?X}', 'Venda-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)pg2', '/_MpXT|', 'Venda Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)pC', 'ZMp?X}', 'Vietnamesisch', 'Vietnam', NULL, '[[regtime_]]', NULL),
('ZN)pC', '/_MpXT|', 'Vietnamese', 'Vietnam', NULL, '[[regtime_]]', NULL),
('ZN)pֆ', 'ZMp?X}', 'Walamo-Sprache', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('ZN)pֆ', '/_MpXT|', 'Walamo Language', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('ZN)pkZ', 'ZMp?X}', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('ZN)pkZ', '/_MpXT|', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('ZN)p1', 'ZMp?X}', 'Xhosa', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN)p1', '/_MpXT|', 'Xhosa', 'South Africa', NULL, '[[regtime_]]', NULL),
('ZN)p,%', 'ZMp?X}', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)p,%', '/_MpXT|', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('ZN)p9', 'ZMp?X}', 'Chinesisch', 'China', NULL, '[[regtime_]]', NULL),
('ZN)p9', '/_MpXT|', 'Chinese', 'China', NULL, '[[regtime_]]', NULL),
('ZN*s2?', 'ZMp?X}', 'Chinesisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('ZN*s2?', '/_MpXT|', 'Chinese', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('ZN*s2ʴ', 'ZMp?X}', 'Chinesisch', 'Sonderverwaltungszone Macao', NULL, '[[regtime_]]', NULL),
('ZN*s2ʴ', '/_MpXT|', 'Chinese', 'Macao', NULL, '[[regtime_]]', NULL),
('ZN*s2ˀwe', 'ZMp?X}', 'Chinesisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('ZN*s2ˀwe', '/_MpXT|', 'Chinese', 'Singapur', NULL, '[[regtime_]]', NULL),
('ZN*s2\rȨ', 'ZMp?X}', 'Chinesisch', 'Taiwan', NULL, '[[regtime_]]', NULL),
('ZN*s2\rȨ', '/_MpXT|', 'Chinese', 'Taiwan', NULL, '[[regtime_]]', NULL),
('ZN*s2̿g', 'ZMp?X}', 'Zulu', 'Südafrika', NULL, '[[regtime_]]', NULL),
('ZN*s2̿g', '/_MpXT|', 'Zulu', 'South Africa', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `log_entry`
--

CREATE TABLE `log_entry` (
  `id` binary(16) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` smallint NOT NULL,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` json DEFAULT NULL,
  `extra` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.log_entry.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer`
--

CREATE TABLE `mail_header_footer` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer`
--

INSERT INTO `mail_header_footer` VALUES
('[\ZqūАF', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer_translation`
--

CREATE TABLE `mail_header_footer_translation` (
  `mail_header_footer_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `header_html` longtext COLLATE utf8mb4_unicode_ci,
  `header_plain` longtext COLLATE utf8mb4_unicode_ci,
  `footer_html` longtext COLLATE utf8mb4_unicode_ci,
  `footer_plain` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_header_footer_id`,`language_id`),
  KEY `fk.mail_header_footer_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer_translation`
--

INSERT INTO `mail_header_footer_translation` VALUES
('[\ZqūАF', 'ZMp?X}', 'Standard-E-Mail-Fußzeile', 'Standard-E-Mail-Fußzeile basierend auf den Stammdaten', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Adresse:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bankverbindung:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Adresse:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bankverbindung:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL),
('[\ZqūАF', '/_MpXT|', 'Default email footer', 'Default email footer derived from basic information', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Address:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bank account:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Address:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bank account:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template`
--

CREATE TABLE `mail_template` (
  `id` binary(16) NOT NULL,
  `mail_template_type_id` binary(16) DEFAULT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.mail_template.mail_template_type_id` (`mail_template_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template`
--

INSERT INTO `mail_template` VALUES
('Z]r󥈥Cm', 'Z\\pDVy', 1, '[[regtime_]]', NULL),
('Z]r󥈥J', 'Z\\pDVyJ', 1, '[[regtime_]]', NULL),
('Z^r^B8', 'Z\\pDVyP', 1, '[[regtime_]]', NULL),
('Z^rώ-i', 'Z\\pDVy', 1, '[[regtime_]]', NULL),
('Z^r6$𥖈P', 'Z\\pDVy6', 1, '[[regtime_]]', NULL),
('Z^sƦi', 'Z\\pDVyt', 1, '[[regtime_]]', NULL),
('Z^s:3Joj}', 'Z\\pDVyڷ', 1, '[[regtime_]]', NULL),
('ZhpVc', 'Zhp9c<`o', 1, '[[regtime_]]', NULL),
('Zs7sۑ^J', 'Zmis컗{', 1, '[[regtime_]]', NULL),
('Zvs>J', 'ZvqͿM*a', 1, '[[regtime_]]', NULL),
('ZzrƂw~=nV', 'Z\\pDVy1', 1, '[[regtime_]]', NULL),
('ZzqHgA@E', 'Z\\pDVyڷ', 1, '[[regtime_]]', NULL),
('Z{p\rx)J', 'Z\\pDVyݬ\n', 1, '[[regtime_]]', NULL),
('Z{q˹`c', 'Z\\pDVyޡi', 1, '[[regtime_]]', NULL),
('Z{q.Y5', 'Z\\pDVy', 1, '[[regtime_]]', NULL),
('Z{1r͒0> *', 'Z\\pDVy>c', 1, '[[regtime_]]', NULL),
('Z{?rW=u', 'Z\\pDVy\\l', 1, '[[regtime_]]', NULL),
('Z{Ms fN', 'Z\\pDVyp', 1, '[[regtime_]]', NULL),
('Z{Zqf-', 'Z\\pDVy	', 1, '[[regtime_]]', NULL),
('Z{ns-LYc', 'Z\\pDVyPe', 1, '[[regtime_]]', NULL),
('Z{}sE~n^q', 'Z\\pDVys', 1, '[[regtime_]]', NULL),
('Z{stll', 'Z\\pDVy<', 1, '[[regtime_]]', NULL),
('Z{p۱YKsGY', 'Z\\pDVyMJ', 1, '[[regtime_]]', NULL),
('Z{qjǷx', 'Z\\pDVyٴ', 1, '[[regtime_]]', NULL),
('Z{r<BaH', 'Z\\pDVy᭴@', 1, '[[regtime_]]', NULL),
('Z{si[|I', 'Z\\pDVyW', 1, '[[regtime_]]', NULL),
('Zr85', 'Zr85', 1, '[[regtime_]]', NULL),
('Zs0C7', 'Zs0DG', 1, '[[regtime_]]', NULL),
('Zqvj', 'Z¸q͉', 1, '[[regtime_]]', NULL),
('Zsϐ\Z', 'Zq򫘪7<n', 1, '[[regtime_]]', NULL),
('[HpX">', '[HpX"ӕ', 1, '[[regtime_]]', NULL),
('[HpX";y', '[HpX",', 1, '[[regtime_]]', NULL),
('[HpX"E', '[HpX"n', 1, '[[regtime_]]', NULL),
('[HpX"|', '[HpX"V', 1, '[[regtime_]]', NULL),
('[iqJ8V', '[iurt݌9Ji', 1, '[[regtime_]]', NULL),
('[wspdW''', '[wspd', 1, '[[regtime_]]', NULL),
('[q`oq0', '[sC', 1, '[[regtime_]]', NULL),
('[rl', '[qA/ˬ', 1, '[[regtime_]]', NULL),
('[q\ZE\0}', '[rJK~	i', 1, '[[regtime_]]', NULL),
('[p9bp', '[sx\09h', 1, '[[regtime_]]', NULL),
('[2pٽOG', '[1r\0l&', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_media`
--

CREATE TABLE `mail_template_media` (
  `id` binary(16) NOT NULL,
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk.mail_template_media.mail_template_id` (`mail_template_id`),
  KEY `fk.mail_template_media.media_id` (`media_id`),
  KEY `fk.mail_template_media.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_translation`
--

CREATE TABLE `mail_template_translation` (
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `sender_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `content_html` longtext COLLATE utf8mb4_unicode_ci,
  `content_plain` longtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_template_id`,`language_id`),
  KEY `fk.mail_template_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_translation`
--

INSERT INTO `mail_template_translation` VALUES
('Z]r󥈥Cm', 'ZMp?X}', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Schön, dass Sie sich für unseren Newsletter interessieren!</p>\n                <p>Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie <a href="{{ url }}">hier</a> klicken.</p>\n                <p>Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Schön, dass Sie sich für unseren Newsletter interessieren!\n\n                Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie auf den folgenden Link klicken: {{ url }}\n\n                Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.\n        ', NULL, '[[regtime_]]', NULL),
('Z]r󥈥Cm', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Thank you for your interest in our newsletter!</p>\n                <p>In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking <a href="{{ url }}">here</a>.</p>\n                <p>If you have not subscribed to the newsletter, please ignore this email.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Thank you for your interest in our newsletter!\n\n                In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking on the link: {{ url }}\n\n                If you have not subscribed to the newsletter, please ignore this email.\n        ', NULL, '[[regtime_]]', NULL),
('Z]r󥈥J', 'ZMp?X}', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>vielen Dank für Ihre Anmeldung.</p>\n                <p>Sie haben sich erfolgreich zu unserem Newsletter angemeldet.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                vielen Dank für Ihre Anmeldung.\n\n                Sie haben sich erfolgreich zu unserem Newsletter angemeldet.\n        ', NULL, '[[regtime_]]', NULL),
('Z]r󥈥J', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>thank you very much for your registration.</p>\n                <p>You have successfully subscribed to our newsletter.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                thank you very much for your registration.\n\n                You have successfully subscribed to our newsletter.\n        ', NULL, '[[regtime_]]', NULL),
('Z^r^B8', 'ZMp?X}', '{{ salesChannel.name }}', 'Bestellbestätigung', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    Sobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.<br>\n    <br>\n    Den aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    Über diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nSobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.\n\nDen aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nÜber diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z^r^B8', '/_MpXT|', '{{ salesChannel.name }}', 'Order confirmation', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n    As soon as your payment has been made, you will receive a separate notification and your order will be processed.<br>\n    <br>\n    You may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    You may use this link to edit your order, change the payment method or make additional payments.<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}\n\nAs soon as your payment has been made, you will receive a separate notification and your order will be processed.\n\nYou may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nYou may use this link to edit your order, change the payment method or make additional payments.\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z^rώ-i', 'ZMp?X}', '{{ salesChannel.name }}', 'Deine Registrierung bei {{ salesChannel.name }}', 'Registrierungsbestätigung', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n                <br/>\n                vielen Dank für Ihre Anmeldung in unserem Shop.<br/>\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse <strong>{{ customer.email }}</strong> und dem von Ihnen gewählten Kennwort.<br/>\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                vielen Dank für Ihre Anmeldung in unserem Shop.\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse {{ customer.email }} und dem von Ihnen gewählten Kennwort.\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n', NULL, '[[regtime_]]', NULL),
('Z^rώ-i', '/_MpXT|', '{{ salesChannel.name }}', 'Your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n                <br/>\n                thank you for your signing up with our Shop.<br/>\n                You will gain access via the email address <strong>{{ customer.email }}</strong> and the password you have chosen.<br/>\n                You can change your password anytime.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                thank you for your signing up with our Shop.\n                You will gain access via the email address {{ customer.email }} and the password you have chosen.\n                You can change your password anytime.\n        ', NULL, '[[regtime_]]', NULL),
('Z^r6$𥖈P', 'ZMp?X}', '{{ salesChannel.name }}', 'Password zurücksetzen - {{ salesChannel.name }}', 'Anfrage zum Zurücksetzen des Passworts', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n        <br/>\n        im Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', 'Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nim Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\nBitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\nPasswort zurücksetzen: {{ resetUrl }}\n\nDieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\nFalls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('Z^r6$𥖈P', '/_MpXT|', '{{ salesChannel.name }}', 'Password reset - {{ salesChannel.name }}', 'Password reset request', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n        <br/>\n        there has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nthere has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\nPlease confirm the link below to specify a new password.\n\nReset password: {{ resetUrl }}\n\nThis link is valid for the next 2 hours. After that you have to request a new confirmation link.\nIf you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('Z^sƦi', 'ZMp?X}', '{{ salesChannel.name }}', 'Ihr Händleraccount wurde freigeschaltet - {{ salesChannel.name }}', 'Kundengruppenwechsel freigeschaltet', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        ihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.<br/>\n        Von nun an werden wir Ihnen den Netto-Preis berechnen.\n    </p>\n</div>\n', 'Hallo,\n\nihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.\nVon nun an werden wir Ihnen den Netto-Preis berechnen.\n', NULL, '[[regtime_]]', NULL),
('Z^sƦi', '/_MpXT|', '{{ salesChannel.name }}', 'Your merchant account has been unlocked - {{ salesChannel.name }}', 'Customer Group Change accepted', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        your merchant account at {{ salesChannel.translated.name }} has been unlocked.<br/>\n        From now on, we will charge you the net purchase price.\n    </p>\n</div>\n', 'Hello,\n\nyour merchant account at {{ salesChannel.translated.name }} has been unlocked.\nFrom now on, we will charge you the net purchase price.\n', NULL, '[[regtime_]]', NULL),
('Z^s:3Joj}', 'ZMp?X}', '{{ salesChannel.name }}', 'Ihr Händleraccountantrag wurde abgelehnt - {{ salesChannel.name }}', 'Kundengruppenwechsel abgelehnt', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        vielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine <br/>\n        Händlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen. <br/>\n        Bei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail. <br/>\n    </p>\n</div>\n', 'Hallo,\n\nvielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine\nHändlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen.\nBei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail.\n', NULL, '[[regtime_]]', NULL),
('Z^s:3Joj}', '/_MpXT|', '{{ salesChannel.name }}', 'Your trader account has not been accepted - {{ salesChannel.name }}', 'Customer Group Change rejected', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        thank you for your interest in our trade prices.\n        Unfortunately, we do not have a trading license yet so that we cannot accept you as a merchant.<br/>\n        In case of further questions please do not hesitate to contact us via telephone, fax or email.\n    </p>\n</div>\n', 'Hello,\n\nthank you for your interest in our trade prices. Unfortunately,\nwe do not have a trading license yet so that we cannot accept you as a merchant.\nIn case of further questions please do not hesitate to contact us via telephone, fax or email.\n', NULL, '[[regtime_]]', NULL),
('ZhpVc', 'ZMp?X}', 'Shopware Administration', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', '        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\n        Passwort zurücksetzen: {{ resetUrl }}\n\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('ZhpVc', '/_MpXT|', 'Shopware Administration', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>', '        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.\n\n        Reset password: {{ resetUrl }}\n\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.\n        If you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('Zs7sۑ^J', 'ZMp?X}', '{{ salesChannel.name }}', 'Kontaktanfrage erhalten - {{ salesChannel.name }}', 'Kontaktanfrage erhalten', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.<br/>\n        <br/>\n        Name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Kontakt E-Mail: {{ contactFormData.email }}<br/>\n        <br>\n        Telefonnummer: {{ contactFormData.phone }}<br/>\n        <br/>\n        Betreff: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.\n\nName: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nKontakt E-Mail: {{ contactFormData.email }}\n\nTelefonnummer: {{ contactFormData.phone }}\n\nBetreff: {{ contactFormData.subject }}\n\nNachricht:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('Zs7sۑ^J', '/_MpXT|', '{{ salesChannel.name }}', 'Contact form received - {{ salesChannel.name }}', 'Contact form received', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        The following Message was sent to you via the contact form.<br/>\n        <br/>\n        Contact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Contact email address: {{ contactFormData.email }}\n        <br/>\n        Phone: {{ contactFormData.phone }}<br/>\n        <br/>\n        Subject: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'The following Message was sent to you via the contact form.\n\nContact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nContact email address: {{ contactFormData.email }}\nPhone: {{ contactFormData.phone }}\n\nSubject: {{ contactFormData.subject }}\n\nMessage:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('Zvs>J', 'ZMp?X}', '{{ shopName }}', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.<br/>\n        <br/>\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team\n    </p>\n</div>', '        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:\n\n        {{ resetUrl }}\n\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('Zvs>J', '/_MpXT|', '{{ shopName }}', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.<br/>\n        <br/>\n        Yours sincerely\n        Your {{ shopName }} team\n    </p>\n</div>', '        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:\n\n        {{ resetUrl }}\n\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.\n\n        Yours sincerely\n        Your {{ shopName }}-Team', NULL, '[[regtime_]]', NULL),
('ZzrƂw~=nV', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('ZzrƂw~=nV', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('ZzqHgA@E', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('ZzqHgA@E', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{p\rx)J', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{p\rx)J', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{q˹`c', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{q˹`c', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{q.Y5', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{q.Y5', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{1r͒0> *', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{1r͒0> *', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('Z{?rW=u', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{?rW=u', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n    <br/>\n    the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n    <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    However, in case you have purchased without a registration or a customer account, you do not have this option.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{Ms fN', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{Ms fN', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{Zqf-', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{Zqf-', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{ns-LYc', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{ns-LYc', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{}sE~n^q', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{}sE~n^q', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{stll', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{stll', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('Z{p۱YKsGY', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Wir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.\n\nBestellnummer: {{ order.orderNumber }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{p۱YKsGY', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We received your payment and will now start processing the order.<br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe received your payment and will now start processing the order.\n\nOrder number: {{ order.orderNumber }}\n\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{qjǷx', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}\n    <br>\n    Der Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nDer Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('Z{qjǷx', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}.<br>\n    <br>\n    You have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" alt="" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}.\n\nYou have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{r<BaH', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{r<BaH', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{si[|I', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Z{si[|I', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Zr85', 'ZMp?X}', '{{ salesChannel.translated.name }}', 'Bitte bestätigen Sie Ihre Anmeldung bei {{ salesChannel.translated.name }}', 'Anmeldebestätigung', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.<br/>\n                    Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Anmeldung abschließen</a><br/>\n                    <br/>\n                    Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n                </p>\n            </div>\n        ', '\n            Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.\n            Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:\n\n            {{ confirmUrl }}\n\n            Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n        ', NULL, '[[regtime_]]', NULL),
('Zr85', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Please confirm your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    thank you for your signing up with {{ salesChannel.translated.name }}.<br/>\n                    Please confirm the sign-up via the following link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Completing sign-up</a><br/>\n                    <br/>\n                    By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n                </p>\n            </div>\n        ', '\n            Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            thank you for your signing up with {{ salesChannel.translated.name }}.\n            Please confirm the sign-up via the following link:\n\n            {{ confirmUrl }}\n\n            By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n        ', NULL, '[[regtime_]]', NULL),
('Zs0C7', 'ZMp?X}', '{{ salesChannel.name }}', 'Bitte bestätigen Sie Ihre E-Mail-Adresse bei {{ salesChannel.name }}', 'Anmeldebestätigung bei Gastbestellungen', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Bitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">E-Mail bestätigen</a><br/>\n        <br/>\n        Nach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.<br/>\n        Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n    </p>\n</div>\n', 'Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nBitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:\n\n{{ confirmUrl }}\n\nNach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.\nDurch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n', NULL, '[[regtime_]]', NULL),
('Zs0C7', '/_MpXT|', '{{ salesChannel.name }}', 'Please confirm your email address at {{ salesChannel.name }}', 'Email confirmation at guest orders', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Please confirm your email address via the following link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">Confirm email</a><br/>\n        <br/>\n        After the confirmation, you will be directed to the checkout, where you can check and complete your order again.<br/>\n        By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nPlease confirm your email address via the following link:\n\n{{ confirmUrl }}\n\nAfter the confirmation, you will be directed to the checkout, where you can check and complete your order again.\nBy this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n', NULL, '[[regtime_]]', NULL),
('Zqvj', 'ZMp?X}', 'Shop', 'Kunden Gruppen Registrierung Akzeptiert', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Ihr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.<br/>\n        Ab sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/>\n\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nIhr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.\nAb sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.\n\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n', NULL, '[[regtime_]]', NULL),
('Zqvj', '/_MpXT|', 'Shop', 'Customer Group Registration Accepted', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Your account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\n        From now on you can shop at the new conditions of this customer group.<br/><br/>\n\n        Please do not hesitate to contact us at any time if you have any questions.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nYour account has been activated for the customer group {{ customerGroup.translated.name }}.\nFrom now on you can shop at the new conditions of this customer group.\n\nPlease do not hesitate to contact us at any time if you have any questions.\n', NULL, '[[regtime_]]', NULL),
('Zsϐ\Z', 'ZMp?X}', 'Shop', 'Kunden Gruppen Registrierung Abgelehnt', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Vielen Dank für Ihr Interesse an den Konditionen für Kundengruppe {{ customerGroup.translated.name }}.<br/>\n        Leider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\n        Bei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nVielen Dank für Ihr Interesse an den Konditionen für Kundengruppe  {{ customerGroup.translated.name }}.\nLeider können wir sie nicht für diese Kundengruppe freischalten.\n\nBei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n', NULL, '[[regtime_]]', NULL),
('Zsϐ\Z', '/_MpXT|', 'Shop', 'Customer Group Registration Declined', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Thank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\n        Unfortunately we cannot activate your account for this customer group.<br/><br/>\n\n        If you have any questions, please feel free to contact us by phone or mail.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nThank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.\nUnfortunately we cannot activate your account for this customer group.\n\nIf you have any questions, please feel free to contact us by phone or mail.\n', NULL, '[[regtime_]]', NULL),
('[HpX">', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[HpX">', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            ''deepLinkCode'': a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[HpX";y', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('[HpX";y', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[HpX"E', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[HpX"E', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[HpX"|', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[HpX"|', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[iqJ8V', 'ZMp?X}', '{{ salesChannel.name }}', 'Ihre Dateien von {{ salesChannel.name }} stehen bereit', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Mit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nMit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('[iqJ8V', '/_MpXT|', '{{ salesChannel.name }}', 'Your downloads from {{ salesChannel.name }} are ready', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the files to the order: {{ order.orderNumber }}\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the files to the order: {{ order.orderNumber }}\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('[wspdW''', 'ZMp?X}', '{{ salesChannel.name }}', 'Neue Produktbewertung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            E-Mail-Adresse: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Produkt: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Bewertung: {{ reviewFormData.points }}<br/>\n        <br/>\n        Titel: {{ reviewFormData.title }}<br/>\n        <br/>\n        Inhalt:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}E-Mail-Adresse: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Produkt: {{ product.translated.name }}{% endif %}\n\nBewertung: {{ reviewFormData.points }}\n\nTitel: {{ reviewFormData.title }}\n\nInhalt:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('[wspdW''', '/_MpXT|', '{{ salesChannel.name }}', 'New product review', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            Email address: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Product: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Rating: {{ reviewFormData.points }}<br/>\n        <br/>\n        Title: {{ reviewFormData.title }}<br/>\n        <br/>\n        Content:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}Email address: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Product: {{ product.translated.name }}{% endif %}\n\nRating: {{ reviewFormData.points }}\n\nTitle: {{ reviewFormData.title }}\n\nContent:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('[q`oq0', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[q`oq0', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[rl', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[rl', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[q\ZE\0}', 'ZMp?X}', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('[q\ZE\0}', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('[p9bp', 'ZMp?X}', 'Admin', '{{ nameOfInviter }} hat dich eingeladen, {{ storeName }} beizutreten', 'Shopware Sso Admin Einladung', '<html lang="de">\n<head>\n    <title>Einladung</title>\n</head>\n<body style="font-family: Inter, Arial, Helvetica, sans-serif; font-weight: 500; line-height: 1.5;">\n<div style="width: 400px; padding: 50px;">\n    <div style="padding-bottom: 25px">\n        <svg width="186" height="40" viewBox="0 0 186 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n            <path d="M54.5636 20.1837C52.8632 19.4458 51.4643 18.777 51.4643 17.6684C51.4643 16.8906 52.3436 16.1528 53.826 16.1528C55.1559 16.1528 56.304 16.4872 57.4849 17.0033C57.8192 17.1523 58.3351 17.1886 58.5931 16.6689L59.1854 15.484C59.407 15.0405 59.2217 14.5208 58.8148 14.2264C57.9645 13.6703 56.1914 12.9688 53.8224 12.9688C49.6803 12.9688 47.9871 15.484 47.9871 17.6284C47.9871 20.4381 50.1635 21.8447 52.7869 23.0296C55.1522 24.1019 56.4457 24.8397 56.4457 25.9883C56.4457 26.9515 55.6319 27.653 54.1894 27.653C52.1546 27.653 50.9374 26.9515 49.9382 26.3954C49.495 26.1373 49.0153 26.2463 48.83 26.6171L48.0525 28.2091C47.8672 28.5798 48.0888 28.9106 48.3468 29.096C49.3097 29.7611 51.2681 30.8334 53.9677 30.8334C57.7756 30.8334 60.0683 28.5035 60.0683 25.8393C60.0719 22.6625 57.7065 21.5176 54.5636 20.1837Z" fill="#189EFF"/>\n            <path d="M31.8908 35.6202C30.154 34.3117 27.5924 33.3158 24.8819 32.2653C21.6554 31.015 17.9965 29.5938 15.2496 27.4094C12.1394 24.9305 10.6242 21.8046 10.6242 17.8537C10.6242 14.3062 12.0958 11.2749 14.879 9.08314C18.0001 6.62608 22.7309 5.32485 28.5553 5.32485C30.1649 5.32485 31.7019 5.42299 33.1262 5.61926C33.2533 5.63744 33.3733 5.56838 33.4241 5.4557C33.4786 5.33939 33.4496 5.20491 33.3551 5.12131C29.6853 1.81736 24.94 0 19.9985 0C14.6573 0 9.63591 2.07905 5.85712 5.85915C2.08197 9.63562 0 14.6588 0 19.9982C0 25.3412 2.07833 30.3644 5.85712 34.1408C9.63228 37.9173 14.6537 40 19.9985 40C24.3151 40 28.4245 38.6443 31.8872 36.0818C31.9598 36.0273 32.0034 35.9437 32.0034 35.8528C32.0034 35.7619 31.9635 35.6747 31.8908 35.6202Z" fill="#189EFF"/>\n            <path d="M39.9062 18.1512C39.8989 18.0749 39.8626 18.0022 39.8044 17.9549C35.6332 14.4911 32.2578 13.0771 28.1556 13.0771C25.9683 13.0771 24.2896 13.5169 23.1705 14.382C22.2004 15.1308 21.688 16.1776 21.688 17.4025C21.688 20.8373 25.8847 22.4038 30.7462 24.2175C33.2497 25.1517 35.8403 26.1185 38.2166 27.4379C38.2602 27.4633 38.3075 27.4742 38.3547 27.4742C38.3874 27.4742 38.4201 27.467 38.4528 27.4561C38.5291 27.427 38.5945 27.3688 38.6236 27.2889C39.5319 24.9627 39.9934 22.5092 39.9934 19.9976C39.9897 19.4088 39.9643 18.7873 39.9062 18.1512Z" fill="#189EFF"/>\n            <path d="M154.829 30.626C155.341 30.5679 155.693 30.1935 155.693 29.7283V21.0522C155.693 16.6142 155.152 13.1758 149.44 13.1758C146.159 13.1758 143.612 14.0627 143.303 14.179C142.878 14.3316 142.609 14.6042 142.726 15.2221L143.074 16.6905C143.191 17.1921 143.536 17.5411 144.077 17.4248C145.004 17.1558 147.009 16.5742 149.055 16.5742C151.293 16.5742 151.987 17.85 151.911 20.6669C151.911 20.6669 150.174 20.1253 148.321 20.1253C143.728 20.1253 141.181 22.597 141.181 25.8791C141.181 29.5865 143.532 30.8405 146.89 30.8405C149.629 30.8405 152.449 30.8078 153.622 30.7314L154.829 30.626ZM151.871 27.4784C151.33 28.3652 149.4 28.1435 147.743 28.1108C145.89 28.0708 144.964 27.4239 144.964 25.8391C144.964 23.9854 146.544 22.9059 148.63 22.9059C150.25 22.9059 151.642 23.3711 151.871 23.5238V27.4784Z" fill="#189EFF"/>\n            <path d="M183.969 12.9719C185.092 12.9719 186 12.0669 186 10.9474C186 9.82789 185.092 8.92285 183.969 8.92285C182.846 8.92285 181.938 9.82789 181.938 10.9474C181.938 12.0669 182.846 12.9719 183.969 12.9719ZM183.969 9.2209C184.91 9.2209 185.68 9.99873 185.68 10.9474C185.68 11.896 184.914 12.6739 183.969 12.6739C183.028 12.6739 182.261 11.896 182.261 10.9474C182.261 9.99873 183.028 9.2209 183.969 9.2209Z" fill="#189EFF"/>\n            <path d="M183.279 11.9731H183.468C183.497 11.9731 183.522 11.9477 183.522 11.9186V11.1735H183.965L184.347 11.9368C184.358 11.9622 184.376 11.9731 184.409 11.9731H184.627C184.677 11.9731 184.696 11.9258 184.677 11.8895L184.278 11.1444C184.532 11.0426 184.71 10.8209 184.71 10.5519C184.71 10.203 184.423 9.92676 184.074 9.92676H183.279C183.246 9.92676 183.224 9.9522 183.224 9.98128V11.9186C183.224 11.9477 183.246 11.9731 183.279 11.9731ZM183.529 10.2103H184.049C184.238 10.2103 184.405 10.3666 184.405 10.5592C184.405 10.7627 184.238 10.9227 184.049 10.9227H183.529V10.2103Z" fill="#189EFF"/>\n            <path d="M71.4301 12.9727C68.7304 12.9727 66.881 14.452 66.4777 14.7501V7.12082C66.4777 6.71373 66.0707 6.30664 65.6638 6.30664H63.5927C63.1494 6.30664 62.7788 6.71373 62.7788 7.12082V30.0231C62.7788 30.4666 63.1494 30.8373 63.5927 30.8373H65.6274C66.147 30.8373 66.4777 30.5029 66.4777 30.0231V18.9663C66.8483 18.2285 68.3271 16.4875 70.9504 16.4875C73.1705 16.4875 74.3514 18.1522 74.3514 20.9618V30.0268C74.3514 30.4702 74.722 30.8409 75.1653 30.8409H77.2363C77.6433 30.8409 78.0502 30.4702 78.0502 30.0268V21.0381C78.0466 16.3784 76.2735 12.9727 71.4301 12.9727Z" fill="#189EFF"/>\n            <path d="M114.73 21.2162C114.526 15.4115 112.096 12.9727 106.496 12.9727C103.808 12.9727 100.599 13.7796 100.127 13.9867C99.5457 14.2375 99.1169 14.5356 99.1169 14.9427V15.2807V16.5201V20.5329V21.0781V36.6892C99.1169 37.1326 99.4876 37.5033 99.9308 37.5033H101.646C102.202 37.5033 102.532 37.1689 102.532 36.6892L102.529 30.5429C103.048 30.6773 105.704 30.9027 107.921 30.8336C111.874 30.71 114.526 27.8386 114.748 22.9899C114.781 22.332 114.73 21.2162 114.73 21.2162ZM111.158 22.9863C111.082 26.2757 110.126 27.7296 107.358 27.8822C105.988 27.9586 102.754 27.5769 102.754 27.5769C102.62 27.5333 102.529 27.4752 102.529 27.3516L102.525 20.6855V16.9054C102.525 16.8036 102.601 16.72 102.703 16.7091C103.085 16.6692 104.484 16.2185 106.496 16.2185C109.868 16.2185 111.056 16.7128 111.165 20.9836C111.173 21.5469 111.176 22.3357 111.158 22.9863Z" fill="#189EFF"/>\n            <path d="M139.223 13.3434H137.672C137.228 13.3434 136.6 13.3434 136.378 13.8632L133.642 23.6987H133.569L128.984 13.3797C128.911 13.158 128.65 12.9727 128.246 12.9727H127.988C127.654 12.9727 127.396 13.158 127.287 13.3797L122.662 23.6623H122.589L119.78 13.8632C119.708 13.5288 119.337 13.3434 119.043 13.3434H116.823C116.231 13.3434 115.973 13.7868 116.231 14.3066L121.223 30.3938C121.296 30.6519 121.557 30.8373 121.924 30.8373H122.146C122.516 30.8373 122.738 30.6519 122.811 30.4302L128.061 18.8173H128.134L133.348 30.4302C133.46 30.6519 133.718 30.8373 134.085 30.8373H134.234C134.605 30.8373 134.936 30.6519 135.012 30.3938L139.892 14.3066C140.15 13.7868 139.815 13.3434 139.223 13.3434Z" fill="#189EFF"/>\n            <path d="M166.496 13.1758C166.405 13.1758 166.321 13.1831 166.23 13.1867C166.081 13.1831 165.936 13.1758 165.78 13.1758C164.893 13.1758 164.043 13.2049 163.247 13.2448C161.714 13.3066 160.806 13.4229 160.159 13.4956C160.159 13.4956 159.745 13.5356 159.261 13.5974C158.938 13.6374 158.702 13.7719 158.557 13.9572C158.458 14.0626 158.397 14.1971 158.397 14.3607V14.4189V14.7569V15.9963V19.4348V30.019C158.397 30.4625 158.767 30.8332 159.211 30.8332H160.911C161.612 30.8332 162.096 30.7605 162.096 30.019V19.4348V17.0068C162.096 16.905 162.255 16.7778 162.343 16.7233C162.76 16.4725 163.763 16.2907 165.78 16.2907C165.976 16.2907 166.103 16.2944 166.249 16.298C166.71 16.3416 167.44 16.4834 167.677 16.6179C168.047 16.8032 168.49 16.6905 168.712 16.2108L169.599 14.7605C170.155 13.6192 168.123 13.1758 166.496 13.1758Z" fill="#189EFF"/>\n            <path d="M178.199 12.9727C173.061 12.9727 169.697 17.0799 169.697 21.885C169.697 26.7664 173.061 30.8336 178.235 30.8336C181.08 30.8336 183.337 29.7977 184.557 28.7255C185.073 28.2821 184.928 27.9477 184.63 27.5806L183.631 26.0285C183.337 25.5851 183.002 25.6941 182.632 25.9558C181.596 26.6937 180.412 27.3988 178.453 27.3988C175.459 27.3988 173.388 25.0326 173.352 22.7391H185.146C185.517 22.7391 185.884 22.4411 185.924 21.9976C185.96 21.7032 185.996 21.1108 185.996 20.8127C185.996 16.2657 182.635 12.9727 178.199 12.9727ZM173.541 19.9986C173.799 17.8541 175.427 16.1167 178.126 16.1167C180.641 16.1167 182.268 17.9304 182.341 19.9986H173.541V19.9986Z" fill="#189EFF"/>\n            <path d="M96.1556 18.2573C95.7704 17.1559 95.229 16.2109 94.5351 15.4258C93.8411 14.6407 93.009 14.0337 92.0461 13.6085C91.0833 13.1832 89.7171 12.9688 88.5835 12.9688C87.4498 12.9688 86.0873 13.1832 85.1244 13.6085C84.1615 14.0337 83.3331 14.6407 82.6355 15.4258C81.9415 16.2109 81.4001 17.1559 81.015 18.2573C80.6298 19.3586 80.4373 20.5762 80.4373 21.9065C80.4373 23.2586 80.6298 24.4799 81.015 25.5703C81.4001 26.6607 81.9415 27.5985 82.6355 28.3836C83.3295 29.1687 84.1615 29.7757 85.1244 30.2009C86.0873 30.6262 87.4498 30.837 88.5835 30.837C89.7171 30.837 91.0833 30.6262 92.0461 30.2009C93.009 29.7757 93.8374 29.1687 94.5351 28.3836C95.229 27.5985 95.7704 26.6607 96.1556 25.5703C96.5407 24.4799 96.7333 23.2586 96.7333 21.9065C96.7333 20.5762 96.5407 19.3586 96.1556 18.2573ZM88.489 27.8929C85.4042 27.8929 83.8491 25.2795 83.8491 22.0555C83.8491 18.8315 85.4005 16.2182 88.489 16.2182C91.5774 16.2182 93.1289 18.8315 93.1289 22.0555C93.1289 25.2795 91.5738 27.8929 88.489 27.8929Z" fill="#189EFF"/>\n        </svg>\n    </div>\n    <div>\n        <p><span style="font-weight: bold">{{ nameOfInviter }}</span> hat Dich eingeladen, am Shopware-Store <span style="font-weight: bold">{{ storeName }}</span> mitzuarbeiten.</p>\n        <p>Um Zugriff auf den Shop zu erhalten, logge Dich bitte entweder ein oder registriere Dich mit der E-Mail-Adresse <span style="font-weight: bold">{{ invitedEmailAddress }}</span>.</p>\n    </div>\n    <div style="padding-top: 25px;">\n        <a href="{{ signupUrl }}" style="border: 1px solid; border-radius: 5px; background: #0870FF; color: #fff; padding:10px 15px; text-decoration: none; font-size: 0.9em; font-weight:bold;">Loslegen</a>\n    </div>\n</div>\n</body>\n</html>\n', '{{ nameOfInviter }} hat Dich eingeladen, am Shopware-Store {{ storeName }} mitzuarbeiten.\n\nUm Zugriff auf den Shop zu erhalten, logge Dich bitte entweder ein oder registriere Dich mit der E-Mail-Adresse {{ invitedEmailAddress }}.\n\n{{ signupUrl }}\n', NULL, '[[regtime_]]', NULL),
('[p9bp', '/_MpXT|', 'Admin', '{{ nameOfInviter }} invited you to join {{ storeName }}', 'Shopware Sso admin Invitation', '<html lang="en">\n<head>\n    <title>Invitation</title>\n</head>\n<body style="font-family: Inter, Arial, Helvetica, sans-serif; font-weight: 500; line-height: 1.5;">\n<div style="width: 400px; padding: 50px;">\n    <div style="padding-bottom: 25px">\n        <svg width="186" height="40" viewBox="0 0 186 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n            <path d="M54.5636 20.1837C52.8632 19.4458 51.4643 18.777 51.4643 17.6684C51.4643 16.8906 52.3436 16.1528 53.826 16.1528C55.1559 16.1528 56.304 16.4872 57.4849 17.0033C57.8192 17.1523 58.3351 17.1886 58.5931 16.6689L59.1854 15.484C59.407 15.0405 59.2217 14.5208 58.8148 14.2264C57.9645 13.6703 56.1914 12.9688 53.8224 12.9688C49.6803 12.9688 47.9871 15.484 47.9871 17.6284C47.9871 20.4381 50.1635 21.8447 52.7869 23.0296C55.1522 24.1019 56.4457 24.8397 56.4457 25.9883C56.4457 26.9515 55.6319 27.653 54.1894 27.653C52.1546 27.653 50.9374 26.9515 49.9382 26.3954C49.495 26.1373 49.0153 26.2463 48.83 26.6171L48.0525 28.2091C47.8672 28.5798 48.0888 28.9106 48.3468 29.096C49.3097 29.7611 51.2681 30.8334 53.9677 30.8334C57.7756 30.8334 60.0683 28.5035 60.0683 25.8393C60.0719 22.6625 57.7065 21.5176 54.5636 20.1837Z" fill="#189EFF"/>\n            <path d="M31.8908 35.6202C30.154 34.3117 27.5924 33.3158 24.8819 32.2653C21.6554 31.015 17.9965 29.5938 15.2496 27.4094C12.1394 24.9305 10.6242 21.8046 10.6242 17.8537C10.6242 14.3062 12.0958 11.2749 14.879 9.08314C18.0001 6.62608 22.7309 5.32485 28.5553 5.32485C30.1649 5.32485 31.7019 5.42299 33.1262 5.61926C33.2533 5.63744 33.3733 5.56838 33.4241 5.4557C33.4786 5.33939 33.4496 5.20491 33.3551 5.12131C29.6853 1.81736 24.94 0 19.9985 0C14.6573 0 9.63591 2.07905 5.85712 5.85915C2.08197 9.63562 0 14.6588 0 19.9982C0 25.3412 2.07833 30.3644 5.85712 34.1408C9.63228 37.9173 14.6537 40 19.9985 40C24.3151 40 28.4245 38.6443 31.8872 36.0818C31.9598 36.0273 32.0034 35.9437 32.0034 35.8528C32.0034 35.7619 31.9635 35.6747 31.8908 35.6202Z" fill="#189EFF"/>\n            <path d="M39.9062 18.1512C39.8989 18.0749 39.8626 18.0022 39.8044 17.9549C35.6332 14.4911 32.2578 13.0771 28.1556 13.0771C25.9683 13.0771 24.2896 13.5169 23.1705 14.382C22.2004 15.1308 21.688 16.1776 21.688 17.4025C21.688 20.8373 25.8847 22.4038 30.7462 24.2175C33.2497 25.1517 35.8403 26.1185 38.2166 27.4379C38.2602 27.4633 38.3075 27.4742 38.3547 27.4742C38.3874 27.4742 38.4201 27.467 38.4528 27.4561C38.5291 27.427 38.5945 27.3688 38.6236 27.2889C39.5319 24.9627 39.9934 22.5092 39.9934 19.9976C39.9897 19.4088 39.9643 18.7873 39.9062 18.1512Z" fill="#189EFF"/>\n            <path d="M154.829 30.626C155.341 30.5679 155.693 30.1935 155.693 29.7283V21.0522C155.693 16.6142 155.152 13.1758 149.44 13.1758C146.159 13.1758 143.612 14.0627 143.303 14.179C142.878 14.3316 142.609 14.6042 142.726 15.2221L143.074 16.6905C143.191 17.1921 143.536 17.5411 144.077 17.4248C145.004 17.1558 147.009 16.5742 149.055 16.5742C151.293 16.5742 151.987 17.85 151.911 20.6669C151.911 20.6669 150.174 20.1253 148.321 20.1253C143.728 20.1253 141.181 22.597 141.181 25.8791C141.181 29.5865 143.532 30.8405 146.89 30.8405C149.629 30.8405 152.449 30.8078 153.622 30.7314L154.829 30.626ZM151.871 27.4784C151.33 28.3652 149.4 28.1435 147.743 28.1108C145.89 28.0708 144.964 27.4239 144.964 25.8391C144.964 23.9854 146.544 22.9059 148.63 22.9059C150.25 22.9059 151.642 23.3711 151.871 23.5238V27.4784Z" fill="#189EFF"/>\n            <path d="M183.969 12.9719C185.092 12.9719 186 12.0669 186 10.9474C186 9.82789 185.092 8.92285 183.969 8.92285C182.846 8.92285 181.938 9.82789 181.938 10.9474C181.938 12.0669 182.846 12.9719 183.969 12.9719ZM183.969 9.2209C184.91 9.2209 185.68 9.99873 185.68 10.9474C185.68 11.896 184.914 12.6739 183.969 12.6739C183.028 12.6739 182.261 11.896 182.261 10.9474C182.261 9.99873 183.028 9.2209 183.969 9.2209Z" fill="#189EFF"/>\n            <path d="M183.279 11.9731H183.468C183.497 11.9731 183.522 11.9477 183.522 11.9186V11.1735H183.965L184.347 11.9368C184.358 11.9622 184.376 11.9731 184.409 11.9731H184.627C184.677 11.9731 184.696 11.9258 184.677 11.8895L184.278 11.1444C184.532 11.0426 184.71 10.8209 184.71 10.5519C184.71 10.203 184.423 9.92676 184.074 9.92676H183.279C183.246 9.92676 183.224 9.9522 183.224 9.98128V11.9186C183.224 11.9477 183.246 11.9731 183.279 11.9731ZM183.529 10.2103H184.049C184.238 10.2103 184.405 10.3666 184.405 10.5592C184.405 10.7627 184.238 10.9227 184.049 10.9227H183.529V10.2103Z" fill="#189EFF"/>\n            <path d="M71.4301 12.9727C68.7304 12.9727 66.881 14.452 66.4777 14.7501V7.12082C66.4777 6.71373 66.0707 6.30664 65.6638 6.30664H63.5927C63.1494 6.30664 62.7788 6.71373 62.7788 7.12082V30.0231C62.7788 30.4666 63.1494 30.8373 63.5927 30.8373H65.6274C66.147 30.8373 66.4777 30.5029 66.4777 30.0231V18.9663C66.8483 18.2285 68.3271 16.4875 70.9504 16.4875C73.1705 16.4875 74.3514 18.1522 74.3514 20.9618V30.0268C74.3514 30.4702 74.722 30.8409 75.1653 30.8409H77.2363C77.6433 30.8409 78.0502 30.4702 78.0502 30.0268V21.0381C78.0466 16.3784 76.2735 12.9727 71.4301 12.9727Z" fill="#189EFF"/>\n            <path d="M114.73 21.2162C114.526 15.4115 112.096 12.9727 106.496 12.9727C103.808 12.9727 100.599 13.7796 100.127 13.9867C99.5457 14.2375 99.1169 14.5356 99.1169 14.9427V15.2807V16.5201V20.5329V21.0781V36.6892C99.1169 37.1326 99.4876 37.5033 99.9308 37.5033H101.646C102.202 37.5033 102.532 37.1689 102.532 36.6892L102.529 30.5429C103.048 30.6773 105.704 30.9027 107.921 30.8336C111.874 30.71 114.526 27.8386 114.748 22.9899C114.781 22.332 114.73 21.2162 114.73 21.2162ZM111.158 22.9863C111.082 26.2757 110.126 27.7296 107.358 27.8822C105.988 27.9586 102.754 27.5769 102.754 27.5769C102.62 27.5333 102.529 27.4752 102.529 27.3516L102.525 20.6855V16.9054C102.525 16.8036 102.601 16.72 102.703 16.7091C103.085 16.6692 104.484 16.2185 106.496 16.2185C109.868 16.2185 111.056 16.7128 111.165 20.9836C111.173 21.5469 111.176 22.3357 111.158 22.9863Z" fill="#189EFF"/>\n            <path d="M139.223 13.3434H137.672C137.228 13.3434 136.6 13.3434 136.378 13.8632L133.642 23.6987H133.569L128.984 13.3797C128.911 13.158 128.65 12.9727 128.246 12.9727H127.988C127.654 12.9727 127.396 13.158 127.287 13.3797L122.662 23.6623H122.589L119.78 13.8632C119.708 13.5288 119.337 13.3434 119.043 13.3434H116.823C116.231 13.3434 115.973 13.7868 116.231 14.3066L121.223 30.3938C121.296 30.6519 121.557 30.8373 121.924 30.8373H122.146C122.516 30.8373 122.738 30.6519 122.811 30.4302L128.061 18.8173H128.134L133.348 30.4302C133.46 30.6519 133.718 30.8373 134.085 30.8373H134.234C134.605 30.8373 134.936 30.6519 135.012 30.3938L139.892 14.3066C140.15 13.7868 139.815 13.3434 139.223 13.3434Z" fill="#189EFF"/>\n            <path d="M166.496 13.1758C166.405 13.1758 166.321 13.1831 166.23 13.1867C166.081 13.1831 165.936 13.1758 165.78 13.1758C164.893 13.1758 164.043 13.2049 163.247 13.2448C161.714 13.3066 160.806 13.4229 160.159 13.4956C160.159 13.4956 159.745 13.5356 159.261 13.5974C158.938 13.6374 158.702 13.7719 158.557 13.9572C158.458 14.0626 158.397 14.1971 158.397 14.3607V14.4189V14.7569V15.9963V19.4348V30.019C158.397 30.4625 158.767 30.8332 159.211 30.8332H160.911C161.612 30.8332 162.096 30.7605 162.096 30.019V19.4348V17.0068C162.096 16.905 162.255 16.7778 162.343 16.7233C162.76 16.4725 163.763 16.2907 165.78 16.2907C165.976 16.2907 166.103 16.2944 166.249 16.298C166.71 16.3416 167.44 16.4834 167.677 16.6179C168.047 16.8032 168.49 16.6905 168.712 16.2108L169.599 14.7605C170.155 13.6192 168.123 13.1758 166.496 13.1758Z" fill="#189EFF"/>\n            <path d="M178.199 12.9727C173.061 12.9727 169.697 17.0799 169.697 21.885C169.697 26.7664 173.061 30.8336 178.235 30.8336C181.08 30.8336 183.337 29.7977 184.557 28.7255C185.073 28.2821 184.928 27.9477 184.63 27.5806L183.631 26.0285C183.337 25.5851 183.002 25.6941 182.632 25.9558C181.596 26.6937 180.412 27.3988 178.453 27.3988C175.459 27.3988 173.388 25.0326 173.352 22.7391H185.146C185.517 22.7391 185.884 22.4411 185.924 21.9976C185.96 21.7032 185.996 21.1108 185.996 20.8127C185.996 16.2657 182.635 12.9727 178.199 12.9727ZM173.541 19.9986C173.799 17.8541 175.427 16.1167 178.126 16.1167C180.641 16.1167 182.268 17.9304 182.341 19.9986H173.541V19.9986Z" fill="#189EFF"/>\n            <path d="M96.1556 18.2573C95.7704 17.1559 95.229 16.2109 94.5351 15.4258C93.8411 14.6407 93.009 14.0337 92.0461 13.6085C91.0833 13.1832 89.7171 12.9688 88.5835 12.9688C87.4498 12.9688 86.0873 13.1832 85.1244 13.6085C84.1615 14.0337 83.3331 14.6407 82.6355 15.4258C81.9415 16.2109 81.4001 17.1559 81.015 18.2573C80.6298 19.3586 80.4373 20.5762 80.4373 21.9065C80.4373 23.2586 80.6298 24.4799 81.015 25.5703C81.4001 26.6607 81.9415 27.5985 82.6355 28.3836C83.3295 29.1687 84.1615 29.7757 85.1244 30.2009C86.0873 30.6262 87.4498 30.837 88.5835 30.837C89.7171 30.837 91.0833 30.6262 92.0461 30.2009C93.009 29.7757 93.8374 29.1687 94.5351 28.3836C95.229 27.5985 95.7704 26.6607 96.1556 25.5703C96.5407 24.4799 96.7333 23.2586 96.7333 21.9065C96.7333 20.5762 96.5407 19.3586 96.1556 18.2573ZM88.489 27.8929C85.4042 27.8929 83.8491 25.2795 83.8491 22.0555C83.8491 18.8315 85.4005 16.2182 88.489 16.2182C91.5774 16.2182 93.1289 18.8315 93.1289 22.0555C93.1289 25.2795 91.5738 27.8929 88.489 27.8929Z" fill="#189EFF"/>\n        </svg>\n    </div>\n    <div>\n        <p><span style="font-weight: bold">{{ nameOfInviter }}</span> has invited you to collaborate on the Shopware store <span style="font-weight: bold">{{ storeName }}</span>.</p>\n        <p>To get access to the store, please either log in or sign up using the email address <span style="font-weight: bold">{{ invitedEmailAddress }}</span>.</p>\n    </div>\n    <div style="padding-top: 25px;">\n        <a href="{{ signupUrl }}" style="border: 1px solid; border-radius: 5px; background: #0870FF; color: #fff; padding:10px 15px; text-decoration: none; font-size: 0.9em; font-weight:bold;">Get started</a>\n    </div>\n</div>\n</body>\n</html>\n', '{{ nameOfInviter }} has invited you to collaborate on the Shopware store {{ storeName }}.\n\nTo get access to the store, please either log in or sign up using the email address {{ invitedEmailAddress }}.\n\n{{ signupUrl }}\n', NULL, '[[regtime_]]', NULL),
('[2pٽOG', 'ZMp?X}', '{{ salesChannel.name }}', 'Kunden-Password geändert', NULL, '<div style="font-family:arial; font-size:12px;">\n    Hallo {{ customer.firstName }} {{ customer.lastName }},<br/>\n    <br/>\n    Das Passwort für Ihr {{ shopName }}-Konto wurde erfolgreich geändert. <br/>\n</div>\n', 'Hallo {{ customer.firstName }} {{ customer.lastName }},\n\nDas Passwort für Ihr {{ shopName }}-Konto wurde erfolgreich geändert.\n', NULL, '[[regtime_]]', NULL),
('[2pٽOG', '/_MpXT|', '{{ salesChannel.name }}', 'Customer password changed', NULL, '<div style="font-family:arial; font-size:12px;">\n    Hello {{ customer.firstName }} {{ customer.lastName }},<br/>\n    <br/>\n    Your {{ shopName }} account password has been changed successfully. <br/>\n</div>\n', 'Hello {{ customer.firstName }} {{ customer.lastName }},\n\nYour {{ shopName }} account password has been changed successfully.\n', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_type`
--

CREATE TABLE `mail_template_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `available_entities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.mail_template_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_type`
--

INSERT INTO `mail_template_type` VALUES
('Z\\pDVy', 'customer_register', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Z\\pDVy', 'newsletterDoubleOptIn', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Z\\pDVyJ', 'newsletterRegister', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Z\\pDVyP', 'order_confirmation_mail', '{"order":"order","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Z\\pDVyt', 'customer_group_change_accept', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVyڷ', 'customer_group_change_reject', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Z\\pDVy6', 'password_change', '{"customer":"customer","resetUrl":null,"salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL),
('Z\\pDVyەf', 'sepa_confirmation', '{"order":"order","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('Z\\pDVy܁7', 'product_stock_warning', '{"product":"product","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL);
INSERT INTO `mail_template_type` VALUES
('Z\\pDVyڷ', 'order_delivery.state.returned_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVy1', 'order_delivery.state.shipped_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVyݬ\n', 'order_delivery.state.returned', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVy', 'order_delivery.state.shipped', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVyޡi', 'order_delivery.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVys', 'order_transaction.state.reminded', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVyPe', 'order_transaction.state.refunded_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('Z\\pDVyٴ', 'order_transaction.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null