<?php
/**
 * Google Analytics administration panel.
 *
 * @package WordPress
 * @subpackage Administration
 */

/** WordPress Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

//Fetch data from database to show the value again.
$value = (array) get_option('sitepad_cookieconsent');
$value = array_merge($value, $_POST);

//Fetch the data from Post and Update
if(isset($_POST['cookiemsg'])){
	$value['cookiemsg'] = $_POST['cookiemsg'];
	$value['cookiemsg'] = wp_unslash($value['cookiemsg']);
}

if(isset($_POST['customlink'])){
	$value['customlink'] = rawurlencode($_POST['customlink']);
}

if(isset($_POST['dismissTxt'])){
	$value['dismissTxt'] = $_POST['dismissTxt'];
	$value['dismissTxt'] = wp_unslash($value['dismissTxt']);
}

if(!empty($_POST['policyTxt'])){
	$value['policyTxt'] = $_POST['policyTxt'];
	$value['policyTxt'] = wp_unslash($value['policyTxt']);
}

if(isset($_POST['submit']) || isset($_POST['edit_sitepad'])){
	
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	
	$value['cookieconsentOn'] = $_POST['cookieconsentOn'];
	
	// Set default value
	$values = $value;
	$values['post_popup_width'] = !empty($value['post_popup_width']) ? $value['post_popup_width'] : '100';
	$values['popup_ver_position'] = !empty($value['popup_ver_position']) ? $value['popup_ver_position'] : 'flex-end';
	$values['popup_animation'] = !empty($value['popup_animation']) ? $value['popup_animation'] : 'slideInUp';
	$values['popup_animation_delay'] = !empty($value['popup_animation_delay']) ? $value['popup_animation_delay'] : '600';

	// Popup attrs
	$popup_atts = array('post_popup_width', 'popup_hori_position', 'popup_ver_position', 'popup_border_radius', 'popup_animation', 'popup_animation_delay', 'trig_click_ele', 'popup_sel_close', 'popup_selector_close', 'popup_content_bg', 'popup_border_width',  'popup_border_color', 'post_popup_height', 'popup_cookie_selector', 'popup_border_type' );

	$atts = '';
	$message = !empty($value['cookiemsg']) ? $value['cookiemsg'] : 'This website uses cookies to ensure you get the best experience on our website.';
	$btn_text = !empty($value['dismissTxt']) ? $value['dismissTxt'] : 'Got It!';
	$policyTxt = !empty($value['policyTxt']) ? $value['policyTxt'] : 'Learn More';
	$btn_class = !empty($value['popup_selector_close']) ? $value['popup_selector_close'] : 'site-cookie-dismiss';

	// Set close selector
	$values['popup_selector_close'] = $values['popup_cookie_selector']  = '.'.$btn_class;

	foreach($values as $key => $val){
		if(in_array($key, $popup_atts)){
			$atts .= $key .'="'. $val .'" ';
		}
	}

	if( !empty($value['customlink']) ){
		$message .= ' <a href="'.$value['customlink'].'"> '. $policyTxt .' </a>';
	}

	$content = '[pl_popup popup_content_back="color" trig_load="true" popup_cookie_session="true" popup_sel_close="true" popup_cookie_name="site-cookie-consent" popup_cookie_exp="365" '.$atts.'][/pl_popup][pl_row stretch="auto" col_gap="10" width_content="auto" row_height="default" overlay_hover_delay="400" row_shape_top_color="#fff" row_shape_top_width="100" row_shape_top_height="100" row_shape_bottom_color="#fff" row_shape_bottom_width="100" row_shape_bottom_height="100" content_pos="center"][pl_col overlay_hover_delay="400" col_width="76.29"][pl_heading heading_state="normal" color="'. $value["color"]. '"]'. $message .'[/pl_heading][/pl_col][pl_col overlay_hover_delay="400" col_width="23.71"][pl_btn text="'. $btn_text .'" align="center" type="pagelayer-btn-custom" size="pagelayer-btn-small" btn_hover_delay="400" icon_position="pagelayer-btn-icon-left" icon_spacing="5" ele_classes="'. $btn_class .'" btn_typo=",15,,,,,Solid,,,1," btn_bg_color="'. $value['btn_bg_color'].'" btn_color="'. $value['btn_color'].'"][/pl_btn][/pl_col][/pl_row]';

	// We need to create the post
	if( empty($value['templ_id']) || empty(get_post((int)$value['templ_id'])) ){

		$ret = wp_insert_post([
			'post_type' => 'pagelayer-template',
			'post_title' => 'Cookie-Consent',
			'post_content' => $content,
			'post_status' => 'publish',
			'comment_status' => 'closed',
			'ping_status' => 'closed'
		]);
		
		$value['templ_id'] = $ret;
		
		// Save our template metas
		update_post_meta($ret, 'pagelayer_template_type', 'popup');
		update_post_meta($ret, 'pagelayer-data', time());
		
		update_option('sitepad_cookieconsent', $value);
		
	}else if( isset($_POST['submit']) ){
		
		// Save global widget content
		$post = array(
			'ID' => (int) $value['templ_id'],
			'post_content' => $content,
		);
		
		// Update the post into the database
		$ret = wp_update_post($post);
	}

	if( !empty($value['templ_id']) && !empty($value['cookieconsentOn']) ){
		
		$meta_array = get_post_meta($value['templ_id'], 'pagelayer_template_conditions', true);
		
		if( empty($meta_array) ){		
			$condi_array[0] = array(
				'type' => 'include',
				'template' => '',
				'sub_template' => '',
				'id' => '',
			);
			update_post_meta($value['templ_id'], 'pagelayer_template_conditions', $condi_array);
		}
		
	}else{
		update_post_meta($value['templ_id'], 'pagelayer_template_conditions', array());
	}

}

if(!empty($value['templ_id']) && isset($_POST['edit_sitepad']) ){
	$templ_link = wp_get_shortlink( (int)$value['templ_id'] );
	$templ_link .= substr_count($link, '?') > 0 ? '&pagelayer-live=1' : '&pagelayer-live=1';
 
	if( wp_redirect($templ_link) ){
		exit;
	}
}

// Include Admin Header
$title = __('Cookie Consent');

require_once( ABSPATH . 'site-admin/admin-header.php' );
echo '<script src="https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.0/spectrum.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.0/spectrum.min.css">';	

if(!empty($value) && !empty($_POST) && isset($_POST['submit']) ){
	$update = update_option('sitepad_cookieconsent', $value);
	echo '<div id="message" class="updated notice is-dismissible"><p>'.__('Cookie Consent settings has been saved successfully !').'</p></div>';
}

?>

<style>
.dashicons, .dashicons-before::before {
	width: 30px;
}
.sme-dash-header::before {
	font-size: 25px !important;
} 
.tab{
	display: inline-flex;
	width: 100%;
}
.form-table {
    clear: both;
    margin-top: 0.5em;
    width: 100%;
}
.form-table th {
    font-weight: 600;
    line-height: 1.3;
    padding: 20px 10px 20px 0;
    text-align: left;
    vertical-align: top;
    width: 200px;
}
.form-table th, .form-wrap label {
    color: #23282d;
    font-weight: 400;
    text-shadow: none;
    vertical-align: baseline;
}
.table_form{
	width: 100%;
}
input.regular-text {
    width: 25em;
}
#note{
    font-style: italic;
    padding-left: 25px;
}

#edit-note{
margin: 5px 0 15px;
background: #fff;
border-left: 4px solid #fff;
border-left-color: #46b450;
box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);
margin: 5px 15px 2px;
padding: 1px 12px;
}

.edit-warning{
border-left-color: #f13637 !important;
}
</style>

<script>
jQuery('document').ready( function(){
	var opts = {
		showInput: true,
		className: "full-spectrum",
		showInitial: true,
		showPalette: true,
		showSelectionPalette: true,
		maxSelectionSize: 20,
		preferredFormat: "hex",
		allowEmpty:true,
	};
	jQuery( '#bannerbg' ).spectrum( opts );
	jQuery( '#bannertxt' ).spectrum( opts );
	jQuery( '#buttonbg' ).spectrum( opts );
	jQuery( '#buttontxt' ).spectrum( opts );
	jQuery( '#popup_border_color' ).spectrum( opts );
	
	jQuery("#bannerbg").on("change.spectrum", function(){
		var banbg = jQuery("#bannerbg").spectrum("get");
		jQuery('input[name="popup_content_bg"]').attr('value', banbg);
	});
	jQuery("#bannertxt").on("change.spectrum", function(){
		var bantxt = jQuery("#bannertxt").spectrum("get");
		jQuery('input[name="color"]').attr('value', bantxt);
	});
	jQuery("#buttonbg").on("change.spectrum", function(){
		var btnbg = jQuery("#buttonbg").spectrum("get");
		jQuery('input[name="btn_bg_color"]').attr('value', btnbg);
	});
	jQuery("#buttontxt").on("change.spectrum", function(){
		var btntxt = jQuery("#buttontxt").spectrum("get");
		jQuery('input[name="btn_color"]').attr('value', btntxt);
	});
	jQuery("#popup_border_color").on("change.spectrum", function(){
		var btntxt = jQuery("#popup_border_color").spectrum("get");
		jQuery('input[name="popup_border_color"]').attr('value', btntxt);
	});
});

</script>

<div class="wrap">
<div class="bg">
	<h1><span class="dashicons sme-dash-header dashicons-warning"></span>
		<?php echo __('Cookie Consent'); ?> 
	</h1>
	<div id="edit-note" class="edit-warning">
		<p class="mb-0 p-2">
			<?php 
			echo __('<b>Deprecated:</b> This Cookie Consent method is deprecated. Please use the new <b>Cookieadmin</b> feature, which can be enabled from the ') 
			 . '<a href="' . admin_url('features.php') . '">Features page</a>.';
			?>
		</p>
	</div>
	<div class="tab">
		<form class="table_form" method="post" action="cookie-consent.php" novalidate="novalidate">
			<?php wp_nonce_field('sitepad-options') ?>
			<table class="form-table">
			<tbody>
				<tr>
				<th scope="row">
					<label for="TurnOnCC"><?php echo __('Turn on Cookie Consent'); ?></label>
				</th>
				<td>
					<?php 	
						echo '<input type="checkbox" name="cookieconsentOn" id="cookieconsentOn" 
						'.(!empty($value['cookieconsentOn']) ? 'checked="checked"' : '' ).' />';
					?>
				</td>
				</tr>
				<tr>
					<th scope="row">
						<label for=""><?php echo __('Banner Width'); ?></label>
					</th>
					<td>
						<?php 									
						echo '<input type="number" max="100" min="0" name="post_popup_width" value="'. (!empty($value['post_popup_width']) ? $value['post_popup_width'] : '').'" /> ( % )';
						?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for=""><?php echo __('Banner Horizontal Position'); ?></label>
					</th>
					<td>
						<?php 									
						echo '<input type="radio" name="popup_hori_position" value="flex-start" '.(!empty($value['popup_hori_position']) && $value['popup_hori_position'] == 'flex-start' ? 'checked="checked"' : '' ) .' /> '. __('Left') .'
						&nbsp; &nbsp;
						<input type="radio" name="popup_hori_position" value="center" '.(!empty($value['popup_hori_position']) && $value['popup_hori_position'] == 'center' ? 'checked="checked"' : '').' /> '. __('Center') .'
						&nbsp; &nbsp;
						<input type="radio" name="popup_hori_position" value="flex-end" '.(!empty($value['popup_hori_position']) && $value['popup_hori_position'] == 'flex-end' ? 'checked="checked"' : '').' /> '. __('Right');
						?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for=""><?php echo __('Banner Vertical Position'); ?></label>
					</th>
					<td>
						<?php 									
						echo '<input type="radio" name="popup_ver_position" value="flex-start" '.(!empty($value['popup_ver_position']) && $value['popup_ver_position'] == 'flex-start' ? 'checked="checked"' : '' ) .' />  '. __('Top') .'
						&nbsp; &nbsp;
						<input type="radio" name="popup_ver_position" value="center" '.(!empty($value['popup_ver_position']) && $value['popup_ver_position'] == 'center' ? 'checked="checked"' : '').' /> '. __('Middle') .'
						&nbsp; &nbsp;
						<input type="radio" name="popup_ver_position" value="flex-end" '.(!empty($value['popup_ver_position']) && $value['popup_ver_position'] == 'flex-end' ? 'checked="checked"' : '').' /> '. __('Bottom');
						?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label><?php echo __('Banner Animation'); ?></label>
					</th>
					<td>
						<?php 
						echo '<select name="popup_animation">
							<option value="slideInDown" '.(!empty($value['popup_animation']) && $value['popup_animation'] == 'slideInDown' ? 'selected="selected"' : '' ) .'> '. __('Slide In Down') .'</option>
							<option value="slideInUp" '.(!empty($value['popup_animation']) && $value['popup_animation'] == 'slideInUp' ? 'selected="selected"' : '' ) .'> '. __('Slide In Up') .'</option>
							<option value="slideInLeft" '.(!empty($value['popup_animation']) && $value['popup_animation'] == 'slideInLeft' ? 'selected="selected"' : '' ) .'> '. __('Slide In Left') .'</option>
							<option value="slideInRight" '.(!empty($value['popup_animation']) && $value['popup_animation'] == 'slideInRight' ? 'selected="selected"' : '' ) .'> '. __('Slide in Right') .'</option>
						</select>';
						?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for=""><?php echo __('Banner Animation Delay'); ?></label>
					</th>
					<td>
						<?php 									
						echo '<input type="number" name="popup_animation_delay" value="'.(!empty($value['popup_animation_delay']) ? $value['popup_animation_delay'] : '600').'" /> ( millisecond )';
						?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="BannerColor"><?php echo __('Banner Style'); ?></label>
					</th>
					<td>
						<table>
							<tr>
							<th scope="row">
								<label for="BannerBG"><?php echo __('Banner Background Color'); ?></label>
							</th>
							<td>
								<?php 	
									echo '<input type="text" name="popup_content_bg" id="bannerbg" value="'.
									(!empty($value['popup_content_bg']) ? $value['popup_content_bg'] : '#ffffff' ).'" />';
								?>
							</td>
							</tr>
							<tr>
							<th scope="row">
								<label for="BannerBG"><?php echo __('Banner Text Color'); ?></label>
							</th>
							<td>
								<?php 	
									echo '<input type="text" name="color" id="bannertxt" value="'.
									(!empty($value['color']) ? $value['color'] : '#000000' ).'" />';
								?>
							</td>
							</tr>
							<tr>
							<th scope="row">
								<label for="ButtonBG"><?php echo __('Button Background Color'); ?></label>
							</th>
							<td>
								<?php 	
									echo '<input type="text" name="btn_bg_color" id="buttonbg" value="'.(!empty($value['btn_bg_color']) ? $value['btn_bg_color'] : '#008000' ).'"/>';
								?>
							</td>
							</tr>
							<tr>
							<th scope="row">
								<label for="ButtonTxt"><?php echo __('Button Text Color'); ?></label>
							</th>
							<td>
								<?php 	
									echo '<input type="text" name="btn_color" id="buttontxt" value="'.(!empty($value['btn_color']) ? $value['btn_color'] : '#ffffff' ).'" />';
								?>
							</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="CCMessage"><?php echo __('Customize'); ?></label>
					</th>
					<td>
						<table width="100%">
							<tr>
								<th scope="row">
									<label for="BannerBG"><?php echo __('Custom Message'); ?></label>
								</th>
								<td>
									<textarea id="cookiemsg" class="regular-text" cols="20" rows="3" style="width:100%; max-width:350px; background: transparent none repeat scroll 0% 0% !important; z-index: auto; position: relative; line-height: 19.6px; font-size: 14px; transition: none 0s ease 0s;" name="cookiemsg" placeholder="<?php echo __('This website uses cookies to ensure you get the best experience on our website.'); ?>"><?php if(!empty($value['cookiemsg']) && $value['cookiemsg'] != __('This website uses cookies to ensure you get the best experience on our website.') ){ echo $value['cookiemsg']; } ?></textarea>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="DismissBtnText"><?php echo __('Dismiss Button Text'); ?></label>
								</th>
								<td>
									<input type="text" name="dismissTxt" placeholder="<?php echo __('Got It!'); ?>" style="width:60%" value="<?php if(!empty($value['dismissTxt']) && $value['dismissTxt'] != __('Got It!')){ echo $value['dismissTxt']; } ?>"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="popup_selector_close"><?php echo __('Dismiss Button Class'); ?></label>
								</th>
								<td>
									<input type="text" name="popup_selector_close" placeholder="<?php echo __('site-cookie-dismiss'); ?>" style="width:60%" value="<?php if(!empty($value['popup_selector_close']) && $value['popup_selector_close'] != __('site-cookie-dismiss')){ echo $value['popup_selector_close']; } ?>"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="PolicyTxt"><?php echo __('Policy Link Text'); ?></label>
								</th>
								<td>
									<input type="text" name="policyTxt" placeholder="<?php echo __('Learn More'); ?>" style="width:60%" value="<?php if(!empty($value['policyTxt']) && $value['policyTxt'] != __('Learn More')){ echo $value['policyTxt']; } ?>"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="CCLearnmore"><?php echo __('Learn More Link'); ?></label>
								</th>
								<td>
									<input type="text" name="customlink" placeholder="http://www.example.com/cookiepolicy.html" style="width:40%" value="<?php if(!empty($value['customlink'])){ echo rawurldecode($value['customlink']); } ?>"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</tbody>
			</table>
			
			<br />
			<center style="line-height: 2.5;">
				<input type="submit" name="submit" id="submit" class="button button-primary" value="Save Changes" />
				&nbsp; OR &nbsp;
				<input type="submit" name="edit_sitepad" id="edit_sitepad" class="button button-primary" value="Edit With Sitepad" />
			</center>
			<br />
			<div id="edit-note" class="note-info">
				<p class="mb-0 p-2"> <?php echo  __('<b> NOTE : - </b> You can enable cookie consent with the above form or with the SitePad Editor. The above form is a simple wizard while the SitePad Editor will allow you to do a visual edit of your cookie consent. If you edit your cookie consent from here, it will overwrite the contents of the cookie consent settings of the SitePad Editor and vice versa.');?> </p>
			</div>
	</div>
	<br/><br/>
</div>
</div>
<?php

require_once( ABSPATH . 'site-admin/admin-footer.php' ); ?>