<?php
/**
 * Google Analytics administration panel.
 *
 * @package WordPress
 * @subpackage Administration
 */

/** WordPress Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

$title = __('MailChimp');

require_once( ABSPATH . 'site-admin/admin-header.php' );

if(isset($_POST['mailchimp_popup'])){
	
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	
	$mailChimpPopUp = $_POST['mailchimp_popup'];
	
	$option = $_POST['option'];
	if(empty($option)){
		$_POST['selected_page'] = '';
	}
	
	$select_option = $_POST['selected_page'];
	
	$array = array('mailchimp_popup' => wp_unslash($mailChimpPopUp),
			'option' => $option,
			'selected_page' => array((!empty($select_option) ? $select_option : ''))
			);
	
	update_option('mail_chimp', $array);
	
	echo '<div id="message" class="updated notice is-dismissible"><p>'.__('MailChimp Code has been added successfully !').'</p></div>';
}

$value = get_option('mail_chimp');

?>
<style>
.dashicons, .dashicons-before::before {
	width: 30px;
}
.sme-dash-header::before {
	font-size: 25px !important;
}
.tab{
	display: inline-flex;
	width: 100%;
}
.form-table {
    clear: both;
    margin-top: 0.5em;
    width: 100%;
}
.form-table th {
    font-weight: 600;
    line-height: 1.3;
    padding: 20px 10px 20px 0;
    text-align: left;
    vertical-align: top;
    width: 200px;
}
.form-table th, .form-wrap label {
    color: #23282d;
    font-weight: 400;
    text-shadow: none;
    vertical-align: baseline;
}
.table_form{
	width: 100%;
}
input.regular-text {
    width: 25em;
}
#note{
    font-style: italic;
    padding-left: 25px;
}
</style>

<script>
jQuery('document').ready( function(){
	show_selection();
});

function show_selection(){
	if(jQuery('input:radio[name="option"]:checked').val() == 'choose_pages'){
		jQuery('#hidden_option').show();
	}else{
		jQuery('#hidden_option').hide();
		jQuery("input[name='selected_page']").prop('select', 'selected');	
	}	
}
</script>
	<div class="wrap">
		<div class="bg">
			<h1><span class="dashicons sme-dash-header dashicons-email-alt"></span>
				<?php echo __('MailChimp'); ?> 
			</h1>
			<div class="tab">
				<form class="table_form" method="post" action="mailchimp.php" novalidate="novalidate">
					<?php wp_nonce_field('sitepad-options') ?>
						<table class="form-table">
							<tbody>
							<tr>
								<th scope="row">
									<label for="ShowOnPages"><?php echo __('Show on Pages'); ?></label>
								</th>
								<td>
									<?php 									
									echo '<input id="all_pages" type="radio" name="option" value="" onclick="show_selection();"'.((empty($value['option'])) ? 'checked="checked"' : '').'/><label for="all_pages">All</label> &nbsp;&nbsp;
									<input id="choose_pages" type="radio" name="option" value="choose_pages" onclick="show_selection();"'.((!empty($value['option']) && ($value['option'] == 'choose_pages')) ? 'checked="checked"' : '').'/><label for="choose_pages">Selected</label>';
									?>
								</td>
							</tr>
							<tr id="hidden_option" style="display:none;">
								<th scope="row">
								</th>
								<td>
									<select name="selected_page">
									<?php
									$pages = get_pages();
									$i = 0;
									$option = '';
									foreach($pages as $page){
										if($page->ID != 1 && $page->ID != 2){										
											$option .= '<option value="'.$page->ID.'" '.((!empty($value['selected_page']) && $page->ID == $value['selected_page']) ? 'selected' : '').'>'.$page->post_title .' </option>';
										}
									}								
									echo $option;
								?></select>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="mailChimpPopUp"><?php echo __('Subscriber pop-up'); ?></label>
								</th>
								<td>
									<textarea id="mailChimpPopUp" class="regular-text" cols="40" rows="5" style="width: 100%; max-width: 1000px; background: transparent none repeat scroll 0% 0% !important; z-index: auto; position: relative; line-height: 19.6px; font-size: 14px; transition: none 0s ease 0s;" name="mailchimp_popup" ><?php if(!empty($value['mailchimp_popup'])){ echo $value['mailchimp_popup']; } ?></textarea>
									<p class="description"><?php echo __('Enter Code that you will get from MailChimp site'); ?></p>
								</td>
							</tr>
							</tbody>
						</table>
						<br /><br />
					<?php submit_button(); ?>
				</form>
			</div>
			<br/><br/>
		</div>
	</div>
<?php

require_once( ABSPATH . 'site-admin/admin-footer.php' ); ?>