<?php
/**
 * Tools Administration Screen.
 *
 * @package WordPress
 * @subpackage Administration
 */

/** WordPress Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

function setup_onboarding(){
	
	global $sitepad;
	
	if(isset($_POST['get_started'])){
		update_option('sp_setup_current_status', 1);
		sm_redirect('spurl=/site-admin/setup.php', 0);
		return true;
	}
	
	echo '
	<div class="container">	
	<h1 class="text-center sitepad-heading">'.__( 'Welcome to '.BRAND_SM_EDITOR ).'</h1><hr class="sitepad-hr"/>
	<p class="text-center sitepad-text mt-4">You are just 3 steps away from creating your awesome website</p>
		<div class="row text-center mt-5">
			<div class="col-sm-4 page-tile site-tile">
				<div class="setup-screenshot">
					<img src="'.sitepad_assets_url().'/images/themes_collage.png" class="screenshot-img mx-auto"/>
					<div class="align-middle mt-2 screenshot-title">1. '.__('Choose a theme').'</div>
					<div class="align-middle screenshot-details">
						'.__('Choose a theme for your website').'
					</div>
				</div>				
			</div>
			<div class="col-sm-4 page-tile site-tile">
				<div class="setup-screenshot">
					<img src="'.sitepad_assets_url().'/images/site_details.png" class="screenshot-img mx-auto"/>
					<div class="align-middle mt-2 screenshot-title">2. '.__('Site Details').'</div>
					<div class="align-middle screenshot-details">
						'.__('Enter site details like site name, email, etc.').'
					</div>
				</div>				
			</div>
			<div class="col-sm-4 page-tile site-tile">
				<div class="setup-screenshot">
					<img src="'.sitepad_assets_url().'/images/complete_setup.png" class="screenshot-img mx-auto"/>
					<div class="align-middle mt-2 screenshot-title">3. '.__('Complete Setup').'</div>
					<div class="align-middle screenshot-details">
						'.__('Setup will do the magic').'
					</div>
				</div>				
			</div>
		</div>
	</div>
	<br />
	<form method="post">
	<center>
		<input type="submit" class="button button-primary" name="get_started" value="'.__( 'Get Started' ).'" />
	</center>
	</form>';
	
}

function setup_theme(){
	
	if(isset($_POST['select_theme'])){
		$theme_slug = optPOST('theme_name');
		
		if(empty($theme_slug)){
			$error['empty_theme'] = 'Theme name was not posted';
		}
		
		if(empty($error)){
			
			sitepad_setup_start($theme_slug);
			
			update_option('sp_setup_current_status', 2);
			sm_redirect('spurl=/site-admin/setup.php', 0);
			return true;
		}
	}
	
	// Include the theme setup file
	include_once('themes_setup.php');
}

//var_dump(function_exists('our_error_handle'));die();
function setup_details(){
	
	global $setup_fields;
	
	if(isset($_POST['complete_setup'])){
		
		foreach($setup_fields as $sk => $sv){
			$setup_fields[$sk]['value'] = optPOST($sk);
		}
		
		if(!empty($setup_fields['pagelayer_cf_to_email']['value']) && !emailvalidation($setup_fields['pagelayer_cf_to_email']['value'])){
			$error['invalid_email'] = 'Email address is invalid';
		}
		
		// Make sure we have the full url
		if(!empty($setup_fields['pagelayer-facebook-url']['value']) && !preg_match('/^http/is', $setup_fields['pagelayer-facebook-url']['value'])){
			if(!preg_match('/^facebook/is', $setup_fields['pagelayer-facebook-url']['value'])){
				$setup_fields['pagelayer-facebook-url']['value'] = 'facebook.com/'.ltrim($setup_fields['pagelayer-facebook-url']['value'], '/');
			}
			$setup_fields['pagelayer-facebook-url']['value'] = 'https://'.$setup_fields['pagelayer-facebook-url']['value'];
		}
		
		// Make sure we have the full url
		if(!empty($setup_fields['pagelayer-twitter-url']['value']) && !preg_match('/^http/is', $setup_fields['pagelayer-twitter-url']['value'])){
			if(!preg_match('/^twitter/is', $setup_fields['pagelayer-twitter-url']['value'])){
				$setup_fields['pagelayer-twitter-url']['value'] = 'twitter.com/'.ltrim($setup_fields['pagelayer-twitter-url']['value'], '/');
			}
			$setup_fields['pagelayer-twitter-url']['value'] = 'https://'.$setup_fields['pagelayer-twitter-url']['value'];
		}
		
		// Make sure we have the full url
		if(!empty($setup_fields['pagelayer-instagram-url']['value']) && !preg_match('/^http/is', $setup_fields['pagelayer-instagram-url']['value'])){
			if(!preg_match('/^instagram/is', $setup_fields['pagelayer-instagram-url']['value'])){
				$setup_fields['pagelayer-instagram-url']['value'] = 'instagram.com/'.ltrim($setup_fields['pagelayer-instagram-url']['value'], '/');
			}
			$setup_fields['pagelayer-instagram-url']['value'] = 'https://'.$setup_fields['pagelayer-instagram-url']['value'];
		}
		
		// Make sure we have the full url
		if(!empty($setup_fields['pagelayer-linkedin-url']['value']) && !preg_match('/^http/is', $setup_fields['pagelayer-linkedin-url']['value'])){
			if(!preg_match('/^linkedin/is', $setup_fields['pagelayer-linkedin-url']['value'])){
				$setup_fields['pagelayer-linkedin-url']['value'] = 'linkedin.com/'.ltrim($setup_fields['pagelayer-linkedin-url']['value'], '/');
			}
			$setup_fields['pagelayer-linkedin-url']['value'] = 'https://'.$setup_fields['pagelayer-linkedin-url']['value'];
		}
		
		// Make sure we have the full url
		if(!empty($setup_fields['pagelayer-youtube-url']['value']) && !preg_match('/^http/is', $setup_fields['pagelayer-youtube-url']['value'])){
			if(!preg_match('/^youtube/is', $setup_fields['pagelayer-youtube-url']['value'])){
				$setup_fields['pagelayer-youtube-url']['value'] = 'youtube.com/'.ltrim($setup_fields['pagelayer-youtube-url']['value'], '/');
			}
			$setup_fields['pagelayer-youtube-url']['value'] = 'https://'.$setup_fields['pagelayer-youtube-url']['value'];
		}
		
		// Make sure we have the full url
		if(!empty($setup_fields['pagelayer-gplus-url']['value']) && !preg_match('/^http/is', $setup_fields['pagelayer-gplus-url']['value'])){
			if(!preg_match('/^plus\./is', $setup_fields['pagelayer-gplus-url']['value'])){
				$setup_fields['pagelayer-gplus-url']['value'] = 'plus.google.com/'.ltrim($setup_fields['pagelayer-gplus-url']['value'], '/');
			}
			$setup_fields['pagelayer-gplus-url']['value'] = 'https://'.$setup_fields['pagelayer-gplus-url']['value'];
		}
		
		// Complete the setup as no errors
		if(empty($error)){
			
			//r_print($setup_fields);
			foreach($setup_fields as $sk => $sv){
				// We are not checking !empty because if a user wants to set the field as empty it should update it
				update_option($sk, $setup_fields[$sk]['value']);
			}
			
			sitepad_setup_final();
			
			update_option('sp_setup_current_status', 3);
			
			// sp_setup_done is updated in switch_theme() function called above
			
			$done = 1;
		}
	}
	//r_print($setup_fields);
	
	if(!empty($done)){
		
		$home = get_page_by_path('home');
		$link = pagelayer_livelink($home->ID);
			
		echo '
<div class="alert alert-success col-md-6 mx-auto mt-4">
	<h4 class="alert-heading">'.__('Setup Complete !').'</h4>
	<p style="font-size: 14px">'.__('Setup has been completed successfully !').' '.__('You will now be redirected to the').' <a class="alert-link" id="setup_home_link" href="'.$link.'">'.BRAND_SM_EDITOR.'</a> '.__('in').' <span id="setup_redirect_timer">5</span> '.__('seconds').'.</p>
	<hr>
	<p style="font-size: 14px">'.__('Happy website building from the').' '.BRAND_SM_EDITOR.' '.__('Team !').'</p>
</div>

<script>
function redirect_timer() {
	var time_shower = $("#setup_redirect_timer");
	var time_left = parseInt(time_shower.html());
	
	if(time_left == 1){
		window.location = $("#setup_home_link").attr("href");
		return;
	}
	
	time_shower.html(time_left - 1);
	
	// Set a timeout
	tid = setTimeout(redirect_timer, 1000);
}
var tid = setTimeout(redirect_timer, 1000);
</script>';
		
		return true;
		
	}
	
	echo '
	<script>
		function toggle_additional(){
			$("#additional_details").toggle(500);
			$("#toggle_additional_link").toggleClass("dashicons-minus dashicons-plus");
		}
		
		function submit_details_form(ele){
			var form = $(ele).closest("form");
			var submit = $(ele);
			
			var modal = $("#sitepad-download-img-modal");
			modal.modal("show");
			
			var submitForm = function(){
				form.submit();
				modal.modal("hide");
			};
			
			modal.find(".sitepad-download-image").unbind("click");
			modal.find(".sitepad-download-image").on("click", function(){
				modal.find("[name=download_imgs]").prop("checked", true);
				submitForm();
			});
			
			modal.find(".sitepad-download-image-no").unbind("click");
			modal.find(".sitepad-download-image-no").on("click", function(){
				submitForm();
			});
		}
	</script>
	
	<div class="container">
	
	<h1 class="text-center mt-1" style="padding-top:25px;">'.__('Enter your Site Details').'</h1><hr class="sitepad-hr mt-1 mb-2"/>
	<p align="center" class="mb-5" style="font-size:14px;">'.__('These details will be used to pre fill the information for your website. <br />All fields are <b>OPTIONAL</b> and can be edited later.').'</p>
	<form action="setup.php" method="post" class="setup-form">';
	
	echo error_handle($error, '100%', false, false, 'offset-sm-2 col-sm-8');
	
	echo '
	<div class="modal" tabindex="-1" role="dialog" id="sitepad-download-img-modal">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">'.__('Image Copyright').'</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<p>'. __('We try our best to use images that are free from legal perspectives. However, we do not take any responsibility for the same. Do you want to use the demo images with this theme ?').'</p>
					<p>'. __('If you click <b>Yes</b>, then the images will be downloaded from their respective sources. If you click <b>No</b>, then we will use placeholder images which are distributed with this theme and can be replaced easily.').'</p>
				</div>
				<div class="modal-footer">
					<div style="display:none;">
						<input type="checkbox" class="form-control" name="download_imgs" id="download_imgs"/>
					</div>
					<button type="button" class="btn btn-primary sitepad-download-image">'.__('Yes').'</button>
					<button type="button" class="btn btn-secondary sitepad-download-image-no">'.__('No').'</button>
				</div>
			</div>
		</div>
	</div>
	<div class="row justify-content-sm-center">
	<div class="col-4">
		<div class="row" style="font-size:20px;color:#666666;">
			<div class="w-100">
				<h3 class="sitepad-sub-heading d-inline-block">'.__('Site details').'</h3>
			</div>
			<hr class="sitepad-hr m-0 mt-1" style="width:50px;"/>
		</div>
	</div>
	<div class="offset-sm-1 col-4">
		<div class="row" style="font-size:20px;color:#666666;">
			<div class="w-100">
				<h3 class="sitepad-sub-heading d-inline-block">'.__('Social Media').'</h3>
			</div>
			<hr class="sitepad-hr m-0 mt-1" style="width:50px;"/>
		</div><br />
	</div>
	
	<div class="col-4">
		<div class="row mb-3">
			<label for="blogname" class="setup-field-head">'.$setup_fields['blogname']['heading'].'</label>
			<input type="text" class="form-control" name="blogname" id="blogname" value="'.aPOSTval('blogname', (!empty($setup_fields['blogname']['value']) ? $setup_fields['blogname']['value'] : $setup_fields['blogname']['default'])).'" />
			<label class="setup-field-exp">'.$setup_fields['blogname']['exp'].'</label>
		</div>
		
		<div class="row mb-3">
			<label for="blogdescription" class="setup-field-head">'.$setup_fields['blogdescription']['heading'].'</label>
			<input type="text" class="form-control" name="blogdescription" id="blogdescription" value="'.aPOSTval('blogdescription', (!empty($setup_fields['blogdescription']['value']) ? $setup_fields['blogdescription']['value'] : $setup_fields['blogdescription']['default'])).'" />
			<label class="setup-field-exp">'.$setup_fields['blogdescription']['exp'].'</label>
		</div>
		
		<div class="row mb-3">
			<label for="pagelayer_cf_to_email" class="setup-field-head">'.$setup_fields['pagelayer_cf_to_email']['heading'].'</label>
			<input type="text" class="form-control" name="pagelayer_cf_to_email" id="pagelayer_cf_to_email" placeholder="'.$setup_fields['pagelayer_cf_to_email']['default'].'" value="'.aPOSTval('pagelayer_cf_to_email', get_option('pagelayer_cf_to_email')).'" />
			<label class="setup-field-exp">'.$setup_fields['pagelayer_cf_to_email']['exp'].'</label>
		</div>
		
		<div class="row mb-3">
			<label for="pagelayer-phone" class="setup-field-head">'.$setup_fields['pagelayer-phone']['heading'].'</label>
			<input type="text" class="form-control" name="pagelayer-phone" id="pagelayer-phone" placeholder="'.$setup_fields['pagelayer-phone']['default'].'" value="'.aPOSTval('pagelayer-phone', get_option('pagelayer-phone')).'" />
			<label class="setup-field-exp">'.$setup_fields['pagelayer-phone']['exp'].'</label>
		</div>
		
		<div class="row mb-3">
			<label for="pagelayer-address" class="setup-field-head">'.$setup_fields['pagelayer-address']['heading'].'</label>
			<input type="text" class="form-control" name="pagelayer-address" id="pagelayer-address" placeholder="'.$setup_fields['pagelayer-address']['default'].'" value="'.aPOSTval('pagelayer-address', get_option('pagelayer-address')).'" />
			<label class="setup-field-exp">'.$setup_fields['pagelayer-address']['exp'].'</label>
		</div>
	</div>
	
	
	<div class="offset-sm-1 col-4">
		<div class="row mb-3">
			<label for="pagelayer-facebook-url" class="setup-field-head">'.$setup_fields['pagelayer-facebook-url']['heading'].'</label>
			<input type="text" class="form-control" name="pagelayer-facebook-url" id="pagelayer-facebook-url" placeholder="'.$setup_fields['pagelayer-facebook-url']['default'].'" value="'.aPOSTval('pagelayer-facebook-url', get_option('pagelayer-facebook-url')).'" />
			<label class="setup-field-exp">'.$setup_fields['pagelayer-facebook-url']['exp'].'</label>
		</div>
		
		<div class="row mb-3">
			<label for="pagelayer-twitter-url" class="setup-field-head">'.$setup_fields['pagelayer-twitter-url']['heading'].'</label>
			<input type="text" class="form-control" name="pagelayer-twitter-url" id="pagelayer-twitter-url" placeholder="'.$setup_fields['pagelayer-twitter-url']['default'].'" value="'.aPOSTval('pagelayer-twitter-url', get_option('pagelayer-twitter-url')).'" />
			<label class="setup-field-exp">'.$setup_fields['pagelayer-twitter-url']['exp'].'</label>
		</div>
		
		<div class="row mb-3">
			<label for="pagelayer-instagram-url" class="setup-field-head">'.$setup_fields['pagelayer-instagram-url']['heading'].'</label>
			<input type="text" class="form-control" name="pagelayer-instagram-url" id="pagelayer-instagram-url" placeholder="'.$setup_fields['pagelayer-instagram-url']['default'].'" value="'.aPOSTval('pagelayer-instagram-url', get_option('pagelayer-instagram-url')).'" />
			<label class="setup-field-exp">'.$setup_fields['pagelayer-instagram-url']['exp'].'</label>
		</div>
		
		<div class="row mt-4 mb-2">
			<label class="setup-field-head" onclick="toggle_additional();">
				<span class="icon-square"><i class="dashicons dashicons-plus" id="toggle_additional_link" style="font-size:19px;"></i></span>
				&nbsp;'.__('More Profiles').'
			</label>
		</div>
		
		<div class="row" id="additional_details" style="display:none;">
			<div class="col-12">
				<br />
				<div class="row mb-3">
					<label for="pagelayer-linkedin-url" class="setup-field-head">'.$setup_fields['pagelayer-linkedin-url']['heading'].'</label>
					<input type="text" class="form-control" name="pagelayer-linkedin-url" id="pagelayer-linkedin-url" placeholder="'.$setup_fields['pagelayer-linkedin-url']['default'].'" value="'.aPOSTval('pagelayer-linkedin-url', get_option('pagelayer-linkedin-url')).'" />
					<label class="setup-field-exp">'.$setup_fields['pagelayer-linkedin-url']['exp'].'</label>
				</div>
				
				<div class="row mb-3">
					<label for="pagelayer-youtube-url" class="setup-field-head">'.$setup_fields['pagelayer-youtube-url']['heading'].'</label>
					<input type="text" class="form-control" name="pagelayer-youtube-url" id="pagelayer-youtube-url" placeholder="'.$setup_fields['pagelayer-youtube-url']['default'].'" value="'.aPOSTval('pagelayer-youtube-url', get_option('pagelayer-youtube-url')).'" />
					<label class="setup-field-exp">'.$setup_fields['pagelayer-youtube-url']['exp'].'</label>
				</div>
				
				<div class="row mb-3">
					<label for="pagelayer-gplus-url" class="setup-field-head">'.$setup_fields['pagelayer-gplus-url']['heading'].'</label>
					<input type="text" class="form-control" name="pagelayer-gplus-url" id="pagelayer-gplus-url" placeholder="'.$setup_fields['pagelayer-gplus-url']['default'].'" value="'.aPOSTval('pagelayer-gplus-url', get_option('pagelayer-gplus-url')).'" />
					<label class="setup-field-exp">'.$setup_fields['pagelayer-gplus-url']['exp'].'</label>
				</div>
			</div>
		</div>
	</div>
	
	<div class="col-8 mt-4">
		<div class="row justify-content-sm-center">
			<div class="col-sm-2">
				<input type="hidden" name="complete_setup" value="1" />
				<input type="button" class="button button-primary" name="proceed_setup" onclick="submit_details_form(this)" value="'.__( 'Proceed with Install' ).'" />
			</div>
		</div>
	</div>
				
	<center>
		<br>
		<input type="checkbox" name="sitepad_dev_mode" value="1" />
		'.$setup_fields['sitepad_dev_mode']['heading'].' <label class="setup-field-exp">'.$setup_fields['sitepad_dev_mode']['exp'].'</label>
	</center>
	
	</div>
	</form>
	';
}

function setup_complete(){
	
	global $sitepad;
	
	// Reset the setup
	if(isset($_POST['reset_setup'])){
		update_option('sp_setup_current_status', 0);
		delete_option('sp_setup_done');
		sm_redirect('spurl=/site-admin/setup.php', 0);
		return true;
	}
	
	echo '
	<div class="container">
	<br /><br />
	<div class="row justify-content-sm-center">
	<div class="col-sm-6">
	<div class="alert alert-success text-center">
		'.__('Setup Completed Successfully !').'
	</div>
	<p align="center">'.__('You will now be redirected to the editor').'</p>
	</div>
	</div>
	
	<form method="post">
	<center>
		<input type="submit" class="button button-primary button-large" name="reset_setup" value="'.__( 'Reset and start setup again' ).'" />
	</center>
	</form>';
	
}

// If the site was reset we need to delete all the setup data
function setup_clear_data(){
	
	global $setup_fields;
	
	foreach($setup_fields as $sk => $sv){
		if(preg_match('/^sp_/is', $sk)){
			delete_option($sk);
		}
	}
	
	delete_option('sp_setup_selected_theme');
	delete_option('sp_setup_current_status');
	delete_option('sp_setup_clear_data');
	
	return true;
}

$setup_fields = array('blogname' => array('heading' => __('Title'),
									'exp' => __('Short Title or your company name'), 
									'default' => get_option('blogname') ? get_option('blogname') : 'My Website'), 
					'blogdescription' => array('heading' => __('Description'),
									'exp' => __('Short description of your site / company'), 
									'default' => get_option('blogdescription') ? get_option('blogdescription') : 'Built with SitePad'), 
					'pagelayer_cf_to_email' => array('heading' => __('Email'),
									'exp' => __('Used on the Contact page'), 
									'default' => get_option('pagelayer_cf_to_email') ? get_option('pagelayer_cf_to_email') : 'mail@example.com'), 
					'pagelayer-phone' => array('heading' => __('Phone'),
									'exp' => __('Used on the Contact page'), 
									'default' => '+1(123)456-7890'),
					'pagelayer-address' => array('heading' => __('Address'),
									'exp' => __('Used on the Contact page'), 
									'default' => __('123, Street name, City, State, Pin, Country')), 
					'pagelayer-facebook-url' => array('heading' => __('Facebook'),
									'exp' => __('Link to your Facebook page'), 
									'default' => 'https://facebook.com/yourhandle'), 
					'pagelayer-twitter-url' => array('heading' => __('Twitter'),
									'exp' => __('Link to your Twitter profile'), 
									'default' => 'https://twitter.com/yourhandle'), 
					'pagelayer-instagram-url' => array('heading' => __('Instagram'),
									'exp' => __('Link to your Instagram page'), 
									'default' => 'https://instagram.com/yourhandle'), 
					'pagelayer-linkedin-url' => array('heading' => __('LinkedIn'),
									'exp' => __('Link to your LinkedIn page'), 
									'default' => 'https://linkedin.com/yourhandle'), 
					'pagelayer-youtube-url' => array('heading' => __('YouTube'),
									'exp' => __('Link to your YouTube channel'), 
									'default' => 'https://youtube.com/yourchannel'), 
					'pagelayer-gplus-url' => array('heading' => __('Google+'),
									'exp' => __('Link to your Google+ page'), 
									'default' => 'https://plus.google.com/yourhandle'),
					'sitepad_dev_mode' => array('heading' => __('Enable Dev Mode'),
									'exp' => __('(If checked, your site will be visible only if you are logged in !)'),
						),
					);
//r_print($setup_fields);		
/*function died(){
	print_r(error_get_last());
}
register_shutdown_function('died');*/

set_time_limit(500);

$sp_setup_clear_data = get_option('sp_setup_clear_data');

// If the site was reset we need to delete all the setup data
if(!empty($sp_setup_clear_data)){
	setup_clear_data();
}

$current_status = (int) get_option('sp_setup_current_status');
$setup_done = (int) get_option('sp_setup_done');

if(!empty($setup_done)){
	wp_redirect(admin_url());
}

//echo $current_status;

$title = __('Setup Site');

wp_register_style('setup-wizard', sitepad_assets_url().'/css/setup.css');
wp_enqueue_style('setup-wizard');

require_once( ABSPATH . 'site-admin/admin-header.php' );

?>
<script>

var current_status = '<?php echo $current_status; ?>';

function set_tab_active(step){
	$(".setup-nav").children("span").removeClass("active");
	$("#step-"+step+"-tab").addClass("active");
}

function try_full_screen(){
	try{
		
		// Do we need to set default mode as contracted ?
		var full = getcookie('sp-setup-fullscreen') || 1;
		set_fullscreen(full);
	
	}catch(e){}
};

try_full_screen();

jQuery(document).ready(function(){
	
	set_tab_active(current_status);
	
	try_full_screen();
	
	$('.submenu').click(function () {
		$(".submenu-item").toggleClass("col-lg-2 d-none");
		$(".themes-data").toggleClass("col-lg-10 col-lg-12");
	});
	
});
</script>

<div class="wrap setup-fullscreen-dn" id="setup_screen">
<div class="bg">

<div class="">
<div class="row" style="margin:0px;">
	<div class="col-sm-12 setup-nav" id="setup-nav">
		<span class="setup-nav-object" id="step-0-tab" data-id="0">Overview</span>		
		<i class="dashicons-before dashicons-arrow-right-alt2 setup-nav-object"></i>
		<span class="setup-nav-object" id="step-1-tab" data-id="1">Theme</span>
		<i class="dashicons-before dashicons-arrow-right-alt2 setup-nav-object"></i>
		<span class="setup-nav-object" id="step-2-tab" data-id="2">Details</span>
		<i class="dashicons-before dashicons-arrow-right-alt2 setup-nav-object"></i>
		<span class="setup-nav-object" id="step-3-tab" data-id="3">Complete</span>
		<i class="dashicons dashicons-editor-contract toggle-setup-page" onclick="set_fullscreen(-1)" style="cursor: pointer;" id="toggle-fullscreen"></i>
	</div>
</div>
</div>

<?php 
if ( current_user_can('edit_posts') ){

	switch($current_status){
		
		// Onboarding page
		default:
		setup_onboarding();
		break;
		
		// Choose Theme
		case 1:
		setup_theme();
		break;
		
		// Enter details
		case 2:
		setup_details();
		break;
		
		// Setup Complete
		case 3:
		setup_complete();
		break;
		
	}

}

?>
</div>
</div>
<?php
include( ABSPATH . 'site-admin/admin-footer.php' );
