<?php

// We need the ABSPATH
if (!defined('ABSPATH')) exit;

function pagelayer_sc_dm_sidebar(&$el){

	$html = '';
	$nav_list = wp_list_pages(
		array(
				'title_li'  => '',
				'order'	  => 'menu_order',
				'child_of'  => empty($el['atts']['hide_parent']) ? 0 : documentor()->get_current_doc_id(),
				'echo'	=> false,
				'post_type' => 'docs',
				'walker'	 => new Documentor_Walker_Docs(),
		)
	);

	if($nav_list){
		$html  = '<a class="documentor-sidebar-toggler"><i class="fas fa-times"></i></a>';
		$html .= '<ul class="documentor-nav-list'.( $el['atts']['show_child'] ? ' documentor-nav-list-show-childs' : '' ) .'">';
		$html .=  $nav_list;
		$html .= '</ul>';
	} 

	$el['atts']['post_html'] = $html;
}

function pagelayer_sc_dm_feedback(&$el){
	
	$show_counts = $el['atts']['show_counts'];
	$positive_title = $el['atts']['positive_title'];
	$negative_title = $el['atts']['negative_title'];
	$el['atts']['pcount'] = '';
	$el['atts']['ncount'] = '';
	$no_votes = $el['atts']['no_votes'];
	$positive = (int) get_post_meta( get_the_ID(), 'positive', true );
	$negative = (int) get_post_meta( get_the_ID(), 'negative', true );

	if($show_counts){
		$el['atts']['positive_title'] = $positive ? sprintf( _n( '%d ' . $positive_title, '%d ' . $positive_title, $positive, 'documentor' ), number_format_i18n( $positive ) ) : __( $no_votes, 'documentor' );
		$el['atts']['negative_title'] = $negative ? sprintf( _n( '%d ' . $negative_title, '%d ' . $negative_title, $negative, 'documentor' ), number_format_i18n( $negative ) ) : __( $no_votes, 'documentor' );
	}

	if($positive){ 
		$el['atts']['pcount'] = '<span class="badge">'. esc_html( number_format_i18n( $positive ) ) .'</span>';
	} 

	if($negative){ 
		$el['atts']['ncount'] = '<span class="badge">'. esc_html( number_format_i18n( $negative ) ) .'</span>';
	}
	
}

function pagelayer_sc_dm_article(&$el){

	$children = wp_list_pages( 'title_li=&order=menu_order&child_of=' . get_the_ID() . '&echo=0&depth=1&post_type=' . get_post_type() );

	if(!$children && (pagelayer_is_live() ||  wp_doing_ajax())){
		$children = '<li class="page_item"><a href="javascript_void(0)">Sub Category 1</a></li><li class="page_item"><a href="javascript_void(0)">Sub Category 2</a></li>';
	}

	if(!$children){
		$el['atts']['heading'] = '';	
	}
	 
	$el['atts']['post_html'] = $children;
}
function pagelayer_sc_dm_title(&$el){

	global $post;

	$title =  pagelayer_is_live() ? "Title" : get_the_title( );

	$el['atts']['title'] = $title;
}

function pagelayer_sc_dm_breadcrumbs(&$el){
	
	$breadcrumbs = documentor()->get_breadcrumbs_array();
	$html = '';
	
	foreach( $breadcrumbs as $k => $crumb ){
		if( $k > 0 ){ 
			$html .= '<li class="delimiter">'. $el['atts']['separator'].'</li>';
		}
		
		$html .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">';
		
		if(isset($crumb['url'])) $html .= '<a itemprop="item" href="'. esc_url( $crumb['url'] ).'">';
		
		$html .= '<span itemprop="name">'. esc_html( $crumb['label'] ) .'</span>';
		
		if(isset($crumb['url'])) $html .= '</a>';
		
		$html .= '<meta itemprop="position" content="'. esc_attr( $k + 1 ) .'" />';
		$html .= '</li>';
	}

	$el['atts']['post_html'] = $html;
}

function pagelayer_sc_dm_adjacent_links(&$el){
	
	$html = '';
	$prev_post_id = documentor()->get_previous_adjacent_doc_id();
	$next_post_id = documentor()->get_next_adjacent_doc_id();

	if($prev_post_id || $next_post_id){
		
		$html = '<nav class="documentor-single-adjacent-nav">';
	  
		if( $prev_post_id ){
			$html .= '<span class="nav-previous">';
			$html .= '<a href="'.esc_url( get_the_permalink( $prev_post_id ) ) .'" class="documentor-btn documentor-btn-md">'. esc_html( get_the_title( $prev_post_id ) ) .'</a>';
			$html .= '</span>';
		}
	  
		if( $next_post_id ){
			$html .= '<span class="nav-next">';
			$html .= '<a href="'.esc_url( get_the_permalink( $next_post_id ) ) .'" class="documentor-btn documentor-btn-md">'. esc_html( get_the_title( $next_post_id ) ) .'</a>';
			$html .= '</span>';
		}
	  
		$html .= '</nav>';
	}

	$el['atts']['post_html'] = $html;
}

function pagelayer_sc_dm_archive_box(&$el){
	global $wp_query;

	if(pagelayer_is_live() || wp_doing_ajax()){
		 $args = array(
			  'post_type'		=> 'docs',
			  'posts_per_page' => -1, // phpcs:ignore
			  'post_parent'	 => 0,
			  'orderby'		  => array(
					'menu_order' => 'ASC',
					'date'		 => 'DESC',
			  ),
		 );
	
		 $wp_query = new WP_Query( $args );
	}
	
	$current_term = false;
	$html = '';
	if( have_posts()){
		while ( have_posts() ){
			$html .= the_post();
			$terms = wp_get_post_terms( get_the_ID(), 'docs_category' );
			
			if(
			$terms &&
			! empty( $terms ) &&
			isset( $terms[0]->name ) &&
			$current_term !== $terms[0]->name
			) {
				
				$current_term = $terms[0]->name;
				$html .= '<li class="documentor-archive-list-category">';
				$html .=  esc_html( $terms[0]->name ); 
				$html .= '</li>';
			}

			$html .= '<li class="documentor-archive-list-item">';
			$html .=  documentor_loop_title($el['atts']);
			$html .=  documentor_loop_articles($el['atts']);
			$html .= '</li>';
		}
	}
	
	 if(!have_posts() && (pagelayer_is_live() || wp_doing_ajax())){
		$html .= '<li class="documentor-archive-list-item">';
		$html .=  documentor_loop_title($el['atts']);
		$html .=  documentor_loop_articles($el['atts']);
		$html .= '</li>';
	 }

	$el['atts']['post_html'] = $html;
}

function documentor_loop_title($atts){
	$html = '';
	$articles = get_pages(
		array(
			'child_of'  => get_the_ID(),
			'post_type' => 'docs',
		)
	);
	$articles_count = count( $articles );	 

	$html .= '<a href="'. get_the_permalink().'" class="documentor-archive-list-item-title">';
	
	if($atts['hicon']){
		$html .= '<i class="'. $atts['hicon'].'"></i>';
	}
	
	$html .= get_the_post_thumbnail( '','documentor_archive' ); 
	$html .= '<span>';
	$html .= '<span>';
	$html .= sprintf( esc_html( _n( '%s Article', '%s Articles', $articles_count, 'documentor' ) ), esc_html( $articles_count ) );
	$html .= '</span>';
	$html .= '<h2>'. get_the_title() .'</h2>';
	$html .= '</span>';
	$html .= '</a>';
	
	return $html;
}

function documentor_loop_articles($atts){
	
	$html ='';
	$show = $atts['show_articles'];
	$articles_number = $atts['articles_depth'];

	if ( -1 === $articles_number ) {
		$articles_number = 9999;
	}

	if ( ! $show || $articles_number < 1 ) {
		return;
	}

	$top_articles = new WP_Query(
		array(
			'post_type'		=> 'docs',
			'posts_per_page' => -1, // phpcs:ignore
			'post_parent'	 => get_the_ID(),
			'orderby'		  => array(
				'menu_order' => 'ASC',
				'date'		 => 'DESC',
			),
		)
	);
	
	$parent_link  = get_permalink();
	$count = 0;

	$nav_list = wp_list_pages(
		array(
			'title_li'  => '',
			'order'	  => 'menu_order',
			'child_of'  => documentor()->get_current_doc_id(),
			'echo'		=> false,
			'post_type' => 'docs',
			'icon'		=> $atts['icon'],
			'depth'	  => $articles_number,
			'walker'	 => new Documentor_Walker_Docs(),
		)
	);

	if(!$nav_list && (pagelayer_is_live() || wp_doing_ajax())){
		$nav_list = '<li class="page_item"><a href="">List</a></li>';
	}

	if ($nav_list) {
		$show_childs = documentor()->get_option( 'sidebar_show_nav_childs', 'documentor_single', false );
		$html .= '<div class="home_page_cats slimscroll-virt">';
		$html .= '<ul class="documentor-nav-list'. ( $show_childs ? ' documentor-nav-list-show-childs' : '' ).'">';
		$html .=  $nav_list; 
		$html .= '</ul>';
		$html .= '</div>';
	} 
	
	wp_reset_postdata(); 
	return $html;
}


