<?php

// We need the ABSPATH
if (!defined('ABSPATH')) exit;

function documentor_get_conf(){	
	$conf ='{
		"single-template": {
			"post_type":"pagelayer-template",
			"type": "single",
			"title": "Single Doc",
			"conditions": [
				{
					"type": "include",
					"template": "singular",
					"sub_template": "docs",
					"id": ""
				}
			]
		},
		"archive-template": {
			"post_type":"pagelayer-template",
			"type":"archive",
			"title":"Docs Archive",
			"conditions": [
				{
					"type": "include",
					"template": "archives",
					"sub_template": "docs",
					"id":""
				}
			]
		}
	}';
	
	return $conf;
}

function documentor_get_content(){
			
	$content['single-template'] = '<!-- sp:pagelayer/pl_row {"stretch":"full","col_gap":10,"width_content":"full","row_height":"default","overlay_hover_delay":400,"row_shape_top_color":"#227bc3","row_shape_top_width":100,"row_shape_top_height":100,"row_shape_bottom_color":"#e44993","row_shape_bottom_width":100,"row_shape_bottom_height":100,"pagelayer-id":"ymk8312"} -->
	<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":400,"ele_sticky_on":"desktop","col_width":"21.48","border_type":"solid","border_width":{"0":"0px","1":"1px","2":"0px","3":"0px"},"border_color":"#CCC","ele_sticky_in_col":"true","ele_sticky_pos":"top","pagelayer-id":"0bx6956"} -->
	<!-- sp:pagelayer/pl_dm_table_content {"list_style":"disc","color":"#183153ff","link_colors":"active","link_color":"#183153ff","link_hover_color":"#74c0fcff","link_current_color":"#74c0fcff","title":"Quick Links","typo":{"0":"Times New Roman","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"toggle_icon":"true","bgcolor":"","icon":"fas fa-bars","icon_color":"#ffffffff","icon_size":32,"border_width":"1px,1px,1px,1px","border_color":"#CCC","box_border_type":"solid","box_border_width":{"0":"2","1":"2","2":"2","3":"2"},"box_border_color":"#183153ff","box_border_radius":{"0":"5","1":"5","2":"5","3":"5"},"icon_bgcolor":"#183153ff","icon_btnsize":50,"toggle_child":"true","bottom_align":0,"right_align":10,"pagelayer-id":"u9q5054"} /-->
	<!-- sp:pagelayer/pl_dm_sidebar {"show_child":"","show_search":"true","list_style":"disc","bgcolor":"#ffffff75","link_colors":"active","link_color":"#183153ff","link_hover_color":"#74c0fcff","link_current_color":"#74c0fcff","margin":{"0":"0","1":"0","2":"0","3":"0"},"padding":{"0":"0","1":"0","2":"0","3":"30"},"spadding":"0,0,0,0","smargin":{"0":"5","1":"5","2":"5","3":"5"},"hide_count":"true","pagelayer-id":"xu67854"} /-->
	<!-- /sp:pagelayer/pl_col -->
	<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":400,"col_width_mobile":100,"col_width":70,"col_width_tablet":100,"ele_sticky_on":"tablet,mobile","pagelayer-id":"ap28460"} -->
	<!-- sp:pagelayer/pl_dm_breadcrumbs {"bgcolor":"#ffffffff","color":"#5700ffff","state":"","color_hover":"#ff7900ff","bgcolor_hover":"","abgcolor":"#ffffffff","acolor":"#183153ff","acolor_hover":"#74c0fcff","separator":"/","separator_color":"#183153ff","ele_sticky_pos":"top","ele_sticky_on":"tablet,mobile","pagelayer-id":"olt1814"} /-->
	<!-- sp:pagelayer/pl_post_title {"title_color":"#183153ff","typo":",35,,700,,,solid,,,,","pagelayer-id":"xgt2174"} /-->
	<!-- sp:pagelayer/pl_dm_table_content {"list_style":"disc","title":"On this page","color":"#183153ff","bgcolor":"","link_colors":"normal","link_color":"#183153ff","link_current_color":"#74c0fcff","link_hover_color":"#74c0fcff","icon":"fas fa-bars","ele_padding":{"0":"20px","1":"20px","2":"20px","3":"20px"},"border_type":"solid","border_width":"1px,1px,1px,1px","border_color":"#CCC","ele_bg_type":"color","ele_bg_color":"#f0f0f089","typo":{"0":"Verdana","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"toggle_child":"true","pagelayer-id":"8z27298"} /-->
	<!-- sp:pagelayer/pl_post_content {"ele_sticky_on":"desktop","ele_sticky_in_col":"true","align":"left","pagelayer-id":"ucf7745"} /-->
	<!-- sp:pagelayer/pl_dm_article {"list_style":"none","id":"43","hvcolor":"#74c0fcff","heading":"Sub Categories","align":"center","color":"#183153ff","typo":{"0":"Verdana","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"pagelayer-id":"1s39229"} /-->
	<!-- sp:pagelayer/pl_dm_footer {"show_author":"true","show_date":"true","show_time":"true","color":"#183153ff","bgcolor":"#f0f1f174","typo":{"0":"","1":"","2":"Italic","3":"300","4":"Normal","5":"","6":"Solid","7":"","8":"Capitalize","9":"","10":""},"align":"right","pagelayer-id":"hxu5172"} /-->
	<!-- sp:pagelayer/pl_dm_adjacent_links {"link_colors":"hover","bgcolor_hover":"#ffffffff","color_hover":"#043559ff","bgcolor":"#ffffffff","color":"#183153ff","btn_border_type":"solid","btn_border_width":{"0":"2","1":"2","2":"2","3":"2"},"btn_border_color":"#183153ff","btn_border_type_hover":"solid","btn_border_width_hover":{"0":"2","1":"2","2":"2","3":"2"},"btn_border_color_hover":"#74c0fcff","btn_bor_hover":"hover","typo":{"0":"Verdana","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"pagelayer-id":"k156946"} /-->
	<!-- sp:pagelayer/pl_dm_feedback {"positive_title":"person found this useful","negative_title":"persons found this not useful","no_votes":"No votes yet","question":"Was this page helpful?","show_counts":"true","plink_colors":"hover","plink_color":"#1b9d07ff","pbgcolor":"#ffffffff","plink_hover_color":"#ffffffff","pbgcolor_hover":"#0c9105ff","nlink_colors":"hover","nlink_color":"#ff0000ff","nbgcolor":"#ffffffff","nbgcolor_hover":"#ff0000ff","nlink_hover_color":"#ffffffff","typo":{"0":"Times New Roman","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"color":"#183153ff","bgcolor":"#ffffffff","border_type":"solid","border_width":["1px","0px","0px","0px"],"border_color":"#eeeeeeff","pagelayer-id":"tax7358"} /-->
	<!-- /sp:pagelayer/pl_col -->
	<!-- /sp:pagelayer/pl_row -->';
		
	$content['archive-template'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":10,"width_content":"auto","row_height":"default","overlay_hover_delay":400,"row_shape_top_color":"#227bc3","row_shape_top_width":100,"row_shape_top_height":100,"row_shape_bottom_color":"#e44993","row_shape_bottom_width":100,"row_shape_bottom_height":100,"pagelayer-id":"8nv1658"} -->
	<!-- sp:pagelayer/pl_col {"widget_space":15,"overlay_hover_delay":400,"pagelayer-id":"cil9552"} -->
	<!-- sp:pagelayer/pl_post_title {"title_color":"#183153ff","typo":{"0":"","1":"55","2":"","3":"700","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"align":"center","pagelayer-id":"rzr5299"} /-->
	<!-- sp:pagelayer/pl_dm_search_box {"box_border_color":"#e3e5e5ff","link_colors":"hover","link_bgcolor":"#ffffffff","link_color":"#183153ff","link_mark_color":"#74c0fcff","rbox_border_radius":{"0":"0","1":"0","2":"10","3":"10"},"rbox_border_color":"#183153ff","box_border_type":"solid","box_border_width":{"0":"2","1":"2","2":"2","3":"2"},"box_border_radius":{"0":"5","1":"5","2":"5","3":"5"},"bgcolor":"#ffffffff","padding":{"0":"0","1":"0","2":"0","3":0},"margin":{"0":"5","1":"5","2":"5","3":"5"},"align":"center","rbox_shadow":{"0":"0","1":"1","2":"5","3":"#cdcfcfff","4":"0","5":""},"rbox_border_type":"solid","rbox_border_width":{"0":"0","1":"0","2":"0","3":"0"},"link_hover_color":"#74c0fcff","link_hover_mark_color":"#183153ff","typo":{"0":"","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"pagelayer-id":"jin2663"} /-->
	<!-- sp:pagelayer/pl_dm_archive_box {"show_articles":"true","list_style":"","box_shadow":{"0":"0","1":"0","2":"5","3":"#cdcfcfff","4":"0","5":""},"articles_depth":"1","columns":"3","columns_tablet":"2","col_gap_tablet":0,"columns_mobile":"1","child_color":"","link_colors":"normal","link_color":"#183153ff","link_hover_color":"#74c0fcff","bgcolor_hover":"","box_border_radius":{"0":"10","1":"10","2":"10","3":"10"},"icon":"fas fa-caret-right","ltypo":{"0":"Trebuchet MS","1":"","2":"","3":"","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"hicon":"","hicon_space":11,"hicon_color":"#00ccffff","hicon_size":23,"icon_space":5,"padding":{"0":"2","1":"2","2":"2","3":"2"},"margin":"0,0,0,0","hpadding":"0,0,0,0","hmargin":"0,0,0,0","count_style_bg":"","count_style_color":"#616465ff","ctypo":{"0":"","1":"","2":"Oblique","3":"200","4":"","5":"","6":"Solid","7":"","8":"","9":"","10":""},"color":"#183153ff","hover_color":"#74c0fcff","countcolor":"#183153ff","cat_color":"#183153ff","cat_hover_color":"#74c0fcff","hide_count":"true","pagelayer-id":"adn9661"} /-->
	<!-- /sp:pagelayer/pl_col -->
	<!-- /sp:pagelayer/pl_row -->';
	
	return $content;
}

function documentor_import_template_content($fields, $content, $import_pages = array()){
	global $pagelayer;
	
	$template_name = wp_get_theme();
	$template_name = $template_name->template;
	$error = array();
	
	foreach($fields as $fk => $fv){

		if(empty($data[$fk])){
			$fields[$fk]['post_content'] = $content[$fk];
			$data[$fk] = $fields[$fk];
		}	
	}

	//for Pages
	foreach($data as $dk => $dv){

		if(!empty($import_pages) && !isset($import_pages[$dk])){
			continue;
		}

		$new_post = [];				
		// Delete Old Data ?
		$args = array(
			'post_type' => 'pagelayer-template',
			'meta_query' => array(
				array(
					'key' => 'documentor_imported_content',
					'value' => $dk,
					'compare' => 'EXISTS'
				)
			)
		);
		
		$query = new WP_Query($args);

		if(!empty($query->posts)){

			foreach ( $query->posts as $p ) {
				//echo $p->ID.'<br>';
				$update_post['ID'] = $p->ID;
				$update_post['post_content'] = $dv['post_content'];
				wp_update_post($update_post);
			}
			continue;
		}
		// Make an array
		$new_post['post_content'] = $dv['post_content'];
		$new_post['post_title'] = $dv['title'];
		$new_post['post_name'] = $dk;
		$new_post['post_type'] = $dv['post_type'];
		$new_post['post_status'] = 'publish';
		//r_print($new_post);
		
		// Now insert / update the post
		$ret = pagelayer_insert_content($new_post, $err);

		$post_id = $ret;

		if(empty($ret)){
			$error[] = 'Could not update the page '.$dv['title'];
			continue;
		}
				
		if($dv['post_type'] == 'pagelayer-template'){
			update_post_meta($post_id, 'pagelayer_template_type', $dv['type']);
			update_post_meta($post_id, 'pagelayer_template_conditions', $dv['conditions']);
			update_post_meta($post_id, 'documentor_imported_content', $dk);
		}
	}
	
	return $error;
}

