# Documentor - Online Documentation

* Contributors: softaculous
* Tags: documentation, document, help, ajax, export
* Requires at least: 4.6.0
* Tested up to: 5.5
* Requires PHP: 5.5.9
* Stable tag: 1.0.0
* License: GPLv2 or later
* License URI: <http://www.gnu.org/licenses/gpl-2.0.html>

Create, host and manage multiple products documentations.

## Description

Online documentation for your multiple products. Create, host and manage documentations in your WordPress site.

### Links

* [Live Demo](https://softaculous.com/docs)

## Features

* Multiple products support
* AJAX search
* AJAX loading for documentation pages
* Documentation categories
* Users feedback buttons
* Automatic anchor links on headings on docs content
* Comments section for articles
* Export documentation to static HTML
* Templates for theme developers
* Custom ordering

## Installation

### Automatic installation

Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of Documentor, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.

In the search field type `Documentor` and click Search Plugins. Once you’ve found our plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.

### Manual installation

The manual installation method involves downloading our Documentor plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains [instructions on how to do this here](https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation).

## Frequently Asked Questions

### Initialize JS after AJAX page loaded

If you need to initialize some JS after ajax loaded, you may use **Documentor > Settings > Single Doc > AJAX custom JS** section or use predefined custom event `documentor_ajax_loaded`:

    jQuery( document ).on( 'documentor_ajax_loaded', function() {
        // your code here.
    } );

## Screenshots

1. Documentations Archive
2. Documentation
3. Documentations Admin
4. Documentations Admin Classic UI

## Changelog

= 1.0.0 =

* Initial Release
