<?php
/**
 * Admin -> Kkart -> Extensions -> Kkart.com Subscriptions main page.
 *
 * @package Kkart\Views
 */

defined( 'ABSPATH' ) || exit();

?>

<div class="wrap kkart kkart_addons_wrap kkart-helper">
	<?php require KKART_Helper::get_view_filename( 'html-section-nav.php' ); ?>
	<h1 class="screen-reader-text"><?php esc_html_e( 'Kkart Extensions', 'kkart' ); ?></h1>
	<?php require KKART_Helper::get_view_filename( 'html-section-notices.php' ); ?>

		<div class="start-container">
			<div class="text">
				<img src="<?php echo esc_url( KKART()->plugin_url() . '/assets/images/kkart_logo.png' ); ?>" alt="<?php esc_attr_e( 'Kkart', 'kkart' ); ?>" style="width:180px;">

				<?php if ( ! empty( $_GET['kkart-helper-status'] ) && 'helper-disconnected' === $_GET['kkart-helper-status'] ) : ?>
					<p><strong><?php esc_html_e( 'Sorry to see you go.', 'kkart' ); ?></strong> <?php esc_html_e( 'Feel free to reconnect again using the button below.', 'kkart' ); ?></p>
				<?php endif; ?>

				<h2><?php esc_html_e( 'Manage your subscriptions, get important product notifications, and updates, all from the convenience of your Kkart dashboard', 'kkart' ); ?></h2>
				<p><?php esc_html_e( 'Once connected, your Kkart.com purchases will be listed here.', 'kkart' ); ?></p>
				<p><a class="button button-primary button-helper-connect" href="<?php echo esc_url( $connect_url ); ?>"><?php esc_html_e( 'Connect', 'kkart' ); ?></a></p>
			</div>
		</div>
</div>
