<?php
/**
 * Kkart Admin: Payments reminder note.
 *
 * Adds a notes to complete the payment methods.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Onboarding_Payments.
 */
class OnboardingPayments {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-onboarding-payments-reminder';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		// We want to show the note after five days.
		if ( ! self::kkart_admin_active_for( 5 * DAY_IN_SECONDS ) ) {
			return;
		}

		// Check to see if any gateways have been added.
		$gateways         = KKART()->payment_gateways->get_available_payment_gateways();
		$enabled_gateways = array_filter(
			$gateways,
			function( $gateway ) {
				return 'yes' === $gateway->enabled;
			}
		);
		if ( ! empty( $enabled_gateways ) ) {
			return;
		}

		$note = new Note();
		$note->set_title( __( 'Start accepting payments on your store!', 'kkart' ) );
		$note->set_content( __( 'Take payments with the provider that’s right for you - choose from 100+ payment gateways for Kkart.', 'kkart' ) );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_content_data( (object) array() );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'view-payment-gateways',
			__( 'Learn more', 'kkart' ),
			'https://kkart.com/product-category/kkart-extensions/payment-gateways/',
			Note::E_KKART_ADMIN_NOTE_ACTIONED,
			true
		);
		return $note;
	}
}
