<?php
/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/kkart/order/order-details-customer.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.4.4
 */

defined( 'ABSPATH' ) || exit;

$show_shipping = ! kkart_ship_to_billing_address_only() && $order->needs_shipping_address();
?>
<section class="kkart-customer-details">

	<?php if ( $show_shipping ) : ?>

	<section class="kkart-columns kkart-columns--2 kkart-columns--addresses col2-set addresses">
		<div class="kkart-column kkart-column--1 kkart-column--billing-address col-1">

	<?php endif; ?>

	<h2 class="kkart-column__title"><?php esc_html_e( 'Billing address', 'kkart' ); ?></h2>

	<address>
		<?php echo wp_kses_post( $order->get_formatted_billing_address( esc_html__( 'N/A', 'kkart' ) ) ); ?>

		<?php if ( $order->get_billing_phone() ) : ?>
			<p class="kkart-customer-details--phone"><?php echo esc_html( $order->get_billing_phone() ); ?></p>
		<?php endif; ?>

		<?php if ( $order->get_billing_email() ) : ?>
			<p class="kkart-customer-details--email"><?php echo esc_html( $order->get_billing_email() ); ?></p>
		<?php endif; ?>
	</address>

	<?php if ( $show_shipping ) : ?>

		</div><!-- /.col-1 -->

		<div class="kkart-column kkart-column--2 kkart-column--shipping-address col-2">
			<h2 class="kkart-column__title"><?php esc_html_e( 'Shipping address', 'kkart' ); ?></h2>
			<address>
				<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'kkart' ) ) ); ?>
			</address>
		</div><!-- /.col-2 -->

	</section><!-- /.col2-set -->

	<?php endif; ?>

	<?php do_action( 'kkart_order_details_after_customer_details', $order ); ?>

</section>
