<?php

//////////////////////////////////////////////////////////////
//===========================================================
// comment-strs.php
//===========================================================
// PAGELAYER
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Pulkit Gupta
// Date:	   23rd Jan 2017
// Time:	   23:00 hrs
// Site:	   http://pagelayer.com/wordpress (PAGELAYER)
// ----------------------------------------------------------
// Please Read the Terms of use at http://pagelayer.com/tos
// ----------------------------------------------------------
//===========================================================
// (c)Pagelayer Team
//===========================================================
//////////////////////////////////////////////////////////////

// Are we being accessed directly ?
if(!defined('PAGELAYER_PRO_VERSION')) {
	exit('Hacking Attempt !');
}

// Get comment strings
function pagelayer_get_comment_str(){

	$comment_str = array(
		
		// ========================
		// Home Header Banner
		// ========================
		'Short tagline that clearly describes your business or industry',
		'Main headline that describes your business',
		'Introductory text about your business, products, or services that engages visitors',
		'Primary CTA',
		'Secondary CTA',
		
		// ========================
		// Home - Services Section
		// ========================
		'Heading For The Services Section',
		'Paragraph describing the Services Section',
		'Service 1',
		'This section will highlight specific details about a service 1',
		'Service 2',
		'This section will highlight specific details about a service 2',
		'Service 3',
		'This section will highlight specific details about a service 3',
		'Service 4',
		'This section will highlight specific details about a service 4',
		'Service 5',
		'This section will highlight specific details about a service 5',
		'Service 6',
		'This section will highlight specific details about a service 6',
		'Service 7',
		'This section will highlight specific details about a service 7',
		'Service 8',
		'This section will highlight specific details about a service 8',
		'Service 9',
		'This section will highlight specific details about a service 9',
		'Service 10',
		'This section will highlight specific details about a service 10',
		
		// ========================
		// Home - Features Section
		// ========================
		'Heading For The Features Section',
		'Paragraph describing the Features Section',
		'Feature 1',
		'Short description of Feature 1',
		'Feature 2',
		'Short description of Feature 2',
		'Feature 3',
		'Short description of Feature 3',
		'Feature 4',
		'Short description of Feature 4',
		'Feature 5',
		'Short description of Feature 5',
		'Feature 6',
		'Short description of Feature 6',
		'Feature 7',
		'Short description of Feature 7',
		'Feature 8',
		'Short description of Feature 8',
		
		// ========================
		// Home - Call To Action
		// ========================
		'Prefix for Call To Action',
		'Heading for Call To Action',
		'Subheading for Call To Action',
		'Call To Action',
		'Learn More',
		
		// ========================
		// Home - Testimonials Section
		// ========================
		'Prefix For The Testimonials Section',
		'Heading For The Testimonials Section',
		'Subheading For The Testimonials Section',
		'Write a testimonial 1 from a satisfied customer. You can replace this with actual testimonials from your clients.',
		'Designation 1',
		'Write a testimonial 2 from a satisfied customer. You can replace this with actual testimonials from your clients.',
		'Designation 2',
		'Write a testimonial 3 from a satisfied customer. You can replace this with actual testimonials from your clients.',
		'Designation 3',
		'Write a testimonial 4 from a satisfied customer. You can replace this with actual testimonials from your clients.',
		'Designation 4',
		'Write a testimonial 5 from a satisfied customer. You can replace this with actual testimonials from your clients.',
		'Designation 5',
		'Write a testimonial 6 from a satisfied customer. You can replace this with actual testimonials from your clients.',
		'Designation 6',
		
		// ========================
		// Home - Portfolio Section
		// ========================
		'Heading for Portfolio Section',
		'Subheading for Portfolio Section',
		'Portfolio Item 1',
		'Short description of Portfolio 1',
		'Portfolio Item 2',
		'Short description of Portfolio 2',
		'Portfolio Item 3',
		'Short description of Portfolio 3',
		'Portfolio Item 4',
		'Short description of Portfolio 4',
		'Portfolio Item 5',
		'Short description of Portfolio 5',
		'Portfolio Item 6',
		'Short description of Portfolio 6',
		'Portfolio Item 7',
		'Short description of Portfolio 7',
		'Portfolio Item 8',
		'Short description of Portfolio 8',
		
		// ========================
		// Home - Team Section
		// ========================
		'Heading For The Team Section',
		'Subheading For The Team Section',
		'Team Member 1',
		'Position 1',
		'Team Member 2',
		'Position 2',
		'Team Member 3',
		'Position 3',
		'Team Member 4',
		'Position 4',
		'Team Member 5',
		'Position 5',
		'Team Member 6',
		'Position 6',
		
		// ========================
		// Pricing Table
		// ========================
		'Heading For The Pricing Section',
		'Description of the Pricing Section',
		'Choose a suitable plan',
		'Select Plan',
		'Basic Plan',
		'Standard Plan',
		'Premium Plan',
		'Elite Plan',
		'Per Month',
		'Per Year',
		'Plan Feature 1',
		'Plan Feature 2',
		'Plan Feature 3',
		'Plan Feature 4',
		'Plan Feature 5',
		'Plan Feature 6',
		'Plan Feature 7',

		// ========================
		// Workflow / How It Works Section
		// ========================
		'Heading For The Workflow Section',
		'Subheading describing the Workflow Section',
		'Workflow Step 1 Title',
		'Short description for Workflow Step 1',
		'Workflow Step 2 Title',
		'Short description for Workflow Step 2',
		'Workflow Step 3 Title',
		'Short description for Workflow Step 3',
		'Workflow Step 4 Title',
		'Short description for Workflow Step 4',

		// ========================
		// Timeline Section
		// ========================
		'Timeline Section Heading',
		'Subheading describing the Timeline Section',
		'Timeline 1 Title',
		'Short description for Timeline Item 1',
		'Timeline 2 Title',
		'Short description for Timeline Item 2',
		'Timeline 3 Title',
		'Short description for Timeline Item 3',
		'Timeline 4 Title',
		'Short description for Timeline Item 4',
		'Timeline 5 Title',
		'Short description for Timeline Item 5',
		
		// ========================
		// Home - Latest News Section
		// ========================
		'Latest News',
		'Short description for latest news',
		
		// ========================
		// Home - Footer Section
		// ========================
		'Headline for the About area in the footer',
		'Short description about the business or brand to display in the footer',
		
		// Newsletter 
		'Subscribe to our newsletter',
		'A short description for the newsletter section',
		'Subscribe',
		
		// ========================
		// About Page
		// ========================
		'About Us',
		'Subheading For The About Us Page',
		'Heading for the About Us Section',
		'A short and engaging paragraph introducing your company, mission, and values',		
		
		// Propositions Section
		'Heading Describing Your Unique Value Propositions',
		'Subheading Describing Your Unique Value Propositions',
		'Value Proposition 1',
		'Value Proposition 2',
		'Value Proposition 3',
		'Value Proposition 4',
		
		// Mission Section
		'Heading For The Mission 1 Statement',
		'Paragraph describing the Mission 1 Statement',
		'Heading For The Mission 2 Statement',
		'Paragraph describing the Mission 2 Statement',
		'Heading For The Mission 3 Statement',
		'Paragraph describing the Mission 3 Statement',
		'Heading For The Mission 4 Statement',
		'Paragraph describing the Mission 4 Statement',
		'Heading For The Mission 5 Statement',
		'Paragraph describing the Mission 5 Statement',
		
		// Statistics Section
		'Heading For The Statistics Section',
		'Small description of the Statistics Section',
		'Statistic Heading 1',
		'Statistic Heading 2',
		'Statistic Heading 3',
		'Statistic Heading 4',
		
		// ========================
		// Services Page
		// ========================
		'Heading For The Services Page',
		'Subheading For The Services Page',
		
		// ========================
		// FAQ Section
		// ========================
		'Heading For FAQ Section',
		'Subheading For The FAQ Section',
		'Frequently Asked Question 1',
		'Answer of the Frequently Asked Question 1',
		'Frequently Asked Question 2',
		'Answer of the Frequently Asked Question 2',
		'Frequently Asked Question 3',
		'Answer of the Frequently Asked Question 3',
		'Frequently Asked Question 4',
		'Answer of the Frequently Asked Question 4',
		'Frequently Asked Question 5',
		'Answer of the Frequently Asked Question 5',
		
		// ========================
		// Partners Section
		// ========================
		'Our Partners',
		'All logos belong to their respective owners',
		
		// ========================
		// Contact Page
		// ========================
		'Heading For The Contact Page',
		'Subheading For The Contact Page',
		'Heading For The Contact Form Section',
		'Subheading For The Contact Form Section',
		'Get In Touch',
		'Address Title',
		'Phone Title',
		'Email Address Title',
		'Name',
		'Subject',
		'Message here',
		'Send',
		'Opening hours Title',
		'Opening hours placeholder',
		'Follow Us On',
		
		// Special chars
		'-',
		'$',
		'Contact',
		'Home',
		'About',
		'Services',
		'Terms and Conditions',
		'Privacy policy',
		'Links',
		'Gallery',
	);
	
	// Asign key to strs
	$strings = [];
	foreach($comment_str as $s){		
		$strings[substr(md5($s), 0, 5)] = $s;
	}
	
	return $strings;
}

function pagelayer_extract_comment_atts($post_id, $content){
	
	global $pagelayer, $pagelayer_allowed_com;
	
	// Load shortcode
	pagelayer_load_shortcodes();
	
	$pagelayer_allowed_com = pagelayer_get_comment_str();
	
	$post = get_post($post_id);
	
	if(empty($post->ID) || empty($post->post_content)){
		 return $content;
	}
	
	// Step 1: Get content edtable attributes
	$blocks = parse_blocks( $content );
	$el_atts = array();
	
	// Get editable content array
	foreach( $blocks as $block ){
		$block_name = $block['blockName'];
		
		// Is pagelayer block
		if( is_string( $block_name ) && 0 === strpos( $block_name, 'pagelayer/' ) ){
			pagelayer_flatten_block_atts($block, $el_atts);
		}
		
	}
	
	$el_atts = array_filter($el_atts);
	
	// Step 2: Add comment content in original content
	$blocks = parse_blocks( $post->post_content );
	$output = '';
	
	foreach( $blocks as $block ){
		$block_name = $block['blockName'];
		
		// Is pagelayer block
		if ( is_string( $block_name ) && 0 === strpos( $block_name, 'pagelayer/' ) ) {
			$_block = pagelayer_add_comment_atts($block, $el_atts);
			$output .= serialize_block($_block);
			continue;
		}
		
		$output .= serialize_block($block);
	}
	return $output;
}

function pagelayer_add_comment_atts($block, $new_atts){
	global $pagelayer, $pagelayer_comment_errors, $pagelayer_allowed_com, $pagelayer_comment_alerts;
	
	if(empty($block['attrs']['pagelayer-id'])){
		return $block;
	}
	
	$pl_id = $block['attrs']['pagelayer-id'];
	
	if(isset($new_atts[$pl_id]) && is_array($new_atts[$pl_id])){
		$block['attrs']['comment_atts'] = $new_atts[$pl_id];
	// Clear cached
	}elseif(isset($block['attrs']['comment_atts'])){
		unset($block['attrs']['comment_atts']);
	}
	
	$blockName = $block['blockName'];
	
	// If block saved by Pagelayer Editor
	if(in_array( $blockName, ['pagelayer/pl_inner_col', 'pagelayer/pl_inner_row'])){
		$blockName = str_replace('inner_', '', $blockName);
	}
	
	$tag = substr( $blockName, 10 );
	$pl_tag = str_replace('-', '_', $tag);
	
	if(isset($pagelayer->shortcodes[$pl_tag])){
	
		// Create attribute Object
		$pl_props = $pagelayer->shortcodes[$pl_tag];
		$pl_id = $block['attrs']['pagelayer-id'];
		
		$el_atts[$pl_id] = array();
		
		foreach($pagelayer->tabs as $tab){
			
			if(empty($pl_props[$tab])){
				continue;
			}
			
			foreach($pl_props[$tab] as $section => $_props){
				
				$props = !empty($pl_props[$section]) ? $pl_props[$section] : $pagelayer->styles[$section];
				
				if(empty($props)){
					continue;
				}
				
				// Reset / Create the cache
				foreach($props as $prop => $param){
					
					// No value set
					if(empty($block['attrs'][$prop]) || // Empty value in original content
						(isset($param['ai']) && $param['ai'] === false) || // AI MODE is off
						(is_string($block['attrs'][$prop]) && strlen(trim($block['attrs'][$prop])) < 1) || // Val not set
						empty($param['edit']) // Not editable !
					){
						continue;
					}
					
					// Check for req
					if(!empty($param['req'])){
						
						$set = true;
						
						foreach($param['req'] as $rk => $reqval){
							$except = $rk[0] == '!' ? true : false;
							$rk = $except ? substr($rk, 1) : $rk;
							$val = pagelayer_isset($block['attrs'], $rk);
							
							//echo $prop.' - '.$rk.' : '.$reqval.' == '.$val.'<br>';
							
							// The value should not be there
							if($except){
								
								if(!is_array($reqval) && $reqval == $val){
									$set = false;
									break;
								}
								
								// Its an array and a value is found, then dont show
								if(is_array($reqval) && in_array($val, $reqval)){
									$set = false;
									break;
								}
								
							// The value must be equal
							}else{
								
								 if(!is_array($reqval) && $reqval != $val){
									$set = false;
									break;
								 }
								
								// Its an array and no value is found, then dont show
								if(is_array($reqval) && !in_array($val, $reqval)){
									$set = false;
									break;
								}
							}
							
						}
						
						// Unset as we dont need
						if(empty($set)){
							continue;
						}
						
					}
					
					$tmp = trim(strip_tags($block['attrs']['comment_atts'][$prop]));
					
					$skip_temp = trim($tmp, "+");
					if(is_numeric($skip_temp)){
						continue;
					}
					
					if(is_string($tmp) && $tmp[0] == '!'){
						$pagelayer_comment_alerts[$pl_id][$prop]['o'] = $block['attrs'][$prop];
						$pagelayer_comment_alerts[$pl_id][$prop]['c'] = $block['attrs']['comment_atts'][$prop];
						continue;
					}
					
					if(!in_array($tmp, $pagelayer_allowed_com)){
						$pagelayer_comment_errors[$pl_id][$prop]['o'] = $block['attrs'][$prop];
						$pagelayer_comment_errors[$pl_id][$prop]['c'] = $block['attrs']['comment_atts'][$prop];
					}
					
				}
			}
		}
		
	}
	
	// This have innerBlocks
	if(!empty($block['innerBlocks']) && is_array($block['innerBlocks'])){
		foreach($block['innerBlocks'] as $key => $inner_block){
			$block['innerBlocks'][$key] = pagelayer_add_comment_atts($inner_block, $new_atts);
		}
	}
	
	return $block;
}

function pagelayer_flatten_block_atts($block, &$el_atts){
	global $pagelayer;
	
	// TODO: if empty then assign id and updated content
	if(empty($block['attrs']['pagelayer-id'])){
		return;
	}
	
	$blockName = $block['blockName'];
	
	// If block saved by Pagelayer Editor
	if(in_array( $blockName, ['pagelayer/pl_inner_col', 'pagelayer/pl_inner_row'])){
		$blockName = str_replace('inner_', '', $blockName);
	}
	
	$tag = substr( $blockName, 10 );
	$pl_tag = str_replace('-', '_', $tag);
	
	if(isset($pagelayer->shortcodes[$pl_tag])){
	
		// Create attribute Object
		$pl_props = $pagelayer->shortcodes[$pl_tag];
		$pl_id = $block['attrs']['pagelayer-id'];
		
		$el_atts[$pl_id] = array();
		
		foreach($pagelayer->tabs as $tab){
			
			if(empty($pl_props[$tab])){
				continue;
			}
			
			foreach($pl_props[$tab] as $section => $_props){
				
				$props = !empty($pl_props[$section]) ? $pl_props[$section] : $pagelayer->styles[$section];
				
				if(empty($props)){
					continue;
				}
				
				// Reset / Create the cache
				foreach($props as $prop => $param){
					
					// No value set
					if(empty($block['attrs'][$prop]) || (isset($param['ai']) && $param['ai'] === false) || (is_string($block['attrs'][$prop]) && strlen(trim($block['attrs'][$prop])) < 1)){
						continue;
					}
					
					// Is editable?
					if(!empty($param['edit'])){
						$el_atts[$pl_id][$prop] = $block['attrs'][$prop];
					}
					
					// Is image skipped?
					if($param['type'] == 'image' && isset($block['attrs'][$prop.'_ai'])){
						$el_atts[$pl_id][$prop] = $block['attrs'][$prop.'_ai'];
					}
				}
			}
		}
		
	}
		
	// This have innerBlocks
	if(!empty($block['innerBlocks'])){
		foreach($block['innerBlocks'] as $key => $inner_block){
			pagelayer_flatten_block_atts($inner_block, $el_atts, $only_images);
		}
	}
}