import { useState, useEffect, useRef } from '@wordpress/element';
export const RenderVideoBlock = (props) => {

	const { _props, tag, data } = props;
	const { setAttributes, isSelected } = _props;
	const { id, atts : attributes, tmp} = data;
		
	useEffect(() => {
		pagelayer_pl_video(pagelayer_query(`.p-${id}`));
	});
	
	useEffect(()=>{
		var jEle = pagelayer_query(`.p-${id}`);
		var vidOverlay = jEle.find('.pagelayer-video-overlay');
		
		if(vidOverlay.length > 0){
			vidOverlay.show();
		}
		
	}, [attributes])

	var videoUrl = pagelayer_empty(tmp['src-url']) ? attributes['src'] : tmp['src-url'];

	var vid_atts = pagelayer_video_url(videoUrl, true);
	
	if('src' in vid_atts && !pagelayer_empty(vid_atts['src'])){

		vid_atts['src'] += (vid_atts['src'].indexOf('?') == -1 ? '?' : '');

		if('autoplay' in attributes){
			vid_atts['src'] += '&autoplay=1';
		} else {
			vid_atts['src'] += '&autoplay=0';
		}

		if ('mute' in attributes) {
			var mute = attributes['mute'] === 'true' ? 1 : 0;
			vid_atts['src'] += '&' + (vid_atts['type'] == 'vimeo' ? 'muted' : 'mute') + '=' + mute;
		}

		if ('loop' in attributes) {
			vid_atts['src'] += '&loop=1';
		}
	
		attributes['vid_src'] = vid_atts['src']+(vid_atts['type'] == 'youtube' ? '&playlist='+vid_atts['id'] : '');
	}
	
	return (
		<>
			<div className={`pagelayer-video-holder pagelayer-video-${attributes?.video_ratio}`}>

				{attributes?.vid_src && (
					<iframe
						id="embed_video"
						className="pagelayer-video-iframe"
						width="100%"
						height="auto"
						src={attributes?.vid_src}
						frameborder={0}
					>
					</iframe>
				)}

				{attributes?.lightbox ? (
					<a href={videoUrl} >
						{attributes?.overlay && (
							<div className="pagelayer-video-overlay" style={{ backgroundImage: `url(${tmp['video_overlay_image-url']})` }}>
								<i className={attributes.play_icon} aria-hidden="true"></i>
							</div>
						)}
					</a>
				) : (
					<>
						{attributes?.overlay && (
							<div className="pagelayer-video-overlay" style={{ backgroundImage: `url(${tmp['video_overlay_image-url']})`}}>
								<i className={attributes.play_icon} aria-hidden="true"></i>
							</div>
						)}
					</>
				)}
				{!isSelected && (
					<div className="pagelayer-video-edit">
						<span className="fa fa-pencil"></span>
					</div>
				)}
			</div>
		</>
	);
}
