import { useState, useEffect } from '@wordpress/element';
import { LabelControl } from './label';

export const MultiSelectControl = (props) => {
	
	const { prop, label, value, setAttributes } = props;
	const { name } = prop['c'];
	
	var selection = pagelayer_empty(value) ? [] : value;
	
	if(pagelayer_is_string(selection)){
		selection = selection.split(',');
	}
	
	const [isSelectorOpen, setIsSelectorOpen] = useState(false);

	const option = (val, lang) => {
		const itemSelected = selection.includes(val) ? 'selected' : '';
		return (
			<li
				className="pagelayer-elp-multiselect-option"
				data-val={val}
				data-selected={itemSelected}
				onClick={ () => handleOptionClick(val)}
			>{ lang }</li>
		);
	};

	const showSelected = () => {
		return selection.map((value) => (
			<span className="pagelayer-elp-multiselect-selected" data-val={value}>
				{prop['list'][value]}{' '}
				<span className="pagelayer-elp-multiselect-remove" onClick={() => handleRemove(value)}>
					x
				</span>
			</span>
		));
	};

	const handleRemove = (value) => {
		const updatedSelection = selection.filter((val) => val !== value);
		setAttributes({[name]: updatedSelection.join(',') });
	};

	const handleOptionClick = (val) => {
		
		if (selection.includes(val)) {
			const updatedSelection = selection.filter((value) => value !== val);
			setAttributes({[name]: updatedSelection.join(',') });
		} else {
			const updatedSelection = [...selection, val];
			setAttributes({[name]: updatedSelection.join(',')});
		}
		
	};

	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<div className="pagelayer-elp-multiselect-div pagelayer-elp-pos-rel">
				<div 
					className="pagelayer-elp-multiselect" 
					onClick={ () => setIsSelectorOpen(!isSelectorOpen) }
				>{showSelected()}</div>
				{ isSelectorOpen && (
					<ul className={`pagelayer-elp-multiselect-ul ${isSelectorOpen ? 'open' : ''}`} name={name}>
						{Object.keys(prop['list']).map((key) => option(key, prop['list'][key]))}
					</ul>
				)}
			</div>
		</div>
	);
}
