<?php

// Add/Save Meta Tags
add_action('wp_ajax_sitepad_save_meta_tags', 'sitepad_save_meta_tags');
function sitepad_save_meta_tags() {
	
	global $wpdb;
	
	// Some AJAX security
	check_ajax_referer('sitepad_ajax', 'sitepad_nonce');
	
	$msg = array();
	$meta_details = array();
  
	$page_id = (int) optGET('postID');
	
	if(empty($page_id)){
		$msg = array("error" => "Invalid page id");
		echo json_encode($msg);
		wp_die();
	}
	
	$allowed_meta = array('site_title', 'meta_author', 'meta_contact', 'meta_copyright', 'meta_description', 'meta_keys');
	
	foreach($allowed_meta as $meta_key){
		// We are not using optPOST because it has htmlizer which converts some greek characters to html entities
		$posted = (!empty($_REQUEST[$meta_key]) ? inputsec(trim($_REQUEST[$meta_key])) : '');
		
		if(!empty($posted)){
			$meta_details[$meta_key] = $posted;
		}
	}
	
	if(empty($meta_details)){
		$msg = array("error" => "Nothing to save");
		echo json_encode($msg);
		wp_die();
	}
	
	update_post_meta($page_id, 'sitepad_meta_tags', wp_unslash( $meta_details) );
	$msg = array("success" => "Metadata saved");
	echo json_encode($msg);
	wp_die();
}

// Clear Meta Tags
add_action('wp_ajax_sitepad_clear_meta_tags', 'sitepad_clear_meta_tags');
function sitepad_clear_meta_tags(){
	
	// Some AJAX security
	check_ajax_referer('sitepad_ajax', 'sitepad_nonce');
	
	$meta_details = array();
	$page_id = (int) optGET('postID');
	
	if(empty($page_id)){
		$msg = array("error" => "Invalid page id");
		echo json_encode($msg);
		wp_die();
	}
	
	$get_meta = update_post_meta($page_id, 'sitepad_meta_tags', $meta_details);
	
	$msg = array("success" => "Meta tags deleted");
	echo json_encode($msg);
	wp_die();
}

// Get SEO vars value
function sitepad_replace_seo_vars( $string ){
	
	$_post = get_queried_object();
	
	$author_meta = get_user_by( 'id', $_post->post_author);
	$vars = array('site_title' => get_bloginfo( 'name', 'display' ),
				'page_title' => $_post->post_title,
				'post_type' => $_post->post_type,
				'author' => $author_meta->display_name,
				'email' => get_option('admin_email'));
				
	foreach($vars as $kk => $vv){
		$string = str_replace('$'.$kk , $vv, $string);	
	}
	return $string;
}

// Set the title from seo field
add_filter( 'pre_get_document_title', 'sitepad_set_seo_title');
function sitepad_set_seo_title(){
	
	global $post;
	
	// Is 404?
	if(empty($post)){
		return;
	}
	
	$meta_details = get_post_meta($post->ID, 'sitepad_meta_tags', true);
	$globaldata = get_option('sitepad_global_meta_tags');
	$title = '';
	
	if(!empty($meta_details['site_title'])){
		$title = sitepad_replace_seo_vars($meta_details['site_title']);
	}elseif(!empty($globaldata['site_title'])){
		$title = sitepad_replace_seo_vars($globaldata['site_title']);
	}
	
	return $title;
	
}

// Show Meta tags on Pages
add_action('wp_head', 'sitepad_show_meta_tags' , 2);
function sitepad_show_meta_tags(){
	
	global $post;
	
	//CrossSite Scripting is disabled as XSS Auditor would not let user Edit Page in Chrome and IE.
	//@header("X-XSS-Protection: 0");
	
	if(empty($post)){
		return;
	}
	
	$echo_meta = '';
	$meta_values = array();
	$meta_details = get_post_meta($post->ID, 'sitepad_meta_tags', true);
	$globaldata = get_option('sitepad_global_meta_tags');
	
	// We do not have any meta data
	if(empty($meta_details) && empty($globaldata)){
		return true;
	}
		
	$allowed_meta = array('meta_author', 'meta_contact', 'meta_copyright', 'meta_description', 'meta_keys');
				
	foreach($allowed_meta as $meta_key){
		if(!empty($meta_details[$meta_key])){
			$meta_values[$meta_key] = sitepad_replace_seo_vars($meta_details[$meta_key]);
		}elseif(!empty($globaldata[$meta_key])){
			$meta_values[$meta_key] = sitepad_replace_seo_vars($globaldata[$meta_key]);
		}
	}
	
	if(!empty($meta_values['meta_author'])){
		$echo_meta .= '<meta name="author" content="'.$meta_values['meta_author'].'" />';
	}
	
	if(!empty($meta_values['meta_contact'])){
		$echo_meta .= '<meta name="contact" content="'.$meta_values['meta_contact'].'" />';
	}
	
	if(!empty($meta_values['meta_copyright'])){
		$echo_meta .= '<meta name="copyright" content="'.$meta_values['meta_copyright'].'" />';
	}
	
	if(!empty($meta_values['meta_description'])){
		$echo_meta .= '<meta name="description" content="'.esc_attr( wp_strip_all_tags( $meta_values['meta_description'] )).'" />';
	}
	
	if(!empty($meta_values['meta_keys'])){
		$echo_meta .= '<meta name="keywords" content="'.$meta_values['meta_keys'].'" />';
	}
	
	echo $echo_meta;
}