<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Děkujeme za registraci na {FORUMNAME}. Vaše uživatelské jméno je {USERNAME}. Pokud zapomenete heslo, můžete o něj požádat na {FORGOTPASSWORDLINK}

Předtím, než se přihlásíte, musíte aktivovat svůj účet kliknutím na následující odkaz:

{ACTIVATIONLINK}

Pokud budete mít problémy s aktivací, navštivte {ACTIVATIONLINKWITHOUTCODE} a použijte tento kód "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Vaše žádost o registraci na {FORUMNAME} byla přijata, {REALNAME}.

Vaše uživatelské jméno je {USERNAME}.

Než se budete moci přihlásit a začít používat fórum, musí být vaše žádost přezkoumána a poté schválena.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Schválení členství ve skupině';
$txt['mc_group_approve_body'] = '{USERNAME},

S potěšením vám oznamujeme, že vaše žádost o členství ve skupině "{GROUPNAME}" na fóru {FORUMNAME} byla schválena a váš účet byl aktualizován.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Zamítnutí členství ve skupině';
$txt['mc_group_reject_body'] = '{USERNAME},

S lítostí vám oznamujeme, že vaše žádost o připojení do skupiny "{GROUPNAME}" na fóru {FORUMNAME} byla zamítnuta.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Zamítnutí členství ve skupině';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

Je nám líto, ale vaše žádost o členství ve skupině "{GROUPNAME}" na fóru {FORUMNAME} byla zamítnuta.

Důvod zamítnutí: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Vítejte, {NAME}!

Váš účet byl schválen administrátorem fóra; nyní se již můžete přihlásit. Vaše uživatelské jméno je: {USERNAME}. Pokud zapomenete heslo, můžete jej změnit na {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Vítejte, {USERNAME}!

Váš účet na fóru {FORUMNAME} byl právě schválen administrátorem. Než se budete moci přihlásit, použijte prosím tento odkaz pro aktivaci účtu:

{ACTIVATIONLINK}

Pokud budete mít problémy s aktivací, navštivte {ACTIVATIONLINKWITHOUTCODE} a použijte prosím tento kód "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrace zamítnuta';
$txt['admin_approve_reject_body'] = '{USERNAME},

s lítostí vám oznamujeme, že vaše registrace na fóru {FORUMNAME} byla zamítnuta.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Účet byl smazán';
$txt['admin_approve_delete_body'] = '{USERNAME},

váš účet na fóru {FORUMNAME} byl smazán. Mohlo to být způsobeno tím, že jste nikdy svůj účet neaktivoval, v tom případě se zaregistrujte znovu.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Upomínka registrace';
$txt['admin_approve_remind_body'] = '{USERNAME},
Dovolujeme si upozornit, že stále nemáte aktivován svůj účet na fóru {FORUMNAME}.

Použijte prosím tento odkaz pro aktivaci účtu:
{ACTIVATIONLINK}

Pokud budete mít problémy s aktivací, navštivte {ACTIVATIONLINKWITHOUTCODE} a použijte prosím tento kód "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Děkujeme za registraci na fóru {FORUMNAME}. Vaše uživatelské jméno je {USERNAME} a heslo je {PASSWORD}.

Předtím, než se přihlásíte, musíte aktivovat svůj účet. Chcete-li tak učinit, klikněte prosím na následující odkaz:

{ACTIVATIONLINK}

Pokud budete mít problémy s aktivací, navštivte {ACTIVATIONLINKWITHOUTCODE} a použijte prosím tento kód "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Děkujeme za registraci na fóru {FORUMNAME}. Vaše uživatelské jméno je {USERNAME} a heslo je {PASSWORD}, url fóra je: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Nové oznámení: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Celé oznámení si můžete prohlédnout kliknutím na následující odkaz:
{TOPICLINK}

Odhlášení od těchto oznámení můžete provést na tomto odkazu:
{UNSUBSCRIBELINK}

Pro více voleb emailů, které dostáváte, se přihlašte na fórum a ve vašem profilu navštivte sekci Oznámení.
{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nové téma: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Nové téma \'{TOPICSUBJECT}\' bylo zasláno do diskuse, kterou sledujete.

Můžete si jej prohlédnout na
{TOPICLINK}

Může být zasláno více příspěvků, ale neobdržíte již další oznámení, dokud si téma neprohlédnete.

Text je uveden níže:
{MESSAGE}

Odhlášení se z odběru nových témat provedete pomocí tohoto odkazu:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nové téma: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Nové téma \'{TOPICSUBJECT}\' bylo zasláno do diskuse, kterou sledujete.

Můžete si jej prohlédnout na
{TOPICLINK}

Může být zasláno více příspěvků, ale neobdržíte již další oznámení, dokud si téma neprohlédnete.

Odhlášení se z odběru nových témat provedete pomocí tohoto odkazu:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nové téma: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Nové téma, \'{TOPICSUBJECT}\', bylo zasláno do diskuse, kterou sledujete.

Můžete si jej prohlédnout na
{TOPICLINK}

Text tématu je níže:
{MESSAGE}

Odhlášení se z odběru nových témat provedete pomocí tohoto odkazu:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nové téma: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Nové téma, \'{TOPICSUBJECT}\', bylo zasláno do diskuse, kterou sledujete.

Můžete si jej prohlédnout na
{TOPICLINK}

Odhlášení se z odběru nových témat provedete pomocí tohoto odkazu:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Odpověď v tématu: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = '{POSTERNAME} poslal příspěvek do \'{SUBJECT}\'.

Můžete si ho prohlédnout zde
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Nová neschválená příloha v: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Nová příloha byl přidána v \'{SUBJECT}\', a čeká na schválení.

Můžete schválit nebo zamítnout tuto přílohu na odkazu níže, který směřuje na příslušný příspěvek.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nový neschválený příspěvek: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Byl napsán nový příspěvěk, který vyžaduje schválení: \'{SUBJECT}\'

Můžete ho schválit nebo zamítnout na tomto odkaze:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nové neschválené téma: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Bylo založeno nové téma, které čeká na schválení: \'{SUBJECT}\'

Můžete ho schválit nebo odmítnout na tomto odkaze:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Nová žádost o členství ve skupině';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} žádá o zařazení do skupiny "{GROUPNAME}". Uživatel zadal následující důvod:

{REASON}

Tuto žádost můžete schválit nebo zamítnout kliknutím na níže uvedený odkaz:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Projde vám předplatné na fóru {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

vaše předplatné na fóru {FORUMNAME} brzy skončí. Pokud jste si vybrali automatické obnovení, nemusíte nic dělat, jinak byste mohli zvážit opakování předplatného. Detaily:

Jméno předplatného: {SUBSCRIPTION}
Platí do: {END_DATE}

Pro správu vašich předplatných navštivte tento odkaz:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Vítejte zpět na fóru {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Abyste znovu ověřili svůj email, klikněte na následující odkaz: 
{ACTIVATIONLINK}

Pokud budete mít problémy s aktivací, navštivte {ACTIVATIONLINKWITHOUTCODE} a použijte tento kód "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nové heslo pro fórum {FORUMNAME}';
$txt['forgot_password_body'] = 'Vážený(á) {REALNAME},
tento email vám byl zaslán, neboť jste zřejmě zapomněli své heslo. Chcete-li nastavit nové heslo, klikněte na následující odkaz:
{REMINDLINK}

IP ADRESA: {IP}
Uživatelské jméno: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Nahlášený příspěvek: {TOPICSUBJECT} od {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Tento příspěvek, "{TOPICSUBJECT}" od {POSTERNAME} byl nahlášen uživatelem {REPORTERNAME} v diskusi, kterou moderujete:

Téma: {TOPICLINK}
Centrum moderace: {REPORTLINK}

S hlášením přišel tento komentář:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Reakce k nahlášenému příspěvku: {TOPICSUBJECT} od {POSTERNAME}';
$txt['reply_to_moderator_body'] = '"{TOPICSUBJECT}" byl v minulosti nahlášen moderátorům.

Mezitím uživatel {COMMENTERNAME} přidal k hlášení komentář. Více informací je k nalezení na fóru.

Téma: {TOPICLINK}
Centrum moderace: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Nahlášený profil: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Profil uživatele "{MEMBERNAME}" byl nahlášen uživatelem {REPORTERNAME}.

Profil: {PROFILELINK}
Centrum moderace: {REPORTLINK}

S hlášením přišel tento komentář:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Reakce k nahlášenému profilu: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'V minulosti byl profil {MEMBERNAME} nahlášen.

Mezitím uživatel {COMMENTERNAME} přidal komentář k tomuto hlášení. Více informací je k nalezení na fóru.

Profil: {PROFILELINK}
Centrum moderace: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Detaily o novém heslu';
$txt['change_password_body'] = 'Dobrý den, {USERNAME}!

Vaše přihlašovací údaje na {FORUMNAME} byly změněny. Níže jsou Vaše nové přihlašovací údaje.

Vaše uživatelské jméno je "{USERNAME}" a Vaše heslo je "{PASSWORD}".

Své heslo můžete měnit po přihlášení se do fóra a navštívení stránky profilu:

{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['register_activate_body'] = 'Děkujeme za registraci na {FORUMNAME}. Vaše uživatelské jméno je {USERNAME}. Pokud zapomenete heslo, můžete o něj požádat na {FORGOTPASSWORDLINK}

Předtím, než se přihlásíte, musíte aktivovat svůj účet. Chcete-li tak učinit, klikněte prosím na následující odkaz:

{ACTIVATIONLINK}

Pokud budete mít problémy s aktivací, navštivte {ACTIVATIONLINKWITHOUTCODE} a použijte tento kód "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['register_coppa_body'] = 'Děkujeme za registraci na {FORUMNAME}. Vaše uživatelské jméno je {USERNAME}. Pokud zapomenete heslo, můžete o něj požádat na {FORGOTPASSWORDLINK}

Předtím, než se budete moci přihlásit do fóra, je vyžadován souhlas rodičů/zákonných zástupců. Více informací získáte kliknutím na níže uvedený odkaz:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['register_immediate_body'] = 'Děkujeme za registraci na {FORUMNAME}. Vaše uživatelské jméno je {USERNAME}. Pokud zapomenete heslo, můžete o něj požádat na {FORGOTPASSWORDLINK}

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Vítejte na fóru {FORUMNAME}';
$txt['register_pending_body'] = 'Zdravíme, {REALNAME}, obdrželi jsme vaši žádost o registraci na fóru {FORUMNAME}.

Vaše uživatelské jméno je {USERNAME}. Pokud zapomenete heslo, můžete o něj požádat na {FORGOTPASSWORDLINK}

Předtím, než se budete moci přihlásit, musí být vaše žádost přezkoumána a schválena.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Odpověď v tématu: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Do tématu, které sledujete, byla zaslána odpověď od {POSTERNAME}.

Odpověď si můžete prohlédnout na: {TOPICLINK}

Odhlášení z odběru nových odpovědí provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Odpověď v tématu: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Do tématu, které sledujete, byla zaslána odpověď od {POSTERNAME}.

Odpověď si můžete prohlédnout na: {TOPICLINK}

Odhlášení se z odběru nových odpovědí provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

Text odpovědi se nachází níže:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Odpověď v tématu: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Do tématu, které sledujete, byla zaslána odpověď od {POSTERNAME}.

Odpověď si můžete prohlédnout na: {TOPICLINK}

Odhlášení se z odběru nových odpovědí provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

Může být zasláno více příspěvků, ale neobdržíte již další oznámení, dokud si téma neprohlédnete.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Odpověď v tématu: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Do tématu, které sledujete, byla zaslána odpověď od {POSTERNAME}.

Odpověď si můžete prohlédnout na: {TOPICLINK}

Odhlášení se z odběru nových odpovědí provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

Text odpovědi se nachází níže:
{MESSAGE}

Může být zasláno více příspěvků, ale neobdržíte již další oznámení, dokud si téma neprohlédnete.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Téma připíchnuto: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Téma, které sledujete, bylo připíchnuto.

Téma zobrazíte na: {TOPICLINK}

Odhlášení se z odběru informací provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Téma zamčeno: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Téma, které sledujete, bylo zamčeno.

Téma zobrazíte na: {TOPICLINK}

Odhlášení se z odběru informací provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Téma odemčeno: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Téma, které sledujete, bylo odemčeno.

Téma zobrazíte na: {TOPICLINK}

Odhlášení se z odběru informací provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Téma smazáno: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Téma, které sledujete, bylo smazáno.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Téma přesunuto: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Téma, které sledujete, bylo přesunuto do jiné diskuse.

Téma zobrazíte na: {TOPICLINK}

Odhlášení se z odběru informací provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Téma sloučeno: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Téma, které sledujete, bylo sloučeno s dalším tématem.

Nově sloučené téma je zde: {TOPICLINK}

Odhlášení se z odběru informací provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Téma rozděleno: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Téma, které sledujete, bylo rozděleno na dvě či více témat.

Zbytek tohoto tématu je zde: {TOPICLINK}

Odhlášení se z odběru informací provedete pomocí tohoto odkazu: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Přihlášení nového uživatele';
$txt['admin_notify_body'] = 'Uživatel {USERNAME} se právě přihlásil na vaše fórum. Jeho profil si prohlédnete kliknutím na níže uvedený odkaz:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Přihlášení nového uživatele';
$txt['admin_notify_approval_body'] = 'Uživatel {USERNAME} se právě přihlásil na vaše fórum. Jeho profil si prohlédnete kliknutím na níže uvedený odkaz:
{PROFILELINK}

Předtím, než bude smět plně využívat fórum, musí být jeho účet schválen. Schválení účtu provedete na níže uvedeném odkazu:
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Důležité! Adresář pro přílohy je téměř plný';
$txt['admin_attachments_full_body'] = '{REALNAME},

Adresář pro přílohy na fóru {FORUMNAME} je téměř plný. Navštivte fórum pro vyřešení problému.

Jakmile adresář pro přílohy dosáhne maximální povolené velikosti, nebudou uživatelé již nadále moci přikládat soubory k příspěvkům a nahrávat vlastní avatary.

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Vrácení platby za předplatné';
$txt['paid_subscription_refund_body'] = '{REALNAME},

uživateli byly vráceny peníze za předplatné. Následují detaily předplatného:

	Předplatné: {NAME}
	Uživatel: {REFUNDNAME} ({REFUNDUSER})
	Datum: {DATE}

Profil uživatele je na tomto odkazu:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nové předplatné';
$txt['paid_subscription_new_body'] = '{REALNAME},

uživatel si pořídil nové předplatné. Zde jsou detaily předplatného:

	Předplatné: {NAME}
	Uživatel: {SUBNAME} ({SUBUSER})
	Email: {SUBEMAIL}
	Cena: {PRICE}
	Datum: {DATE}

Profil uživatele si můžete prohlédnout na tomto odkazu:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Nastala chyba s předplatným';
$txt['paid_subscription_error_body'] = 'Vážený {REALNAME},

Při zpracování předplatného došlo k následující chybě
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nová soukromá zpráva: {SUBJECT}';
$txt['new_pm_body'] = 'Právě vám přišla soukromá zpráva od uživatele {SENDER} na fóru {FORUMNAME}.

DŮLEŽITÉ: Toto je jen oznámení. Neodpovídejte na tento email.

Zprávu si přečtěte zde: {READLINK}

Odpovězte na ni zde: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nová soukromá zpráva: {SUBJECT}';
$txt['new_pm_body_body'] = 'Právě vám přišla soukromá zpráva od uživatele {SENDER} na fóru {FORUMNAME}.

DŮLEŽITÉ: Toto je jen oznámení. Neodpovídejte na tento email.

Zpráva:
{MESSAGE}

Odpovězte na ni zde: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nová soukromá zpráva: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Právě vám a {TOLIST} přišla soukromá zpráva od uživatele {SENDER} na fóru {FORUMNAME}.

DŮLEŽITÉ: Toto je jen oznámení. Neodpovídejte na tento email.

Zprávu si přečtěte zde: {READLINK}

Odpovězte na ni (jen odesílateli) zde: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nová soukromá zpráva: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Právě vám a {TOLIST} přišla soukromá zpráva od uživatele {SENDER} na fóru {FORUMNAME}.

DŮLEŽITÉ: Toto je jen oznámení. Neodpovídejte na tento email.

Zpráva:
{MESSAGE}

Odpovězte na ni (jen odesílateli) zde: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Byl jste citován v příspěvku: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Zdravím, {MEMBERNAME},

byl jste citován v příspěvku "{CONTENTSUBJECT}" od uživatele {QUOTENAME}, příspěvek si můžete prohlédnout zde:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Byl jste zmíněn v příspěvku: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Zdravím, {MEMBERNAME},

byl jste zmíněn v příspěvku "{CONTENTSUBJECT}" od uživatele {MENTIONNAME}, příspěvek si můžete prohlédnout zde:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Všechno nejlepší z fóra {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Vážený {REALNAME},

My z fóra {FORUMNAME} bychom vám rádi popřáli veselé narozeniny. Ať je tento den i následující rok plný radosti.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'Na vaše narozeniny...';
$txtBirthdayEmails['karlbenson1_body'] = 'Mohli jsme vám poslat pohlednici. Mohli jsme poslat květiny nebo dort.

Ale to jsme neudělali.

Mohli jsme vám dokonce poslat jednu z těch automaticky generovaných zpráv s přáním k narozeninám, kde ani nemusíme nahradit VLOŽTE JMÉNO.

Ale to jsme neudělali.

Místo toho jsme vám napsali toto osobní přání.

Rádi bychom vám popřáli velmi vyjímečné narozeniny.

{REGARDS}

//:: Toto je automaticky generovaná zpráva :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Všechno nejlepší!';
$txtBirthdayEmails['nite0859_body'] = 'Vaši přátelé z fóra {FORUMNAME} by vám chtěli popřát vše nejlepší k narozeninám, {REALNAME}. Pokud jste už dlouho nenavštívili fórum, zkuste nahlédnout a dát tam ostatním vám popřát.

I když jsou to vaše narozeniny, {REALNAME}, rádi bychom vám připomenuli, že vaše členství na fóru je pro nás nejlepší dárek.

Vše nejlepší,
tým fóra {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Přání k narozeninám pro {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Vážený {REALNAME},

uplynul další rok ve vašem životě. My z fóra {FORUMNAME} doufáme, že byl plný radosti a přejeme vám štěstí do dalšího roku.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Vše nejlepší, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = '{REALNAME}, víte, kdo má dneska narozeniny?

My víme... VY!

Vše nejlepší!

Jste sice o rok starší, ale doufáme, že o hodně šťastnější než loni.

Užijte si dnešní den, {REALNAME}!

- Z rodiny fóra {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Vaše přání k narozeninám';
$txtBirthdayEmails['karlbenson2_body'] = 'Doufáme, že vaše narozeniny jsou nejlepší ze všech, ať už je zataženo, slunečno, nebo jakkoli.
Užijte si kus narozeninového dortu a zábavy.

Doufáme, že vás toto přání potěšilo, a doufáme, že se u něj zase potkáme napřesrok.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>