<?php

/**
 * Simple Machines Forum (SMF)
 *
 * @package SMF
 * @author Simple Machines https://www.simplemachines.org
 * @copyright 2025 Simple Machines and individual contributors
 * @license https://www.simplemachines.org/about/smf/license.php BSD
 *
 * @version 2.1.5
 */

if (!defined('SMF'))
	die('No direct access...');

/**
 * Helper function for utf8_normalize_kd.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array Compatibility Decomposition maps for Unicode normalization.
 */
function utf8_normalize_kd_maps()
{
	return array(
		"\xC2\xA0" => "\x20",
		"\xC2\xA8" => "\x20\xCC\x88",
		"\xC2\xAA" => "\x61",
		"\xC2\xAF" => "\x20\xCC\x84",
		"\xC2\xB2" => "\x32",
		"\xC2\xB3" => "\x33",
		"\xC2\xB4" => "\x20\xCC\x81",
		"\xC2\xB5" => "\xCE\xBC",
		"\xC2\xB8" => "\x20\xCC\xA7",
		"\xC2\xB9" => "\x31",
		"\xC2\xBA" => "\x6F",
		"\xC2\xBC" => "\x31\xE2\x81\x84\x34",
		"\xC2\xBD" => "\x31\xE2\x81\x84\x32",
		"\xC2\xBE" => "\x33\xE2\x81\x84\x34",
		"\xC4\xB2" => "\x49\x4A",
		"\xC4\xB3" => "\x69\x6A",
		"\xC4\xBF" => "\x4C\xC2\xB7",
		"\xC5\x80" => "\x6C\xC2\xB7",
		"\xC5\x89" => "\xCA\xBC\x6E",
		"\xC5\xBF" => "\x73",
		"\xC7\x84" => "\x44\x5A\xCC\x8C",
		"\xC7\x85" => "\x44\x7A\xCC\x8C",
		"\xC7\x86" => "\x64\x7A\xCC\x8C",
		"\xC7\x87" => "\x4C\x4A",
		"\xC7\x88" => "\x4C\x6A",
		"\xC7\x89" => "\x6C\x6A",
		"\xC7\x8A" => "\x4E\x4A",
		"\xC7\x8B" => "\x4E\x6A",
		"\xC7\x8C" => "\x6E\x6A",
		"\xC7\xB1" => "\x44\x5A",
		"\xC7\xB2" => "\x44\x7A",
		"\xC7\xB3" => "\x64\x7A",
		"\xCA\xB0" => "\x68",
		"\xCA\xB1" => "\xC9\xA6",
		"\xCA\xB2" => "\x6A",
		"\xCA\xB3" => "\x72",
		"\xCA\xB4" => "\xC9\xB9",
		"\xCA\xB5" => "\xC9\xBB",
		"\xCA\xB6" => "\xCA\x81",
		"\xCA\xB7" => "\x77",
		"\xCA\xB8" => "\x79",
		"\xCB\x98" => "\x20\xCC\x86",
		"\xCB\x99" => "\x20\xCC\x87",
		"\xCB\x9A" => "\x20\xCC\x8A",
		"\xCB\x9B" => "\x20\xCC\xA8",
		"\xCB\x9C" => "\x20\xCC\x83",
		"\xCB\x9D" => "\x20\xCC\x8B",
		"\xCB\xA0" => "\xC9\xA3",
		"\xCB\xA1" => "\x6C",
		"\xCB\xA2" => "\x73",
		"\xCB\xA3" => "\x78",
		"\xCB\xA4" => "\xCA\x95",
		"\xCD\xBA" => "\x20\xCD\x85",
		"\xCE\x84" => "\x20\xCC\x81",
		"\xCE\x85" => "\x20\xCC\x88\xCC\x81",
		"\xCF\x90" => "\xCE\xB2",
		"\xCF\x91" => "\xCE\xB8",
		"\xCF\x92" => "\xCE\xA5",
		"\xCF\x93" => "\xCE\xA5\xCC\x81",
		"\xCF\x94" => "\xCE\xA5\xCC\x88",
		"\xCF\x95" => "\xCF\x86",
		"\xCF\x96" => "\xCF\x80",
		"\xCF\xB0" => "\xCE\xBA",
		"\xCF\xB1" => "\xCF\x81",
		"\xCF\xB2" => "\xCF\x82",
		"\xCF\xB4" => "\xCE\x98",
		"\xCF\xB5" => "\xCE\xB5",
		"\xCF\xB9" => "\xCE\xA3",
		"\xD6\x87" => "\xD5\xA5\xD6\x82",
		"\xD9\xB5" => "\xD8\xA7\xD9\xB4",
		"\xD9\xB6" => "\xD9\x88\xD9\xB4",
		"\xD9\xB7" => "\xDB\x87\xD9\xB4",
		"\xD9\xB8" => "\xD9\x8A\xD9\xB4",
		"\xE0\xB8\xB3" => "\xE0\xB9\x8D\xE0\xB8\xB2",
		"\xE0\xBA\xB3" => "\xE0\xBB\x8D\xE0\xBA\xB2",
		"\xE0\xBB\x9C" => "\xE0\xBA\xAB\xE0\xBA\x99",
		"\xE0\xBB\x9D" => "\xE0\xBA\xAB\xE0\xBA\xA1",
		"\xE0\xBC\x8C" => "\xE0\xBC\x8B",
		"\xE0\xBD\xB7" => "\xE0\xBE\xB2\xE0\xBD\xB1\xE0\xBE\x80",
		"\xE0\xBD\xB9" => "\xE0\xBE\xB3\xE0\xBD\xB1\xE0\xBE\x80",
		"\xE1\x83\xBC" => "\xE1\x83\x9C",
		"\xE1\xB4\xAC" => "\x41",
		"\xE1\xB4\xAD" => "\xC3\x86",
		"\xE1\xB4\xAE" => "\x42",
		"\xE1\xB4\xB0" => "\x44",
		"\xE1\xB4\xB1" => "\x45",
		"\xE1\xB4\xB2" => "\xC6\x8E",
		"\xE1\xB4\xB3" => "\x47",
		"\xE1\xB4\xB4" => "\x48",
		"\xE1\xB4\xB5" => "\x49",
		"\xE1\xB4\xB6" => "\x4A",
		"\xE1\xB4\xB7" => "\x4B",
		"\xE1\xB4\xB8" => "\x4C",
		"\xE1\xB4\xB9" => "\x4D",
		"\xE1\xB4\xBA" => "\x4E",
		"\xE1\xB4\xBC" => "\x4F",
		"\xE1\xB4\xBD" => "\xC8\xA2",
		"\xE1\xB4\xBE" => "\x50",
		"\xE1\xB4\xBF" => "\x52",
		"\xE1\xB5\x80" => "\x54",
		"\xE1\xB5\x81" => "\x55",
		"\xE1\xB5\x82" => "\x57",
		"\xE1\xB5\x83" => "\x61",
		"\xE1\xB5\x84" => "\xC9\x90",
		"\xE1\xB5\x85" => "\xC9\x91",
		"\xE1\xB5\x86" => "\xE1\xB4\x82",
		"\xE1\xB5\x87" => "\x62",
		"\xE1\xB5\x88" => "\x64",
		"\xE1\xB5\x89" => "\x65",
		"\xE1\xB5\x8A" => "\xC9\x99",
		"\xE1\xB5\x8B" => "\xC9\x9B",
		"\xE1\xB5\x8C" => "\xC9\x9C",
		"\xE1\xB5\x8D" => "\x67",
		"\xE1\xB5\x8F" => "\x6B",
		"\xE1\xB5\x90" => "\x6D",
		"\xE1\xB5\x91" => "\xC5\x8B",
		"\xE1\xB5\x92" => "\x6F",
		"\xE1\xB5\x93" => "\xC9\x94",
		"\xE1\xB5\x94" => "\xE1\xB4\x96",
		"\xE1\xB5\x95" => "\xE1\xB4\x97",
		"\xE1\xB5\x96" => "\x70",
		"\xE1\xB5\x97" => "\x74",
		"\xE1\xB5\x98" => "\x75",
		"\xE1\xB5\x99" => "\xE1\xB4\x9D",
		"\xE1\xB5\x9A" => "\xC9\xAF",
		"\xE1\xB5\x9B" => "\x76",
		"\xE1\xB5\x9C" => "\xE1\xB4\xA5",
		"\xE1\xB5\x9D" => "\xCE\xB2",
		"\xE1\xB5\x9E" => "\xCE\xB3",
		"\xE1\xB5\x9F" => "\xCE\xB4",
		"\xE1\xB5\xA0" => "\xCF\x86",
		"\xE1\xB5\xA1" => "\xCF\x87",
		"\xE1\xB5\xA2" => "\x69",
		"\xE1\xB5\xA3" => "\x72",
		"\xE1\xB5\xA4" => "\x75",
		"\xE1\xB5\xA5" => "\x76",
		"\xE1\xB5\xA6" => "\xCE\xB2",
		"\xE1\xB5\xA7" => "\xCE\xB3",
		"\xE1\xB5\xA8" => "\xCF\x81",
		"\xE1\xB5\xA9" => "\xCF\x86",
		"\xE1\xB5\xAA" => "\xCF\x87",
		"\xE1\xB5\xB8" => "\xD0\xBD",
		"\xE1\xB6\x9B" => "\xC9\x92",
		"\xE1\xB6\x9C" => "\x63",
		"\xE1\xB6\x9D" => "\xC9\x95",
		"\xE1\xB6\x9E" => "\xC3\xB0",
		"\xE1\xB6\x9F" => "\xC9\x9C",
		"\xE1\xB6\xA0" => "\x66",
		"\xE1\xB6\xA1" => "\xC9\x9F",
		"\xE1\xB6\xA2" => "\xC9\xA1",
		"\xE1\xB6\xA3" => "\xC9\xA5",
		"\xE1\xB6\xA4" => "\xC9\xA8",
		"\xE1\xB6\xA5" => "\xC9\xA9",
		"\xE1\xB6\xA6" => "\xC9\xAA",
		"\xE1\xB6\xA7" => "\xE1\xB5\xBB",
		"\xE1\xB6\xA8" => "\xCA\x9D",
		"\xE1\xB6\xA9" => "\xC9\xAD",
		"\xE1\xB6\xAA" => "\xE1\xB6\x85",
		"\xE1\xB6\xAB" => "\xCA\x9F",
		"\xE1\xB6\xAC" => "\xC9\xB1",
		"\xE1\xB6\xAD" => "\xC9\xB0",
		"\xE1\xB6\xAE" => "\xC9\xB2",
		"\xE1\xB6\xAF" => "\xC9\xB3",
		"\xE1\xB6\xB0" => "\xC9\xB4",
		"\xE1\xB6\xB1" => "\xC9\xB5",
		"\xE1\xB6\xB2" => "\xC9\xB8",
		"\xE1\xB6\xB3" => "\xCA\x82",
		"\xE1\xB6\xB4" => "\xCA\x83",
		"\xE1\xB6\xB5" => "\xC6\xAB",
		"\xE1\xB6\xB6" => "\xCA\x89",
		"\xE1\xB6\xB7" => "\xCA\x8A",
		"\xE1\xB6\xB8" => "\xE1\xB4\x9C",
		"\xE1\xB6\xB9" => "\xCA\x8B",
		"\xE1\xB6\xBA" => "\xCA\x8C",
		"\xE1\xB6\xBB" => "\x7A",
		"\xE1\xB6\xBC" => "\xCA\x90",
		"\xE1\xB6\xBD" => "\xCA\x91",
		"\xE1\xB6\xBE" => "\xCA\x92",
		"\xE1\xB6\xBF" => "\xCE\xB8",
		"\xE1\xBA\x9A" => "\x61\xCA\xBE",
		"\xE1\xBA\x9B" => "\x73\xCC\x87",
		"\xE1\xBE\xBD" => "\x20\xCC\x93",
		"\xE1\xBE\xBF" => "\x20\xCC\x93",
		"\xE1\xBF\x80" => "\x20\xCD\x82",
		"\xE1\xBF\x81" => "\x20\xCC\x88\xCD\x82",
		"\xE1\xBF\x8D" => "\x20\xCC\x93\xCC\x80",
		"\xE1\xBF\x8E" => "\x20\xCC\x93\xCC\x81",
		"\xE1\xBF\x8F" => "\x20\xCC\x93\xCD\x82",
		"\xE1\xBF\x9D" => "\x20\xCC\x94\xCC\x80",
		"\xE1\xBF\x9E" => "\x20\xCC\x94\xCC\x81",
		"\xE1\xBF\x9F" => "\x20\xCC\x94\xCD\x82",
		"\xE1\xBF\xAD" => "\x20\xCC\x88\xCC\x80",
		"\xE1\xBF\xAE" => "\x20\xCC\x88\xCC\x81",
		"\xE1\xBF\xBD" => "\x20\xCC\x81",
		"\xE1\xBF\xBE" => "\x20\xCC\x94",
		"\xE2\x80\x80" => "\x20",
		"\xE2\x80\x81" => "\x20",
		"\xE2\x80\x82" => "\x20",
		"\xE2\x80\x83" => "\x20",
		"\xE2\x80\x84" => "\x20",
		"\xE2\x80\x85" => "\x20",
		"\xE2\x80\x86" => "\x20",
		"\xE2\x80\x87" => "\x20",
		"\xE2\x80\x88" => "\x20",
		"\xE2\x80\x89" => "\x20",
		"\xE2\x80\x8A" => "\x20",
		"\xE2\x80\x91" => "\xE2\x80\x90",
		"\xE2\x80\x97" => "\x20\xCC\xB3",
		"\xE2\x80\xA4" => "\x2E",
		"\xE2\x80\xA5" => "\x2E\x2E",
		"\xE2\x80\xA6" => "\x2E\x2E\x2E",
		"\xE2\x80\xAF" => "\x20",
		"\xE2\x80\xB3" => "\xE2\x80\xB2\xE2\x80\xB2",
		"\xE2\x80\xB4" => "\xE2\x80\xB2\xE2\x80\xB2\xE2\x80\xB2",
		"\xE2\x80\xB6" => "\xE2\x80\xB5\xE2\x80\xB5",
		"\xE2\x80\xB7" => "\xE2\x80\xB5\xE2\x80\xB5\xE2\x80\xB5",
		"\xE2\x80\xBC" => "\x21\x21",
		"\xE2\x80\xBE" => "\x20\xCC\x85",
		"\xE2\x81\x87" => "\x3F\x3F",
		"\xE2\x81\x88" => "\x3F\x21",
		"\xE2\x81\x89" => "\x21\x3F",
		"\xE2\x81\x97" => "\xE2\x80\xB2\xE2\x80\xB2\xE2\x80\xB2\xE2\x80\xB2",
		"\xE2\x81\x9F" => "\x20",
		"\xE2\x81\xB0" => "\x30",
		"\xE2\x81\xB1" => "\x69",
		"\xE2\x81\xB4" => "\x34",
		"\xE2\x81\xB5" => "\x35",
		"\xE2\x81\xB6" => "\x36",
		"\xE2\x81\xB7" => "\x37",
		"\xE2\x81\xB8" => "\x38",
		"\xE2\x81\xB9" => "\x39",
		"\xE2\x81\xBA" => "\x2B",
		"\xE2\x81\xBB" => "\xE2\x88\x92",
		"\xE2\x81\xBC" => "\x3D",
		"\xE2\x81\xBD" => "\x28",
		"\xE2\x81\xBE" => "\x29",
		"\xE2\x81\xBF" => "\x6E",
		"\xE2\x82\x80" => "\x30",
		"\xE2\x82\x81" => "\x31",
		"\xE2\x82\x82" => "\x32",
		"\xE2\x82\x83" => "\x33",
		"\xE2\x82\x84" => "\x34",
		"\xE2\x82\x85" => "\x35",
		"\xE2\x82\x86" => "\x36",
		"\xE2\x82\x87" => "\x37",
		"\xE2\x82\x88" => "\x38",
		"\xE2\x82\x89" => "\x39",
		"\xE2\x82\x8A" => "\x2B",
		"\xE2\x82\x8B" => "\xE2\x88\x92",
		"\xE2\x82\x8C" => "\x3D",
		"\xE2\x82\x8D" => "\x28",
		"\xE2\x82\x8E" => "\x29",
		"\xE2\x82\x90" => "\x61",
		"\xE2\x82\x91" => "\x65",
		"\xE2\x82\x92" => "\x6F",
		"\xE2\x82\x93" => "\x78",
		"\xE2\x82\x94" => "\xC9\x99",
		"\xE2\x82\x95" => "\x68",
		"\xE2\x82\x96" => "\x6B",
		"\xE2\x82\x97" => "\x6C",
		"\xE2\x82\x98" => "\x6D",
		"\xE2\x82\x99" => "\x6E",
		"\xE2\x82\x9A" => "\x70",
		"\xE2\x82\x9B" => "\x73",
		"\xE2\x82\x9C" => "\x74",
		"\xE2\x82\xA8" => "\x52\x73",
		"\xE2\x84\x80" => "\x61\x2F\x63",
		"\xE2\x84\x81" => "\x61\x2F\x73",
		"\xE2\x84\x82" => "\x43",
		"\xE2\x84\x83" => "\xC2\xB0\x43",
		"\xE2\x84\x85" => "\x63\x2F\x6F",
		"\xE2\x84\x86" => "\x63\x2F\x75",
		"\xE2\x84\x87" => "\xC6\x90",
		"\xE2\x84\x89" => "\xC2\xB0\x46",
		"\xE2\x84\x8A" => "\x67",
		"\xE2\x84\x8B" => "\x48",
		"\xE2\x84\x8C" => "\x48",
		"\xE2\x84\x8D" => "\x48",
		"\xE2\x84\x8E" => "\x68",
		"\xE2\x84\x8F" => "\xC4\xA7",
		"\xE2\x84\x90" => "\x49",
		"\xE2\x84\x91" => "\x49",
		"\xE2\x84\x92" => "\x4C",
		"\xE2\x84\x93" => "\x6C",
		"\xE2\x84\x95" => "\x4E",
		"\xE2\x84\x96" => "\x4E\x6F",
		"\xE2\x84\x99" => "\x50",
		"\xE2\x84\x9A" => "\x51",
		"\xE2\x84\x9B" => "\x52",
		"\xE2\x84\x9C" => "\x52",
		"\xE2\x84\x9D" => "\x52",
		"\xE2\x84\xA0" => "\x53\x4D",
		"\xE2\x84\xA1" => "\x54\x45\x4C",
		"\xE2\x84\xA2" => "\x54\x4D",
		"\xE2\x84\xA4" => "\x5A",
		"\xE2\x84\xA8" => "\x5A",
		"\xE2\x84\xAC" => "\x42",
		"\xE2\x84\xAD" => "\x43",
		"\xE2\x84\xAF" => "\x65",
		"\xE2\x84\xB0" => "\x45",
		"\xE2\x84\xB1" => "\x46",
		"\xE2\x84\xB3" => "\x4D",
		"\xE2\x84\xB4" => "\x6F",
		"\xE2\x84\xB5" => "\xD7\x90",
		"\xE2\x84\xB6" => "\xD7\x91",
		"\xE2\x84\xB7" => "\xD7\x92",
		"\xE2\x84\xB8" => "\xD7\x93",
		"\xE2\x84\xB9" => "\x69",
		"\xE2\x84\xBB" => "\x46\x41\x58",
		"\xE2\x84\xBC" => "\xCF\x80",
		"\xE2\x84\xBD" => "\xCE\xB3",
		"\xE2\x84\xBE" => "\xCE\x93",
		"\xE2\x84\xBF" => "\xCE\xA0",
		"\xE2\x85\x80" => "\xE2\x88\x91",
		"\xE2\x85\x85" => "\x44",
		"\xE2\x85\x86" => "\x64",
		"\xE2\x85\x87" => "\x65",
		"\xE2\x85\x88" => "\x69",
		"\xE2\x85\x89" => "\x6A",
		"\xE2\x85\x90" => "\x31\xE2\x81\x84\x37",
		"\xE2\x85\x91" => "\x31\xE2\x81\x84\x39",
		"\xE2\x85\x92" => "\x31\xE2\x81\x84\x31\x30",
		"\xE2\x85\x93" => "\x31\xE2\x81\x84\x33",
		"\xE2\x85\x94" => "\x32\xE2\x81\x84\x33",
		"\xE2\x85\x95" => "\x31\xE2\x81\x84\x35",
		"\xE2\x85\x96" => "\x32\xE2\x81\x84\x35",
		"\xE2\x85\x97" => "\x33\xE2\x81\x84\x35",
		"\xE2\x85\x98" => "\x34\xE2\x81\x84\x35",
		"\xE2\x85\x99" => "\x31\xE2\x81\x84\x36",
		"\xE2\x85\x9A" => "\x35\xE2\x81\x84\x36",
		"\xE2\x85\x9B" => "\x31\xE2\x81\x84\x38",
		"\xE2\x85\x9C" => "\x33\xE2\x81\x84\x38",
		"\xE2\x85\x9D" => "\x35\xE2\x81\x84\x38",
		"\xE2\x85\x9E" => "\x37\xE2\x81\x84\x38",
		"\xE2\x85\x9F" => "\x31\xE2\x81\x84",
		"\xE2\x85\xA0" => "\x49",
		"\xE2\x85\xA1" => "\x49\x49",
		"\xE2\x85\xA2" => "\x49\x49\x49",
		"\xE2\x85\xA3" => "\x49\x56",
		"\xE2\x85\xA4" => "\x56",
		"\xE2\x85\xA5" => "\x56\x49",
		"\xE2\x85\xA6" => "\x56\x49\x49",
		"\xE2\x85\xA7" => "\x56\x49\x49\x49",
		"\xE2\x85\xA8" => "\x49\x58",
		"\xE2\x85\xA9" => "\x58",
		"\xE2\x85\xAA" => "\x58\x49",
		"\xE2\x85\xAB" => "\x58\x49\x49",
		"\xE2\x85\xAC" => "\x4C",
		"\xE2\x85\xAD" => "\x43",
		"\xE2\x85\xAE" => "\x44",
		"\xE2\x85\xAF" => "\x4D",
		"\xE2\x85\xB0" => "\x69",
		"\xE2\x85\xB1" => "\x69\x69",
		"\xE2\x85\xB2" => "\x69\x69\x69",
		"\xE2\x85\xB3" => "\x69\x76",
		"\xE2\x85\xB4" => "\x76",
		"\xE2\x85\xB5" => "\x76\x69",
		"\xE2\x85\xB6" => "\x76\x69\x69",
		"\xE2\x85\xB7" => "\x76\x69\x69\x69",
		"\xE2\x85\xB8" => "\x69\x78",
		"\xE2\x85\xB9" => "\x78",
		"\xE2\x85\xBA" => "\x78\x69",
		"\xE2\x85\xBB" => "\x78\x69\x69",
		"\xE2\x85\xBC" => "\x6C",
		"\xE2\x85\xBD" => "\x63",
		"\xE2\x85\xBE" => "\x64",
		"\xE2\x85\xBF" => "\x6D",
		"\xE2\x86\x89" => "\x30\xE2\x81\x84\x33",
		"\xE2\x88\xAC" => "\xE2\x88\xAB\xE2\x88\xAB",
		"\xE2\x88\xAD" => "\xE2\x88\xAB\xE2\x88\xAB\xE2\x88\xAB",
		"\xE2\x88\xAF" => "\xE2\x88\xAE\xE2\x88\xAE",
		"\xE2\x88\xB0" => "\xE2\x88\xAE\xE2\x88\xAE\xE2\x88\xAE",
		"\xE2\x91\xA0" => "\x31",
		"\xE2\x91\xA1" => "\x32",
		"\xE2\x91\xA2" => "\x33",
		"\xE2\x91\xA3" => "\x34",
		"\xE2\x91\xA4" => "\x35",
		"\xE2\x91\xA5" => "\x36",
		"\xE2\x91\xA6" => "\x37",
		"\xE2\x91\xA7" => "\x38",
		"\xE2\x91\xA8" => "\x39",
		"\xE2\x91\xA9" => "\x31\x30",
		"\xE2\x91\xAA" => "\x31\x31",
		"\xE2\x91\xAB" => "\x31\x32",
		"\xE2\x91\xAC" => "\x31\x33",
		"\xE2\x91\xAD" => "\x31\x34",
		"\xE2\x91\xAE" => "\x31\x35",
		"\xE2\x91\xAF" => "\x31\x36",
		"\xE2\x91\xB0" => "\x31\x37",
		"\xE2\x91\xB1" => "\x31\x38",
		"\xE2\x91\xB2" => "\x31\x39",
		"\xE2\x91\xB3" => "\x32\x30",
		"\xE2\x91\xB4" => "\x28\x31\x29",
		"\xE2\x91\xB5" => "\x28\x32\x29",
		"\xE2\x91\xB6" => "\x28\x33\x29",
		"\xE2\x91\xB7" => "\x28\x34\x29",
		"\xE2\x91\xB8" => "\x28\x35\x29",
		"\xE2\x91\xB9" => "\x28\x36\x29",
		"\xE2\x91\xBA" => "\x28\x37\x29",
		"\xE2\x91\xBB" => "\x28\x38\x29",
		"\xE2\x91\xBC" => "\x28\x39\x29",
		"\xE2\x91\xBD" => "\x28\x31\x30\x29",
		"\xE2\x91\xBE" => "\x28\x31\x31\x29",
		"\xE2\x91\xBF" => "\x28\x31\x32\x29",
		"\xE2\x92\x80" => "\x28\x31\x33\x29",
		"\xE2\x92\x81" => "\x28\x31\x34\x29",
		"\xE2\x92\x82" => "\x28\x31\x35\x29",
		"\xE2\x92\x83" => "\x28\x31\x36\x29",
		"\xE2\x92\x84" => "\x28\x31\x37\x29",
		"\xE2\x92\x85" => "\x28\x31\x38\x29",
		"\xE2\x92\x86" => "\x28\x31\x39\x29",
		"\xE2\x92\x87" => "\x28\x32\x30\x29",
		"\xE2\x92\x88" => "\x31\x2E",
		"\xE2\x92\x89" => "\x32\x2E",
		"\xE2\x92\x8A" => "\x33\x2E",
		"\xE2\x92\x8B" => "\x34\x2E",
		"\xE2\x92\x8C" => "\x35\x2E",
		"\xE2\x92\x8D" => "\x36\x2E",
		"\xE2\x92\x8E" => "\x37\x2E",
		"\xE2\x92\x8F" => "\x38\x2E",
		"\xE2\x92\x90" => "\x39\x2E",
		"\xE2\x92\x91" => "\x31\x30\x2E",
		"\xE2\x92\x92" => "\x31\x31\x2E",
		"\xE2\x92\x93" => "\x31\x32\x2E",
		"\xE2\x92\x94" => "\x31\x33\x2E",
		"\xE2\x92\x95" => "\x31\x34\x2E",
		"\xE2\x92\x96" => "\x31\x35\x2E",
		"\xE2\x92\x97" => "\x31\x36\x2E",
		"\xE2\x92\x98" => "\x31\x37\x2E",
		"\xE2\x92\x99" => "\x31\x38\x2E",
		"\xE2\x92\x9A" => "\x31\x39\x2E",
		"\xE2\x92\x9B" => "\x32\x30\x2E",
		"\xE2\x92\x9C" => "\x28\x61\x29",
		"\xE2\x92\x9D" => "\x28\x62\x29",
		"\xE2\x92\x9E" => "\x28\x63\x29",
		"\xE2\x92\x9F" => "\x28\x64\x29",
		"\xE2\x92\xA0" => "\x28\x65\x29",
		"\xE2\x92\xA1" => "\x28\x66\x29",
		"\xE2\x92\xA2" => "\x28\x67\x29",
		"\xE2\x92\xA3" => "\x28\x68\x29",
		"\xE2\x92\xA4" => "\x28\x69\x29",
		"\xE2\x92\xA5" => "\x28\x6A\x29",
		"\xE2\x92\xA6" => "\x28\x6B\x29",
		"\xE2\x92\xA7" => "\x28\x6C\x29",
		"\xE2\x92\xA8" => "\x28\x6D\x29",
		"\xE2\x92\xA9" => "\x28\x6E\x29",
		"\xE2\x92\xAA" => "\x28\x6F\x29",
		"\xE2\x92\xAB" => "\x28\x70\x29",
		"\xE2\x92\xAC" => "\x28\x71\x29",
		"\xE2\x92\xAD" => "\x28\x72\x29",
		"\xE2\x92\xAE" => "\x28\x73\x29",
		"\xE2\x92\xAF" => "\x28\x74\x29",
		"\xE2\x92\xB0" => "\x28\x75\x29",
		"\xE2\x92\xB1" => "\x28\x76\x29",
		"\xE2\x92\xB2" => "\x28\x77\x29",
		"\xE2\x92\xB3" => "\x28\x78\x29",
		"\xE2\x92\xB4" => "\x28\x79\x29",
		"\xE2\x92\xB5" => "\x28\x7A\x29",
		"\xE2\x92\xB6" => "\x41",
		"\xE2\x92\xB7" => "\x42",
		"\xE2\x92\xB8" => "\x43",
		"\xE2\x92\xB9" => "\x44",
		"\xE2\x92\xBA" => "\x45",
		"\xE2\x92\xBB" => "\x46",
		"\xE2\x92\xBC" => "\x47",
		"\xE2\x92\xBD" => "\x48",
		"\xE2\x92\xBE" => "\x49",
		"\xE2\x92\xBF" => "\x4A",
		"\xE2\x93\x80" => "\x4B",
		"\xE2\x93\x81" => "\x4C",
		"\xE2\x93\x82" => "\x4D",
		"\xE2\x93\x83" => "\x4E",
		"\xE2\x93\x84" => "\x4F",
		"\xE2\x93\x85" => "\x50",
		"\xE2\x93\x86" => "\x51",
		"\xE2\x93\x87" => "\x52",
		"\xE2\x93\x88" => "\x53",
		"\xE2\x93\x89" => "\x54",
		"\xE2\x93\x8A" => "\x55",
		"\xE2\x93\x8B" => "\x56",
		"\xE2\x93\x8C" => "\x57",
		"\xE2\x93\x8D" => "\x58",
		"\xE2\x93\x8E" => "\x59",
		"\xE2\x93\x8F" => "\x5A",
		"\xE2\x93\x90" => "\x61",
		"\xE2\x93\x91" => "\x62",
		"\xE2\x93\x92" => "\x63",
		"\xE2\x93\x93" => "\x64",
		"\xE2\x93\x94" => "\x65",
		"\xE2\x93\x95" => "\x66",
		"\xE2\x93\x96" => "\x67",
		"\xE2\x93\x97" => "\x68",
		"\xE2\x93\x98" => "\x69",
		"\xE2\x93\x99" => "\x6A",
		"\xE2\x93\x9A" => "\x6B",
		"\xE2\x93\x9B" => "\x6C",
		"\xE2\x93\x9C" => "\x6D",
		"\xE2\x93\x9D" => "\x6E",
		"\xE2\x93\x9E" => "\x6F",
		"\xE2\x93\x9F" => "\x70",
		"\xE2\x93\xA0" => "\x71",
		"\xE2\x93\xA1" => "\x72",
		"\xE2\x93\xA2" => "\x73",
		"\xE2\x93\xA3" => "\x74",
		"\xE2\x93\xA4" => "\x75",
		"\xE2\x93\xA5" => "\x76",
		"\xE2\x93\xA6" => "\x77",
		"\xE2\x93\xA7" => "\x78",
		"\xE2\x93\xA8" => "\x79",
		"\xE2\x93\xA9" => "\x7A",
		"\xE2\x93\xAA" => "\x30",
		"\xE2\xA8\x8C" => "\xE2\x88\xAB\xE2\x88\xAB\xE2\x88\xAB\xE2\x88\xAB",
		"\xE2\xA9\xB4" => "\x3A\x3A\x3D",
		"\xE2\xA9\xB5" => "\x3D\x3D",
		"\xE2\xA9\xB6" => "\x3D\x3D\x3D",
		"\xE2\xB1\xBC" => "\x6A",
		"\xE2\xB1\xBD" => "\x56",
		"\xE2\xB5\xAF" => "\xE2\xB5\xA1",
		"\xE2\xBA\x9F" => "\xE6\xAF\x8D",
		"\xE2\xBB\xB3" => "\xE9\xBE\x9F",
		"\xE2\xBC\x80" => "\xE4\xB8\x80",
		"\xE2\xBC\x81" => "\xE4\xB8\xA8",
		"\xE2\xBC\x82" => "\xE4\xB8\xB6",
		"\xE2\xBC\x83" => "\xE4\xB8\xBF",
		"\xE2\xBC\x84" => "\xE4\xB9\x99",
		"\xE2\xBC\x85" => "\xE4\xBA\x85",
		"\xE2\xBC\x86" => "\xE4\xBA\x8C",
		"\xE2\xBC\x87" => "\xE4\xBA\xA0",
		"\xE2\xBC\x88" => "\xE4\xBA\xBA",
		"\xE2\xBC\x89" => "\xE5\x84\xBF",
		"\xE2\xBC\x8A" => "\xE5\x85\xA5",
		"\xE2\xBC\x8B" => "\xE5\x85\xAB",
		"\xE2\xBC\x8C" => "\xE5\x86\x82",
		"\xE2\xBC\x8D" => "\xE5\x86\x96",
		"\xE2\xBC\x8E" => "\xE5\x86\xAB",
		"\xE2\xBC\x8F" => "\xE5\x87\xA0",
		"\xE2\xBC\x90" => "\xE5\x87\xB5",
		"\xE2\xBC\x91" => "\xE5\x88\x80",
		"\xE2\xBC\x92" => "\xE5\x8A\x9B",
		"\xE2\xBC\x93" => "\xE5\x8B\xB9",
		"\xE2\xBC\x94" => "\xE5\x8C\x95",
		"\xE2\xBC\x95" => "\xE5\x8C\x9A",
		"\xE2\xBC\x96" => "\xE5\x8C\xB8",
		"\xE2\xBC\x97" => "\xE5\x8D\x81",
		"\xE2\xBC\x98" => "\xE5\x8D\x9C",
		"\xE2\xBC\x99" => "\xE5\x8D\xA9",
		"\xE2\xBC\x9A" => "\xE5\x8E\x82",
		"\xE2\xBC\x9B" => "\xE5\x8E\xB6",
		"\xE2\xBC\x9C" => "\xE5\x8F\x88",
		"\xE2\xBC\x9D" => "\xE5\x8F\xA3",
		"\xE2\xBC\x9E" => "\xE5\x9B\x97",
		"\xE2\xBC\x9F" => "\xE5\x9C\x9F",
		"\xE2\xBC\xA0" => "\xE5\xA3\xAB",
		"\xE2\xBC\xA1" => "\xE5\xA4\x82",
		"\xE2\xBC\xA2" => "\xE5\xA4\x8A",
		"\xE2\xBC\xA3" => "\xE5\xA4\x95",
		"\xE2\xBC\xA4" => "\xE5\xA4\xA7",
		"\xE2\xBC\xA5" => "\xE5\xA5\xB3",
		"\xE2\xBC\xA6" => "\xE5\xAD\x90",
		"\xE2\xBC\xA7" => "\xE5\xAE\x80",
		"\xE2\xBC\xA8" => "\xE5\xAF\xB8",
		"\xE2\xBC\xA9" => "\xE5\xB0\x8F",
		"\xE2\xBC\xAA" => "\xE5\xB0\xA2",
		"\xE2\xBC\xAB" => "\xE5\xB0\xB8",
		"\xE2\xBC\xAC" => "\xE5\xB1\xAE",
		"\xE2\xBC\xAD" => "\xE5\xB1\xB1",
		"\xE2\xBC\xAE" => "\xE5\xB7\x9B",
		"\xE2\xBC\xAF" => "\xE5\xB7\xA5",
		"\xE2\xBC\xB0" => "\xE5\xB7\xB1",
		"\xE2\xBC\xB1" => "\xE5\xB7\xBE",
		"\xE2\xBC\xB2" => "\xE5\xB9\xB2",
		"\xE2\xBC\xB3" => "\xE5\xB9\xBA",
		"\xE2\xBC\xB4" => "\xE5\xB9\xBF",
		"\xE2\xBC\xB5" => "\xE5\xBB\xB4",
		"\xE2\xBC\xB6" => "\xE5\xBB\xBE",
		"\xE2\xBC\xB7" => "\xE5\xBC\x8B",
		"\xE2\xBC\xB8" => "\xE5\xBC\x93",
		"\xE2\xBC\xB9" => "\xE5\xBD\x90",
		"\xE2\xBC\xBA" => "\xE5\xBD\xA1",
		"\xE2\xBC\xBB" => "\xE5\xBD\xB3",
		"\xE2\xBC\xBC" => "\xE5\xBF\x83",
		"\xE2\xBC\xBD" => "\xE6\x88\x88",
		"\xE2\xBC\xBE" => "\xE6\x88\xB6",
		"\xE2\xBC\xBF" => "\xE6\x89\x8B",
		"\xE2\xBD\x80" => "\xE6\x94\xAF",
		"\xE2\xBD\x81" => "\xE6\x94\xB4",
		"\xE2\xBD\x82" => "\xE6\x96\x87",
		"\xE2\xBD\x83" => "\xE6\x96\x97",
		"\xE2\xBD\x84" => "\xE6\x96\xA4",
		"\xE2\xBD\x85" => "\xE6\x96\xB9",
		"\xE2\xBD\x86" => "\xE6\x97\xA0",
		"\xE2\xBD\x87" => "\xE6\x97\xA5",
		"\xE2\xBD\x88" => "\xE6\x9B\xB0",
		"\xE2\xBD\x89" => "\xE6\x9C\x88",
		"\xE2\xBD\x8A" => "\xE6\x9C\xA8",
		"\xE2\xBD\x8B" => "\xE6\xAC\xA0",
		"\xE2\xBD\x8C" => "\xE6\xAD\xA2",
		"\xE2\xBD\x8D" => "\xE6\xAD\xB9",
		"\xE2\xBD\x8E" => "\xE6\xAE\xB3",
		"\xE2\xBD\x8F" => "\xE6\xAF\x8B",
		"\xE2\xBD\x90" => "\xE6\xAF\x94",
		"\xE2\xBD\x91" => "\xE6\xAF\x9B",
		"\xE2\xBD\x92" => "\xE6\xB0\x8F",
		"\xE2\xBD\x93" => "\xE6\xB0\x94",
		"\xE2\xBD\x94" => "\xE6\xB0\xB4",
		"\xE2\xBD\x95" => "\xE7\x81\xAB",
		"\xE2\xBD\x96" => "\xE7\x88\xAA",
		"\xE2\xBD\x97" => "\xE7\x88\xB6",
		"\xE2\xBD\x98" => "\xE7\x88\xBB",
		"\xE2\xBD\x99" => "\xE7\x88\xBF",
		"\xE2\xBD\x9A" => "\xE7\x89\x87",
		"\xE2\xBD\x9B" => "\xE7\x89\x99",
		"\xE2\xBD\x9C" => "\xE7\x89\x9B",
		"\xE2\xBD\x9D" => "\xE7\x8A\xAC",
		"\xE2\xBD\x9E" => "\xE7\x8E\x84",
		"\xE2\xBD\x9F" => "\xE7\x8E\x89",
		"\xE2\xBD\xA0" => "\xE7\x93\x9C",
		"\xE2\xBD\xA1" => "\xE7\x93\xA6",
		"\xE2\xBD\xA2" => "\xE7\x94\x98",
		"\xE2\xBD\xA3" => "\xE7\x94\x9F",
		"\xE2\xBD\xA4" => "\xE7\x94\xA8",
		"\xE2\xBD\xA5" => "\xE7\x94\xB0",
		"\xE2\xBD\xA6" => "\xE7\x96\x8B",
		"\xE2\xBD\xA7" => "\xE7\x96\x92",
		"\xE2\xBD\xA8" => "\xE7\x99\xB6",
		"\xE2\xBD\xA9" => "\xE7\x99\xBD",
		"\xE2\xBD\xAA" => "\xE7\x9A\xAE",
		"\xE2\xBD\xAB" => "\xE7\x9A\xBF",
		"\xE2\xBD\xAC" => "\xE7\x9B\xAE",
		"\xE2\xBD\xAD" => "\xE7\x9F\x9B",
		"\xE2\xBD\xAE" => "\xE7\x9F\xA2",
		"\xE2\xBD\xAF" => "\xE7\x9F\xB3",
		"\xE2\xBD\xB0" => "\xE7\xA4\xBA",
		"\xE2\xBD\xB1" => "\xE7\xA6\xB8",
		"\xE2\xBD\xB2" => "\xE7\xA6\xBE",
		"\xE2\xBD\xB3" => "\xE7\xA9\xB4",
		"\xE2\xBD\xB4" => "\xE7\xAB\x8B",
		"\xE2\xBD\xB5" => "\xE7\xAB\xB9",
		"\xE2\xBD\xB6" => "\xE7\xB1\xB3",
		"\xE2\xBD\xB7" => "\xE7\xB3\xB8",
		"\xE2\xBD\xB8" => "\xE7\xBC\xB6",
		"\xE2\xBD\xB9" => "\xE7\xBD\x91",
		"\xE2\xBD\xBA" => "\xE7\xBE\x8A",
		"\xE2\xBD\xBB" => "\xE7\xBE\xBD",
		"\xE2\xBD\xBC" => "\xE8\x80\x81",
		"\xE2\xBD\xBD" => "\xE8\x80\x8C",
		"\xE2\xBD\xBE" => "\xE8\x80\x92",
		"\xE2\xBD\xBF" => "\xE8\x80\xB3",
		"\xE2\xBE\x80" => "\xE8\x81\xBF",
		"\xE2\xBE\x81" => "\xE8\x82\x89",
		"\xE2\xBE\x82" => "\xE8\x87\xA3",
		"\xE2\xBE\x83" => "\xE8\x87\xAA",
		"\xE2\xBE\x84" => "\xE8\x87\xB3",
		"\xE2\xBE\x85" => "\xE8\x87\xBC",
		"\xE2\xBE\x86" => "\xE8\x88\x8C",
		"\xE2\xBE\x87" => "\xE8\x88\x9B",
		"\xE2\xBE\x88" => "\xE8\x88\x9F",
		"\xE2\xBE\x89" => "\xE8\x89\xAE",
		"\xE2\xBE\x8A" => "\xE8\x89\xB2",
		"\xE2\xBE\x8B" => "\xE8\x89\xB8",
		"\xE2\xBE\x8C" => "\xE8\x99\x8D",
		"\xE2\xBE\x8D" => "\xE8\x99\xAB",
		"\xE2\xBE\x8E" => "\xE8\xA1\x80",
		"\xE2\xBE\x8F" => "\xE8\xA1\x8C",
		"\xE2\xBE\x90" => "\xE8\xA1\xA3",
		"\xE2\xBE\x91" => "\xE8\xA5\xBE",
		"\xE2\xBE\x92" => "\xE8\xA6\x8B",
		"\xE2\xBE\x93" => "\xE8\xA7\x92",
		"\xE2\xBE\x94" => "\xE8\xA8\x80",
		"\xE2\xBE\x95" => "\xE8\xB0\xB7",
		"\xE2\xBE\x96" => "\xE8\xB1\x86",
		"\xE2\xBE\x97" => "\xE8\xB1\x95",
		"\xE2\xBE\x98" => "\xE8\xB1\xB8",
		"\xE2\xBE\x99" => "\xE8\xB2\x9D",
		"\xE2\xBE\x9A" => "\xE8\xB5\xA4",
		"\xE2\xBE\x9B" => "\xE8\xB5\xB0",
		"\xE2\xBE\x9C" => "\xE8\xB6\xB3",
		"\xE2\xBE\x9D" => "\xE8\xBA\xAB",
		"\xE2\xBE\x9E" => "\xE8\xBB\x8A",
		"\xE2\xBE\x9F" => "\xE8\xBE\x9B",
		"\xE2\xBE\xA0" => "\xE8\xBE\xB0",
		"\xE2\xBE\xA1" => "\xE8\xBE\xB5",
		"\xE2\xBE\xA2" => "\xE9\x82\x91",
		"\xE2\xBE\xA3" => "\xE9\x85\x89",
		"\xE2\xBE\xA4" => "\xE9\x87\x86",
		"\xE2\xBE\xA5" => "\xE9\x87\x8C",
		"\xE2\xBE\xA6" => "\xE9\x87\x91",
		"\xE2\xBE\xA7" => "\xE9\x95\xB7",
		"\xE2\xBE\xA8" => "\xE9\x96\x80",
		"\xE2\xBE\xA9" => "\xE9\x98\x9C",
		"\xE2\xBE\xAA" => "\xE9\x9A\xB6",
		"\xE2\xBE\xAB" => "\xE9\x9A\xB9",
		"\xE2\xBE\xAC" => "\xE9\x9B\xA8",
		"\xE2\xBE\xAD" => "\xE9\x9D\x91",
		"\xE2\xBE\xAE" => "\xE9\x9D\x9E",
		"\xE2\xBE\xAF" => "\xE9\x9D\xA2",
		"\xE2\xBE\xB0" => "\xE9\x9D\xA9",
		"\xE2\xBE\xB1" => "\xE9\x9F\x8B",
		"\xE2\xBE\xB2" => "\xE9\x9F\xAD",
		"\xE2\xBE\xB3" => "\xE9\x9F\xB3",
		"\xE2\xBE\xB4" => "\xE9\xA0\x81",
		"\xE2\xBE\xB5" => "\xE9\xA2\xA8",
		"\xE2\xBE\xB6" => "\xE9\xA3\x9B",
		"\xE2\xBE\xB7" => "\xE9\xA3\x9F",
		"\xE2\xBE\xB8" => "\xE9\xA6\x96",
		"\xE2\xBE\xB9" => "\xE9\xA6\x99",
		"\xE2\xBE\xBA" => "\xE9\xA6\xAC",
		"\xE2\xBE\xBB" => "\xE9\xAA\xA8",
		"\xE2\xBE\xBC" => "\xE9\xAB\x98",
		"\xE2\xBE\xBD" => "\xE9\xAB\x9F",
		"\xE2\xBE\xBE" => "\xE9\xAC\xA5",
		"\xE2\xBE\xBF" => "\xE9\xAC\xAF",
		"\xE2\xBF\x80" => "\xE9\xAC\xB2",
		"\xE2\xBF\x81" => "\xE9\xAC\xBC",
		"\xE2\xBF\x82" => "\xE9\xAD\x9A",
		"\xE2\xBF\x83" => "\xE9\xB3\xA5",
		"\xE2\xBF\x84" => "\xE9\xB9\xB5",
		"\xE2\xBF\x85" => "\xE9\xB9\xBF",
		"\xE2\xBF\x86" => "\xE9\xBA\xA5",
		"\xE2\xBF\x87" => "\xE9\xBA\xBB",
		"\xE2\xBF\x88" => "\xE9\xBB\x83",
		"\xE2\xBF\x89" => "\xE9\xBB\x8D",
		"\xE2\xBF\x8A" => "\xE9\xBB\x91",
		"\xE2\xBF\x8B" => "\xE9\xBB\xB9",
		"\xE2\xBF\x8C" => "\xE9\xBB\xBD",
		"\xE2\xBF\x8D" => "\xE9\xBC\x8E",
		"\xE2\xBF\x8E" => "\xE9\xBC\x93",
		"\xE2\xBF\x8F" => "\xE9\xBC\xA0",
		"\xE2\xBF\x90" => "\xE9\xBC\xBB",
		"\xE2\xBF\x91" => "\xE9\xBD\x8A",
		"\xE2\xBF\x92" => "\xE9\xBD\x92",
		"\xE2\xBF\x93" => "\xE9\xBE\x8D",
		"\xE2\xBF\x94" => "\xE9\xBE\x9C",
		"\xE2\xBF\x95" => "\xE9\xBE\xA0",
		"\xE3\x80\x80" => "\x20",
		"\xE3\x80\xB6" => "\xE3\x80\x92",
		"\xE3\x80\xB8" => "\xE5\x8D\x81",
		"\xE3\x80\xB9" => "\xE5\x8D\x84",
		"\xE3\x80\xBA" => "\xE5\x8D\x85",
		"\xE3\x82\x9B" => "\x20\xE3\x82\x99",
		"\xE3\x82\x9C" => "\x20\xE3\x82\x9A",
		"\xE3\x82\x9F" => "\xE3\x82\x88\xE3\x82\x8A",
		"\xE3\x83\xBF" => "\xE3\x82\xB3\xE3\x83\x88",
		"\xE3\x84\xB1" => "\xE1\x84\x80",
		"\xE3\x84\xB2" => "\xE1\x84\x81",
		"\xE3\x84\xB3" => "\xE1\x86\xAA",
		"\xE3\x84\xB4" => "\xE1\x84\x82",
		"\xE3\x84\xB5" => "\xE1\x86\xAC",
		"\xE3\x84\xB6" => "\xE1\x86\xAD",
		"\xE3\x84\xB7" => "\xE1\x84\x83",
		"\xE3\x84\xB8" => "\xE1\x84\x84",
		"\xE3\x84\xB9" => "\xE1\x84\x85",
		"\xE3\x84\xBA" => "\xE1\x86\xB0",
		"\xE3\x84\xBB" => "\xE1\x86\xB1",
		"\xE3\x84\xBC" => "\xE1\x86\xB2",
		"\xE3\x84\xBD" => "\xE1\x86\xB3",
		"\xE3\x84\xBE" => "\xE1\x86\xB4",
		"\xE3\x84\xBF" => "\xE1\x86\xB5",
		"\xE3\x85\x80" => "\xE1\x84\x9A",
		"\xE3\x85\x81" => "\xE1\x84\x86",
		"\xE3\x85\x82" => "\xE1\x84\x87",
		"\xE3\x85\x83" => "\xE1\x84\x88",
		"\xE3\x85\x84" => "\xE1\x84\xA1",
		"\xE3\x85\x85" => "\xE1\x84\x89",
		"\xE3\x85\x86" => "\xE1\x84\x8A",
		"\xE3\x85\x87" => "\xE1\x84\x8B",
		"\xE3\x85\x88" => "\xE1\x84\x8C",
		"\xE3\x85\x89" => "\xE1\x84\x8D",
		"\xE3\x85\x8A" => "\xE1\x84\x8E",
		"\xE3\x85\x8B" => "\xE1\x84\x8F",
		"\xE3\x85\x8C" => "\xE1\x84\x90",
		"\xE3\x85\x8D" => "\xE1\x84\x91",
		"\xE3\x85\x8E" => "\xE1\x84\x92",
		"\xE3\x85\x8F" => "\xE1\x85\xA1",
		"\xE3\x85\x90" => "\xE1\x85\xA2",
		"\xE3\x85\x91" => "\xE1\x85\xA3",
		"\xE3\x85\x92" => "\xE1\x85\xA4",
		"\xE3\x85\x93" => "\xE1\x85\xA5",
		"\xE3\x85\x94" => "\xE1\x85\xA6",
		"\xE3\x85\x95" => "\xE1\x85\xA7",
		"\xE3\x85\x96" => "\xE1\x85\xA8",
		"\xE3\x85\x97" => "\xE1\x85\xA9",
		"\xE3\x85\x98" => "\xE1\x85\xAA",
		"\xE3\x85\x99" => "\xE1\x85\xAB",
		"\xE3\x85\x9A" => "\xE1\x85\xAC",
		"\xE3\x85\x9B" => "\xE1\x85\xAD",
		"\xE3\x85\x9C" => "\xE1\x85\xAE",
		"\xE3\x85\x9D" => "\xE1\x85\xAF",
		"\xE3\x85\x9E" => "\xE1\x85\xB0",
		"\xE3\x85\x9F" => "\xE1\x85\xB1",
		"\xE3\x85\xA0" => "\xE1\x85\xB2",
		"\xE3\x85\xA1" => "\xE1\x85\xB3",
		"\xE3\x85\xA2" => "\xE1\x85\xB4",
		"\xE3\x85\xA3" => "\xE1\x85\xB5",
		"\xE3\x85\xA4" => "\xE1\x85\xA0",
		"\xE3\x85\xA5" => "\xE1\x84\x94",
		"\xE3\x85\xA6" => "\xE1\x84\x95",
		"\xE3\x85\xA7" => "\xE1\x87\x87",
		"\xE3\x85\xA8" => "\xE1\x87\x88",
		"\xE3\x85\xA9" => "\xE1\x87\x8C",
		"\xE3\x85\xAA" => "\xE1\x87\x8E",
		"\xE3\x85\xAB" => "\xE1\x87\x93",
		"\xE3\x85\xAC" => "\xE1\x87\x97",
		"\xE3\x85\xAD" => "\xE1\x87\x99",
		"\xE3\x85\xAE" => "\xE1\x84\x9C",
		"\xE3\x85\xAF" => "\xE1\x87\x9D",
		"\xE3\x85\xB0" => "\xE1\x87\x9F",
		"\xE3\x85\xB1" => "\xE1\x84\x9D",
		"\xE3\x85\xB2" => "\xE1\x84\x9E",
		"\xE3\x85\xB3" => "\xE1\x84\xA0",
		"\xE3\x85\xB4" => "\xE1\x84\xA2",
		"\xE3\x85\xB5" => "\xE1\x84\xA3",
		"\xE3\x85\xB6" => "\xE1\x84\xA7",
		"\xE3\x85\xB7" => "\xE1\x84\xA9",
		"\xE3\x85\xB8" => "\xE1\x84\xAB",
		"\xE3\x85\xB9" => "\xE1\x84\xAC",
		"\xE3\x85\xBA" => "\xE1\x84\xAD",
		"\xE3\x85\xBB" => "\xE1\x84\xAE",
		"\xE3\x85\xBC" => "\xE1\x84\xAF",
		"\xE3\x85\xBD" => "\xE1\x84\xB2",
		"\xE3\x85\xBE" => "\xE1\x84\xB6",
		"\xE3\x85\xBF" => "\xE1\x85\x80",
		"\xE3\x86\x80" => "\xE1\x85\x87",
		"\xE3\x86\x81" => "\xE1\x85\x8C",
		"\xE3\x86\x82" => "\xE1\x87\xB1",
		"\xE3\x86\x83" => "\xE1\x87\xB2",
		"\xE3\x86\x84" => "\xE1\x85\x97",
		"\xE3\x86\x85" => "\xE1\x85\x98",
		"\xE3\x86\x86" => "\xE1\x85\x99",
		"\xE3\x86\x87" => "\xE1\x86\x84",
		"\xE3\x86\x88" => "\xE1\x86\x85",
		"\xE3\x86\x89" => "\xE1\x86\x88",
		"\xE3\x86\x8A" => "\xE1\x86\x91",
		"\xE3\x86\x8B" => "\xE1\x86\x92",
		"\xE3\x86\x8C" => "\xE1\x86\x94",
		"\xE3\x86\x8D" => "\xE1\x86\x9E",
		"\xE3\x86\x8E" => "\xE1\x86\xA1",
		"\xE3\x86\x92" => "\xE4\xB8\x80",
		"\xE3\x86\x93" => "\xE4\xBA\x8C",
		"\xE3\x86\x94" => "\xE4\xB8\x89",
		"\xE3\x86\x95" => "\xE5\x9B\x9B",
		"\xE3\x86\x96" => "\xE4\xB8\x8A",
		"\xE3\x86\x97" => "\xE4\xB8\xAD",
		"\xE3\x86\x98" => "\xE4\xB8\x8B",
		"\xE3\x86\x99" => "\xE7\x94\xB2",
		"\xE3\x86\x9A" => "\xE4\xB9\x99",
		"\xE3\x86\x9B" => "\xE4\xB8\x99",
		"\xE3\x86\x9C" => "\xE4\xB8\x81",
		"\xE3\x86\x9D" => "\xE5\xA4\xA9",
		"\xE3\x86\x9E" => "\xE5\x9C\xB0",
		"\xE3\x86\x9F" => "\xE4\xBA\xBA",
		"\xE3\x88\x80" => "\x28\xE1\x84\x80\x29",
		"\xE3\x88\x81" => "\x28\xE1\x84\x82\x29",
		"\xE3\x88\x82" => "\x28\xE1\x84\x83\x29",
		"\xE3\x88\x83" => "\x28\xE1\x84\x85\x29",
		"\xE3\x88\x84" => "\x28\xE1\x84\x86\x29",
		"\xE3\x88\x85" => "\x28\xE1\x84\x87\x29",
		"\xE3\x88\x86" => "\x28\xE1\x84\x89\x29",
		"\xE3\x88\x87" => "\x28\xE1\x84\x8B\x29",
		"\xE3\x88\x88" => "\x28\xE1\x84\x8C\x29",
		"\xE3\x88\x89" => "\x28\xE1\x84\x8E\x29",
		"\xE3\x88\x8A" => "\x28\xE1\x84\x8F\x29",
		"\xE3\x88\x8B" => "\x28\xE1\x84\x90\x29",
		"\xE3\x88\x8C" => "\x28\xE1\x84\x91\x29",
		"\xE3\x88\x8D" => "\x28\xE1\x84\x92\x29",
		"\xE3\x88\x8E" => "\x28\xE1\x84\x80\xE1\x85\xA1\x29",
		"\xE3\x88\x8F" => "\x28\xE1\x84\x82\xE1\x85\xA1\x29",
		"\xE3\x88\x90" => "\x28\xE1\x84\x83\xE1\x85\xA1\x29",
		"\xE3\x88\x91" => "\x28\xE1\x84\x85\xE1\x85\xA1\x29",
		"\xE3\x88\x92" => "\x28\xE1\x84\x86\xE1\x85\xA1\x29",
		"\xE3\x88\x93" => "\x28\xE1\x84\x87\xE1\x85\xA1\x29",
		"\xE3\x88\x94" => "\x28\xE1\x84\x89\xE1\x85\xA1\x29",
		"\xE3\x88\x95" => "\x28\xE1\x84\x8B\xE1\x85\xA1\x29",
		"\xE3\x88\x96" => "\x28\xE1\x84\x8C\xE1\x85\xA1\x29",
		"\xE3\x88\x97" => "\x28\xE1\x84\x8E\xE1\x85\xA1\x29",
		"\xE3\x88\x98" => "\x28\xE1\x84\x8F\xE1\x85\xA1\x29",
		"\xE3\x88\x99" => "\x28\xE1\x84\x90\xE1\x85\xA1\x29",
		"\xE3\x88\x9A" => "\x28\xE1\x84\x91\xE1\x85\xA1\x29",
		"\xE3\x88\x9B" => "\x28\xE1\x84\x92\xE1\x85\xA1\x29",
		"\xE3\x88\x9C" => "\x28\xE1\x84\x8C\xE1\x85\xAE\x29",
		"\xE3\x88\x9D" => "\x28\xE1\x84\x8B\xE1\x85\xA9\xE1\x84\x8C\xE1\x85\xA5\xE1\x86\xAB\x29",
		"\xE3\x88\x9E" => "\x28\xE1\x84\x8B\xE1\x85\xA9\xE1\x84\x92\xE1\x85\xAE\x29",
		"\xE3\x88\xA0" => "\x28\xE4\xB8\x80\x29",
		"\xE3\x88\xA1" => "\x28\xE4\xBA\x8C\x29",
		"\xE3\x88\xA2" => "\x28\xE4\xB8\x89\x29",
		"\xE3\x88\xA3" => "\x28\xE5\x9B\x9B\x29",
		"\xE3\x88\xA4" => "\x28\xE4\xBA\x94\x29",
		"\xE3\x88\xA5" => "\x28\xE5\x85\xAD\x29",
		"\xE3\x88\xA6" => "\x28\xE4\xB8\x83\x29",
		"\xE3\x88\xA7" => "\x28\xE5\x85\xAB\x29",
		"\xE3\x88\xA8" => "\x28\xE4\xB9\x9D\x29",
		"\xE3\x88\xA9" => "\x28\xE5\x8D\x81\x29",
		"\xE3\x88\xAA" => "\x28\xE6\x9C\x88\x29",
		"\xE3\x88\xAB" => "\x28\xE7\x81\xAB\x29",
		"\xE3\x88\xAC" => "\x28\xE6\xB0\xB4\x29",
		"\xE3\x88\xAD" => "\x28\xE6\x9C\xA8\x29",
		"\xE3\x88\xAE" => "\x28\xE9\x87\x91\x29",
		"\xE3\x88\xAF" => "\x28\xE5\x9C\x9F\x29",
		"\xE3\x88\xB0" => "\x28\xE6\x97\xA5\x29",
		"\xE3\x88\xB1" => "\x28\xE6\xA0\xAA\x29",
		"\xE3\x88\xB2" => "\x28\xE6\x9C\x89\x29",
		"\xE3\x88\xB3" => "\x28\xE7\xA4\xBE\x29",
		"\xE3\x88\xB4" => "\x28\xE5\x90\x8D\x29",
		"\xE3\x88\xB5" => "\x28\xE7\x89\xB9\x29",
		"\xE3\x88\xB6" => "\x28\xE8\xB2\xA1\x29",
		"\xE3\x88\xB7" => "\x28\xE7\xA5\x9D\x29",
		"\xE3\x88\xB8" => "\x28\xE5\x8A\xB4\x29",
		"\xE3\x88\xB9" => "\x28\xE4\xBB\xA3\x29",
		"\xE3\x88\xBA" => "\x28\xE5\x91\xBC\x29",
		"\xE3\x88\xBB" => "\x28\xE5\xAD\xA6\x29",
		"\xE3\x88\xBC" => "\x28\xE7\x9B\xA3\x29",
		"\xE3\x88\xBD" => "\x28\xE4\xBC\x81\x29",
		"\xE3\x88\xBE" => "\x28\xE8\xB3\x87\x29",
		"\xE3\x88\xBF" => "\x28\xE5\x8D\x94\x29",
		"\xE3\x89\x80" => "\x28\xE7\xA5\xAD\x29",
		"\xE3\x89\x81" => "\x28\xE4\xBC\x91\x29",
		"\xE3\x89\x82" => "\x28\xE8\x87\xAA\x29",
		"\xE3\x89\x83" => "\x28\xE8\x87\xB3\x29",
		"\xE3\x89\x84" => "\xE5\x95\x8F",
		"\xE3\x89\x85" => "\xE5\xB9\xBC",
		"\xE3\x89\x86" => "\xE6\x96\x87",
		"\xE3\x89\x87" => "\xE7\xAE\x8F",
		"\xE3\x89\x90" => "\x50\x54\x45",
		"\xE3\x89\x91" => "\x32\x31",
		"\xE3\x89\x92" => "\x32\x32",
		"\xE3\x89\x93" => "\x32\x33",
		"\xE3\x89\x94" => "\x32\x34",
		"\xE3\x89\x95" => "\x32\x35",
		"\xE3\x89\x96" => "\x32\x36",
		"\xE3\x89\x97" => "\x32\x37",
		"\xE3\x89\x98" => "\x32\x38",
		"\xE3\x89\x99" => "\x32\x39",
		"\xE3\x89\x9A" => "\x33\x30",
		"\xE3\x89\x9B" => "\x33\x31",
		"\xE3\x89\x9C" => "\x33\x32",
		"\xE3\x89\x9D" => "\x33\x33",
		"\xE3\x89\x9E" => "\x33\x34",
		"\xE3\x89\x9F" => "\x33\x35",
		"\xE3\x89\xA0" => "\xE1\x84\x80",
		"\xE3\x89\xA1" => "\xE1\x84\x82",
		"\xE3\x89\xA2" => "\xE1\x84\x83",
		"\xE3\x89\xA3" => "\xE1\x84\x85",
		"\xE3\x89\xA4" => "\xE1\x84\x86",
		"\xE3\x89\xA5" => "\xE1\x84\x87",
		"\xE3\x89\xA6" => "\xE1\x84\x89",
		"\xE3\x89\xA7" => "\xE1\x84\x8B",
		"\xE3\x89\xA8" => "\xE1\x84\x8C",
		"\xE3\x89\xA9" => "\xE1\x84\x8E",
		"\xE3\x89\xAA" => "\xE1\x84\x8F",
		"\xE3\x89\xAB" => "\xE1\x84\x90",
		"\xE3\x89\xAC" => "\xE1\x84\x91",
		"\xE3\x89\xAD" => "\xE1\x84\x92",
		"\xE3\x89\xAE" => "\xE1\x84\x80\xE1\x85\xA1",
		"\xE3\x89\xAF" => "\xE1\x84\x82\xE1\x85\xA1",
		"\xE3\x89\xB0" => "\xE1\x84\x83\xE1\x85\xA1",
		"\xE3\x89\xB1" => "\xE1\x84\x85\xE1\x85\xA1",
		"\xE3\x89\xB2" => "\xE1\x84\x86\xE1\x85\xA1",
		"\xE3\x89\xB3" => "\xE1\x84\x87\xE1\x85\xA1",
		"\xE3\x89\xB4" => "\xE1\x84\x89\xE1\x85\xA1",
		"\xE3\x89\xB5" => "\xE1\x84\x8B\xE1\x85\xA1",
		"\xE3\x89\xB6" => "\xE1\x84\x8C\xE1\x85\xA1",
		"\xE3\x89\xB7" => "\xE1\x84\x8E\xE1\x85\xA1",
		"\xE3\x89\xB8" => "\xE1\x84\x8F\xE1\x85\xA1",
		"\xE3\x89\xB9" => "\xE1\x84\x90\xE1\x85\xA1",
		"\xE3\x89\xBA" => "\xE1\x84\x91\xE1\x85\xA1",
		"\xE3\x89\xBB" => "\xE1\x84\x92\xE1\x85\xA1",
		"\xE3\x89\xBC" => "\xE1\x84\x8E\xE1\x85\xA1\xE1\x86\xB7\xE1\x84\x80\xE1\x85\xA9",
		"\xE3\x89\xBD" => "\xE1\x84\x8C\xE1\x85\xAE\xE1\x84\x8B\xE1\x85\xB4",
		"\xE3\x89\xBE" => "\xE1\x84\x8B\xE1\x85\xAE",
		"\xE3\x8A\x80" => "\xE4\xB8\x80",
		"\xE3\x8A\x81" => "\xE4\xBA\x8C",
		"\xE3\x8A\x82" => "\xE4\xB8\x89",
		"\xE3\x8A\x83" => "\xE5\x9B\x9B",
		"\xE3\x8A\x84" => "\xE4\xBA\x94",
		"\xE3\x8A\x85" => "\xE5\x85\xAD",
		"\xE3\x8A\x86" => "\xE4\xB8\x83",
		"\xE3\x8A\x87" => "\xE5\x85\xAB",
		"\xE3\x8A\x88" => "\xE4\xB9\x9D",
		"\xE3\x8A\x89" => "\xE5\x8D\x81",
		"\xE3\x8A\x8A" => "\xE6\x9C\x88",
		"\xE3\x8A\x8B" => "\xE7\x81\xAB",
		"\xE3\x8A\x8C" => "\xE6\xB0\xB4",
		"\xE3\x8A\x8D" => "\xE6\x9C\xA8",
		"\xE3\x8A\x8E" => "\xE9\x87\x91",
		"\xE3\x8A\x8F" => "\xE5\x9C\x9F",
		"\xE3\x8A\x90" => "\xE6\x97\xA5",
		"\xE3\x8A\x91" => "\xE6\xA0\xAA",
		"\xE3\x8A\x92" => "\xE6\x9C\x89",
		"\xE3\x8A\x93" => "\xE7\xA4\xBE",
		"\xE3\x8A\x94" => "\xE5\x90\x8D",
		"\xE3\x8A\x95" => "\xE7\x89\xB9",
		"\xE3\x8A\x96" => "\xE8\xB2\xA1",
		"\xE3\x8A\x97" => "\xE7\xA5\x9D",
		"\xE3\x8A\x98" => "\xE5\x8A\xB4",
		"\xE3\x8A\x99" => "\xE7\xA7\x98",
		"\xE3\x8A\x9A" => "\xE7\x94\xB7",
		"\xE3\x8A\x9B" => "\xE5\xA5\xB3",
		"\xE3\x8A\x9C" => "\xE9\x81\xA9",
		"\xE3\x8A\x9D" => "\xE5\x84\xAA",
		"\xE3\x8A\x9E" => "\xE5\x8D\xB0",
		"\xE3\x8A\x9F" => "\xE6\xB3\xA8",
		"\xE3\x8A\xA0" => "\xE9\xA0\x85",
		"\xE3\x8A\xA1" => "\xE4\xBC\x91",
		"\xE3\x8A\xA2" => "\xE5\x86\x99",
		"\xE3\x8A\xA3" => "\xE6\xAD\xA3",
		"\xE3\x8A\xA4" => "\xE4\xB8\x8A",
		"\xE3\x8A\xA5" => "\xE4\xB8\xAD",
		"\xE3\x8A\xA6" => "\xE4\xB8\x8B",
		"\xE3\x8A\xA7" => "\xE5\xB7\xA6",
		"\xE3\x8A\xA8" => "\xE5\x8F\xB3",
		"\xE3\x8A\xA9" => "\xE5\x8C\xBB",
		"\xE3\x8A\xAA" => "\xE5\xAE\x97",
		"\xE3\x8A\xAB" => "\xE5\xAD\xA6",
		"\xE3\x8A\xAC" => "\xE7\x9B\xA3",
		"\xE3\x8A\xAD" => "\xE4\xBC\x81",
		"\xE3\x8A\xAE" => "\xE8\xB3\x87",
		"\xE3\x8A\xAF" => "\xE5\x8D\x94",
		"\xE3\x8A\xB0" => "\xE5\xA4\x9C",
		"\xE3\x8A\xB1" => "\x33\x36",
		"\xE3\x8A\xB2" => "\x33\x37",
		"\xE3\x8A\xB3" => "\x33\x38",
		"\xE3\x8A\xB4" => "\x33\x39",
		"\xE3\x8A\xB5" => "\x34\x30",
		"\xE3\x8A\xB6" => "\x34\x31",
		"\xE3\x8A\xB7" => "\x34\x32",
		"\xE3\x8A\xB8" => "\x34\x33",
		"\xE3\x8A\xB9" => "\x34\x34",
		"\xE3\x8A\xBA" => "\x34\x35",
		"\xE3\x8A\xBB" => "\x34\x36",
		"\xE3\x8A\xBC" => "\x34\x37",
		"\xE3\x8A\xBD" => "\x34\x38",
		"\xE3\x8A\xBE" => "\x34\x39",
		"\xE3\x8A\xBF" => "\x35\x30",
		"\xE3\x8B\x80" => "\x31\xE6\x9C\x88",
		"\xE3\x8B\x81" => "\x32\xE6\x9C\x88",
		"\xE3\x8B\x82" => "\x33\xE6\x9C\x88",
		"\xE3\x8B\x83" => "\x34\xE6\x9C\x88",
		"\xE3\x8B\x84" => "\x35\xE6\x9C\x88",
		"\xE3\x8B\x85" => "\x36\xE6\x9C\x88",
		"\xE3\x8B\x86" => "\x37\xE6\x9C\x88",
		"\xE3\x8B\x87" => "\x38\xE6\x9C\x88",
		"\xE3\x8B\x88" => "\x39\xE6\x9C\x88",
		"\xE3\x8B\x89" => "\x31\x30\xE6\x9C\x88",
		"\xE3\x8B\x8A" => "\x31\x31\xE6\x9C\x88",
		"\xE3\x8B\x8B" => "\x31\x32\xE6\x9C\x88",
		"\xE3\x8B\x8C" => "\x48\x67",
		"\xE3\x8B\x8D" => "\x65\x72\x67",
		"\xE3\x8B\x8E" => "\x65\x56",
		"\xE3\x8B\x8F" => "\x4C\x54\x44",
		"\xE3\x8B\x90" => "\xE3\x82\xA2",
		"\xE3\x8B\x91" => "\xE3\x82\xA4",
		"\xE3\x8B\x92" => "\xE3\x82\xA6",
		"\xE3\x8B\x93" => "\xE3\x82\xA8",
		"\xE3\x8B\x94" => "\xE3\x82\xAA",
		"\xE3\x8B\x95" => "\xE3\x82\xAB",
		"\xE3\x8B\x96" => "\xE3\x82\xAD",
		"\xE3\x8B\x97" => "\xE3\x82\xAF",
		"\xE3\x8B\x98" => "\xE3\x82\xB1",
		"\xE3\x8B\x99" => "\xE3\x82\xB3",
		"\xE3\x8B\x9A" => "\xE3\x82\xB5",
		"\xE3\x8B\x9B" => "\xE3\x82\xB7",
		"\xE3\x8B\x9C" => "\xE3\x82\xB9",
		"\xE3\x8B\x9D" => "\xE3\x82\xBB",
		"\xE3\x8B\x9E" => "\xE3\x82\xBD",
		"\xE3\x8B\x9F" => "\xE3\x82\xBF",
		"\xE3\x8B\xA0" => "\xE3\x83\x81",
		"\xE3\x8B\xA1" => "\xE3\x83\x84",
		"\xE3\x8B\xA2" => "\xE3\x83\x86",
		"\xE3\x8B\xA3" => "\xE3\x83\x88",
		"\xE3\x8B\xA4" => "\xE3\x83\x8A",
		"\xE3\x8B\xA5" => "\xE3\x83\x8B",
		"\xE3\x8B\xA6" => "\xE3\x83\x8C",
		"\xE3\x8B\xA7" => "\xE3\x83\x8D",
		"\xE3\x8B\xA8" => "\xE3\x83\x8E",
		"\xE3\x8B\xA9" => "\xE3\x83\x8F",
		"\xE3\x8B\xAA" => "\xE3\x83\x92",
		"\xE3\x8B\xAB" => "\xE3\x83\x95",
		"\xE3\x8B\xAC" => "\xE3\x83\x98",
		"\xE3\x8B\xAD" => "\xE3\x83\x9B",
		"\xE3\x8B\xAE" => "\xE3\x83\x9E",
		"\xE3\x8B\xAF" => "\xE3\x83\x9F",
		"\xE3\x8B\xB0" => "\xE3\x83\xA0",
		"\xE3\x8B\xB1" => "\xE3\x83\xA1",
		"\xE3\x8B\xB2" => "\xE3\x83\xA2",
		"\xE3\x8B\xB3" => "\xE3\x83\xA4",
		"\xE3\x8B\xB4" => "\xE3\x83\xA6",
		"\xE3\x8B\xB5" => "\xE3\x83\xA8",
		"\xE3\x8B\xB6" => "\xE3\x83\xA9",
		"\xE3\x8B\xB7" => "\xE3\x83\xAA",
		"\xE3\x8B\xB8" => "\xE3\x83\xAB",
		"\xE3\x8B\xB9" => "\xE3\x83\xAC",
		"\xE3\x8B\xBA" => "\xE3\x83\xAD",
		"\xE3\x8B\xBB" => "\xE3\x83\xAF",
		"\xE3\x8B\xBC" => "\xE3\x83\xB0",
		"\xE3\x8B\xBD" => "\xE3\x83\xB1",
		"\xE3\x8B\xBE" => "\xE3\x83\xB2",
		"\xE3\x8B\xBF" => "\xE4\xBB\xA4\xE5\x92\x8C",
		"\xE3\x8C\x80" => "\xE3\x82\xA2\xE3\x83\x8F\xE3\x82\x9A\xE3\x83\xBC\xE3\x83\x88",
		"\xE3\x8C\x81" => "\xE3\x82\xA2\xE3\x83\xAB\xE3\x83\x95\xE3\x82\xA1",
		"\xE3\x8C\x82" => "\xE3\x82\xA2\xE3\x83\xB3\xE3\x83\x98\xE3\x82\x9A\xE3\x82\xA2",
		"\xE3\x8C\x83" => "\xE3\x82\xA2\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8C\x84" => "\xE3\x82\xA4\xE3\x83\x8B\xE3\x83\xB3\xE3\x82\xAF\xE3\x82\x99",
		"\xE3\x8C\x85" => "\xE3\x82\xA4\xE3\x83\xB3\xE3\x83\x81",
		"\xE3\x8C\x86" => "\xE3\x82\xA6\xE3\x82\xA9\xE3\x83\xB3",
		"\xE3\x8C\x87" => "\xE3\x82\xA8\xE3\x82\xB9\xE3\x82\xAF\xE3\x83\xBC\xE3\x83\x88\xE3\x82\x99",
		"\xE3\x8C\x88" => "\xE3\x82\xA8\xE3\x83\xBC\xE3\x82\xAB\xE3\x83\xBC",
		"\xE3\x8C\x89" => "\xE3\x82\xAA\xE3\x83\xB3\xE3\x82\xB9",
		"\xE3\x8C\x8A" => "\xE3\x82\xAA\xE3\x83\xBC\xE3\x83\xA0",
		"\xE3\x8C\x8B" => "\xE3\x82\xAB\xE3\x82\xA4\xE3\x83\xAA",
		"\xE3\x8C\x8C" => "\xE3\x82\xAB\xE3\x83\xA9\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8C\x8D" => "\xE3\x82\xAB\xE3\x83\xAD\xE3\x83\xAA\xE3\x83\xBC",
		"\xE3\x8C\x8E" => "\xE3\x82\xAB\xE3\x82\x99\xE3\x83\xAD\xE3\x83\xB3",
		"\xE3\x8C\x8F" => "\xE3\x82\xAB\xE3\x82\x99\xE3\x83\xB3\xE3\x83\x9E",
		"\xE3\x8C\x90" => "\xE3\x82\xAD\xE3\x82\x99\xE3\x82\xAB\xE3\x82\x99",
		"\xE3\x8C\x91" => "\xE3\x82\xAD\xE3\x82\x99\xE3\x83\x8B\xE3\x83\xBC",
		"\xE3\x8C\x92" => "\xE3\x82\xAD\xE3\x83\xA5\xE3\x83\xAA\xE3\x83\xBC",
		"\xE3\x8C\x93" => "\xE3\x82\xAD\xE3\x82\x99\xE3\x83\xAB\xE3\x82\xBF\xE3\x82\x99\xE3\x83\xBC",
		"\xE3\x8C\x94" => "\xE3\x82\xAD\xE3\x83\xAD",
		"\xE3\x8C\x95" => "\xE3\x82\xAD\xE3\x83\xAD\xE3\x82\xAF\xE3\x82\x99\xE3\x83\xA9\xE3\x83\xA0",
		"\xE3\x8C\x96" => "\xE3\x82\xAD\xE3\x83\xAD\xE3\x83\xA1\xE3\x83\xBC\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8C\x97" => "\xE3\x82\xAD\xE3\x83\xAD\xE3\x83\xAF\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8C\x98" => "\xE3\x82\xAF\xE3\x82\x99\xE3\x83\xA9\xE3\x83\xA0",
		"\xE3\x8C\x99" => "\xE3\x82\xAF\xE3\x82\x99\xE3\x83\xA9\xE3\x83\xA0\xE3\x83\x88\xE3\x83\xB3",
		"\xE3\x8C\x9A" => "\xE3\x82\xAF\xE3\x83\xAB\xE3\x82\xBB\xE3\x82\x99\xE3\x82\xA4\xE3\x83\xAD",
		"\xE3\x8C\x9B" => "\xE3\x82\xAF\xE3\x83\xAD\xE3\x83\xBC\xE3\x83\x8D",
		"\xE3\x8C\x9C" => "\xE3\x82\xB1\xE3\x83\xBC\xE3\x82\xB9",
		"\xE3\x8C\x9D" => "\xE3\x82\xB3\xE3\x83\xAB\xE3\x83\x8A",
		"\xE3\x8C\x9E" => "\xE3\x82\xB3\xE3\x83\xBC\xE3\x83\x9B\xE3\x82\x9A",
		"\xE3\x8C\x9F" => "\xE3\x82\xB5\xE3\x82\xA4\xE3\x82\xAF\xE3\x83\xAB",
		"\xE3\x8C\xA0" => "\xE3\x82\xB5\xE3\x83\xB3\xE3\x83\x81\xE3\x83\xBC\xE3\x83\xA0",
		"\xE3\x8C\xA1" => "\xE3\x82\xB7\xE3\x83\xAA\xE3\x83\xB3\xE3\x82\xAF\xE3\x82\x99",
		"\xE3\x8C\xA2" => "\xE3\x82\xBB\xE3\x83\xB3\xE3\x83\x81",
		"\xE3\x8C\xA3" => "\xE3\x82\xBB\xE3\x83\xB3\xE3\x83\x88",
		"\xE3\x8C\xA4" => "\xE3\x82\xBF\xE3\x82\x99\xE3\x83\xBC\xE3\x82\xB9",
		"\xE3\x8C\xA5" => "\xE3\x83\x86\xE3\x82\x99\xE3\x82\xB7",
		"\xE3\x8C\xA6" => "\xE3\x83\x88\xE3\x82\x99\xE3\x83\xAB",
		"\xE3\x8C\xA7" => "\xE3\x83\x88\xE3\x83\xB3",
		"\xE3\x8C\xA8" => "\xE3\x83\x8A\xE3\x83\x8E",
		"\xE3\x8C\xA9" => "\xE3\x83\x8E\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8C\xAA" => "\xE3\x83\x8F\xE3\x82\xA4\xE3\x83\x84",
		"\xE3\x8C\xAB" => "\xE3\x83\x8F\xE3\x82\x9A\xE3\x83\xBC\xE3\x82\xBB\xE3\x83\xB3\xE3\x83\x88",
		"\xE3\x8C\xAC" => "\xE3\x83\x8F\xE3\x82\x9A\xE3\x83\xBC\xE3\x83\x84",
		"\xE3\x8C\xAD" => "\xE3\x83\x8F\xE3\x82\x99\xE3\x83\xBC\xE3\x83\xAC\xE3\x83\xAB",
		"\xE3\x8C\xAE" => "\xE3\x83\x92\xE3\x82\x9A\xE3\x82\xA2\xE3\x82\xB9\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8C\xAF" => "\xE3\x83\x92\xE3\x82\x9A\xE3\x82\xAF\xE3\x83\xAB",
		"\xE3\x8C\xB0" => "\xE3\x83\x92\xE3\x82\x9A\xE3\x82\xB3",
		"\xE3\x8C\xB1" => "\xE3\x83\x92\xE3\x82\x99\xE3\x83\xAB",
		"\xE3\x8C\xB2" => "\xE3\x83\x95\xE3\x82\xA1\xE3\x83\xA9\xE3\x83\x83\xE3\x83\x88\xE3\x82\x99",
		"\xE3\x8C\xB3" => "\xE3\x83\x95\xE3\x82\xA3\xE3\x83\xBC\xE3\x83\x88",
		"\xE3\x8C\xB4" => "\xE3\x83\x95\xE3\x82\x99\xE3\x83\x83\xE3\x82\xB7\xE3\x82\xA7\xE3\x83\xAB",
		"\xE3\x8C\xB5" => "\xE3\x83\x95\xE3\x83\xA9\xE3\x83\xB3",
		"\xE3\x8C\xB6" => "\xE3\x83\x98\xE3\x82\xAF\xE3\x82\xBF\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8C\xB7" => "\xE3\x83\x98\xE3\x82\x9A\xE3\x82\xBD",
		"\xE3\x8C\xB8" => "\xE3\x83\x98\xE3\x82\x9A\xE3\x83\x8B\xE3\x83\x92",
		"\xE3\x8C\xB9" => "\xE3\x83\x98\xE3\x83\xAB\xE3\x83\x84",
		"\xE3\x8C\xBA" => "\xE3\x83\x98\xE3\x82\x9A\xE3\x83\xB3\xE3\x82\xB9",
		"\xE3\x8C\xBB" => "\xE3\x83\x98\xE3\x82\x9A\xE3\x83\xBC\xE3\x82\xB7\xE3\x82\x99",
		"\xE3\x8C\xBC" => "\xE3\x83\x98\xE3\x82\x99\xE3\x83\xBC\xE3\x82\xBF",
		"\xE3\x8C\xBD" => "\xE3\x83\x9B\xE3\x82\x9A\xE3\x82\xA4\xE3\x83\xB3\xE3\x83\x88",
		"\xE3\x8C\xBE" => "\xE3\x83\x9B\xE3\x82\x99\xE3\x83\xAB\xE3\x83\x88",
		"\xE3\x8C\xBF" => "\xE3\x83\x9B\xE3\x83\xB3",
		"\xE3\x8D\x80" => "\xE3\x83\x9B\xE3\x82\x9A\xE3\x83\xB3\xE3\x83\x88\xE3\x82\x99",
		"\xE3\x8D\x81" => "\xE3\x83\x9B\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8D\x82" => "\xE3\x83\x9B\xE3\x83\xBC\xE3\x83\xB3",
		"\xE3\x8D\x83" => "\xE3\x83\x9E\xE3\x82\xA4\xE3\x82\xAF\xE3\x83\xAD",
		"\xE3\x8D\x84" => "\xE3\x83\x9E\xE3\x82\xA4\xE3\x83\xAB",
		"\xE3\x8D\x85" => "\xE3\x83\x9E\xE3\x83\x83\xE3\x83\x8F",
		"\xE3\x8D\x86" => "\xE3\x83\x9E\xE3\x83\xAB\xE3\x82\xAF",
		"\xE3\x8D\x87" => "\xE3\x83\x9E\xE3\x83\xB3\xE3\x82\xB7\xE3\x83\xA7\xE3\x83\xB3",
		"\xE3\x8D\x88" => "\xE3\x83\x9F\xE3\x82\xAF\xE3\x83\xAD\xE3\x83\xB3",
		"\xE3\x8D\x89" => "\xE3\x83\x9F\xE3\x83\xAA",
		"\xE3\x8D\x8A" => "\xE3\x83\x9F\xE3\x83\xAA\xE3\x83\x8F\xE3\x82\x99\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8D\x8B" => "\xE3\x83\xA1\xE3\x82\xAB\xE3\x82\x99",
		"\xE3\x8D\x8C" => "\xE3\x83\xA1\xE3\x82\xAB\xE3\x82\x99\xE3\x83\x88\xE3\x83\xB3",
		"\xE3\x8D\x8D" => "\xE3\x83\xA1\xE3\x83\xBC\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8D\x8E" => "\xE3\x83\xA4\xE3\x83\xBC\xE3\x83\x88\xE3\x82\x99",
		"\xE3\x8D\x8F" => "\xE3\x83\xA4\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8D\x90" => "\xE3\x83\xA6\xE3\x82\xA2\xE3\x83\xB3",
		"\xE3\x8D\x91" => "\xE3\x83\xAA\xE3\x83\x83\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8D\x92" => "\xE3\x83\xAA\xE3\x83\xA9",
		"\xE3\x8D\x93" => "\xE3\x83\xAB\xE3\x83\x92\xE3\x82\x9A\xE3\x83\xBC",
		"\xE3\x8D\x94" => "\xE3\x83\xAB\xE3\x83\xBC\xE3\x83\x95\xE3\x82\x99\xE3\x83\xAB",
		"\xE3\x8D\x95" => "\xE3\x83\xAC\xE3\x83\xA0",
		"\xE3\x8D\x96" => "\xE3\x83\xAC\xE3\x83\xB3\xE3\x83\x88\xE3\x82\xB1\xE3\x82\x99\xE3\x83\xB3",
		"\xE3\x8D\x97" => "\xE3\x83\xAF\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8D\x98" => "\x30\xE7\x82\xB9",
		"\xE3\x8D\x99" => "\x31\xE7\x82\xB9",
		"\xE3\x8D\x9A" => "\x32\xE7\x82\xB9",
		"\xE3\x8D\x9B" => "\x33\xE7\x82\xB9",
		"\xE3\x8D\x9C" => "\x34\xE7\x82\xB9",
		"\xE3\x8D\x9D" => "\x35\xE7\x82\xB9",
		"\xE3\x8D\x9E" => "\x36\xE7\x82\xB9",
		"\xE3\x8D\x9F" => "\x37\xE7\x82\xB9",
		"\xE3\x8D\xA0" => "\x38\xE7\x82\xB9",
		"\xE3\x8D\xA1" => "\x39\xE7\x82\xB9",
		"\xE3\x8D\xA2" => "\x31\x30\xE7\x82\xB9",
		"\xE3\x8D\xA3" => "\x31\x31\xE7\x82\xB9",
		"\xE3\x8D\xA4" => "\x31\x32\xE7\x82\xB9",
		"\xE3\x8D\xA5" => "\x31\x33\xE7\x82\xB9",
		"\xE3\x8D\xA6" => "\x31\x34\xE7\x82\xB9",
		"\xE3\x8D\xA7" => "\x31\x35\xE7\x82\xB9",
		"\xE3\x8D\xA8" => "\x31\x36\xE7\x82\xB9",
		"\xE3\x8D\xA9" => "\x31\x37\xE7\x82\xB9",
		"\xE3\x8D\xAA" => "\x31\x38\xE7\x82\xB9",
		"\xE3\x8D\xAB" => "\x31\x39\xE7\x82\xB9",
		"\xE3\x8D\xAC" => "\x32\x30\xE7\x82\xB9",
		"\xE3\x8D\xAD" => "\x32\x31\xE7\x82\xB9",
		"\xE3\x8D\xAE" => "\x32\x32\xE7\x82\xB9",
		"\xE3\x8D\xAF" => "\x32\x33\xE7\x82\xB9",
		"\xE3\x8D\xB0" => "\x32\x34\xE7\x82\xB9",
		"\xE3\x8D\xB1" => "\x68\x50\x61",
		"\xE3\x8D\xB2" => "\x64\x61",
		"\xE3\x8D\xB3" => "\x41\x55",
		"\xE3\x8D\xB4" => "\x62\x61\x72",
		"\xE3\x8D\xB5" => "\x6F\x56",
		"\xE3\x8D\xB6" => "\x70\x63",
		"\xE3\x8D\xB7" => "\x64\x6D",
		"\xE3\x8D\xB8" => "\x64\x6D\x32",
		"\xE3\x8D\xB9" => "\x64\x6D\x33",
		"\xE3\x8D\xBA" => "\x49\x55",
		"\xE3\x8D\xBB" => "\xE5\xB9\xB3\xE6\x88\x90",
		"\xE3\x8D\xBC" => "\xE6\x98\xAD\xE5\x92\x8C",
		"\xE3\x8D\xBD" => "\xE5\xA4\xA7\xE6\xAD\xA3",
		"\xE3\x8D\xBE" => "\xE6\x98\x8E\xE6\xB2\xBB",
		"\xE3\x8D\xBF" => "\xE6\xA0\xAA\xE5\xBC\x8F\xE4\xBC\x9A\xE7\xA4\xBE",
		"\xE3\x8E\x80" => "\x70\x41",
		"\xE3\x8E\x81" => "\x6E\x41",
		"\xE3\x8E\x82" => "\xCE\xBC\x41",
		"\xE3\x8E\x83" => "\x6D\x41",
		"\xE3\x8E\x84" => "\x6B\x41",
		"\xE3\x8E\x85" => "\x4B\x42",
		"\xE3\x8E\x86" => "\x4D\x42",
		"\xE3\x8E\x87" => "\x47\x42",
		"\xE3\x8E\x88" => "\x63\x61\x6C",
		"\xE3\x8E\x89" => "\x6B\x63\x61\x6C",
		"\xE3\x8E\x8A" => "\x70\x46",
		"\xE3\x8E\x8B" => "\x6E\x46",
		"\xE3\x8E\x8C" => "\xCE\xBC\x46",
		"\xE3\x8E\x8D" => "\xCE\xBC\x67",
		"\xE3\x8E\x8E" => "\x6D\x67",
		"\xE3\x8E\x8F" => "\x6B\x67",
		"\xE3\x8E\x90" => "\x48\x7A",
		"\xE3\x8E\x91" => "\x6B\x48\x7A",
		"\xE3\x8E\x92" => "\x4D\x48\x7A",
		"\xE3\x8E\x93" => "\x47\x48\x7A",
		"\xE3\x8E\x94" => "\x54\x48\x7A",
		"\xE3\x8E\x95" => "\xCE\xBC\x6C",
		"\xE3\x8E\x96" => "\x6D\x6C",
		"\xE3\x8E\x97" => "\x64\x6C",
		"\xE3\x8E\x98" => "\x6B\x6C",
		"\xE3\x8E\x99" => "\x66\x6D",
		"\xE3\x8E\x9A" => "\x6E\x6D",
		"\xE3\x8E\x9B" => "\xCE\xBC\x6D",
		"\xE3\x8E\x9C" => "\x6D\x6D",
		"\xE3\x8E\x9D" => "\x63\x6D",
		"\xE3\x8E\x9E" => "\x6B\x6D",
		"\xE3\x8E\x9F" => "\x6D\x6D\x32",
		"\xE3\x8E\xA0" => "\x63\x6D\x32",
		"\xE3\x8E\xA1" => "\x6D\x32",
		"\xE3\x8E\xA2" => "\x6B\x6D\x32",
		"\xE3\x8E\xA3" => "\x6D\x6D\x33",
		"\xE3\x8E\xA4" => "\x63\x6D\x33",
		"\xE3\x8E\xA5" => "\x6D\x33",
		"\xE3\x8E\xA6" => "\x6B\x6D\x33",
		"\xE3\x8E\xA7" => "\x6D\xE2\x88\x95\x73",
		"\xE3\x8E\xA8" => "\x6D\xE2\x88\x95\x73\x32",
		"\xE3\x8E\xA9" => "\x50\x61",
		"\xE3\x8E\xAA" => "\x6B\x50\x61",
		"\xE3\x8E\xAB" => "\x4D\x50\x61",
		"\xE3\x8E\xAC" => "\x47\x50\x61",
		"\xE3\x8E\xAD" => "\x72\x61\x64",
		"\xE3\x8E\xAE" => "\x72\x61\x64\xE2\x88\x95\x73",
		"\xE3\x8E\xAF" => "\x72\x61\x64\xE2\x88\x95\x73\x32",
		"\xE3\x8E\xB0" => "\x70\x73",
		"\xE3\x8E\xB1" => "\x6E\x73",
		"\xE3\x8E\xB2" => "\xCE\xBC\x73",
		"\xE3\x8E\xB3" => "\x6D\x73",
		"\xE3\x8E\xB4" => "\x70\x56",
		"\xE3\x8E\xB5" => "\x6E\x56",
		"\xE3\x8E\xB6" => "\xCE\xBC\x56",
		"\xE3\x8E\xB7" => "\x6D\x56",
		"\xE3\x8E\xB8" => "\x6B\x56",
		"\xE3\x8E\xB9" => "\x4D\x56",
		"\xE3\x8E\xBA" => "\x70\x57",
		"\xE3\x8E\xBB" => "\x6E\x57",
		"\xE3\x8E\xBC" => "\xCE\xBC\x57",
		"\xE3\x8E\xBD" => "\x6D\x57",
		"\xE3\x8E\xBE" => "\x6B\x57",
		"\xE3\x8E\xBF" => "\x4D\x57",
		"\xE3\x8F\x80" => "\x6B\xCE\xA9",
		"\xE3\x8F\x81" => "\x4D\xCE\xA9",
		"\xE3\x8F\x82" => "\x61\x2E\x6D\x2E",
		"\xE3\x8F\x83" => "\x42\x71",
		"\xE3\x8F\x84" => "\x63\x63",
		"\xE3\x8F\x85" => "\x63\x64",
		"\xE3\x8F\x86" => "\x43\xE2\x88\x95\x6B\x67",
		"\xE3\x8F\x87" => "\x43\x6F\x2E",
		"\xE3\x8F\x88" => "\x64\x42",
		"\xE3\x8F\x89" => "\x47\x79",
		"\xE3\x8F\x8A" => "\x68\x61",
		"\xE3\x8F\x8B" => "\x48\x50",
		"\xE3\x8F\x8C" => "\x69\x6E",
		"\xE3\x8F\x8D" => "\x4B\x4B",
		"\xE3\x8F\x8E" => "\x4B\x4D",
		"\xE3\x8F\x8F" => "\x6B\x74",
		"\xE3\x8F\x90" => "\x6C\x6D",
		"\xE3\x8F\x91" => "\x6C\x6E",
		"\xE3\x8F\x92" => "\x6C\x6F\x67",
		"\xE3\x8F\x93" => "\x6C\x78",
		"\xE3\x8F\x94" => "\x6D\x62",
		"\xE3\x8F\x95" => "\x6D\x69\x6C",
		"\xE3\x8F\x96" => "\x6D\x6F\x6C",
		"\xE3\x8F\x97" => "\x50\x48",
		"\xE3\x8F\x98" => "\x70\x2E\x6D\x2E",
		"\xE3\x8F\x99" => "\x50\x50\x4D",
		"\xE3\x8F\x9A" => "\x50\x52",
		"\xE3\x8F\x9B" => "\x73\x72",
		"\xE3\x8F\x9C" => "\x53\x76",
		"\xE3\x8F\x9D" => "\x57\x62",
		"\xE3\x8F\x9E" => "\x56\xE2\x88\x95\x6D",
		"\xE3\x8F\x9F" => "\x41\xE2\x88\x95\x6D",
		"\xE3\x8F\xA0" => "\x31\xE6\x97\xA5",
		"\xE3\x8F\xA1" => "\x32\xE6\x97\xA5",
		"\xE3\x8F\xA2" => "\x33\xE6\x97\xA5",
		"\xE3\x8F\xA3" => "\x34\xE6\x97\xA5",
		"\xE3\x8F\xA4" => "\x35\xE6\x97\xA5",
		"\xE3\x8F\xA5" => "\x36\xE6\x97\xA5",
		"\xE3\x8F\xA6" => "\x37\xE6\x97\xA5",
		"\xE3\x8F\xA7" => "\x38\xE6\x97\xA5",
		"\xE3\x8F\xA8" => "\x39\xE6\x97\xA5",
		"\xE3\x8F\xA9" => "\x31\x30\xE6\x97\xA5",
		"\xE3\x8F\xAA" => "\x31\x31\xE6\x97\xA5",
		"\xE3\x8F\xAB" => "\x31\x32\xE6\x97\xA5",
		"\xE3\x8F\xAC" => "\x31\x33\xE6\x97\xA5",
		"\xE3\x8F\xAD" => "\x31\x34\xE6\x97\xA5",
		"\xE3\x8F\xAE" => "\x31\x35\xE6\x97\xA5",
		"\xE3\x8F\xAF" => "\x31\x36\xE6\x97\xA5",
		"\xE3\x8F\xB0" => "\x31\x37\xE6\x97\xA5",
		"\xE3\x8F\xB1" => "\x31\x38\xE6\x97\xA5",
		"\xE3\x8F\xB2" => "\x31\x39\xE6\x97\xA5",
		"\xE3\x8F\xB3" => "\x32\x30\xE6\x97\xA5",
		"\xE3\x8F\xB4" => "\x32\x31\xE6\x97\xA5",
		"\xE3\x8F\xB5" => "\x32\x32\xE6\x97\xA5",
		"\xE3\x8F\xB6" => "\x32\x33\xE6\x97\xA5",
		"\xE3\x8F\xB7" => "\x32\x34\xE6\x97\xA5",
		"\xE3\x8F\xB8" => "\x32\x35\xE6\x97\xA5",
		"\xE3\x8F\xB9" => "\x32\x36\xE6\x97\xA5",
		"\xE3\x8F\xBA" => "\x32\x37\xE6\x97\xA5",
		"\xE3\x8F\xBB" => "\x32\x38\xE6\x97\xA5",
		"\xE3\x8F\xBC" => "\x32\x39\xE6\x97\xA5",
		"\xE3\x8F\xBD" => "\x33\x30\xE6\x97\xA5",
		"\xE3\x8F\xBE" => "\x33\x31\xE6\x97\xA5",
		"\xE3\x8F\xBF" => "\x67\x61\x6C",
		"\xEA\x9A\x9C" => "\xD1\x8A",
		"\xEA\x9A\x9D" => "\xD1\x8C",
		"\xEA\x9D\xB0" => "\xEA\x9D\xAF",
		"\xEA\x9F\xB2" => "\x43",
		"\xEA\x9F\xB3" => "\x46",
		"\xEA\x9F\xB4" => "\x51",
		"\xEA\x9F\xB8" => "\xC4\xA6",
		"\xEA\x9F\xB9" => "\xC5\x93",
		"\xEA\xAD\x9C" => "\xEA\x9C\xA7",
		"\xEA\xAD\x9D" => "\xEA\xAC\xB7",
		"\xEA\xAD\x9E" => "\xC9\xAB",
		"\xEA\xAD\x9F" => "\xEA\xAD\x92",
		"\xEA\xAD\xA9" => "\xCA\x8D",
		"\xEF\xAC\x80" => "\x66\x66",
		"\xEF\xAC\x81" => "\x66\x69",
		"\xEF\xAC\x82" => "\x66\x6C",
		"\xEF\xAC\x83" => "\x66\x66\x69",
		"\xEF\xAC\x84" => "\x66\x66\x6C",
		"\xEF\xAC\x85" => "\x73\x74",
		"\xEF\xAC\x86" => "\x73\x74",
		"\xEF\xAC\x93" => "\xD5\xB4\xD5\xB6",
		"\xEF\xAC\x94" => "\xD5\xB4\xD5\xA5",
		"\xEF\xAC\x95" => "\xD5\xB4\xD5\xAB",
		"\xEF\xAC\x96" => "\xD5\xBE\xD5\xB6",
		"\xEF\xAC\x97" => "\xD5\xB4\xD5\xAD",
		"\xEF\xAC\xA0" => "\xD7\xA2",
		"\xEF\xAC\xA1" => "\xD7\x90",
		"\xEF\xAC\xA2" => "\xD7\x93",
		"\xEF\xAC\xA3" => "\xD7\x94",
		"\xEF\xAC\xA4" => "\xD7\x9B",
		"\xEF\xAC\xA5" => "\xD7\x9C",
		"\xEF\xAC\xA6" => "\xD7\x9D",
		"\xEF\xAC\xA7" => "\xD7\xA8",
		"\xEF\xAC\xA8" => "\xD7\xAA",
		"\xEF\xAC\xA9" => "\x2B",
		"\xEF\xAD\x8F" => "\xD7\x90\xD7\x9C",
		"\xEF\xAD\x90" => "\xD9\xB1",
		"\xEF\xAD\x91" => "\xD9\xB1",
		"\xEF\xAD\x92" => "\xD9\xBB",
		"\xEF\xAD\x93" => "\xD9\xBB",
		"\xEF\xAD\x94" => "\xD9\xBB",
		"\xEF\xAD\x95" => "\xD9\xBB",
		"\xEF\xAD\x96" => "\xD9\xBE",
		"\xEF\xAD\x97" => "\xD9\xBE",
		"\xEF\xAD\x98" => "\xD9\xBE",
		"\xEF\xAD\x99" => "\xD9\xBE",
		"\xEF\xAD\x9A" => "\xDA\x80",
		"\xEF\xAD\x9B" => "\xDA\x80",
		"\xEF\xAD\x9C" => "\xDA\x80",
		"\xEF\xAD\x9D" => "\xDA\x80",
		"\xEF\xAD\x9E" => "\xD9\xBA",
		"\xEF\xAD\x9F" => "\xD9\xBA",
		"\xEF\xAD\xA0" => "\xD9\xBA",
		"\xEF\xAD\xA1" => "\xD9\xBA",
		"\xEF\xAD\xA2" => "\xD9\xBF",
		"\xEF\xAD\xA3" => "\xD9\xBF",
		"\xEF\xAD\xA4" => "\xD9\xBF",
		"\xEF\xAD\xA5" => "\xD9\xBF",
		"\xEF\xAD\xA6" => "\xD9\xB9",
		"\xEF\xAD\xA7" => "\xD9\xB9",
		"\xEF\xAD\xA8" => "\xD9\xB9",
		"\xEF\xAD\xA9" => "\xD9\xB9",
		"\xEF\xAD\xAA" => "\xDA\xA4",
		"\xEF\xAD\xAB" => "\xDA\xA4",
		"\xEF\xAD\xAC" => "\xDA\xA4",
		"\xEF\xAD\xAD" => "\xDA\xA4",
		"\xEF\xAD\xAE" => "\xDA\xA6",
		"\xEF\xAD\xAF" => "\xDA\xA6",
		"\xEF\xAD\xB0" => "\xDA\xA6",
		"\xEF\xAD\xB1" => "\xDA\xA6",
		"\xEF\xAD\xB2" => "\xDA\x84",
		"\xEF\xAD\xB3" => "\xDA\x84",
		"\xEF\xAD\xB4" => "\xDA\x84",
		"\xEF\xAD\xB5" => "\xDA\x84",
		"\xEF\xAD\xB6" => "\xDA\x83",
		"\xEF\xAD\xB7" => "\xDA\x83",
		"\xEF\xAD\xB8" => "\xDA\x83",
		"\xEF\xAD\xB9" => "\xDA\x83",
		"\xEF\xAD\xBA" => "\xDA\x86",
		"\xEF\xAD\xBB" => "\xDA\x86",
		"\xEF\xAD\xBC" => "\xDA\x86",
		"\xEF\xAD\xBD" => "\xDA\x86",
		"\xEF\xAD\xBE" => "\xDA\x87",
		"\xEF\xAD\xBF" => "\xDA\x87",
		"\xEF\xAE\x80" => "\xDA\x87",
		"\xEF\xAE\x81" => "\xDA\x87",
		"\xEF\xAE\x82" => "\xDA\x8D",
		"\xEF\xAE\x83" => "\xDA\x8D",
		"\xEF\xAE\x84" => "\xDA\x8C",
		"\xEF\xAE\x85" => "\xDA\x8C",
		"\xEF\xAE\x86" => "\xDA\x8E",
		"\xEF\xAE\x87" => "\xDA\x8E",
		"\xEF\xAE\x88" => "\xDA\x88",
		"\xEF\xAE\x89" => "\xDA\x88",
		"\xEF\xAE\x8A" => "\xDA\x98",
		"\xEF\xAE\x8B" => "\xDA\x98",
		"\xEF\xAE\x8C" => "\xDA\x91",
		"\xEF\xAE\x8D" => "\xDA\x91",
		"\xEF\xAE\x8E" => "\xDA\xA9",
		"\xEF\xAE\x8F" => "\xDA\xA9",
		"\xEF\xAE\x90" => "\xDA\xA9",
		"\xEF\xAE\x91" => "\xDA\xA9",
		"\xEF\xAE\x92" => "\xDA\xAF",
		"\xEF\xAE\x93" => "\xDA\xAF",
		"\xEF\xAE\x94" => "\xDA\xAF",
		"\xEF\xAE\x95" => "\xDA\xAF",
		"\xEF\xAE\x96" => "\xDA\xB3",
		"\xEF\xAE\x97" => "\xDA\xB3",
		"\xEF\xAE\x98" => "\xDA\xB3",
		"\xEF\xAE\x99" => "\xDA\xB3",
		"\xEF\xAE\x9A" => "\xDA\xB1",
		"\xEF\xAE\x9B" => "\xDA\xB1",
		"\xEF\xAE\x9C" => "\xDA\xB1",
		"\xEF\xAE\x9D" => "\xDA\xB1",
		"\xEF\xAE\x9E" => "\xDA\xBA",
		"\xEF\xAE\x9F" => "\xDA\xBA",
		"\xEF\xAE\xA0" => "\xDA\xBB",
		"\xEF\xAE\xA1" => "\xDA\xBB",
		"\xEF\xAE\xA2" => "\xDA\xBB",
		"\xEF\xAE\xA3" => "\xDA\xBB",
		"\xEF\xAE\xA4" => "\xDB\x95\xD9\x94",
		"\xEF\xAE\xA5" => "\xDB\x95\xD9\x94",
		"\xEF\xAE\xA6" => "\xDB\x81",
		"\xEF\xAE\xA7" => "\xDB\x81",
		"\xEF\xAE\xA8" => "\xDB\x81",
		"\xEF\xAE\xA9" => "\xDB\x81",
		"\xEF\xAE\xAA" => "\xDA\xBE",
		"\xEF\xAE\xAB" => "\xDA\xBE",
		"\xEF\xAE\xAC" => "\xDA\xBE",
		"\xEF\xAE\xAD" => "\xDA\xBE",
		"\xEF\xAE\xAE" => "\xDB\x92",
		"\xEF\xAE\xAF" => "\xDB\x92",
		"\xEF\xAE\xB0" => "\xDB\x92\xD9\x94",
		"\xEF\xAE\xB1" => "\xDB\x92\xD9\x94",
		"\xEF\xAF\x93" => "\xDA\xAD",
		"\xEF\xAF\x94" => "\xDA\xAD",
		"\xEF\xAF\x95" => "\xDA\xAD",
		"\xEF\xAF\x96" => "\xDA\xAD",
		"\xEF\xAF\x97" => "\xDB\x87",
		"\xEF\xAF\x98" => "\xDB\x87",
		"\xEF\xAF\x99" => "\xDB\x86",
		"\xEF\xAF\x9A" => "\xDB\x86",
		"\xEF\xAF\x9B" => "\xDB\x88",
		"\xEF\xAF\x9C" => "\xDB\x88",
		"\xEF\xAF\x9D" => "\xDB\x87\xD9\xB4",
		"\xEF\xAF\x9E" => "\xDB\x8B",
		"\xEF\xAF\x9F" => "\xDB\x8B",
		"\xEF\xAF\xA0" => "\xDB\x85",
		"\xEF\xAF\xA1" => "\xDB\x85",
		"\xEF\xAF\xA2" => "\xDB\x89",
		"\xEF\xAF\xA3" => "\xDB\x89",
		"\xEF\xAF\xA4" => "\xDB\x90",
		"\xEF\xAF\xA5" => "\xDB\x90",
		"\xEF\xAF\xA6" => "\xDB\x90",
		"\xEF\xAF\xA7" => "\xDB\x90",
		"\xEF\xAF\xA8" => "\xD9\x89",
		"\xEF\xAF\xA9" => "\xD9\x89",
		"\xEF\xAF\xAA" => "\xD9\x8A\xD9\x94\xD8\xA7",
		"\xEF\xAF\xAB" => "\xD9\x8A\xD9\x94\xD8\xA7",
		"\xEF\xAF\xAC" => "\xD9\x8A\xD9\x94\xDB\x95",
		"\xEF\xAF\xAD" => "\xD9\x8A\xD9\x94\xDB\x95",
		"\xEF\xAF\xAE" => "\xD9\x8A\xD9\x94\xD9\x88",
		"\xEF\xAF\xAF" => "\xD9\x8A\xD9\x94\xD9\x88",
		"\xEF\xAF\xB0" => "\xD9\x8A\xD9\x94\xDB\x87",
		"\xEF\xAF\xB1" => "\xD9\x8A\xD9\x94\xDB\x87",
		"\xEF\xAF\xB2" => "\xD9\x8A\xD9\x94\xDB\x86",
		"\xEF\xAF\xB3" => "\xD9\x8A\xD9\x94\xDB\x86",
		"\xEF\xAF\xB4" => "\xD9\x8A\xD9\x94\xDB\x88",
		"\xEF\xAF\xB5" => "\xD9\x8A\xD9\x94\xDB\x88",
		"\xEF\xAF\xB6" => "\xD9\x8A\xD9\x94\xDB\x90",
		"\xEF\xAF\xB7" => "\xD9\x8A\xD9\x94\xDB\x90",
		"\xEF\xAF\xB8" => "\xD9\x8A\xD9\x94\xDB\x90",
		"\xEF\xAF\xB9" => "\xD9\x8A\xD9\x94\xD9\x89",
		"\xEF\xAF\xBA" => "\xD9\x8A\xD9\x94\xD9\x89",
		"\xEF\xAF\xBB" => "\xD9\x8A\xD9\x94\xD9\x89",
		"\xEF\xAF\xBC" => "\xDB\x8C",
		"\xEF\xAF\xBD" => "\xDB\x8C",
		"\xEF\xAF\xBE" => "\xDB\x8C",
		"\xEF\xAF\xBF" => "\xDB\x8C",
		"\xEF\xB0\x80" => "\xD9\x8A\xD9\x94\xD8\xAC",
		"\xEF\xB0\x81" => "\xD9\x8A\xD9\x94\xD8\xAD",
		"\xEF\xB0\x82" => "\xD9\x8A\xD9\x94\xD9\x85",
		"\xEF\xB0\x83" => "\xD9\x8A\xD9\x94\xD9\x89",
		"\xEF\xB0\x84" => "\xD9\x8A\xD9\x94\xD9\x8A",
		"\xEF\xB0\x85" => "\xD8\xA8\xD8\xAC",
		"\xEF\xB0\x86" => "\xD8\xA8\xD8\xAD",
		"\xEF\xB0\x87" => "\xD8\xA8\xD8\xAE",
		"\xEF\xB0\x88" => "\xD8\xA8\xD9\x85",
		"\xEF\xB0\x89" => "\xD8\xA8\xD9\x89",
		"\xEF\xB0\x8A" => "\xD8\xA8\xD9\x8A",
		"\xEF\xB0\x8B" => "\xD8\xAA\xD8\xAC",
		"\xEF\xB0\x8C" => "\xD8\xAA\xD8\xAD",
		"\xEF\xB0\x8D" => "\xD8\xAA\xD8\xAE",
		"\xEF\xB0\x8E" => "\xD8\xAA\xD9\x85",
		"\xEF\xB0\x8F" => "\xD8\xAA\xD9\x89",
		"\xEF\xB0\x90" => "\xD8\xAA\xD9\x8A",
		"\xEF\xB0\x91" => "\xD8\xAB\xD8\xAC",
		"\xEF\xB0\x92" => "\xD8\xAB\xD9\x85",
		"\xEF\xB0\x93" => "\xD8\xAB\xD9\x89",
		"\xEF\xB0\x94" => "\xD8\xAB\xD9\x8A",
		"\xEF\xB0\x95" => "\xD8\xAC\xD8\xAD",
		"\xEF\xB0\x96" => "\xD8\xAC\xD9\x85",
		"\xEF\xB0\x97" => "\xD8\xAD\xD8\xAC",
		"\xEF\xB0\x98" => "\xD8\xAD\xD9\x85",
		"\xEF\xB0\x99" => "\xD8\xAE\xD8\xAC",
		"\xEF\xB0\x9A" => "\xD8\xAE\xD8\xAD",
		"\xEF\xB0\x9B" => "\xD8\xAE\xD9\x85",
		"\xEF\xB0\x9C" => "\xD8\xB3\xD8\xAC",
		"\xEF\xB0\x9D" => "\xD8\xB3\xD8\xAD",
		"\xEF\xB0\x9E" => "\xD8\xB3\xD8\xAE",
		"\xEF\xB0\x9F" => "\xD8\xB3\xD9\x85",
		"\xEF\xB0\xA0" => "\xD8\xB5\xD8\xAD",
		"\xEF\xB0\xA1" => "\xD8\xB5\xD9\x85",
		"\xEF\xB0\xA2" => "\xD8\xB6\xD8\xAC",
		"\xEF\xB0\xA3" => "\xD8\xB6\xD8\xAD",
		"\xEF\xB0\xA4" => "\xD8\xB6\xD8\xAE",
		"\xEF\xB0\xA5" => "\xD8\xB6\xD9\x85",
		"\xEF\xB0\xA6" => "\xD8\xB7\xD8\xAD",
		"\xEF\xB0\xA7" => "\xD8\xB7\xD9\x85",
		"\xEF\xB0\xA8" => "\xD8\xB8\xD9\x85",
		"\xEF\xB0\xA9" => "\xD8\xB9\xD8\xAC",
		"\xEF\xB0\xAA" => "\xD8\xB9\xD9\x85",
		"\xEF\xB0\xAB" => "\xD8\xBA\xD8\xAC",
		"\xEF\xB0\xAC" => "\xD8\xBA\xD9\x85",
		"\xEF\xB0\xAD" => "\xD9\x81\xD8\xAC",
		"\xEF\xB0\xAE" => "\xD9\x81\xD8\xAD",
		"\xEF\xB0\xAF" => "\xD9\x81\xD8\xAE",
		"\xEF\xB0\xB0" => "\xD9\x81\xD9\x85",
		"\xEF\xB0\xB1" => "\xD9\x81\xD9\x89",
		"\xEF\xB0\xB2" => "\xD9\x81\xD9\x8A",
		"\xEF\xB0\xB3" => "\xD9\x82\xD8\xAD",
		"\xEF\xB0\xB4" => "\xD9\x82\xD9\x85",
		"\xEF\xB0\xB5" => "\xD9\x82\xD9\x89",
		"\xEF\xB0\xB6" => "\xD9\x82\xD9\x8A",
		"\xEF\xB0\xB7" => "\xD9\x83\xD8\xA7",
		"\xEF\xB0\xB8" => "\xD9\x83\xD8\xAC",
		"\xEF\xB0\xB9" => "\xD9\x83\xD8\xAD",
		"\xEF\xB0\xBA" => "\xD9\x83\xD8\xAE",
		"\xEF\xB0\xBB" => "\xD9\x83\xD9\x84",
		"\xEF\xB0\xBC" => "\xD9\x83\xD9\x85",
		"\xEF\xB0\xBD" => "\xD9\x83\xD9\x89",
		"\xEF\xB0\xBE" => "\xD9\x83\xD9\x8A",
		"\xEF\xB0\xBF" => "\xD9\x84\xD8\xAC",
		"\xEF\xB1\x80" => "\xD9\x84\xD8\xAD",
		"\xEF\xB1\x81" => "\xD9\x84\xD8\xAE",
		"\xEF\xB1\x82" => "\xD9\x84\xD9\x85",
		"\xEF\xB1\x83" => "\xD9\x84\xD9\x89",
		"\xEF\xB1\x84" => "\xD9\x84\xD9\x8A",
		"\xEF\xB1\x85" => "\xD9\x85\xD8\xAC",
		"\xEF\xB1\x86" => "\xD9\x85\xD8\xAD",
		"\xEF\xB1\x87" => "\xD9\x85\xD8\xAE",
		"\xEF\xB1\x88" => "\xD9\x85\xD9\x85",
		"\xEF\xB1\x89" => "\xD9\x85\xD9\x89",
		"\xEF\xB1\x8A" => "\xD9\x85\xD9\x8A",
		"\xEF\xB1\x8B" => "\xD9\x86\xD8\xAC",
		"\xEF\xB1\x8C" => "\xD9\x86\xD8\xAD",
		"\xEF\xB1\x8D" => "\xD9\x86\xD8\xAE",
		"\xEF\xB1\x8E" => "\xD9\x86\xD9\x85",
		"\xEF\xB1\x8F" => "\xD9\x86\xD9\x89",
		"\xEF\xB1\x90" => "\xD9\x86\xD9\x8A",
		"\xEF\xB1\x91" => "\xD9\x87\xD8\xAC",
		"\xEF\xB1\x92" => "\xD9\x87\xD9\x85",
		"\xEF\xB1\x93" => "\xD9\x87\xD9\x89",
		"\xEF\xB1\x94" => "\xD9\x87\xD9\x8A",
		"\xEF\xB1\x95" => "\xD9\x8A\xD8\xAC",
		"\xEF\xB1\x96" => "\xD9\x8A\xD8\xAD",
		"\xEF\xB1\x97" => "\xD9\x8A\xD8\xAE",
		"\xEF\xB1\x98" => "\xD9\x8A\xD9\x85",
		"\xEF\xB1\x99" => "\xD9\x8A\xD9\x89",
		"\xEF\xB1\x9A" => "\xD9\x8A\xD9\x8A",
		"\xEF\xB1\x9B" => "\xD8\xB0\xD9\xB0",
		"\xEF\xB1\x9C" => "\xD8\xB1\xD9\xB0",
		"\xEF\xB1\x9D" => "\xD9\x89\xD9\xB0",
		"\xEF\xB1\x9E" => "\x20\xD9\x8C\xD9\x91",
		"\xEF\xB1\x9F" => "\x20\xD9\x8D\xD9\x91",
		"\xEF\xB1\xA0" => "\x20\xD9\x8E\xD9\x91",
		"\xEF\xB1\xA1" => "\x20\xD9\x8F\xD9\x91",
		"\xEF\xB1\xA2" => "\x20\xD9\x90\xD9\x91",
		"\xEF\xB1\xA3" => "\x20\xD9\x91\xD9\xB0",
		"\xEF\xB1\xA4" => "\xD9\x8A\xD9\x94\xD8\xB1",
		"\xEF\xB1\xA5" => "\xD9\x8A\xD9\x94\xD8\xB2",
		"\xEF\xB1\xA6" => "\xD9\x8A\xD9\x94\xD9\x85",
		"\xEF\xB1\xA7" => "\xD9\x8A\xD9\x94\xD9\x86",
		"\xEF\xB1\xA8" => "\xD9\x8A\xD9\x94\xD9\x89",
		"\xEF\xB1\xA9" => "\xD9\x8A\xD9\x94\xD9\x8A",
		"\xEF\xB1\xAA" => "\xD8\xA8\xD8\xB1",
		"\xEF\xB1\xAB" => "\xD8\xA8\xD8\xB2",
		"\xEF\xB1\xAC" => "\xD8\xA8\xD9\x85",
		"\xEF\xB1\xAD" => "\xD8\xA8\xD9\x86",
		"\xEF\xB1\xAE" => "\xD8\xA8\xD9\x89",
		"\xEF\xB1\xAF" => "\xD8\xA8\xD9\x8A",
		"\xEF\xB1\xB0" => "\xD8\xAA\xD8\xB1",
		"\xEF\xB1\xB1" => "\xD8\xAA\xD8\xB2",
		"\xEF\xB1\xB2" => "\xD8\xAA\xD9\x85",
		"\xEF\xB1\xB3" => "\xD8\xAA\xD9\x86",
		"\xEF\xB1\xB4" => "\xD8\xAA\xD9\x89",
		"\xEF\xB1\xB5" => "\xD8\xAA\xD9\x8A",
		"\xEF\xB1\xB6" => "\xD8\xAB\xD8\xB1",
		"\xEF\xB1\xB7" => "\xD8\xAB\xD8\xB2",
		"\xEF\xB1\xB8" => "\xD8\xAB\xD9\x85",
		"\xEF\xB1\xB9" => "\xD8\xAB\xD9\x86",
		"\xEF\xB1\xBA" => "\xD8\xAB\xD9\x89",
		"\xEF\xB1\xBB" => "\xD8\xAB\xD9\x8A",
		"\xEF\xB1\xBC" => "\xD9\x81\xD9\x89",
		"\xEF\xB1\xBD" => "\xD9\x81\xD9\x8A",
		"\xEF\xB1\xBE" => "\xD9\x82\xD9\x89",
		"\xEF\xB1\xBF" => "\xD9\x82\xD9\x8A",
		"\xEF\xB2\x80" => "\xD9\x83\xD8\xA7",
		"\xEF\xB2\x81" => "\xD9\x83\xD9\x84",
		"\xEF\xB2\x82" => "\xD9\x83\xD9\x85",
		"\xEF\xB2\x83" => "\xD9\x83\xD9\x89",
		"\xEF\xB2\x84" => "\xD9\x83\xD9\x8A",
		"\xEF\xB2\x85" => "\xD9\x84\xD9\x85",
		"\xEF\xB2\x86" => "\xD9\x84\xD9\x89",
		"\xEF\xB2\x87" => "\xD9\x84\xD9\x8A",
		"\xEF\xB2\x88" => "\xD9\x85\xD8\xA7",
		"\xEF\xB2\x89" => "\xD9\x85\xD9\x85",
		"\xEF\xB2\x8A" => "\xD9\x86\xD8\xB1",
		"\xEF\xB2\x8B" => "\xD9\x86\xD8\xB2",
		"\xEF\xB2\x8C" => "\xD9\x86\xD9\x85",
		"\xEF\xB2\x8D" => "\xD9\x86\xD9\x86",
		"\xEF\xB2\x8E" => "\xD9\x86\xD9\x89",
		"\xEF\xB2\x8F" => "\xD9\x86\xD9\x8A",
		"\xEF\xB2\x90" => "\xD9\x89\xD9\xB0",
		"\xEF\xB2\x91" => "\xD9\x8A\xD8\xB1",
		"\xEF\xB2\x92" => "\xD9\x8A\xD8\xB2",
		"\xEF\xB2\x93" => "\xD9\x8A\xD9\x85",
		"\xEF\xB2\x94" => "\xD9\x8A\xD9\x86",
		"\xEF\xB2\x95" => "\xD9\x8A\xD9\x89",
		"\xEF\xB2\x96" => "\xD9\x8A\xD9\x8A",
		"\xEF\xB2\x97" => "\xD9\x8A\xD9\x94\xD8\xAC",
		"\xEF\xB2\x98" => "\xD9\x8A\xD9\x94\xD8\xAD",
		"\xEF\xB2\x99" => "\xD9\x8A\xD9\x94\xD8\xAE",
		"\xEF\xB2\x9A" => "\xD9\x8A\xD9\x94\xD9\x85",
		"\xEF\xB2\x9B" => "\xD9\x8A\xD9\x94\xD9\x87",
		"\xEF\xB2\x9C" => "\xD8\xA8\xD8\xAC",
		"\xEF\xB2\x9D" => "\xD8\xA8\xD8\xAD",
		"\xEF\xB2\x9E" => "\xD8\xA8\xD8\xAE",
		"\xEF\xB2\x9F" => "\xD8\xA8\xD9\x85",
		"\xEF\xB2\xA0" => "\xD8\xA8\xD9\x87",
		"\xEF\xB2\xA1" => "\xD8\xAA\xD8\xAC",
		"\xEF\xB2\xA2" => "\xD8\xAA\xD8\xAD",
		"\xEF\xB2\xA3" => "\xD8\xAA\xD8\xAE",
		"\xEF\xB2\xA4" => "\xD8\xAA\xD9\x85",
		"\xEF\xB2\xA5" => "\xD8\xAA\xD9\x87",
		"\xEF\xB2\xA6" => "\xD8\xAB\xD9\x85",
		"\xEF\xB2\xA7" => "\xD8\xAC\xD8\xAD",
		"\xEF\xB2\xA8" => "\xD8\xAC\xD9\x85",
		"\xEF\xB2\xA9" => "\xD8\xAD\xD8\xAC",
		"\xEF\xB2\xAA" => "\xD8\xAD\xD9\x85",
		"\xEF\xB2\xAB" => "\xD8\xAE\xD8\xAC",
		"\xEF\xB2\xAC" => "\xD8\xAE\xD9\x85",
		"\xEF\xB2\xAD" => "\xD8\xB3\xD8\xAC",
		"\xEF\xB2\xAE" => "\xD8\xB3\xD8\xAD",
		"\xEF\xB2\xAF" => "\xD8\xB3\xD8\xAE",
		"\xEF\xB2\xB0" => "\xD8\xB3\xD9\x85",
		"\xEF\xB2\xB1" => "\xD8\xB5\xD8\xAD",
		"\xEF\xB2\xB2" => "\xD8\xB5\xD8\xAE",
		"\xEF\xB2\xB3" => "\xD8\xB5\xD9\x85",
		"\xEF\xB2\xB4" => "\xD8\xB6\xD8\xAC",
		"\xEF\xB2\xB5" => "\xD8\xB6\xD8\xAD",
		"\xEF\xB2\xB6" => "\xD8\xB6\xD8\xAE",
		"\xEF\xB2\xB7" => "\xD8\xB6\xD9\x85",
		"\xEF\xB2\xB8" => "\xD8\xB7\xD8\xAD",
		"\xEF\xB2\xB9" => "\xD8\xB8\xD9\x85",
		"\xEF\xB2\xBA" => "\xD8\xB9\xD8\xAC",
		"\xEF\xB2\xBB" => "\xD8\xB9\xD9\x85",
		"\xEF\xB2\xBC" => "\xD8\xBA\xD8\xAC",
		"\xEF\xB2\xBD" => "\xD8\xBA\xD9\x85",
		"\xEF\xB2\xBE" => "\xD9\x81\xD8\xAC",
		"\xEF\xB2\xBF" => "\xD9\x81\xD8\xAD",
		"\xEF\xB3\x80" => "\xD9\x81\xD8\xAE",
		"\xEF\xB3\x81" => "\xD9\x81\xD9\x85",
		"\xEF\xB3\x82" => "\xD9\x82\xD8\xAD",
		"\xEF\xB3\x83" => "\xD9\x82\xD9\x85",
		"\xEF\xB3\x84" => "\xD9\x83\xD8\xAC",
		"\xEF\xB3\x85" => "\xD9\x83\xD8\xAD",
		"\xEF\xB3\x86" => "\xD9\x83\xD8\xAE",
		"\xEF\xB3\x87" => "\xD9\x83\xD9\x84",
		"\xEF\xB3\x88" => "\xD9\x83\xD9\x85",
		"\xEF\xB3\x89" => "\xD9\x84\xD8\xAC",
		"\xEF\xB3\x8A" => "\xD9\x84\xD8\xAD",
		"\xEF\xB3\x8B" => "\xD9\x84\xD8\xAE",
		"\xEF\xB3\x8C" => "\xD9\x84\xD9\x85",
		"\xEF\xB3\x8D" => "\xD9\x84\xD9\x87",
		"\xEF\xB3\x8E" => "\xD9\x85\xD8\xAC",
		"\xEF\xB3\x8F" => "\xD9\x85\xD8\xAD",
		"\xEF\xB3\x90" => "\xD9\x85\xD8\xAE",
		"\xEF\xB3\x91" => "\xD9\x85\xD9\x85",
		"\xEF\xB3\x92" => "\xD9\x86\xD8\xAC",
		"\xEF\xB3\x93" => "\xD9\x86\xD8\xAD",
		"\xEF\xB3\x94" => "\xD9\x86\xD8\xAE",
		"\xEF\xB3\x95" => "\xD9\x86\xD9\x85",
		"\xEF\xB3\x96" => "\xD9\x86\xD9\x87",
		"\xEF\xB3\x97" => "\xD9\x87\xD8\xAC",
		"\xEF\xB3\x98" => "\xD9\x87\xD9\x85",
		"\xEF\xB3\x99" => "\xD9\x87\xD9\xB0",
		"\xEF\xB3\x9A" => "\xD9\x8A\xD8\xAC",
		"\xEF\xB3\x9B" => "\xD9\x8A\xD8\xAD",
		"\xEF\xB3\x9C" => "\xD9\x8A\xD8\xAE",
		"\xEF\xB3\x9D" => "\xD9\x8A\xD9\x85",
		"\xEF\xB3\x9E" => "\xD9\x8A\xD9\x87",
		"\xEF\xB3\x9F" => "\xD9\x8A\xD9\x94\xD9\x85",
		"\xEF\xB3\xA0" => "\xD9\x8A\xD9\x94\xD9\x87",
		"\xEF\xB3\xA1" => "\xD8\xA8\xD9\x85",
		"\xEF\xB3\xA2" => "\xD8\xA8\xD9\x87",
		"\xEF\xB3\xA3" => "\xD8\xAA\xD9\x85",
		"\xEF\xB3\xA4" => "\xD8\xAA\xD9\x87",
		"\xEF\xB3\xA5" => "\xD8\xAB\xD9\x85",
		"\xEF\xB3\xA6" => "\xD8\xAB\xD9\x87",
		"\xEF\xB3\xA7" => "\xD8\xB3\xD9\x85",
		"\xEF\xB3\xA8" => "\xD8\xB3\xD9\x87",
		"\xEF\xB3\xA9" => "\xD8\xB4\xD9\x85",
		"\xEF\xB3\xAA" => "\xD8\xB4\xD9\x87",
		"\xEF\xB3\xAB" => "\xD9\x83\xD9\x84",
		"\xEF\xB3\xAC" => "\xD9\x83\xD9\x85",
		"\xEF\xB3\xAD" => "\xD9\x84\xD9\x85",
		"\xEF\xB3\xAE" => "\xD9\x86\xD9\x85",
		"\xEF\xB3\xAF" => "\xD9\x86\xD9\x87",
		"\xEF\xB3\xB0" => "\xD9\x8A\xD9\x85",
		"\xEF\xB3\xB1" => "\xD9\x8A\xD9\x87",
		"\xEF\xB3\xB2" => "\xD9\x80\xD9\x8E\xD9\x91",
		"\xEF\xB3\xB3" => "\xD9\x80\xD9\x8F\xD9\x91",
		"\xEF\xB3\xB4" => "\xD9\x80\xD9\x90\xD9\x91",
		"\xEF\xB3\xB5" => "\xD8\xB7\xD9\x89",
		"\xEF\xB3\xB6" => "\xD8\xB7\xD9\x8A",
		"\xEF\xB3\xB7" => "\xD8\xB9\xD9\x89",
		"\xEF\xB3\xB8" => "\xD8\xB9\xD9\x8A",
		"\xEF\xB3\xB9" => "\xD8\xBA\xD9\x89",
		"\xEF\xB3\xBA" => "\xD8\xBA\xD9\x8A",
		"\xEF\xB3\xBB" => "\xD8\xB3\xD9\x89",
		"\xEF\xB3\xBC" => "\xD8\xB3\xD9\x8A",
		"\xEF\xB3\xBD" => "\xD8\xB4\xD9\x89",
		"\xEF\xB3\xBE" => "\xD8\xB4\xD9\x8A",
		"\xEF\xB3\xBF" => "\xD8\xAD\xD9\x89",
		"\xEF\xB4\x80" => "\xD8\xAD\xD9\x8A",
		"\xEF\xB4\x81" => "\xD8\xAC\xD9\x89",
		"\xEF\xB4\x82" => "\xD8\xAC\xD9\x8A",
		"\xEF\xB4\x83" => "\xD8\xAE\xD9\x89",
		"\xEF\xB4\x84" => "\xD8\xAE\xD9\x8A",
		"\xEF\xB4\x85" => "\xD8\xB5\xD9\x89",
		"\xEF\xB4\x86" => "\xD8\xB5\xD9\x8A",
		"\xEF\xB4\x87" => "\xD8\xB6\xD9\x89",
		"\xEF\xB4\x88" => "\xD8\xB6\xD9\x8A",
		"\xEF\xB4\x89" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\x8A" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\x8B" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\x8C" => "\xD8\xB4\xD9\x85",
		"\xEF\xB4\x8D" => "\xD8\xB4\xD8\xB1",
		"\xEF\xB4\x8E" => "\xD8\xB3\xD8\xB1",
		"\xEF\xB4\x8F" => "\xD8\xB5\xD8\xB1",
		"\xEF\xB4\x90" => "\xD8\xB6\xD8\xB1",
		"\xEF\xB4\x91" => "\xD8\xB7\xD9\x89",
		"\xEF\xB4\x92" => "\xD8\xB7\xD9\x8A",
		"\xEF\xB4\x93" => "\xD8\xB9\xD9\x89",
		"\xEF\xB4\x94" => "\xD8\xB9\xD9\x8A",
		"\xEF\xB4\x95" => "\xD8\xBA\xD9\x89",
		"\xEF\xB4\x96" => "\xD8\xBA\xD9\x8A",
		"\xEF\xB4\x97" => "\xD8\xB3\xD9\x89",
		"\xEF\xB4\x98" => "\xD8\xB3\xD9\x8A",
		"\xEF\xB4\x99" => "\xD8\xB4\xD9\x89",
		"\xEF\xB4\x9A" => "\xD8\xB4\xD9\x8A",
		"\xEF\xB4\x9B" => "\xD8\xAD\xD9\x89",
		"\xEF\xB4\x9C" => "\xD8\xAD\xD9\x8A",
		"\xEF\xB4\x9D" => "\xD8\xAC\xD9\x89",
		"\xEF\xB4\x9E" => "\xD8\xAC\xD9\x8A",
		"\xEF\xB4\x9F" => "\xD8\xAE\xD9\x89",
		"\xEF\xB4\xA0" => "\xD8\xAE\xD9\x8A",
		"\xEF\xB4\xA1" => "\xD8\xB5\xD9\x89",
		"\xEF\xB4\xA2" => "\xD8\xB5\xD9\x8A",
		"\xEF\xB4\xA3" => "\xD8\xB6\xD9\x89",
		"\xEF\xB4\xA4" => "\xD8\xB6\xD9\x8A",
		"\xEF\xB4\xA5" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\xA6" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\xA7" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\xA8" => "\xD8\xB4\xD9\x85",
		"\xEF\xB4\xA9" => "\xD8\xB4\xD8\xB1",
		"\xEF\xB4\xAA" => "\xD8\xB3\xD8\xB1",
		"\xEF\xB4\xAB" => "\xD8\xB5\xD8\xB1",
		"\xEF\xB4\xAC" => "\xD8\xB6\xD8\xB1",
		"\xEF\xB4\xAD" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\xAE" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\xAF" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\xB0" => "\xD8\xB4\xD9\x85",
		"\xEF\xB4\xB1" => "\xD8\xB3\xD9\x87",
		"\xEF\xB4\xB2" => "\xD8\xB4\xD9\x87",
		"\xEF\xB4\xB3" => "\xD8\xB7\xD9\x85",
		"\xEF\xB4\xB4" => "\xD8\xB3\xD8\xAC",
		"\xEF\xB4\xB5" => "\xD8\xB3\xD8\xAD",
		"\xEF\xB4\xB6" => "\xD8\xB3\xD8\xAE",
		"\xEF\xB4\xB7" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\xB8" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\xB9" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\xBA" => "\xD8\xB7\xD9\x85",
		"\xEF\xB4\xBB" => "\xD8\xB8\xD9\x85",
		"\xEF\xB4\xBC" => "\xD8\xA7\xD9\x8B",
		"\xEF\xB4\xBD" => "\xD8\xA7\xD9\x8B",
		"\xEF\xB5\x90" => "\xD8\xAA\xD8\xAC\xD9\x85",
		"\xEF\xB5\x91" => "\xD8\xAA\xD8\xAD\xD8\xAC",
		"\xEF\xB5\x92" => "\xD8\xAA\xD8\xAD\xD8\xAC",
		"\xEF\xB5\x93" => "\xD8\xAA\xD8\xAD\xD9\x85",
		"\xEF\xB5\x94" => "\xD8\xAA\xD8\xAE\xD9\x85",
		"\xEF\xB5\x95" => "\xD8\xAA\xD9\x85\xD8\xAC",
		"\xEF\xB5\x96" => "\xD8\xAA\xD9\x85\xD8\xAD",
		"\xEF\xB5\x97" => "\xD8\xAA\xD9\x85\xD8\xAE",
		"\xEF\xB5\x98" => "\xD8\xAC\xD9\x85\xD8\xAD",
		"\xEF\xB5\x99" => "\xD8\xAC\xD9\x85\xD8\xAD",
		"\xEF\xB5\x9A" => "\xD8\xAD\xD9\x85\xD9\x8A",
		"\xEF\xB5\x9B" => "\xD8\xAD\xD9\x85\xD9\x89",
		"\xEF\xB5\x9C" => "\xD8\xB3\xD8\xAD\xD8\xAC",
		"\xEF\xB5\x9D" => "\xD8\xB3\xD8\xAC\xD8\xAD",
		"\xEF\xB5\x9E" => "\xD8\xB3\xD8\xAC\xD9\x89",
		"\xEF\xB5\x9F" => "\xD8\xB3\xD9\x85\xD8\xAD",
		"\xEF\xB5\xA0" => "\xD8\xB3\xD9\x85\xD8\xAD",
		"\xEF\xB5\xA1" => "\xD8\xB3\xD9\x85\xD8\xAC",
		"\xEF\xB5\xA2" => "\xD8\xB3\xD9\x85\xD9\x85",
		"\xEF\xB5\xA3" => "\xD8\xB3\xD9\x85\xD9\x85",
		"\xEF\xB5\xA4" => "\xD8\xB5\xD8\xAD\xD8\xAD",
		"\xEF\xB5\xA5" => "\xD8\xB5\xD8\xAD\xD8\xAD",
		"\xEF\xB5\xA6" => "\xD8\xB5\xD9\x85\xD9\x85",
		"\xEF\xB5\xA7" => "\xD8\xB4\xD8\xAD\xD9\x85",
		"\xEF\xB5\xA8" => "\xD8\xB4\xD8\xAD\xD9\x85",
		"\xEF\xB5\xA9" => "\xD8\xB4\xD8\xAC\xD9\x8A",
		"\xEF\xB5\xAA" => "\xD8\xB4\xD9\x85\xD8\xAE",
		"\xEF\xB5\xAB" => "\xD8\xB4\xD9\x85\xD8\xAE",
		"\xEF\xB5\xAC" => "\xD8\xB4\xD9\x85\xD9\x85",
		"\xEF\xB5\xAD" => "\xD8\xB4\xD9\x85\xD9\x85",
		"\xEF\xB5\xAE" => "\xD8\xB6\xD8\xAD\xD9\x89",
		"\xEF\xB5\xAF" => "\xD8\xB6\xD8\xAE\xD9\x85",
		"\xEF\xB5\xB0" => "\xD8\xB6\xD8\xAE\xD9\x85",
		"\xEF\xB5\xB1" => "\xD8\xB7\xD9\x85\xD8\xAD",
		"\xEF\xB5\xB2" => "\xD8\xB7\xD9\x85\xD8\xAD",
		"\xEF\xB5\xB3" => "\xD8\xB7\xD9\x85\xD9\x85",
		"\xEF\xB5\xB4" => "\xD8\xB7\xD9\x85\xD9\x8A",
		"\xEF\xB5\xB5" => "\xD8\xB9\xD8\xAC\xD9\x85",
		"\xEF\xB5\xB6" => "\xD8\xB9\xD9\x85\xD9\x85",
		"\xEF\xB5\xB7" => "\xD8\xB9\xD9\x85\xD9\x85",
		"\xEF\xB5\xB8" => "\xD8\xB9\xD9\x85\xD9\x89",
		"\xEF\xB5\xB9" => "\xD8\xBA\xD9\x85\xD9\x85",
		"\xEF\xB5\xBA" => "\xD8\xBA\xD9\x85\xD9\x8A",
		"\xEF\xB5\xBB" => "\xD8\xBA\xD9\x85\xD9\x89",
		"\xEF\xB5\xBC" => "\xD9\x81\xD8\xAE\xD9\x85",
		"\xEF\xB5\xBD" => "\xD9\x81\xD8\xAE\xD9\x85",
		"\xEF\xB5\xBE" => "\xD9\x82\xD9\x85\xD8\xAD",
		"\xEF\xB5\xBF" => "\xD9\x82\xD9\x85\xD9\x85",
		"\xEF\xB6\x80" => "\xD9\x84\xD8\xAD\xD9\x85",
		"\xEF\xB6\x81" => "\xD9\x84\xD8\xAD\xD9\x8A",
		"\xEF\xB6\x82" => "\xD9\x84\xD8\xAD\xD9\x89",
		"\xEF\xB6\x83" => "\xD9\x84\xD8\xAC\xD8\xAC",
		"\xEF\xB6\x84" => "\xD9\x84\xD8\xAC\xD8\xAC",
		"\xEF\xB6\x85" => "\xD9\x84\xD8\xAE\xD9\x85",
		"\xEF\xB6\x86" => "\xD9\x84\xD8\xAE\xD9\x85",
		"\xEF\xB6\x87" => "\xD9\x84\xD9\x85\xD8\xAD",
		"\xEF\xB6\x88" => "\xD9\x84\xD9\x85\xD8\xAD",
		"\xEF\xB6\x89" => "\xD9\x85\xD8\xAD\xD8\xAC",
		"\xEF\xB6\x8A" => "\xD9\x85\xD8\xAD\xD9\x85",
		"\xEF\xB6\x8B" => "\xD9\x85\xD8\xAD\xD9\x8A",
		"\xEF\xB6\x8C" => "\xD9\x85\xD8\xAC\xD8\xAD",
		"\xEF\xB6\x8D" => "\xD9\x85\xD8\xAC\xD9\x85",
		"\xEF\xB6\x8E" => "\xD9\x85\xD8\xAE\xD8\xAC",
		"\xEF\xB6\x8F" => "\xD9\x85\xD8\xAE\xD9\x85",
		"\xEF\xB6\x92" => "\xD9\x85\xD8\xAC\xD8\xAE",
		"\xEF\xB6\x93" => "\xD9\x87\xD9\x85\xD8\xAC",
		"\xEF\xB6\x94" => "\xD9\x87\xD9\x85\xD9\x85",
		"\xEF\xB6\x95" => "\xD9\x86\xD8\xAD\xD9\x85",
		"\xEF\xB6\x96" => "\xD9\x86\xD8\xAD\xD9\x89",
		"\xEF\xB6\x97" => "\xD9\x86\xD8\xAC\xD9\x85",
		"\xEF\xB6\x98" => "\xD9\x86\xD8\xAC\xD9\x85",
		"\xEF\xB6\x99" => "\xD9\x86\xD8\xAC\xD9\x89",
		"\xEF\xB6\x9A" => "\xD9\x86\xD9\x85\xD9\x8A",
		"\xEF\xB6\x9B" => "\xD9\x86\xD9\x85\xD9\x89",
		"\xEF\xB6\x9C" => "\xD9\x8A\xD9\x85\xD9\x85",
		"\xEF\xB6\x9D" => "\xD9\x8A\xD9\x85\xD9\x85",
		"\xEF\xB6\x9E" => "\xD8\xA8\xD8\xAE\xD9\x8A",
		"\xEF\xB6\x9F" => "\xD8\xAA\xD8\xAC\xD9\x8A",
		"\xEF\xB6\xA0" => "\xD8\xAA\xD8\xAC\xD9\x89",
		"\xEF\xB6\xA1" => "\xD8\xAA\xD8\xAE\xD9\x8A",
		"\xEF\xB6\xA2" => "\xD8\xAA\xD8\xAE\xD9\x89",
		"\xEF\xB6\xA3" => "\xD8\xAA\xD9\x85\xD9\x8A",
		"\xEF\xB6\xA4" => "\xD8\xAA\xD9\x85\xD9\x89",
		"\xEF\xB6\xA5" => "\xD8\xAC\xD9\x85\xD9\x8A",
		"\xEF\xB6\xA6" => "\xD8\xAC\xD8\xAD\xD9\x89",
		"\xEF\xB6\xA7" => "\xD8\xAC\xD9\x85\xD9\x89",
		"\xEF\xB6\xA8" => "\xD8\xB3\xD8\xAE\xD9\x89",
		"\xEF\xB6\xA9" => "\xD8\xB5\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAA" => "\xD8\xB4\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAB" => "\xD8\xB6\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAC" => "\xD9\x84\xD8\xAC\xD9\x8A",
		"\xEF\xB6\xAD" => "\xD9\x84\xD9\x85\xD9\x8A",
		"\xEF\xB6\xAE" => "\xD9\x8A\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAF" => "\xD9\x8A\xD8\xAC\xD9\x8A",
		"\xEF\xB6\xB0" => "\xD9\x8A\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB1" => "\xD9\x85\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB2" => "\xD9\x82\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB3" => "\xD9\x86\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xB4" => "\xD9\x82\xD9\x85\xD8\xAD",
		"\xEF\xB6\xB5" => "\xD9\x84\xD8\xAD\xD9\x85",
		"\xEF\xB6\xB6" => "\xD8\xB9\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB7" => "\xD9\x83\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB8" => "\xD9\x86\xD8\xAC\xD8\xAD",
		"\xEF\xB6\xB9" => "\xD9\x85\xD8\xAE\xD9\x8A",
		"\xEF\xB6\xBA" => "\xD9\x84\xD8\xAC\xD9\x85",
		"\xEF\xB6\xBB" => "\xD9\x83\xD9\x85\xD9\x85",
		"\xEF\xB6\xBC" => "\xD9\x84\xD8\xAC\xD9\x85",
		"\xEF\xB6\xBD" => "\xD9\x86\xD8\xAC\xD8\xAD",
		"\xEF\xB6\xBE" => "\xD8\xAC\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xBF" => "\xD8\xAD\xD8\xAC\xD9\x8A",
		"\xEF\xB7\x80" => "\xD9\x85\xD8\xAC\xD9\x8A",
		"\xEF\xB7\x81" => "\xD9\x81\xD9\x85\xD9\x8A",
		"\xEF\xB7\x82" => "\xD8\xA8\xD8\xAD\xD9\x8A",
		"\xEF\xB7\x83" => "\xD9\x83\xD9\x85\xD9\x85",
		"\xEF\xB7\x84" => "\xD8\xB9\xD8\xAC\xD9\x85",
		"\xEF\xB7\x85" => "\xD8\xB5\xD9\x85\xD9\x85",
		"\xEF\xB7\x86" => "\xD8\xB3\xD8\xAE\xD9\x8A",
		"\xEF\xB7\x87" => "\xD9\x86\xD8\xAC\xD9\x8A",
		"\xEF\xB7\xB0" => "\xD8\xB5\xD9\x84\xDB\x92",
		"\xEF\xB7\xB1" => "\xD9\x82\xD9\x84\xDB\x92",
		"\xEF\xB7\xB2" => "\xD8\xA7\xD9\x84\xD9\x84\xD9\x87",
		"\xEF\xB7\xB3" => "\xD8\xA7\xD9\x83\xD8\xA8\xD8\xB1",
		"\xEF\xB7\xB4" => "\xD9\x85\xD8\xAD\xD9\x85\xD8\xAF",
		"\xEF\xB7\xB5" => "\xD8\xB5\xD9\x84\xD8\xB9\xD9\x85",
		"\xEF\xB7\xB6" => "\xD8\xB1\xD8\xB3\xD9\x88\xD9\x84",
		"\xEF\xB7\xB7" => "\xD8\xB9\xD9\x84\xD9\x8A\xD9\x87",
		"\xEF\xB7\xB8" => "\xD9\x88\xD8\xB3\xD9\x84\xD9\x85",
		"\xEF\xB7\xB9" => "\xD8\xB5\xD9\x84\xD9\x89",
		"\xEF\xB7\xBA" => "\xD8\xB5\xD9\x84\xD9\x89\x20\xD8\xA7\xD9\x84\xD9\x84\xD9\x87\x20\xD8\xB9\xD9\x84\xD9\x8A\xD9\x87\x20\xD9\x88\xD8\xB3\xD9\x84\xD9\x85",
		"\xEF\xB7\xBB" => "\xD8\xAC\xD9\x84\x20\xD8\xAC\xD9\x84\xD8\xA7\xD9\x84\xD9\x87",
		"\xEF\xB7\xBC" => "\xD8\xB1\xDB\x8C\xD8\xA7\xD9\x84",
		"\xEF\xB8\x90" => "\x2C",
		"\xEF\xB8\x91" => "\xE3\x80\x81",
		"\xEF\xB8\x92" => "\xE3\x80\x82",
		"\xEF\xB8\x93" => "\x3A",
		"\xEF\xB8\x94" => "\x3B",
		"\xEF\xB8\x95" => "\x21",
		"\xEF\xB8\x96" => "\x3F",
		"\xEF\xB8\x97" => "\xE3\x80\x96",
		"\xEF\xB8\x98" => "\xE3\x80\x97",
		"\xEF\xB8\x99" => "\x2E\x2E\x2E",
		"\xEF\xB8\xB0" => "\x2E\x2E",
		"\xEF\xB8\xB1" => "\xE2\x80\x94",
		"\xEF\xB8\xB2" => "\xE2\x80\x93",
		"\xEF\xB8\xB3" => "\x5F",
		"\xEF\xB8\xB4" => "\x5F",
		"\xEF\xB8\xB5" => "\x28",
		"\xEF\xB8\xB6" => "\x29",
		"\xEF\xB8\xB7" => "\x7B",
		"\xEF\xB8\xB8" => "\x7D",
		"\xEF\xB8\xB9" => "\xE3\x80\x94",
		"\xEF\xB8\xBA" => "\xE3\x80\x95",
		"\xEF\xB8\xBB" => "\xE3\x80\x90",
		"\xEF\xB8\xBC" => "\xE3\x80\x91",
		"\xEF\xB8\xBD" => "\xE3\x80\x8A",
		"\xEF\xB8\xBE" => "\xE3\x80\x8B",
		"\xEF\xB8\xBF" => "\xE3\x80\x88",
		"\xEF\xB9\x80" => "\xE3\x80\x89",
		"\xEF\xB9\x81" => "\xE3\x80\x8C",
		"\xEF\xB9\x82" => "\xE3\x80\x8D",
		"\xEF\xB9\x83" => "\xE3\x80\x8E",
		"\xEF\xB9\x84" => "\xE3\x80\x8F",
		"\xEF\xB9\x87" => "\x5B",
		"\xEF\xB9\x88" => "\x5D",
		"\xEF\xB9\x89" => "\x20\xCC\x85",
		"\xEF\xB9\x8A" => "\x20\xCC\x85",
		"\xEF\xB9\x8B" => "\x20\xCC\x85",
		"\xEF\xB9\x8C" => "\x20\xCC\x85",
		"\xEF\xB9\x8D" => "\x5F",
		"\xEF\xB9\x8E" => "\x5F",
		"\xEF\xB9\x8F" => "\x5F",
		"\xEF\xB9\x90" => "\x2C",
		"\xEF\xB9\x91" => "\xE3\x80\x81",
		"\xEF\xB9\x92" => "\x2E",
		"\xEF\xB9\x94" => "\x3B",
		"\xEF\xB9\x95" => "\x3A",
		"\xEF\xB9\x96" => "\x3F",
		"\xEF\xB9\x97" => "\x21",
		"\xEF\xB9\x98" => "\xE2\x80\x94",
		"\xEF\xB9\x99" => "\x28",
		"\xEF\xB9\x9A" => "\x29",
		"\xEF\xB9\x9B" => "\x7B",
		"\xEF\xB9\x9C" => "\x7D",
		"\xEF\xB9\x9D" => "\xE3\x80\x94",
		"\xEF\xB9\x9E" => "\xE3\x80\x95",
		"\xEF\xB9\x9F" => "\x23",
		"\xEF\xB9\xA0" => "\x26",
		"\xEF\xB9\xA1" => "\x2A",
		"\xEF\xB9\xA2" => "\x2B",
		"\xEF\xB9\xA3" => "\x2D",
		"\xEF\xB9\xA4" => "\x3C",
		"\xEF\xB9\xA5" => "\x3E",
		"\xEF\xB9\xA6" => "\x3D",
		"\xEF\xB9\xA8" => "\x5C",
		"\xEF\xB9\xA9" => "\x24",
		"\xEF\xB9\xAA" => "\x25",
		"\xEF\xB9\xAB" => "\x40",
		"\xEF\xB9\xB0" => "\x20\xD9\x8B",
		"\xEF\xB9\xB1" => "\xD9\x80\xD9\x8B",
		"\xEF\xB9\xB2" => "\x20\xD9\x8C",
		"\xEF\xB9\xB4" => "\x20\xD9\x8D",
		"\xEF\xB9\xB6" => "\x20\xD9\x8E",
		"\xEF\xB9\xB7" => "\xD9\x80\xD9\x8E",
		"\xEF\xB9\xB8" => "\x20\xD9\x8F",
		"\xEF\xB9\xB9" => "\xD9\x80\xD9\x8F",
		"\xEF\xB9\xBA" => "\x20\xD9\x90",
		"\xEF\xB9\xBB" => "\xD9\x80\xD9\x90",
		"\xEF\xB9\xBC" => "\x20\xD9\x91",
		"\xEF\xB9\xBD" => "\xD9\x80\xD9\x91",
		"\xEF\xB9\xBE" => "\x20\xD9\x92",
		"\xEF\xB9\xBF" => "\xD9\x80\xD9\x92",
		"\xEF\xBA\x80" => "\xD8\xA1",
		"\xEF\xBA\x81" => "\xD8\xA7\xD9\x93",
		"\xEF\xBA\x82" => "\xD8\xA7\xD9\x93",
		"\xEF\xBA\x83" => "\xD8\xA7\xD9\x94",
		"\xEF\xBA\x84" => "\xD8\xA7\xD9\x94",
		"\xEF\xBA\x85" => "\xD9\x88\xD9\x94",
		"\xEF\xBA\x86" => "\xD9\x88\xD9\x94",
		"\xEF\xBA\x87" => "\xD8\xA7\xD9\x95",
		"\xEF\xBA\x88" => "\xD8\xA7\xD9\x95",
		"\xEF\xBA\x89" => "\xD9\x8A\xD9\x94",
		"\xEF\xBA\x8A" => "\xD9\x8A\xD9\x94",
		"\xEF\xBA\x8B" => "\xD9\x8A\xD9\x94",
		"\xEF\xBA\x8C" => "\xD9\x8A\xD9\x94",
		"\xEF\xBA\x8D" => "\xD8\xA7",
		"\xEF\xBA\x8E" => "\xD8\xA7",
		"\xEF\xBA\x8F" => "\xD8\xA8",
		"\xEF\xBA\x90" => "\xD8\xA8",
		"\xEF\xBA\x91" => "\xD8\xA8",
		"\xEF\xBA\x92" => "\xD8\xA8",
		"\xEF\xBA\x93" => "\xD8\xA9",
		"\xEF\xBA\x94" => "\xD8\xA9",
		"\xEF\xBA\x95" => "\xD8\xAA",
		"\xEF\xBA\x96" => "\xD8\xAA",
		"\xEF\xBA\x97" => "\xD8\xAA",
		"\xEF\xBA\x98" => "\xD8\xAA",
		"\xEF\xBA\x99" => "\xD8\xAB",
		"\xEF\xBA\x9A" => "\xD8\xAB",
		"\xEF\xBA\x9B" => "\xD8\xAB",
		"\xEF\xBA\x9C" => "\xD8\xAB",
		"\xEF\xBA\x9D" => "\xD8\xAC",
		"\xEF\xBA\x9E" => "\xD8\xAC",
		"\xEF\xBA\x9F" => "\xD8\xAC",
		"\xEF\xBA\xA0" => "\xD8\xAC",
		"\xEF\xBA\xA1" => "\xD8\xAD",
		"\xEF\xBA\xA2" => "\xD8\xAD",
		"\xEF\xBA\xA3" => "\xD8\xAD",
		"\xEF\xBA\xA4" => "\xD8\xAD",
		"\xEF\xBA\xA5" => "\xD8\xAE",
		"\xEF\xBA\xA6" => "\xD8\xAE",
		"\xEF\xBA\xA7" => "\xD8\xAE",
		"\xEF\xBA\xA8" => "\xD8\xAE",
		"\xEF\xBA\xA9" => "\xD8\xAF",
		"\xEF\xBA\xAA" => "\xD8\xAF",
		"\xEF\xBA\xAB" => "\xD8\xB0",
		"\xEF\xBA\xAC" => "\xD8\xB0",
		"\xEF\xBA\xAD" => "\xD8\xB1",
		"\xEF\xBA\xAE" => "\xD8\xB1",
		"\xEF\xBA\xAF" => "\xD8\xB2",
		"\xEF\xBA\xB0" => "\xD8\xB2",
		"\xEF\xBA\xB1" => "\xD8\xB3",
		"\xEF\xBA\xB2" => "\xD8\xB3",
		"\xEF\xBA\xB3" => "\xD8\xB3",
		"\xEF\xBA\xB4" => "\xD8\xB3",
		"\xEF\xBA\xB5" => "\xD8\xB4",
		"\xEF\xBA\xB6" => "\xD8\xB4",
		"\xEF\xBA\xB7" => "\xD8\xB4",
		"\xEF\xBA\xB8" => "\xD8\xB4",
		"\xEF\xBA\xB9" => "\xD8\xB5",
		"\xEF\xBA\xBA" => "\xD8\xB5",
		"\xEF\xBA\xBB" => "\xD8\xB5",
		"\xEF\xBA\xBC" => "\xD8\xB5",
		"\xEF\xBA\xBD" => "\xD8\xB6",
		"\xEF\xBA\xBE" => "\xD8\xB6",
		"\xEF\xBA\xBF" => "\xD8\xB6",
		"\xEF\xBB\x80" => "\xD8\xB6",
		"\xEF\xBB\x81" => "\xD8\xB7",
		"\xEF\xBB\x82" => "\xD8\xB7",
		"\xEF\xBB\x83" => "\xD8\xB7",
		"\xEF\xBB\x84" => "\xD8\xB7",
		"\xEF\xBB\x85" => "\xD8\xB8",
		"\xEF\xBB\x86" => "\xD8\xB8",
		"\xEF\xBB\x87" => "\xD8\xB8",
		"\xEF\xBB\x88" => "\xD8\xB8",
		"\xEF\xBB\x89" => "\xD8\xB9",
		"\xEF\xBB\x8A" => "\xD8\xB9",
		"\xEF\xBB\x8B" => "\xD8\xB9",
		"\xEF\xBB\x8C" => "\xD8\xB9",
		"\xEF\xBB\x8D" => "\xD8\xBA",
		"\xEF\xBB\x8E" => "\xD8\xBA",
		"\xEF\xBB\x8F" => "\xD8\xBA",
		"\xEF\xBB\x90" => "\xD8\xBA",
		"\xEF\xBB\x91" => "\xD9\x81",
		"\xEF\xBB\x92" => "\xD9\x81",
		"\xEF\xBB\x93" => "\xD9\x81",
		"\xEF\xBB\x94" => "\xD9\x81",
		"\xEF\xBB\x95" => "\xD9\x82",
		"\xEF\xBB\x96" => "\xD9\x82",
		"\xEF\xBB\x97" => "\xD9\x82",
		"\xEF\xBB\x98" => "\xD9\x82",
		"\xEF\xBB\x99" => "\xD9\x83",
		"\xEF\xBB\x9A" => "\xD9\x83",
		"\xEF\xBB\x9B" => "\xD9\x83",
		"\xEF\xBB\x9C" => "\xD9\x83",
		"\xEF\xBB\x9D" => "\xD9\x84",
		"\xEF\xBB\x9E" => "\xD9\x84",
		"\xEF\xBB\x9F" => "\xD9\x84",
		"\xEF\xBB\xA0" => "\xD9\x84",
		"\xEF\xBB\xA1" => "\xD9\x85",
		"\xEF\xBB\xA2" => "\xD9\x85",
		"\xEF\xBB\xA3" => "\xD9\x85",
		"\xEF\xBB\xA4" => "\xD9\x85",
		"\xEF\xBB\xA5" => "\xD9\x86",
		"\xEF\xBB\xA6" => "\xD9\x86",
		"\xEF\xBB\xA7" => "\xD9\x86",
		"\xEF\xBB\xA8" => "\xD9\x86",
		"\xEF\xBB\xA9" => "\xD9\x87",
		"\xEF\xBB\xAA" => "\xD9\x87",
		"\xEF\xBB\xAB" => "\xD9\x87",
		"\xEF\xBB\xAC" => "\xD9\x87",
		"\xEF\xBB\xAD" => "\xD9\x88",
		"\xEF\xBB\xAE" => "\xD9\x88",
		"\xEF\xBB\xAF" => "\xD9\x89",
		"\xEF\xBB\xB0" => "\xD9\x89",
		"\xEF\xBB\xB1" => "\xD9\x8A",
		"\xEF\xBB\xB2" => "\xD9\x8A",
		"\xEF\xBB\xB3" => "\xD9\x8A",
		"\xEF\xBB\xB4" => "\xD9\x8A",
		"\xEF\xBB\xB5" => "\xD9\x84\xD8\xA7\xD9\x93",
		"\xEF\xBB\xB6" => "\xD9\x84\xD8\xA7\xD9\x93",
		"\xEF\xBB\xB7" => "\xD9\x84\xD8\xA7\xD9\x94",
		"\xEF\xBB\xB8" => "\xD9\x84\xD8\xA7\xD9\x94",
		"\xEF\xBB\xB9" => "\xD9\x84\xD8\xA7\xD9\x95",
		"\xEF\xBB\xBA" => "\xD9\x84\xD8\xA7\xD9\x95",
		"\xEF\xBB\xBB" => "\xD9\x84\xD8\xA7",
		"\xEF\xBB\xBC" => "\xD9\x84\xD8\xA7",
		"\xEF\xBC\x81" => "\x21",
		"\xEF\xBC\x82" => "\x22",
		"\xEF\xBC\x83" => "\x23",
		"\xEF\xBC\x84" => "\x24",
		"\xEF\xBC\x85" => "\x25",
		"\xEF\xBC\x86" => "\x26",
		"\xEF\xBC\x87" => "\x27",
		"\xEF\xBC\x88" => "\x28",
		"\xEF\xBC\x89" => "\x29",
		"\xEF\xBC\x8A" => "\x2A",
		"\xEF\xBC\x8B" => "\x2B",
		"\xEF\xBC\x8C" => "\x2C",
		"\xEF\xBC\x8D" => "\x2D",
		"\xEF\xBC\x8E" => "\x2E",
		"\xEF\xBC\x8F" => "\x2F",
		"\xEF\xBC\x90" => "\x30",
		"\xEF\xBC\x91" => "\x31",
		"\xEF\xBC\x92" => "\x32",
		"\xEF\xBC\x93" => "\x33",
		"\xEF\xBC\x94" => "\x34",
		"\xEF\xBC\x95" => "\x35",
		"\xEF\xBC\x96" => "\x36",
		"\xEF\xBC\x97" => "\x37",
		"\xEF\xBC\x98" => "\x38",
		"\xEF\xBC\x99" => "\x39",
		"\xEF\xBC\x9A" => "\x3A",
		"\xEF\xBC\x9B" => "\x3B",
		"\xEF\xBC\x9C" => "\x3C",
		"\xEF\xBC\x9D" => "\x3D",
		"\xEF\xBC\x9E" => "\x3E",
		"\xEF\xBC\x9F" => "\x3F",
		"\xEF\xBC\xA0" => "\x40",
		"\xEF\xBC\xA1" => "\x41",
		"\xEF\xBC\xA2" => "\x42",
		"\xEF\xBC\xA3" => "\x43",
		"\xEF\xBC\xA4" => "\x44",
		"\xEF\xBC\xA5" => "\x45",
		"\xEF\xBC\xA6" => "\x46",
		"\xEF\xBC\xA7" => "\x47",
		"\xEF\xBC\xA8" => "\x48",
		"\xEF\xBC\xA9" => "\x49",
		"\xEF\xBC\xAA" => "\x4A",
		"\xEF\xBC\xAB" => "\x4B",
		"\xEF\xBC\xAC" => "\x4C",
		"\xEF\xBC\xAD" => "\x4D",
		"\xEF\xBC\xAE" => "\x4E",
		"\xEF\xBC\xAF" => "\x4F",
		"\xEF\xBC\xB0" => "\x50",
		"\xEF\xBC\xB1" => "\x51",
		"\xEF\xBC\xB2" => "\x52",
		"\xEF\xBC\xB3" => "\x53",
		"\xEF\xBC\xB4" => "\x54",
		"\xEF\xBC\xB5" => "\x55",
		"\xEF\xBC\xB6" => "\x56",
		"\xEF\xBC\xB7" => "\x57",
		"\xEF\xBC\xB8" => "\x58",
		"\xEF\xBC\xB9" => "\x59",
		"\xEF\xBC\xBA" => "\x5A",
		"\xEF\xBC\xBB" => "\x5B",
		"\xEF\xBC\xBC" => "\x5C",
		"\xEF\xBC\xBD" => "\x5D",
		"\xEF\xBC\xBE" => "\x5E",
		"\xEF\xBC\xBF" => "\x5F",
		"\xEF\xBD\x80" => "\x60",
		"\xEF\xBD\x81" => "\x61",
		"\xEF\xBD\x82" => "\x62",
		"\xEF\xBD\x83" => "\x63",
		"\xEF\xBD\x84" => "\x64",
		"\xEF\xBD\x85" => "\x65",
		"\xEF\xBD\x86" => "\x66",
		"\xEF\xBD\x87" => "\x67",
		"\xEF\xBD\x88" => "\x68",
		"\xEF\xBD\x89" => "\x69",
		"\xEF\xBD\x8A" => "\x6A",
		"\xEF\xBD\x8B" => "\x6B",
		"\xEF\xBD\x8C" => "\x6C",
		"\xEF\xBD\x8D" => "\x6D",
		"\xEF\xBD\x8E" => "\x6E",
		"\xEF\xBD\x8F" => "\x6F",
		"\xEF\xBD\x90" => "\x70",
		"\xEF\xBD\x91" => "\x71",
		"\xEF\xBD\x92" => "\x72",
		"\xEF\xBD\x93" => "\x73",
		"\xEF\xBD\x94" => "\x74",
		"\xEF\xBD\x95" => "\x75",
		"\xEF\xBD\x96" => "\x76",
		"\xEF\xBD\x97" => "\x77",
		"\xEF\xBD\x98" => "\x78",
		"\xEF\xBD\x99" => "\x79",
		"\xEF\xBD\x9A" => "\x7A",
		"\xEF\xBD\x9B" => "\x7B",
		"\xEF\xBD\x9C" => "\x7C",
		"\xEF\xBD\x9D" => "\x7D",
		"\xEF\xBD\x9E" => "\x7E",
		"\xEF\xBD\x9F" => "\xE2\xA6\x85",
		"\xEF\xBD\xA0" => "\xE2\xA6\x86",
		"\xEF\xBD\xA1" => "\xE3\x80\x82",
		"\xEF\xBD\xA2" => "\xE3\x80\x8C",
		"\xEF\xBD\xA3" => "\xE3\x80\x8D",
		"\xEF\xBD\xA4" => "\xE3\x80\x81",
		"\xEF\xBD\xA5" => "\xE3\x83\xBB",
		"\xEF\xBD\xA6" => "\xE3\x83\xB2",
		"\xEF\xBD\xA7" => "\xE3\x82\xA1",
		"\xEF\xBD\xA8" => "\xE3\x82\xA3",
		"\xEF\xBD\xA9" => "\xE3\x82\xA5",
		"\xEF\xBD\xAA" => "\xE3\x82\xA7",
		"\xEF\xBD\xAB" => "\xE3\x82\xA9",
		"\xEF\xBD\xAC" => "\xE3\x83\xA3",
		"\xEF\xBD\xAD" => "\xE3\x83\xA5",
		"\xEF\xBD\xAE" => "\xE3\x83\xA7",
		"\xEF\xBD\xAF" => "\xE3\x83\x83",
		"\xEF\xBD\xB0" => "\xE3\x83\xBC",
		"\xEF\xBD\xB1" => "\xE3\x82\xA2",
		"\xEF\xBD\xB2" => "\xE3\x82\xA4",
		"\xEF\xBD\xB3" => "\xE3\x82\xA6",
		"\xEF\xBD\xB4" => "\xE3\x82\xA8",
		"\xEF\xBD\xB5" => "\xE3\x82\xAA",
		"\xEF\xBD\xB6" => "\xE3\x82\xAB",
		"\xEF\xBD\xB7" => "\xE3\x82\xAD",
		"\xEF\xBD\xB8" => "\xE3\x82\xAF",
		"\xEF\xBD\xB9" => "\xE3\x82\xB1",
		"\xEF\xBD\xBA" => "\xE3\x82\xB3",
		"\xEF\xBD\xBB" => "\xE3\x82\xB5",
		"\xEF\xBD\xBC" => "\xE3\x82\xB7",
		"\xEF\xBD\xBD" => "\xE3\x82\xB9",
		"\xEF\xBD\xBE" => "\xE3\x82\xBB",
		"\xEF\xBD\xBF" => "\xE3\x82\xBD",
		"\xEF\xBE\x80" => "\xE3\x82\xBF",
		"\xEF\xBE\x81" => "\xE3\x83\x81",
		"\xEF\xBE\x82" => "\xE3\x83\x84",
		"\xEF\xBE\x83" => "\xE3\x83\x86",
		"\xEF\xBE\x84" => "\xE3\x83\x88",
		"\xEF\xBE\x85" => "\xE3\x83\x8A",
		"\xEF\xBE\x86" => "\xE3\x83\x8B",
		"\xEF\xBE\x87" => "\xE3\x83\x8C",
		"\xEF\xBE\x88" => "\xE3\x83\x8D",
		"\xEF\xBE\x89" => "\xE3\x83\x8E",
		"\xEF\xBE\x8A" => "\xE3\x83\x8F",
		"\xEF\xBE\x8B" => "\xE3\x83\x92",
		"\xEF\xBE\x8C" => "\xE3\x83\x95",
		"\xEF\xBE\x8D" => "\xE3\x83\x98",
		"\xEF\xBE\x8E" => "\xE3\x83\x9B",
		"\xEF\xBE\x8F" => "\xE3\x83\x9E",
		"\xEF\xBE\x90" => "\xE3\x83\x9F",
		"\xEF\xBE\x91" => "\xE3\x83\xA0",
		"\xEF\xBE\x92" => "\xE3\x83\xA1",
		"\xEF\xBE\x93" => "\xE3\x83\xA2",
		"\xEF\xBE\x94" => "\xE3\x83\xA4",
		"\xEF\xBE\x95" => "\xE3\x83\xA6",
		"\xEF\xBE\x96" => "\xE3\x83\xA8",
		"\xEF\xBE\x97" => "\xE3\x83\xA9",
		"\xEF\xBE\x98" => "\xE3\x83\xAA",
		"\xEF\xBE\x99" => "\xE3\x83\xAB",
		"\xEF\xBE\x9A" => "\xE3\x83\xAC",
		"\xEF\xBE\x9B" => "\xE3\x83\xAD",
		"\xEF\xBE\x9C" => "\xE3\x83\xAF",
		"\xEF\xBE\x9D" => "\xE3\x83\xB3",
		"\xEF\xBE\x9E" => "\xE3\x82\x99",
		"\xEF\xBE\x9F" => "\xE3\x82\x9A",
		"\xEF\xBE\xA0" => "\xE1\x85\xA0",
		"\xEF\xBE\xA1" => "\xE1\x84\x80",
		"\xEF\xBE\xA2" => "\xE1\x84\x81",
		"\xEF\xBE\xA3" => "\xE1\x86\xAA",
		"\xEF\xBE\xA4" => "\xE1\x84\x82",
		"\xEF\xBE\xA5" => "\xE1\x86\xAC",
		"\xEF\xBE\xA6" => "\xE1\x86\xAD",
		"\xEF\xBE\xA7" => "\xE1\x84\x83",
		"\xEF\xBE\xA8" => "\xE1\x84\x84",
		"\xEF\xBE\xA9" => "\xE1\x84\x85",
		"\xEF\xBE\xAA" => "\xE1\x86\xB0",
		"\xEF\xBE\xAB" => "\xE1\x86\xB1",
		"\xEF\xBE\xAC" => "\xE1\x86\xB2",
		"\xEF\xBE\xAD" => "\xE1\x86\xB3",
		"\xEF\xBE\xAE" => "\xE1\x86\xB4",
		"\xEF\xBE\xAF" => "\xE1\x86\xB5",
		"\xEF\xBE\xB0" => "\xE1\x84\x9A",
		"\xEF\xBE\xB1" => "\xE1\x84\x86",
		"\xEF\xBE\xB2" => "\xE1\x84\x87",
		"\xEF\xBE\xB3" => "\xE1\x84\x88",
		"\xEF\xBE\xB4" => "\xE1\x84\xA1",
		"\xEF\xBE\xB5" => "\xE1\x84\x89",
		"\xEF\xBE\xB6" => "\xE1\x84\x8A",
		"\xEF\xBE\xB7" => "\xE1\x84\x8B",
		"\xEF\xBE\xB8" => "\xE1\x84\x8C",
		"\xEF\xBE\xB9" => "\xE1\x84\x8D",
		"\xEF\xBE\xBA" => "\xE1\x84\x8E",
		"\xEF\xBE\xBB" => "\xE1\x84\x8F",
		"\xEF\xBE\xBC" => "\xE1\x84\x90",
		"\xEF\xBE\xBD" => "\xE1\x84\x91",
		"\xEF\xBE\xBE" => "\xE1\x84\x92",
		"\xEF\xBF\x82" => "\xE1\x85\xA1",
		"\xEF\xBF\x83" => "\xE1\x85\xA2",
		"\xEF\xBF\x84" => "\xE1\x85\xA3",
		"\xEF\xBF\x85" => "\xE1\x85\xA4",
		"\xEF\xBF\x86" => "\xE1\x85\xA5",
		"\xEF\xBF\x87" => "\xE1\x85\xA6",
		"\xEF\xBF\x8A" => "\xE1\x85\xA7",
		"\xEF\xBF\x8B" => "\xE1\x85\xA8",
		"\xEF\xBF\x8C" => "\xE1\x85\xA9",
		"\xEF\xBF\x8D" => "\xE1\x85\xAA",
		"\xEF\xBF\x8E" => "\xE1\x85\xAB",
		"\xEF\xBF\x8F" => "\xE1\x85\xAC",
		"\xEF\xBF\x92" => "\xE1\x85\xAD",
		"\xEF\xBF\x93" => "\xE1\x85\xAE",
		"\xEF\xBF\x94" => "\xE1\x85\xAF",
		"\xEF\xBF\x95" => "\xE1\x85\xB0",
		"\xEF\xBF\x96" => "\xE1\x85\xB1",
		"\xEF\xBF\x97" => "\xE1\x85\xB2",
		"\xEF\xBF\x9A" => "\xE1\x85\xB3",
		"\xEF\xBF\x9B" => "\xE1\x85\xB4",
		"\xEF\xBF\x9C" => "\xE1\x85\xB5",
		"\xEF\xBF\xA0" => "\xC2\xA2",
		"\xEF\xBF\xA1" => "\xC2\xA3",
		"\xEF\xBF\xA2" => "\xC2\xAC",
		"\xEF\xBF\xA3" => "\x20\xCC\x84",
		"\xEF\xBF\xA4" => "\xC2\xA6",
		"\xEF\xBF\xA5" => "\xC2\xA5",
		"\xEF\xBF\xA6" => "\xE2\x82\xA9",
		"\xEF\xBF\xA8" => "\xE2\x94\x82",
		"\xEF\xBF\xA9" => "\xE2\x86\x90",
		"\xEF\xBF\xAA" => "\xE2\x86\x91",
		"\xEF\xBF\xAB" => "\xE2\x86\x92",
		"\xEF\xBF\xAC" => "\xE2\x86\x93",
		"\xEF\xBF\xAD" => "\xE2\x96\xA0",
		"\xEF\xBF\xAE" => "\xE2\x97\x8B",
		"\xF0\x90\x9E\x81" => "\xCB\x90",
		"\xF0\x90\x9E\x82" => "\xCB\x91",
		"\xF0\x90\x9E\x83" => "\xC3\xA6",
		"\xF0\x90\x9E\x84" => "\xCA\x99",
		"\xF0\x90\x9E\x85" => "\xC9\x93",
		"\xF0\x90\x9E\x87" => "\xCA\xA3",
		"\xF0\x90\x9E\x88" => "\xEA\xAD\xA6",
		"\xF0\x90\x9E\x89" => "\xCA\xA5",
		"\xF0\x90\x9E\x8A" => "\xCA\xA4",
		"\xF0\x90\x9E\x8B" => "\xC9\x96",
		"\xF0\x90\x9E\x8C" => "\xC9\x97",
		"\xF0\x90\x9E\x8D" => "\xE1\xB6\x91",
		"\xF0\x90\x9E\x8E" => "\xC9\x98",
		"\xF0\x90\x9E\x8F" => "\xC9\x9E",
		"\xF0\x90\x9E\x90" => "\xCA\xA9",
		"\xF0\x90\x9E\x91" => "\xC9\xA4",
		"\xF0\x90\x9E\x92" => "\xC9\xA2",
		"\xF0\x90\x9E\x93" => "\xC9\xA0",
		"\xF0\x90\x9E\x94" => "\xCA\x9B",
		"\xF0\x90\x9E\x95" => "\xC4\xA7",
		"\xF0\x90\x9E\x96" => "\xCA\x9C",
		"\xF0\x90\x9E\x97" => "\xC9\xA7",
		"\xF0\x90\x9E\x98" => "\xCA\x84",
		"\xF0\x90\x9E\x99" => "\xCA\xAA",
		"\xF0\x90\x9E\x9A" => "\xCA\xAB",
		"\xF0\x90\x9E\x9B" => "\xC9\xAC",
		"\xF0\x90\x9E\x9C" => "\xF0\x9D\xBC\x84",
		"\xF0\x90\x9E\x9D" => "\xEA\x9E\x8E",
		"\xF0\x90\x9E\x9E" => "\xC9\xAE",
		"\xF0\x90\x9E\x9F" => "\xF0\x9D\xBC\x85",
		"\xF0\x90\x9E\xA0" => "\xCA\x8E",
		"\xF0\x90\x9E\xA1" => "\xF0\x9D\xBC\x86",
		"\xF0\x90\x9E\xA2" => "\xC3\xB8",
		"\xF0\x90\x9E\xA3" => "\xC9\xB6",
		"\xF0\x90\x9E\xA4" => "\xC9\xB7",
		"\xF0\x90\x9E\xA5" => "\x71",
		"\xF0\x90\x9E\xA6" => "\xC9\xBA",
		"\xF0\x90\x9E\xA7" => "\xF0\x9D\xBC\x88",
		"\xF0\x90\x9E\xA8" => "\xC9\xBD",
		"\xF0\x90\x9E\xA9" => "\xC9\xBE",
		"\xF0\x90\x9E\xAA" => "\xCA\x80",
		"\xF0\x90\x9E\xAB" => "\xCA\xA8",
		"\xF0\x90\x9E\xAC" => "\xCA\xA6",
		"\xF0\x90\x9E\xAD" => "\xEA\xAD\xA7",
		"\xF0\x90\x9E\xAE" => "\xCA\xA7",
		"\xF0\x90\x9E\xAF" => "\xCA\x88",
		"\xF0\x90\x9E\xB0" => "\xE2\xB1\xB1",
		"\xF0\x90\x9E\xB2" => "\xCA\x8F",
		"\xF0\x90\x9E\xB3" => "\xCA\xA1",
		"\xF0\x90\x9E\xB4" => "\xCA\xA2",
		"\xF0\x90\x9E\xB5" => "\xCA\x98",
		"\xF0\x90\x9E\xB6" => "\xC7\x80",
		"\xF0\x90\x9E\xB7" => "\xC7\x81",
		"\xF0\x90\x9E\xB8" => "\xC7\x82",
		"\xF0\x90\x9E\xB9" => "\xF0\x9D\xBC\x8A",
		"\xF0\x90\x9E\xBA" => "\xF0\x9D\xBC\x9E",
		"\xF0\x9C\xB3\x96" => "\x41",
		"\xF0\x9C\xB3\x97" => "\x42",
		"\xF0\x9C\xB3\x98" => "\x43",
		"\xF0\x9C\xB3\x99" => "\x44",
		"\xF0\x9C\xB3\x9A" => "\x45",
		"\xF0\x9C\xB3\x9B" => "\x46",
		"\xF0\x9C\xB3\x9C" => "\x47",
		"\xF0\x9C\xB3\x9D" => "\x48",
		"\xF0\x9C\xB3\x9E" => "\x49",
		"\xF0\x9C\xB3\x9F" => "\x4A",
		"\xF0\x9C\xB3\xA0" => "\x4B",
		"\xF0\x9C\xB3\xA1" => "\x4C",
		"\xF0\x9C\xB3\xA2" => "\x4D",
		"\xF0\x9C\xB3\xA3" => "\x4E",
		"\xF0\x9C\xB3\xA4" => "\x4F",
		"\xF0\x9C\xB3\xA5" => "\x50",
		"\xF0\x9C\xB3\xA6" => "\x51",
		"\xF0\x9C\xB3\xA7" => "\x52",
		"\xF0\x9C\xB3\xA8" => "\x53",
		"\xF0\x9C\xB3\xA9" => "\x54",
		"\xF0\x9C\xB3\xAA" => "\x55",
		"\xF0\x9C\xB3\xAB" => "\x56",
		"\xF0\x9C\xB3\xAC" => "\x57",
		"\xF0\x9C\xB3\xAD" => "\x58",
		"\xF0\x9C\xB3\xAE" => "\x59",
		"\xF0\x9C\xB3\xAF" => "\x5A",
		"\xF0\x9C\xB3\xB0" => "\x30",
		"\xF0\x9C\xB3\xB1" => "\x31",
		"\xF0\x9C\xB3\xB2" => "\x32",
		"\xF0\x9C\xB3\xB3" => "\x33",
		"\xF0\x9C\xB3\xB4" => "\x34",
		"\xF0\x9C\xB3\xB5" => "\x35",
		"\xF0\x9C\xB3\xB6" => "\x36",
		"\xF0\x9C\xB3\xB7" => "\x37",
		"\xF0\x9C\xB3\xB8" => "\x38",
		"\xF0\x9C\xB3\xB9" => "\x39",
		"\xF0\x9D\x90\x80" => "\x41",
		"\xF0\x9D\x90\x81" => "\x42",
		"\xF0\x9D\x90\x82" => "\x43",
		"\xF0\x9D\x90\x83" => "\x44",
		"\xF0\x9D\x90\x84" => "\x45",
		"\xF0\x9D\x90\x85" => "\x46",
		"\xF0\x9D\x90\x86" => "\x47",
		"\xF0\x9D\x90\x87" => "\x48",
		"\xF0\x9D\x90\x88" => "\x49",
		"\xF0\x9D\x90\x89" => "\x4A",
		"\xF0\x9D\x90\x8A" => "\x4B",
		"\xF0\x9D\x90\x8B" => "\x4C",
		"\xF0\x9D\x90\x8C" => "\x4D",
		"\xF0\x9D\x90\x8D" => "\x4E",
		"\xF0\x9D\x90\x8E" => "\x4F",
		"\xF0\x9D\x90\x8F" => "\x50",
		"\xF0\x9D\x90\x90" => "\x51",
		"\xF0\x9D\x90\x91" => "\x52",
		"\xF0\x9D\x90\x92" => "\x53",
		"\xF0\x9D\x90\x93" => "\x54",
		"\xF0\x9D\x90\x94" => "\x55",
		"\xF0\x9D\x90\x95" => "\x56",
		"\xF0\x9D\x90\x96" => "\x57",
		"\xF0\x9D\x90\x97" => "\x58",
		"\xF0\x9D\x90\x98" => "\x59",
		"\xF0\x9D\x90\x99" => "\x5A",
		"\xF0\x9D\x90\x9A" => "\x61",
		"\xF0\x9D\x90\x9B" => "\x62",
		"\xF0\x9D\x90\x9C" => "\x63",
		"\xF0\x9D\x90\x9D" => "\x64",
		"\xF0\x9D\x90\x9E" => "\x65",
		"\xF0\x9D\x90\x9F" => "\x66",
		"\xF0\x9D\x90\xA0" => "\x67",
		"\xF0\x9D\x90\xA1" => "\x68",
		"\xF0\x9D\x90\xA2" => "\x69",
		"\xF0\x9D\x90\xA3" => "\x6A",
		"\xF0\x9D\x90\xA4" => "\x6B",
		"\xF0\x9D\x90\xA5" => "\x6C",
		"\xF0\x9D\x90\xA6" => "\x6D",
		"\xF0\x9D\x90\xA7" => "\x6E",
		"\xF0\x9D\x90\xA8" => "\x6F",
		"\xF0\x9D\x90\xA9" => "\x70",
		"\xF0\x9D\x90\xAA" => "\x71",
		"\xF0\x9D\x90\xAB" => "\x72",
		"\xF0\x9D\x90\xAC" => "\x73",
		"\xF0\x9D\x90\xAD" => "\x74",
		"\xF0\x9D\x90\xAE" => "\x75",
		"\xF0\x9D\x90\xAF" => "\x76",
		"\xF0\x9D\x90\xB0" => "\x77",
		"\xF0\x9D\x90\xB1" => "\x78",
		"\xF0\x9D\x90\xB2" => "\x79",
		"\xF0\x9D\x90\xB3" => "\x7A",
		"\xF0\x9D\x90\xB4" => "\x41",
		"\xF0\x9D\x90\xB5" => "\x42",
		"\xF0\x9D\x90\xB6" => "\x43",
		"\xF0\x9D\x90\xB7" => "\x44",
		"\xF0\x9D\x90\xB8" => "\x45",
		"\xF0\x9D\x90\xB9" => "\x46",
		"\xF0\x9D\x90\xBA" => "\x47",
		"\xF0\x9D\x90\xBB" => "\x48",
		"\xF0\x9D\x90\xBC" => "\x49",
		"\xF0\x9D\x90\xBD" => "\x4A",
		"\xF0\x9D\x90\xBE" => "\x4B",
		"\xF0\x9D\x90\xBF" => "\x4C",
		"\xF0\x9D\x91\x80" => "\x4D",
		"\xF0\x9D\x91\x81" => "\x4E",
		"\xF0\x9D\x91\x82" => "\x4F",
		"\xF0\x9D\x91\x83" => "\x50",
		"\xF0\x9D\x91\x84" => "\x51",
		"\xF0\x9D\x91\x85" => "\x52",
		"\xF0\x9D\x91\x86" => "\x53",
		"\xF0\x9D\x91\x87" => "\x54",
		"\xF0\x9D\x91\x88" => "\x55",
		"\xF0\x9D\x91\x89" => "\x56",
		"\xF0\x9D\x91\x8A" => "\x57",
		"\xF0\x9D\x91\x8B" => "\x58",
		"\xF0\x9D\x91\x8C" => "\x59",
		"\xF0\x9D\x91\x8D" => "\x5A",
		"\xF0\x9D\x91\x8E" => "\x61",
		"\xF0\x9D\x91\x8F" => "\x62",
		"\xF0\x9D\x91\x90" => "\x63",
		"\xF0\x9D\x91\x91" => "\x64",
		"\xF0\x9D\x91\x92" => "\x65",
		"\xF0\x9D\x91\x93" => "\x66",
		"\xF0\x9D\x91\x94" => "\x67",
		"\xF0\x9D\x91\x96" => "\x69",
		"\xF0\x9D\x91\x97" => "\x6A",
		"\xF0\x9D\x91\x98" => "\x6B",
		"\xF0\x9D\x91\x99" => "\x6C",
		"\xF0\x9D\x91\x9A" => "\x6D",
		"\xF0\x9D\x91\x9B" => "\x6E",
		"\xF0\x9D\x91\x9C" => "\x6F",
		"\xF0\x9D\x91\x9D" => "\x70",
		"\xF0\x9D\x91\x9E" => "\x71",
		"\xF0\x9D\x91\x9F" => "\x72",
		"\xF0\x9D\x91\xA0" => "\x73",
		"\xF0\x9D\x91\xA1" => "\x74",
		"\xF0\x9D\x91\xA2" => "\x75",
		"\xF0\x9D\x91\xA3" => "\x76",
		"\xF0\x9D\x91\xA4" => "\x77",
		"\xF0\x9D\x91\xA5" => "\x78",
		"\xF0\x9D\x91\xA6" => "\x79",
		"\xF0\x9D\x91\xA7" => "\x7A",
		"\xF0\x9D\x91\xA8" => "\x41",
		"\xF0\x9D\x91\xA9" => "\x42",
		"\xF0\x9D\x91\xAA" => "\x43",
		"\xF0\x9D\x91\xAB" => "\x44",
		"\xF0\x9D\x91\xAC" => "\x45",
		"\xF0\x9D\x91\xAD" => "\x46",
		"\xF0\x9D\x91\xAE" => "\x47",
		"\xF0\x9D\x91\xAF" => "\x48",
		"\xF0\x9D\x91\xB0" => "\x49",
		"\xF0\x9D\x91\xB1" => "\x4A",
		"\xF0\x9D\x91\xB2" => "\x4B",
		"\xF0\x9D\x91\xB3" => "\x4C",
		"\xF0\x9D\x91\xB4" => "\x4D",
		"\xF0\x9D\x91\xB5" => "\x4E",
		"\xF0\x9D\x91\xB6" => "\x4F",
		"\xF0\x9D\x91\xB7" => "\x50",
		"\xF0\x9D\x91\xB8" => "\x51",
		"\xF0\x9D\x91\xB9" => "\x52",
		"\xF0\x9D\x91\xBA" => "\x53",
		"\xF0\x9D\x91\xBB" => "\x54",
		"\xF0\x9D\x91\xBC" => "\x55",
		"\xF0\x9D\x91\xBD" => "\x56",
		"\xF0\x9D\x91\xBE" => "\x57",
		"\xF0\x9D\x91\xBF" => "\x58",
		"\xF0\x9D\x92\x80" => "\x59",
		"\xF0\x9D\x92\x81" => "\x5A",
		"\xF0\x9D\x92\x82" => "\x61",
		"\xF0\x9D\x92\x83" => "\x62",
		"\xF0\x9D\x92\x84" => "\x63",
		"\xF0\x9D\x92\x85" => "\x64",
		"\xF0\x9D\x92\x86" => "\x65",
		"\xF0\x9D\x92\x87" => "\x66",
		"\xF0\x9D\x92\x88" => "\x67",
		"\xF0\x9D\x92\x89" => "\x68",
		"\xF0\x9D\x92\x8A" => "\x69",
		"\xF0\x9D\x92\x8B" => "\x6A",
		"\xF0\x9D\x92\x8C" => "\x6B",
		"\xF0\x9D\x92\x8D" => "\x6C",
		"\xF0\x9D\x92\x8E" => "\x6D",
		"\xF0\x9D\x92\x8F" => "\x6E",
		"\xF0\x9D\x92\x90" => "\x6F",
		"\xF0\x9D\x92\x91" => "\x70",
		"\xF0\x9D\x92\x92" => "\x71",
		"\xF0\x9D\x92\x93" => "\x72",
		"\xF0\x9D\x92\x94" => "\x73",
		"\xF0\x9D\x92\x95" => "\x74",
		"\xF0\x9D\x92\x96" => "\x75",
		"\xF0\x9D\x92\x97" => "\x76",
		"\xF0\x9D\x92\x98" => "\x77",
		"\xF0\x9D\x92\x99" => "\x78",
		"\xF0\x9D\x92\x9A" => "\x79",
		"\xF0\x9D\x92\x9B" => "\x7A",
		"\xF0\x9D\x92\x9C" => "\x41",
		"\xF0\x9D\x92\x9E" => "\x43",
		"\xF0\x9D\x92\x9F" => "\x44",
		"\xF0\x9D\x92\xA2" => "\x47",
		"\xF0\x9D\x92\xA5" => "\x4A",
		"\xF0\x9D\x92\xA6" => "\x4B",
		"\xF0\x9D\x92\xA9" => "\x4E",
		"\xF0\x9D\x92\xAA" => "\x4F",
		"\xF0\x9D\x92\xAB" => "\x50",
		"\xF0\x9D\x92\xAC" => "\x51",
		"\xF0\x9D\x92\xAE" => "\x53",
		"\xF0\x9D\x92\xAF" => "\x54",
		"\xF0\x9D\x92\xB0" => "\x55",
		"\xF0\x9D\x92\xB1" => "\x56",
		"\xF0\x9D\x92\xB2" => "\x57",
		"\xF0\x9D\x92\xB3" => "\x58",
		"\xF0\x9D\x92\xB4" => "\x59",
		"\xF0\x9D\x92\xB5" => "\x5A",
		"\xF0\x9D\x92\xB6" => "\x61",
		"\xF0\x9D\x92\xB7" => "\x62",
		"\xF0\x9D\x92\xB8" => "\x63",
		"\xF0\x9D\x92\xB9" => "\x64",
		"\xF0\x9D\x92\xBB" => "\x66",
		"\xF0\x9D\x92\xBD" => "\x68",
		"\xF0\x9D\x92\xBE" => "\x69",
		"\xF0\x9D\x92\xBF" => "\x6A",
		"\xF0\x9D\x93\x80" => "\x6B",
		"\xF0\x9D\x93\x81" => "\x6C",
		"\xF0\x9D\x93\x82" => "\x6D",
		"\xF0\x9D\x93\x83" => "\x6E",
		"\xF0\x9D\x93\x85" => "\x70",
		"\xF0\x9D\x93\x86" => "\x71",
		"\xF0\x9D\x93\x87" => "\x72",
		"\xF0\x9D\x93\x88" => "\x73",
		"\xF0\x9D\x93\x89" => "\x74",
		"\xF0\x9D\x93\x8A" => "\x75",
		"\xF0\x9D\x93\x8B" => "\x76",
		"\xF0\x9D\x93\x8C" => "\x77",
		"\xF0\x9D\x93\x8D" => "\x78",
		"\xF0\x9D\x93\x8E" => "\x79",
		"\xF0\x9D\x93\x8F" => "\x7A",
		"\xF0\x9D\x93\x90" => "\x41",
		"\xF0\x9D\x93\x91" => "\x42",
		"\xF0\x9D\x93\x92" => "\x43",
		"\xF0\x9D\x93\x93" => "\x44",
		"\xF0\x9D\x93\x94" => "\x45",
		"\xF0\x9D\x93\x95" => "\x46",
		"\xF0\x9D\x93\x96" => "\x47",
		"\xF0\x9D\x93\x97" => "\x48",
		"\xF0\x9D\x93\x98" => "\x49",
		"\xF0\x9D\x93\x99" => "\x4A",
		"\xF0\x9D\x93\x9A" => "\x4B",
		"\xF0\x9D\x93\x9B" => "\x4C",
		"\xF0\x9D\x93\x9C" => "\x4D",
		"\xF0\x9D\x93\x9D" => "\x4E",
		"\xF0\x9D\x93\x9E" => "\x4F",
		"\xF0\x9D\x93\x9F" => "\x50",
		"\xF0\x9D\x93\xA0" => "\x51",
		"\xF0\x9D\x93\xA1" => "\x52",
		"\xF0\x9D\x93\xA2" => "\x53",
		"\xF0\x9D\x93\xA3" => "\x54",
		"\xF0\x9D\x93\xA4" => "\x55",
		"\xF0\x9D\x93\xA5" => "\x56",
		"\xF0\x9D\x93\xA6" => "\x57",
		"\xF0\x9D\x93\xA7" => "\x58",
		"\xF0\x9D\x93\xA8" => "\x59",
		"\xF0\x9D\x93\xA9" => "\x5A",
		"\xF0\x9D\x93\xAA" => "\x61",
		"\xF0\x9D\x93\xAB" => "\x62",
		"\xF0\x9D\x93\xAC" => "\x63",
		"\xF0\x9D\x93\xAD" => "\x64",
		"\xF0\x9D\x93\xAE" => "\x65",
		"\xF0\x9D\x93\xAF" => "\x66",
		"\xF0\x9D\x93\xB0" => "\x67",
		"\xF0\x9D\x93\xB1" => "\x68",
		"\xF0\x9D\x93\xB2" => "\x69",
		"\xF0\x9D\x93\xB3" => "\x6A",
		"\xF0\x9D\x93\xB4" => "\x6B",
		"\xF0\x9D\x93\xB5" => "\x6C",
		"\xF0\x9D\x93\xB6" => "\x6D",
		"\xF0\x9D\x93\xB7" => "\x6E",
		"\xF0\x9D\x93\xB8" => "\x6F",
		"\xF0\x9D\x93\xB9" => "\x70",
		"\xF0\x9D\x93\xBA" => "\x71",
		"\xF0\x9D\x93\xBB" => "\x72",
		"\xF0\x9D\x93\xBC" => "\x73",
		"\xF0\x9D\x93\xBD" => "\x74",
		"\xF0\x9D\x93\xBE" => "\x75",
		"\xF0\x9D\x93\xBF" => "\x76",
		"\xF0\x9D\x94\x80" => "\x77",
		"\xF0\x9D\x94\x81" => "\x78",
		"\xF0\x9D\x94\x82" => "\x79",
		"\xF0\x9D\x94\x83" => "\x7A",
		"\xF0\x9D\x94\x84" => "\x41",
		"\xF0\x9D\x94\x85" => "\x42",
		"\xF0\x9D\x94\x87" => "\x44",
		"\xF0\x9D\x94\x88" => "\x45",
		"\xF0\x9D\x94\x89" => "\x46",
		"\xF0\x9D\x94\x8A" => "\x47",
		"\xF0\x9D\x94\x8D" => "\x4A",
		"\xF0\x9D\x94\x8E" => "\x4B",
		"\xF0\x9D\x94\x8F" => "\x4C",
		"\xF0\x9D\x94\x90" => "\x4D",
		"\xF0\x9D\x94\x91" => "\x4E",
		"\xF0\x9D\x94\x92" => "\x4F",
		"\xF0\x9D\x94\x93" => "\x50",
		"\xF0\x9D\x94\x94" => "\x51",
		"\xF0\x9D\x94\x96" => "\x53",
		"\xF0\x9D\x94\x97" => "\x54",
		"\xF0\x9D\x94\x98" => "\x55",
		"\xF0\x9D\x94\x99" => "\x56",
		"\xF0\x9D\x94\x9A" => "\x57",
		"\xF0\x9D\x94\x9B" => "\x58",
		"\xF0\x9D\x94\x9C" => "\x59",
		"\xF0\x9D\x94\x9E" => "\x61",
		"\xF0\x9D\x94\x9F" => "\x62",
		"\xF0\x9D\x94\xA0" => "\x63",
		"\xF0\x9D\x94\xA1" => "\x64",
		"\xF0\x9D\x94\xA2" => "\x65",
		"\xF0\x9D\x94\xA3" => "\x66",
		"\xF0\x9D\x94\xA4" => "\x67",
		"\xF0\x9D\x94\xA5" => "\x68",
		"\xF0\x9D\x94\xA6" => "\x69",
		"\xF0\x9D\x94\xA7" => "\x6A",
		"\xF0\x9D\x94\xA8" => "\x6B",
		"\xF0\x9D\x94\xA9" => "\x6C",
		"\xF0\x9D\x94\xAA" => "\x6D",
		"\xF0\x9D\x94\xAB" => "\x6E",
		"\xF0\x9D\x94\xAC" => "\x6F",
		"\xF0\x9D\x94\xAD" => "\x70",
		"\xF0\x9D\x94\xAE" => "\x71",
		"\xF0\x9D\x94\xAF" => "\x72",
		"\xF0\x9D\x94\xB0" => "\x73",
		"\xF0\x9D\x94\xB1" => "\x74",
		"\xF0\x9D\x94\xB2" => "\x75",
		"\xF0\x9D\x94\xB3" => "\x76",
		"\xF0\x9D\x94\xB4" => "\x77",
		"\xF0\x9D\x94\xB5" => "\x78",
		"\xF0\x9D\x94\xB6" => "\x79",
		"\xF0\x9D\x94\xB7" => "\x7A",
		"\xF0\x9D\x94\xB8" => "\x41",
		"\xF0\x9D\x94\xB9" => "\x42",
		"\xF0\x9D\x94\xBB" => "\x44",
		"\xF0\x9D\x94\xBC" => "\x45",
		"\xF0\x9D\x94\xBD" => "\x46",
		"\xF0\x9D\x94\xBE" => "\x47",
		"\xF0\x9D\x95\x80" => "\x49",
		"\xF0\x9D\x95\x81" => "\x4A",
		"\xF0\x9D\x95\x82" => "\x4B",
		"\xF0\x9D\x95\x83" => "\x4C",
		"\xF0\x9D\x95\x84" => "\x4D",
		"\xF0\x9D\x95\x86" => "\x4F",
		"\xF0\x9D\x95\x8A" => "\x53",
		"\xF0\x9D\x95\x8B" => "\x54",
		"\xF0\x9D\x95\x8C" => "\x55",
		"\xF0\x9D\x95\x8D" => "\x56",
		"\xF0\x9D\x95\x8E" => "\x57",
		"\xF0\x9D\x95\x8F" => "\x58",
		"\xF0\x9D\x95\x90" => "\x59",
		"\xF0\x9D\x95\x92" => "\x61",
		"\xF0\x9D\x95\x93" => "\x62",
		"\xF0\x9D\x95\x94" => "\x63",
		"\xF0\x9D\x95\x95" => "\x64",
		"\xF0\x9D\x95\x96" => "\x65",
		"\xF0\x9D\x95\x97" => "\x66",
		"\xF0\x9D\x95\x98" => "\x67",
		"\xF0\x9D\x95\x99" => "\x68",
		"\xF0\x9D\x95\x9A" => "\x69",
		"\xF0\x9D\x95\x9B" => "\x6A",
		"\xF0\x9D\x95\x9C" => "\x6B",
		"\xF0\x9D\x95\x9D" => "\x6C",
		"\xF0\x9D\x95\x9E" => "\x6D",
		"\xF0\x9D\x95\x9F" => "\x6E",
		"\xF0\x9D\x95\xA0" => "\x6F",
		"\xF0\x9D\x95\xA1" => "\x70",
		"\xF0\x9D\x95\xA2" => "\x71",
		"\xF0\x9D\x95\xA3" => "\x72",
		"\xF0\x9D\x95\xA4" => "\x73",
		"\xF0\x9D\x95\xA5" => "\x74",
		"\xF0\x9D\x95\xA6" => "\x75",
		"\xF0\x9D\x95\xA7" => "\x76",
		"\xF0\x9D\x95\xA8" => "\x77",
		"\xF0\x9D\x95\xA9" => "\x78",
		"\xF0\x9D\x95\xAA" => "\x79",
		"\xF0\x9D\x95\xAB" => "\x7A",
		"\xF0\x9D\x95\xAC" => "\x41",
		"\xF0\x9D\x95\xAD" => "\x42",
		"\xF0\x9D\x95\xAE" => "\x43",
		"\xF0\x9D\x95\xAF" => "\x44",
		"\xF0\x9D\x95\xB0" => "\x45",
		"\xF0\x9D\x95\xB1" => "\x46",
		"\xF0\x9D\x95\xB2" => "\x47",
		"\xF0\x9D\x95\xB3" => "\x48",
		"\xF0\x9D\x95\xB4" => "\x49",
		"\xF0\x9D\x95\xB5" => "\x4A",
		"\xF0\x9D\x95\xB6" => "\x4B",
		"\xF0\x9D\x95\xB7" => "\x4C",
		"\xF0\x9D\x95\xB8" => "\x4D",
		"\xF0\x9D\x95\xB9" => "\x4E",
		"\xF0\x9D\x95\xBA" => "\x4F",
		"\xF0\x9D\x95\xBB" => "\x50",
		"\xF0\x9D\x95\xBC" => "\x51",
		"\xF0\x9D\x95\xBD" => "\x52",
		"\xF0\x9D\x95\xBE" => "\x53",
		"\xF0\x9D\x95\xBF" => "\x54",
		"\xF0\x9D\x96\x80" => "\x55",
		"\xF0\x9D\x96\x81" => "\x56",
		"\xF0\x9D\x96\x82" => "\x57",
		"\xF0\x9D\x96\x83" => "\x58",
		"\xF0\x9D\x96\x84" => "\x59",
		"\xF0\x9D\x96\x85" => "\x5A",
		"\xF0\x9D\x96\x86" => "\x61",
		"\xF0\x9D\x96\x87" => "\x62",
		"\xF0\x9D\x96\x88" => "\x63",
		"\xF0\x9D\x96\x89" => "\x64",
		"\xF0\x9D\x96\x8A" => "\x65",
		"\xF0\x9D\x96\x8B" => "\x66",
		"\xF0\x9D\x96\x8C" => "\x67",
		"\xF0\x9D\x96\x8D" => "\x68",
		"\xF0\x9D\x96\x8E" => "\x69",
		"\xF0\x9D\x96\x8F" => "\x6A",
		"\xF0\x9D\x96\x90" => "\x6B",
		"\xF0\x9D\x96\x91" => "\x6C",
		"\xF0\x9D\x96\x92" => "\x6D",
		"\xF0\x9D\x96\x93" => "\x6E",
		"\xF0\x9D\x96\x94" => "\x6F",
		"\xF0\x9D\x96\x95" => "\x70",
		"\xF0\x9D\x96\x96" => "\x71",
		"\xF0\x9D\x96\x97" => "\x72",
		"\xF0\x9D\x96\x98" => "\x73",
		"\xF0\x9D\x96\x99" => "\x74",
		"\xF0\x9D\x96\x9A" => "\x75",
		"\xF0\x9D\x96\x9B" => "\x76",
		"\xF0\x9D\x96\x9C" => "\x77",
		"\xF0\x9D\x96\x9D" => "\x78",
		"\xF0\x9D\x96\x9E" => "\x79",
		"\xF0\x9D\x96\x9F" => "\x7A",
		"\xF0\x9D\x96\xA0" => "\x41",
		"\xF0\x9D\x96\xA1" => "\x42",
		"\xF0\x9D\x96\xA2" => "\x43",
		"\xF0\x9D\x96\xA3" => "\x44",
		"\xF0\x9D\x96\xA4" => "\x45",
		"\xF0\x9D\x96\xA5" => "\x46",
		"\xF0\x9D\x96\xA6" => "\x47",
		"\xF0\x9D\x96\xA7" => "\x48",
		"\xF0\x9D\x96\xA8" => "\x49",
		"\xF0\x9D\x96\xA9" => "\x4A",
		"\xF0\x9D\x96\xAA" => "\x4B",
		"\xF0\x9D\x96\xAB" => "\x4C",
		"\xF0\x9D\x96\xAC" => "\x4D",
		"\xF0\x9D\x96\xAD" => "\x4E",
		"\xF0\x9D\x96\xAE" => "\x4F",
		"\xF0\x9D\x96\xAF" => "\x50",
		"\xF0\x9D\x96\xB0" => "\x51",
		"\xF0\x9D\x96\xB1" => "\x52",
		"\xF0\x9D\x96\xB2" => "\x53",
		"\xF0\x9D\x96\xB3" => "\x54",
		"\xF0\x9D\x96\xB4" => "\x55",
		"\xF0\x9D\x96\xB5" => "\x56",
		"\xF0\x9D\x96\xB6" => "\x57",
		"\xF0\x9D\x96\xB7" => "\x58",
		"\xF0\x9D\x96\xB8" => "\x59",
		"\xF0\x9D\x96\xB9" => "\x5A",
		"\xF0\x9D\x96\xBA" => "\x61",
		"\xF0\x9D\x96\xBB" => "\x62",
		"\xF0\x9D\x96\xBC" => "\x63",
		"\xF0\x9D\x96\xBD" => "\x64",
		"\xF0\x9D\x96\xBE" => "\x65",
		"\xF0\x9D\x96\xBF" => "\x66",
		"\xF0\x9D\x97\x80" => "\x67",
		"\xF0\x9D\x97\x81" => "\x68",
		"\xF0\x9D\x97\x82" => "\x69",
		"\xF0\x9D\x97\x83" => "\x6A",
		"\xF0\x9D\x97\x84" => "\x6B",
		"\xF0\x9D\x97\x85" => "\x6C",
		"\xF0\x9D\x97\x86" => "\x6D",
		"\xF0\x9D\x97\x87" => "\x6E",
		"\xF0\x9D\x97\x88" => "\x6F",
		"\xF0\x9D\x97\x89" => "\x70",
		"\xF0\x9D\x97\x8A" => "\x71",
		"\xF0\x9D\x97\x8B" => "\x72",
		"\xF0\x9D\x97\x8C" => "\x73",
		"\xF0\x9D\x97\x8D" => "\x74",
		"\xF0\x9D\x97\x8E" => "\x75",
		"\xF0\x9D\x97\x8F" => "\x76",
		"\xF0\x9D\x97\x90" => "\x77",
		"\xF0\x9D\x97\x91" => "\x78",
		"\xF0\x9D\x97\x92" => "\x79",
		"\xF0\x9D\x97\x93" => "\x7A",
		"\xF0\x9D\x97\x94" => "\x41",
		"\xF0\x9D\x97\x95" => "\x42",
		"\xF0\x9D\x97\x96" => "\x43",
		"\xF0\x9D\x97\x97" => "\x44",
		"\xF0\x9D\x97\x98" => "\x45",
		"\xF0\x9D\x97\x99" => "\x46",
		"\xF0\x9D\x97\x9A" => "\x47",
		"\xF0\x9D\x97\x9B" => "\x48",
		"\xF0\x9D\x97\x9C" => "\x49",
		"\xF0\x9D\x97\x9D" => "\x4A",
		"\xF0\x9D\x97\x9E" => "\x4B",
		"\xF0\x9D\x97\x9F" => "\x4C",
		"\xF0\x9D\x97\xA0" => "\x4D",
		"\xF0\x9D\x97\xA1" => "\x4E",
		"\xF0\x9D\x97\xA2" => "\x4F",
		"\xF0\x9D\x97\xA3" => "\x50",
		"\xF0\x9D\x97\xA4" => "\x51",
		"\xF0\x9D\x97\xA5" => "\x52",
		"\xF0\x9D\x97\xA6" => "\x53",
		"\xF0\x9D\x97\xA7" => "\x54",
		"\xF0\x9D\x97\xA8" => "\x55",
		"\xF0\x9D\x97\xA9" => "\x56",
		"\xF0\x9D\x97\xAA" => "\x57",
		"\xF0\x9D\x97\xAB" => "\x58",
		"\xF0\x9D\x97\xAC" => "\x59",
		"\xF0\x9D\x97\xAD" => "\x5A",
		"\xF0\x9D\x97\xAE" => "\x61",
		"\xF0\x9D\x97\xAF" => "\x62",
		"\xF0\x9D\x97\xB0" => "\x63",
		"\xF0\x9D\x97\xB1" => "\x64",
		"\xF0\x9D\x97\xB2" => "\x65",
		"\xF0\x9D\x97\xB3" => "\x66",
		"\xF0\x9D\x97\xB4" => "\x67",
		"\xF0\x9D\x97\xB5" => "\x68",
		"\xF0\x9D\x97\xB6" => "\x69",
		"\xF0\x9D\x97\xB7" => "\x6A",
		"\xF0\x9D\x97\xB8" => "\x6B",
		"\xF0\x9D\x97\xB9" => "\x6C",
		"\xF0\x9D\x97\xBA" => "\x6D",
		"\xF0\x9D\x97\xBB" => "\x6E",
		"\xF0\x9D\x97\xBC" => "\x6F",
		"\xF0\x9D\x97\xBD" => "\x70",
		"\xF0\x9D\x97\xBE" => "\x71",
		"\xF0\x9D\x97\xBF" => "\x72",
		"\xF0\x9D\x98\x80" => "\x73",
		"\xF0\x9D\x98\x81" => "\x74",
		"\xF0\x9D\x98\x82" => "\x75",
		"\xF0\x9D\x98\x83" => "\x76",
		"\xF0\x9D\x98\x84" => "\x77",
		"\xF0\x9D\x98\x85" => "\x78",
		"\xF0\x9D\x98\x86" => "\x79",
		"\xF0\x9D\x98\x87" => "\x7A",
		"\xF0\x9D\x98\x88" => "\x41",
		"\xF0\x9D\x98\x89" => "\x42",
		"\xF0\x9D\x98\x8A" => "\x43",
		"\xF0\x9D\x98\x8B" => "\x44",
		"\xF0\x9D\x98\x8C" => "\x45",
		"\xF0\x9D\x98\x8D" => "\x46",
		"\xF0\x9D\x98\x8E" => "\x47",
		"\xF0\x9D\x98\x8F" => "\x48",
		"\xF0\x9D\x98\x90" => "\x49",
		"\xF0\x9D\x98\x91" => "\x4A",
		"\xF0\x9D\x98\x92" => "\x4B",
		"\xF0\x9D\x98\x93" => "\x4C",
		"\xF0\x9D\x98\x94" => "\x4D",
		"\xF0\x9D\x98\x95" => "\x4E",
		"\xF0\x9D\x98\x96" => "\x4F",
		"\xF0\x9D\x98\x97" => "\x50",
		"\xF0\x9D\x98\x98" => "\x51",
		"\xF0\x9D\x98\x99" => "\x52",
		"\xF0\x9D\x98\x9A" => "\x53",
		"\xF0\x9D\x98\x9B" => "\x54",
		"\xF0\x9D\x98\x9C" => "\x55",
		"\xF0\x9D\x98\x9D" => "\x56",
		"\xF0\x9D\x98\x9E" => "\x57",
		"\xF0\x9D\x98\x9F" => "\x58",
		"\xF0\x9D\x98\xA0" => "\x59",
		"\xF0\x9D\x98\xA1" => "\x5A",
		"\xF0\x9D\x98\xA2" => "\x61",
		"\xF0\x9D\x98\xA3" => "\x62",
		"\xF0\x9D\x98\xA4" => "\x63",
		"\xF0\x9D\x98\xA5" => "\x64",
		"\xF0\x9D\x98\xA6" => "\x65",
		"\xF0\x9D\x98\xA7" => "\x66",
		"\xF0\x9D\x98\xA8" => "\x67",
		"\xF0\x9D\x98\xA9" => "\x68",
		"\xF0\x9D\x98\xAA" => "\x69",
		"\xF0\x9D\x98\xAB" => "\x6A",
		"\xF0\x9D\x98\xAC" => "\x6B",
		"\xF0\x9D\x98\xAD" => "\x6C",
		"\xF0\x9D\x98\xAE" => "\x6D",
		"\xF0\x9D\x98\xAF" => "\x6E",
		"\xF0\x9D\x98\xB0" => "\x6F",
		"\xF0\x9D\x98\xB1" => "\x70",
		"\xF0\x9D\x98\xB2" => "\x71",
		"\xF0\x9D\x98\xB3" => "\x72",
		"\xF0\x9D\x98\xB4" => "\x73",
		"\xF0\x9D\x98\xB5" => "\x74",
		"\xF0\x9D\x98\xB6" => "\x75",
		"\xF0\x9D\x98\xB7" => "\x76",
		"\xF0\x9D\x98\xB8" => "\x77",
		"\xF0\x9D\x98\xB9" => "\x78",
		"\xF0\x9D\x98\xBA" => "\x79",
		"\xF0\x9D\x98\xBB" => "\x7A",
		"\xF0\x9D\x98\xBC" => "\x41",
		"\xF0\x9D\x98\xBD" => "\x42",
		"\xF0\x9D\x98\xBE" => "\x43",
		"\xF0\x9D\x98\xBF" => "\x44",
		"\xF0\x9D\x99\x80" => "\x45",
		"\xF0\x9D\x99\x81" => "\x46",
		"\xF0\x9D\x99\x82" => "\x47",
		"\xF0\x9D\x99\x83" => "\x48",
		"\xF0\x9D\x99\x84" => "\x49",
		"\xF0\x9D\x99\x85" => "\x4A",
		"\xF0\x9D\x99\x86" => "\x4B",
		"\xF0\x9D\x99\x87" => "\x4C",
		"\xF0\x9D\x99\x88" => "\x4D",
		"\xF0\x9D\x99\x89" => "\x4E",
		"\xF0\x9D\x99\x8A" => "\x4F",
		"\xF0\x9D\x99\x8B" => "\x50",
		"\xF0\x9D\x99\x8C" => "\x51",
		"\xF0\x9D\x99\x8D" => "\x52",
		"\xF0\x9D\x99\x8E" => "\x53",
		"\xF0\x9D\x99\x8F" => "\x54",
		"\xF0\x9D\x99\x90" => "\x55",
		"\xF0\x9D\x99\x91" => "\x56",
		"\xF0\x9D\x99\x92" => "\x57",
		"\xF0\x9D\x99\x93" => "\x58",
		"\xF0\x9D\x99\x94" => "\x59",
		"\xF0\x9D\x99\x95" => "\x5A",
		"\xF0\x9D\x99\x96" => "\x61",
		"\xF0\x9D\x99\x97" => "\x62",
		"\xF0\x9D\x99\x98" => "\x63",
		"\xF0\x9D\x99\x99" => "\x64",
		"\xF0\x9D\x99\x9A" => "\x65",
		"\xF0\x9D\x99\x9B" => "\x66",
		"\xF0\x9D\x99\x9C" => "\x67",
		"\xF0\x9D\x99\x9D" => "\x68",
		"\xF0\x9D\x99\x9E" => "\x69",
		"\xF0\x9D\x99\x9F" => "\x6A",
		"\xF0\x9D\x99\xA0" => "\x6B",
		"\xF0\x9D\x99\xA1" => "\x6C",
		"\xF0\x9D\x99\xA2" => "\x6D",
		"\xF0\x9D\x99\xA3" => "\x6E",
		"\xF0\x9D\x99\xA4" => "\x6F",
		"\xF0\x9D\x99\xA5" => "\x70",
		"\xF0\x9D\x99\xA6" => "\x71",
		"\xF0\x9D\x99\xA7" => "\x72",
		"\xF0\x9D\x99\xA8" => "\x73",
		"\xF0\x9D\x99\xA9" => "\x74",
		"\xF0\x9D\x99\xAA" => "\x75",
		"\xF0\x9D\x99\xAB" => "\x76",
		"\xF0\x9D\x99\xAC" => "\x77",
		"\xF0\x9D\x99\xAD" => "\x78",
		"\xF0\x9D\x99\xAE" => "\x79",
		"\xF0\x9D\x99\xAF" => "\x7A",
		"\xF0\x9D\x99\xB0" => "\x41",
		"\xF0\x9D\x99\xB1" => "\x42",
		"\xF0\x9D\x99\xB2" => "\x43",
		"\xF0\x9D\x99\xB3" => "\x44",
		"\xF0\x9D\x99\xB4" => "\x45",
		"\xF0\x9D\x99\xB5" => "\x46",
		"\xF0\x9D\x99\xB6" => "\x47",
		"\xF0\x9D\x99\xB7" => "\x48",
		"\xF0\x9D\x99\xB8" => "\x49",
		"\xF0\x9D\x99\xB9" => "\x4A",
		"\xF0\x9D\x99\xBA" => "\x4B",
		"\xF0\x9D\x99\xBB" => "\x4C",
		"\xF0\x9D\x99\xBC" => "\x4D",
		"\xF0\x9D\x99\xBD" => "\x4E",
		"\xF0\x9D\x99\xBE" => "\x4F",
		"\xF0\x9D\x99\xBF" => "\x50",
		"\xF0\x9D\x9A\x80" => "\x51",
		"\xF0\x9D\x9A\x81" => "\x52",
		"\xF0\x9D\x9A\x82" => "\x53",
		"\xF0\x9D\x9A\x83" => "\x54",
		"\xF0\x9D\x9A\x84" => "\x55",
		"\xF0\x9D\x9A\x85" => "\x56",
		"\xF0\x9D\x9A\x86" => "\x57",
		"\xF0\x9D\x9A\x87" => "\x58",
		"\xF0\x9D\x9A\x88" => "\x59",
		"\xF0\x9D\x9A\x89" => "\x5A",
		"\xF0\x9D\x9A\x8A" => "\x61",
		"\xF0\x9D\x9A\x8B" => "\x62",
		"\xF0\x9D\x9A\x8C" => "\x63",
		"\xF0\x9D\x9A\x8D" => "\x64",
		"\xF0\x9D\x9A\x8E" => "\x65",
		"\xF0\x9D\x9A\x8F" => "\x66",
		"\xF0\x9D\x9A\x90" => "\x67",
		"\xF0\x9D\x9A\x91" => "\x68",
		"\xF0\x9D\x9A\x92" => "\x69",
		"\xF0\x9D\x9A\x93" => "\x6A",
		"\xF0\x9D\x9A\x94" => "\x6B",
		"\xF0\x9D\x9A\x95" => "\x6C",
		"\xF0\x9D\x9A\x96" => "\x6D",
		"\xF0\x9D\x9A\x97" => "\x6E",
		"\xF0\x9D\x9A\x98" => "\x6F",
		"\xF0\x9D\x9A\x99" => "\x70",
		"\xF0\x9D\x9A\x9A" => "\x71",
		"\xF0\x9D\x9A\x9B" => "\x72",
		"\xF0\x9D\x9A\x9C" => "\x73",
		"\xF0\x9D\x9A\x9D" => "\x74",
		"\xF0\x9D\x9A\x9E" => "\x75",
		"\xF0\x9D\x9A\x9F" => "\x76",
		"\xF0\x9D\x9A\xA0" => "\x77",
		"\xF0\x9D\x9A\xA1" => "\x78",
		"\xF0\x9D\x9A\xA2" => "\x79",
		"\xF0\x9D\x9A\xA3" => "\x7A",
		"\xF0\x9D\x9A\xA4" => "\xC4\xB1",
		"\xF0\x9D\x9A\xA5" => "\xC8\xB7",
		"\xF0\x9D\x9A\xA8" => "\xCE\x91",
		"\xF0\x9D\x9A\xA9" => "\xCE\x92",
		"\xF0\x9D\x9A\xAA" => "\xCE\x93",
		"\xF0\x9D\x9A\xAB" => "\xCE\x94",
		"\xF0\x9D\x9A\xAC" => "\xCE\x95",
		"\xF0\x9D\x9A\xAD" => "\xCE\x96",
		"\xF0\x9D\x9A\xAE" => "\xCE\x97",
		"\xF0\x9D\x9A\xAF" => "\xCE\x98",
		"\xF0\x9D\x9A\xB0" => "\xCE\x99",
		"\xF0\x9D\x9A\xB1" => "\xCE\x9A",
		"\xF0\x9D\x9A\xB2" => "\xCE\x9B",
		"\xF0\x9D\x9A\xB3" => "\xCE\x9C",
		"\xF0\x9D\x9A\xB4" => "\xCE\x9D",
		"\xF0\x9D\x9A\xB5" => "\xCE\x9E",
		"\xF0\x9D\x9A\xB6" => "\xCE\x9F",
		"\xF0\x9D\x9A\xB7" => "\xCE\xA0",
		"\xF0\x9D\x9A\xB8" => "\xCE\xA1",
		"\xF0\x9D\x9A\xB9" => "\xCE\x98",
		"\xF0\x9D\x9A\xBA" => "\xCE\xA3",
		"\xF0\x9D\x9A\xBB" => "\xCE\xA4",
		"\xF0\x9D\x9A\xBC" => "\xCE\xA5",
		"\xF0\x9D\x9A\xBD" => "\xCE\xA6",
		"\xF0\x9D\x9A\xBE" => "\xCE\xA7",
		"\xF0\x9D\x9A\xBF" => "\xCE\xA8",
		"\xF0\x9D\x9B\x80" => "\xCE\xA9",
		"\xF0\x9D\x9B\x81" => "\xE2\x88\x87",
		"\xF0\x9D\x9B\x82" => "\xCE\xB1",
		"\xF0\x9D\x9B\x83" => "\xCE\xB2",
		"\xF0\x9D\x9B\x84" => "\xCE\xB3",
		"\xF0\x9D\x9B\x85" => "\xCE\xB4",
		"\xF0\x9D\x9B\x86" => "\xCE\xB5",
		"\xF0\x9D\x9B\x87" => "\xCE\xB6",
		"\xF0\x9D\x9B\x88" => "\xCE\xB7",
		"\xF0\x9D\x9B\x89" => "\xCE\xB8",
		"\xF0\x9D\x9B\x8A" => "\xCE\xB9",
		"\xF0\x9D\x9B\x8B" => "\xCE\xBA",
		"\xF0\x9D\x9B\x8C" => "\xCE\xBB",
		"\xF0\x9D\x9B\x8D" => "\xCE\xBC",
		"\xF0\x9D\x9B\x8E" => "\xCE\xBD",
		"\xF0\x9D\x9B\x8F" => "\xCE\xBE",
		"\xF0\x9D\x9B\x90" => "\xCE\xBF",
		"\xF0\x9D\x9B\x91" => "\xCF\x80",
		"\xF0\x9D\x9B\x92" => "\xCF\x81",
		"\xF0\x9D\x9B\x93" => "\xCF\x82",
		"\xF0\x9D\x9B\x94" => "\xCF\x83",
		"\xF0\x9D\x9B\x95" => "\xCF\x84",
		"\xF0\x9D\x9B\x96" => "\xCF\x85",
		"\xF0\x9D\x9B\x97" => "\xCF\x86",
		"\xF0\x9D\x9B\x98" => "\xCF\x87",
		"\xF0\x9D\x9B\x99" => "\xCF\x88",
		"\xF0\x9D\x9B\x9A" => "\xCF\x89",
		"\xF0\x9D\x9B\x9B" => "\xE2\x88\x82",
		"\xF0\x9D\x9B\x9C" => "\xCE\xB5",
		"\xF0\x9D\x9B\x9D" => "\xCE\xB8",
		"\xF0\x9D\x9B\x9E" => "\xCE\xBA",
		"\xF0\x9D\x9B\x9F" => "\xCF\x86",
		"\xF0\x9D\x9B\xA0" => "\xCF\x81",
		"\xF0\x9D\x9B\xA1" => "\xCF\x80",
		"\xF0\x9D\x9B\xA2" => "\xCE\x91",
		"\xF0\x9D\x9B\xA3" => "\xCE\x92",
		"\xF0\x9D\x9B\xA4" => "\xCE\x93",
		"\xF0\x9D\x9B\xA5" => "\xCE\x94",
		"\xF0\x9D\x9B\xA6" => "\xCE\x95",
		"\xF0\x9D\x9B\xA7" => "\xCE\x96",
		"\xF0\x9D\x9B\xA8" => "\xCE\x97",
		"\xF0\x9D\x9B\xA9" => "\xCE\x98",
		"\xF0\x9D\x9B\xAA" => "\xCE\x99",
		"\xF0\x9D\x9B\xAB" => "\xCE\x9A",
		"\xF0\x9D\x9B\xAC" => "\xCE\x9B",
		"\xF0\x9D\x9B\xAD" => "\xCE\x9C",
		"\xF0\x9D\x9B\xAE" => "\xCE\x9D",
		"\xF0\x9D\x9B\xAF" => "\xCE\x9E",
		"\xF0\x9D\x9B\xB0" => "\xCE\x9F",
		"\xF0\x9D\x9B\xB1" => "\xCE\xA0",
		"\xF0\x9D\x9B\xB2" => "\xCE\xA1",
		"\xF0\x9D\x9B\xB3" => "\xCE\x98",
		"\xF0\x9D\x9B\xB4" => "\xCE\xA3",
		"\xF0\x9D\x9B\xB5" => "\xCE\xA4",
		"\xF0\x9D\x9B\xB6" => "\xCE\xA5",
		"\xF0\x9D\x9B\xB7" => "\xCE\xA6",
		"\xF0\x9D\x9B\xB8" => "\xCE\xA7",
		"\xF0\x9D\x9B\xB9" => "\xCE\xA8",
		"\xF0\x9D\x9B\xBA" => "\xCE\xA9",
		"\xF0\x9D\x9B\xBB" => "\xE2\x88\x87",
		"\xF0\x9D\x9B\xBC" => "\xCE\xB1",
		"\xF0\x9D\x9B\xBD" => "\xCE\xB2",
		"\xF0\x9D\x9B\xBE" => "\xCE\xB3",
		"\xF0\x9D\x9B\xBF" => "\xCE\xB4",
		"\xF0\x9D\x9C\x80" => "\xCE\xB5",
		"\xF0\x9D\x9C\x81" => "\xCE\xB6",
		"\xF0\x9D\x9C\x82" => "\xCE\xB7",
		"\xF0\x9D\x9C\x83" => "\xCE\xB8",
		"\xF0\x9D\x9C\x84" => "\xCE\xB9",
		"\xF0\x9D\x9C\x85" => "\xCE\xBA",
		"\xF0\x9D\x9C\x86" => "\xCE\xBB",
		"\xF0\x9D\x9C\x87" => "\xCE\xBC",
		"\xF0\x9D\x9C\x88" => "\xCE\xBD",
		"\xF0\x9D\x9C\x89" => "\xCE\xBE",
		"\xF0\x9D\x9C\x8A" => "\xCE\xBF",
		"\xF0\x9D\x9C\x8B" => "\xCF\x80",
		"\xF0\x9D\x9C\x8C" => "\xCF\x81",
		"\xF0\x9D\x9C\x8D" => "\xCF\x82",
		"\xF0\x9D\x9C\x8E" => "\xCF\x83",
		"\xF0\x9D\x9C\x8F" => "\xCF\x84",
		"\xF0\x9D\x9C\x90" => "\xCF\x85",
		"\xF0\x9D\x9C\x91" => "\xCF\x86",
		"\xF0\x9D\x9C\x92" => "\xCF\x87",
		"\xF0\x9D\x9C\x93" => "\xCF\x88",
		"\xF0\x9D\x9C\x94" => "\xCF\x89",
		"\xF0\x9D\x9C\x95" => "\xE2\x88\x82",
		"\xF0\x9D\x9C\x96" => "\xCE\xB5",
		"\xF0\x9D\x9C\x97" => "\xCE\xB8",
		"\xF0\x9D\x9C\x98" => "\xCE\xBA",
		"\xF0\x9D\x9C\x99" => "\xCF\x86",
		"\xF0\x9D\x9C\x9A" => "\xCF\x81",
		"\xF0\x9D\x9C\x9B" => "\xCF\x80",
		"\xF0\x9D\x9C\x9C" => "\xCE\x91",
		"\xF0\x9D\x9C\x9D" => "\xCE\x92",
		"\xF0\x9D\x9C\x9E" => "\xCE\x93",
		"\xF0\x9D\x9C\x9F" => "\xCE\x94",
		"\xF0\x9D\x9C\xA0" => "\xCE\x95",
		"\xF0\x9D\x9C\xA1" => "\xCE\x96",
		"\xF0\x9D\x9C\xA2" => "\xCE\x97",
		"\xF0\x9D\x9C\xA3" => "\xCE\x98",
		"\xF0\x9D\x9C\xA4" => "\xCE\x99",
		"\xF0\x9D\x9C\xA5" => "\xCE\x9A",
		"\xF0\x9D\x9C\xA6" => "\xCE\x9B",
		"\xF0\x9D\x9C\xA7" => "\xCE\x9C",
		"\xF0\x9D\x9C\xA8" => "\xCE\x9D",
		"\xF0\x9D\x9C\xA9" => "\xCE\x9E",
		"\xF0\x9D\x9C\xAA" => "\xCE\x9F",
		"\xF0\x9D\x9C\xAB" => "\xCE\xA0",
		"\xF0\x9D\x9C\xAC" => "\xCE\xA1",
		"\xF0\x9D\x9C\xAD" => "\xCE\x98",
		"\xF0\x9D\x9C\xAE" => "\xCE\xA3",
		"\xF0\x9D\x9C\xAF" => "\xCE\xA4",
		"\xF0\x9D\x9C\xB0" => "\xCE\xA5",
		"\xF0\x9D\x9C\xB1" => "\xCE\xA6",
		"\xF0\x9D\x9C\xB2" => "\xCE\xA7",
		"\xF0\x9D\x9C\xB3" => "\xCE\xA8",
		"\xF0\x9D\x9C\xB4" => "\xCE\xA9",
		"\xF0\x9D\x9C\xB5" => "\xE2\x88\x87",
		"\xF0\x9D\x9C\xB6" => "\xCE\xB1",
		"\xF0\x9D\x9C\xB7" => "\xCE\xB2",
		"\xF0\x9D\x9C\xB8" => "\xCE\xB3",
		"\xF0\x9D\x9C\xB9" => "\xCE\xB4",
		"\xF0\x9D\x9C\xBA" => "\xCE\xB5",
		"\xF0\x9D\x9C\xBB" => "\xCE\xB6",
		"\xF0\x9D\x9C\xBC" => "\xCE\xB7",
		"\xF0\x9D\x9C\xBD" => "\xCE\xB8",
		"\xF0\x9D\x9C\xBE" => "\xCE\xB9",
		"\xF0\x9D\x9C\xBF" => "\xCE\xBA",
		"\xF0\x9D\x9D\x80" => "\xCE\xBB",
		"\xF0\x9D\x9D\x81" => "\xCE\xBC",
		"\xF0\x9D\x9D\x82" => "\xCE\xBD",
		"\xF0\x9D\x9D\x83" => "\xCE\xBE",
		"\xF0\x9D\x9D\x84" => "\xCE\xBF",
		"\xF0\x9D\x9D\x85" => "\xCF\x80",
		"\xF0\x9D\x9D\x86" => "\xCF\x81",
		"\xF0\x9D\x9D\x87" => "\xCF\x82",
		"\xF0\x9D\x9D\x88" => "\xCF\x83",
		"\xF0\x9D\x9D\x89" => "\xCF\x84",
		"\xF0\x9D\x9D\x8A" => "\xCF\x85",
		"\xF0\x9D\x9D\x8B" => "\xCF\x86",
		"\xF0\x9D\x9D\x8C" => "\xCF\x87",
		"\xF0\x9D\x9D\x8D" => "\xCF\x88",
		"\xF0\x9D\x9D\x8E" => "\xCF\x89",
		"\xF0\x9D\x9D\x8F" => "\xE2\x88\x82",
		"\xF0\x9D\x9D\x90" => "\xCE\xB5",
		"\xF0\x9D\x9D\x91" => "\xCE\xB8",
		"\xF0\x9D\x9D\x92" => "\xCE\xBA",
		"\xF0\x9D\x9D\x93" => "\xCF\x86",
		"\xF0\x9D\x9D\x94" => "\xCF\x81",
		"\xF0\x9D\x9D\x95" => "\xCF\x80",
		"\xF0\x9D\x9D\x96" => "\xCE\x91",
		"\xF0\x9D\x9D\x97" => "\xCE\x92",
		"\xF0\x9D\x9D\x98" => "\xCE\x93",
		"\xF0\x9D\x9D\x99" => "\xCE\x94",
		"\xF0\x9D\x9D\x9A" => "\xCE\x95",
		"\xF0\x9D\x9D\x9B" => "\xCE\x96",
		"\xF0\x9D\x9D\x9C" => "\xCE\x97",
		"\xF0\x9D\x9D\x9D" => "\xCE\x98",
		"\xF0\x9D\x9D\x9E" => "\xCE\x99",
		"\xF0\x9D\x9D\x9F" => "\xCE\x9A",
		"\xF0\x9D\x9D\xA0" => "\xCE\x9B",
		"\xF0\x9D\x9D\xA1" => "\xCE\x9C",
		"\xF0\x9D\x9D\xA2" => "\xCE\x9D",
		"\xF0\x9D\x9D\xA3" => "\xCE\x9E",
		"\xF0\x9D\x9D\xA4" => "\xCE\x9F",
		"\xF0\x9D\x9D\xA5" => "\xCE\xA0",
		"\xF0\x9D\x9D\xA6" => "\xCE\xA1",
		"\xF0\x9D\x9D\xA7" => "\xCE\x98",
		"\xF0\x9D\x9D\xA8" => "\xCE\xA3",
		"\xF0\x9D\x9D\xA9" => "\xCE\xA4",
		"\xF0\x9D\x9D\xAA" => "\xCE\xA5",
		"\xF0\x9D\x9D\xAB" => "\xCE\xA6",
		"\xF0\x9D\x9D\xAC" => "\xCE\xA7",
		"\xF0\x9D\x9D\xAD" => "\xCE\xA8",
		"\xF0\x9D\x9D\xAE" => "\xCE\xA9",
		"\xF0\x9D\x9D\xAF" => "\xE2\x88\x87",
		"\xF0\x9D\x9D\xB0" => "\xCE\xB1",
		"\xF0\x9D\x9D\xB1" => "\xCE\xB2",
		"\xF0\x9D\x9D\xB2" => "\xCE\xB3",
		"\xF0\x9D\x9D\xB3" => "\xCE\xB4",
		"\xF0\x9D\x9D\xB4" => "\xCE\xB5",
		"\xF0\x9D\x9D\xB5" => "\xCE\xB6",
		"\xF0\x9D\x9D\xB6" => "\xCE\xB7",
		"\xF0\x9D\x9D\xB7" => "\xCE\xB8",
		"\xF0\x9D\x9D\xB8" => "\xCE\xB9",
		"\xF0\x9D\x9D\xB9" => "\xCE\xBA",
		"\xF0\x9D\x9D\xBA" => "\xCE\xBB",
		"\xF0\x9D\x9D\xBB" => "\xCE\xBC",
		"\xF0\x9D\x9D\xBC" => "\xCE\xBD",
		"\xF0\x9D\x9D\xBD" => "\xCE\xBE",
		"\xF0\x9D\x9D\xBE" => "\xCE\xBF",
		"\xF0\x9D\x9D\xBF" => "\xCF\x80",
		"\xF0\x9D\x9E\x80" => "\xCF\x81",
		"\xF0\x9D\x9E\x81" => "\xCF\x82",
		"\xF0\x9D\x9E\x82" => "\xCF\x83",
		"\xF0\x9D\x9E\x83" => "\xCF\x84",
		"\xF0\x9D\x9E\x84" => "\xCF\x85",
		"\xF0\x9D\x9E\x85" => "\xCF\x86",
		"\xF0\x9D\x9E\x86" => "\xCF\x87",
		"\xF0\x9D\x9E\x87" => "\xCF\x88",
		"\xF0\x9D\x9E\x88" => "\xCF\x89",
		"\xF0\x9D\x9E\x89" => "\xE2\x88\x82",
		"\xF0\x9D\x9E\x8A" => "\xCE\xB5",
		"\xF0\x9D\x9E\x8B" => "\xCE\xB8",
		"\xF0\x9D\x9E\x8C" => "\xCE\xBA",
		"\xF0\x9D\x9E\x8D" => "\xCF\x86",
		"\xF0\x9D\x9E\x8E" => "\xCF\x81",
		"\xF0\x9D\x9E\x8F" => "\xCF\x80",
		"\xF0\x9D\x9E\x90" => "\xCE\x91",
		"\xF0\x9D\x9E\x91" => "\xCE\x92",
		"\xF0\x9D\x9E\x92" => "\xCE\x93",
		"\xF0\x9D\x9E\x93" => "\xCE\x94",
		"\xF0\x9D\x9E\x94" => "\xCE\x95",
		"\xF0\x9D\x9E\x95" => "\xCE\x96",
		"\xF0\x9D\x9E\x96" => "\xCE\x97",
		"\xF0\x9D\x9E\x97" => "\xCE\x98",
		"\xF0\x9D\x9E\x98" => "\xCE\x99",
		"\xF0\x9D\x9E\x99" => "\xCE\x9A",
		"\xF0\x9D\x9E\x9A" => "\xCE\x9B",
		"\xF0\x9D\x9E\x9B" => "\xCE\x9C",
		"\xF0\x9D\x9E\x9C" => "\xCE\x9D",
		"\xF0\x9D\x9E\x9D" => "\xCE\x9E",
		"\xF0\x9D\x9E\x9E" => "\xCE\x9F",
		"\xF0\x9D\x9E\x9F" => "\xCE\xA0",
		"\xF0\x9D\x9E\xA0" => "\xCE\xA1",
		"\xF0\x9D\x9E\xA1" => "\xCE\x98",
		"\xF0\x9D\x9E\xA2" => "\xCE\xA3",
		"\xF0\x9D\x9E\xA3" => "\xCE\xA4",
		"\xF0\x9D\x9E\xA4" => "\xCE\xA5",
		"\xF0\x9D\x9E\xA5" => "\xCE\xA6",
		"\xF0\x9D\x9E\xA6" => "\xCE\xA7",
		"\xF0\x9D\x9E\xA7" => "\xCE\xA8",
		"\xF0\x9D\x9E\xA8" => "\xCE\xA9",
		"\xF0\x9D\x9E\xA9" => "\xE2\x88\x87",
		"\xF0\x9D\x9E\xAA" => "\xCE\xB1",
		"\xF0\x9D\x9E\xAB" => "\xCE\xB2",
		"\xF0\x9D\x9E\xAC" => "\xCE\xB3",
		"\xF0\x9D\x9E\xAD" => "\xCE\xB4",
		"\xF0\x9D\x9E\xAE" => "\xCE\xB5",
		"\xF0\x9D\x9E\xAF" => "\xCE\xB6",
		"\xF0\x9D\x9E\xB0" => "\xCE\xB7",
		"\xF0\x9D\x9E\xB1" => "\xCE\xB8",
		"\xF0\x9D\x9E\xB2" => "\xCE\xB9",
		"\xF0\x9D\x9E\xB3" => "\xCE\xBA",
		"\xF0\x9D\x9E\xB4" => "\xCE\xBB",
		"\xF0\x9D\x9E\xB5" => "\xCE\xBC",
		"\xF0\x9D\x9E\xB6" => "\xCE\xBD",
		"\xF0\x9D\x9E\xB7" => "\xCE\xBE",
		"\xF0\x9D\x9E\xB8" => "\xCE\xBF",
		"\xF0\x9D\x9E\xB9" => "\xCF\x80",
		"\xF0\x9D\x9E\xBA" => "\xCF\x81",
		"\xF0\x9D\x9E\xBB" => "\xCF\x82",
		"\xF0\x9D\x9E\xBC" => "\xCF\x83",
		"\xF0\x9D\x9E\xBD" => "\xCF\x84",
		"\xF0\x9D\x9E\xBE" => "\xCF\x85",
		"\xF0\x9D\x9E\xBF" => "\xCF\x86",
		"\xF0\x9D\x9F\x80" => "\xCF\x87",
		"\xF0\x9D\x9F\x81" => "\xCF\x88",
		"\xF0\x9D\x9F\x82" => "\xCF\x89",
		"\xF0\x9D\x9F\x83" => "\xE2\x88\x82",
		"\xF0\x9D\x9F\x84" => "\xCE\xB5",
		"\xF0\x9D\x9F\x85" => "\xCE\xB8",
		"\xF0\x9D\x9F\x86" => "\xCE\xBA",
		"\xF0\x9D\x9F\x87" => "\xCF\x86",
		"\xF0\x9D\x9F\x88" => "\xCF\x81",
		"\xF0\x9D\x9F\x89" => "\xCF\x80",
		"\xF0\x9D\x9F\x8A" => "\xCF\x9C",
		"\xF0\x9D\x9F\x8B" => "\xCF\x9D",
		"\xF0\x9D\x9F\x8E" => "\x30",
		"\xF0\x9D\x9F\x8F" => "\x31",
		"\xF0\x9D\x9F\x90" => "\x32",
		"\xF0\x9D\x9F\x91" => "\x33",
		"\xF0\x9D\x9F\x92" => "\x34",
		"\xF0\x9D\x9F\x93" => "\x35",
		"\xF0\x9D\x9F\x94" => "\x36",
		"\xF0\x9D\x9F\x95" => "\x37",
		"\xF0\x9D\x9F\x96" => "\x38",
		"\xF0\x9D\x9F\x97" => "\x39",
		"\xF0\x9D\x9F\x98" => "\x30",
		"\xF0\x9D\x9F\x99" => "\x31",
		"\xF0\x9D\x9F\x9A" => "\x32",
		"\xF0\x9D\x9F\x9B" => "\x33",
		"\xF0\x9D\x9F\x9C" => "\x34",
		"\xF0\x9D\x9F\x9D" => "\x35",
		"\xF0\x9D\x9F\x9E" => "\x36",
		"\xF0\x9D\x9F\x9F" => "\x37",
		"\xF0\x9D\x9F\xA0" => "\x38",
		"\xF0\x9D\x9F\xA1" => "\x39",
		"\xF0\x9D\x9F\xA2" => "\x30",
		"\xF0\x9D\x9F\xA3" => "\x31",
		"\xF0\x9D\x9F\xA4" => "\x32",
		"\xF0\x9D\x9F\xA5" => "\x33",
		"\xF0\x9D\x9F\xA6" => "\x34",
		"\xF0\x9D\x9F\xA7" => "\x35",
		"\xF0\x9D\x9F\xA8" => "\x36",
		"\xF0\x9D\x9F\xA9" => "\x37",
		"\xF0\x9D\x9F\xAA" => "\x38",
		"\xF0\x9D\x9F\xAB" => "\x39",
		"\xF0\x9D\x9F\xAC" => "\x30",
		"\xF0\x9D\x9F\xAD" => "\x31",
		"\xF0\x9D\x9F\xAE" => "\x32",
		"\xF0\x9D\x9F\xAF" => "\x33",
		"\xF0\x9D\x9F\xB0" => "\x34",
		"\xF0\x9D\x9F\xB1" => "\x35",
		"\xF0\x9D\x9F\xB2" => "\x36",
		"\xF0\x9D\x9F\xB3" => "\x37",
		"\xF0\x9D\x9F\xB4" => "\x38",
		"\xF0\x9D\x9F\xB5" => "\x39",
		"\xF0\x9D\x9F\xB6" => "\x30",
		"\xF0\x9D\x9F\xB7" => "\x31",
		"\xF0\x9D\x9F\xB8" => "\x32",
		"\xF0\x9D\x9F\xB9" => "\x33",
		"\xF0\x9D\x9F\xBA" => "\x34",
		"\xF0\x9D\x9F\xBB" => "\x35",
		"\xF0\x9D\x9F\xBC" => "\x36",
		"\xF0\x9D\x9F\xBD" => "\x37",
		"\xF0\x9D\x9F\xBE" => "\x38",
		"\xF0\x9D\x9F\xBF" => "\x39",
		"\xF0\x9E\x80\xB0" => "\xD0\xB0",
		"\xF0\x9E\x80\xB1" => "\xD0\xB1",
		"\xF0\x9E\x80\xB2" => "\xD0\xB2",
		"\xF0\x9E\x80\xB3" => "\xD0\xB3",
		"\xF0\x9E\x80\xB4" => "\xD0\xB4",
		"\xF0\x9E\x80\xB5" => "\xD0\xB5",
		"\xF0\x9E\x80\xB6" => "\xD0\xB6",
		"\xF0\x9E\x80\xB7" => "\xD0\xB7",
		"\xF0\x9E\x80\xB8" => "\xD0\xB8",
		"\xF0\x9E\x80\xB9" => "\xD0\xBA",
		"\xF0\x9E\x80\xBA" => "\xD0\xBB",
		"\xF0\x9E\x80\xBB" => "\xD0\xBC",
		"\xF0\x9E\x80\xBC" => "\xD0\xBE",
		"\xF0\x9E\x80\xBD" => "\xD0\xBF",
		"\xF0\x9E\x80\xBE" => "\xD1\x80",
		"\xF0\x9E\x80\xBF" => "\xD1\x81",
		"\xF0\x9E\x81\x80" => "\xD1\x82",
		"\xF0\x9E\x81\x81" => "\xD1\x83",
		"\xF0\x9E\x81\x82" => "\xD1\x84",
		"\xF0\x9E\x81\x83" => "\xD1\x85",
		"\xF0\x9E\x81\x84" => "\xD1\x86",
		"\xF0\x9E\x81\x85" => "\xD1\x87",
		"\xF0\x9E\x81\x86" => "\xD1\x88",
		"\xF0\x9E\x81\x87" => "\xD1\x8B",
		"\xF0\x9E\x81\x88" => "\xD1\x8D",
		"\xF0\x9E\x81\x89" => "\xD1\x8E",
		"\xF0\x9E\x81\x8A" => "\xEA\x9A\x89",
		"\xF0\x9E\x81\x8B" => "\xD3\x99",
		"\xF0\x9E\x81\x8C" => "\xD1\x96",
		"\xF0\x9E\x81\x8D" => "\xD1\x98",
		"\xF0\x9E\x81\x8E" => "\xD3\xA9",
		"\xF0\x9E\x81\x8F" => "\xD2\xAF",
		"\xF0\x9E\x81\x90" => "\xD3\x8F",
		"\xF0\x9E\x81\x91" => "\xD0\xB0",
		"\xF0\x9E\x81\x92" => "\xD0\xB1",
		"\xF0\x9E\x81\x93" => "\xD0\xB2",
		"\xF0\x9E\x81\x94" => "\xD0\xB3",
		"\xF0\x9E\x81\x95" => "\xD0\xB4",
		"\xF0\x9E\x81\x96" => "\xD0\xB5",
		"\xF0\x9E\x81\x97" => "\xD0\xB6",
		"\xF0\x9E\x81\x98" => "\xD0\xB7",
		"\xF0\x9E\x81\x99" => "\xD0\xB8",
		"\xF0\x9E\x81\x9A" => "\xD0\xBA",
		"\xF0\x9E\x81\x9B" => "\xD0\xBB",
		"\xF0\x9E\x81\x9C" => "\xD0\xBE",
		"\xF0\x9E\x81\x9D" => "\xD0\xBF",
		"\xF0\x9E\x81\x9E" => "\xD1\x81",
		"\xF0\x9E\x81\x9F" => "\xD1\x83",
		"\xF0\x9E\x81\xA0" => "\xD1\x84",
		"\xF0\x9E\x81\xA1" => "\xD1\x85",
		"\xF0\x9E\x81\xA2" => "\xD1\x86",
		"\xF0\x9E\x81\xA3" => "\xD1\x87",
		"\xF0\x9E\x81\xA4" => "\xD1\x88",
		"\xF0\x9E\x81\xA5" => "\xD1\x8A",
		"\xF0\x9E\x81\xA6" => "\xD1\x8B",
		"\xF0\x9E\x81\xA7" => "\xD2\x91",
		"\xF0\x9E\x81\xA8" => "\xD1\x96",
		"\xF0\x9E\x81\xA9" => "\xD1\x95",
		"\xF0\x9E\x81\xAA" => "\xD1\x9F",
		"\xF0\x9E\x81\xAB" => "\xD2\xAB",
		"\xF0\x9E\x81\xAC" => "\xEA\x99\x91",
		"\xF0\x9E\x81\xAD" => "\xD2\xB1",
		"\xF0\x9E\xB8\x80" => "\xD8\xA7",
		"\xF0\x9E\xB8\x81" => "\xD8\xA8",
		"\xF0\x9E\xB8\x82" => "\xD8\xAC",
		"\xF0\x9E\xB8\x83" => "\xD8\xAF",
		"\xF0\x9E\xB8\x85" => "\xD9\x88",
		"\xF0\x9E\xB8\x86" => "\xD8\xB2",
		"\xF0\x9E\xB8\x87" => "\xD8\xAD",
		"\xF0\x9E\xB8\x88" => "\xD8\xB7",
		"\xF0\x9E\xB8\x89" => "\xD9\x8A",
		"\xF0\x9E\xB8\x8A" => "\xD9\x83",
		"\xF0\x9E\xB8\x8B" => "\xD9\x84",
		"\xF0\x9E\xB8\x8C" => "\xD9\x85",
		"\xF0\x9E\xB8\x8D" => "\xD9\x86",
		"\xF0\x9E\xB8\x8E" => "\xD8\xB3",
		"\xF0\x9E\xB8\x8F" => "\xD8\xB9",
		"\xF0\x9E\xB8\x90" => "\xD9\x81",
		"\xF0\x9E\xB8\x91" => "\xD8\xB5",
		"\xF0\x9E\xB8\x92" => "\xD9\x82",
		"\xF0\x9E\xB8\x93" => "\xD8\xB1",
		"\xF0\x9E\xB8\x94" => "\xD8\xB4",
		"\xF0\x9E\xB8\x95" => "\xD8\xAA",
		"\xF0\x9E\xB8\x96" => "\xD8\xAB",
		"\xF0\x9E\xB8\x97" => "\xD8\xAE",
		"\xF0\x9E\xB8\x98" => "\xD8\xB0",
		"\xF0\x9E\xB8\x99" => "\xD8\xB6",
		"\xF0\x9E\xB8\x9A" => "\xD8\xB8",
		"\xF0\x9E\xB8\x9B" => "\xD8\xBA",
		"\xF0\x9E\xB8\x9C" => "\xD9\xAE",
		"\xF0\x9E\xB8\x9D" => "\xDA\xBA",
		"\xF0\x9E\xB8\x9E" => "\xDA\xA1",
		"\xF0\x9E\xB8\x9F" => "\xD9\xAF",
		"\xF0\x9E\xB8\xA1" => "\xD8\xA8",
		"\xF0\x9E\xB8\xA2" => "\xD8\xAC",
		"\xF0\x9E\xB8\xA4" => "\xD9\x87",
		"\xF0\x9E\xB8\xA7" => "\xD8\xAD",
		"\xF0\x9E\xB8\xA9" => "\xD9\x8A",
		"\xF0\x9E\xB8\xAA" => "\xD9\x83",
		"\xF0\x9E\xB8\xAB" => "\xD9\x84",
		"\xF0\x9E\xB8\xAC" => "\xD9\x85",
		"\xF0\x9E\xB8\xAD" => "\xD9\x86",
		"\xF0\x9E\xB8\xAE" => "\xD8\xB3",
		"\xF0\x9E\xB8\xAF" => "\xD8\xB9",
		"\xF0\x9E\xB8\xB0" => "\xD9\x81",
		"\xF0\x9E\xB8\xB1" => "\xD8\xB5",
		"\xF0\x9E\xB8\xB2" => "\xD9\x82",
		"\xF0\x9E\xB8\xB4" => "\xD8\xB4",
		"\xF0\x9E\xB8\xB5" => "\xD8\xAA",
		"\xF0\x9E\xB8\xB6" => "\xD8\xAB",
		"\xF0\x9E\xB8\xB7" => "\xD8\xAE",
		"\xF0\x9E\xB8\xB9" => "\xD8\xB6",
		"\xF0\x9E\xB8\xBB" => "\xD8\xBA",
		"\xF0\x9E\xB9\x82" => "\xD8\xAC",
		"\xF0\x9E\xB9\x87" => "\xD8\xAD",
		"\xF0\x9E\xB9\x89" => "\xD9\x8A",
		"\xF0\x9E\xB9\x8B" => "\xD9\x84",
		"\xF0\x9E\xB9\x8D" => "\xD9\x86",
		"\xF0\x9E\xB9\x8E" => "\xD8\xB3",
		"\xF0\x9E\xB9\x8F" => "\xD8\xB9",
		"\xF0\x9E\xB9\x91" => "\xD8\xB5",
		"\xF0\x9E\xB9\x92" => "\xD9\x82",
		"\xF0\x9E\xB9\x94" => "\xD8\xB4",
		"\xF0\x9E\xB9\x97" => "\xD8\xAE",
		"\xF0\x9E\xB9\x99" => "\xD8\xB6",
		"\xF0\x9E\xB9\x9B" => "\xD8\xBA",
		"\xF0\x9E\xB9\x9D" => "\xDA\xBA",
		"\xF0\x9E\xB9\x9F" => "\xD9\xAF",
		"\xF0\x9E\xB9\xA1" => "\xD8\xA8",
		"\xF0\x9E\xB9\xA2" => "\xD8\xAC",
		"\xF0\x9E\xB9\xA4" => "\xD9\x87",
		"\xF0\x9E\xB9\xA7" => "\xD8\xAD",
		"\xF0\x9E\xB9\xA8" => "\xD8\xB7",
		"\xF0\x9E\xB9\xA9" => "\xD9\x8A",
		"\xF0\x9E\xB9\xAA" => "\xD9\x83",
		"\xF0\x9E\xB9\xAC" => "\xD9\x85",
		"\xF0\x9E\xB9\xAD" => "\xD9\x86",
		"\xF0\x9E\xB9\xAE" => "\xD8\xB3",
		"\xF0\x9E\xB9\xAF" => "\xD8\xB9",
		"\xF0\x9E\xB9\xB0" => "\xD9\x81",
		"\xF0\x9E\xB9\xB1" => "\xD8\xB5",
		"\xF0\x9E\xB9\xB2" => "\xD9\x82",
		"\xF0\x9E\xB9\xB4" => "\xD8\xB4",
		"\xF0\x9E\xB9\xB5" => "\xD8\xAA",
		"\xF0\x9E\xB9\xB6" => "\xD8\xAB",
		"\xF0\x9E\xB9\xB7" => "\xD8\xAE",
		"\xF0\x9E\xB9\xB9" => "\xD8\xB6",
		"\xF0\x9E\xB9\xBA" => "\xD8\xB8",
		"\xF0\x9E\xB9\xBB" => "\xD8\xBA",
		"\xF0\x9E\xB9\xBC" => "\xD9\xAE",
		"\xF0\x9E\xB9\xBE" => "\xDA\xA1",
		"\xF0\x9E\xBA\x80" => "\xD8\xA7",
		"\xF0\x9E\xBA\x81" => "\xD8\xA8",
		"\xF0\x9E\xBA\x82" => "\xD8\xAC",
		"\xF0\x9E\xBA\x83" => "\xD8\xAF",
		"\xF0\x9E\xBA\x84" => "\xD9\x87",
		"\xF0\x9E\xBA\x85" => "\xD9\x88",
		"\xF0\x9E\xBA\x86" => "\xD8\xB2",
		"\xF0\x9E\xBA\x87" => "\xD8\xAD",
		"\xF0\x9E\xBA\x88" => "\xD8\xB7",
		"\xF0\x9E\xBA\x89" => "\xD9\x8A",
		"\xF0\x9E\xBA\x8B" => "\xD9\x84",
		"\xF0\x9E\xBA\x8C" => "\xD9\x85",
		"\xF0\x9E\xBA\x8D" => "\xD9\x86",
		"\xF0\x9E\xBA\x8E" => "\xD8\xB3",
		"\xF0\x9E\xBA\x8F" => "\xD8\xB9",
		"\xF0\x9E\xBA\x90" => "\xD9\x81",
		"\xF0\x9E\xBA\x91" => "\xD8\xB5",
		"\xF0\x9E\xBA\x92" => "\xD9\x82",
		"\xF0\x9E\xBA\x93" => "\xD8\xB1",
		"\xF0\x9E\xBA\x94" => "\xD8\xB4",
		"\xF0\x9E\xBA\x95" => "\xD8\xAA",
		"\xF0\x9E\xBA\x96" => "\xD8\xAB",
		"\xF0\x9E\xBA\x97" => "\xD8\xAE",
		"\xF0\x9E\xBA\x98" => "\xD8\xB0",
		"\xF0\x9E\xBA\x99" => "\xD8\xB6",
		"\xF0\x9E\xBA\x9A" => "\xD8\xB8",
		"\xF0\x9E\xBA\x9B" => "\xD8\xBA",
		"\xF0\x9E\xBA\xA1" => "\xD8\xA8",
		"\xF0\x9E\xBA\xA2" => "\xD8\xAC",
		"\xF0\x9E\xBA\xA3" => "\xD8\xAF",
		"\xF0\x9E\xBA\xA5" => "\xD9\x88",
		"\xF0\x9E\xBA\xA6" => "\xD8\xB2",
		"\xF0\x9E\xBA\xA7" => "\xD8\xAD",
		"\xF0\x9E\xBA\xA8" => "\xD8\xB7",
		"\xF0\x9E\xBA\xA9" => "\xD9\x8A",
		"\xF0\x9E\xBA\xAB" => "\xD9\x84",
		"\xF0\x9E\xBA\xAC" => "\xD9\x85",
		"\xF0\x9E\xBA\xAD" => "\xD9\x86",
		"\xF0\x9E\xBA\xAE" => "\xD8\xB3",
		"\xF0\x9E\xBA\xAF" => "\xD8\xB9",
		"\xF0\x9E\xBA\xB0" => "\xD9\x81",
		"\xF0\x9E\xBA\xB1" => "\xD8\xB5",
		"\xF0\x9E\xBA\xB2" => "\xD9\x82",
		"\xF0\x9E\xBA\xB3" => "\xD8\xB1",
		"\xF0\x9E\xBA\xB4" => "\xD8\xB4",
		"\xF0\x9E\xBA\xB5" => "\xD8\xAA",
		"\xF0\x9E\xBA\xB6" => "\xD8\xAB",
		"\xF0\x9E\xBA\xB7" => "\xD8\xAE",
		"\xF0\x9E\xBA\xB8" => "\xD8\xB0",
		"\xF0\x9E\xBA\xB9" => "\xD8\xB6",
		"\xF0\x9E\xBA\xBA" => "\xD8\xB8",
		"\xF0\x9E\xBA\xBB" => "\xD8\xBA",
		"\xF0\x9F\x84\x80" => "\x30\x2E",
		"\xF0\x9F\x84\x81" => "\x30\x2C",
		"\xF0\x9F\x84\x82" => "\x31\x2C",
		"\xF0\x9F\x84\x83" => "\x32\x2C",
		"\xF0\x9F\x84\x84" => "\x33\x2C",
		"\xF0\x9F\x84\x85" => "\x34\x2C",
		"\xF0\x9F\x84\x86" => "\x35\x2C",
		"\xF0\x9F\x84\x87" => "\x36\x2C",
		"\xF0\x9F\x84\x88" => "\x37\x2C",
		"\xF0\x9F\x84\x89" => "\x38\x2C",
		"\xF0\x9F\x84\x8A" => "\x39\x2C",
		"\xF0\x9F\x84\x90" => "\x28\x41\x29",
		"\xF0\x9F\x84\x91" => "\x28\x42\x29",
		"\xF0\x9F\x84\x92" => "\x28\x43\x29",
		"\xF0\x9F\x84\x93" => "\x28\x44\x29",
		"\xF0\x9F\x84\x94" => "\x28\x45\x29",
		"\xF0\x9F\x84\x95" => "\x28\x46\x29",
		"\xF0\x9F\x84\x96" => "\x28\x47\x29",
		"\xF0\x9F\x84\x97" => "\x28\x48\x29",
		"\xF0\x9F\x84\x98" => "\x28\x49\x29",
		"\xF0\x9F\x84\x99" => "\x28\x4A\x29",
		"\xF0\x9F\x84\x9A" => "\x28\x4B\x29",
		"\xF0\x9F\x84\x9B" => "\x28\x4C\x29",
		"\xF0\x9F\x84\x9C" => "\x28\x4D\x29",
		"\xF0\x9F\x84\x9D" => "\x28\x4E\x29",
		"\xF0\x9F\x84\x9E" => "\x28\x4F\x29",
		"\xF0\x9F\x84\x9F" => "\x28\x50\x29",
		"\xF0\x9F\x84\xA0" => "\x28\x51\x29",
		"\xF0\x9F\x84\xA1" => "\x28\x52\x29",
		"\xF0\x9F\x84\xA2" => "\x28\x53\x29",
		"\xF0\x9F\x84\xA3" => "\x28\x54\x29",
		"\xF0\x9F\x84\xA4" => "\x28\x55\x29",
		"\xF0\x9F\x84\xA5" => "\x28\x56\x29",
		"\xF0\x9F\x84\xA6" => "\x28\x57\x29",
		"\xF0\x9F\x84\xA7" => "\x28\x58\x29",
		"\xF0\x9F\x84\xA8" => "\x28\x59\x29",
		"\xF0\x9F\x84\xA9" => "\x28\x5A\x29",
		"\xF0\x9F\x84\xAA" => "\xE3\x80\x94\x53\xE3\x80\x95",
		"\xF0\x9F\x84\xAB" => "\x43",
		"\xF0\x9F\x84\xAC" => "\x52",
		"\xF0\x9F\x84\xAD" => "\x43\x44",
		"\xF0\x9F\x84\xAE" => "\x57\x5A",
		"\xF0\x9F\x84\xB0" => "\x41",
		"\xF0\x9F\x84\xB1" => "\x42",
		"\xF0\x9F\x84\xB2" => "\x43",
		"\xF0\x9F\x84\xB3" => "\x44",
		"\xF0\x9F\x84\xB4" => "\x45",
		"\xF0\x9F\x84\xB5" => "\x46",
		"\xF0\x9F\x84\xB6" => "\x47",
		"\xF0\x9F\x84\xB7" => "\x48",
		"\xF0\x9F\x84\xB8" => "\x49",
		"\xF0\x9F\x84\xB9" => "\x4A",
		"\xF0\x9F\x84\xBA" => "\x4B",
		"\xF0\x9F\x84\xBB" => "\x4C",
		"\xF0\x9F\x84\xBC" => "\x4D",
		"\xF0\x9F\x84\xBD" => "\x4E",
		"\xF0\x9F\x84\xBE" => "\x4F",
		"\xF0\x9F\x84\xBF" => "\x50",
		"\xF0\x9F\x85\x80" => "\x51",
		"\xF0\x9F\x85\x81" => "\x52",
		"\xF0\x9F\x85\x82" => "\x53",
		"\xF0\x9F\x85\x83" => "\x54",
		"\xF0\x9F\x85\x84" => "\x55",
		"\xF0\x9F\x85\x85" => "\x56",
		"\xF0\x9F\x85\x86" => "\x57",
		"\xF0\x9F\x85\x87" => "\x58",
		"\xF0\x9F\x85\x88" => "\x59",
		"\xF0\x9F\x85\x89" => "\x5A",
		"\xF0\x9F\x85\x8A" => "\x48\x56",
		"\xF0\x9F\x85\x8B" => "\x4D\x56",
		"\xF0\x9F\x85\x8C" => "\x53\x44",
		"\xF0\x9F\x85\x8D" => "\x53\x53",
		"\xF0\x9F\x85\x8E" => "\x50\x50\x56",
		"\xF0\x9F\x85\x8F" => "\x57\x43",
		"\xF0\x9F\x85\xAA" => "\x4D\x43",
		"\xF0\x9F\x85\xAB" => "\x4D\x44",
		"\xF0\x9F\x85\xAC" => "\x4D\x52",
		"\xF0\x9F\x86\x90" => "\x44\x4A",
		"\xF0\x9F\x88\x80" => "\xE3\x81\xBB\xE3\x81\x8B",
		"\xF0\x9F\x88\x81" => "\xE3\x82\xB3\xE3\x82\xB3",
		"\xF0\x9F\x88\x82" => "\xE3\x82\xB5",
		"\xF0\x9F\x88\x90" => "\xE6\x89\x8B",
		"\xF0\x9F\x88\x91" => "\xE5\xAD\x97",
		"\xF0\x9F\x88\x92" => "\xE5\x8F\x8C",
		"\xF0\x9F\x88\x93" => "\xE3\x83\x86\xE3\x82\x99",
		"\xF0\x9F\x88\x94" => "\xE4\xBA\x8C",
		"\xF0\x9F\x88\x95" => "\xE5\xA4\x9A",
		"\xF0\x9F\x88\x96" => "\xE8\xA7\xA3",
		"\xF0\x9F\x88\x97" => "\xE5\xA4\xA9",
		"\xF0\x9F\x88\x98" => "\xE4\xBA\xA4",
		"\xF0\x9F\x88\x99" => "\xE6\x98\xA0",
		"\xF0\x9F\x88\x9A" => "\xE7\x84\xA1",
		"\xF0\x9F\x88\x9B" => "\xE6\x96\x99",
		"\xF0\x9F\x88\x9C" => "\xE5\x89\x8D",
		"\xF0\x9F\x88\x9D" => "\xE5\xBE\x8C",
		"\xF0\x9F\x88\x9E" => "\xE5\x86\x8D",
		"\xF0\x9F\x88\x9F" => "\xE6\x96\xB0",
		"\xF0\x9F\x88\xA0" => "\xE5\x88\x9D",
		"\xF0\x9F\x88\xA1" => "\xE7\xB5\x82",
		"\xF0\x9F\x88\xA2" => "\xE7\x94\x9F",
		"\xF0\x9F\x88\xA3" => "\xE8\xB2\xA9",
		"\xF0\x9F\x88\xA4" => "\xE5\xA3\xB0",
		"\xF0\x9F\x88\xA5" => "\xE5\x90\xB9",
		"\xF0\x9F\x88\xA6" => "\xE6\xBC\x94",
		"\xF0\x9F\x88\xA7" => "\xE6\x8A\x95",
		"\xF0\x9F\x88\xA8" => "\xE6\x8D\x95",
		"\xF0\x9F\x88\xA9" => "\xE4\xB8\x80",
		"\xF0\x9F\x88\xAA" => "\xE4\xB8\x89",
		"\xF0\x9F\x88\xAB" => "\xE9\x81\x8A",
		"\xF0\x9F\x88\xAC" => "\xE5\xB7\xA6",
		"\xF0\x9F\x88\xAD" => "\xE4\xB8\xAD",
		"\xF0\x9F\x88\xAE" => "\xE5\x8F\xB3",
		"\xF0\x9F\x88\xAF" => "\xE6\x8C\x87",
		"\xF0\x9F\x88\xB0" => "\xE8\xB5\xB0",
		"\xF0\x9F\x88\xB1" => "\xE6\x89\x93",
		"\xF0\x9F\x88\xB2" => "\xE7\xA6\x81",
		"\xF0\x9F\x88\xB3" => "\xE7\xA9\xBA",
		"\xF0\x9F\x88\xB4" => "\xE5\x90\x88",
		"\xF0\x9F\x88\xB5" => "\xE6\xBA\x80",
		"\xF0\x9F\x88\xB6" => "\xE6\x9C\x89",
		"\xF0\x9F\x88\xB7" => "\xE6\x9C\x88",
		"\xF0\x9F\x88\xB8" => "\xE7\x94\xB3",
		"\xF0\x9F\x88\xB9" => "\xE5\x89\xB2",
		"\xF0\x9F\x88\xBA" => "\xE5\x96\xB6",
		"\xF0\x9F\x88\xBB" => "\xE9\x85\x8D",
		"\xF0\x9F\x89\x80" => "\xE3\x80\x94\xE6\x9C\xAC\xE3\x80\x95",
		"\xF0\x9F\x89\x81" => "\xE3\x80\x94\xE4\xB8\x89\xE3\x80\x95",
		"\xF0\x9F\x89\x82" => "\xE3\x80\x94\xE4\xBA\x8C\xE3\x80\x95",
		"\xF0\x9F\x89\x83" => "\xE3\x80\x94\xE5\xAE\x89\xE3\x80\x95",
		"\xF0\x9F\x89\x84" => "\xE3\x80\x94\xE7\x82\xB9\xE3\x80\x95",
		"\xF0\x9F\x89\x85" => "\xE3\x80\x94\xE6\x89\x93\xE3\x80\x95",
		"\xF0\x9F\x89\x86" => "\xE3\x80\x94\xE7\x9B\x97\xE3\x80\x95",
		"\xF0\x9F\x89\x87" => "\xE3\x80\x94\xE5\x8B\x9D\xE3\x80\x95",
		"\xF0\x9F\x89\x88" => "\xE3\x80\x94\xE6\x95\x97\xE3\x80\x95",
		"\xF0\x9F\x89\x90" => "\xE5\xBE\x97",
		"\xF0\x9F\x89\x91" => "\xE5\x8F\xAF",
		"\xF0\x9F\xAF\xB0" => "\x30",
		"\xF0\x9F\xAF\xB1" => "\x31",
		"\xF0\x9F\xAF\xB2" => "\x32",
		"\xF0\x9F\xAF\xB3" => "\x33",
		"\xF0\x9F\xAF\xB4" => "\x34",
		"\xF0\x9F\xAF\xB5" => "\x35",
		"\xF0\x9F\xAF\xB6" => "\x36",
		"\xF0\x9F\xAF\xB7" => "\x37",
		"\xF0\x9F\xAF\xB8" => "\x38",
		"\xF0\x9F\xAF\xB9" => "\x39",
	);
}

?>