<?php
// Version: 2.1.3; Install

// These should be the same as those in index.language.php.
$txt['lang_character_set'] = 'UTF-8';
$txt['lang_rtl'] = '0';

$txt['install_step_welcome'] = 'Willkommen';
$txt['install_step_writable'] = 'Beschreibbarkeitsprüfung';
$txt['install_step_forum'] = 'Forumseinstellungen';
$txt['install_step_databaseset'] = 'Datenbankeinstellungen';
$txt['install_step_databasechange'] = 'Datenbankbefüllung';
$txt['install_step_admin'] = 'Administrationskonto';
$txt['install_step_delete'] = 'Installation abschließen';

$txt['smf_installer'] = 'SMF-Installation';
$txt['installer_language'] = 'Sprache';
$txt['installer_language_set'] = 'Speichern';
$txt['congratulations'] = 'Glückwunsch, die Installation ist abgeschlossen!';
$txt['congratulations_help'] = 'Wenn Sie Unterstützung brauchen oder SMF nicht einwandfrei läuft, denken Sie bitte daran, dass <a href="https://www.simplemachines.org/community/index.php" target="_blank" rel="noopener">wir Ihnen helfen können</a>, falls Sie es wünschen.';
$txt['still_writable'] = 'Ihr Installationsverzeichnis ist noch beschreibbar. Es ist aus Sicherheitsgründen sinnvoll, die chmod-Berechtigungen zu ändern, sodass es schreibgeschützt ist.';
$txt['delete_installer'] = 'Klicken Sie hier, um diese „install.php“-Datei zu löschen';
$txt['delete_installer_maybe'] = '<em>(funktioniert nicht auf allen Servern).</em>';
$txt['go_to_your_forum'] = 'Jetzt können Sie <a href="%1$s">Ihr neu installiertes Forum</a> ansehen und benutzen. Sobald Sie sich eingeloggt haben, können Sie auf das Administrationszentrum zugreifen.';
$txt['good_luck'] = 'Viel Glück!<br>Simple Machines';

$txt['install_welcome'] = 'Willkommen';
$txt['install_welcome_desc'] = 'Willkommen bei SMF. Dieses Skript wird Sie durch den Installationsprozess von %1$s führen. Im Folgenden werden einige Daten über Ihr Forum gesammelt und in ein paar Minuten wird es verfügbar sein.';
$txt['install_no_https'] = 'Ihre Umgebung unterstützt keine HTTPS-Streams. Einige Funktionen, z. B. das Empfangen von Updates von simplemachines.org, werden nicht funktionieren.';
$txt['install_no_mbstring'] = 'Ihre Umgebung unterstützt die benötigte mbstring-Bibliothek nicht. Bitte aktivieren Sie mbstring und versuchen Sie es dann erneut.';
$txt['install_no_fileinfo'] = 'Ihre Umgebung unterstützt die benötigte fileinfo-Bibliothek nicht. Bitte aktivieren Sie fileinfo und versuchen Sie es dann erneut.';
$txt['install_all_lovely'] = 'Ein paar anfängliche Tests wurden durchgeführt und alles scheint in Ordnung zu sein. Klicken Sie den „Fortfahren“-Button unten, um zu beginnen.';

$txt['user_refresh_install'] = 'Forum aktualisiert';
$txt['user_refresh_install_desc'] = 'Während der Installation wurde festgestellt, dass (mit den von Ihnen eingegebenen Daten) eine oder mehrere Datenbanktabellen, die das Installationsskript anlegen könnte, bereits existieren.<br>Alle fehlenden Tabellen Ihrer Installation wurden mit den Standard-Daten frisch erstellt, aus den vorhandenen Tabellen wurden aber keine Daten gelöscht.';

$txt['default_topic_subject'] = 'Willkommen bei SMF!';
$txt['default_topic_message'] = 'Willkommen im Simple-Machines-Forum!<br><br>Wir hoffen, dass Ihnen Ihr neues Forum Spaß macht. Wenn Sie Probleme haben, zögern Sie nicht, uns [url=https://www.simplemachines.org/community/index.php]um Hilfe zu fragen[/url].<br><br>Danke!<br>Simple Machines';
$txt['default_board_name'] = 'Generelle Diskussion';
$txt['default_board_description'] = 'Diskutieren Sie in diesem Board über alles, was Ihnen einfällt.';
$txt['default_category_name'] = 'Generelle Kategorie';
$txt['default_time_format'] = '%d.%m.%Y, %H:%M:%S %Z';
$txt['default_news'] = 'SMF – gerade installiert!';
$txt['default_reserved_names'] = 'Administrator\nAdmin\nWebmaster\nGast\nroot';
$txt['default_fugue_smileyset_name'] = 'Fugues Sammlung';
$txt['default_alienine_smileyset_name'] = 'Alienines Sammlung';
$txt['default_aaron_smileyset_name'] = 'Aarons Sammlung';
$txt['default_akyhne_smileyset_name'] = 'Akyhnes Sammlung';
$txt['default_legacy_smileyset_name'] = '2.0-Standard';
$txt['default_theme_name'] = 'SMF-Standard-Theme – Curve2';

$txt['default_administrator_group'] = 'Administratoren';
$txt['default_global_moderator_group'] = 'Globale Moderatoren';
$txt['default_moderator_group'] = 'Moderatoren';
$txt['default_newbie_group'] = 'Neuling';
$txt['default_junior_group'] = 'Juniormitglied';
$txt['default_full_group'] = 'Vollwertiges Mitglied';
$txt['default_senior_group'] = 'Seniormitglied';
$txt['default_hero_group'] = 'Heldenmitglied';

$txt['default_smiley_smiley'] = 'Smiley';
$txt['default_wink_smiley'] = 'Zwinker';
$txt['default_cheesy_smiley'] = 'Lächeln';
$txt['default_grin_smiley'] = 'Grins';
$txt['default_angry_smiley'] = 'Wütend';
$txt['default_sad_smiley'] = 'Traurig';
$txt['default_shocked_smiley'] = 'Schockiert';
$txt['default_cool_smiley'] = 'Cool';
$txt['default_huh_smiley'] = 'Hä?';
$txt['default_roll_eyes_smiley'] = 'Augenrollen';
$txt['default_tongue_smiley'] = 'Zunge';
$txt['default_embarrassed_smiley'] = 'Verlegen';
$txt['default_lips_sealed_smiley'] = 'Schweigend';
$txt['default_undecided_smiley'] = 'Unentschlossen';
$txt['default_kiss_smiley'] = 'Kuss';
$txt['default_cry_smiley'] = 'Heul';
$txt['default_evil_smiley'] = 'Teuflisch';
$txt['default_azn_smiley'] = 'Asiatisch';
$txt['default_afro_smiley'] = 'Afro';
$txt['default_laugh_smiley'] = 'Lach';
$txt['default_police_smiley'] = 'Polizei';
$txt['default_angel_smiley'] = 'Engel';

$txt['error_message_click'] = 'Klicken Sie hier';
$txt['error_message_try_again'] = ', um diesen Schritt erneut zu versuchen.';
$txt['error_message_bad_try_again'] = 'um trotzdem zu installieren. Beachten Sie bitte, dass dies <em>nicht</em> empfehlenswert ist.';

$txt['install_settings'] = 'Forumseinstellungen';
$txt['install_settings_info'] = 'Auf dieser Seite müssen Sie einige grundlegende Einstellungen für Ihr Forum festlegen. SMF hat einige davon automatisch für Sie erkannt.';
$txt['install_settings_name'] = 'Name des Forums';
$txt['install_settings_name_info'] = 'Das ist der Name Ihres Forums, z. B. „Das Test-Forum“.';
$txt['install_settings_name_default'] = 'Mein Forum';
$txt['install_settings_url'] = 'Forums-URL';
$txt['install_settings_url_info'] = 'Dies ist die URL zu Ihrem Forum <strong>ohne den abschließenden „/“!</strong>.<br>In den meisten Fällen können Sie den voreingestellten Wert belassen – normalerweise stimmt er.';
$txt['install_settings_reg_mode'] = 'Registrierungsmodus';
$txt['install_settings_reg_modes'] = 'Registrierungsmodi';
$txt['install_settings_reg_immediate'] = 'Sofortige Registrierung';
$txt['install_settings_reg_email'] = 'E-Mail-Aktivierung';
$txt['install_settings_reg_admin'] = 'Admin-Genehmigung';
$txt['install_settings_reg_disabled'] = 'Registrierung deaktiviert';
$txt['install_settings_reg_mode_info'] = 'Dieses Feld erlaubt es Ihnen, den Registrierungsmodus bereits bei der Installation zu ändern, um ungewollte Registrierungen zu vermeiden.';
$txt['install_settings_compress'] = 'Gzip-Komprimierung';
$txt['install_settings_compress_title'] = 'Daten komprimieren, um Bandbreite zu sparen.';
// In this string, you can translate the word "PASS" to change what it says when the test passes.
$txt['install_settings_compress_info'] = 'Diese Option funktioniert nicht auf allen Servern, kann aber eine Menge Bandbreite sparen.<br>Klicken Sie <a href="install.php?obgz=1&amp;pass_string=Erfolgreich" onclick="return reqWin(this.href, 200, 60);" target="_blank" rel="noopener">hier</a> um sie zu testen (der Test sollte „Erfolgreich“ zurückmelden)';
$txt['install_settings_dbsession'] = 'Datenbanksitzungen';
$txt['install_settings_dbsession_title'] = 'Benutze die Datenbank für Sitzungen anstelle von Dateien.';
$txt['install_settings_dbsession_info1'] = 'Diese Option ist fast immer die beste Wahl, da sie Sitzungen zuverlässiger macht.';
$txt['install_settings_dbsession_info2'] = 'Diese Option ist generell eine gute Idee, wird aber möglicherweise nicht fehlerfrei auf diesem Server funktionieren.';
$txt['install_settings_stats'] = 'Sammeln von Statistiken erlauben';
$txt['install_settings_stats_title'] = 'Simple Machines erlauben, monatlich grundlegende Statistiken zu sammeln';
$txt['install_settings_stats_info'] = 'Falls aktiviert, erlaubt dies Simple Machines, Ihre Webseite monatlich zu besuchen, um grundlegende Statistiken zu sammeln. Dies hilft uns, Entscheidungen zu treffen, für welche Konfigurationen die Software optimiert wird. Für weitere Informationen besuchen Sie bitte unsere <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">Informationsseite</a>.';
$txt['install_settings_proceed'] = 'Weiter';

$txt['db_settings'] = 'Datenbankserver-Einstellungen';
$txt['db_settings_info'] = 'Geben Sie hier die Einstellungen für Ihren Datenbankserver ein. Sollten Sie diese Daten nicht kennen, fragen Sie Ihren Serveranbieter.';
$txt['db_settings_type'] = 'Datenbanktyp';
$txt['db_settings_type_info'] = 'Mehrere unterstützte Datenbanktypen wurden erkannt – bitte wählen Sie den gewünschten Typ aus. Bitte beachten Sie, dass es nicht möglich ist, SMF-Versionen vor 2.0 RC3 gleichzeitig mit neueren SMF-Versionen in derselben PostgreSQL-Datenbank zu betreiben. In diesem Fall müssen Sie Ihre älteren Installationen aktualisieren.';
$txt['db_settings_server'] = 'Servername';
$txt['db_settings_server_info'] = 'Dies ist fast immer „localhost“ – sollten Sie ihn nicht wissen, versuchen Sie „localhost“.';
$txt['db_settings_username'] = 'Benutzername';
$txt['db_settings_username_info'] = 'Tragen Sie hier den Benutzernamen ein, den Sie zum Verbinden mit Ihrer Datenbank benötigen.<br>Sollten Sie ihn nicht wissen, versuchen Sie den Benutzernamen ihres FTP-Zugangs, da diese oft übereinstimmen.';
$txt['db_settings_password'] = 'Passwort';
$txt['db_settings_password_info'] = 'Tragen Sie hier das Passwort ein, das Sie zum Verbinden mit Ihrer Datenbank benötigen.<br>Sollten Sie es nicht wissen, versuchen Sie das Passwort ihres FTP-Zugangs.';
$txt['db_settings_database'] = 'Datenbankname';
$txt['db_settings_database_info'] = 'Tragen Sie hier den Namen der Datenbank ein, die Sie für die Speicherung der SMF-Daten benutzen möchten.';
$txt['db_settings_database_info_note'] = 'Falls diese Datenbank nicht existiert, wird dieses Installationsskript versuchen, sie zu erstellen.';
$txt['db_settings_port'] = 'Datenbank-Port';
$txt['db_settings_port_info'] = 'Lassen Sie dies leer, um den Standardwert zu verwenden';
$txt['db_settings_prefix'] = 'Tabellenpräfix';
$txt['db_settings_prefix_info'] = 'Das Präfix (Vorsilbe) für jede Tabelle in der Datenbank. <strong>Installieren Sie niemals zwei Foren mit demselben Präfix!</strong><br>Diese Option erlaubt mehrere Installationen in einer Datenbank.';
$txt['db_populate'] = 'Datenbank befüllt';
$txt['db_populate_info'] = 'Ihre Einstellungen wurden gespeichert und die Datenbank mit den erforderlichen Werten befüllt, um Ihr Forum funktionstüchtig zu machen. Zusammenfassung der Initialisierung:';
$txt['db_populate_info2'] = 'Klicken Sie „Weiter“ um zur Administrationskonto-Erzeugungsseite zu gelangen.';
$txt['db_populate_inserts'] = '%1$d Zeilen eingefügt.';
$txt['db_populate_tables'] = '%1$d Tabellen erstellt.';
$txt['db_populate_insert_dups'] = '%1$d doppelte Einträge ignoriert.';
$txt['db_populate_table_dups'] = '%1$d doppelte Tabellen ignoriert.';

$txt['user_settings'] = 'Erstellen Sie Ihr Konto';
$txt['user_settings_info'] = 'Das Installationsprogramm wird nun ein neues Administratorkonto für Sie erstellen.';
$txt['user_settings_username'] = 'Ihr Benutzername';
$txt['user_settings_username_info'] = 'Tragen Sie hier den Namen ein, mit dem Sie sich einloggen möchten.<br>Dies kann später geändert werden.';
$txt['user_settings_password'] = 'Passwort';
$txt['user_settings_password_info'] = 'Tragen Sie hier das gewünschte Passwort ein und merken Sie es sich gut!';
$txt['user_settings_again'] = 'Passwort';
$txt['user_settings_again_info'] = '(Zur Bestätigung).';
$txt['user_settings_admin_email'] = 'E-Mail-Adresse des Administrators';
$txt['user_settings_admin_email_info'] = 'Geben Sie Ihre E-Mail-Adresse an. Dies muss eine gültige E-Mail-Adresse sein!';
$txt['user_settings_server_email'] = 'E-Mail-Adresse des Webmasters';
$txt['user_settings_server_email_info'] = 'Geben Sie <strong>die E-Mail-Adresse ein, die SMF nutzen soll, um E-Mails zu verschicken</strong>. Dies muss eine gültige E-Mail-Adresse sein!';
$txt['user_settings_database'] = 'Datenbank-Passwort';
$txt['user_settings_database_info'] = 'Aus Sicherheitsgründen erfordert das Installationsprogramm die Eingabe des Datenbankpassworts zur Erzeugung eines Administrations-Kontos.';
$txt['user_settings_skip'] = 'Überspringen';
$txt['user_settings_skip_sure'] = 'Sind Sie sicher, dass Sie die Erzeugung des Administratorkontos überspringen möchten?';
$txt['user_settings_proceed'] = 'Fertigstellen';

$txt['ftp_checking_writable'] = 'Überprüfe, ob Dateien geschrieben werden können';
$txt['ftp_setup'] = 'FTP-Verbindungsinformationen';
$txt['ftp_setup_info'] = 'Dieses Installationsprogramm kann sich per FTP mit dem Server verbinden und die Dateien beschreibbar machen, die es erfordern. Sollte dies nicht funktionieren, müssen Sie sich selbst einloggen und dies manuell machen. Bitte beachten Sie, dass hierfür SSL momentan nicht unterstützt wird.';
$txt['ftp_setup_why'] = 'Was macht dieser Schritt?';
$txt['ftp_setup_why_info'] = 'Einige Dateien müssen beschreibbar sein, damit SMF richtig funktioniert. Dieser Schritt ermöglicht dem Installationsskript, dies selbsttätig zu ändern. In manchen Fällen kann es vorkommen, dass dies nicht funktioniert – ändern Sie dann bitte bei folgenden Dateien die Berechtigungen auf 777 (beschreibbar, 755 auf einigen Servern):';
$txt['ftp_setup_again'] = 'Erneut testen, ob die Dateien beschreibbar sind.';

$txt['error_missing_files'] = 'Einige wichtige Dateien konnten im Verzeichnis des Installationsskripts nicht gefunden werden!<br><br>Bitte vergewissern Sie sich, dass Sie alle Dateien – inklusive der sql-Datei – hochgeladen haben und versuchen Sie es erneut.';
$txt['error_session_save_path'] = 'Bitte informieren Sie Ihren Serveranbieter, dass der <strong>session.save_path in der Datei php.ini</strong> ungültig ist! Der Pfad sollte auf ein Verzeichnis verweisen, das <strong>existiert</strong> und vom Benutzer, unter dem PHP läuft, <strong>beschreibbar</strong> ist.<br>';
$txt['error_windows_chmod'] = 'Sie benutzen einen Windows-Server und einige wichtige Dateien sind nicht beschreibbar. Bitten Sie Ihren Serveranbieter um <strong>Schreibberechtigungen</strong> für den Benutzer, unter dem PHP läuft, für die Dateien Ihrer SMF-Installation. Die folgenden Dateien müssen beschreibbar sein:';
$txt['settings_error'] = 'Ihre Einstellungen kontnen nicht in Settings.php gespeichert werden.';
$txt['error_ftp_no_connect'] = 'Die Verbindung zum FTP-Server ist mit den angegebenen Daten nicht möglich.';
$txt['error_db_file'] = 'Das Datenbankskript kann nicht gefunden werden! Bitte prüfen Sie, ob sich die Datei „%1$s“ im Forumsverzeichnis befindet.';
$txt['error_db_connect'] = 'Die Verbindung zum Datenbankserver kann mit den angegebenen Daten nicht aufgebaut werden.<br><br>Wenn Sie nicht sicher sind, was Sie eingeben müssen, kontaktieren Sie Ihren Serveranbieter.';
$txt['error_db_connect_settings'] = 'Die Verbindung kann nicht aufgebaut werden.<br><br>Bitte überprüfen Sie, dass die Datenbank-Verbindungsinformationen in der Datei "Settings.php" korrekt sind.';
$txt['error_db_database'] = 'Das Installationsskript konnte nicht auf die Datenbank „<em>%1$s</em>“ zugreifen. Bei manchen Hosts müssen Sie die Datenbank zuerst im Administrationsbereich erstellen, bevor Sie diese nutzen können. Andere Hosts fügen ein Präfix – z. B. Ihren Benutzernamen – zu dem Datenbanknamen hinzu.';
$txt['error_db_queries'] = 'Einige der Anfragen konnten nicht ausgeführt werden. Dies kann verursacht werden durch eine nicht unterstützte Version der Datenbanksoftware (Entwicklerversion oder veraltet).<br><br>Technische Informationen zu den Abfragen:';
$txt['error_db_queries_line'] = 'Zeile #';
$txt['error_db_missing'] = 'Das Installationsskript konnte keine Datenbankunterstützung in PHP erkennen. Bitte fragen Sie Ihren Serveranbieter, ob PHP mit Unterstützung für die gewünschte Datenbank kompiliert wurde und ob die richtige Erweiterung geladen wird.';
$txt['error_db_script_missing'] = 'Das Installationsskript konnte keine Installationsskripte für den gewählten Datenbanktyp finden. Bitte prüfen Sie, dass alle benötigten Installationsskripte in das Forumsverzeichnis hochgeladen wurden, zum Beispiel „%1$s“';
$txt['error_session_missing'] = 'Das Installationsskript konnte keine Unterstützung für Sitzungen in Ihrer PHP-Umgebung finden. Bitten Sie Ihren Serveranbieter, sicherzustellen, dass PHP mit Sitzungsunterstützung kompiliert wurde (dies ist eigentlich Standard und bedeutet, dass Ihr Serveranbieter dies momentan explizit deaktiviert hat).';
$txt['error_user_settings_again_match'] = 'Sie haben zwei verschiedene Passwörter eingegeben!';
$txt['error_user_settings_no_password'] = 'Ihr Passwort muss mindestens vier Zeichen lang sein.';
$txt['error_user_settings_taken'] = 'Ein Mitglied ist bereits mit diesem Benutzernamen und/oder dieser E-Mail-Adresse registriert.<br><br>Es wurde kein neues Benutzerkonto erstellt.';
$txt['error_user_settings_query'] = 'Ein Datenbankfehler ist beim Erstellen des Administratorkontos aufgetreten. Der Fehler lautet:';
$txt['error_sourcefile_missing'] = 'Die Datei „Sources/%1$s“ konnte nicht gefunden werden. Bitte überprüfen Sie, dass sie erfolgreich hochgeladen wurde und versuchen Sie es dann nochmal.';
$txt['error_db_alter_priv'] = 'Der Datenbankzugang, den Sie angegeben haben, hat keine ALTER-, CREATE- und/oder DROP-Berechtigung für Tabellen in der Datenbank. Dies ist notwendig, damit SMF reibungslos funktioniert.';
$txt['error_versions_do_not_match'] = 'Das Installationsskript hat eine andere Version von SMF gefunden, die bereits mit den angegebenen Informationen installiert ist. Wenn Sie das Forum aktualisieren möchten, sollten Sie das Aktualisierungsskript benutzen, nicht das Installationsskript.<br><br>Andernfalls können Sie andere Zugangsdaten benutzen oder ein Backup erstellen und anschließend die vorhandenen Daten in der Datenbank löschen.';
$txt['error_mod_security'] = 'Das Installationsskript hat das Modul „mod_security“ auf Ihrem Server gefunden. mod_security blockiert gesendete Formulardaten, bevor SMF etwas dagegen unternehmen kann. SMF hat einen eingebauten Sicherheits-Scanner, der effektiver als mod_security arbeitet und keine Formulardaten blockiert.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Mehr Informationen zum Deaktivieren von mod_security</a>';
$txt['error_mod_security_no_write'] = 'Das Installationsskript hat erkannt, dass das „mod_security“-Modul auf Ihrem Webserver installiert ist. mod_security blockiert abgeschickte Formulardaten, bevor SMF eingreifen kann. SMF hat einen eingebauten Sicherheits-Scanner, der effizienter als mod_security arbeitet und keine Formulardaten blockiert.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Weitere Informationen zum Deaktivieren von mod_security</a><br><br>Alternativ können Sie mit Ihrem FTP-Programm die Datei „.htaccess“ beschreibbar machen (777) und die Seite neu laden.';
$txt['error_utf8_version'] = 'Die aktuelle Version Ihrer Datenbank unterstützt den UTF-8-Zeichensatz nicht. Sie können SMF trotzdem installieren, müssen jedoch die UTF-8-Unterstützung deaktivieren. Möchten Sie in Zukunft zu UTF-8 wechseln (z. B. nachdem Ihre Datenbank auf Version >= %1$s aktualisiert wurde), können Sie dies über den Administrationsbereich tun.';
$txt['error_valid_admin_email_needed'] = 'Sie haben keine gültige E-Mail-Adresse für Ihr Administrator-Benutzerkonto angegeben.';
$txt['error_valid_server_email_needed'] = 'Sie haben keine gültige Webmaster-E-Mail-Adresse angegeben.';
$txt['error_already_installed'] = 'Das Installationsskript hat erkannt, dass Sie SMF bereits installiert haben. Es wird empfohlen, dass Sie <strong>nicht</strong> versuchen, die vorhandene Installation zu überschreiben – sollten Sie fortfahren, <strong>kann dies zu Datenverlust führen oder die existierenden Daten beschädigen</strong>.<br><br>Falls Sie Ihr Forum aktualisieren wollen, besuchen Sie bitte die <a href="https://www.simplemachines.org">Simple-Machines-Webseite</a> und laden Sie das neueste <em>Aktualisierungs</em>-Paket herunter.<br><br>Falls Sie Ihre aktuelle Installation inklusive aller Daten trotzdem überschreiben wollen, wird empfohlen, dass Sie vorher alle existierenden Datenbanktabellen löschen, die Datei „Settings.php“ ersetzen und es dann erneut versuchen.';
$txt['error_warning_notice'] = 'Warnung!';
$txt['error_script_outdated'] = 'Dieses Installationsskript ist veraltet! Die aktuelle Version von SMF ist %1$s, das Installationsskript ist jedoch für Version %2$s.<br><br>
	Es ist empfehlenswert, die <a href="https://www.simplemachines.org">Simple-Machines</a>-Webseite zu besuchen, um sicherzustellen, dass Sie die neueste Version installieren.';
$txt['error_db_prefix_numeric'] = 'Der gewählte Datenbanktyp unterstützt keine numerischen Präfixe.';
$txt['error_pg_scs'] = 'PostgreSQL ist falsch konfiguriert. Bitte schalten Sie den Konfigurationsparameter „standard_conforming_strings“ ein.';
$txt['error_invalid_characters_username'] = 'Ungültiges Zeichen im Benutzernamen verwendet.';
$txt['error_username_too_long'] = 'Benutzername darf maximal 25 Zeichen lang sein.';
$txt['error_username_left_empty'] = 'Das Benutzernamensfeld wurde leer gelassen.';
$txt['error_db_prefix_reserved'] = 'Das Präfix, das Sie eingegeben haben, ist reserviert. Bitte geben Sie ein anderes an.';
$txt['error_utf8_support'] = 'Die Datenbank, die Sie benutzen möchten, verwendet keinen UTF8-Zeichensatz';

$txt['ftp_login'] = 'Ihre FTP-Zugangsdaten';
$txt['ftp_login_info'] = 'Dieses Web-Installationsskript benötigt Ihre FTP-Daten, um die Installation für Sie zu automatisieren. Bitte beachten Sie, dass diese Daten nicht gespeichert werden, sondern lediglich während der SMF-Installation genutzt werden.';
$txt['ftp_server'] = 'Server';
$txt['ftp_server_info'] = 'Die Adresse (oft „localhost“) und der Port Ihres FTP-Servers.';
$txt['ftp_port'] = 'Port';
$txt['ftp_username'] = 'Benutzername';
$txt['ftp_username_info'] = 'Der Benutzername zum Einloggen. <em>Dies wird nicht gespeichert.</em>';
$txt['ftp_password'] = 'Passwort';
$txt['ftp_password_info'] = 'Das Passwort zum Einloggen. <em>Dies wird nicht gespeichert.</em>';
$txt['ftp_path'] = 'Installationspfad';
$txt['ftp_path_info'] = 'Dies ist der <em>relative</em> Pfad, den Sie im FTP-Client benutzen.';
$txt['ftp_path_found_info'] = 'Der Pfad in der oberen Box wurde automatisch ausgelesen.';
$txt['ftp_path_help'] = 'Ihr FTP-Pfad ist das (relative) Verzeichnis, das Sie sehen, wenn Sie sich mit Ihrem FTP-Client auf Ihrem Server einloggen. Häufig beginnt dieser mit „<pre>www</pre>“, „<pre>public_html</pre>“ oder „<pre>httpdocs</pre>“. Ihr SMF-Verzeichnis sollte unterhalb Ihres FTP-Pfades liegen, z. B. „public_html/forum“. Ihr FTP-Pfad unterscheidet sich von Ihrer URL und ihrem vollen Pfad.<br><br>Dateien in diesem Pfad könnten überschrieben werden, also stellen Sie sicher, dass dieser korrekt ist.';
$txt['ftp_path_help_close'] = 'Schließen';
$txt['ftp_connect'] = 'Verbinden';

$txt['force_ssl'] = 'SSL aktivieren';
$txt['force_ssl_label'] = 'SSL überall im Forum erzwingen';
$txt['force_ssl_info'] = 'Stellen Sie sicher, dass SSL und HTTPS überall im Forum unterstützt werden, sonst könnte Ihr Forum unerreichbar werden';

$txt['chmod_linux_info'] = 'Falls Sie einen Shell-Zugang haben, kann der Befehl unterhalb automatisch die Berechtigungen dieser Dateien korrigieren';

// The upgrader needs text strings too!
$txt['upgrade_step_login'] = 'Einloggen';
$txt['upgrade_step_options'] = 'Aktualisierungs-Optionen';
$txt['upgrade_step_backup'] = 'Sicherung';
$txt['upgrade_step_database'] = 'Datenbank-Änderungen';
$txt['upgrade_step_convertutf'] = 'Umstellung auf UTF-8';
$txt['upgrade_step_convertjson'] = 'Serialisierte Strings zu JSON konvertieren';
$txt['upgrade_step_delete'] = 'Upgrade.php löschen';

$txt['upgrade_upgrade_utility'] = 'SMF-Aktualisierungs-Dienstprogramm';
$txt['upgrade_warning'] = 'Warnung!';
$txt['upgrade_critical_error'] = 'Kritischer Fehler!';
$txt['upgrade_continue'] = 'Weiter';
$txt['upgrade_skip'] = 'Überspringen';
$txt['upgrade_note'] = 'Hinweis!';
$txt['upgrade_step'] = 'Schritt';
$txt['upgrade_steps'] = 'Schritte';
$txt['upgrade_progress'] = 'Fortschritt';
$txt['upgrade_overall_progress'] = 'Gesamtfortschritt';
$txt['upgrade_step_progress'] = 'Fortschritt dieses Schritts';
$txt['upgrade_time_elapsed'] = 'Verstrichene Zeit';
$txt['upgrade_time_mins'] = 'Minuten';
$txt['upgrade_time_secs'] = 'Sekunden';
$txt['upgrade_username'] = 'Benutzername:';
$txt['upgrade_wrong_username'] = 'Benutzername falsch';
$txt['upgrade_password'] = 'Passwort:';
$txt['upgrade_wrong_password'] = 'Passwort falsch';
$txt['upgrade_script_timeout_minutes'] = 'Dieses Aktualisierungsskript kann nicht ausgeführt werden, bis %1$s für mindestens %2$d Minuten inaktiv war';
$txt['upgrade_script_timeout_seconds'] = 'Dieses Aktualisierungsskript kann nicht ausgeführt werden, bis %1$s für mindestens %2$d Sekunden inaktiv war';

$txt['upgrade_wait'] = 'Bitte warten Sie, während ein Backup erzeugt wird. Bei großen Foren kann dies einige Zeit dauern!';
$txt['upgrade_wait2'] = 'Bitte warten Sie, während Ihre Datenbank auf UTF-8 konvertiert wird. Für große Foren kann dies einige Zeit dauern!';
$txt['upgrade_sec_login'] = 'Aus Sicherheitsgründen loggen Sie sich bitte mit Ihrem Administratoren-Benutzerkonto ein, um mit der Aktualisierung fortzufahren.';
$txt['upgrade_incomplete'] = 'Unvollständig';
$txt['upgrade_not_quite_done'] = 'Noch nicht ganz fertig!';
$txt['upgrade_paused_overload'] = 'Diese Aktualisierung wurde pausiert, um eine Überbeanspruchung des Servers zu vermeiden. Keine Sorge, alles ist in Ordnung – klicken Sie einfach unten den <label for="contbutt">Weiter-Button</label>, um die Aktualisierung fortzusetzen.';
$txt['upgrade_continue_step'] = 'Setzen Sie an der Stelle fort, die Sie bei der letzten Ausführung des Aktualisierungsskripts erreicht haben.';
$txt['upgrade_bypass'] = '<strong>Hinweis:</strong> Falls notwendig, kann die obige Sicherheitsprüfung von Benutzern, die zwar den Server administrieren, aber keine Administrationsberechtigungen im Forum haben, umgangen werden. Um die Prüfung zu umgehen, öffnen Sie die Datei „upgrade.php“ in einem Texteditor, ersetzen Sie „$disable_security = false;“ mit „$disable_security = true;“ und laden Sie diese Seite erneut.';
$txt['upgrade_areyouready'] = 'Bevor die Aktualisierung beginnt, prüfen Sie bitte die Optionen unterhalb – und klicken Sie „Weiter“, sobald Sie bereit sind.';
$txt['upgrade_backup_table'] = 'Sicherung der Datenbanktabellen mit dem folgenden Präfix durchführen';
$txt['upgrade_backup_complete'] = 'Sicherung abgeschlossen! Klicken Sie „Weiter“ um fortzufahren.';
$txt['upgrade_recommended'] = 'empfohlen!';
$txt['upgrade_maintenance'] = 'Das Forum während der Aktualisierung in den Wartungsmodus versetzen.';
$txt['upgrade_maintenance_title'] = 'Wartungstitel:';
$txt['upgrade_maintenance_message'] = 'Wartungsnachricht:';
$txt['upgrade_customize'] = 'Anpassen';
$txt['upgrade_debug_info'] = 'Zusätzliche Debug-Informationen ausgeben.';
$txt['upgrade_empty_errorlog'] = 'Fehlerprotokoll vor der Aktualisierung leeren.';
$txt['upgrade_delete_karma'] = 'Alle Karma-Einstellungen und -Informationen aus der Datenbank löschen';
$txt['upgrade_reprocess_attachments'] = 'Dateianhangskonvertierung erneut durchführen';
$txt['upgrade_stats_collection'] = 'Simple Machines das monatliche Sammeln von grundlegenden Statistiken erlauben.';
$txt['upgrade_stats_info'] = 'Falls aktiviert, erlaubt dies Simple Machines, Ihre Webseite monatlich zu besuchen, um grundlegende Statistiken zu sammeln. Dies hilft uns, Entscheidungen zu treffen, für welche Konfigurationen die Software optimiert wird. Für weitere Informationen besuchen Sie bitte unsere <a href="%1$s" target="_blank" rel="noopener">Informationsseite</a>.';
$txt['upgrade_migrate_settings_file'] = 'Auf eine neue Einstellungs-Datei migrieren.';
$txt['upgrade_db_changes'] = 'Datenbank-Änderungen werden durchgeführt';
$txt['upgrade_db_patient'] = 'Bitte warten Sie – dies könnte in großen Foren einige Zeit dauern. Die verstrichene Zeit wird vom Server aktualisiert, um den Fortschritt anzuzeigen.';
$txt['upgrade_db_complete'] = '1 Datenbank-Aktualisierung abgeschlossen! Klicken Sie auf „Weiter“, um fortzufahren.';
$txt['upgrade_db_complete2'] = 'Datenbank-Aktualisierungen abgeschlossen! Klicken Sie auf „Weiter“, um fortzufahren.';
$txt['upgrade_script'] = 'Aktualisierungsskript wird ausgeführt';
$txt['upgrade_error'] = 'Fehler!';
$txt['upgrade_unknown_error'] = 'Unbekannter Fehler!';
/* Same sentence, 3 different strings */
$txt['upgrade_completed'] = 'Abgeschlossen';
$txt['upgrade_outof'] = 'von';
$txt['upgrade_tables'] = 'Tabellen.';

$txt['upgrade_run_script'] = 'Wir empfehlen, dass Sie dieses Skript nicht ausführen, es sei denn, Sie sind sich sicher, dass';
$txt['upgrade_run_script2'] = 'seine/ihre Aktualisierung abgeschlossen hat.';
$txt['upgrade_run'] = 'Sie können die Aktualisierung entweder nochmal von vorne beginnen oder beim letzten Schritt fortsetzen, den Sie während der letzten Aktualisierung erreicht haben.';

$txt['upgrade_completed_table'] = 'Tabelle abgeschlossen:';
$txt['upgrade_current_table'] = 'Aktuelle Tabelle:';
$txt['upgrade_fulltext'] = 'Bitte beachten Sie, dass Ihr Volltext-Index entfernt wurde, um die Konvertierung zu ermöglichen. Sie müssen ihn manuell im Administrationsbereich wieder erzeugen, nachdem die Aktualisierung abgeschlossen ist.';
$txt['upgrade_conversion_proceed'] = 'Konvertierung abgeschlossen! Klicken Sie „Weiter“ um fortzufahren.';
$txt['upgrade_convert_datajson'] = 'Konvertiere Daten von PHP-Serialisierung zu JSON…';
$txt['upgrade_json_completed'] = 'Konvertierung zu JSON abgeschlossen! Klicken Sie "Weiter" um fortzufahren.';
$txt['upgrade_executing'] = 'Führe aus:';
$txt['upgrade_of'] = 'von';
$txt['upgrade_admin_login'] = 'Admin-Login:';
$txt['upgrade_admin_disabled'] = '(DEAKTIVIERT)';
$txt['upgrade_done'] = 'Aktualisierung abgeschlossen. Sie können <a href="%1$s/index.php">Ihre Installation von SMF</a> nun nutzen. Wir hoffen, es gefällt Ihnen!';

$txt['upgrade_delete_now'] = 'upgrade.php und dessen Dateien jetzt löschen';
$txt['upgrade_delete_server'] = '(funktioniert nicht auf allen Servern).';
$txt['upgrade_problems'] = 'Falls Sie während der Aktualisierung irgendwelche Probleme hatten oder Probleme bei der Benutzung von SMF haben, zögern Sie bitte nicht, <a href="%1$s">uns um Hilfe zu fragen</a>.';
$txt['upgrade_luck'] = 'Viel Glück,';

$txt['upgrade_ftp_login'] = 'Ihre FTP-Verbindungsinformationen';
$txt['upgrade_ftp_perms'] = 'Das Aktualisierungsskript kann Dateiberechtigungsprobleme beheben, um die Aktualisierung so einfach wie möglich zu machen. Geben Sie einfach unten Ihre Zugangsdaten ein oder klicken Sie <a href="#" onclick="warning_popup();">hier</a> für eine Liste der Dateien, die geändert werden müssen.';
$txt['upgrade_ftp_warning'] = 'Warnung';
$txt['upgrade_ftp_files'] = 'Die folgenden Dateien müssen beschreibbar sein, um fortzufahren:';
$txt['upgrade_ftp_shell'] = 'Falls Sie einen Shell-Zugang haben, kann der Befehl unterhalb automatisch die Berechtigungen dieser Dateien korrigieren';
$txt['upgrade_ftp_error'] = 'Der folgende Fehler ist beim Verbindungsversuch aufgetreten:';

$txt['upgrade_ready_proceed'] = 'Danke, dass Sie sich entschieden haben, auf SMF %1$s zu aktualisieren. Alle Dateien scheinen am richtigen Ort zu sein und die Aktualisierung kann nun weitergehen.';
$txt['upgrade_error_script_js'] = 'Das Aktualisierungsskript kann die Datei "script.js" nicht finden oder sie ist veraltet. Stellen Sie sicher, dass die Theme-Pfade korrekt sind. Sie können ein Einstellungsprüfungs-Dienstprogramm von der <a href="https://www.simplemachines.org">Simple-Machines-Webseite</a> herunterladen.';
$txt['upgrade_warning_lots_data'] = 'Dieses Aktualisierungsskript hat festgestellt, dass Ihr Forum viele Daten enthält, die einer Aktualisierung bedürfen. Dieser Prozess kann je nach Größe Ihres Servers und Forums einige Zeit in Anspruch nehmen. Für sehr große Foren (~300.000 Nachrichten) kann dies mehrere Stunden dauern.';
$txt['upgrade_warning_out_of_date'] = 'Dieses Aktualisierungsskript ist nicht mehr auf dem neuesten Stand! Die aktuelle Version von SMF ist <em id="smfVersion" style="white-space: nowrap;">??</em>, aber dieses Aktualisierungsskript ist für Version <em id="yourVersion" style="white-space: nowrap;">%1$s</em>.<br><br>Es wird empfohlen, dass Sie die <a href="%2$s">Simple-Machines-Webseite</a> besuchen, um sicherzustellen, dass Sie auf die aktuelle Version aktualisieren.';

$txt['upgrade_forumdir_settings'] = 'Ihre Forumsverzeichnis-Einstellungen <em>könnten</em> falsch sein. Ihr Forums-Hauptverzeichnis ist momentan auf „%1$s“ gesetzt, sollte aber vermutlich „%2$s“ sein. Laut „Settings.php“ sind Ihre Verzeichnisse momentan:';
$txt['upgrade_forumdir'] = 'Forumsverzeichnis:';
$txt['upgrade_sourcedir'] = '„Source“-Verzeichnis:';
$txt['upgrade_cachedir'] = 'Cache-Verzeichnis:';
$txt['upgrade_incorrect_settings'] = 'Falls diese Angaben falsch sind, öffnen Sie bitte „Settings.php“ in einem Texteditor, bevor Sie diese Aktualisierung fortsetzen. Falls sie falsch sind, weil Sie Ihr Forum an einen neuen Ort umziehen, laden Sie bitte das „<a href="https://download.simplemachines.org/?tools">Repair Settings</a>“-Dienstprogramm von der Simple-Machines-Webseite herunter und führen Sie es aus, bevor Sie fortfahren.';

$txt['upgrade_fulltext_error'] = 'Ihr Volltext-Suchindex wurde entfernt, um die Konvertierung zu ermöglichen. Sie werden ihn neu erzeugen müssen.';
$txt['upgrade_writable_files'] = 'Die folgenden Dateien müssen beschreibbar sein, um die Aktualisierung fortzusetzen. Bitte stellen Sie sicher, dass die Windows-Berechtigungen korrekt gesetzt sind und dies erlauben:';
$txt['upgrade_time_user'] = '„%1$s“ führt das Aktualisierungsskript aus.';

// We represent the time here in backwards variables, as it makes the code easier.
$txt['upgrade_time_hms'] = 'Das Aktualisierungsskript läuft seit %3$d Stunden, %2$d Minuten und %1$d Sekunden.';
$txt['upgrade_time_ms'] = 'Das Aktualisierungsskript läuft seit %2$d Minuten und %1$d Sekunden.';
$txt['upgrade_time_s'] = 'Das Aktualisierungsskript läuft seit %1$d Sekunden.';
$txt['upgrade_time_updated_hms'] = 'Das Aktualisierungsskript wurde zuletzt vor %3$d Stunden, %2$d Minuten und %1$d Sekunden aktualisiert.';
$txt['upgrade_time_updated_hm'] = 'Das Aktualisierungsskript wurde zuletzt vor %2$d Minuten und %1$d Sekunden aktualisiert.';
$txt['upgrade_time_updated_s'] = 'Das Aktualisierungsskript wurde zuletzt vor %1$d Sekunden aktualisiert.';
$txt['upgrade_completed_time_hms'] = 'Aktualisierung abgeschlossen in %3$d Stunden, %2$s Minuten und %1$s Sekunden';
$txt['upgrade_completed_time_ms'] = 'Aktualisierung abgeschlossen in %2$s Minuten und %1$s Sekunden';
$txt['upgrade_completed_time_s'] = 'Aktualisierung abgeschlossen in %1$s Sekunden';
$txt['upgrade_success_time_db'] = 'Erfolgreich! Datenbank-Aktualisierungen abgeschlossen in %3$d Stunden, %2$d Minuten und %1$d Sekunden.';

$txt['upgrade_unsuccessful'] = 'Fehlgeschlagen!';
$txt['upgrade_thisquery'] = 'Diese Datenbankabfrage:';
$txt['upgrade_causerror'] = 'Verursachte diesen Fehler:';
$txt['upgrade_completedtables_outof'] = '<span id="tab_done">%1$d</span> von %2$d Tabellen abgeschlossen.';
$txt['upgrade_success'] = 'Erfolgreich!';
$txt['upgrade_loop'] = 'Das Aktualisierungsskript scheint sich in einer Endlosschleife zu befinden – Schritt: ';
$txt['upgrade_respondtime'] = 'Der Server hat seit %1$d Sekunden nicht geantwortet. Wahrscheinlich lohnt es sich, noch ein wenig länger zu warten, bevor Sie es erneut versuchen.';
$txt['upgrade_respondtime_clickhere'] = 'Klicken Sie hier, um es erneut zu versuchen.';
$txt['mtitle'] = 'Aktualisiere das Forum…';
$txt['mmessage'] = 'Keine Sorge, Ihr Forum wird in Kürze aktualisiert sein. Es wird nur einen Augenblick dauern ;).';

// Upgrader error messages
// argument(s): template name (if applicable)
$txt['error_unexpected_template_call'] = 'Fehler: Unerwarteter Aufruf bei Benutzung der „%1$s“-Vorlage. Bitte kopieren Sie den vollständigen Text oberhalb und besuchen Sie das SMF-Supportforum, um die Entwickler über diesen Bug zu informieren.';
$txt['error_invalid_template'] = 'Aktualisierung abgebrochen! Ungültige Vorlage: template_%1$s';
$txt['error_lang_index_missing'] = 'Das Aktualisierungsskript konnte keine Sprachdateien für die ausgewählte Sprache "%1$s" finden.<br><br>SMF wird ohne installierte Sprachdateien nicht in dieser Sprache funktionieren.<br><br>Bitte installieren Sie sie, oder <a href="%2$s?step=0;lang=english">versuchen Sie es auf Englisch</a>.';
$txt['error_upgrade_files_missing'] = 'Das Aktualisierungsskript konnte einige wichtige Dateien nicht finden.<br><br>Bitte stellen Sie sicher, dass Sie alle Dateien im Paket hochgeladen haben, einschließlich der "Themes"-, "Sources"- und anderer Verzeichnisse.';
$txt['error_upgrade_old_files'] = 'Das Aktualisierungsskript hat einige alte oder veraltete Dateien gefunden.<br><br>Bitte stellen Sie sicher, dass Sie die neuen Versionen aller Dateien im Paket hochgeladen haben.';
$txt['error_upgrade_old_lang_files'] = 'Das Aktualisierungsskript hat einige alte oder veraltete Sprachdateien für die ausgewählte Sprache "%1$s" gefunden.<br><br>Bitte stellen Sie sicher, dass Sie die neuen Versionen aller Dateien im Paket hochgeladen haben, inklusive Theme- und Sprachdateien des Standard-Themes.<br>&nbsp;&nbsp;&nbsp;[<a href="%2$s?skiplang">Überspringen</a>] [<a href="%2$s?lang=english">Versuchen Sie es auf Englisch</a>]';
$txt['error_php_too_low'] = 'Achtung! Auf Ihrem Server scheint eine PHP-Version installiert zu sein, die nicht den Mindestanforderungen von SMF entspricht.<br><br>Bitten Sie Ihren Serveranbieter um eine Aktualisierung.';
$txt['error_db_too_low'] = 'Ihre Datenbank-Version „%1$s“ genügt nicht den Mindestanforderungen von SMF.<br><br>Bitten Sie Ihren Serveranbieter um eine Aktualisierung.';
$txt['error_db_privileges'] = 'Der in der Datei „Settings.php“ angegebene Benutzer „%1$s“ hat keine passenden Berechtigungen.<br><br>Bitten Sie Ihren Serveranbieter, diesem Benutzer die Berechtigungen ALTER, CREATE und DROP zu geben.';
$txt['error_dir_not_writable'] = 'Das Verzeichnis "%1$s" muss beschreibbar sein, um die Aktualisierung fortzusetzen. Bitte stellen Sie sicher, dass die Berechtigungen stimmen, um dies zu erlauben.';
$txt['error_cache_not_found'] = 'Das Cache-Verzeichnis konnte nicht gefunden werden.<br><br>Bitte stellen Sie sicher, dass Sie ein Verzeichnis namens „cache“ in Ihrem Forumsverzeichnis haben, bevor Sie fortfahren.';
$txt['error_agreement_not_writable'] = 'Das Aktualisierungsskript konnte die Datei „agreement.txt“ nicht beschreiben.<br><br>Falls Sie einen Linux- oder Unix-basierten Server nutzen, stellen Sie bitte sicher, dass die Datei auf 777 chmod\'et ist oder, falls sie nicht existiert, dass das Verzeichnis, in dem das Aktualisierungsskript liegt, die Berechtigung 777 hat.<br>Falls Ihr Server auf Windows läuft, stellen Sie bitte sicher, dass das Internet-Gastkonto die passenden Berechtigungen für das Skript oder dessen Verzeichnis hat.';
$txt['error_not_admin'] = 'Sie müssen ein Administrator sein, um eine Aktualisierung durchzuführen!';

$txt['warning_lang_old'] = 'Die ausgewählten Sprachdateien für „%1$s“ wurden nicht auf die neueste Version aktualisiert. Die Aktualisierung wird mit der Forums-Standardsprache „%2$s“ fortgesetzt.';
$txt['warning_lang_missing'] = 'Das Aktualisierungsskript konnte die „Install“-Sprachdatei für die von Ihnen gewählte Sprache „%1$s“ nicht finden. Die Aktualisierung wird mit der Forums-Standardsprache „%2$s“ fortgesetzt.';

// Attachment & Avatar folder checks
$txt['warning_av_missing'] = 'Achtung! Profilbild-Verzeichnis nicht gefunden. Fortsetzen könnte unsicher sein. Bitte bestätigen Sie die Verzeichniseinstellungen bevor Sie fortfahren.';
$txt['warning_custom_av_missing'] = 'Achtung! Benutzerdefiniertes-Profilbild-Verzeichnis nicht gefunden. Fortsetzen könnte unsicher sein. Bitte bestätigen Sie die Verzeichniseinstellungen bevor Sie fortfahren.';
$txt['warning_att_dir_missing'] = 'Achtung! Ein oder mehrere Dateianhangs-Verzeichnisse nicht gefunden. Fortsetzen könnte unsicher sein. Bitte bestätigen Sie die Verzeichniseinstellungen bevor Sie fortfahren.';

// Page titles
$txt['updating_smf_installation'] = 'Ihre SMF-Installation wird aktualisiert!';
$txt['upgrade_options'] = 'Aktualisierungsoptionen';
$txt['backup_database'] = 'Sichern der Datenbank';
$txt['database_changes'] = 'Datenbankänderungen';
$txt['upgrade_complete'] = 'Aktualisierung abgeschlossen';
$txt['converting_utf8'] = 'Zu UTF-8 konvertieren';
$txt['converting_json'] = 'Zu JSON konvertieren';

?>