<?php

namespace SilverStripe\Reports\ExternalLinks\Model;

use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Reports\ExternalLinks\Model\BrokenExternalPageTrackStatus;
use SilverStripe\Reports\ExternalLinks\Model\BrokenExternalLink;
use SilverStripe\Versioned\Versioned;
use SilverStripe\ORM\DataObject;
use SilverStripe\ORM\HasManyList;

/**
 * Represents a track for a single page
 * @method HasManyList<BrokenExternalLink> BrokenLinks()
 * @method BrokenExternalPageTrackStatus Status()
 */
class BrokenExternalPageTrack extends DataObject
{
    private static $table_name = 'BrokenExternalPageTrack';

    private static $db = array(
        'Processed' => 'Boolean'
    );

    private static $has_one = array(
        'Page' => SiteTree::class,
        'Status' => BrokenExternalPageTrackStatus::class
    );

    private static $has_many = array(
        'BrokenLinks' => BrokenExternalLink::class
    );

    /**
     * @return SiteTree|null
     */
    public function Page()
    {
        return Versioned::get_by_stage(SiteTree::class, 'Stage')
            ->byID($this->PageID);
    }
}
