<?php
/**
 * Docs archive template
 *
 * This template can be overridden by copying it to yourtheme/documentor/archive.php.
 *
 * @author  softaculous
 * @package documentor/Templates
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

documentor()->get_template_part( 'global/wrap-start' );

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <div class="entry-content">
        <?php //documentor()->get_template_part( 'archive/description' ); ?>


<?php documentor()->get_template_part( 'archive/title' );

if ( documentor()->get_option( 'sidebar_show_search', 'documentor_single', true ) ) { ?>
<div class="home_search" style="text-align:center;">
	<form role="search" method="get" class="documentor-search-form width_control" action="<?php echo esc_url( home_url($wp->request) ); ?>">
		<input type="search" class="documentor-search-field search_form_index" placeholder="<?php echo esc_attr__( 'Type to search', 'documentor' ); ?>" value="<?php echo get_search_query(); ?>" name="s" autocomplete="off">
		<input type="hidden" name="post_type" value="docs">
	</form>
	<div class="documentor-search-form-result search_on_index"></div>
</div>
<?php } ?>

        <div class="documentor-archive">
            <ul class="documentor-archive-list">
                <?php
                // phpcs:ignore
                $current_term = false;
				
                if ( have_posts() ) :
                    while ( have_posts() ) :
                        the_post();

                        // phpcs:ignore
                        $terms = wp_get_post_terms( get_the_ID(), 'docs_category' );
                        if (
                            $terms &&
                            ! empty( $terms ) &&
                            isset( $terms[0]->name ) &&
                            $current_term !== $terms[0]->name
                        ) {
                            // phpcs:ignore
                            $current_term = $terms[0]->name;
                            ?>
                            <li class="documentor-archive-list-category">
                                <?php echo esc_html( $terms[0]->name ); ?>
                            </li>
                            <?php
                        }

                        ?>
                        <li class="documentor-archive-list-item">
                            <?php documentor()->get_template_part( 'archive/loop-title' ); ?>
                            <?php documentor()->get_template_part( 'archive/loop-articles' ); ?>
                        </li>
                        <?php
                    endwhile;
                endif;
                ?>
            </ul>
        </div>

        <?php
            wp_link_pages(
                array(
                    'before' => '<div class="page-links">' . __( 'Pages:', 'documentor' ),
                    'after'  => '</div>',
                )
            );
            ?>
    </div>
</article>

<?php

documentor()->get_template_part( 'global/wrap-end' );
