<?php
/**
 * Docs search template
 *
 * This template can be overridden by copying it to yourtheme/documentor/search.php.
 *
 * @author  softaculous
 * @package documentor/Templates
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

documentor()->get_template_part( 'global/wrap-start' );

// phpcs:ignore
$keys = implode( '|', explode( ' ', get_search_query() ) );

?>
<header class="page-header">
	<center>
	<h1 class="page-title">
		<?php
		// translators: %s search query.
		printf( esc_html__( 'Documentation search: "%s"', 'documentor' ), esc_html( get_search_query() ) );
		?>
	</h1>
	</center>
</header><!-- .page-header -->
<?php

if ( documentor()->get_option( 'sidebar_show_search', 'documentor_single', true ) ) { ?>
<div class="home_search" style="text-align:center;">
	<form role="search" method="get" class="documentor-search-form width_control" action="<?php echo esc_url( home_url($wp->request) ); ?>">
		<input type="search" class="documentor-search-field search_form_index" placeholder="<?php echo esc_attr__( 'Type to search', 'documentor' ); ?>" value="<?php echo get_search_query(); ?>" name="s" autocomplete="off">
		<input type="hidden" name="post_type" value="docs">
	</form>
	<div class="documentor-search-form-result search_on_index"></div>
</div>
<?php } ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <div class="entry-content">
        <div class="documentor-search">
            <ul class="documentor-search-list">
                <?php
                if ( have_posts() ) :
                    while ( have_posts() ) :
                        the_post();
                        // highlight search terms in title.
                        // phpcs:disable
                        $title   = wp_trim_words( get_the_title(), 20 );
                        $title   = preg_replace( '/(' . preg_quote($keys, '/') . ')/iu', '<mark>\0</mark>', $title );
                        $excerpt = wp_trim_words( get_the_excerpt(), 50 );
                        $excerpt = preg_replace( '/(' . preg_quote($keys, '/') . ')/iu', '<mark>\0</mark>', $excerpt );
                        // phpcs:enable
                        ?>
                        <li class="documentor-search-list-item">
                            <a href="<?php the_permalink(); ?>">
                                <span class="documentor-search-list-item-title">
                                    <strong><?php echo wp_kses( $title, array( 'mark' => array() ) ); ?></strong>
                                </span>
                                <span class="documentor-search-list-item-excerpt" style="display:block"><?php echo wp_kses( $excerpt, array( 'mark' => array() ) ); ?></span>
                            </a>
                        </li>
                        <?php
                    endwhile;					
					
					echo paginate_links( array(
						'current' => max( 1, get_query_var('paged') ),
						'total' => $wp_query->max_num_pages
					) );		
					
                endif;
                ?>
            </ul>
        </div>

        <?php
            wp_link_pages(
                array(
                    'before' => '<div class="page-links">' . __( 'Pages:', 'documentor' ),
                    'after'  => '</div>',
                )
            );
        ?>
    </div>
</article>
<br>
<?php

documentor()->get_template_part( 'global/wrap-end' );
