<?php

/*
 * This file is part of the Thelia package.
 * http://www.thelia.net
 *
 * (c) OpenStudio <info@thelia.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Thelia\Form\Lang;

use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Validator\Constraints\NotBlank;
use Thelia\Core\Translation\Translator;
use Thelia\Form\BaseForm;

/**
 * Class LangDefaultBehaviorForm.
 *
 * @author Manuel Raynaud <manu@raynaud.io>
 */
class LangDefaultBehaviorForm extends BaseForm
{
    /**
     * in this function you add all the fields you need for your Form.
     * Form this you have to call add method on $this->formBuilder attribute :.
     *
     * $this->formBuilder->add("name", TextType::class)
     *   ->add("email", EmailType::class, array(
     *           "attr" => array(
     *               "class" => "field"
     *           ),
     *           "label" => "email",
     *           "constraints" => array(
     *               new \Symfony\Component\Validator\Constraints\NotBlank()
     *           )
     *       )
     *   )
     *   ->add('age', IntegerType::class);
     *
     * @return null
     */
    protected function buildForm()
    {
        $this->formBuilder
            ->add('behavior', ChoiceType::class, [
                'choices' => [
                    Translator::getInstance()->trans('Strictly use the requested language') => 0,
                    Translator::getInstance()->trans('Replace by the default language') => 1,
                ],
                'constraints' => [
                    new NotBlank(),
                ],
                'label' => Translator::getInstance()->trans('If a translation is missing or incomplete :'),
                'label_attr' => [
                    'for' => 'defaultBehavior-form',
                ],
            ]);
    }

    /**
     * @return string the name of you form. This name must be unique
     */
    public static function getName()
    {
        return 'thelia_lang_defaultBehavior';
    }
}
