<?php

$theme = $_GET['theme'];
$dir = dirname(dirname(dirname(dirname(dirname($_SERVER['SCRIPT_FILENAME']))))).'/sitepad-data/themes';

$file = $dir.'/'.$theme.'/style.css';

// Is the directory valid ?
if(!preg_match('/^\w+$/is', $theme) || !file_exists($dir.'/'.$theme) || empty($theme)){
	die('HACKING ATTEMPT');
}

// We are zipping if possible
if(function_exists('ob_gzhandler') && !ini_get('zlib.output_compression')){
	ob_start('ob_gzhandler');
}

// Handle the url() inside CSS files
function sitepad_css_url($matches){
	
	global $theme;
	
	$orig_url = trim($matches[1], '\'"');
	//r_print($orig_url);
	
	if(preg_match('/data\:(.*)/is', $orig_url)){
		//echo 'Skipping : '.$orig_url."\n";
		return $matches[0];
	}
	
	// If it is an external URL do not make any changes
	if(preg_match('/^http(s?):\/\//is', $orig_url)){
		return $matches[0];
	}
	
	// Relative URls
	$url = '../../../sitepad-data/themes/'.$theme.'/'.$orig_url;
	
	return 'url('.$url.')';
	
}

// Type CSS
header("Content-type: text/css; charset: UTF-8");

// Set a zero Mtime
$filetime = filemtime($file);

// Cache Control
header("Cache-Control: must-revalidate");

// Checking if the client is validating his cache and if it is current.
if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) && (@strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']) >= $filetime)) {
	
	// Client's cache IS current, so we just respond '304 Not Modified'.
	header('Last-Modified: '.gmdate('D, d M Y H:i:s', $filetime).' GMT', true, 304);
	
	return;
	
}else{
	
	// Image not cached or cache outdated, we respond '200 OK' and output the image.
	header('Last-Modified: '.gmdate('D, d M Y H:i:s', $filetime).' GMT', true, 200);
	
}

$css = file_get_contents($file);
$css = preg_replace_callback('/url\(([^\)]*)\)/is', 'sitepad_css_url', $css);

$data = file_get_contents(dirname(__FILE__).'/common-sitepad.css');
$data .= $css;

echo $data;
