<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
abstract class Social extends \Kaltura\Client\ObjectBase
{
	public function getKalturaObjectType()
	{
		return 'KalturaSocial';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->id))
			$this->id = (string)$xml->id;
		if(count($xml->name))
			$this->name = (string)$xml->name;
		if(count($xml->firstName))
			$this->firstName = (string)$xml->firstName;
		if(count($xml->lastName))
			$this->lastName = (string)$xml->lastName;
		if(count($xml->email))
			$this->email = (string)$xml->email;
		if(count($xml->gender))
			$this->gender = (string)$xml->gender;
		if(count($xml->userId))
			$this->userId = (string)$xml->userId;
		if(count($xml->birthday))
			$this->birthday = (string)$xml->birthday;
		if(count($xml->status))
			$this->status = (string)$xml->status;
		if(count($xml->pictureUrl))
			$this->pictureUrl = (string)$xml->pictureUrl;
	}
	/**
	 * Facebook identifier
	 * @var string
	 * @readonly
	 */
	public $id = null;

	/**
	 * Full name
	 * @var string
	 */
	public $name = null;

	/**
	 * First name
	 * @var string
	 */
	public $firstName = null;

	/**
	 * Last name
	 * @var string
	 */
	public $lastName = null;

	/**
	 * User email
	 * @var string
	 */
	public $email = null;

	/**
	 * Gender
	 * @var string
	 */
	public $gender = null;

	/**
	 * User identifier
	 * @var string
	 * @readonly
	 */
	public $userId = null;

	/**
	 * User birthday
	 * @var string
	 */
	public $birthday = null;

	/**
	 * User model status
	 *             Possible values: UNKNOWN, OK, ERROR, NOACTION, NOTEXIST, CONFLICT, MERGE, MERGEOK, NEWUSER, MINFRIENDS, INVITEOK, INVITEERROR, ACCESSDENIED, WRONGPASSWORDORUSERNAME, UNMERGEOK
	 * @var string
	 * @readonly
	 */
	public $status = null;

	/**
	 * Profile picture URL
	 * @var string
	 */
	public $pictureUrl = null;

}
