
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `tiki2112`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[indexName]]`
--

CREATE TABLE `[[indexName]]` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` varchar(235) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `creation_date` datetime DEFAULT NULL,
  `modification_date` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `language` text COLLATE utf8mb4_unicode_ci,
  `gallery_id` text COLLATE utf8mb4_unicode_ci,
  `view_permission` text COLLATE utf8mb4_unicode_ci,
  `attachments` text COLLATE utf8mb4_unicode_ci,
  `primary_image` text COLLATE utf8mb4_unicode_ci,
  `geo_located` text COLLATE utf8mb4_unicode_ci,
  `geo_location` text COLLATE utf8mb4_unicode_ci,
  `allowed_groups` text COLLATE utf8mb4_unicode_ci,
  `allowed_users` text COLLATE utf8mb4_unicode_ci,
  `relations` text COLLATE utf8mb4_unicode_ci,
  `relation_types` text COLLATE utf8mb4_unicode_ci,
  `relation_count` text COLLATE utf8mb4_unicode_ci,
  `title_initial` text COLLATE utf8mb4_unicode_ci,
  `title_firstword` text COLLATE utf8mb4_unicode_ci,
  `searchable` text COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `contents` mediumtext COLLATE utf8mb4_unicode_ci,
  `title_unstemmed` text COLLATE utf8mb4_unicode_ci,
  `lastlogin_date` datetime DEFAULT NULL,
  `currentlogin_date` datetime DEFAULT NULL,
  `user_country` text COLLATE utf8mb4_unicode_ci,
  `user_gender` text COLLATE utf8mb4_unicode_ci,
  `user_homepage` text COLLATE utf8mb4_unicode_ci,
  `user_realName` text COLLATE utf8mb4_unicode_ci,
  `user_allowmsgs` text COLLATE utf8mb4_unicode_ci,
  `user_language` text COLLATE utf8mb4_unicode_ci,
  `user_style` text COLLATE utf8mb4_unicode_ci,
  `user_page` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `object_type` (`object_type`,`object_id`(160))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[indexName]]`
--

INSERT INTO `[[indexName]]` VALUES
(1, 'file gallery', '1', 'File Galleries', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'F', 'File', 'y', 'tiki-list_file_gallery.php?galleryId=1', ' File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'file gallery', '2', 'Users File Galleries', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'U', 'Users', 'y', 'tiki-list_file_gallery.php?galleryId=2', ' Users File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'file gallery', '3', 'Wiki Attachments', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'W', 'Wiki', 'y', 'tiki-list_file_gallery.php?galleryId=3', ' Wiki Attachments  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 'user', 'admin', 'System Administrator', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 'tiki_p_list_users', '', '', 'n', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf', '', '', '', '', 'S', 'System', 'n', 'admin', ' System Administrator [[regtime]]   ', 'System Administrator', '[[regtime]]', '[[regtime]]', '', '', '', 'System Administrator', 'y', 'tokenycfefedxfbytywbaaucdupydwdqbbudw', '', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf'),
(5, 'group', 'Anonymous', 'Anonymous', NULL, NULL, NULL, 'Public users not logged', NULL, NULL, 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Anonymous', 'n', 'Anonymous', ' Anonymous Public users not logged ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'group', 'Registered', 'Registered', NULL, NULL, NULL, 'Users logged into the system', NULL, NULL, 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'R', 'Registered', 'n', 'Registered', ' Registered Users logged into the system ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, 'group', 'Admins', 'Admins', NULL, NULL, NULL, 'Administrator and accounts managers.', NULL, NULL, 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Admins', 'n', 'Admins', ' Admins Administrator and accounts managers. ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `messu_archive`
--

CREATE TABLE `messu_archive` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_messages`
--

CREATE TABLE `messu_messages` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`),
  KEY `userIsRead` (`user`(190),`isRead`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_sent`
--

CREATE TABLE `messu_sent` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `expireref` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob NOT NULL,
  PRIMARY KEY (`sesskey`),
  KEY `expiry` (`expiry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_account`
--

CREATE TABLE `tiki_acct_account` (
  `accountBookId` int(10) unsigned NOT NULL,
  `accountId` int(10) unsigned NOT NULL DEFAULT '0',
  `accountName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `accountNotes` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `accountBudget` double NOT NULL DEFAULT '0',
  `accountLocked` int(1) NOT NULL DEFAULT '0',
  `accountTax` int(11) NOT NULL DEFAULT '0',
  `accountUserId` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`accountBookId`,`accountId`),
  KEY `accountTax` (`accountTax`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_bankaccount`
--

CREATE TABLE `tiki_acct_bankaccount` (
  `bankBookId` int(10) unsigned NOT NULL,
  `bankAccountId` int(10) unsigned NOT NULL,
  `externalNumber` int(10) NOT NULL,
  `bankCountry` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankCode` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankIBAN` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankBIC` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankDelimeter` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ';',
  `bankDecPoint` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `bankThousand` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `bankHasHeader` tinyint(1) NOT NULL DEFAULT '1',
  `fieldNameAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameBookingDate` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `formatBookingDate` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameValueDate` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `formatValueDate` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameBookingText` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameReason` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartName` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartBankCode` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameAmount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amountType` int(10) unsigned NOT NULL,
  `fieldNameAmountSign` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SignPositive` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SignNegative` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`bankBookId`,`bankAccountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_book`
--

CREATE TABLE `tiki_acct_book` (
  `bookId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bookName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bookClosed` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `bookStartDate` date DEFAULT NULL,
  `bookEndDate` date DEFAULT NULL,
  `bookCurrency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'EUR',
  `bookCurrencyPos` int(11) NOT NULL,
  `bookDecimals` int(11) NOT NULL DEFAULT '2',
  `bookDecPoint` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `bookThousand` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `exportSeparator` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ';',
  `exportEOL` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LF',
  `exportQuote` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '"',
  `bookAutoTax` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`bookId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_item`
--

CREATE TABLE `tiki_acct_item` (
  `itemId` int(11) NOT NULL AUTO_INCREMENT,
  `itemBookId` int(10) unsigned NOT NULL,
  `itemJournalId` int(10) unsigned NOT NULL DEFAULT '0',
  `itemAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `itemType` int(1) NOT NULL DEFAULT '-1',
  `itemAmount` double NOT NULL DEFAULT '0',
  `itemText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_journal`
--

CREATE TABLE `tiki_acct_journal` (
  `journalBookId` int(10) unsigned NOT NULL,
  `journalId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `journalDate` date DEFAULT NULL,
  `journalDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `journalCancelled` int(1) NOT NULL DEFAULT '0',
  `journalTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`journalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stack`
--

CREATE TABLE `tiki_acct_stack` (
  `stackBookId` int(10) unsigned NOT NULL,
  `stackId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stackDate` date DEFAULT NULL,
  `stackDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stackTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`stackId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stackitem`
--

CREATE TABLE `tiki_acct_stackitem` (
  `stackBookId` int(10) unsigned NOT NULL,
  `stackItemStackId` int(10) unsigned NOT NULL DEFAULT '0',
  `stackItemAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `stackItemType` int(1) NOT NULL DEFAULT '-1',
  `stackItemAmount` double NOT NULL DEFAULT '0',
  `stackItemText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stackBookId`,`stackItemStackId`,`stackItemAccountId`,`stackItemType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_statement`
--

CREATE TABLE `tiki_acct_statement` (
  `statementBookId` int(10) unsigned NOT NULL,
  `statementAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `statementId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `statementBookingDate` date DEFAULT NULL,
  `statementValueDate` date DEFAULT NULL,
  `statementBookingText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementReason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpart` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpartAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpartBankCode` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementAmount` double NOT NULL,
  `statementJournalId` int(10) unsigned NOT NULL DEFAULT '0',
  `statementStackId` int(11) NOT NULL,
  PRIMARY KEY (`statementId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_tax`
--

CREATE TABLE `tiki_acct_tax` (
  `taxBookId` int(10) unsigned NOT NULL,
  `taxId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taxText` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxAmount` double NOT NULL DEFAULT '0',
  `taxIsFix` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog`
--

CREATE TABLE `tiki_actionlog` (
  `actionId` int(8) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastModif` int(14) DEFAULT NULL,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `categId` int(12) NOT NULL DEFAULT '0',
  `client` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`actionId`),
  KEY `lastModif` (`lastModif`),
  KEY `object` (`object`(100),`objectType`,`action`(100))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_actionlog`
--


-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_conf`
--

CREATE TABLE `tiki_actionlog_conf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`action`,`objectType`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=62 ;

--
-- Dumping data for table `tiki_actionlog_conf`
--

INSERT INTO `tiki_actionlog_conf` VALUES
(1, 'Created', 'wiki page', 'y'),
(2, 'Updated', 'wiki page', 'y'),
(3, 'Removed', 'wiki page', 'y'),
(4, 'Viewed', 'wiki page', 'n'),
(5, 'Viewed', 'forum', 'n'),
(6, 'Posted', 'forum', 'n'),
(7, 'Replied', 'forum', 'n'),
(8, 'Updated', 'forum', 'n'),
(9, 'Viewed', 'file gallery', 'n'),
(10, 'Viewed', 'image gallery', 'n'),
(11, 'Uploaded', 'file gallery', 'n'),
(12, 'Uploaded', 'image gallery', 'n'),
(13, '%', 'category', 'n'),
(14, 'login', 'system', 'y'),
(15, 'Posted', 'message', 'n'),
(16, 'Replied', 'message', 'n'),
(17, 'Viewed', 'message', 'n'),
(18, 'Removed version', 'wiki page', 'n'),
(19, 'Removed last version', 'wiki page', 'n'),
(20, 'Rollback', 'wiki page', 'n'),
(21, 'Removed', 'forum', 'n'),
(22, 'Downloaded', 'file gallery', 'n'),
(23, 'Posted', 'comment', 'n'),
(24, 'Replied', 'comment', 'n'),
(25, 'Updated', 'comment', 'n'),
(26, 'Removed', 'comment', 'n'),
(27, 'Renamed', 'wiki page', 'n'),
(28, 'Created', 'sheet', 'n'),
(29, 'Updated', 'sheet', 'n'),
(30, 'Removed', 'sheet', 'n'),
(31, 'Viewed', 'sheet', 'n'),
(32, 'Viewed', 'blog', 'n'),
(33, 'Posted', 'blog', 'n'),
(34, 'Updated', 'blog', 'n'),
(35, 'Removed', 'blog', 'n'),
(36, 'Removed', 'file', 'n'),
(37, 'Viewed', 'article', 'n'),
(38, '%', 'system', 'y'),
(39, 'feature', 'system', 'y'),
(40, 'Updated', 'trackeritem', 'y'),
(41, 'Created', 'trackeritem', 'y'),
(42, 'Viewed', 'trackeritem', 'y'),
(43, 'Removed', 'trackeritem', 'y'),
(44, 'Created', 'wiki page attachment', 'n'),
(45, 'Removed', 'wiki page attachment', 'n'),
(46, 'Categorized', 'wiki page', 'n'),
(47, 'Uncategorized', 'wiki page', 'n'),
(48, 'Flagged', 'wiki page', 'n'),
(49, 'Fetch', 'url', 'n'),
(50, 'Refresh', 'url', 'n'),
(51, 'Joined Room', 'bigbluebutton', 'n'),
(52, 'Left Room', 'bigbluebutton', 'n'),
(53, 'Created', 'tracker', 'y'),
(54, 'Updated', 'tracker', 'y'),
(55, 'Removed', 'tracker', 'y'),
(56, 'Created', 'category', 'y'),
(57, 'Updated', 'category', 'y'),
(58, 'Removed', 'category', 'y'),
(59, 'Created', 'calendar event', 'n'),
(60, 'Updated', 'calendar event', 'n'),
(61, 'Removed', 'calendar event', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_params`
--

CREATE TABLE `tiki_actionlog_params` (
  `actionId` int(8) NOT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  KEY `actionId` (`actionId`),
  KEY `nameValue` (`name`,`value`(151))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream`
--

CREATE TABLE `tiki_activity_stream` (
  `activityId` int(8) NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eventDate` int(11) NOT NULL,
  `arguments` mediumblob,
  PRIMARY KEY (`activityId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_mapping`
--

CREATE TABLE `tiki_activity_stream_mapping` (
  `field_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`field_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_rules`
--

CREATE TABLE `tiki_activity_stream_rules` (
  `ruleId` int(8) NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruleType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ruleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_address_books`
--

CREATE TABLE `tiki_address_books` (
  `addressBookId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varbinary(200) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`addressBookId`),
  UNIQUE KEY `user` (`user`(141),`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_address_cards`
--

CREATE TABLE `tiki_address_cards` (
  `addressCardId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `addressBookId` int(10) unsigned NOT NULL,
  `carddata` mediumblob,
  `uri` varbinary(200) DEFAULT NULL,
  `lastmodified` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  PRIMARY KEY (`addressCardId`),
  KEY `addressBookId` (`addressBookId`,`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_areas`
--

CREATE TABLE `tiki_areas` (
  `categId` int(11) NOT NULL,
  `perspectives` text COLLATE utf8mb4_unicode_ci,
  `exclusive` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `share_common` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `enabled` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  KEY `categId` (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_articles`
--

CREATE TABLE `tiki_articles` (
  `articleId` int(8) NOT NULL AUTO_INCREMENT,
  `topline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 's',
  `authorName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topicId` int(14) DEFAULT NULL,
  `topicName` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(12) DEFAULT NULL,
  `useImage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_caption` text COLLATE utf8mb4_unicode_ci,
  `image_type` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(14) DEFAULT NULL,
  `image_x` int(4) DEFAULT NULL,
  `image_y` int(4) DEFAULT NULL,
  `list_image_x` int(4) DEFAULT NULL,
  `list_image_y` int(4) DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `body` text COLLATE utf8mb4_unicode_ci,
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nbreads` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` int(14) DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  `isfloat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ispublished` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`articleId`),
  KEY `title` (`title`(191)),
  KEY `heading` (`heading`(191)),
  KEY `body` (`body`(191)),
  KEY `nbreads` (`nbreads`),
  KEY `author` (`author`(32)),
  KEY `topicId` (`topicId`),
  KEY `publishDate` (`publishDate`),
  KEY `expireDate` (`expireDate`),
  KEY `type` (`type`),
  FULLTEXT KEY `ft` (`title`,`heading`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_article_types`
--

CREATE TABLE `tiki_article_types` (
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_ratings` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_pre_publ` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_post_expire` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `heading_only` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_comments` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_image` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_avatar` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_author` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_pubdate` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_expdate` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_reads` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_size` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_topline` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_subtitle` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_linkto` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_image_caption` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `creator_edit` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_can_rate_article` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`type`),
  KEY `show_pre_publ` (`show_pre_publ`),
  KEY `show_post_expire` (`show_post_expire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_article_types`
--

INSERT INTO `tiki_article_types` VALUES
('Article', NULL, NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Review', 'y', NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Event', NULL, NULL, 'n', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Classified', NULL, NULL, 'n', 'y', 'n', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_auth_tokens`
--

CREATE TABLE `tiki_auth_tokens` (
  `tokenId` int(11) NOT NULL AUTO_INCREMENT,
  `creation` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timeout` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '1',
  `maxhits` int(11) NOT NULL DEFAULT '1',
  `token` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameters` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups` text COLLATE utf8mb4_unicode_ci,
  `createUser` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `userPrefix` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '_token',
  PRIMARY KEY (`tokenId`),
  KEY `tiki_auth_tokens_token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banners`
--

CREATE TABLE `tiki_banners` (
  `bannerId` int(12) NOT NULL AUTO_INCREMENT,
  `client` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `which` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageData` longblob,
  `imageType` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageName` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `HTMLData` text COLLATE utf8mb4_unicode_ci,
  `fixedURLData` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `textData` text COLLATE utf8mb4_unicode_ci,
  `fromDate` int(14) DEFAULT NULL,
  `toDate` int(14) DEFAULT NULL,
  `useDates` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tue` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wed` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thu` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fri` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sun` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourFrom` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourTo` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `maxImpressions` int(8) DEFAULT NULL,
  `impressions` int(8) DEFAULT NULL,
  `maxUserImpressions` int(8) DEFAULT '-1',
  `maxClicks` int(8) DEFAULT NULL,
  `clicks` int(8) DEFAULT NULL,
  `zone` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onlyInURIs` text COLLATE utf8mb4_unicode_ci,
  `exceptInURIs` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`bannerId`),
  KEY `ban1` (`zone`,`useDates`,`impressions`,`maxImpressions`,`hourFrom`,`hourTo`,`fromDate`,`toDate`,`mon`,`tue`,`wed`,`thu`,`fri`,`sat`,`sun`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning`
--

CREATE TABLE `tiki_banning` (
  `banId` int(12) NOT NULL AUTO_INCREMENT,
  `mode` enum('user','ip') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip1` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip2` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip3` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip4` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `date_from` timestamp NULL DEFAULT NULL,
  `date_to` timestamp NULL DEFAULT NULL,
  `use_dates` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `attempts` int(11) DEFAULT NULL,
  PRIMARY KEY (`banId`),
  KEY `ban` (`use_dates`,`date_from`,`date_to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning_sections`
--

CREATE TABLE `tiki_banning_sections` (
  `banId` int(12) NOT NULL DEFAULT '0',
  `section` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`banId`,`section`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blogs`
--

CREATE TABLE `tiki_blogs` (
  `blogId` int(8) NOT NULL AUTO_INCREMENT,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `posts` int(8) DEFAULT NULL,
  `maxPosts` int(8) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `activity` decimal(4,2) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `post_heading` text COLLATE utf8mb4_unicode_ci,
  `use_find` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_title` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_title_in_post` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_breadcrumbs` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `use_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_excerpt` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_date` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_poster` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_comments` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `always_owner` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_related` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_max` int(4) DEFAULT '5',
  PRIMARY KEY (`blogId`),
  KEY `title` (`title`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_activity`
--

CREATE TABLE `tiki_blog_activity` (
  `blogId` int(8) NOT NULL DEFAULT '0',
  `day` int(14) NOT NULL DEFAULT '0',
  `posts` int(8) DEFAULT NULL,
  PRIMARY KEY (`blogId`,`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts`
--

CREATE TABLE `tiki_blog_posts` (
  `postId` int(8) NOT NULL AUTO_INCREMENT,
  `blogId` int(8) NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `data_size` int(11) unsigned NOT NULL DEFAULT '0',
  `excerpt` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` bigint(20) DEFAULT '0',
  `trackbacks_to` text COLLATE utf8mb4_unicode_ci,
  `trackbacks_from` text COLLATE utf8mb4_unicode_ci,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priv` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `wysiwyg` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`postId`),
  KEY `data` (`data`(191)),
  KEY `blogId` (`blogId`),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`data`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts_images`
--

CREATE TABLE `tiki_blog_posts_images` (
  `imgId` int(14) NOT NULL AUTO_INCREMENT,
  `postId` int(14) NOT NULL DEFAULT '0',
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`imgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendars`
--

CREATE TABLE `tiki_calendars` (
  `calendarId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `customlocations` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customcategories` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customlanguages` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `custompriorities` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customparticipants` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customsubscription` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customstatus` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `personal` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_categories`
--

CREATE TABLE `tiki_calendar_categories` (
  `calcatId` int(11) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`calcatId`),
  UNIQUE KEY `catname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_changes`
--

CREATE TABLE `tiki_calendar_changes` (
  `changeId` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `calitemId` int(11) unsigned NOT NULL,
  `synctoken` int(11) unsigned NOT NULL,
  `calendarId` int(11) unsigned NOT NULL,
  `operation` tinyint(1) NOT NULL,
  PRIMARY KEY (`changeId`),
  KEY `calendarId` (`calendarId`,`synctoken`),
  KEY `calitemId` (`calitemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_instances`
--

CREATE TABLE `tiki_calendar_instances` (
  `calendarInstanceId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendarId` int(10) unsigned NOT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 = owner, 2 = read, 3 = readwrite',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varbinary(200) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int(11) unsigned NOT NULL DEFAULT '0',
  `color` varbinary(10) DEFAULT NULL,
  `timezone` text COLLATE utf8mb4_unicode_ci,
  `transparent` tinyint(1) NOT NULL DEFAULT '0',
  `share_href` varbinary(100) DEFAULT NULL,
  `share_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `share_invite_status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1 = noresponse, 2 = accepted, 3 = declined, 4 = invalid',
  PRIMARY KEY (`calendarInstanceId`),
  UNIQUE KEY `calendarId_2` (`calendarId`,`share_href`),
  UNIQUE KEY `user` (`user`(141),`uri`),
  UNIQUE KEY `calendarId` (`calendarId`,`user`(189))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_items`
--

CREATE TABLE `tiki_calendar_items` (
  `calitemId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `start` int(14) NOT NULL DEFAULT '0',
  `end` int(14) NOT NULL DEFAULT '0',
  `locationId` int(14) DEFAULT NULL,
  `categoryId` int(14) DEFAULT NULL,
  `nlId` int(12) NOT NULL DEFAULT '0',
  `priority` enum('0','1','2','3','4','5','6','7','8','9') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `status` enum('0','1','2') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `recurrenceId` int(14) DEFAULT NULL,
  `changed` tinyint(1) DEFAULT '0',
  `recurrenceStart` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `uid` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calitemId`),
  KEY `calendarId` (`calendarId`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_locations`
--

CREATE TABLE `tiki_calendar_locations` (
  `callocId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  PRIMARY KEY (`callocId`),
  UNIQUE KEY `locname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_options`
--

CREATE TABLE `tiki_calendar_options` (
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `optionName` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calendarId`,`optionName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_recurrence`
--

CREATE TABLE `tiki_calendar_recurrence` (
  `recurrenceId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `start` int(4) NOT NULL DEFAULT '0',
  `end` int(4) NOT NULL DEFAULT '2359',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `locationId` int(14) DEFAULT NULL,
  `categoryId` int(14) DEFAULT NULL,
  `nlId` int(12) NOT NULL DEFAULT '0',
  `priority` enum('1','2','3','4','5','6','7','8','9') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `status` enum('0','1','2') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  `weekly` tinyint(1) DEFAULT '0',
  `weekday` tinyint(1) DEFAULT NULL,
  `monthly` tinyint(1) DEFAULT '0',
  `dayOfMonth` int(2) DEFAULT NULL,
  `yearly` tinyint(1) DEFAULT '0',
  `dateOfYear` int(4) DEFAULT NULL,
  `nbRecurrences` int(8) DEFAULT NULL,
  `startPeriod` int(14) DEFAULT NULL,
  `endPeriod` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `uid` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`recurrenceId`),
  KEY `calendarId` (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_roles`
--

CREATE TABLE `tiki_calendar_roles` (
  `calitemId` int(14) NOT NULL DEFAULT '0',
  `username` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `role` enum('0','1','2','3','6') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `partstat` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calitemId`,`username`(16),`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_scheduling_objects`
--

CREATE TABLE `tiki_calendar_scheduling_objects` (
  `schedulingObjectId` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calendardata` mediumblob,
  `uri` varbinary(200) DEFAULT NULL,
  `lastmodif` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  PRIMARY KEY (`schedulingObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_subscriptions`
--

CREATE TABLE `tiki_calendar_subscriptions` (
  `subscriptionId` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `calendarId` int(11) unsigned NOT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` text COLLATE utf8mb4_unicode_ci,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh_rate` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int(11) unsigned NOT NULL DEFAULT '0',
  `color` varbinary(10) DEFAULT NULL,
  `strip_todos` tinyint(1) DEFAULT NULL,
  `strip_alarms` tinyint(1) DEFAULT NULL,
  `strip_attachments` tinyint(1) DEFAULT NULL,
  `lastmodif` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`subscriptionId`),
  UNIQUE KEY `user` (`user`(189),`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cart_inventory_hold`
--

CREATE TABLE `tiki_cart_inventory_hold` (
  `productId` int(14) NOT NULL,
  `quantity` int(14) NOT NULL,
  `timeHeld` int(14) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories`
--

CREATE TABLE `tiki_categories` (
  `categId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int(12) DEFAULT NULL,
  `rootId` int(11) NOT NULL DEFAULT '0',
  `hits` int(8) DEFAULT NULL,
  `tplGroupContainerId` int(12) DEFAULT NULL,
  `tplGroupPattern` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories_roles`
--

CREATE TABLE `tiki_categories_roles` (
  `categId` int(12) NOT NULL,
  `categRoleId` int(12) NOT NULL,
  `groupRoleId` int(12) NOT NULL,
  `groupId` int(12) NOT NULL,
  PRIMARY KEY (`categId`,`categRoleId`,`groupRoleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories_roles_available`
--

CREATE TABLE `tiki_categories_roles_available` (
  `categId` int(12) NOT NULL,
  `categRoleId` int(12) NOT NULL,
  PRIMARY KEY (`categId`,`categRoleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categorized_objects`
--

CREATE TABLE `tiki_categorized_objects` (
  `catObjectId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_objects`
--

CREATE TABLE `tiki_category_objects` (
  `catObjectId` int(12) NOT NULL DEFAULT '0',
  `categId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_sites`
--

CREATE TABLE `tiki_category_sites` (
  `categId` int(10) NOT NULL DEFAULT '0',
  `siteId` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`siteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_channels`
--

CREATE TABLE `tiki_chat_channels` (
  `channelId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_users` int(8) DEFAULT NULL,
  `mode` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh` int(6) DEFAULT NULL,
  PRIMARY KEY (`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_messages`
--

CREATE TABLE `tiki_chat_messages` (
  `messageId` int(8) NOT NULL AUTO_INCREMENT,
  `channelId` int(8) NOT NULL DEFAULT '0',
  `data` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_users`
--

CREATE TABLE `tiki_chat_users` (
  `nickname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `channelId` int(8) NOT NULL DEFAULT '0',
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`nickname`(183),`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_comments`
--

CREATE TABLE `tiki_comments` (
  `threadId` int(14) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parentId` int(14) DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `commentDate` int(14) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `average` decimal(8,4) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smiley` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_id` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_rating` tinyint(2) DEFAULT NULL,
  `archived` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `locked` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`threadId`),
  UNIQUE KEY `no_repeats` (`parentId`,`userName`(40),`title`(43),`commentDate`,`message_id`(40),`in_reply_to`(40)),
  KEY `title` (`title`(191)),
  KEY `data` (`data`(191)),
  KEY `hits` (`hits`),
  KEY `tc_pi` (`parentId`),
  KEY `objectType` (`object`(160),`objectType`),
  KEY `commentDate` (`commentDate`),
  KEY `threaded` (`message_id`(89),`in_reply_to`(88),`parentId`),
  FULLTEXT KEY `ft` (`title`,`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_connect`
--

CREATE TABLE `tiki_connect` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  `guid` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `server` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `server` (`server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content`
--

CREATE TABLE `tiki_content` (
  `contentId` int(8) NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `contentLabel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`contentId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates`
--

CREATE TABLE `tiki_content_templates` (
  `templateId` int(10) NOT NULL AUTO_INCREMENT,
  `template_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `content` longblob,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`templateId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates_sections`
--

CREATE TABLE `tiki_content_templates_sections` (
  `templateId` int(10) NOT NULL DEFAULT '0',
  `section` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`templateId`,`section`(181))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions`
--

CREATE TABLE `tiki_contributions` (
  `contributionId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions_assigned`
--

CREATE TABLE `tiki_contributions_assigned` (
  `contributionId` int(12) NOT NULL,
  `objectId` int(12) NOT NULL,
  PRIMARY KEY (`objectId`,`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cookies`
--

CREATE TABLE `tiki_cookies` (
  `cookieId` int(10) NOT NULL AUTO_INCREMENT,
  `cookie` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`cookieId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_copyrights`
--

CREATE TABLE `tiki_copyrights` (
  `copyrightId` int(12) NOT NULL AUTO_INCREMENT,
  `page` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `authors` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `holder` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright_order` int(11) DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`copyrightId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits`
--

CREATE TABLE `tiki_credits` (
  `creditId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userId` int(8) NOT NULL,
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiration_date` timestamp NULL DEFAULT NULL,
  `total_amount` float NOT NULL DEFAULT '0',
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int(8) DEFAULT NULL,
  `goalId` int(11) DEFAULT NULL,
  PRIMARY KEY (`creditId`),
  KEY `userId` (`userId`,`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_types`
--

CREATE TABLE `tiki_credits_types` (
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_text` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_text` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_static_level` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `scaling_divisor` float NOT NULL DEFAULT '1',
  PRIMARY KEY (`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_usage`
--

CREATE TABLE `tiki_credits_usage` (
  `usageId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `usage_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int(8) DEFAULT NULL,
  PRIMARY KEY (`usageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_custom_route`
--

CREATE TABLE `tiki_custom_route` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `short_url` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_db_status`
--

CREATE TABLE `tiki_db_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `objectId` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tableName` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `other` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_categories`
--

CREATE TABLE `tiki_directory_categories` (
  `categId` int(10) NOT NULL AUTO_INCREMENT,
  `parent` int(10) DEFAULT NULL,
  `name` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `childrenType` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sites` int(10) DEFAULT NULL,
  `viewableChildren` int(4) DEFAULT NULL,
  `allowSites` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `showCount` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `editorGroup` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(12) DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_search`
--

CREATE TABLE `tiki_directory_search` (
  `term` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  PRIMARY KEY (`term`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_sites`
--

CREATE TABLE `tiki_directory_sites` (
  `siteId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(12) DEFAULT NULL,
  `isValid` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `cache` longblob,
  `cache_timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`siteId`),
  KEY `isValid` (`isValid`),
  KEY `url` (`url`(191)),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_discount`
--

CREATE TABLE `tiki_discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max` int(11) DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `code` (`code`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_download`
--

CREATE TABLE `tiki_download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userId` int(8) NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` int(14) NOT NULL DEFAULT '0',
  `IP` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `object` (`object`(163),`userId`,`type`),
  KEY `userId` (`userId`),
  KEY `type` (`type`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dsn`
--

CREATE TABLE `tiki_dsn` (
  `dsnId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dsn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`dsnId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dynamic_variables`
--

CREATE TABLE `tiki_dynamic_variables` (
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_extwiki`
--

CREATE TABLE `tiki_extwiki` (
  `extwikiId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extwiki` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `indexname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`extwikiId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faqs`
--

CREATE TABLE `tiki_faqs` (
  `faqId` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `questions` int(5) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `canSuggest` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`faqId`),
  KEY `title` (`title`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faq_questions`
--

CREATE TABLE `tiki_faq_questions` (
  `questionId` int(10) NOT NULL AUTO_INCREMENT,
  `faqId` int(10) DEFAULT NULL,
  `position` int(4) DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`questionId`),
  KEY `faqId` (`faqId`),
  KEY `question` (`question`(191)),
  KEY `answer` (`answer`(191)),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`question`,`answer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_feature`
--

CREATE TABLE `tiki_feature` (
  `feature_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `feature_name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` mediumint(9) NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `setting_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feature_type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'feature',
  `template` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permission` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordinal` mediumint(9) NOT NULL DEFAULT '1',
  `depends_on` mediumint(9) DEFAULT NULL,
  `keyword` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tip` text COLLATE utf8mb4_unicode_ci,
  `feature_count` mediumint(9) NOT NULL DEFAULT '0',
  `feature_path` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_featured_links`
--

CREATE TABLE `tiki_featured_links` (
  `url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `hits` int(8) DEFAULT NULL,
  `position` int(6) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_files`
--

CREATE TABLE `tiki_files` (
  `fileId` int(14) NOT NULL AUTO_INCREMENT,
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `author` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(14) DEFAULT NULL,
  `maxhits` int(14) DEFAULT NULL,
  `lastDownload` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_reference` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `search_data` longtext COLLATE utf8mb4_unicode_ci,
  `metadata` longtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int(14) DEFAULT NULL,
  `lastModifUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `comment` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `archiveId` int(14) DEFAULT '0',
  `deleteAfter` int(14) DEFAULT NULL,
  `ocr_state` tinyint(1) DEFAULT NULL,
  `ocr_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ocr_data` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fileId`),
  KEY `name` (`name`(191)),
  KEY `description` (`description`(191)),
  KEY `created` (`created`),
  KEY `archiveId` (`archiveId`),
  KEY `galleryId` (`galleryId`),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`name`,`description`,`search_data`,`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_backlinks`
--

CREATE TABLE `tiki_file_backlinks` (
  `fileId` int(14) NOT NULL,
  `objectId` int(12) NOT NULL,
  KEY `objectId` (`objectId`),
  KEY `fileId` (`fileId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_drafts`
--

CREATE TABLE `tiki_file_drafts` (
  `fileId` int(14) NOT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int(14) DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`fileId`,`user`(177))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_galleries`
--

CREATE TABLE `tiki_file_galleries` (
  `galleryId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `template` int(10) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `visible` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `maxRows` int(10) DEFAULT NULL,
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_id` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_icon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_name` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_size` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_desc` int(8) DEFAULT NULL,
  `show_created` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_hits` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_lastDownload` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int(14) NOT NULL DEFAULT '-1',
  `lockable` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_lockedby` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `archives` int(4) DEFAULT '0',
  `sort_mode` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_modified` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_creator` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subgal_conf` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_last_user` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_comment` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_files` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_explorer` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_path` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_slideshow` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_ocr_state` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_view` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quota` int(8) DEFAULT '0',
  `size` int(14) DEFAULT NULL,
  `wiki_syntax` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backlinkPerms` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_backlinks` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_deleteAfter` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_checked` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_share` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_max_size_x` int(8) NOT NULL DEFAULT '0',
  `image_max_size_y` int(8) NOT NULL DEFAULT '0',
  `show_source` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'o',
  `icon_fileId` int(14) unsigned DEFAULT NULL,
  `ocr_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`galleryId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_file_galleries`
--

INSERT INTO `tiki_file_galleries` VALUES
(1, 'File Galleries', 'system', NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL),
(2, 'Users File Galleries', 'system', NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL),
(3, 'Wiki Attachments', 'system', NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_handlers`
--

CREATE TABLE `tiki_file_handlers` (
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cmd` varchar(238) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums`
--

CREATE TABLE `tiki_forums` (
  `forumId` int(8) NOT NULL AUTO_INCREMENT,
  `parentId` int(8) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastPost` int(14) DEFAULT NULL,
  `threads` int(8) DEFAULT NULL,
  `comments` int(8) DEFAULT NULL,
  `controlFlood` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floodInterval` int(8) DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `mail` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `useMail` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `section` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `usePruneUnreplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pruneUnrepliedAge` int(8) DEFAULT NULL,
  `usePruneOld` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pruneMaxAge` int(8) DEFAULT NULL,
  `topicsPerPage` int(6) DEFAULT NULL,
  `topicOrdering` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `threadOrdering` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_store` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_store_dir` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_max_size` int(12) DEFAULT NULL,
  `att_list_nb` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_level` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_password` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_use_password` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moderator_group` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_address` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_mails_for_inbound_mails` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_mails_reply_link` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_from` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_server` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_port` int(4) DEFAULT NULL,
  `inbound_pop_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_password` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_smileys` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_rating_choice_topic` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_posts` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_email` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_online` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_summary` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_replies` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_reads` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_pts` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_title` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_author_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vote_threads` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_last_n` int(2) DEFAULT '0',
  `threadStyle` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentsPerPage` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_flat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mandatory_contribution` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forumLanguage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`forumId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_queue`
--

CREATE TABLE `tiki_forums_queue` (
  `qId` int(14) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int(14) DEFAULT NULL,
  `forumId` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `title` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_smiley` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_title` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tags` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`qId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_reported`
--

CREATE TABLE `tiki_forums_reported` (
  `threadId` int(12) NOT NULL DEFAULT '0',
  `forumId` int(12) NOT NULL DEFAULT '0',
  `parentId` int(12) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestamp` int(14) DEFAULT NULL,
  `reason` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`threadId`,`forumId`,`parentId`,`user`(182))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_attachments`
--

CREATE TABLE `tiki_forum_attachments` (
  `attId` int(14) NOT NULL AUTO_INCREMENT,
  `threadId` int(14) NOT NULL DEFAULT '0',
  `qId` int(14) NOT NULL DEFAULT '0',
  `forumId` int(14) DEFAULT NULL,
  `filename` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(12) DEFAULT NULL,
  `data` longblob,
  `dir` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attId`),
  KEY `threadId` (`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_reads`
--

CREATE TABLE `tiki_forum_reads` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `threadId` int(14) NOT NULL DEFAULT '0',
  `forumId` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`user`(177),`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetagged_objects`
--

CREATE TABLE `tiki_freetagged_objects` (
  `tagId` int(12) NOT NULL AUTO_INCREMENT,
  `objectId` int(11) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagId`,`user`(168),`objectId`),
  KEY `tagId` (`tagId`),
  KEY `user` (`user`(191)),
  KEY `objectId` (`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetags`
--

CREATE TABLE `tiki_freetags` (
  `tagId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `raw_tag` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`tagId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_galleries`
--

CREATE TABLE `tiki_galleries` (
  `galleryId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `visible` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `geographic` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `maxRows` int(10) DEFAULT NULL,
  `rowImages` int(10) DEFAULT NULL,
  `thumbSizeX` int(10) DEFAULT NULL,
  `thumbSizeY` int(10) DEFAULT NULL,
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sortorder` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'created',
  `sortdirection` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'desc',
  `galleryimage` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'first',
  `parentgallery` int(14) NOT NULL DEFAULT '-1',
  `showname` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `showimageid` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `showdescription` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `showcreated` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `showuser` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `showhits` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `showxysize` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `showfilesize` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `showfilename` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `defaultscale` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'o',
  `showcategories` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`galleryId`),
  KEY `name` (`name`),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  KEY `parentgallery` (`parentgallery`),
  KEY `visibleUser` (`visible`,`user`(190)),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_galleries_scales`
--

CREATE TABLE `tiki_galleries_scales` (
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `scale` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`galleryId`,`scale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goals`
--

CREATE TABLE `tiki_goals` (
  `goalId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `description` text COLLATE utf8mb4_unicode_ci,
  `enabled` int(11) NOT NULL DEFAULT '0',
  `daySpan` int(11) NOT NULL DEFAULT '14',
  `from` datetime DEFAULT NULL,
  `to` datetime DEFAULT NULL,
  `eligible` blob,
  `conditions` blob,
  `rewards` blob,
  PRIMARY KEY (`goalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goal_events`
--

CREATE TABLE `tiki_goal_events` (
  `eventId` int(11) NOT NULL AUTO_INCREMENT,
  `eventDate` int(11) NOT NULL,
  `eventType` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `targetType` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetObject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `groups` blob NOT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_groupalert`
--

CREATE TABLE `tiki_groupalert` (
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectId` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `displayEachuser` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`groupName`(161),`objectType`,`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_inclusion`
--

CREATE TABLE `tiki_group_inclusion` (
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `includeGroup` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`groupName`(120),`includeGroup`(120))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_group_inclusion`
--

INSERT INTO `tiki_group_inclusion` VALUES
('Registered', 'Anonymous');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_watches`
--

CREATE TABLE `tiki_group_watches` (
  `watchId` int(12) NOT NULL AUTO_INCREMENT,
  `group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `event` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `object` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`watchId`),
  KEY `event-object-group` (`event`,`object`(100),`group`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_contents`
--

CREATE TABLE `tiki_h5p_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `library_id` int(10) unsigned NOT NULL,
  `parameters` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `filtered` longtext COLLATE utf8mb4_unicode_ci,
  `slug` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `embed_type` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disable` int(10) unsigned NOT NULL DEFAULT '0',
  `content_type` varchar(127) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authors` mediumtext COLLATE utf8mb4_unicode_ci,
  `license` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `source` varchar(2083) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year_from` int(10) unsigned DEFAULT NULL,
  `year_to` int(10) unsigned DEFAULT NULL,
  `license_version` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_extras` longtext COLLATE utf8mb4_unicode_ci,
  `author_comments` longtext COLLATE utf8mb4_unicode_ci,
  `changes` mediumtext COLLATE utf8mb4_unicode_ci,
  `default_language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `a11y_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fileId` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_contents_libraries`
--

CREATE TABLE `tiki_h5p_contents_libraries` (
  `content_id` int(10) unsigned NOT NULL,
  `library_id` int(10) unsigned NOT NULL,
  `dependency_type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `drop_css` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`content_id`,`library_id`,`dependency_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries`
--

CREATE TABLE `tiki_h5p_libraries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major_version` int(10) unsigned NOT NULL,
  `minor_version` int(10) unsigned NOT NULL,
  `patch_version` int(10) unsigned NOT NULL,
  `runnable` int(10) unsigned NOT NULL,
  `restricted` int(10) unsigned NOT NULL DEFAULT '0',
  `fullscreen` int(10) unsigned NOT NULL,
  `embed_types` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `preloaded_js` text COLLATE utf8mb4_unicode_ci,
  `preloaded_css` text COLLATE utf8mb4_unicode_ci,
  `drop_library_css` text COLLATE utf8mb4_unicode_ci,
  `semantics` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tutorial_url` varchar(1023) COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_icon` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata_settings` text COLLATE utf8mb4_unicode_ci,
  `add_to` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `name_version` (`name`,`major_version`,`minor_version`,`patch_version`),
  KEY `runnable` (`runnable`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_cachedassets`
--

CREATE TABLE `tiki_h5p_libraries_cachedassets` (
  `library_id` int(10) unsigned NOT NULL,
  `hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_hub_cache`
--

CREATE TABLE `tiki_h5p_libraries_hub_cache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `machine_name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major_version` int(10) unsigned NOT NULL,
  `minor_version` int(10) unsigned NOT NULL,
  `patch_version` int(10) unsigned NOT NULL,
  `h5p_major_version` int(10) unsigned DEFAULT NULL,
  `h5p_minor_version` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(511) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `updated_at` int(10) unsigned NOT NULL,
  `is_recommended` int(10) unsigned NOT NULL,
  `popularity` int(10) unsigned NOT NULL,
  `screenshots` text COLLATE utf8mb4_unicode_ci,
  `license` text COLLATE utf8mb4_unicode_ci,
  `example` varchar(511) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tutorial` varchar(511) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  `categories` text COLLATE utf8mb4_unicode_ci,
  `owner` varchar(511) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name_version` (`machine_name`,`major_version`,`minor_version`,`patch_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_languages`
--

CREATE TABLE `tiki_h5p_libraries_languages` (
  `library_id` int(10) unsigned NOT NULL,
  `language_code` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`language_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_libraries`
--

CREATE TABLE `tiki_h5p_libraries_libraries` (
  `library_id` int(10) unsigned NOT NULL,
  `required_library_id` int(10) unsigned NOT NULL,
  `dependency_type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`required_library_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_results`
--

CREATE TABLE `tiki_h5p_results` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `score` int(10) unsigned NOT NULL,
  `max_score` int(10) unsigned NOT NULL,
  `opened` int(10) unsigned NOT NULL,
  `finished` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `content_user` (`content_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_tmpfiles`
--

CREATE TABLE `tiki_h5p_tmpfiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `path` (`path`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_history`
--

CREATE TABLE `tiki_history` (
  `historyId` int(12) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(8) NOT NULL DEFAULT '0',
  `version_minor` int(8) NOT NULL DEFAULT '0',
  `lastModif` int(14) DEFAULT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pageName`,`version`),
  KEY `user` (`user`(191)),
  KEY `historyId` (`historyId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_hotwords`
--

CREATE TABLE `tiki_hotwords` (
  `word` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`word`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages`
--

CREATE TABLE `tiki_html_pages` (
  `pageName` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` longblob,
  `refresh` int(10) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`pageName`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages_dynamic_zones`
--

CREATE TABLE `tiki_html_pages_dynamic_zones` (
  `pageName` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `zone` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pageName`,`zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_images`
--

CREATE TABLE `tiki_images` (
  `imageId` int(14) NOT NULL AUTO_INCREMENT,
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `lon` float DEFAULT NULL,
  `lat` float DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`imageId`),
  KEY `name` (`name`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  KEY `ti_gId` (`galleryId`),
  KEY `ti_cr` (`created`),
  KEY `ti_us` (`user`(191)),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_images_data`
--

CREATE TABLE `tiki_images_data` (
  `imageId` int(14) NOT NULL DEFAULT '0',
  `xsize` int(8) NOT NULL DEFAULT '0',
  `ysize` int(8) NOT NULL DEFAULT '0',
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `etag` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`imageId`,`xsize`,`ysize`,`type`),
  KEY `t_i_d_it` (`imageId`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_reps`
--

CREATE TABLE `tiki_integrator_reps` (
  `repID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `css_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visibility` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `cacheable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `expiration` int(11) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_integrator_reps`
--

INSERT INTO `tiki_integrator_reps` VALUES
(1, 'Doxygened (1.3.4) Documentation', '', 'index.html', 'doxygen.css', 'n', 'y', 0, 'Use this repository as rule source for all your repositories based on doxygened docs. To setup yours just add new repository and copy rules from this repository :)');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_rules`
--

CREATE TABLE `tiki_integrator_rules` (
  `ruleID` int(11) NOT NULL AUTO_INCREMENT,
  `repID` int(11) NOT NULL DEFAULT '0',
  `ord` int(2) unsigned NOT NULL DEFAULT '0',
  `srch` blob NOT NULL,
  `repl` blob NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `casesense` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `rxmod` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enabled` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ruleID`),
  KEY `repID` (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_integrator_rules`
--

INSERT INTO `tiki_integrator_rules` VALUES
(1, 1, 1, '.*<body[^>]*?>(.*?)</body.*', '1', 'y', 'n', 'i', 'y', 'Extract code between <body> and </body> tags'),
(2, 1, 2, 'img src=("|'')(?!http://)', 'img src=1{path}/', 'y', 'n', 'i', 'y', 'Fix image paths'),
(3, 1, 3, 'href=("|'')(?!(#|(http|ftp)://))', 'href=1tiki-integrator.php?repID={repID}&file=', 'y', 'n', 'i', 'y', 'Replace internal links to integrator. Don not touch an external link.');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invite`
--

CREATE TABLE `tiki_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inviter` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `groups` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ts` int(11) NOT NULL,
  `emailsubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `emailcontent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `wikicontent` text COLLATE utf8mb4_unicode_ci,
  `wikipageafter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invited`
--

CREATE TABLE `tiki_invited` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_invite` int(11) NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastname` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used` enum('no','registered','logged') COLLATE utf8mb4_unicode_ci NOT NULL,
  `used_on_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_invite` (`id_invite`),
  KEY `used_on_user` (`used_on_user`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_language`
--

CREATE TABLE `tiki_language` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `source` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tran` text COLLATE utf8mb4_unicode_ci,
  `changed` tinyint(1) DEFAULT NULL,
  `general` tinyint(1) DEFAULT NULL COMMENT 'true if this translation is general and can be contributed to the Tiki community, false if it is specific to this instance',
  `userId` int(8) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_links`
--

CREATE TABLE `tiki_links` (
  `fromPage` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `toPage` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`fromPage`(96),`toPage`(95)),
  KEY `toPage` (`toPage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_link_cache`
--

CREATE TABLE `tiki_link_cache` (
  `cacheId` int(14) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `refresh` int(14) DEFAULT NULL,
  PRIMARY KEY (`cacheId`),
  KEY `url` (`url`(191)),
  KEY `urlindex` (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_events`
--

CREATE TABLE `tiki_live_support_events` (
  `eventId` int(14) NOT NULL AUTO_INCREMENT,
  `reqId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seqId` int(14) DEFAULT NULL,
  `senderId` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_messages`
--

CREATE TABLE `tiki_live_support_messages` (
  `msgId` int(12) NOT NULL AUTO_INCREMENT,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_to` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` int(4) DEFAULT NULL,
  `email` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_message_comments`
--

CREATE TABLE `tiki_live_support_message_comments` (
  `cId` int(12) NOT NULL AUTO_INCREMENT,
  `msgId` int(12) DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`cId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_modules`
--

CREATE TABLE `tiki_live_support_modules` (
  `modId` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`modId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `tiki_live_support_modules`
--

INSERT INTO `tiki_live_support_modules` VALUES
(1, 'wiki'),
(2, 'forums'),
(3, 'image galleries'),
(4, 'file galleries'),
(5, 'directory');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_operators`
--

CREATE TABLE `tiki_live_support_operators` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `accepted_requests` int(10) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longest_chat` int(10) DEFAULT NULL,
  `shortest_chat` int(10) DEFAULT NULL,
  `average_chat` int(10) DEFAULT NULL,
  `last_chat` int(14) DEFAULT NULL,
  `time_online` int(10) DEFAULT NULL,
  `votes` int(10) DEFAULT NULL,
  `points` int(10) DEFAULT NULL,
  `status_since` int(14) DEFAULT NULL,
  PRIMARY KEY (`user`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_requests`
--

CREATE TABLE `tiki_live_support_requests` (
  `reqId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tiki_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` text COLLATE utf8mb4_unicode_ci,
  `req_timestamp` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  `status` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chat_started` int(14) DEFAULT NULL,
  `chat_ended` int(14) DEFAULT NULL,
  PRIMARY KEY (`reqId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_logs`
--

CREATE TABLE `tiki_logs` (
  `logId` int(8) NOT NULL AUTO_INCREMENT,
  `logtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logmessage` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `loguser` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logip` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logclient` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `logtime` int(14) NOT NULL,
  PRIMARY KEY (`logId`),
  KEY `logtype` (`logtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mailin_accounts`
--

CREATE TABLE `tiki_mailin_accounts` (
  `accountId` int(12) NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `protocol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pop',
  `host` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` int(4) DEFAULT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pass` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `anonymous` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `admin` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `attachments` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `routing` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `article_topicId` int(4) DEFAULT NULL,
  `article_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discard_after` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_inlineImages` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `save_html` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `categoryId` int(12) DEFAULT NULL,
  `namespace` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `respond_email` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `leave_email` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`accountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_events`
--

CREATE TABLE `tiki_mail_events` (
  `event` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_queue`
--

CREATE TABLE `tiki_mail_queue` (
  `messageId` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci,
  `attempts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menus`
--

CREATE TABLE `tiki_menus` (
  `menuId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_items_icons` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `parse` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`menuId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=43 ;

--
-- Dumping data for table `tiki_menus`
--

INSERT INTO `tiki_menus` VALUES
(42, 'Application menu', 'Main extensive navigation menu', 'd', NULL, 'y', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_languages`
--

CREATE TABLE `tiki_menu_languages` (
  `menuId` int(8) NOT NULL AUTO_INCREMENT,
  `language` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`menuId`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_options`
--

CREATE TABLE `tiki_menu_options` (
  `optionId` int(8) NOT NULL AUTO_INCREMENT,
  `menuId` int(8) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(4) DEFAULT NULL,
  `section` text COLLATE utf8mb4_unicode_ci,
  `perm` text COLLATE utf8mb4_unicode_ci,
  `groupname` text COLLATE utf8mb4_unicode_ci,
  `userlevel` int(4) DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`optionId`),
  UNIQUE KEY `uniq_menu` (`menuId`,`name`(30),`url`(50),`position`,`section`(60),`perm`(50),`groupname`(50))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=197 ;

--
-- Dumping data for table `tiki_menu_options`
--

INSERT INTO `tiki_menu_options` VALUES
(1, 42, 'o', 'Home', './', 10, '', '', '', 0, 'home48x48', NULL),
(2, 42, 'o', 'Search', 'tiki-searchresults.php', 13, 'feature_search_fulltext', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(3, 42, 'o', 'Search', 'tiki-searchindex.php', 13, 'feature_search', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(4, 42, 'o', 'Contact Us', 'tiki-contact.php', 20, 'feature_contact,feature_messages', '', '', 0, 'contactus48x48', NULL),
(5, 42, 'o', 'Stats', 'tiki-stats.php', 23, 'feature_stats', 'tiki_p_view_stats', '', 0, 'stats48x48', NULL),
(6, 42, 'o', 'Categories', 'tiki-browse_categories.php', 25, 'feature_categories', 'tiki_p_view_category', '', 0, 'categories48x48', NULL),
(7, 42, 'o', 'Tags', 'tiki-browse_freetags.php', 27, 'feature_freetags', 'tiki_p_view_freetags', '', 0, 'vcard48x48', NULL),
(8, 42, 'o', 'Calendar', 'tiki-calendar.php', 35, 'feature_calendar', 'tiki_p_view_calendar', '', 0, 'date48x48', NULL),
(9, 42, 'o', 'Tiki Calendar', 'tiki-action_calendar.php', 37, 'feature_action_calendar', 'tiki_p_view_tiki_calendar', '', 0, 'tikicalendar48x48', NULL),
(10, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_view', '', 0, NULL, NULL),
(11, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_request', '', 0, NULL, NULL),
(12, 42, 'o', '(debug)', 'javascript:toggle(''debugconsole'')', 40, 'feature_debug_console', 'tiki_p_admin', '', 0, 'debug48x48', NULL),
(13, 42, 'o', 'User Wizard', 'tiki-wizard_user.php', 45, 'feature_wizard_user', '', 'Registered', 0, 'wizard_user48x48', NULL),
(14, 42, 's', 'My Account', 'tiki-my_tiki.php', 50, 'feature_mytiki', '', 'Registered', 0, 'userfiles48x48', NULL),
(15, 42, 'o', 'My Account Home', 'tiki-my_tiki.php', 51, 'feature_mytiki', '', 'Registered', 0, NULL, NULL),
(16, 42, 'o', 'Preferences', 'tiki-user_preferences.php', 55, 'feature_mytiki,feature_userPreferences', '', 'Registered', 0, NULL, NULL),
(17, 42, 'o', 'Messages', 'messu-mailbox.php', 60, 'feature_mytiki,feature_messages', 'tiki_p_messages', 'Registered', 0, NULL, NULL),
(18, 42, 'o', 'Tasks', 'tiki-user_tasks.php', 65, 'feature_mytiki,feature_tasks', 'tiki_p_tasks', 'Registered', 0, NULL, NULL),
(19, 42, 'o', 'Bookmarks', 'tiki-user_bookmarks.php', 70, 'feature_mytiki,feature_user_bookmarks', 'tiki_p_create_bookmarks', 'Registered', 0, NULL, NULL),
(20, 42, 'o', 'Modules', 'tiki-user_assigned_modules.php', 75, 'feature_mytiki,user_assigned_modules', 'tiki_p_configure_modules', 'Registered', 0, NULL, NULL),
(21, 42, 'o', 'Webmail', 'tiki-webmail.php', 85, 'feature_mytiki,feature_webmail', 'tiki_p_use_webmail', 'Registered', 0, NULL, NULL),
(22, 42, 'o', 'Contacts', 'tiki-contacts.php', 87, 'feature_mytiki,feature_contacts', '', 'Registered', 0, NULL, NULL),
(23, 42, 'o', 'Mail-in', 'tiki-user_mailin.php', 88, 'feature_mytiki,feature_mailin', '', 'Registered', 0, NULL, NULL),
(24, 42, 'o', 'Notepad', 'tiki-notepad_list.php', 90, 'feature_mytiki,feature_notepad', 'tiki_p_notepad', 'Registered', 0, NULL, NULL),
(25, 42, 'o', 'My Files', 'tiki-userfiles.php', 95, 'feature_mytiki,feature_userfiles', 'tiki_p_userfiles', 'Registered', 0, NULL, NULL),
(26, 42, 'o', 'User Menu', 'tiki-usermenu.php', 100, 'feature_mytiki,feature_usermenu', 'tiki_p_usermenu', 'Registered', 0, NULL, NULL),
(27, 42, 'o', 'Mini Calendar', 'tiki-minical.php', 105, 'feature_mytiki,feature_minical', 'tiki_p_minical', 'Registered', 0, NULL, NULL),
(28, 42, 'o', 'My Watches', 'tiki-user_watches.php', 110, 'feature_mytiki,feature_user_watches', '', 'Registered', 0, NULL, NULL),
(29, 42, 's', 'Community', 'tiki-list_users.php', 187, 'feature_friends', 'tiki_p_list_users', '', 0, 'users48x48', NULL),
(30, 42, 'o', 'User List', 'tiki-list_users.php', 188, 'feature_friends', 'tiki_p_list_users', '', 0, NULL, NULL),
(31, 42, 'o', 'Friendship Network', 'tiki-friends.php', 189, 'feature_friends', '', 'Registered', 0, NULL, NULL),
(32, 42, 's', 'Wiki', 'tiki-index.php', 200, 'feature_wiki', 'tiki_p_view', '', 0, 'wikipages48x48', NULL),
(33, 42, 'o', 'Wiki Home', 'tiki-index.php', 202, 'feature_wiki', 'tiki_p_view', '', 0, NULL, NULL),
(34, 42, 'o', 'Last Changes', 'tiki-lastchanges.php', 205, 'feature_wiki,feature_lastChanges', 'tiki_p_view', '', 0, NULL, NULL),
(35, 42, 'o', 'Rankings', 'tiki-wiki_rankings.php', 215, 'feature_wiki,feature_wiki_rankings', 'tiki_p_view', '', 0, NULL, NULL),
(36, 42, 'o', 'List Pages', 'tiki-listpages.php?cookietab=1#tab1', 220, 'feature_wiki,feature_listPages', 'tiki_p_view', '', 0, NULL, NULL),
(37, 42, 'o', 'Create a Wiki Page', 'tiki-listpages.php?cookietab=2#tab2', 222, 'feature_wiki,feature_listPages', 'tiki_p_view,tiki_p_edit', '', 0, NULL, NULL),
(38, 42, 'o', 'Orphan Pages', 'tiki-orphan_pages.php', 225, 'feature_wiki,feature_listorphanPages', 'tiki_p_view', '', 0, NULL, NULL),
(39, 42, 'o', 'Sandbox', 'tiki-editpage.php?page=sandbox', 230, 'feature_wiki,feature_sandbox', 'tiki_p_view', '', 0, NULL, NULL),
(40, 42, 'o', 'Multiple Print', 'tiki-print_pages.php', 235, 'feature_wiki,feature_wiki_multiprint', 'tiki_p_view', '', 0, NULL, NULL),
(41, 42, 'o', 'Send Pages', 'tiki-send_objects.php', 240, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_send_pages', '', 0, NULL, NULL),
(42, 42, 'o', 'Received Pages', 'tiki-received_pages.php', 245, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_admin_received_pages', '', 0, NULL, NULL),
(43, 42, 'o', 'Structures', 'tiki-admin_structures.php', 250, 'feature_wiki,feature_wiki_structure', 'tiki_p_view', '', 0, NULL, NULL),
(44, 42, 'o', 'Mind Map', 'tiki-mindmap.php', 255, 'feature_wiki_mindmap', 'tiki_p_view', '', 0, NULL, NULL),
(45, 42, 's', 'Image Galleries', 'tiki-galleries.php', 300, 'feature_galleries', 'tiki_p_view_image_gallery', '', 0, 'stock_select-color48x48', NULL),
(46, 42, 'o', 'Galleries', 'tiki-galleries.php', 305, 'feature_galleries', 'tiki_p_list_image_galleries', '', 0, NULL, NULL),
(47, 42, 'o', 'Rankings', 'tiki-galleries_rankings.php', 310, 'feature_galleries,feature_gal_rankings', 'tiki_p_list_image_galleries', '', 0, NULL, NULL),
(48, 42, 'o', 'Upload Image', 'tiki-upload_image.php', 315, 'feature_galleries', 'tiki_p_upload_images', '', 0, NULL, NULL),
(49, 42, 'o', 'Directory Batch', 'tiki-batch_upload.php', 318, 'feature_galleries,feature_gal_batch', 'tiki_p_batch_upload', '', 0, NULL, NULL),
(50, 42, 'o', 'System Gallery', 'tiki-list_gallery.php?galleryId=0', 320, 'feature_galleries', 'tiki_p_admin_galleries', '', 0, NULL, NULL),
(51, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_read_article', '', 0, 'stock_bold48x48', NULL),
(52, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, 'stock_bold48x48', NULL),
(53, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(54, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(55, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(56, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(57, 42, 'o', 'Rankings', 'tiki-cms_rankings.php', 365, 'feature_articles,feature_cms_rankings', 'tiki_p_read_article', '', 0, NULL, NULL),
(58, 42, 'o', 'Submit Article', 'tiki-edit_submission.php', 370, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(59, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(60, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_approve_submission', '', 0, NULL, NULL),
(61, 42, 'o', 'View Submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_remove_submission', '', 0, NULL, NULL),
(62, 42, 'o', 'New Article', 'tiki-edit_article.php', 380, 'feature_articles', 'tiki_p_read_article,tiki_p_edit_article', '', 0, NULL, NULL),
(63, 42, 'o', 'Send Articles', 'tiki-send_objects.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_send_articles', '', 0, NULL, NULL),
(64, 42, 'o', 'Received Articles', 'tiki-received_articles.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_admin_received_articles', '', 0, NULL, NULL),
(65, 42, 'o', 'Admin Types', 'tiki-article_types.php', 395, 'feature_articles', 'tiki_p_articles_admin_types', '', 0, NULL, NULL),
(66, 42, 'o', 'Admin Topics', 'tiki-admin_topics.php', 390, 'feature_articles', 'tiki_p_articles_admin_topics', '', 0, NULL, NULL),
(67, 42, 's', 'Blogs', 'tiki-list_blogs.php', 450, 'feature_blogs', 'tiki_p_read_blog', '', 0, 'blogs48x48', NULL),
(68, 42, 'o', 'List Blogs', 'tiki-list_blogs.php', 455, 'feature_blogs', 'tiki_p_read_blog', '', 0, NULL, NULL),
(69, 42, 'o', 'Rankings', 'tiki-blog_rankings.php', 460, 'feature_blogs,feature_blog_rankings', 'tiki_p_read_blog', '', 0, NULL, NULL),
(70, 42, 'o', 'Create Blog', 'tiki-edit_blog.php', 465, 'feature_blogs', 'tiki_p_read_blog,tiki_p_create_blogs', '', 0, NULL, NULL),
(71, 42, 'o', 'New Blog Post', 'tiki-blog_post.php', 470, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_post', '', 0, NULL, NULL),
(72, 42, 'o', 'List Blog Posts', 'tiki-list_posts.php', 475, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_admin', '', 0, NULL, NULL),
(73, 42, 's', 'Forums', 'tiki-forums.php', 500, 'feature_forums', 'tiki_p_forum_read', '', 0, 'stock_index48x48', NULL),
(74, 42, 'o', 'List Forums', 'tiki-forums.php', 505, 'feature_forums', 'tiki_p_forum_read', '', 0, NULL, NULL),
(75, 42, 'o', 'Rankings', 'tiki-forum_rankings.php', 510, 'feature_forums,feature_forum_rankings', 'tiki_p_forum_read', '', 0, NULL, NULL),
(76, 42, 'o', 'Admin Forums', 'tiki-admin_forums.php', 515, 'feature_forums', 'tiki_p_forum_read,tiki_p_admin_forum', '', 0, NULL, NULL),
(77, 42, 's', 'Directory', 'tiki-directory_browse.php', 550, 'feature_directory', 'tiki_p_view_directory', '', 0, 'directory48x48', NULL),
(78, 42, 'o', 'Submit a new link', 'tiki-directory_add_site.php', 555, 'feature_directory', 'tiki_p_submit_link', '', 0, NULL, NULL),
(79, 42, 'o', 'Browse Directory', 'tiki-directory_browse.php', 560, 'feature_directory', 'tiki_p_view_directory', '', 0, NULL, NULL),
(80, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_cats', '', 0, NULL, NULL),
(81, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_sites', '', 0, NULL, NULL),
(82, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_validate_links', '', 0, NULL, NULL),
(83, 42, 's', 'File Galleries', 'tiki-list_file_gallery.php', 600, 'feature_file_galleries', 'tiki_p_list_file_galleries|tiki_p_view_file_gallery|tiki_p_upload_files', '', 0, 'file-manager48x48', NULL),
(84, 42, 'o', 'List Galleries', 'tiki-list_file_gallery.php', 605, 'feature_file_galleries', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(85, 42, 'o', 'Rankings', 'tiki-file_galleries_rankings.php', 610, 'feature_file_galleries,feature_file_galleries_rankings', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(86, 42, 'o', 'Upload File', 'tiki-upload_file.php', 615, 'feature_file_galleries', 'tiki_p_upload_files', '', 0, NULL, NULL),
(87, 42, 'o', 'Directory batch', 'tiki-batch_upload_files.php', 617, 'feature_file_galleries_batch', 'tiki_p_batch_upload_file_dir', '', 0, NULL, NULL),
(88, 42, 's', 'FAQs', 'tiki-list_faqs.php', 650, 'feature_faqs', 'tiki_p_view_faqs', '', 0, 'stock_dialog_question48x48', NULL),
(89, 42, 'o', 'List FAQs', 'tiki-list_faqs.php', 665, 'feature_faqs', 'tiki_p_view_faqs', '', 0, NULL, NULL),
(90, 42, 'o', 'Admin FAQs', 'tiki-list_faqs.php', 660, 'feature_faqs', 'tiki_p_admin_faqs', '', 0, NULL, NULL),
(91, 42, 's', 'Quizzes', 'tiki-list_quizzes.php', 750, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, 'quizzes48x48', NULL),
(92, 42, 'o', 'List Quizzes', 'tiki-list_quizzes.php', 755, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, NULL, NULL),
(93, 42, 'o', 'Quiz Stats', 'tiki-quiz_stats.php', 760, 'feature_quizzes', 'tiki_p_view_quiz_stats', '', 0, NULL, NULL),
(94, 42, 'o', 'Admin Quizzes', 'tiki-edit_quiz.php', 765, 'feature_quizzes', 'tiki_p_admin_quizzes', '', 0, NULL, NULL),
(95, 42, 's', 'Spreadsheets', 'tiki-sheets.php', 780, 'feature_sheet', 'tiki_p_view_sheet', '', 0, 'spreadsheet48x48', NULL),
(96, 42, 'o', 'List Sheets', 'tiki-sheets.php', 782, 'feature_sheet', 'tiki_p_view_sheet', '', 0, NULL, NULL),
(97, 42, 's', 'Trackers', 'tiki-list_trackers.php', 800, 'feature_trackers', 'tiki_p_list_trackers', '', 0, 'gnome-settings-font48x48', NULL),
(98, 42, 'o', 'List Trackers', 'tiki-list_trackers.php', 805, 'feature_trackers', 'tiki_p_list_trackers', '', 0, NULL, NULL),
(99, 42, 'o', 'Manage Tabular Formats', 'tiki-tabular-manage', 810, 'tracker_tabular_enabled', 'tiki_p_tabular_admin', '', 0, NULL, NULL),
(100, 42, 's', 'Accounting', 'tiki-accounting_books.php', 830, 'feature_accounting', 'tiki_p_acct_view', '', 0, 'accounting48x48', NULL),
(101, 42, 'o', 'Accounting books', 'tiki-accounting_books.php', 835, 'feature_accounting', 'tiki_p_acct_view', '', 0, NULL, NULL),
(102, 42, 's', 'Surveys', 'tiki-list_surveys.php', 850, 'feature_surveys', 'tiki_p_take_survey', '', 0, 'surveys48x48', NULL),
(103, 42, 'o', 'List Surveys', 'tiki-list_surveys.php', 855, 'feature_surveys', 'tiki_p_take_survey', '', 0, NULL, NULL),
(104, 42, 'o', 'Stats', 'tiki-survey_stats.php', 860, 'feature_surveys', 'tiki_p_view_survey_stats', '', 0, 'stats48x48', NULL),
(105, 42, 'o', 'Admin Surveys', 'tiki-admin_surveys.php', 865, 'feature_surveys', 'tiki_p_admin_surveys', '', 0, NULL, NULL),
(106, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_subscribe_newsletters', '', 0, 'messages48x48', NULL),
(107, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, 'messages48x48', NULL),
(108, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, 'messages48x48', NULL),
(109, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_list_newsletters', '', 0, 'messages48x48', NULL),
(110, 42, 'o', 'Send Newsletters', 'tiki-send_newsletters.php', 905, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, NULL, NULL),
(111, 42, 'o', 'Admin Newsletters', 'tiki-admin_newsletters.php', 910, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, NULL, NULL),
(112, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin', '', 0, 'icon-configuration48x48', NULL),
(113, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_categories', '', 0, 'icon-configuration48x48', NULL),
(114, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_banners', '', 0, 'icon-configuration48x48', NULL),
(115, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(116, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_cookies', '', 0, 'icon-configuration48x48', NULL),
(117, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_dynamic', '', 0, 'icon-configuration48x48', NULL),
(118, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_mailin', '', 0, 'icon-configuration48x48', NULL),
(119, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_content_templates', '', 0, 'icon-configuration48x48', NULL),
(120, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_html_pages', '', 0, 'icon-configuration48x48', NULL),
(121, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_view_referer_stats', '', 0, 'icon-configuration48x48', NULL),
(122, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_shoutbox', '', 0, 'icon-configuration48x48', NULL),
(123, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_live_support_admin', '', 0, 'icon-configuration48x48', NULL),
(124, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'user_is_operator', '', 0, 'icon-configuration48x48', NULL),
(125, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, 'icon-configuration48x48', NULL),
(126, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(127, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_view_tpl', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(128, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_editcss', 'tiki_p_create_css', '', 0, 'icon-configuration48x48', NULL),
(129, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_contribution', '', 0, 'icon-configuration48x48', NULL),
(130, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_users', '', 0, 'icon-configuration48x48', NULL),
(131, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_toolbars', '', 0, 'icon-configuration48x48', NULL),
(132, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_menu', '', 0, 'icon-configuration48x48', NULL),
(133, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_clean_cache', '', 0, 'icon-configuration48x48', NULL),
(134, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_modules', '', 0, 'icon-configuration48x48', NULL),
(135, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_webservices', '', 0, 'icon-configuration48x48', NULL),
(136, 42, 'o', ' Control Panels', 'tiki-admin.php', 1051, '', 'tiki_p_admin', '', 0, NULL, NULL),
(137, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'tiki_p_live_support_admin', '', 0, NULL, NULL),
(138, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'user_is_operator', '', 0, NULL, NULL),
(139, 42, 'o', 'Banning', 'tiki-admin_banning.php', 1060, 'feature_banning', 'tiki_p_admin_banning', '', 0, NULL, NULL),
(140, 42, 'o', 'Calendar', 'tiki-admin_calendars.php', 1065, 'feature_calendar', 'tiki_p_admin_calendar', '', 0, NULL, NULL),
(141, 42, 'o', 'Admin credits', 'tiki-admin_credits.php', 1067, 'payment_feature', 'tiki_p_admin_users', '', 0, NULL, NULL),
(142, 42, 'o', 'Users', 'tiki-adminusers.php', 1070, '', 'tiki_p_admin_users', '', 0, NULL, NULL),
(143, 42, 'o', 'Groups', 'tiki-admingroups.php', 1075, '', 'tiki_p_admin', '', 0, NULL, NULL),
(144, 42, 'o', 'External Pages Cache', 'tiki-list_cache.php', 1080, 'cachepages', 'tiki_p_admin', '', 0, NULL, NULL),
(145, 42, 'o', 'Modules', 'tiki-admin_modules.php', 1085, '', 'tiki_p_admin_modules', '', 0, NULL, NULL),
(146, 42, 'o', 'Hotwords', 'tiki-admin_hotwords.php', 1095, 'feature_hotwords', 'tiki_p_admin', '', 0, NULL, NULL),
(147, 42, 'o', 'Edit languages', 'tiki-edit_languages.php', 1098, 'lang_use_db', 'tiki_p_edit_languages', '', 0, NULL, NULL),
(148, 42, 'o', 'External Feeds', 'tiki-admin_rssmodules.php', 1100, '', 'tiki_p_admin_rssmodules', '', 0, NULL, NULL),
(149, 42, 'o', 'External Wikis', 'tiki-admin_external_wikis.php', 1102, '', 'tiki_p_admin', '', 0, NULL, NULL),
(150, 42, 'o', 'Menus', 'tiki-admin_menus.php', 1105, '', 'tiki_p_edit_menu', '', 0, NULL, NULL),
(151, 42, 'o', 'Polls', 'tiki-admin_polls.php', 1110, 'feature_polls', 'tiki_p_admin_polls', '', 0, NULL, NULL),
(152, 42, 'o', 'Mail Notifications', 'tiki-admin_notifications.php', 1120, '', 'tiki_p_admin_notifications', '', 0, NULL, NULL),
(153, 42, 'o', 'Search Stats', 'tiki-search_stats.php', 1125, 'feature_search_stats', 'tiki_p_admin', '', 0, NULL, NULL),
(154, 42, 'o', 'Theme Control', 'tiki-theme_control.php', 1130, 'feature_theme_control', 'tiki_p_admin', '', 0, NULL, NULL),
(155, 42, 'o', 'Tokens', 'tiki-admin_tokens.php', 1132, 'auth_token_access', 'tiki_p_admin', '', 0, NULL, NULL),
(156, 42, 'o', 'Toolbars', 'tiki-admin_toolbars.php', 1135, '', 'tiki_p_admin_toolbars', '', 0, NULL, NULL),
(157, 42, 'o', 'Transitions', 'tiki-admin_transitions.php', 1140, '', 'tiki_p_admin', '', 0, NULL, NULL),
(158, 42, 'o', 'Categories', 'tiki-admin_categories.php', 1145, 'feature_categories', 'tiki_p_admin_categories', '', 0, 'categories48x48', NULL),
(159, 42, 'o', 'Banners', 'tiki-list_banners.php', 1150, 'feature_banners', 'tiki_p_admin_banners', '', 0, NULL, NULL),
(160, 42, 'o', 'Edit Templates', 'tiki-edit_templates.php', 1155, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, NULL, NULL),
(161, 42, 'o', 'View Templates', 'tiki-edit_templates.php', 1155, 'feature_view_tpl', 'tiki_p_edit_templates', '', 2, NULL, NULL),
(162, 42, 'o', 'Edit CSS', 'tiki-edit_css.php', 1158, 'feature_editcss', 'tiki_p_create_css', '', 2, NULL, NULL),
(163, 42, 'o', 'Dynamic content', 'tiki-list_contents.php', 1165, 'feature_dynamic_content', 'tiki_p_admin_dynamic', '', 0, NULL, NULL),
(164, 42, 'o', 'Mail-in', 'tiki-admin_mailin.php', 1175, 'feature_mailin', 'tiki_p_admin_mailin', '', 0, NULL, NULL),
(165, 42, 'o', 'HTML Pages', 'tiki-admin_html_pages.php', 1185, 'feature_html_pages', 'tiki_p_edit_html_pages', '', 0, NULL, NULL),
(166, 42, 'o', 'Shoutbox', 'tiki-shoutbox.php', 1190, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(167, 42, 'o', 'Shoutbox Words', 'tiki-admin_shoutbox_words.php', 1191, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(168, 42, 'o', 'Referer Stats', 'tiki-referer_stats.php', 1195, 'feature_referer_stats', 'tiki_p_view_referer_stats', '', 0, NULL, NULL),
(169, 42, 'o', 'Integrator', 'tiki-admin_integrator.php', 1205, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, NULL, NULL),
(170, 42, 'o', 'phpinfo', 'tiki-phpinfo.php', 1215, '', 'tiki_p_admin', '', 0, NULL, NULL),
(171, 42, 'o', 'Tiki Cache/Sys Admin', 'tiki-admin_system.php', 1230, '', 'tiki_p_clean_cache', '', 0, NULL, NULL),
(172, 42, 'o', 'Tiki Importer', 'tiki-importer.php', 1240, '', 'tiki_p_admin_importer', '', 0, NULL, NULL),
(173, 42, 'o', 'Tiki Logs', 'tiki-syslog.php', 1245, '', 'tiki_p_admin', '', 0, NULL, NULL),
(174, 42, 'o', 'Security Admin', 'tiki-admin_security.php', 1250, '', 'tiki_p_admin', '', 0, NULL, NULL),
(175, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_admin', '', 0, NULL, NULL),
(176, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog', '', 0, NULL, NULL),
(177, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog_owngroups', '', 0, NULL, NULL),
(178, 42, 'o', 'Content Templates', 'tiki-admin_content_templates.php', 1256, 'feature_wiki_templates', 'tiki_p_edit_content_templates', '', 0, NULL, NULL),
(179, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_wiki_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(180, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_article_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(181, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_file_galleries_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(182, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_image_galleries_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(183, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_poll_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(184, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_faq_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(185, 42, 'o', 'Contribution', 'tiki-admin_contribution.php', 1265, 'feature_contribution', 'tiki_p_admin_contribution', '', 0, NULL, NULL),
(186, 42, 's', 'Kaltura Video', 'tiki-list_kaltura_entries.php', 950, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, 'kaltura48x48', NULL),
(187, 42, 'o', 'List Media', 'tiki-list_kaltura_entries.php', 952, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, NULL, NULL),
(188, 42, 'o', 'Upload Media', 'tiki-kaltura_upload.php', 954, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_upload_videos', '', 0, NULL, NULL),
(189, 42, 'o', 'Permissions', 'tiki-objectpermissions.php', 1077, '', 'tiki_p_admin|tiki_p_admin_objects', '', 0, NULL, NULL),
(190, 42, 'o', 'Perspectives', 'tiki-edit_perspective.php', 1081, 'feature_perspective', 'tiki_p_admin', '', 0, NULL, NULL),
(191, 42, 'o', 'Social networks', 'tiki-socialnetworks.php', 115, 'feature_mytiki,feature_socialnetworks', 'tiki_p_socialnetworks|tiki_p_admin_socialnetworks', 'Registered', 0, NULL, NULL),
(192, 42, 'o', 'TimeSheet', 'tiki-timesheet.php', 39, 'feature_time_sheet', '', '', 0, 'timesheet48x48', NULL),
(193, 42, 'o', 'Scheduler', 'tiki-admin_schedulers.php', 1270, '', 'tiki_p_admin', '', 0, NULL, NULL),
(194, 42, 'o', 'Webservices', 'tiki-admin_webservices.php', 1280, 'feature_webservices', 'tiki_p_admin_webservices', '', 0, NULL, NULL),
(195, 42, 'o', 'References', 'tiki-references.php', 255, 'feature_wiki,feature_references', 'tiki_p_edit_references', '', 0, NULL, NULL),
(196, 42, 'o', 'Custom Routes', 'tiki-admin_routes.php', 1290, 'feature_sefurl_routes', 'tiki_p_admin', '', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_events`
--

CREATE TABLE `tiki_minical_events` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `eventId` int(12) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `start` int(14) DEFAULT NULL,
  `end` int(14) DEFAULT NULL,
  `security` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` int(3) DEFAULT NULL,
  `topicId` int(12) DEFAULT NULL,
  `reminded` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_topics`
--

CREATE TABLE `tiki_minical_topics` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `topicId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isIcon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`topicId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minichat`
--

CREATE TABLE `tiki_minichat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ts` int(10) unsigned NOT NULL,
  `user` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nick` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `msg` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `channel` (`channel`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_modules`
--

CREATE TABLE `tiki_modules` (
  `moduleId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ord` int(4) NOT NULL DEFAULT '0',
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cache_time` int(14) DEFAULT NULL,
  `rows` int(4) DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`moduleId`),
  KEY `positionType` (`position`,`type`),
  KEY `namePosOrdParam` (`name`(100),`position`,`ord`,`params`(120))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `tiki_modules`
--

INSERT INTO `tiki_modules` VALUES
(1, 'menu', 'left', 1, NULL, NULL, 7200, NULL, 'id=42&title=System+Menu', 'a:1:{i:0;s:10:"Registered";}'),
(2, 'logo', 'top', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(3, 'login_box', 'top', 2, NULL, NULL, 0, NULL, 'mode=popup&nobox=y', 'a:0:{}'),
(4, 'rsslist', 'bottom', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(5, 'poweredby', 'bottom', 2, NULL, NULL, 7200, NULL, 'nobox=y&icons=n&version=n', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletters`
--

CREATE TABLE `tiki_newsletters` (
  `nlId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastSent` int(14) DEFAULT NULL,
  `editions` int(10) DEFAULT NULL,
  `users` int(10) DEFAULT NULL,
  `allowUserSub` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `allowAnySub` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unsubMsg` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `validateAddr` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `frequency` int(14) DEFAULT NULL,
  `allowTxt` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allowArticleClip` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `autoArticleClip` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `articleClipTypes` text COLLATE utf8mb4_unicode_ci,
  `articleClipRange` int(14) DEFAULT NULL,
  `emptyClipBlocksSend` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  PRIMARY KEY (`nlId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_groups`
--

CREATE TABLE `tiki_newsletter_groups` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `include_groups` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  PRIMARY KEY (`nlId`,`groupName`(179))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_included`
--

CREATE TABLE `tiki_newsletter_included` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `includedId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nlId`,`includedId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_pages`
--

CREATE TABLE `tiki_newsletter_pages` (
  `nlId` int(12) NOT NULL,
  `wikiPageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `validateAddrs` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `addToList` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`wikiPageName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_subscriptions`
--

CREATE TABLE `tiki_newsletter_subscriptions` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valid` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscribed` int(14) DEFAULT NULL,
  `isUser` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `included` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`email`(178),`isUser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_oauthserver_clients`
--

CREATE TABLE `tiki_oauthserver_clients` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_secret` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `redirect_uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `client_id` (`client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_objects`
--

CREATE TABLE `tiki_objects` (
  `objectId` int(12) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `href` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `comments_locked` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`objectId`),
  KEY `type` (`type`,`objectId`),
  KEY `itemId` (`itemId`(141),`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_attributes`
--

CREATE TABLE `tiki_object_attributes` (
  `attributeId` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attributeId`),
  UNIQUE KEY `item_attribute_uq` (`type`,`itemId`(91),`attribute`(50)),
  KEY `attribute_lookup_ix` (`attribute`,`value`(121))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_ratings`
--

CREATE TABLE `tiki_object_ratings` (
  `catObjectId` int(12) NOT NULL DEFAULT '0',
  `pollId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_relations`
--

CREATE TABLE `tiki_object_relations` (
  `relationId` int(11) NOT NULL AUTO_INCREMENT,
  `relation` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`relationId`),
  KEY `relation_source_ix` (`source_type`,`source_itemId`),
  KEY `relation_target_ix` (`target_type`,`target_itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_scores`
--

CREATE TABLE `tiki_object_scores` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `triggerObjectType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerObjectId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerUser` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerEvent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruleId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipientObjectType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipientObjectId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pointsAssigned` int(11) NOT NULL,
  `pointsBalance` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `reversalOf` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_output`
--

CREATE TABLE `tiki_output` (
  `entityId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `outputType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(8) NOT NULL DEFAULT '0',
  `outputId` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`outputId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages`
--

CREATE TABLE `tiki_pages` (
  `page_id` int(14) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pageSlug` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` int(8) NOT NULL DEFAULT '0',
  `version_minor` int(8) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` int(8) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `cache` longtext COLLATE utf8mb4_unicode_ci,
  `wiki_cache` int(10) DEFAULT NULL,
  `cache_timestamp` int(14) DEFAULT NULL,
  `pageRank` decimal(4,3) DEFAULT NULL,
  `creator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_size` int(10) unsigned DEFAULT '0',
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) DEFAULT '0',
  `created` int(14) DEFAULT NULL,
  `wysiwyg` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wiki_authors_style` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `comments_enabled` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `pageName` (`pageName`),
  UNIQUE KEY `pageSlug` (`pageSlug`),
  KEY `data` (`data`(191)),
  KEY `pageRank` (`pageRank`),
  KEY `lastModif` (`lastModif`),
  FULLTEXT KEY `ft` (`pageName`,`description`,`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_changes`
--

CREATE TABLE `tiki_pages_changes` (
  `page_id` int(14) NOT NULL DEFAULT '0',
  `version` int(10) NOT NULL DEFAULT '0',
  `segments_added` int(10) DEFAULT NULL,
  `segments_removed` int(10) DEFAULT NULL,
  `segments_total` int(10) DEFAULT NULL,
  PRIMARY KEY (`page_id`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_translation_bits`
--

CREATE TABLE `tiki_pages_translation_bits` (
  `translation_bit_id` int(14) NOT NULL AUTO_INCREMENT,
  `page_id` int(14) NOT NULL,
  `version` int(8) NOT NULL,
  `source_translation_bit` int(10) DEFAULT NULL,
  `original_translation_bit` int(10) DEFAULT NULL,
  `flags` set('critical') COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`translation_bit_id`),
  KEY `page_id` (`page_id`),
  KEY `original_translation_bit` (`original_translation_bit`),
  KEY `source_translation_bit` (`source_translation_bit`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pageviews`
--

CREATE TABLE `tiki_pageviews` (
  `day` int(14) NOT NULL DEFAULT '0',
  `pageviews` int(14) DEFAULT NULL,
  PRIMARY KEY (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_footnotes`
--

CREATE TABLE `tiki_page_footnotes` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pageName` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`user`(150),`pageName`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_references`
--

CREATE TABLE `tiki_page_references` (
  `ref_id` int(14) NOT NULL AUTO_INCREMENT,
  `page_id` int(14) DEFAULT NULL,
  `biblio_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `part` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publisher` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `style` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ref_id`),
  UNIQUE KEY `uk1_tiki_page_ref_biblio_code` (`page_id`,`biblio_code`),
  KEY `PageId` (`page_id`),
  KEY `idx_tiki_page_ref_title` (`title`(191)),
  KEY `idx_tiki_page_ref_author` (`author`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_received`
--

CREATE TABLE `tiki_payment_received` (
  `paymentReceivedId` int(11) NOT NULL AUTO_INCREMENT,
  `paymentRequestId` int(11) NOT NULL,
  `payment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `amount` decimal(7,2) DEFAULT NULL,
  `type` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'paid',
  `details` text COLLATE utf8mb4_unicode_ci,
  `userId` int(8) DEFAULT NULL,
  PRIMARY KEY (`paymentReceivedId`),
  KEY `payment_request_ix` (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_requests`
--

CREATE TABLE `tiki_payment_requests` (
  `paymentRequestId` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(7,2) NOT NULL,
  `amount_paid` decimal(7,2) NOT NULL DEFAULT '0.00',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `due_date` timestamp NULL DEFAULT NULL,
  `authorized_until` timestamp NULL DEFAULT NULL,
  `cancel_date` timestamp NULL DEFAULT NULL,
  `description` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions` text COLLATE utf8mb4_unicode_ci,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `userId` int(8) DEFAULT NULL,
  PRIMARY KEY (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspectives`
--

CREATE TABLE `tiki_perspectives` (
  `perspectiveId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`perspectiveId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspective_preferences`
--

CREATE TABLE `tiki_perspective_preferences` (
  `perspectiveId` int(11) NOT NULL,
  `pref` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`perspectiveId`,`pref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_plugin_security`
--

CREATE TABLE `tiki_plugin_security` (
  `fingerprint` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_by` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_objectId` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`fingerprint`(191)),
  KEY `last_object` (`last_objectType`,`last_objectId`(171))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_polls`
--

CREATE TABLE `tiki_polls` (
  `pollId` int(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publishDate` int(14) DEFAULT NULL,
  `voteConsiderationSpan` int(4) DEFAULT '0',
  PRIMARY KEY (`pollId`),
  KEY `tiki_poll_lookup` (`active`,`title`(190))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_objects`
--

CREATE TABLE `tiki_poll_objects` (
  `catObjectId` int(11) NOT NULL DEFAULT '0',
  `pollId` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_options`
--

CREATE TABLE `tiki_poll_options` (
  `pollId` int(8) NOT NULL DEFAULT '0',
  `optionId` int(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(4) NOT NULL DEFAULT '0',
  `votes` int(8) DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_preferences`
--

CREATE TABLE `tiki_preferences` (
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`name`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_preferences`
--

INSERT INTO `tiki_preferences` VALUES
('browsertitle', '[[site_name]]'),
('server_domain', '[[domhost]]'),
('sender_email', '[[admin_email]]'),
('https_login', 'allowed'),
('https_port', '443'),
('error_reporting_level', '2039'),
('use_proxy', 'n'),
('proxy_host', ''),
('proxy_port', ''),
('proxy_user', ''),
('proxy_pass', ''),
('error_reporting_adminonly', 'y'),
('smarty_notice_reporting', 'n'),
('log_tpl', 'n'),
('feature_switch_ssl_mode', 'n'),
('feature_show_stay_in_ssl_mode', 'y'),
('language', '[[end_language]]'),
('unified_mysql_index_rebuilding', '[[indexName]]'),
('unified_field_count', '36'),
('unified_identifier_fields', 'a:12:{i:0;s:8:"language";i:1;s:10:"gallery_id";i:2;s:15:"view_permission";i:3;s:13:"primary_image";i:4;s:11:"geo_located";i:5;s:12:"geo_location";i:6;s:13:"title_initial";i:7;s:15:"title_firstword";i:8;s:10:"searchable";i:9;s:3:"url";i:10;s:11:"object_type";i:11;s:9:"object_id";}'),
('unified_mysql_index_current', '[[indexName]]'),
('unified_last_rebuild', '[[timestamp]]'),
('unified_last_rebuild_stats', 'a:1:{s:7:"default";a:4:{s:6:"counts";a:5:{s:4:"file";i:0;s:12:"file gallery";i:3;s:4:"user";i:1;s:5:"group";i:3;s:9:"wiki page";i:0;}s:5:"times";a:6:{s:4:"file";d:0.0005681514739990234375;s:12:"file gallery";d:0.1725900173187255859375;s:4:"user";d:0.0400769710540771484375;s:5:"group";d:0.005220890045166015625;s:9:"wiki page";d:0.000113964080810546875;s:5:"total";d:0.2185699939727783203125;}s:25:"total tiki fields indexed";i:36;s:45:"total fields used in the mysql search index: ";i:37;}}'),
('wizard_admin_hide_on_login', 'n'),
('language_admin', '[[admin_language]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_private_messages`
--

CREATE TABLE `tiki_private_messages` (
  `messageId` int(8) NOT NULL AUTO_INCREMENT,
  `toNickname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `poster` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int(14) DEFAULT NULL,
  `received` tinyint(1) NOT NULL DEFAULT '0',
  `message` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`messageId`),
  KEY `received` (`received`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_profile_symbols`
--

CREATE TABLE `tiki_profile_symbols` (
  `domain` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `named` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`domain`,`profile`(70),`object`(71)),
  KEY `named` (`named`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_programmed_content`
--

CREATE TABLE `tiki_programmed_content` (
  `pId` int(8) NOT NULL AUTO_INCREMENT,
  `contentId` int(8) NOT NULL DEFAULT '0',
  `content_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `publishDate` int(14) NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_queue`
--

CREATE TABLE `tiki_queue` (
  `entryId` int(11) NOT NULL AUTO_INCREMENT,
  `queue` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `handler` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`entryId`),
  KEY `queue_name_ix` (`queue`),
  KEY `queue_handler_ix` (`handler`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quizzes`
--

CREATE TABLE `tiki_quizzes` (
  `quizId` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `canRepeat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `storeResults` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `questionsPerPage` int(4) DEFAULT NULL,
  `timeLimited` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timeLimit` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `taken` int(10) DEFAULT NULL,
  `immediateFeedback` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `showAnswers` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shuffleQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shuffleAnswers` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `bDeleted` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nAuthor` int(4) DEFAULT NULL,
  `bOnline` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bRandomQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nRandomQuestions` tinyint(4) DEFAULT NULL,
  `bLimitQuestionsPerPage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nLimitQuestionsPerPage` tinyint(4) DEFAULT NULL,
  `bMultiSession` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nCanRepeat` tinyint(4) DEFAULT NULL,
  `sGradingMethod` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sShowScore` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sShowCorrectAnswers` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sPublishStats` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bAdditionalQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bForum` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sForum` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sPrologue` text COLLATE utf8mb4_unicode_ci,
  `sData` text COLLATE utf8mb4_unicode_ci,
  `sEpilogue` text COLLATE utf8mb4_unicode_ci,
  `passingperct` int(4) DEFAULT '0',
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_questions`
--

CREATE TABLE `tiki_quiz_questions` (
  `questionId` int(10) NOT NULL AUTO_INCREMENT,
  `quizId` int(10) DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `position` int(4) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `maxPoints` int(4) DEFAULT NULL,
  PRIMARY KEY (`questionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_question_options`
--

CREATE TABLE `tiki_quiz_question_options` (
  `optionId` int(10) NOT NULL AUTO_INCREMENT,
  `questionId` int(10) DEFAULT NULL,
  `optionText` text COLLATE utf8mb4_unicode_ci,
  `points` int(4) DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_results`
--

CREATE TABLE `tiki_quiz_results` (
  `resultId` int(10) NOT NULL AUTO_INCREMENT,
  `quizId` int(10) DEFAULT NULL,
  `fromPoints` int(4) DEFAULT NULL,
  `toPoints` int(4) DEFAULT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`resultId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats`
--

CREATE TABLE `tiki_quiz_stats` (
  `quizId` int(10) NOT NULL DEFAULT '0',
  `questionId` int(10) NOT NULL DEFAULT '0',
  `optionId` int(10) NOT NULL DEFAULT '0',
  `votes` int(10) DEFAULT NULL,
  PRIMARY KEY (`quizId`,`questionId`,`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats_sum`
--

CREATE TABLE `tiki_quiz_stats_sum` (
  `quizId` int(10) NOT NULL DEFAULT '0',
  `quizName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timesTaken` int(10) DEFAULT NULL,
  `avgpoints` decimal(5,2) DEFAULT NULL,
  `avgavg` decimal(5,2) DEFAULT NULL,
  `avgtime` decimal(5,2) DEFAULT NULL,
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_configs`
--

CREATE TABLE `tiki_rating_configs` (
  `ratingConfigId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int(11) NOT NULL DEFAULT '3600',
  `formula` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `callbacks` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_obtained`
--

CREATE TABLE `tiki_rating_obtained` (
  `ratingId` int(11) NOT NULL AUTO_INCREMENT,
  `ratingConfigId` int(11) NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` int(11) NOT NULL,
  `expire` int(11) NOT NULL,
  `value` float NOT NULL,
  PRIMARY KEY (`ratingId`),
  UNIQUE KEY `tiki_obtained_rating_uq` (`type`,`object`,`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_articles`
--

CREATE TABLE `tiki_received_articles` (
  `receivedArticleId` int(14) NOT NULL AUTO_INCREMENT,
  `receivedFromSite` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedDate` int(14) DEFAULT NULL,
  `title` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(12) DEFAULT NULL,
  `useImage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_type` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(14) DEFAULT NULL,
  `image_x` int(4) DEFAULT NULL,
  `image_y` int(4) DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `body` longblob,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  PRIMARY KEY (`receivedArticleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_pages`
--

CREATE TABLE `tiki_received_pages` (
  `receivedPageId` int(14) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` longblob,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromSite` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedDate` int(14) DEFAULT NULL,
  `parent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint(3) unsigned DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `structureName` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentName` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_alias` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `pos` int(4) DEFAULT NULL,
  PRIMARY KEY (`receivedPageId`),
  KEY `structureName` (`structureName`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_referer_stats`
--

CREATE TABLE `tiki_referer_stats` (
  `referer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) DEFAULT NULL,
  `last` int(14) DEFAULT NULL,
  `lasturl` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`referer`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_registration_fields`
--

CREATE TABLE `tiki_registration_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `show` tinyint(1) NOT NULL DEFAULT '1',
  `size` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_related_categories`
--

CREATE TABLE `tiki_related_categories` (
  `categId` int(10) NOT NULL DEFAULT '0',
  `relatedTo` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`relatedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_feeds`
--

CREATE TABLE `tiki_rss_feeds` (
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rssVer` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `refresh` int(8) DEFAULT '300',
  `lastUpdated` int(14) DEFAULT NULL,
  `cache` longblob,
  PRIMARY KEY (`name`,`rssVer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_items`
--

CREATE TABLE `tiki_rss_items` (
  `rssItemId` int(11) NOT NULL AUTO_INCREMENT,
  `rssId` int(11) NOT NULL,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `publication_date` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `categories` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rssItemId`),
  KEY `tiki_rss_items_rss` (`rssId`),
  KEY `tiki_rss_items_item` (`rssId`,`guid`(177))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_modules`
--

CREATE TABLE `tiki_rss_modules` (
  `rssId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `refresh` int(8) DEFAULT NULL,
  `lastUpdated` int(14) DEFAULT NULL,
  `showTitle` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `showPubDate` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `sitetitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `siteurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actions` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rssId`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_scheduler`
--

CREATE TABLE `tiki_scheduler` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `run_time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `re_run` tinyint(4) DEFAULT NULL,
  `run_only_once` tinyint(4) DEFAULT NULL,
  `creation_date` int(14) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_scheduler_run`
--

CREATE TABLE `tiki_scheduler_run` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `scheduler_id` int(11) NOT NULL,
  `start_time` int(14) DEFAULT NULL,
  `end_time` int(14) DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `output` text COLLATE utf8mb4_unicode_ci,
  `stalled` tinyint(4) DEFAULT '0',
  `healed` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_schema`
--

CREATE TABLE `tiki_schema` (
  `patch_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `install_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patch_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_schema`
--

INSERT INTO `tiki_schema` VALUES
('00000000_schema_change_tiki', '[[regtime]]'),
('20080227_invite_tiki', '[[regtime]]'),
('20080809_semlinks_tiki', '[[regtime]]'),
('20080827_bigfeaturetype_tiki', '[[regtime]]'),
('20080829_pagealiasdata_tiki', '[[regtime]]'),
('20080829_pluginvalidation_tiki', '[[regtime]]'),
('20080901_pluginvalidation_tiki', '[[regtime]]'),
('20080902_trackerparsedesc_tiki', '[[regtime]]'),
('20080905_feature_tip_tiki', '[[regtime]]'),
('20080916_webservice_registry_tiki', '[[regtime]]'),
('20080922_calendar_customstatus_tiki', '[[regtime]]'),
('20080924_webmail_tiki', '[[regtime]]'),
('20080926_bannerindex_tiki', '[[regtime]]'),
('20081004_mindmap_menu_tiki', '[[regtime]]'),
('20081006_comments_moderation_tiki', '[[regtime]]'),
('20081008_bit_flags_nullable_tiki', '[[regtime]]'),
('20081010_filter_perms_tiki', '[[regtime]]'),
('20081014_trust_input_perm_tiki', '[[regtime]]'),
('20081018_filter_perms_tiki', '[[regtime]]'),
('20081019_score_tiki', '[[regtime]]'),
('20081022_application_menu_tiki', '[[regtime]]'),
('20081024_fulltext_file_tiki', '[[regtime]]'),
('20081027_calendar_tiki', '[[regtime]]'),
('20081027_file_galleries_tiki', '[[regtime]]'),
('20081027_groupalert_tiki', '[[regtime]]'),
('20081027_surveys_tiki', '[[regtime]]'),
('20081027_trackers_tiki', '[[regtime]]'),
('20081027_wysiwyg_history_tiki', '[[regtime]]'),
('20081029_tracker_index_tiki', '[[regtime]]'),
('20081102_application_menu_structures_tiki', '[[regtime]]'),
('20081105_calendar_items_allday_tiki', '[[regtime]]'),
('20081107_menu42_tiki', '[[regtime]]'),
('20081112_tiki_p_tracker_view_comments_tiki', '[[regtime]]'),
('20081114_tiki_banner_tiki', '[[regtime]]'),
('20081119_tiki_p_export_tracker_tiki', '[[regtime]]'),
('20081120_showCategories_tiki', '[[regtime]]'),
('20081120_tiki_poll_structures_update_tiki', '[[regtime]]'),
('20081125_tiki_tracker_types_tiki', '[[regtime]]'),
('20081127_calendar_recurrence_tiki', '[[regtime]]'),
('20081130_tiki_users_permission_tiki', '[[regtime]]'),
('20081211_newsletter_files_tiki', '[[regtime]]'),
('20081211_score_tiki', '[[regtime]]'),
('20081212_tiki_p_view_backlinks_tiki', '[[regtime]]'),
('20081214_webservice_post_tiki', '[[regtime]]'),
('20090106_group_watch_tiki', '[[regtime]]'),
('20090120_sefurl_rules_tiki', '[[regtime]]'),
('20090129_callendar_search_tiki', '[[regtime]]'),
('20090203_null_tiki', '[[regtime]]'),
('20090205_forum_and_comments_locking_tiki', '[[regtime]]'),
('20090205_menucase_tiki', '[[regtime]]'),
('20090205_menus_items_icons_tiki', '[[regtime]]'),
('20090206_content_tpl_menu_tiki', '[[regtime]]'),
('20090206_poll_tiki', '[[regtime]]'),
('20090211_mailnotification_tiki', '[[regtime]]'),
('20090212_forum_tiki', '[[regtime]]'),
('20090220_admin_section_tiki', '[[regtime]]'),
('20090226_admin_menu_tiki', '[[regtime]]'),
('20090301_browsertitle_tiki', '[[regtime]]'),
('20090304_tiki_p_view_backlink_without_s_tiki', '[[regtime]]'),
('20090306_menu_perms_tiki', '[[regtime]]'),
('20090306_text_for_menu_options_tiki', '[[regtime]]'),
('20090310_application_menu_tiki', '[[regtime]]'),
('20090310_feature_search_show_object_filter_tiki', '[[regtime]]'),
('20090311_remove_mod_menu_application_menu_tiki', '[[regtime]]'),
('20090316_index_tiki', '[[regtime]]'),
('20090323_maxUserImpressions_banners_tiki', '[[regtime]]'),
('20090330_quicktags_renames_tiki', '[[regtime]]'),
('20090401_newsletters_included_tiki', '[[regtime]]'),
('20090401_replace_shoutjax_with_shoutbox_tiki', '[[regtime]]'),
('20090401_replace_switch_lang2_with_switch_lang_tiki', '[[regtime]]'),
('20090416_plugin_security_tiki', '[[regtime]]'),
('20090416_quicktags_kil_email_tiki', '[[regtime]]'),
('20090416_quicktags_plugin_helpers_tiki', '[[regtime]]'),
('20090427_filegal_optionalize_tiki', '[[regtime]]'),
('20090429_groupId_tiki', '[[regtime]]'),
('20090513_calendar_priority_tiki', '[[regtime]]'),
('20090513_swffix_tiki', '[[regtime]]'),
('20090513_wiki_similar_permission_tiki', '[[regtime]]'),
('20090515_score_tiki', '[[regtime]]'),
('20090602_webmail_protocols_tiki', '[[regtime]]'),
('20090605_tiki_p_modify_tracker_items_pending_closed_tiki', '[[regtime]]'),
('20090617_add_new_table_for_reports_tiki', '[[regtime]]'),
('20090623_actionlog_view_article_tiki', '[[regtime]]'),
('20090626_change_pear_auth_preferences_to_ldap_tiki', '[[regtime]]'),
('20090707_tiki_p_delete_account_tiki', '[[regtime]]'),
('20090713_tiki_importer_permission_and_menu_entry_tiki', '[[regtime]]'),
('20090715_sefurl_for_filegalleries_tiki', '[[regtime]]'),
('20090720_perspectives_tiki', '[[regtime]]'),
('20090721_webmail_ext_public_tiki', '[[regtime]]'),
('20090727_category_permissions_tiki', '[[regtime]]'),
('20090727_user_votings_index_tiki', '[[regtime]]'),
('20090730_p_list_newsletters_tiki', '[[regtime]]'),
('20090803_perspective_permission_tiki', '[[regtime]]'),
('20090804_kaltura_permissions_tiki', '[[regtime]]'),
('20090804_menu_search_tiki', '[[regtime]]'),
('20090805_kill_newsreader_tiki', '[[regtime]]'),
('20090805_remove_drawings_prefs_etc_tiki', '[[regtime]]'),
('20090805_remove_games_tiki', '[[regtime]]'),
('20090806_group_permissions_tiki', '[[regtime]]'),
('20090806_menu_list_trackers_tiki', '[[regtime]]'),
('20090806_perms_featurechecks_tiki', '[[regtime]]'),
('20090806_remove_charts_tiki', '[[regtime]]'),
('20090806_remove_latin_collations_tiki', '[[regtime]]'),
('20090806_strasa_option_rename_tiki', '[[regtime]]'),
('20090807_transitions_tiki', '[[regtime]]'),
('20090808_add_wiki_minor_edits_tiki', '[[regtime]]'),
('20090809_marc_needs_more_space_tiki', '[[regtime]]'),
('20090811_filegals_container_tiki', '[[regtime]]'),
('20090811_kaltura_editor_pref_tiki', '[[regtime]]'),
('20090811_quizzes_tiki', '[[regtime]]'),
('20090811_rename_quicktags_to_toolbars_tiki', '[[regtime]]'),
('20090823_kaltura_menu_options_tiki', '[[regtime]]'),
('20090826_group_expiration_tiki', '[[regtime]]'),
('20090904_wysiwyg_newsletters_tiki', '[[regtime]]'),
('20090911_tracker_item_change_user_tiki', '[[regtime]]'),
('20090912_change_feature_name_for_lesser_magic_tiki', '[[regtime]]'),
('20090913_plugin_security_addedby_tiki', '[[regtime]]'),
('20090915_change_perms_for_browse_cats_tiki', '[[regtime]]'),
('20090921_logo_tiki', '[[regtime]]'),
('20090923_mod_change_category_defaults_tiki', '[[regtime]]'),
('20090925_online_logged_users_modules_merge_tiki', '[[regtime]]'),
('20090927_top_images_modules_merge_tiki', '[[regtime]]'),
('20090928_galaxia_leftovers_tiki', '[[regtime]]'),
('20090928_last_images_modules_merge_tiki', '[[regtime]]'),
('20090928_transition_guards_text_tiki', '[[regtime]]'),
('20091004_last_tracker_items_modules_merge_tiki', '[[regtime]]'),
('20091007_update_database_structure_tiki', '[[regtime]]'),
('20091008_reg_group_includes_anon_tiki', '[[regtime]]'),
('20091011_serurl_dl_order_tiki', '[[regtime]]'),
('20091013_fix_perms_tiki', '[[regtime]]'),
('20091015_application_menu_admin_renames_tiki', '[[regtime]]'),
('20091016_categorization_tracker_item_tiki', '[[regtime]]'),
('20091019_article_by_rating_modules_merge_tiki', '[[regtime]]'),
('20091019_last_articles_modules_merge_tiki', '[[regtime]]'),
('20091019_users_perms_types_tidying_tiki', '[[regtime]]'),
('20091020_bigger_user_prefs_tiki', '[[regtime]]'),
('20091020_faq_created_tiki', '[[regtime]]'),
('20091020_kaltura_tiki', '[[regtime]]'),
('20091020_remove_charts_tiki', '[[regtime]]'),
('20091020_sefurl_trackeritem_tiki', '[[regtime]]'),
('20091021_moz_pagelist_tiki', '[[regtime]]'),
('20091023_bookmarks_name_lengthen_tiki', '[[regtime]]'),
('20091023_nul_categ_tiki', '[[regtime]]'),
('20091023_report_tiki', '[[regtime]]'),
('20091027_multiple_session_handler_tiki', '[[regtime]]'),
('20091028_quota_tiki', '[[regtime]]'),
('20091030_wiki_watch_tiki', '[[regtime]]'),
('20091103_upgrade_categperm_tiki', '[[regtime]]'),
('20091105_auth_tokens_tiki', '[[regtime]]'),
('20091111_fgal_size_tiki', '[[regtime]]'),
('20091112_rename_mnu_application_menu_tiki', '[[regtime]]'),
('20091112_template_type_tiki', '[[regtime]]'),
('20091113_old_categ_perm_tiki', '[[regtime]]'),
('20091118_sefurl_tiki', '[[regtime]]'),
('20091120_poll_lookup_index_tiki', '[[regtime]]'),
('20091120_username_pattern_tiki', '[[regtime]]'),
('20091123_dns_permission_tiki', '[[regtime]]'),
('20091123_metrics_tiki', '[[regtime]]'),
('20091123_upgrade_categperm_2_tiki', '[[regtime]]'),
('20091124_fgal_backlink_tiki', '[[regtime]]'),
('20091124_metrics_dsn_tiki', '[[regtime]]'),
('20091125_wiki_comments_per_page_tiki', '[[regtime]]'),
('20091126_dynamic_variables_i18n_tiki', '[[regtime]]'),
('20091204_filegal_wiki_syntax_tiki', '[[regtime]]'),
('20091204_tiki_p_view_newsletter_tiki', '[[regtime]]'),
('20091208_backlink_perms_tiki', '[[regtime]]'),
('20091209_rss_feeds_name_tiki', '[[regtime]]'),
('20091210_charset_tiki', '[[regtime]]'),
('20091210_dcs_type_tiki', '[[regtime]]'),
('20091214_perspective_management_tiki', '[[regtime]]'),
('20091216_show_backlinks_tiki', '[[regtime]]'),
('20091228_page_keywords_tiki', '[[regtime]]'),
('20100101_search_modules_merge_tiki', '[[regtime]]'),
('20100101_search_wiki_page_modules_merge_tiki', '[[regtime]]'),
('20100104_tiki_p_tracker_revote_ratings_tiki', '[[regtime]]'),
('20100106_forum_att_list_nb_tiki', '[[regtime]]'),
('20100107_payment_tiki', '[[regtime]]'),
('20100113_forum_display_tiki', '[[regtime]]'),
('20100114_tiki_actionlog_merge_tiki', '[[regtime]]'),
('20100115_admin_modules_menu_tiki', '[[regtime]]'),
('20100115_tiki_p_admin_modules_tiki', '[[regtime]]'),
('20100115_translations_in_progress_tiki', '[[regtime]]'),
('20100117_old_doc_tw_o_url_tiki', '[[regtime]]'),
('20100118_blog_use_author_tiki', '[[regtime]]'),
('20100118_forum_display_tiki', '[[regtime]]'),
('20100126_file_lastDownload_tiki', '[[regtime]]'),
('20100128_tiki_p_blog_view_ref_tiki', '[[regtime]]'),
('20100129_clean_up_tiki', '[[regtime]]'),
('20100129_events_kil_tiki', '[[regtime]]'),
('20100203_payment_detail_tiki', '[[regtime]]'),
('20100205_tiki_p_wiki_view_ref_tiki', '[[regtime]]'),
('20100207_repair_file_galleries_tiki', '[[regtime]]'),
('20100211_rss_items_tiki', '[[regtime]]'),
('20100211_tiki_perms_menu_item_tiki', '[[regtime]]'),
('20100211_tiki_sheet_add_parseValues_tiki', '[[regtime]]'),
('20100212_rss_automation_tiki', '[[regtime]]'),
('20100213_group_inclusion_key_tiki', '[[regtime]]'),
('20100214_workspaces_remove_menu_items_tiki', '[[regtime]]'),
('20100215_create_tiki_user_login_cookies_tiki', '[[regtime]]'),
('20100215_rating_permissions_tiki', '[[regtime]]'),
('20100216_attributes_tiki', '[[regtime]]'),
('20100216_kil_moz_screencast_tiki', '[[regtime]]'),
('20100216_rename_tikisheet_tiki', '[[regtime]]'),
('20100217_rating_config_tiki', '[[regtime]]'),
('20100218_auth_token_reuse_tiki', '[[regtime]]'),
('20100222_add_webmail_fromEmail_field_tiki', '[[regtime]]'),
('20100222_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100223_blog_always_owner_tiki', '[[regtime]]'),
('20100224_object_relations_tiki', '[[regtime]]'),
('20100226_menu_template_feature_check_tiki', '[[regtime]]'),
('20100226_tracker_dump_perm_tiki', '[[regtime]]'),
('20100302_filegal_images_max_sizes_tiki', '[[regtime]]'),
('20100308_file_delete_after_tiki', '[[regtime]]'),
('20100309_add_sheet_parent_tiki', '[[regtime]]'),
('20100312_emailPattern_tiki', '[[regtime]]'),
('20100324_newsletters_clippings_tiki', '[[regtime]]'),
('20100409_bigger_module_params_tiki', '[[regtime]]'),
('20100414_actionlog_pref_tiki', '[[regtime]]'),
('20100414_actionlog_system_tiki', '[[regtime]]'),
('20100419_bigbluebutton_tiki', '[[regtime]]'),
('20100422_tracker_log_tiki', '[[regtime]]'),
('20100429_newsletter_pages_tiki', '[[regtime]]'),
('20100507_flash_banner_tiki', '[[regtime]]'),
('20100519_actionlog_tiki', '[[regtime]]'),
('20100525_tracker_validation_message_tiki', '[[regtime]]'),
('20100525_tracker_validation_tiki', '[[regtime]]'),
('20100611_rss_items_url_tiki', '[[regtime]]'),
('20100617_sefurl_user_info_tiki', '[[regtime]]'),
('20100618_calendar_participation_tiki', '[[regtime]]'),
('20100621_pageprefixaliasdata_tiki', '[[regtime]]'),
('20100622_pageprefixtrackeritemid_tiki', '[[regtime]]'),
('20100623_semantic_to_relation_tiki', '[[regtime]]'),
('20100624_banning_index_tiki', '[[regtime]]'),
('20100628_payment_user_tiki', '[[regtime]]'),
('20100629_remove_feature_blog_comments_tiki', '[[regtime]]'),
('20100702_discount_tiki', '[[regtime]]'),
('20100712_remove_unsupported_feed_formats_tiki', '[[regtime]]'),
('20100713_rename_feed_prefs_tiki', '[[regtime]]'),
('20100714_batch_transition_tiki', '[[regtime]]'),
('20100716_user_selector_pref_rename_tiki', '[[regtime]]'),
('20100720_tiki_p_view_page_contribution_tiki', '[[regtime]]'),
('20100721_batch_transition_rollback_tiki', '[[regtime]]'),
('20100721_todo_tiki', '[[regtime]]'),
('20100721_todonotif_tiki', '[[regtime]]'),
('20100727_tiki_p_promote_page_tiki', '[[regtime]]'),
('20100730_list_image_article_tiki', '[[regtime]]'),
('20100802_tiki_p_share_tiki', '[[regtime]]'),
('20100802_url_shortener_tiki', '[[regtime]]'),
('20100804_remove_tiki_languages_tiki', '[[regtime]]'),
('20100806_blog_posts_header_tiki', '[[regtime]]'),
('20100807_alter_tiki_translate_fields_to_text_tiki', '[[regtime]]'),
('20100810_title_comments_upgrade_tiki', '[[regtime]]'),
('20100812_blog_control_max_related_content_tiki', '[[regtime]]'),
('20100812_blog_show_related_content_tiki', '[[regtime]]'),
('20100817_add_email_and_website_fields_to_comments_tiki', '[[regtime]]'),
('20100817_credits_tiki', '[[regtime]]'),
('20100817_rename_preference_wiki_comments_notitle_tiki', '[[regtime]]'),
('20100818_watch_tiki', '[[regtime]]'),
('20100820_blog_posts_wysiwyg_tiki', '[[regtime]]'),
('20100820_feed_fields_text_and_desc_are_not_empty_tiki', '[[regtime]]'),
('20100824_blog_post_excerpt_tiki', '[[regtime]]'),
('20100825_add_changed_column_to_tiki_language_table_tiki', '[[regtime]]'),
('20100825_remove_blog_option_use_title_tiki', '[[regtime]]'),
('20100830_sheet_add_styles_and_classes_tiki', '[[regtime]]'),
('20100831_freetag_tiki', '[[regtime]]'),
('20100901_duplic_actionlog_tiki', '[[regtime]]'),
('20100901_expire_tiki', '[[regtime]]'),
('20100902_invit_tiki', '[[regtime]]'),
('20100903_article_ispublished_tiki', '[[regtime]]'),
('20100906_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100909_alter_tiki_language_fields_to_text_tiki', '[[regtime]]'),
('20100909_ckeditor_upgrade_tiki', '[[regtime]]'),
('20100909_lengthen_wiki_attachments_filename_tiki', '[[regtime]]'),
('20100910_new_fields_for_tiki_blogs_tiki', '[[regtime]]'),
('20100912_rename_autosave_pref_tiki', '[[regtime]]'),
('20100915_add_edit_languages_menu_option_tiki', '[[regtime]]'),
('20100919_tiki_page_contribution_tiki', '[[regtime]]'),
('20100920_ckeditor_remove_pref_tiki', '[[regtime]]'),
('20100920_jq_sheet_remove_pref_tiki', '[[regtime]]'),
('20100920_todo_event_tiki', '[[regtime]]'),
('20100923_fix_column_position_tiki', '[[regtime]]'),
('20100923_social_networking_permission_and_menuitem_tiki', '[[regtime]]'),
('20100925_fix_some_default_value_tiki', '[[regtime]]'),
('20100927_better_column_fix2_tiki', '[[regtime]]'),
('20100927_better_column_fix_tiki', '[[regtime]]'),
('20100928_sefurl_regex_reordering_tiki', '[[regtime]]'),
('20101008_user_id_for_tiki_language_tiki', '[[regtime]]'),
('20101014_tiki_language_add_lastModif_column_tiki', '[[regtime]]'),
('20101015_tiki_admin_perms_tiki', '[[regtime]]'),
('20101021_rename_blog_post_comment_object_type_tiki', '[[regtime]]'),
('20101025_fgal_show_deleteAfter_tiki', '[[regtime]]'),
('20101025_profile_sources_pref_tikiwiki_to_tiki', '[[regtime]]'),
('20101025_rename_create_blog_menu_entry_tiki', '[[regtime]]'),
('20101026_auth_token_add_columns_tiki', '[[regtime]]'),
('20101027_add_file_gallery_columns_tiki', '[[regtime]]'),
('20101027_rename_invit_to_invite_tiki', '[[regtime]]'),
('20101028_p_invit_tiki', '[[regtime]]'),
('20101110_actionlog_tiki', '[[regtime]]'),
('20101117_actionlog_tiki', '[[regtime]]'),
('20101119_categ_perm_tiki', '[[regtime]]'),
('20101126_fgal_add_gallerie_user_tiki', '[[regtime]]'),
('20101130_recreate_tiki_accounting_tables_tiki', '[[regtime]]'),
('20101130_tiki_accounting_tiki', '[[regtime]]'),
('20101201_tiki_accounting_fix_index_tiki', '[[regtime]]'),
('20101203_fgal_archive_default_tiki', '[[regtime]]'),
('20101207_feature_file_drafts_tiki', '[[regtime]]'),
('20101208_webservice_soap_tiki', '[[regtime]]'),
('20101210_fgal_add_wiki_attachments_tiki', '[[regtime]]'),
('20101210_sync_users_ldap_tiki', '[[regtime]]'),
('20101211_filegal_maxhits_column_tiki', '[[regtime]]'),
('20101211_kil_feature_phplayers_tiki', '[[regtime]]'),
('20101215_remove_files_tiki', '[[regtime]]'),
('20101215_template_file_galleries_tiki', '[[regtime]]'),
('20101219_kill_feature_mobile_tiki', '[[regtime]]'),
('20101230_create_top_modules_tiki', '[[regtime]]'),
('20110103_include_in_history_tiki', '[[regtime]]'),
('20110104_flagged_revision_log_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_again_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_tiki', '[[regtime]]'),
('20110112_approval_permissions_tiki', '[[regtime]]'),
('20110115_create_bottom_modules_tiki', '[[regtime]]'),
('20110118_p_remove_tracker_items_tiki', '[[regtime]]'),
('20110124_update_sheet_to_support_cloning_tiki', '[[regtime]]'),
('20110201_c_code_to_user_modules_tiki', '[[regtime]]'),
('20110209_p_list_users_tiki', '[[regtime]]'),
('20110220_p_tracker_view_attachments_tiki', '[[regtime]]'),
('20110223_queue_tiki', '[[regtime]]'),
('20110224_tiki_cart_inventory_hold_tiki', '[[regtime]]'),
('20110307_remove_calendar_reminder_tiki', '[[regtime]]'),
('20110308_rss_item_key_tiki', '[[regtime]]'),
('20110317_attributes_increase_length_tiki', '[[regtime]]'),
('20110411_banner_tiki', '[[regtime]]'),
('20110412_permissions_out_of_db_tiki', '[[regtime]]'),
('20110413_blog_post_priv_default_value_tiki', '[[regtime]]'),
('20110419_kill_old_search_tiki', '[[regtime]]'),
('20110420_newsletter_optional_group_inclusion_tiki', '[[regtime]]'),
('20110421_compact_search_in_topbar_tiki', '[[regtime]]'),
('20110507_remove_module_style_params_tiki', '[[regtime]]'),
('20110513_banner_tiki', '[[regtime]]'),
('20110519_quick_edit_categ_params_merge_tiki', '[[regtime]]'),
('20110603_convert_tracker_comments_tiki', '[[regtime]]'),
('20110606_convert_ip_fields_to_ipv6_tiki', '[[regtime]]'),
('20110609_batch_update_tracker_item_links_tiki', '[[regtime]]'),
('20110609_missing_sql_tiki', '[[regtime]]'),
('20110609_unique_login_tiki', '[[regtime]]'),
('20110610_readd_sefurl_index_left_tiki', '[[regtime]]'),
('20110610_revert_poll_additions_tiki', '[[regtime]]'),
('20110611_accounting_fix_primarykeys_tiki', '[[regtime]]'),
('20110613_filegal_source_display_tiki', '[[regtime]]'),
('20110614_provider_authentication_tiki', '[[regtime]]'),
('20110615_structure_alias_tiki', '[[regtime]]'),
('20110622_file_from_url_log_tiki', '[[regtime]]'),
('20110630_fix_blogs_copyright_frencho_tiki', '[[regtime]]'),
('20110717_invoice_menu_options_tiki', '[[regtime]]'),
('20110725_tracker_field_permname_tiki', '[[regtime]]'),
('20110727_tracker_multilingual_convert_tiki', '[[regtime]]'),
('20110803_objectpermissions_tiki', '[[regtime]]'),
('20110808_default_perm_name_tiki', '[[regtime]]'),
('20110808_tracker_tiki', '[[regtime]]'),
('20110815_creator_lost_7_tiki', '[[regtime]]'),
('20110819_group_max_length_tiki', '[[regtime]]'),
('20110823_tiki_connect_create_tiki', '[[regtime]]'),
('20110830_default_enable_in_use_tiki', '[[regtime]]'),
('20110830_tiki_connect_longer_guid_tiki', '[[regtime]]'),
('20110902_revert_rootCategId_addition_tiki', '[[regtime]]'),
('20110904_shoutbox_def_tweetid_tiki', '[[regtime]]'),
('20110905_extend_actionlog_comment_tiki', '[[regtime]]'),
('20110905_multibyte_lc_fix_tiki', '[[regtime]]'),
('20110908_author_submission_tiki', '[[regtime]]'),
('20110909_tiki_forums_add_language_tiki', '[[regtime]]'),
('20110911_add_missing_engine_specs_tiki', '[[regtime]]'),
('20110912_groupsexpiryanniversary_tiki', '[[regtime]]'),
('20110912_remove_unused_fields_tiki', '[[regtime]]'),
('20110923_referer_stats_tiki', '[[regtime]]'),
('20110926_tracker_menu_feature_reports_tiki', '[[regtime]]'),
('20111001_add_tiki_areas_tiki', '[[regtime]]'),
('20111006_drop_useless_key_tiki', '[[regtime]]'),
('20111010_revert_fix_user_bookmarks_folders_key_tiki', '[[regtime]]'),
('20111014_menu_feature_time_sheet_tiki', '[[regtime]]'),
('20111118_remove_versionOfPreferencesCache_tiki', '[[regtime]]'),
('20111210_add_blog_hits_tiki', '[[regtime]]'),
('20111217_on_value_tracker_tiki', '[[regtime]]'),
('20111231_change_datetime_defaults_to_null_tiki', '[[regtime]]'),
('20120115_remove_article_show_lang_tiki', '[[regtime]]'),
('20120118_remove_users_prefs_language_tiki', '[[regtime]]'),
('20120123_remove_column_from_tiki_user_reports_tiki', '[[regtime]]'),
('20120315_list_image_article_y_tiki', '[[regtime]]'),
('20120319_remove_sheets_with_no_relation_tiki', '[[regtime]]'),
('20120320_remove_admin_trackers_application_menu_tiki', '[[regtime]]'),
('20120323_add_reports_to_application_menu_tiki', '[[regtime]]'),
('20120323_remove_tracker_reports_from_application_menu_tiki', '[[regtime]]'),
('20120324_add_filegals_icon_tiki', '[[regtime]]'),
('20120401_kaltura_prefs_rename_tiki', '[[regtime]]'),
('20120408_add_forumthread_sefurl_tiki', '[[regtime]]'),
('20120421_autoincementtoautoincrement_tiki', '[[regtime]]'),
('20120422_mime_tiki', '[[regtime]]'),
('20120423_add_page_refs_tiki', '[[regtime]]'),
('20120423_add_status_attr_tiki', '[[regtime]]'),
('20120426_perspectives_menu_entry_tiki', '[[regtime]]'),
('20120426_tiki_db_status_tiki', '[[regtime]]'),
('20120429_fix_collation_tiki', '[[regtime]]'),
('20120510_mailqueue_tiki', '[[regtime]]'),
('20120604_add_holder_to_copyright_tiki', '[[regtime]]'),
('20120628_correct_admin_user_createdate_tiki', '[[regtime]]'),
('20120823_admin_user_credit_menu_entry_tiki', '[[regtime]]'),
('20120823_workspace_template_tiki', '[[regtime]]'),
('20120824_advanced_mode_flag_tiki', '[[regtime]]'),
('20120825_accounting_menu_entry_tiki', '[[regtime]]'),
('20120826_store_metadata_tiki', '[[regtime]]'),
('20120904_category_root_tiki', '[[regtime]]'),
('20120927_add_area_exclusive_and_common_tiki', '[[regtime]]'),
('20120927_add_menu_parse_tiki', '[[regtime]]'),
('20120930_tiki_p_view_poll_choices_tiki', '[[regtime]]'),
('20121009_module_search_box_to_search_tiki', '[[regtime]]'),
('20121016_actionlog_comment_text_tiki', '[[regtime]]'),
('20121027_tracker_samerow_fix_tiki', '[[regtime]]'),
('20121210_add_missing_index_user_assigned_modules_tiki', '[[regtime]]'),
('20121210_better_forum_reported_index_tiki', '[[regtime]]'),
('20121213_module_zone_enlarge_tiki', '[[regtime]]'),
('20130220_wiki_attachments_tiki', '[[regtime]]'),
('20130228_bigger_token_groups_tiki', '[[regtime]]'),
('20130301_sefurl_tracker_type_tiki', '[[regtime]]'),
('20130314_keep_search_pref_settings_tiki', '[[regtime]]'),
('20130322_app_menu_timesheet_pos_tiki', '[[regtime]]'),
('20130322_restore_lost_filegals_tiki', '[[regtime]]'),
('20130328_extend_actionlog_bbb_tiki', '[[regtime]]'),
('20130410_keep_wysiwyg_htmltowiki_setting_tiki', '[[regtime]]'),
('20130415_repair_file_galleries_again_tiki', '[[regtime]]'),
('20130417_score_alter_tiki', '[[regtime]]'),
('20130417_score_tiki', '[[regtime]]'),
('20130419_newsletters_clippings_tiki', '[[regtime]]'),
('20130513_convert_tracker_field_parameters_tiki', '[[regtime]]'),
('20130530_category_log_tiki', '[[regtime]]'),
('20130530_tracker_modification_log_tiki', '[[regtime]]'),
('20130605_mailin_show_inline_tiki', '[[regtime]]'),
('20130606_mailin_add_categoryId_tiki', '[[regtime]]'),
('20130608_convert_mailin_pwd_tiki', '[[regtime]]'),
('20130608_mailin_response_tiki', '[[regtime]]'),
('20130611_mailin_add_html_tiki', '[[regtime]]'),
('20130614_mailin_add_admin_tiki', '[[regtime]]'),
('20130616_mailin_add_namespace_tiki', '[[regtime]]'),
('20130623_create_mailin_user_struct_tiki', '[[regtime]]'),
('20130624_mailin_add_attr_tiki', '[[regtime]]'),
('20130704_catname_tiki', '[[regtime]]'),
('20130705_activity_stream_tiki', '[[regtime]]'),
('20130715_activity_stream_rules_tiki', '[[regtime]]'),
('20130730_friendship_conversion_tiki', '[[regtime]]'),
('20130730_wiki_para_format_default_change_tiki', '[[regtime]]'),
('20130807_tracker_files_display_param_change_tiki', '[[regtime]]'),
('20130809_limit_name_lengths_in_objects_tiki', '[[regtime]]'),
('20131007_menus_items_missing_icons_tiki', '[[regtime]]'),
('20131108_mytiki_add_mailin_tiki', '[[regtime]]'),
('20131117_unified_engine_default_change_tiki', '[[regtime]]'),
('20131218_stored_queries_tiki', '[[regtime]]'),
('20131231_add_sheet_metadata_tiki', '[[regtime]]'),
('20140109_query_unique_name_tiki', '[[regtime]]'),
('20140117_monitor_tiki', '[[regtime]]'),
('20140129_bigger_target_monitor_tiki', '[[regtime]]'),
('20140203_menu_item_and_icon_user_wizard_tiki', '[[regtime]]'),
('20140206_add_parser_column_tiki', '[[regtime]]'),
('20140210_user_wizard_add_section_name_tiki', '[[regtime]]'),
('20140214_goals_tiki', '[[regtime]]'),
('20140219_full_goal_events_tiki', '[[regtime]]'),
('20140301_add_column_rating_choice_topic_on_forums_tiki', '[[regtime]]'),
('20140318_user_wizard_add_groupname_tiki', '[[regtime]]'),
('20140402_mailin_protocol_option_tiki', '[[regtime]]'),
('20140402_payment_authorization_tiki', '[[regtime]]'),
('20140402_remove_mailin_smtp_tiki', '[[regtime]]'),
('20140509_rss_add_categories_tiki', '[[regtime]]'),
('20140625_survey_tiki', '[[regtime]]'),
('20140705_page_slug_tiki', '[[regtime]]'),
('20140807_federated_search_tiki', '[[regtime]]'),
('20140812_convert_tiki_connect_data_to_json_tiki', '[[regtime]]'),
('20140914_addon_profiles_tiki', '[[regtime]]'),
('20141003_change_style_pref_to_theme_tiki', '[[regtime]]'),
('20141106_menu_configuration_panel_tiki', '[[regtime]]'),
('20141114_remove_babelfish_tiki', '[[regtime]]'),
('20141120_tracker_tabular_tiki', '[[regtime]]'),
('20141122_change_prefname_availblestyles_to_availablethemes_tiki', '[[regtime]]'),
('20141125_menu_control_panels_tiki', '[[regtime]]'),
('20150109_tabular_filters_tiki', '[[regtime]]'),
('20150112_theme_option_etc_tiki', '[[regtime]]'),
('20150203_add_menu_option_class_tiki', '[[regtime]]'),
('20150310_rename_freetags_in_menu_42_tiki', '[[regtime]]'),
('20150310_rename_mytiki_in_menu_42_tiki', '[[regtime]]'),
('20150327_tracker_showPopup_option_fix_tiki', '[[regtime]]'),
('20150414_profile_symbol_tooshort_fix_tiki', '[[regtime]]'),
('20150426_menu_item_external_wikis_restored_tiki', '[[regtime]]'),
('20150508_perspectives_style_to_theme_tiki', '[[regtime]]'),
('20150730_menu_item_tabular_trackers_tiki', '[[regtime]]'),
('20150901_prefname_char_length_tiki', '[[regtime]]'),
('20150929_make_hotwords_longer_tiki', '[[regtime]]'),
('20151203_tiki_score_revamp_tiki', '[[regtime]]'),
('20151203_tokens_create_user_tiki', '[[regtime]]'),
('20160120_remove_gmap_menu_item_tiki', '[[regtime]]'),
('20160201_remove_maps_menus_tiki', '[[regtime]]'),
('20160206_theme_option_modules_tiki', '[[regtime]]'),
('20160315_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160325_menu_42_list_pages_tiki', '[[regtime]]'),
('20160420_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160519_calendar_events_action_log_tiki', '[[regtime]]'),
('20160527_menu_item_payment_tiki', '[[regtime]]'),
('20160604_remove_unwanted_files_tiki', '[[regtime]]'),
('20160608_menu_item_admin_tokens_tiki', '[[regtime]]'),
('20160612_new_password_implementation_tiki', '[[regtime]]'),
('20160612_remove_feature_challenge_pref_tiki', '[[regtime]]'),
('20160614_clear_password_removal_tiki', '[[regtime]]'),
('20160627_remove_more_unwanted_files_tiki', '[[regtime]]'),
('20160817_fix_dymanic_list_field_values_tiki', '[[regtime]]'),
('20160914_extwiki_missing_columns_fix_tiki', '[[regtime]]'),
('20160915_extwiki_indexname_length_tiki', '[[regtime]]'),
('20161109_remove_old_password_tiki', '[[regtime]]'),
('20161117_favicon_tiki', '[[regtime]]'),
('20161206_larger_comment_field_tiki', '[[regtime]]'),
('20161220_add_h5p_tables_tiki', '[[regtime]]'),
('20170122_schedulers_tiki', '[[regtime]]'),
('20170127_remove_templates_c_tiki', '[[regtime]]'),
('20170129_feature_dump_tiki', '[[regtime]]'),
('20170207_iefix_rem_tiki', '[[regtime]]'),
('20170213_footnotearea_tiki', '[[regtime]]'),
('20170218_schedulers_menu_tiki', '[[regtime]]'),
('20170305_webservices_menu_tiki', '[[regtime]]'),
('20170307_kill_wikilingo_tiki', '[[regtime]]'),
('20170319_kill_jcapture_tiki', '[[regtime]]'),
('20170322_fix_allocate_memory_prefs_tiki', '[[regtime]]'),
('20170329_add_color_to_groups_tiki', '[[regtime]]'),
('20170329_larger_category_descriptions_tiki', '[[regtime]]'),
('20170330_merge_hiddenlinks_into_headinglinks_tiki', '[[regtime]]'),
('20170427_update_accounting_journal_cols_tiki', '[[regtime]]'),
('20170531_feature_usability_tiki', '[[regtime]]'),
('20170628_schedulers_menu_tiki', '[[regtime]]'),
('20170702_wiki_url_scheme_pref_default_tiki', '[[regtime]]'),
('20170717_add_missing_trackeritem_attachment_backlinks_tiki', '[[regtime]]'),
('20170726_remove_article_hashes_tiki', '[[regtime]]'),
('20170726_tabular_config_tiki', '[[regtime]]'),
('20170829_custom_routes_tiki', '[[regtime]]'),
('20170920_admin_webservices_menu_option_tiki', '[[regtime]]'),
('20170925_add_general_to_language_tiki', '[[regtime]]'),
('20170930_custom_routes_menu_tiki', '[[regtime]]'),
('20171002_queue_handler_size_increase_tiki', '[[regtime]]'),
('20171010_action_log_info_new_column_tiki', '[[regtime]]'),
('20171016_no_homepage_specificed_tiki', '[[regtime]]'),
('20171121_create_plugin_include_relations_tiki', '[[regtime]]'),
('20171122_h5p_update_add_hub_table_tiki', '[[regtime]]'),
('20171123_create_object_links_tiki', '[[regtime]]'),
('20171129_backlinks_for_object_types_admin_options_tiki', '[[regtime]]'),
('20171130_plugin_include_link_original_tiki', '[[regtime]]'),
('20171204_update_geo_enabled_tiki', '[[regtime]]'),
('20171231_add_short_url_tiki', '[[regtime]]'),
('20180228_comment_on_object_attributes_tiki', '[[regtime]]'),
('20180331_rename_custom_route_object_type_tiki', '[[regtime]]'),
('20180405_custom_routes_menu_tiki', '[[regtime]]'),
('20180405_remove_unused_user_id_tiki', '[[regtime]]'),
('20180410_install_piwik_plugin_tiki', '[[regtime]]'),
('20180411_schedulers_change_column_to_text_tiki', '[[regtime]]'),
('20180412_rename_short_url_prefs_tiki', '[[regtime]]'),
('20180419_scheduler_run_stalled_column_tiki', '[[regtime]]'),
('20180421_scheduler_run_healed_column_tiki', '[[regtime]]'),
('20180503_fix_throttled_newsletters_tiki', '[[regtime]]'),
('20180609_change_log_column_type_tiki', '[[regtime]]'),
('20180625_user_reports_null_last_reports_tiki', '[[regtime]]'),
('20180705_fix_calendaritem_tracker_attributes_tiki', '[[regtime]]'),
('20180706_remove_menu_reports_tiki', '[[regtime]]'),
('20180803_semaphore_value_tiki', '[[regtime]]'),
('20180808_ocr_tiki', '[[regtime]]'),
('20180815_merge_topic_read_perm_tiki', '[[regtime]]'),
('20180909_remove_page_content_fetch_readability_tiki', '[[regtime]]'),
('20180918_remove_poweredby_module_tiki', '[[regtime]]'),
('20180921_php_upgrade_fix_from_older_tiki', '[[regtime]]'),
('20180921_sql_upgrade_fix_from_older_tiki', '[[regtime]]'),
('20180923_convert_collation_to_utf8mb4_tiki', '[[regtime]]'),
('20180925_feature_jquery_superfish_pref_default_tiki', '[[regtime]]'),
('20181114_ocr_uff8mb4_tiki', '[[regtime]]'),
('20181127_convert_db_local_to_utf8mb4_tiki', '[[regtime]]'),
('20181130_update_column_name_size_tracker_table_tiki', '[[regtime]]'),
('20190117_create_oauthserver_clients_table_tiki', '[[regtime]]'),
('20190121_h5p_add_new_library_fields_tiki', '[[regtime]]'),
('20190121_h5p_allow_null_in_filtered_tiki', '[[regtime]]'),
('20190123_h5p_move_storage_assets_to_new_dir_tiki', '[[regtime]]'),
('20190129_fix_ambiguity_on_oauthserver_id_column_tiki', '[[regtime]]'),
('20190226_change_xmpp_auth_pref_name_tiki', '[[regtime]]'),
('20190303_make_tiki_object_href_larger_tiki', '[[regtime]]'),
('20190401_add_support_database_strict_mode_tiki', '[[regtime]]'),
('20190425_add_creation_date_schedule_tiki', '[[regtime]]'),
('20190425_set_creation_date_to_scheduler_tiki', '[[regtime]]'),
('20190523_migrate_webmail_accounts_tiki', '[[regtime]]'),
('20190526_remove_tiki_addon_profiles_tiki', '[[regtime]]'),
('20190620_add_role_groups_tiki', '[[regtime]]'),
('20190627_add_ocr_fgal_status_tiki', '[[regtime]]'),
('20190717_add_role_categ_available_tiki', '[[regtime]]'),
('20190722_ocr_fgal_tiki', '[[regtime]]'),
('20190723_add_is_tlp_group_tiki', '[[regtime]]'),
('20190729_add_tlp_group_category_tiki', '[[regtime]]'),
('20190831_add_two_factor_secret_tiki', '[[regtime]]'),
('20190913_caldav_tiki', '[[regtime]]'),
('20190925_caldav_updates_tiki', '[[regtime]]'),
('20191114_caldav_recurring_updates_tiki', '[[regtime]]'),
('20191116_scheduler_run_only_once_tiki', '[[regtime]]'),
('20191126_add_forum_parent_tiki', '[[regtime]]'),
('20191218_carddav_tiki', '[[regtime]]'),
('20200113_tracker_field_rules_column_tiki', '[[regtime]]'),
('20200123_calendar_rsvp_tiki', '[[regtime]]'),
('20200126_remove_invoice_menu_options_tiki', '[[regtime]]'),
('20200309_fix_sefurl_regex_out_issues_tiki', '[[regtime]]'),
('20200513_expand_sessions_data_column_tiki', '[[regtime]]'),
('20200614_expand_mail_queue_message_column_tiki', '[[regtime]]'),
('20200710_feature_templated_groups_tiki', '[[regtime]]'),
('20201024_h5p_add_a11y_title_tiki', '[[regtime]]'),
('20201024_h5p_add_default_lang_tiki', '[[regtime]]'),
('20201212_remove_comment_hash_tiki', '[[regtime]]'),
('20210410_alter_activity_stream_arguments_column_tiki', '[[regtime]]'),
('20230125_add_goalid_to_credits_tiki', '[[regtime]]'),
('20230504_add_attemps_on_tiki_banning_tiki', '[[regtime]]'),
('999999991_decode_pages_sources_tiki', '[[regtime]]'),
('99999999_image_plugins_kill_tiki', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_score`
--

CREATE TABLE `tiki_score` (
  `event` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  `reversalEvent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_score`
--

INSERT INTO `tiki_score` VALUES
('tiki.user.login', '[\n	{"ruleId":"User logs in","recipientType":"user","recipient":"user","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.view', '[\n	{"ruleId":"See other user''s profile","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your profile seen","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.friend', '[\n	{"ruleId":"Make friends","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.message', '[\n	{"ruleId":"Send message","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Receive message","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.create', '[\n	{"ruleId":"Publish new article","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.view', '[\n	{"ruleId":"Read an article","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your article read","recipientType":"user","recipient":"author","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.filegallery.create', '[\n	{"ruleId":"Create new file gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.create', '[\n	{"ruleId":"Upload new file to gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.download', '[\n	{"ruleId":"Download other user''s file","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your file downloaded","recipientType":"user","recipient":"owner","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.imagegallery.create', '[\n	{"ruleId":"Create new image gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.image.create', '[\n	{"ruleId":"Upload new image to gallery","recipientType":"user","recipient":"user","score":"6","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.image.view', '[\n	{"ruleId":"See other user''s image","recipientType":"user","recipient":"user","score":"3","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your image seen","recipientType":"user","recipient":"owner","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.create', '[\n	{"ruleId":"Create new blog","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blogpost.create', '[\n	{"ruleId":"Post in a blog","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.view', '[\n	{"ruleId":"Read other user''s blog","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n	{"ruleId":"Have your blog read","recipientType":"user","recipient":"author","score":"3","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.create', '[\n	{"ruleId":"Create a wiki page","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.update', '[\n	{"ruleId":"Edit an existing wiki page","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.attachfile', '[\n	{"ruleId":"Attach file to wiki page","recipientType":"user","recipient":"user","score":"3","validObjectIds":[""],"expiration":""}\n]', '');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_queries`
--

CREATE TABLE `tiki_search_queries` (
  `queryId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `lastModif` int(11) DEFAULT NULL,
  `label` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` blob,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`queryId`),
  UNIQUE KEY `tiki_user_query_uq` (`userId`,`label`),
  KEY `query_userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_stats`
--

CREATE TABLE `tiki_search_stats` (
  `term` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) DEFAULT NULL,
  PRIMARY KEY (`term`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_secdb`
--

CREATE TABLE `tiki_secdb` (
  `md5_value` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tiki_version` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `severity` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filename`(171),`tiki_version`(20)),
  KEY `sdb_fn` (`filename`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_secdb`
--

INSERT INTO `tiki_secdb` VALUES
('d408317a35f74ef8e9c33a36eaf2a39c', './about.php', '21.12', 0),
('07e78496c4bac204f38d390c55b4cddd', './admin/include_articles.php', '21.12', 0),
('b032999dba0a61414c98a21524b004a2', './admin/include_category.php', '21.12', 0),
('cdf6689d89ee29c93e3131a629992d70', './admin/include_connect.php', '21.12', 0),
('5308a99b880ed7cb7861590198e7ba88', './admin/include_features.php', '21.12', 0),
('7d19b133a70664e5f7d35271301fc942', './admin/include_fgal.php', '21.12', 0),
('0770352bc74ef13913d48bbcfe6f8b88', './admin/include_freetags.php', '21.12', 0),
('ca142f4add8a51271223d4ff77edbf05', './admin/include_gal.php', '21.12', 0),
('c3287891f90b1a49a20016b197f4b51c', './admin/include_general.php', '21.12', 0),
('f45d8e0292a9366d6892b88e7a89b578', './admin/include_i18n.php', '21.12', 0),
('2e92579bf8218d67f2fc9d168d43b12c', './admin/include_intertiki.php', '21.12', 0),
('14df1f8ec33946dfa4af64f59800592e', './admin/include_login.php', '21.12', 0),
('5e47b0f70a186f793b3b369fd53d2fe8', './admin/include_look.php', '21.12', 0),
('2f13810128bd51a0c90cedd04559ed26', './admin/include_packages.php', '21.12', 0),
('aecc66f877a82a9d8cc84688df25ab1c', './admin/include_performance.php', '21.12', 0),
('879acf40cbab77a169094637b7e2471e', './admin/include_profiles.php', '21.12', 0),
('579cde5ec1fa205ede10c9bc4591b524', './admin/include_rating.php', '21.12', 0),
('1309835f4d36dcc8822516a482abb5a2', './admin/include_score.php', '21.12', 0),
('525226c6c58c35ea34c5b8834758bb30', './admin/include_search.php', '21.12', 0),
('4cb575af9cad9d0be77285b8a02aec0b', './admin/include_security.php', '21.12', 0),
('9de66d5fccf5fd71ade47950bdf93908', './admin/include_sefurl.php', '21.12', 0),
('18d99ff06794f76b9ff43ff31e12be1a', './admin/include_semantic.php', '21.12', 0),
('96a12c16d68c12dedd2208fca52415dd', './admin/include_socialnetworks.php', '21.12', 0),
('7b62f18edc7eb66ceda66a440fbf7c27', './admin/include_textarea.php', '21.12', 0),
('eec4568329bcbde7767f4cbf3ee0caff', './admin/include_trackers.php', '21.12', 0),
('200e6f211d07672a80341c050f460c99', './admin/include_user.php', '21.12', 0),
('76ee87d943faeb580d3826a465065aa5', './admin/include_video.php', '21.12', 0),
('e800273dee24d4c64fe7f432eb8da7dd', './admin/include_wiki.php', '21.12', 0),
('83dfb465438b81671f97ad7e2a2fbd5a', './admin/include_wikiatt.php', '21.12', 0),
('cafc998b72c427c9a612d9adeccfc3fb', './admin/include_workspace.php', '21.12', 0),
('582e12494e636695a6f9f21b45c0faaa', './admin/index.php', '21.12', 0),
('a8d8cfcf22119550dfbb659312ed4e30', './antibot.php', '21.12', 0),
('17710ae8770b821a77669caaf772ff62', './article_image.php', '21.12', 0),
('36a71fb74e867b17054537f6e1b61875', './banner_click.php', '21.12', 0),
('cdcf322faa54026ceb9144e0d004454e', './banner_image.php', '21.12', 0),
('fca53279b082c6bd2a32d59790be11fd', './categorize.php', '21.12', 0),
('c6aacd06f3b38d3c19e03e0515f578eb', './categorize_list.php', '21.12', 0),
('b9c0cc142a2e0a6be2d127e1f585aebe', './check_composer_exists.php', '21.12', 0),
('b9e4eae2b1c05cd59669436575ebb924', './comments.php', '21.12', 0),
('4c30e1cee6da22f0e092ba2924d454e1', './commxmlrpc.php', '21.12', 0),
('363abd17fe52607519e404b6b07bc2da', './console.php', '21.12', 0),
('519723269acf56e5038241384dd8ac5c', './contribution.php', '21.12', 0),
('751928a2c55e7762a12fc51a1f1c842d', './copyrights.php', '21.12', 0),
('23ac525b79dff1e269620cbbbe6ef7b4', './cron.php', '21.12', 0),
('570e6fbcf512b2b59efa9362c0395fa8', './db/cert/index.php', '21.12', 0),
('570e6fbcf512b2b59efa9362c0395fa8', './db/config/index.php', '21.12', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './db/index.php', '21.12', 0),
('13f3908703547b5d7ca9a751b1261ad9', './db/preconfiguration.php', '21.12', 0),
('fa4be30ac4a22d4943b83ffbe578db4c', './db/tiki-db.php', '21.12', 0),
('d41d8cd98f00b204e9800998ecf8427e', './db/tiki-secdb_21.12_mysql.sql', '21.12', 0),
('87b59e7894554da767d82dce2c5dcb54', './db/tiki.sql', '21.12', 0),
('54a1260e3ed53e7488ced3cfe5c8a14c', './db/tiki_1.8to1.9.sql', '21.12', 0),
('3bb3714e7fa7dbc823b93c446ed2c5e1', './db/tiki_1.9to2.0.sql', '21.12', 0),
('e254781c554fe280e7afaeedcafc2617', './db/tiki_2.0to3.0.sql', '21.12', 0),
('e00162025dbf4a1c44e7b8998bef02cd', './db/tiki_convert_myisam_to_innodb.sql', '21.12', 0),
('1b5d1eaebc0905c2bae45493275c03f6', './db/tiki_fulltext_indexes.sql', '21.12', 0),
('7f6698c8c0e0db0e556b02439a13dbdd', './db/tiki_innodb.sql', '21.12', 0),
('9425e37fc31a591c10cf3dea5717bb43', './db/tiki_myisam.sql', '21.12', 0),
('88f320ed1442246029c8a0cf659549f8', './display_banner.php', '21.12', 0),
('1925c89e873f73dc168165dfca0b863a', './doc/devtools/20160715_trim50_tracker_permanent_names_for_mysqlfts_tiki.sql', '21.12', 0),
('36691eebb20fe376f444e9192cfa8836', './doc/devtools/backup.php', '21.12', 0),
('b71d9972fa406d12761217e0ace41334', './doc/devtools/buildincrement.php', '21.12', 0),
('7a4a3fed3ab4319691bbc074377ca1f4', './doc/devtools/check_filegal_dir.php', '21.12', 0),
('81c6d6c43e64c4f192bdb3419a7a0b46', './doc/devtools/check_schema_naming_convention.php', '21.12', 0),
('46a3ec55e56577d2180d5c71c2e00511', './doc/devtools/check_schema_sql_drop.php', '21.12', 0),
('08ed67728030cde8d7e6992166eb48ea', './doc/devtools/check_schema_upgrade.php', '21.12', 0),
('b9e89dcd49520af8a5b98e9fc17cdc2d', './doc/devtools/check_sql_engine.php', '21.12', 0),
('79a587a42b46cda094895a7c1d1e9e4a', './doc/devtools/check_sql_engine_conversion.php', '21.12', 0),
('dd5f6d2d91144ce1e7a859d3e2d69da6', './doc/devtools/check_template_translation_standards.php', '21.12', 0),
('d761009ec3481ad44d8f74e22a6d2332', './doc/devtools/check_tiki-new.php', '21.12', 0),
('6796e3f48e650b60e38ca2a2174646d0', './doc/devtools/check_tiki.php', '21.12', 0),
('264b95dc0b6ac817fda1e2fe797d7731', './doc/devtools/clear_tracker_fast.sql', '21.12', 0),
('001e696af253b6f194cee14d9883d998', './doc/devtools/commit_translations_by_lang.php', '21.12', 0),
('2ddfe4efce2b29fbb7630c6047c9d84b', './doc/devtools/composer_http_mode.php', '21.12', 0),
('b9be63004b97033f0743d0800a4c977e', './doc/devtools/convert_templates_prefs-2.0.php', '21.12', 0),
('baae925d0b155ae006ac2d4196b35584', './doc/devtools/convert_tpl_ajax.php', '21.12', 0),
('bfe924e4def320a65db386e4c8239683', './doc/devtools/convert_tracker_attachments.php', '21.12', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './doc/devtools/experimental/index.php', '21.12', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './doc/devtools/experimental/unzip/index.php', '21.12', 0),
('f6a4b25bbf36a6f88f908c27089d32fa', './doc/devtools/experimental/unzip/unzipper.php', '21.12', 0),
('59b60a393b909c24812816f407841a4b', './doc/devtools/export_all_translation_to_file.php', '21.12', 0),
('dc5598e46295c24f05758e4fe9811552', './doc/devtools/export_translations_to_file.php', '21.12', 0),
('4ad349155118c6d13e73979d47d25b52', './doc/devtools/extract-img-db-to-fs.php', '21.12', 0),
('cbf6111f0530dfae2594f2d7acabe157', './doc/devtools/fgal_revamp_archive_fix.php', '21.12', 0),
('895d3eeb3e6612b5e2a1d7cff3d41731', './doc/devtools/fix-encoding.php', '21.12', 0),
('8868bd8ac5ca52468edda58ff0e96322', './doc/devtools/fixsvnkeyids.php', '21.12', 0),
('a130ff334a55a9ec1cfa02ba2d5f0b21', './doc/devtools/get_translation_percentage.php', '21.12', 0),
('273479d877a29c9949f47777f8e14449', './doc/devtools/ggg-trace.php', '21.12', 0),
('c61704230d077fe200a5a747d87878ef', './doc/devtools/gittools.php', '21.12', 0),
('29d9eab0cced72126f4b5166110c8b52', './doc/devtools/h5p_reset_all_data.sql', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './doc/devtools/index.php', '21.12', 0),
('076cf57e26f71cb7ec2a09014ebc698a', './doc/devtools/invert_relations.php', '21.12', 0),
('8528287fb9735bce0ab2eb1da2ce338f', './doc/devtools/ks_prefreport.php', '21.12', 0),
('c8ab811d380bfea8db68f9b60c57e4ec', './doc/devtools/make_db_local.sql', '21.12', 0),
('c3a2649e667367ab38d8f5e5d737f80a', './doc/devtools/mergelang.php', '21.12', 0),
('c1f638fe057d5e3d05b6a60bbd4421eb', './doc/devtools/migrate_image_galleries.php', '21.12', 0),
('560f9316514735b824cbd09ed3efcba8', './doc/devtools/parse_tiki.php', '21.12', 0),
('5ca532cf82c46c2b9625a35437f119f5', './doc/devtools/prefreport.php', '21.12', 0),
('c0fbee6782a55cd7969aeb61074297bf', './doc/devtools/rebuild_search_index.php', '21.12', 0),
('168ea93dc4d8196feb6f7924f14f3e7f', './doc/devtools/remove_empty_wiki_attachment_filegals.php', '21.12', 0),
('ddc29eaa01dc0ccff460c20d74bcd840', './doc/devtools/rescue_wiki_changes_from_elastic.php', '21.12', 0),
('60ed3fca47784c468da1ef050f5509bb', './doc/devtools/restorehelp.php', '21.12', 0),
('7c96113ecd36ff40ebe0056c2c7fc8fa', './doc/devtools/rewritesecdb.php', '21.12', 0),
('56cad452c16c935a76be001cefad1e53', './doc/devtools/search_smarty_prefs-2.0.php', '21.12', 0),
('c88e08f3450a216dd34d23adc2f0ccfb', './doc/devtools/securitycheck.php', '21.12', 0),
('02455ce84eb18a0adbe451e95a00f18b', './doc/devtools/stripcomments.php', '21.12', 0),
('e5a4e2df3801f8a793b4caafd24b68d0', './doc/devtools/svnbranch.php', '21.12', 0),
('b4bcb4ecaf29eb23200febf0ae4c0fa1', './doc/devtools/svnbranchreview.php', '21.12', 0),
('52ab9fbee1c91b538d1162c11bcd365f', './doc/devtools/svnbranchupdate.php', '21.12', 0),
('040f9324b8bc17256430cb57f2debccb', './doc/devtools/svnmerge.php', '21.12', 0),
('32fa347fe86fb9b4e762fc664fd5d686', './doc/devtools/svnswitch.php', '21.12', 0),
('527595a0de53ecd09d1b2b4c620f24f8', './doc/devtools/svntools.php', '21.12', 0),
('a5df6688bd7cba8ea881de08a211d77a', './doc/devtools/svnup.php', '21.12', 0),
('cbc62c2f86148dcfe5f0446dab19c19e', './doc/devtools/sync.php', '21.12', 0),
('65920d12abdc621f67fd78894d63a2a9', './doc/devtools/tiki-create_md5.php', '21.12', 0),
('2d4e282772d8fafa0b9e090b1baad856', './doc/devtools/tiki-show_raw_links.php', '21.12', 0),
('0e0adb5e4b85bd3c36a9b7d7affab67a', './doc/devtools/tiki-sync_ldap.php', '21.12', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './doc/devtools/tim/index.php', '21.12', 0),
('b39c28ec21d47306dca34bc82510d9f9', './doc/devtools/translate.php', '21.12', 0),
('8f9895e094de343fa3661ee8dcccaf8a', './doc/devtools/update_composer_lock.php', '21.12', 0),
('993fc0e98055633dc75b20effae4ac8b', './doc/devtools/update_english_strings.php', '21.12', 0),
('9899ed683f4162471c7e34d24f3c0788', './doc/devtools/update_vendor_bundled.php', '21.12', 0),
('c95b1d56a06cafba4f73eb3f6daf0034', './doc/devtools/upto_18_drop_unused_tables.sql', '21.12', 0),
('214a3022a15d52cb769682000b45ae55', './doc/devtools/upto_4.1_delete_all_cetgory_perms.sql', '21.12', 0),
('d20bb5a10ce694a47c9ddc3a595615e7', './doc/devtools/upto_4.1_drop_unused_4.0_tables.sql', '21.12', 0),
('58572000763181f94d8101a459c40a14', './doc/devtools/upto_7_drop_unused_6.x_tables.sql', '21.12', 0),
('f17fe96b63203403cacdca6771152408', './doc/devtools/vcscommons.php', '21.12', 0),
('07bc7d7b59ffba4a5b036b33b2eb5952', './doc/index.php', '21.12', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './doc/reports/index.php', '21.12', 0),
('f13b414a6bde1cd9bfa43dca83c1afcd', './dump/index.php', '21.12', 0),
('c24a68c2e588c137cca52688425109f8', './fgal_listing_conf.php', '21.12', 0),
('be12a1b036eea46b1d8334da7b98ceff', './freetag_apply.php', '21.12', 0),
('fe5917e3e639032c6081f7d01fde0512', './freetag_list.php', '21.12', 0),
('6c5a1ed381e0d9d30c4bc3657c54bed9', './get_strings.php', '21.12', 0),
('0efee4d1f69fa62b41281c4b19d27a95', './group_tracker_ajax.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/avatars/index.php', '21.12', 0),
('f53a35f98b5081376849d63a2c7aa5ad', './img/flags/flagnames.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/flags/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/icons/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/large/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/mime/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/mime/large/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/sprite/index.php', '21.12', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './img/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/profiles/index.php', '21.12', 0),
('24cd66e06eabffa9f23bb6105b670131', './img/rating_smiles/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/smiles/index.php', '21.12', 0),
('24cd66e06eabffa9f23bb6105b670131', './img/superfish/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/tiki/index.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './img/tikihelp/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/trackers/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/webmail/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/wiki/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/wiki_up/index.php', '21.12', 0),
('11c3bb4aa5a01af96b469d2fc11c8d24', './index.php', '21.12', 0),
('ed54aa7d5c2b23fc95e9944a5d64064a', './installer/Patch.php', '21.12', 0),
('7863f70e51416f6d7cd44db1b47997c2', './installer/ProgressBar.php', '21.12', 0),
('50c736bd8e85e2170990c334ed284f28', './installer/index.php', '21.12', 0),
('026633a36f193bb9e00263143aabbff7', './installer/installlib.php', '21.12', 0),
('2bb856c10f0c98e0a6e8bc5be5bf7e6b', './installer/schema/00000000_schema_change_tiki.sql', '21.12', 0),
('006c768f38fb584f81a9577977988c40', './installer/schema/20080227_invite_tiki.sql', '21.12', 0),
('8bd46c63fe3a91b1c6e6d063df32d7e3', './installer/schema/20080809_semlinks_tiki.sql', '21.12', 0),
('b7bc39833ff6498a7f2810f6ba477c7c', './installer/schema/20080827_bigfeaturetype_tiki.sql', '21.12', 0),
('2398106f99b68b3767b9719765489233', './installer/schema/20080829_pagealiasdata_tiki.sql', '21.12', 0),
('c4f4acac0dc6cbc2ebfb2f9c0be7e529', './installer/schema/20080829_pluginvalidation_tiki.sql', '21.12', 0),
('b3e9d8bf2668aefc4771dab17d0a24a2', './installer/schema/20080901_pluginvalidation_tiki.sql', '21.12', 0),
('ff79e407ffb5b00ff4d1e89a73c9704a', './installer/schema/20080902_trackerparsedesc_tiki.sql', '21.12', 0),
('7f8b965f930f78a8bddcef926ae47037', './installer/schema/20080905_feature_tip_tiki.sql', '21.12', 0),
('726d6b47131605927cf1927df0000924', './installer/schema/20080916_webservice_registry_tiki.sql', '21.12', 0),
('32603465e3345c4fb4135313fd639fed', './installer/schema/20080922_calendar_customstatus_tiki.sql', '21.12', 0),
('b5ab53b9f57092bca8ea8592fa037f7b', './installer/schema/20080924_webmail_tiki.sql', '21.12', 0),
('a692f6c42ad0de8abb9d754288dec8d2', './installer/schema/20080926_bannerindex_tiki.sql', '21.12', 0),
('bc29e3e80740fc29e33d27defbcbc97f', './installer/schema/20081004_mindmap_menu_tiki.sql', '21.12', 0),
('536631185aad52c71ef92899b5c5b62f', './installer/schema/20081006_comments_moderation_tiki.sql', '21.12', 0),
('97837099f4b69a93e84f567d3c56d257', './installer/schema/20081008_bit_flags_nullable_tiki.sql', '21.12', 0),
('49ed8d384cebe8c438a3f339c1956521', './installer/schema/20081010_filter_perms_tiki.sql', '21.12', 0),
('2e63a1b5e05aab6502e083ce82c0dc79', './installer/schema/20081014_trust_input_perm_tiki.sql', '21.12', 0),
('a360c4d3bf674a0701ab7f4280f5c3a8', './installer/schema/20081018_filter_perms_tiki.sql', '21.12', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20081019_score_tiki.sql', '21.12', 0),
('9936db192fac5ee273acfe31dec15cf9', './installer/schema/20081022_application_menu_tiki.sql', '21.12', 0),
('9a97cd6ca26d30c0b9d05c4aa537084d', './installer/schema/20081024_fulltext_file_tiki.sql', '21.12', 0),
('8d701d07641ef5d3f7b69d7e6d5a33a9', './installer/schema/20081027_calendar_tiki.sql', '21.12', 0),
('3d53e3b67422f25ff924fbe763538155', './installer/schema/20081027_file_galleries_tiki.sql', '21.12', 0),
('5de4fad5520791e15af18990a46cc9e0', './installer/schema/20081027_groupalert_tiki.sql', '21.12', 0),
('58df86055cb0233d2b7d32defd83828b', './installer/schema/20081027_surveys_tiki.sql', '21.12', 0),
('9ec9d1e68f44edbf587713bcd1e456c7', './installer/schema/20081027_trackers_tiki.sql', '21.12', 0),
('b716c67361eacf1a987e1bb40f6316ee', './installer/schema/20081027_wysiwyg_history_tiki.sql', '21.12', 0),
('dca26112be92a3177d122e04f6fa959a', './installer/schema/20081029_tracker_index_tiki.sql', '21.12', 0),
('00c60bf6063b7c4d89e0c9ead79abf75', './installer/schema/20081102_application_menu_structures_tiki.sql', '21.12', 0),
('1ef6d37f65c50ed067481f95baf4fd09', './installer/schema/20081105_calendar_items_allday_tiki.sql', '21.12', 0),
('27788e1efb7a90034e8950fd8f4354bd', './installer/schema/20081107_menu42_tiki.sql', '21.12', 0),
('d4c56d850365c4b6acf6ad25b90d4c73', './installer/schema/20081112_tiki_p_tracker_view_comments_tiki.sql', '21.12', 0),
('43d6558ec8576961ad0fa57eea6ec549', './installer/schema/20081114_tiki_banner_tiki.sql', '21.12', 0),
('dafa2c29eca3f81a8cb59ee6208de018', './installer/schema/20081119_tiki_p_export_tracker_tiki.sql', '21.12', 0),
('910db98348db50f457bcd220e6b94d96', './installer/schema/20081120_showCategories_tiki.sql', '21.12', 0),
('b96d9c4717c53493180e1b3bba0448ac', './installer/schema/20081120_tiki_poll_structures_update_tiki.sql', '21.12', 0),
('89c22600772bbf20691a784f5abafb0b', './installer/schema/20081125_tiki_tracker_types_tiki.sql', '21.12', 0),
('2a05643888d72c97f051a313404ae0f5', './installer/schema/20081127_calendar_recurrence_tiki.sql', '21.12', 0),
('87e87aca605d69c54c0144768facb548', './installer/schema/20081130_tiki_users_permission_tiki.sql', '21.12', 0),
('f0f9c1466b9330c3a4fa41680a9a63e4', './installer/schema/20081211_newsletter_files_tiki.sql', '21.12', 0),
('fd50074486eece74754eff0e24fa8cc7', './installer/schema/20081211_score_tiki.sql', '21.12', 0),
('419cfa4072a49c9712f047c6d00019e7', './installer/schema/20081212_tiki_p_view_backlinks_tiki.sql', '21.12', 0),
('5671f4746f9ab96caf1673eaabfc8134', './installer/schema/20081214_webservice_post_tiki.sql', '21.12', 0),
('fa760fbadd8b8611db93629587f4c856', './installer/schema/20090106_group_watch_tiki.sql', '21.12', 0),
('91eaa83db90f06582180cd14355122b4', './installer/schema/20090120_sefurl_rules_tiki.sql', '21.12', 0),
('c26a0ce1737db912d15bf60e52b22d1d', './installer/schema/20090129_callendar_search_tiki.sql', '21.12', 0),
('78e3b5aa3c867fa9b6bc5766c70ee9eb', './installer/schema/20090203_null_tiki.sql', '21.12', 0),
('c635a46b0df03ad6549eb3aa555ef0c3', './installer/schema/20090205_forum_and_comments_locking_tiki.sql', '21.12', 0),
('ae4896884f1506b3aef47977d105a445', './installer/schema/20090205_menucase_tiki.sql', '21.12', 0),
('7767c3b7b399c9c01a2687a136c90c6b', './installer/schema/20090205_menus_items_icons_tiki.sql', '21.12', 0),
('500233565a264f3160e0d76034b5bbb2', './installer/schema/20090206_content_tpl_menu_tiki.sql', '21.12', 0),
('70324c0efc3a3fa7d82966f01050c621', './installer/schema/20090206_poll_tiki.sql', '21.12', 0),
('526e7e62f79d0a3a303661f107ab8c50', './installer/schema/20090211_mailnotification_tiki.sql', '21.12', 0),
('7803cbadaa3504e48ab96d2073b85a9f', './installer/schema/20090212_forum_tiki.sql', '21.12', 0),
('b9996cda2a892f43f736e15331321b44', './installer/schema/20090220_admin_section_tiki.sql', '21.12', 0),
('e2e57d5445fccb30772d339a4b6b3e4a', './installer/schema/20090226_admin_menu_tiki.sql', '21.12', 0),
('270f4a015a19424cef2cc35021be8572', './installer/schema/20090301_browsertitle_tiki.sql', '21.12', 0),
('e0d61c3cc6c9b77a755c891d85cb177c', './installer/schema/20090304_tiki_p_view_backlink_without_s_tiki.sql', '21.12', 0),
('f7bd45395c2ff0fd2798e35562df924a', './installer/schema/20090306_menu_perms_tiki.sql', '21.12', 0),
('06fd6cb8f5d2b047ea709ad02c625170', './installer/schema/20090306_text_for_menu_options_tiki.sql', '21.12', 0),
('ce4a78cdeb27a383ce8810ee4fa0d964', './installer/schema/20090310_application_menu_tiki.sql', '21.12', 0),
('cbbffca4f72b5728da74826e7837f286', './installer/schema/20090310_feature_search_show_object_filter_tiki.sql', '21.12', 0),
('667061194dd0bf84dfb4d1dcabeea9b1', './installer/schema/20090311_remove_mod_menu_application_menu_tiki.sql', '21.12', 0),
('956e0e696703ab32441f8ee6f8a6ab77', './installer/schema/20090316_index_tiki.sql', '21.12', 0),
('cbe4979f2306bafb7cbd672dd1cf01d8', './installer/schema/20090323_maxUserImpressions_banners_tiki.sql', '21.12', 0),
('54b66f96391a42d5708064e4ef4c8f97', './installer/schema/20090330_quicktags_renames_tiki.sql', '21.12', 0),
('6b2b361cdf76da968df937fa7376a181', './installer/schema/20090401_newsletters_included_tiki.sql', '21.12', 0),
('39598df227aa9dc8bdadd488df7bbee8', './installer/schema/20090401_replace_shoutjax_with_shoutbox_tiki.sql', '21.12', 0),
('bef61fb68a07da74003ff4afe066c802', './installer/schema/20090401_replace_switch_lang2_with_switch_lang_tiki.sql', '21.12', 0),
('c977452a2ecd8922410ce858425687b3', './installer/schema/20090416_plugin_security_tiki.php', '21.12', 0),
('c2797e88c7a6cf704595e5cd541aeae8', './installer/schema/20090416_plugin_security_tiki.sql', '21.12', 0),
('c90f5078217322adfb556675fa934a82', './installer/schema/20090416_quicktags_kil_email_tiki.sql', '21.12', 0),
('93c12b32158f54c0633bf753269b6494', './installer/schema/20090416_quicktags_plugin_helpers_tiki.sql', '21.12', 0),
('bf02c6a99bf51c768fa4cd2078bb985b', './installer/schema/20090427_filegal_optionalize_tiki.sql', '21.12', 0),
('55df14def9249a255c63a08a413e8d52', './installer/schema/20090429_groupId_tiki.sql', '21.12', 0),
('47b2e95f6c75fc43dd02ec7cb3d3ce7c', './installer/schema/20090513_calendar_priority_tiki.sql', '21.12', 0),
('d9a996de940eb309bf773b52303d825f', './installer/schema/20090513_swffix_tiki.sql', '21.12', 0),
('32809522a429ac7b66f2f96d06d45a8f', './installer/schema/20090513_wiki_similar_permission_tiki.sql', '21.12', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20090515_score_tiki.sql', '21.12', 0),
('9b769896b43df599d973fdd73835fb90', './installer/schema/20090602_webmail_protocols_tiki.sql', '21.12', 0),
('442aa44b3f6f263b01edc9228dcad2ce', './installer/schema/20090605_tiki_p_modify_tracker_items_pending_closed_tiki.sql', '21.12', 0),
('337e0cfb80b1d8dc0a41385b9d3ac655', './installer/schema/20090617_add_new_table_for_reports_tiki.sql', '21.12', 0),
('9f92fa8fa2b8160595b2ac1381fae55a', './installer/schema/20090623_actionlog_view_article_tiki.sql', '21.12', 0),
('cb7026c21dbab9aeec235fff9f1a06b6', './installer/schema/20090626_change_pear_auth_preferences_to_ldap_tiki.sql', '21.12', 0),
('420b72a12e9646cae3b236144528f393', './installer/schema/20090707_tiki_p_delete_account_tiki.sql', '21.12', 0),
('ba933dc23124eb6cc7252fa0fceaa90c', './installer/schema/20090713_tiki_importer_permission_and_menu_entry_tiki.sql', '21.12', 0),
('62dd644b6e39e612d19f540e44282414', './installer/schema/20090715_sefurl_for_filegalleries_tiki.sql', '21.12', 0),
('2371e785ce2570b5dbe4382a9b4488ee', './installer/schema/20090720_perspectives_tiki.sql', '21.12', 0),
('e9b19e102e3eedad9ef8e8f7d032792c', './installer/schema/20090721_webmail_ext_public_tiki.sql', '21.12', 0),
('8139d5f5e562aafc301fe9e64a721c02', './installer/schema/20090727_category_permissions_tiki.sql', '21.12', 0),
('52d147c0e3a28323ddeae7728a6cd2d9', './installer/schema/20090727_user_votings_index_tiki.sql', '21.12', 0),
('628613b2da84a05f443544eaa6b99424', './installer/schema/20090730_p_list_newsletters_tiki.sql', '21.12', 0),
('b92b91a727e9bfb7a7fbe4ad11953a33', './installer/schema/20090803_perspective_permission_tiki.sql', '21.12', 0),
('82f33550024286cdc27d2915604e9158', './installer/schema/20090804_kaltura_permissions_tiki.sql', '21.12', 0),
('d5dc1e57a3396aef995cf2a910469897', './installer/schema/20090804_menu_search_tiki.sql', '21.12', 0),
('f72547e2cb4c194b8fa32d3bec3c9018', './installer/schema/20090805_kill_newsreader_tiki.sql', '21.12', 0),
('cc5c96b09f7b9706036f9bf9b9b73fac', './installer/schema/20090805_remove_drawings_prefs_etc_tiki.sql', '21.12', 0),
('c3f351efc86fb06230ecb11592ed2e9a', './installer/schema/20090805_remove_games_tiki.sql', '21.12', 0),
('cb13f0c90d7565566ffddedd17449dc0', './installer/schema/20090806_group_permissions_tiki.sql', '21.12', 0),
('4fffdf190d26d20a72f384036f924cbf', './installer/schema/20090806_menu_list_trackers_tiki.sql', '21.12', 0),
('2ac3852a87ef99e70fd38dceafcfac46', './installer/schema/20090806_perms_featurechecks_tiki.sql', '21.12', 0),
('ee38952775b551eacf1bb72da93c5acb', './installer/schema/20090806_remove_charts_tiki.sql', '21.12', 0),
('8b5d955462daed16192cd422fc514590', './installer/schema/20090806_remove_latin_collations_tiki.sql', '21.12', 0),
('e1e6b59348c4e6ceb064d2af676b3620', './installer/schema/20090806_strasa_option_rename_tiki.sql', '21.12', 0),
('219ba83a50324f3187bec73f99799637', './installer/schema/20090807_transitions_tiki.sql', '21.12', 0),
('6adbc7a739c0fd262f6600bfc9630510', './installer/schema/20090808_add_wiki_minor_edits_tiki.sql', '21.12', 0),
('0067c2b32ca47ce7b42ea5d45f64cdf4', './installer/schema/20090809_marc_needs_more_space_tiki.sql', '21.12', 0),
('e0a7048d37a6f4ae95fe246a70935e6f', './installer/schema/20090811_filegals_container_tiki.sql', '21.12', 0),
('90cbc20466a1dcd55a42f4532099a4b3', './installer/schema/20090811_kaltura_editor_pref_tiki.sql', '21.12', 0),
('0c64b4b6661d1601b4b1d847b1e6810c', './installer/schema/20090811_quizzes_tiki.sql', '21.12', 0),
('b97dac6447ab14c1278a80bfef18d0d6', './installer/schema/20090811_rename_quicktags_to_toolbars_tiki.sql', '21.12', 0),
('4795abe4f54b97fe2fe1e851d1665031', './installer/schema/20090823_kaltura_menu_options_tiki.sql', '21.12', 0),
('4c19a550fa670b8680b4536491de9f58', './installer/schema/20090826_group_expiration_tiki.sql', '21.12', 0),
('c456caa0febc6f77a02d7202820b6878', './installer/schema/20090904_wysiwyg_newsletters_tiki.sql', '21.12', 0),
('055a4c9f0da1ea66388257c95851fd37', './installer/schema/20090911_tracker_item_change_user_tiki.sql', '21.12', 0),
('647c88b4faa510131fd775b6fd494129', './installer/schema/20090912_change_feature_name_for_lesser_magic_tiki.sql', '21.12', 0),
('97dea83392a7fde1ab54f1ce3df0f26a', './installer/schema/20090913_plugin_security_addedby_tiki.sql', '21.12', 0),
('fd23b4fc2cb7b31f09fcd533ec21f264', './installer/schema/20090915_change_perms_for_browse_cats_tiki.sql', '21.12', 0),
('1f07cce9c277e528d55fb4554f28cea1', './installer/schema/20090921_logo_tiki.sql', '21.12', 0),
('719e84f481152de227bf38b62f212e62', './installer/schema/20090923_mod_change_category_defaults_tiki.php', '21.12', 0),
('f580a5bdef3c93176c9fcc963d6f7ee5', './installer/schema/20090925_online_logged_users_modules_merge_tiki.sql', '21.12', 0),
('b74f2d4a9ac9b184868809defef17b9e', './installer/schema/20090927_top_images_modules_merge_tiki.sql', '21.12', 0),
('d581271bb2b939b62a9c7d3468d71363', './installer/schema/20090928_galaxia_leftovers_tiki.sql', '21.12', 0),
('a9b31268ede9a9d19bad4b3e9a560858', './installer/schema/20090928_last_images_modules_merge_tiki.sql', '21.12', 0),
('47512729ed5702c29ebf674158b7dd22', './installer/schema/20090928_transition_guards_text_tiki.sql', '21.12', 0),
('694228330e0c5978f91390194374cddb', './installer/schema/20091004_last_tracker_items_modules_merge_tiki.php', '21.12', 0),
('566e10ed8016fd2ae2e77017a6af5bc5', './installer/schema/20091007_update_database_structure_tiki.sql', '21.12', 0),
('44c61ac918cc1385b7640393c138efff', './installer/schema/20091008_reg_group_includes_anon_tiki.sql', '21.12', 0),
('1a6e2252aefc8b4549eea766c4681418', './installer/schema/20091011_serurl_dl_order_tiki.sql', '21.12', 0),
('2e691f9f536276faf13b3e7708f77863', './installer/schema/20091013_fix_perms_tiki.sql', '21.12', 0),
('c7ca3defd20741232a8c11b89d2250ab', './installer/schema/20091015_application_menu_admin_renames_tiki.sql', '21.12', 0),
('273bebc06180dcf99c0fbb6f57f32cae', './installer/schema/20091016_categorization_tracker_item_tiki.sql', '21.12', 0),
('034e2ae4f792446a2f2f3e63baa50c4f', './installer/schema/20091019_article_by_rating_modules_merge_tiki.php', '21.12', 0),
('c0ccc3d4da4b543ab2e6110cf9fffacb', './installer/schema/20091019_last_articles_modules_merge_tiki.php', '21.12', 0),
('f8cef1ce28764cf186963efb6e754b6d', './installer/schema/20091019_users_perms_types_tidying_tiki.sql', '21.12', 0),
('cea39d8b633ccf21c530eb38dc8d5d4d', './installer/schema/20091020_bigger_user_prefs_tiki.sql', '21.12', 0),
('97f2e29237a5f2f66a8d68ef1d519aa9', './installer/schema/20091020_faq_created_tiki.sql', '21.12', 0),
('d64f44fb2fc4a66091c7f084278da4f0', './installer/schema/20091020_kaltura_tiki.sql', '21.12', 0),
('849edab4e7d7fdec986089032840ef2c', './installer/schema/20091020_remove_charts_tiki.sql', '21.12', 0),
('87b5cd3a5894c73bc20c2351b549d774', './installer/schema/20091020_sefurl_trackeritem_tiki.sql', '21.12', 0),
('89456db508a7a0d97200907f83c143b0', './installer/schema/20091021_moz_pagelist_tiki.sql', '21.12', 0),
('de6aa476f72445aa4dae312681ce9ebb', './installer/schema/20091023_bookmarks_name_lengthen_tiki.sql', '21.12', 0),
('4ebf9ad2bf9cc6d3e0c6046a38cd3096', './installer/schema/20091023_nul_categ_tiki.sql', '21.12', 0),
('a149de4e5b9d725180961926b6732bb9', './installer/schema/20091023_report_tiki.sql', '21.12', 0),
('345569753d67064166061deda3c47e34', './installer/schema/20091027_multiple_session_handler_tiki.sql', '21.12', 0),
('b3db4a3b28d2e6ca3751e7fdfd22a7a9', './installer/schema/20091028_quota_tiki.sql', '21.12', 0),
('a278b9df0b6b039001b9219863cb7625', './installer/schema/20091030_wiki_watch_tiki.sql', '21.12', 0),
('56f0f541b1c88532811b839523ce665f', './installer/schema/20091103_upgrade_categperm_tiki.php', '21.12', 0),
('6cb6c4aeeb9e0f4790f66fd56bd1e30e', './installer/schema/20091105_auth_tokens_tiki.sql', '21.12', 0),
('f1570b8fd47a0dca223a15382da22709', './installer/schema/20091111_fgal_size_tiki.sql', '21.12', 0),
('7bd8ac55be14e25c7120a26f23eff436', './installer/schema/20091112_rename_mnu_application_menu_tiki.sql', '21.12', 0),
('712125292ff84ad268db796e12d0d860', './installer/schema/20091112_template_type_tiki.sql', '21.12', 0),
('7b18ad1124c4793f68eee26efecc6c15', './installer/schema/20091113_old_categ_perm_tiki.sql', '21.12', 0),
('cbeebd65f32c65d2171b5afe3cb0bb88', './installer/schema/20091118_sefurl_tiki.sql', '21.12', 0),
('893c7f6e4e519c67adc07265daffd31d', './installer/schema/20091120_poll_lookup_index_tiki.sql', '21.12', 0),
('df8cef1f416acca82b52e30e6094aadd', './installer/schema/20091120_username_pattern_tiki.sql', '21.12', 0),
('3e981f300423d52b094778c83e513245', './installer/schema/20091123_dns_permission_tiki.sql', '21.12', 0),
('daf1fb4d5cbbe0e7e38322fcce6c7876', './installer/schema/20091123_metrics_tiki.sql', '21.12', 0),
('99063e6d4f39182c89bd3d79d7afb749', './installer/schema/20091123_upgrade_categperm_2_tiki.php', '21.12', 0),
('0d01e1e05dddfbbbdf9395e59d2ef0c6', './installer/schema/20091124_fgal_backlink_tiki.sql', '21.12', 0),
('5b47492ea791031cf119ac3daf791f97', './installer/schema/20091124_metrics_dsn_tiki.sql', '21.12', 0),
('c070d97d1927459c781cd75887f40d11', './installer/schema/20091125_wiki_comments_per_page_tiki.sql', '21.12', 0),
('94d90cb820a65bdb9a64cb0d2396a643', './installer/schema/20091126_dynamic_variables_i18n_tiki.sql', '21.12', 0),
('5cb9af495c32baaab1a4c975d8cceaef', './installer/schema/20091204_filegal_wiki_syntax_tiki.sql', '21.12', 0),
('a72f40dc524ffce5390afc15923cb78f', './installer/schema/20091204_tiki_p_view_newsletter_tiki.sql', '21.12', 0),
('bb96171d83b521a6699b6cb1630c178e', './installer/schema/20091208_backlink_perms_tiki.sql', '21.12', 0),
('8e295076a1387fd3d68c8a0e23066c7a', './installer/schema/20091209_rss_feeds_name_tiki.sql', '21.12', 0),
('a5044acc14e9a7efe50944b93917d7b2', './installer/schema/20091210_charset_tiki.sql', '21.12', 0),
('d617149349d294764b6820ed8d412244', './installer/schema/20091210_dcs_type_tiki.sql', '21.12', 0),
('727df9ab6d528c92cb82fa1df65bc56a', './installer/schema/20091214_perspective_management_tiki.php', '21.12', 0),
('c275deb83663a95e4265677d33bda5de', './installer/schema/20091214_perspective_management_tiki.sql', '21.12', 0),
('ec2eeddd35627137e13ae7eef8c18f4c', './installer/schema/20091216_show_backlinks_tiki.sql', '21.12', 0),
('bff553fae8d722d9c239714e9e75f369', './installer/schema/20091228_page_keywords_tiki.sql', '21.12', 0),
('5b547103c6c3720dfd46515f3dc4b9cf', './installer/schema/20100101_search_modules_merge_tiki.sql', '21.12', 0),
('2e4b473f1a5ab5dbbf7933ddbb7e2cf4', './installer/schema/20100101_search_wiki_page_modules_merge_tiki.sql', '21.12', 0),
('6b8a6f903619170fc06b5e21acb8a88d', './installer/schema/20100104_tiki_p_tracker_revote_ratings_tiki.sql', '21.12', 0),
('3cbd0d19bfef3b685a304e96902656d8', './installer/schema/20100106_forum_att_list_nb_tiki.sql', '21.12', 0),
('6091b103afb3a34dac0ee1fbf73cf111', './installer/schema/20100107_payment_tiki.sql', '21.12', 0),
('0e531e6cd9f6bc248c9e940afcdce1c9', './installer/schema/20100113_forum_display_tiki.sql', '21.12', 0),
('3e8c5924e3563c9f15474662ed5165c5', './installer/schema/20100114_tiki_actionlog_merge_tiki.sql', '21.12', 0),
('8b23e2a3a3dc1aa2bd6be6650005e50e', './installer/schema/20100115_admin_modules_menu_tiki.sql', '21.12', 0),
('69a98c55dfdb0639be58af44be275639', './installer/schema/20100115_tiki_p_admin_modules_tiki.sql', '21.12', 0),
('7435683dd08e061a90055de63c6ca777', './installer/schema/20100115_translations_in_progress_tiki.sql', '21.12', 0),
('42a4ae39d6d4045d0e4d96fd785fd620', './installer/schema/20100117_old_doc_tw_o_url_tiki.sql', '21.12', 0),
('a7311875283acb4a98ea9210ff9588ba', './installer/schema/20100118_blog_use_author_tiki.sql', '21.12', 0),
('79e3b88f76c6ced0918f76d5b6665578', './installer/schema/20100118_forum_display_tiki.sql', '21.12', 0),
('2ea1308ff02955c7b6656076301299ab', './installer/schema/20100126_file_lastDownload_tiki.sql', '21.12', 0),
('68f8d2e78cc73e8562839970ba92a70d', './installer/schema/20100128_tiki_p_blog_view_ref_tiki.sql', '21.12', 0),
('6f2fff9200d779aabaf21e7144b5ecdd', './installer/schema/20100129_clean_up_tiki.sql', '21.12', 0),
('7413da3b3b575abed3464e09b768a080', './installer/schema/20100129_events_kil_tiki.sql', '21.12', 0),
('c66c9f9a5d2d14ae38ac664738d0836d', './installer/schema/20100203_payment_detail_tiki.sql', '21.12', 0),
('888c53dd6f29cd376fde45828fc8d69d', './installer/schema/20100205_tiki_p_wiki_view_ref_tiki.sql', '21.12', 0),
('d4e31e1fc0e8b8c3a2c17f9bdfd2ca44', './installer/schema/20100207_repair_file_galleries_tiki.php', '21.12', 0),
('62b68d582219c533707616735cdf5808', './installer/schema/20100211_rss_items_tiki.sql', '21.12', 0),
('350aff4b5e0a30d274134424b0788327', './installer/schema/20100211_tiki_perms_menu_item_tiki.sql', '21.12', 0),
('3fcab51527f14091b72a61862d375c45', './installer/schema/20100211_tiki_sheet_add_parseValues_tiki.sql', '21.12', 0),
('f2596badf24baf56d10e2c6789213960', './installer/schema/20100212_rss_automation_tiki.sql', '21.12', 0),
('b8760600ba1e21e712f362e63befac45', './installer/schema/20100213_group_inclusion_key_tiki.sql', '21.12', 0),
('c517e0b264751804c7ff41e37f1a413c', './installer/schema/20100214_workspaces_remove_menu_items_tiki.sql', '21.12', 0),
('2e13b2537ecd9512345c81c16b4910f9', './installer/schema/20100215_create_tiki_user_login_cookies_tiki.sql', '21.12', 0),
('54cc4bcc3ffa4453554c3ce8b06fecc3', './installer/schema/20100215_rating_permissions_tiki.sql', '21.12', 0),
('8fe2a877d3ba15b47a0708ce40024d15', './installer/schema/20100216_attributes_tiki.sql', '21.12', 0),
('36037bd886a0e5868c5fe59c337f6c2e', './installer/schema/20100216_kil_moz_screencast_tiki.sql', '21.12', 0),
('8a232ebfe1aff7c6a9cc6ad47b88a4cf', './installer/schema/20100216_rename_tikisheet_tiki.sql', '21.12', 0),
('a898addd31219a957b2726c6be673ba5', './installer/schema/20100217_rating_config_tiki.sql', '21.12', 0),
('62a29f5266842c3aafc5e77ca31a4b3f', './installer/schema/20100218_auth_token_reuse_tiki.sql', '21.12', 0),
('0dcee212645ce8000ad216d6bf812c2e', './installer/schema/20100222_add_webmail_fromEmail_field_tiki.sql', '21.12', 0),
('5cf4ae8252efbc6fc53560fb1855fbd6', './installer/schema/20100222_sheet_toolbar_default_tiki.sql', '21.12', 0),
('01714f7d35dd064f2ea3075ea8046096', './installer/schema/20100223_blog_always_owner_tiki.sql', '21.12', 0),
('d71296c973433d613a12e4d1ee6321cf', './installer/schema/20100224_object_relations_tiki.sql', '21.12', 0),
('9a60dd3d2db1b9e7a0187a818ef08d7a', './installer/schema/20100226_menu_template_feature_check_tiki.sql', '21.12', 0),
('ce7a80dc86bcabf4372e9745cce0e440', './installer/schema/20100226_tracker_dump_perm_tiki.sql', '21.12', 0),
('a1191e4c09d52e1886507e62e6573994', './installer/schema/20100302_filegal_images_max_sizes_tiki.sql', '21.12', 0),
('bf751d0e1c3ad816fbdd7e612c1880db', './installer/schema/20100308_file_delete_after_tiki.sql', '21.12', 0),
('902b64fe934469ed98341678a7840245', './installer/schema/20100309_add_sheet_parent_tiki.sql', '21.12', 0),
('6164442730abf0ff4849170a5c90dbda', './installer/schema/20100312_emailPattern_tiki.sql', '21.12', 0),
('3c97d38fb32ce744185b6ff04d58fa0d', './installer/schema/20100324_newsletters_clippings_tiki.sql', '21.12', 0),
('8d0e67468c13d44ce90601a230c7fd68', './installer/schema/20100409_bigger_module_params_tiki.sql', '21.12', 0),
('4177492c2f4ee3bfbe97c90f38ae0626', './installer/schema/20100414_actionlog_pref_tiki.sql', '21.12', 0),
('f2e50c371c67658571f3290165beff43', './installer/schema/20100414_actionlog_system_tiki.sql', '21.12', 0),
('bbaebffa62af9ccfc56bcece0793b7e0', './installer/schema/20100419_bigbluebutton_tiki.sql', '21.12', 0),
('f4afdf505b5739a5c0686e45a8db05e7', './installer/schema/20100422_tracker_log_tiki.sql', '21.12', 0),
('308355b22eed6e20d83a812cf0462fd0', './installer/schema/20100429_newsletter_pages_tiki.sql', '21.12', 0),
('67152e85d0f28f88130cb9a620d1131a', './installer/schema/20100507_flash_banner_tiki.php', '21.12', 0),
('1b5f530a959dd6c18375fdacf258c03e', './installer/schema/20100519_actionlog_tiki.sql', '21.12', 0),
('f7f3a83c028f4a1afbc5e4ad922386fb', './installer/schema/20100525_tracker_validation_message_tiki.sql', '21.12', 0),
('50075186c65a27d7a0eee7962f0f0862', './installer/schema/20100525_tracker_validation_tiki.sql', '21.12', 0),
('c85d90ed2ab759856b41dc3d705f7a96', './installer/schema/20100611_rss_items_url_tiki.sql', '21.12', 0),
('4cb7c699ac79b750404f413e18841472', './installer/schema/20100617_sefurl_user_info_tiki.sql', '21.12', 0),
('7a887d3c80359db3c7baf7a18b4a51d0', './installer/schema/20100618_calendar_participation_tiki.sql', '21.12', 0),
('2c666df90eaaa04fb2ee6d1928b38814', './installer/schema/20100621_pageprefixaliasdata_tiki.sql', '21.12', 0),
('838bb67100b2ef14a12db5d8f026fe24', './installer/schema/20100622_pageprefixtrackeritemid_tiki.sql', '21.12', 0),
('c841699992b391db66f91faba7493f62', './installer/schema/20100623_semantic_to_relation_tiki.php', '21.12', 0),
('4673960aa9da0b18682403cb6be37d5a', './installer/schema/20100623_semantic_to_relation_tiki.sql', '21.12', 0),
('690f54a7ae99b145b7fdda6c8df6d1b8', './installer/schema/20100624_banning_index_tiki.sql', '21.12', 0),
('49f703eb7f92a2ecf5d8cd7e127dd02e', './installer/schema/20100628_payment_user_tiki.sql', '21.12', 0),
('687f64c286450f0fe0de1cfbf05c3d0e', './installer/schema/20100629_remove_feature_blog_comments_tiki.sql', '21.12', 0),
('68cf0eae8dbdf2a35c69ed4d579e2b66', './installer/schema/20100702_discount_tiki.sql', '21.12', 0),
('1cd43cc0c8d523dc0e9d7dda5e6fd25f', './installer/schema/20100712_remove_unsupported_feed_formats_tiki.sql', '21.12', 0),
('19adc11a5cc9a329cedc5f84f4f90e61', './installer/schema/20100713_rename_feed_prefs_tiki.sql', '21.12', 0),
('91725fe31a54b7681540807302be4a48', './installer/schema/20100714_batch_transition_tiki.sql', '21.12', 0),
('e62cac7f6a4bc314978ee2ac087d67a7', './installer/schema/20100716_user_selector_pref_rename_tiki.sql', '21.12', 0),
('a0719690681cf54c6ecdddeda600dc28', './installer/schema/20100720_tiki_p_view_page_contribution_tiki.sql', '21.12', 0),
('7fbf99c2db7f32abaa339668cbcd06d3', './installer/schema/20100721_batch_transition_rollback_tiki.sql', '21.12', 0),
('38442f36835a3108f4f8bdfaf6fe72d4', './installer/schema/20100721_todo_tiki.sql', '21.12', 0),
('57eb1c692598aebcc6f6c62be8267419', './installer/schema/20100721_todonotif_tiki.sql', '21.12', 0),
('5b12e1bc1238983e0fd1ced13c876eb0', './installer/schema/20100727_tiki_p_promote_page_tiki.sql', '21.12', 0),
('c3049a9ad85d934d80509f1bce54ed56', './installer/schema/20100730_list_image_article_tiki.sql', '21.12', 0),
('5b0a22957d84f831f300f0040aeeb6a0', './installer/schema/20100802_tiki_p_share_tiki.sql', '21.12', 0),
('8e02a6d8ad2e1cc0c9e2bf6f9ee8ed28', './installer/schema/20100802_url_shortener_tiki.sql', '21.12', 0),
('44806754ed381ae3a982f7837e49bccd', './installer/schema/20100804_remove_tiki_languages_tiki.sql', '21.12', 0),
('d25e77ce8d4571079e175bc6c47396f2', './installer/schema/20100806_blog_posts_header_tiki.sql', '21.12', 0),
('686669d28d921b67f74e73c939c72a6c', './installer/schema/20100807_alter_tiki_translate_fields_to_text_tiki.sql', '21.12', 0),
('7ef9c8bb7582170a536f47932aee91d4', './installer/schema/20100810_title_comments_upgrade_tiki.sql', '21.12', 0),
('8df0894c777a22e016d7c86adeb5c21a', './installer/schema/20100812_blog_control_max_related_content_tiki.sql', '21.12', 0),
('3ea3be26f5d40cf2edd81abd799ba344', './installer/schema/20100812_blog_show_related_content_tiki.sql', '21.12', 0),
('31c1a0ef9f413ab92ceb6bfe4523fbe3', './installer/schema/20100817_add_email_and_website_fields_to_comments_tiki.sql', '21.12', 0),
('6ea024455e832c9103a199533dbe6568', './installer/schema/20100817_credits_tiki.sql', '21.12', 0),
('5d2cc4aa05385cfc2eba8ac701ae148e', './installer/schema/20100817_rename_preference_wiki_comments_notitle_tiki.sql', '21.12', 0),
('4a3d0c92c69fb3dcc0b9770d62d27c71', './installer/schema/20100818_watch_tiki.sql', '21.12', 0),
('2759ff42a931fce14c367e87ae4c0331', './installer/schema/20100820_blog_posts_wysiwyg_tiki.sql', '21.12', 0),
('31bcc44f8cb269593a399ee00313995e', './installer/schema/20100820_feed_fields_text_and_desc_are_not_empty_tiki.sql', '21.12', 0),
('8d0992f78c263a025ccbd605f6fb7262', './installer/schema/20100824_blog_post_excerpt_tiki.sql', '21.12', 0),
('e2a19962bed53701d9998d7c4434a85d', './installer/schema/20100825_add_changed_column_to_tiki_language_table_tiki.sql', '21.12', 0),
('f0f6af415f67e26aee90c86b87dbf387', './installer/schema/20100825_remove_blog_option_use_title_tiki.sql', '21.12', 0),
('890a3d6accb68581f7d00ebd2c347c1e', './installer/schema/20100830_sheet_add_styles_and_classes_tiki.sql', '21.12', 0),
('560834495744de5dc66690afea1a7626', './installer/schema/20100831_freetag_tiki.sql', '21.12', 0),
('47ed97c0106c3693caa30a0e2ba418fb', './installer/schema/20100901_duplic_actionlog_tiki.sql', '21.12', 0),
('d1f95ffd6ff3f55516c7ff77e3d51297', './installer/schema/20100901_expire_tiki.sql', '21.12', 0),
('99eb503b8e9fcbb4951be5545cc87b9e', './installer/schema/20100902_invit_tiki.sql', '21.12', 0),
('c2b3511dc21a90f27e01a2b270b36ff4', './installer/schema/20100903_article_ispublished_tiki.sql', '21.12', 0),
('57ba839a9b670ba2d383e95875842a79', './installer/schema/20100906_sheet_toolbar_default_tiki.sql', '21.12', 0),
('7a6c571a8fa5ae4142a639593d567671', './installer/schema/20100909_alter_tiki_language_fields_to_text_tiki.sql', '21.12', 0),
('56c277c30f3bb31dc71972f0b90b860a', './installer/schema/20100909_ckeditor_upgrade_tiki.sql', '21.12', 0),
('0d2cdf85fdd09e62d49b8f21ce1e0b48', './installer/schema/20100909_lengthen_wiki_attachments_filename_tiki.sql', '21.12', 0),
('c2c91b87c9818a362b19af7d95361bee', './installer/schema/20100910_new_fields_for_tiki_blogs_tiki.sql', '21.12', 0),
('de4d46f4cc1e55843ee4fb763f1bfbb2', './installer/schema/20100912_rename_autosave_pref_tiki.sql', '21.12', 0),
('ceb893e4b41453e3f40e6f49740694a8', './installer/schema/20100915_add_edit_languages_menu_option_tiki.sql', '21.12', 0),
('b013ef3769d8303ade0931d40bcadbbe', './installer/schema/20100919_tiki_page_contribution_tiki.sql', '21.12', 0),
('9628e595d2392ac509aa9a851b416822', './installer/schema/20100920_ckeditor_remove_pref_tiki.sql', '21.12', 0),
('ea7b94f6c26c78f9cfe9914004b126a2', './installer/schema/20100920_jq_sheet_remove_pref_tiki.sql', '21.12', 0),
('0f0e8d6edd889f948074b5c58eb706d3', './installer/schema/20100920_todo_event_tiki.sql', '21.12', 0),
('0a44187ddda66fb57a8e37de3c683697', './installer/schema/20100923_fix_column_position_tiki.sql', '21.12', 0),
('70deaf3aecb55eff018d3f3d692a7838', './installer/schema/20100923_social_networking_permission_and_menuitem_tiki.sql', '21.12', 0),
('15b3ea9e0602ba476f14eca5ed031f62', './installer/schema/20100925_fix_some_default_value_tiki.sql', '21.12', 0),
('dd623f99481a41597fdf2a9a2d31f7be', './installer/schema/20100927_better_column_fix2_tiki.php', '21.12', 0),
('87089021a0fb65f871b3ed7dbd766d36', './installer/schema/20100927_better_column_fix_tiki.php', '21.12', 0),
('7078f85293d9b2df64d6b783fd69a8f9', './installer/schema/20100928_sefurl_regex_reordering_tiki.sql', '21.12', 0),
('b319e7d8b377939e46e5c59fbbfc9cdb', './installer/schema/20101008_user_id_for_tiki_language_tiki.sql', '21.12', 0),
('aa530de5c60b975c437300e3789b2f88', './installer/schema/20101014_tiki_language_add_lastModif_column_tiki.sql', '21.12', 0),
('d982ed41cbf120d9b6c2ebe5ac7e2813', './installer/schema/20101015_tiki_admin_perms_tiki.sql', '21.12', 0),
('f641cc4bf74fb2e9ff547e1aac5c17ae', './installer/schema/20101021_rename_blog_post_comment_object_type_tiki.sql', '21.12', 0),
('ae10d405e50604c62961ff3f82c58fdb', './installer/schema/20101025_fgal_show_deleteAfter_tiki.sql', '21.12', 0),
('0a0afe6962bb24e3d73b2c9409e54fcd', './installer/schema/20101025_profile_sources_pref_tikiwiki_to_tiki.sql', '21.12', 0),
('8d475ba6cabe360e56d29efdbea5e905', './installer/schema/20101025_rename_create_blog_menu_entry_tiki.sql', '21.12', 0),
('3e70698041a57203ad6063378c85984a', './installer/schema/20101026_auth_token_add_columns_tiki.sql', '21.12', 0),
('6497387d0c7806b7aa2427ebef94f37b', './installer/schema/20101027_add_file_gallery_columns_tiki.sql', '21.12', 0),
('228fe45691621f0bb44c70c86a2313c4', './installer/schema/20101027_rename_invit_to_invite_tiki.sql', '21.12', 0),
('8c9d09f4bcecefe64b6610e390492a55', './installer/schema/20101028_p_invit_tiki.sql', '21.12', 0),
('06adc57267b54f62d81f7045853d2842', './installer/schema/20101110_actionlog_tiki.sql', '21.12', 0),
('b61f72f5e9c94f9868f641b673f08ec9', './installer/schema/20101117_actionlog_tiki.sql', '21.12', 0),
('18252b1f4851a73f05c7108718b95836', './installer/schema/20101119_categ_perm_tiki.sql', '21.12', 0),
('b4798dabe798ce6d321a864f17695513', './installer/schema/20101126_fgal_add_gallerie_user_tiki.php', '21.12', 0),
('e4b0f44e867fc72e58fb85fc610399a9', './installer/schema/20101130_recreate_tiki_accounting_tables_tiki.sql', '21.12', 0),
('3302b26e70bb5b51e46e783fdea048ed', './installer/schema/20101130_tiki_accounting_tiki.sql', '21.12', 0),
('f4f667d5a0393718c980cf83fe5be0a6', './installer/schema/20101201_tiki_accounting_fix_index_tiki.sql', '21.12', 0),
('ab434bc67f52b72a28cce6ab0ae0d351', './installer/schema/20101203_fgal_archive_default_tiki.sql', '21.12', 0),
('9d6fdac3ebb63a29a4a6fc67e925d9f7', './installer/schema/20101207_feature_file_drafts_tiki.sql', '21.12', 0),
('a46381a5a632a1c933b5e776c39fee0d', './installer/schema/20101208_webservice_soap_tiki.sql', '21.12', 0),
('23310cedb2a0eb52ef14cb02247a591a', './installer/schema/20101210_fgal_add_wiki_attachments_tiki.php', '21.12', 0),
('dd5468fab59af87a2aa1d9d86c46d125', './installer/schema/20101210_sync_users_ldap_tiki.sql', '21.12', 0),
('5058136507b87f7dad9221c554f053b4', './installer/schema/20101211_filegal_maxhits_column_tiki.sql', '21.12', 0),
('eec197ea0a1ad1328be0ee897490c922', './installer/schema/20101211_kil_feature_phplayers_tiki.php', '21.12', 0),
('f6e3f8d12dc1ab16f9b8375f553a64be', './installer/schema/20101215_remove_files_tiki.sql', '21.12', 0),
('56bd633ebe67ea8013b7263320d9d442', './installer/schema/20101215_template_file_galleries_tiki.sql', '21.12', 0),
('3de83e0ba0fb478781deadea680de629', './installer/schema/20101219_kill_feature_mobile_tiki.sql', '21.12', 0),
('a75511502d9aaa6062d733fa26eff122', './installer/schema/20101230_create_top_modules_tiki.php', '21.12', 0),
('4ee4898cf36420a15d9bce153645e92d', './installer/schema/20110103_include_in_history_tiki.sql', '21.12', 0),
('24ff523ffad872d3ce90571ce0d70702', './installer/schema/20110104_flagged_revision_log_tiki.sql', '21.12', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_again_tiki.sql', '21.12', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_tiki.sql', '21.12', 0),
('83e49b253f0a00059a979cd3a88a6343', './installer/schema/20110112_approval_permissions_tiki.sql', '21.12', 0),
('5b12bb196ba96cd1c51ee275f5da6efc', './installer/schema/20110115_create_bottom_modules_tiki.php', '21.12', 0),
('0b0ad5da10e9c802b02aff9be0e603a7', './installer/schema/20110118_p_remove_tracker_items_tiki.sql', '21.12', 0),
('c55afd33b7db3e2822c266655eee7aa7', './installer/schema/20110124_update_sheet_to_support_cloning_tiki.sql', '21.12', 0),
('6578b9a56ba05b5f5972182d8324647f', './installer/schema/20110201_c_code_to_user_modules_tiki.php', '21.12', 0),
('96de5f8fc058be02a0d781c11f96876f', './installer/schema/20110209_p_list_users_tiki.sql', '21.12', 0),
('e182b1170b0628144f3b7031b4ae9e56', './installer/schema/20110220_p_tracker_view_attachments_tiki.sql', '21.12', 0),
('cf450811ce67bd74a29f4c977127e74f', './installer/schema/20110223_queue_tiki.sql', '21.12', 0),
('540c8adbe21843a849f78019a3a90752', './installer/schema/20110224_tiki_cart_inventory_hold_tiki.sql', '21.12', 0),
('097d060cf3ea7d34012d7692bcdefe40', './installer/schema/20110307_remove_calendar_reminder_tiki.sql', '21.12', 0),
('9383d1ca207d3aec10bf0e8847b8e8f2', './installer/schema/20110308_rss_item_key_tiki.sql', '21.12', 0),
('58b53aa01ecf477ac82dde6e4ef3d7e5', './installer/schema/20110317_attributes_increase_length_tiki.sql', '21.12', 0),
('9830d9ebee9ed93916946a229528d0f0', './installer/schema/20110411_banner_tiki.sql', '21.12', 0),
('8540fc07af7bdbbe76307d4af97a02fc', './installer/schema/20110412_permissions_out_of_db_tiki.sql', '21.12', 0),
('93e5ba1928f66db69d80f8556f6e0279', './installer/schema/20110413_blog_post_priv_default_value_tiki.sql', '21.12', 0),
('56eb71d5321768180d28bbdd0d54a1ae', './installer/schema/20110419_kill_old_search_tiki.sql', '21.12', 0),
('221fbfc6f88ef2630110ad5f6e19a358', './installer/schema/20110420_newsletter_optional_group_inclusion_tiki.sql', '21.12', 0),
('37c7ccf6d9b10f0bd4612d2967a8c309', './installer/schema/20110421_compact_search_in_topbar_tiki.sql', '21.12', 0),
('22ac2552b70bc5b077c29450466aeec9', './installer/schema/20110507_remove_module_style_params_tiki.sql', '21.12', 0),
('c19e62816382404968d7a6dfff401da2', './installer/schema/20110513_banner_tiki.sql', '21.12', 0),
('49ee38d3748df43aed7787eee4832c25', './installer/schema/20110519_quick_edit_categ_params_merge_tiki.php', '21.12', 0),
('d43e01ff75818f0ce802cf666a5a9123', './installer/schema/20110603_convert_tracker_comments_tiki.sql', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('9820218bc613e80463759ac5cdffcb61', './installer/schema/20110606_convert_ip_fields_to_ipv6_tiki.sql', '21.12', 0),
('40f0744f54d9759ec458a8d0aa18dc2f', './installer/schema/20110609_batch_update_tracker_item_links_tiki.php', '21.12', 0),
('787a5f5d2bab3458b3012ae54469ee1c', './installer/schema/20110609_missing_sql_tiki.sql', '21.12', 0),
('498e77c0cbc3a1d2df66cad5d8bb2f02', './installer/schema/20110609_unique_login_tiki.php', '21.12', 0),
('7b2ca0e301980076571f77079fb4ffbd', './installer/schema/20110610_readd_sefurl_index_left_tiki.php', '21.12', 0),
('d2eb778b6e53206bda4c5a620bec19ee', './installer/schema/20110610_revert_poll_additions_tiki.php', '21.12', 0),
('118fe0373f666f454253d166c37723d3', './installer/schema/20110611_accounting_fix_primarykeys_tiki.sql', '21.12', 0),
('7ac89aee06b1e7dfc191afd6b837af2b', './installer/schema/20110613_filegal_source_display_tiki.sql', '21.12', 0),
('427cc93a90cdacb6d1969a8909edcf2d', './installer/schema/20110614_provider_authentication_tiki.sql', '21.12', 0),
('45cc111cc1df4c17c6982177b24a0250', './installer/schema/20110615_structure_alias_tiki.sql', '21.12', 0),
('3d3efcb12b2491dade431346a93f4272', './installer/schema/20110622_file_from_url_log_tiki.sql', '21.12', 0),
('2881aa2867a68821baa2f8a9d95e16cb', './installer/schema/20110630_fix_blogs_copyright_frencho_tiki.sql', '21.12', 0),
('1207ff134476c048445fa5a175aeda3d', './installer/schema/20110717_invoice_menu_options_tiki.sql', '21.12', 0),
('d706c164e7327bf66d68644d7297e921', './installer/schema/20110725_tracker_field_permname_tiki.sql', '21.12', 0),
('251cecfa76c048b5d4c5c8f5bc78f9c4', './installer/schema/20110727_tracker_multilingual_convert_tiki.php', '21.12', 0),
('9c2fe77d70c17df2c038e4488b17d794', './installer/schema/20110727_tracker_multilingual_convert_tiki.sql', '21.12', 0),
('94392c46b0ed3843e2cc020e7c75db6f', './installer/schema/20110803_objectpermissions_tiki.sql', '21.12', 0),
('3713bca2297fd26847d523ac6512224b', './installer/schema/20110808_default_perm_name_tiki.sql', '21.12', 0),
('2616b96d2ce5225935c658d36a171833', './installer/schema/20110808_tracker_tiki.sql', '21.12', 0),
('a08aa709071292d07d56267037fd0f95', './installer/schema/20110815_creator_lost_7_tiki.sql', '21.12', 0),
('4fc9819d32aca61b48496e52c8aa36f9', './installer/schema/20110819_group_max_length_tiki.sql', '21.12', 0),
('e231fddadcb14872a9ce9ca65abedc38', './installer/schema/20110823_tiki_connect_create_tiki.sql', '21.12', 0),
('909b66c9cec3266e729c30c78a5e0676', './installer/schema/20110830_default_enable_in_use_tiki.php', '21.12', 0),
('1b9c3c961e6deca124a4012adf6a2734', './installer/schema/20110830_tiki_connect_longer_guid_tiki.sql', '21.12', 0),
('a98b196cc92793a0d5604d079f0e8dd5', './installer/schema/20110902_revert_rootCategId_addition_tiki.php', '21.12', 0),
('328b8627af75d5564f388731ab74c711', './installer/schema/20110904_shoutbox_def_tweetid_tiki.sql', '21.12', 0),
('06177cffcaa034aa10f307ab16118ee4', './installer/schema/20110905_extend_actionlog_comment_tiki.sql', '21.12', 0),
('7dae763f1b60462d4deea54b63f13d05', './installer/schema/20110905_multibyte_lc_fix_tiki.php', '21.12', 0),
('24ce6ceaf2a590a5291cbb899b6b8ce7', './installer/schema/20110908_author_submission_tiki.sql', '21.12', 0),
('322244495b3f612ff070dba910433fde', './installer/schema/20110909_tiki_forums_add_language_tiki.sql', '21.12', 0),
('13a301980674abdc01e85abea9425dfa', './installer/schema/20110911_add_missing_engine_specs_tiki.sql', '21.12', 0),
('76e3828702b68de894048a364ad096f3', './installer/schema/20110912_groupsexpiryanniversary_tiki.sql', '21.12', 0),
('6e71326d28f1b81e66467802d5dfed74', './installer/schema/20110912_remove_unused_fields_tiki.sql', '21.12', 0),
('6114f9218bd29cdc11f8c1a1d039985e', './installer/schema/20110923_referer_stats_tiki.sql', '21.12', 0),
('5cb9b8bc23137ec40da043d997af27cc', './installer/schema/20110926_tracker_menu_feature_reports_tiki.sql', '21.12', 0),
('fe33b73d123c8916219bb20e364a5c2d', './installer/schema/20111001_add_tiki_areas_tiki.sql', '21.12', 0),
('407750420d6d2827c1198ce722fefc24', './installer/schema/20111006_drop_useless_key_tiki.sql', '21.12', 0),
('8a209404605b849b3179d6b9ef3ef1cb', './installer/schema/20111010_revert_fix_user_bookmarks_folders_key_tiki.php', '21.12', 0),
('e4fd615f3ee7224ce7065179ac05b602', './installer/schema/20111014_menu_feature_time_sheet_tiki.sql', '21.12', 0),
('e49fc3a8c6b20f7beee8389d50f0f134', './installer/schema/20111118_remove_versionOfPreferencesCache_tiki.sql', '21.12', 0),
('955501778236fe83504e4ce2c02099c8', './installer/schema/20111210_add_blog_hits_tiki.sql', '21.12', 0),
('8c3eefd5747facc604522bce0b7a3b0a', './installer/schema/20111217_on_value_tracker_tiki.sql', '21.12', 0),
('8f2a0c21aa4b8fbb1fea7812b0dd987c', './installer/schema/20111231_change_datetime_defaults_to_null_tiki.php', '21.12', 0),
('54901ab93551e49fd2372410d26f24d7', './installer/schema/20120115_remove_article_show_lang_tiki.sql', '21.12', 0),
('eb75b6d04c0ba431ba96f3f3e00b183e', './installer/schema/20120118_remove_users_prefs_language_tiki.sql', '21.12', 0),
('8aa7cfcc0e89ac36204d4d2923d782dd', './installer/schema/20120123_remove_column_from_tiki_user_reports_tiki.sql', '21.12', 0),
('6f7ae9d4d88d1fd8f47ed4207a142ec7', './installer/schema/20120315_list_image_article_y_tiki.sql', '21.12', 0),
('885239c9f8095951b27783e13121d9b3', './installer/schema/20120319_remove_sheets_with_no_relation_tiki.sql', '21.12', 0),
('47a64215b806bc69fc1762bec8628a80', './installer/schema/20120320_remove_admin_trackers_application_menu_tiki.sql', '21.12', 0),
('8be855afd09afffd9421030ef884d7c0', './installer/schema/20120323_add_reports_to_application_menu_tiki.sql', '21.12', 0),
('5915f745e660dbfb599856e21d1d5a8c', './installer/schema/20120323_remove_tracker_reports_from_application_menu_tiki.sql', '21.12', 0),
('46b7f80f9589da64c98a70b9269c6cc2', './installer/schema/20120324_add_filegals_icon_tiki.sql', '21.12', 0),
('ef7cd89a6a747950a94c018b0b9b3021', './installer/schema/20120401_kaltura_prefs_rename_tiki.sql', '21.12', 0),
('d584b6468da64406ca9c74047e2b2f45', './installer/schema/20120408_add_forumthread_sefurl_tiki.sql', '21.12', 0),
('e5c32a4acc3564abb7646802d82939ea', './installer/schema/20120421_autoincementtoautoincrement_tiki.sql', '21.12', 0),
('0351e57b91c6022444ecfeffc7c72e07', './installer/schema/20120422_mime_tiki.sql', '21.12', 0),
('98c3ad22db54d5a603bf29f8711da702', './installer/schema/20120423_add_page_refs_tiki.sql', '21.12', 0),
('0a97722ec5858dade8610abc538d06a3', './installer/schema/20120423_add_status_attr_tiki.sql', '21.12', 0),
('eb751653821eea4afa005a21965fb001', './installer/schema/20120426_perspectives_menu_entry_tiki.sql', '21.12', 0),
('065220f370cf11f688281a5c21a047ce', './installer/schema/20120426_tiki_db_status_tiki.sql', '21.12', 0),
('02bf40200fca128296c8d09cea9f60ce', './installer/schema/20120429_fix_collation_tiki.php', '21.12', 0),
('2a1743af01a89efb43f2e6b0822ca5d7', './installer/schema/20120510_mailqueue_tiki.sql', '21.12', 0),
('02fd7c020f0f0eecb8c46c966387bfa7', './installer/schema/20120604_add_holder_to_copyright_tiki.sql', '21.12', 0),
('76c9d5df3cf491f680198d41898a1611', './installer/schema/20120628_correct_admin_user_createdate_tiki.sql', '21.12', 0),
('f77420b5c17943f0f57b9ae25f40fd04', './installer/schema/20120823_admin_user_credit_menu_entry_tiki.sql', '21.12', 0),
('12883dd19af98f0a15e96c8e12355986', './installer/schema/20120823_workspace_template_tiki.sql', '21.12', 0),
('849d88e7bb98c32166cc7f7c8e422bf0', './installer/schema/20120824_advanced_mode_flag_tiki.sql', '21.12', 0),
('b09f72e445325d5b290bd74023b5f956', './installer/schema/20120825_accounting_menu_entry_tiki.sql', '21.12', 0),
('b94ca87f607d459633ed52b307917eb8', './installer/schema/20120826_store_metadata_tiki.sql', '21.12', 0),
('9978f03b84b9a683f5d0f03e0ae5333f', './installer/schema/20120904_category_root_tiki.php', '21.12', 0),
('040310ecc810ced038db139a0bf9943d', './installer/schema/20120904_category_root_tiki.sql', '21.12', 0),
('46aadea27a9cd9646b771b97b4a9ab30', './installer/schema/20120927_add_area_exclusive_and_common_tiki.sql', '21.12', 0),
('29f3ec57c679da3c747c8d1fb78f4bcd', './installer/schema/20120927_add_menu_parse_tiki.sql', '21.12', 0),
('2a44d38e5345ebf58742ba826ecb5ecc', './installer/schema/20120930_tiki_p_view_poll_choices_tiki.sql', '21.12', 0),
('3cb67ce6e2d0c884110fd7848c94a7c9', './installer/schema/20121009_module_search_box_to_search_tiki.sql', '21.12', 0),
('7ffee0c3c2c04925d2657e7a3aced53e', './installer/schema/20121016_actionlog_comment_text_tiki.sql', '21.12', 0),
('a0febeb05f910d11a36b2494bf89f707', './installer/schema/20121027_tracker_samerow_fix_tiki.sql', '21.12', 0),
('1cdbb1b1c87529f75509a40d900de4cd', './installer/schema/20121210_add_missing_index_user_assigned_modules_tiki.sql', '21.12', 0),
('fddde4267df7ab11df0999f2114b76b0', './installer/schema/20121210_better_forum_reported_index_tiki.sql', '21.12', 0),
('ee444aa9cafa9e7139e7270f26329925', './installer/schema/20121213_module_zone_enlarge_tiki.php', '21.12', 0),
('566786e812240f906c36fd1d4acd9542', './installer/schema/20121213_module_zone_enlarge_tiki.sql', '21.12', 0),
('f400a5ecec07b112fec66e77b1d2f729', './installer/schema/20130220_wiki_attachments_tiki.sql', '21.12', 0),
('737e19c901e25ff8c54a4558fe018a29', './installer/schema/20130228_bigger_token_groups_tiki.sql', '21.12', 0),
('ee050d5b8a9eca59e6f125a45c283475', './installer/schema/20130301_sefurl_tracker_type_tiki.sql', '21.12', 0),
('5dbed3f1754a382fc2679f55a98523fc', './installer/schema/20130314_keep_search_pref_settings_tiki.php', '21.12', 0),
('cad976420a3bc2e4a49506632af268e4', './installer/schema/20130322_app_menu_timesheet_pos_tiki.sql', '21.12', 0),
('44ec4903b1538e416525a6594899e66c', './installer/schema/20130322_restore_lost_filegals_tiki.sql', '21.12', 0),
('78828e075e63206219481fd1a96faca5', './installer/schema/20130328_extend_actionlog_bbb_tiki.sql', '21.12', 0),
('713be777dbc04c700f52e7e8dfa0625b', './installer/schema/20130410_keep_wysiwyg_htmltowiki_setting_tiki.php', '21.12', 0),
('58a924f2a7c8e71ca454cfce8e8e17ba', './installer/schema/20130415_repair_file_galleries_again_tiki.php', '21.12', 0),
('a6dc788402261b5ad7f8dc457a519d38', './installer/schema/20130417_score_alter_tiki.sql', '21.12', 0),
('1548a7f6c0f3e048a2d9cff98040430e', './installer/schema/20130417_score_tiki.sql', '21.12', 0),
('2ec218efe4d675718cb4874068bcb483', './installer/schema/20130419_newsletters_clippings_tiki.sql', '21.12', 0),
('2d06340fb1c30b84af798895adf0ffc9', './installer/schema/20130513_convert_tracker_field_parameters_tiki.php', '21.12', 0),
('06c8be2f743dd4a2a13a7a0a364abbc3', './installer/schema/20130530_category_log_tiki.sql', '21.12', 0),
('ccfa5273eda1b232f21b778e00ddfc2a', './installer/schema/20130530_tracker_modification_log_tiki.sql', '21.12', 0),
('362b275807bed067759ba6fb1502cf15', './installer/schema/20130605_mailin_show_inline_tiki.sql', '21.12', 0),
('6f6945a8092cae1c0a663ea8a915770d', './installer/schema/20130606_mailin_add_categoryId_tiki.sql', '21.12', 0),
('27fccffbe3538e684c59887872ab7cfe', './installer/schema/20130608_convert_mailin_pwd_tiki.php', '21.12', 0),
('810b71aa0c0166b64f8f27194511fb83', './installer/schema/20130608_mailin_response_tiki.sql', '21.12', 0),
('b5732bd4a0ea92ba019ca86d43a66d63', './installer/schema/20130611_mailin_add_html_tiki.sql', '21.12', 0),
('15de188ed2b8dbb2239e575b1150e0a3', './installer/schema/20130614_mailin_add_admin_tiki.sql', '21.12', 0),
('8c1977cb799881db7f7d87c4ec260f99', './installer/schema/20130616_mailin_add_namespace_tiki.sql', '21.12', 0),
('27dcd7e053d46f8f03c8236b40381841', './installer/schema/20130623_create_mailin_user_struct_tiki.sql', '21.12', 0),
('2d3d0193bdd38bfe398eca12b4263a86', './installer/schema/20130624_mailin_add_attr_tiki.sql', '21.12', 0),
('22381e5220531fc9df24b9a92f1d3f9e', './installer/schema/20130704_catname_tiki.sql', '21.12', 0),
('3927bb8ba89cef57e6679b080295d62d', './installer/schema/20130705_activity_stream_tiki.sql', '21.12', 0),
('5cd63d71a596f99fde4c47176211bca1', './installer/schema/20130715_activity_stream_rules_tiki.sql', '21.12', 0),
('b0c92047743ffa0882fd6d9638b60428', './installer/schema/20130730_friendship_conversion_tiki.sql', '21.12', 0),
('eb1b580c76058e9ac1ed6a20c7acfa2d', './installer/schema/20130730_wiki_para_format_default_change_tiki.php', '21.12', 0),
('84749f29101065dcf614f762739df1f1', './installer/schema/20130807_tracker_files_display_param_change_tiki.php', '21.12', 0),
('790af95b261d76070062329e68ce0a4a', './installer/schema/20130809_limit_name_lengths_in_objects_tiki.php', '21.12', 0),
('31334949f0ce1de52c3f6a93a28fe43c', './installer/schema/20131007_menus_items_missing_icons_tiki.sql', '21.12', 0),
('571ae86418cc31331bb0021296349765', './installer/schema/20131108_mytiki_add_mailin_tiki.sql', '21.12', 0),
('338976e3c921542932d05cc625f71b99', './installer/schema/20131117_unified_engine_default_change_tiki.php', '21.12', 0),
('7af33fcf95367728c63029bbdb3eb78f', './installer/schema/20131218_stored_queries_tiki.sql', '21.12', 0),
('818b79ae45f7ed853c70c0ecb19e7c46', './installer/schema/20131231_add_sheet_metadata_tiki.sql', '21.12', 0),
('5d4970d01862e922d6ffda13229d4fe9', './installer/schema/20140109_query_unique_name_tiki.sql', '21.12', 0),
('7bcd2c028606a9a113d75c2507b8de38', './installer/schema/20140117_monitor_tiki.sql', '21.12', 0),
('1e08c3fc2c93915f8b3a631a3d26044d', './installer/schema/20140129_bigger_target_monitor_tiki.sql', '21.12', 0),
('1c47a37146f38292f1d968bfef47ebb8', './installer/schema/20140203_menu_item_and_icon_user_wizard_tiki.sql', '21.12', 0),
('ce1c7d411fae4b462bed93d9ac6a5a95', './installer/schema/20140206_add_parser_column_tiki.sql', '21.12', 0),
('edde062c490700faca572aaabf77cb52', './installer/schema/20140210_user_wizard_add_section_name_tiki.sql', '21.12', 0),
('46a7dcca1dda0c9c09a99c8de2d981fa', './installer/schema/20140214_goals_tiki.sql', '21.12', 0),
('9688ec355cfd340c37c15580966c2cce', './installer/schema/20140219_full_goal_events_tiki.sql', '21.12', 0),
('d6e3d03ba7405a447f4d3fd47f0ce4aa', './installer/schema/20140301_add_column_rating_choice_topic_on_forums_tiki.sql', '21.12', 0),
('8ab2629b201dc667190659d2fc0d3c02', './installer/schema/20140318_user_wizard_add_groupname_tiki.sql', '21.12', 0),
('44d633f4dfefff02d3a54fda12a86304', './installer/schema/20140402_mailin_protocol_option_tiki.sql', '21.12', 0),
('9fcb77f139414164845c0f9117748905', './installer/schema/20140402_payment_authorization_tiki.sql', '21.12', 0),
('c8cbc000d5875cc0a92f7953db4797fe', './installer/schema/20140402_remove_mailin_smtp_tiki.sql', '21.12', 0),
('664417ce11b34798af188c68990f9782', './installer/schema/20140509_rss_add_categories_tiki.sql', '21.12', 0),
('dd9a3fc5e45cf923014c6798b659969b', './installer/schema/20140625_survey_tiki.sql', '21.12', 0),
('f0548c3fc6b7af6aacb96bfd593540b9', './installer/schema/20140705_page_slug_tiki.php', '21.12', 0),
('e8434febe415828ffc72641e5b2013b3', './installer/schema/20140705_page_slug_tiki.sql', '21.12', 0),
('7500c5dfb3f24af214a04dfddc30d94f', './installer/schema/20140807_federated_search_tiki.sql', '21.12', 0),
('c76057be626bb736adb3247c5d95df0b', './installer/schema/20140812_convert_tiki_connect_data_to_json_tiki.php', '21.12', 0),
('e3072df61eae0c85a320d3c66983fbab', './installer/schema/20140914_addon_profiles_tiki.sql', '21.12', 0),
('4235f48e190a893a4deb146e332bb25b', './installer/schema/20141003_change_style_pref_to_theme_tiki.php', '21.12', 0),
('b570b04882abe860e483717f508a4424', './installer/schema/20141106_menu_configuration_panel_tiki.sql', '21.12', 0),
('722ef80e1f2641b33d0c51930cda0439', './installer/schema/20141114_remove_babelfish_tiki.sql', '21.12', 0),
('dc313abcc4768c0659d7d92c9332b89b', './installer/schema/20141120_tracker_tabular_tiki.sql', '21.12', 0),
('1c4726c7c1398af65801e1e79b66049f', './installer/schema/20141122_change_prefname_availblestyles_to_availablethemes_tiki.sql', '21.12', 0),
('109233b6947f5095378ea739f554ecde', './installer/schema/20141125_menu_control_panels_tiki.sql', '21.12', 0),
('810f09f5a3711abf92c3e4976f9807fd', './installer/schema/20150109_tabular_filters_tiki.sql', '21.12', 0),
('58c344c5452911759d101ad286b68d7d', './installer/schema/20150112_theme_option_etc_tiki.sql', '21.12', 0),
('1eee7b39a4687be425eeb55a590d8d22', './installer/schema/20150203_add_menu_option_class_tiki.sql', '21.12', 0),
('975871b45b1c2c9d8e493e3b3d0cdaaa', './installer/schema/20150310_rename_freetags_in_menu_42_tiki.sql', '21.12', 0),
('fb48dee14b960d1d7c48a08a85ef7fc8', './installer/schema/20150310_rename_mytiki_in_menu_42_tiki.sql', '21.12', 0),
('2d346e27c91070cc840b7dab52504a0f', './installer/schema/20150327_tracker_showPopup_option_fix_tiki.sql', '21.12', 0),
('8e032a195dac36d92fdbeaf0aecfd85e', './installer/schema/20150414_profile_symbol_tooshort_fix_tiki.sql', '21.12', 0),
('fc3c6bd5ed7353f96f36fa1fe9c318b1', './installer/schema/20150426_menu_item_external_wikis_restored_tiki.sql', '21.12', 0),
('b28c5e96da77f2c4b9a0de8802daa3c8', './installer/schema/20150508_perspectives_style_to_theme_tiki.php', '21.12', 0),
('bd25949296c7ceaf65935eb8530c73c6', './installer/schema/20150730_menu_item_tabular_trackers_tiki.sql', '21.12', 0),
('ffb42720a6dd9ba8670b6bacaf35eb84', './installer/schema/20150901_prefname_char_length_tiki.sql', '21.12', 0),
('7fae5fdf9dcc1a2446e7d930bbc0fdfe', './installer/schema/20150929_make_hotwords_longer_tiki.sql', '21.12', 0),
('2afddf6d23449b961d9c97ec5125a3fc', './installer/schema/20151203_tiki_score_revamp_tiki.sql', '21.12', 0),
('0b0ac54a682f34d94dddc4505b328c7f', './installer/schema/20151203_tokens_create_user_tiki.sql', '21.12', 0),
('5468fa2c97256a0f7fb4c92251f7b880', './installer/schema/20160120_remove_gmap_menu_item_tiki.sql', '21.12', 0),
('381f850f916bceec588cda286a9361be', './installer/schema/20160201_remove_maps_menus_tiki.sql', '21.12', 0),
('6647ca98d6677dbfe4f2c096488e1c88', './installer/schema/20160206_theme_option_modules_tiki.sql', '21.12', 0),
('d767fe6ea302cb082eb0a2e91a024b23', './installer/schema/20160315_correct_blogpost_encoding_tiki.sql', '21.12', 0),
('ea2f7fb91e7fde0d126e2221f16cb7f0', './installer/schema/20160325_menu_42_list_pages_tiki.sql', '21.12', 0),
('8cc364ddb16d2f13d019c3eacd1ff66b', './installer/schema/20160420_correct_blogpost_encoding_tiki.sql', '21.12', 0),
('12fe008b7f0546d15f76f80aacf97e16', './installer/schema/20160519_calendar_events_action_log_tiki.sql', '21.12', 0),
('861d7ba1007a5553f7df989ff948be5c', './installer/schema/20160527_menu_item_payment_tiki.sql', '21.12', 0),
('38de3de2f754d98b06b623c3c8d39971', './installer/schema/20160604_remove_unwanted_files_tiki.php', '21.12', 0),
('8cc8de59f71262e6a1f99d927b79aaba', './installer/schema/20160608_menu_item_admin_tokens_tiki.sql', '21.12', 0),
('c949f7ae51ac122ccff013162fcd8287', './installer/schema/20160612_new_password_implementation_tiki.sql', '21.12', 0),
('f83941959cbe9067a082cf26e1043c4f', './installer/schema/20160612_remove_feature_challenge_pref_tiki.sql', '21.12', 0),
('adc07b416a815a8f03874198fd656d13', './installer/schema/20160614_clear_password_removal_tiki.sql', '21.12', 0),
('e3a81f9aeedc555b5a2d7d213fa1928c', './installer/schema/20160627_remove_more_unwanted_files_tiki.php', '21.12', 0),
('732cd5399fe8ad8588235f81ba8c792e', './installer/schema/20160817_fix_dymanic_list_field_values_tiki.php', '21.12', 0),
('1da67a00b23b4a9260bf2c3aab4a7505', './installer/schema/20160914_extwiki_missing_columns_fix_tiki.php', '21.12', 0),
('e989dbbf57a7bf4951f0abb97563fec0', './installer/schema/20160915_extwiki_indexname_length_tiki.sql', '21.12', 0),
('aefb27a79a9a007fb3532db28ca55bb9', './installer/schema/20161109_remove_old_password_tiki.php', '21.12', 0),
('eee4743d39b2312e6ecff75c92a69d9a', './installer/schema/20161117_favicon_tiki.sql', '21.12', 0),
('c11ab00fb5536582645af47d2e8f365b', './installer/schema/20161206_larger_comment_field_tiki.sql', '21.12', 0),
('325ae75b34911521780c74ed7568459e', './installer/schema/20161220_add_h5p_tables_tiki.sql', '21.12', 0),
('240ba47520a7acce828f0bf6cef8ab7c', './installer/schema/20170122_schedulers_tiki.sql', '21.12', 0),
('d51b6f0939b1cc406495907648400655', './installer/schema/20170127_remove_templates_c_tiki.php', '21.12', 0),
('fd2258f8a39b5169741c2099d4b03817', './installer/schema/20170129_feature_dump_tiki.sql', '21.12', 0),
('c8a60d8cdfb3565b69127ae54d04da0a', './installer/schema/20170207_iefix_rem_tiki.sql', '21.12', 0),
('f84913f95963a58e47c93c2739f283f3', './installer/schema/20170213_footnotearea_tiki.sql', '21.12', 0),
('7e9a23984ebda395c2d649295bdc338c', './installer/schema/20170218_schedulers_menu_tiki.sql', '21.12', 0),
('60263c47c43b093a7c136d13181ecd9c', './installer/schema/20170305_webservices_menu_tiki.sql', '21.12', 0),
('8edbc1084b547b63c6f78494fdf6be9f', './installer/schema/20170307_kill_wikilingo_tiki.sql', '21.12', 0),
('d94c2fd4462b9645a41586c87af072da', './installer/schema/20170319_kill_jcapture_tiki.sql', '21.12', 0),
('9ed43fbdc01e8c73bd2e7ee263f10b21', './installer/schema/20170322_fix_allocate_memory_prefs_tiki.sql', '21.12', 0),
('c00631e32fd03059c5eef945f7863763', './installer/schema/20170329_add_color_to_groups_tiki.sql', '21.12', 0),
('4438e6ee090276c2075c8bfc957e1491', './installer/schema/20170329_larger_category_descriptions_tiki.sql', '21.12', 0),
('23f4d598463814df65c646ac33611f49', './installer/schema/20170330_merge_hiddenlinks_into_headinglinks_tiki.sql', '21.12', 0),
('2fd39ce818ff806b5278a6dbf5140802', './installer/schema/20170427_update_accounting_journal_cols_tiki.sql', '21.12', 0),
('08e0d74ea36e315296ef16f3d29a4d63', './installer/schema/20170531_feature_usability_tiki.sql', '21.12', 0),
('6a10646d08ded550f49800b7b5014fed', './installer/schema/20170628_schedulers_menu_tiki.sql', '21.12', 0),
('e2be2c76a255001bcc9e8fd4357369a8', './installer/schema/20170702_wiki_url_scheme_pref_default_tiki.php', '21.12', 0),
('f231e615d2a51fbfa426a9244d6a73a8', './installer/schema/20170717_add_missing_trackeritem_attachment_backlinks_tiki.php', '21.12', 0),
('f266609ceac80f0c53c24145a7c45a21', './installer/schema/20170726_remove_article_hashes_tiki.sql', '21.12', 0),
('7900f8cb0da7eefc44e333004c55f701', './installer/schema/20170726_tabular_config_tiki.sql', '21.12', 0),
('5c7fdeca3bec2b10dba0756b877839be', './installer/schema/20170829_custom_routes_tiki.sql', '21.12', 0),
('8bda31c0d04c361263cda1c39944199c', './installer/schema/20170920_admin_webservices_menu_option_tiki.sql', '21.12', 0),
('ad273fb8a3de46ecb514f2e7d94736e4', './installer/schema/20170925_add_general_to_language_tiki.sql', '21.12', 0),
('d14ab7413cc7dd0ab9511af079b707cf', './installer/schema/20170930_custom_routes_menu_tiki.sql', '21.12', 0),
('876555c041bae9e5e061c7adb8a6bd24', './installer/schema/20171002_queue_handler_size_increase_tiki.sql', '21.12', 0),
('185f87362504350e5d4bcca21df607d3', './installer/schema/20171010_action_log_info_new_column_tiki.php', '21.12', 0),
('e1dc61fd0edcf7b795afe10f2ef0004a', './installer/schema/20171016_no_homepage_specificed_tiki.php', '21.12', 0),
('e697c75333377694f06c1328ffb26758', './installer/schema/20171121_create_plugin_include_relations_tiki.php', '21.12', 0),
('f4abc334a722098ff7aba542ed26c7ce', './installer/schema/20171122_h5p_update_add_hub_table_tiki.sql', '21.12', 0),
('11662e10f799ef9e3bf5348746c8b1ce', './installer/schema/20171123_create_object_links_tiki.php', '21.12', 0),
('d99b0b8efaed59d28bc42cd06c16a011', './installer/schema/20171129_backlinks_for_object_types_admin_options_tiki.sql', '21.12', 0),
('66cbeb1c9c5d27862ca5888ea0071aec', './installer/schema/20171130_plugin_include_link_original_tiki.sql', '21.12', 0),
('c622a5feed33323862aa6f2dc164f5da', './installer/schema/20171204_update_geo_enabled_tiki.sql', '21.12', 0),
('fdf500b3ad5aa5eb8c0cbe2666d36f5d', './installer/schema/20171231_add_short_url_tiki.sql', '21.12', 0),
('75ab724a0ed998cf5c03f8c20b6ba543', './installer/schema/20180228_comment_on_object_attributes_tiki.sql', '21.12', 0),
('45b5c210f7fefa7873401d3cb6024ff6', './installer/schema/20180331_rename_custom_route_object_type_tiki.sql', '21.12', 0),
('03b5cd52cdbfc264e8432645d2e3d51d', './installer/schema/20180405_custom_routes_menu_tiki.sql', '21.12', 0),
('0a5cb5a13d80bf5690eb982dc5904cac', './installer/schema/20180405_remove_unused_user_id_tiki.sql', '21.12', 0),
('2916e6d252bff3494aa2789949963656', './installer/schema/20180410_install_piwik_plugin_tiki.php', '21.12', 0),
('6ba406554a14d2fddad4c069f0dc2ed2', './installer/schema/20180411_schedulers_change_column_to_text_tiki.sql', '21.12', 0),
('52e9f72e43040b23b489ea44c43ee32e', './installer/schema/20180412_rename_short_url_prefs_tiki.sql', '21.12', 0),
('733dc3217ef761090477e9413426cb79', './installer/schema/20180419_scheduler_run_stalled_column_tiki.sql', '21.12', 0),
('cd428c5756b4f05ea6b764f0cf1a28c9', './installer/schema/20180421_scheduler_run_healed_column_tiki.sql', '21.12', 0),
('eed54e26fdc4867a1c59784aaa835f73', './installer/schema/20180503_fix_throttled_newsletters_tiki.sql', '21.12', 0),
('526019e79ad1a4415c61928c042d4c0d', './installer/schema/20180609_change_log_column_type_tiki.sql', '21.12', 0),
('751120c011c1c4de4f1578b271e6d4b9', './installer/schema/20180625_user_reports_null_last_reports_tiki.sql', '21.12', 0),
('bc86aa555cffced621d949868afdf7b2', './installer/schema/20180705_fix_calendaritem_tracker_attributes_tiki.sql', '21.12', 0),
('31991df8d0082922a07ed84d2776e862', './installer/schema/20180706_remove_menu_reports_tiki.sql', '21.12', 0),
('812e2e73e30215f18b64b95bd03763a2', './installer/schema/20180803_semaphore_value_tiki.sql', '21.12', 0),
('4f18a0947aea64a264a0d591bb25c871', './installer/schema/20180808_ocr_tiki.sql', '21.12', 0),
('248fb02673aed57936068d21e55ca3d0', './installer/schema/20180815_merge_topic_read_perm_tiki.sql', '21.12', 0),
('3c2bad543cb7a0a240d301977a65b7ea', './installer/schema/20180909_remove_page_content_fetch_readability_tiki.sql', '21.12', 0),
('04f3233604e34ed46c3a0596baf160d6', './installer/schema/20180918_remove_poweredby_module_tiki.sql', '21.12', 0),
('abd4a5c1d1c03f0ac6a8b21fa262394e', './installer/schema/20180921_php_upgrade_fix_from_older_tiki.php', '21.12', 0),
('ecd3ae9eb0ca11ca3ec63059462a47d7', './installer/schema/20180921_sql_upgrade_fix_from_older_tiki.php', '21.12', 0),
('b9cb8082f40f99750aac915ce93ae396', './installer/schema/20180923_convert_collation_to_utf8mb4_tiki.php', '21.12', 0),
('8ce7d838c1210818cec7467301c4f2bd', './installer/schema/20180925_feature_jquery_superfish_pref_default_tiki.php', '21.12', 0),
('29317c82da0d406663cba29d46a5d041', './installer/schema/20181114_ocr_uff8mb4_tiki.sql', '21.12', 0),
('288c05f1e479dd9687a9d57c186c2c3c', './installer/schema/20181127_convert_db_local_to_utf8mb4_tiki.php', '21.12', 0),
('9d9161bd99ebf5430f3f1e4278117e0e', './installer/schema/20181130_update_column_name_size_tracker_table_tiki.sql', '21.12', 0),
('2531e2b1a80dc003cfd1a2d94cd64d9e', './installer/schema/20190117_create_oauthserver_clients_table_tiki.sql', '21.12', 0),
('67b1a038054ed146c2766265d99e0646', './installer/schema/20190121_h5p_add_new_library_fields_tiki.sql', '21.12', 0),
('7104ef096f1b22dde38c0c4f2f48f956', './installer/schema/20190121_h5p_allow_null_in_filtered_tiki.sql', '21.12', 0),
('48034610340ed22f5a1f50c946c2ab13', './installer/schema/20190123_h5p_move_storage_assets_to_new_dir_tiki.php', '21.12', 0),
('2227b432b39b2361a08ed85c78b73074', './installer/schema/20190129_fix_ambiguity_on_oauthserver_id_column_tiki.php', '21.12', 0),
('068ca01a57fba854eba3ad536530310e', './installer/schema/20190226_change_xmpp_auth_pref_name_tiki.sql', '21.12', 0),
('b2d09fb8cf6362a66e4e7ff0c0434f38', './installer/schema/20190303_make_tiki_object_href_larger_tiki.sql', '21.12', 0),
('6e0be312d346770a1f4005b8e234b9d7', './installer/schema/20190401_add_support_database_strict_mode_tiki.sql', '21.12', 0),
('1c10cd737040087392e064baddbf25f1', './installer/schema/20190425_add_creation_date_schedule_tiki.sql', '21.12', 0),
('d04b6b793c0e1dbd723cea8b102966cf', './installer/schema/20190425_set_creation_date_to_scheduler_tiki.php', '21.12', 0),
('0865b5fc477aececc6513ae19494a5d5', './installer/schema/20190523_migrate_webmail_accounts_tiki.php', '21.12', 0),
('e4ac9a8109622ea18809c642ad6d26a4', './installer/schema/20190526_remove_tiki_addon_profiles_tiki.sql', '21.12', 0),
('5f29fd9203816d46e921ab28826f4f16', './installer/schema/20190620_add_role_groups_tiki.sql', '21.12', 0),
('871e967e4e8268ec69b096f78b4e1dbd', './installer/schema/20190627_add_ocr_fgal_status_tiki.sql', '21.12', 0),
('eb215c708c3a33bb7ffcdccb6a88846d', './installer/schema/20190717_add_role_categ_available_tiki.sql', '21.12', 0),
('21fadc155ab35853f7affe28b2422af7', './installer/schema/20190722_ocr_fgal_tiki.sql', '21.12', 0),
('dfe176e17549e7ae7bd54ac28ba5f0ac', './installer/schema/20190723_add_is_tlp_group_tiki.sql', '21.12', 0),
('b197a50f75f1d7fa998caecc6725b790', './installer/schema/20190729_add_tlp_group_category_tiki.sql', '21.12', 0),
('35808972cf4a216c0e90f482254e8181', './installer/schema/20190831_add_two_factor_secret_tiki.sql', '21.12', 0),
('de8db997d574a7afe9a8a54ca76c0c04', './installer/schema/20190913_caldav_tiki.sql', '21.12', 0),
('6c411e8725a9b696bb7db7a9a730b53d', './installer/schema/20190925_caldav_updates_tiki.sql', '21.12', 0),
('b5a5fb647b0291834f8bf0c4925ad7db', './installer/schema/20191114_caldav_recurring_updates_tiki.sql', '21.12', 0),
('1a16b25a33696e1b9dcc4121f7611ea0', './installer/schema/20191116_scheduler_run_only_once_tiki.sql', '21.12', 0),
('2b041737a62a9abc30ee7065db8c8f54', './installer/schema/20191126_add_forum_parent_tiki.sql', '21.12', 0),
('a62a38886e82131fb641d09d773bd1d6', './installer/schema/20191218_carddav_tiki.sql', '21.12', 0),
('c61977bd122475c05d7118b53143fab1', './installer/schema/20200113_tracker_field_rules_column_tiki.sql', '21.12', 0),
('4399d43e24d437313364a3cfb23f7016', './installer/schema/20200123_calendar_rsvp_tiki.sql', '21.12', 0),
('fc8fd4b751dac80a6a02ba1a227b8b85', './installer/schema/20200126_remove_invoice_menu_options_tiki.sql', '21.12', 0),
('946a4955c0fa0fc04de07ea80d5bc2d6', './installer/schema/20200309_fix_sefurl_regex_out_issues_tiki.sql', '21.12', 0),
('79235d26670fd6216d745318aa090320', './installer/schema/20200513_expand_sessions_data_column_tiki.sql', '21.12', 0),
('e9454bb8f0bd53b05d127004bc996fb5', './installer/schema/20200614_expand_mail_queue_message_column_tiki.sql', '21.12', 0),
('90d90db44a3efcddad9e69f2f7df4a0a', './installer/schema/20200710_feature_templated_groups_tiki.php', '21.12', 0),
('6378e0b162580584a084a5287e5d1f20', './installer/schema/20201024_h5p_add_a11y_title_tiki.sql', '21.12', 0),
('783f6534bf5f806b4d963bb5634970a0', './installer/schema/20201024_h5p_add_default_lang_tiki.sql', '21.12', 0),
('aeb851095f17c5a570ebd944c5a716a0', './installer/schema/20201212_remove_comment_hash_tiki.sql', '21.12', 0),
('fea269d780e2f2cd1e8791124d12c1fb', './installer/schema/20210410_alter_activity_stream_arguments_column_tiki.sql', '21.12', 0),
('1c3c041fe552a3f777254591a5a74f03', './installer/schema/20230125_add_goalid_to_credits_tiki.sql', '21.12', 0),
('033babdf1b3bb8c93a27e5d0d768f8d0', './installer/schema/20230504_add_attemps_on_tiki_banning_tiki.sql', '21.12', 0),
('62aef516def26d05e0780fa9d91a560f', './installer/schema/999999991_decode_pages_sources_tiki.php', '21.12', 0),
('9330e96f81d51679d0db723e06a0c63e', './installer/schema/99999999_image_plugins_kill_tiki.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './installer/schema/index.php', '21.12', 0),
('c358133ceec10ffdb63971f42a3e72b7', './installer/schema/optional_20170801_initialize_article_nbreads_tiki.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './installer/script/index.php', '21.12', 0),
('1c0b939c5c8e2a3412e8101f3d8ebc6a', './installer/shell.php', '21.12', 0),
('957a029bb6bfbc94ea8d968a874e25d4', './installer/tiki-installer.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ar/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/ar/language.js', '21.12', 0),
('6b88bbc42029e470aa1055a5af258ff5', './lang/ar/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/bg/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/bg/language.js', '21.12', 0),
('1a69868eabec3d6fea6f7d7cd40b5641', './lang/bg/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ca/index.php', '21.12', 0),
('1cf4fda8199320994c98fd4df4b5a503', './lang/ca/language.js', '21.12', 0),
('60bf9174cfa9d6668a68e4bbfc8bf66f', './lang/ca/language.php', '21.12', 0),
('89260e200eb9cd3b9674e6164328fd4e', './lang/ca/language_r.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/cn/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/cn/language.js', '21.12', 0),
('e47353c15d980c0a91cfcac9a2c24b32', './lang/cn/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/cs/index.php', '21.12', 0),
('48f9529d7208b366e0233f616b2cd375', './lang/cs/language.js', '21.12', 0),
('117678f849a631ca7ec8c11c0323b7a0', './lang/cs/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/cy/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/cy/language.js', '21.12', 0),
('5f4dca17fd65a484d27ab176a42af1cc', './lang/cy/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/da/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/da/language.js', '21.12', 0),
('f0a1182c98054cd94f23a4c6114b132e', './lang/da/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/de/index.php', '21.12', 0),
('fa1d7523a19ebc5371a20930f68d900e', './lang/de/language.js', '21.12', 0),
('643d7f07ef4ef2251b522bb15a584be3', './lang/de/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/el/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/el/language.js', '21.12', 0),
('6dea1f31748885de5e21792fe0fb79a1', './lang/el/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/en-uk/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/en-uk/language.js', '21.12', 0),
('27c87d4a67d1d24882a0657d7d1d02c9', './lang/en-uk/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/en/index.php', '21.12', 0),
('a85d4e2ee3280711a928c2db57898908', './lang/en/language.js', '21.12', 0),
('11b89f204f3f3b2f1dbff5ebf0256f24', './lang/en/language.php', '21.12', 0),
('89260e200eb9cd3b9674e6164328fd4e', './lang/en/language_r.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/es/index.php', '21.12', 0),
('835c916c0807fa69f460c94d47794819', './lang/es/language.js', '21.12', 0),
('d521d5f195e2aabb14c227df35db574b', './lang/es/language.php', '21.12', 0),
('2e0ec59a4ff14097eb984286734bf3a5', './lang/es/language_r.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/fa/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/fa/language.js', '21.12', 0),
('ca4dc8ff642b43a607c833760fb0a323', './lang/fa/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/fi/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/fi/language.js', '21.12', 0),
('e5cee05dc5c588af3201014ee93c26c6', './lang/fi/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/fj/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/fj/language.js', '21.12', 0),
('d9782db061a8d1011d59bb821073c1a6', './lang/fj/language.php', '21.12', 0),
('b165df5cc2b7dd7f543175a8043b63f8', './lang/flagmapping.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/fr/index.php', '21.12', 0),
('3b25d7af3db63ee146b7b4766aadf680', './lang/fr/language.js', '21.12', 0),
('95fddd1441a65387dd3359174de17b8a', './lang/fr/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/fy-NL/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/fy-NL/language.js', '21.12', 0),
('8022db37dc5b4172e5475901686764d7', './lang/fy-NL/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/gl/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/gl/language.js', '21.12', 0),
('7e20b006807ca6569a9b009784438be3', './lang/gl/language.php', '21.12', 0),
('1e8c87e847e5acebebc32028743e379f', './lang/he/custom.php_example.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/he/index.php', '21.12', 0),
('63631771c735f1f2568b6f4457b00455', './lang/he/language.js', '21.12', 0),
('a16bd4394d1bfbdac11683949fbb8711', './lang/he/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/hr/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/hr/language.js', '21.12', 0),
('acd3ee83c4b85db45aa807d05ec5b57a', './lang/hr/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/hu/index.php', '21.12', 0),
('20210c47d72d167c23f9d2dc8fc4be7a', './lang/hu/language.js', '21.12', 0),
('a0d17bb826f317fc680df43d01c41a4f', './lang/hu/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/id/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/id/language.js', '21.12', 0),
('84dc1feb721fe36aa9113ab412630362', './lang/id/language.php', '21.12', 0),
('13e577a09b6f1e001d6c196f86b7eba5', './lang/index.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/is/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/is/language.js', '21.12', 0),
('863a464468ca5dc56474be739fd58a8e', './lang/is/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/it/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/it/language.js', '21.12', 0),
('a4bc02c01d06dc1b30ccb47e248d2254', './lang/it/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/iu-iq/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/iu-iq/language.js', '21.12', 0),
('d7f4042aa83e5bff7a206a299bcffb80', './lang/iu-iq/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/iu-ro/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/iu-ro/language.js', '21.12', 0),
('d7f4042aa83e5bff7a206a299bcffb80', './lang/iu-ro/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/iu/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/iu/language.js', '21.12', 0),
('b39d44bf29dc8a85eb99ec5aef495c11', './lang/iu/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ja/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/ja/language.js', '21.12', 0),
('07b9cd41e3528e61773b0982aa44430f', './lang/ja/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ko/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/ko/language.js', '21.12', 0),
('9434d20507d0050f96bb4f9cc8a0403b', './lang/ko/language.php', '21.12', 0),
('0af5590dfbaaa996b47ff31930a51fd8', './lang/langmapping.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/lt/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/lt/language.js', '21.12', 0),
('47a7aa7b2c7809912ded5e356c89e16c', './lang/lt/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/nds/index.php', '21.12', 0),
('e15e69dc5eca771f46207b0711eda859', './lang/nds/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/nl/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/nl/language.js', '21.12', 0),
('51c229b2c996350f923e18737daf7596', './lang/nl/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/no/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/no/language.js', '21.12', 0),
('7ab95ddf2b11d2c0e1c2b2dccd619819', './lang/no/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/pl/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/pl/language.js', '21.12', 0),
('e718ac5d2a9674750476ca9d0096c653', './lang/pl/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/pt-br/index.php', '21.12', 0),
('e2964f2251cc945b9153eb3a27ea6400', './lang/pt-br/language.js', '21.12', 0),
('106abe51fb3419e06f70373f4e5d0192', './lang/pt-br/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/pt/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/pt/language.js', '21.12', 0),
('0002552674c20d88ee532324e65481b9', './lang/pt/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/rm/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/rm/language.js', '21.12', 0),
('6964091c7cf6e632796ce25c0bf5042c', './lang/rm/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ro/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/ro/language.js', '21.12', 0),
('87900591f373f59304e39615f4357601', './lang/ro/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ru/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/ru/language.js', '21.12', 0),
('dc8c537f83fcb8ea7140151520893a1f', './lang/ru/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sb/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sb/language.js', '21.12', 0),
('bc283a1f37b5344e34e36651b15cdeae', './lang/sb/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/si/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/si/language.js', '21.12', 0),
('86872137ae8c33d0dc4bc56829be8c0b', './lang/si/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sk/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sk/language.js', '21.12', 0),
('f2a901c987eed77340ba9e0dd7ee2129', './lang/sk/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sl/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sl/language.js', '21.12', 0),
('a3f14647954e21552b96f5a833c40067', './lang/sl/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sq/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sq/language.js', '21.12', 0),
('e8be6b9e86a6c6ce9a0822ed1f77d7a4', './lang/sq/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sr-latn/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sr-latn/language.js', '21.12', 0),
('eb4e3c8479d503b9d15364a0abc097de', './lang/sr-latn/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sv/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sv/language.js', '21.12', 0),
('e1480745d1beaf34b823c81b4091bc74', './lang/sv/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/sw/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/sw/language.js', '21.12', 0),
('c89523ca0aec99360fcc14fb2b76591d', './lang/sw/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/th/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/th/language.js', '21.12', 0),
('09791468d22d1b3a8f090771061beca4', './lang/th/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/tr/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/tr/language.js', '21.12', 0),
('30f290a47995213495160df35ca63684', './lang/tr/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/tv/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/tv/language.js', '21.12', 0),
('c259b6b98cd96dc8d8966bb6b6235fd4', './lang/tv/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/tw/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/tw/language.js', '21.12', 0),
('4c4bf14845e8089fb2420dbc11c713fa', './lang/tw/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/uk/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/uk/language.js', '21.12', 0),
('79c7624f4ed4ed386cb15c2b52480453', './lang/uk/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/ur/index.php', '21.12', 0),
('a808f8bc4db23af28696da932629441f', './lang/ur/language.js', '21.12', 0),
('4216ad68d1e36e8d3c9ff9b37c5f891f', './lang/ur/language.php', '21.12', 0),
('73df6f54edfd0d2827eb282fc7e93049', './lang/vi/index.php', '21.12', 0),
('d1c756dc49170033b15eef6bbcfec46a', './lang/vi/language.js', '21.12', 0),
('51d190b22900e2ae35df296b8a1f0822', './lang/vi/language.php', '21.12', 0),
('a0d68ae403b4424c387209c647ab2547', './lib/Alchemy/AlchemyLib.php', '21.12', 0),
('a71d728d6c906640d0638e91598f6685', './lib/Alchemy/Guesser.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/Alchemy/index.php', '21.12', 0),
('b5214fffad68238dd1e20048c44ce549', './lib/Image/Gd.php', '21.12', 0),
('0add1f09fae6ba8188664ff132dfb639', './lib/Image/Image.php', '21.12', 0),
('450405b6d58384ece35eea8410846872', './lib/Image/ImageAbstract.php', '21.12', 0),
('5c76f6c182da6202874d9157bc716bee', './lib/Image/ImagickNew.php', '21.12', 0),
('36608613ab3a9f2e9ebffea327588784', './lib/Image/ImagickOld.php', '21.12', 0),
('d9c113051bbbf166ab38197f8390c10b', './lib/Image/img_plugin_default_and_mandatory.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/Image/index.php', '21.12', 0),
('e1d9d94bc0cc82247a8347afa63a578b', './lib/Unoconv/UnoconvLib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/Unoconv/index.php', '21.12', 0),
('c4e2e465951540f9d45a2652539e4420', './lib/accounting/accountinglib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/accounting/index.php', '21.12', 0),
('2aaefd33a3d908b00ae0bddbc3b9f894', './lib/activity/activitylib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/activity/index.php', '21.12', 0),
('fa7a0e6650c3653c2bf6695487028eaf', './lib/admin/adminlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/admin/index.php', '21.12', 0),
('d55e1527f68fb97b377a8245809b181d', './lib/ajax/autosave.js', '21.12', 0),
('89785ddc337dc028c0fdd8acda47d58f', './lib/ajax/autosave.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/ajax/index.php', '21.12', 0),
('7e29fad5d8db56b3e3cf8f3d2bd3e616', './lib/articles/artlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/articles/index.php', '21.12', 0),
('c095c4a56ae72a7dbfb306611194cc1e', './lib/attributes/attributelib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/attributes/index.php', '21.12', 0),
('764cd5011ab5db055a43df14c4c2f488', './lib/attributes/relationlib.php', '21.12', 0),
('9a24e237861b54df8de1ecb63bacdce9', './lib/auth/PasswordHash.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/auth/index.php', '21.12', 0),
('163ca2d1604e48683e5b21cf44df7a8e', './lib/auth/ldap.php', '21.12', 0),
('ed3ddfe20b04c5e1e248f4eb110dab35', './lib/auth/phpbb.php', '21.12', 0),
('072989cc1c727e87dec891b862427f88', './lib/auth/tokens.php', '21.12', 0),
('7148a5f672a2f09dea93918b80c27d40', './lib/avatarlib.php', '21.12', 0),
('85c3fd5cdc0331e7159e8b375954c79f', './lib/ban/banlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/ban/index.php', '21.12', 0),
('783b07010f77b4de80fd77e5cb6aaa14', './lib/banners/bannerlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/banners/index.php', '21.12', 0),
('0bbdc0f7d31de36d709e59c260bd6191', './lib/bigbluebuttonlib.php', '21.12', 0),
('a8303961180ea795c7a976bf4255390f', './lib/blogs/bloglib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/blogs/index.php', '21.12', 0),
('5bf008d177cbfefb875a4617eaf95b6e', './lib/bookmarks/bookmarklib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/bookmarks/index.php', '21.12', 0),
('57dfe9baf72af1bb685435917e0e6110', './lib/breadcrumblib.php', '21.12', 0),
('9ab30ef26c673f3470cad28e55a25e17', './lib/cache/cachelib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/cache/index.php', '21.12', 0),
('dd7a3b20cdfd7cb09ffd8c0a4e219a97', './lib/cache/memcachelib.php', '21.12', 0),
('2410ad5ad6902d83a080a2d04ee3f1e5', './lib/cache/redislib.php', '21.12', 0),
('cf60ddd9a2a64488f5e3f0e55e1a228f', './lib/calendar/calendarlib.php', '21.12', 0),
('2a494904dbcb7c807d4b770c336a7d3b', './lib/calendar/calrecurrence.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/calendar/index.php', '21.12', 0),
('70c68e7675ef487999cd3b5878bf79e2', './lib/calendar/tikicalendarlib.php', '21.12', 0),
('fe25d25f08a495da7347f596445b0c85', './lib/captcha/Captcha_Questions.php', '21.12', 0),
('8815d0c51e5472112c368a498e094b46', './lib/captcha/Captcha_ReCaptcha20.php', '21.12', 0),
('586a6ba60c0853065c745b5fc091571a', './lib/captcha/Captcha_ReCaptcha30.php', '21.12', 0),
('918a67cd4ed85c8ab7841c22a4f070c9', './lib/captcha/captchalib.js', '21.12', 0),
('03ed9f9a98123b57bf47d8d0734883af', './lib/captcha/captchalib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/captcha/index.php', '21.12', 0),
('534a131bae276829a4e37f8238811d4f', './lib/categories/categlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/categories/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/ckeditor_tiki/index.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/index.php', '21.12', 0),
('8ca8ee0f4f12aa4078c1e125237c817a', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/tikilink.js', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/ckeditor_tiki/plugins/_tikilink/index.php', '21.12', 0),
('019a5581e5d12021faad71b7ed6a875c', './lib/ckeditor_tiki/plugins/_tikilink/plugin.js', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/ckeditor_tiki/plugins/autosave/index.php', '21.12', 0),
('cd8928f19d0c3bd5d4c189f053eabdd5', './lib/ckeditor_tiki/plugins/autosave/plugin.js', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/ckeditor_tiki/plugins/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/ckeditor_tiki/plugins/inlinecancel/index.php', '21.12', 0),
('67a5261e7d1a654926c6f1392244e245', './lib/ckeditor_tiki/plugins/inlinecancel/plugin.js', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/ckeditor_tiki/plugins/inlinesave/index.php', '21.12', 0),
('230b3b3bc19c976e46fdb59363b71507', './lib/ckeditor_tiki/plugins/inlinesave/plugin.js', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/ckeditor_tiki/plugins/tikiplugin/index.php', '21.12', 0),
('8e786cee51c4f0659b06572ae4737870', './lib/ckeditor_tiki/plugins/tikiplugin/plugin.js', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/ckeditor_tiki/plugins/tikiwiki/index.php', '21.12', 0),
('e9908322b8eb4aa8b62ce23c69415ba5', './lib/ckeditor_tiki/plugins/tikiwiki/plugin.js', '21.12', 0),
('bc1ac28bd013e33cf87ff9f05f09b2c5', './lib/ckeditor_tiki/tiki-ckeditor.js', '21.12', 0),
('a9105bd06a7d52add769c21bd035ed03', './lib/ckeditor_tiki/tikilink_dialog.js', '21.12', 0),
('d1f8a78b2818b9cddaaefe70e7bdc7af', './lib/ckeditor_tiki/tikistyles.js', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('5af3d1bb0218380013ee46c85e4188ac', './lib/ckeditor_tiki/tikitemplates.js', '21.12', 0),
('140cac0133d49ccb0836f3e0bfb1616a', './lib/ckeditor_tiki/wysiwyglib.php', '21.12', 0),
('e0c76fdc7001e093eb8756739b86893b', './lib/codemirror_tiki/codemirror_tiki.js', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/codemirror_tiki/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/codemirror_tiki/mode/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/codemirror_tiki/mode/tiki/index.php', '21.12', 0),
('1f5ae82cf0ab3bcbcf90d9017fba4517', './lib/codemirror_tiki/mode/tiki/tiki.js', '21.12', 0),
('cf141b17654c508a68d352e233d585d1', './lib/codemirror_tiki/tiki_codemirror.php', '21.12', 0),
('f545d987050bf08c56ba6d0e6206898b', './lib/commcenter/commlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/commcenter/index.php', '21.12', 0),
('e44880054bd8f2c39960cab2c54fd7d3', './lib/comments/commentslib.js', '21.12', 0),
('1245ab9ffad5555b70a39f325b5f38d0', './lib/comments/commentslib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/comments/index.php', '21.12', 0),
('5ef16e0529c1734386fd14558931fc9f', './lib/contribution/contributionlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/contribution/index.php', '21.12', 0),
('b866b5b52465b953d06613d5b1d8ebfd', './lib/copyrights/copyrightslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/copyrights/index.php', '21.12', 0),
('9f4e714642c93f286f165aa5d328fe92', './lib/core/BOMChecker/Scanner.php', '21.12', 0),
('698e26e8bf1ff438f910a0ecc8de0712', './lib/core/Category/Manipulator.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Category/index.php', '21.12', 0),
('2c8d68559af9040a8280c9c18dfea8f0', './lib/core/CustomRoute/Controller.php', '21.12', 0),
('bb1d7f2f573e68af3993402ebfe254d1', './lib/core/CustomRoute/CustomRoute.php', '21.12', 0),
('3f9bd54a095f5a05eb67a42760152bed', './lib/core/CustomRoute/CustomRouteLib.php', '21.12', 0),
('3ca378cad16ff1a546d01445a7418e07', './lib/core/CustomRoute/Item.php', '21.12', 0),
('a5ec8d81ccbd08fdfcc56978b29eca48', './lib/core/CustomRoute/Type.php', '21.12', 0),
('468b2c40f1507b068b2758c16dbc7150', './lib/core/CustomRoute/Type/Direct.php', '21.12', 0),
('1cc155c7118e8a97834a1f4a13280fa8', './lib/core/CustomRoute/Type/TikiObject.php', '21.12', 0),
('083713e483a91160fce69b269784fd94', './lib/core/CustomRoute/Type/TrackerField.php', '21.12', 0),
('208f2dbbcb47e938bf87017f4a375e9a', './lib/core/DeclFilter.php', '21.12', 0),
('ad437804752b1abc7af7d0742eded9f3', './lib/core/DeclFilter/CatchAllFilterRule.php', '21.12', 0),
('fb93d1ad605e69feaa6a1391b724b726', './lib/core/DeclFilter/CatchAllUnsetRule.php', '21.12', 0),
('b55f3bc01d782506608f9fd54f2deaeb', './lib/core/DeclFilter/FilterRule.php', '21.12', 0),
('4a36152843a75f265b8225ce6c652600', './lib/core/DeclFilter/KeyPatternFilterRule.php', '21.12', 0),
('3bb89a5c7ca30a8d7bc755c4d2c8545b', './lib/core/DeclFilter/KeyPatternUnsetRule.php', '21.12', 0),
('1c8d8993378f243fb0f2b71ce9e43b21', './lib/core/DeclFilter/Rule.php', '21.12', 0),
('46ad269ed227f32ada0b789791414682', './lib/core/DeclFilter/StaticKeyFilterRule.php', '21.12', 0),
('4a3b6265c4d725b50bb1a9007d650fb8', './lib/core/DeclFilter/StaticKeyUnsetRule.php', '21.12', 0),
('6b48a93c718142261e7a84288531cafc', './lib/core/DeclFilter/UnsetRule.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/DeclFilter/index.php', '21.12', 0),
('b0b6fc112d661886803d3b8ce1902079', './lib/core/Feed/Abstract.php', '21.12', 0),
('ce2f0ceae425c81a3491db01132f2a4e', './lib/core/Feed/Container.php', '21.12', 0),
('e49838db2a26fddc6b4e02abd3c242a9', './lib/core/Feed/Contents.php', '21.12', 0),
('15fd75b6e05bce7d92c3a97f0ca65a52', './lib/core/Feed/Html.php', '21.12', 0),
('eca33011f0d6ad273e324b44a0015b71', './lib/core/Feed/Html/Receive.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Feed/Html/index.php', '21.12', 0),
('5c2214227fb0e2d4717bbde723aa429b', './lib/core/Feed/Item.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Feed/index.php', '21.12', 0),
('17a77720bf83dcb2b0834276394456e5', './lib/core/Feedback.php', '21.12', 0),
('0edf865f0e8ccd2063935be557c50a12', './lib/core/File/DiagramHelper.php', '21.12', 0),
('0ca149842dc20d7482dba8eeebd07b8f', './lib/core/File/FileHelper.php', '21.12', 0),
('930ee0fe31e74f13abeea95d71c01420', './lib/core/File/OcrHelper.php', '21.12', 0),
('09cfc9a57ff4a4c5b6bd3261c24d8c7a', './lib/core/File/PDFHelper.php', '21.12', 0),
('00f9379e89706e9c878ff42120c92175', './lib/core/File/XMLHelper.php', '21.12', 0),
('c1dfd8332dc74894a24b88e59264c059', './lib/core/Group/Roles/RolesLib.php', '21.12', 0),
('e2e0a502475896183b0f84cc706d14df', './lib/core/H5P/EditorTikiAjax.php', '21.12', 0),
('36bef7ae5fd2e9a11562207f79d62341', './lib/core/H5P/EditorTikiStorage.php', '21.12', 0),
('557f516815dfcf1c24c8517c24967bf5', './lib/core/H5P/Event.php', '21.12', 0),
('8af1be3847f7e2a903331e2b22810c5f', './lib/core/H5P/H5PTiki.php', '21.12', 0),
('0ef72548f91b187a7dab892cbe9049b2', './lib/core/H5P/editor.js', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/H5P/index.php', '21.12', 0),
('fe3bf3c6d90c2aada27aa180e55225cd', './lib/core/IDS/Rule.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/IDS/index.php', '21.12', 0),
('b13337f2007ca598bc8e944223181305', './lib/core/IDS/log.php', '21.12', 0),
('6bb93faedc7f15fc6b14d6079583c690', './lib/core/JisonParser/Phraser.js', '21.12', 0),
('6be5e26bd1e963304d96134d75370b83', './lib/core/JisonParser/Phraser.php', '21.12', 0),
('5711db803c606889bfc2f8c302a23b28', './lib/core/JisonParser/Phraser/Handler.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/JisonParser/Phraser/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/JisonParser/index.php', '21.12', 0),
('bd48a752533c0770bef4e07f146b45c7', './lib/core/JitFilter.php', '21.12', 0),
('a152adc8dbd0ee4c5c30dfa7e8140452', './lib/core/JitFilter/Element.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/JitFilter/index.php', '21.12', 0),
('c32d6a2ee2e417ba4c4062f0ec5c2c57', './lib/core/Math/Formula/Applicator.php', '21.12', 0),
('dea4f44bd182d19cad36685c2f38d99c', './lib/core/Math/Formula/Currency.php', '21.12', 0),
('5e30a2e75b24592c2d6e5daa76dd977c', './lib/core/Math/Formula/Element.php', '21.12', 0),
('fb3466af616565a9e92f1b399a60c007', './lib/core/Math/Formula/Exception.php', '21.12', 0),
('cab4c8ff49c4884b1b81e3ec799579fd', './lib/core/Math/Formula/Function.php', '21.12', 0),
('28fcfb3dcbac4e50b9f59e8ed042238b', './lib/core/Math/Formula/Function/Add.php', '21.12', 0),
('7f3aac5ce77d2f5256a72eb94faa771c', './lib/core/Math/Formula/Function/And.php', '21.12', 0),
('75b3c2cad691042a18933abfeb4a1c0f', './lib/core/Math/Formula/Function/Avg.php', '21.12', 0),
('8489d3ff231090e8917738f32e3c68c2', './lib/core/Math/Formula/Function/Ceil.php', '21.12', 0),
('9fa5d9881994aab5b8d3e4111bce6c3b', './lib/core/Math/Formula/Function/Clean.php', '21.12', 0),
('01a407e91f7dbddfdb621c91f7f99bef', './lib/core/Math/Formula/Function/Coalesce.php', '21.12', 0),
('ac16bc3ef6610dc01b55f83c53ee456d', './lib/core/Math/Formula/Function/Concat.php', '21.12', 0),
('99c5035524ca40b3f30c98f34f0a46a2', './lib/core/Math/Formula/Function/Contains.php', '21.12', 0),
('9e7c5a815337743ab1c90bd0296b1ae8', './lib/core/Math/Formula/Function/Count.php', '21.12', 0),
('96d701284f7039fcffd6546d81f5be43', './lib/core/Math/Formula/Function/Currency.php', '21.12', 0),
('48f95321ec98b67f46aebbc690710113', './lib/core/Math/Formula/Function/CurrencyConvert.php', '21.12', 0),
('b2f1e6891695d449655a166e05e6fe32', './lib/core/Math/Formula/Function/Date.php', '21.12', 0),
('5477c72d8d10921c830856d3e92178b6', './lib/core/Math/Formula/Function/Div.php', '21.12', 0),
('5d33416e5007664c642734162d75186b', './lib/core/Math/Formula/Function/Equals.php', '21.12', 0),
('22917341283c1cb52c0afc6a1852109c', './lib/core/Math/Formula/Function/Eval.php', '21.12', 0),
('f67feffadab1845e9359eb8bc289031d', './lib/core/Math/Formula/Function/Floor.php', '21.12', 0),
('3b54bfe203219a2186e48c613e4e3620', './lib/core/Math/Formula/Function/ForEach.php', '21.12', 0),
('a58463b773425ff2fd1bda18f9ed75ad', './lib/core/Math/Formula/Function/Hash.php', '21.12', 0),
('535892fa9813b0778eef8a23b419a27f', './lib/core/Math/Formula/Function/If.php', '21.12', 0),
('05b1ef9be40676ea79de657c57d46f80', './lib/core/Math/Formula/Function/IsEmpty.php', '21.12', 0),
('4eba239bac7f680763adf3c9955b8b59', './lib/core/Math/Formula/Function/LessThan.php', '21.12', 0),
('2fa72aa4ca4fd387ff52864e988da41e', './lib/core/Math/Formula/Function/Lower.php', '21.12', 0),
('3c09813a3385d9d955c1632c26cf47bf', './lib/core/Math/Formula/Function/Map.php', '21.12', 0),
('100fc1e244aa182fdc94502a52cf03c1', './lib/core/Math/Formula/Function/Max.php', '21.12', 0),
('5c21ce2dbe06365ecd0648447ed9d771', './lib/core/Math/Formula/Function/Min.php', '21.12', 0),
('99b0255b22ec338d94d5bc8a45ef7028', './lib/core/Math/Formula/Function/MoreThan.php', '21.12', 0),
('77e80ac8158439e8ed9951ec8f8c3310', './lib/core/Math/Formula/Function/Mul.php', '21.12', 0),
('de7097b29d4f37b7ec2ced57a035bc72', './lib/core/Math/Formula/Function/Not.php', '21.12', 0),
('935b090c958e82c83f1db8f88527ec58', './lib/core/Math/Formula/Function/NotEquals.php', '21.12', 0),
('c9df148397ad79a6622f30ca8f68015c', './lib/core/Math/Formula/Function/NumberFormat.php', '21.12', 0),
('3d2112e0bf252c4279c55d72d4951528', './lib/core/Math/Formula/Function/Or.php', '21.12', 0),
('eb76c06f2782d6fc2155b22e9053f42b', './lib/core/Math/Formula/Function/Pad.php', '21.12', 0),
('d77d4dd4b8e9ef81c94842045f610337', './lib/core/Math/Formula/Function/PregReplace.php', '21.12', 0),
('c289013e55e5fa67171c09496856d75b', './lib/core/Math/Formula/Function/Random.php', '21.12', 0),
('d7cb7361253cc80626f468ccadbc032d', './lib/core/Math/Formula/Function/Round.php', '21.12', 0),
('818cbc6a6fa6e813498e07126f092c70', './lib/core/Math/Formula/Function/SplitList.php', '21.12', 0),
('da0dcff8fc03094d3e037f155634ab26', './lib/core/Math/Formula/Function/Str.php', '21.12', 0),
('38ac53a15cd12c32da19a3ddf018f431', './lib/core/Math/Formula/Function/StrReplace.php', '21.12', 0),
('ba9c94092f0df950119014ec71d42a60', './lib/core/Math/Formula/Function/StrToTime.php', '21.12', 0),
('d72edd4bc3e6de19e1ea6eaae618dec2', './lib/core/Math/Formula/Function/Sub.php', '21.12', 0),
('95cc4dbc37b23db49ff6ba13bef4f722', './lib/core/Math/Formula/Function/Substring.php', '21.12', 0),
('2bfc3c8cbf30f427bc8cfa893acdd9b9', './lib/core/Math/Formula/Function/Subtotal.php', '21.12', 0),
('a68e2fd5ef660752b57559e8ee92df50', './lib/core/Math/Formula/Function/Upper.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Math/Formula/Function/index.php', '21.12', 0),
('bace03aaf434d034e90746bab744e910', './lib/core/Math/Formula/InternalString.php', '21.12', 0),
('3cd7d0a06930a226a9c24b3540c64108', './lib/core/Math/Formula/Parser.php', '21.12', 0),
('1b172465501586121a4c720177ef95f4', './lib/core/Math/Formula/Parser/Exception.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Math/Formula/Parser/index.php', '21.12', 0),
('b14477b87a6a3ccf0a00f2d1ec8fa707', './lib/core/Math/Formula/Runner.php', '21.12', 0),
('cc076be478fc0dea3cfe22b300883cea', './lib/core/Math/Formula/Runner/Exception.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Math/Formula/Runner/index.php', '21.12', 0),
('142c3df552b9291c3c623a0f2c9645fd', './lib/core/Math/Formula/Tokenizer.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Math/Formula/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Math/index.php', '21.12', 0),
('5bb4423ab7e301dc20aaab0ee07d01e1', './lib/core/Modules/Permissions.php', '21.12', 0),
('2309f433a0c43601884bf9cfc3716ef8', './lib/core/Multilingual/Aligner/BilingualAligner.php', '21.12', 0),
('97112f7a927f70577ef4d9b0b4e99c47', './lib/core/Multilingual/Aligner/MockMTWrapper.php', '21.12', 0),
('9f9851dd1ed1c8cf09fcb9427d482a17', './lib/core/Multilingual/Aligner/SentenceAlignments.php', '21.12', 0),
('57a38c9b72258dd7c8f4bb6792dfb83b', './lib/core/Multilingual/Aligner/SentenceAlignments3.php', '21.12', 0),
('01b4da1e4187970cdffffc68cbc884ad', './lib/core/Multilingual/Aligner/SentenceSegmentor.php', '21.12', 0),
('b067b9c4bad1bcf4ed15e56476d510be', './lib/core/Multilingual/Aligner/ShortestPathFinder.php', '21.12', 0),
('e71b6949bc25b989effc4d07bfe96109', './lib/core/Multilingual/Aligner/UpdatePages.php', '21.12', 0),
('78d94bbb0f31025aa00d9aeb43a244e3', './lib/core/Multilingual/Aligner/UpdateSentences.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Multilingual/Aligner/index.php', '21.12', 0),
('e32aa8d90d4c22ef5560fb72eabdb009', './lib/core/Multilingual/MachineTranslation.php', '21.12', 0),
('e30a58a21e8a41e287b4e03b8b5e3379', './lib/core/Multilingual/MachineTranslation/BingTranslateWrapper.php', '21.12', 0),
('c0c94829a89c388eed018805dfe96e72', './lib/core/Multilingual/MachineTranslation/Cache.php', '21.12', 0),
('bbb5e0f2e7035469829aeedb61769840', './lib/core/Multilingual/MachineTranslation/GoogleTranslateWrapper.php', '21.12', 0),
('5cf58aca07c6abcb061579664e57ad3e', './lib/core/Multilingual/MachineTranslation/Interface.php', '21.12', 0),
('470f1b68bba7f3a773a6a8366814724d', './lib/core/Multilingual/MachineTranslation/Null.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Multilingual/MachineTranslation/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Multilingual/index.php', '21.12', 0),
('dca79a2344e9b01828f3a4ddcdfa4037', './lib/core/Notifications/Email.php', '21.12', 0),
('bbdf6679988d3ce55d1e931bd6b6e397', './lib/core/Perms.php', '21.12', 0),
('fdb2bb6f4e424f7df1a16f8edd593622', './lib/core/Perms/Accessor.php', '21.12', 0),
('421e021811bed3b6e1225a592de6378e', './lib/core/Perms/Applier.php', '21.12', 0),
('d8efd8bf6b5954d8135644e36027e92a', './lib/core/Perms/Builder.php', '21.12', 0),
('2398d1da196c81aba2ffa3e5f0fad112', './lib/core/Perms/Check.php', '21.12', 0),
('a4c40c9bbdeebe270c7a70a473653f90', './lib/core/Perms/Check/Alternate.php', '21.12', 0),
('56691c97f5bdff82310f5909a32ab2da', './lib/core/Perms/Check/Creator.php', '21.12', 0),
('69f9f8b933216db1343ceca173f9d19a', './lib/core/Perms/Check/Direct.php', '21.12', 0),
('b367b7fd6f3fb9ce8851e4832cd905d5', './lib/core/Perms/Check/Fixed.php', '21.12', 0),
('f100242ddb2a0ab7d105658d15f434c4', './lib/core/Perms/Check/Indirect.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Perms/Check/index.php', '21.12', 0),
('5df6eb7ef313d6e66a990d0ebc9df842', './lib/core/Perms/Context.php', '21.12', 0),
('9a440dad438c99d7e25dd7f4b4edd9cf', './lib/core/Perms/Reflection/Category.php', '21.12', 0),
('4f18730137b9ce496f4d1988af067ff3', './lib/core/Perms/Reflection/Container.php', '21.12', 0),
('f411f5ba76dfe905596cbf832fac4439', './lib/core/Perms/Reflection/Factory.php', '21.12', 0),
('8913d41580f9e8381e0859da872920b8', './lib/core/Perms/Reflection/Global.php', '21.12', 0),
('d30784931645e3515617f93954c8c72f', './lib/core/Perms/Reflection/Object.php', '21.12', 0),
('92cdef2b95c77cdad1a4918d2f312df5', './lib/core/Perms/Reflection/PermissionComparator.php', '21.12', 0),
('8aaae9b770c4325913fa4238b5854fb3', './lib/core/Perms/Reflection/PermissionSet.php', '21.12', 0),
('66fb27c71585c164af6c6b8a33684590', './lib/core/Perms/Reflection/Quick.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Perms/Reflection/index.php', '21.12', 0),
('273fab4037ad72615bda21f16948b7dc', './lib/core/Perms/Resolver.php', '21.12', 0),
('7589f17c86ca00108f969feb776098e4', './lib/core/Perms/Resolver/Default.php', '21.12', 0),
('65ca22b609dd6702c786ca93df6109e3', './lib/core/Perms/Resolver/Static.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Perms/Resolver/index.php', '21.12', 0),
('a82d921f3d2149b9797d0754350ea657', './lib/core/Perms/ResolverFactory.php', '21.12', 0),
('8339d1f9e4a11d9bcddaea55d587d482', './lib/core/Perms/ResolverFactory/CategoryFactory.php', '21.12', 0),
('034ac9b276ab72eb59e99eff5dcab598', './lib/core/Perms/ResolverFactory/GlobalFactory.php', '21.12', 0),
('2c04173962ac118762b548aa52a35384', './lib/core/Perms/ResolverFactory/ObjectFactory.php', '21.12', 0),
('4ec6e6438372786ca92e5fa9d6bf38f4', './lib/core/Perms/ResolverFactory/StaticFactory.php', '21.12', 0),
('0c7adaae6f85fa32ccb6255049024c7c', './lib/core/Perms/ResolverFactory/TestFactory.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Perms/ResolverFactory/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Perms/index.php', '21.12', 0),
('da1af4786499ac17530eaecd09277c2a', './lib/core/Reports/Cache.php', '21.12', 0),
('11ebbee6a3ac89b878539accdf648467', './lib/core/Reports/Factory.php', '21.12', 0),
('6b05ffa36620880c3adbd66c6500837c', './lib/core/Reports/Manager.php', '21.12', 0),
('2726fddc12aec693f27832eba75e5237', './lib/core/Reports/Send.php', '21.12', 0),
('4c99b01c4baad7f27acdd427e3712a7b', './lib/core/Reports/Send/EmailBuilder.php', '21.12', 0),
('5f6f2f5544fcf1da9c39fe64227ffda2', './lib/core/Reports/Send/EmailBuilder/Abstract.php', '21.12', 0),
('1d19eafbff6c9096f2a0e94565d6d7e5', './lib/core/Reports/Send/EmailBuilder/ArticleDeleted.php', '21.12', 0),
('3e818c1d701e6cf5bf160ddf2bca166c', './lib/core/Reports/Send/EmailBuilder/ArticleEdited.php', '21.12', 0),
('4ad4290f6d4e2f591c72dc9f8549d031', './lib/core/Reports/Send/EmailBuilder/ArticleSubmitted.php', '21.12', 0),
('69c8d24d59471a6c22dec753f89c28d9', './lib/core/Reports/Send/EmailBuilder/BlogPost.php', '21.12', 0),
('1f7f12698d993fa513c91d756632faff', './lib/core/Reports/Send/EmailBuilder/CalendarChanged.php', '21.12', 0),
('ad7a568515b5d8e0df15d64d674bce57', './lib/core/Reports/Send/EmailBuilder/CategoryChanged.php', '21.12', 0),
('3d7c879495b86a4739104700b36ead20', './lib/core/Reports/Send/EmailBuilder/Factory.php', '21.12', 0),
('0136ee2d8c6f883880aa9c4e9dc66666', './lib/core/Reports/Send/EmailBuilder/FileGalleryChanged.php', '21.12', 0),
('35b9345f35671e6ecdd0bd99ab6bc0a2', './lib/core/Reports/Send/EmailBuilder/ForumPostThread.php', '21.12', 0),
('4635ad9f1ebde3d540405ab1812f9f6b', './lib/core/Reports/Send/EmailBuilder/ForumPostTopic.php', '21.12', 0),
('8daeba168e20846c110973e876511494', './lib/core/Reports/Send/EmailBuilder/ImageGalleryChanged.php', '21.12', 0),
('5336dd807af38e4736efeba7e08b7d39', './lib/core/Reports/Send/EmailBuilder/StructureAdd.php', '21.12', 0),
('7164fab7e4dc44d94d85cc3fb3c710ba', './lib/core/Reports/Send/EmailBuilder/StructureMoveDown.php', '21.12', 0),
('089af84474a9542bf38a1174e5c15344', './lib/core/Reports/Send/EmailBuilder/StructureMoveUp.php', '21.12', 0),
('80e0eeeb348ad84d084fef6cd7b2bdbf', './lib/core/Reports/Send/EmailBuilder/StructureRemove.php', '21.12', 0),
('123777a626966ec0969dd9d130dfa67d', './lib/core/Reports/Send/EmailBuilder/TrackerFileAttachment.php', '21.12', 0),
('0b8d7b6fc02001c63fe963cfd0d2a273', './lib/core/Reports/Send/EmailBuilder/TrackerItemComment.php', '21.12', 0),
('4f8b864c56f017883139ad683ef71245', './lib/core/Reports/Send/EmailBuilder/TrackerItemModified.php', '21.12', 0),
('bf3ad28c1dc405ce7970321f39f78037', './lib/core/Reports/Send/EmailBuilder/WikiFileAttached.php', '21.12', 0),
('8dd3825632c93d7e30e312d752945d31', './lib/core/Reports/Send/EmailBuilder/WikiPageChanged.php', '21.12', 0),
('22349ac00c6ccbef0086e859ee056ee1', './lib/core/Reports/Send/EmailBuilder/WikiPageCreated.php', '21.12', 0),
('1d545221bbf216c09b848dcf93e8c380', './lib/core/Reports/Send/EmailBuilder/WikiPageDeleted.php', '21.12', 0),
('d30c55521adc1323330b28b5117e8910', './lib/core/Reports/Send/EmailBuilder/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Reports/Send/index.php', '21.12', 0),
('5c82f2b8a30644ea8595253aa3530fb8', './lib/core/Reports/Users.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Reports/index.php', '21.12', 0),
('699700e346aa97b0dc6f464dc8a3222b', './lib/core/Scheduler/Exception/CrontimeFormatException.php', '21.12', 0),
('2dca98684ef47e47f6f59411cab84228', './lib/core/Scheduler/Exception/Exception.php', '21.12', 0),
('f952c0da149be2c686c748d6c9f4c119', './lib/core/Scheduler/Item.php', '21.12', 0),
('099cb9b4109b521f2e53fb2a90d7fc4b', './lib/core/Scheduler/Manager.php', '21.12', 0),
('32642265944550ce8a90f8c72dc079b0', './lib/core/Scheduler/Task/CommandTask.php', '21.12', 0),
('902eae837bdc753388e1e7e9208dc355', './lib/core/Scheduler/Task/ConsoleCommandTask.php', '21.12', 0),
('8922765c2f340b260ec694b4645717a3', './lib/core/Scheduler/Task/HTTPGetCommandTask.php', '21.12', 0),
('4f48c8b4592b0d80f7170aad10bdd9d5', './lib/core/Scheduler/Task/ShellCommandTask.php', '21.12', 0),
('d14d82534e8fc89b04665793e794a27b', './lib/core/Scheduler/Task/TikiCheckerCommandTask.php', '21.12', 0),
('3f5f4d64a1f867494e697daac4974681', './lib/core/Scheduler/Utils.php', '21.12', 0),
('46400cccccf18a37300eb5e48463f383', './lib/core/Search/Action/Action.php', '21.12', 0),
('4db4e7df0c1d24a7ae43f6308c07b898', './lib/core/Search/Action/ActionStep.php', '21.12', 0),
('1f3e820768076ea380a338c6f09e6ad8', './lib/core/Search/Action/ChangeStatusAction.php', '21.12', 0),
('685d9cfa642835278d0045ba6c138e5f', './lib/core/Search/Action/Delete.php', '21.12', 0),
('436c27b3b481c8f4475a4e5ac89aa967', './lib/core/Search/Action/EmailAction.php', '21.12', 0),
('a378824fbff47f30f61fdd15bd375e61', './lib/core/Search/Action/Exception.php', '21.12', 0),
('00aebf8c45714169f732f4a2f832a847', './lib/core/Search/Action/Factory.php', '21.12', 0),
('88c5d8597ffc03cadfaa4cc05aa67584', './lib/core/Search/Action/FileGalleryChangeFilename.php', '21.12', 0),
('6b0657361a4d9f4eb04a0b9d29e347c2', './lib/core/Search/Action/FileGalleryImageOverlay.php', '21.12', 0),
('03ab7489fc077e65f6fd19de6f13b6d7', './lib/core/Search/Action/ReportingTransform.php', '21.12', 0),
('24e70f0c13ad8ea17614ea7a132fa304', './lib/core/Search/Action/Sequence.php', '21.12', 0),
('45caa38f2cc04a2dd382f82678f687db', './lib/core/Search/Action/Step.php', '21.12', 0),
('ffc35f6eb9c5c8e01fc781cdd5669857', './lib/core/Search/Action/TrackerItemModify.php', '21.12', 0),
('d4c86b633c4850fbac6afcc224b86753', './lib/core/Search/Action/UnknownStep.php', '21.12', 0),
('3a7a629f06f86e61cd5c7f953a01fb3c', './lib/core/Search/Action/WikiApprovalAction.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Search/Action/index.php', '21.12', 0),
('7cd32444c57116879b3869f5f4da465c', './lib/core/Search/ContentFilter/VersionNumber.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/ContentFilter/index.php', '21.12', 0),
('32988ca8459292a482563254bc7debd3', './lib/core/Search/ContentSource/ActivityStreamSource.php', '21.12', 0),
('adc5bed71657d4972dccf7a0188ad8e7', './lib/core/Search/ContentSource/ArticleSource.php', '21.12', 0),
('04a9edff14338e3a3ced4b1960229e06', './lib/core/Search/ContentSource/BlogPostSource.php', '21.12', 0),
('1ca11c0fedebcdca273172623a175b0b', './lib/core/Search/ContentSource/CalendarItemSource.php', '21.12', 0),
('85666adfc06e2652af0481658c40329c', './lib/core/Search/ContentSource/CalendarSource.php', '21.12', 0),
('82cc8ee8813dd5453cec677e706d81c7', './lib/core/Search/ContentSource/CategorySource.php', '21.12', 0),
('2578c0d87c26114cac26b27d1dbcd711', './lib/core/Search/ContentSource/CommentSource.php', '21.12', 0),
('47646424f813e2ee8ac4add755271e6b', './lib/core/Search/ContentSource/CreditSource.php', '21.12', 0),
('03626f9309f0465aada6b0e4c7250737', './lib/core/Search/ContentSource/FileGallerySource.php', '21.12', 0),
('0acd464b177be413bbd38fb5d8d83fa8', './lib/core/Search/ContentSource/FileSource.php', '21.12', 0),
('181994b06313a97dfd5a8b71f1d4889c', './lib/core/Search/ContentSource/ForumPostSource.php', '21.12', 0),
('f35342c79788e73cdfe796ca9e64491b', './lib/core/Search/ContentSource/ForumSource.php', '21.12', 0),
('ca657b6eda50cc97424caf98a8f48866', './lib/core/Search/ContentSource/GoalEventSource.php', '21.12', 0),
('171320446ce2cd872ab9af692aa380ce', './lib/core/Search/ContentSource/GoalSource.php', '21.12', 0),
('4e88e36d917a7355661ccc64333a4da1', './lib/core/Search/ContentSource/GroupSource.php', '21.12', 0),
('619549a66dd2ff1ff2f688574a3b400c', './lib/core/Search/ContentSource/Interface.php', '21.12', 0),
('a24ebcd3d0bf2b342c724f2ac1ac3a88', './lib/core/Search/ContentSource/SheetSource.php', '21.12', 0),
('09347221b0d17c786ee88fa588822598', './lib/core/Search/ContentSource/Static.php', '21.12', 0),
('e453eb8754fc9a13f5c0f19801e3cac4', './lib/core/Search/ContentSource/TrackerFieldSource.php', '21.12', 0),
('21b6ad2654d131f7802c152060981a2b', './lib/core/Search/ContentSource/TrackerItemSource.php', '21.12', 0),
('072d7873ad5a8bc4c8f0020860882bd6', './lib/core/Search/ContentSource/TrackerSource.php', '21.12', 0),
('1fd510e558cc88688a39950e39f2ec6a', './lib/core/Search/ContentSource/UserSource.php', '21.12', 0),
('62f2449404ee5805d121dd6c83ac14bf', './lib/core/Search/ContentSource/WebserviceSource.php', '21.12', 0),
('b64ba71a38431a78c60ff76f875001dc', './lib/core/Search/ContentSource/WikiSource.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/ContentSource/index.php', '21.12', 0),
('5a6072f1f70ae37b4234a65aa2d04845', './lib/core/Search/Elastic/BulkOperation.php', '21.12', 0),
('ccc3900742f45f480422514738d4275d', './lib/core/Search/Elastic/Connection.php', '21.12', 0),
('7ec4e4587bc1998e810969b1bf5cbac2', './lib/core/Search/Elastic/Exception.php', '21.12', 0),
('e20b845522c05480b970a4a31e439080', './lib/core/Search/Elastic/FacetBuilder.php', '21.12', 0),
('9e3f4d017122560bb0572be2f04a3088', './lib/core/Search/Elastic/FacetReader.php', '21.12', 0),
('0f84fb12f7cecfe39383dc37544e8988', './lib/core/Search/Elastic/Index.php', '21.12', 0),
('7caa8f8e30c9600186a62d6546c75cd2', './lib/core/Search/Elastic/MappingException.php', '21.12', 0),
('ab6f29b7b5dfaef8c882e6d80813dcaf', './lib/core/Search/Elastic/NotFoundException.php', '21.12', 0),
('87daf5acb5bd99797b811f2a460fd45f', './lib/core/Search/Elastic/NumberFormatException.php', '21.12', 0),
('4846e49c910fbedeb9cb01b91ee7366a', './lib/core/Search/Elastic/OrderBuilder.php', '21.12', 0),
('da99574e3723e4ecf1cbd69daf4d1fe0', './lib/core/Search/Elastic/QueryBuilder.php', '21.12', 0),
('bd63c71619b1900798615e68157d3ffc', './lib/core/Search/Elastic/QueryParsingException.php', '21.12', 0),
('c6a6d0257da174ed3b5469483cec6abb', './lib/core/Search/Elastic/RescoreQueryBuilder.php', '21.12', 0),
('41edc7820724f76c12e875aee714e976', './lib/core/Search/Elastic/ResultSet.php', '21.12', 0),
('7819ecbd65745e92edb4410d311af3e6', './lib/core/Search/Elastic/SortException.php', '21.12', 0),
('4b24ee06c772c114d9212aeb754e6cba', './lib/core/Search/Elastic/TransportException.php', '21.12', 0),
('534c1437cf34cbf6e359e11aefe6ac63', './lib/core/Search/Elastic/TypeFactory.php', '21.12', 0),
('f7080b607ac95ccf7aa6c73762ee0744', './lib/core/Search/EngineResult/Elastic.php', '21.12', 0),
('a166661d0fa1122b3ccf8fb70d1115ff', './lib/core/Search/EngineResult/Interface.php', '21.12', 0),
('e949ed1f3a79cd6fa891159be327ba0d', './lib/core/Search/EngineResult/MySQL.php', '21.12', 0),
('d4c2588974026f8f3f221618eb6fa392', './lib/core/Search/Exception.php', '21.12', 0),
('f626a052e150bd78db70e6acfdd28a43', './lib/core/Search/Expr/And.php', '21.12', 0),
('ffb320813cc6d2933396ba369da06e87', './lib/core/Search/Expr/Distance.php', '21.12', 0),
('6933ba0857f46d76fffd794a09dde409', './lib/core/Search/Expr/ExplicitPhrase.php', '21.12', 0),
('8f360db736259bceb1881c70ae9f938f', './lib/core/Search/Expr/ImplicitPhrase.php', '21.12', 0),
('5c33f8c7d729addd9f0a8634ac759a7d', './lib/core/Search/Expr/Initial.php', '21.12', 0),
('0baf94d021410538067d5290adcfe282', './lib/core/Search/Expr/Interface.php', '21.12', 0),
('686ee2873e3a0c7816cb7b0da9cd2061', './lib/core/Search/Expr/MoreLikeThis.php', '21.12', 0),
('5c85a2c12afb8d65ecdb08386cce3eac', './lib/core/Search/Expr/Not.php', '21.12', 0),
('7cc69350abbadba385c46bea3986af08', './lib/core/Search/Expr/Or.php', '21.12', 0),
('0ca2996ca2d3fa52b891b0018532f5c4', './lib/core/Search/Expr/Parser.php', '21.12', 0),
('6f711ece31dc048adb0caa8e2af22f7a', './lib/core/Search/Expr/Range.php', '21.12', 0),
('d283b97c942c77e97352ad94b47a9c5f', './lib/core/Search/Expr/Token.php', '21.12', 0),
('632e4f2fcef783cce537fba262bbd0d3', './lib/core/Search/Expr/Tokenizer.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/Expr/index.php', '21.12', 0),
('293bcc4b8f88518fce3d5e8f9a61e1f4', './lib/core/Search/FacetProvider.php', '21.12', 0),
('65cca82d2bbcab0cf9c059f34c664d54', './lib/core/Search/FacetProvider/Interface.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Search/FacetProvider/index.php', '21.12', 0),
('b042a3dcc8a0432ff10711f959ae79c2', './lib/core/Search/Federated/CompilerPass.php', '21.12', 0),
('54e56079ff6ac1bf04c055a5ed82ab43', './lib/core/Search/Federated/IndexInterface.php', '21.12', 0),
('5f9580b3f337dc09c3aacbf771088149', './lib/core/Search/Federated/ManifoldCfIndex.php', '21.12', 0),
('89e5234154d3b6e292e88c818935edfc', './lib/core/Search/Federated/TikiIndex.php', '21.12', 0),
('dc1a774200c0415a855cdb01fa254fa5', './lib/core/Search/Federated/UrlPrefixTransform.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Search/Federated/index.php', '21.12', 0),
('d46deccefe6838e4c56116ef3e9fd417', './lib/core/Search/Formatter.php', '21.12', 0),
('d068bee65d6df06ed28069d808d2994a', './lib/core/Search/Formatter/AppendPagination.php', '21.12', 0),
('88425a23f4f0650b6c38dd8ef4a92665', './lib/core/Search/Formatter/ArrayBuilder.php', '21.12', 0),
('eb6e167cc2f2c72366c594b8d4cb9e97', './lib/core/Search/Formatter/Builder.php', '21.12', 0),
('788821e4d556bf277b260dc817815f06', './lib/core/Search/Formatter/DataSource/Declarative.php', '21.12', 0),
('33dcc06b1fde19f024ec1d912416d123', './lib/core/Search/Formatter/DataSource/Interface.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Search/Formatter/DataSource/index.php', '21.12', 0),
('a2a3e30c9ae651a4bac5651634df354b', './lib/core/Search/Formatter/Factory.php', '21.12', 0),
('d6d933ca2b8a49a38ace565fb01fe65c', './lib/core/Search/Formatter/Plugin/AbstractTableTemplate.php', '21.12', 0),
('695372136d3fe8a7223653c99f94e6c1', './lib/core/Search/Formatter/Plugin/ArrayTemplate.php', '21.12', 0),
('db2a13dffbcd3a3c528948ab8d5ac085', './lib/core/Search/Formatter/Plugin/CsvTemplate.php', '21.12', 0),
('4166d2eea2cb320b6fcd39cf74f7d485', './lib/core/Search/Formatter/Plugin/Interface.php', '21.12', 0),
('1305a9e24b80aae0425c0c97772c54d5', './lib/core/Search/Formatter/Plugin/ReportTemplate.php', '21.12', 0),
('b1ec39c83dc42f4a323095c8e52c70f8', './lib/core/Search/Formatter/Plugin/SmartyTemplate.php', '21.12', 0),
('bc9d3e1f1e62a56be86abcf9e30c21a0', './lib/core/Search/Formatter/Plugin/WikiTemplate.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Search/Formatter/Plugin/index.php', '21.12', 0),
('6abb24eda8df8c625228d735c53d9b4e', './lib/core/Search/Formatter/Transform/DynamicLoader.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Search/Formatter/Transform/index.php', '21.12', 0),
('b5805a4c96fdac3b985b935dc55fec3c', './lib/core/Search/Formatter/ValueFormatter.php', '21.12', 0),
('52fe8f1bb18cd582be875e0033680e14', './lib/core/Search/Formatter/ValueFormatter/Abstract.php', '21.12', 0),
('a5f59aab56bcaf3c1a11ceeb82888232', './lib/core/Search/Formatter/ValueFormatter/Categorylist.php', '21.12', 0),
('62cd1b87406833e524bfd885631b9707', './lib/core/Search/Formatter/ValueFormatter/Currency.php', '21.12', 0),
('a43d0840161a82d97ec9d6cb167bb3e2', './lib/core/Search/Formatter/ValueFormatter/Date.php', '21.12', 0),
('fbf1b9535608096f38890cb4a5a6f3a0', './lib/core/Search/Formatter/ValueFormatter/Datetime.php', '21.12', 0),
('f6c9dbd720f360a117de9c7ece1c6e7a', './lib/core/Search/Formatter/ValueFormatter/Imagegrabber.php', '21.12', 0),
('139996770a065d7802e166ed86822f7a', './lib/core/Search/Formatter/ValueFormatter/Interface.php', '21.12', 0),
('d2f5a6c5346fa6eace3b999555f6e319', './lib/core/Search/Formatter/ValueFormatter/Number.php', '21.12', 0),
('e93e5efc122543a7cdd1e612cc59ac83', './lib/core/Search/Formatter/ValueFormatter/Objectlink.php', '21.12', 0),
('bb3ff2199551f8b5bc93679320edae11', './lib/core/Search/Formatter/ValueFormatter/Plain.php', '21.12', 0),
('81ef1adedf5719610854196b984c50c7', './lib/core/Search/Formatter/ValueFormatter/Reference.php', '21.12', 0),
('ba7279bb3ebdf27e0263d861fa29fd50', './lib/core/Search/Formatter/ValueFormatter/Slug.php', '21.12', 0),
('6c2d86dad6ec5501fb947e09d1729fcd', './lib/core/Search/Formatter/ValueFormatter/Snippet.php', '21.12', 0),
('b9d16cfc19d9a72fc4b1e0762c07e8eb', './lib/core/Search/Formatter/ValueFormatter/Sorthandle.php', '21.12', 0),
('0449d5271562b698aa4ce0fad035eff7', './lib/core/Search/Formatter/ValueFormatter/Templaterender.php', '21.12', 0),
('8744fd41d82cf3111795f437af6cb9bd', './lib/core/Search/Formatter/ValueFormatter/Timeago.php', '21.12', 0),
('dfede24f2d5a7a4e1af1275641f38bd0', './lib/core/Search/Formatter/ValueFormatter/Trackerrender.php', '21.12', 0),
('2d0be9f0b98c1291664a6db7090e2df8', './lib/core/Search/Formatter/ValueFormatter/Url.php', '21.12', 0),
('32add44b1d65591d66fff9020e41e4a2', './lib/core/Search/Formatter/ValueFormatter/Urlencode.php', '21.12', 0),
('6fb8692613b963e16fb3f74da6831a9a', './lib/core/Search/Formatter/ValueFormatter/Wikiplugin.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Search/Formatter/ValueFormatter/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/Formatter/index.php', '21.12', 0),
('66ebddebea14f6f24836d2c857b05cdd', './lib/core/Search/GlobalSource/AdvancedRatingSource.php', '21.12', 0),
('21cfc9ff63430ab15d8efde3420f3a4d', './lib/core/Search/GlobalSource/ArticleAttachmentSource.php', '21.12', 0),
('918e70f7736eed0ee481c5f2241d7c33', './lib/core/Search/GlobalSource/CategorySource.php', '21.12', 0),
('6968f030438c4421812d67dc461062f5', './lib/core/Search/GlobalSource/CommentSource.php', '21.12', 0),
('90065ffb9b09fb559f04c81b7d3270dd', './lib/core/Search/GlobalSource/FileAttachmentSource.php', '21.12', 0),
('c2ac54ceac3db25762a22667a3f57018', './lib/core/Search/GlobalSource/FreeTagSource.php', '21.12', 0),
('83b3fb95a36231c2312f08dcec1fc26b', './lib/core/Search/GlobalSource/Geolocation.php', '21.12', 0),
('5c41f126e01f08feec46b927781c2641', './lib/core/Search/GlobalSource/Interface.php', '21.12', 0),
('561850da21376ef544120e645559b860', './lib/core/Search/GlobalSource/PermissionSource.php', '21.12', 0),
('b978e724abe9db47f8a2fd3c925547dc', './lib/core/Search/GlobalSource/RelationSource.php', '21.12', 0),
('e1f379907d0cb83a6ffd92f74d94fa18', './lib/core/Search/GlobalSource/SearchableSource.php', '21.12', 0),
('1bfa74e500cc4b8eecf76d976131789c', './lib/core/Search/GlobalSource/SocialSource.php', '21.12', 0),
('b625ada1ffef32de85b02e673d26c52e', './lib/core/Search/GlobalSource/Static.php', '21.12', 0),
('37b2b7c8f66a3f10f068d50a82826ae3', './lib/core/Search/GlobalSource/TitleInitialSource.php', '21.12', 0),
('6b8ab34b0f5979f7cd66d7f6da2ca2cc', './lib/core/Search/GlobalSource/UrlSource.php', '21.12', 0),
('3605a76221b57468c95d674af0bcde88', './lib/core/Search/GlobalSource/VisitsSource.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/GlobalSource/index.php', '21.12', 0),
('549652a0eb55c208b33518407361e84a', './lib/core/Search/Index/AbstractIndexDecorator.php', '21.12', 0),
('d71f1661186dc2445e532a9eadade9fe', './lib/core/Search/Index/CategoryFilterDecorator.php', '21.12', 0),
('4d05d086a4443f46ad2cd587c78b272a', './lib/core/Search/Index/Interface.php', '21.12', 0),
('ba036f22f85a8af903f433ae72bf4119', './lib/core/Search/Index/Memory.php', '21.12', 0),
('ca511786e4b94e288b65d7f440e64ad8', './lib/core/Search/Index/QueryAlertDecorator.php', '21.12', 0),
('7d3833a08aa1c0d684875c5262fd5ae4', './lib/core/Search/Index/QueryRepository.php', '21.12', 0),
('2ba43d0ddf78726401fb3b5697e3cf40', './lib/core/Search/Index/TypeAnalysisDecorator.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/Index/index.php', '21.12', 0),
('7789db5bf9cc08f597d80a2e47786ebd', './lib/core/Search/Indexer.php', '21.12', 0),
('e6e58b8120e33c75b3b9a5bc96fd3dea', './lib/core/Search/Lucene/HighlightHelper.php', '21.12', 0),
('ac3472ec6271cebc42fe9a77cb00005e', './lib/core/Search/Lucene/Index.php', '21.12', 0),
('ba5a968aa02929241db0d5e04b398b7d', './lib/core/Search/Lucene/TypeFactory.php', '21.12', 0),
('f2dc7ed08f7a58db0a23871663759e02', './lib/core/Search/MySql/Exception.php', '21.12', 0),
('e026b1829640c7b6965ced734db26a1e', './lib/core/Search/MySql/FieldQueryBuilder.php', '21.12', 0),
('205f007d5b81affa49ac45ffbf646475', './lib/core/Search/MySql/HighlightHelper.php', '21.12', 0),
('8e1dd896f5b9eb754bb7accd7649abc5', './lib/core/Search/MySql/Index.php', '21.12', 0),
('8c10f1bcf8aefebcf08e553e86ebbd96', './lib/core/Search/MySql/LimitReachedException.php', '21.12', 0),
('f018b66d2853f80358db8108376c9781', './lib/core/Search/MySql/QueryBuffer.php', '21.12', 0),
('21197a7bd09a3088e9d8e4565e38df8a', './lib/core/Search/MySql/QueryBuilder.php', '21.12', 0),
('0eb206049a00c6fc206cb474d40897da', './lib/core/Search/MySql/QueryException.php', '21.12', 0),
('736d576682d330598a88bee90d776189', './lib/core/Search/MySql/Table.php', '21.12', 0),
('9afe45ced70269c0a982a21a67a304d0', './lib/core/Search/MySql/TrackerFieldTranslator.php', '21.12', 0),
('c631baa377d4d7a282e6800172ceb411', './lib/core/Search/MySql/TypeFactory.php', '21.12', 0),
('e43f1d57880c86b80e47b398b10db54e', './lib/core/Search/PackageSource/Interface.php', '21.12', 0),
('ea1d0eb80980f8279763d000bb9d4034', './lib/core/Search/Query.php', '21.12', 0),
('e1b742c7146ff735e1ff71d26a24c2dd', './lib/core/Search/Query/Facet/Abstract.php', '21.12', 0),
('b23ac7bd4ec7d71863b125b4a3aaeae7', './lib/core/Search/Query/Facet/DateHistogram.php', '21.12', 0),
('c572d0c90cf438679bda29973d211f66', './lib/core/Search/Query/Facet/DateRange.php', '21.12', 0),
('a3f2a7c59c86225da78287e25a7c1e02', './lib/core/Search/Query/Facet/Interface.php', '21.12', 0),
('426ba774a200a1a3bf197d2512856b9a', './lib/core/Search/Query/Facet/Term.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Search/Query/Facet/index.php', '21.12', 0),
('9b9196558543c72bd259b145cc8ba613', './lib/core/Search/Query/FacetWikiBuilder.php', '21.12', 0),
('b9546756b490fe23a1afeed91307e195', './lib/core/Search/Query/Interface.php', '21.12', 0),
('f3259c30fbb1c65b749dc8d0326ae5e4', './lib/core/Search/Query/Order.php', '21.12', 0),
('2ac56fe250d3622754a4acdf0d24ef23', './lib/core/Search/Query/Relation.php', '21.12', 0),
('136b03cf8bee16a8634e7fdac438cdcc', './lib/core/Search/Query/RelationReplacer.php', '21.12', 0),
('51712d7dcf88edfde56327486f3baa90', './lib/core/Search/Query/WeightCalculator/Field.php', '21.12', 0),
('13613f6325afe80b04a855bacedad907', './lib/core/Search/Query/WeightCalculator/Interface.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Search/Query/WeightCalculator/index.php', '21.12', 0),
('5c9634e33c79f46bc0efbaf4c9391ff1', './lib/core/Search/Query/WikiBuilder.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/Query/index.php', '21.12', 0),
('258565d32620bde05942ecf85a3b7cbd', './lib/core/Search/ResultSet.php', '21.12', 0),
('087f9c6f20a305a0b59fafb68f3cf5c2', './lib/core/Search/ResultSet/FacetFilter.php', '21.12', 0),
('c01457643de42343b1e011106e0f9bb0', './lib/core/Search/ResultSet/SnippetHelper.php', '21.12', 0),
('95a8278b54bfe50b569e3724457a1460', './lib/core/Search/ResultSet/UrlHighlightTermsTransform.php', '21.12', 0),
('60ebcb14d5ea1eb28e9a6409c44b29f1', './lib/core/Search/ResultSet/WikiBuilder.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/ResultSet/index.php', '21.12', 0),
('2d5afc290d81c576ae7822949ac7f4d7', './lib/core/Search/Type/Analyzer.php', '21.12', 0),
('1ec7fe7cfc2d8de612d15513d9de56f6', './lib/core/Search/Type/DateTime.php', '21.12', 0),
('96d0554e8757cacb4919a3a0a5ebafa4', './lib/core/Search/Type/Factory/Direct.php', '21.12', 0),
('008fd0618bc0b29ea8f06fdd6a8d7065', './lib/core/Search/Type/Factory/Interface.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/Search/Type/Factory/index.php', '21.12', 0),
('806bc34f1519b27b2ce7d5afb5ca912b', './lib/core/Search/Type/GeoPoint.php', '21.12', 0),
('1f9039eec6833529a1467c1482fb4189', './lib/core/Search/Type/Interface.php', '21.12', 0),
('3fa160fe826562e034c165196e3d2c3e', './lib/core/Search/Type/Json.php', '21.12', 0),
('4ba8d276e1e29fa4da2b63a696ecb48f', './lib/core/Search/Type/MultivaluePlain.php', '21.12', 0),
('efb58fd049970fdafb7491ac0ca76693', './lib/core/Search/Type/MultivalueText.php', '21.12', 0),
('16763a463f07afd38837a968178858aa', './lib/core/Search/Type/Nested.php', '21.12', 0),
('522afa98c1f7108861131be06f617938', './lib/core/Search/Type/Numeric.php', '21.12', 0),
('e51cfde2b41e65c1d9fac86065681398', './lib/core/Search/Type/Object.php', '21.12', 0),
('8541ba3d49bf68e98b4d910087ad4311', './lib/core/Search/Type/PlainMediumText.php', '21.12', 0),
('11952ea96a24c4699fab79c4b3b82d21', './lib/core/Search/Type/PlainShortText.php', '21.12', 0),
('0d1001c439255c34def9ab44def779cd', './lib/core/Search/Type/PlainText.php', '21.12', 0),
('a3f56837d1dd4174b85d0ec66bbdcd67', './lib/core/Search/Type/ShortText.php', '21.12', 0),
('35c30e5acf0d2f1ad9310d4d00af1998', './lib/core/Search/Type/SimpleText.php', '21.12', 0),
('9e853bf34ac9c27a11fcdf6e8d006f7e', './lib/core/Search/Type/Timestamp.php', '21.12', 0),
('6de16db95c8d7c4c6264d48a9fbe27ff', './lib/core/Search/Type/Whole.php', '21.12', 0),
('570b09532300f96b06de106a56ea3231', './lib/core/Search/Type/WikiText.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Search/Type/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Search/index.php', '21.12', 0),
('5354fbe5cc0df8038c849ae28d61c010', './lib/core/Sections.php', '21.12', 0),
('74b5a5d1ebf0e8b474f17043fc0e621e', './lib/core/Services/Access/Controller.php', '21.12', 0),
('25cfe88f501a01ba33be3dd304977627', './lib/core/Services/Access/index.php', '21.12', 0),
('95cde702c576d284ec6b22c76affebcf', './lib/core/Services/ActivityStream/Controller.php', '21.12', 0),
('25a1369835b5c4ce4e01f5ab86146461', './lib/core/Services/ActivityStream/ManageController.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/ActivityStream/index.php', '21.12', 0),
('57bccb47358046732973950ebdd3551b', './lib/core/Services/Article/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Article/index.php', '21.12', 0),
('4577ef56a6fa7067cb508b05c0b13dd5', './lib/core/Services/Attribute/Controller.php', '21.12', 0),
('25cfe88f501a01ba33be3dd304977627', './lib/core/Services/Attribute/index.php', '21.12', 0),
('0c2c39d7517656929728390308fd1299', './lib/core/Services/AuthSource/Controller.php', '21.12', 0),
('dfbbe831217900b9d0e76eea4c4a30af', './lib/core/Services/AuthSource/OAuthController.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/AuthSource/index.php', '21.12', 0),
('e0a018d8c0eab5931ececa0662a5d477', './lib/core/Services/AutoSave/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/AutoSave/index.php', '21.12', 0),
('5abc17fd86832bf195e1a9656fa7f4d6', './lib/core/Services/BigBlueButton/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/BigBlueButton/index.php', '21.12', 0),
('5d94dd69f7283094b8a6753a24ca00c3', './lib/core/Services/Broker.php', '21.12', 0),
('849355406ebc128672adba913bdd54f1', './lib/core/Services/Calendar/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Calendar/index.php', '21.12', 0),
('627ebcfc1bc4401c398cbda081167145', './lib/core/Services/Category/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Category/index.php', '21.12', 0),
('b5e25cbd6de19906aa8fdef6c97da00f', './lib/core/Services/Comment/AnnotationController.php', '21.12', 0),
('02e593c28792e1fb68943e10a6e372a2', './lib/core/Services/Comment/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Comment/index.php', '21.12', 0),
('d1ca6a7faa7e38f9ce14eed468ba037e', './lib/core/Services/Connect/Client.php', '21.12', 0),
('d5ea2dbd91c53fb1ab6737097ebb626d', './lib/core/Services/Connect/Server.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Connect/index.php', '21.12', 0),
('d633a87ef392ced4954f71e10b9e4c03', './lib/core/Services/ContentTemplate/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/ContentTemplate/index.php', '21.12', 0),
('3fcce89f690d29aad654e1440cf5585b', './lib/core/Services/CustomRoute/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/CustomRoute/index.php', '21.12', 0),
('ede4574de9f5ad8309778d08f5394fad', './lib/core/Services/Cypht/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Cypht/index.php', '21.12', 0),
('34bbc74f30a42a380cec16eee5810d3b', './lib/core/Services/Diagram/Controller.php', '21.12', 0),
('d101a18d0f27a60f120abb86186fa71c', './lib/core/Services/Draw/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Draw/index.php', '21.12', 0),
('6d0334696b52d435a00bdec8a822a034', './lib/core/Services/Edit/Controller.php', '21.12', 0),
('6a56bbce645ab1a1af8ae1138c410523', './lib/core/Services/Edit/ListConverter.php', '21.12', 0),
('f5d249ebcbf4e5692400b0b3cc4aa870', './lib/core/Services/Edit/ListPluginHelper.php', '21.12', 0),
('fbb95f67ed7c017bfc68ffd515c25b6c', './lib/core/Services/Edit/PluginController.php', '21.12', 0),
('d523e7bbbe2d434dec2bf975cae3ca4d', './lib/core/Services/Edit/SemaphoreController.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Edit/index.php', '21.12', 0),
('734644495f8cc8d5aca19283d7a66019', './lib/core/Services/Exception.php', '21.12', 0),
('3c571fb702d3b63e7e6fac15788dbbbe', './lib/core/Services/Exception/Denied.php', '21.12', 0),
('2aec7a15083546ac51748932c7359a6a', './lib/core/Services/Exception/Disabled.php', '21.12', 0),
('adefc868a4162cb246ddbb0c27dafe4e', './lib/core/Services/Exception/DuplicateValue.php', '21.12', 0),
('d5d36a9f4d97b085c264707df4708371', './lib/core/Services/Exception/EditConflict.php', '21.12', 0),
('76823285601ffcabea2af5897de24914', './lib/core/Services/Exception/FieldError.php', '21.12', 0),
('bf93ef396384bc38f982d6571716e4a8', './lib/core/Services/Exception/MissingValue.php', '21.12', 0),
('23b396c9cc15e36504472c65ce2bc818', './lib/core/Services/Exception/NotAvailable.php', '21.12', 0),
('64de2d488cf207611eadb90ca5ef5aeb', './lib/core/Services/Exception/NotFound.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Exception/index.php', '21.12', 0),
('e6c5fc925d367a70e2657202fed538e4', './lib/core/Services/Export/Controller.php', '21.12', 0),
('a95da6790f860ef0803d9a3fd2d587f0', './lib/core/Services/File/Controller.php', '21.12', 0),
('ef4dd8b4626a5f8e40f3fd7e20ae0cb0', './lib/core/Services/File/FinderController.php', '21.12', 0),
('4760d777599024c820e772d5c73e1a16', './lib/core/Services/File/Utilities.php', '21.12', 0),
('76151ba5268aca0303942204c70cb335', './lib/core/Services/File/VimeoController.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/File/index.php', '21.12', 0),
('55a9c77c6b791e0d61488065a1f5e410', './lib/core/Services/Forum/Controller.php', '21.12', 0),
('25cfe88f501a01ba33be3dd304977627', './lib/core/Services/Forum/index.php', '21.12', 0),
('8c9b9c0e9f40fd300c5314bc58f6fb38', './lib/core/Services/Goal/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Goal/index.php', '21.12', 0),
('0796703d3ddc278f7a6f20bcc81fea75', './lib/core/Services/Group/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Group/index.php', '21.12', 0),
('8dcae2c703888e9290db075ff21465c1', './lib/core/Services/H5P/Controller.php', '21.12', 0),
('cf6221a08a69880cacf17f57874d021e', './lib/core/Services/IDS/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/IDS/index.php', '21.12', 0),
('ba1b52e42f449f81a9b88eff18131143', './lib/core/Services/Kaltura/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Kaltura/index.php', '21.12', 0),
('e133b26a307fe5e1a6400f84f01c39ae', './lib/core/Services/Language/Controller.php', '21.12', 0),
('4a3c3f70762553ad287a38f253614e2e', './lib/core/Services/Language/TransifexController.php', '21.12', 0),
('24869907a383a926ed59a71dc07fff96', './lib/core/Services/Language/TranslationController.php', '21.12', 0),
('ba6afaa3171d0838bc1e6155c34cf821', './lib/core/Services/Language/TranslationReader.php', '21.12', 0),
('cd5c032af06ee8b8b520184740343519', './lib/core/Services/Language/Utilities.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Language/index.php', '21.12', 0),
('eb511204d4948a36744f24316fdf9ef2', './lib/core/Services/MailIn/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/MailIn/index.php', '21.12', 0),
('97ffc7493a3c9813218e0fd34c93fc95', './lib/core/Services/Menu/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Menu/index.php', '21.12', 0),
('684a0523e9eada9603f14555d69ed411', './lib/core/Services/Module/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Module/index.php', '21.12', 0),
('8395b18339b97ad6a807edeace0b93e4', './lib/core/Services/MustRead/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/MustRead/index.php', '21.12', 0),
('8f4a02696957b9e4907b5ff6079aa64d', './lib/core/Services/OAuthServer/Controller.php', '21.12', 0),
('eb7ac564016bee1cc25c65c6b1a544b9', './lib/core/Services/OAuthServer/JsonResponse.php', '21.12', 0),
('22cff768942e5d0a3317c9bee96c51e7', './lib/core/Services/Object/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Object/index.php', '21.12', 0),
('60679e08646aa497036c83e4f19431e7', './lib/core/Services/PDF/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/PDF/index.php', '21.12', 0),
('41be5caea144f666ed507bf55fdf45f1', './lib/core/Services/Payment/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Payment/index.php', '21.12', 0),
('926995e3addc40c42c30b55f3bd1ffff', './lib/core/Services/Rating/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Rating/index.php', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('164b79e6312a9d8fc709b04e3ae93dda', './lib/core/Services/Recommendation/DevelopmentController.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Recommendation/index.php', '21.12', 0),
('7e7d30325b2883f27b3522df1ee1f8b6', './lib/core/Services/Relation/Controller.php', '21.12', 0),
('25cfe88f501a01ba33be3dd304977627', './lib/core/Services/Relation/index.php', '21.12', 0),
('79c495b0089e76f01ad73792d5e188a2', './lib/core/Services/RemoteController.php', '21.12', 0),
('fee45c42995b34067e9bea6e0893c4f2', './lib/core/Services/ResultLoader.php', '21.12', 0),
('fbebc8ed9d27bebf6b33e891b7c9a1b8', './lib/core/Services/ResultLoader/WebService.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/ResultLoader/index.php', '21.12', 0),
('112329ba63a186b16a69c26affa7607f', './lib/core/Services/Scheduler/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Scheduler/index.php', '21.12', 0),
('4c8dcbcd3aca1cbcc64cdd9720e1194b', './lib/core/Services/Score/Controller.php', '21.12', 0),
('4915c2e86e25c96b85326a23a8a8b21b', './lib/core/Services/Search/Controller.php', '21.12', 0),
('2092089439f83dc152de22d599184959', './lib/core/Services/Search/CustomSearchController.php', '21.12', 0),
('96a564430ec1f9135050729df68f941e', './lib/core/Services/Search/ManifoldController.php', '21.12', 0),
('6b13fd2fb306513f1220aee43656f009', './lib/core/Services/Search/StoredController.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Search/index.php', '21.12', 0),
('2dfe07cddc4652bb26832ece00d45d0b', './lib/core/Services/ShowTikiOrg/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/ShowTikiOrg/index.php', '21.12', 0),
('57c29bbb53d5e22f1cc8bfe01790fd64', './lib/core/Services/StyleGuide/Controller.php', '21.12', 0),
('c38a140e25a224d65f5d121848dd3a35', './lib/core/Services/Suite/Controller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Suite/index.php', '21.12', 0),
('49ba68d92cce6650dd5d82141dbd95cd', './lib/core/Services/Tracker/CalendarController.php', '21.12', 0),
('2f722460004a00f0747a4b3dc169f18b', './lib/core/Services/Tracker/Controller.php', '21.12', 0),
('a243e087e16c0404b0a665f2d111b728', './lib/core/Services/Tracker/SyncController.php', '21.12', 0),
('ad4c34793aee8ff3c82c2975e1f9b6f3', './lib/core/Services/Tracker/TabularController.php', '21.12', 0),
('664bd8460243a0743692f1c87339575e', './lib/core/Services/Tracker/TodoController.php', '21.12', 0),
('08531216b96dc3f4a48932dc1dd4c67a', './lib/core/Services/Tracker/Utilities.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Tracker/index.php', '21.12', 0),
('ab27b3dd4a45f89245eac665f6340edd', './lib/core/Services/User/ConditionsController.php', '21.12', 0),
('459bb8145bf9b25c56b4f678a81a4949', './lib/core/Services/User/Controller.php', '21.12', 0),
('9e1cd910647e1a4107449affd1f6aebf', './lib/core/Services/User/FavoriteController.php', '21.12', 0),
('0eac91d785d16ace016bb91323fffb97', './lib/core/Services/User/MonitorController.php', '21.12', 0),
('67a767c04f2cbd5df69dcc885e404665', './lib/core/Services/User/SocialController.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/User/index.php', '21.12', 0),
('77029682c3ca757175a794098a9d6606', './lib/core/Services/Utilities.php', '21.12', 0),
('383eac347ba9795a8d4a907882689f26', './lib/core/Services/Wiki/Controller.php', '21.12', 0),
('c475fd0c65fe7b6da00858789c75265f', './lib/core/Services/Wiki/StructureController.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Wiki/index.php', '21.12', 0),
('c7cc00cbd5605f0485f35a784b92ef3e', './lib/core/Services/Workspace/Controller.php', '21.12', 0),
('561f0021544087d224addda5c8904343', './lib/core/Services/Workspace/ProfileAnalyser.php', '21.12', 0),
('fc2b7f71977b0be6765a236781386d54', './lib/core/Services/Workspace/ProfileBuilder.php', '21.12', 0),
('990c03e03afc3316500b665008049e3f', './lib/core/Services/Workspace/Utilities.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Services/Workspace/index.php', '21.12', 0),
('e11069c5f2135c631dde0d2f97b27b3f', './lib/core/Services/Xmpp/Controller.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Services/Xmpp/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Services/index.php', '21.12', 0),
('3845f68d5bb2c65b4b235f8bf43ada24', './lib/core/StandardAnalyzer/Analyzer/Standard.php', '21.12', 0),
('066a7e029f8f86305ab9cb97548b2f88', './lib/core/StandardAnalyzer/Analyzer/Standard/English.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/StandardAnalyzer/Analyzer/Standard/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/StandardAnalyzer/Analyzer/index.php', '21.12', 0),
('a486463988348494a67f2e3a68ee9cc2', './lib/core/StandardAnalyzer/TokenFilter/EnglishStemmer.php', '21.12', 0),
('bf087034d9601193b1728032f44dd647', './lib/core/StandardAnalyzer/TokenFilter/EnglishStemmer/PorterStemmer.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/core/StandardAnalyzer/TokenFilter/EnglishStemmer/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/StandardAnalyzer/TokenFilter/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/StandardAnalyzer/index.php', '21.12', 0),
('39aa4030348707395dce2920dae638d4', './lib/core/Table/Check.php', '21.12', 0),
('592c58bd17276e1c434b0a3c3e6288ea', './lib/core/Table/Code/Abstract.php', '21.12', 0),
('f47c1a1494341cdae83836711ff6dea8', './lib/core/Table/Code/Bind.php', '21.12', 0),
('bd80c6142792f82fd222cd1a2f5ce64e', './lib/core/Table/Code/MainOptions.php', '21.12', 0),
('a722dd27ea9261d676d2cb9155e72751', './lib/core/Table/Code/Manager.php', '21.12', 0),
('d5f1ba4d0212fd05515bd4d68733e6da', './lib/core/Table/Code/Other.php', '21.12', 0),
('d85a8acd8fd9741c008340e52e9f5fb7', './lib/core/Table/Code/WidgetOptions.php', '21.12', 0),
('60f154ce0f0980c3c953c129be24f65f', './lib/core/Table/Code/WidgetOptionsFilter.php', '21.12', 0),
('7196b2b4229aedb108e0e2406c100a39', './lib/core/Table/Code/WidgetOptionsMath.php', '21.12', 0),
('956f20a7d7984475f8be34b1452d6f18', './lib/core/Table/Code/WidgetOptionsPager.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Table/Code/index.php', '21.12', 0),
('7ecacd736b10c8295968958a265afe88', './lib/core/Table/Factory.php', '21.12', 0),
('3a8b91d6890af6c75b7d9a2c3329b81c', './lib/core/Table/Manager.php', '21.12', 0),
('ca152e5c3149115343e0dd38882d33d4', './lib/core/Table/Plugin.php', '21.12', 0),
('cce0d9f365a6b6828bbce642a1509b59', './lib/core/Table/Settings/Abstract.php', '21.12', 0),
('6c9d1d41c1602aede3a8841953380996', './lib/core/Table/Settings/Plugin.php', '21.12', 0),
('6b87acf78c3c31d4ec9a41473231d752', './lib/core/Table/Settings/PluginWithAjax.php', '21.12', 0),
('6de02c4296d9fd3f218504ce6af10966', './lib/core/Table/Settings/Standard.php', '21.12', 0),
('76f023b294b1ade84e55b97afd36e643', './lib/core/Table/Settings/TikiAdminForums.php', '21.12', 0),
('148a5601d36d081cc9d82700121d7de5', './lib/core/Table/Settings/TikiAdminGroups.php', '21.12', 0),
('f432f6c8972454d94ea73d17d7e3fcfe', './lib/core/Table/Settings/TikiAdminGroupsBanned.php', '21.12', 0),
('d3e6d798030c3ef22c935ef697f16253', './lib/core/Table/Settings/TikiAdminGroupsMembers.php', '21.12', 0),
('611c37fa74a7f7a7899988a2529c89c1', './lib/core/Table/Settings/TikiAdminusers.php', '21.12', 0),
('d5903b8e1b18d2d91a8234071f6a44a2', './lib/core/Table/Settings/TikiForums.php', '21.12', 0),
('210e4cc01ef8f9d7d3d6cb0e301c03e2', './lib/core/Table/Settings/TikiListpages.php', '21.12', 0),
('9904676e6954bc13bf8291cd85108c7d', './lib/core/Table/Settings/TikiPayment.php', '21.12', 0),
('8f6a02b0bbea4fd7b639c007f58fd23c', './lib/core/Table/Settings/TikiPaymentPast.php', '21.12', 0),
('6e14f1faf7d47db751f37b14be1b8007', './lib/core/Table/Settings/TikiViewforum.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Table/Settings/index.php', '21.12', 0),
('5043095fbbfffa0473ed5b813a46cb6a', './lib/core/Table/Totals.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Table/index.php', '21.12', 0),
('3e3115938fa08240811f2e62f2a42b2a', './lib/core/Tiki/Autoload.php', '21.12', 0),
('55395a31fb3f6c8259ed157abb8ae525', './lib/core/Tiki/BigBlueButton/Configuration.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/BigBlueButton/index.php', '21.12', 0),
('8b088e96df2dcc6b8139a370fc9540eb', './lib/core/Tiki/Command/AdminIndexRebuildCommand.php', '21.12', 0),
('5e9dc9feedfd499171729fcc9fc65506', './lib/core/Tiki/Command/Application.php', '21.12', 0),
('c753cbf1857093b1cc2bb4e6bd2f890b', './lib/core/Tiki/Command/BackupDBCommand.php', '21.12', 0),
('b2725e6926f69e06de14afe745c24711', './lib/core/Tiki/Command/BackupFilesCommand.php', '21.12', 0),
('9799056b2d1ae35511bbae63bca39bee', './lib/core/Tiki/Command/CacheClearCommand.php', '21.12', 0),
('e47ce572e64e674d36c5a98239f4d1ea', './lib/core/Tiki/Command/CacheGenerateCommand.php', '21.12', 0),
('b1dbe31b38431a937bcd696fc36aaf36', './lib/core/Tiki/Command/CommandUnavailableException.php', '21.12', 0),
('81c5aedec10202f01c73ce52520d0062', './lib/core/Tiki/Command/ConfigureCommand.php', '21.12', 0),
('aafbd4675e14cbe7947900fa0dd05ef9', './lib/core/Tiki/Command/ConsoleApplicationBuilder.php', '21.12', 0),
('ec9ed2dc9aa3301db327992701069bdd', './lib/core/Tiki/Command/ConsoleSetupException.php', '21.12', 0),
('addcad36071026f19d4ac833d88fc44d', './lib/core/Tiki/Command/DailyReportSendCommand.php', '21.12', 0),
('13030b6600b48d7fd8de59130001f889', './lib/core/Tiki/Command/EnglishUpdateCommand.php', '21.12', 0),
('1175144736ba86b0bf265e4680d3d05f', './lib/core/Tiki/Command/FakerCommentsCommand.php', '21.12', 0),
('b0570a81730dbc8234c5fc4dbacdce9f', './lib/core/Tiki/Command/FakerTrackerCommand.php', '21.12', 0),
('92f1cca696671379ba8ac6a08ecc2c3f', './lib/core/Tiki/Command/FilesBatchuploadCommand.php', '21.12', 0),
('07d078adfd09377c013faaaceb056b28', './lib/core/Tiki/Command/FilesCheckCommand.php', '21.12', 0),
('ade6c679d07e115ff6252f1178a21719', './lib/core/Tiki/Command/FilesCopyCommand.php', '21.12', 0),
('f0fd48c51d0c42455fd9a1fbadd8e946', './lib/core/Tiki/Command/FilesDeleteoldCommand.php', '21.12', 0),
('2e083ab35da86ab509d3a22c1c8e9171', './lib/core/Tiki/Command/FilesMoveCommand.php', '21.12', 0),
('ac6ecef9db6fb696533abee1d63caaf4', './lib/core/Tiki/Command/FixBOMandUnixCommand.php', '21.12', 0),
('cfc4e4754f40d4a17c5c3ad2aacc0832', './lib/core/Tiki/Command/FixSVNKeyIdsCommand.php', '21.12', 0),
('2d32b96213efd60e424330d0e6425caa', './lib/core/Tiki/Command/GalleryMigrateCommand.php', '21.12', 0),
('4307dec97e76e34feb6162a07ee00820', './lib/core/Tiki/Command/GetStringsCommand.php', '21.12', 0),
('15cf9c364c4d606eb61ebbf0ea509c31', './lib/core/Tiki/Command/GoalCheckCommand.php', '21.12', 0),
('c5b7ccdf2ef7cfbc84b88f69c4039153', './lib/core/Tiki/Command/IndexCatchUpCommand.php', '21.12', 0),
('77e6cf6fc3f7d8d4b54b07afcc7df13c', './lib/core/Tiki/Command/IndexOptimizeCommand.php', '21.12', 0),
('b0ecd9896458cd8fe435fe9588acb8e4', './lib/core/Tiki/Command/IndexRebuildCommand.php', '21.12', 0),
('9684896c69f34d3a914bf126733a0da2', './lib/core/Tiki/Command/InstallCommand.php', '21.12', 0),
('be4d1a6088444fa136a8b81c08210d29', './lib/core/Tiki/Command/InstallerLockCommand.php', '21.12', 0),
('6ecf51c687dd0b54de85ce967c44728f', './lib/core/Tiki/Command/ListExecuteCommand.php', '21.12', 0),
('3896948a871d2bbc4d5eafafa22b78ee', './lib/core/Tiki/Command/MailInPollCommand.php', '21.12', 0),
('281f40391057446de53df3ef7f91ed20', './lib/core/Tiki/Command/MailQueueSendCommand.php', '21.12', 0),
('b56ad76f3a8bdef0672d37413e2367f3', './lib/core/Tiki/Command/MultiTikiListCommand.php', '21.12', 0),
('a74c1c261f3b106eff9431a77db9b099', './lib/core/Tiki/Command/MultiTikiMoveCommand.php', '21.12', 0),
('dce0e2b233ffb057911a9c18b94ac52e', './lib/core/Tiki/Command/NotificationDigestCommand.php', '21.12', 0),
('3e10b0585094f363b8bc3f653b4f6617', './lib/core/Tiki/Command/OCRAllCommand.php', '21.12', 0),
('3e2838aec4ddbed697bc44b1fdc713e0', './lib/core/Tiki/Command/OCRFileCommand.php', '21.12', 0),
('4beeefbd5ea24912ce43aed60cc77c00', './lib/core/Tiki/Command/OCRSetCommand.php', '21.12', 0),
('fe7aeabca691b09d7db136c0c92ec53b', './lib/core/Tiki/Command/OCRStatusCommand.php', '21.12', 0),
('6d5f397fb0e6f3cd9f0dac8f127ea655', './lib/core/Tiki/Command/ObjectsNotifyMaintainersCommand.php', '21.12', 0),
('d0efad5621a37b8a0b8b25f43fa296ba', './lib/core/Tiki/Command/PackageClearCacheCommand.php', '21.12', 0),
('d38c6d5d339afe00625b2f3dc5401819', './lib/core/Tiki/Command/PackageDisableCommand.php', '21.12', 0),
('5740aff81d05189b821451ef2368041f', './lib/core/Tiki/Command/PackageEnableCommand.php', '21.12', 0),
('8376b0025932a5cea2570cc490efa69c', './lib/core/Tiki/Command/PackageInstallCommand.php', '21.12', 0),
('d32c6482f47dd8f1e6890f5606583dbf', './lib/core/Tiki/Command/PackageListCommand.php', '21.12', 0),
('e2cb7b7293ffcc3533eea6b865d1b472', './lib/core/Tiki/Command/PackageRemoveCommand.php', '21.12', 0),
('019bdb18bc3726957528ae7bdaf4ee16', './lib/core/Tiki/Command/PackageUpdateCommand.php', '21.12', 0),
('b228e1e9528985568fb6c365d3adde40', './lib/core/Tiki/Command/PatchCommand.php', '21.12', 0),
('fb05a4ee9d96bff642b4fe28ba77fc30', './lib/core/Tiki/Command/PluginApproveRunCommand.php', '21.12', 0),
('f8aeca99d024f6a2b58a1d3b56ba7835', './lib/core/Tiki/Command/PluginListRunCommand.php', '21.12', 0),
('ae7c5c611811bc240cfa6e9e6bbdcf0c', './lib/core/Tiki/Command/PluginRefreshRunCommand.php', '21.12', 0),
('4dc12a128e3dc3e4992f1b853bc8650e', './lib/core/Tiki/Command/PreferencesDeleteCommand.php', '21.12', 0),
('f2ad5288aeec370f90fd4fc9f642f432', './lib/core/Tiki/Command/PreferencesExportCommand.php', '21.12', 0),
('52f83153333508a3c3bee4954edc7887', './lib/core/Tiki/Command/PreferencesGetCommand.php', '21.12', 0),
('00b5f566bda508ce9643df1eff37e607', './lib/core/Tiki/Command/PreferencesSetCommand.php', '21.12', 0),
('8a899fb67157093c94f74d50c28bb645', './lib/core/Tiki/Command/ProfileBaselineCommand.php', '21.12', 0),
('28bc5243bab5a963effa4dc24026ecea', './lib/core/Tiki/Command/ProfileExport/ActivityRuleSet.php', '21.12', 0),
('4276f32275c8e86ef49b6f807f96e7d3', './lib/core/Tiki/Command/ProfileExport/ActivityStreamRule.php', '21.12', 0),
('6406c39a09ca74e4f6314a9b7af065a8', './lib/core/Tiki/Command/ProfileExport/AllModules.php', '21.12', 0),
('99065c4bfa9f4c92f8dafc98eabab5a7', './lib/core/Tiki/Command/ProfileExport/Article.php', '21.12', 0),
('c6b361731afd422107096eff33c97625', './lib/core/Tiki/Command/ProfileExport/ArticleTopic.php', '21.12', 0),
('9e5cea9f04f821d66fe7710c6e0ebf3b', './lib/core/Tiki/Command/ProfileExport/ArticleType.php', '21.12', 0),
('db401ea976ad684ff1d2321c97bc1a0d', './lib/core/Tiki/Command/ProfileExport/Calendar.php', '21.12', 0),
('438926b98698ef80be599b1662c75f6a', './lib/core/Tiki/Command/ProfileExport/Category.php', '21.12', 0),
('a1e302b7101c64c5373abf768b5a34e9', './lib/core/Tiki/Command/ProfileExport/FileGallery.php', '21.12', 0),
('b356449f8c12ba684cca4de430a7fd2f', './lib/core/Tiki/Command/ProfileExport/Finalize.php', '21.12', 0),
('82ee8053f37a6a03668a95f8de28b89f', './lib/core/Tiki/Command/ProfileExport/Forum.php', '21.12', 0),
('833d42bd1fc68551374aad11b199a1d1', './lib/core/Tiki/Command/ProfileExport/Goal.php', '21.12', 0),
('a0ebf4576bb62a6d5b454783a599e7ce', './lib/core/Tiki/Command/ProfileExport/GoalSet.php', '21.12', 0),
('c1189d9e9b8c7db8229b5855cd9b3742', './lib/core/Tiki/Command/ProfileExport/Group.php', '21.12', 0),
('86f8626785a6d007125f3fdc14425303', './lib/core/Tiki/Command/ProfileExport/IncludeProfile.php', '21.12', 0),
('c5d4e031d1c83cbc65cbe8589e16f40f', './lib/core/Tiki/Command/ProfileExport/Init.php', '21.12', 0),
('e3eca7f159ce735884d9880a104cc07a', './lib/core/Tiki/Command/ProfileExport/Menu.php', '21.12', 0),
('0853a52c1d32eda0c9e8eb00aa5276e9', './lib/core/Tiki/Command/ProfileExport/Module.php', '21.12', 0),
('c10cbe8b5153032181def922e93965e5', './lib/core/Tiki/Command/ProfileExport/ObjectWriter.php', '21.12', 0),
('02061639185ed5d6afbcd8987052274f', './lib/core/Tiki/Command/ProfileExport/Preference.php', '21.12', 0),
('8a6468074921188d1c6f7fe988afdb06', './lib/core/Tiki/Command/ProfileExport/RatingConfig.php', '21.12', 0),
('2d9fe0ad052411c87bc43edf552422fa', './lib/core/Tiki/Command/ProfileExport/RatingConfigSet.php', '21.12', 0),
('ffabb2590e813b539c385b956955cf58', './lib/core/Tiki/Command/ProfileExport/RecentChanges.php', '21.12', 0),
('d1a112eac39d27308fd11e6c5af744a7', './lib/core/Tiki/Command/ProfileExport/Rss.php', '21.12', 0),
('5f64e8a2f430e5284b168371a885952a', './lib/core/Tiki/Command/ProfileExport/Tracker.php', '21.12', 0),
('0a2d182ccf8a7492001e8d54c532bd1a', './lib/core/Tiki/Command/ProfileExport/TrackerField.php', '21.12', 0),
('5142ef87c42f2e861ccdc5b2059c191b', './lib/core/Tiki/Command/ProfileExport/TrackerItem.php', '21.12', 0),
('8a6e50b3b7e1a04e0fdcf325ae627849', './lib/core/Tiki/Command/ProfileExport/WikiPage.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Command/ProfileExport/index.php', '21.12', 0),
('f47d583b0afd00b556cde71c8211b4f4', './lib/core/Tiki/Command/ProfileForgetCommand.php', '21.12', 0),
('c1c0bc7b8b9941809311841f3b792661', './lib/core/Tiki/Command/ProfileInstallCommand.php', '21.12', 0),
('353eb4e1b0689b1a5d9f23e90273fabf', './lib/core/Tiki/Command/RecommendationBatchCommand.php', '21.12', 0),
('f086c5e7aaceffafa28943b98f1eac85', './lib/core/Tiki/Command/RedactDBCommand.php', '21.12', 0),
('2ff6ef5a35bf9450ad7399e24af4dee4', './lib/core/Tiki/Command/RefreshRssCommand.php', '21.12', 0),
('76c7ed97c81d0c3033f397b7ed695743', './lib/core/Tiki/Command/RssClearCacheCommand.php', '21.12', 0),
('51c198a9413686af762429773f9da2ec', './lib/core/Tiki/Command/SchedulerHealCommand.php', '21.12', 0),
('d37d8950894d111c74cff5e9b3f2a14d', './lib/core/Tiki/Command/SchedulerRunCommand.php', '21.12', 0),
('e44a1db605ea69617c516f1ba4ebf80a', './lib/core/Tiki/Command/ScssCompileCommand.php', '21.12', 0),
('4c75da06514335bcb1657f1865417ce7', './lib/core/Tiki/Command/SemiAutoMergeCommand.php', '21.12', 0),
('f5aa60fa0955dc39ae11f7bcc32dcbc5', './lib/core/Tiki/Command/SitemapGenerateCommand.php', '21.12', 0),
('04c6d160414b23f2b0ca6baad6574d1c', './lib/core/Tiki/Command/StatsCommand.php', '21.12', 0),
('0e3ab9b4160f83764b0fbf734d60fb0a', './lib/core/Tiki/Command/ThemeInstallCommand.php', '21.12', 0),
('ce06204db40450d8f687ef3219bb9989', './lib/core/Tiki/Command/ThemeRemoveCommand.php', '21.12', 0),
('c0df3204075cb40e8e644d3451700001', './lib/core/Tiki/Command/ThemeUpdateCommand.php', '21.12', 0),
('fc68f11c58516066598f839576f2993c', './lib/core/Tiki/Command/TikiInfoCommand.php', '21.12', 0),
('1a99fc65c0ee49fed538d9e7d1c73e95', './lib/core/Tiki/Command/TrackerClearCommand.php', '21.12', 0),
('235cd13a592b88dd5b69c11550c05d85', './lib/core/Tiki/Command/TrackerExportCommand.php', '21.12', 0),
('0fc564525f05558425d4e06da565357e', './lib/core/Tiki/Command/TrackerImportCommand.php', '21.12', 0),
('2fe943e53b813c4b42db66fc99731a1d', './lib/core/Tiki/Command/UpdateCommand.php', '21.12', 0),
('a008aa245efc2ae61fcdd01c9b5e4dea', './lib/core/Tiki/Command/UserCreateCommand.php', '21.12', 0),
('abaef20460bee52c7cce4e227aea425c', './lib/core/Tiki/Command/UserUnlockCommand.php', '21.12', 0),
('ed65f445a989f54464b1c5e25a27e270', './lib/core/Tiki/Command/UsersListCommand.php', '21.12', 0),
('3fc13587de323b857ab26727a98d6e62', './lib/core/Tiki/Command/UsersPasswordCommand.php', '21.12', 0),
('1900ce1dfc79f63b64667049bb971151', './lib/core/Tiki/Command/UsersTemporaryCommand.php', '21.12', 0),
('8febec07a729d9bc3d9300d1288aa842', './lib/core/Tiki/Command/VCSUpdateCommand.php', '21.12', 0),
('e5675ddd142f1d32834cefcd2aaba8ca', './lib/core/Tiki/Command/VendorSecurityCommand.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Command/index.php', '21.12', 0),
('c881080e467e050d529d427c2cf564d2', './lib/core/Tiki/Composer/Autoload.php', '21.12', 0),
('f14da48d8022a8fffccdfd4591ef0e1f', './lib/core/Tiki/Composer/BootstrapCompiler.php', '21.12', 0),
('3535ee0ca7c5ea98cf45879091379d7a', './lib/core/Tiki/Composer/CleanVendorAfterVendorBundledMigration.php', '21.12', 0),
('5978c986b9721f18b66752fa6d9bddc8', './lib/core/Tiki/Composer/CleanVendors.php', '21.12', 0),
('b5cb96869901e5ee05039de2d345b3dd', './lib/core/Tiki/Composer/PatchCypht.php', '21.12', 0),
('7e5b9c81bb0c9ea3f44cf5066fdae226', './lib/core/Tiki/Composer/RestoreVendors.php', '21.12', 0),
('9c03093c36a5d1004a17d54d18947d23', './lib/core/Tiki/Composer/ThemeInstaller.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Composer/index.php', '21.12', 0),
('e6ad62f89a8dd33d3eea78d302506b13', './lib/core/Tiki/Config/Ini.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Tiki/Config/index.php', '21.12', 0),
('c72b4810daba78db15191f0fd61e27f3', './lib/core/Tiki/Connect/Abstract.php', '21.12', 0),
('2db6f6e44df5e9efc36a07059ea01a79', './lib/core/Tiki/Connect/Client.php', '21.12', 0),
('10388f3a46e117b5bfdaa3391855ab02', './lib/core/Tiki/Connect/Server.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Tiki/Connect/index.php', '21.12', 0),
('7a56dc179c4b53c693ffa25828781084', './lib/core/Tiki/Editable/Value.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Editable/index.php', '21.12', 0),
('06c8bc120d1d491565a6dd635ad57fae', './lib/core/Tiki/Event/Chain.php', '21.12', 0),
('547ad2bf8f3c0c3b56786ad6f39e4db0', './lib/core/Tiki/Event/Customizer.php', '21.12', 0),
('f31754457cd9ca55c6f733743a55e13c', './lib/core/Tiki/Event/Customizer/Executor.php', '21.12', 0),
('770f506c6858654ba4d212d129cc8b8a', './lib/core/Tiki/Event/Customizer/RuleSet.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Event/Customizer/index.php', '21.12', 0),
('b92193f19963ab324c05aa7df1c6257f', './lib/core/Tiki/Event/EdgeProvider.php', '21.12', 0),
('020d59b89a28f99b726ba8968ccac086', './lib/core/Tiki/Event/Function/EventLog.php', '21.12', 0),
('af85f808a169f623113cd9d6f6655cc8', './lib/core/Tiki/Event/Function/EventNotify.php', '21.12', 0),
('f77f03e660161eec39ef87774a389749', './lib/core/Tiki/Event/Function/EventRecord.php', '21.12', 0),
('c4341fda9ea0f7994f92f03f38918df2', './lib/core/Tiki/Event/Function/EventSample.php', '21.12', 0),
('f6c3ed0cb57015e25a119498d2ed0a38', './lib/core/Tiki/Event/Function/EventTrigger.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Event/Function/index.php', '21.12', 0),
('488484a1f0c9e2dd37924debb92d0eba', './lib/core/Tiki/Event/Lib.php', '21.12', 0),
('61f14340baa3d1bddb8efd16a91bf31d', './lib/core/Tiki/Event/Manager.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Tiki/Event/index.php', '21.12', 0),
('e6468d122a0f5806b6fd0cc8a78c9035', './lib/core/Tiki/Faker.php', '21.12', 0),
('0b6dc2171cb60bf8680dc9a003e16a21', './lib/core/Tiki/FileGallery/Definition.php', '21.12', 0),
('80e34f8d0c1fefd25386e00bda6c8e92', './lib/core/Tiki/FileGallery/File.php', '21.12', 0),
('5698f5395c1f50cdd247bdfe74135382', './lib/core/Tiki/FileGallery/FileDraft.php', '21.12', 0),
('9a05c100aa31aacab8c91a95990a1b4f', './lib/core/Tiki/FileGallery/FileWrapper/PhysicalFile.php', '21.12', 0),
('7577a1fe77af9e0392fed9141c82cc2c', './lib/core/Tiki/FileGallery/FileWrapper/PreloadedContent.php', '21.12', 0),
('3e203b1ddf52eae1840fd197e6f97e45', './lib/core/Tiki/FileGallery/FileWrapper/WrapperInterface.php', '21.12', 0),
('e8e73ba65ec8a8ed67d0b7b783601107', './lib/core/Tiki/FileGallery/FileWrapper/WriteException.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/FileGallery/FileWrapper/index.php', '21.12', 0),
('7a740247973b90079adcbaf02a545940', './lib/core/Tiki/FileGallery/Handler/FileSystem.php', '21.12', 0),
('11f33435032761c613152f875860d23e', './lib/core/Tiki/FileGallery/Handler/HandlerInterface.php', '21.12', 0),
('133880db1de9067907f300271ae7fb17', './lib/core/Tiki/FileGallery/Handler/Podcast.php', '21.12', 0),
('f461145153beb2e8636d4c3c8299adf4', './lib/core/Tiki/FileGallery/Handler/Preloaded.php', '21.12', 0),
('5ba2ecf311a7d66214396dc8d026f4e2', './lib/core/Tiki/FileGallery/Handler/System.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/FileGallery/Handler/index.php', '21.12', 0),
('6398d13607abbd89eb6036a44c8903e9', './lib/core/Tiki/FileGallery/Manipulator/ImageTransformer.php', '21.12', 0),
('ff55246680eabffa436c9238c3bdb1a6', './lib/core/Tiki/FileGallery/Manipulator/Manipulator.php', '21.12', 0),
('f167ed7c8767d143b543a4ca17111d04', './lib/core/Tiki/FileGallery/Manipulator/MetadataExtractor.php', '21.12', 0),
('bf060ea994760ef81cb3cc15bbe8fb3e', './lib/core/Tiki/FileGallery/Manipulator/Validator.php', '21.12', 0),
('f315cd649a4bfcd2bd8bc704f0e63cbd', './lib/core/Tiki/FileGallery/SaveHandler.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Tiki/FileGallery/index.php', '21.12', 0),
('d6e857fb775030e22e5effde8fdf348c', './lib/core/Tiki/Files/AbstractCheckGallery.php', '21.12', 0),
('5461087b4dbf3af1e2d19c8648b3862d', './lib/core/Tiki/Files/CheckAttachmentGallery.php', '21.12', 0),
('b40773b2ebc9fd2a7f5d03774a97f9d7', './lib/core/Tiki/Files/CheckFileGallery.php', '21.12', 0),
('9cc7f8903d54a4405721b72b29a42d45', './lib/core/Tiki/Files/CheckImageGallery.php', '21.12', 0),
('3d182939288bb51c3c43edc651873439', './lib/core/Tiki/Log.php', '21.12', 0),
('757a2ee6645db0e4b26ed7cb7ab4bf4d', './lib/core/Tiki/MailIn/Account.php', '21.12', 0),
('6c6e2cc703032a8e67cc200b663da570', './lib/core/Tiki/MailIn/Action/ActionInterface.php', '21.12', 0),
('cda151c09f9c4b5b6b1c2725ac125ea4', './lib/core/Tiki/MailIn/Action/ArticlePut.php', '21.12', 0),
('35f93fc9880d889799a45cbcb9c3994d', './lib/core/Tiki/MailIn/Action/Comment.php', '21.12', 0),
('3548e0e0fc84782466d9f91e10372faf', './lib/core/Tiki/MailIn/Action/DirectFactory.php', '21.12', 0),
('547f3d7272b735f51785c753d1682104', './lib/core/Tiki/MailIn/Action/FactoryInterface.php', '21.12', 0),
('60b92aed93f8df1ac1b2eab470a162c6', './lib/core/Tiki/MailIn/Action/RecipientPlaceholderFactory.php', '21.12', 0),
('90e2c0b85973465ed79ca0ba135933f0', './lib/core/Tiki/MailIn/Action/SubjectPrefixFactory.php', '21.12', 0),
('688ee80ee03daaa16cb4d72df6fa0747', './lib/core/Tiki/MailIn/Action/WikiAppend.php', '21.12', 0),
('e660c0408fa7dedf68a83c996687993a', './lib/core/Tiki/MailIn/Action/WikiGet.php', '21.12', 0),
('14806854ed2ae743c221d976b85033ad', './lib/core/Tiki/MailIn/Action/WikiPrepend.php', '21.12', 0),
('a8a46c22c1e5ac622953ead7676b5bf8', './lib/core/Tiki/MailIn/Action/WikiPut.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/MailIn/Action/index.php', '21.12', 0),
('7ad1de75bd9e374229844ea009ab12e9', './lib/core/Tiki/MailIn/Exception/MailInException.php', '21.12', 0),
('6c5a73b028c54a9eda0bca2f24dc97b9', './lib/core/Tiki/MailIn/Exception/TransportException.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/MailIn/Exception/index.php', '21.12', 0),
('af38d52c2ef272cfc7e819dcfc124f2f', './lib/core/Tiki/MailIn/Provider/ArticlePutProvider.php', '21.12', 0),
('884ed66d3c7c65ec46bc65c0709e2fc2', './lib/core/Tiki/MailIn/Provider/BasicWikiProvider.php', '21.12', 0),
('1a77216aa6e4d5327b1c1c8d5c7edce3', './lib/core/Tiki/MailIn/Provider/CompilerPass.php', '21.12', 0),
('dd7f87306a631b32bec4aefc77975334', './lib/core/Tiki/MailIn/Provider/ProviderInterface.php', '21.12', 0),
('6aaeb437e6a2ed24b7aab920784253ff', './lib/core/Tiki/MailIn/Provider/ProviderList.php', '21.12', 0),
('2210cd38802fbfa2c546758417c33478', './lib/core/Tiki/MailIn/Provider/ReplyHandlerProvider.php', '21.12', 0),
('136e64e59f2a3cb5aa855d5021697085', './lib/core/Tiki/MailIn/Provider/WikiMultipleProvider.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/MailIn/Provider/index.php', '21.12', 0),
('cd9c95d158fd227c041bc59734d31b53', './lib/core/Tiki/MailIn/Source/Imap.php', '21.12', 0),
('2305a5144461dd52ad435415ee78d577', './lib/core/Tiki/MailIn/Source/Message.php', '21.12', 0),
('274191c37bbff5f6a27db2d5bcc883b0', './lib/core/Tiki/MailIn/Source/Pop3.php', '21.12', 0),
('259a9025ca86ab79f7c3cab38d3c0727', './lib/core/Tiki/MailIn/Source/SourceInterface.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/MailIn/Source/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/MailIn/index.php', '21.12', 0),
('8dc6d10fdd1631033eba5033562215d1', './lib/core/Tiki/MemoryLimit.php', '21.12', 0),
('8f10718a48f44c19edf8769443b21d8f', './lib/core/Tiki/ObjectSelector/Selector.php', '21.12', 0),
('e29358cc43f1a0cd46eae0eb487c200f', './lib/core/Tiki/ObjectSelector/SelectorItem.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/ObjectSelector/index.php', '21.12', 0),
('357edd6eeba016114a33d018409a6af7', './lib/core/Tiki/Package/ComposerCli.php', '21.12', 0),
('858d1505e165fe8b46d9ccbe01029671', './lib/core/Tiki/Package/ComposerManager.php', '21.12', 0),
('9e296fc579903e90788d1c978367f4fc', './lib/core/Tiki/Package/ComposerPackage.php', '21.12', 0),
('47ba084e0e44005a54e8f5bc7962722d', './lib/core/Tiki/Package/Extension/Api.php', '21.12', 0),
('cf1715f3ee8227f1114e8ef5829c3d22', './lib/core/Tiki/Package/Extension/Api/Events.php', '21.12', 0),
('1afdd5a0a019acc8a5807b78e178f3ae', './lib/core/Tiki/Package/Extension/Api/Search.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Package/Extension/Api/index.php', '21.12', 0),
('34fa4fc41990e6b066a0464849bdb37e', './lib/core/Tiki/Package/Extension/Extension.php', '21.12', 0),
('8d1dbcea78f6e6b0123697c945878287', './lib/core/Tiki/Package/Extension/Utilities.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Package/Extension/index.php', '21.12', 0),
('1ab2f9ce5bc5e0cc94f863fcefde1f0e', './lib/core/Tiki/Package/ExtensionManager.php', '21.12', 0),
('abe96d118ebb2f4c33129fec5ddb0565', './lib/core/Tiki/Package/PackageCommandHelper.php', '21.12', 0),
('7cc4fcc8b921bb050c26c3fa9e1a937d', './lib/core/Tiki/Package/VendorHelper.php', '21.12', 0),
('46f04738a236b4b8be7188b5c016d42b', './lib/core/Tiki/PageCache.php', '21.12', 0),
('2c944ca22b85f4d75432ddf7265ad2cc', './lib/core/Tiki/Profile.php', '21.12', 0),
('2608668907ef13f7d101ed130ba58d15', './lib/core/Tiki/Profile/ChannelList.php', '21.12', 0),
('e7dc4641c1d577ac4b0a999de2662a80', './lib/core/Tiki/Profile/Converter.php', '21.12', 0),
('6386ffa7a106b9face1eff7fecfeb505', './lib/core/Tiki/Profile/DateConverter.php', '21.12', 0),
('d3261850365b250f0070a345a181998b', './lib/core/Tiki/Profile/InstallHandler.php', '21.12', 0),
('6518b53d2ca96478efa0320f4a42ec22', './lib/core/Tiki/Profile/InstallHandler/ActivityRuleSet.php', '21.12', 0),
('d9ec8dea306363a5c286dd5cf72a91b8', './lib/core/Tiki/Profile/InstallHandler/ActivityStreamRule.php', '21.12', 0),
('21a96420fd2a83c49e08bc35acb0f919', './lib/core/Tiki/Profile/InstallHandler/AreaBinding.php', '21.12', 0),
('bc0f50532daa683b29d1d2cb6dfc94b5', './lib/core/Tiki/Profile/InstallHandler/Article.php', '21.12', 0),
('6c54dd39e46c45db3bee6e4d78a1578a', './lib/core/Tiki/Profile/InstallHandler/ArticleTopic.php', '21.12', 0),
('e092b121937bc150343e71edb32d1d4d', './lib/core/Tiki/Profile/InstallHandler/ArticleType.php', '21.12', 0),
('1d0aca03b56281dfc560a4728116276a', './lib/core/Tiki/Profile/InstallHandler/Blog.php', '21.12', 0),
('d0956c0317da116c9435ae61ff4fa554', './lib/core/Tiki/Profile/InstallHandler/BlogPost.php', '21.12', 0),
('12ae163f69150b3bf36124831b68f2ca', './lib/core/Tiki/Profile/InstallHandler/Calendar.php', '21.12', 0),
('e9d35e05e885e4d807669de8cf43260e', './lib/core/Tiki/Profile/InstallHandler/Categorize.php', '21.12', 0),
('fd437898018fb7e16e649459b778ea4e', './lib/core/Tiki/Profile/InstallHandler/Category.php', '21.12', 0),
('e98c19ff3a3e056fcf284b29f2fc0716', './lib/core/Tiki/Profile/InstallHandler/DataChannel.php', '21.12', 0),
('f84f9dbc79e3df5ca69b74d9e1f6ea53', './lib/core/Tiki/Profile/InstallHandler/ExtWiki.php', '21.12', 0),
('5693778bf5efd9220c719ad7b4311a64', './lib/core/Tiki/Profile/InstallHandler/FileGallery.php', '21.12', 0),
('cacd7b00b307d5f335097f5f79f15caf', './lib/core/Tiki/Profile/InstallHandler/Forum.php', '21.12', 0),
('3b03ed6b5324aabb6e2c7edb1a48821f', './lib/core/Tiki/Profile/InstallHandler/Goal.php', '21.12', 0),
('693fb1d514bd82b12cc1db9dd64faf81', './lib/core/Tiki/Profile/InstallHandler/GoalSet.php', '21.12', 0),
('de1e2cd2fcfa0cf6e426703a03d0ae82', './lib/core/Tiki/Profile/InstallHandler/Menu.php', '21.12', 0),
('93b5b74ac493aa83a5f013191b816da8', './lib/core/Tiki/Profile/InstallHandler/MenuOption.php', '21.12', 0),
('406723658189b911f7c00661e58c5176', './lib/core/Tiki/Profile/InstallHandler/Module.php', '21.12', 0),
('27ddd4c14583309c5001f19eb226fd7d', './lib/core/Tiki/Profile/InstallHandler/Perspective.php', '21.12', 0),
('f94c805ed45e1db8845bfe18dd49f5fd', './lib/core/Tiki/Profile/InstallHandler/PluginAlias.php', '21.12', 0),
('ebeb6ac6180be1841737f2181b95220c', './lib/core/Tiki/Profile/InstallHandler/RatingConfig.php', '21.12', 0),
('528e000c05796c01c566565564ae99ea', './lib/core/Tiki/Profile/InstallHandler/RatingConfigSet.php', '21.12', 0),
('4193f5f0d3cc2204b3f233f0aaaae1a4', './lib/core/Tiki/Profile/InstallHandler/Rss.php', '21.12', 0),
('0d36d1bfac7b3466cc0510faf83e2ae6', './lib/core/Tiki/Profile/InstallHandler/Scheduler.php', '21.12', 0),
('1ba69d0e097ac2334e8994513f81fdf3', './lib/core/Tiki/Profile/InstallHandler/Sheet.php', '21.12', 0),
('01fd4240ba37d71bbe785bfb0e86cd91', './lib/core/Tiki/Profile/InstallHandler/Template.php', '21.12', 0),
('a8c1583c4a75c465d1f1b665f2aa1cf2', './lib/core/Tiki/Profile/InstallHandler/Tracker.php', '21.12', 0),
('6deb42c5676e5379d8b8095f39c90206', './lib/core/Tiki/Profile/InstallHandler/TrackerField.php', '21.12', 0),
('8650a45f3cefd1505b2e769d7bd8340a', './lib/core/Tiki/Profile/InstallHandler/TrackerItem.php', '21.12', 0),
('7bd7f3f3caa9ffbc51a070ff36497037', './lib/core/Tiki/Profile/InstallHandler/TrackerOption.php', '21.12', 0),
('0f622811c6a7f44b7b044bf366763e04', './lib/core/Tiki/Profile/InstallHandler/Transition.php', '21.12', 0),
('35caffefebff03590cd7f945644f7cf4', './lib/core/Tiki/Profile/InstallHandler/User.php', '21.12', 0),
('242e16855bdb196b1ef9a3c994ffc125', './lib/core/Tiki/Profile/InstallHandler/Webmail.php', '21.12', 0),
('f7f9bc444633df1627eff9e8a9c8ed45', './lib/core/Tiki/Profile/InstallHandler/Webservice.php', '21.12', 0),
('76f41695d84cb23c1d62aab3a46b2890', './lib/core/Tiki/Profile/InstallHandler/WebserviceTemplate.php', '21.12', 0),
('71fa351e10c8de878824d656c175c135', './lib/core/Tiki/Profile/InstallHandler/WikiPage.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Profile/InstallHandler/index.php', '21.12', 0),
('393e9e3a74d3d79e1e5818f6ea288799', './lib/core/Tiki/Profile/Installer.php', '21.12', 0),
('72bfd841e4585e93bcda2fbe51db4565', './lib/core/Tiki/Profile/List.php', '21.12', 0),
('2502f814bec45f12e2bc3f2bc9fcedae', './lib/core/Tiki/Profile/Object.php', '21.12', 0),
('73fb3125d03ce39dcf5c3164a17fed71', './lib/core/Tiki/Profile/SymbolLoader.php', '21.12', 0),
('8455cbe120f5e664c322c9e352bcf14f', './lib/core/Tiki/Profile/Transport/File.php', '21.12', 0),
('4d7de68a5ec35ca89695e97b26cf908f', './lib/core/Tiki/Profile/Transport/Interface.php', '21.12', 0),
('9832b8c032e7a8e0e64d419960d5f8b1', './lib/core/Tiki/Profile/Transport/Local.php', '21.12', 0),
('b7ce124423bb4de79a8456691a44cb58', './lib/core/Tiki/Profile/Transport/Repository.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Profile/Transport/index.php', '21.12', 0),
('22936f786e93d00bc772f5a4fd33e783', './lib/core/Tiki/Profile/ValueMapConverter.php', '21.12', 0),
('291edfaf3a91871d3203f72f7dfc4bb7', './lib/core/Tiki/Profile/Writer.php', '21.12', 0),
('112897367e31197ab109249065ef674b', './lib/core/Tiki/Profile/Writer/ExternalWriter.php', '21.12', 0),
('b052b6f883af86453fe70db386c72067', './lib/core/Tiki/Profile/Writer/Helper.php', '21.12', 0),
('9e621a5d1d458f0bdf19ec88c21ea96e', './lib/core/Tiki/Profile/Writer/ProfileFinder.php', '21.12', 0),
('1ccb8992d6bc36269c63757e9c809657', './lib/core/Tiki/Profile/Writer/Queue.php', '21.12', 0),
('d982e0bc1af22904d68119d472a720f6', './lib/core/Tiki/Profile/Writer/ReferenceProvider.php', '21.12', 0),
('1c643554339d45b0ee2bfc182eca1612', './lib/core/Tiki/Profile/Writer/SearchFieldHelper.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Profile/Writer/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Profile/index.php', '21.12', 0),
('9829a66efe6ef87e0ef46cdb6d83667b', './lib/core/Tiki/Recommendation/BatchProcessor.php', '21.12', 0),
('f2f2b3d051aecd11670038417a4c2e3c', './lib/core/Tiki/Recommendation/Comparator.php', '21.12', 0),
('bce9449f97eba2f1736e28b89f4535f1', './lib/core/Tiki/Recommendation/Debug/SourceDocument.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Recommendation/Debug/index.php', '21.12', 0),
('318d7ded1722be4ea60d30062a134067', './lib/core/Tiki/Recommendation/Engine/CompilerPass.php', '21.12', 0),
('1820c3108c32aa50a162e391ee84036b', './lib/core/Tiki/Recommendation/Engine/EngineInterface.php', '21.12', 0),
('e1bb9a1192133cf5b9dc70db3b527a3e', './lib/core/Tiki/Recommendation/Engine/FakeEngine.php', '21.12', 0),
('0117c7e08634c8f707758c6dd7c0e2c7', './lib/core/Tiki/Recommendation/Engine/UserFavorite.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Recommendation/Engine/index.php', '21.12', 0),
('f09e0e3306c83a86556db1d6f539d290', './lib/core/Tiki/Recommendation/EngineOutput.php', '21.12', 0),
('b55c4ed62b87c7467e1f00e598234897', './lib/core/Tiki/Recommendation/EngineSet.php', '21.12', 0),
('c8ed5d6f9ccc9cc7d24d2cd27a1301f7', './lib/core/Tiki/Recommendation/Input/UserInput.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Recommendation/Input/index.php', '21.12', 0),
('dedf3b973415002e1afc2e6ba20022da', './lib/core/Tiki/Recommendation/Recommendation.php', '21.12', 0),
('aefb6d4e0e7b469a6d8c99bbc7bc3241', './lib/core/Tiki/Recommendation/RecommendationSet.php', '21.12', 0),
('4a086aebd65ee578ad65ae4dd9c56361', './lib/core/Tiki/Recommendation/Store/ActivityStore.php', '21.12', 0),
('cff8a5aed45f69d375c5d5b5640c2e71', './lib/core/Tiki/Recommendation/Store/StoreInterface.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Recommendation/Store/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Recommendation/index.php', '21.12', 0),
('5146d462e1ada3dac058c9d244434a2a', './lib/core/Tiki/Render/Editable.php', '21.12', 0),
('f1de32a1bc066eced17c069f739b71ac', './lib/core/Tiki/Render/Lazy.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Render/index.php', '21.12', 0),
('78bdd1455d854ffcc2bab87ed4851e08', './lib/core/Tiki/Request.php', '21.12', 0),
('1d29679e5374d059e65df2a777aa8ac8', './lib/core/Tiki/SabreDav/AclPlugin.php', '21.12', 0),
('3fef41cc67ba251508765f3924df5659', './lib/core/Tiki/SabreDav/BasicAuth.php', '21.12', 0),
('f023f4c5a698fca8afc191941e1a814e', './lib/core/Tiki/SabreDav/CalDAVBackend.php', '21.12', 0),
('aebf8b0da309bcbfd7c419bd8a554f5b', './lib/core/Tiki/SabreDav/CardDAVBackend.php', '21.12', 0),
('c79f528b33a4fbef8554b8b0be0d1713', './lib/core/Tiki/SabreDav/Directory.php', '21.12', 0),
('bbbc5f5c8c72f23be7c64d3609c8c22e', './lib/core/Tiki/SabreDav/File.php', '21.12', 0),
('8d90f3a1aedd22cd0b787b75c782acd7', './lib/core/Tiki/SabreDav/LocksBackend.php', '21.12', 0),
('7ceae6973ee85713ecd58b0802b04d5f', './lib/core/Tiki/SabreDav/PrincipalBackend.php', '21.12', 0),
('b8be21f8b4767a6d969736bb9d9570c0', './lib/core/Tiki/SabreDav/Utilities.php', '21.12', 0),
('e713dd04c8ad7cb64179cccbffc23d7b', './lib/core/Tiki/SabreDav/WikiDirectory.php', '21.12', 0),
('6c8db6197dee59b1afbb0953c55e8209', './lib/core/Tiki/SabreDav/WikiPage.php', '21.12', 0),
('bb17272786dbc0a2b25e3b1dac2b6799', './lib/core/Tiki/Security.php', '21.12', 0),
('784b3dce5f477004720d6fd17d8bedf6', './lib/core/Tiki/Sitemap/AbstractType.php', '21.12', 0),
('ecb002a8e51edfa636569dc2390aa33b', './lib/core/Tiki/Sitemap/Generator.php', '21.12', 0),
('03c406b045f0e257ef38c4983ab1188b', './lib/core/Tiki/Sitemap/Type/Articles.php', '21.12', 0),
('ecf7fd619aed01aeafdc031ed0de6316', './lib/core/Tiki/Sitemap/Type/Blog.php', '21.12', 0),
('9baaae37a5572040951bc9adb42d2817', './lib/core/Tiki/Sitemap/Type/Forums.php', '21.12', 0),
('2affb3da2bdf9a5388e5a7a72f3e293f', './lib/core/Tiki/Sitemap/Type/Page.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Sitemap/Type/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Sitemap/index.php', '21.12', 0),
('ef277938f198e618405f1516958de296', './lib/core/Tiki/Theme/Handler.php', '21.12', 0),
('ba65c034d2ed68799dd45e487affe408', './lib/core/Tiki/Theme/Menu.php', '21.12', 0),
('aa303686289664fe9ef78f9d940d62aa', './lib/core/Tiki/Theme/Module.php', '21.12', 0),
('49c17cd000957c55d4851f959dc76d6a', './lib/core/Tiki/Theme/ThemeInstaller.php', '21.12', 0),
('cd05249bce7af5360d606e6f93211b05', './lib/core/Tiki/Theme/Zip.php', '21.12', 0),
('16d5b56dcf8546940815c8228e26fabc', './lib/core/Tiki/TimeLimit.php', '21.12', 0),
('6b90a4cfc0fc8c29784d08c15bb4d4ca', './lib/core/Tiki/Transition.php', '21.12', 0),
('2df48d51997b4f6e1c350b004331796f', './lib/core/Tiki/Url.php', '21.12', 0),
('97c18dd98e1cad6ccf4a3b918141b022', './lib/core/Tiki/Version/Checker.php', '21.12', 0),
('3563ff385698c3e65ddd8380467db8da', './lib/core/Tiki/Version/Upgrade.php', '21.12', 0),
('c97acf61eeb6778196dad55516088a02', './lib/core/Tiki/Version/Utils.php', '21.12', 0),
('d047a3daca4a06fef2f7569d06799bc0', './lib/core/Tiki/Version/Version.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Version/index.php', '21.12', 0),
('246739a74f98510d8556374444c4dce6', './lib/core/Tiki/Wiki/SlugManager.php', '21.12', 0),
('9ad8e6c9fd4d02aef5f3f3d58c250328', './lib/core/Tiki/Wiki/SlugManager/CompilerPass.php', '21.12', 0),
('e0fbd30faef310bb5dcc9c5d6bb0ee3e', './lib/core/Tiki/Wiki/SlugManager/DashGenerator.php', '21.12', 0),
('e15753c8c9eed16a971725a4073edf47', './lib/core/Tiki/Wiki/SlugManager/Generator.php', '21.12', 0),
('ec85bab3ffc6c6f134aff4623b062690', './lib/core/Tiki/Wiki/SlugManager/InMemoryTracker.php', '21.12', 0),
('8b2b39ab4c3000640f07a613a6711b2c', './lib/core/Tiki/Wiki/SlugManager/UnderscoreGenerator.php', '21.12', 0),
('0a00d8294c5e2a1e13ab050cb673ed1c', './lib/core/Tiki/Wiki/SlugManager/UrlencodeGenerator.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tiki/Wiki/SlugManager/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Tiki/index.php', '21.12', 0),
('abecb919bcfc4284955db02e8fbd35eb', './lib/core/TikiDb.php', '21.12', 0),
('cba45ff709cc33b387adebbb05003a8c', './lib/core/TikiDb/Adodb.php', '21.12', 0),
('e851658b381081a82951fd5cffb17ea7', './lib/core/TikiDb/Bridge.php', '21.12', 0),
('9d6480360611caf2fb4b8e8fb1d098ec', './lib/core/TikiDb/ErrorHandler.php', '21.12', 0),
('31cd68ee88974df17143a85e3daaab5c', './lib/core/TikiDb/Exception.php', '21.12', 0),
('30034fbff94f94be62ccea20abbc1197', './lib/core/TikiDb/Exception/DuplicateEntry.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/TikiDb/Exception/index.php', '21.12', 0),
('8a5c507a1d330b80b574f8cae6919163', './lib/core/TikiDb/Expr.php', '21.12', 0),
('6ccaa1c8df8d6ea16457c71d84935674', './lib/core/TikiDb/Initializer.php', '21.12', 0),
('8c5276278101b569dbc88a49f4859e35', './lib/core/TikiDb/Initializer/Adodb.php', '21.12', 0),
('99ae489be3ae038a69e83f8ec80a23b2', './lib/core/TikiDb/Initializer/Pdo.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/TikiDb/Initializer/index.php', '21.12', 0),
('2d464543e5cd8054c92eea1309cd9b0e', './lib/core/TikiDb/MasterSlaveDispatch.php', '21.12', 0),
('1a35710c9eb74b9b8a97721cd96f039a', './lib/core/TikiDb/Pdo.php', '21.12', 0),
('dd693ee6830b3ef455f875851d193aeb', './lib/core/TikiDb/SanitizeEncoding.php', '21.12', 0),
('678f96b5dcadd0ab1c30d31748773497', './lib/core/TikiDb/Table.php', '21.12', 0),
('628c61eb9af627ba80566ae929921e1f', './lib/core/TikiDb/Transaction.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/TikiDb/index.php', '21.12', 0),
('8793c8dd72d8b45c28f31fc7696a6a93', './lib/core/TikiFilter.php', '21.12', 0),
('c6ff445b61bf9383bf6ef5f78bc5a872', './lib/core/TikiFilter/Alnum.php', '21.12', 0),
('fa59a1aa1697df0f7058e3cef6f901da', './lib/core/TikiFilter/Alpha.php', '21.12', 0),
('6cb42d3776f09b1b91dff4fee26e5fa6', './lib/core/TikiFilter/AttributeType.php', '21.12', 0),
('425c6f62cd2e0f379c03d59c26aac647', './lib/core/TikiFilter/Callback.php', '21.12', 0),
('24c432e4cca27798463c3a0865de39bc', './lib/core/TikiFilter/HtmlPurifier.php', '21.12', 0),
('15b9eb675511d87da765f391a1d3ae4e', './lib/core/TikiFilter/IsoDate.php', '21.12', 0),
('19f0e624c9b0c2115a0c2d29fd6e594d', './lib/core/TikiFilter/Lang.php', '21.12', 0),
('bbbba60c46996a7a76335efe809c948a', './lib/core/TikiFilter/None.php', '21.12', 0),
('0cc040a72660f3d64f4ebd5d090f91a8', './lib/core/TikiFilter/PregFilter.php', '21.12', 0),
('6e86ad809839b019c376b60d7c82a19c', './lib/core/TikiFilter/PrepareInput.php', '21.12', 0),
('3491a3efd134023aa8ddbf02321ccc5a', './lib/core/TikiFilter/PreventXss.php', '21.12', 0),
('751f04528870321ef39ebaff1106f2fc', './lib/core/TikiFilter/RawUnsafe.php', '21.12', 0),
('ac97d46534c2bee984a076e4f6beaeb4', './lib/core/TikiFilter/RelativeURL.php', '21.12', 0),
('547819311d0725556e9070fb27f0bdab', './lib/core/TikiFilter/WikiContent.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/TikiFilter/index.php', '21.12', 0),
('5ebcef498908e70ac0371b196a0700cf', './lib/core/Tracker/CompilerPass.php', '21.12', 0),
('88f7b378e18b9dd67bcbc539d6ea4e48', './lib/core/Tracker/Definition.php', '21.12', 0),
('4397c8d59f2d2c9308140e5d7a77339d', './lib/core/Tracker/Field/Abstract.php', '21.12', 0),
('5d7e2b7008ab8d6843d97b6955b718ea', './lib/core/Tracker/Field/Action.php', '21.12', 0),
('72cd9fb885add288196931c941ebb1c1', './lib/core/Tracker/Field/Articles.php', '21.12', 0),
('2884bfb9b1422294e4de4ea07b5e26ec', './lib/core/Tracker/Field/AutoIncrement.php', '21.12', 0),
('54611c79c055864cd0bcb33feb23313d', './lib/core/Tracker/Field/CalendarItem.php', '21.12', 0),
('0b74a54605b84140e006fc9edb7680cf', './lib/core/Tracker/Field/Category.php', '21.12', 0),
('28b65da7688ac8bd399d2f075c1fc6e8', './lib/core/Tracker/Field/Checkbox.php', '21.12', 0),
('7d14fe9c8df0be972d77c9ad80804e7a', './lib/core/Tracker/Field/Computed.php', '21.12', 0),
('307dd644ec433bd186f8cce1287f61f7', './lib/core/Tracker/Field/CountrySelector.php', '21.12', 0),
('65627245a5cdeadd4d3926f098b95333', './lib/core/Tracker/Field/Currency.php', '21.12', 0),
('b669a83fede7872f664986e10c8470ec', './lib/core/Tracker/Field/DateTime.php', '21.12', 0),
('79f44d70cd3bc94999fb7f29ba0dc494', './lib/core/Tracker/Field/Dropdown.php', '21.12', 0),
('2e9e62782968bcf6f08ac3d60b8f1f96', './lib/core/Tracker/Field/DynamicList.php', '21.12', 0),
('f903e1dd9912f8f7308302db1a0f8e35', './lib/core/Tracker/Field/Email.php', '21.12', 0),
('1a59fc375191a17e1bb32dfab6b037cf', './lib/core/Tracker/Field/Exportable.php', '21.12', 0),
('a7453d461ec4ba097691c2ef247e338a', './lib/core/Tracker/Field/Factory.php', '21.12', 0),
('6a7ae9954dbf0a73f180ee591cc10d50', './lib/core/Tracker/Field/File.php', '21.12', 0),
('03c4b0fb523a814796ae8589c80684f1', './lib/core/Tracker/Field/Files.php', '21.12', 0),
('168c7f994577fc54e1452f81a9a65a02', './lib/core/Tracker/Field/Filterable.php', '21.12', 0),
('66670506f2b3758a44fa54b7b7685fc6', './lib/core/Tracker/Field/Freetags.php', '21.12', 0),
('e93a5e4ac74ef94cc5ac8b82d4076824', './lib/core/Tracker/Field/GeographicFeature.php', '21.12', 0),
('6ac6f6de7edd68f22f5457dd486b7f60', './lib/core/Tracker/Field/GroupSelector.php', '21.12', 0),
('a2ae5bdc39d926a8170401d6eb07bfd1', './lib/core/Tracker/Field/Header.php', '21.12', 0),
('bd5a54063d32adbbd5587ced6f7a6b5c', './lib/core/Tracker/Field/Icon.php', '21.12', 0),
('ff327b1e90f4f3d71072588032e91f32', './lib/core/Tracker/Field/Image.php', '21.12', 0),
('1fc9e17fae6b08ee902c07e379f62e0d', './lib/core/Tracker/Field/InGroup.php', '21.12', 0),
('deb6d6615eb1f14226e7cce135ea9387', './lib/core/Tracker/Field/Indexable.php', '21.12', 0),
('f3c101f4ff4e2074cb984ed1ffe00a3c', './lib/core/Tracker/Field/Interface.php', '21.12', 0),
('c93c2af05bbc610f50e07fde1063c237', './lib/core/Tracker/Field/Ip.php', '21.12', 0),
('c4e359961ad3ac208f5b2e8051c9ec10', './lib/core/Tracker/Field/ItemLink.php', '21.12', 0),
('4cafe4d968ffe5cc62e67b39b36b260c', './lib/core/Tracker/Field/ItemsList.php', '21.12', 0),
('5339430c481a87c932c9b12bf889d3ea', './lib/core/Tracker/Field/JsCalendar.php', '21.12', 0),
('d063ff4c0d0077c13f704bd8cc54d880', './lib/core/Tracker/Field/Kaltura.php', '21.12', 0),
('4a14e8f68e54efc47b8651988d0b312b', './lib/core/Tracker/Field/Language.php', '21.12', 0),
('0449be0a6afabcf731c225938a2cbd5b', './lib/core/Tracker/Field/Ldap.php', '21.12', 0),
('a3b77e31b20eab03855d94d36136d395', './lib/core/Tracker/Field/Location.php', '21.12', 0),
('9dea1456a0d7d968273bddb7ccc64649', './lib/core/Tracker/Field/Math.php', '21.12', 0),
('5b9e5af36e5efcf5cfa636026f089b78', './lib/core/Tracker/Field/Numeric.php', '21.12', 0),
('fb3b65a523485cadd7cbad83204bc86b', './lib/core/Tracker/Field/PageSelector.php', '21.12', 0),
('1260be31a67b70e83cfcb06ae49ddf43', './lib/core/Tracker/Field/Rating.php', '21.12', 0),
('2ebed8d0b9fd28e2f0f619a89c68ad04', './lib/core/Tracker/Field/Relation.php', '21.12', 0),
('27889de924e524b1d0188a0246d89c22', './lib/core/Tracker/Field/ShowTikiOrg.php', '21.12', 0),
('824847fd5b9bfad14e635fa3f30ee43e', './lib/core/Tracker/Field/StaticText.php', '21.12', 0),
('37ae625aaa5887361d50c3ab989c9cab', './lib/core/Tracker/Field/Synchronizable.php', '21.12', 0),
('5f2b63759384a61c9754a2bcb3b07670', './lib/core/Tracker/Field/Text.php', '21.12', 0),
('446fa8a9a35e7c399677103ef04b3dea', './lib/core/Tracker/Field/TextArea.php', '21.12', 0),
('5fa0077f1523d1378fb80b7421e296a1', './lib/core/Tracker/Field/Url.php', '21.12', 0),
('5a354196c37045764fd3ee0dc0d24813', './lib/core/Tracker/Field/UserGroups.php', '21.12', 0),
('f180b739b20a33bb08db1a5db038c3df', './lib/core/Tracker/Field/UserPreference.php', '21.12', 0),
('138b08d93aeb9603aa919e30a4104c3d', './lib/core/Tracker/Field/UserSelector.php', '21.12', 0),
('4160b98460e0a11bea37cbabda48406e', './lib/core/Tracker/Field/UserSubscription.php', '21.12', 0),
('1a2665d292357a57fcf1cb6b9aa2ed12', './lib/core/Tracker/Field/WebService.php', '21.12', 0),
('de86c1a3c55c4553915e09c204056faf', './lib/core/Tracker/Field/Wiki.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/Tracker/Field/index.php', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('8f6ed709c1ea0a2a45098282349c626c', './lib/core/Tracker/Filter/Collection.php', '21.12', 0),
('a412c9266b6a224c323b5085647cc21e', './lib/core/Tracker/Filter/Control/Control.php', '21.12', 0),
('875f6576bc995ce319c1582667f83480', './lib/core/Tracker/Filter/Control/CurrencyRange.php', '21.12', 0),
('9d8ca49cccce4d16ea8cc8cdc6c720f4', './lib/core/Tracker/Filter/Control/DateRange.php', '21.12', 0),
('135df8331ef5ccca30409f3fca3b8293', './lib/core/Tracker/Filter/Control/DropDown.php', '21.12', 0),
('611ca0e9242a071aa675fab5d3ff4288', './lib/core/Tracker/Filter/Control/InlineCheckboxes.php', '21.12', 0),
('665fe4a982199172d2126b0ab8a83176', './lib/core/Tracker/Filter/Control/MultiSelect.php', '21.12', 0),
('d8385ebcc107de7d9c0cc601434bbdd7', './lib/core/Tracker/Filter/Control/NumericRange.php', '21.12', 0),
('865deace65bfc6d8a2d31b8b9f13aa01', './lib/core/Tracker/Filter/Control/ObjectSelector.php', '21.12', 0),
('ccd078b94e2ac9a35ec28a101eb715c5', './lib/core/Tracker/Filter/Control/TextField.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Filter/Control/index.php', '21.12', 0),
('745c9d614d91302b9d1f31d34df7c6d8', './lib/core/Tracker/Filter/Exception/Exception.php', '21.12', 0),
('5ab566fd8c2556b955b5ed4c7958e182', './lib/core/Tracker/Filter/Exception/FieldNotFound.php', '21.12', 0),
('86857768bd666f65057252a793edfe1f', './lib/core/Tracker/Filter/Exception/ModeNotSupported.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Filter/Exception/index.php', '21.12', 0),
('321bcbaee51f80941992d15d1e65d053', './lib/core/Tracker/Filter/Filter.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Filter/index.php', '21.12', 0),
('22b3a2ba128a8e3b29e05e2c3152b938', './lib/core/Tracker/Item.php', '21.12', 0),
('f9c7b40311be3abca03aea8f0bdfc490', './lib/core/Tracker/Options.php', '21.12', 0),
('73438c3d09d3df5135ad77cc8e278998', './lib/core/Tracker/Query.php', '21.12', 0),
('39574a12f8e57f584a63c83b35f01c31', './lib/core/Tracker/Rule/Action/Action.php', '21.12', 0),
('2754790cb27ea160b50c48f781d0f78e', './lib/core/Tracker/Rule/Action/Hide.php', '21.12', 0),
('7e7b13c43e314b16a4e941e34913d2f1', './lib/core/Tracker/Rule/Action/NoOp.php', '21.12', 0),
('ac2b313fb8ec7d550ee3f4447df3ead3', './lib/core/Tracker/Rule/Action/NotRequired.php', '21.12', 0),
('92dff0598810e6a9c90a6b1ce6b101ac', './lib/core/Tracker/Rule/Action/Required.php', '21.12', 0),
('a51d37f8e6269fe30396096204b7c53b', './lib/core/Tracker/Rule/Action/Show.php', '21.12', 0),
('122f3fae4314cf8477cccd07e33cdcad', './lib/core/Tracker/Rule/Column.php', '21.12', 0),
('a9e6e52520c9e3e18d95ba62ad2aff0e', './lib/core/Tracker/Rule/Definition.php', '21.12', 0),
('779bbfc6fa75d144f7d8e88473ff7731', './lib/core/Tracker/Rule/LogicalType/All.php', '21.12', 0),
('6b3abb3b2a2542c3ed480fa9b057da0b', './lib/core/Tracker/Rule/LogicalType/Any.php', '21.12', 0),
('93b0ea1406065b99e449da0322814379', './lib/core/Tracker/Rule/LogicalType/LogicalType.php', '21.12', 0),
('9744c18234e958b9fed452bb312e7eb2', './lib/core/Tracker/Rule/LogicalType/None.php', '21.12', 0),
('048d934c3de0ef4c99d5d8fcc48822cf', './lib/core/Tracker/Rule/Operator/BooleanTrueFalse.php', '21.12', 0),
('545d734f7ef71296a34fd7ec6a5e83b8', './lib/core/Tracker/Rule/Operator/CollectionContains.php', '21.12', 0),
('4b41ae71d8e3bbf8a464d4040d2a2b51', './lib/core/Tracker/Rule/Operator/CollectionEmpty.php', '21.12', 0),
('d138758e1b8bb146e9796d1ed7119b0c', './lib/core/Tracker/Rule/Operator/CollectionNotContains.php', '21.12', 0),
('fe7df959af0453ef6a37711629985b57', './lib/core/Tracker/Rule/Operator/DateTimeAfter.php', '21.12', 0),
('51c9ba4f44dddeba6240b4b400ad558e', './lib/core/Tracker/Rule/Operator/DateTimeBefore.php', '21.12', 0),
('36e206acc0b801f216f7a091f093fdf8', './lib/core/Tracker/Rule/Operator/DateTimeOn.php', '21.12', 0),
('60333308099d7555866f87f73290d2d3', './lib/core/Tracker/Rule/Operator/NumberEquals.php', '21.12', 0),
('735bbe64804dbc8982b2ebac01e1d24a', './lib/core/Tracker/Rule/Operator/NumberGreaterThan.php', '21.12', 0),
('e833cfd9c10fd4bd22f027846efa21ee', './lib/core/Tracker/Rule/Operator/NumberLessThan.php', '21.12', 0),
('dafdc3dc33ed16fc9613a657084a7bc1', './lib/core/Tracker/Rule/Operator/NumberNotEquals.php', '21.12', 0),
('06a43f952ba55d811dbf9dbf8cc6014e', './lib/core/Tracker/Rule/Operator/Operator.php', '21.12', 0),
('c2527dd0b006aed62fa5bc4dc1770d88', './lib/core/Tracker/Rule/Operator/TextContains.php', '21.12', 0),
('7f0e8f94fe714734b9328cdf0d060c08', './lib/core/Tracker/Rule/Operator/TextEquals.php', '21.12', 0),
('254bbac468869df3d8ac256a42855737', './lib/core/Tracker/Rule/Operator/TextIsEmpty.php', '21.12', 0),
('97870351d87acdee1c07fe05894df1a1', './lib/core/Tracker/Rule/Operator/TextIsNotEmpty.php', '21.12', 0),
('04d9b2b5bc9952eb46cea70ed1f389fa', './lib/core/Tracker/Rule/Operator/TextNotContains.php', '21.12', 0),
('e47fb9997abade9f0df5a518490aa02c', './lib/core/Tracker/Rule/Rules.php', '21.12', 0),
('8dcaadef8c7bdd54d61d2fef626f405f', './lib/core/Tracker/Rule/Target/Field.php', '21.12', 0),
('1e14bbf207772ee5406648156967e064', './lib/core/Tracker/Rule/Target/NoTarget.php', '21.12', 0),
('69c07e45c50fe91ca28325bbd4df77d6', './lib/core/Tracker/Rule/Target/Target.php', '21.12', 0),
('5a4993f92dd5c09c813c4d46f2956243', './lib/core/Tracker/Rule/Type/Boolean.php', '21.12', 0),
('1aeaf7bb38a9838b7ad2281f086ab37e', './lib/core/Tracker/Rule/Type/Collection.php', '21.12', 0),
('7417e7d57ec582a5e29df6b49358f156', './lib/core/Tracker/Rule/Type/DateTime.php', '21.12', 0),
('2eeebb32b276f16c9a8c78efec760451', './lib/core/Tracker/Rule/Type/Field.php', '21.12', 0),
('b9437e8909eebbe071ef66e4d38d209d', './lib/core/Tracker/Rule/Type/Nothing.php', '21.12', 0),
('eb3dbc15d5873e5de8fc158e6651f7e1', './lib/core/Tracker/Rule/Type/Number.php', '21.12', 0),
('23eadd7f865966ce5573e4634ee16b5c', './lib/core/Tracker/Rule/Type/Text.php', '21.12', 0),
('2eab2128c7b77348342a0e00f78be049', './lib/core/Tracker/Rule/Type/Type.php', '21.12', 0),
('2324d634d741671c14f513c34e6f435f', './lib/core/Tracker/Tabular/Exception/Exception.php', '21.12', 0),
('9a2a82234e57a824a0a2dfb8656a3d91', './lib/core/Tracker/Tabular/Exception/FieldNotFound.php', '21.12', 0),
('55265f7d29ffb41aa59366451cdfd703', './lib/core/Tracker/Tabular/Exception/ModeNotSupported.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Tabular/Exception/index.php', '21.12', 0),
('3a7d285237f0813810565f516c1dd41c', './lib/core/Tracker/Tabular/Manager.php', '21.12', 0),
('4001e1593a83974bec0a7e85782ae85a', './lib/core/Tracker/Tabular/Schema.php', '21.12', 0),
('c77996e210a165fbdc2848a538fb96dd', './lib/core/Tracker/Tabular/Schema/CachedLookupHelper.php', '21.12', 0),
('0f3a1f6f5809bb6700bb2e9c5c2dbd64', './lib/core/Tracker/Tabular/Schema/Column.php', '21.12', 0),
('85f34136aa8b8e01561ef9d022aecebb', './lib/core/Tracker/Tabular/Schema/DateHelper.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Tabular/Schema/index.php', '21.12', 0),
('f391396b753f3f8cc9e599bafc05b9fb', './lib/core/Tracker/Tabular/Source/AutoDetectCsvSource.php', '21.12', 0),
('ef2a0c1c61dea61f6a95487e76507a7d', './lib/core/Tracker/Tabular/Source/CsvSource.php', '21.12', 0),
('74b9863223d61867fb6661a28d6dfbff', './lib/core/Tracker/Tabular/Source/CsvSourceEntry.php', '21.12', 0),
('c1679f41f925aa7b8f17976d46b39636', './lib/core/Tracker/Tabular/Source/PaginatedQuerySource.php', '21.12', 0),
('c25534fc1589989a45040311d8f00179', './lib/core/Tracker/Tabular/Source/QuerySource.php', '21.12', 0),
('bb2ad2c208dd7658951fc5d0127a7d3d', './lib/core/Tracker/Tabular/Source/QuerySourceEntry.php', '21.12', 0),
('e096bcce69288c8fe5cbabedd9e21aaa', './lib/core/Tracker/Tabular/Source/SourceInterface.php', '21.12', 0),
('812e03b5493eae2bce4752bbe8f36c8b', './lib/core/Tracker/Tabular/Source/TrackerSource.php', '21.12', 0),
('5dba7877bfef7b1edba443006148c0a2', './lib/core/Tracker/Tabular/Source/TrackerSourceEntry.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Tabular/Source/index.php', '21.12', 0),
('c0ec6d8af683e020e9ab55b87601a75c', './lib/core/Tracker/Tabular/Writer/CsvWriter.php', '21.12', 0),
('c028128123f677ffc12d4309586f354a', './lib/core/Tracker/Tabular/Writer/HtmlWriter.php', '21.12', 0),
('f50dfe5b60fd009ead64c70dac4a7584', './lib/core/Tracker/Tabular/Writer/TrackerWriter.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Tabular/Writer/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/Tracker/Tabular/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/Tracker/index.php', '21.12', 0),
('9b3eefddb7254b1c98998065e8763a39', './lib/core/WikiParser/OutputLink.php', '21.12', 0),
('3faeac10bc57f5d2c797593628800423', './lib/core/WikiParser/Parsable.php', '21.12', 0),
('36bb43daa1f5ac06747f14f5d96c0720', './lib/core/WikiParser/PluginArgumentParser.php', '21.12', 0),
('fe9e0a1bb7a50ff69d4aede07d96c525', './lib/core/WikiParser/PluginDefinition.php', '21.12', 0),
('0a58ef7aae3a828e70f27fa178f42fce', './lib/core/WikiParser/PluginMatcher.php', '21.12', 0),
('b95bf22b8adc7bbdd9dd6d8506714257', './lib/core/WikiParser/PluginOutput.php', '21.12', 0),
('21d82aba74732aa68eb23f99fca6a919', './lib/core/WikiParser/PluginParser.php', '21.12', 0),
('ecbd6765fa84659a0f5b2228649e04e0', './lib/core/WikiParser/PluginRepository.php', '21.12', 0),
('cb6f657af6a173dccc6550937fdd87e7', './lib/core/WikiParser/PluginRunner.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/WikiParser/index.php', '21.12', 0),
('1a18fe5cb5c7d14c2058338fc5caf8ec', './lib/core/WikiPlugin/Casperjs/Render.php', '21.12', 0),
('221d1b4bbf53678bea7987e14bb0791e', './lib/core/WikiPlugin/Casperjs/Result.php', '21.12', 0),
('1c30a1f17f103f9fbf21445416c887c5', './lib/core/WikiPlugin/Casperjs/Runner.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/core/WikiPlugin/Casperjs/index.php', '21.12', 0),
('547ab51f11a0378dc186744377c741c8', './lib/core/WikiPlugin/Helper.php', '21.12', 0),
('830e82bd70c6f5da5e38d54337b9836a', './lib/core/WikiPlugin/Negotiator/Wiki.php', '21.12', 0),
('6f594a6c84327c2a099c7ed9d75a2a03', './lib/core/WikiPlugin/Negotiator/Wiki/Alias.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/WikiPlugin/Negotiator/Wiki/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/WikiPlugin/Negotiator/index.php', '21.12', 0),
('7c0256ad77e53527cd96ef8e11df936f', './lib/core/WikiPlugin/Reference.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/core/WikiPlugin/index.php', '21.12', 0),
('64a72db96735e64074c9ac6e8d3778d9', './lib/core/Yaml/Directive/DirectiveInclude.php', '21.12', 0),
('045dcdccf924e65443cb14c8373e1f13', './lib/core/Yaml/Directives.php', '21.12', 0),
('7bb5f25b3e91ba6b93697ac1215cf9ef', './lib/core/Yaml/Filter/FilterInterface.php', '21.12', 0),
('28b71f95357512630f912e227432e1fc', './lib/core/Yaml/Filter/ReplaceUserData.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/core/index.php', '21.12', 0),
('bb250b9788c3422708bc219c4403fdd2', './lib/credits/creditslib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/credits/index.php', '21.12', 0),
('2af049ddc9b2626f2e3bbfac69cb7136', './lib/crypt/cryptlib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/crypt/index.php', '21.12', 0),
('df2de1b64f1b05fb3d43782cf7061ba8', './lib/csslib.php', '21.12', 0),
('518925d348800ed33a44d8371aa242a7', './lib/cypht/index.php', '21.12', 0),
('b6906668138c2be14a20edb88c1ff14f', './lib/cypht/integration/classes.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/cypht/integration/index.php', '21.12', 0),
('f9a6f49a9a6328c96ea7b34636a9a7f7', './lib/cypht/jquery.touch.js', '21.12', 0),
('0c66a65d0aa85a918b1ec76d1c917224', './lib/cypht/modules/smtp/assets/kindeditor/kindeditor-all-min.js', '21.12', 0),
('e4b1244d6fc42d5d98df7f1f449bfdc3', './lib/cypht/modules/smtp/assets/kindeditor/lang/ar.js', '21.12', 0),
('6d3f41b78a09497586e6d34dc556b198', './lib/cypht/modules/smtp/assets/kindeditor/lang/en.js', '21.12', 0),
('871e7a17fecc7ac988e1e4fa55ae3eab', './lib/cypht/modules/smtp/assets/kindeditor/lang/ko.js', '21.12', 0),
('3d18e4d6112a16d9fa98a339dad48bde', './lib/cypht/modules/smtp/assets/kindeditor/lang/ru.js', '21.12', 0),
('153d085e62a886da128a271f3437fc6c', './lib/cypht/modules/smtp/assets/kindeditor/lang/zh-CN.js', '21.12', 0),
('79f40767eefbb848997f89398418871f', './lib/cypht/modules/smtp/assets/kindeditor/lang/zh-TW.js', '21.12', 0),
('398623d87da4c7e3b6172560909d2661', './lib/cypht/modules/smtp/assets/kindeditor/plugins/autoheight/autoheight.js', '21.12', 0),
('de059c65b33c5edd9d7bea7a13c9cb7a', './lib/cypht/modules/smtp/assets/kindeditor/plugins/lineheight/lineheight.js', '21.12', 0),
('14347ea9cf68cce001d986363509589b', './lib/cypht/modules/smtp/assets/kindeditor/plugins/link/link.js', '21.12', 0),
('d4a3befcae4ff2fd52ba5508d0cedd07', './lib/cypht/modules/smtp/assets/kindeditor/plugins/pagebreak/pagebreak.js', '21.12', 0),
('0f656369fb0e3d0fffd84c4a968c1cce', './lib/cypht/modules/smtp/assets/kindeditor/plugins/plainpaste/plainpaste.js', '21.12', 0),
('d6c88e9bf68d5fe3503f3baa3169d140', './lib/cypht/modules/smtp/assets/kindeditor/plugins/preview/preview.js', '21.12', 0),
('36570537663c4293b8a38cd4b7ab3a4e', './lib/cypht/modules/smtp/assets/kindeditor/plugins/table/table.js', '21.12', 0),
('4de03ae43389c5d3dc4a1af091252acf', './lib/cypht/modules/smtp/assets/kindeditor/plugins/wordpaste/wordpaste.js', '21.12', 0),
('1d369ca4421e2c4d58d0f7cac4ecfd0e', './lib/cypht/modules/smtp/assets/kindeditor/themes/default/default.css', '21.12', 0),
('980daeffacd23cf845ba764eefd6f08c', './lib/cypht/modules/smtp/assets/markdown/editor.css', '21.12', 0),
('525f787b3df7abae5f6d0656075639d9', './lib/cypht/modules/smtp/assets/markdown/editor.js', '21.12', 0),
('8af08dcb5d207265f604dce4c250e6ec', './lib/cypht/modules/smtp/assets/markdown/marked.js', '21.12', 0),
('0c66a65d0aa85a918b1ec76d1c917224', './lib/cypht/modules/smtp/kindeditor/kindeditor-all-min.js', '21.12', 0),
('f558687f8afda8cfffac68a6a73fda05', './lib/cypht/modules/smtp/kindeditor/lang/ar.js', '21.12', 0),
('3d931788e11c0d26654de5545d84ce73', './lib/cypht/modules/smtp/kindeditor/lang/en.js', '21.12', 0),
('871e7a17fecc7ac988e1e4fa55ae3eab', './lib/cypht/modules/smtp/kindeditor/lang/ko.js', '21.12', 0),
('3d18e4d6112a16d9fa98a339dad48bde', './lib/cypht/modules/smtp/kindeditor/lang/ru.js', '21.12', 0),
('1dd425ccc53e88a09ee386f0eb41b02e', './lib/cypht/modules/smtp/kindeditor/lang/zh-CN.js', '21.12', 0),
('79f40767eefbb848997f89398418871f', './lib/cypht/modules/smtp/kindeditor/lang/zh-TW.js', '21.12', 0),
('398623d87da4c7e3b6172560909d2661', './lib/cypht/modules/smtp/kindeditor/plugins/autoheight/autoheight.js', '21.12', 0),
('0327199a4d998cf04e7705ce8728980f', './lib/cypht/modules/smtp/kindeditor/plugins/lineheight/lineheight.js', '21.12', 0),
('01e80f0d15025011efe7b1d1f74a1799', './lib/cypht/modules/smtp/kindeditor/plugins/link/link.js', '21.12', 0),
('e84e79256c6a6d6f18185a9bb94fecb3', './lib/cypht/modules/smtp/kindeditor/plugins/pagebreak/pagebreak.js', '21.12', 0),
('706c1842cca0516ef8b4a0f0bbad8336', './lib/cypht/modules/smtp/kindeditor/plugins/plainpaste/plainpaste.js', '21.12', 0),
('2d045e80947e994310cb3fc4028325b6', './lib/cypht/modules/smtp/kindeditor/plugins/preview/preview.js', '21.12', 0),
('e8db723c53972b51f834e600189dce18', './lib/cypht/modules/smtp/kindeditor/plugins/table/table.js', '21.12', 0),
('cd0e586c7e2bef7d8c571a6480d30bad', './lib/cypht/modules/smtp/kindeditor/plugins/wordpaste/wordpaste.js', '21.12', 0),
('1d369ca4421e2c4d58d0f7cac4ecfd0e', './lib/cypht/modules/smtp/kindeditor/themes/default/default.css', '21.12', 0),
('980daeffacd23cf845ba764eefd6f08c', './lib/cypht/modules/smtp/markdown/editor.css', '21.12', 0),
('525f787b3df7abae5f6d0656075639d9', './lib/cypht/modules/smtp/markdown/editor.js', '21.12', 0),
('8af08dcb5d207265f604dce4c250e6ec', './lib/cypht/modules/smtp/markdown/marked.js', '21.12', 0),
('afde2537c0fd01d7038f565e5c8dc6e5', './lib/cypht/modules/themes/assets/blue.css', '21.12', 0),
('bf73b23ce2a9de374158f3a92f5f40b2', './lib/cypht/modules/themes/assets/dark.css', '21.12', 0),
('e9427d656290f4af14b139d3d5cccfa3', './lib/cypht/modules/themes/assets/gray.css', '21.12', 0),
('67ab880c852f3c4cd1cea408c399f3f8', './lib/cypht/modules/themes/assets/green.css', '21.12', 0),
('a375755141c32793775baecf7583e7a5', './lib/cypht/modules/themes/assets/hn.css', '21.12', 0),
('64e650eb263e8e52f3dd234a5069f7a1', './lib/cypht/modules/themes/assets/lightblue.css', '21.12', 0),
('e41043cc99582baaf015fe4e0c2ddbb6', './lib/cypht/modules/themes/assets/so_alone.css', '21.12', 0),
('73cbc15f2a1620df2a0ed10b73b10acc', './lib/cypht/modules/themes/assets/tan.css', '21.12', 0),
('409ff3d09cb50254d0a6285976662d89', './lib/cypht/modules/themes/assets/tdark.css', '21.12', 0),
('e1fc48a89c2902221145fb876bd31c32', './lib/cypht/modules/themes/assets/terminal.css', '21.12', 0),
('afde2537c0fd01d7038f565e5c8dc6e5', './lib/cypht/modules/themes/blue.css', '21.12', 0),
('bf73b23ce2a9de374158f3a92f5f40b2', './lib/cypht/modules/themes/dark.css', '21.12', 0),
('e9427d656290f4af14b139d3d5cccfa3', './lib/cypht/modules/themes/gray.css', '21.12', 0),
('67ab880c852f3c4cd1cea408c399f3f8', './lib/cypht/modules/themes/green.css', '21.12', 0),
('a375755141c32793775baecf7583e7a5', './lib/cypht/modules/themes/hn.css', '21.12', 0),
('64e650eb263e8e52f3dd234a5069f7a1', './lib/cypht/modules/themes/lightblue.css', '21.12', 0),
('e41043cc99582baaf015fe4e0c2ddbb6', './lib/cypht/modules/themes/so_alone.css', '21.12', 0),
('73cbc15f2a1620df2a0ed10b73b10acc', './lib/cypht/modules/themes/tan.css', '21.12', 0),
('409ff3d09cb50254d0a6285976662d89', './lib/cypht/modules/themes/tdark.css', '21.12', 0),
('e1fc48a89c2902221145fb876bd31c32', './lib/cypht/modules/themes/terminal.css', '21.12', 0),
('07523a9396f1752735278d1ad0abd14c', './lib/cypht/modules/tiki/calendar_modules.php', '21.12', 0),
('2a3c5a4887f565587b398df7aa8d7396', './lib/cypht/modules/tiki/general_modules.php', '21.12', 0),
('3617792a0c2eeccf6eaf363ea1d60bc7', './lib/cypht/modules/tiki/groupmail_modules.php', '21.12', 0),
('263b1c21cf88bc426a01806874fae74a', './lib/cypht/modules/tiki/modules.php', '21.12', 0),
('fdb9a80e5c70e06176557f9d7b3eab09', './lib/cypht/modules/tiki/setup.php', '21.12', 0),
('356d12d6ae332a9983083a9e23e94d63', './lib/cypht/modules/tiki/site.css', '21.12', 0),
('eca8fe99062468921351e4e625940e79', './lib/cypht/modules/tiki/site.js', '21.12', 0),
('c5c22b0ace9ebc2f5ecabdd2296fc922', './lib/cypht/modules/tiki/themes/blue.css', '21.12', 0),
('c83cbc76522e118247d5946a74ad972d', './lib/cypht/modules/tiki/themes/dark.css', '21.12', 0),
('e03e6b0859e661b1c0fabf566c86723e', './lib/cypht/modules/tiki/themes/gray.css', '21.12', 0),
('f1d46fba97f6df1a8156db5c03bb5856', './lib/cypht/modules/tiki/themes/green.css', '21.12', 0),
('ee48cd44b69f7486a914d6ad00d8cbcf', './lib/cypht/modules/tiki/themes/hn.css', '21.12', 0),
('77ef9e2685f76cd57d77fa7b7aaf3238', './lib/cypht/modules/tiki/themes/lightblue.css', '21.12', 0),
('f3ba5c55b9c0b77b1245c15e316154d7', './lib/cypht/modules/tiki/themes/so_alone.css', '21.12', 0),
('0d38d563106085599185b7c5e9a0d3e8', './lib/cypht/modules/tiki/themes/tan.css', '21.12', 0),
('de528ead65463cf85d911301fb575d89', './lib/cypht/modules/tiki/themes/tdark.css', '21.12', 0),
('29ccfda5bd526096114def3efb3fec14', './lib/cypht/modules/tiki/themes/terminal.css', '21.12', 0),
('161f3f8420cf8315146c46f4b02a3a7f', './lib/cypht/site.css', '21.12', 0),
('269e7dec61ab66e21ce74a7c85b9e25f', './lib/cypht/site.js', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/db/index.php', '21.12', 0),
('60a5b64f19d5b746187ac4b80a9b0db0', './lib/db/tiki_registration_fields.php', '21.12', 0),
('8a238e2d5867d1e21006c04c9d576fb2', './lib/dcs/dcslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/dcs/index.php', '21.12', 0),
('f120212ba4986d663f6fd6955dfef09c', './lib/debug/Tracer.php', '21.12', 0),
('e24b6d98b037b8d6addc72bebc807d2d', './lib/debug/debug-command_dmsg.php', '21.12', 0),
('7e0f7bfe1050fddac9a5c3e20fdb537d', './lib/debug/debug-command_features.php', '21.12', 0),
('7ea01e12683f59fae5e1659c46c664f2', './lib/debug/debug-command_perm.php', '21.12', 0),
('437c9a248d11d11f395355993cbd5bb4', './lib/debug/debug-command_print.php', '21.12', 0),
('7ad1cac112049dba9559559dff48a8ee', './lib/debug/debug-command_slist.php', '21.12', 0),
('2de6285ce404fe5121b46d85e410141a', './lib/debug/debug-command_sprint.php', '21.12', 0),
('26241d2f42350d42dc8be553723016c8', './lib/debug/debug-command_sql.php', '21.12', 0),
('264c70773eebe8e0d90621915b7dee8e', './lib/debug/debug-command_test.php', '21.12', 0),
('29e229395646c0c25ab36a393d518447', './lib/debug/debug-command_tikitables.php', '21.12', 0),
('5e8f203f50f79ec100f4563932be9784', './lib/debug/debug-command_watch.php', '21.12', 0),
('3aa99f047b72f7e76d212db654717a74', './lib/debug/debugger-common.php', '21.12', 0),
('91a6468a605d51035fe14526e083e754', './lib/debug/debugger-ext.php', '21.12', 0),
('65c139a33d99385329efc271abdbbda0', './lib/debug/debugger.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/debug/index.php', '21.12', 0),
('c97434237d09b1173aed62a548ec2002', './lib/diff.php', '21.12', 0),
('274095a3753dbe72f4a4276a538c8d05', './lib/diff/Diff.php', '21.12', 0),
('1fadfe63f61e79a4cb37d3a587f8039a', './lib/diff/Renderer.php', '21.12', 0),
('da143457071e23870588a58d700413b0', './lib/diff/difflib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/diff/index.php', '21.12', 0),
('523784434ead43500aa28c50ef01739b', './lib/diff/renderer_bytes.php', '21.12', 0),
('b338c8ee6f75433f6773587ef4bb5dc0', './lib/diff/renderer_character.php', '21.12', 0),
('ebc6b8d4373a6982714f36aa2586cac1', './lib/diff/renderer_character_inline.php', '21.12', 0),
('af90127b6f8d732f0eb0106885c630f2', './lib/diff/renderer_htmldiff.php', '21.12', 0),
('891110146337184bdb213c94c86d9a06', './lib/diff/renderer_inline.php', '21.12', 0),
('fd4b459e95f71859dff934f877b5b19e', './lib/diff/renderer_sidebyside.php', '21.12', 0),
('3650e0f9a112cb0c6fc2f8da43e04e66', './lib/diff/renderer_unified.php', '21.12', 0),
('d2c141c0bc5f29fc51c86584ddd400c4', './lib/directory/dirlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/directory/index.php', '21.12', 0),
('7e524f8e5ab0921701e77fde1af8ec03', './lib/dracula/graffle.js', '21.12', 0),
('6e9b58af0d870378f4c69483b175e87d', './lib/dracula/graph.js', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/dracula/index.php', '21.12', 0),
('8b1b503c7e881b85379888e7d9c39873', './lib/dracula/raphael-min.js', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/encoding/index.php', '21.12', 0),
('7d59036fcae14ef4b004bdc34e503d28', './lib/encoding/lib-encoding.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/equation/index.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/equation/pictures/index.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/equation/tmp/index.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/events/index.php', '21.12', 0),
('96099ae5bfbeb665f0e8fb89f7d5b30f', './lib/faqs/faqlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/faqs/index.php', '21.12', 0),
('ed7ed63be6e469e1c2c0f7496e792a99', './lib/featured_links/flinkslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/featured_links/index.php', '21.12', 0),
('3375898a54dc05bb14e8d061616c1635', './lib/filegals/filegalbatchlib.php', '21.12', 0),
('243ec83e2261894dd7cfb8fe48ef4bb9', './lib/filegals/filegalcopylib.php', '21.12', 0),
('d269fc715a8700eb7fe53028244ca971', './lib/filegals/filegallib.php', '21.12', 0),
('bc1799b3b29aed0098b5ffb2ece8b066', './lib/filegals/h5plib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/filegals/index.php', '21.12', 0),
('f22f93be01bbd97c87c21677c936e1c3', './lib/filegals/max_upload_size.php', '21.12', 0),
('fceca832c0ed4d377fbd30b5da4b7805', './lib/filegals/scormlib.php', '21.12', 0),
('905816ffaf55a7f8e5388deb823f08f2', './lib/filegals/vimeolib.php', '21.12', 0),
('75170d2b04429a393c229a45bfaf336b', './lib/freetag/freetaglib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/freetag/index.php', '21.12', 0),
('fdda774820ec55f4377961a253cd2d8a', './lib/geo/geolib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/geo/index.php', '21.12', 0),
('7f55d19dc75571a99589adfe76c65a62', './lib/gitlib.php', '21.12', 0),
('938111a1fac5c9f76c62659893571e4e', './lib/goal/eventlib.php', '21.12', 0),
('e6b8244de860546612fc4547de0dc698', './lib/goal/goallib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/goal/index.php', '21.12', 0),
('37c417604c53f3b54509b092744cfef7', './lib/goal/rewardlib.php', '21.12', 0),
('3ae58476f0fd5def5f4412d6e0821551', './lib/graph-engine/abstract.gridbased.php', '21.12', 0),
('3668f01ce863e2aa79b32ae01885ced7', './lib/graph-engine/core.php', '21.12', 0),
('60f9d6600f0a0e67ee43009941594f4e', './lib/graph-engine/gd.php', '21.12', 0),
('b641e28512e1ff60943249185907e3a4', './lib/graph-engine/graph.bar.php', '21.12', 0),
('ec947c68cb2d568bc572453f347f0fff', './lib/graph-engine/graph.multiline.php', '21.12', 0),
('423e77ee4dfd1cee0e141d2dfaf0a17d', './lib/graph-engine/graph.pie.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/graph-engine/index.php', '21.12', 0),
('09d9e39340f5d29c53bb7e0e720b90fb', './lib/graph-engine/pdflib.php', '21.12', 0),
('b3c5ded632106b066688bdd09aa30756', './lib/graph-engine/ps.php', '21.12', 0),
('8ca57ac4f0e5872d9a9efe2d6c8006f3', './lib/groupalert/groupalertlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/groupalert/index.php', '21.12', 0),
('4aa9d15af18e954dafdfd518fd747f52', './lib/headerlib.php', '21.12', 0),
('edb377766d66cbaad36d07c829f6de3f', './lib/hotwords/hotwordlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/hotwords/index.php', '21.12', 0),
('2f32cce529c84436fea0d242da5a5bd3', './lib/htmlpages/htmlpageslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/htmlpages/index.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/htmlparser/index.php', '21.12', 0),
('2d73e07c63a0de2d56661a678502804c', './lib/htmlparser/rebuildgrammar.php', '21.12', 0),
('bbbb7c7b31e19048ba17bc44f5dd4f23', './lib/htmlpurifier_tiki/HTMLPurifier.tiki.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/htmlpurifier_tiki/index.php', '21.12', 0),
('a7f971b05974f7ee210a1ba606ab6a0c', './lib/ical/File.php', '21.12', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/ical/iCal/Parser/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/ical/iCal/index.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/ical/index.php', '21.12', 0),
('5d4aea5aa3be0afa6a6909f56eb03a39', './lib/imagegals/imagegallib.js', '21.12', 0),
('af12656f2bac4e218e8f535be3890ea4', './lib/imagegals/imagegallib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/imagegals/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/importer/index.php', '21.12', 0),
('8e7561f8f485fd2bb100719fafe744ec', './lib/importer/tikiimporter.php', '21.12', 0),
('d533a032dcf6b38d4506f1b04830757a', './lib/importer/tikiimporter_blog.php', '21.12', 0),
('a8d3df65a3f632c063499377fe5ea65a', './lib/importer/tikiimporter_blog_wordpress.php', '21.12', 0),
('ab74a49186e38d3b0f3d3331eb4a79ba', './lib/importer/tikiimporter_wiki.php', '21.12', 0),
('4ca5cae6acc6835cd11e6a0c1d52e9e1', './lib/importer/tikiimporter_wiki_mediawiki.php', '21.12', 0),
('a32b5e09f781240fc9219766cefcfbc0', './lib/importerlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/index.php', '21.12', 0),
('bc9b44e9a2c6dc5dcbdfd5d81729874b', './lib/init/index.php', '21.12', 0),
('d8e24923ca446d43a4302485c3643fae', './lib/init/initlib.php', '21.12', 0),
('9c895e771c97d0ed7f3d40d3247e7106', './lib/init/smarty.php', '21.12', 0),
('f0fdeeb465ed31e6de3c2b8fe0c576d3', './lib/init/tra.php', '21.12', 0),
('ec2fea51c2b35c1f5bc3b1415413f416', './lib/init/typography.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/integrator/index.php', '21.12', 0),
('27b522367089d3bf8bbfdcd6067a15ac', './lib/integrator/integrator.php', '21.12', 0),
('2588eaabec04a3026ea72901cfa865be', './lib/jquery_tiki/autoToc.js', '21.12', 0),
('0adfe2b29487000c096e255df4d25df4', './lib/jquery_tiki/calendar_edit_item.js', '21.12', 0),
('ac39e86ce8fdc7834c06a7557d3bfe42', './lib/jquery_tiki/customsearch.js', '21.12', 0),
('d14fc6d56d32b3321b040cd64e7f385b', './lib/jquery_tiki/elfinder/elFinderVolumeTikiFiles.class.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/jquery_tiki/elfinder/index.php', '21.12', 0),
('a179329fd7fd8ec33280c82f92896f6c', './lib/jquery_tiki/elfinder/tiki-elfinder.js', '21.12', 0),
('0cd7ac357a2d99f6df8996c26e54ef9c', './lib/jquery_tiki/elfinder/tikiElFinder.php', '21.12', 0),
('18dccfdbed38c8c46041b533f96f5af6', './lib/jquery_tiki/files.js', '21.12', 0),
('43fff3de16bcfe1362a5cea8bc589973', './lib/jquery_tiki/fullcalendar_to_pdf.js', '21.12', 0),
('8cbbbe76e854523c2fe3c1e3c0fdfa3e', './lib/jquery_tiki/iconsets.js', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/jquery_tiki/index.php', '21.12', 0),
('312d62d79935e6688fe93762dd865d22', './lib/jquery_tiki/inline_edit.js', '21.12', 0),
('8bbe766d331728f0370eb9bb10e11f7e', './lib/jquery_tiki/multilike.js', '21.12', 0),
('58fca149b898faa8b6717581810b9d18', './lib/jquery_tiki/mustread.js', '21.12', 0),
('1b3f8454c84cfa6cb84cc30fc0f8f8d7', './lib/jquery_tiki/pdf.js', '21.12', 0),
('b31a56d6179bd7f6f23ae3e3d371d407', './lib/jquery_tiki/pluginedit.js', '21.12', 0),
('4a510bd17a33086ee2c5fe48ef8bbf1b', './lib/jquery_tiki/pluginedit_list.js', '21.12', 0),
('cc6af86118c6e6e52688f76588dc3ca7', './lib/jquery_tiki/social.js', '21.12', 0),
('4a1e0dc74f682d211d6253c40441af49', './lib/jquery_tiki/tablesorter.js', '21.12', 0),
('b7d3e3d2d1c1f3d48e10e30773d9f0f8', './lib/jquery_tiki/theme-customizer.js', '21.12', 0),
('86daefa8b37de2428ba54632692650ff', './lib/jquery_tiki/tiki-admin.js', '21.12', 0),
('f7212d16ae65f092acf79220e3c934fd', './lib/jquery_tiki/tiki-admin_oauthserver.js', '21.12', 0),
('e64c5d8adb4b98a71b6de57bfce79418', './lib/jquery_tiki/tiki-bootstrapmodalfix.js', '21.12', 0),
('68d697e0147928e1fb3d42cf3e158a0e', './lib/jquery_tiki/tiki-confirm.js', '21.12', 0),
('64e672b1b84b81a5feb9a28e58f36d14', './lib/jquery_tiki/tiki-connect.js', '21.12', 0),
('93d8a7c4063f16f48d6936da3ba4b9a1', './lib/jquery_tiki/tiki-diagram.js', '21.12', 0),
('d78afff3d839de77297a62177cb63363', './lib/jquery_tiki/tiki-jquery.js', '21.12', 0),
('0c90e13ae1f37e2a6b45392e15102069', './lib/jquery_tiki/tiki-jquery_upload.js', '21.12', 0),
('4c49c9d4e340333e61f9e000facdd1a2', './lib/jquery_tiki/tiki-maps-ol3.js', '21.12', 0),
('a811ed8befc1c36158f75e28989ae813', './lib/jquery_tiki/tiki-maps.js', '21.12', 0),
('49936c404d806ec9eacc346f3ba16853', './lib/jquery_tiki/tiki-mxgraph.js', '21.12', 0),
('8a72da71b56be1f1c5aab2867357da3a', './lib/jquery_tiki/tiki-pdfjs.js', '21.12', 0),
('1ee84bacbcc3d15d0f5fe674f374d8ef', './lib/jquery_tiki/tiki-popovers_for_footnotes.js', '21.12', 0),
('860bb278383fdf99776ad842f520e8c0', './lib/jquery_tiki/tiki-profile.js', '21.12', 0),
('2e3a32a369145e5001745067e03ce10b', './lib/jquery_tiki/tiki-schedulers.js', '21.12', 0),
('d75e14626906065151618d66224a58ba', './lib/jquery_tiki/tiki-tasks.js', '21.12', 0),
('8d6db58446dfc83f5319f79a663732b0', './lib/jquery_tiki/tiki-toolbars.js', '21.12', 0),
('fb23b06d9ea341165e82f80604f327a2', './lib/jquery_tiki/tiki-trackers.js', '21.12', 0),
('237a213ba2ee8b5cc65c568e8d21e038', './lib/jquery_tiki/tiki-vimeo_upload.js', '21.12', 0),
('cb95e581e255cfaa5011e85cfb827cb0', './lib/jquery_tiki/tiki-workspace-ui.js', '21.12', 0),
('92beaa9c3192532214b2fc41079e05ba', './lib/jquery_tiki/wikiplugin-annotation.js', '21.12', 0),
('31dbb56f766507151a7aedac43e2cd58', './lib/jquery_tiki/wikiplugin-ganttchart.js', '21.12', 0),
('14dbc8e82feacfc2cd62df55d7a5eb00', './lib/jquery_tiki/wikiplugin-mediaplayer.js', '21.12', 0),
('2beb500142a2cfb1122739672a7283ca', './lib/jquery_tiki/wikiplugin-pivottable.js', '21.12', 0),
('1714b721d613805381fc4529ead7a1b1', './lib/jquery_tiki/wikiplugin-xmpp.js', '21.12', 0),
('6d18a199ec76d778e00aeef07925670a', './lib/language/CollectFiles.php', '21.12', 0),
('b8de5734e6571be894262ab50328fb8a', './lib/language/Exception.php', '21.12', 0),
('451ae295c608be18f7d6e9f26998c6cd', './lib/language/File.php', '21.12', 0),
('14c4ef8487830b98d2dfeec54e6d9e68', './lib/language/FileType.php', '21.12', 0),
('f44c218cdc5e4d1353f852c63f47f3a6', './lib/language/FileType/Php.php', '21.12', 0),
('f4e10baccf66f53e7142184020a10634', './lib/language/FileType/Tpl.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/language/FileType/index.php', '21.12', 0),
('ce6fbcaeac4075ab9ce90fd6cd67338c', './lib/language/GetStrings.php', '21.12', 0),
('ea013410266992985496c2b00e0c0ca0', './lib/language/Language.php', '21.12', 0),
('6d8f46aac384ed2c1beab22af9bb33d9', './lib/language/LanguageTranslations.php', '21.12', 0),
('adde2ec7302d66ff99d86e4d06f6cf4e', './lib/language/MergeFiles.php', '21.12', 0),
('9f90c0baaa5fdd8dadbdd3efc7e38ed3', './lib/language/WriteFile.php', '21.12', 0),
('8ad22765716ab52cc98f6ba9dd21f6b9', './lib/language/WriteFile/Factory.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/language/WriteFile/index.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/language/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/language/js/index.php', '21.12', 0),
('d740f8a4c55d02fed291503602059aff', './lib/language/js/interactive_translation.js', '21.12', 0),
('9ea09fe247e0b4bfd6546e9a92128a8b', './lib/language/js/tiki-edit_languages.js', '21.12', 0),
('ec7eff08c20ccb7bc708e72aea25e97a', './lib/ldap/filter.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/ldap/index.php', '21.12', 0),
('8d4cc807088d03cc88ff505b0a929ce4', './lib/ldap/ldaplib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/live_support/index.php', '21.12', 0),
('8aa4af72119d85eaa6f9368683e6a960', './lib/live_support/live-support.js', '21.12', 0),
('696c0b38ce231542ea66d9254dac3a4d', './lib/live_support/lsadminlib.php', '21.12', 0),
('5a1270dd4a479581931c3d9919432eec', './lib/live_support/lslib.php', '21.12', 0),
('00c07fe2c4877b9d78f7e2e8e00a1931', './lib/loginlib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/logs/index.php', '21.12', 0),
('71dad535ba9e9064905f828e9aebeb59', './lib/logs/logslib.php', '21.12', 0),
('e8f1f6b6da55f27b6c52835166db2c1a', './lib/logs/logsquerylib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/mail/index.php', '21.12', 0),
('0966b4b6b02d680417ff889967436342', './lib/mail/maillib.php', '21.12', 0),
('7103d8dcea6a2a99d5a1b70940e99079', './lib/mail/mimelib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/mailin/index.php', '21.12', 0),
('24976c9001a4a504a2bc0db794e41249', './lib/mailin/mailinlib.php', '21.12', 0),
('cd2534ea537c22109295093ea6794a4f', './lib/mailin/usermailinlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/menubuilder/index.php', '21.12', 0),
('b6e754101ed7c0bf80957f553274af06', './lib/menubuilder/menulib.php', '21.12', 0),
('dc9b8b8302bd472f601652b6203f9302', './lib/menubuilder/tiki-admin_menu_options.js', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/messu/index.php', '21.12', 0),
('6d2d659e33e9d5d4ccca05e15d73d7a1', './lib/messu/messulib.php', '21.12', 0),
('76cd7d5c1f753d0fcb735bdbfd74bc85', './lib/metadata/datatypes/basicinfo.php', '21.12', 0),
('63b7e40b3ea8e437f4d05971813afd47', './lib/metadata/datatypes/exif.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/metadata/datatypes/index.php', '21.12', 0),
('9ada775a241535c5fe86b70efd16af70', './lib/metadata/datatypes/iptc.php', '21.12', 0),
('5e54b4342968ed5db8cb8251c70bcd5d', './lib/metadata/datatypes/xmp.php', '21.12', 0),
('1ee1b6a691006107df87917b553d7638', './lib/metadata/filetypes/imagefile.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/metadata/filetypes/index.php', '21.12', 0),
('2f7449d451f4bcb6ab444afd456578f6', './lib/metadata/filetypes/jpeg.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/metadata/index.php', '21.12', 0),
('152a5f11896ed9449ee20b9899b2b393', './lib/metadata/metadatalib.php', '21.12', 0),
('ff078482a08ba438a9f7f14cdf85fc4f', './lib/metadata/reconcile.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/mime/index.php', '21.12', 0),
('eb6a708616682d6532c608b2b2067d88', './lib/mime/mimelib.php', '21.12', 0),
('849ea2119a106d79a18085ace30e4a18', './lib/mime/mimetypes.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/minical/index.php', '21.12', 0),
('2bf0ee7f9a1436df934009e1feed1b96', './lib/minical/minicallib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/modules/index.php', '21.12', 0),
('059ae483e8996985ae4b81fdb97a3f56', './lib/modules/modlib.php', '21.12', 0),
('9013bf24fd0c771e08d7c64b7a68bcd5', './lib/modules/tiki-admin_modules.js', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/multilingual/index.php', '21.12', 0),
('7cedf39aaf59a5e4c83f0d947a876bd4', './lib/multilingual/multilinguallib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/newsletters/index.php', '21.12', 0),
('7f618a6cc71085d46cc6cee208aa5ab3', './lib/newsletters/nllib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/notepad/index.php', '21.12', 0),
('5adcbd12e7395ee06d71a155bec0499e', './lib/notepad/notepadlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/notifications/index.php', '21.12', 0),
('fe301ecf484d7ea009bf075f26148adc', './lib/notifications/notificationemaillib.php', '21.12', 0),
('8b1dca5e60576487d827688d373d950e', './lib/notifications/notificationlib.php', '21.12', 0),
('129a2338faee972d1e237f46380509f0', './lib/oauthlib.php', '21.12', 0),
('b3512252516341ed5e447e0d929ecbcf', './lib/oauthserver/entities/AccessTokenEntity.php', '21.12', 0),
('42f466bbd8f07faf800ce4602d51e0b3', './lib/oauthserver/entities/AuthCodeEntity.php', '21.12', 0),
('214c3a632d9555f687b1be36a5e0b0b5', './lib/oauthserver/entities/ClientEntity.php', '21.12', 0),
('1b943d8d35c05027baf903055bbfcb28', './lib/oauthserver/entities/RefreshTokenEntity.php', '21.12', 0),
('4b062c16b897026bf9adaadcf1238c93', './lib/oauthserver/entities/ScopeEntity.php', '21.12', 0),
('3d217c33a95ef46c608f93ebeb5d027a', './lib/oauthserver/entities/UserEntity.php', '21.12', 0),
('af0a9833e63820a01aa321f705444a3f', './lib/oauthserver/helpers.php', '21.12', 0),
('d9a7ab98c15ee3208b0f0fdebdc0aef0', './lib/oauthserver/oauthserverlib.php', '21.12', 0),
('e79bf8100120fadfd2ea73ddacd101a5', './lib/oauthserver/repositories/AccessTokenRepository.php', '21.12', 0),
('44c4db7594658cc4d5cc1268f0a813a3', './lib/oauthserver/repositories/AuthCodeRepository.php', '21.12', 0),
('40cf096f5336e2c6c4ac55e8cf331bb6', './lib/oauthserver/repositories/ClientRepository.php', '21.12', 0),
('ca9c852687f6f029ae85e76f4a4b76cd', './lib/oauthserver/repositories/RefreshTokenRepository.php', '21.12', 0),
('59d597bffb906ab650a31babda39da80', './lib/oauthserver/repositories/ScopeRepository.php', '21.12', 0),
('96984350f148f6a93e12c9debd1c6af7', './lib/oauthserver/responsetypes/BearerTokenResponse.php', '21.12', 0),
('4159e563b090628fa61e6e68102b931b', './lib/oauthserver/server/AuthorizationServer.php', '21.12', 0),
('34745b9e54995dccff328b6b930a0d37', './lib/objectlib.php', '21.12', 0),
('f2f5f3d6be8606b356be7b8936b6ba3c', './lib/ocrlib.php', '21.12', 0),
('94eca680d7048c48aee128f70ebc4d89', './lib/ointegratelib.php', '21.12', 0),
('63508ed874da1432017a7c808f00bc2b', './lib/openlayers/OpenLayers.js', '21.12', 0),
('bc6ec4a829998bb09aeb9ee49f72406c', './lib/openlayers/OpenLayers.light.js', '21.12', 0),
('b624d36aec327baad809a9c326faac31', './lib/openlayers/OpenLayers.mobile.js', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/art/index.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/img/index.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/index.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/licenses/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/openlayers/theme/dark/index.php', '21.12', 0),
('a6bcea2af384a1f59ceaf6d99a737b72', './lib/openlayers/theme/default/google.css', '21.12', 0),
('ae75483aedfcd7d1ea3bb11f6148cf2f', './lib/openlayers/theme/default/google.tidy.css', '21.12', 0),
('97e9508128e3d02599b15c947b8490a1', './lib/openlayers/theme/default/ie6-style.css', '21.12', 0),
('256c553a4738811397517c82f0119101', './lib/openlayers/theme/default/ie6-style.tidy.css', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/theme/default/img/index.php', '21.12', 0),
('d7e4ed1a6b03b93c4452db55dc262927', './lib/openlayers/theme/default/style.css', '21.12', 0),
('340578162d772d9c74c7f0785b4754e8', './lib/openlayers/theme/default/style.mobile.css', '21.12', 0),
('9132583981f7f7ef6f3c00a387bdca6f', './lib/openlayers/theme/default/style.mobile.tidy.css', '21.12', 0),
('9521ac61157d73a252cdebe6df5e019d', './lib/openlayers/theme/default/style.tidy.css', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/theme/index.php', '21.12', 0),
('089aa1736c31c7d56af011497933929a', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Sendmail.php', '21.12', 0),
('053a71b911dc5a8ed3d5102cfc77a7a1', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Smtp.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/openpgp/index.php', '21.12', 0),
('84b4c2366398618e1a56bb9089f687a4', './lib/openpgp/openpgplib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/parser/index.php', '21.12', 0),
('38bdc93a1603b58249da6f7d304121ad', './lib/parser/parserlib.php', '21.12', 0),
('bc6b665d2b4568a5c8b562ba737a3abd', './lib/pass_blacklists/index.php', '21.12', 0),
('460e632e88f693ecac28e2d47fcd1c56', './lib/payment/behavior/cancel_cart_order.php', '21.12', 0),
('c0065e60dd7baa9503910758290711d7', './lib/payment/behavior/cancel_membership_extension.php', '21.12', 0),
('538eed1d5bcfd1ea39a747d35ffd1839', './lib/payment/behavior/cart_exchange_product.php', '21.12', 0),
('93c17c8eff8fc8f0914d3adeb07bcbb1', './lib/payment/behavior/cart_gift_certificate_purchase.php', '21.12', 0),
('f4e615d82873273808ec26264d1b336b', './lib/payment/behavior/cart_gift_certificate_refund.php', '21.12', 0),
('6b570a7eb859db619cd2b527aa6e43a9', './lib/payment/behavior/cart_send_confirm_email.php', '21.12', 0),
('261d06ffacb45389391b22e6ef42da07', './lib/payment/behavior/execute_datachannel.php', '21.12', 0),
('47c87e33e7d2fc292d95a1c451533c11', './lib/payment/behavior/extend_membership.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/payment/behavior/index.php', '21.12', 0),
('942a95c9ef5155c5daef53de2c1b1471', './lib/payment/behavior/perform_trade.php', '21.12', 0),
('e2d739c5a8b184a61555ab2e30bd7396', './lib/payment/behavior/record_cart_order.php', '21.12', 0),
('eb8780e89ace82884bd2613c13194e49', './lib/payment/behavior/replace_inventory.php', '21.12', 0),
('06c0e2bedfc097caea7df49629130f13', './lib/payment/behavior/sample.php', '21.12', 0),
('47fa5c19dbbd4a8960a7c0dd3620bcf3', './lib/payment/cartlib.js', '21.12', 0),
('1f2cbd6b539770108100fd40aaf43944', './lib/payment/cartlib.php', '21.12', 0),
('d967934aa7e4fb39b301c9ed56d12fb2', './lib/payment/cclitelib.php', '21.12', 0),
('cfc7287972bf7cf8a00b20e415c7cdb4', './lib/payment/creditspaylib.php', '21.12', 0),
('765b32b2a6f803f538c4099416c89381', './lib/payment/discountlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/payment/index.php', '21.12', 0),
('f1f30b4f0b18ec93afb0f9576777124c', './lib/payment/israelpostlib.php', '21.12', 0),
('2cf40970343f8654d87b81cf1579b46f', './lib/payment/paymentlib.php', '21.12', 0),
('57f7b56c6bcd3f52bfb6a0595a2ef678', './lib/payment/paypallib.php', '21.12', 0),
('1bbaf9036a95c1599f1244863e43bfe4', './lib/pdfimages.php', '21.12', 0),
('53c03958df79a006dcbcdd1cd4c89e28', './lib/pdflib.php', '21.12', 0),
('1705e706e1d31dd90bca4dc41a69ea30', './lib/perspective/binderlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/perspective/index.php', '21.12', 0),
('534bc90d58f63f15d5f9e7107dd4ea17', './lib/perspectivelib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/phpseclib_tiki/index.php', '21.12', 0),
('3e1d5de090dacc8470afb8e19ced6e33', './lib/phpseclib_tiki/tikisecure.php', '21.12', 0),
('78ea176d27b185bb21d41097bf269e24', './lib/polls/index.php', '21.12', 0),
('8e1834825397c887bb1d7e4e7386445a', './lib/polls/polllib.php', '21.12', 0),
('6e5de27adfa34aa380d066f40ad08ee1', './lib/polls/polllib_shared.php', '21.12', 0),
('dcb1f51271ce086a545f513e1770204a', './lib/prefs/access.php', '21.12', 0),
('74a36845ca1b977d54254fa77c54937a', './lib/prefs/activity.php', '21.12', 0),
('7e171333ccfe3670c94ffe8ed5b4259c', './lib/prefs/ajax.php', '21.12', 0),
('2bafeaf0a374b4e6423800e47b1208bf', './lib/prefs/alchemy.php', '21.12', 0),
('3d168c10e2eb550c33d2ae2d24939c25', './lib/prefs/allocate.php', '21.12', 0),
('8b13cfd808cc9a548b0e46be8252adb0', './lib/prefs/allowmsg.php', '21.12', 0),
('f2f4ebf012c96e73ddc651461c7e5288', './lib/prefs/areas.php', '21.12', 0),
('ee56ed546434887c40712aea7fa66c4e', './lib/prefs/art.php', '21.12', 0),
('f2aeaa9990f9d31a01a0bc2b86bf78ea', './lib/prefs/article.php', '21.12', 0),
('2ba2e29abb746eae49fac58925aea202', './lib/prefs/auth.php', '21.12', 0),
('c087b81c3abf6f5e57a36755251dc19a', './lib/prefs/available.php', '21.12', 0),
('779e1db0cf04b321e12a4cc8edc007d4', './lib/prefs/bigbluebutton.php', '21.12', 0),
('1c233b03491e4e0e55dd669ac79014c1', './lib/prefs/blog.php', '21.12', 0),
('ed0416d4a195eeda17d3f65dcb2b2223', './lib/prefs/box.php', '21.12', 0),
('d17c6bac50dbc0894c8aa3e88484b772', './lib/prefs/calendar.php', '21.12', 0),
('803b67add008eaba201de9cf6ca077a5', './lib/prefs/captcha.php', '21.12', 0),
('a58c1ec04ee1b5ea10a130ad8a409ac6', './lib/prefs/cas.php', '21.12', 0),
('ab554b627da8c3b4fc1e896cfd8fd3c7', './lib/prefs/categories.php', '21.12', 0),
('ccf40d9d62f8f60cfef5aec1090b42f2', './lib/prefs/category.php', '21.12', 0),
('5c7fa37aa2770d17194dd02dcbf3a0dc', './lib/prefs/categorypath.php', '21.12', 0),
('9ff67a3f543a7b29a39183eb204da511', './lib/prefs/center.php', '21.12', 0),
('3e392170d59537f260d85e0c96612c15', './lib/prefs/change.php', '21.12', 0),
('7ffa95814b7d26a8e6f0dadadbe801c3', './lib/prefs/comments.php', '21.12', 0),
('e2223f59ad40e00484c951f031420431', './lib/prefs/conditions.php', '21.12', 0),
('f8c5fb4f055edc3c81d39b30132be3dc', './lib/prefs/connect.php', '21.12', 0),
('8723e055c8a61cf4c5995ee99d0e3826', './lib/prefs/contact.php', '21.12', 0),
('d391d88c692b59d823f5f52d8fb52697', './lib/prefs/cookie.php', '21.12', 0),
('b7b99cdb946f171695c5bea72bc1e35d', './lib/prefs/count.php', '21.12', 0),
('7979f0de4af49e252f69d252c232f498', './lib/prefs/dailyreports.php', '21.12', 0),
('8da8a486d34e3a5ac657cfb50df6fcde', './lib/prefs/default.php', '21.12', 0),
('ce45f073a27c18324f7fab7462dde61e', './lib/prefs/desactive.php', '21.12', 0),
('061f4a8dccd0efc92134db255d42512d', './lib/prefs/direct.php', '21.12', 0),
('dd92c0d494e8817ce85fc502588a8b22', './lib/prefs/directory.php', '21.12', 0),
('3293d1d28dedc2f64bfcfdeeced5f29d', './lib/prefs/display.php', '21.12', 0),
('e5be341ac8425937a05cc3d79eafb43f', './lib/prefs/email.php', '21.12', 0),
('e0e1eb7c67fbc12bc31b5b33edcff267', './lib/prefs/error.php', '21.12', 0),
('4dae0b5151595021e3dc575ce46e9076', './lib/prefs/faq.php', '21.12', 0),
('cec9822a044bac25fc2a93d3bb210ee5', './lib/prefs/feature.php', '21.12', 0),
('898252b93d7d9fd5487b8d1835809c85', './lib/prefs/federated.php', '21.12', 0),
('298682b176f199deb3b843b6733eb190', './lib/prefs/feed.php', '21.12', 0),
('ebae30fd982be9bfed7a19a6b13fa4f5', './lib/prefs/fgal.php', '21.12', 0),
('0a77b02fc9bbc307aab8d3128f061f76', './lib/prefs/file.php', '21.12', 0),
('9d5779ff5e4c3991541f383ca00b4032', './lib/prefs/flaggedrev.php', '21.12', 0),
('8e4132d665b5b29c1bebbb12a9a0160c', './lib/prefs/footer.php', '21.12', 0),
('dc69a4b79d8564151975fe7b3a421f07', './lib/prefs/footnote.php', '21.12', 0),
('84b953712be6677ac21c59fe48fb0e52', './lib/prefs/forum.php', '21.12', 0),
('b9636052752e661addf4520faf2be2df', './lib/prefs/forums.php', '21.12', 0),
('bf94d9553bd2d728cb0303cb44f908c3', './lib/prefs/freetags.php', '21.12', 0),
('0c4918e6cfd7378d586b52e4db574ede', './lib/prefs/gal.php', '21.12', 0),
('a49d092df28b85029ce9cf33b38bc343', './lib/prefs/generate.php', '21.12', 0),
('129b9de7be85270991fb84be69ec3d8f', './lib/prefs/geo.php', '21.12', 0),
('d88e557c40f028999b30bb053b195ecd', './lib/prefs/global.php', '21.12', 0),
('d1a92d3be933f729f7357d78ab725bef', './lib/prefs/gmap.php', '21.12', 0),
('91e7b17a92c58d3d59454388ce34a556', './lib/prefs/goal.php', '21.12', 0),
('09f121ced1eb045b0a4a52aefc19db13', './lib/prefs/h5p.php', '21.12', 0),
('db93bf19e62ae651df5d138f3b510a99', './lib/prefs/header.php', '21.12', 0),
('0ccbd7e1b039000a0f90f3c941d2e2f3', './lib/prefs/highlight.php', '21.12', 0),
('63380fbe3b55e0920114ed1df137b41d', './lib/prefs/home.php', '21.12', 0),
('18ab75c0424c0e03c74fc3452d16a497', './lib/prefs/http.php', '21.12', 0),
('d447a0d787781013d657a0b688e18489', './lib/prefs/https.php', '21.12', 0),
('91aff34c0a3198395a17d0836553895b', './lib/prefs/ids.php', '21.12', 0),
('1364dc8173c7a64124d4cdb9a11879b2', './lib/prefs/image.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/prefs/index.php', '21.12', 0),
('43a418d1c24e63b90dea7306c61236b4', './lib/prefs/intertiki.php', '21.12', 0),
('3ea05721720dc5921e74bc79fa07f70e', './lib/prefs/ip.php', '21.12', 0),
('2333e93192d6e6adbc8a4b719f76d814', './lib/prefs/javascript.php', '21.12', 0),
('79b3e12ea9d2a180acebf66ff29d8952', './lib/prefs/jquery.php', '21.12', 0),
('25aff75272ef444f55133038e0ce55cd', './lib/prefs/kaltura.php', '21.12', 0),
('9037de028049a9db7cfe4e9bce7a5e3b', './lib/prefs/keep.php', '21.12', 0),
('847a1d586a4a5d80581ea79f7df3ee14', './lib/prefs/lang.php', '21.12', 0),
('bf3e06b566ab727722e216e6c5f3c916', './lib/prefs/language.php', '21.12', 0),
('2840238295400ef8a78b4361f55697f6', './lib/prefs/layout.php', '21.12', 0),
('d5b347302b9b83736a06b134f1deafcf', './lib/prefs/ldap.php', '21.12', 0),
('0f9905519b2a72e195c81f2e3f5b20c0', './lib/prefs/load.php', '21.12', 0),
('ed7d28662da55f5ec11df5d819499dd3', './lib/prefs/lock.php', '21.12', 0),
('558a894146b061012fae17c9c577d397', './lib/prefs/log.php', '21.12', 0),
('1c99b8cde2254fe72b8a103a5966d763', './lib/prefs/login.php', '21.12', 0),
('a0cb1da5990e65cd24bff72edeabd9b8', './lib/prefs/long.php', '21.12', 0),
('8f462106f9e52d6871b5c4fd23dd8159', './lib/prefs/lowercase.php', '21.12', 0),
('b50264b3f62e162e20a32f3f9e6c7fa5', './lib/prefs/mail.php', '21.12', 0),
('002e7be1f916b8906fe50038c40ae849', './lib/prefs/main.php', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('00057cf51be128e279c21d6f733da9dc', './lib/prefs/max.php', '21.12', 0),
('5a0a506f30a26a9b0394238466996940', './lib/prefs/memcache.php', '21.12', 0),
('bd852fd23ea8283314f853c60f5b60d0', './lib/prefs/menus.php', '21.12', 0),
('0e16f95173b4bcdee251f6b184002dc5', './lib/prefs/messu.php', '21.12', 0),
('4e76d2fc1fdab9afc42874d9f82731bf', './lib/prefs/metatag.php', '21.12', 0),
('b95bdc8817463e9b039017bec90ff127', './lib/prefs/middle.php', '21.12', 0),
('9aaf6b1816dad5f72d697e4ffc7bf453', './lib/prefs/min.php', '21.12', 0),
('a9d99ec1c134d00607be3a7460fc9f81', './lib/prefs/mobile.php', '21.12', 0),
('3ab88c7e0d6c546e9e80e0c04aff5d33', './lib/prefs/module.php', '21.12', 0),
('13a69a401f8cb9b93cfa7a5cadf1aa43', './lib/prefs/monitor.php', '21.12', 0),
('a00467b2c825250c795d0a637824fb9a', './lib/prefs/morelikethis.php', '21.12', 0),
('a206d362c1c948b91731f7c88b790ffd', './lib/prefs/multidomain.php', '21.12', 0),
('df0e7d9333585bda0ef6a8b40ba9f3ad', './lib/prefs/mustread.php', '21.12', 0),
('0deeb30811fd3031782a0b8f8bc05570', './lib/prefs/namespace.php', '21.12', 0),
('78508b62fabf1766f2392e9b79fdcc5e', './lib/prefs/newsletter.php', '21.12', 0),
('a84e45bec5989162fd018e47f78145b3', './lib/prefs/nextprev.php', '21.12', 0),
('be123dadbb41642bd32283f6203b8ef5', './lib/prefs/oauthserver.php', '21.12', 0),
('dd67ed345adcdc7412aa76297b71ca41', './lib/prefs/object.php', '21.12', 0),
('c02135aa139593471a5803fa6b36b0dd', './lib/prefs/ocr.php', '21.12', 0),
('3a074c1bd46e82a6dbb420457baee736', './lib/prefs/openpgp.php', '21.12', 0),
('055c1517729c88e0960d6fc43d1f49c9', './lib/prefs/page.php', '21.12', 0),
('874b0b1d4513ed6270354c5d771cc00f', './lib/prefs/pagination.php', '21.12', 0),
('1534272bdec3e6af7475c605bbca4e4b', './lib/prefs/pam.php', '21.12', 0),
('af216648fc987ca4a109416eb51c0d67', './lib/prefs/pass.php', '21.12', 0),
('a7602ba6218d9f066e7d093bffcc3c4c', './lib/prefs/payment.php', '21.12', 0),
('2158c8b92658c1c4bdc37a4defb4fc02', './lib/prefs/permission.php', '21.12', 0),
('d3f76c40056a8747dc1680f13fb791fe', './lib/prefs/php.php', '21.12', 0),
('857be60083079266a5d0b28b7164e848', './lib/prefs/poll.php', '21.12', 0),
('c1067e852ea2510e0e9af1e74a77c2ed', './lib/prefs/preset.php', '21.12', 0),
('aec20b8bf3ecac0c82b69b0fdc3ece3d', './lib/prefs/print.php', '21.12', 0),
('2843317a0a9666034cbdaf44817b2bfe', './lib/prefs/profile.php', '21.12', 0),
('e0a5f56e6fb84f284d946e6e9d4ecee6', './lib/prefs/proxy.php', '21.12', 0),
('84a3df6630d4fb2a679ab4a00adb03c0', './lib/prefs/pwa.php', '21.12', 0),
('17c8b8ab56ff588d88088fb187478791', './lib/prefs/quantify.php', '21.12', 0),
('b3428259a4f646880a64344ecc5fe30e', './lib/prefs/rating.php', '21.12', 0),
('553abacdc51fdc37ead39dbf96ed3c5c', './lib/prefs/recaptcha.php', '21.12', 0),
('edcd2ecf5c17d25f6f9cdcb5b754d1d6', './lib/prefs/record.php', '21.12', 0),
('7fb81fb634275adb5939017a3b34f2d5', './lib/prefs/redis.php', '21.12', 0),
('e606af45462169c82b802aa5ad36443e', './lib/prefs/restrict.php', '21.12', 0),
('29a884f1a4d447d23d2850cf6d8a4f41', './lib/prefs/saml.php', '21.12', 0),
('efa11a8f1da8b10ff565d620742d9a0e', './lib/prefs/scheduler.php', '21.12', 0),
('7564b465afa616e2b73233223061e7a9', './lib/prefs/scorm.php', '21.12', 0),
('54ca06764ed20c230cab26a580627381', './lib/prefs/search.php', '21.12', 0),
('0fefb42931f8f63d1e395bcf528741d1', './lib/prefs/section.php', '21.12', 0),
('3aa5cb881a62fd7f22a8584a18e990b1', './lib/prefs/sefurl.php', '21.12', 0),
('f7e8547d80720d194fb8bc9e27f87aed', './lib/prefs/sender.php', '21.12', 0),
('9891d61217c570e5bff6d73607b80366', './lib/prefs/server.php', '21.12', 0),
('853122178d799c8852258303c4e30987', './lib/prefs/session.php', '21.12', 0),
('90af6488733fe4dbc545be3e4510585f', './lib/prefs/share.php', '21.12', 0),
('3c8b26b2b1d9d12a1a5a8126f038855c', './lib/prefs/shib.php', '21.12', 0),
('7644a58c76bddd025a5cfa32f22d90a8', './lib/prefs/shipping.php', '21.12', 0),
('13db3e7c0255ed001a2a50ab3cb26f81', './lib/prefs/short.php', '21.12', 0),
('725fd236788219454c4ceb69814a78fb', './lib/prefs/show.php', '21.12', 0),
('e1fbd5ea236aaa49adf8d2a4e838302b', './lib/prefs/site.php', '21.12', 0),
('19471e4bcb4cd35edc361a3008d3e297', './lib/prefs/sitead.php', '21.12', 0),
('afc123419f6f057d6f3f9dffb9eab49b', './lib/prefs/sitelogo.php', '21.12', 0),
('d91626ce0e51bf27eaa90c2214de4904', './lib/prefs/sitemap.php', '21.12', 0),
('1e0e1079dbb301a1d9f693489dd8326f', './lib/prefs/slide.php', '21.12', 0),
('8c82fe64708c714278a1421095b391c3', './lib/prefs/smarty.php', '21.12', 0),
('79b5e9fb3f1fe77f5b9a421a6c47ccc7', './lib/prefs/social.php', '21.12', 0),
('760ea41a86b77fdc09f82cf5ad65f815', './lib/prefs/socialnetworks.php', '21.12', 0),
('7240440e58c19f59e2ccd6116be47d01', './lib/prefs/storedsearch.php', '21.12', 0),
('e015dce7a188b7d0ca5ca3de1b5b1487', './lib/prefs/suite.php', '21.12', 0),
('c41a91a2532879840e66fa47f6b6606d', './lib/prefs/t.php', '21.12', 0),
('e6d680933077944bb96c6788d6af2fb4', './lib/prefs/theme.php', '21.12', 0),
('69588f0d46cbf2678b010138656e09fb', './lib/prefs/tiki.php', '21.12', 0),
('33e43fd6fa1e96ef761c3ae1b9138b3a', './lib/prefs/tracker.php', '21.12', 0),
('50b950bbc78507a754aabf27e8952e5c', './lib/prefs/trackerfield.php', '21.12', 0),
('9185d1d19753c0cc102e1f15c2319b35', './lib/prefs/uf.php', '21.12', 0),
('20a1546ca406a01a8961371a374fc045', './lib/prefs/unified.php', '21.12', 0),
('b5b17532e740ce33dd130ad776c5ef43', './lib/prefs/unsuccessful.php', '21.12', 0),
('9b2000eeec2ee74ef6e463b468633a9b', './lib/prefs/url.php', '21.12', 0),
('e901a07791c15cb2ac3669f41d2e2267', './lib/prefs/use.php', '21.12', 0),
('cd4296ee8a70ceb1b0ffa942bbedbc72', './lib/prefs/user.php', '21.12', 0),
('05fbfff95e2aa07735c785e568ac82a3', './lib/prefs/userfiles.php', '21.12', 0),
('fe836ce6c27ee5ee88683fa20cfb8b6b', './lib/prefs/username.php', '21.12', 0),
('ff47421170f14e7f54f5f1355495e4b3', './lib/prefs/users.php', '21.12', 0),
('6eea05db7069cbeb41cb2dcc6b44ecaa', './lib/prefs/validator.php', '21.12', 0),
('64a9aa6664ccf78d7eb733eba42a1909', './lib/prefs/vimeo.php', '21.12', 0),
('4580a283bc6ca870e8f5d1931638812c', './lib/prefs/vuejs.php', '21.12', 0),
('83c632a3fc8a8e7ae6ae1bcdcc2a6922', './lib/prefs/w.php', '21.12', 0),
('e223653a4f3c8681248a6cf82813ca28', './lib/prefs/warn.php', '21.12', 0),
('b461eb0245815a9fe93a3a84a871e72c', './lib/prefs/webcron.php', '21.12', 0),
('8f454cc3d7b926e208df492ab97b1dca', './lib/prefs/webservice.php', '21.12', 0),
('1e2b9d400f7210a3e9d76fc1a06b6f32', './lib/prefs/wiki.php', '21.12', 0),
('311fe1cec6b3c043bc5c1ebbd475b0f5', './lib/prefs/wikiapproval.php', '21.12', 0),
('10add00d063c7a1e4c0b53a6cb195e5e', './lib/prefs/wikiplugin.php', '21.12', 0),
('5f3fbeada1c252d24d75b1b53c2f0a81', './lib/prefs/wikiplugininline.php', '21.12', 0),
('5c74c7fc727a6ee80444ae52a00d63d6', './lib/prefs/wikipluginprefs.php', '21.12', 0),
('ebc3005d8bba06ce4cb4ad3631f64b0c', './lib/prefs/wizard.php', '21.12', 0),
('f09359d8b726ef4cb543458b55f1240a', './lib/prefs/workspace.php', '21.12', 0),
('86953b2952172307cffc42b812804aca', './lib/prefs/wysiwyg.php', '21.12', 0),
('89cdeb1368db75f434279ce6a9c97b3b', './lib/prefs/xmpp.php', '21.12', 0),
('feb1e7a65488b9237ae60ec688ebb56a', './lib/prefs/zend.php', '21.12', 0),
('0fe81284ee37a204feb6b64b19309efb', './lib/prefs/zotero.php', '21.12', 0),
('484312e1c5dd52030baa5446a6f07a75', './lib/prefslib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/profilelib/index.php', '21.12', 0),
('2a0a39243d50f78b67d80943cd945cd9', './lib/profilelib/shell.php', '21.12', 0),
('c2a544ad2e8302a3059cfa31a384761e', './lib/pwa/app.js', '21.12', 0),
('76406a0d21259afe5b4f09c5de1c5387', './lib/queuelib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/quizzes/index.php', '21.12', 0),
('46ddbaeda9a943e196dd27b7d28a46eb', './lib/quizzes/quizlib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/rangy_tiki/index.php', '21.12', 0),
('8ba14c961b254142083975948acad297', './lib/rangy_tiki/rangy-phraser.js', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/rankings/index.php', '21.12', 0),
('b1cf900597c60426e1ec6674dea063cf', './lib/rankings/ranklib.php', '21.12', 0),
('58a07496fe20e98e65fb8e345da49b19', './lib/rating/configlib.php', '21.12', 0),
('74b54134054580dd6a77aa71d257f29a', './lib/rating/formula/ArticleInfo.php', '21.12', 0),
('c6c9f542d20352a7ddfe767a0295b9d9', './lib/rating/formula/Attribute.php', '21.12', 0),
('a98fb56c02620f38218bea554c049c8a', './lib/rating/formula/CategoryPresent.php', '21.12', 0),
('d974e5a6562e617a7861d3d6fdcbc1b3', './lib/rating/formula/RatingAverage.php', '21.12', 0),
('d494c14ef47e421c5c2334b3b76afd4a', './lib/rating/formula/RatingSum.php', '21.12', 0),
('53b739405280d390ca555e6584168a9d', './lib/rating/formula/RelationPresent.php', '21.12', 0),
('4f20f2dba09b122757aeec6ca975c868', './lib/rating/formula/ResultCount.php', '21.12', 0),
('a7d5c940e6b03c48cbe5e26a1bd7cd95', './lib/rating/formula/TrackerField.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/rating/formula/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/rating/index.php', '21.12', 0),
('a3802ddf7bf7f6703c04b55152b6079d', './lib/rating/ratinglib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/references/index.php', '21.12', 0),
('7a6e918e1ed1366d60b781dab98f2b2a', './lib/references/referenceslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/refererstats/index.php', '21.12', 0),
('c055c4f0aea3d3b3cc5da62e74b27bca', './lib/refererstats/refererlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/registration/index.php', '21.12', 0),
('ed4b2efab7d1cc418e1035ec8da52722', './lib/registration/registrationlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/rss/index.php', '21.12', 0),
('90fc55096286fac3d293152a656c75a9', './lib/rss/pagecontentlib.php', '21.12', 0),
('0582f0976bd1a3e5a1fd925237152164', './lib/rss/rsslib.php', '21.12', 0),
('e13e3415d0bd5e6d6932ed3f656f43d0', './lib/schedulerslib.php', '21.12', 0),
('8f81251aa47931366cdf4e37192d8d37', './lib/score/events.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/score/index.php', '21.12', 0),
('3e02ce9b43ebff17625b576252cd3bb8', './lib/score/scorelib.php', '21.12', 0),
('0294d0e2f92b7e9a9ab72470b66423ff', './lib/search/federatedsearchlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/search/index.php', '21.12', 0),
('7e4450562f9a42a969a52e63397ae424', './lib/search/refresh-functions.php', '21.12', 0),
('7b7ea77af60028aafcc24570c9920619', './lib/search/refresh.php', '21.12', 0),
('18197e000b423843c217872d59554b18', './lib/search/report_string_in_db.php', '21.12', 0),
('afc6992cb2cfd3fc95ecc7b3dee6eb7f', './lib/search/searchlib-mysql.php', '21.12', 0),
('c92c8e114eb86ff1dd420694aa7e4f68', './lib/search/searchlib-unified.php', '21.12', 0),
('924c4e42d9406514de06a9797509079b', './lib/search/searchstatslib.php', '21.12', 0),
('2a0a39243d50f78b67d80943cd945cd9', './lib/search/shell.php', '21.12', 0),
('5be721e3597b58c43dcf7f039a5370de', './lib/search/storedsearchlib.php', '21.12', 0),
('94db1cfb15c19cab8a9f408b203060ec', './lib/serializedlist.php', '21.12', 0),
('f6c3c03257c9eb17747e3e8e08e58e93', './lib/servicelib.php', '21.12', 0),
('f5b2a32ba0900ea57bd3c1cfdf6e6476', './lib/setup/absolute_urls.php', '21.12', 0),
('03ac9129b4b0344242a37a6806f8985f', './lib/setup/avatar_force_upload.php', '21.12', 0),
('a6e348ade4a54ac672596284c43fa950', './lib/setup/categories.php', '21.12', 0),
('ec57504d180cb71bf73f9ac489e975df', './lib/setup/comments_zone.php', '21.12', 0),
('4d13e0d2bfe549879bcf54b6b047532c', './lib/setup/cookies.php', '21.12', 0),
('60c796a875b32599b30bfcf568eb96d6', './lib/setup/credits.php', '21.12', 0),
('f0da42abe05197ed6f95838b86e152fd', './lib/setup/default_homepage.php', '21.12', 0),
('31074e9024431d87ca8886a487953268', './lib/setup/dynamic_variables.php', '21.12', 0),
('97e47df774c4500a4a0c8ae48a8af74d', './lib/setup/editmode.php', '21.12', 0),
('bbb8b083b26ca4ed4714ac4c940e93db', './lib/setup/error_reporting.php', '21.12', 0),
('2f890abe94f2958ad8f93d5134e91ae9', './lib/setup/events.php', '21.12', 0),
('007736f3c250c261918795272bfcf1db', './lib/setup/freetags.php', '21.12', 0),
('61b0b94256c31ff19178477dcfbecb05', './lib/setup/fullscreen.php', '21.12', 0),
('a06d31c4aa7bbe80b6db0dd3e280dae3', './lib/setup/ids.php', '21.12', 0),
('8586be511a7143b9595ba358d5b768d6', './lib/setup/index.php', '21.12', 0),
('182c4259a62517006e62353f84bdb294', './lib/setup/integrator.php', '21.12', 0),
('2ab612778d39f18ab9a17faf1ae883c1', './lib/setup/javascript.php', '21.12', 0),
('dacb4570f29d3b654086dccc20fb0f3d', './lib/setup/language.php', '21.12', 0),
('25588e81ba9a150d29a86044f55bd1f8', './lib/setup/last_update.php', '21.12', 0),
('9cf2540f3c5fc5c69e8a67452b7f9f92', './lib/setup/live_support.php', '21.12', 0),
('baa266bdb14dc26cf3f203f1de424e40', './lib/setup/load_threshold.php', '21.12', 0),
('4dd99b57b89c3c42c20eddd559892fdb', './lib/setup/mailin.php', '21.12', 0),
('35f47f7914575d952dda39fcb42a1e36', './lib/setup/mobile.php', '21.12', 0),
('6abe9501e2ddaa85f8bace0deaf64219', './lib/setup/openid.php', '21.12', 0),
('261f84e09dcda20aa6313613797a2005', './lib/setup/output_compression.php', '21.12', 0),
('356a86cb95e604a63f6022fe1aec0658', './lib/setup/perms.php', '21.12', 0),
('38a5291d78f17d5d895561fa3bd86ed6', './lib/setup/plugins_actions.php', '21.12', 0),
('8f6726cb8a390f9d8eb96944a35818c7', './lib/setup/polls.php', '21.12', 0),
('bc66205ab10a02da33a19502c8c6bd10', './lib/setup/prefs.php', '21.12', 0),
('0be592f046c9dd313a23befe1cfd6dc9', './lib/setup/sections.php', '21.12', 0),
('fdbc33b01c1f955e2f55049c378862ca', './lib/setup/site_closed.php', '21.12', 0),
('24bb895948d506fc99b0cb60bf9d6113', './lib/setup/stats.php', '21.12', 0),
('11d913f1ae92be56ca6a9816eb2cd2fe', './lib/setup/theme.php', '21.12', 0),
('bfe3f4137426aefa6f589c52cb6d8a83', './lib/setup/third_party.php', '21.12', 0),
('1cc5dd18d440a89cec10de2b2c3ca9e7', './lib/setup/tikiIndex.php', '21.12', 0),
('9bda328dec5f212545009c03c8a17a86', './lib/setup/tikisetup.class.php', '21.12', 0),
('a56495fa16cb71455279a0aff1d8b8d4', './lib/setup/timer.class.php', '21.12', 0),
('5c2e4706a0e0d721e4e0458e7b9a8487', './lib/setup/tracker_force_fill.php', '21.12', 0),
('ba7a50802782b74c44285bdfa175026d', './lib/setup/twversion.class.php', '21.12', 0),
('ddf0d7610e8b69eaa8d80bd4c90cd18c', './lib/setup/user_prefs.php', '21.12', 0),
('e0997ec5204b488d2e1eae2b51446513', './lib/setup/userlevels.php', '21.12', 0),
('f3139a7d63a8365cfc913746479c0230', './lib/setup/usermenu.php', '21.12', 0),
('bec4c79f351bf3725003c68d36c1c659', './lib/setup/wiki.php', '21.12', 0),
('74826c29ef5f044428195559acd73802', './lib/sharelib.php', '21.12', 0),
('caececa85df226832d81e902c2013bd1', './lib/sheet/conf/config.inc.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/sheet/conf/index.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/excel/index.php', '21.12', 0),
('70aa4f9e9dc0e57fd3c09f8e864bac9e', './lib/sheet/excel/reader.php', '21.12', 0),
('1ac9cc2c65d86d7f9af18dacb24ed917', './lib/sheet/excel/reader_ole.php', '21.12', 0),
('f3dd5f5074f5cc873f09bc71023cfb59', './lib/sheet/excel/writer.php', '21.12', 0),
('c402d499b081d7ebf6aa76251b88bcc2', './lib/sheet/excel/writer/biffwriter.php', '21.12', 0),
('b6a52362850347819b0b699174e43d24', './lib/sheet/excel/writer/format.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/excel/writer/index.php', '21.12', 0),
('a298a0e8996098122c4064bc8830d222', './lib/sheet/excel/writer/parser.php', '21.12', 0),
('cc0b4c6365515adee07681a795a233b7', './lib/sheet/excel/writer/validator.php', '21.12', 0),
('95db33b0fa3ee64b49fb706881202cc2', './lib/sheet/excel/writer/workbook.php', '21.12', 0),
('3b4e531a53863712df049403e706d6c6', './lib/sheet/excel/writer/worksheet.php', '21.12', 0),
('17c0027830fe09a797c467b49f8ffd62', './lib/sheet/grid.js', '21.12', 0),
('e5808c20dc1a6af9cde72e5d98703f14', './lib/sheet/grid.php', '21.12', 0),
('bc556d204d711f0c730ab28e40cffb28', './lib/sheet/include/core/APIC.php', '21.12', 0),
('4542c098a078aecbb83a418d8bf1f07e', './lib/sheet/include/core/APICObject.php', '21.12', 0),
('79655865bfe4361be8a9d9725a013c74', './lib/sheet/include/core/APIClass.php', '21.12', 0),
('205c382c7eb0ff387e96d9e3a43c63b7', './lib/sheet/include/core/APIClassRegistry.php', '21.12', 0),
('07e6bd8a686d6db0868999eec7ca7cd8', './lib/sheet/include/core/ErrorManager.php', '21.12', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/sheet/include/core/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/sheet/include/index.php', '21.12', 0),
('69585f702336477a9e4e1d5efdd86afb', './lib/sheet/include/org/apicnet/index.php', '21.12', 0),
('23a5439c43c837532c6890d6dbde018a', './lib/sheet/include/org/apicnet/io/File.php', '21.12', 0),
('32c7aec5e8b8a6b99f6066aff4ed96db', './lib/sheet/include/org/apicnet/io/OOo/OOoCalc.php', '21.12', 0),
('c735705436a587c87e862e84717ff81e', './lib/sheet/include/org/apicnet/io/OOo/OOoDoc.php', '21.12', 0),
('a46b78a97c19f4f3780de88f75ef4509', './lib/sheet/include/org/apicnet/io/OOo/OOoManifest.php', '21.12', 0),
('a76ef3b5fdbec8da10351035b5c623a3', './lib/sheet/include/org/apicnet/io/OOo/OOoMeta.php', '21.12', 0),
('829764b6154d63610515171ec420f471', './lib/sheet/include/org/apicnet/io/OOo/OOoMime.php', '21.12', 0),
('fd3d004a90c02298c7c5bf231d8bbb27', './lib/sheet/include/org/apicnet/io/OOo/OOoStyle.php', '21.12', 0),
('cda276917c2c9e757eba7a1454e0799e', './lib/sheet/include/org/apicnet/io/OOo/OOoUtil.php', '21.12', 0),
('d7d31bce1caadf373f0bff58dec2d7cd', './lib/sheet/include/org/apicnet/io/OOo/OOoWriter.php', '21.12', 0),
('459cbcd832d7c7615cce545efff9b5ce', './lib/sheet/include/org/apicnet/io/OOo/absOOo.php', '21.12', 0),
('dae46a9399e4cc46ba8ffa8befd32292', './lib/sheet/include/org/apicnet/io/OOo/index.php', '21.12', 0),
('d41d8cd98f00b204e9800998ecf8427e', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoCadre.php', '21.12', 0),
('c6712320e322ed6958e9802bd8b9173f', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoImg.php', '21.12', 0),
('a33136fa82591442c4d045edf0957504', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoTable.php', '21.12', 0),
('198cd93eb2cb5a1f8213b97e1d24d621', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoText.php', '21.12', 0),
('dae46a9399e4cc46ba8ffa8befd32292', './lib/sheet/include/org/apicnet/io/OOo/objOOo/index.php', '21.12', 0),
('c68767b198a7f08145ce4ff7d31f0531', './lib/sheet/include/org/apicnet/io/archive/CZip.php', '21.12', 0),
('57de715775c07de7aa80e3f3a55239e8', './lib/sheet/include/org/apicnet/io/archive/index.php', '21.12', 0),
('5c6ce7b1e2d187a20350fdc26caa928e', './lib/sheet/include/org/apicnet/io/cdir.php', '21.12', 0),
('7aeb069252f1125cf619fedc8b96e3d4', './lib/sheet/include/org/apicnet/io/index.php', '21.12', 0),
('cb48e59127b0679d89ee80df0cbcbcc9', './lib/sheet/include/org/apicnet/util/HTTPHeader.php', '21.12', 0),
('0b284345bb7820020cbe66613e56a234', './lib/sheet/include/org/apicnet/util/StringBuffer.php', '21.12', 0),
('7aeb069252f1125cf619fedc8b96e3d4', './lib/sheet/include/org/apicnet/util/index.php', '21.12', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/sheet/include/org/index.php', '21.12', 0),
('67a8a1562e6634841848c91b6a6b7067', './lib/sheet/index.php', '21.12', 0),
('da94f66a9ac0ed21c08632459d90a214', './lib/sheet/ole.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/ole/index.php', '21.12', 0),
('dd7feb67835510089dcdca10d2d3f1fd', './lib/sheet/ole/pps.php', '21.12', 0),
('262087e729cbcf64e53c77e0fc679c64', './lib/sheet/ole/pps/file.php', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/ole/pps/index.php', '21.12', 0),
('deba0a6edf921f9c8ed8025596cb3fa7', './lib/sheet/ole/pps/root.php', '21.12', 0),
('0780ba5cce66e52f81232c00e5e68e15', './lib/sheet/sheetlib.php', '21.12', 0),
('058f8e0fa5b40d4da4a0bf0d59265228', './lib/shipping/custom/example.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/shipping/custom/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/shipping/index.php', '21.12', 0),
('3fae23f2b578493bb139e54c802ed1ea', './lib/shipping/provider_fedex.php', '21.12', 0),
('d1065ce259f06c5d6cfe56a50be22e86', './lib/shipping/provider_ups.php', '21.12', 0),
('324c9231510a2648df6faa3cadfd6dfd', './lib/shipping/shippinglib.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/shipping/ups-wsdl/index.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/shoutbox/index.php', '21.12', 0),
('ed297dccfce3bdb84e5a3fb2fda5eb62', './lib/shoutbox/shoutboxlib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/simile_tiki/index.php', '21.12', 0),
('65f745e6113485a6723ff934c18f9679', './lib/simile_tiki/tiki-timeline.js', '21.12', 0),
('d027b11fe3ebf7a025b62f95901f0d38', './lib/smarty_tiki/block.accordion.php', '21.12', 0),
('3ab9690b2e0cd14e9020cd37f2a856ed', './lib/smarty_tiki/block.accordion_group.php', '21.12', 0),
('5e3ea5032c4b6849ccb7da0f3ba715ab', './lib/smarty_tiki/block.actions.php', '21.12', 0),
('6d1d937a33a6ee43d23a52843fc9de0e', './lib/smarty_tiki/block.activityframe.php', '21.12', 0),
('261e3f270fcff69353e29994b4eca5da', './lib/smarty_tiki/block.ajax_href.php', '21.12', 0),
('e54e65e6365ebd10a580c3329fa689a1', './lib/smarty_tiki/block.compact.php', '21.12', 0),
('15c99fd76dd1863296903f58e7dcf0a3', './lib/smarty_tiki/block.display.php', '21.12', 0),
('4981f1c4d939db4520676fba167b6968', './lib/smarty_tiki/block.filter.php', '21.12', 0),
('63d1cce68ee39b29744a11b47239d746', './lib/smarty_tiki/block.ifsearchexists.php', '21.12', 0),
('828e5efd4d721980d915f2bf6505417b', './lib/smarty_tiki/block.ifsearchnotexists.php', '21.12', 0),
('2876f8435be7917cb6184c7201cb43d4', './lib/smarty_tiki/block.itemfield.php', '21.12', 0),
('7f68f391245aeb4697c1ace0251e0025', './lib/smarty_tiki/block.jq.php', '21.12', 0),
('93ba09e9392566d6d8d1d4fc09e953b3', './lib/smarty_tiki/block.modules_list.php', '21.12', 0),
('7db2471da0e6bcb53839aba00be695ec', './lib/smarty_tiki/block.packageplugin.php', '21.12', 0),
('86ccf1268b497be6747f7f5a2fd53e0f', './lib/smarty_tiki/block.pagination_links.php', '21.12', 0),
('19639f3c23a85c599ce937d7e5aaac09', './lib/smarty_tiki/block.permission.php', '21.12', 0),
('4415a47b4e761ca0606b19c83dcc04ab', './lib/smarty_tiki/block.popup_link.php', '21.12', 0),
('4c0c9cff5dace5df8820d7f14db91e5f', './lib/smarty_tiki/block.remarksbox.php', '21.12', 0),
('17370754e07fc295ced6cec92842da9b', './lib/smarty_tiki/block.repeat.php', '21.12', 0),
('51de720f3bbd2f2b2950ea8610b29ca7', './lib/smarty_tiki/block.self_link.php', '21.12', 0),
('040be686ad01744e3c654aaadaf24f88', './lib/smarty_tiki/block.sortlinks.php', '21.12', 0),
('a3502c26157c8cfd7fb302f013e2f666', './lib/smarty_tiki/block.tab.php', '21.12', 0),
('168116b67d91767ac6f8bd4f6caf11bb', './lib/smarty_tiki/block.tabset.php', '21.12', 0),
('ac4b6c45c531b23ea3ced5ec3076dd90', './lib/smarty_tiki/block.textarea.php', '21.12', 0),
('76e5533294672ad6fb7e3c6c94cf332b', './lib/smarty_tiki/block.tikimodule.php', '21.12', 0),
('b02c37b6a248717830f32afc67d9a02f', './lib/smarty_tiki/block.title.php', '21.12', 0),
('8c5fbd7f77ff5beece8e2f1b0c80bc25', './lib/smarty_tiki/block.tr.php', '21.12', 0),
('f296b971133d4adab236a66d751ed13a', './lib/smarty_tiki/block.trackeritemcheck.php', '21.12', 0),
('ea45097832212d313ab075e0c70b857d', './lib/smarty_tiki/block.translation.php', '21.12', 0),
('c25ebe661e5c9892d82a97ab2c4b9656', './lib/smarty_tiki/block.vue.php', '21.12', 0),
('f57a8388e7635651493f18f92aa61258', './lib/smarty_tiki/block.wiki.php', '21.12', 0),
('2b54a7f74f4a51c6e3bfeda326739a54', './lib/smarty_tiki/block.wikiplugin.php', '21.12', 0),
('c4a1fb3aec9c7437d0551a7fb6d6c120', './lib/smarty_tiki/compiler.assign_content.php', '21.12', 0),
('6938a7efe4659e5956f6fa5b5dc63be0', './lib/smarty_tiki/function.activity.php', '21.12', 0),
('27e59e1a82d9c8c893a9497f13da606e', './lib/smarty_tiki/function.article.php', '21.12', 0),
('5459e9fd15f0dfc3037f0a9488c4f758', './lib/smarty_tiki/function.attachments.php', '21.12', 0),
('44917bb3cc6b5e7e86df17e7f8f09d68', './lib/smarty_tiki/function.autocomplete.php', '21.12', 0),
('06afb22f68d44b9ffee110a38d8c061b', './lib/smarty_tiki/function.banner.php', '21.12', 0),
('e314054616c7bb4c019d50fe8a06d30c', './lib/smarty_tiki/function.bootstrap_modal.php', '21.12', 0),
('c28b247ea5a4cd763b8dff00965d3fa6', './lib/smarty_tiki/function.breadcrumbs.php', '21.12', 0),
('8fad291ef9f6be3611fcc7edbba4f3d2', './lib/smarty_tiki/function.button.php', '21.12', 0),
('d58bfa5fba1bbfd18b82ffdf27974123', './lib/smarty_tiki/function.categoryName.php', '21.12', 0),
('78545a95f4f15316c2c64d13ff477090', './lib/smarty_tiki/function.categoryselector.php', '21.12', 0),
('d528d9770a97a20c858b6163d9e0ee3e', './lib/smarty_tiki/function.content.php', '21.12', 0),
('d1f52552438695b74a296026ad240f36', './lib/smarty_tiki/function.cookie.php', '21.12', 0),
('1a28a1ce02ae709cf11055e589b4e4ec', './lib/smarty_tiki/function.cookie_jar.php', '21.12', 0),
('6b5e82ba1101eaa32284f23f915a7ee7', './lib/smarty_tiki/function.count.php', '21.12', 0),
('854e00c28664b1c1f70c6b1c4e9720bc', './lib/smarty_tiki/function.currency.php', '21.12', 0),
('22ee4bcb0842c08e1b77ed521a6538f4', './lib/smarty_tiki/function.custom_template.php', '21.12', 0),
('32c7f893ad85394b13a3ad5cc6f8f554', './lib/smarty_tiki/function.datetime_range.php', '21.12', 0),
('4a4372b5eb56e8499baa035798e1b200', './lib/smarty_tiki/function.debugger.php', '21.12', 0),
('bd42fccd096dd5e089fd36db7a09b346', './lib/smarty_tiki/function.defaultmapcenter.php', '21.12', 0),
('9c8c2639c91b8d342580d7a847ba975e', './lib/smarty_tiki/function.ed.php', '21.12', 0),
('9fb3c744cb24ef7471ee835fed039caf', './lib/smarty_tiki/function.elapsed.php', '21.12', 0),
('f9afafcf76adbcacd12d7d842dd6eb4e', './lib/smarty_tiki/function.favorite.php', '21.12', 0),
('5df39d5d4b3be4b36e75bc13eb2daeb6', './lib/smarty_tiki/function.feedback.php', '21.12', 0),
('a723956b7edc0e3bcd7057b644a27b1a', './lib/smarty_tiki/function.fgal_browse.php', '21.12', 0),
('6a02515e3ad3e7bd786d65b643e388dd', './lib/smarty_tiki/function.file_selector.php', '21.12', 0),
('d3e649a2c8c36ca2bae3be76d883152b', './lib/smarty_tiki/function.filegal_manager_url.php', '21.12', 0),
('2c8cbee7820499cfcb6fe6e0d3c34f4e', './lib/smarty_tiki/function.filegal_uploader.php', '21.12', 0),
('4e0a6bf2879fc22c6abdacba63e0bcec', './lib/smarty_tiki/function.fileinfo.php', '21.12', 0),
('a184a0f3ee5bd67ebc4351aa2895e654', './lib/smarty_tiki/function.formitem.php', '21.12', 0),
('b82c479b8f7e98929f767a6fdde52d4f', './lib/smarty_tiki/function.gallery.php', '21.12', 0),
('871a9fc3cd6813c58badd4f1860ebe46', './lib/smarty_tiki/function.help.php', '21.12', 0),
('2bef8974fc9f0132c434525a8eef22c1', './lib/smarty_tiki/function.html_body_attributes.php', '21.12', 0),
('bcf4ff9b581f9a72fcd818df27f4b266', './lib/smarty_tiki/function.html_select_date.php', '21.12', 0),
('5a0b720d74a8411598a4c83e0ef90a88', './lib/smarty_tiki/function.html_select_duration.php', '21.12', 0),
('5381fb448fc66b6e9dd680c6842d14f7', './lib/smarty_tiki/function.html_select_time.php', '21.12', 0),
('71d7cbb4ccbabb2c1b32330fabc6b3dc', './lib/smarty_tiki/function.icon.php', '21.12', 0),
('ab627e6ce60d7a79ee5d6ddf37baeefe', './lib/smarty_tiki/function.initials_filter_links.php', '21.12', 0),
('cf7a2c4a2d94ead34c2ff611a69fab6f', './lib/smarty_tiki/function.interactivetranslation.php', '21.12', 0),
('2ae29be14fd5e00a42cb24b653652f61', './lib/smarty_tiki/function.js_insert_icon.php', '21.12', 0),
('d8b31a5a0d2c2529279bd513beeed723', './lib/smarty_tiki/function.js_maxlength.php', '21.12', 0),
('7ee74843267915ce16c0084c54948ea5', './lib/smarty_tiki/function.jscalendar.php', '21.12', 0),
('5296b9636a9c60ac957f5091224057ee', './lib/smarty_tiki/function.jspopup.php', '21.12', 0),
('f03887a4842a4cf130b04118e1acbd3d', './lib/smarty_tiki/function.like.php', '21.12', 0),
('be790bb15e8bf0fcd47726bbdf2941ea', './lib/smarty_tiki/function.listfilter.php', '21.12', 0),
('9d41550a596ce5bf3ea9d78ce0130a42', './lib/smarty_tiki/function.lock.php', '21.12', 0),
('b6157cc869bc06ec9b5cf5e6c857f4e7', './lib/smarty_tiki/function.memusage.php', '21.12', 0),
('5baa81f5e54ebff5b8c52fff3148f556', './lib/smarty_tiki/function.menu.php', '21.12', 0),
('87ae1fa6f847e6b020e106cb04c1a099', './lib/smarty_tiki/function.module.php', '21.12', 0),
('5d8b7a12c5adbd431e659d6685736607', './lib/smarty_tiki/function.modulelist.php', '21.12', 0),
('eb57ef081ea8c119da90b34b4cdbd3f4', './lib/smarty_tiki/function.monitor_link.php', '21.12', 0),
('29b45c268150303c4a220846fadc2844', './lib/smarty_tiki/function.multilike.php', '21.12', 0),
('67f008840df8c6cbb70293b55247863b', './lib/smarty_tiki/function.norecords.php', '21.12', 0),
('f9558b01d90ad04c6d17e4bc78c834c0', './lib/smarty_tiki/function.notification_link.php', '21.12', 0),
('c0505d2094b066c2e52d6957cbcd844a', './lib/smarty_tiki/function.obj_in_cat.php', '21.12', 0),
('767eeb13a5be6d4972da177017b40185', './lib/smarty_tiki/function.object_link.php', '21.12', 0),
('5a9a4d29df29b76165f70dc591145be8', './lib/smarty_tiki/function.object_score.php', '21.12', 0),
('3132f92d472a4a34eeedb62c694006da', './lib/smarty_tiki/function.object_selector.php', '21.12', 0),
('3df304617e3307f645536bdd00a5f85b', './lib/smarty_tiki/function.object_selector_multi.php', '21.12', 0),
('2b993de11fa00e9ac656bbdd2c8bdeef', './lib/smarty_tiki/function.object_title.php', '21.12', 0),
('8c31865d828aff9a7d375b1dab0e96de', './lib/smarty_tiki/function.object_type.php', '21.12', 0),
('917e7bd735064b0db45a5bd0329896ac', './lib/smarty_tiki/function.page_alias.php', '21.12', 0),
('0fd2bd6405720307efb78429cbd38406', './lib/smarty_tiki/function.page_in_structure.php', '21.12', 0),
('0f778ef391e761650c6d7f5737cb4a26', './lib/smarty_tiki/function.payment.php', '21.12', 0),
('d9988ae216da573a9f0808eaa925af83', './lib/smarty_tiki/function.permission_link.php', '21.12', 0),
('13e232ed1fa47c25102d660a5aff0dcf', './lib/smarty_tiki/function.pluralize.php', '21.12', 0),
('8c435e4001b0310555a001df8a96c212', './lib/smarty_tiki/function.poll.php', '21.12', 0),
('1eb6c50fcfea220a684700aaeaedc94f', './lib/smarty_tiki/function.popup.php', '21.12', 0),
('ab39f2365d173f2a8d849c9f8d572ed1', './lib/smarty_tiki/function.preference.php', '21.12', 0),
('f5df6e6fd8b8bb800c585065c5ad6889', './lib/smarty_tiki/function.profilesymbolvalue.php', '21.12', 0),
('8f7b0d5744f9913cb83d230e552d2c02', './lib/smarty_tiki/function.query.php', '21.12', 0),
('ad0c2fa5acd371415c39e5fc1f4d6395', './lib/smarty_tiki/function.quotabar.php', '21.12', 0),
('2e1d00cb646b3841069ddaede2448b96', './lib/smarty_tiki/function.rating.php', '21.12', 0),
('85de1ea4a0e9af51b5adb2fae4216101', './lib/smarty_tiki/function.rating_choice.php', '21.12', 0),
('aa05b73d85b5b3ff446718c299e8af27', './lib/smarty_tiki/function.rating_override_menu.php', '21.12', 0),
('635c92fed7a10bdc6bc7ae87982875ce', './lib/smarty_tiki/function.rating_result.php', '21.12', 0),
('8dae5586c0c19c6ddfc66ad97a88d68d', './lib/smarty_tiki/function.rating_result_avg.php', '21.12', 0),
('b165f40ceb9b293eddc2790af8e19a88', './lib/smarty_tiki/function.rcontent.php', '21.12', 0),
('8381b173b01acaf35b203d5fd055813e', './lib/smarty_tiki/function.redirect.php', '21.12', 0),
('812dfd33a5839eea538de17d17c3a8d1', './lib/smarty_tiki/function.reindex_file_pixel.php', '21.12', 0),
('4c96530d4dd8e46e3cdb4fbac097e9a6', './lib/smarty_tiki/function.router_params.php', '21.12', 0),
('a0223dac9d0c68d02819caf3192aeb99', './lib/smarty_tiki/function.rss.php', '21.12', 0),
('a3c4c742ec8b17227a38b98652b6dbd1', './lib/smarty_tiki/function.sameurl.php', '21.12', 0),
('9fb379db8c1c76c48dc116af3d983ca5', './lib/smarty_tiki/function.scheduler_params.php', '21.12', 0),
('8287939793d24ea04d353741fa55e658', './lib/smarty_tiki/function.sefurl.php', '21.12', 0),
('fce205779460aced4c9ab255a2742488', './lib/smarty_tiki/function.select_all.php', '21.12', 0),
('c44be097511583efad2be108b47d6b64', './lib/smarty_tiki/function.service.php', '21.12', 0),
('e784cca813f7b2810a3e4ac24882b6c2', './lib/smarty_tiki/function.service_inline.php', '21.12', 0),
('3210e224a7e4b9a960ea30e4e2ea57df', './lib/smarty_tiki/function.set.php', '21.12', 0),
('9182679850ad5730aa93f50a64869ad0', './lib/smarty_tiki/function.show_sort.php', '21.12', 0),
('8dd9ea2c9df661111351c4c707ead475', './lib/smarty_tiki/function.svn_lastup.php', '21.12', 0),
('9d6a75907dfc85f70bfff2ad4baae8aa', './lib/smarty_tiki/function.svn_rev.php', '21.12', 0),
('1e2c00a6a7d6b3b4279c4f90ff5643ec', './lib/smarty_tiki/function.thumb.php', '21.12', 0),
('b8ad5df3fdc4a78080cde3e263dcbfc3', './lib/smarty_tiki/function.ticket.php', '21.12', 0),
('64c7b72adbe4cc82cec745fa30277d73', './lib/smarty_tiki/function.toolbars.php', '21.12', 0),
('a8dd7ba7952d0d2fa5a47220fa00bff4', './lib/smarty_tiki/function.tracker_item_status_icon.php', '21.12', 0),
('941661a53f22ce0b582ab38f04c7d470', './lib/smarty_tiki/function.trackerfields.php', '21.12', 0),
('808ef39ae2cd44ebddcd0e516d51b79a', './lib/smarty_tiki/function.trackerheader.php', '21.12', 0),
('d2ec8bcd9cc3b2d850282d7ce60e1a0c', './lib/smarty_tiki/function.trackerinput.php', '21.12', 0),
('5329a9eb2a62c5af2727fb7f4db933ce', './lib/smarty_tiki/function.trackeroutput.php', '21.12', 0),
('99acfc0811e10b272d2e9b87096b414d', './lib/smarty_tiki/function.trackerrules.php', '21.12', 0),
('980542ebe706c27cfd2833cc0f1490c9', './lib/smarty_tiki/function.treetable.php', '21.12', 0),
('f31421adc87756f1c9f44e7d83b5a962', './lib/smarty_tiki/function.user_registration.php', '21.12', 0),
('bf3e48277bc261822868b03180ee80f4', './lib/smarty_tiki/function.user_selector.php', '21.12', 0),
('3bb18584ef2dbae2ad5da55857ea4876', './lib/smarty_tiki/function.var_dump.php', '21.12', 0),
('59cf0f60d633ba5159e1f700ae6a8700', './lib/smarty_tiki/function.vimeo_uploader.php', '21.12', 0),
('4367ae4e448a35b585e32828f785d521', './lib/smarty_tiki/function.wikidiff.php', '21.12', 0),
('82b3c74bb20606c3e033e1be0e7be4fc', './lib/smarty_tiki/function.wikistructure.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/smarty_tiki/index.php', '21.12', 0),
('8ff529ce04fc4e1244cf947bc90f78ea', './lib/smarty_tiki/modifier.a_or_an.php', '21.12', 0),
('b650a9590dd91f15d50e42236d32003c', './lib/smarty_tiki/modifier.adjust.php', '21.12', 0),
('3abd18a0e78d7eee64e56326a4f6268f', './lib/smarty_tiki/modifier.avatarize.php', '21.12', 0),
('5f3c66d245886d9e7c70c7ca95b0ee1f', './lib/smarty_tiki/modifier.breakline.php', '21.12', 0),
('d7b12e03096856ba14f9132cd83da764', './lib/smarty_tiki/modifier.categid.php', '21.12', 0),
('c35fba2ef0c7c144578cf4ae70f20d4a', './lib/smarty_tiki/modifier.compactisodate.php', '21.12', 0),
('81e16dc7db16c035dc7f0e9b5ee21296', './lib/smarty_tiki/modifier.countryflag.php', '21.12', 0),
('66e35cd0c30236fdab674d6c5b857429', './lib/smarty_tiki/modifier.dbg.php', '21.12', 0),
('24a2e1c949d59480fbd4f18b920f508f', './lib/smarty_tiki/modifier.div.php', '21.12', 0),
('d3869d7f879b84448022d4ea5a57b060', './lib/smarty_tiki/modifier.duration.php', '21.12', 0),
('435cd196307b18949d7855b0dc47a6eb', './lib/smarty_tiki/modifier.duration_short.php', '21.12', 0),
('10965d432307382617667462528bf783', './lib/smarty_tiki/modifier.escape.php', '21.12', 0),
('c10cd236d96b73338f92e448eb8a07c9', './lib/smarty_tiki/modifier.file_can_convert_to_pdf.php', '21.12', 0),
('b6510655b2ae43b125fdff96af71bb3e', './lib/smarty_tiki/modifier.file_diagram.php', '21.12', 0),
('af49190a6e3fdefaa05c6734822fc8af', './lib/smarty_tiki/modifier.forumname.php', '21.12', 0),
('5019390973f753d6d5deafdf6db48f66', './lib/smarty_tiki/modifier.forumtopiccount.php', '21.12', 0),
('7036fd56fc07bfc5dd9f27cbad1918cb', './lib/smarty_tiki/modifier.groupmembercount.php', '21.12', 0),
('db687a24c8593288f268add4fe6747c2', './lib/smarty_tiki/modifier.how_many_user_inscriptions.php', '21.12', 0),
('d6e7f374fbddcec05e82cde3c959d6e5', './lib/smarty_tiki/modifier.htmldecode.php', '21.12', 0),
('f2de98c7c6509af7a97bc065d667529b', './lib/smarty_tiki/modifier.iconify.php', '21.12', 0),
('8914ed502726b6308b1dc124731cfa23', './lib/smarty_tiki/modifier.in_group.php', '21.12', 0),
('a7f8c81e8d1e35cb83828b4aa1a9c0df', './lib/smarty_tiki/modifier.isodate.php', '21.12', 0),
('424594646d9d0ff9e497bb12748b01dc', './lib/smarty_tiki/modifier.kbsize.php', '21.12', 0),
('0e7651282356072fc2efa9268cf5db63', './lib/smarty_tiki/modifier.langname.php', '21.12', 0),
('8fad0b656d5b6ddb5d60ea944b393f7c', './lib/smarty_tiki/modifier.lcfirst.php', '21.12', 0),
('80c14c12a7af50b5300e6b6f519a81d7', './lib/smarty_tiki/modifier.max_user_inscriptions.php', '21.12', 0),
('e91581e8a366b3f1f98438ceb4aca987', './lib/smarty_tiki/modifier.money_format.php', '21.12', 0),
('8ef5b460b2fe528aba1db63d9d92d99b', './lib/smarty_tiki/modifier.namespace.php', '21.12', 0),
('55d49e9e85826c0a62fa2b11fe147c62', './lib/smarty_tiki/modifier.nonamespace.php', '21.12', 0),
('08c4356a158216b300b388ef1609ade7', './lib/smarty_tiki/modifier.nonp.php', '21.12', 0),
('309b7452ec4fb469e4811a81a8085769', './lib/smarty_tiki/modifier.number_format.php', '21.12', 0),
('892c948c42aa228232c46f580d75c4e8', './lib/smarty_tiki/modifier.numstyle.php', '21.12', 0),
('80642821dd6af696a942d36734c6652d', './lib/smarty_tiki/modifier.output.php', '21.12', 0),
('081fd3b4120eb5bf112b2cf234893f16', './lib/smarty_tiki/modifier.packageitemid.php', '21.12', 0),
('8509457c6ef2e650e395e5087fd04967', './lib/smarty_tiki/modifier.pagename.php', '21.12', 0),
('ca144602d36ea5a5ad5e321590c818ff', './lib/smarty_tiki/modifier.parse.php', '21.12', 0),
('5cd6f5fceea10ab0b31835bed1c4fb98', './lib/smarty_tiki/modifier.percent.php', '21.12', 0),
('d3c583290d8b31d3a943f7eb01b7a57d', './lib/smarty_tiki/modifier.quoted.php', '21.12', 0),
('78cc8a38f1c9c0c47eb1cc678012b16f', './lib/smarty_tiki/modifier.replacei.php', '21.12', 0),
('55e36d356b8eb486102c766252123186', './lib/smarty_tiki/modifier.reverse_array.php', '21.12', 0),
('ed237da18b932b0849ef673948c1f0f9', './lib/smarty_tiki/modifier.sefurl.php', '21.12', 0),
('d3e5a8ad1675056af714ab0781a42583', './lib/smarty_tiki/modifier.slug.php', '21.12', 0),
('983a48f5088ce6dae161ca62939026e8', './lib/smarty_tiki/modifier.star.php', '21.12', 0),
('834527707e267dda5b6ce21ca21022ce', './lib/smarty_tiki/modifier.stringfix.php', '21.12', 0),
('dd0381f33a1540450032640db771bb22', './lib/smarty_tiki/modifier.substring.php', '21.12', 0),
('5c8fc986007c81090b9d6dd8b1131872', './lib/smarty_tiki/modifier.tasklink.php', '21.12', 0),
('b00872b48c417d34729d0c750f78e620', './lib/smarty_tiki/modifier.template.php', '21.12', 0),
('1d27a7bd0795437284d8aef3e7d7a166', './lib/smarty_tiki/modifier.ternary.php', '21.12', 0),
('1705150ac618e7935600f98d7bcc63d6', './lib/smarty_tiki/modifier.tiki_date_format.php', '21.12', 0),
('cbb0381a35d8bfcca11698a2d90e1cac', './lib/smarty_tiki/modifier.tiki_long_date.php', '21.12', 0),
('e419e8430d561af647d0137f719ec646', './lib/smarty_tiki/modifier.tiki_long_datetime.php', '21.12', 0),
('4f342fae77a2fcc40bf8b2b4010eb3e8', './lib/smarty_tiki/modifier.tiki_long_time.php', '21.12', 0),
('d84b28010cd2cf262b9067c06849b803', './lib/smarty_tiki/modifier.tiki_remaining_days_from_now.php', '21.12', 0),
('587fcc2633d71e378984e87c2dece6c6', './lib/smarty_tiki/modifier.tiki_short_date.php', '21.12', 0),
('af44efee4be7e18e148cf8c9489c7c28', './lib/smarty_tiki/modifier.tiki_short_datetime.php', '21.12', 0),
('49f2c61eea8699574bef1d2fe161114e', './lib/smarty_tiki/modifier.tiki_short_time.php', '21.12', 0),
('ad63215f21d1c54580108d7358298aa1', './lib/smarty_tiki/modifier.times.php', '21.12', 0),
('136d34edd0a95dd4b1232585b1567bb7', './lib/smarty_tiki/modifier.tr_if.php', '21.12', 0),
('abbc36d80f3398d02540e6b64274e3a1', './lib/smarty_tiki/modifier.truex.php', '21.12', 0),
('9fa3fdcade695178aee058f42edf970b', './lib/smarty_tiki/modifier.truncate.php', '21.12', 0),
('83f0bf57e3bc428a40dda12bfb62dcf5', './lib/smarty_tiki/modifier.userlink.php', '21.12', 0),
('f3c18ed77144be14ad2f8090a7db11f3', './lib/smarty_tiki/modifier.username.php', '21.12', 0),
('a11dc052ec7c75423dbb5ffd409ef8cb', './lib/smarty_tiki/modifier.utf8unicode.php', '21.12', 0),
('864a086e7b53d461f4c1c7f4663ad7c5', './lib/smarty_tiki/modifier.virtual_path.php', '21.12', 0),
('751c57a49dad7597087c49391b54321f', './lib/smarty_tiki/modifier.yesno.php', '21.12', 0),
('8d001ea048cdd52d79e270aa3c861b87', './lib/smarty_tiki/outputfilter.highlight.php', '21.12', 0),
('94455da25d48f79d8544edd4c1b49531', './lib/smarty_tiki/outputfilter.ticket.php', '21.12', 0),
('2a11026620b74603a500e3bc9010fb0d', './lib/smarty_tiki/prefilter.jq.php', '21.12', 0),
('472f23f197efaccb437621512c321496', './lib/smarty_tiki/prefilter.log_tpl.php', '21.12', 0),
('155d6a2ce14b4b7f69d690f5ba943ff6', './lib/smarty_tiki/prefilter.tr.php', '21.12', 0),
('c3f576352bc878c88bc1dd047ed8fc28', './lib/smarty_tiki/resource.tplwiki.php', '21.12', 0),
('f74adb2f942e2aded97e9b75d2911244', './lib/smarty_tiki/resource.wiki.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/soap/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/soap/nusoap/index.php', '21.12', 0),
('fe94a13a99f3c2c37f10c39a80cdc292', './lib/soap/nusoap/nusoap.php', '21.12', 0),
('89da5e3f763859b681c23952769fad86', './lib/soap/soaplib.php', '21.12', 0),
('cf48ac42d1f76cbeb5f813e9df33af42', './lib/soap/tiki-admin_webservices.js', '21.12', 0),
('a1864fe309f33fceade6aa6bbc6f215e', './lib/soap/wsdllib.php', '21.12', 0),
('c7a24bfa982b7d9c959fcf73b9b70445', './lib/socialnetworkslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/stats/index.php', '21.12', 0),
('69a9194089b89f10b3ec9491329de863', './lib/stats/statslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/structures/index.php', '21.12', 0),
('2b3ba308ff11c05e84369d33da0618a2', './lib/structures/structlib.php', '21.12', 0),
('129e88916bbbd7dbcd96d58fe796a878', './lib/structures/tiki-edit_structure.js', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/surveys/index.php', '21.12', 0),
('66d577b5206a9fb53d7ef72d72e3b456', './lib/surveys/surveylib.php', '21.12', 0),
('b7772f9654890f1d626c9150eae9ae6b', './lib/surveys/tiki-admin_survey_questions.js', '21.12', 0),
('4e29314fb1f038a7ab3323d3bffd57ee', './lib/svg-edit_tiki/draw.js', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/svg-edit_tiki/index.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/swfobject/index.php', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/swfobject/src/index.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/taglines/index.php', '21.12', 0),
('6bca8864fe49da9ee8a87f4df2b44d9e', './lib/taglines/taglinelib.php', '21.12', 0),
('78ea176d27b185bb21d41097bf269e24', './lib/tail/index.php', '21.12', 0),
('2ca85d224760d19c715bce2da43caa65', './lib/tar.class.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/tasks/index.php', '21.12', 0),
('10f7e3b4677624ac9313e8409eed6d4b', './lib/tasks/tasklib.php', '21.12', 0),
('ff8d50a3f84032da9fe5740e7be3319a', './lib/templates/index.php', '21.12', 0),
('621e7a00ea4aae74db3705f8d8f3e94f', './lib/templates/templateslib.php', '21.12', 0),
('60f20292fdf7b91baaa5d69b11046c0f', './lib/test/AcceptanceTests/AllTests.php', '21.12', 0),
('e408b3f665e34b970e88cb72668bb19d', './lib/test/AcceptanceTests/CollaborativeMultilingualTerminologyTest.php', '21.12', 0),
('c4f9e6ad2c257da6988666e611d0b2b4', './lib/test/AcceptanceTests/ListPagesTest.php', '21.12', 0),
('6b6cb9237b586ea84c6cfcca3809da80', './lib/test/AcceptanceTests/MultilingualTest.php', '21.12', 0),
('e14daf27d991a9ee66ddb96b96472092', './lib/test/AcceptanceTests/MultilinguallibTest.php', '21.12', 0),
('cb497aa0c1f6b99c30f0d3d2dcc7c7a6', './lib/test/AcceptanceTests/SearchTest.php', '21.12', 0),
('536d2cc03448237ed46c36901df338b3', './lib/test/AcceptanceTests/TikiLibrariesAccessTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/AcceptanceTests/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/AcceptanceTests/utils/index.php', '21.12', 0),
('66bc9eb8c91b2bf3d91082c18049a4c0', './lib/test/AcceptanceTests/utils/upgrade_test_database_dump_file.php', '21.12', 0),
('cee766b47659cf6bad537d6fd4494689', './lib/test/AllTestsAcceptance.php', '21.12', 0),
('96b1a2ee2024a30d6c54b57e966bd5cc', './lib/test/Calendar/DateTest.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/Calendar/index.php', '21.12', 0),
('97bb37281e1b5475b8274c64f7767d71', './lib/test/ContinuousIntegationTesting.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/IntegrationTests/index.php', '21.12', 0),
('7d801c8bf0fe90847d6cf7bcf091512e', './lib/test/MultilingualLibTest.php', '21.12', 0),
('9b93607c771e5ed28e5aae8a5580e85f', './lib/test/TestHelpers.php', '21.12', 0),
('d61aea190de26a01693f4342004a4dd2', './lib/test/TestHelpers/TikiDbHelper.php', '21.12', 0),
('b98b699742924e542a4b5cc2e52be5b1', './lib/test/TestHelpers/TikiProfileHelper.php', '21.12', 0),
('771b882299a2fd98f622cf9eaa1b539d', './lib/test/TestHelpers/WebClientHelper.php', '21.12', 0),
('5e48dbf78dfdfff0a79f6065d848f719', './lib/test/TestHelpers/cli/create_dump_db_file.php', '21.12', 0),
('f44898059294c219db2dfecc2a72b294', './lib/test/TestHelpers/cli/restore_db_dump.php', '21.12', 0),
('01803a618d0b7a07d4e201d3105fb9ec', './lib/test/TestRunnerWithBaseline.php', '21.12', 0),
('f98db00c693823471c934cb71e76c38f', './lib/test/TestRunnerWithBaselineTest.php', '21.12', 0),
('21542073b91cf43a05dbe32b54f8e547', './lib/test/TestableTikiLib.php', '21.12', 0),
('bbe4e9d8ec2e85b5f1ab2444c3a34422', './lib/test/TikiAcceptanceTestDBRestorer.php', '21.12', 0),
('9674d693683a5f0f2a0aaf0ec7687f0c', './lib/test/TikiDatabaseTestCase.php', '21.12', 0),
('3a8ed35bea6b9b83f46d5cd0f610ab29', './lib/test/TikiLib/LibTest.php', '21.12', 0),
('44e3cab21515d5af706af8b865518256', './lib/test/TikiLib/MultiExplodeTest.php', '21.12', 0),
('3802f32788eaad659ea40d687f23dab3', './lib/test/TikiLib/TestableTikiLibTest.php', '21.12', 0),
('84275773a98a18b1b623c1f72dc3f9b5', './lib/test/TikiLib/TikiLibTest.php', '21.12', 0),
('a3a17c3ed0f514c5aaf58e34ed006076', './lib/test/TikiLib/UriMergeTest.php', '21.12', 0),
('bb91c762c210edfb9c08bfc964af0561', './lib/test/TikiLib/UrlEncodeAccentTest.php', '21.12', 0),
('ef8cdd6946f0aa2768190ce0b4542da1', './lib/test/TikiLib/UserLibTest.php', '21.12', 0),
('f9073b2c9089dfa04d40fe464eb4eb90', './lib/test/TikiLib/UserWatchesTest.php', '21.12', 0),
('80eb75ca1793808b6d66a3f6e2b8f883', './lib/test/TikiLib/WikiParserTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/TikiLib/index.php', '21.12', 0),
('644c2a766d0c412537b42561bded7822', './lib/test/TikiSeleniumTestCase.php', '21.12', 0),
('1d1ede8a52b686aa2a5ee9bea38eba07', './lib/test/TikiTestCase.php', '21.12', 0),
('96feb5a910cc8d1fa14c775decfd6882', './lib/test/TikiVersionTest.php', '21.12', 0),
('88ced7c3d085907be74b7563253c1f0d', './lib/test/attributes/AttributeTest.php', '21.12', 0),
('00241a5ebf338800ced70a37059d8c88', './lib/test/attributes/RelationTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/attributes/index.php', '21.12', 0),
('2a3378c0a79598e4d343cdb2f317cd23', './lib/test/auth/AuthTokensTest.php', '21.12', 0),
('c1d73820297680a05e383b06e6871aa9', './lib/test/auth/MembershipTest.php', '21.12', 0),
('46444ebfe4db183dcf03d05123104096', './lib/test/auth/PasswordTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/auth/fixtures/index.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/auth/index.php', '21.12', 0),
('7672bafff98d7d13214cf273552d6dbf', './lib/test/bigbluebutton/DynamicConfigurationTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/bigbluebutton/index.php', '21.12', 0),
('12e29fd95649d4cd5ffb77bf34c42149', './lib/test/bootstrap.php', '21.12', 0),
('90eed7ba1b1cd6594e16a6d93ffb62c9', './lib/test/comments/CommentsTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/comments/index.php', '21.12', 0),
('e5d2aebf93149db92a7f736ec4084bf7', './lib/test/core/Category/ManipulatorTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Category/index.php', '21.12', 0),
('7191814bab67d3a2146e3b0027f5390f', './lib/test/core/Connect/ClientTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Connect/index.php', '21.12', 0),
('4507de6b879f33d850a1a0eeb05f0efa', './lib/test/core/CustomRoute/ControllerTest.php', '21.12', 0),
('ee402d9d2f9ab408e32160c89bfe7214', './lib/test/core/CustomRoute/CustomRouteTest.php', '21.12', 0),
('0dbe482b360f9fb1d1561beca4a914ff', './lib/test/core/CustomRoute/ItemTest.php', '21.12', 0),
('eb93d0177a9fc5aa087f2c2bda380bc8', './lib/test/core/DeclFilter/BaseTest.php', '21.12', 0),
('bd478c4ade943948a96d38e616a34fa7', './lib/test/core/DeclFilter/CatchAllFilterTest.php', '21.12', 0),
('f9fdfab411c4fdc51c4fa932e3ffc76f', './lib/test/core/DeclFilter/CatchAllUnsetTest.php', '21.12', 0),
('37b53bd1e8fcd770e068c4de71ec7041', './lib/test/core/DeclFilter/ConfigureTest.php', '21.12', 0),
('fb588ee33882885e7cc563c033edb81b', './lib/test/core/DeclFilter/KeyPatternFilterTest.php', '21.12', 0),
('bf86a67ac90cf32b33eb60fd5dea3591', './lib/test/core/DeclFilter/KeyPatternUnsetTest.php', '21.12', 0),
('248ab1b7b346781226785534ab26b9e3', './lib/test/core/DeclFilter/StaticKeyFilterTest.php', '21.12', 0),
('2b0564f8c459c52790aa26925629da09', './lib/test/core/DeclFilter/StaticKeyUnsetTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/DeclFilter/index.php', '21.12', 0),
('6eba0f2569eeb661c3c4d29cd4dd9be8', './lib/test/core/Event/CustomizerTest.php', '21.12', 0),
('3d6edd8432ee94a00dae4cfac8c3d556', './lib/test/core/Event/ManagerTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Event/index.php', '21.12', 0),
('a4265dd61db12664a5be4a18c15d7f75', './lib/test/core/File/FileHelperTest.php', '21.12', 0),
('aae4011d765d48779a5f0bd2115c8f25', './lib/test/core/Files/CheckAttachmentGalleryTest.php', '21.12', 0),
('17f2c02f94668d3b24a3924d2907c1c7', './lib/test/core/Files/CheckFileGalleryTest.php', '21.12', 0),
('5ffeba376ed92b7a62e5498416eb6cdb', './lib/test/core/Files/CheckImageGalleryTest.php', '21.12', 0),
('e2f7784b19990c3103d72172b0874692', './lib/test/core/JitFilter/AccessTest.php', '21.12', 0),
('3111d00f008dfd3bc605e7db6666507d', './lib/test/core/JitFilter/FilterTest.php', '21.12', 0),
('7fa07e5b2ef678cf188411338d49e686', './lib/test/core/JitFilter/IteratorTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/JitFilter/index.php', '21.12', 0),
('c4b4b674d0e44c213d155ec77e4d5f15', './lib/test/core/Math/Formula/CurrencyTest.php', '21.12', 0),
('2affab41c656ec192ae341c4a1431b07', './lib/test/core/Math/Formula/DummyFunction/FortyTwo.php', '21.12', 0),
('54e9c00e242de9091716c9be442d4752', './lib/test/core/Math/Formula/DummyFunction/Testop.php', '21.12', 0),
('16b533ccc02d969f27b2c7a3461764e3', './lib/test/core/Math/Formula/DummyFunction/index.php', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('26b40bbf4847de568c6db99d91f86f0a', './lib/test/core/Math/Formula/ElementTest.php', '21.12', 0),
('6e5fb429775c9286d1c56680f4a3e099', './lib/test/core/Math/Formula/ParserTest.php', '21.12', 0),
('7906eca6082e96dd42bc1fab854b6e71', './lib/test/core/Math/Formula/RunnerTest.php', '21.12', 0),
('a3db421161b2ef0292751e85d84a73da', './lib/test/core/Math/Formula/TokenizerTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Math/Formula/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Math/index.php', '21.12', 0),
('130f68711dd92a5970fc7eb436f91038', './lib/test/core/Multilingual/Aligner/BilingualAlignerTest.php', '21.12', 0),
('842022c0c44a5a4a049c3082b4c0a030', './lib/test/core/Multilingual/Aligner/SentenceAlignmentsTest.php', '21.12', 0),
('b99faf8dfabfca6fb16e27d64976a298', './lib/test/core/Multilingual/Aligner/SentenceSegmentorTest.php', '21.12', 0),
('7a23d8546bc40a27e6ee5b8f967a0d9f', './lib/test/core/Multilingual/Aligner/ShortestPathFinderTest.php', '21.12', 0),
('4619041b817d26a37dfb83c7089da0e6', './lib/test/core/Multilingual/Aligner/UpdatePagesTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Multilingual/Aligner/index.php', '21.12', 0),
('302340c0587336de79143902b9bb360c', './lib/test/core/Multilingual/MachineTranslation/GoogleTranslateWrapperTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Multilingual/MachineTranslation/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Multilingual/index.php', '21.12', 0),
('a168cefc671436a31443be5892104207', './lib/test/core/Notifications/EmailTest.php', '21.12', 0),
('ecb4e7f051c0ecab1bf09122af2d1d5e', './lib/test/core/ObjectSelector/ObjectSelectorTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/ObjectSelector/index.php', '21.12', 0),
('1ca2c4dbaf3a6b193ab9efa53c5a5190', './lib/test/core/Perms/AccessorTest.php', '21.12', 0),
('359c66dbeef2fc0e75b4cfd62639f287', './lib/test/core/Perms/ApplierTest.php', '21.12', 0),
('e3405340bd6c82a051d14b9dca6500d9', './lib/test/core/Perms/BaseTest.php', '21.12', 0),
('a15586cd3c87327fac0b1eb5126f8fd1', './lib/test/core/Perms/BuilderTest.php', '21.12', 0),
('ef3c175b7746956fa37a8a99751b94bf', './lib/test/core/Perms/Check/AlternateTest.php', '21.12', 0),
('2078ca1a93a40f125f76f03e800313dd', './lib/test/core/Perms/Check/CreatorTest.php', '21.12', 0),
('717bf462af96bb83ee80c945e81c82f3', './lib/test/core/Perms/Check/DirectTest.php', '21.12', 0),
('f51274a58642df9e99828a1e9777ea06', './lib/test/core/Perms/Check/IndirectTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Perms/Check/index.php', '21.12', 0),
('6e7cd2128add18901e95dcdf08b37f97', './lib/test/core/Perms/CheckSequenceTest.php', '21.12', 0),
('2e1466ffa8a2d36e892754509fd04eea', './lib/test/core/Perms/MixedTest.php', '21.12', 0),
('948890c1f52f6539874a3627f7a97896', './lib/test/core/Perms/Reflection/FactoryTest.php', '21.12', 0),
('91d02b52682bf440c98be896b0936341', './lib/test/core/Perms/Reflection/PermissionComparatorTest.php', '21.12', 0),
('31c30469c9ab1639098c5e8a06a2f611', './lib/test/core/Perms/Reflection/PermissionSetTest.php', '21.12', 0),
('91e9a41b6e8fc03a8cdccad360487b4f', './lib/test/core/Perms/Reflection/QuickTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Perms/Reflection/index.php', '21.12', 0),
('2274f40301a8fe113e9c1bc48972e287', './lib/test/core/Perms/Resolver/DefaultTest.php', '21.12', 0),
('3a8f21f29a19cb360248c357db82f507', './lib/test/core/Perms/Resolver/StaticTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Perms/Resolver/index.php', '21.12', 0),
('c4dc72f98cc1d0b5b924e9762cbf55f8', './lib/test/core/Perms/ResolverFactory/CategoryFactoryTest.php', '21.12', 0),
('9f6c0b6e68c6deaa7987f94ab8dbe2c0', './lib/test/core/Perms/ResolverFactory/GlobalFactoryTest.php', '21.12', 0),
('b688ffd9d1007677f58cc682ec34dd3a', './lib/test/core/Perms/ResolverFactory/ObjectFactoryTest.php', '21.12', 0),
('1523e4ff63032e847dde6a5dad26103d', './lib/test/core/Perms/ResolverFactory/TestFactoryTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Perms/ResolverFactory/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Perms/index.php', '21.12', 0),
('2f2205d321b685377b44604b8d4b01b8', './lib/test/core/Recommendation/BatchTest.php', '21.12', 0),
('d03b7daeffc316d8e15e21ac599c4dfb', './lib/test/core/Recommendation/ComparatorTest.php', '21.12', 0),
('e52a1b4aab08b4eeb0fcdc1983a2066e', './lib/test/core/Recommendation/EngineSetTest.php', '21.12', 0),
('c8cbd64c96924cc23b9650f392696faf', './lib/test/core/Recommendation/RecommendationSetTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Recommendation/index.php', '21.12', 0),
('10beee5571cf38ae7218979c45aa0205', './lib/test/core/Reports/CacheTest.php', '21.12', 0),
('c2a8722dbd2718e9e254ad7846ba3b9a', './lib/test/core/Reports/FactoryTest.php', '21.12', 0),
('856d67e65cda9d588d2f758aaf031c30', './lib/test/core/Reports/ManagerTest.php', '21.12', 0),
('e5010a62b8fbc4c86066c572593e4609', './lib/test/core/Reports/ReportsEndToEndTest.php', '21.12', 0),
('35d44adf31c969fb870cf99cb05487e6', './lib/test/core/Reports/Send/EmailBuilderTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Reports/Send/index.php', '21.12', 0),
('31617b91cc0b15f7a19feb29d47c14b1', './lib/test/core/Reports/SendTest.php', '21.12', 0),
('f47064163c983947d42d7080ad4a7d53', './lib/test/core/Reports/UsersTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Reports/fixtures/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Reports/index.php', '21.12', 0),
('deca35f1cc6dca8b4c4c2bbb95d7d1f8', './lib/test/core/Request/RequestTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Request/index.php', '21.12', 0),
('00c52f929f3a7da1d26f0a80d422cf64', './lib/test/core/Scheduler/ItemTest.php', '21.12', 0),
('b2a4203ca408a0a1b81296b8ed58868b', './lib/test/core/Scheduler/ManagerTest.php', '21.12', 0),
('c5e6316e3838d61b0240139d8ef3893f', './lib/test/core/Search/ActionStepTest.php', '21.12', 0),
('d53e0e90802cd12b7dcba4be190b6ea0', './lib/test/core/Search/Elastic/BaseTest.php', '21.12', 0),
('1d8005174da5742ebb641c55b2536b7f', './lib/test/core/Search/Elastic/BulkIncrementalUpdateTest.php', '21.12', 0),
('6c0d457b48a8bee376d33afc939d2a35', './lib/test/core/Search/Elastic/BulkIndexingTest.php', '21.12', 0),
('46472a733f7d2910ff483888dc036cd7', './lib/test/core/Search/Elastic/CamelCaseTest.php', '21.12', 0),
('a31cc3ad2a9442039e58d12c3f1de1a5', './lib/test/core/Search/Elastic/FacetBuilderTest.php', '21.12', 0),
('52ebf74675bd3860900c6ac7573aa902', './lib/test/core/Search/Elastic/FacetReaderTest.php', '21.12', 0),
('9f6b5e9360de15c5e50d472c3be62ed2', './lib/test/core/Search/Elastic/FacetTest.php', '21.12', 0),
('a8ebfcfe4f8a27d027c5b389cdb3c019', './lib/test/core/Search/Elastic/FederatedQueryTest.php', '21.12', 0),
('61a6b3d56101d50cd7e03213017dd55e', './lib/test/core/Search/Elastic/IncrementalUpdateTest.php', '21.12', 0),
('90190cff35f7bd3700bf009ec0cee773', './lib/test/core/Search/Elastic/MoreLikeThisTest.php', '21.12', 0),
('e104e9ecbccb9968e3e5d5bb492c45c6', './lib/test/core/Search/Elastic/NumericTest.php', '21.12', 0),
('216e1bc749fa669f8acc976a5fa6f926', './lib/test/core/Search/Elastic/PaginationTest.php', '21.12', 0),
('4212daec7440fde5af6d9243d2d95215', './lib/test/core/Search/Elastic/ProtocolTest.php', '21.12', 0),
('d751a3cc35b540d59b776969cd5ca21a', './lib/test/core/Search/Elastic/QueryBuilderTest.php', '21.12', 0),
('c960dbd1c9fb378f20c2712e1bf2488e', './lib/test/core/Search/Elastic/QueryRepositoryTest.php', '21.12', 0),
('268610a4750683e880e2ff6fb739db0b', './lib/test/core/Search/Elastic/RescoreQueryBuilderTest.php', '21.12', 0),
('e73fa903bce6a055486ba1ad1416ab99', './lib/test/core/Search/Elastic/SortTest.php', '21.12', 0),
('cc1717fc89329e6d3e58e510fc69bb66', './lib/test/core/Search/Elastic/StemmingTest.php', '21.12', 0),
('1bb79ae958e321e4cacee0adf10b1d9a', './lib/test/core/Search/Elastic/TypeAnalyzerTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Search/Elastic/index.php', '21.12', 0),
('a6c088dadd7223e13f27251d57b5268a', './lib/test/core/Search/Expr/ParserTest.php', '21.12', 0),
('42ca8a1de7c200e12e8eabdcbc750a68', './lib/test/core/Search/Expr/TokenizerTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Search/Expr/index.php', '21.12', 0),
('974cc6af9f9503a2953afc5d4198241d', './lib/test/core/Search/Formatter/ArrayBuilderTest.php', '21.12', 0),
('a937c5d743e40d88f8e64d96e7a508ef', './lib/test/core/Search/Formatter/DataSourceTest.php', '21.12', 0),
('da95c863e67d28a45d1009376105a6d9', './lib/test/core/Search/Formatter/FactoryTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Search/Formatter/index.php', '21.12', 0),
('180f7707612796ef792b9b4fda1590c4', './lib/test/core/Search/FormatterTest.php', '21.12', 0),
('5c0f6d78808809318408e89c6920a7e1', './lib/test/core/Search/GlobalSource/PermissionSourceTest.php', '21.12', 0),
('aa44c9c67685fafad25597dca03ccc34', './lib/test/core/Search/GlobalSource/TitleInitialTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Search/GlobalSource/index.php', '21.12', 0),
('4075f6c64e4d7f39bdae377fd6a76602', './lib/test/core/Search/Index/BaseTest.php', '21.12', 0),
('8bbd34604b452c2b547e588a6fbe1d74', './lib/test/core/Search/Index/IncrementalUpdateTest.php', '21.12', 0),
('7d3cde6eab347cc362ba0519f96eaf19', './lib/test/core/Search/Index/NumericTest.php', '21.12', 0),
('39c9a5b357a577eacbaab84628ea94b4', './lib/test/core/Search/Index/PaginationTest.php', '21.12', 0),
('6f0ff958416e44441eccaf0e71b76776', './lib/test/core/Search/Index/SortTest.php', '21.12', 0),
('56e4263a7d2485beb1db6239d45911c7', './lib/test/core/Search/Index/StemmingTest.php', '21.12', 0),
('45853b618670e2d813c11d9ef593b288', './lib/test/core/Search/Index/TypeAnalyzerTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Search/Index/index.php', '21.12', 0),
('60703c4cadce83e889ee3ea2a7da84ba', './lib/test/core/Search/IndexerTest.php', '21.12', 0),
('e44e4591a20be128a762eaeaf16da9bc', './lib/test/core/Search/Lucene/BaseTest.php', '21.12', 0),
('68ebada262ac03c804d555459c5e9cf1', './lib/test/core/Search/Lucene/IncrementalUpdateTest.php', '21.12', 0),
('9c93b4fe36391e8b0c55c6e5b277717e', './lib/test/core/Search/Lucene/NumericTest.php', '21.12', 0),
('9648d60afb200deaaa20422f794cfed1', './lib/test/core/Search/Lucene/PaginationTest.php', '21.12', 0),
('9395f1c4ca11fffa94414af107382851', './lib/test/core/Search/Lucene/SortTest.php', '21.12', 0),
('5eb4976270b397735fbc90cb78e96c5b', './lib/test/core/Search/Lucene/StemmingTest.php', '21.12', 0),
('f26a2fd80eeb0ca5fda34bddc84bb2d3', './lib/test/core/Search/Lucene/TypeAnalyzerTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Search/Lucene/index.php', '21.12', 0),
('bb8f96f9dd4302f1ba3cd5847b216b07', './lib/test/core/Search/MySql/BaseTest.php', '21.12', 0),
('9f81aa5d69162be306b7b1e7d42ce400', './lib/test/core/Search/MySql/IncrementalUpdateTest.php', '21.12', 0),
('08d54ddc0c176d923e00a69747d9b56b', './lib/test/core/Search/MySql/LargeDatasetTest.php', '21.12', 0),
('57b971138abe4107cb1decb458471671', './lib/test/core/Search/MySql/PaginationTest.php', '21.12', 0),
('9997f16fbf642d060e86030753768944', './lib/test/core/Search/MySql/QueryBuilderTest.php', '21.12', 0),
('1e5690c0221f7119bf844d550ffca59f', './lib/test/core/Search/MySql/SortTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Search/MySql/index.php', '21.12', 0),
('7daff82b15cc0289ed13ea9d4b18c3f2', './lib/test/core/Search/Query/OrderTest.php', '21.12', 0),
('5a0ade6fe2d0f34c81e571745e555754', './lib/test/core/Search/Query/index.php', '21.12', 0),
('8dbc320d8005b726c5723ad967b50abf', './lib/test/core/Search/QueryTest.php', '21.12', 0),
('a0258291ed8b473bf749d7cc72078f55', './lib/test/core/Search/TypeAnalyzerTest.php', '21.12', 0),
('a7bf10a0b0c570206198346fdaec0655', './lib/test/core/Search/basic.tpl', '21.12', 0),
('d3d08628083ff518b77e144ddb387125', './lib/test/core/Search/embedded.tpl', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Search/index.php', '21.12', 0),
('bc3ddd82fa365989ae34360b416e95ce', './lib/test/core/Search/paginate.tpl', '21.12', 0),
('c6518dd569a885106127789d9e6ab55c', './lib/test/core/Services/Comment/ControllerTest.php', '21.12', 0),
('b06b159b4d361cc1d8a7b331bba932b5', './lib/test/core/Services/ResultLoaderTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Services/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tiki/Command/ProfileExport/Fixtures/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tiki/Command/ProfileExport/Fixtures/test/index.php', '21.12', 0),
('b37efb89f2aeffd5accd34379311d114', './lib/test/core/Tiki/Command/ProfileExport/TrackerItemTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tiki/Command/ProfileExport/index.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tiki/Command/index.php', '21.12', 0),
('61df0e976029198456c63a81d0920f71', './lib/test/core/Tiki/FileGallery/DefinitionTest.php', '21.12', 0),
('b316fc3424fa69445b13ddb30feb9525', './lib/test/core/Tiki/FileGallery/FileDraftTest.php', '21.12', 0),
('2268211cd1582ddbb3e561233c25131d', './lib/test/core/Tiki/FileGallery/FileTest.php', '21.12', 0),
('6899f7e008677e183d12daa7ba0b5f12', './lib/test/core/Tiki/FileGallery/Manipulator/ImageTransformerTest.php', '21.12', 0),
('11c0dec6ec2ad245d3e86e975335fa0a', './lib/test/core/Tiki/FileGallery/Manipulator/MetadataExtractorTest.php', '21.12', 0),
('bff2ac34a9fe78fbdf3e5ded3eae462e', './lib/test/core/Tiki/FileGallery/Manipulator/ValidatorTest.php', '21.12', 0),
('455c05f981a8dfc7169652aff374f6d4', './lib/test/core/Tiki/FileGallery/SaveHandlerTest.php', '21.12', 0),
('719f44c82c318ec5de7b3ea37f254520', './lib/test/core/Tiki/Package/ComposerCliTest.php', '21.12', 0),
('7d4142c3411255e9568acf900cbf2d5b', './lib/test/core/Tiki/Package/ComposerManagerTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tiki/Package/index.php', '21.12', 0),
('2f7402d5049935acdfba64b1ee26531e', './lib/test/core/Tiki/ProfileTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tiki/index.php', '21.12', 0),
('ad0f9162d307c15d5203ce7ba87c2198', './lib/test/core/TikiDb/SanitizeEncodingTest.php', '21.12', 0),
('226110b9d153addcf24f4976b99b48e9', './lib/test/core/TikiDb/TableTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/TikiDb/index.php', '21.12', 0),
('a33101b944f268425f737b949220c49e', './lib/test/core/TikiFilter/CallbackTest.php', '21.12', 0),
('26118d185dca33f1b17fdd5b5c426e9d', './lib/test/core/TikiFilter/MapTest.php', '21.12', 0),
('8e91f9bdd2ca1948a26f1248cf041b03', './lib/test/core/TikiFilter/PrepareInputTest.php', '21.12', 0),
('defefe123eb931b68d22e0b28c2c93b0', './lib/test/core/TikiFilter/WordTest.php', '21.12', 0),
('1ded2132d2f8329d3990bfb9d4471cdd', './lib/test/core/TikiFilter/XssTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/TikiFilter/index.php', '21.12', 0),
('f9060589c94450b6557787a84008f4fb', './lib/test/core/TikiSecurityTest.php', '21.12', 0),
('8fe651929b0d770f6a16a53e9262236d', './lib/test/core/Tracker/OptionsTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Tracker/index.php', '21.12', 0),
('44b3060019151dc9c5955112893373ba', './lib/test/core/Transition/AtLeastTest.php', '21.12', 0),
('102029942866134506501c5e27d63ced', './lib/test/core/Transition/AtMostTest.php', '21.12', 0),
('fe415d69692a487ff538a2153cd55aba', './lib/test/core/Transition/BasicTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/core/Transition/index.php', '21.12', 0),
('25df5c525bdc60899138be0a41d79066', './lib/test/core/Wiki/SlugManagerTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Wiki/index.php', '21.12', 0),
('49ba38d8928315ae1784e65103b1e711', './lib/test/core/WikiParser/OutputLinkTest.php', '21.12', 0),
('692655edc52fc17529296b21f5591c6b', './lib/test/core/WikiParser/PluginArgumentParserTest.php', '21.12', 0),
('e9eba0f2ddf90ed9c80f9d00c07c104d', './lib/test/core/WikiParser/PluginMatcherTest.php', '21.12', 0),
('3227e180ec29145b386357abfedef0e2', './lib/test/core/WikiParser/PluginOutputTest.php', '21.12', 0),
('110b903e50fa2ed3a64b048882661f6b', './lib/test/core/WikiParser/PluginParserTest.php', '21.12', 0),
('8bc73f67e0d09263c03021559fed67a1', './lib/test/core/WikiParser/PluginRepositoryTest.php', '21.12', 0),
('21455e0529636a325b0eba222b32578e', './lib/test/core/WikiParser/StressTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/core/WikiParser/index.php', '21.12', 0),
('75e704468645b68c0b010f635f1544bc', './lib/test/core/WikiParser/wikiplugin_foo.php', '21.12', 0),
('2502f4881ed2f4d00f435679e624dd53', './lib/test/core/Workspace/AnalyserTest.php', '21.12', 0),
('2dd3c411786c155c0a9ea80c06de1907', './lib/test/core/Workspace/BuilderTest.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/test/core/Workspace/index.php', '21.12', 0),
('1b29c9656696fc52280bb59fd99b35c4', './lib/test/core/Yaml/DirectivesTest.php', '21.12', 0),
('7cb088e36c0d56d056fc6c5d481e55a0', './lib/test/core/bootstrap.php', '21.12', 0),
('a0f61bceeb7110a73dbb45532c064723', './lib/test/core/include_non_autoload_compatible_classes.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/core/index.php', '21.12', 0),
('69585f702336477a9e4e1d5efdd86afb', './lib/test/core/temp/cache/index.php', '21.12', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/test/core/temp/index.php', '21.12', 0),
('12317d005f6df69b28b0a24133ab5339', './lib/test/diff/DiffTest.php', '21.12', 0),
('1c1365cabb8d478dc75957381604c717', './lib/test/diff/fixtures/index.php', '21.12', 0),
('413b3d7f3ffdd724e667d93c925a2622', './lib/test/diff/fixtures/unidiff.php', '21.12', 0),
('79b0483d898053219a49b6663440b0e5', './lib/test/diff/index.php', '21.12', 0),
('e79b1b31c6b4faf0a567d2afda74c6ee', './lib/test/editlib/EditLibTest.php', '21.12', 0),
('ad6d835804326b7f35be9d496201c766', './lib/test/editlib/ParseToWiki_CharacterTest.php', '21.12', 0),
('fa8f4f21f411eb659f9402cbd58274c7', './lib/test/editlib/ParseToWiki_LinkTest.php', '21.12', 0),
('40dcc65b8fefc2ec89038da08bc4fdb5', './lib/test/editlib/ParseToWiki_ListTest.php', '21.12', 0),
('c75748d3d044816b23315107eeff8f54', './lib/test/editlib/ParseToWiki_TextTest.php', '21.12', 0),
('b9fe57acc31ec30393877d8761baf488', './lib/test/editlib/ParseToWysiwyg_CharacterTest.php', '21.12', 0),
('1d0490c521670eb3e6694f105a3fa8bc', './lib/test/editlib/ParseToWysiwyg_LinkTest.php', '21.12', 0),
('58c6e9ad6247cc52801234f64aaecc4b', './lib/test/editlib/ParseToWysiwyg_ListTest.php', '21.12', 0),
('97d8498b57fe7ea95e6abf65c112368e', './lib/test/editlib/ParseToWysiwyg_TextTest.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/editlib/index.php', '21.12', 0),
('9bc54437c27f363c42781e300f944872', './lib/test/filegals/FilegalsTest.php', '21.12', 0),
('89eba75058970ab4ac9b659ee61cf30d', './lib/test/freetag/FreetagTest.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/freetag/index.php', '21.12', 0),
('b3f65c5f150fac25c7d55d4252d09a06', './lib/test/importer/TikiImporterBlogTest.php', '21.12', 0),
('4194d76a548a841dc7bc528ccf4812cd', './lib/test/importer/TikiImporterBlogWordpressTest.php', '21.12', 0),
('e939c31aa35ec585cb2365a38bbac0e8', './lib/test/importer/TikiImporterTest.php', '21.12', 0),
('390717b0b41f8135cf9703dc367b7546', './lib/test/importer/TikiImporterWikiMediawikiTest.php', '21.12', 0),
('a7269d84dc72f36e066f1cd4ac3bc067', './lib/test/importer/TikiImporterWikiTest.php', '21.12', 0),
('1c1365cabb8d478dc75957381604c717', './lib/test/importer/fixtures/index.php', '21.12', 0),
('8b261ffa9cc80144fd5124f785baa64e', './lib/test/importer/fixtures/mediawiki_page_as_array.php', '21.12', 0),
('79b0483d898053219a49b6663440b0e5', './lib/test/importer/index.php', '21.12', 0),
('41f33f62fa49032ce4d2172a2ce77e31', './lib/test/importer/tikiimporter_testcase.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/index.php', '21.12', 0),
('fb753c2665f69f0ad709db6ba3711cd7', './lib/test/language/CollectFilesTest.php', '21.12', 0),
('e85b5f92ea271c229c7be0b5bfd4c320', './lib/test/language/FileType/PhpTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/language/FileType/index.php', '21.12', 0),
('e976acfe9bd09673534aa434b0510320', './lib/test/language/GetStringsEndToEndTest.php', '21.12', 0),
('4beff7f9dccc73603332babeb3ee369f', './lib/test/language/GetStringsTest.php', '21.12', 0),
('2e52634e9521ea8226a5168684a4dd24', './lib/test/language/LanguageTest.php', '21.12', 0),
('ec86b0aca13744df7837f870214db88f', './lib/test/language/LanguageTranslationsTest.php', '21.12', 0),
('f3c738123fc529cf0519ce909091c85c', './lib/test/language/MergeFilesTest.php', '21.12', 0),
('ad1d398d3e67819f6878b9f7b73d7803', './lib/test/language/ParseFileTest.php', '21.12', 0),
('d125a0f0b7d4c15746be86124c5c51f1', './lib/test/language/WriteFile/FactoryTest.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './lib/test/language/WriteFile/index.php', '21.12', 0),
('37b3899d0f4a03c1fd0dae1fad36e2cd', './lib/test/language/WriteFileTest.php', '21.12', 0),
('245e57aa9b2304be17b2f31785eb7dc3', './lib/test/language/fixtures/custom.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/language/fixtures/index.php', '21.12', 0),
('ec45070aabeeaa91912e988899450e4d', './lib/test/language/fixtures/language_end_to_end_test_modified.php', '21.12', 0),
('c554b72f129aa0069d20dafe0a998500', './lib/test/language/fixtures/language_end_to_end_test_original.php', '21.12', 0),
('3a06659ae53a502aee2499e5471eed16', './lib/test/language/fixtures/language_escape_special_characters.php', '21.12', 0),
('f68d6c96e3669772881271568bbd29af', './lib/test/language/fixtures/language_fa_modified.php', '21.12', 0),
('2ff8e074bb2865c0a82d1aab45fd3783', './lib/test/language/fixtures/language_fa_original.php', '21.12', 0),
('0feb83fd9d48613015688e40692dc770', './lib/test/language/fixtures/language_invalid.php', '21.12', 0),
('f464f6784a269022cc5ca404476d6a11', './lib/test/language/fixtures/language_merge_files_original.php', '21.12', 0),
('c856093fb6e2be46974a7decc118fa6a', './lib/test/language/fixtures/language_merge_files_result.php', '21.12', 0),
('081cc4a8d22ee5e9ebbee07766827144', './lib/test/language/fixtures/language_modif.php', '21.12', 0),
('ef72e4e828e1980c29a90a84af90f2df', './lib/test/language/fixtures/language_orig.php', '21.12', 0),
('2410c0080d813ba1db09f1626fa01165', './lib/test/language/fixtures/language_punctuations.php', '21.12', 0),
('7bae0df2dc0002607034b390e5a63ed7', './lib/test/language/fixtures/language_ru_modified.php', '21.12', 0),
('5d6fd4835f01daf9137d2d230016b465', './lib/test/language/fixtures/language_ru_original.php', '21.12', 0),
('ae12b74389f0674a07695127449f71de', './lib/test/language/fixtures/language_simple.php', '21.12', 0),
('171ab1c8654a0ce742d1a6c193561d4a', './lib/test/language/fixtures/language_to_parse_file.php', '21.12', 0),
('2cc61cf116c49b62deac82ebb80f70e2', './lib/test/language/fixtures/language_untranslated.php', '21.12', 0),
('bf8f117c3d7aaa52b33313f10d713116', './lib/test/language/fixtures/language_with_translations.php', '21.12', 0),
('435dcafd20fc85749a7241a2f6956a61', './lib/test/language/fixtures/language_with_translations_and_file_paths.php', '21.12', 0),
('71713743cd942d7097eb2380518d732a', './lib/test/language/fixtures/language_writestringstofile_first_call.php', '21.12', 0),
('f08c31284f134b68e67705c1ce296cce', './lib/test/language/fixtures/language_writestringstofile_second_call.php', '21.12', 0),
('d08c076c67c4ef50d954c53820fe3a8f', './lib/test/language/fixtures/test_collecting_strings.php', '21.12', 0),
('4337b1f5e4802d2aa8fa676cab5778ac', './lib/test/language/fixtures/test_collecting_strings.tpl', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/language/index.php', '21.12', 0),
('ae3084938b3981d20a830a319e85fc00', './lib/test/lib/AbsoluteToRelativeLinkTest.php', '21.12', 0),
('e744a4ddd6c2bbbed6c538b85eccab3b', './lib/test/lib/Perspective/AreasMultiDomainBasicTest.php', '21.12', 0),
('75592d4cbcf04d510bc1d724437ef4f6', './lib/test/lib/Perspective/PerspectivesNavigationBaseTestCase.php', '21.12', 0),
('208bd783b46a08867e6055193de4d008', './lib/test/lib/Perspective/PerspectivesTest.php', '21.12', 0),
('276afbd4698823da79bb8a4c88a5b8d7', './lib/test/lib/accounting/AccountingLibTest.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/lib/accounting/index.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/lib/index.php', '21.12', 0),
('04f3268c67446c4f5dffb0914df0f11a', './lib/test/notifications/NotificationEmailLibTest.php', '21.12', 0),
('39fdb9ba9222715b19a7cb9272dc4252', './lib/test/payment/CartTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/payment/index.php', '21.12', 0),
('56252a4d4a39538105e00bff4731b110', './lib/test/phpunit.php', '21.12', 0),
('40c2b6e2c4e9cdf3b8ece1c8f0f9f81c', './lib/test/phpunit_with_baseline.php', '21.12', 0),
('0c6d0e8f7601704a39c6fe14f60aa5ad', './lib/test/rating/AggregationTest.php', '21.12', 0),
('c3327c7ffdfda594231937f9d15a8065', './lib/test/rating/RegisterVoteTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/rating/index.php', '21.12', 0),
('83edb2fbeae264e58f25485db7d27fd3', './lib/test/shipping/ShippingTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/shipping/index.php', '21.12', 0),
('e2a2262461cef7853234410aa16f3a58', './lib/test/smarty_tiki/ModifierDurationTest.php', '21.12', 0),
('415aa6f8abcd623cb4bef32c7cb8c750', './lib/test/smarty_tiki/index.php', '21.12', 0),
('d16dac67858154af42ce463b01cd3943', './lib/test/wiki-plugins/CodeTest.php', '21.12', 0),
('b02938dbf965ae70ad13c696327391ea', './lib/test/wiki-plugins/TranslationOfTest.php', '21.12', 0),
('59950769b56afc4f706e69134176ff7d', './lib/test/wiki-plugins/YoutubeTest.php', '21.12', 0),
('4b610e717a5e998bc642a3db66f65281', './lib/test/wiki-plugins/index.php', '21.12', 0),
('54a754cc507285e95f7a814a135a2413', './lib/test/wiki/WikiLibTest.php', '21.12', 0),
('84867a724549ccc8e15821f200be1420', './lib/theme/iconsetlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/theme/index.php', '21.12', 0),
('1b023e810b116cb6541414bb60f3b50c', './lib/theme/themecontrollib.php', '21.12', 0),
('7dacbe6ec2d265553ec1fe40210142ca', './lib/theme/themelib.php', '21.12', 0),
('6556f8cd87ea97383e99b5701c42d153', './lib/tiki-dynamic-js.php', '21.12', 0),
('401621db93f9f8db3412a1cf928b14e6', './lib/tiki-js.js', '21.12', 0),
('bb98d7b86c0b2771ee236983e95626a4', './lib/tikiaccesslib.php', '21.12', 0),
('c0deec6257e76685d76f98fa139b8ce4', './lib/tikidate.php', '21.12', 0),
('67a8a1562e6634841848c91b6a6b7067', './lib/tikihelp/css/index.php', '21.12', 0),
('af025548322a0f5d058fec14351d62aa', './lib/tikihelp/css/menu.css', '21.12', 0),
('aa2ff0c00b57e7ece68ac9de6f21bbb4', './lib/tikihelp/css/toolbar.css', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/tikihelp/index.php', '21.12', 0),
('96ed9bd0969f3f89e2c76be975f7c6ab', './lib/tikihelp/js/global.js', '21.12', 0),
('a847a1df13971d9bde8214a27dcf578b', './lib/tikihelp/js/highlight.js', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/tikihelp/js/index.php', '21.12', 0),
('286cd63e0a5b497d54d275bba06c698a', './lib/tikihelp/js/toolbar.js', '21.12', 0),
('41e0966449117c4e961c8523d5bd24d1', './lib/tikihelp/menu/ftiens4.js', '21.12', 0),
('14cec197155381dda9c139e6008095ff', './lib/tikihelp/menu/index.php', '21.12', 0),
('3a58a2fe95f389c6b620dbf8357bb3f5', './lib/tikihelp/menu/menuNodes.js', '21.12', 0),
('11eb5f2d2ffdbc019cc4e7ec0e818e18', './lib/tikihelp/menu/ua.js', '21.12', 0),
('7140262b5558b6e257a3c1ee9f28bc4e', './lib/tikihelplib.php', '21.12', 0),
('6eb0f19dcfc9729ca8cc073064702f86', './lib/tikilib.php', '21.12', 0),
('1b1cbdcccb174869ef26c65d7cb80f19', './lib/tikisession-adodb.php', '21.12', 0),
('319154e0d56034c1e2061390548c2a1d', './lib/tikisession-memcache.php', '21.12', 0),
('06065e3a4f40ab61518d152627cdd6bb', './lib/tikisession-pdo.php', '21.12', 0),
('54e174eb95246ba8172bea0e99310776', './lib/tikiticketlib.php', '21.12', 0),
('31c7f5649784708227b4ebd9902cde6f', './lib/todolib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/toolbars/index.php', '21.12', 0),
('7212421a056abdfea8cfd18e709a0219', './lib/toolbars/tiki-admin_toolbars.js', '21.12', 0),
('9d7ad3cae0f46aa58d26226abcee77a0', './lib/toolbars/toolbarslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/trackers/index.php', '21.12', 0),
('21cab38f750a8d17f3cc6d342683fd4f', './lib/trackers/trackerlib.php', '21.12', 0),
('e157c75fb29d1021ba4b5a31480d93f8', './lib/transitionlib.php', '21.12', 0),
('e6dd71217ce2ddc334df9ff8ee33e909', './lib/tree/BrowseTreeMaker.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/tree/index.php', '21.12', 0),
('34c719f1ddc825c9d57678b68c1b34a4', './lib/tree/tree.php', '21.12', 0),
('ae6337997fa244ec2f4ca8eafb392042', './lib/user/blacklistlib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/user/index.php', '21.12', 0),
('aa66fc720e6a0a910ad1a5095801a01d', './lib/user/monitorlib.php', '21.12', 0),
('ed708f3f2e3b2d59119c3154d66d137a', './lib/user/monitormaillib.php', '21.12', 0),
('cde255af464427a91d1f28b7107f8461', './lib/user/sociallib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/userfiles/index.php', '21.12', 0),
('d8231511d6add375ebd1875f65c6ea4f', './lib/userfiles/userfileslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/usermenu/index.php', '21.12', 0),
('8a704416f18b4a8fff551635e69862e0', './lib/usermenu/usermenulib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/usermodules/index.php', '21.12', 0),
('09bd61f03a9daf6a71bb369948ea8722', './lib/usermodules/usermoduleslib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/userprefs/index.php', '21.12', 0),
('547c1e0e36e4ca012b3199ece5b2610d', './lib/userprefs/userprefslib.php', '21.12', 0),
('9782d13f7ab2e260db7f166146da6d48', './lib/userslib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/validators/index.php', '21.12', 0),
('cfde1e8154716385a38ed83238ad71aa', './lib/validators/validator_captcha.php', '21.12', 0),
('1d347231657fe7a38a0f1ad0c3b49e3f', './lib/validators/validator_distinct.php', '21.12', 0),
('49ebceefec12669200d6eaeccb10d52b', './lib/validators/validator_pagename.php', '21.12', 0),
('0152b62ae00d50850052072be0ef5ac0', './lib/validators/validator_passcode.php', '21.12', 0),
('c51821e7c6c18ee3dd5b5192551f0ec6', './lib/validators/validator_password.php', '21.12', 0),
('5b71e81ca61c118d0480c10f24441d1b', './lib/validators/validator_regex.php', '21.12', 0),
('95421856945b5880b443f00f691fa76c', './lib/validators/validator_tiki.js', '21.12', 0),
('c0575f37345682a725de00b974ff61e9', './lib/validators/validator_uniqueemail.php', '21.12', 0),
('cb75c66477a178444709544df76f12fb', './lib/validators/validator_username.php', '21.12', 0),
('7e809b5f0cc4f0f284cf6f5d75ab3a0b', './lib/validatorslib.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/videogals/index.php', '21.12', 0),
('4279bf59a8aa5d8a25393c22d53296db', './lib/videogals/kalturalib.php', '21.12', 0),
('7ab3da08eecbdcc4b19c4a24929c35a1', './lib/vue/lib/ui-predicate-vue.css', '21.12', 0),
('ca50ab5c366ea46ecf2d04d27e84cc5f', './lib/vue/lib/ui-predicate-vue.js', '21.12', 0),
('23b638cb7a1da53a515c43527bb1edcb', './lib/vue/vuejslib.php', '21.12', 0),
('c4626565c8363551c70b00aea57b3822', './lib/webmail/addressbooklib.php', '21.12', 0),
('c16c31d4be1df8f9365a632a07260fd8', './lib/webmail/contactlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/webmail/index.php', '21.12', 0),
('204b2304ec4181ed091c72c63315c46a', './lib/webmail/net_pop3.php', '21.12', 0),
('e900c75ddc9a513dc5bd5137276f4366', './lib/webmail/tikimaillib.php', '21.12', 0),
('dd669c3187578e1e9bf163e8e4fe7cff', './lib/webservicelib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/wiki-plugins/index.php', '21.12', 0),
('c494b194ee070e38d21a79620b9cef9a', './lib/wiki-plugins/wikiplugin_activitystream.php', '21.12', 0),
('c8b78ec5e8358947a735518fb21506e4', './lib/wiki-plugins/wikiplugin_addfreetag.php', '21.12', 0),
('9bf2e1a0180cea4d40caa93f3675f1f6', './lib/wiki-plugins/wikiplugin_addreference.php', '21.12', 0),
('c0487edf98116c2cab665ba5bb3db07e', './lib/wiki-plugins/wikiplugin_addrelation.php', '21.12', 0),
('5537c5555ae8b984779bd2a6640c6cd5', './lib/wiki-plugins/wikiplugin_addtocart.php', '21.12', 0),
('668ba5d8ccbca88e25262f0ce9e484e3', './lib/wiki-plugins/wikiplugin_addtogooglecal.php', '21.12', 0),
('0a48c3700f1b43fbe63e062d2d2cd959', './lib/wiki-plugins/wikiplugin_adjustinventory.php', '21.12', 0),
('7c9287eda62512009e7e6f1ea0951c81', './lib/wiki-plugins/wikiplugin_agentinfo.php', '21.12', 0),
('997e847b3a49336e9054ef5b82bb2946', './lib/wiki-plugins/wikiplugin_ajaxload.php', '21.12', 0),
('0d0b2b10d18e74c817d7158adde92adb', './lib/wiki-plugins/wikiplugin_alink.php', '21.12', 0),
('e1f932489b506973012c058485b9d465', './lib/wiki-plugins/wikiplugin_aname.php', '21.12', 0),
('6b2c1664e17e9b71e188c1a2400ce58f', './lib/wiki-plugins/wikiplugin_annotation.php', '21.12', 0),
('2eda2838953ff1a1c6912fb1723f5bc5', './lib/wiki-plugins/wikiplugin_appframe.php', '21.12', 0),
('ac536f3d6e64e3abcce89572ddd464a9', './lib/wiki-plugins/wikiplugin_archivebuilder.php', '21.12', 0),
('839fe7a64727e41675d38689ea687050', './lib/wiki-plugins/wikiplugin_article.php', '21.12', 0),
('1442c387b377c0972ca1f59781bd871e', './lib/wiki-plugins/wikiplugin_articles.php', '21.12', 0),
('f6578a2d095fcb559e3bfb0ce6ffb86d', './lib/wiki-plugins/wikiplugin_attach.php', '21.12', 0),
('a35523eb8727bcda85f6266a5ce8f535', './lib/wiki-plugins/wikiplugin_attributes.php', '21.12', 0),
('7f1075cb48313b263f7071d015668ce0', './lib/wiki-plugins/wikiplugin_author.php', '21.12', 0),
('4abd3eacbff910ed2b92feba7ee36506', './lib/wiki-plugins/wikiplugin_autoqueryargs.php', '21.12', 0),
('76bef763cd108c9dca6b93abdee9e177', './lib/wiki-plugins/wikiplugin_avatar.php', '21.12', 0),
('d2baaeb7ae54ec5f0de17af07683799f', './lib/wiki-plugins/wikiplugin_back.php', '21.12', 0),
('33f054934dc0dc1099b882f1627f13f6', './lib/wiki-plugins/wikiplugin_backlinks.php', '21.12', 0),
('a5d5be71e4abe5d1405bd4c3dcbcdd67', './lib/wiki-plugins/wikiplugin_banner.php', '21.12', 0),
('ca7a1b7cc856e58f4a2ecae6b8b8aaaa', './lib/wiki-plugins/wikiplugin_benchmark.php', '21.12', 0),
('75bd86fe74a717d22768a4d44e02bde2', './lib/wiki-plugins/wikiplugin_bigbluebutton.php', '21.12', 0),
('9e6de4cb3eb335fbb635f8d0ba6b59b9', './lib/wiki-plugins/wikiplugin_bloglist.php', '21.12', 0),
('e4da8cd5f5ed7d136cf48796cd0d6bba', './lib/wiki-plugins/wikiplugin_box.php', '21.12', 0),
('4691e442a2d2c18cef35f19523041c9a', './lib/wiki-plugins/wikiplugin_button.php', '21.12', 0),
('015a680064e29024525d275df72d10ba', './lib/wiki-plugins/wikiplugin_calendar.php', '21.12', 0),
('0b1e75008a208477ff42ebc484e7ad9e', './lib/wiki-plugins/wikiplugin_carousel.php', '21.12', 0),
('2638ee53aad54d2eac55b73210983e38', './lib/wiki-plugins/wikiplugin_cartmissinguserinfo.php', '21.12', 0),
('5e56378bb98867036a1fd472136bca39', './lib/wiki-plugins/wikiplugin_casperjs.php', '21.12', 0),
('f3b3c217fe2738e90871da7de7b0de3f', './lib/wiki-plugins/wikiplugin_category.php', '21.12', 0),
('1b2bcd21df8e0c8a6cd4a4dcfed4a338', './lib/wiki-plugins/wikiplugin_categorytransition.php', '21.12', 0),
('38d664a802855d643c51960833b32b84', './lib/wiki-plugins/wikiplugin_catorphans.php', '21.12', 0),
('14f9cabe9d4ae6dbbefac14b51a00769', './lib/wiki-plugins/wikiplugin_catpath.php', '21.12', 0),
('43a7dc96970b9bb85e6d29c290e54099', './lib/wiki-plugins/wikiplugin_cclite.php', '21.12', 0),
('19dd1a7e679f1ea28be69800c5bf0257', './lib/wiki-plugins/wikiplugin_center.php', '21.12', 0),
('f5bd3f7a6d422b68c4d0b5e9a9ad42c6', './lib/wiki-plugins/wikiplugin_chart.php', '21.12', 0),
('0d4f25e975d26495b8d7864af3db441f', './lib/wiki-plugins/wikiplugin_chartjs.php', '21.12', 0),
('578b54e72961ae9ac6a23c65f800d765', './lib/wiki-plugins/wikiplugin_checkreferer.php', '21.12', 0),
('49ef7b76d7bf932960f7005fafe5e932', './lib/wiki-plugins/wikiplugin_code.php', '21.12', 0),
('c0785965eab39b08789bfab47296a1a2', './lib/wiki-plugins/wikiplugin_colorbox.php', '21.12', 0),
('859e11c151299e8b50922557a9284ef7', './lib/wiki-plugins/wikiplugin_comment.php', '21.12', 0),
('c1d1f95235f9d4a527cc51f52ac2a627', './lib/wiki-plugins/wikiplugin_content.php', '21.12', 0),
('1293320b8831ccc3148e141d5071fe36', './lib/wiki-plugins/wikiplugin_contributionsdashboard.php', '21.12', 0),
('9c92c5c51aae6110486ab7deb101338d', './lib/wiki-plugins/wikiplugin_convene.php', '21.12', 0),
('f2bbd2b9bbc6a08e6737e91b184d218f', './lib/wiki-plugins/wikiplugin_cookie.php', '21.12', 0),
('3a96dba111e47fb259049eb255e23fdd', './lib/wiki-plugins/wikiplugin_cookieconsent.php', '21.12', 0),
('44425c52ec7c4ed80ee72256facbf6d3', './lib/wiki-plugins/wikiplugin_copyright.php', '21.12', 0),
('947470fa3fd4be0a71b148c195d63f01', './lib/wiki-plugins/wikiplugin_countdown.php', '21.12', 0),
('aacf9182f5ec119ee40d3bf8419f0ccd', './lib/wiki-plugins/wikiplugin_customsearch.php', '21.12', 0),
('235214888718dd2979b7e2fd14a2aea6', './lib/wiki-plugins/wikiplugin_cypht.php', '21.12', 0),
('a6bf58ffdc784dba007aa9a22712c16a', './lib/wiki-plugins/wikiplugin_datachannel.php', '21.12', 0),
('9ef258075e5ea7a3218077b45326bd09', './lib/wiki-plugins/wikiplugin_dbreport.php', '21.12', 0),
('7431cde80cd4caf3b3dff481ef86a016', './lib/wiki-plugins/wikiplugin_diagram.php', '21.12', 0),
('bf925f046781c9f95a2af2969d371039', './lib/wiki-plugins/wikiplugin_dialog.php', '21.12', 0),
('bff61ab28d54d50f4e05b1c592fbf170', './lib/wiki-plugins/wikiplugin_div.php', '21.12', 0),
('9e0276e6e950d5d23a0638347476dff1', './lib/wiki-plugins/wikiplugin_dl.php', '21.12', 0),
('ac3a277334b9fbcc629f102ff9d047a3', './lib/wiki-plugins/wikiplugin_draw.php', '21.12', 0),
('45eb884983210363126e9e811b418996', './lib/wiki-plugins/wikiplugin_dynamicvariables.php', '21.12', 0),
('8e04d0c9285ec8e919f42a678be447f7', './lib/wiki-plugins/wikiplugin_equation.php', '21.12', 0),
('4b82d140e9bfacb169a7ef8e35863e03', './lib/wiki-plugins/wikiplugin_events.php', '21.12', 0),
('cdf8225794cb42b88209264cca7cb59e', './lib/wiki-plugins/wikiplugin_exercise.php', '21.12', 0),
('b0e57cbf679244668f77cc1e4d17e2aa', './lib/wiki-plugins/wikiplugin_extendcarthold.php', '21.12', 0),
('84da8803279dea064daa08d8a305aa81', './lib/wiki-plugins/wikiplugin_fade.php', '21.12', 0),
('e0a95bf585a8b95b14dc66f52547d2bd', './lib/wiki-plugins/wikiplugin_fancylist.php', '21.12', 0),
('919ededff0d817c817604b3ffa6f7026', './lib/wiki-plugins/wikiplugin_fancytable.php', '21.12', 0),
('d3e1aae0924e52269ac34adf961acc2a', './lib/wiki-plugins/wikiplugin_favorite.php', '21.12', 0),
('50dfce0530f2fb9fdfdebe6c1fe8c31d', './lib/wiki-plugins/wikiplugin_file.php', '21.12', 0),
('edb54f4f5d6ed58d769d772876750cf5', './lib/wiki-plugins/wikiplugin_files.php', '21.12', 0),
('9a762ec39fba0c7ed682e5725cc4dbaf', './lib/wiki-plugins/wikiplugin_fitnesse.php', '21.12', 0),
('8af0ea8031d026da164938c33567360d', './lib/wiki-plugins/wikiplugin_flash.php', '21.12', 0),
('a8aab4c190f933cedfc3d4e4fae3b128', './lib/wiki-plugins/wikiplugin_fluidgrid.php', '21.12', 0),
('f8f4667b44f93393d2fbdf59da44b550', './lib/wiki-plugins/wikiplugin_font.php', '21.12', 0),
('b7215baa10a7872b71627aadd700986d', './lib/wiki-plugins/wikiplugin_footnote.php', '21.12', 0),
('8bed9795bfdf70cd379dc42dacb0aba8', './lib/wiki-plugins/wikiplugin_footnotearea.php', '21.12', 0),
('ee028fc0a325d496945324fdc4ca3fbe', './lib/wiki-plugins/wikiplugin_freetagged.php', '21.12', 0),
('5825adbbf3e5898036ca0113c6718cc4', './lib/wiki-plugins/wikiplugin_friend.php', '21.12', 0),
('d27e17f52ae438abc5b61b27b266fb6d', './lib/wiki-plugins/wikiplugin_ftp.php', '21.12', 0),
('df3eef47b19bbe29b998fcb1595ac4f8', './lib/wiki-plugins/wikiplugin_fullwidthtitle.php', '21.12', 0),
('f730c15da4b3017190195011f8a009ba', './lib/wiki-plugins/wikiplugin_galleriffic.php', '21.12', 0),
('e3238dc8d809b598f8d257a9df77c90c', './lib/wiki-plugins/wikiplugin_ganttchart.php', '21.12', 0),
('ccc77c295991986365f0cdce0e0386f3', './lib/wiki-plugins/wikiplugin_gauge.php', '21.12', 0),
('1ce47a057ec51ea8d404904be35fb85b', './lib/wiki-plugins/wikiplugin_gdgraph.php', '21.12', 0),
('ce1ccc0e3a37145b03fefdd489eeb57e', './lib/wiki-plugins/wikiplugin_getaccesstoken.php', '21.12', 0),
('3c2ed59972b89ef3de3915fd902e1eb6', './lib/wiki-plugins/wikiplugin_googleanalytics.php', '21.12', 0),
('8df40b728f707f04f85118b957dfb7d1', './lib/wiki-plugins/wikiplugin_googlechart.php', '21.12', 0),
('ccb46d845b4d498c41ab1771791e263e', './lib/wiki-plugins/wikiplugin_googledoc.php', '21.12', 0),
('8695b7c15efcede799bee2d71c9abf32', './lib/wiki-plugins/wikiplugin_group.php', '21.12', 0),
('fb43d0f4c9e0ee825341b5e0c3701a7f', './lib/wiki-plugins/wikiplugin_groupedit.php', '21.12', 0),
('d9102d20a378960dc278b036b7f0753c', './lib/wiki-plugins/wikiplugin_groupexpiry.php', '21.12', 0),
('4e45341a153e31f8100d29577dcdcdfb', './lib/wiki-plugins/wikiplugin_grouplist.php', '21.12', 0),
('91d06891fc61ebe7393e93a647f98657', './lib/wiki-plugins/wikiplugin_groupmailcore.php', '21.12', 0),
('e6c79822b0764a8d013810a83ab385f1', './lib/wiki-plugins/wikiplugin_groupstat.php', '21.12', 0),
('1faeadcad9b048037f128c4600866f38', './lib/wiki-plugins/wikiplugin_h5p.php', '21.12', 0),
('b4d4565a441d7a0162633d393035f9b0', './lib/wiki-plugins/wikiplugin_hasbought.php', '21.12', 0),
('ebfcfc75fed9c08cd1dd2f30d7109d35', './lib/wiki-plugins/wikiplugin_html.php', '21.12', 0),
('35e87057086e7dc99575cc94983a281e', './lib/wiki-plugins/wikiplugin_htmlfeed.php', '21.12', 0),
('cd25a95d4dd1206f95dcc4ebcacd43e8', './lib/wiki-plugins/wikiplugin_htmlfeedlink.php', '21.12', 0),
('b9edda63cd85ae878aa6824f68a652bb', './lib/wiki-plugins/wikiplugin_icon.php', '21.12', 0),
('a09550031054ed62329f64989019913c', './lib/wiki-plugins/wikiplugin_iframe.php', '21.12', 0),
('a7d5b205b97af4f247087ce410b7ee84', './lib/wiki-plugins/wikiplugin_img.php', '21.12', 0),
('1a7c65967c0ee566e16d66e4f1abcb56', './lib/wiki-plugins/wikiplugin_include.php', '21.12', 0),
('2d5c4a79ce253561156a16820c16dbe7', './lib/wiki-plugins/wikiplugin_includetpl.php', '21.12', 0),
('b803218c54df2bb2458bb9e6fdf7d0db', './lib/wiki-plugins/wikiplugin_includeurl.php', '21.12', 0),
('7f0b27035fd557d776ad7d7c7f590c96', './lib/wiki-plugins/wikiplugin_insert.php', '21.12', 0),
('0c8fed022298b223bc46b00cf1016786', './lib/wiki-plugins/wikiplugin_invite.php', '21.12', 0),
('684f473da9156891cf42134260d0db91', './lib/wiki-plugins/wikiplugin_jq.php', '21.12', 0),
('5314b0e461ce3fe2dbafde8db2cd945d', './lib/wiki-plugins/wikiplugin_js.php', '21.12', 0),
('a989eb77c2e49895f0ccf915d789087e', './lib/wiki-plugins/wikiplugin_kaltura.php', '21.12', 0),
('970aa6a4dbbb4a4d9c85c63090bd86da', './lib/wiki-plugins/wikiplugin_lang.php', '21.12', 0),
('3c9a89b4f228593a36dadda03f2bad03', './lib/wiki-plugins/wikiplugin_lastmod.php', '21.12', 0),
('49304268bb30cbaa057d19ed6fede9c5', './lib/wiki-plugins/wikiplugin_layout.php', '21.12', 0),
('f64a56133f3b16cbf838863ce4225be2', './lib/wiki-plugins/wikiplugin_like.php', '21.12', 0),
('50cc2a38157fb3afcfc1899db05aa12d', './lib/wiki-plugins/wikiplugin_list.php', '21.12', 0),
('992caa4e1e229e8f216f2228bb74bb79', './lib/wiki-plugins/wikiplugin_listexecute.php', '21.12', 0),
('86dec4701b2d5c8fe16b30ff197b32c7', './lib/wiki-plugins/wikiplugin_listpages.php', '21.12', 0),
('5fa06aefbed8b83e3ba886c9852fbc2e', './lib/wiki-plugins/wikiplugin_localfiles.php', '21.12', 0),
('140c33a23a5824aebaac78bb35b30c22', './lib/wiki-plugins/wikiplugin_lsdir.php', '21.12', 0),
('36bb1e1b61f34ee316688220942be909', './lib/wiki-plugins/wikiplugin_mail.php', '21.12', 0),
('c82788cb69e12766a3fc6aa34ffdd311', './lib/wiki-plugins/wikiplugin_map.php', '21.12', 0),
('a551d0c145ac0372b6859068c880265d', './lib/wiki-plugins/wikiplugin_markdown.php', '21.12', 0),
('2d5e4043facc09d083b6d9b9e9d1b7fa', './lib/wiki-plugins/wikiplugin_mcalendar.php', '21.12', 0),
('b43e8c887da70e818746d767a84c1f17', './lib/wiki-plugins/wikiplugin_mediaplayer.php', '21.12', 0),
('4e355b082183a068c0e8816fc29ae748', './lib/wiki-plugins/wikiplugin_memberlist.php', '21.12', 0),
('35d2c77789b55d473eb2cf598cf23085', './lib/wiki-plugins/wikiplugin_memberpayment.php', '21.12', 0),
('db203d0cb2057e89c700f0081f10ebee', './lib/wiki-plugins/wikiplugin_metatag.php', '21.12', 0),
('30fdc9d37ead36ad09eb1a3759e148da', './lib/wiki-plugins/wikiplugin_miniquiz.php', '21.12', 0),
('8abb3f8ae922192de1b9a87e2892d4ee', './lib/wiki-plugins/wikiplugin_module.php', '21.12', 0),
('12288de67cc4997098280f8218652f37', './lib/wiki-plugins/wikiplugin_modulelist.php', '21.12', 0),
('100a026f67fb0a140e616630aa97e195', './lib/wiki-plugins/wikiplugin_mono.php', '21.12', 0),
('5984ef4b165f429f25ab2734e915b7b6', './lib/wiki-plugins/wikiplugin_mouseover.php', '21.12', 0),
('481310317fe61219daaeb50308aae790', './lib/wiki-plugins/wikiplugin_mwtable.php', '21.12', 0),
('f78e7f21cfa908d84868b68dbfc31185', './lib/wiki-plugins/wikiplugin_myspace.php', '21.12', 0),
('da5d9d88b246e90874c393e30c49a640', './lib/wiki-plugins/wikiplugin_networkcondition.php', '21.12', 0),
('1cccf6ceaee62e65d09ce50c24fdfde4', './lib/wiki-plugins/wikiplugin_now.php', '21.12', 0),
('deaf983e2110ed29ee0bd67df88ac0d2', './lib/wiki-plugins/wikiplugin_objecthits.php', '21.12', 0),
('faf096ca2a33e25afad0d81250f8aa25', './lib/wiki-plugins/wikiplugin_objectlink.php', '21.12', 0),
('987be93b294485075b05a56138208315', './lib/wiki-plugins/wikiplugin_package.php', '21.12', 0),
('b91ef4b73ff5aa0a8c38a163219e7729', './lib/wiki-plugins/wikiplugin_pagetabs.php', '21.12', 0),
('21a547f89b099cce744f327c670df1d9', './lib/wiki-plugins/wikiplugin_param.php', '21.12', 0),
('e6f7fc2ae27d45d5e6d2747577d3f893', './lib/wiki-plugins/wikiplugin_payment.php', '21.12', 0),
('c38fec8534da3fec8fea38535da3f231', './lib/wiki-plugins/wikiplugin_paymentlist.php', '21.12', 0),
('581a721b856e1215d5f1bf08c28287c8', './lib/wiki-plugins/wikiplugin_paypal.php', '21.12', 0),
('68c8f51b9b7ca903af2d846dc8f73559', './lib/wiki-plugins/wikiplugin_pdf.php', '21.12', 0),
('ccbcdf1e12e17c3f22b7244116fed44f', './lib/wiki-plugins/wikiplugin_pdfbookmark.php', '21.12', 0),
('ae18ca8399c7510859837b2d7f453e19', './lib/wiki-plugins/wikiplugin_pdfpage.php', '21.12', 0),
('8b99a9716154dc26985f31e290a07c5c', './lib/wiki-plugins/wikiplugin_pdfpagebreak.php', '21.12', 0),
('3f482ce8a0c300d4a11813643bfd172a', './lib/wiki-plugins/wikiplugin_perm.php', '21.12', 0),
('7866f672448722eaa7262c10c0807da7', './lib/wiki-plugins/wikiplugin_perspective.php', '21.12', 0),
('5fc146b49a4c373d30c29f56e893ae06', './lib/wiki-plugins/wikiplugin_pivottable.php', '21.12', 0),
('e5a8241cd6362c09cf03989185c6c52e', './lib/wiki-plugins/wikiplugin_piwik.php', '21.12', 0),
('a8383d7b5cc1ab8c4b6eb8d71b581431', './lib/wiki-plugins/wikiplugin_playscorm.php', '21.12', 0),
('02d85645e74ef62eeed09654e828d94e', './lib/wiki-plugins/wikiplugin_pluginmanager.php', '21.12', 0),
('a69f6616ec63610ee7034ebd1f8d91b5', './lib/wiki-plugins/wikiplugin_poll.php', '21.12', 0),
('e2eb91b7bac50746ba9c6a6fdde5c305', './lib/wiki-plugins/wikiplugin_pref.php', '21.12', 0),
('bc44e4c1acfa87bc8b48ee2e3897c3ed', './lib/wiki-plugins/wikiplugin_prefdoc.php', '21.12', 0),
('f8483f414e9b3aab5b0f7d3bf9fd20af', './lib/wiki-plugins/wikiplugin_preference.php', '21.12', 0),
('5841fb3ece3e29f2180ea59c09dd14ec', './lib/wiki-plugins/wikiplugin_prettytrackerviews.php', '21.12', 0),
('5fc02f5d803b2e44d2853babc9634297', './lib/wiki-plugins/wikiplugin_preview.php', '21.12', 0),
('29cb5fc50c829d6fba8fff6c0e96f7dc', './lib/wiki-plugins/wikiplugin_profile.php', '21.12', 0),
('7522f4e0ed0706af7ffb02f9080d95d0', './lib/wiki-plugins/wikiplugin_profilesymbolvalue.php', '21.12', 0),
('05c4556d6e30805a64110441c2a75a45', './lib/wiki-plugins/wikiplugin_proposal.php', '21.12', 0),
('2e5f63194a4633298345c4b883ace749', './lib/wiki-plugins/wikiplugin_quote.php', '21.12', 0),
('92428eac37d2c56baf97740be8141832', './lib/wiki-plugins/wikiplugin_r.php', '21.12', 0),
('f97251e37691165fb111d8a61918c3c9', './lib/wiki-plugins/wikiplugin_randominclude.php', '21.12', 0),
('9f8cedac46d524df3e7c58965e05e7be', './lib/wiki-plugins/wikiplugin_rcontent.php', '21.12', 0),
('178a08856568940da2f17ea7c15cce48', './lib/wiki-plugins/wikiplugin_realnamelist.php', '21.12', 0),
('404d24e5601b8c0682078491069e9dd0', './lib/wiki-plugins/wikiplugin_redirect.php', '21.12', 0),
('531544698199663bcf5df08acbaa1c27', './lib/wiki-plugins/wikiplugin_regex.php', '21.12', 0),
('de3ebcfeaa61f6a0cf0a5e9a9f15f204', './lib/wiki-plugins/wikiplugin_registermemberpayment.php', '21.12', 0),
('426e56a64b349d6c2ec26281fa3598aa', './lib/wiki-plugins/wikiplugin_relations.php', '21.12', 0),
('30b1d1581055b0e3d3d133b31f59435e', './lib/wiki-plugins/wikiplugin_remarksbox.php', '21.12', 0),
('ff45bd488c689a78fcf59b70e9246a4d', './lib/wiki-plugins/wikiplugin_rr.php', '21.12', 0),
('d22f861dcf6c4e4afdb804f654db7183', './lib/wiki-plugins/wikiplugin_rss.php', '21.12', 0),
('0787aa56b92d794a4fbfc2068399a3d1', './lib/wiki-plugins/wikiplugin_scroll.php', '21.12', 0),
('f9c87d4f10033282004b242665ac4602', './lib/wiki-plugins/wikiplugin_sf.php', '21.12', 0),
('c3d134f24bdf46021cde227b210f4a5b', './lib/wiki-plugins/wikiplugin_sharethis.php', '21.12', 0),
('ea97a1828d5fbcaf9f4a06d70f6cf4d9', './lib/wiki-plugins/wikiplugin_sheet.php', '21.12', 0),
('5f0a8acbfe41f5974ae029e39d1607ae', './lib/wiki-plugins/wikiplugin_shopperinfo.php', '21.12', 0),
('c8787c6cb93b07534cc25a0e356db285', './lib/wiki-plugins/wikiplugin_shorten.php', '21.12', 0),
('e9d7c1dd4bfdebaf0731bdaf77c17116', './lib/wiki-plugins/wikiplugin_showpages.php', '21.12', 0),
('06cf9ac0f0c5b5b6086ab4f4a506131d', './lib/wiki-plugins/wikiplugin_showpref.php', '21.12', 0),
('93426b881d240b04e4692c8c99f0ae73', './lib/wiki-plugins/wikiplugin_showreference.php', '21.12', 0),
('f315da7634aa232d2b957f6bbbdb3128', './lib/wiki-plugins/wikiplugin_sign.php', '21.12', 0),
('aba03c96d019bab36cb42e2e70359cfc', './lib/wiki-plugins/wikiplugin_skype.php', '21.12', 0),
('abdbb20e89c6f9d1fa86beac3d28c918', './lib/wiki-plugins/wikiplugin_slider.php', '21.12', 0),
('b4e0d2ca870ec1c07cbe83bc91ab073e', './lib/wiki-plugins/wikiplugin_slideshow.php', '21.12', 0),
('28b64d7b3aa9c24a94f90d5bd564d98a', './lib/wiki-plugins/wikiplugin_slideshowslide.php', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('7e3c031e5ccadf9ebea8aadd9e219351', './lib/wiki-plugins/wikiplugin_smarty.php', '21.12', 0),
('d4a926db12562b62cdf5adbbb38683b7', './lib/wiki-plugins/wikiplugin_snarf.php', '21.12', 0),
('a6d8735a27a0b9a85814e9742f828797', './lib/wiki-plugins/wikiplugin_sort.php', '21.12', 0),
('b8beb1394cb428f0c77ab61612eff81d', './lib/wiki-plugins/wikiplugin_split.php', '21.12', 0),
('b6c0f304e57885e3b76c33493281f66d', './lib/wiki-plugins/wikiplugin_sql.php', '21.12', 0),
('8666e4942dd8d380a9be5beca8370a96', './lib/wiki-plugins/wikiplugin_stat.php', '21.12', 0),
('30302e29da0afb0e024fb11f6b51aa59', './lib/wiki-plugins/wikiplugin_sub.php', '21.12', 0),
('eb1377d86111a516213710cdafe86913', './lib/wiki-plugins/wikiplugin_subscribegroup.php', '21.12', 0),
('978dc4201df53e8577830c107c1f3d36', './lib/wiki-plugins/wikiplugin_subscribegroups.php', '21.12', 0),
('622e4b18fcb35d4b011bbf3d083b1dce', './lib/wiki-plugins/wikiplugin_subscribenewsletter.php', '21.12', 0),
('8c7aedb7d97fe0aee0d6ea4bdb4e9fbb', './lib/wiki-plugins/wikiplugin_sup.php', '21.12', 0),
('86346c2714f0c51b78792f3a38892eb0', './lib/wiki-plugins/wikiplugin_survey.php', '21.12', 0),
('cc66f0822a3afc84d662917d1e0030bf', './lib/wiki-plugins/wikiplugin_swiper.php', '21.12', 0),
('81a35e3939efcc476bc57768e439efd2', './lib/wiki-plugins/wikiplugin_tabs.php', '21.12', 0),
('fe8aae8fe3e5d8324f88850cd958a0b3', './lib/wiki-plugins/wikiplugin_tag.php', '21.12', 0),
('9eaeddf4f730debdc8f75b648568f052', './lib/wiki-plugins/wikiplugin_timeline.php', '21.12', 0),
('6565b1d0d21f8d2c01a1f7c44d50870f', './lib/wiki-plugins/wikiplugin_timesheet.php', '21.12', 0),
('272a4cfd82f9f2098b982a88f1591051', './lib/wiki-plugins/wikiplugin_titlesearch.php', '21.12', 0),
('2e135adfb80f71e58788d164874be9c9', './lib/wiki-plugins/wikiplugin_toc.php', '21.12', 0),
('0408ef975616bf1727190c158445d824', './lib/wiki-plugins/wikiplugin_together.php', '21.12', 0),
('c9ec7ba08756096ad7c95e6f672526b5', './lib/wiki-plugins/wikiplugin_tour.php', '21.12', 0),
('bbf7572cbee62abb64eacde3b8132a9d', './lib/wiki-plugins/wikiplugin_tr.php', '21.12', 0),
('58fd980c515ae24aa8746c928f7d4e05', './lib/wiki-plugins/wikiplugin_tracker.php', '21.12', 0),
('7ad5f7f0e327c20a7a898461f79c260a', './lib/wiki-plugins/wikiplugin_trackercalendar.php', '21.12', 0),
('711b18d6bcf895fdaaff9e005e1fcfc2', './lib/wiki-plugins/wikiplugin_trackercomments.php', '21.12', 0),
('fc07c8536feb3c75fe460f289ab8f54c', './lib/wiki-plugins/wikiplugin_trackerfilter.php', '21.12', 0),
('3de946ee7606b092ec5260d4dfa119c4', './lib/wiki-plugins/wikiplugin_trackerif.php', '21.12', 0),
('d0e353b942dd3af29bcca4d2d26208fb', './lib/wiki-plugins/wikiplugin_trackeritemcopy.php', '21.12', 0),
('d07585a725af27af4425fa8714d004a8', './lib/wiki-plugins/wikiplugin_trackeritemfield.php', '21.12', 0),
('7d77427d2dedd7128b31a47959fb0d57', './lib/wiki-plugins/wikiplugin_trackerlist.php', '21.12', 0),
('ad25860a51bf4acbb9ea54ece83b7012', './lib/wiki-plugins/wikiplugin_trackerpasscode.php', '21.12', 0),
('24f87276823b71b97f8bd81f865d4ab6', './lib/wiki-plugins/wikiplugin_trackerprefill.php', '21.12', 0),
('aa2e9884f0152050692e56b174493cc6', './lib/wiki-plugins/wikiplugin_trackerquerytemplate.php', '21.12', 0),
('4609aa88aaa95603ba2fa1a62dd699cc', './lib/wiki-plugins/wikiplugin_trackerstat.php', '21.12', 0),
('2c51b5366d0c0c2bf05530a262f8d94a', './lib/wiki-plugins/wikiplugin_trackertimeline.php', '21.12', 0),
('e96e4f11da83b8eb4fc77f46f2f22212', './lib/wiki-plugins/wikiplugin_trackertoggle.php', '21.12', 0),
('1282a481f9ecb689f182b984d9348d67', './lib/wiki-plugins/wikiplugin_trade.php', '21.12', 0),
('f71f96906a474d4cc70002a8f0a597f9', './lib/wiki-plugins/wikiplugin_transclude.php', '21.12', 0),
('2609764f9c73cce298eb39354c4fd544', './lib/wiki-plugins/wikiplugin_translated.php', '21.12', 0),
('36ac1c892bde8aa6c25884000a29bd31', './lib/wiki-plugins/wikiplugin_translationof.php', '21.12', 0),
('72a2f79f1660b6718ef7e2781a9aa2b5', './lib/wiki-plugins/wikiplugin_twitter.php', '21.12', 0),
('51209bb31a8f2a66c9e4de179681eec9', './lib/wiki-plugins/wikiplugin_usercount.php', '21.12', 0),
('ab44bec3ba35022db701d0cdb2407b27', './lib/wiki-plugins/wikiplugin_useringroup.php', '21.12', 0),
('fb340588a9af6642fe5679868c367d9e', './lib/wiki-plugins/wikiplugin_userlastlogged.php', '21.12', 0),
('05952c1c667d7570f44613d68eabdbd9', './lib/wiki-plugins/wikiplugin_userlink.php', '21.12', 0),
('f6521a62a85404db067722e84c07fec5', './lib/wiki-plugins/wikiplugin_userlist.php', '21.12', 0),
('cea13dd93a8c1ac2ff5834a63a062ec0', './lib/wiki-plugins/wikiplugin_userpref.php', '21.12', 0),
('5acf1981b6bc559854da8ff985246a3d', './lib/wiki-plugins/wikiplugin_versions.php', '21.12', 0),
('c5b9fec013e374c54f60361193679305', './lib/wiki-plugins/wikiplugin_vimeo.php', '21.12', 0),
('5cf785098a540cf0c30762cd6d74317d', './lib/wiki-plugins/wikiplugin_vote.php', '21.12', 0),
('4096e30479b46bd93a7c90a43669b107', './lib/wiki-plugins/wikiplugin_votings.php', '21.12', 0),
('9a63f5e985185d915b227b04be9ab095', './lib/wiki-plugins/wikiplugin_vue.php', '21.12', 0),
('975d6ccd5fd5737809ac02dd16fe6959', './lib/wiki-plugins/wikiplugin_wantedpages.php', '21.12', 0),
('78ff52a9cbba0a6d05c1f83d5762645f', './lib/wiki-plugins/wikiplugin_webdocviewer.php', '21.12', 0),
('84e9f37c5c559e5c2654c69de1a971bb', './lib/wiki-plugins/wikiplugin_webservice.php', '21.12', 0),
('b8a5a1d695299e1841dc6c83c6523582', './lib/wiki-plugins/wikiplugin_wikidiff.php', '21.12', 0),
('270d38ca4d3f8e222d0737fad31980e9', './lib/wiki-plugins/wikiplugin_wysiwyg.php', '21.12', 0),
('57da7f851d4d672ffcaf772935028e6b', './lib/wiki-plugins/wikiplugin_xmlupdate.php', '21.12', 0),
('e3356b1c8587aec7b70d1660ce186cdb', './lib/wiki-plugins/wikiplugin_xmpp.php', '21.12', 0),
('39e2faa936f68f95023db9b1516f5e84', './lib/wiki-plugins/wikiplugin_youtube.php', '21.12', 0),
('2ed8250b936b3f2f096c67467f25f4af', './lib/wiki-plugins/wikiplugin_zotero.php', '21.12', 0),
('83e795156bd20deef689af35d477c5bd', './lib/wiki-plugins/wikiplugin_zoterolist.php', '21.12', 0),
('ffdf9807e4c277ae0c3f14b801a49c50', './lib/wiki/editlib.php', '21.12', 0),
('7b545a135a3445876d6c0c0c58c1cff3', './lib/wiki/exportlib.php', '21.12', 0),
('984573bfa49aeff7eda0ea6ed988c55a', './lib/wiki/flaggedrevisionlib.php', '21.12', 0),
('8e92b8f58c8602b86ee1d7e64d00b7ef', './lib/wiki/histlib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/wiki/index.php', '21.12', 0),
('7196e47b970156dbb756e2da27ed31ad', './lib/wiki/pluginslib.php', '21.12', 0),
('da4e0a7eeb49d631b2dbb8350b9160ad', './lib/wiki/quantifylib.php', '21.12', 0),
('bce99f6cb078628b71813ed0454f1986', './lib/wiki/renderlib.php', '21.12', 0),
('8d6270ff53d2f82ebccedd2462221deb', './lib/wiki/semanticlib.php', '21.12', 0),
('00b8d159a88e17c80914cb9959ea2fbb', './lib/wiki/wikilib.php', '21.12', 0),
('21701aa6f41e9b69581f9a74765dd32b', './lib/wiki/xmllib.php', '21.12', 0),
('daf832de7969cf50f81e7214b198a4e9', './lib/wizard/index.php', '21.12', 0),
('5374fbf0addc63c320bde0cfbdd1be43', './lib/wizard/pages/admin_advanced.php', '21.12', 0),
('9525c6b13ba7d6b3701446a36319cb13', './lib/wizard/pages/admin_auto_toc.php', '21.12', 0),
('4f9ad8ea3c2cec4d16b3a0b6cb24f20a', './lib/wizard/pages/admin_category.php', '21.12', 0),
('b9742f16d0e100670a55ca72b2c51183', './lib/wizard/pages/admin_community.php', '21.12', 0),
('db14b4fe0e072e821f53877233eb1e11', './lib/wizard/pages/admin_date_time.php', '21.12', 0),
('d6654e0bd7894a93310dd8c57204ad9a', './lib/wizard/pages/admin_editor_type.php', '21.12', 0),
('b188a92839b4f5f409af9a14f154111a', './lib/wizard/pages/admin_features.php', '21.12', 0),
('d5101c70d2661f3c2b38704863feca22', './lib/wizard/pages/admin_files.php', '21.12', 0),
('cb0a4a9ac85999b5d0d154d7acccf4a9', './lib/wizard/pages/admin_files_storage.php', '21.12', 0),
('3215c05f8793daefb04e95d9fd70ff49', './lib/wizard/pages/admin_language.php', '21.12', 0),
('1d246272a77c46eb5de2994ee046b88f', './lib/wizard/pages/admin_login.php', '21.12', 0),
('3836e993d7018189b8ef78a230367032', './lib/wizard/pages/admin_look_and_feel.php', '21.12', 0),
('fa6453ef960834d4248104a16ca55c8b', './lib/wizard/pages/admin_namespace.php', '21.12', 0),
('b5fd14ff54b5f42bee94c65486cb1417', './lib/wizard/pages/admin_search.php', '21.12', 0),
('fac83fb63a508e3815f43478f2cdee4b', './lib/wizard/pages/admin_structures.php', '21.12', 0),
('4e84a4cf2e1160784093afb60444cb95', './lib/wizard/pages/admin_text_area.php', '21.12', 0),
('c632f918ed2a0b0fb13fca0a60da52ee', './lib/wizard/pages/admin_wiki.php', '21.12', 0),
('098f02e5671ba248f9413274a32a2a8c', './lib/wizard/pages/admin_wizard.php', '21.12', 0),
('4e05242228d8055ddfa4e27dbc8546c9', './lib/wizard/pages/admin_wizard_completed.php', '21.12', 0),
('684ffab47fb1c6e5cc8e8945d9306b52', './lib/wizard/pages/admin_wysiwyg.php', '21.12', 0),
('8a5a9304d225a046bb6efd4e7edf03fe', './lib/wizard/pages/changes_doc_page_iframe.php', '21.12', 0),
('3ed22dd78534758a42417c00883cf8a4', './lib/wizard/pages/changes_new_in_13.php', '21.12', 0),
('5118a38bd04684e820f03286dc94e52f', './lib/wizard/pages/changes_new_in_14.php', '21.12', 0),
('56562d64afc1b92ff9c65c72810611ba', './lib/wizard/pages/changes_new_in_15.php', '21.12', 0),
('c7fff1c4a0eee52a1d9e4709dcd54ebb', './lib/wizard/pages/changes_new_in_16.php', '21.12', 0),
('4c9bea40fe7b2b565d806f1118e660db', './lib/wizard/pages/changes_new_in_17.php', '21.12', 0),
('e0f0ace1b6706df724eacf6cf17d3d88', './lib/wizard/pages/changes_new_in_18.php', '21.12', 0),
('c6f9b0e7684dfc2e1d2d806f214e5fd4', './lib/wizard/pages/changes_new_in_19.php', '21.12', 0),
('6fa57702fbb11bdf654f81cadfe36dfe', './lib/wizard/pages/changes_new_in_20.php', '21.12', 0),
('a308cbb310cebb3260851c3c69ef503a', './lib/wizard/pages/changes_new_in_21.php', '21.12', 0),
('0265d3ea9419a78c40d74f34e2d14dea', './lib/wizard/pages/changes_novice_admin_assistance.php', '21.12', 0),
('39328a655fdb3ce3649816bbe90bc2ed', './lib/wizard/pages/changes_others.php', '21.12', 0),
('8280ff11517f167c3a24fbaa857507ba', './lib/wizard/pages/changes_permissions_and_logs.php', '21.12', 0),
('f4e112b2fae5c804af64de0356c47461', './lib/wizard/pages/changes_send_feedback.php', '21.12', 0),
('95bcf161f1496c74d69c789380dde93c', './lib/wizard/pages/changes_trackers.php', '21.12', 0),
('bcce2f30165bf17d31a86610e83b5554', './lib/wizard/pages/changes_ui.php', '21.12', 0),
('eda1e38cd76957554c38e918ce2ede09', './lib/wizard/pages/changes_wizard_completed.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './lib/wizard/pages/index.php', '21.12', 0),
('74a1fbe9ced048b1712727f0cf57ea0d', './lib/wizard/pages/profiles_completed.php', '21.12', 0),
('4c83933e8a61224b3ff5a41d686ea595', './lib/wizard/pages/profiles_demo_cases_in_project_management.php', '21.12', 0),
('cef63c8bc511a86744a615d25e7e3174', './lib/wizard/pages/profiles_demo_common_confs.php', '21.12', 0),
('e06167262a2a321bea4f3f4158fc46e8', './lib/wizard/pages/profiles_demo_highly_specialized_confs.php', '21.12', 0),
('8e41ac760425ff2144c491c23d1f568c', './lib/wizard/pages/profiles_demo_interesting_use_cases.php', '21.12', 0),
('4a2664c29f94d2294870458fe40bf157', './lib/wizard/pages/profiles_demo_more_advanced_confs.php', '21.12', 0),
('06b4bf16740f29f2e002a3f5c23aec36', './lib/wizard/pages/profiles_demo_other_interesting_use_cases.php', '21.12', 0),
('bd40bde28dbf3dccc63bc9325c4352aa', './lib/wizard/pages/profiles_featured_site_confs.php', '21.12', 0),
('798916f8ac08fe72a859a1ff9e8b986e', './lib/wizard/pages/profiles_useful_admin_confs.php', '21.12', 0),
('4af215592597106ea6f44d1d74475e0f', './lib/wizard/pages/profiles_useful_changes_in_display.php', '21.12', 0),
('cb019eec968b42253620c53c716d26a9', './lib/wizard/pages/profiles_useful_micro_confs.php', '21.12', 0),
('562c080d438455a83f1c48f6e25ce2d0', './lib/wizard/pages/profiles_useful_new_tech_confs.php', '21.12', 0),
('c8843b75ae22cbc656d9a2daf7d52225', './lib/wizard/pages/user_dummy1.php', '21.12', 0),
('fa80ad3c2c9be4f7b043fa04adf0fc94', './lib/wizard/pages/user_dummy2.php', '21.12', 0),
('4efbc3db4c9e10f280f091df61c331e6', './lib/wizard/pages/user_dummy3.php', '21.12', 0),
('9233e6394f7aca681de5ad44b60f537e', './lib/wizard/pages/user_preferences_info.php', '21.12', 0),
('c4440cdb3a6487234e1be097b383d833', './lib/wizard/pages/user_preferences_notifications.php', '21.12', 0),
('569f1e27763a95dcaca60da0dc30d20a', './lib/wizard/pages/user_preferences_params.php', '21.12', 0),
('53b5f3cf547586d97c8c22192912f7e7', './lib/wizard/pages/user_preferences_reports.php', '21.12', 0),
('9b6ed72c7c6872333a2ad017ddb7b4b3', './lib/wizard/pages/user_tracker.php', '21.12', 0),
('ebe5068c4c97ddd6756bf6cec6fc08e9', './lib/wizard/pages/user_wizard.php', '21.12', 0),
('e06ac12a1bc2a9427aca00ace7ea255c', './lib/wizard/pages/user_wizard_completed.php', '21.12', 0),
('f91d1bdb5e4b4f6344d7e12ecc9c10d4', './lib/wizard/wizard.php', '21.12', 0),
('c85b97964c1b8abe89a3aa16de314287', './lib/wizard/wizardlib.php', '21.12', 0),
('cdf43de6ca7d9c17fb9688d1b74c1ac8', './lib/xmpp/ConverseJS.php', '21.12', 0),
('2dc116b8ad901159a83c92448e8c0d4c', './lib/xmpp/TikiXmppChat.php', '21.12', 0),
('8bda6b2b6538d4b8c36474146446e171', './lib/xmpp/TikiXmppPrebind.php', '21.12', 0),
('d12d7dc8fb32d9df1459469933c994e0', './lib/xmpp/css/conversejs.css', '21.12', 0),
('4992fd4f3de262ac4225d5529f3d0892', './lib/xmpp/js/conversejs-tiki-oauth.js', '21.12', 0),
('dfc2ced3078a3da2c96e151bfbcec767', './lib/xmpp/js/conversejs-tiki.js', '21.12', 0),
('564bc1d246c9d9a7b8f5750418ecf8cc', './lib/xmpp/xmpplib.php', '21.12', 0),
('ca3462ee5a800a588b312089408cfc84', './lib/ziplib.php', '21.12', 0),
('0f64a7df203b74a503596afe24e25f5b', './lib/zoterolib.php', '21.12', 0),
('47c96af877345a9aad811685a832bf01', './list-file_backlinks_ajax.php', '21.12', 0),
('1c1fa01667fb0d609842a42240089856', './list-tracker_field_values_ajax.php', '21.12', 0),
('7a8cfe9deaab7d45ea4cf0ca9696d39f', './lists/articles.php', '21.12', 0),
('fad862f6723d55dabf05adeb8ec79e85', './messu-archive.php', '21.12', 0),
('891e1792f001c2e3f47587b7983b80e1', './messu-broadcast.php', '21.12', 0),
('550398322fa8fbac81e36a9c5e33d3dd', './messu-compose.php', '21.12', 0),
('536efa78dd4b1fbeb9c43a2f231d6152', './messu-mailbox.php', '21.12', 0),
('f93a03f2d72cb2a867d0a17ef7f797ba', './messu-read.php', '21.12', 0),
('9eb6107d7529a1a904a71a2b9b8868b0', './messu-read_archive.php', '21.12', 0),
('42115acc74018112a4ea89055c8f7480', './messu-read_sent.php', '21.12', 0),
('1c9a95c931a8859bb5bceb10a37a4012', './messu-sent.php', '21.12', 0),
('d7a6fd73166dbdb378529c5ecd38d7af', './modules/cache/index.php', '21.12', 0),
('50c736bd8e85e2170990c334ed284f28', './modules/index.php', '21.12', 0),
('dbe3d49bdc370039195342bd613ca42a', './modules/mod-func-action_calendar.php', '21.12', 0),
('0631a48a45337d0e84dfc52297a2637b', './modules/mod-func-action_similarcontent.php', '21.12', 0),
('d0260576b27a9bf086384d9e264f2416', './modules/mod-func-adminbar.php', '21.12', 0),
('425c73313575bb82d1470bfee819124e', './modules/mod-func-adsense.php', '21.12', 0),
('340fbc164334a1287b5568a0f51fdf7a', './modules/mod-func-article_archives.php', '21.12', 0),
('02a89265e80dffacc454cc1b9e3fd2ae', './modules/mod-func-article_topics.php', '21.12', 0),
('19575e2e8fdf399e8bbdec3417e30c88', './modules/mod-func-articles.php', '21.12', 0),
('8a82a00052171a617cbc689128a7f673', './modules/mod-func-assistant.php', '21.12', 0),
('7bf7c14d5899419ce014cd115b16de6f', './modules/mod-func-blog_last_comments.php', '21.12', 0),
('d70165f304120e2cc555239a8b3a2c0c', './modules/mod-func-breadcrumb.php', '21.12', 0),
('730e6ffdd50f11e9249321216dcbc0a3', './modules/mod-func-breadcrumbs.php', '21.12', 0),
('2726268503ee24de030590304e431d8b', './modules/mod-func-calendar_new.php', '21.12', 0),
('f2e6b5dddd3177892d8f562201773b7d', './modules/mod-func-cart.php', '21.12', 0),
('99f371ac5dc137943957f78640c3a6da', './modules/mod-func-categories.php', '21.12', 0),
('3ee65a92e60f2cde9d7947d965d51c1f', './modules/mod-func-category_transition.php', '21.12', 0),
('acd3aafe419e14c39a31da5a877c3a67', './modules/mod-func-change_category.php', '21.12', 0),
('3e6c35f8668ee26c3631944fbe2821b3', './modules/mod-func-collapse.php', '21.12', 0),
('97e542ffd0140e647c3a651321f0d995', './modules/mod-func-comm_received_objects.php', '21.12', 0),
('f844cd04a5db70d542e622694ea84258', './modules/mod-func-contributors.php', '21.12', 0),
('8270a6b5d9f788402b606192795d5bdb', './modules/mod-func-credits.php', '21.12', 0),
('64a2f4dee16fc5e27b3111831dd17076', './modules/mod-func-directory_last_sites.php', '21.12', 0),
('61a1d728155177bb015097f3073d421c', './modules/mod-func-directory_stats.php', '21.12', 0),
('cb9baed9cdde0bb43fb7600bc225e920', './modules/mod-func-directory_top_sites.php', '21.12', 0),
('137e040553f06e13e0a89981ee457391', './modules/mod-func-domain_password.php', '21.12', 0),
('a6c3ad93737ac8c1c72749958dec5b57', './modules/mod-func-facebook.php', '21.12', 0),
('188c16d37ed7fbf44761dae62789611a', './modules/mod-func-featured_links.php', '21.12', 0),
('a436e0a40dac60a18d4b88dccaada349', './modules/mod-func-file_galleries.php', '21.12', 0),
('25c5b677d38b914f459e61479d4f16c4', './modules/mod-func-forums_best_voted_topics.php', '21.12', 0),
('71eb416a3fa397acdb9823602bc81509', './modules/mod-func-forums_last_posts.php', '21.12', 0),
('00a414cbb484a4603b5609a105887e0a', './modules/mod-func-forums_most_commented_forums.php', '21.12', 0),
('78c1da13e0f11f22ee797b378c7eaf15', './modules/mod-func-forums_most_read_topics.php', '21.12', 0),
('52e18a3da19d1ef25474926a1979b2bf', './modules/mod-func-forums_most_visited_forums.php', '21.12', 0),
('655c296ca5ecb7f271fcef96858127a2', './modules/mod-func-freetag.php', '21.12', 0),
('8cbfda94f67694ee98aaebf1d1d658f0', './modules/mod-func-freetags_current.php', '21.12', 0),
('e4a683f79e1bc998f64c61a9810ac21e', './modules/mod-func-freetags_morelikethis.php', '21.12', 0),
('a8d556c4e736bc13406da6eefa31aecb', './modules/mod-func-freetags_most_popular.php', '21.12', 0),
('41fc186e41e4b9024a9b5582ffc4e881', './modules/mod-func-freetags_prefered.php', '21.12', 0),
('71095bd704959cadfc93f066b79556f8', './modules/mod-func-friend_list.php', '21.12', 0),
('2019c112cfdd4917482246b7a302443d', './modules/mod-func-git_detail.php', '21.12', 0),
('c49bda1f69335de16fae4b26bc32f768', './modules/mod-func-google.php', '21.12', 0),
('64a1cb614d2a6c5eb383cdac550e8c4f', './modules/mod-func-groups_emulation.php', '21.12', 0),
('625baae3a4b5a26db34d70894e3b4dba', './modules/mod-func-last_actions.php', '21.12', 0),
('fe4cd54a4e45934feecf081d6836e72d', './modules/mod-func-last_blog_posts.php', '21.12', 0),
('389e0796c58698e98d76651db3d7d164', './modules/mod-func-last_category_objects.php', '21.12', 0),
('947e78d71eeeff5d2bfa3db8dd23c8b2', './modules/mod-func-last_created_blogs.php', '21.12', 0),
('0d1040c89750d1f98131f14d172a2e55', './modules/mod-func-last_created_faqs.php', '21.12', 0),
('b14181d1308d2cba4fd8954a6211806f', './modules/mod-func-last_created_quizzes.php', '21.12', 0),
('f21681e27feecbb617c012f3c1e503f9', './modules/mod-func-last_file_galleries.php', '21.12', 0),
('b089c3e0516ca2e1bbe47c3f37a3d6f2', './modules/mod-func-last_files.php', '21.12', 0),
('b978f6d9e917618b60ac3cd3bdefc2cf', './modules/mod-func-last_image_galleries.php', '21.12', 0),
('0ae714ae06a9b2bfe0552697bb9e7712', './modules/mod-func-last_images.php', '21.12', 0),
('0ea48100aeb915907f4a8614ba68d464', './modules/mod-func-last_modif_events.php', '21.12', 0),
('4e0b65e0293447ecfc30b40a9ba53b05', './modules/mod-func-last_modif_pages.php', '21.12', 0),
('c7c56e8babac6fed2df7cf6bbea1dbb3', './modules/mod-func-last_modified_blogs.php', '21.12', 0),
('c4072c58d2a4f02ecb54360fa109ba9e', './modules/mod-func-last_podcasts.php', '21.12', 0),
('7e47a9ff6d636b7c40f6f27eaeac409e', './modules/mod-func-last_submissions.php', '21.12', 0),
('d05288c31c57b23e32189dde03fa7954', './modules/mod-func-last_tracker_comments.php', '21.12', 0),
('d43e924a256f6305cc0ddc8f0675a3f0', './modules/mod-func-last_tracker_items.php', '21.12', 0),
('92cf05c4433d71483fff3030a13f2e3a', './modules/mod-func-last_validated_faq_questions.php', '21.12', 0),
('2cdb885a88683be6db7cbfbf6d7d3463', './modules/mod-func-last_visitors.php', '21.12', 0),
('8fd4da52646dd44463a0807a3c98e400', './modules/mod-func-last_youtube_playlist_videos.php', '21.12', 0),
('4f3499514819369ea12bf4b96f18472b', './modules/mod-func-live_support.php', '21.12', 0),
('02496719f87c96c05bedac2a95d4d22d', './modules/mod-func-loadstats.php', '21.12', 0),
('7c073690498ca158d922aa214a70cfde', './modules/mod-func-locator.php', '21.12', 0),
('870098a2e92ebaed993cc0d19ece408d', './modules/mod-func-login_box.php', '21.12', 0),
('5925764fecbebc097f4dd377920835ee', './modules/mod-func-logo.php', '21.12', 0),
('d1cc80c9eddae9c65c2e35dab32a210b', './modules/mod-func-map_edit_features.php', '21.12', 0),
('e5cde7479b19a3f795b9bad3908b4065', './modules/mod-func-map_layer_selector.php', '21.12', 0),
('9b8fd7f3cb6feb51277f6cba0d8ff8aa', './modules/mod-func-map_mode_selector.php', '21.12', 0),
('7c992c091662ab5e3afd45db83e1e0a2', './modules/mod-func-map_search_location.php', '21.12', 0),
('1188fb1612606eb66c71f27a1f0fee90', './modules/mod-func-menu.php', '21.12', 0),
('80045da6e2e1134dcfa97845710088a4', './modules/mod-func-menupage.php', '21.12', 0),
('710b6cc8daba1ea025d1e2ff0cf3cd06', './modules/mod-func-menustructure.php', '21.12', 0),
('e65856fef2d7135c684d8c868c1fe844', './modules/mod-func-messages_unread_messages.php', '21.12', 0),
('a29ccc03da5974dbf1da178ccc8550e0', './modules/mod-func-minichat.php', '21.12', 0),
('bf4029d9b579f3038e8620c2a83af017', './modules/mod-func-mobile.php', '21.12', 0),
('c91f3a418ef8a1dfd0f046a20cb5b2d3', './modules/mod-func-months_links.php', '21.12', 0),
('1105b536ccad33fa292ec8ba161645d7', './modules/mod-func-most_commented.php', '21.12', 0),
('357e86575ee5a1ba21eb405da0659c4d', './modules/mod-func-mustread.php', '21.12', 0),
('c60163bd5bfb94b45d9b0037990feca5', './modules/mod-func-notificationlink.php', '21.12', 0),
('c5415bce564460aa9896e521c8ba9c7e', './modules/mod-func-num_submissions.php', '21.12', 0),
('27c2e8d031287e8a5006f529965190e0', './modules/mod-func-old_articles.php', '21.12', 0),
('9a3a988b13ee98dc1e54c860b2156482', './modules/mod-func-package.php', '21.12', 0),
('71f21563783ce8dd7b4156d262b98d9f', './modules/mod-func-payment_outstanding.php', '21.12', 0),
('f52142b502656a3a0f7decf41b7b0eea', './modules/mod-func-permissions.php', '21.12', 0),
('4974b831fb8e27205e1debf05a887292', './modules/mod-func-perspective.php', '21.12', 0),
('248b414e74025ea417ce671906d1d8ad', './modules/mod-func-poweredby.php', '21.12', 0),
('04c7b1756b45c53bf6018e75b212da2c', './modules/mod-func-quick_edit.php', '21.12', 0),
('c50a36966cd16087ceb220c11bd6d1e2', './modules/mod-func-quick_search.php', '21.12', 0),
('8077e67d50cfa948460cb57feb466fd3', './modules/mod-func-quickadmin.php', '21.12', 0),
('f9feb3feb65af000b44c6ad17facf686', './modules/mod-func-random_images.php', '21.12', 0),
('3264d714a84ee310fbe8bc48995ff1a3', './modules/mod-func-random_pages.php', '21.12', 0),
('daba7d8744e51295555f3f3b8993058b', './modules/mod-func-register.php', '21.12', 0),
('bbf91e3e73310134ad5d65aab2bafb64', './modules/mod-func-rsslist.php', '21.12', 0),
('ff8feb9af5eb2365dc40a4159e51a350', './modules/mod-func-search.php', '21.12', 0),
('2eb2eec0c71c46b4f0db81b664eba36f', './modules/mod-func-search_morelikethis.php', '21.12', 0),
('f2a2729e7391755693b7fa4c08753dbf', './modules/mod-func-search_wiki_page.php', '21.12', 0),
('59d57b3428e4112cf81f05d0ec5ad834', './modules/mod-func-semantic_links.php', '21.12', 0),
('a138d8537d6857b05fc945634d655eaf', './modules/mod-func-share.php', '21.12', 0),
('cee4ec78b1b2658b7d38d82029dcce2f', './modules/mod-func-short_url.php', '21.12', 0),
('9e60eb6e4c8ae85cb819395f8d78ef3b', './modules/mod-func-shoutbox.php', '21.12', 0),
('daf0c3bf1a6ddd236940b8513658c15c', './modules/mod-func-since_last_visit.php', '21.12', 0),
('68ba7e6678c4978279bea23e04b2195a', './modules/mod-func-since_last_visit_new.php', '21.12', 0),
('876ef35b30226ec48bd825e0830aa7aa', './modules/mod-func-svnup.php', '21.12', 0),
('0df446f741bab8d6e6405fad29408e30', './modules/mod-func-switch_lang.php', '21.12', 0),
('1f317684212c20421f8cd69635f54abe', './modules/mod-func-switch_lang_admin.php', '21.12', 0),
('ad45b47a074e9be33a86b9493d68a08e', './modules/mod-func-switch_theme.php', '21.12', 0),
('ea19a428a24f21cb80924cf3427d9d6a', './modules/mod-func-terminology.php', '21.12', 0),
('f253c2b45ae94ab0ffe48428c9dd7dcb', './modules/mod-func-tikitests.php', '21.12', 0),
('81ba596cbc9091b30333880cc30809d0', './modules/mod-func-top_active_blogs.php', '21.12', 0),
('bda024387fc7fe57f6e2906a2d3051f6', './modules/mod-func-top_articles.php', '21.12', 0),
('e8656d0def84ab739f9db5ddc055c2cc', './modules/mod-func-top_blog_posters.php', '21.12', 0),
('e9086db5b9833aff9bd1ef6d13a561ce', './modules/mod-func-top_file_galleries.php', '21.12', 0),
('bd8b895a23c149e23ba76c74771ae005', './modules/mod-func-top_files.php', '21.12', 0),
('27b1b3a3474186e9361bcedf3aa3c4b8', './modules/mod-func-top_forum_posters.php', '21.12', 0),
('9e6fcf3a1fb6dedeeb5112427f441e52', './modules/mod-func-top_image_galleries.php', '21.12', 0),
('1ba58cf4343af766d0fa2aae3d8cfafe', './modules/mod-func-top_images.php', '21.12', 0),
('73e657f2733720e76f62c19ee2ea31d7', './modules/mod-func-top_objects.php', '21.12', 0),
('d5fc3cca3df6ae709fe0040df2caa172', './modules/mod-func-top_pages.php', '21.12', 0),
('94801fbf942cd66f6cb9af77772dd31d', './modules/mod-func-top_quizzes.php', '21.12', 0),
('25edf3d653ac72a7c8a7dceb89e1ff82', './modules/mod-func-top_visited_blogs.php', '21.12', 0),
('ff997d500cc83a218f412cd57739cf20', './modules/mod-func-top_visited_faqs.php', '21.12', 0),
('4a647376bf07cff6e6d1b234bcbddcb8', './modules/mod-func-tracker_input.php', '21.12', 0),
('17d2c848c11cef4c063515f0f71b743d', './modules/mod-func-trackerhelp.php', '21.12', 0),
('28aa5b3966b112b079d8b7293e991a42', './modules/mod-func-translation.php', '21.12', 0),
('3ba45b052c27e87e4477846b783483eb', './modules/mod-func-twitter.php', '21.12', 0),
('25d2ffde7232246fd6d0bc5deda2abc3', './modules/mod-func-upcoming_events.php', '21.12', 0),
('9c1f5125b4034b83652705f596864146', './modules/mod-func-user_blogs.php', '21.12', 0),
('3ab650fbe959f1b17a765f6a3a0c5f29', './modules/mod-func-user_bookmarks.php', '21.12', 0),
('f1b8e42d41fcfd5d2726c4ee6e469bc5', './modules/mod-func-user_image_galleries.php', '21.12', 0),
('c40d7a1df2f61ff00cd800aea4e56e13', './modules/mod-func-user_pages.php', '21.12', 0),
('22e115d8d6c54942ebf0c9722243346e', './modules/mod-func-user_tasks.php', '21.12', 0),
('a1923b5efc44ac0ef2e6642ebc622959', './modules/mod-func-user_tasks_public.php', '21.12', 0),
('b48de505c3914ad100d2bf5b083ce9b2', './modules/mod-func-usergroup_tracker.php', '21.12', 0),
('58815f81ed920e44713d95be9f647d73', './modules/mod-func-users_list.php', '21.12', 0),
('9d54c13ae248ac523e149a7440977788', './modules/mod-func-users_own_rank.php', '21.12', 0),
('6a197075c97569c67fd353e9bff145b2', './modules/mod-func-users_rank.php', '21.12', 0),
('a9e7970d0c0cfec783672150d9787287', './modules/mod-func-websearch.php', '21.12', 0),
('1137a176c28f7134c916146e7d68f459', './modules/mod-func-whats_related.php', '21.12', 0),
('e741c83a95f5279fe2812317304bb1f7', './modules/mod-func-who_is_there.php', '21.12', 0),
('bcfa92ac7b230af0ace0aee7956c1cad', './modules/mod-func-wiki_last_comments.php', '21.12', 0),
('573bae5821cab6ae3250cd6fb68e81ae', './modules/mod-func-xmpp.php', '21.12', 0),
('2202f9714845701349881bc6615914f6', './modules/mod-func-youtube.php', '21.12', 0),
('cb20b7d1a376770dc28f9a5aea7c2e90', './modules/mod-func-zone.php', '21.12', 0),
('93b7cbb8456ad1d6fcacb02125214c5e', './modules/mod-func-zotero.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/check.php', '21.12', 0),
('9883feeca6c27603d6437b9dc45bdd16', './permissioncheck/create_new_htaccess.php', '21.12', 0),
('817caae7d55dbd1a62e310f694e5b250', './permissioncheck/functions.inc.php', '21.12', 0),
('fbbb522882b004334a31d25e436ed6e0', './permissioncheck/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/insane/check.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/mixed/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/mixed/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/morepain/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/morepain/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/moreworry/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/moreworry/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/pain/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/pain/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/paranoia-suphp/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/paranoia-suphp/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/paranoia/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/paranoia/index.php', '21.12', 0),
('733037f30195dbeee021b8b8fbcbb6c8', './permissioncheck/permission_granted.inc.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/risky/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/risky/index.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/sbox/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/sbox/index.php', '21.12', 0),
('0d1064f8748d89516590ce770dc3ed93', './permissioncheck/usecases.inc.php', '21.12', 0),
('15b78649d814e9c488e36c311f1bbea2', './permissioncheck/worry/check.php', '21.12', 0),
('b7356fc0f370ecc73663f54d36c4902f', './permissioncheck/worry/index.php', '21.12', 0),
('309200367a6b80be9f07337e3f6f5909', './poll_categorize.php', '21.12', 0),
('9da8bf7b217bf8c18890d5f1e3a65798', './received_article_image.php', '21.12', 0),
('929a0442e571017ca0f2968e95e0e8fe', './references.php', '21.12', 0),
('6971d78a5a25ad6ae8af9170f35304fa', './reindex_file.php', '21.12', 0),
('43ec4684b862b57dd837765432eab296', './remote.php', '21.12', 0),
('ac150dba4c268a59979dc2ef13107ec6', './route.php', '21.12', 0),
('3d885cf8fb4dc4490e6c03b9aabc7558', './select_banner.php', '21.12', 0),
('00b7fab516dd291673df21ba0100f5bb', './show_image.php', '21.12', 0),
('5e70372c86acc77c4b577c2e59be2822', './snarf_ajax.php', '21.12', 0),
('42af1b8e7412d7006fbd725a39365716', './storage/index.php', '21.12', 0),
('7dee02b08f61f79ee1005517e938f290', './storage/public/index.php', '21.12', 0),
('aac69a497f51e0fa3eaeff7510053946', './sw.js', '21.12', 0),
('e98f2aed0a61d00410be5916109da28e', './templates/access/confirm.tpl', '21.12', 0),
('d4de41db5c7e43cc32f8c1225d38eeb5', './templates/access/confirm_select.tpl', '21.12', 0),
('6ee2655a0ab8f134fd1ee751436b3178', './templates/access/include_extra_fields.tpl', '21.12', 0),
('21600c9b143944d1d0586b9c89ade4b9', './templates/access/include_hidden.tpl', '21.12', 0),
('2130e0ef21977dbf1a85c8d1c713441f', './templates/access/include_items.tpl', '21.12', 0),
('da0f8a80c6e7b68b7b3a1bd36745c4c4', './templates/access/include_submit.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/access/index.php', '21.12', 0),
('eb5b33b9de71c0baab53579dd062dff6', './templates/activity/activityframe.tpl', '21.12', 0),
('fb101462d8b06feb4c3a6d96ddff7bbe', './templates/activity/activitystream.tpl', '21.12', 0),
('137c3f826cb234690847f0efac30f44e', './templates/activity/default_event.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/activity/index.php', '21.12', 0),
('b471295b0970a9822543581c113cd7c3', './templates/activity/tiki.comment.post.tpl', '21.12', 0),
('b471295b0970a9822543581c113cd7c3', './templates/activity/tiki.comment.reply.tpl', '21.12', 0),
('af665cc297ae64c3d4be2e7550344e07', './templates/activity/tiki.forumpost.create.tpl', '21.12', 0),
('e61bcebc92da695ca5f066657c996d80', './templates/activity/tiki.forumpost.reply.tpl', '21.12', 0),
('70b09a747021a1336e072ada35bef454', './templates/activity/tiki.forumpost.update.tpl', '21.12', 0),
('f8d29662f9fc323b38c443b3da96c8e9', './templates/activity/tiki.mustread.required.tpl', '21.12', 0),
('e174b8a16842c1133db03b4b53f4364f', './templates/activity/tiki.query.critical.tpl', '21.12', 0),
('cc6affee88486b5f450957bb4f77da09', './templates/activity/tiki.query.high.tpl', '21.12', 0),
('100da4e5fcc4c4416fd109d1cc268408', './templates/activity/tiki.query.low.tpl', '21.12', 0),
('8cade1f8006cca0017bd93e43c983433', './templates/activity/tiki.recommendation.incoming.tpl', '21.12', 0),
('748258db71c382f78aa535eb7d136c87', './templates/activity/tiki.tracker.create.tpl', '21.12', 0),
('86c8ba04daf8bd992903530af8a01f53', './templates/activity/tiki.trackeritem.create.tpl', '21.12', 0),
('0b57a2638d8cc3066ec1c3f59d289f3a', './templates/activity/tiki.trackeritem.update.tpl', '21.12', 0),
('0e665e0873c88b2fd9504c46e97ad82c', './templates/activity/tiki.user.follow.add.tpl', '21.12', 0),
('77490102a3675d9fed0a518d981c7d5c', './templates/activity/tiki.user.follow.incoming.tpl', '21.12', 0),
('30c00cbe62e47516be0590006d60f610', './templates/activity/tiki.user.friend.add.tpl', '21.12', 0),
('9bea8d48c0a54f873a8524a018cca99f', './templates/activity/tiki.wiki.create.tpl', '21.12', 0),
('e2ae0be1c92d6db8f91c7dd72bd417c6', './templates/activity/tiki.wiki.update.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/activitystream/index.php', '21.12', 0),
('22e6e52c4b7d537abbe651dca2014e9b', './templates/activitystream/render.tpl', '21.12', 0),
('720ffe37007d7fc682bbae508a84af42', './templates/addreference.tpl', '21.12', 0),
('6e2d00b84ac4a739e5b8a8fba7ab4769', './templates/admin/admin_navbar.tpl', '21.12', 0),
('4f69859dd3db5dd9853f7a5a6efc1abd', './templates/admin/admin_navbar_menu.tpl', '21.12', 0),
('bb205b2f2e51d64658dc1675e928d094', './templates/admin/include_ads.tpl', '21.12', 0),
('90006858f863cb6ae3b98f133ae82aea', './templates/admin/include_anchors.tpl', '21.12', 0),
('286384fb32cba1453b29d63f39be667c', './templates/admin/include_apply_bottom.tpl', '21.12', 0),
('fce665ad4bf3befe13bb53a273765af5', './templates/admin/include_apply_top.tpl', '21.12', 0),
('91212ea32c45bce5f3f274516dfb3c5e', './templates/admin/include_articles.tpl', '21.12', 0),
('e8a386d4d9af8b4baf8dec4be07d9e99', './templates/admin/include_blogs.tpl', '21.12', 0),
('61f05ebe688962b6a7c4055f92df1074', './templates/admin/include_calendar.tpl', '21.12', 0),
('f3e0acee3eaf3720ee944234cf4a32e5', './templates/admin/include_category.tpl', '21.12', 0),
('2693a2fea3904af4026cd585abc129c2', './templates/admin/include_comments.tpl', '21.12', 0),
('906030a74bddaa0f3396b4ae354b4154', './templates/admin/include_community.tpl', '21.12', 0),
('2f3b82459c784b914b05599c3931979a', './templates/admin/include_connect.tpl', '21.12', 0),
('ea63d567e5addc6f8d4be46b5449e897', './templates/admin/include_copyright.tpl', '21.12', 0),
('6742743d57e1115f79dd98ffe7ee494f', './templates/admin/include_directory.tpl', '21.12', 0),
('e4c885cadf7efaa6c3cc84a1aa137b74', './templates/admin/include_extension_package_inactive.tpl', '21.12', 0),
('bc126bb71fc2096a9e9b12e1b2c206c9', './templates/admin/include_extension_package_missing_page.tpl', '21.12', 0),
('a10a7781a6f095e37b8f6e3bc0bec51e', './templates/admin/include_faqs.tpl', '21.12', 0),
('51a1bcef423c497788bb5af30537c4de', './templates/admin/include_features.tpl', '21.12', 0),
('f2710e50760497165273aafe03218292', './templates/admin/include_fgal.tpl', '21.12', 0),
('acddce12bb6a6c418c86092bb49e6c40', './templates/admin/include_forums.tpl', '21.12', 0),
('652898a11c1f66d335045ff5984641c8', './templates/admin/include_freetags.tpl', '21.12', 0),
('76ab23f0217125f61f17387e8f0b129c', './templates/admin/include_gal.tpl', '21.12', 0),
('d76c8e39f6d6e5b94b8830e6fd83b3f2', './templates/admin/include_general.tpl', '21.12', 0),
('426f92bc500556091b6fa08a041a5525', './templates/admin/include_i18n.tpl', '21.12', 0),
('98156ce22ebaa64a27db7714d6186e57', './templates/admin/include_intertiki.tpl', '21.12', 0),
('d872a5a32f0fdce019285dbcb1cc1889', './templates/admin/include_list_sections.tpl', '21.12', 0),
('6b81b44a96601bdf9183d2c2c2c8436c', './templates/admin/include_login.tpl', '21.12', 0),
('c7f2c2f7e9a35b374cf03dec1217da55', './templates/admin/include_look.tpl', '21.12', 0),
('0f53c5c712b2ef3738a47d4c9e94add7', './templates/admin/include_maps.tpl', '21.12', 0),
('6f471ce3a4a0076746886331a63a8d46', './templates/admin/include_messages.tpl', '21.12', 0),
('589ae4f2b2c327f155e481bc8e444c3c', './templates/admin/include_metatags.tpl', '21.12', 0),
('99cf40299edfade660c0b0a506a1715e', './templates/admin/include_module.tpl', '21.12', 0),
('b068fd1fbe9b4b3e1a53286e4def6b2d', './templates/admin/include_packages.tpl', '21.12', 0),
('7efbdabe8ba0fac8a1a7be05bea627d5', './templates/admin/include_payment.tpl', '21.12', 0),
('a7a0ef378a532a9ba8cbff2d54606f7e', './templates/admin/include_performance.tpl', '21.12', 0),
('8c574f87a9a3f0bef96dd6f3652842bf', './templates/admin/include_polls.tpl', '21.12', 0),
('00f92744e12e39f29442446332ddfccb', './templates/admin/include_print.tpl', '21.12', 0),
('a07562620594f962cdff90658529f74b', './templates/admin/include_profiles.tpl', '21.12', 0),
('fddd718da51aeaf2b96c1f468224a10b', './templates/admin/include_profiles_preview.tpl', '21.12', 0),
('bdf243a2ccf3f4325fcdacfc18d540b8', './templates/admin/include_rating.tpl', '21.12', 0),
('901d4a43ad4c0000695d6c60f05c5a93', './templates/admin/include_rss.tpl', '21.12', 0),
('2075c149c2a531244c3822892ac5feeb', './templates/admin/include_rtc.tpl', '21.12', 0),
('45540a0011800dcff56796577cdedccb', './templates/admin/include_score.tpl', '21.12', 0),
('62ac9cdb15189d1ff6475193f96366a5', './templates/admin/include_search.tpl', '21.12', 0),
('fb0456a9f4d30008208ca306a18895c0', './templates/admin/include_search_report_string_in_db.tpl', '21.12', 0),
('643adcdcc8e2d8298e4ce4a9c61e9596', './templates/admin/include_security.tpl', '21.12', 0),
('a9bc85b5461b340adc9d25e3ccbff3ce', './templates/admin/include_sefurl.tpl', '21.12', 0),
('b8941d64880b7a4284a95c690fbe36f1', './templates/admin/include_semantic.tpl', '21.12', 0),
('d38738d73137978077f6f88ec323608e', './templates/admin/include_share.tpl', '21.12', 0),
('1684c62c11a555f666427eb1c832a3a3', './templates/admin/include_socialnetworks.tpl', '21.12', 0),
('b0fc3d16933e46bdc4131ac5a06980d8', './templates/admin/include_stats.tpl', '21.12', 0),
('4805c9cc1fdf0a1085e3d7b8ea21a1bf', './templates/admin/include_textarea.tpl', '21.12', 0),
('b1c71173fb7e35e1b2f655730e966e37', './templates/admin/include_trackers.tpl', '21.12', 0),
('8a622175c72a786acc46a0448cdd3559', './templates/admin/include_user.tpl', '21.12', 0),
('8637e04fb6eccd4af8153df8091ff6a8', './templates/admin/include_video.tpl', '21.12', 0),
('ef2829c0d13fbaf546e9b828b8213a1a', './templates/admin/include_webservices.tpl', '21.12', 0),
('4d8ba2cf59f62c0d7b796ac2323d11fe', './templates/admin/include_wiki.tpl', '21.12', 0),
('14230f44f513cb3a381af3cd9f7d5da5', './templates/admin/include_wikiatt.tpl', '21.12', 0),
('a14a4872c67f7a211aaf7f5a58363968', './templates/admin/include_workspace.tpl', '21.12', 0),
('9bfa8bad710a0d9b74164639b0bf48d8', './templates/admin/include_wysiwyg.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/admin/index.php', '21.12', 0),
('9412f61f427d51c1b6e1d4f3a9996fd6', './templates/admin_modules_form.tpl', '21.12', 0),
('c5dbef2a3042af35fa213a97ea8ea23c', './templates/antibot.tpl', '21.12', 0),
('ad040e7ced6eb5286be4a2fc3c85f632', './templates/article-teaser.tpl', '21.12', 0),
('e559b3b50b2140feda3bc15317ef5476', './templates/article.tpl', '21.12', 0),
('ca795ced1ff4a743c7cc79db2c2c11b2', './templates/article/create_from_url.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/article/index.php', '21.12', 0),
('3e8e7d7c54414037dbe30a3e14f9752a', './templates/article_trailer.tpl', '21.12', 0),
('5b5c84f6243527c2283cc861eafd656b', './templates/attachments.tpl', '21.12', 0),
('bee2d292bad4f8fc8db93d269cf8c339', './templates/attachments_tracker.tpl', '21.12', 0),
('db3797dfd3d171651a95521fd8fc521b', './templates/blog_actions.tpl', '21.12', 0),
('2a3d7f7764c8fe4b536dba18112a4da3', './templates/blog_heading.tpl', '21.12', 0),
('b20f9f5a410adf18e2171c3dc3ad6d0b', './templates/blog_post_actions.tpl', '21.12', 0),
('e0e6494a1df88e8abb474a8acdbef1db', './templates/blog_post_author_info.tpl', '21.12', 0),
('fc57ed0d0b94f5459a3842d782f9640a', './templates/blog_post_heading.tpl', '21.12', 0),
('fdc33c38433f649934a5d4724843c08c', './templates/blog_post_navigation.tpl', '21.12', 0),
('bfa89292a9b13a6059d433b5422ee01a', './templates/blog_post_postbody_content.tpl', '21.12', 0),
('964e7598a9472c30e18534d24e78974a', './templates/blog_post_postbody_title.tpl', '21.12', 0),
('bbcdd01ea8c272bd3c0c534cc78ac26a', './templates/blog_post_related_content.tpl', '21.12', 0),
('3a3be639f47730eb48181208df7c3733', './templates/blog_post_status.tpl', '21.12', 0),
('9fb11910d9958156341c21999614b4b8', './templates/blog_wrapper.tpl', '21.12', 0),
('3380c92606ca478ed0c2a232d46d6243', './templates/bootstrap_menu.tpl', '21.12', 0),
('512a4ef672515351ec57750cb6fee754', './templates/bootstrap_menu_navbar.tpl', '21.12', 0),
('fac680b683ec570c4289b3eb6d978e60', './templates/bootstrap_menu_navbar_children.tpl', '21.12', 0),
('c62e8f7d3524fd6e71224cc4ae3fe59d', './templates/browse_file_gallery.tpl', '21.12', 0),
('3517f3ad069aa56cf54649907f186aa6', './templates/browsedcategory.tpl', '21.12', 0),
('bc974daf50ede61400d45f38ac8f62e4', './templates/calendar.tpl', '21.12', 0),
('4dc1db4ad9848ea0ed3b10ca1f32b8e3', './templates/canonical.tpl', '21.12', 0),
('2a30ba00481a7345eaa776cc34b49222', './templates/categobjects.tpl', '21.12', 0),
('0ed9d9e33fb56ff6da310a814f74a55d', './templates/categobjects_title.tpl', '21.12', 0),
('e1d8e41a04421adc2dfa73b7ddd206d9', './templates/categorize.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/category/index.php', '21.12', 0),
('9c1c640b10412583aedacbf3d703ecef', './templates/category/select.tpl', '21.12', 0),
('e660692bad5b300bff76a4ff79376ea6', './templates/category_related_objects.tpl', '21.12', 0),
('d48c011b6c7039d54f42eba8f0eafd1d', './templates/category_tree_entry.tpl', '21.12', 0),
('0ea45b926f348c5663b959a6bda9ddde', './templates/categpath.tpl', '21.12', 0),
('4efa3e18541ff4a677e45a309d614334', './templates/comment-body.tpl', '21.12', 0),
('e115d2c70653cbaa46dd97a668c0dd40', './templates/comment-footer.tpl', '21.12', 0),
('8b1404560820a94c64970b805751ce11', './templates/comment-header.tpl', '21.12', 0),
('ee59909338f5f876b62a98e2d2c98ebd', './templates/comment.tpl', '21.12', 0),
('549432aa87f60101160c999c1380bc91', './templates/comment/archive.tpl', '21.12', 0),
('01f6da3b5983b90524d5b4accd11f643', './templates/comment/deliberation_item.tpl', '21.12', 0),
('79eb0772f875e5de62fba4cf035c94a2', './templates/comment/edit.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/comment/index.php', '21.12', 0),
('d2359d3974b7f623f190b0767760cb24', './templates/comment/list.tpl', '21.12', 0),
('590dc40f308257449b3a04415f419ef4', './templates/comment/list_inner.tpl', '21.12', 0),
('5f39ad3c8223c0578528ae72a689141f', './templates/comment/lock.tpl', '21.12', 0),
('fe0893902449f68a3fd819323823707b', './templates/comment/moderate.tpl', '21.12', 0),
('84f971e1c9c067349c585489d4fe9c43', './templates/comment/post.tpl', '21.12', 0),
('8e8bbd9d469862d5d4ce9d519dfdb71c', './templates/comment/remove.tpl', '21.12', 0),
('e0ba7342b27f6467b8f699e5d53abeb5', './templates/comment/unlock.tpl', '21.12', 0),
('59740e34da23b25f4f7ac90a420056e8', './templates/comments.tpl', '21.12', 0),
('b90a78ad5b007a09d8dbd6794c2e74bf', './templates/comments_button.tpl', '21.12', 0),
('fffdffc78ff9453a097c9919c3401fd8', './templates/confirm.tpl', '21.12', 0),
('bf23a1e8bfb62faaeac87e051119deff', './templates/contribution.tpl', '21.12', 0),
('cc9d7d4db85fb64af6520fe05b9d49ef', './templates/cookie_consent.tpl', '21.12', 0),
('9b813b7418d62911f7fd74fe9e5582de', './templates/copyrights.tpl', '21.12', 0),
('cd1487635fa62ce3b629d6a63de52fe0', './templates/credits.tpl', '21.12', 0),
('070ce7f6adc64f94fdf99ff09887eab0', './templates/currency_output.tpl', '21.12', 0),
('23309d7b6dcdc0b3b990353da875c446', './templates/customroute/remove.tpl', '21.12', 0),
('55cace05c1c23b7e31b605bdb59b868d', './templates/database-connection-error.tpl', '21.12', 0),
('4f30f511481dbe305a0e8a2f4b6e7cf3', './templates/debug/function.debugger.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/debug/index.php', '21.12', 0),
('a776b2e70849cc39903176b5dce1ec97', './templates/debug/tiki-debug_console_help.tpl', '21.12', 0),
('ae2e55af5085eb36d42f256b90e3b074', './templates/debug/tiki-debug_console_tab.tpl', '21.12', 0),
('effb4200f0eab550eac97606e9e9170b', './templates/debug/tiki-debug_dmsg_tab.tpl', '21.12', 0),
('40d847ff26d0e3884b7fdb7d3fc28e51', './templates/debug/tiki-debug_features.tpl', '21.12', 0),
('6ed3735ba53b34af9660b3524b6df3a4', './templates/debug/tiki-debug_permissions.tpl', '21.12', 0),
('3bba6f5a56e238f8856be8c91d03531d', './templates/debug/tiki-debug_tikitables.tpl', '21.12', 0),
('f4c90857741d98a22c23a84af2339a37', './templates/debug/tiki-debug_watch_tab.tpl', '21.12', 0),
('0987ac0fa9fe82d60879fc2da7c9c246', './templates/discussinforum.tpl', '21.12', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/draw/edit.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/draw/index.php', '21.12', 0),
('f04c6b869e969494e7885ffdf0996565', './templates/duplicate_file_gallery.tpl', '21.12', 0),
('78b5dfb4673dc47e7f3b8aeeeae04653', './templates/edit/help.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/edit/index.php', '21.12', 0),
('af46d9a671e09c84d2dabbc40ba07458', './templates/edit/inline_dialog.tpl', '21.12', 0),
('0cb34a9c701cf012b604071bb13fa4a0', './templates/edit/preview.tpl', '21.12', 0),
('3959de9d5c4c845c3d3eda44355b57c3', './templates/edit_file_gallery.tpl', '21.12', 0),
('ebcec2483ed7ee944da8c96fb74b0924', './templates/empty.tpl', '21.12', 0),
('e2e2eac02523daf4ae52dd9d03ed186a', './templates/error-ajax.tpl', '21.12', 0),
('30f036288891504a2cd7f1bc85ebcab7', './templates/error.tpl', '21.12', 0),
('eeb800ffacacb8007b9711f35b85c701', './templates/error_raw.tpl', '21.12', 0),
('aa1689eed2fee857b845d46028b5d03c', './templates/error_simple.tpl', '21.12', 0),
('b4ffce13bce220d358d3a3305381183d', './templates/error_ticket.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/examples/index.php', '21.12', 0),
('897dde9c73f854dc347f235ab89081d0', './templates/examples/search/facet_charts.tpl', '21.12', 0),
('8dcd3408c53be0ee14d201b580e3dee7', './templates/examples/search/facet_charts2.tpl', '21.12', 0),
('74651bc83744ba3f227aea96d9eedaf3', './templates/examples/search/facet_checkboxes.tpl', '21.12', 0),
('11262767bc39106197f582a99029fdfd', './templates/examples/shop/add_to_cart.tpl', '21.12', 0),
('fd0bcd8c256b3f15cc1c2e9f9ca0714c', './templates/examples/shop/custom_search_form.tpl', '21.12', 0),
('cbe8c1e8a77e0e3595405b78fd68a85b', './templates/examples/shop/index.php', '21.12', 0),
('5ade29ec5b7c45d531379d23031bf847', './templates/examples/shop/product_ajax.tpl', '21.12', 0),
('b65aa5f03d9b30d5983972c524e39464', './templates/examples/shop/product_item.tpl', '21.12', 0),
('3cea5f4a3a65ff14803d605b7255024d', './templates/examples/shop/product_list.tpl', '21.12', 0),
('10dd5e875973462cbdd10872b682b50a', './templates/examples/shop/product_list_inner.tpl', '21.12', 0),
('a47ecf0499aa4cff7d12feba78c56444', './templates/feedback/action.tpl', '21.12', 0),
('3873a3eaf36b1bbcd25f55fe045c080d', './templates/feedback/default.tpl', '21.12', 0),
('26d64bc65400df7b92130d6a603f826d', './templates/feedback/link.tpl', '21.12', 0),
('38e1027eca099f007265a874b9339630', './templates/feedback/perm.tpl', '21.12', 0),
('9fe13d98c805396a8ba48a49d9241400', './templates/feedback/pref.tpl', '21.12', 0),
('d4bafa8f007063cd70aa6ebadcf95efd', './templates/fgal_attachments.tpl', '21.12', 0),
('371598f83a41339978bd480e37e05264', './templates/fgal_context_menu.tpl', '21.12', 0),
('f3d11c7526b62b82a0d7168dbca7b77e', './templates/fgal_file_link_attributes.tpl', '21.12', 0),
('707d0dbe42d99fadeb89d1c5c84b69f4', './templates/fgal_listing_conf.tpl', '21.12', 0),
('3d13f82c664aa4712e61d373d95c2b22', './templates/fgal_thumbnailframe.tpl', '21.12', 0),
('642a0f2efb018660f88b6ff69ad8c5f9', './templates/fgal_view_page.tpl', '21.12', 0),
('f1ff033afe7ee68ad0f31424f1741fbf', './templates/file/browse.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/file/index.php', '21.12', 0),
('4126bb94dcc9319fd052fbe17c9873d8', './templates/file/jquery_upload.tpl', '21.12', 0),
('6c86cb931d3f7755c9481d58504c53e3', './templates/file/list_gallery.tpl', '21.12', 0),
('07ab76eb0cdb44c2510cb94153337638', './templates/file/remote.tpl', '21.12', 0),
('6e0533e73bbbdd2e60b8754f7ba37107', './templates/file/thumbnail_gallery.tpl', '21.12', 0),
('5b40a0a10a7d5c57981f5ac682c02346', './templates/file/upload.tpl', '21.12', 0),
('04eadcc2c36fee6f5a3812825873358b', './templates/file/uploader.tpl', '21.12', 0),
('d6c2112fdfd2b5f17578ff2c4f85d5f1', './templates/file_backlinks.tpl', '21.12', 0),
('10e306f2795110ce521fcb30b5005e09', './templates/file_displays/diagram.tpl', '21.12', 0),
('795d10321012c36a9d5d0247fbfc8769', './templates/file_displays/pdf.tpl', '21.12', 0),
('656a51aedfca6b1a4a430d97f0fe6cfd', './templates/file_gallery_slideshow.tpl', '21.12', 0),
('def25df2fcb44843f74ef1b084d00472', './templates/file_properties_table.tpl', '21.12', 0),
('0d5b515d25c5ef72964e299c0a75f9c7', './templates/file_selector.tpl', '21.12', 0),
('b995f9b2c4601b385ac0e5ec282c681d', './templates/filter.tpl', '21.12', 0),
('3f964bc395a546a2a2bdfbaf40d88a44', './templates/filter_control/currency_range.tpl', '21.12', 0),
('f74a8c454589768c29fa1c627a233550', './templates/filter_control/date_range.tpl', '21.12', 0),
('19e66a8c5f7752659dfd585041449e1c', './templates/filter_control/drop_down.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/filter_control/index.php', '21.12', 0),
('d6083b6b4715bbfc319ffe37a54b9829', './templates/filter_control/inline_checkboxes.tpl', '21.12', 0),
('a4a0ac9404a3b6f1fcb174aec8dc3bfe', './templates/filter_control/multi_select.tpl', '21.12', 0),
('38f18c66e542ab4ade737d63458a0a2a', './templates/filter_control/numeric_range.tpl', '21.12', 0),
('57fa26807cfee5f38171acf843b24620', './templates/filter_control/text_field.tpl', '21.12', 0),
('629dbd45d0e0fcb27c0f52352938ef46', './templates/find.tpl', '21.12', 0),
('ad0c0854f67f23c8bcdcb9f9f77b2854', './templates/footer.tpl', '21.12', 0),
('d317eaa38e59a3e81f80b848069baa96', './templates/freetag.tpl', '21.12', 0),
('7c2a69cc50504db885b90a474322a40d', './templates/freetag_list.tpl', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('b3559ac421bb4dc02abdbf58f9f982f3', './templates/goal/admin.tpl', '21.12', 0),
('dfc4261164e25c3c6d2a99637cdcda48', './templates/goal/create.tpl', '21.12', 0),
('02a5cca262e2162054fd8546ed1a6a0d', './templates/goal/delete.tpl', '21.12', 0),
('3054cde4689c817432082ef80390757a', './templates/goal/edit.tpl', '21.12', 0),
('f29bbc1d229d13e51868aa38da8785d2', './templates/goal/edit_condition.tpl', '21.12', 0),
('041355258ce88b70a18f9c5036a3dd2e', './templates/goal/edit_eligible.tpl', '21.12', 0),
('9e57594ff779c6bb7cbf12940faca80c', './templates/goal/edit_reward.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/goal/index.php', '21.12', 0),
('a2164710306aa9efb06fcf273134610d', './templates/goal/render_conditions.tpl', '21.12', 0),
('c85495d7bbc8e106fabf0a27b601e11d', './templates/goal/render_rewards.tpl', '21.12', 0),
('55e7485b431dc6aa550f0aa9a007178a', './templates/goal/show.tpl', '21.12', 0),
('4c5e0bfd2e657b9b51a503c343ccc114', './templates/goal/show_list.tpl', '21.12', 0),
('2863f9972904e1a1f2a16bc9d4b17f7f', './templates/h5p/edit.tpl', '21.12', 0),
('e4efce7d23255d733bb8f520a34aeea6', './templates/h5p/embed.tpl', '21.12', 0),
('5d7e0ed4f9d53e9945acd4f989c57b72', './templates/h5p/list_libraries.tpl', '21.12', 0),
('7834e84cc652151689e8c1704ed304b4', './templates/h5p/list_results.tpl', '21.12', 0),
('2b51c5908f45e8f18c233142d76ae1b2', './templates/header.tpl', '21.12', 0),
('d9ee711c1ae48677c22d140830945e13', './templates/iconpickermodal.tpl', '21.12', 0),
('47e6ad5280b6674bdaec9ee9533184e7', './templates/ids/remove.tpl', '21.12', 0),
('50c736bd8e85e2170990c334ed284f28', './templates/index.php', '21.12', 0),
('8b841cd8e62ba82c40636d909947b085', './templates/interactive_translation_box.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/kaltura/index.php', '21.12', 0),
('f1c73667c568cd35d287b5e8c85a6cb1', './templates/kaltura/list.tpl', '21.12', 0),
('5911f108e16875cb10a060c4a35f6723', './templates/kaltura/upload.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/language/index.php', '21.12', 0),
('e6c7593d1200b86b4db070e3c170123e', './templates/language/manage_custom_translations.tpl', '21.12', 0),
('58a211e46739f32824e1bb81392df255', './templates/language/upload.tpl', '21.12', 0),
('a08752ca23cb803752859bb836b8a5bd', './templates/language/write_to_language_php.tpl', '21.12', 0),
('6db3d17e4c80166beaa59999de92c66d', './templates/layout_fullscreen_check.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/layouts/basic/index.php', '21.12', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/basic/layout_edit.tpl', '21.12', 0),
('875596ba65f539c932e6c0ea23e6c180', './templates/layouts/basic/layout_view.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/layouts/classic/index.php', '21.12', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/classic/layout_edit.tpl', '21.12', 0),
('98a57ac69f24b1487196b979eada53f8', './templates/layouts/classic/layout_view.tpl', '21.12', 0),
('946b377cae62ac4d7ce43e32e55a1342', './templates/layouts/classic/module.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/layouts/index.php', '21.12', 0),
('408d4dc572687bb0105de29d1a943c6b', './templates/layouts/internal/ajax.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/layouts/internal/index.php', '21.12', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/internal/layout_edit.tpl', '21.12', 0),
('f010e49d64fa115a23c20e8b761fb589', './templates/layouts/internal/layout_view.tpl', '21.12', 0),
('49b923142d4bbacc338a4cc11a8d8e6a', './templates/layouts/internal/modal.tpl', '21.12', 0),
('4d580079c0f35ad17264558200d541f6', './templates/layouts/layout_plain.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/layouts/social/index.php', '21.12', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/social/layout_edit.tpl', '21.12', 0),
('daac827b2e1e3b3c2a386a447a6b2144', './templates/layouts/social/layout_view.tpl', '21.12', 0),
('4a2a0419dd710f089d6db24089e60c7f', './templates/like.tpl', '21.12', 0),
('a21f7a2d193177567ba8415fdf893b00', './templates/list_file_gallery.tpl', '21.12', 0),
('cafbb19a1b676f233f7e062a1c132ad2', './templates/list_file_gallery_content.tpl', '21.12', 0),
('a72f65e9319c2d243ab45d47b5e2812d', './templates/lists/article-search.tpl', '21.12', 0),
('660283d28af7f4414f55bf223929101a', './templates/lists/articles.tpl', '21.12', 0),
('5455dde928898dfcae1fcd0523da277c', './templates/mail/admin_tiki_checker.tpl', '21.12', 0),
('81c40b3b68ccfe7c27753e3023d3d666', './templates/mail/admin_tiki_checker_subject.tpl', '21.12', 0),
('f0754858f3cd08f7a43b966c6e5dfb77', './templates/mail/blogs_send_link.tpl', '21.12', 0),
('e718393ab561898f4429ecf1a200e75b', './templates/mail/cart_gift_cert.tpl', '21.12', 0),
('e198805eb37e894e999cdb5ef648f539', './templates/mail/cart_gift_cert_subject.tpl', '21.12', 0),
('ca08d8d64a8348eee11fc2d64a895e10', './templates/mail/cart_order_received_anon.tpl', '21.12', 0),
('923db1b975a962ece0ce61b0d214bb79', './templates/mail/cart_order_received_anon_subject.tpl', '21.12', 0),
('811f08e98a17d840eb99e47b803c11c7', './templates/mail/cart_order_received_reg.tpl', '21.12', 0),
('923db1b975a962ece0ce61b0d214bb79', './templates/mail/cart_order_received_reg_subject.tpl', '21.12', 0),
('a9068cd2387f14a9cc0b7b38e8e4d37b', './templates/mail/confirm_newsletter_subscription.tpl', '21.12', 0),
('a346d23ec3d9e894fb676203b9c86e5d', './templates/mail/confirm_user_email.tpl', '21.12', 0),
('23127de6c8836e3984c5e6302f040f8e', './templates/mail/confirm_user_email_after_approval.tpl', '21.12', 0),
('c14036a9f627fe83b2773e96f990765d', './templates/mail/confirm_user_email_after_approval_subject.tpl', '21.12', 0),
('aceeccf9e36362cf7fbff48301908139', './templates/mail/confirm_user_email_subject.tpl', '21.12', 0),
('30171ab9e9bc2fce76b7e3169097b629', './templates/mail/fgal_old_file_deleted.tpl', '21.12', 0),
('dd21bb7eb77f3273b8552398aa8665bb', './templates/mail/fgal_quota_exceeded.tpl', '21.12', 0),
('230cec9ff3427cfd61c92dbb1459b070', './templates/mail/forum_outbound.tpl', '21.12', 0),
('4d56609ab3e758883f08ec510ab600e1', './templates/mail/forum_post_notification.tpl', '21.12', 0),
('3bbc2abb5d26cca5a07d23561fd9ab36', './templates/mail/forum_post_queued_notification.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/mail/index.php', '21.12', 0),
('f7265822802cab7cfd18a8d77def039e', './templates/mail/invite_tempuser.tpl', '21.12', 0),
('38f029db22b43d145d7eae800343c65a', './templates/mail/invite_tempuser_subject.tpl', '21.12', 0),
('217d59d3901efdb270e4ee9bb7b4791f', './templates/mail/mail_invite.tpl', '21.12', 0),
('c031b6c7c19396f8918b9b1b1ef80230', './templates/mail/mail_invite_subject.tpl', '21.12', 0),
('514189f50ec9119d2e435383a7114206', './templates/mail/mailin_reply_subject.tpl', '21.12', 0),
('9c4e6fa61dd846f3bc3f56f8b7fe0138', './templates/mail/mention_notification.tpl', '21.12', 0),
('0d3f14e6547edd89e2f4fc14e3232d83', './templates/mail/mention_notification_subject.tpl', '21.12', 0),
('30ab9c6e354fe17a468ab0c89cec9f96', './templates/mail/messu_message_notification.tpl', '21.12', 0),
('248739d35b542a1e06ccae50165f0268', './templates/mail/messu_message_notification_subject.tpl', '21.12', 0),
('2d34c2e9d0d6060322581007c0441060', './templates/mail/moderate_activation_mail.tpl', '21.12', 0),
('3477f02776a3de5e680957f7b47a1420', './templates/mail/moderate_activation_mail_subject.tpl', '21.12', 0),
('aecae669aa4186530d96a2259d00d757', './templates/mail/moderate_validation_mail.tpl', '21.12', 0),
('b0e8d001b1fcc0474b6cec0579ea57e9', './templates/mail/moderate_validation_mail_subject.tpl', '21.12', 0),
('8608794fb76b2816889ba81238ebe571', './templates/mail/new_friend_invitation.tpl', '21.12', 0),
('ce654bd70fd229f230a2d4212d58c645', './templates/mail/new_friend_invitation_subject.tpl', '21.12', 0),
('41b7092f011eff682e3fe88b8e54c40a', './templates/mail/new_user_notification.tpl', '21.12', 0),
('2006f3db2c56fc0582059bd9829a09be', './templates/mail/new_user_notification_subject.tpl', '21.12', 0),
('fee2e61f0c3617050605a22a56bfcbb0', './templates/mail/newsletter_articleclip.tpl', '21.12', 0),
('a761b0f8202a269f99e7e3cab4e3c874', './templates/mail/newsletter_byebye.tpl', '21.12', 0),
('7a0c74a53ea8306a76c83e9c59d2822f', './templates/mail/newsletter_byebye_subject.tpl', '21.12', 0),
('a92eba8387aca59a2b08d5d3d6a6082f', './templates/mail/newsletter_unsubscribe.tpl', '21.12', 0),
('0be6f46d30b816d1e2dde6021a567b3e', './templates/mail/newsletter_welcome.tpl', '21.12', 0),
('45d5341b18fafa14b57c5d7475c4337d', './templates/mail/newsletter_welcome_subject.tpl', '21.12', 0),
('3207806f8c37da520b4f03565c964dd2', './templates/mail/notification_subject.tpl', '21.12', 0),
('25f08d21f055ab82272e31f561d766fa', './templates/mail/password_reminder.tpl', '21.12', 0),
('d146f22b28606205a9d327db132a8af9', './templates/mail/password_reminder_subject.tpl', '21.12', 0),
('7fdfc9aaabaeace9b770f101984d1a4d', './templates/mail/plugin_pending_notification.tpl', '21.12', 0),
('c786cdfe811a8ef1340c7c19a8d65665', './templates/mail/report.tpl', '21.12', 0),
('0864ce5dfb7048cb98f6222481a29cf2', './templates/mail/rss_new_source_category.tpl', '21.12', 0),
('bd753b8fc6e836ca2e5b3d3dd0f2c248', './templates/mail/rss_new_source_category_subject.tpl', '21.12', 0),
('2a694213a4114d1e8285cd3b8470e540', './templates/mail/scheduler_healed_notification.tpl', '21.12', 0),
('d62736398c741e6d7de5412b728c3108', './templates/mail/scheduler_healed_notification_subject.tpl', '21.12', 0),
('0f25f9a7cf4e2c2d8609ff1a91af6e78', './templates/mail/scheduler_stalled_notification.tpl', '21.12', 0),
('e2140feafae6e201198155619906b571', './templates/mail/scheduler_stalled_notification_subject.tpl', '21.12', 0),
('154ee4eb082dd598ef26abd754e1b42a', './templates/mail/share.tpl', '21.12', 0),
('be5be7c37715f044e7ffe7126a4ab786', './templates/mail/share_subject.tpl', '21.12', 0),
('21228244deb0877ed3eb8318fd4d7c23', './templates/mail/submission_notification.tpl', '21.12', 0),
('a0ff13f814058b348f07844f21a7159e', './templates/mail/submission_notification_subject.tpl', '21.12', 0),
('3193888bfff6e9761cc10c1949954e98', './templates/mail/tracker_changed_notification.tpl', '21.12', 0),
('6000fe5daf7e9afde78623ac8900dd08', './templates/mail/tracker_changed_notification_subject.tpl', '21.12', 0),
('28a103f2869488eae2a358676649041d', './templates/mail/unsuccessful_logins.tpl', '21.12', 0),
('a9a61b6f0827bf017da24112c0c445c2', './templates/mail/unsuccessful_logins_subject.tpl', '21.12', 0),
('7800ee421095735265c817e05c693309', './templates/mail/unsuccessful_logins_suspend.tpl', '21.12', 0),
('13be7631f7911f3fc1ef5ad3e68bd264', './templates/mail/unsuccessful_logins_suspend_subject.tpl', '21.12', 0),
('95ca83abc522c83593404686b921a3be', './templates/mail/user_creation_validation_mail.tpl', '21.12', 0),
('d444754a9f68a14e97ade4304129c94a', './templates/mail/user_creation_validation_mail_subject.tpl', '21.12', 0),
('c885a96e22575b0c4c2f25faac99c369', './templates/mail/user_joins_group_notification.tpl', '21.12', 0),
('abbdaebb153b973b1bb3de7dedd97e1a', './templates/mail/user_joins_group_notification_subject.tpl', '21.12', 0),
('f4a2b893939370cda573d714a77b5a83', './templates/mail/user_validation_mail.tpl', '21.12', 0),
('81eb2b053ecdc79c18957764eb1a968a', './templates/mail/user_validation_mail_subject.tpl', '21.12', 0),
('30647aa242f720df6b89ffc5ecbe0619', './templates/mail/user_validation_msg.tpl', '21.12', 0),
('31d06336646bf306b79b8986d57e8c81', './templates/mail/user_validation_waiting_msg.tpl', '21.12', 0),
('f42b9a45b76eb44a9aa2f22f2cf74ee6', './templates/mail/user_watch_article_post.tpl', '21.12', 0),
('8a7802361a04682330421ec3878a9978', './templates/mail/user_watch_article_post_subject.tpl', '21.12', 0),
('e3169ce44490a833269883ef44b4e008', './templates/mail/user_watch_blog_post.tpl', '21.12', 0),
('4696501bec230fa149153cd7e7dfb181', './templates/mail/user_watch_blog_post_subject.tpl', '21.12', 0),
('5751c9244b8647b33982bbb4fe448b4a', './templates/mail/user_watch_calendar.tpl', '21.12', 0),
('76901b0053bcfe80d1b3aea1abe6efbc', './templates/mail/user_watch_calendar_subject.tpl', '21.12', 0),
('c54004694787e9e8f3462aa36f899991', './templates/mail/user_watch_category_changed_subject.tpl', '21.12', 0),
('3e745558bf04b6274a8f29cc81f34d97', './templates/mail/user_watch_category_created.tpl', '21.12', 0),
('42f64260bfab0d37929f301add618fa2', './templates/mail/user_watch_category_created_subject.tpl', '21.12', 0),
('05cec4ce3483c89da40bff3459eedf65', './templates/mail/user_watch_category_removed.tpl', '21.12', 0),
('23eecb2fd91fd0efb986600b1728a7a4', './templates/mail/user_watch_category_removed_subject.tpl', '21.12', 0),
('a6b6a7f590d3fdec2c59e9430d98d169', './templates/mail/user_watch_category_updated.tpl', '21.12', 0),
('c6c8630cbe867f88df46a87e1d7c694a', './templates/mail/user_watch_category_updated_subject.tpl', '21.12', 0),
('f0639871223dd2b303280f2dadda6698', './templates/mail/user_watch_comment.tpl', '21.12', 0),
('a836c45b1cd4876322bb321475fd693e', './templates/mail/user_watch_comment_subject.tpl', '21.12', 0),
('94a50137b1e452867973908c93a36414', './templates/mail/user_watch_file_gallery_changed_subject.tpl', '21.12', 0),
('3fd668d8e81d8cac2651dff7eee3b460', './templates/mail/user_watch_file_gallery_remove_file.tpl', '21.12', 0),
('02b07ecb6a09be90e53b33f5e6138b5b', './templates/mail/user_watch_file_gallery_upload.tpl', '21.12', 0),
('d182b4ecd5425968f5e71e9fd6bcc6a8', './templates/mail/user_watch_forum_queued_subject.tpl', '21.12', 0),
('a1f188463dd0935f51857caefb53b6a6', './templates/mail/user_watch_forum_subject.tpl', '21.12', 0),
('93783f0afe08b296fd7ec62a1232e598', './templates/mail/user_watch_image_gallery_changed_subject.tpl', '21.12', 0),
('39e3954add897f75327a2481d62135d3', './templates/mail/user_watch_image_gallery_upload.tpl', '21.12', 0),
('9e84109f5129ecc1db8efd7f5e879cae', './templates/mail/user_watch_map_changed.tpl', '21.12', 0),
('beb56906d6da2fa9f5ed9f06c37bbade', './templates/mail/user_watch_object_entered_category.tpl', '21.12', 0),
('4b40f1de20bd2cd20c19cf928011eb96', './templates/mail/user_watch_object_entered_category_subject.tpl', '21.12', 0),
('00a2dd8e1bc26a4bbac27c316dc697fd', './templates/mail/user_watch_object_leaved_category.tpl', '21.12', 0),
('fb15290b96240ac8e589b828325b9691', './templates/mail/user_watch_object_leaved_category_subject.tpl', '21.12', 0),
('4b5cf3e4229346a95cde910ef9d47171', './templates/mail/user_watch_structure.tpl', '21.12', 0),
('02b28c0b025e3d52142ce541d2c5cb8e', './templates/mail/user_watch_structure_subject.tpl', '21.12', 0),
('1247812e59c1864e5ca8f14d33cd666a', './templates/mail/user_watch_token.tpl', '21.12', 0),
('c9c51ef510b7cc1ebc7c67739cce1a2e', './templates/mail/user_watch_wiki_new_attach.tpl', '21.12', 0),
('5af8f40a3b5cde62661ff1cd637ea503', './templates/mail/user_watch_wiki_new_attach_subject.tpl', '21.12', 0),
('f7c1fe588585b09fbfcddfc74f7f585c', './templates/mail/user_watch_wiki_page_changed.tpl', '21.12', 0),
('3aa37c3754f91721d31986c50fe58650', './templates/mail/user_watch_wiki_page_changed_subject.tpl', '21.12', 0),
('126a9c0b7944fbb72a673aa6b6a312c6', './templates/mail/user_watch_wiki_page_renamed.tpl', '21.12', 0),
('78e83e70f5504bf2fe9144251f8fd1e9', './templates/mail/user_watch_wiki_page_renamed_subject.tpl', '21.12', 0),
('ff0586befe6b1528ef6c954d6c3845a7', './templates/mail/user_welcome_msg.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/mailin/index.php', '21.12', 0),
('32f7268460b05fb8f46e75c6158a6464', './templates/mailin/remove_account.tpl', '21.12', 0),
('f35f5f57314d79fb4fbe8b9d33c04f28', './templates/mailin/replace_account.tpl', '21.12', 0),
('1c2355f99bb9f12658827a044d2bf9ce', './templates/managestream/advanced.tpl', '21.12', 0),
('79eecf58610163629b2ef248992335ad', './templates/managestream/change_rule_status.tpl', '21.12', 0),
('7936502b73dc84c52453d160613c24d1', './templates/managestream/change_rule_type.tpl', '21.12', 0),
('5f9ec6d6310137d5f2be74153bb15455', './templates/managestream/delete.tpl', '21.12', 0),
('8f200601df005a7129134d0a6c149227', './templates/managestream/deleteactivity.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/managestream/index.php', '21.12', 0),
('a3ed7524fb76a62644d29984ffad316f', './templates/managestream/list.tpl', '21.12', 0),
('9ed7a9a42ea636a3081e19116ab5ecf5', './templates/managestream/record.tpl', '21.12', 0),
('603b072feea811590a5dd532e1242f1e', './templates/managestream/sample.tpl', '21.12', 0),
('da62a986d618cd8f57d95fa06706d9d9', './templates/managestream/tracker_filter.tpl', '21.12', 0),
('4211d6df739a4e0725577d7886c6bb6c', './templates/menu/clone.tpl', '21.12', 0),
('2c3687049b9a679cc7e57f520d4ed957', './templates/menu/edit.tpl', '21.12', 0),
('c2d95e6a22de5726a406cc39263cff11', './templates/menu/edit_option.tpl', '21.12', 0),
('848b5ceb1f98960a40af3adff7a8c3e8', './templates/menu/export_menu_options.tpl', '21.12', 0),
('2c21a7bdc05de3a90707f2eba0185bc1', './templates/menu/import_menu_options.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/menu/index.php', '21.12', 0),
('bf5f2cfdd7024faa2167474f84333814', './templates/menu/preview.tpl', '21.12', 0),
('b468db73027129ed9d0ffc81e559b4e3', './templates/menu/quicklinks.tpl', '21.12', 0),
('371a7e19212c19e24792b42479586d76', './templates/messu-archive.tpl', '21.12', 0),
('daac28acb29d81c1197c40cdec34a80d', './templates/messu-broadcast.tpl', '21.12', 0),
('39faa53b13b65e1b35d02c0109be1c90', './templates/messu-compose.tpl', '21.12', 0),
('a3d56285e9945fc1a272174f399698e5', './templates/messu-download.tpl', '21.12', 0),
('9c81285439760a984874801a8fbc2762', './templates/messu-mailbox.tpl', '21.12', 0),
('b4fe96e20f8665bae6882045f98045cb', './templates/messu-nav.tpl', '21.12', 0),
('aea1969b02dd3c65546aa6122cf8a1e3', './templates/messu-read.tpl', '21.12', 0),
('ab56b7c2844fe32df469f394a1f9e9a3', './templates/messu-read_archive.tpl', '21.12', 0),
('634cc2dc82ae8c351c6d20c15d81bc87', './templates/messu-read_sent.tpl', '21.12', 0),
('4975f8d514964a162aa1536449bcb2b2', './templates/messu-sent.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/metadata/index.php', '21.12', 0),
('62c1692760994bc96109be3541d5802f', './templates/metadata/meta_view_dialog.tpl', '21.12', 0),
('169318c602fe6b1ec4cb42d9e8f44ce2', './templates/metadata/meta_view_tabs.tpl', '21.12', 0),
('bbde23236444aa2d7ebb0e4d76c578c4', './templates/module.tpl', '21.12', 0),
('cf2a585b380575feeb10aafe003e3bc5', './templates/module/execute.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/module/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/modules/index.php', '21.12', 0),
('79075c2fb9c6fee700fa49d975c7382c', './templates/modules/mod-action_calendar.tpl', '21.12', 0),
('6c2aff25f579aeb9a608e667b9502833', './templates/modules/mod-action_similarcontent.tpl', '21.12', 0),
('aa68e1d12408817567059df559cb198d', './templates/modules/mod-adminbar.tpl', '21.12', 0),
('30874674038187ff240cc8c36a1ae013', './templates/modules/mod-adsense.tpl', '21.12', 0),
('cf0745fbd088327e1d6f9f6fe7d98ed9', './templates/modules/mod-article_archives.tpl', '21.12', 0),
('f109d43f86112b6b5559a47f831c0f8d', './templates/modules/mod-article_topics.tpl', '21.12', 0),
('f4618c694d3082e06550c04214e664b2', './templates/modules/mod-articles.tpl', '21.12', 0),
('211b2a2756952b5eb9250583fcc1f6a8', './templates/modules/mod-assistant.tpl', '21.12', 0),
('67f4fc97b637e64ddfc62e9abfb8f5e5', './templates/modules/mod-blog_last_comments.tpl', '21.12', 0),
('fc9bba7e3e2907280a581ea3e5a3af95', './templates/modules/mod-breadcrumb.tpl', '21.12', 0),
('c9a6b003645ba0ba6ef179f08003615a', './templates/modules/mod-breadcrumbs.tpl', '21.12', 0),
('24e3f7fa5459dcca6d18dbf3e7ded2f6', './templates/modules/mod-calendar_new.tpl', '21.12', 0),
('7ed41a7a3b15386602a42a67196163bf', './templates/modules/mod-cart.tpl', '21.12', 0),
('11085c847ceef51c11b9283597d880d5', './templates/modules/mod-categories.tpl', '21.12', 0),
('0857762597d2a962f427dfbe87952569', './templates/modules/mod-category_transition.tpl', '21.12', 0),
('9dd727e07f3a83eeef6bd31b6fac032e', './templates/modules/mod-change_category.tpl', '21.12', 0),
('fa3aaeb6fc6bcdd3aa3f24cba45870ca', './templates/modules/mod-collapse.tpl', '21.12', 0),
('2d9a57dbcbc291ce434313d75825c944', './templates/modules/mod-comm_received_objects.tpl', '21.12', 0),
('231f7eecc12e51a7bab1b741ea9e3f51', './templates/modules/mod-contributors.tpl', '21.12', 0),
('f6c65c1000d9b1f948f3a8f20d775fa4', './templates/modules/mod-credits.tpl', '21.12', 0),
('d54704691409dd0bdaaead514d41f92e', './templates/modules/mod-directory_last_sites.tpl', '21.12', 0),
('dd1f513756f2d64652466bd89994fadb', './templates/modules/mod-directory_stats.tpl', '21.12', 0),
('5b6025772d321b440038085e7c9215ae', './templates/modules/mod-directory_top_sites.tpl', '21.12', 0),
('90bbfb3761d473d8396713e3cc8691ae', './templates/modules/mod-domain_password.tpl', '21.12', 0),
('0f9a2afb6f374591f679532675cc80ff', './templates/modules/mod-facebook.tpl', '21.12', 0),
('d3a0735af522f30267f409f967a2a4f1', './templates/modules/mod-featured_links.tpl', '21.12', 0),
('f5726bdd798783b2b7a872870eb104ec', './templates/modules/mod-file_galleries.tpl', '21.12', 0),
('bc3501939501809c510058c3cb044bd1', './templates/modules/mod-forums_best_voted_topics.tpl', '21.12', 0),
('c17f5d3020e3c7245fcacf8cd2563e65', './templates/modules/mod-forums_last_posts.tpl', '21.12', 0),
('da38fe5b805128172f13f71708149daf', './templates/modules/mod-forums_most_commented_forums.tpl', '21.12', 0),
('48ed41d3da54f52e3ae19b1f6f7d0178', './templates/modules/mod-forums_most_read_topics.tpl', '21.12', 0),
('383e9a5db2a67633d243e7b734f858cf', './templates/modules/mod-forums_most_visited_forums.tpl', '21.12', 0),
('5b43bfc7a99606cf9df99555fd5394f2', './templates/modules/mod-freetag.tpl', '21.12', 0),
('2b206a2a62257622f32259f99f0d8671', './templates/modules/mod-freetags_current.tpl', '21.12', 0),
('85d442e3c2b3008fbf21172da8c04671', './templates/modules/mod-freetags_morelikethis.tpl', '21.12', 0),
('85ac075ca4431750b8e4507f60c030f9', './templates/modules/mod-freetags_most_popular.tpl', '21.12', 0),
('3ff4735a208bd915acb216a9c2061c47', './templates/modules/mod-freetags_prefered.tpl', '21.12', 0),
('86109f8810603804557d867876df3e30', './templates/modules/mod-friend_list.tpl', '21.12', 0),
('e1df5ef60441afab650f80c52c45f585', './templates/modules/mod-git_detail.tpl', '21.12', 0),
('ee4f07e9d25e449c35ea7d40a2ad62c0', './templates/modules/mod-google.tpl', '21.12', 0),
('547e25a55ddb4391af5e5cba5d9001d6', './templates/modules/mod-groups_emulation.tpl', '21.12', 0),
('918abe0ff33ad65c01cdde3d2d0c39c8', './templates/modules/mod-last_actions.tpl', '21.12', 0),
('967aa5792549ce7dcdb9607275981567', './templates/modules/mod-last_blog_posts.tpl', '21.12', 0),
('ec5819757f1c853f1ce174fb9123e117', './templates/modules/mod-last_category_objects.tpl', '21.12', 0),
('0129ecbe33f6cca7828e9eb2305f0e18', './templates/modules/mod-last_created_blogs.tpl', '21.12', 0),
('1236804e3bbc1c185c9961de1bd96e06', './templates/modules/mod-last_created_faqs.tpl', '21.12', 0),
('983bdc0d57d4f23ea819ee3a82d6f48c', './templates/modules/mod-last_created_quizzes.tpl', '21.12', 0),
('a8dc70528ebec2647279f0bbb6c153bf', './templates/modules/mod-last_file_galleries.tpl', '21.12', 0),
('9ebc787deebe004d02613ab73de60ab9', './templates/modules/mod-last_files.tpl', '21.12', 0),
('9c895489455fcd876447cef5bc09bb76', './templates/modules/mod-last_image_galleries.tpl', '21.12', 0),
('a20cab3e36309501f0042473d5e9df30', './templates/modules/mod-last_images.tpl', '21.12', 0),
('11cc5cb39bdaf9ea25dc687dec97bd8c', './templates/modules/mod-last_modif_events.tpl', '21.12', 0),
('cbf761acb4b43b558ea058128c30149d', './templates/modules/mod-last_modif_pages.tpl', '21.12', 0),
('4c70bb296cd45a7016806c5d738b1ed1', './templates/modules/mod-last_modified_blogs.tpl', '21.12', 0),
('b733da783bf214e9545fd8441f88c14d', './templates/modules/mod-last_podcasts.tpl', '21.12', 0),
('2baf9baed5e8067165bd053bbaab714b', './templates/modules/mod-last_submissions.tpl', '21.12', 0),
('77c6e2b10402b62dfa48d65ae1ad1423', './templates/modules/mod-last_tracker_comments.tpl', '21.12', 0),
('e14343ede92e946f358f82407ed091b0', './templates/modules/mod-last_tracker_items.tpl', '21.12', 0),
('b89930ed6340b371c936f0401483b006', './templates/modules/mod-last_validated_faq_questions.tpl', '21.12', 0),
('fcf3dcb475e141bfa62822d62a49bebe', './templates/modules/mod-last_visitors.tpl', '21.12', 0),
('356bdcd4b33abb74231826846964177f', './templates/modules/mod-last_youtube_playlist_videos.tpl', '21.12', 0),
('2e8bc23e8c194390d40876986ed63060', './templates/modules/mod-live_support.tpl', '21.12', 0),
('5ff7c5f28d30369f5f6914426cf7ff9e', './templates/modules/mod-loadstats.tpl', '21.12', 0),
('b1b5056a13d20097606cde395aaa351a', './templates/modules/mod-locator.tpl', '21.12', 0),
('7dfe06ba06f2b38eb188f68b1541a96b', './templates/modules/mod-login_box.tpl', '21.12', 0),
('808dde75c36213c57ec24d4b26018287', './templates/modules/mod-logo.tpl', '21.12', 0),
('639fdaea507567206384ae5557939b66', './templates/modules/mod-map_edit_features.tpl', '21.12', 0),
('575df57be63b3b17f0268c6d78844371', './templates/modules/mod-map_layer_selector.tpl', '21.12', 0),
('3097d27806f3c4ab2b834b3a979a7e3f', './templates/modules/mod-map_mode_selector.tpl', '21.12', 0),
('840bb72bd88decb23c5220cc141abe0c', './templates/modules/mod-map_search_location.tpl', '21.12', 0),
('92b291a876fd39c92913dfe3849cabbb', './templates/modules/mod-menu.tpl', '21.12', 0),
('0575f61c0c5ce357f5ebc95dc047e20d', './templates/modules/mod-menupage.tpl', '21.12', 0),
('89961cbe1b272d8f0e1d70b85e943404', './templates/modules/mod-menustructure.tpl', '21.12', 0),
('4c5d4f008b0b1c3e69b99d98936e479e', './templates/modules/mod-messages_unread_messages.tpl', '21.12', 0),
('6890ee7f9be366800436f4c7f74e75e7', './templates/modules/mod-minichat.tpl', '21.12', 0),
('375185b3ed5974f20db89c717df301f1', './templates/modules/mod-mobile.tpl', '21.12', 0),
('14fd066ffbd4f470d2d8e0e4de161725', './templates/modules/mod-months_links.tpl', '21.12', 0),
('b7b1433cfcc404365405361eca23270c', './templates/modules/mod-most_commented.tpl', '21.12', 0),
('33a42367e4f060580cdc71e10058a81a', './templates/modules/mod-mustread.tpl', '21.12', 0),
('48d3185aa646fc0002cf0676b69d8ed0', './templates/modules/mod-notificationlink.tpl', '21.12', 0),
('3bc764c7e4518a44463bc18b3a2bdeb9', './templates/modules/mod-num_submissions.tpl', '21.12', 0),
('2f44bed2d9223acabf8dfafc92d6f8ab', './templates/modules/mod-old_articles.tpl', '21.12', 0),
('f37c3eead4aafc4432134e640e765d03', './templates/modules/mod-package.tpl', '21.12', 0),
('b8787c0919054ce45cbd601cc24480d1', './templates/modules/mod-payment_outstanding.tpl', '21.12', 0),
('4d942dc81f8741052ea901c9e66b81de', './templates/modules/mod-permissions.tpl', '21.12', 0),
('db837f6196f557f1587ccf061548a27a', './templates/modules/mod-perspective.tpl', '21.12', 0),
('2e5f77bc65115ff54c25241577c4196b', './templates/modules/mod-quick_edit.tpl', '21.12', 0),
('9b0b406878fac1280d046520b696ff4e', './templates/modules/mod-quick_search.tpl', '21.12', 0),
('2b99614b6587a0b93dc833afd2190be7', './templates/modules/mod-quickadmin.tpl', '21.12', 0),
('1cb4c3bad2562277df6c3867724812d8', './templates/modules/mod-random_images.tpl', '21.12', 0),
('55ad6409ebdfaa3730141eaf8ae36a61', './templates/modules/mod-random_pages.tpl', '21.12', 0),
('487eefbef9c4da59289ee9d4ecdd5b5c', './templates/modules/mod-register.tpl', '21.12', 0),
('e69174323fd96e9f4ce2b6e1592b2f6c', './templates/modules/mod-rsslist.tpl', '21.12', 0),
('c3674f9715cc8641ed67cff5f6915fb7', './templates/modules/mod-search.tpl', '21.12', 0),
('f6ed3678e43a1b89e7cecdf9705b4642', './templates/modules/mod-search_morelikethis.tpl', '21.12', 0),
('a4375e9dfd349d5ea3ca39b458654f94', './templates/modules/mod-search_wiki_page.tpl', '21.12', 0),
('5dbf3786d50d0274839b1a7bbaea9d93', './templates/modules/mod-semantic_links.tpl', '21.12', 0),
('673ce240c8e540a5d9d66a645f801649', './templates/modules/mod-share.tpl', '21.12', 0),
('5cd28ffcdd897029fb9dfa991bb4e6c3', './templates/modules/mod-short_url.tpl', '21.12', 0),
('77796e321ba6685fe0699c13bc30c404', './templates/modules/mod-shoutbox.tpl', '21.12', 0),
('915c24a91daf65db31a3bfe8612f05a2', './templates/modules/mod-since_last_visit.tpl', '21.12', 0),
('89607b14f7b245c0d1a4fca4e74df178', './templates/modules/mod-since_last_visit_new.tpl', '21.12', 0),
('ce5d1c1ac6e3d4696b1cf1200bd243cd', './templates/modules/mod-svnup.tpl', '21.12', 0),
('cee73ce35500e573cef1b03514be78ee', './templates/modules/mod-switch_lang.tpl', '21.12', 0),
('ad225fb7cfe2a2a07f1ade16d9d4bed5', './templates/modules/mod-switch_lang_admin.tpl', '21.12', 0),
('afd7f4404ae08dd3af6f45834ac246ff', './templates/modules/mod-switch_theme.tpl', '21.12', 0),
('186236b3c5faa8a2f74e996f0fc1c3ef', './templates/modules/mod-terminology.tpl', '21.12', 0),
('3afb6f466bb805b75c933b5cbf73fc07', './templates/modules/mod-tikitests.tpl', '21.12', 0),
('82651ae78d070df2e549b3ef76ee5b20', './templates/modules/mod-top_active_blogs.tpl', '21.12', 0),
('abe90f82957c01ade5316c1116adf5d9', './templates/modules/mod-top_articles.tpl', '21.12', 0),
('891b3d8c3385056f02931d90caa44b50', './templates/modules/mod-top_blog_posters.tpl', '21.12', 0),
('62897465ef42ed329712127c1023b63d', './templates/modules/mod-top_file_galleries.tpl', '21.12', 0),
('77380cf0cf6a505fad8e71433b05a873', './templates/modules/mod-top_files.tpl', '21.12', 0),
('9d8d3da13d266484449a0fc4840c295b', './templates/modules/mod-top_forum_posters.tpl', '21.12', 0),
('157b66c18f83b3cb7dda3e203da28969', './templates/modules/mod-top_image_galleries.tpl', '21.12', 0),
('b363c6e5a3ea7d54f6d95ae5fe2f624d', './templates/modules/mod-top_images.tpl', '21.12', 0),
('4a03400baf904454907898bd4977b16e', './templates/modules/mod-top_objects.tpl', '21.12', 0),
('b62e0b0f11b45c1e9ff266748506a560', './templates/modules/mod-top_pages.tpl', '21.12', 0),
('5513940d8a91d3c881820e2087c1a8a0', './templates/modules/mod-top_quizzes.tpl', '21.12', 0),
('1b8ba2e85dfe0275562fba26459a0f0d', './templates/modules/mod-top_visited_blogs.tpl', '21.12', 0),
('06c67cce090ac264bf1ab109d7b45a4e', './templates/modules/mod-top_visited_faqs.tpl', '21.12', 0),
('d66d473cd35b91f777861f44991256c9', './templates/modules/mod-tracker_input.tpl', '21.12', 0),
('f62dfa94b0b463c396f1f62b458ce8bb', './templates/modules/mod-trackerhelp.tpl', '21.12', 0),
('b5a9d6c1174b072a953a19c83eea1274', './templates/modules/mod-translation.tpl', '21.12', 0),
('29110513154dd6509fc4a937084337ab', './templates/modules/mod-twitter.tpl', '21.12', 0),
('90794a4b62fafa891643e4f1fe8a9f1f', './templates/modules/mod-upcoming_events.tpl', '21.12', 0),
('467f03690d97c559406f370a9002d66e', './templates/modules/mod-user_blogs.tpl', '21.12', 0),
('abc99ec745201742b052e7f93f836750', './templates/modules/mod-user_bookmarks.tpl', '21.12', 0),
('04c206636c836c71112258c6f761fc1a', './templates/modules/mod-user_image_galleries.tpl', '21.12', 0),
('739cc918266d3029e89178bd8da99f41', './templates/modules/mod-user_pages.tpl', '21.12', 0),
('26f8364a0a94d3e6ca53eda64670b9de', './templates/modules/mod-user_tasks.tpl', '21.12', 0),
('22dc9106c52887661157c88e0abe71c1', './templates/modules/mod-user_tasks_public.tpl', '21.12', 0),
('3edac7708d3141432dad3e6dc3546a89', './templates/modules/mod-usergroup_tracker.tpl', '21.12', 0),
('228be3ac562d30609afe0b72d45afef4', './templates/modules/mod-users_list.tpl', '21.12', 0),
('bb90d4940e4e2801d790dace7e0d7cc6', './templates/modules/mod-users_own_rank.tpl', '21.12', 0),
('aacf0bcf5465bc7de4f6ecde48e45bfe', './templates/modules/mod-users_rank.tpl', '21.12', 0),
('4b0d362610387ba25992e5d235f973ba', './templates/modules/mod-websearch.tpl', '21.12', 0),
('00125e3961ebde099ac36058b6fc2b77', './templates/modules/mod-whats_related.tpl', '21.12', 0),
('2a1318054b4dfbddc8a4c1c5ea7f905c', './templates/modules/mod-who_is_there.tpl', '21.12', 0),
('e7a4fa9890484a32d59f6350509eb306', './templates/modules/mod-wiki_last_comments.tpl', '21.12', 0),
('30d47e920a1b317c9bc7a731fa53496b', './templates/modules/mod-xmpp.tpl', '21.12', 0),
('ed5f5ea014f9022e0b698f252358c1bf', './templates/modules/mod-youtube.tpl', '21.12', 0),
('75962cbb93a714545604956ea894df6b', './templates/modules/mod-zone.tpl', '21.12', 0),
('76903cfcc3c594aff3c16f59ec3e242f', './templates/modules/mod-zotero.tpl', '21.12', 0),
('e859987973397ef4fb36699e550b2ede', './templates/modules/user_module.tpl', '21.12', 0),
('197f13de8a504334973749ca8c747e85', './templates/modules/websearch.tpl', '21.12', 0),
('8caf2daab11b86139a2fa1807cadfa51', './templates/monitor/clearall.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/monitor/index.php', '21.12', 0),
('7ff5016f20a6940a4600701eaf530c8c', './templates/monitor/link.tpl', '21.12', 0),
('396dac0b5f49faa5458159b018ef0e42', './templates/monitor/notification_email_body.tpl', '21.12', 0),
('4faf69b20e424490671d2aa8802b6194', './templates/monitor/notification_email_digest_subject.tpl', '21.12', 0),
('04b5b1e77217b68713cc8f19702dd8ee', './templates/monitor/notification_email_subject.tpl', '21.12', 0),
('ac9d7ebfa1bcf287ec0ba76b1bca93b9', './templates/monitor/notification_link.tpl', '21.12', 0),
('843d1b45029b105e7be3987679ec6586', './templates/monitor/object.tpl', '21.12', 0),
('c5217c982f13b00402d9331ee88da379', './templates/monitor/stream.tpl', '21.12', 0),
('b23ccb6e8567a16373c4620a78022a74', './templates/monitor/unread.tpl', '21.12', 0),
('d69c0c84b535384a29d4765f589a3782', './templates/multilike.tpl', '21.12', 0),
('5147856f7784621b47d6359f73ba1e6f', './templates/mustread/circulate.tpl', '21.12', 0),
('f5abb3d56abac9cdd6b87d69410da1e9', './templates/mustread/detail.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/mustread/index.php', '21.12', 0),
('398d7b68ae1db111f0c59854e319fac1', './templates/mustread/list.tpl', '21.12', 0),
('bbe13c0814ad5c6f9e52505e2f2651b1', './templates/mustread/object.tpl', '21.12', 0),
('50fe064fd8be33241cb4928fddebb117', './templates/mxgraph/editor.tpl', '21.12', 0),
('66a9d86cf86efb481adf7687f85f6410', './templates/mxgraph/save_modal.tpl', '21.12', 0),
('d41d8cd98f00b204e9800998ecf8427e', './templates/oauthserver/client_row.tpl', '21.12', 0),
('e1cb0d30aa0e083fae82d0fc5b2fbb98', './templates/oauthserver/consent.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/object/index.php', '21.12', 0),
('c20a4bddff4d316871d8a83357fd7fa2', './templates/object/infobox.tpl', '21.12', 0),
('617521824e10ae03bb10ab40d8fb3e93', './templates/object/infobox/activity.tpl', '21.12', 0),
('85191d3dac0e41a8267ec968f974baa8', './templates/object/infobox/index.php', '21.12', 0),
('fefdd953d62e8bc7fa38f829aa05e1dc', './templates/object/infobox/trackeritem.tpl', '21.12', 0),
('0cef314da19a880fae1e860e69aff413', './templates/object/lock.tpl', '21.12', 0),
('9092722388f154c1e9f5be42be73eb24', './templates/object_perms_summary.tpl', '21.12', 0),
('4c9a5659872dabcbd9e34e52195b0173', './templates/object_selector.tpl', '21.12', 0),
('4db00bc0e8c8a02ba59dd530d7097dd8', './templates/object_selector_multi.tpl', '21.12', 0),
('8ac526cb3db5b5f6f99387ebfb36fa26', './templates/object_selector_multi_extra.tpl', '21.12', 0),
('efae64ae95497e19cafd404a53329046', './templates/pagehistory.tpl', '21.12', 0),
('938ff27fb65fdda7464dc1dccea60afb', './templates/password_help.tpl', '21.12', 0),
('753332717826a48796c9c3dafc956067', './templates/password_jq.tpl', '21.12', 0),
('add3d77a54f0fd5b20f5f9513536b350', './templates/permission_link.tpl', '21.12', 0),
('c124c9f48d2e612cfd4275a94331f2d0', './templates/plugin/edit.tpl', '21.12', 0),
('9b2ba1e828eb6d3652c773fc70924bae', './templates/plugin/list.tpl', '21.12', 0),
('916858987816a25540abadb98d753747', './templates/plugin/quick_add_references.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/plugins/index.php', '21.12', 0),
('8d3adef154ab356db104cd7324c8aa06', './templates/poll.tpl', '21.12', 0),
('ada36e7d8c4e6fe56aba9c7674b30540', './templates/prefs/flag.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/prefs/index.php', '21.12', 0),
('d19ea08136dcbe55948d6877cda3b31c', './templates/prefs/list.tpl', '21.12', 0),
('1bead492a334ea6b272f63d74964bf56', './templates/prefs/multicheckbox.tpl', '21.12', 0),
('3c378e883b9ed360ab9dea72bed76633', './templates/prefs/multilist.tpl', '21.12', 0),
('3267a65d48cee0120f190830fd90ada6', './templates/prefs/multiselector.tpl', '21.12', 0),
('aaa05251d781d09a7cad08e4e2473144', './templates/prefs/password.tpl', '21.12', 0),
('6a9ddb117d6f6576cdaad8089ea9ea79', './templates/prefs/radio.tpl', '21.12', 0),
('0579364ff5105ec862dd00b22ad1da44', './templates/prefs/selector.tpl', '21.12', 0),
('7dc6c1f930ba958a08073bf2b46facc1', './templates/prefs/shared.tpl', '21.12', 0),
('5f6c8a7e92514dad12b4788f3a90c685', './templates/prefs/text.tpl', '21.12', 0),
('ba9b9d19db5c729d4513dc1808d5bb3c', './templates/prefs/textarea.tpl', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './templates/print/index.php', '21.12', 0),
('aa6fb8f60fe4ef7d03413ffa2fd9fc7d', './templates/print/print-decorator_indexed.tpl', '21.12', 0),
('f96135f90458667a45bde6ddca40786f', './templates/print/print-decorator_indexrow.tpl', '21.12', 0),
('2b56eda271aadc0e2b5e9014bf72c75a', './templates/print/print-index_footer.tpl', '21.12', 0),
('ed2496911a79d957b9a02fea39c265fc', './templates/print/print-index_header.tpl', '21.12', 0),
('cb70a1f10f9e35726cd535fd039fa6dd', './templates/print/print-object_trackeritem.tpl', '21.12', 0),
('c82dcc4c0360affb661b91758d38e055', './templates/print/print-object_wiki.tpl', '21.12', 0),
('4c6782087f638d5dbd30512c09ffd179', './templates/print/print-page_footer.tpl', '21.12', 0),
('f3f93978f8a2d52a21f6b6602d75a24c', './templates/print/print-page_header.tpl', '21.12', 0),
('0a293bd9cc815c34970820b55930e8dd', './templates/print/print-title_trackeritem.tpl', '21.12', 0),
('8035a67a17997d1f1d32bd3161ef068f', './templates/print/print-title_wiki.tpl', '21.12', 0),
('aebdd686a494f09a4f7ffd9ddb64ac3b', './templates/pwa/pwa.tpl', '21.12', 0),
('1fc9d2797b3a485e9674b6f8ee2e0c92', './templates/rating.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/rating/index.php', '21.12', 0),
('2af45106725037f9f1a11e6a2ea55475', './templates/rating/vote.tpl', '21.12', 0),
('4670ad9e624702dc2fb1fe942bfc1a47', './templates/rating_choice.tpl', '21.12', 0),
('5bd1e7074df76cc9537cac0650bbfbc4', './templates/recommendation_dev/compare.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/recommendation_dev/index.php', '21.12', 0),
('351edc79a44bb5e2e926d381412d4bfc', './templates/register-email.tpl', '21.12', 0),
('0c89ee5296c9f1147772536097ea66ad', './templates/register-form.tpl', '21.12', 0),
('539b75a13601d7bb65c4208444df89d7', './templates/register-groupchoice.tpl', '21.12', 0),
('2e644bb5a5b91586f119e58d1c2d0542', './templates/register-login.tpl', '21.12', 0),
('1704f25b87ec0b3e2dcd424043cd8b10', './templates/register-pass.tpl', '21.12', 0),
('2c18b98136369fd41566ceda38fa8d44', './templates/register-pass2.tpl', '21.12', 0),
('bb23796d5e7c774aa18a7f335f29b2c5', './templates/register-passcode.tpl', '21.12', 0),
('3b4e61d27a679ed7e685d2a649897269', './templates/remarksbox.tpl', '21.12', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/edit.tpl', '21.12', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/exportcsv.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/report/index.php', '21.12', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/load.tpl', '21.12', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/preview.tpl', '21.12', 0),
('913f61a61dca8474b73dc5e845badda3', './templates/report/wikidata.tpl', '21.12', 0),
('82c5a57c18b7c47d5cfd507648fdb74f', './templates/scheduler/remove.tpl', '21.12', 0),
('4755fd9c4ecbaa638615530cf3c9b9b4', './templates/scheduler/reset.tpl', '21.12', 0),
('c8cca8782996bba375f5720b86d81846', './templates/scheduler/run.tpl', '21.12', 0),
('f1547a8c565ba2dc35d1d9fa0c186c2e', './templates/score/create_score_event.tpl', '21.12', 0),
('fb33f93668f0580815cd6b2a74a30494', './templates/search/help.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/search/index.php', '21.12', 0),
('f8cb758da9ed3bbfb22b526fcbe3fa81', './templates/search/list/carousel.tpl', '21.12', 0),
('299910931a7988757f81bd04bbab13e0', './templates/search/list/count.tpl', '21.12', 0),
('87cd7c8be72dbdb242658f639a1b0439', './templates/search/list/debug.tpl', '21.12', 0),
('c87cf64d4a13d5c226a7ba93fb497bbe', './templates/search/list/filter.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/search/list/index.php', '21.12', 0),
('96e2182b6d9ce440d79fd52e6123c9bd', './templates/search/list/medialist.tpl', '21.12', 0),
('49ee8da94f0b1a77396e44870701e237', './templates/search/list/table.tpl', '21.12', 0),
('473e9804a0e81609929159b7e098ec25', './templates/search/process_queue.tpl', '21.12', 0),
('c29fb7a6e3fe4d1e9c62e8de15b27d6a', './templates/search/rebuild.tpl', '21.12', 0),
('332d6ab1a51a289edb4dc9847e035f3e', './templates/search_customsearch/cache_expired.tpl', '21.12', 0),
('ad310e2785835582f8c9554cdbe3cad0', './templates/search_customsearch/customsearch.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/search_customsearch/index.php', '21.12', 0),
('8a3e13e0613e91182e0eee875f392fbb', './templates/search_manifold/check.tpl', '21.12', 0),
('061357308d4c134e00d3c419d9279a99', './templates/search_manifold/create_index.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/search_manifold/index.php', '21.12', 0),
('e5970052bf4320b7cc5ab3f124c9ed42', './templates/search_stored/delete.tpl', '21.12', 0),
('7e39a65a90a732e096d79d6be62f72fa', './templates/search_stored/edit.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/search_stored/index.php', '21.12', 0),
('19008cb99f496ad0f805807f626ead7d', './templates/search_stored/list.tpl', '21.12', 0),
('a67b707d403e6ce8be0d72dbd995d50b', './templates/search_stored/select.tpl', '21.12', 0),
('ca5db09408e470b043da2af80faf4655', './templates/searchresults-plain.tpl', '21.12', 0),
('9b9ccfd904c0eca714b36455766e57d4', './templates/send_newsletter_footer.tpl', '21.12', 0),
('dc68895de01ca39d3859a786c801f64a', './templates/send_newsletter_header.tpl', '21.12', 0),
('eeb81e74da17335f1f9e6372ff4b024e', './templates/sent_newsletters.tpl', '21.12', 0),
('c399ba3005f12ee795fde0ceb4931bf0', './templates/show_copyright.tpl', '21.12', 0),
('b6a2ab347e9ced8b175bee04db5b1920', './templates/social/add_friend.tpl', '21.12', 0),
('f0dd9f5e3f45a5f6a964cad99ffa530e', './templates/social/approve_friend.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/social/index.php', '21.12', 0),
('5a868eb79cd38dbaca5b6afbdd2eb08b', './templates/social/list_friends.tpl', '21.12', 0),
('b501002203a8e2360c913d4e50510712', './templates/social/remove_friend.tpl', '21.12', 0),
('5afcaa0825f45059b6756d5b70175e85', './templates/structures_toc-endul.tpl', '21.12', 0),
('a6abc833f7071efcac574c67bab8ae11', './templates/structures_toc-leaf.tpl', '21.12', 0),
('2fb0aab7b96cff8a030f7115ddd50dbc', './templates/structures_toc-startul.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/styleguide/index.php', '21.12', 0),
('0adb1f68fd60c91bf474a0a95580a6b1', './templates/styleguide/sections/alerts.tpl', '21.12', 0),
('3ddfac5c210d6ed209e248eff685ee11', './templates/styleguide/sections/buttons.tpl', '21.12', 0),
('23eef4dff77a32eb8cd974157a75cac7', './templates/styleguide/sections/colors.tpl', '21.12', 0),
('afe56631fd30e89e589856e0c21015c8', './templates/styleguide/sections/dropdowns.tpl', '21.12', 0),
('891c3f78c378901d056e2b2254106257', './templates/styleguide/sections/fonts.tpl', '21.12', 0),
('e0e6520ce8152c6a3f9ac0ab6ffd4d8e', './templates/styleguide/sections/forms.tpl', '21.12', 0),
('de6c71d30702edc0a7e76130fff2c049', './templates/styleguide/sections/headings.tpl', '21.12', 0),
('b8099749e873a4fe33f17c51e1a03260', './templates/styleguide/sections/icons.tpl', '21.12', 0),
('1d86b87cfd9b4be5c59a3bacd2f5fc32', './templates/styleguide/sections/lists.tpl', '21.12', 0),
('1487bc3b51c38019ba1682f4a2945914', './templates/styleguide/sections/navbars.tpl', '21.12', 0),
('cd5eb2217953363b830be9871e0cd6fd', './templates/styleguide/sections/tables.tpl', '21.12', 0),
('fe052d6cf77b6b672764dd244fe70fcd', './templates/styleguide/sections/tabs.tpl', '21.12', 0),
('94fe31611b584e9d9e5b80b9ebd46abf', './templates/styleguide/show.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/suite/index.php', '21.12', 0),
('28a505eeb785edcbac9c00a421a91d67', './templates/suite/jitsi.tpl', '21.12', 0),
('c67425a0073abc34befe8fe0a1448cfe', './templates/tablesorter/index.php', '21.12', 0),
('1f8bafadce7cab512497b25a21a0b20f', './templates/tablesorter/totals.tpl', '21.12', 0),
('2abe093bd8ebb153955b095cb8f9a51e', './templates/tabular/create.tpl', '21.12', 0),
('cd56f61df01212658034233a0dda533c', './templates/tabular/create_tracker.tpl', '21.12', 0),
('f77c65a13c6943cbc6e9de4484a40ebd', './templates/tabular/delete.tpl', '21.12', 0),
('92a8142748c2920198348bdafcb40dc6', './templates/tabular/duplicate.tpl', '21.12', 0),
('7bb0dcc5f66aa6eb2329315483e558e3', './templates/tabular/edit.tpl', '21.12', 0),
('9a4beaddde6d1493da61b6cc7d061388', './templates/tabular/export_search_csv.tpl', '21.12', 0),
('a5ff31c2c9901dec7743a6c60210cff6', './templates/tabular/filter.tpl', '21.12', 0),
('8d8e433cda2ba824990003f2d9073e94', './templates/tabular/import_csv.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/tabular/index.php', '21.12', 0),
('9c1ee94edfcedccdfdbd591860afe201', './templates/tabular/item_actions.tpl', '21.12', 0),
('3ebbf3d86e26bd736015b17e803a391d', './templates/tabular/list.tpl', '21.12', 0),
('cd234c00e2c4cc6c42f06d83a8200045', './templates/tabular/manage.tpl', '21.12', 0),
('f21a55153a9d84b8ef26ea6ef283322a', './templates/tabular/select.tpl', '21.12', 0),
('84f947f403f3fdf0c5ec8f88fb628b6f', './templates/tabular/select_filter.tpl', '21.12', 0),
('d1fb713d3b21b1389c9870b7156c6e74', './templates/tiki-accounting.tpl', '21.12', 0),
('59d26d8ad08de657e399848d6fc183db', './templates/tiki-accounting_account_form.tpl', '21.12', 0),
('3380667eabd4d4021e8c56707abe1026', './templates/tiki-accounting_account_list.tpl', '21.12', 0),
('55bcb8e064b14505db53a8ee473e493e', './templates/tiki-accounting_account_view.tpl', '21.12', 0),
('b015d26ce7d05496846dd31a2e1011be', './templates/tiki-accounting_accounts_csv.tpl', '21.12', 0),
('1a8a4506256e495ee511db0abfdc15fd', './templates/tiki-accounting_books.tpl', '21.12', 0),
('fe3f49f1403cdc38a8c43a3c1d9c6e5f', './templates/tiki-accounting_cancel.tpl', '21.12', 0),
('aec9101f2cb1031ea9c3cb24ba9c3979', './templates/tiki-accounting_entry.tpl', '21.12', 0),
('6280894b79a509b5d638d4bbba439650', './templates/tiki-accounting_export.tpl', '21.12', 0),
('7fc293f799db123724709f240e9bc979', './templates/tiki-accounting_journal.tpl', '21.12', 0),
('316bbcdd0e50d1b39b7ca2382072bbe4', './templates/tiki-accounting_journal_csv.tpl', '21.12', 0),
('e6b1919f4cd278b35a074a7fac2f9953', './templates/tiki-accounting_stack.tpl', '21.12', 0),
('509da18683bd7a2913f20228aaf91989', './templates/tiki-accounting_stacklist.tpl', '21.12', 0),
('048b027f95ecd98bde7c469e1a0959c4', './templates/tiki-action_calendar.tpl', '21.12', 0),
('9487c723097622081a8dc9c4a7d2ce4e', './templates/tiki-admin.tpl', '21.12', 0),
('0293287d79e9e4e21bd38b53f43fc1f5', './templates/tiki-admin_actionlog.tpl', '21.12', 0),
('13c29b29cda85f7e8787541bad3c090b', './templates/tiki-admin_banning.tpl', '21.12', 0),
('557c5217bbc4f75ff8ad3724c490e44b', './templates/tiki-admin_calendars.tpl', '21.12', 0),
('f88d83470cd782333d696a976f905784', './templates/tiki-admin_categories.tpl', '21.12', 0),
('f1fa20c07a3cb8ae982f2852fe94276d', './templates/tiki-admin_content_templates.tpl', '21.12', 0),
('59e8c634fb8bf97604db20d1ae2ce2a8', './templates/tiki-admin_contribution.tpl', '21.12', 0),
('9836631d472bd7da75c530067d6f35d3', './templates/tiki-admin_cookies.tpl', '21.12', 0),
('d78a3323bb7858281aae92617d975c4a', './templates/tiki-admin_credits.tpl', '21.12', 0),
('017aa153e5abd323806df4fdfb626de9', './templates/tiki-admin_dsn.tpl', '21.12', 0),
('187f4a6c87664b97cefd7d2dd6ab7cd9', './templates/tiki-admin_external_wikis.tpl', '21.12', 0),
('e57ce74e85e1bb5fe39582f10264ea47', './templates/tiki-admin_forums.tpl', '21.12', 0),
('6e9bab290c253da2904ca1f1dc10ae18', './templates/tiki-admin_hotwords.tpl', '21.12', 0),
('6e181d3a1ae0bc28a061e47b48bfaeb2', './templates/tiki-admin_html_page_content.tpl', '21.12', 0),
('c1bb5d9b4bafc4a18dd19bf41ac205bc', './templates/tiki-admin_html_pages.tpl', '21.12', 0),
('c3ee092db230c87e16dc2f3102d0b6b3', './templates/tiki-admin_ids.tpl', '21.12', 0),
('7a2c34db9586c51f66c99fd2dbe90935', './templates/tiki-admin_integrator.tpl', '21.12', 0),
('64598fdeb5a8f9e9edb069982c18420d', './templates/tiki-admin_integrator_rules.tpl', '21.12', 0),
('7cea280797f6c585c19a9a38cc188f05', './templates/tiki-admin_keywords.tpl', '21.12', 0),
('4439fbbb45e0ca52399cf0633c517ff4', './templates/tiki-admin_links.tpl', '21.12', 0),
('85fcff708b9b7d901f8fc28f4ee07592', './templates/tiki-admin_mailin.tpl', '21.12', 0),
('4626c89b42278c2add7d805627fcba98', './templates/tiki-admin_mailin_routes.tpl', '21.12', 0),
('2ca9dcf5df0a6df0b2d196853e1da1bb', './templates/tiki-admin_menu_options.tpl', '21.12', 0),
('3c3b14f47c461a495d8fde5c0e52a9da', './templates/tiki-admin_menus.tpl', '21.12', 0),
('16ce59a50b157f5981cd5143c6dad972', './templates/tiki-admin_modules.tpl', '21.12', 0),
('bf46e841e3051e32b5a717041bfa4ea0', './templates/tiki-admin_newsletter_subscriptions.tpl', '21.12', 0),
('bbdc1cfb52b7d789de1e58b80180f75a', './templates/tiki-admin_newsletters.tpl', '21.12', 0),
('bc90e86e9a4e3667b087d0d44e925dd3', './templates/tiki-admin_notifications.tpl', '21.12', 0),
('913335108c1ab9e6298819e2ded77a25', './templates/tiki-admin_oauthserver.tpl', '21.12', 0),
('a93bc0da1258f59f9e9f3643f7251bec', './templates/tiki-admin_poll_options.tpl', '21.12', 0),
('62f2402156907a7dc2bf05aaafc633c6', './templates/tiki-admin_polls.tpl', '21.12', 0),
('25616a5bb53b26fa99260a6da4f9c560', './templates/tiki-admin_routes.tpl', '21.12', 0),
('cdff5c33103e2988a0217e85c7f5da2a', './templates/tiki-admin_rssmodules.tpl', '21.12', 0),
('e42b80ad0358e7f4d73833257bc33f90', './templates/tiki-admin_schedulers.tpl', '21.12', 0),
('7cf6371dcf9383cd2428484aece0f037', './templates/tiki-admin_security.tpl', '21.12', 0),
('f8292cebfef2f0a392dec543a3243216', './templates/tiki-admin_shoutbox_words.tpl', '21.12', 0),
('353e9d6869d90fafaa55ea2a62754a38', './templates/tiki-admin_sitemap.tpl', '21.12', 0),
('e24afb08f68759d42107b11f56ae5eb4', './templates/tiki-admin_structures.tpl', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('420d5a8483fa534bb96ad4ddba806509', './templates/tiki-admin_survey_questions.tpl', '21.12', 0),
('a6d7ec818c5c814fd45062dbfe2399bd', './templates/tiki-admin_surveys.tpl', '21.12', 0),
('d096297a45a45373927662f34986a0c9', './templates/tiki-admin_sync.tpl', '21.12', 0),
('645499dec9cffe96903351da4c470213', './templates/tiki-admin_system.tpl', '21.12', 0),
('924a4538e8dc638cb33a88149160551e', './templates/tiki-admin_tokens.tpl', '21.12', 0),
('22c23d3f0e99c5ea703c966dbb740df6', './templates/tiki-admin_toolbars.tpl', '21.12', 0),
('e0ef61d7ae07d2840661955601bd8498', './templates/tiki-admin_topics.tpl', '21.12', 0),
('a5f1c2ccb4c2a0bc2f687f68feb168db', './templates/tiki-admin_tracker_fields.tpl', '21.12', 0),
('324ab32692dfd70a7e537ecb13e0c717', './templates/tiki-admin_transitions.tpl', '21.12', 0),
('1c36eacb3f1ca5ef08351518eb14675e', './templates/tiki-admin_webservices.tpl', '21.12', 0),
('d71c0bb64d7ce900d5dbf43e72703475', './templates/tiki-admingroups.tpl', '21.12', 0),
('8a29fa2ccd4e6755869e88c9e2bcb7df', './templates/tiki-adminusers.tpl', '21.12', 0),
('4b426bfe2c7e781baa2120b4a86cde4a', './templates/tiki-ajax_header.tpl', '21.12', 0),
('28fac9b15f9604a51c219beaeef49d0c', './templates/tiki-all_languages.tpl', '21.12', 0),
('3c181d488aaf6a78ad78dd75229b2f00', './templates/tiki-article_types.tpl', '21.12', 0),
('70560c5a8f3407d458647c6c2fbfad65', './templates/tiki-articles-js.tpl', '21.12', 0),
('e0379ff04aca45ebc9b02598ab6ffca2', './templates/tiki-assignuser.tpl', '21.12', 0),
('93bd47a922d2e8438aaab85018824b2b', './templates/tiki-backlinks.tpl', '21.12', 0),
('222200e8b2d481bddaed00d3c55a8e7a', './templates/tiki-batch_upload.tpl', '21.12', 0),
('1169bc0a6a9180028dbb9f8d60506a38', './templates/tiki-batch_upload_files.tpl', '21.12', 0),
('29a7d8cf6409fd3eeb3ae115a3392824', './templates/tiki-blog_post.tpl', '21.12', 0),
('0b50f0f345e91e5217d5c7d305731223', './templates/tiki-browse_categories.tpl', '21.12', 0),
('1c0a78436313b434a24bd863ffbe189a', './templates/tiki-browse_freetags.tpl', '21.12', 0),
('6e228f586ac1722e6f927f41d880b4b8', './templates/tiki-browse_gallery.tpl', '21.12', 0),
('179b20dd4a701a33e932835476d7d79f', './templates/tiki-browse_image.tpl', '21.12', 0),
('de35fea141bd4746b2036890e2141569', './templates/tiki-calendar.tpl', '21.12', 0),
('e0501bf936abc3e50ea636c83ed93bae', './templates/tiki-calendar_box.tpl', '21.12', 0),
('d8b8a5a5761bf64e60052bed2f863b52', './templates/tiki-calendar_box_multiple.tpl', '21.12', 0),
('cd4d85d764219a27aa7dc0c7d996b64e', './templates/tiki-calendar_calmode.tpl', '21.12', 0),
('278de951825ba45695fd8aa0c5fc345c', './templates/tiki-calendar_daymode.tpl', '21.12', 0),
('e1e20fc5410d7c98d7f4f01c0d5d592a', './templates/tiki-calendar_edit_item.tpl', '21.12', 0),
('7390e42f71d0337d12a2487486ecdae3', './templates/tiki-calendar_import.tpl', '21.12', 0),
('0dffdd8bfbd5e439562a601b0b3b2aa5', './templates/tiki-calendar_listmode.tpl', '21.12', 0),
('0bb5e090595c6cf9fc68f3b16f5a2873', './templates/tiki-calendar_nav.tpl', '21.12', 0),
('f1cb73875f91d93b443333e42d37db5a', './templates/tiki-calendar_params_ical.tpl', '21.12', 0),
('a2620d3a9498908438715effbe994547', './templates/tiki-calendar_weekmode.tpl', '21.12', 0),
('da58d6044be3dc375f0a460cb7a610f6', './templates/tiki-change_password.tpl', '21.12', 0),
('7d449412cfd9f4e643bdbce1a9435301', './templates/tiki-check.tpl', '21.12', 0),
('80de1846c598a98339c2b48fc4dc3133', './templates/tiki-choose_page_language.tpl', '21.12', 0),
('752af520d6ece957eb3ddb6dfeea0a5e', './templates/tiki-contact.tpl', '21.12', 0),
('c5d2d2f5282b42ffeae37317c1a87d45', './templates/tiki-contacts.tpl', '21.12', 0),
('5ef544a8d90439445cc856b499f519b9', './templates/tiki-copypage.tpl', '21.12', 0),
('7f5a5d8869eded346a8bcb4d91d4ac0d', './templates/tiki-create_multilang_pages.tpl', '21.12', 0),
('31482be3c979fd73ed636e57a80b3b0c', './templates/tiki-create_webhelp.tpl', '21.12', 0),
('e8c3eee9aa2bcdc9fdd6cd5ac446b276', './templates/tiki-directory_add_site.tpl', '21.12', 0),
('fec938adc691519c3094d7d89adc0f1a', './templates/tiki-directory_admin.tpl', '21.12', 0),
('5f3e3da1bc268f2a76c5e2fc52a78140', './templates/tiki-directory_admin_bar.tpl', '21.12', 0),
('4e00465ac95881131f9c9ff4df4a39aa', './templates/tiki-directory_admin_categories.tpl', '21.12', 0),
('1efcf2bfcc76f649afb5e3dd844764e4', './templates/tiki-directory_admin_related.tpl', '21.12', 0),
('6624be278f38132e654b5fdee4b04c95', './templates/tiki-directory_admin_sites.tpl', '21.12', 0),
('5787b3156abe29ddd387741029cc0b6c', './templates/tiki-directory_bar.tpl', '21.12', 0),
('60adc4ce70c389db916232ee0eeeac00', './templates/tiki-directory_browse.tpl', '21.12', 0),
('cb5f15fea20871b69be9359e65149a04', './templates/tiki-directory_footer.tpl', '21.12', 0),
('62d14cfe5dd81b6dc8929b00e81347a1', './templates/tiki-directory_ranking.tpl', '21.12', 0),
('d770ad10ca93a24de6b54e47cccbae4b', './templates/tiki-directory_search.tpl', '21.12', 0),
('b6f4a763c877bd32b96970132a03fdf3', './templates/tiki-directory_validate_sites.tpl', '21.12', 0),
('f6e314a07a998f48230d8f33d181c170', './templates/tiki-discount.tpl', '21.12', 0),
('6c5fbbf31d364085140fda0f3cdd5b22', './templates/tiki-edit-page-include-prompt_for_edit_or_translate.tpl', '21.12', 0),
('4dd08788a28a1a194cecdea20fc648f6', './templates/tiki-edit-page-included_by.tpl', '21.12', 0),
('802812b6c65e6e27d2cbe6daef6112f2', './templates/tiki-edit_article.tpl', '21.12', 0),
('d970babc063cc45b9afc8fa29a4d3f7c', './templates/tiki-edit_banner.tpl', '21.12', 0),
('fd5c829e320cdbed9d710c9ea9ecd801', './templates/tiki-edit_blog.tpl', '21.12', 0),
('53004609b132d9aa35eb42525b8212b0', './templates/tiki-edit_categories.tpl', '21.12', 0),
('8a8a2febe818e15bc35e1b840cb940c6', './templates/tiki-edit_css.tpl', '21.12', 0),
('9b6848fe0888c50a865cb2b8e5d29e94', './templates/tiki-edit_docs.tpl', '21.12', 0),
('8263323754ffcf08dc6c9ba4df8b3846', './templates/tiki-edit_draw.tpl', '21.12', 0),
('13181513a1ee8c1c6cd8a72ab87927ba', './templates/tiki-edit_groups.tpl', '21.12', 0),
('d79542fe044eadfa7abd84fa21fd9e69', './templates/tiki-edit_help.tpl', '21.12', 0),
('579f42ea6cfef4906786dc19740c24ad', './templates/tiki-edit_help_plugins.tpl', '21.12', 0),
('44df07f6c61ded1d335423e1bead2a6e', './templates/tiki-edit_help_sheet.tpl', '21.12', 0),
('bd9c8e5ac2cadd91464423a55c538283', './templates/tiki-edit_help_wysiwyg.tpl', '21.12', 0),
('f1fc5c13304ae57a05514385926cea70', './templates/tiki-edit_image.tpl', '21.12', 0),
('ac20691e17af9bcbda79177615d60cfe', './templates/tiki-edit_languages.tpl', '21.12', 0),
('4a4990771a0c40c025b86ccb18b856e0', './templates/tiki-edit_perspective.tpl', '21.12', 0),
('9d2ec8dbd4164daea953896e94e5e049', './templates/tiki-edit_programmed_content.tpl', '21.12', 0),
('1f790a6510e3e1cfe397169f57fffb66', './templates/tiki-edit_question_options.tpl', '21.12', 0),
('541779ae4b0fc873799e4db690e7c694', './templates/tiki-edit_quiz.tpl', '21.12', 0),
('97f6e850da6b0ee1ea34df3a63ba80a2', './templates/tiki-edit_quiz_questions.tpl', '21.12', 0),
('bd40ecf2d44e8dd661f084137bc137d1', './templates/tiki-edit_quiz_results.tpl', '21.12', 0),
('09d4b3b4be4c077eaf0a0fcebe1e8baf', './templates/tiki-edit_report.tpl', '21.12', 0),
('eeb90bbce439f148c53b3b521a77a1ca', './templates/tiki-edit_structure.tpl', '21.12', 0),
('ccfa7b9672d2f86942b6e97f6080a1ee', './templates/tiki-edit_submission.tpl', '21.12', 0),
('a8ca46fa956a01df2d52c39cfbaa7014', './templates/tiki-edit_templates.tpl', '21.12', 0),
('badd3706cf880e412948161a713409b4', './templates/tiki-edit_topic.tpl', '21.12', 0),
('5ec4eea15f15abb253e88b825603abaa', './templates/tiki-edit_translation.tpl', '21.12', 0),
('d054b6706ec390386b4a7b668222478e', './templates/tiki-editpage.tpl', '21.12', 0),
('52cdb62788f5abc40a54cad573bcfff5', './templates/tiki-export-sheets.tpl', '21.12', 0),
('8209cd972522108d644712be2acc314c', './templates/tiki-export_comment_xml.tpl', '21.12', 0),
('531de4d1f555d1f1cccf7bcce60c1218', './templates/tiki-export_page_xml.tpl', '21.12', 0),
('6f1f056dc7e0ab918b225b3ab5b5cd5b', './templates/tiki-export_tracker_item.tpl', '21.12', 0),
('6db458fb8d349ff72c41eb0afa478e2f', './templates/tiki-export_users.tpl', '21.12', 0),
('d83992225689db07b58422ee85fb19c4', './templates/tiki-faq_questions.tpl', '21.12', 0),
('f187d4c586eac637c462ac86d11ee0b7', './templates/tiki-featured_link.tpl', '21.12', 0),
('dc43ca0c6e81dfe5f5c1e51d2597e671', './templates/tiki-file_archives.tpl', '21.12', 0),
('c4847338a84a2c2dfddb81fdf834434f', './templates/tiki-file_info_box.tpl', '21.12', 0),
('e6ff7e9dca1722198170ba84a631183e', './templates/tiki-flaggedrev_approval_header.tpl', '21.12', 0),
('8e886b84d0d9e87388147421ae41d67b', './templates/tiki-forum_import.tpl', '21.12', 0),
('e686168995c1c76abfdbb01dc1987685', './templates/tiki-forum_queue.tpl', '21.12', 0),
('31c02cc4109cd7b2c75f391c0c0bf3a5', './templates/tiki-forums.tpl', '21.12', 0),
('c0f58dad7336d6238e405d40170c2956', './templates/tiki-forums_reported.tpl', '21.12', 0),
('7a90acee77d35b18d7682dd263ecb333', './templates/tiki-freetag-translate.tpl', '21.12', 0),
('85e2758f96a67137773bb610af4ec33c', './templates/tiki-friends.tpl', '21.12', 0),
('819b93ee78859c8ab541779141d68621', './templates/tiki-galleries.tpl', '21.12', 0),
('3a6800d89cc0c796d2264e9cfeef238c', './templates/tiki-graph-sheets.tpl', '21.12', 0),
('35bfab80dbb5c331453ee16817ebd483', './templates/tiki-history_sheets.tpl', '21.12', 0),
('673ddc439c7f1241ffdd2b9ea00e85b7', './templates/tiki-import-sheets.tpl', '21.12', 0),
('d27d6d22e9f783f6c73eb9afcfb1c453', './templates/tiki-import_structuredtext.tpl', '21.12', 0),
('5c686b452f407b02662a12f558fc2c85', './templates/tiki-import_xml_zip.tpl', '21.12', 0),
('008bae55e3e410f1a7a6a34d3e29d107', './templates/tiki-importer.tpl', '21.12', 0),
('f8983f32ebc44c338efbb7032b02b0be', './templates/tiki-index_p.tpl', '21.12', 0),
('36dee357b096beaac5d3d23e1b9790e0', './templates/tiki-information.tpl', '21.12', 0),
('d45a0fe1a543280f8948b7b47baf88b9', './templates/tiki-install.tpl', '21.12', 0),
('ed9654a88eea1a0ec38e8a06aa3c6edb', './templates/tiki-install_screens.tpl', '21.12', 0),
('e73f7eff2552b209697a5a6bf1787a57', './templates/tiki-integrator.tpl', '21.12', 0),
('ef8feec0eda97d90100c908cbfce54d7', './templates/tiki-invite.tpl', '21.12', 0),
('376dee0f9f8816a121330332295826c2', './templates/tiki-invited.tpl', '21.12', 0),
('a1554cb147262dcc4561fbfb23c83532', './templates/tiki-kaltura_upload.tpl', '21.12', 0),
('505a029faef0e437314c640ea4dafac6', './templates/tiki-kaltura_video.tpl', '21.12', 0),
('f32db4ea5bc75ab397c1bc8b9a029fcf', './templates/tiki-lastchanges.tpl', '21.12', 0),
('0386dc039d876dc46fe92990bf789c8d', './templates/tiki-likepages.tpl', '21.12', 0),
('da683ddc421fe91ad2398c3c281c4c84', './templates/tiki-list_articles.tpl', '21.12', 0),
('23977f9a28892a6a7cb28a1926168295', './templates/tiki-list_banners.tpl', '21.12', 0),
('b6ca521eb7e26665df647f810a5f7e84', './templates/tiki-list_blogs.tpl', '21.12', 0),
('efe695fd9319d0d933252f62b3adac58', './templates/tiki-list_cache.tpl', '21.12', 0),
('c839371ddd7190c787ced050eedfdf0b', './templates/tiki-list_comments.tpl', '21.12', 0),
('2c72ff0d3dff1d3445645b47751faa84', './templates/tiki-list_contents.tpl', '21.12', 0),
('00f6caacdc58c015a08bfa1d79c36c2a', './templates/tiki-list_faqs.tpl', '21.12', 0),
('877f77d79282490ce02fcd842115aca2', './templates/tiki-list_file_gallery.tpl', '21.12', 0),
('b89b6f5efc94bd160dbb748abf14a437', './templates/tiki-list_gallery.tpl', '21.12', 0),
('18cd6c0cc8e41040a918c912df940457', './templates/tiki-list_integrator_repositories.tpl', '21.12', 0),
('e661bb92ca8e8ef6d02dc49e64eb40df', './templates/tiki-list_invite.tpl', '21.12', 0),
('6eb616c41be6e4eee4a4fa427d3dea45', './templates/tiki-list_kaltura_browse_entries.tpl', '21.12', 0),
('a4314aefb411e10f37fb17f4cb8674ad', './templates/tiki-list_kaltura_entries.tpl', '21.12', 0),
('6d4dcc13519df0d2f96292ffc67b8a74', './templates/tiki-list_kaltura_entries_actions.tpl', '21.12', 0),
('2d714e244e4dafdbaeb5873b6dd558b3', './templates/tiki-list_kaltura_entries_add_info.tpl', '21.12', 0),
('bfa1042e64ac3d45bcf47a91a921aaea', './templates/tiki-list_kaltura_media_entries.tpl', '21.12', 0),
('8cb1c7c47338bf0c1222945592e419f3', './templates/tiki-list_kaltura_mix_entries.tpl', '21.12', 0),
('331f3897479c6069e358dd4ce9a0c648', './templates/tiki-list_object_permissions.tpl', '21.12', 0),
('7094fa750c4da6f4008db12352417850', './templates/tiki-list_posts.tpl', '21.12', 0),
('ca81a610ca7378400074b98085d642e4', './templates/tiki-list_quizzes.tpl', '21.12', 0),
('6e667284c326dbd17e7c43d8ad79ea39', './templates/tiki-list_submissions.tpl', '21.12', 0),
('3a46f2bc7315b8b31ab1e37b7aab64e1', './templates/tiki-list_surveys.tpl', '21.12', 0),
('c2ebef276d706129fe73e6cfaeed7428', './templates/tiki-list_trackers.tpl', '21.12', 0),
('8c4e8ee2d2510d7735686a87bf5a8882', './templates/tiki-list_users.tpl', '21.12', 0),
('bff7f71387623d99a8d4dee01a393d97', './templates/tiki-listpages.tpl', '21.12', 0),
('292ef21829fd3ab39022d08df9f3258e', './templates/tiki-listpages_content.tpl', '21.12', 0),
('fe21a036135130eb3d205efef124b92f', './templates/tiki-live_support_admin.tpl', '21.12', 0),
('06e66df6d9c3cc0fc1aa4d6887f32041', './templates/tiki-live_support_chat_window.tpl', '21.12', 0),
('cc9b8b9571eaafed8277057baf1a1577', './templates/tiki-live_support_client.tpl', '21.12', 0),
('812574afb2c169eb840ba03b5d61a3b8', './templates/tiki-live_support_console.tpl', '21.12', 0),
('a906226ab572fc843a3288a60e305855', './templates/tiki-live_support_transcripts.tpl', '21.12', 0),
('e5f97f211d939e2b7cb85e85323b0bca', './templates/tiki-login.tpl', '21.12', 0),
('991706f8c921e6aa5cc51ebb20921086', './templates/tiki-login_confirm_email.tpl', '21.12', 0),
('ada7920c44f1d81b571cbed20cbc2500', './templates/tiki-mailin.tpl', '21.12', 0),
('dbee42edacc25ac26bfa0fb41d2e3ab1', './templates/tiki-mindmap.tpl', '21.12', 0),
('a7087176a94360c349dc644250c9a848', './templates/tiki-minical.tpl', '21.12', 0),
('22f4019959df5093c7687e0d118ea6e4', './templates/tiki-minical_prefs.tpl', '21.12', 0),
('2a4b54f6eaf3e5940d047a2b0ef8f38b', './templates/tiki-mods.tpl', '21.12', 0),
('b15a1b9de95ff7fbc9d14e0bb497301a', './templates/tiki-my_tiki.tpl', '21.12', 0),
('ca91c4a552e1c91f9b74d5f0b134f73f', './templates/tiki-mytiki_bar.tpl', '21.12', 0),
('0df9cd4dbd2388bac16c8fb3a529d059', './templates/tiki-newsletter_archives.tpl', '21.12', 0),
('caded2f17a2b14a74df4f369b06e7c68', './templates/tiki-newsletters.tpl', '21.12', 0),
('464e5ef10d85a47f9da601fe22f3e190', './templates/tiki-notepad_list.tpl', '21.12', 0),
('5f30a947fea71f7df6fe19be0fdd7e7a', './templates/tiki-notepad_read.tpl', '21.12', 0),
('ec48861eb8b1704a7d9c875232ce1d3f', './templates/tiki-notepad_write.tpl', '21.12', 0),
('881555398f7d6546ea07165f0f23d933', './templates/tiki-object_watches.tpl', '21.12', 0),
('466261201f7b896957ba3c14a6bbf0bd', './templates/tiki-objectpermissions.tpl', '21.12', 0),
('57612e1b4ce699875d99a8da01c3a38d', './templates/tiki-old_polls.tpl', '21.12', 0),
('7c00215e4a01e56e7a383e950666ee13', './templates/tiki-openid_select.tpl', '21.12', 0),
('b8f184d56cf596d55b50edaf1ceb8b00', './templates/tiki-orphan_pages.tpl', '21.12', 0),
('ddd4f2df35a8a43c254e81946fa0360b', './templates/tiki-page.tpl', '21.12', 0),
('aa71e20337d40ce8685e76f0e003ddec', './templates/tiki-page_bar.tpl', '21.12', 0),
('f33441664ddd010acc0b693337cf1a34', './templates/tiki-page_contribution.tpl', '21.12', 0),
('a9fcfc61c26e125cdea2e4dca53c3e91', './templates/tiki-page_contribution_form.tpl', '21.12', 0),
('bebcab8d76acbf18ea4b309fa13f1fa3', './templates/tiki-pagehistory.tpl', '21.12', 0),
('b0f9b4b4217c854d42fb6b45e82f8e54', './templates/tiki-payment-cclite.tpl', '21.12', 0),
('a99ef8e4d8024692f8e2d1de39b8f17a', './templates/tiki-payment-israelpost.tpl', '21.12', 0),
('414896601364456fb248669e42ed1cf9', './templates/tiki-payment-list-past.tpl', '21.12', 0),
('b428f4b9d5bcf120a19ebd8b065e095e', './templates/tiki-payment-list.tpl', '21.12', 0),
('b64fbecccefdfe72f6c65ab972f9cb5a', './templates/tiki-payment-paypal.tpl', '21.12', 0),
('8fe3e6dfe14511ca30f55af668f267d0', './templates/tiki-payment-single.tpl', '21.12', 0),
('a600baf7485b6988448ed46fab07ec0e', './templates/tiki-payment-tikicredits.tpl', '21.12', 0),
('c83c2d7169f0be6f7b04962939981257', './templates/tiki-payment-user.tpl', '21.12', 0),
('7b1f0ea188329851655d28cd030b6403', './templates/tiki-payment.tpl', '21.12', 0),
('e0300a817b345c3f9c2ef57434e21b31', './templates/tiki-pick_avatar.tpl', '21.12', 0),
('e828ee9f6376b0ac3442502441133898', './templates/tiki-plugin_blocked.tpl', '21.12', 0),
('5132e425443cccc3b48d2b4885460960', './templates/tiki-plugin_help.tpl', '21.12', 0),
('c6647f3362368d66a6fb3dd96cedbd52', './templates/tiki-plugin_poll.tpl', '21.12', 0),
('f0b6def65637d946d8ef455168b63f90', './templates/tiki-plugin_sql.tpl', '21.12', 0),
('6972b2cb3ca1138c28dd693da91e219c', './templates/tiki-pluginlist_experiment.tpl', '21.12', 0),
('6b3cb7b3c1abcd8e4b2632c9fe0f8023', './templates/tiki-plugins.tpl', '21.12', 0),
('4efa3ae9f4942917bba004e8669f6997', './templates/tiki-poll.tpl', '21.12', 0),
('0fd1b304b114ee8483bdc5495fa62229', './templates/tiki-poll_form.tpl', '21.12', 0),
('09f1a4b62a3b4a4f3ef35f043d51e874', './templates/tiki-poll_results.tpl', '21.12', 0),
('d8709eae5ebd446b8eb40eec1267b261', './templates/tiki-poll_results_bar.tpl', '21.12', 0),
('3e7e3b1d6c2828ade2f14af5745cd00e', './templates/tiki-preference_translate.tpl', '21.12', 0),
('d2e3217d1a8690b30ad96d05817c4fc5', './templates/tiki-preview.tpl', '21.12', 0),
('7de66e3871d6edd9704b1c9d4d955d10', './templates/tiki-print.tpl', '21.12', 0),
('6765bec86d2886729063e66d8dcd75f4', './templates/tiki-print_article.tpl', '21.12', 0),
('34ff232cb0ca1454de84975144c74609', './templates/tiki-print_blog_post.tpl', '21.12', 0),
('f7a246156200d4555bfba7fd3713dea8', './templates/tiki-print_forum_thread.tpl', '21.12', 0),
('e440bdb591e102c7e6e42de67cedd9a3', './templates/tiki-print_multi_pages.tpl', '21.12', 0),
('6e5455d3a551e35a345b6cdc74c457b3', './templates/tiki-print_pages.tpl', '21.12', 0),
('ec1e5e12b16678d91168dc6bb87149a7', './templates/tiki-quiz_edit.tpl', '21.12', 0),
('997f5da23fac83c9c8430124d0a39a96', './templates/tiki-quiz_result_stats.tpl', '21.12', 0),
('5a16742ace59fe81fe6476902d0bd520', './templates/tiki-quiz_stats.tpl', '21.12', 0),
('53c8e13882f0cd332811909299977a84', './templates/tiki-quiz_stats_quiz.tpl', '21.12', 0),
('f61350bd4fa5eb9d662864f4060e81e2', './templates/tiki-ranking.tpl', '21.12', 0),
('3c4d8edbb7df88d4d5bb4db75bf6f100', './templates/tiki-read_article.tpl', '21.12', 0),
('e6e2a10fc08d93a48eece41b9c63172e', './templates/tiki-received_articles.tpl', '21.12', 0),
('4ca6a49103a1f49ab11e4ea40d746bdf', './templates/tiki-received_pages.tpl', '21.12', 0),
('d9b16404f2b42915b74641d805b01001', './templates/tiki-references.tpl', '21.12', 0),
('0066889c1abffd48f40c48d92d9c934b', './templates/tiki-referer_stats.tpl', '21.12', 0),
('d81aacb4d74a66f9ac482fb899cd6ba3', './templates/tiki-register.tpl', '21.12', 0),
('94b03ddc5fed1f2ec7b3a02951a56f30', './templates/tiki-register_site.tpl', '21.12', 0),
('1adaaaa5db35c5489fd7f7ca51a26a7e', './templates/tiki-remind_password.tpl', '21.12', 0),
('aa1167ac659d8d7e198192e70b0011d2', './templates/tiki-rename_page.tpl', '21.12', 0),
('f270606bcaf8369dbdb1fff21fd3db70', './templates/tiki-report_direct_object_perms.tpl', '21.12', 0),
('e14d0bab9f430a67067052a2af7d46ef', './templates/tiki-rollback.tpl', '21.12', 0),
('40c819d8c9c8f40b4d265a524f1f1d04', './templates/tiki-search_count.tpl', '21.12', 0),
('3003a4e5fb2df8901ed0bbb7e5384099', './templates/tiki-search_replace.tpl', '21.12', 0),
('e9b5b7e6f3d83934cef150d1b1d81779', './templates/tiki-search_stats.tpl', '21.12', 0),
('114b095350d2d002d00a13476d0fe2d8', './templates/tiki-searchfacets.tpl', '21.12', 0),
('1b753f3f625a01b1a9ff2b53fd38e0a1', './templates/tiki-searchindex.tpl', '21.12', 0),
('0081e8ce9e55c4c1a7c5093b4b803c39', './templates/tiki-searchindex_form.tpl', '21.12', 0),
('46add2b9d5829f75390b756c1ec26ac1', './templates/tiki-searchresults.tpl', '21.12', 0),
('5d5c32c1cc16ac8b4bbeb45ce9fc3258', './templates/tiki-send_newsletters.tpl', '21.12', 0),
('73254f127ab26f94a4e69a5fffa58f58', './templates/tiki-send_objects.tpl', '21.12', 0),
('4ad3d39760eb71d2fea014381debf180', './templates/tiki-share.tpl', '21.12', 0),
('9ff76862cfcc264bdf5685ae8156eff9', './templates/tiki-sheets.tpl', '21.12', 0),
('e22fb04cd3b0e0e6a958cdad94514de6', './templates/tiki-sheets_listing.tpl', '21.12', 0),
('48bce49bd31448269ec2fa5c2cc02342', './templates/tiki-shoutbox.tpl', '21.12', 0),
('1a00e0aeccabae6852702dd0d92eb4c5', './templates/tiki-show_page.tpl', '21.12', 0),
('8bfc8720512d6c32ea292f36338c2b2d', './templates/tiki-show_page_raw.tpl', '21.12', 0),
('aeff7502c0ed4295d10e2b0187f3b0ee', './templates/tiki-socialnetworks.tpl', '21.12', 0),
('d85983b8d95c91a658030eacb5b8cd4c', './templates/tiki-socialnetworks_firstlogin.tpl', '21.12', 0),
('a3bc42d0112ac8454f7eac162fcb0ff6', './templates/tiki-socialnetworks_firstlogin_launcher.tpl', '21.12', 0),
('eaeffd857f48fb25d32831d78c01c4c0', './templates/tiki-sqllog.tpl', '21.12', 0),
('12eb5174e139f82d31a6a7f7a321c8a8', './templates/tiki-stats.tpl', '21.12', 0),
('db626a7eda1e628bebfde23789fd8ce3', './templates/tiki-survey_stats.tpl', '21.12', 0),
('7861085cb81171887dd015d22dea4dba', './templates/tiki-survey_stats_survey.tpl', '21.12', 0),
('4e4876c9fe9cf97be907296be2328fc3', './templates/tiki-syslog.tpl', '21.12', 0),
('73ab64e27a24d6238337a34ecb3786e8', './templates/tiki-take_quiz.tpl', '21.12', 0),
('ac4ed3c86cff4e8f9c748adbcfbb9d32', './templates/tiki-take_survey.tpl', '21.12', 0),
('884f4c950cf129df6e5034fb52297b70', './templates/tiki-tests_edit.tpl', '21.12', 0),
('780c9d20d7660cc02947664a763b964e', './templates/tiki-tests_list.tpl', '21.12', 0),
('81278da490d57498acbbdc64e9bdbcb6', './templates/tiki-tests_menubar.tpl', '21.12', 0),
('bb574c7c7e635b1de7a9ac3aef837300', './templates/tiki-tests_record.tpl', '21.12', 0),
('57cb3e3a93cb01c869b6458233f10825', './templates/tiki-tests_replay.tpl', '21.12', 0),
('95246b3f3dde419344d5a49cc1239d6c', './templates/tiki-tests_topbar.tpl', '21.12', 0),
('29aef633f3c0b8ea9359d73126c7b330', './templates/tiki-theme_control.tpl', '21.12', 0),
('11b0d4c92d2ee33c6d9577c2dc657857', './templates/tiki-theme_control_objects.tpl', '21.12', 0),
('b14e53dcea14ba5be7aa8da392baee9b', './templates/tiki-theme_control_sections.tpl', '21.12', 0),
('a99f283935c3d34f280693f635e70000', './templates/tiki-timesheet.tpl', '21.12', 0),
('933fef8fafcc91c9ae6ace838eacbc34', './templates/tiki-tracker_force_fill.tpl', '21.12', 0),
('ae8bfaf87411254cf18c325fe6caab67', './templates/tiki-tracker_reports.tpl', '21.12', 0),
('42eee4028b520e232c0a15957cde968a', './templates/tiki-tracker_view_history.tpl', '21.12', 0),
('5aa58dc9737f433ce3fae00a28938364', './templates/tiki-upload_file.tpl', '21.12', 0),
('8c92ef983df662b97a77a3fa5570df89', './templates/tiki-upload_file_progress.tpl', '21.12', 0),
('1bf6c260b1e900df7e03fa564084cada', './templates/tiki-upload_image.tpl', '21.12', 0),
('87da6631263d9d88137c672dcfb2c12e', './templates/tiki-user_assigned_modules.tpl', '21.12', 0),
('51187f7dc743abd1cd8baa83d0502a44', './templates/tiki-user_bookmarks.tpl', '21.12', 0),
('3e422d057f1824937bdb85655cc36edc', './templates/tiki-user_contacts_prefs.tpl', '21.12', 0),
('b3476994ee76713a8a65dafaa85cb65d', './templates/tiki-user_cssmenu.tpl', '21.12', 0),
('b53eac560a0f1f1c5498196b20b70867', './templates/tiki-user_information.tpl', '21.12', 0),
('78ee0fe6abd84950f7b0ac4595d6c754', './templates/tiki-user_mailin.tpl', '21.12', 0),
('3ba12b45ee7c03c0dea4e5f63bb402d6', './templates/tiki-user_menu.tpl', '21.12', 0),
('ee24e9939859e4e475d4d46a7db60e30', './templates/tiki-user_preferences.tpl', '21.12', 0),
('2612fe37f9d2ca389c224046ee012423', './templates/tiki-user_tasks.tpl', '21.12', 0),
('2674fd451cc0ba81a3e3064290a8f88c', './templates/tiki-user_tasks_edit.tpl', '21.12', 0),
('df512a51d9a53f5e0e89575c75baaeb5', './templates/tiki-user_tasks_list.tpl', '21.12', 0),
('38d6ccd3e48e8ada6f2a832199bcf5fb', './templates/tiki-user_tasks_view.tpl', '21.12', 0),
('fbdd428448fecbd5da3976fa676565d7', './templates/tiki-user_unified_details.tpl', '21.12', 0),
('3c9e4c3596c7f22a7aa3abe375d5c569', './templates/tiki-user_watches.tpl', '21.12', 0),
('e530146f638fb4b97606cc5adae414b5', './templates/tiki-userfiles.tpl', '21.12', 0),
('d63734b839de70a60deed161fc4afb8f', './templates/tiki-usermenu.tpl', '21.12', 0),
('be6834a6175e3bd9bad93e2ef8093cfb', './templates/tiki-userversions.tpl', '21.12', 0),
('3e94922eee5de4004cdbafc453987b25', './templates/tiki-view_articles-titleonly.tpl', '21.12', 0),
('5ceed3de5086bfa92e62685031c35626', './templates/tiki-view_articles.tpl', '21.12', 0),
('932df420efd04ddb062a1daf135e4c54', './templates/tiki-view_banner.tpl', '21.12', 0),
('d4af2dfa32450d4740f847f5e3532cad', './templates/tiki-view_blog.tpl', '21.12', 0),
('37607f8bc38eec74420014f77a73ea43', './templates/tiki-view_blog_post.tpl', '21.12', 0),
('0202745dcdb061cd5a1859cf1298bc02', './templates/tiki-view_cache.tpl', '21.12', 0),
('308d6081188a33137ef8c8cb95131883', './templates/tiki-view_faq.tpl', '21.12', 0),
('4c75747bdf6d9e266672cc9253164957', './templates/tiki-view_forum.tpl', '21.12', 0),
('6121d0c6ec33f4981cafb71f8676ce9c', './templates/tiki-view_forum_thread.tpl', '21.12', 0),
('67069a019fe3e74a61090b5c2aa60972', './templates/tiki-view_sheets.tpl', '21.12', 0),
('7cb31d7e549a2116aa12507714e682fb', './templates/tiki-view_sheets_menu.tpl', '21.12', 0),
('b570a3ea9cb8e3c2f1de48801ccaf8a2', './templates/tiki-view_tracker.tpl', '21.12', 0),
('0e90e66cd96156539a8aa1eaf33f421b', './templates/tiki-view_tracker_item.tpl', '21.12', 0),
('480fc3ea34d4b540a61467ca2b56b767', './templates/tiki-view_tracker_more_info.tpl', '21.12', 0),
('652ed45c19d4bd85e66094c7785157c4', './templates/tiki-webdav-wiki.tpl', '21.12', 0),
('930680c6da83fa5a82721f0ca03362ca', './templates/tiki-webdav.tpl', '21.12', 0),
('6f32172ee4b9cffc12d53c355326ba84', './templates/tiki-webmail.tpl', '21.12', 0),
('cb6ec2209e6b4d152a06ef9de13cd974', './templates/tiki-webmail_contacts.tpl', '21.12', 0),
('c40d4017279b02b1c9774d41faf87941', './templates/tiki-wiki_structure_bar.tpl', '21.12', 0),
('f678c2ee9e14150df48f381401e8bb7b', './templates/tiki-wiki_topline.tpl', '21.12', 0),
('4859a94b09531c975436131d6ca07b48', './templates/tiki-wizard_admin.tpl', '21.12', 0),
('41a39f7600d1fd17ea6e6a6fbaea873e', './templates/tiki-wizard_user.tpl', '21.12', 0),
('6791c0d95e2c7b68b08c377edcc5e3ae', './templates/tiki.tpl', '21.12', 0),
('655d2dc39aefe337be070077f50b7125', './templates/tiki_full.tpl', '21.12', 0),
('10329061cdb7d00fd74e8311c98db6e7', './templates/tracker/add_field.tpl', '21.12', 0),
('2ca163d122b47bb4d9f9eac49bd856d4', './templates/tracker/clear.tpl', '21.12', 0),
('893e87c1a1f4e003dfbc767e9f9157cd', './templates/tracker/clone_item.tpl', '21.12', 0),
('53ca0424cef640507e07f4c8050085b5', './templates/tracker/duplicate.tpl', '21.12', 0),
('9256723aedfeba1781dcc27dac4b1a8e', './templates/tracker/edit_field.tpl', '21.12', 0),
('afb165474b9384c3fe102e4290096f27', './templates/tracker/export.tpl', '21.12', 0),
('09383ee3327f8f8a767350586865e406', './templates/tracker/export_fields.tpl', '21.12', 0),
('24ba6b374f1f308b0744d24960c6c757', './templates/tracker/export_profile.tpl', '21.12', 0),
('137616f0e2204235ffe55c25855d7db1', './templates/tracker/fetch_item_field.tpl', '21.12', 0),
('a39e30dca8bc64879a1f80d19deb666d', './templates/tracker/import.tpl', '21.12', 0),
('070a4b31233439bb669b30f0991535ae', './templates/tracker/import_fields.tpl', '21.12', 0),
('4c76003cb1553ce4a404f36b2d1d447d', './templates/tracker/import_items.tpl', '21.12', 0),
('5e690ff0ece7a08acef05e14d9f0b08f', './templates/tracker/import_profile.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/tracker/index.php', '21.12', 0),
('4891226a2802ffff43787605b7250dd1', './templates/tracker/insert_item.tpl', '21.12', 0),
('2830060c10cb566eb213cc2ca03d045e', './templates/tracker/preview_item.tpl', '21.12', 0),
('54f571445195c890183c5904d3e406cd', './templates/tracker/remove.tpl', '21.12', 0),
('ed325d7de1046edc1c8a5aeb2f888c13', './templates/tracker/remove_fields.tpl', '21.12', 0),
('6b1670c954d54ceff06b16774791b513', './templates/tracker/remove_item.tpl', '21.12', 0),
('0b950328934ba59c9ce7c1f30540c161', './templates/tracker/replace.tpl', '21.12', 0),
('836265f1cd95c98a9cd615c8f56727a1', './templates/tracker/search_help.tpl', '21.12', 0),
('926074d1532e65a0f5bc665d7c362266', './templates/tracker/select_tracker.tpl', '21.12', 0),
('725bf5e66542cf9c6e90448108c3ac38', './templates/tracker/update_item.tpl', '21.12', 0),
('e2de0d007867c55a28b46b117cbc5285', './templates/tracker/update_item_status.tpl', '21.12', 0),
('8174dea0f7da81bb53e78732179f2265', './templates/tracker/view.tpl', '21.12', 0),
('74bcdc85a8372abb7a1040d1fc67432f', './templates/tracker_actions.tpl', '21.12', 0),
('fe11a9abd054bd8c0d78a4c05c734126', './templates/tracker_calendar_over.tpl', '21.12', 0),
('ac195a4240e73ed32ca0571f29cdf7dd', './templates/tracker_error.tpl', '21.12', 0),
('ca91d7c368dea356d4e0c723d015f0e3', './templates/tracker_filter.tpl', '21.12', 0),
('15876071d10124664660c733b3490604', './templates/tracker_input_field.tpl', '21.12', 0),
('514d399b8f7074bb0e1a7f7af768db04', './templates/tracker_pretty_item.tpl', '21.12', 0),
('719b6456693fc174ad3f301dc862d689', './templates/tracker_sort_input.tpl', '21.12', 0),
('31cf2934b7dbfdc664d84e38e761362a', './templates/tracker_status_input.tpl', '21.12', 0),
('22cd84ceb05c29f5feda42d047fe0bf9', './templates/tracker_sync/clone_remote.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/tracker_sync/index.php', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/tracker_todo/index.php', '21.12', 0),
('e1c831841460022642121458eace9775', './templates/tracker_todo/view.tpl', '21.12', 0),
('04b443b980d6df40d727a150a7afca01', './templates/tracker_validator.tpl', '21.12', 0),
('acec0066ad5c553ddb22803e80fa5ec6', './templates/trackerinput/articles.tpl', '21.12', 0),
('50cad9367a0e60ce090f4afa0130a229', './templates/trackerinput/autoincrement.tpl', '21.12', 0),
('ae203ef46ffce09f99e68c13fc431c0c', './templates/trackerinput/calendaritem.tpl', '21.12', 0),
('a10b6a6121dda6aab875c3abf1899773', './templates/trackerinput/category.tpl', '21.12', 0),
('94bb89d2490c6b5ed590f96a004de2b1', './templates/trackerinput/checkbox.tpl', '21.12', 0),
('e02eedc61c1f3f028fde0b50b2f60f76', './templates/trackerinput/countryselector.tpl', '21.12', 0),
('8e143035b0feea2814e7333ad9cee3b2', './templates/trackerinput/currency.tpl', '21.12', 0),
('1e3cc23ccf3af6423a553debb34dc02d', './templates/trackerinput/datetime.tpl', '21.12', 0),
('013ac546b7d03d6421a25436350ecbc5', './templates/trackerinput/dropdown.tpl', '21.12', 0),
('10ec7b9c3f11d7e5f60daa7642188ef9', './templates/trackerinput/email.tpl', '21.12', 0),
('d7e9bec12f607f0636a96a10c5441e7e', './templates/trackerinput/file.tpl', '21.12', 0),
('60adec540d32a70561b3deb15a496234', './templates/trackerinput/files.tpl', '21.12', 0),
('d149dc1d66c41ccfbab57548f5bca3ee', './templates/trackerinput/freetags.tpl', '21.12', 0),
('204063f65438b20a1b07dfd7c0e1cdee', './templates/trackerinput/groupselector.tpl', '21.12', 0),
('c0a0ca70eb31cd57fae209b5820f4744', './templates/trackerinput/icon.tpl', '21.12', 0),
('79d14b76790d930fd3844a6d8ddbf091', './templates/trackerinput/image.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/trackerinput/index.php', '21.12', 0),
('a7c5fc2c155249e6ab97219e6e5f7e29', './templates/trackerinput/ip.tpl', '21.12', 0),
('6688e95226a55ac3f8c102207eb54c48', './templates/trackerinput/itemlink.tpl', '21.12', 0),
('a4a19c9d2b2da3a063ea2db72a614cbf', './templates/trackerinput/itemlink_selector.tpl', '21.12', 0),
('4dfecaea429925070f18f6a32547ac1f', './templates/trackerinput/kaltura.tpl', '21.12', 0),
('bb44c01153f9f0697834a898241e3109', './templates/trackerinput/language.tpl', '21.12', 0),
('e8e043e636700dc27079f88d2ddfcd51', './templates/trackerinput/layout_flat.tpl', '21.12', 0),
('e8ec619efc631f9cb97b741b52966aa9', './templates/trackerinput/layout_tab.tpl', '21.12', 0),
('522d0dd4a22ae21b6e8ceecfd5b79173', './templates/trackerinput/location.tpl', '21.12', 0),
('8971ca2cc4840517d0438e3c120411e5', './templates/trackerinput/numeric.tpl', '21.12', 0),
('fcad9902e3c44991dae6765e795af0d3', './templates/trackerinput/pageselector.tpl', '21.12', 0),
('d74b78121c00c0b6fe240356c2b8a23b', './templates/trackerinput/rating.tpl', '21.12', 0),
('72611af50c115c9280da05bca8719f6f', './templates/trackerinput/relation.tpl', '21.12', 0),
('fd95dbafc0a15493b68ff6f114ef2cea', './templates/trackerinput/showtikiorg.tpl', '21.12', 0),
('a89656f9029553c3bfd9cb1ec24e48af', './templates/trackerinput/statictext.tpl', '21.12', 0),
('f681ac0144b7b0df53e2f78508bcf320', './templates/trackerinput/status.tpl', '21.12', 0),
('f9a97075fd7e7d00f3e7adc44f3a4c46', './templates/trackerinput/text.tpl', '21.12', 0),
('afb060237f45f4e9d74fd9f04e62ec53', './templates/trackerinput/textarea.tpl', '21.12', 0),
('99652e7359cd5c1c7d6067fabbc1b7e6', './templates/trackerinput/url.tpl', '21.12', 0),
('c93a1f89ede44aa8df361f4497c2d8fb', './templates/trackerinput/userpreference.tpl', '21.12', 0),
('44333b77f108508288d8519106cd4d25', './templates/trackerinput/userselector_grouped.tpl', '21.12', 0),
('163422318ab613d775c91f6873d6e15b', './templates/trackerinput/usersubscription.tpl', '21.12', 0),
('6fb1880f1da071d25604a8fa86cbf411', './templates/trackerinput/wiki.tpl', '21.12', 0),
('86465ec8986c59128e96e0b3feaa5e42', './templates/trackeroutput/articles.tpl', '21.12', 0),
('6f2e3b5330a53709eff171be655a097e', './templates/trackeroutput/computed.tpl', '21.12', 0),
('013bb12adb2d542aa7bcf1c314f0c66c', './templates/trackeroutput/files_googleviewer.tpl', '21.12', 0),
('167aa5157320d8de3ba0efda1bcf2a68', './templates/trackeroutput/files_table.tpl', '21.12', 0),
('d5c2eb66bb625ee678934da0ddbcc84a', './templates/trackeroutput/freetags.tpl', '21.12', 0),
('1efff3f4a91cd73b1fff5b292f0d0d82', './templates/trackeroutput/icon.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/trackeroutput/index.php', '21.12', 0),
('9661bfaa8d25d61d79ddb21a63673dab', './templates/trackeroutput/itemslist.tpl', '21.12', 0),
('8d6d1c152eb8182c427dd46328cd0d4d', './templates/trackeroutput/language.tpl', '21.12', 0),
('8c526161f4777d6389334dd7c0905123', './templates/trackeroutput/layout_flat.tpl', '21.12', 0),
('44f1f930c0af54974d42ef685af8e9f0', './templates/trackeroutput/layout_tab.tpl', '21.12', 0),
('5eb4a3f2847c76a0dd9c2ca398c6cfad', './templates/trackeroutput/location.tpl', '21.12', 0),
('00ba09eaf8d09a6771a3e6604d05139f', './templates/trackeroutput/numeric.tpl', '21.12', 0),
('123c0ae8bae274f74c3b66c2835e28da', './templates/trackeroutput/popup.tpl', '21.12', 0),
('d40e707e3e2511872c8ddc98c5039a00', './templates/trackeroutput/rating.tpl', '21.12', 0),
('b88c9c707070cdf8fcc099a6cbb1d3be', './templates/trackeroutput/relation.tpl', '21.12', 0),
('42189d5d9ff21720f400724faa4d7db1', './templates/trackeroutput/text_history.tpl', '21.12', 0),
('368e77e7d458ef9583045e1a4e714ac9', './templates/trackeroutput/usergroups.tpl', '21.12', 0),
('397d048aee8585970dcd00bed0faddab', './templates/trackeroutput/usersubscription.tpl', '21.12', 0),
('9b159eb98f665ddbdbc1f6b7213940a7', './templates/translated-lang.tpl', '21.12', 0),
('5bc77e6bcd4fa406861b45773e27acec', './templates/translation/detach.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/translation/index.php', '21.12', 0),
('6bea4a0c51db467106fa49282b15288d', './templates/translation/manage.tpl', '21.12', 0),
('35e06ca65e3135e77ff7ef428fa85c8c', './templates/user/email_wikipage.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/user/index.php', '21.12', 0),
('f129c23e54cf87401e1d94eb8c552510', './templates/user/info.tpl', '21.12', 0),
('f61e7989e15ca6fead26ffc5b71b4155', './templates/user/manage_groups.tpl', '21.12', 0),
('225298738b7a1a9c079b1d045a97596e', './templates/user/register.tpl', '21.12', 0),
('17b8e69464dc654e0509d607e85dab08', './templates/user/remove_users.tpl', '21.12', 0),
('d02ce9dd19d6d98ab815652415936943', './templates/user/send_message.tpl', '21.12', 0),
('6d96b2c0c0c77e1be5784a8f23e6f7b7', './templates/user/upload_avatar.tpl', '21.12', 0),
('09eb95cab6249a937f91b5d1fa0fc24a', './templates/user_conditions/age_validation.tpl', '21.12', 0),
('35bfde315b89c2dc6fc240c7a2f1cce4', './templates/user_conditions/approval.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/user_conditions/index.php', '21.12', 0),
('e10159e1b4bf4981461e059b8c791405', './templates/user_registration.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/vimeo/index.php', '21.12', 0),
('fb6fcfa8107d1253ee6fc327ebf078b9', './templates/vimeo/jquery_upload.tpl', '21.12', 0),
('b064fff4c5a40fe9feac483a4de5e696', './templates/vimeo/upload.tpl', '21.12', 0),
('194abcc2e9b99a5d78a48267d89e61db', './templates/vimeo/view.tpl', '21.12', 0),
('554c06f6d097d9cefd8f428317001e89', './templates/wiki-discussion.tpl', '21.12', 0),
('7e68d2e74ec68325b50a2c2b23724ece', './templates/wiki-plugins/error_tracker.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/wiki-plugins/index.php', '21.12', 0),
('a4d761bb87a0ee37666b5d2a1e45de93', './templates/wiki-plugins/trackercalendar.tpl', '21.12', 0),
('a1c45b315793c72efe46cb6744da86e6', './templates/wiki-plugins/wikiplugin_addfreetag.tpl', '21.12', 0),
('64bcd405bc3d5f201852db69d377a3f9', './templates/wiki-plugins/wikiplugin_addreference.tpl', '21.12', 0),
('0f5d9d4d1236fb6df2bedc5ad9f50e2f', './templates/wiki-plugins/wikiplugin_addrelation.tpl', '21.12', 0),
('9dbe6416350be2cd2c186303266992e6', './templates/wiki-plugins/wikiplugin_addtocart.tpl', '21.12', 0),
('200b0e41dd5cc6810eab83cffccdb454', './templates/wiki-plugins/wikiplugin_adjustinventory.tpl', '21.12', 0),
('9f53715ad201949a55e8ef242d197caf', './templates/wiki-plugins/wikiplugin_appframe_mapcontrol.tpl', '21.12', 0),
('0f799c411d22dc856c42ea5e6326d12a', './templates/wiki-plugins/wikiplugin_benchmark.tpl', '21.12', 0),
('406aaac99ac4cd55d02f50c334ee3c19', './templates/wiki-plugins/wikiplugin_bigbluebutton.tpl', '21.12', 0),
('4c4713c1abe1ff0f6a01c81b8568df04', './templates/wiki-plugins/wikiplugin_bigbluebutton_create.tpl', '21.12', 0),
('79c017e39dfcb6f06f705ebf2c8928e6', './templates/wiki-plugins/wikiplugin_bigbluebutton_view_recordings.tpl', '21.12', 0),
('54911fea7356dda6abd604072ac544a0', './templates/wiki-plugins/wikiplugin_bloglist.tpl', '21.12', 0),
('fa7d48f21c2d585dc6ffec4885f6f2ac', './templates/wiki-plugins/wikiplugin_categorytransition.tpl', '21.12', 0),
('a0651ba050c0cd6d701a98930c719fa9', './templates/wiki-plugins/wikiplugin_catorphans.tpl', '21.12', 0),
('fa9be2c234e1dbd5e1cd47476ca3bd20', './templates/wiki-plugins/wikiplugin_cclite.tpl', '21.12', 0),
('91f477e182a187c9ec164ac148bbd431', './templates/wiki-plugins/wikiplugin_colobox.tpl', '21.12', 0),
('3a7210a82d692eb58620c24c156d1a1f', './templates/wiki-plugins/wikiplugin_comment.tpl', '21.12', 0),
('c8da1c39fe66e901e188762a6575424c', './templates/wiki-plugins/wikiplugin_datachannel.tpl', '21.12', 0),
('9f5e3873db2816aba619d3f9924b76da', './templates/wiki-plugins/wikiplugin_diagram.tpl', '21.12', 0),
('febcd8143d182bced73bde4fe6de16e5', './templates/wiki-plugins/wikiplugin_events.tpl', '21.12', 0),
('74d245470b4077830daec722c51e5b4d', './templates/wiki-plugins/wikiplugin_favorite.tpl', '21.12', 0),
('2b0b47a35b583e52f50d6ae8915cbde0', './templates/wiki-plugins/wikiplugin_files.tpl', '21.12', 0),
('9f138852f781679b426a60cb6234bb83', './templates/wiki-plugins/wikiplugin_footnote.tpl', '21.12', 0),
('d0092d2064a12cc6235bb6e3e53ceb42', './templates/wiki-plugins/wikiplugin_footnotearea.tpl', '21.12', 0),
('e7710813c5cc6369a0ff886a553ca3f6', './templates/wiki-plugins/wikiplugin_freetagged.tpl', '21.12', 0),
('1744183a5f444fa87bcf501ebc3d8b58', './templates/wiki-plugins/wikiplugin_friend.tpl', '21.12', 0),
('ee9a3cf66fd2f0cc4005ee5ba7383740', './templates/wiki-plugins/wikiplugin_ftp.tpl', '21.12', 0),
('743512f25da0a8d8c19f4db51fbe0d14', './templates/wiki-plugins/wikiplugin_fullwidthtitle.tpl', '21.12', 0),
('1ad40b2a2c048db54251cc1b577a9184', './templates/wiki-plugins/wikiplugin_galleriffic.tpl', '21.12', 0),
('55ba3b9f420650f3077944d2fc157934', './templates/wiki-plugins/wikiplugin_ganttchart.tpl', '21.12', 0),
('a5452a4aa7bd56a9f7916f103a5a4f7f', './templates/wiki-plugins/wikiplugin_grouplist.tpl', '21.12', 0),
('6789cc9e8c559a5b0c48cb8f0a3b6303', './templates/wiki-plugins/wikiplugin_groupstat.tpl', '21.12', 0),
('618a23709b4480e210e41c7387e89b72', './templates/wiki-plugins/wikiplugin_invite.tpl', '21.12', 0),
('5723922e0187a2692db0822b5f3af925', './templates/wiki-plugins/wikiplugin_kaltura.tpl', '21.12', 0),
('97d0255286dd0bf00452ca0b1b0a83c5', './templates/wiki-plugins/wikiplugin_like.tpl', '21.12', 0),
('dffc7a909a70edeb3e9b8e15365074b9', './templates/wiki-plugins/wikiplugin_listexecute.tpl', '21.12', 0),
('f18a1b8ad3648c82052cdb9ee78e433f', './templates/wiki-plugins/wikiplugin_listpagenames.tpl', '21.12', 0),
('993e827f83746a96b0fd43758943c52c', './templates/wiki-plugins/wikiplugin_localfiles.tpl', '21.12', 0),
('6d8371353d07d70936eace84d73344b7', './templates/wiki-plugins/wikiplugin_mail.tpl', '21.12', 0),
('3fa3da1d8f25cef74fc576d998f2b2bd', './templates/wiki-plugins/wikiplugin_mediaplayer_pdfjs.tpl', '21.12', 0),
('f7ddc43dfaa3810a036b697d021dc364', './templates/wiki-plugins/wikiplugin_memberlist.tpl', '21.12', 0),
('60ef2a61815cf7da08bda27638ccae5e', './templates/wiki-plugins/wikiplugin_memberpayment.tpl', '21.12', 0),
('e196fddabf46dff393ca5c4ebf4540a2', './templates/wiki-plugins/wikiplugin_paypal.tpl', '21.12', 0),
('d93c070d6e5569fc620e742f1f175be1', './templates/wiki-plugins/wikiplugin_pivottable.tpl', '21.12', 0),
('214c0b8b8335673b748b411411ea676f', './templates/wiki-plugins/wikiplugin_playscorm.tpl', '21.12', 0),
('de0b80bd0dfa1423a38d94f131e86e9d', './templates/wiki-plugins/wikiplugin_preference.tpl', '21.12', 0),
('016901415e8e9b647e3f5eaee59465a3', './templates/wiki-plugins/wikiplugin_preview.tpl', '21.12', 0),
('4e1ea4b888f048b1d13ddb6b96ae7337', './templates/wiki-plugins/wikiplugin_profile.tpl', '21.12', 0),
('cef02af53e4a79a899feaadac859c384', './templates/wiki-plugins/wikiplugin_proposal.tpl', '21.12', 0),
('eee090292211ff3277658c0618641f42', './templates/wiki-plugins/wikiplugin_quote.tpl', '21.12', 0),
('7b6306f39261460076c20756d5f0a56b', './templates/wiki-plugins/wikiplugin_relations.tpl', '21.12', 0),
('a49e9305c7ea0ae027307d58d36287ad', './templates/wiki-plugins/wikiplugin_rss.tpl', '21.12', 0),
('04eb0e8ddb49d4eb18552101d61fec0e', './templates/wiki-plugins/wikiplugin_shopperinfo.tpl', '21.12', 0),
('8e70658471277d27f9f5a79b719a9187', './templates/wiki-plugins/wikiplugin_sign.tpl', '21.12', 0),
('2c888d0ae064492428ddd59f048b7e92', './templates/wiki-plugins/wikiplugin_snarf.tpl', '21.12', 0),
('9f2370346f2ca1b2aa17cea9f903f051', './templates/wiki-plugins/wikiplugin_stat.tpl', '21.12', 0),
('f067c559644962c315077b8d40e7eb72', './templates/wiki-plugins/wikiplugin_subscribegroup.tpl', '21.12', 0),
('3c9420f61fa1f89333a0fc89ecc4519b', './templates/wiki-plugins/wikiplugin_subscribegroups.tpl', '21.12', 0),
('5f91d46d0987e4e206b2a6bb4db7435b', './templates/wiki-plugins/wikiplugin_subscribenewsletter.tpl', '21.12', 0),
('4557b1f80fdeec06bc2a13ff0496a9e5', './templates/wiki-plugins/wikiplugin_tabs.tpl', '21.12', 0),
('7ef6086fc417162963e66c2103c1fa86', './templates/wiki-plugins/wikiplugin_timesheet.tpl', '21.12', 0),
('03d4863911052a93196d0404eb796f4b', './templates/wiki-plugins/wikiplugin_tour_template.tpl', '21.12', 0),
('d3c2d171e7521282a7228794b434785b', './templates/wiki-plugins/wikiplugin_trackerfilter.tpl', '21.12', 0),
('c1abf5130902ba7fb2e9fec43c50de39', './templates/wiki-plugins/wikiplugin_trackerlist.tpl', '21.12', 0),
('698f4a9ccd066d6128a87616c93327d7', './templates/wiki-plugins/wikiplugin_trackerprefill.tpl', '21.12', 0),
('47b43dd8fef3e1ef1a86459147821b2c', './templates/wiki-plugins/wikiplugin_trackerstat.tpl', '21.12', 0),
('17578ad324fa3c589904009d723fac2c', './templates/wiki-plugins/wikiplugin_trackertimeline.tpl', '21.12', 0),
('cbb6994c6143f841abd504d557157738', './templates/wiki-plugins/wikiplugin_trade.tpl', '21.12', 0),
('b1834ceec629864cfc89380157f5d36a', './templates/wiki-plugins/wikiplugin_vote.tpl', '21.12', 0),
('03ca9f8f15f13f799223cdbea689f2f1', './templates/wiki-plugins/wikiplugin_xmlupdate.tpl', '21.12', 0),
('97c263ce453c543adbb78ce292c4df57', './templates/wiki-plugins/wikiplugin_xmpp.tpl', '21.12', 0),
('a346511262936022deb75e566baadb8f', './templates/wiki/get_page.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/wiki/index.php', '21.12', 0),
('a803fafdcd6bce70d67ba32cda7998e3', './templates/wiki/regenerate_slugs.tpl', '21.12', 0),
('80fd5268e3e07ab2805cb23c84402da5', './templates/wiki/remove_pages.tpl', '21.12', 0),
('385a68741fa909670ae1c695ea8c3a77', './templates/wiki_authors.tpl', '21.12', 0),
('d0058e05c882cf62b6a5e25925140b83', './templates/wiki_edit.tpl', '21.12', 0),
('9727d903abe7bb0b364dd62d1f25b6b9', './templates/wiki_edit_actions.tpl', '21.12', 0),
('6c6b08f9ad9ee451d7a0784aa984b4bc', './templates/wizard/admin_advanced.tpl', '21.12', 0),
('ecd4eff96b3ad6ccf5877387b91bbeb3', './templates/wizard/admin_auto_toc.tpl', '21.12', 0),
('ade38c6697a11a37a145bc4e8803122c', './templates/wizard/admin_category.tpl', '21.12', 0),
('8b7a2307d23f8f08a1a9db474b788400', './templates/wizard/admin_community.tpl', '21.12', 0),
('6d2848bbf69a59d6b65bfea0a07e27dd', './templates/wizard/admin_date_time.tpl', '21.12', 0),
('ea91b34b4aa1ce85d342b1e42a9b9604', './templates/wizard/admin_editor_type.tpl', '21.12', 0),
('4f35de083a8ab4f5928d80cfb55e2785', './templates/wizard/admin_features.tpl', '21.12', 0),
('5adcb8be2f5008b61753e41e3ddd3f70', './templates/wizard/admin_files.tpl', '21.12', 0),
('0bd39b1ae8e78259446692b982ed5c44', './templates/wizard/admin_files_storage.tpl', '21.12', 0),
('7625a81750daa68b4a13fbb529832914', './templates/wizard/admin_language.tpl', '21.12', 0),
('fb923713ae0b9c0a307283ce1318f6db', './templates/wizard/admin_login.tpl', '21.12', 0),
('615415add6611eacbee8ff62586d345b', './templates/wizard/admin_look_and_feel.tpl', '21.12', 0),
('a10b910d66d8502a71cda0a8c4cb6eb3', './templates/wizard/admin_namespace.tpl', '21.12', 0),
('76202e9ff070add8a0febcf8ed5fcc16', './templates/wizard/admin_search.tpl', '21.12', 0),
('18f9c84da07a43dfc062dd7ccdd13d18', './templates/wizard/admin_structures.tpl', '21.12', 0),
('8f95aa227d074e154759f18713a3fbf1', './templates/wizard/admin_text_area.tpl', '21.12', 0),
('2acd9d41ef749eac9fdcacb33c2c6481', './templates/wizard/admin_wiki.tpl', '21.12', 0),
('9848b6817d54b4d68a817560940410e0', './templates/wizard/admin_wizard.tpl', '21.12', 0),
('edcf131058aac17045e6d698021268cb', './templates/wizard/admin_wizard_completed.tpl', '21.12', 0),
('0b9937696db96eea780e45e36a4632bb', './templates/wizard/admin_wysiwyg.tpl', '21.12', 0),
('6ee43e10d39776efe45acf7bac8dc368', './templates/wizard/changes_doc_page_iframe.tpl', '21.12', 0),
('4761546ef5dbe692dd6958422fa3dcce', './templates/wizard/changes_new_in_13.tpl', '21.12', 0),
('22086682bc596fe26dbd329af89fff96', './templates/wizard/changes_new_in_14.tpl', '21.12', 0),
('5e6f2590d0f8157e7099774cc4cd2497', './templates/wizard/changes_new_in_15.tpl', '21.12', 0),
('8c0ec4caefaeb33cf47cd8469204cee0', './templates/wizard/changes_new_in_16.tpl', '21.12', 0),
('9bea222b2e752bdb4e6534954f8bd357', './templates/wizard/changes_new_in_17.tpl', '21.12', 0),
('8cc15d0c590f6555059a8d5a0895e857', './templates/wizard/changes_new_in_18.tpl', '21.12', 0),
('47cec9f5e42820bb8208542626b2543b', './templates/wizard/changes_new_in_19.tpl', '21.12', 0),
('d2215dc87abe8b8fef5c37e2ad7746df', './templates/wizard/changes_new_in_20.tpl', '21.12', 0),
('13aaf1cdc44631bdc1655bf241a4623e', './templates/wizard/changes_new_in_21.tpl', '21.12', 0),
('7be40a4ebb1e52f344bf029f79671380', './templates/wizard/changes_novice_admin_assistance.tpl', '21.12', 0),
('12c458037ed7c62cf23fff198617b8a4', './templates/wizard/changes_others.tpl', '21.12', 0),
('7a0dbc9f3547fccd810774048483c76f', './templates/wizard/changes_permissions_and_logs.tpl', '21.12', 0),
('781f1b8b72375f64ba200c60c9f3e696', './templates/wizard/changes_send_feedback.tpl', '21.12', 0),
('28d6cb05767ceff4f5983f58eb6eb512', './templates/wizard/changes_trackers.tpl', '21.12', 0),
('378cc2028061ad171edba8b948ae6ef0', './templates/wizard/changes_ui.tpl', '21.12', 0),
('1f72886b3fd292a620ca4030dc95760d', './templates/wizard/changes_wizard_completed.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/wizard/index.php', '21.12', 0),
('f180d980d365fb3fc3b280188bf6aeb7', './templates/wizard/profiles_completed.tpl', '21.12', 0),
('c5bbd1331c75551d6fc1305bc8ca180a', './templates/wizard/profiles_demo_cases_in_project_management.tpl', '21.12', 0),
('ace039559d74485bd83217ab8cad1c80', './templates/wizard/profiles_demo_common_confs.tpl', '21.12', 0),
('7d8f560f22ad3da9a3261e5ec5bfdb69', './templates/wizard/profiles_demo_highly_specialized_confs.tpl', '21.12', 0),
('e6b77cd0fcf77edcf15f4fa21581bcbf', './templates/wizard/profiles_demo_interesting_use_cases.tpl', '21.12', 0),
('7d2f68bc2d760b355ab9a6432446f78d', './templates/wizard/profiles_demo_more_advanced_confs.tpl', '21.12', 0),
('04c56f7a35d4cd019cf3a160ff0290d8', './templates/wizard/profiles_demo_other_interesting_use_cases.tpl', '21.12', 0),
('5d9d79aaf7a0de51e51ae4a5ea14bad3', './templates/wizard/profiles_featured_site_confs.tpl', '21.12', 0),
('a908c3cc5cbf28140bd303c1af91fa8a', './templates/wizard/profiles_useful_admin_confs.tpl', '21.12', 0),
('e1ef724a22c7c256e237e77b162ea8bf', './templates/wizard/profiles_useful_changes_in_display.tpl', '21.12', 0),
('0177a8d626fc07ea6ea70b77039137f2', './templates/wizard/profiles_useful_micro_confs.tpl', '21.12', 0),
('541a59969e8cf89bb9a1a092f23afbba', './templates/wizard/profiles_useful_new_tech_confs.tpl', '21.12', 0),
('d9624b30a79391e64331e4e940ce13ab', './templates/wizard/user_dummy1.tpl', '21.12', 0),
('196c650dc1138558f7dd2f13598b5291', './templates/wizard/user_dummy2.tpl', '21.12', 0),
('d488d7d6f265cc5cb0c644b6758a3ded', './templates/wizard/user_dummy3.tpl', '21.12', 0),
('8b1ca3d789ddd09b682e0e457b38145a', './templates/wizard/user_preferences_info.tpl', '21.12', 0),
('c3b4935755f6b33453f01c57e74d24e0', './templates/wizard/user_preferences_notifications.tpl', '21.12', 0),
('39422d796e1b7f12f4d2a013f3c19cb7', './templates/wizard/user_preferences_params.tpl', '21.12', 0),
('26ac86479ea7fed896e4c698fa274b0f', './templates/wizard/user_preferences_reports.tpl', '21.12', 0),
('8d6d10d2698c6fb5e50ca70aa737742a', './templates/wizard/user_tracker.tpl', '21.12', 0),
('fc5f51f7d77aafd98f8531375d43962b', './templates/wizard/user_wizard.tpl', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('3cb436fa9781f4c76eda5677f403379b', './templates/wizard/user_wizard_completed.tpl', '21.12', 0),
('427a1ac4645c9d27d4d4e82ac462557a', './templates/wizard/wizard_bar_admin.tpl', '21.12', 0),
('81be100f15472ea70aba9dffd0aeafb6', './templates/wizard/wizard_bar_user.tpl', '21.12', 0),
('b69add7b6c5002ae09c4dfe0189ca888', './templates/workspace/add_template.tpl', '21.12', 0),
('48612cde8e872c16ef6674e389c53c0a', './templates/workspace/advanced_edit.tpl', '21.12', 0),
('271400b77c853a307af6a4cc5a75e0a0', './templates/workspace/create.tpl', '21.12', 0),
('bef7c0a5117cba0ec5849a36840f1e50', './templates/workspace/edit_content.tpl', '21.12', 0),
('69deebaf365ee7dbcfa3c77cc152c009', './templates/workspace/edit_template.tpl', '21.12', 0),
('0292fb69ceb258a99fe22794b447b501', './templates/workspace/index.php', '21.12', 0),
('8a1f1779be8770a8424bb57f180ca2c8', './templates/workspace/list_templates.tpl', '21.12', 0),
('d960db9c065bb9a0fe305003d97511eb', './templates/workspace/select_permissions.tpl', '21.12', 0),
('eea973e3f3a02211e36c05d894b49b76', './tests/index.php', '21.12', 0),
('b0ecd13a90cc64d864244b55db445adf', './themes/amelia/css/amelia.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/amelia/css/index.php', '21.12', 0),
('94be1f1d9655c4d1fff1ae1bccabcf0a', './themes/amelia/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/amelia/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/amelia/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/amelia/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/amelia/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/amelia/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/amelia/templates/index.php', '21.12', 0),
('29411e4dec87e4eb279f065312e80ef6', './themes/base_files/css/newsletter.css', '21.12', 0),
('141cb16d34db4f502fa5c11447855538', './themes/base_files/css/printpdf.css', '21.12', 0),
('0e06f6ccacf23457ed7d1957ae853212', './themes/base_files/css/printqueries.css', '21.12', 0),
('8ec11e68115a216b5aac4b2b81574560', './themes/base_files/css/theme-customizer.css', '21.12', 0),
('0ef85c20375fcafef62f3c56ad2e6716', './themes/base_files/css/tiki_base.css', '21.12', 0),
('55170e295fb0e2444f5003c9af264488', './themes/base_files/feature_css/admin.css', '21.12', 0),
('2eeaf2e33677e6b78e1a581e4fdb53f8', './themes/base_files/feature_css/calendar-print.css', '21.12', 0),
('fae84e1b1b3c8e5a34a299a56eee69a7', './themes/base_files/feature_css/calendar.css', '21.12', 0),
('66e3c6ba0ab0c6e5fca877e3361ad2ad', './themes/base_files/feature_css/codemirror_mode_tiki.css', '21.12', 0),
('6a4fc565e9e25197a3cc8c8234042200', './themes/base_files/feature_css/codemirror_tiki.css', '21.12', 0),
('4efa8e0f9550faa581186f2c28b02c71', './themes/base_files/feature_css/galleriffic.css', '21.12', 0),
('4a9726fa26f6576eef9179966c93c912', './themes/base_files/feature_css/index.php', '21.12', 0),
('0fd2e3a718ce5dee58a213187bc85744', './themes/base_files/feature_css/jscalendar.css', '21.12', 0),
('0e4c3417e83c51768060b087347c344f', './themes/base_files/feature_css/svg-edit-draw.css', '21.12', 0),
('ea9b92f35e6d458dd1db9215185ae2ee', './themes/base_files/feature_css/wikiplugin-ganttchart.css', '21.12', 0),
('f2871fda295c406f5c4afd6a7c8b2877', './themes/base_files/feature_css/wizards.css', '21.12', 0),
('4833a19afc0e8bcbd1f5ab50f6357440', './themes/base_files/iconsets/default.php', '21.12', 0),
('50c736bd8e85e2170990c334ed284f28', './themes/base_files/iconsets/index.php', '21.12', 0),
('8a54ded594b1a99170fe195ff8816e44', './themes/base_files/iconsets/legacy.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/base_files/index.php', '21.12', 0),
('46e9aa8a7dc04432a56c4a3c69969e78', './themes/base_files/other/BiDi/BiDi.css', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/base_files/other/BiDi/index.php', '21.12', 0),
('50c736bd8e85e2170990c334ed284f28', './themes/base_files/other/index.php', '21.12', 0),
('34dc67dbc8dc1ddb4440ce1eb209c190', './themes/base_files/other/integrator/default.css', '21.12', 0),
('3ac13cbd0dc1a7d0a1406b6b8fb6e78f', './themes/base_files/other/integrator/doxygen.css', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/base_files/other/integrator/index.php', '21.12', 0),
('fffaa265bff7d1b60a3dd0c1172b4db5', './themes/business/css/business.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/business/css/index.php', '21.12', 0),
('909be7adab738cf88477d78afdb723ae', './themes/business/css/newsletter.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/business/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/business/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/business/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/business/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/business/templates/index.php', '21.12', 0),
('f8818878b479065515dedf6d9849e5c9', './themes/cerulean/css/cerulean.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cerulean/css/index.php', '21.12', 0),
('bc82a5a0db739a3e440472eda226f8c4', './themes/cerulean/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cerulean/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cerulean/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cerulean/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/cerulean/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cerulean/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/cerulean/templates/index.php', '21.12', 0),
('a79a0887d33a7944794e7f9672fc6b55', './themes/cosmo/css/cosmo.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cosmo/css/index.php', '21.12', 0),
('876a7dcb00c25cf968cc1c8a3a5fa641', './themes/cosmo/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cosmo/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cosmo/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cosmo/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/cosmo/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cosmo/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/cosmo/templates/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/css/index.php', '21.12', 0),
('51988d9ab985ce7f2df5d70b177b8178', './themes/css/tiki-install.css', '21.12', 0),
('0646ec4e98c1e136ab170eeac0892bfa', './themes/cyborg/css/cyborg.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cyborg/css/index.php', '21.12', 0),
('2cb0ed6d3e6731bd4bdf743cdfb70b9e', './themes/cyborg/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cyborg/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cyborg/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cyborg/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/cyborg/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/cyborg/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/cyborg/templates/index.php', '21.12', 0),
('f6d58a46f05295503170c6a7d923a89b', './themes/darkly/css/darkly.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkly/css/index.php', '21.12', 0),
('d702089894b0f5e8ee882e33b0b1739f', './themes/darkly/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkly/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkly/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkly/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/darkly/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkly/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/darkly/templates/index.php', '21.12', 0),
('eee3d5dee07edb1648fdbc55de1b0060', './themes/darkroom/css/darkroom.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkroom/css/index.php', '21.12', 0),
('97669a504019cdd4ff8a48a3e7f41cfd', './themes/darkroom/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkroom/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkroom/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkroom/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/darkroom/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/darkroom/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/darkroom/templates/index.php', '21.12', 0),
('32becca3beb9ea79a0e8c30eb3f66a7c', './themes/darkshine/css/darkshine.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/darkshine/css/index.php', '21.12', 0),
('1989459090aeb6f9ae35c54b01ab196a', './themes/darkshine/css/newsletter.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/darkshine/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/darkshine/icons/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/darkshine/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/darkshine/scss/index.php', '21.12', 0),
('2c8f14457635c700e4cbd544349bc748', './themes/default/css/default.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/css/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/favicons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/default/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/options/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/default/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/default/templates/index.php', '21.12', 0),
('0ba3f1ebc443487631f8a33b3a2d1106', './themes/feb12/css/feb12.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/feb12/css/index.php', '21.12', 0),
('3364b66f579eef99619637f84ebe8eb3', './themes/feb12/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/feb12/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/feb12/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/feb12/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/feb12/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/feb12/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/feb12/templates/index.php', '21.12', 0),
('310bd57206601cfbee8f35136af7c849', './themes/fivealive-lite/css/fivealive-lite.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive-lite/css/index.php', '21.12', 0),
('d8c9eb22c958f904bbce41e83c7c291c', './themes/fivealive-lite/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive-lite/fonts/index.php', '21.12', 0),
('60025c21da67e059474fc1e1d4c8e638', './themes/fivealive-lite/icons/custom.php', '21.12', 0),
('85ff1f76a1dd1835ce353b7250be03eb', './themes/fivealive-lite/icons/fivealive_lite.php', '21.12', 0),
('e4261506add232926109c7c475c2a697', './themes/fivealive-lite/icons/fivealive_lite_custom.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive-lite/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive-lite/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/fivealive-lite/index.php', '21.12', 0),
('7ad7d36da2276ff9a9cadd5d2747e14a', './themes/fivealive-lite/options/akebi/css/akebi.css', '21.12', 0),
('2c8cab8af20c8fcd937d4ba95ae42865', './themes/fivealive-lite/options/akebi/icons/akebi_custom.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive-lite/options/akebi/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/akebi/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/blueberry/images/index.php', '21.12', 0),
('68ca91d4c5d58bc125b340b65220824b', './themes/fivealive-lite/options/grape/css/grape.css', '21.12', 0),
('b7b5bc2dfd1b3732e662acf07aa0747c', './themes/fivealive-lite/options/grape/css/newsletter.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/grape/images/index.php', '21.12', 0),
('7c1b4a377b912ed8b63047b6526136e5', './themes/fivealive-lite/options/kiwi/css/kiwi.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/kiwi/images/index.php', '21.12', 0),
('b64e316d7e50f8a39a5b9f3944017bae', './themes/fivealive-lite/options/lemon/css/lemon.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/lemon/images/index.php', '21.12', 0),
('a0c9dd0b28d9b8fa40862963616b1634', './themes/fivealive-lite/options/orange/css/orange.css', '21.12', 0),
('42fab3605f717233b05bb6232d239b73', './themes/fivealive-lite/options/orange/icons/orange.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/orange/images/index.php', '21.12', 0),
('14c0555ded55aa9d7b18a27d7e2c88d2', './themes/fivealive-lite/options/plum/css/plum.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/plum/images/index.php', '21.12', 0),
('89057123b85a3879f8d7245d6c56686d', './themes/fivealive-lite/options/raspberry/css/raspberry.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/raspberry/images/index.php', '21.12', 0),
('02a6669bd76b5115c95d2f6ef7fd72d1', './themes/fivealive-lite/options/watermelon/css/watermelon.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive-lite/options/watermelon/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive-lite/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/fivealive-lite/templates/index.php', '21.12', 0),
('5c57d97e99e9975d358a8d87c184edab', './themes/fivealive/css/fivealive.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/css/index.php', '21.12', 0),
('dc78fe29624c9dd991af29ecf51e0028', './themes/fivealive/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/favicons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/fivealive/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/jquery-ui/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/jquery-ui/index.php', '21.12', 0),
('51b912dde9699bc8c60cba7f5c9be3f7', './themes/fivealive/jquery-ui/jquery-ui.css', '21.12', 0),
('036499b6a0aa2e7f986a186f51215266', './themes/fivealive/jquery-ui/jquery-ui.min.css', '21.12', 0),
('79d7bbd652a8de5bc0899db8b3e6dc86', './themes/fivealive/jquery-ui/options/akebi/jquery-ui.css', '21.12', 0),
('93a31bd83b69de4ab5160b72f4860099', './themes/fivealive/jquery-ui/options/akebi/jquery-ui.min.css', '21.12', 0),
('83879405fb3be2b68bada0f85d16ec17', './themes/fivealive/jquery-ui/options/grape/jquery-ui.css', '21.12', 0),
('9ce6d357331dcbf9400cea87352cec1c', './themes/fivealive/jquery-ui/options/grape/jquery-ui.min.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/jquery-ui/options/index.php', '21.12', 0),
('1ee71b0465ad8299c44c41aae5ffedc1', './themes/fivealive/jquery-ui/options/kiwi/jquery-ui.css', '21.12', 0),
('202620ec8a1125a00e6d03bc375bbd16', './themes/fivealive/jquery-ui/options/kiwi/jquery-ui.min.css', '21.12', 0),
('4dd94e830a2ee4ac42189a0db114b5a1', './themes/fivealive/jquery-ui/options/lemon/jquery-ui.css', '21.12', 0),
('c247a0a8b4083f93dad08a556513db9e', './themes/fivealive/jquery-ui/options/lemon/jquery-ui.min.css', '21.12', 0),
('89b65a41920fd43d437ec0a2166ecb85', './themes/fivealive/jquery-ui/options/orange/jquery-ui.css', '21.12', 0),
('221188753698a8089591a0e0826a2e5e', './themes/fivealive/jquery-ui/options/orange/jquery-ui.min.css', '21.12', 0),
('f6353f909a9df79873fa0d25ba43c300', './themes/fivealive/jquery-ui/options/plum/jquery-ui.css', '21.12', 0),
('9ee83e9ad1c69d374035d186c99e762d', './themes/fivealive/jquery-ui/options/plum/jquery-ui.min.css', '21.12', 0),
('f1e1e434005a429c9fd2002205a7553c', './themes/fivealive/jquery-ui/options/raspberry/jquery-ui.css', '21.12', 0),
('5e5b795a650bb46553cb6738e85be28e', './themes/fivealive/jquery-ui/options/raspberry/jquery-ui.min.css', '21.12', 0),
('486eb69a3fdb04771358a83b907f34c6', './themes/fivealive/jquery-ui/options/watermelon/jquery-ui.css', '21.12', 0),
('6f3ef93aa4794d750a4e2502cb657189', './themes/fivealive/jquery-ui/options/watermelon/jquery-ui.min.css', '21.12', 0),
('6da956856b9f0caf34668519d2b4f927', './themes/fivealive/js/custom.js', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/js/index.php', '21.12', 0),
('6ae30607033fb4e7caf761125035dfc5', './themes/fivealive/options/akebi/css/akebi.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi/css/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi/scss/index.php', '21.12', 0),
('be6875444bac960fc8794073903d6777', './themes/fivealive/options/akebi_classic/css/akebi_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi_classic/css/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/akebi_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/blueberry/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/blueberry/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/blueberry/images/index.php', '21.12', 0),
('7af183e7e9d39d1e5b43a5844151fdf8', './themes/fivealive/options/grape/css/grape.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape/css/index.php', '21.12', 0),
('b7b5bc2dfd1b3732e662acf07aa0747c', './themes/fivealive/options/grape/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/grape/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape/scss/index.php', '21.12', 0),
('a1947dd06a12f4585f809eb2a913bc8d', './themes/fivealive/options/grape_classic/css/grape_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape_classic/css/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/grape_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi/css/index.php', '21.12', 0),
('0ba7f54db8daedd6b22d2b1a82c3fe4b', './themes/fivealive/options/kiwi/css/kiwi.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/kiwi/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi_classic/css/index.php', '21.12', 0),
('2a16c65903d0658e746fb2697789114d', './themes/fivealive/options/kiwi_classic/css/kiwi_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/kiwi_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon/css/index.php', '21.12', 0),
('23f29ceedf87a92962ac904a69dd55e0', './themes/fivealive/options/lemon/css/lemon.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/lemon/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon_classic/css/index.php', '21.12', 0),
('065957d7a7648d3aad2e827626b8314c', './themes/fivealive/options/lemon_classic/css/lemon_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/lemon_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange/css/index.php', '21.12', 0),
('fcf9a6896c407e3d0ed90de323d8b843', './themes/fivealive/options/orange/css/orange.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/orange/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange_classic/css/index.php', '21.12', 0),
('ff38481ca1b24848581573e10284db14', './themes/fivealive/options/orange_classic/css/orange_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/orange_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum/css/index.php', '21.12', 0),
('db59428e67c68d857bf1ab82c19beacd', './themes/fivealive/options/plum/css/plum.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/plum/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum_classic/css/index.php', '21.12', 0),
('5180dd546e7ca7e9c1d988e7cdb2a369', './themes/fivealive/options/plum_classic/css/plum_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/plum_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry/css/index.php', '21.12', 0),
('67c9c3429d711e30a20381fb4a5e62dc', './themes/fivealive/options/raspberry/css/raspberry.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/raspberry/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry_classic/css/index.php', '21.12', 0),
('1bae6161111c5614149d1c7c76a996da', './themes/fivealive/options/raspberry_classic/css/raspberry_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/raspberry_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon/css/index.php', '21.12', 0),
('d6e170ad3998ec18041046af85c14952', './themes/fivealive/options/watermelon/css/watermelon.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/fivealive/options/watermelon/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon_classic/css/index.php', '21.12', 0),
('3af3292a1d2297f3c555780577426d52', './themes/fivealive/options/watermelon_classic/css/watermelon_classic.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon_classic/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/options/watermelon_classic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/fivealive/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/fivealive/templates/index.php', '21.12', 0),
('e26e9ead1e91d315a5b90438e61261d1', './themes/flatly/css/flatly.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/flatly/css/index.php', '21.12', 0),
('c490320a28953acfeb6c53ec59c4cab6', './themes/flatly/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/flatly/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/flatly/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/flatly/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/flatly/index.php', '21.12', 0),
('5b116f76d2a613a0197b64bf9db54128', './themes/flatly/options/blue/css/blue.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/flatly/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/flatly/templates/index.php', '21.12', 0),
('b92af0949029f133c9cdf74d1e97e051', './themes/greenvalley/css/greenvalley.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/greenvalley/css/index.php', '21.12', 0),
('893ea914430645d7a4e94e09dcffb6ff', './themes/greenvalley/css/newsletter.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/greenvalley/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/greenvalley/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/greenvalley/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/greenvalley/scss/index.php', '21.12', 0),
('50c736bd8e85e2170990c334ed284f28', './themes/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/journal/css/index.php', '21.12', 0),
('995b55056cf3665c78e27f4f78804d9a', './themes/journal/css/journal.css', '21.12', 0),
('bdb48c80aeca950bf7c9abdacf167528', './themes/journal/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/journal/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/journal/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/journal/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/journal/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/journal/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/journal/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/jqui/css/index.php', '21.12', 0),
('a54ec5fa8adffb0a323ecf1c71dc6650', './themes/jqui/css/jqui.css', '21.12', 0),
('5dfc1db0ffaa84808774ec47b76ce58d', './themes/jqui/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/jqui/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/jqui/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/jqui/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/jqui/index.php', '21.12', 0),
('71e131539bb2cf25f463433670f43823', './themes/jqui/options/element/css/element.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/element/css/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/element/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/element/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/element/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/element/scss/index.php', '21.12', 0),
('43235224d051dbc9b0e73b59033b83ae', './themes/jqui/options/excitebike/css/excitebike.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/excitebike/css/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/excitebike/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/excitebike/icons/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/jqui/options/excitebike/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/excitebike/scss/index.php', '21.12', 0),
('12557d360c507b8fd25a6f2d12dcd560', './themes/jqui/options/flat/css/flat.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/flat/css/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/flat/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/flat/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/flat/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/flat/scss/index.php', '21.12', 0),
('725acfc365c33b6d7e126cc1960a7415', './themes/jqui/options/good/css/good.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/good/css/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/good/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/good/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/good/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/good/scss/index.php', '21.12', 0),
('3277b170c0ded496d3f32026e05408c7', './themes/jqui/options/haus/css/haus.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/haus/css/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/haus/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/haus/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/haus/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/haus/scss/index.php', '21.12', 0),
('8bbeb91bf727ad2f8b64787f05aee2cc', './themes/jqui/options/horizons/css/horizons.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/horizons/css/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/horizons/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/horizons/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/horizons/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/horizons/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/jqui/options/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/rising/css/index.php', '21.12', 0),
('786a2c3eba9f7c9834630cad5bfc2280', './themes/jqui/options/rising/css/rising.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/rising/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/rising/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/rising/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/rising/scss/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/trontastic/css/index.php', '21.12', 0),
('bb02670feaa782debc7d165ba51937b4', './themes/jqui/options/trontastic/css/trontastic.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/trontastic/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/trontastic/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/trontastic/images/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/jqui/options/trontastic/index.php', '21.12', 0),
('668438ff3ff0a5b9225f80bc6180fcac', './themes/jqui/options/trontastic/pics/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/trontastic/pics/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/jqui/options/trontastic/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/jqui/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/jqui/templates/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/js/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lighty/css/index.php', '21.12', 0),
('81f6da37be3ae715e22dd852cc95e826', './themes/lighty/css/lighty.css', '21.12', 0),
('4919ded2a87f5db9a54cf1a277076bce', './themes/lighty/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lighty/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lighty/scss/index.php', '21.12', 0),
('6176afe1cf9935b2be69032093b8c449', './themes/lighty/templates/antibot.tpl', '21.12', 0),
('d410ea69d8c69808853eb7516c96f054', './themes/lighty/templates/blog_post_postbody_title.tpl', '21.12', 0),
('f150a5291591f675538b360c59afc799', './themes/lighty/templates/blog_wrapper.tpl', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/lighty/templates/index.php', '21.12', 0),
('7b03a27476d907d4ae7c7eacf5bab288', './themes/lighty/templates/tiki-contact.tpl', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/litera/css/index.php', '21.12', 0),
('3cd06372424b68b8c74c51c2866409a6', './themes/litera/css/litera.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/litera/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/litera/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/litera/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/litera/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/litera/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/litera/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lumen/css/index.php', '21.12', 0),
('3d61478a8ff2c3115c49c7fda67a062a', './themes/lumen/css/lumen.css', '21.12', 0),
('d118dadd00284643628f2116f6888f6f', './themes/lumen/css/newsletter.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lumen/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lumen/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lumen/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/lumen/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lumen/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/lumen/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lux/css/index.php', '21.12', 0),
('1d7c09610c3bcb0f2c35f60804b7da2c', './themes/lux/css/lux.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lux/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lux/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lux/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/lux/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/lux/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/lux/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/materia/css/index.php', '21.12', 0),
('b9709bd6dc25282e5f82fe4e49a5668b', './themes/materia/css/materia.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/materia/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/materia/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/materia/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/materia/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/materia/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/materia/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/minty/css/index.php', '21.12', 0),
('668cc1df5f5fe70488536450186e268e', './themes/minty/css/minty.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/minty/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/minty/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/minty/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/minty/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/minty/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/minty/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/ohia/css/index.php', '21.12', 0),
('ad1b0d2ce029b6f4da6833261efcb51f', './themes/ohia/css/newsletter.css', '21.12', 0),
('8d7deb3456765252a36eeba758c5ca0e', './themes/ohia/css/ohia.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/ohia/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/ohia/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/ohia/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/ohia/index.php', '21.12', 0),
('4aef402f89d01778565a120eb91006fd', './themes/ohia/need-fix-or-merge-tiki.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/ohia/scss/index.php', '21.12', 0),
('aae566f45c48aa727c7f076ad4eb9c09', './themes/ohia/templates/credits.tpl', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/ohia/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/pulse/css/index.php', '21.12', 0),
('517e4365246cd06910c7320feaac4ddf', './themes/pulse/css/pulse.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/pulse/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/pulse/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/pulse/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/pulse/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/pulse/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/pulse/templates/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/sandstone/css/index.php', '21.12', 0),
('e45af66da89838e4200692f87fa7d45b', './themes/sandstone/css/newsletter.css', '21.12', 0),
('34ef2aad6047507cd1f60c871d14c875', './themes/sandstone/css/sandstone.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/sandstone/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/sandstone/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/sandstone/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/sandstone/less/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/sandstone/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/simplex/css/index.php', '21.12', 0),
('28488cb84866759d16ec7751a604feb7', './themes/simplex/css/newsletter.css', '21.12', 0),
('e3c287aa1875603fecb00c9f0d9934ef', './themes/simplex/css/simplex.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/simplex/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/simplex/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/simplex/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/simplex/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/simplex/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/simplex/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/sketchy/css/index.php', '21.12', 0),
('5ffd7d94be10f2566e266d56b3e26403', './themes/sketchy/css/newsletter.css', '21.12', 0),
('ae298295bf1e60b70b5310955f9623d0', './themes/sketchy/css/sketchy.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/sketchy/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/sketchy/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/sketchy/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/sketchy/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/sketchy/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/sketchy/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/slate/css/index.php', '21.12', 0),
('0dafcc12518e7853200403a8bca4751c', './themes/slate/css/newsletter.css', '21.12', 0),
('3732d128130064103426e3a4b5bc2ba5', './themes/slate/css/slate.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/slate/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/slate/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/slate/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/slate/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/slate/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/slate/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/solar/css/index.php', '21.12', 0),
('fa669f213d26b64e148d39dc4dee11bf', './themes/solar/css/newsletter.css', '21.12', 0),
('20e43ea62b2326858b0cae4eb0a2cbc9', './themes/solar/css/solar.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/solar/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/solar/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/solar/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/solar/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/solar/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/solar/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/spacelab/css/index.php', '21.12', 0),
('3ee33658ff3361587489a486f703c345', './themes/spacelab/css/newsletter.css', '21.12', 0),
('1e096d24873e7f1b3618ae3ac2bb50a6', './themes/spacelab/css/spacelab.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/spacelab/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/spacelab/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/spacelab/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/spacelab/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/spacelab/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/spacelab/templates/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/strasa/css/index.php', '21.12', 0),
('4c74582484b497bcf490b049046c35fb', './themes/strasa/css/newsletter.css', '21.12', 0),
('aa714fa5d41372a43217cbe3a9c983cb', './themes/strasa/css/strasa.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/strasa/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/strasa/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/strasa/images/index.php', '21.12', 0),
('8b3e022a2d287af840af12c3436e6de6', './themes/strasa/options/cool/css/cool.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/strasa/options/cool/css/index.php', '21.12', 0),
('5e8cb94731dab338915352d691a86094', './themes/strasa/options/cool/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/strasa/options/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/strasa/options/mono/css/index.php', '21.12', 0),
('0a99004b672de433760878b32b150285', './themes/strasa/options/mono/css/mono.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/strasa/options/mono/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/strasa/options/mono/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/strasa/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/superhero/css/index.php', '21.12', 0),
('ee61df3849ef9ed04b3a942f84e65bd6', './themes/superhero/css/newsletter.css', '21.12', 0),
('8e0b47ab2617606a623e8c9689fa005e', './themes/superhero/css/superhero.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/superhero/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/superhero/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/superhero/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/superhero/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/superhero/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/superhero/templates/index.php', '21.12', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './themes/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/thenews/css/index.php', '21.12', 0),
('457c2de3cbc1f2676522e1c8e855a519', './themes/thenews/css/newsletter.css', '21.12', 0),
('1ca263af6fdf7685eed2f4a43683538e', './themes/thenews/css/thenews.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/thenews/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/thenews/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/thenews/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/thenews/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/thenews/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/thenews/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/css/index.php', '21.12', 0),
('32a059099f7f722fcac12706ec57daad', './themes/tikicorp/css/tikicorp.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/images/index.php', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/tikicorp/jquery-ui/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/jquery-ui/index.php', '21.12', 0),
('51b912dde9699bc8c60cba7f5c9be3f7', './themes/tikicorp/jquery-ui/jquery-ui.css', '21.12', 0),
('036499b6a0aa2e7f986a186f51215266', './themes/tikicorp/jquery-ui/jquery-ui.min.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/options/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/options/light/css/index.php', '21.12', 0),
('d8ddc9343f22010893357ab4d31428d2', './themes/tikicorp/options/light/css/light.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/options/light/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/options/light/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/options/light/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/options/light/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikicorp/scss/index.php', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('87c70f775511b0ccdd0222424da77dd1', './themes/tikicorp/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikinewt/css/index.php', '21.12', 0),
('c6b26c4fa285b4741a6688af756e3a71', './themes/tikinewt/css/newsletter.css', '21.12', 0),
('2c7b34d93821a991cb0317d3cfc30eeb', './themes/tikinewt/css/tikinewt.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikinewt/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikinewt/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikinewt/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/tikinewt/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikinewt/options/index.php', '21.12', 0),
('8c8fc651c92b51e9461a9735e45438a5', './themes/tikinewt/options/shadows/css/shadows.css', '21.12', 0),
('5fed602ee48bf0ab6b711d33343130a0', './themes/tikinewt/options/shadows/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikinewt/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/tikinewt/templates/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/tikipedia/css/index.php', '21.12', 0),
('cd1d87209a02c51b32aa91f0c4557aa5', './themes/tikipedia/css/newsletter.css', '21.12', 0),
('2ba134c048ba62e0d5503f2224753408', './themes/tikipedia/css/tikipedia.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/tikipedia/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/tikipedia/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/tikipedia/images/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/tikipedia/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/tikipedia/templates/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/united/css/index.php', '21.12', 0),
('7f6a27df43d8567f3f21df5dd1b509ec', './themes/united/css/newsletter.css', '21.12', 0),
('83e3d54910d0f4822144680ee62e72bb', './themes/united/css/united.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/united/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/united/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/united/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/united/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/united/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/united/templates/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/utopias/css/index.php', '21.12', 0),
('aec3b5fce3a32009ea7439ac191cf705', './themes/utopias/css/newsletter.css', '21.12', 0),
('ece355e59163ef7b0f642d021eef1bdb', './themes/utopias/css/utopias.css', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/utopias/fonts/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/utopias/icons/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/utopias/images/index.php', '21.12', 0),
('612b2cd3259f7060ed03a14e8aba41b2', './themes/utopias/scss/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/yeti/css/index.php', '21.12', 0),
('8e09352a53286fd6c455a8e40d3caab2', './themes/yeti/css/newsletter.css', '21.12', 0),
('b4861bd1a09a49a06ebb82a364db48b9', './themes/yeti/css/yeti.css', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/yeti/fonts/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/yeti/icons/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/yeti/images/index.php', '21.12', 0),
('30432a92c5f2ab1e46c7ccfdcad4405c', './themes/yeti/index.php', '21.12', 0),
('1920b9e4d09e2a30da0638ca3ff665a7', './themes/yeti/scss/index.php', '21.12', 0),
('87c70f775511b0ccdd0222424da77dd1', './themes/yeti/templates/index.php', '21.12', 0),
('edc0217d6c76a439058c421891d31f91', './tiki-accounting.php', '21.12', 0),
('5693eb19f6dac1664b6fa49ccc9139ed', './tiki-accounting_account.php', '21.12', 0),
('f4a450ae50533f4e241cb7ac76d5ce46', './tiki-accounting_books.php', '21.12', 0),
('676b36879e77c21874d795693e2669b5', './tiki-accounting_cancel.php', '21.12', 0),
('2a285d7feeb96a23237930dacf094b49', './tiki-accounting_entry.php', '21.12', 0),
('bb0371f5bcaafdf44182837b90b6ebc0', './tiki-accounting_export.php', '21.12', 0),
('666d6778dfa958aff7c69f356673063d', './tiki-accounting_stack.php', '21.12', 0),
('c6bf8afd229bb1dafd0287423f815c2a', './tiki-action_calendar.php', '21.12', 0),
('61085e6fc514bfe0916dc58165e7795a', './tiki-admin.php', '21.12', 0),
('fbce069f6bffa8ec8cf63ee97145107a', './tiki-admin_actionlog.php', '21.12', 0),
('14ecc0e971beab2e39ceee62ab80103c', './tiki-admin_banners.php', '21.12', 0),
('e4fb8e000ce3ff91fdc875165d77dabb', './tiki-admin_banning.php', '21.12', 0),
('2a9af88d8d2f4a404973094f9e0aa69a', './tiki-admin_calendars.php', '21.12', 0),
('a121e1e6081780670a5cf6968b2b9309', './tiki-admin_categories.php', '21.12', 0),
('9440dcf49eab5b595d7b831b9de24b6b', './tiki-admin_content_templates.php', '21.12', 0),
('fdae93867c151273539e1a84be37cc3c', './tiki-admin_contribution.php', '21.12', 0),
('2450fcfe605182695f9cf8fee61f6e65', './tiki-admin_cookies.php', '21.12', 0),
('240ae1c46dc512e8cb66d02d29c9fc19', './tiki-admin_credits.php', '21.12', 0),
('fd3e67648189912b3804b54c97fb1d11', './tiki-admin_dsn.php', '21.12', 0),
('991d111220369cfafaaca012d1aef530', './tiki-admin_external_wikis.php', '21.12', 0),
('25eb499df9348522b353733ca24a73a3', './tiki-admin_forums.php', '21.12', 0),
('74dd4f8355164480ee6d8440a4494a8c', './tiki-admin_hotwords.php', '21.12', 0),
('74499e5217dce7a33e223948ee94a6f9', './tiki-admin_html_page_content.php', '21.12', 0),
('43f3324377cce9dd6e8cdf2d33c3a423', './tiki-admin_html_pages.php', '21.12', 0),
('d39879c70dd0a32a5fcafbb64becf57e', './tiki-admin_ids.php', '21.12', 0),
('624c03479d5c35981307d72bd0c6b494', './tiki-admin_integrator.php', '21.12', 0),
('1bafda83dea6eff92ff3096b04d9e680', './tiki-admin_integrator_rules.php', '21.12', 0),
('796665c3cc7fefaf5b2ae51a48318222', './tiki-admin_keywords.php', '21.12', 0),
('98dc7dd0bf437fc8b80f6f149fd32ba1', './tiki-admin_links.php', '21.12', 0),
('6d5f9e47220779a46291410a23999dc9', './tiki-admin_mailin.php', '21.12', 0),
('8603047d9d3be29f7d1e27510ba158fe', './tiki-admin_mailin_routes.php', '21.12', 0),
('965b5de5322af8a32cecb8dfbda3d139', './tiki-admin_menu_options.php', '21.12', 0),
('2859f7ec89082272a2587672d337bafd', './tiki-admin_menus.php', '21.12', 0),
('d60fda9c0aedcb66f5e5d121943c6c1e', './tiki-admin_modules.php', '21.12', 0),
('b6d677154d44ef83033cb05d6269d06f', './tiki-admin_newsletter_subscriptions.php', '21.12', 0),
('7a06d7ff0bce02d7415f6fd3a4e55afe', './tiki-admin_newsletters.php', '21.12', 0),
('84e6f6859f8e412d71c3e07b787b71ac', './tiki-admin_notifications.php', '21.12', 0),
('8faa125bd200c001319379a0ec1b470d', './tiki-admin_oauthserver.php', '21.12', 0),
('24826ae1d3be526da03cb0510305de16', './tiki-admin_poll_options.php', '21.12', 0),
('c6b26acaaa9a94c4cc478a88841f9136', './tiki-admin_polls.php', '21.12', 0),
('49b70568811d6a9a686e26580615aab1', './tiki-admin_routes.php', '21.12', 0),
('305650e4e4c7a6d6b2282d1483660fcc', './tiki-admin_rssmodules.php', '21.12', 0),
('83e0c005615d8e5ff754f76e2a92327b', './tiki-admin_schedulers.php', '21.12', 0),
('4e033194058b09ff5d4f121780e84d7c', './tiki-admin_security.php', '21.12', 0),
('f0decccab07458817d664a6010ce5d24', './tiki-admin_shoutbox_words.php', '21.12', 0),
('0d9b0444c0786b07561ce1ad41686a5e', './tiki-admin_sitemap.php', '21.12', 0),
('5f3099da065ec79c35ea5488afb5da50', './tiki-admin_structures.php', '21.12', 0),
('101a87ceb232e8d9078752ff525527fe', './tiki-admin_survey_questions.php', '21.12', 0),
('321e25ae7b43f7e08daddf7dd98f0c45', './tiki-admin_surveys.php', '21.12', 0),
('654f3ca2e35714aafa764f3c2ab1419f', './tiki-admin_sync.php', '21.12', 0),
('1af7b537e1936b1eaffe42f166ef04e5', './tiki-admin_system.php', '21.12', 0),
('332d32a7ac578016f9ae4f38a7635fba', './tiki-admin_tokens.php', '21.12', 0),
('4f794d487e3511b7fe5dcd78a535f03a', './tiki-admin_toolbars.php', '21.12', 0),
('626ecdad453ab452f2ec40eeb0c8d5f6', './tiki-admin_topics.php', '21.12', 0),
('c06cda2bb34b6d81e1fcaef02e487856', './tiki-admin_tracker_fields.php', '21.12', 0),
('a9de9c025de2ec30e98ddceaee3c13e0', './tiki-admin_trackers.php', '21.12', 0),
('e3e5b9d1ecbb16ead03e71474ec102c3', './tiki-admin_transitions.php', '21.12', 0),
('13e921045422d0d9b82cd5bfbfbc3f8c', './tiki-admin_webservices.php', '21.12', 0),
('58254429313c22b594df97082e77f0cf', './tiki-admingroups.php', '21.12', 0),
('bac02ae607868bc2d854321ca460c418', './tiki-adminusers.php', '21.12', 0),
('9a9ad42fa39afefe57b3c466500673d7', './tiki-ajax_services.php', '21.12', 0),
('863144d4ff5e5c11ef61cf03d795f69f', './tiki-all_languages.php', '21.12', 0),
('9673ae0ac78c40c239807c8dafb5fd70', './tiki-article_types.php', '21.12', 0),
('878580a7cf7c360cffabdbaadd218d9c', './tiki-articles_rss.php', '21.12', 0),
('4b72e669fbf00af7fbc6f4928349175f', './tiki-assignuser.php', '21.12', 0),
('2267dba5989bdf22aa55b6df893fb786', './tiki-autologin.php', '21.12', 0),
('1e400ee4eb593dcf7602c2689a5c9b47', './tiki-backlinks.php', '21.12', 0),
('ee559630572e06bd3b121fd43561ae5c', './tiki-batch_send_newsletter.php', '21.12', 0),
('5071f54552c5d775f045217c67555ce8', './tiki-batch_todo.php', '21.12', 0),
('be22c22b83cfbf7b5ecdcd5818c17802', './tiki-batch_upload.php', '21.12', 0),
('c2a68e8f4d748877216417495d0b0fd0', './tiki-batch_upload_files.php', '21.12', 0),
('4f9e9ec41025568973f5d1a653da554c', './tiki-blog_post.php', '21.12', 0),
('34b75d09aa82b87f4ceb5db4882e8836', './tiki-blog_rankings.php', '21.12', 0),
('7eb34f4eb33a48ce7b58e23660410949', './tiki-blog_rss.php', '21.12', 0),
('bf470704c74bb397372fc954fd9b424b', './tiki-blogs_rss.php', '21.12', 0),
('1b5e72d65c94b8552cfc7da0d99e4367', './tiki-browse_categories.php', '21.12', 0),
('d23c82f6983cc6fa9813915e1ef7478e', './tiki-browse_freetags.php', '21.12', 0),
('dfd07a5597ab440d3fba74446e4862df', './tiki-browse_gallery.php', '21.12', 0),
('e1cb7902d358c95256200cf098f5aecc', './tiki-browse_image.php', '21.12', 0),
('f947d4fd3dd5b918f872df463c63a900', './tiki-caldav.php', '21.12', 0),
('2421ab3f2ca856463f84ed5c4fffcdde', './tiki-calendar.php', '21.12', 0),
('844f7bcc1af4bc5e17d808dcdd6fbbe2', './tiki-calendar_edit_item.php', '21.12', 0),
('d3d7f24b77a3205e85d3fbbd8be42dc6', './tiki-calendar_export_ical.php', '21.12', 0),
('bc7b6e823def48e5b379748c8ec7b748', './tiki-calendar_import.php', '21.12', 0),
('bda5f16aa73389c6608367be98171b4d', './tiki-calendar_json.php', '21.12', 0),
('8b5bfa6388900674d9f79a9188701899', './tiki-calendar_params_ical.php', '21.12', 0),
('30ce9d1384dda630168fd9d6145ebc4c', './tiki-calendar_setup.php', '21.12', 0),
('39c2fddb69af018ccd7f86666c701200', './tiki-calendars_rss.php', '21.12', 0),
('060d2e74e31c0c32265c464c6f8f5ab4', './tiki-carddav.php', '21.12', 0),
('f8875143b80b62791b831aa66ce9dbdc', './tiki-change_password.php', '21.12', 0),
('45ea0d3c1e6ccf4e0947cbaf34c40684', './tiki-channel.php', '21.12', 0),
('8b7e68f316089690a6f9663319bf0959', './tiki-check.php', '21.12', 0),
('e3edbca2d96f6978168f4b03090b6602', './tiki-cms_rankings.php', '21.12', 0),
('b1a437d357b55d2891ab38db1cb4c7da', './tiki-confirm_user_email.php', '21.12', 0),
('127617256bee2459e09220d3dad4a10c', './tiki-contact.php', '21.12', 0),
('432393533a2d2e338d62dcf7cfd3de55', './tiki-contacts.php', '21.12', 0),
('a843dc0b4d14a95c0f9168868174ec09', './tiki-cookie-jar.php', '21.12', 0),
('8686ec1aee24961aaefecf656e25fbb3', './tiki-copypage.php', '21.12', 0),
('bc1bdbb13e14e8991e09dccdb9c012ff', './tiki-create_multilang_pages.php', '21.12', 0),
('16914c59274020148e9808ef5ed23e5f', './tiki-create_webhelp.php', '21.12', 0),
('b961deb6682613d6dbb73f7d5a86ed2c', './tiki-directories_rss.php', '21.12', 0),
('f7d480aebc1fa8e479be8f3937239f06', './tiki-directory_add_site.php', '21.12', 0),
('6efadf70259a50583c7d65ca381fea14', './tiki-directory_add_tiki_site.php', '21.12', 0),
('d60ebbc8dcee71e3c897ce870808c08d', './tiki-directory_admin.php', '21.12', 0),
('1e977d1a6de4e2bcf05cb3ea73587311', './tiki-directory_admin_categories.php', '21.12', 0),
('f9990e6c44a64ad812dfbc9ced5b9077', './tiki-directory_admin_related.php', '21.12', 0),
('d70ad9c6b5042974ea7bc1b4ad50c535', './tiki-directory_admin_sites.php', '21.12', 0),
('a1ce74c197c8e93b1e57f8e7f3b19b9b', './tiki-directory_browse.php', '21.12', 0),
('ad23ecf4559e0b1ce468916e1fc6a859', './tiki-directory_ranking.php', '21.12', 0),
('3dc0d49246a03b2b26f0733bb3ac0d76', './tiki-directory_redirect.php', '21.12', 0),
('9e34b846cb40e975b7be442a75beed5b', './tiki-directory_rss.php', '21.12', 0),
('87592c91b8b13cf465dad3ca75d3bc96', './tiki-directory_search.php', '21.12', 0),
('33d9ee40817a0b8ab2e38ca28b0fe074', './tiki-directory_validate_sites.php', '21.12', 0),
('2e5f7f58bfb81657c608f7d8082d2636', './tiki-discount.php', '21.12', 0),
('867f805688f8d1ad3ede21fc3084dcd9', './tiki-display.php', '21.12', 0),
('1b1f73a7291817e9a8e8212197a1aa37', './tiki-download_file.php', '21.12', 0),
('ae407f7fe3fea9e296f55f69d526bdeb', './tiki-download_forum_attachment.php', '21.12', 0),
('e6822dfc06e55dc299ea9ad0a6804738', './tiki-download_item_attachment.php', '21.12', 0),
('89d01772f2fd3d007827a3ac83ea037d', './tiki-download_userfile.php', '21.12', 0),
('425ebff7782feae175477007fa9fac16', './tiki-download_wiki_attachment.php', '21.12', 0),
('4cf3962693a4e9d4a3ca70919371d343', './tiki-edit_article.php', '21.12', 0),
('433d35e72da61b7dac349484aefeb461', './tiki-edit_banner.php', '21.12', 0),
('c43cd3e50a4cc76423d6fdde95ede1a6', './tiki-edit_blog.php', '21.12', 0),
('34e6d7e6dd45f7e0042f953daf46ece5', './tiki-edit_categories.php', '21.12', 0),
('5e27de188c5b1de3110370f3659032d2', './tiki-edit_css.php', '21.12', 0),
('44845fef8ee242ac9230c3f49dd4742c', './tiki-edit_docs.php', '21.12', 0),
('c9240e0ec938aa81bdb360e238492ec2', './tiki-edit_draw.php', '21.12', 0),
('69a73b556bda13f5b10f6800d6ebb708', './tiki-edit_groups.php', '21.12', 0),
('d35655a453c50835cb51fe686a5c341e', './tiki-edit_image.php', '21.12', 0),
('d4f7907fca046f156983939fc0c69052', './tiki-edit_languages.php', '21.12', 0),
('0fb7c0eb4e06f2457cf6d06691ec3feb', './tiki-edit_perspective.php', '21.12', 0),
('e7a852c937f7a54e0d764e7f3ae63d78', './tiki-edit_programmed_content.php', '21.12', 0),
('6e0df292cccf0e71e0240923b07500d6', './tiki-edit_question_options.php', '21.12', 0),
('86d18389c1ec46e6b9559afe4b1c3bd5', './tiki-edit_quiz.php', '21.12', 0),
('0ddeb40a75dc3d0739d5390712f7be83', './tiki-edit_quiz_questions.php', '21.12', 0),
('ffcd5b7d739e84a6a1064cdc00f0fe59', './tiki-edit_quiz_results.php', '21.12', 0),
('fca8ae22230dca60133afcbfffa8e70e', './tiki-edit_structure.php', '21.12', 0),
('1a937776c8b8c6a5b4abf61108ad1f86', './tiki-edit_submission.php', '21.12', 0),
('24cb91f312f6ab9065929dd5416eeb36', './tiki-edit_templates.php', '21.12', 0),
('ded4343239578f6332354773ff9de29c', './tiki-edit_topic.php', '21.12', 0),
('7c75e0cd0c902e040d526c35414c823a', './tiki-edit_translation.php', '21.12', 0),
('6e66ad9295ae890eaeff98f591bb965b', './tiki-editdiagram.php', '21.12', 0),
('9182108fea6b9dd2d96a5d26077ba1f9', './tiki-editpage.php', '21.12', 0),
('20c2774dab14801295e7a24feb9a0660', './tiki-emulate_groups_switch.php', '21.12', 0),
('e6292a5df9bd6106f967c226838929a5', './tiki-error_simple.php', '21.12', 0),
('4fb6b1df8b645a7e790a6368bc37ac0d', './tiki-export_sheet.php', '21.12', 0),
('762ac887cac18ba672b7a4a94af3d153', './tiki-export_tracker.php', '21.12', 0),
('2dd5aa818b0b2522b4dcbe5b2eb197bc', './tiki-export_tracker_monitor.php', '21.12', 0),
('d985c36d08049e20a4ff60eedf2f0d3e', './tiki-export_wiki_pages.php', '21.12', 0),
('9461744421e91fd37349f72bcf31ad24', './tiki-faq_questions.php', '21.12', 0),
('69184e7fdd66859167cddd7b3ffdd1b2', './tiki-featured_link.php', '21.12', 0),
('15826aa461da0c812940d10b285a8a1f', './tiki-feed.php', '21.12', 0),
('5107dca0c1c034ab1ac58b9eda622215', './tiki-file_archives.php', '21.12', 0),
('31cb3438f9a0813a586ac25894ef955e', './tiki-file_galleries_rankings.php', '21.12', 0),
('773e689d13b3daa1142b50a4497a92de', './tiki-file_galleries_rss.php', '21.12', 0),
('33efd74a3d06ab04da61262eb9cd829e', './tiki-file_gallery_rss.php', '21.12', 0),
('8d0aea55bea05de61cb0ba2184f659d1', './tiki-filter-base.php', '21.12', 0),
('7c537df64e645f5e1720375bd0a4be4a', './tiki-forum_import.php', '21.12', 0),
('a2d83e318465b9b7fc901a9d878d5c71', './tiki-forum_queue.php', '21.12', 0),
('b9c5c3401a4d6a221a1c8448c7832d00', './tiki-forum_rankings.php', '21.12', 0),
('a655e4dbda35d1e29e35e585bb99ff5d', './tiki-forum_rss.php', '21.12', 0),
('7b0ed7da0a00b775150496b2425284fc', './tiki-forums.php', '21.12', 0),
('e52c1bed708c540449051051395f4154', './tiki-forums_reported.php', '21.12', 0),
('cc668fe4879f9df8a37841c68feb12c5', './tiki-forums_rss.php', '21.12', 0),
('323ae49fa38edce72dfc4af1bd2ebc67', './tiki-freetag_translate.php', '21.12', 0),
('40bd1c690b53e89a22f7d68740fc62b6', './tiki-friends.php', '21.12', 0),
('275dacad7e1faea6198372cff06e1d60', './tiki-galleries.php', '21.12', 0),
('97ca0e895c085aa12c032fa4de461998', './tiki-galleries_rankings.php', '21.12', 0),
('e8e50f70f4cc176c114b0f8005f9c239', './tiki-gdgraph.php', '21.12', 0),
('0eb4f61b99693118e3e1ee2b3a31b541', './tiki-graph_formula.php', '21.12', 0),
('e62d65ad2040baa4130f360d787d8570', './tiki-graph_sheet.php', '21.12', 0),
('3c3d65c5c88a561b9f67f373cebf0e1c', './tiki-history_sheets.php', '21.12', 0),
('ce5ece17f6e2b65d1a9e14f00843a72e', './tiki-image_galleries_rss.php', '21.12', 0),
('01db24feb1285fe57f258301f373e386', './tiki-image_gallery_rss.php', '21.12', 0),
('2c8d2b844260b408714560f2d0abbc0f', './tiki-import_sheet.php', '21.12', 0),
('6df51a747cb327b3dcfb6b4f24a96f12', './tiki-import_structuredtext.php', '21.12', 0),
('4921287293dd7e449326e0a8876edb92', './tiki-import_xml_zip.php', '21.12', 0),
('d2783167d5c7e45c4e9a4cf290631a5d', './tiki-importer.php', '21.12', 0),
('d59abb3978d689c62d11d33ac9f6efa6', './tiki-index.php', '21.12', 0),
('df9927180fe71842fc3d80a54457d425', './tiki-index_p.php', '21.12', 0),
('df524bb7d78746d02df1602b734ef66f', './tiki-index_raw.php', '21.12', 0),
('68954c1b78cbc1a62725a8e35c735a9d', './tiki-information.php', '21.12', 0),
('93b2f70d7ab2439676e645a747d5f793', './tiki-install.php', '21.12', 0),
('ee29ab9f14157e59bc7d5f22f13e037d', './tiki-integrator.php', '21.12', 0),
('2d1c1cf59242472584d705a7b6b6b70f', './tiki-interactive_trans.php', '21.12', 0),
('bccca97e49a29d7c53c2446df97278ff', './tiki-invite.php', '21.12', 0),
('858fddfc3af6a29ef6ecf673e5b117e0', './tiki-invited.php', '21.12', 0),
('d231df9f689020136db86bee21094d48', './tiki-kaltura_upload.php', '21.12', 0),
('1837e0d456838a1a1ef04831101ed436', './tiki-kaltura_video.php', '21.12', 0),
('5b5bd7a31d479d34dd976447bf05fb61', './tiki-lastchanges.php', '21.12', 0),
('4b1a87ca6d8c6c2ee8e89d5d2c4d877a', './tiki-layout_options.php', '21.12', 0),
('618142f9ad826c0b74b9afff957a647b', './tiki-likepages.php', '21.12', 0),
('63d6abc4e88b26396e4d84df95790431', './tiki-list_articles.php', '21.12', 0),
('c1987965cd30eaeafa4f7f3ebcc655c5', './tiki-list_banners.php', '21.12', 0),
('9ed57117a38ac5fd039898c98eb72e28', './tiki-list_blogs.php', '21.12', 0),
('2c63ae969be7b34801d79415e29f319b', './tiki-list_cache.php', '21.12', 0),
('26007a74861c49d6f5bb36cc5dcde1d7', './tiki-list_comments.php', '21.12', 0),
('9e0f4f54e18f5ab640ea87f46faca4b5', './tiki-list_contents.php', '21.12', 0),
('d92672f810a99fadaae64a7d4fcd7bb0', './tiki-list_faqs.php', '21.12', 0),
('e556da15830ca337d44bb0f98db76a9a', './tiki-list_file_gallery.php', '21.12', 0),
('80c4991480ef592841ac4a283e3d6377', './tiki-list_gallery.php', '21.12', 0),
('cd5a3f2321a0e5379de6b9030e5457ce', './tiki-list_integrator_repositories.php', '21.12', 0),
('67e26025a96b167cf26e2c1e9bbff557', './tiki-list_invite.php', '21.12', 0),
('01bedd5d7ad5f55f3084de29ddd531e6', './tiki-list_kaltura_entries.php', '21.12', 0),
('de52defe9990971749279aae31c25027', './tiki-list_object_permissions.php', '21.12', 0),
('c722feae70e50955f7dd9a72d7d77753', './tiki-list_posts.php', '21.12', 0),
('7462a6fe322d5f99d9fddd8d9753e050', './tiki-list_quizzes.php', '21.12', 0),
('ca6a0159dad58dd835d50f926a0a6b5d', './tiki-list_submissions.php', '21.12', 0),
('7cac70fc11decc2b6a0ce5f33fdb3af5', './tiki-list_surveys.php', '21.12', 0),
('e4cc3f52059009a29ea13d16b0f3bec4', './tiki-list_trackers.php', '21.12', 0),
('a176329abc4005dd77e33a188b7dc0ed', './tiki-list_users.php', '21.12', 0),
('1188039e1fe0598877123bb11a28780e', './tiki-listpages.php', '21.12', 0),
('3e2c024866afe97886d551d9696b3417', './tiki-live_support_admin.php', '21.12', 0),
('12433252525b7b697ea0469e26ff2587', './tiki-live_support_chat_frame.php', '21.12', 0),
('822acdf20b46a6dda5e8022fe6fc187f', './tiki-live_support_chat_window.php', '21.12', 0),
('c2c721ce48ed22b007ef3f342a07afec', './tiki-live_support_client.php', '21.12', 0),
('7dc3a1646597df6638ddbe09fcbbf93b', './tiki-live_support_console.php', '21.12', 0),
('39252a387f46756013b8bab85aa1f014', './tiki-live_support_message.php', '21.12', 0),
('352be9ee227c6d69b71fb37c90b62b62', './tiki-live_support_server.php', '21.12', 0),
('6e5c4e37c750da9424341db21bcaa462', './tiki-live_support_transcripts.php', '21.12', 0),
('cc506586eb33e86ede0c05c6c88846bc', './tiki-log_bigbluebutton_leave.php', '21.12', 0),
('558672adf24139e8a98d3947e6016ec8', './tiki-login.php', '21.12', 0),
('0314b4bf84fa813945267cc064b36265', './tiki-login_openid.php', '21.12', 0),
('30c4e3190403dc3f7b88ac70c69c3774', './tiki-login_scr.php', '21.12', 0),
('a9856197775e86cbfe2ce24677141db8', './tiki-login_validate.php', '21.12', 0),
('3b7ba111fc54637bfad9c86533cc9d19', './tiki-logout.php', '21.12', 0),
('49053e09760eba5b9836928089ec65d4', './tiki-mailin-code.php', '21.12', 0),
('1df414893f6b14f9132c8a8c072669e3', './tiki-mailin.php', '21.12', 0),
('4c7ddb6873ecbd8748e75e7135b944e7', './tiki-mindmap.php', '21.12', 0),
('53bc1101d07063843927aac44f0d98c1', './tiki-minical.php', '21.12', 0),
('78cab4abe0c908cebdfa995821bfdcef', './tiki-minical_export.php', '21.12', 0),
('02d3c82f8f82fc98fe92a337bb548565', './tiki-minical_prefs.php', '21.12', 0),
('0a67fe47ea571c0ffa4608cce937866f', './tiki-minical_reminders.php', '21.12', 0),
('5fbb1c4e3f80377322fe79ee40227a1c', './tiki-minichat_ajax.php', '21.12', 0),
('98918f6fdff4daf801100f629f89ee53', './tiki-mods.php', '21.12', 0),
('c727c2023ead2f36255332210e37fb7a', './tiki-module_controls.php', '21.12', 0),
('18381d074262c3414522f8456a065731', './tiki-modules.php', '21.12', 0),
('841cc7d666aee2dfcc5cca0e406fd34f', './tiki-monitor.php', '21.12', 0),
('df2a0b055f26cf118aefb730500140eb', './tiki-my_tiki.php', '21.12', 0),
('317126bdef9088d71b652d39bfce14ea', './tiki-mytiki_shared.php', '21.12', 0),
('966f28051c929ba725c55ae885bc53b6', './tiki-newsletter_archives.php', '21.12', 0),
('cc79703c1e5172a1fa708ee0d1d120b4', './tiki-newsletters.php', '21.12', 0),
('b2c679c55ae6d0aeed928c3a54eedb4f', './tiki-notepad_get.php', '21.12', 0),
('113a89c840eb70df47f18e398ad041fd', './tiki-notepad_list.php', '21.12', 0),
('20e0016ee6f94bf5b2c915039aa96b08', './tiki-notepad_read.php', '21.12', 0),
('e621ec20602a3799c3c11fee686fafb3', './tiki-notepad_write.php', '21.12', 0),
('f3f17a200814bcd49f76355c37b3e90c', './tiki-object_watches.php', '21.12', 0),
('90f581b91bb318f8f47bc7b15a67eb0a', './tiki-objectpermissions.php', '21.12', 0),
('2559065a6be76846003c611ccc7e3ef5', './tiki-old_polls.php', '21.12', 0),
('b3565be63f4cac5f0626ea6915f04e9e', './tiki-orphan_pages.php', '21.12', 0),
('cbe31b8223399e3b949e5ee92fa8c720', './tiki-page.php', '21.12', 0),
('5874cff9b827e56ee611d88abcb053a7', './tiki-page_contribution.php', '21.12', 0),
('bda3375e136e5991601fcd54fc63fec1', './tiki-page_loader.php', '21.12', 0),
('3155988d984013426af68614c0df7e23', './tiki-pagehistory.php', '21.12', 0),
('455ec0ced2342b6fd1158fc43b520198', './tiki-payment.php', '21.12', 0),
('8ac108d3f50340a3401b201e26428b62', './tiki-phpinfo.php', '21.12', 0),
('d0bd1b2c1d467bc6f3286fc5df427575', './tiki-pick_avatar.php', '21.12', 0),
('20b1ff7eb7a5ae347ea49162ff5cd6af', './tiki-pluginlist_experiment.php', '21.12', 0),
('de132ca1de7fea8b51d011be423d676c', './tiki-plugins.php', '21.12', 0),
('9e53ecf8c117355330ac78ed417eb3e5', './tiki-poll_form.php', '21.12', 0),
('285dde5b908216dd22a76c71ac68aa7b', './tiki-poll_results.php', '21.12', 0),
('a45565bbd41f39bd0604c8d284b66e63', './tiki-preference_translate.php', '21.12', 0),
('e2213fc9fb3fd8133ae35074f8e1d0a0', './tiki-print.php', '21.12', 0),
('66cd5426bba55c0e453b188714591efa', './tiki-print_article.php', '21.12', 0),
('1c000df5cb802d4305ade7f25eb562f4', './tiki-print_blog_post.php', '21.12', 0),
('7322583577b7120f3493457e720b3a3c', './tiki-print_indexed.php', '21.12', 0),
('3e550cb6b524da922ac25e83bf5b4930', './tiki-print_multi_pages.php', '21.12', 0),
('f878d66e634e3305eeecd143b806a571', './tiki-print_pages.php', '21.12', 0),
('2f4d4c9c2cf719c107232610ffd03477', './tiki-pv_chart.php', '21.12', 0),
('787d5814099c3a8fce2a7c6b9256c61e', './tiki-quiz_download_answer.php', '21.12', 0),
('96cc4229fe809b3cce03e80df9ce220b', './tiki-quiz_edit.php', '21.12', 0),
('659d8e3ca28d18cabb3322b601e2c512', './tiki-quiz_result_stats.php', '21.12', 0),
('57a3a437079531804dfbd84e10a99488', './tiki-quiz_stats.php', '21.12', 0),
('4355576ecf4593d432bee9cca1820e43', './tiki-quiz_stats_quiz.php', '21.12', 0),
('5dac23497b067cea8669d06ae02fc052', './tiki-read_article.php', '21.12', 0),
('f05a270cedd93920bcabd5f3ce450bf8', './tiki-received_articles.php', '21.12', 0),
('906437e449f277210a522cb283e62ade', './tiki-received_pages.php', '21.12', 0),
('d8089f6e2ccdcd2fa176197657fba84a', './tiki-references.php', '21.12', 0),
('b84b8250b6b66f52b20839c824a83c29', './tiki-referer_stats.php', '21.12', 0),
('0b035a86a07f2a85814953e65dc90b9c', './tiki-register.php', '21.12', 0),
('8fa4768a23ed83ce86e3661b04fd87a1', './tiki-register_site.php', '21.12', 0),
('c18ad2853635b26b41d54606106bd889', './tiki-remind_password.php', '21.12', 0),
('981bf5360b07213f1fe52aa8621c48e9', './tiki-rename_page.php', '21.12', 0),
('292baaea8a8f612a07746d63653942f8', './tiki-report_direct_object_perms.php', '21.12', 0),
('6f9ac3ce92cb287507f25068885d224d', './tiki-rollback.php', '21.12', 0),
('e686a7a1d39a29e04119f991b43a0bad', './tiki-rss_error.php', '21.12', 0),
('eaa5f9b7568ad96231d04f758d3259d4', './tiki-search_replace.php', '21.12', 0),
('ab89ca4272567b5b006456ba057cc758', './tiki-search_stats.php', '21.12', 0),
('4e26fe660588c8976c88dea75b92a027', './tiki-searchindex.php', '21.12', 0),
('5d9049f2f222f3da36ce2300e797463e', './tiki-searchresults.php', '21.12', 0),
('586aac11e034b229267e654e8d90c545', './tiki-section_options.php', '21.12', 0),
('e4fc91bcc7382221d2801025b1501b6d', './tiki-sefurl.php', '21.12', 0),
('a6d47bee1dd583f159ed2e4b09c1ad7c', './tiki-send_mail.php', '21.12', 0),
('22e46325600322ab9da53f40d3378787', './tiki-send_newsletters.php', '21.12', 0),
('6adc3ae6778363b2223479a29a54509f', './tiki-send_objects.php', '21.12', 0),
('64f0734ab6d36fd548bd23303a6a4fe1', './tiki-setup.php', '21.12', 0),
('04d0e726df58a317c4dea82bc31050c2', './tiki-setup_base.php', '21.12', 0),
('fbe8f9c7609bdc46a2a956791b024b50', './tiki-share.php', '21.12', 0),
('9b0199ea11f83e4e1045318f5330e024', './tiki-sheets.php', '21.12', 0),
('c56235e817992ff0fa9fec4a9f3ac780', './tiki-short_url.php', '21.12', 0),
('975c15d83f65e4bfe140730444837cbe', './tiki-shoutbox.php', '21.12', 0),
('dfa128a46813f40fe073a594990e4e15', './tiki-shoutbox_rss.php', '21.12', 0),
('bead65033d972a18e229ab0c1e13f973', './tiki-show_all_images.php', '21.12', 0),
('79c45b2c3c493b0f94378811528e6e99', './tiki-show_user_avatar.php', '21.12', 0),
('dcb29c7f9b329dfe2a09e498c3c699d0', './tiki-sitemap.php', '21.12', 0),
('400fb4e0a59f3bd0576827a83eb49000', './tiki-slideshow.php', '21.12', 0),
('7e833e27c7bac596ac14f728a0bf751d', './tiki-socialnetworks.php', '21.12', 0),
('304f0171dbdd61d476be7f0464e9bd07', './tiki-socialnetworks_firstlogin.php', '21.12', 0),
('dfcabc51f7b6e6aba9c4754b228df2e8', './tiki-socialnetworks_linkedin.php', '21.12', 0),
('60b934bfb5184c706fd9f39f9424c5b2', './tiki-sqllog.php', '21.12', 0),
('5c4dcf5410cd0ed24dfb9829ee25efde', './tiki-stats.php', '21.12', 0),
('b0fe58e0d65e33790dff28357a29ad24', './tiki-survey_stats.php', '21.12', 0),
('fc1fe3de8bee6a3f8cc7c1646ebed304', './tiki-survey_stats_survey.php', '21.12', 0),
('9273fac57c99c852686d279dd003bb5e', './tiki-switch_lang.php', '21.12', 0),
('882918c56fce8be9adaddf3b3c81ec3f', './tiki-switch_perspective.php', '21.12', 0),
('89658d17c04b1f794f14b981dc7d6685', './tiki-switch_theme.php', '21.12', 0),
('485d1623c471dd8bf12c8fa7d11f6f00', './tiki-syslog.php', '21.12', 0),
('a1a4d14e0ce5aebb4db2d77145d88166', './tiki-take_quiz.php', '21.12', 0),
('1d4a3b8467e80625276c3b1ae21c2528', './tiki-take_survey.php', '21.12', 0),
('edc22ffe84824da1e12ffa3ff7f22c4e', './tiki-tc.php', '21.12', 0),
('bf666b4d395558ac74f1f8cec3ca13b9', './tiki-testGD.php', '21.12', 0),
('a70fec9903958ef299b4d5b2b8e6de49', './tiki-theme_control.php', '21.12', 0),
('9395a544443e5e33fd96fc94ea0e54ce', './tiki-theme_control_objects.php', '21.12', 0),
('2a49472b693a6a5d0c985386947f7e53', './tiki-theme_control_sections.php', '21.12', 0),
('b39cbe167f2070ab3600a0d04d473b75', './tiki-timesheet.php', '21.12', 0),
('00d8d98a9b7d33652e743745fd759494', './tiki-timestamp.php', '21.12', 0),
('bf15ae6574412c5d316112d0b13ac7ae', './tiki-tracker_export_join.php', '21.12', 0),
('0f259a49930f9d9d54f6c2e23b287e4c', './tiki-tracker_http_request.php', '21.12', 0),
('79f99e9098a4f1a5381ef706b78ae484', './tiki-tracker_reports.php', '21.12', 0),
('a9c99c3d6a6c06daa3a7c0962a33e3f5', './tiki-tracker_rss.php', '21.12', 0),
('ba93d2c988a97ea03027d2e9e120aa40', './tiki-tracker_view_history.php', '21.12', 0),
('d168d028b1f26c0735aaeed488435b37', './tiki-upload_file.php', '21.12', 0),
('fbb3761bec6fa9bbf0bb6e12ccedd8a9', './tiki-upload_image.php', '21.12', 0),
('08cd26b1c3003ba1f61dbe3cbde18009', './tiki-usage_chart.php', '21.12', 0),
('df051b601fa1b35a63ac80f9b836b90b', './tiki-user_assigned_modules.php', '21.12', 0),
('b575f5ef4215f864bc32124eea8f855a', './tiki-user_bookmarks.php', '21.12', 0),
('80735c0153f4e6706656bf9e4b821c5f', './tiki-user_cached_bookmark.php', '21.12', 0),
('cd92bb6f7cb38d444c521f4ed9009e2b', './tiki-user_contacts_prefs.php', '21.12', 0),
('6b8f41f0b6fe3cbbd7e58feabb083da3', './tiki-user_information.php', '21.12', 0),
('f2052244d87b495d1dd17e0a30ee65e2', './tiki-user_mailin.php', '21.12', 0),
('8117657808d0551ef27b742ae1f0c60a', './tiki-user_notifications.php', '21.12', 0),
('5174bfca208ddee6c4cfec4c5c84792f', './tiki-user_preferences.php', '21.12', 0),
('9a70ad1ec1165608734e2bf2bcf250eb', './tiki-user_reports.php', '21.12', 0),
('d8ee71d1b562e3baf19831311cae108e', './tiki-user_reports_send.php', '21.12', 0),
('d97b7d0331ecad4bb7eb9ce00a64745c', './tiki-user_tasks.php', '21.12', 0),
('06aca002d0dbea62a5791e4e2b7b5531', './tiki-user_unified_details.php', '21.12', 0),
('b66eadc2b5f59bd9e6f4ac92ea463a5c', './tiki-user_watches.php', '21.12', 0),
('1ebefeec706828864f3a5b324b3627a1', './tiki-userfiles.php', '21.12', 0),
('4de5468489d3f631aee7d8357ccab8fd', './tiki-usermenu.php', '21.12', 0),
('db33f286f8929994b07f35e77a4e9856', './tiki-userupload.php', '21.12', 0),
('8db3ccc3786cd10fdaaa2c2538c94b70', './tiki-userversions.php', '21.12', 0),
('9a80852609d04aa7ffda6d23f0db2192', './tiki-view_articles.php', '21.12', 0),
('03d07616f78b1849232b76e1fd113b28', './tiki-view_banner.php', '21.12', 0),
('b2b1b5fa422c4d3718142d5170f0b83b', './tiki-view_blog.php', '21.12', 0),
('469840c8e4e8de11962c050aaa0befe3', './tiki-view_blog_post.php', '21.12', 0),
('c0ed8a7a481313dae43ac098686bd1cd', './tiki-view_blog_post_image.php', '21.12', 0),
('89732a84f8b53f5c8fa949fe36bf8971', './tiki-view_cache.php', '21.12', 0),
('0257e9193dc910da5889b19e10730cf7', './tiki-view_faq.php', '21.12', 0),
('48f33b2f5a5ab1c7c6df5ecfc33a0a2d', './tiki-view_forum.php', '21.12', 0),
('09b1d526705833fd71d0fcc64db8d31a', './tiki-view_forum_thread.php', '21.12', 0),
('d9336b7f83b5d434ff932200484df281', './tiki-view_minical_topic.php', '21.12', 0),
('7da4aef54e06dee784caa668590ebb97', './tiki-view_sheets.php', '21.12', 0),
('c2debf05f92e4d45aa6b355152b83f4a', './tiki-view_tracker.php', '21.12', 0),
('88f6a6d069248be6ba6a16c58efd7bba', './tiki-view_tracker_item.php', '21.12', 0),
('3f90f693f63d7d2d7d14d622b2c36db7', './tiki-view_tracker_more_info.php', '21.12', 0),
('7999d7f6c95d860cdff27ab440f4fe4f', './tiki-webdav.php', '21.12', 0),
('cc3ac9cedb51cd10f483964e9e39fc20', './tiki-webmail.php', '21.12', 0),
('e3a942848846f3c859888a8b15096065', './tiki-webmail_contacts.php', '21.12', 0),
('8dc1f99ef5febf3f8ad43f0ee7a6b269', './tiki-webservices.php', '21.12', 0),
('99002f9fd49851faffdf2b7ec889f6c9', './tiki-wiki_rankings.php', '21.12', 0),
('578d0a9b4bc46a6b591c4b40be982edb', './tiki-wiki_rss.php', '21.12', 0),
('571e682540267ced78a5b959c8885c6a', './tiki-wiki_rss_no_diff.php', '21.12', 0),
('ac1233bfec6aba8c00a5b311333822e9', './tiki-wikiplugin_edit.php', '21.12', 0),
('53282e8a2406321b7600fd7326cd7042', './tiki-wizard_admin.php', '21.12', 0),
('770caf746492b1f981a54afdcd8faf4d', './tiki-wizard_user.php', '21.12', 0),
('c02f73641901998265da27b2a4ff6bf7', './tiki-xmlrpc_services.php', '21.12', 0),
('13e577a09b6f1e001d6c196f86b7eba5', './tiki_tests/index.php', '21.12', 0),
('c1a1f05d15df4b83ddbf69da945ed3d1', './tiki_tests/tests/index.php', '21.12', 0),
('7f04fe2600990564a5628dc033c0e613', './tiki_tests/tiki-tests_edit.php', '21.12', 0),
('edc59aa0b3540a5b2acbfaed5db7f358', './tiki_tests/tiki-tests_list.php', '21.12', 0),
('1dba0af03f520fae3281fe7fbdfb8971', './tiki_tests/tiki-tests_record.php', '21.12', 0),
('25d4b21564e0ff378d10f863250a4642', './tiki_tests/tiki-tests_replay.php', '21.12', 0),
('9ead1d3533c66a8cf9826e5178f72303', './tiki_tests/tiki-tests_show_xpath.php', '21.12', 0),
('19baa7fc0ac52626ef7649a9f3fb5995', './tiki_tests/tikitestslib.php', '21.12', 0),
('3e6a3198fc02db27ead18b38f08c62aa', './validate-ajax.php', '21.12', 0),
('86f1b17113e54b95ec9f604e319f9ffc', './vendor_bundled/vendor/Sam152/Javascript-Equal-Height-Responsive-Rows/grids.min.js', '21.12', 0),
('e067f78041d9ed8b5942928398a4accb', './vendor_bundled/vendor/adodb/adodb-php/adodb-active-record.inc.php', '21.12', 0),
('a84e7a0fc925905a93462882b4e56795', './vendor_bundled/vendor/adodb/adodb-php/adodb-csvlib.inc.php', '21.12', 0),
('2d81e247f548e92ee69465862457a9b2', './vendor_bundled/vendor/adodb/adodb-php/adodb-datadict.inc.php', '21.12', 0),
('1059b87430fbe1aa14893f5aad91446d', './vendor_bundled/vendor/adodb/adodb-php/adodb-error.inc.php', '21.12', 0),
('5914762257d9f8dfec772e067e9deba0', './vendor_bundled/vendor/adodb/adodb-php/adodb-errorhandler.inc.php', '21.12', 0),
('ae6fcf69062a83fd56768adfaf8dc019', './vendor_bundled/vendor/adodb/adodb-php/adodb-errorpear.inc.php', '21.12', 0),
('383a3e901c69100c08dce1c85879a427', './vendor_bundled/vendor/adodb/adodb-php/adodb-exceptions.inc.php', '21.12', 0),
('e2d13f9b8fa8185dc1088246bb0a9b50', './vendor_bundled/vendor/adodb/adodb-php/adodb-lib.inc.php', '21.12', 0),
('74b913bc248311bd5df0e7dc04d1e55e', './vendor_bundled/vendor/adodb/adodb-php/adodb-loadbalancer.inc.php', '21.12', 0),
('bdc29c3936b5c3d622e189d5c3959373', './vendor_bundled/vendor/adodb/adodb-php/adodb-memcache.lib.inc.php', '21.12', 0),
('8f3e1ef69e4cc786d4a55a400e4502e8', './vendor_bundled/vendor/adodb/adodb-php/adodb-pager.inc.php', '21.12', 0),
('dd54bd630b4e651ab0b627cce66236fe', './vendor_bundled/vendor/adodb/adodb-php/adodb-pear.inc.php', '21.12', 0),
('b02eb871ecd096a01eb4a1205e0b41df', './vendor_bundled/vendor/adodb/adodb-php/adodb-perf.inc.php', '21.12', 0),
('c0f91603c1d9bf73c6ecba9dcbbd7724', './vendor_bundled/vendor/adodb/adodb-php/adodb-time.inc.php', '21.12', 0),
('f8a65d45d9ebd701ba290750b9524d0f', './vendor_bundled/vendor/adodb/adodb-php/adodb-xmlschema.inc.php', '21.12', 0),
('e3164c319dc327a9ae887e485eb21758', './vendor_bundled/vendor/adodb/adodb-php/adodb-xmlschema03.inc.php', '21.12', 0),
('bfc65a28551e398e58eea6afeadc2d88', './vendor_bundled/vendor/adodb/adodb-php/adodb.inc.php', '21.12', 0),
('722309e13c1ac6e2f2b4e68d10a3dd21', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-access.inc.php', '21.12', 0),
('99f980e1b4a960e67621d70dc1266517', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-db2.inc.php', '21.12', 0),
('7de2050f2e7db9d81d1d05956fb5cefe', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-firebird.inc.php', '21.12', 0),
('fc30e938d2cce3f64fb29a0c9255dd76', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-generic.inc.php', '21.12', 0),
('ea36679d329b42ddaf4a03fe75913f66', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-ibase.inc.php', '21.12', 0),
('b8fe5765030deee7c0d0c7b08d381604', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-mssql.inc.php', '21.12', 0),
('c875e3b7bfc75c1dccf708287cdc23a0', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-mssqlnative.inc.php', '21.12', 0),
('7b0f60e38aecf8e1fd27748276c89895', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-mysql.inc.php', '21.12', 0),
('fe66cc7bfe78d74bbf3fefcaba17463c', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-oci8.inc.php', '21.12', 0),
('951d87252e66b6a49d0217869ea62b0a', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-postgres.inc.php', '21.12', 0),
('af6932268f7ab6f694470168d72a7d58', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-sapdb.inc.php', '21.12', 0),
('0e69efdc4a52389382a9ad5ff88a3c52', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-sqlite.inc.php', '21.12', 0),
('96a34a8acf529816ce5839ef048a87b7', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-sybase.inc.php', '21.12', 0),
('53b2b2d824b8aefdf0ce8f48217d7778', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-access.inc.php', '21.12', 0),
('15e62bfafadacbeec2626dbd0aa35bd4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado.inc.php', '21.12', 0),
('9112d8c635d042c40364ed4c4d006354', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado5.inc.php', '21.12', 0),
('4f137695676c51f45b49e8af780dd235', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado_access.inc.php', '21.12', 0),
('d08ad5e91a841d194cb399f084eca1b4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado_mssql.inc.php', '21.12', 0),
('bac10c35e4cf22470effa9d6ececc59c', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ads.inc.php', '21.12', 0),
('57cb10101be9b4983a0c9b73eb539aa0', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-borland_ibase.inc.php', '21.12', 0),
('6d3bfed1c980cd1940e161971c5f86c0', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-csv.inc.php', '21.12', 0),
('0c24bdb33c2091a4bebd20f61a8b75f3', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-db2.inc.php', '21.12', 0),
('01b1ccfcc63d559fbfc9afd951b20f4a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-db2oci.inc.php', '21.12', 0),
('813d11ad8535cb74504ba7fe8896ae61', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-db2ora.inc.php', '21.12', 0),
('a889596a6fd3ddfe51dacaaa12df994b', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-fbsql.inc.php', '21.12', 0),
('f9b2fa8d97ee22c56365bf291bb06db3', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-firebird.inc.php', '21.12', 0),
('85e9d61f6378e1a3e5c51731910806aa', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ibase.inc.php', '21.12', 0),
('3cecbec1fa865338d31d2f65d5a113ad', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-informix72.inc.php', '21.12', 0),
('dda0c4104000c5e03e2be7487c14b977', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ldap.inc.php', '21.12', 0),
('05285150f13f8fe42224734471f5cb18', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssql.inc.php', '21.12', 0),
('baaff14252b7344a017b8976e026cabb', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssql_n.inc.php', '21.12', 0),
('e03a8735a36d822ac9ce76761766d10d', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssqlnative.inc.php', '21.12', 0),
('579835c331bea6ecad0c501c62c817f9', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssqlpo.inc.php', '21.12', 0),
('7098fa78b6ca04eca19edee110e535f5', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mysqli.inc.php', '21.12', 0),
('09747ec47b78fc5644907962a3582a51', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-netezza.inc.php', '21.12', 0),
('e9ce9f60545aa88d940e4ce9cad7827f', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci8.inc.php', '21.12', 0),
('54e0c8ce8a6b749254f57f8462c1855e', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci805.inc.php', '21.12', 0),
('d83cd96cee212614f1f4f61e5257792a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci8po.inc.php', '21.12', 0),
('afe54a5bfc49107ae7b8128d0eddf1e5', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci8quercus.inc.php', '21.12', 0),
('e81e33dced107c1fc0b82252652052e9', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc.inc.php', '21.12', 0),
('f511537aa2398d443901e0727d0b6b33', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_db2.inc.php', '21.12', 0),
('274d6f960c158fc9f04702c10b02327a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_mssql.inc.php', '21.12', 0),
('141c18a1262b2cf52b8caa5b1dbad88d', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_mssql2012.inc.php', '21.12', 0),
('5368e398730549b09ecfd477d66e1835', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_oracle.inc.php', '21.12', 0),
('b7e4fb8ac1120397c71000dfa62d6d62', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbtp.inc.php', '21.12', 0),
('a67f05ef89a55a40c625cc9996e7928c', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbtp_unicode.inc.php', '21.12', 0),
('664bbd959351a2565f0c884114d4c0d9', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oracle.inc.php', '21.12', 0),
('4041310f1a52ab9e2ad3c6567426eaf5', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo.inc.php', '21.12', 0),
('f8d83ad7970e792bca6a22a9ce6eb5d2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_dblib.inc.php', '21.12', 0),
('ff5c83ddf861793dfd0e129fc52803a2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_firebird.inc.php', '21.12', 0),
('289fe077a9b9bed99bc66acbe48fa84f', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_mssql.inc.php', '21.12', 0),
('ecbd41c7099492b5735768f7a035f519', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_mysql.inc.php', '21.12', 0),
('0b848afb6e1f209924bd851c151901e6', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_oci.inc.php', '21.12', 0),
('5f1d6cedf3747b5233f017a254a408a6', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_pgsql.inc.php', '21.12', 0),
('c3512b55339d9da9ab2f88d511108807', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_sqlite.inc.php', '21.12', 0),
('1f9370a6d55d41440b941480125d9453', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_sqlsrv.inc.php', '21.12', 0),
('fea26748f516731461a989ac00e414b8', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres.inc.php', '21.12', 0),
('13def5a49a04010d5d4c0426ac16038f', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres64.inc.php', '21.12', 0),
('186509517f39396dedae84259cbc0b3a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres7.inc.php', '21.12', 0),
('d2280ebaa952d7b781a0c5ed7ab76969', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres8.inc.php', '21.12', 0),
('689f2ce83f70d3d014cd95dffc703596', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres9.inc.php', '21.12', 0),
('0c8ab8161a16bdd94cf2bea2ff92d96c', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-proxy.inc.php', '21.12', 0),
('efc9617936ba24ff5846c61115b487c7', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sapdb.inc.php', '21.12', 0),
('66058a88f4da4d506837fe8cc03306bd', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlanywhere.inc.php', '21.12', 0),
('b8955e0b4f2b6585a9dbfcd9a1dc79c2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlite.inc.php', '21.12', 0),
('7349f1515629157e09a4638874554153', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlite3.inc.php', '21.12', 0),
('2eab7bba1ef451f4f7c8bc5847c91d91', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlitepo.inc.php', '21.12', 0),
('c65b12971117d2fa7dd1fc29361f7a1d', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sybase.inc.php', '21.12', 0),
('b52598c53a6fb63d94c48913b688c5a4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sybase_ase.inc.php', '21.12', 0),
('56b5a13abad94e14a7b3dbd4ab71d944', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-text.inc.php', '21.12', 0),
('7ea2bf13c8bda10ff86eb5841a70ba60', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-vfp.inc.php', '21.12', 0),
('add136e231a627b7be351ff6ca9c2367', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ar.inc.php', '21.12', 0),
('71e73244678b3f04fd8e690d3e58bdbf', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-bg.inc.php', '21.12', 0),
('366f1f60d3836fa4c722340bc3c1dab8', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ca.inc.php', '21.12', 0),
('d4f4966c051b922ec4d17ac05e054718', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-cn.inc.php', '21.12', 0),
('09ce8fc357788b5115f4c912d3c4f97b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-cz.inc.php', '21.12', 0),
('e7f979d9655a9e9891c7e3652763cc68', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-da.inc.php', '21.12', 0),
('235fc4e9e38107c3d2d1db99f866b10a', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-de.inc.php', '21.12', 0),
('7b066499ec5b57c85119668cbeee220c', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-en.inc.php', '21.12', 0),
('b26a255006685960b871a3c9cbc8fd22', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-eo.inc.php', '21.12', 0),
('ebed7521e409da27c849432ab20d9fc9', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-es.inc.php', '21.12', 0),
('f9814b4da90fb900ccdac4681fc163b1', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-fa.inc.php', '21.12', 0),
('55883bb8c710f8c3109b3d398a9ec61a', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-fr.inc.php', '21.12', 0),
('3a996e75b894a114f75b100003081c3b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-hu.inc.php', '21.12', 0),
('0201b6bb3c03a221e6582a631443588c', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-id.inc.php', '21.12', 0),
('4e4c73b4513243e22f80ff07d937d6ae', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-it.inc.php', '21.12', 0),
('acaed1ee8440ac851ccd3cf96efa4221', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-nl.inc.php', '21.12', 0),
('dea11f79441cdaecafcedd12d550aa6d', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-oc.inc.php', '21.12', 0),
('a7032a4c367d69ca1a43f61a4741ca7b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-pl.inc.php', '21.12', 0),
('d6c502b7c98356aa4b2eb6e6a00f9f2b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-pt-br.inc.php', '21.12', 0),
('00ddf4bf439c1e263db8648b4288fa0d', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ro.inc.php', '21.12', 0),
('38d7c632415228e76fe87c94dbc0e38f', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ru.inc.php', '21.12', 0),
('d6f7146f671afdeda08973259d8cebf0', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-sv.inc.php', '21.12', 0),
('7067b8cda2f2d2f8d1283e41b22e36ae', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-th.inc.php', '21.12', 0),
('426d22512633a8e48c6c76bb4b8c8e5d', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-uk.inc.php', '21.12', 0),
('2229a01e49521509b53180de4df91c98', './vendor_bundled/vendor/adodb/adodb-php/pear/Auth/Container/ADOdb.php', '21.12', 0),
('749ac3502774282a8f9ef1e7bdc01e21', './vendor_bundled/vendor/adodb/adodb-php/pear/auth_adodb_example.php', '21.12', 0),
('4f880699033926d77954c6f31016dd47', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-db2.inc.php', '21.12', 0),
('63b4cb1d5b1a0b3670192d5453ef4941', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-mssql.inc.php', '21.12', 0),
('c12452bf53991086bf96e18e9e4da931', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-mssqlnative.inc.php', '21.12', 0),
('cbb73967f01b80b362d102343bb1600e', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-mysql.inc.php', '21.12', 0),
('c9b0bb9f4029ad7001b6498a0d768095', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-oci8.inc.php', '21.12', 0),
('3788786e2c222482bc7886441c83b922', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-postgres.inc.php', '21.12', 0),
('1adecd60e384a5a56cb85359fea942ea', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-sqlite3.inc.php', '21.12', 0),
('65789a0767226340f6c06262cb8a4267', './vendor_bundled/vendor/adodb/adodb-php/pivottable.inc.php', '21.12', 0),
('df0e1d4606c8e9ad1534f5f374f63e91', './vendor_bundled/vendor/adodb/adodb-php/rsfilter.inc.php', '21.12', 0),
('4fcc4ffa5dccc34f0a6105052d03584d', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-compress-bzip2.php', '21.12', 0),
('46ade874b83bdfcb7cdeafdd9c928756', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-compress-gzip.php', '21.12', 0),
('cecef8ae8539f6aa6d22ea15cd8219b4', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-cryptsession.php', '21.12', 0),
('095532a91dc1af383527af461cd2d98d', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-cryptsession2.php', '21.12', 0),
('e346d8bb1c9dc44088cf39cbb1b06d78', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-mcrypt.php', '21.12', 0),
('9ae66b8f7f0ba6006a6e8341a2a7d334', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-md5.php', '21.12', 0),
('80aaf47bc05a7e13b2bff9fab5414ca8', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-secret.php', '21.12', 0),
('c191bc4927da251ce1f230d2ab266a1d', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-sha1.php', '21.12', 0),
('3a747064dc523138dbb1088ce63564db', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session-clob.php', '21.12', 0),
('45c07858ffb0c205a6533cc8c3420fb1', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session-clob2.php', '21.12', 0),
('69580d7d81f1dde841a050854c88b0a9', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session.php', '21.12', 0),
('7430c142f3b87be511ba2d862fc84eac', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session2.php', '21.12', 0),
('42fef0886af1f6da31a06de273876b71', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-sessions.mysql.sql', '21.12', 0),
('3c64f822ee1b493b319c6e8196cc06b8', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-sessions.oracle.clob.sql', '21.12', 0),
('08d0fc1f5fbf8b79a4dca43cbd30e3a1', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-sessions.oracle.sql', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('c18239e9c4dfc4ff623e1fe22bcf24dc', './vendor_bundled/vendor/adodb/adodb-php/session/crypt.inc.php', '21.12', 0),
('47f0082ee6017b0ee3d4b7479cf0cef2', './vendor_bundled/vendor/adodb/adodb-php/session/old/adodb-cryptsession.php', '21.12', 0),
('9486261a2fce87c3c65aff7748432a26', './vendor_bundled/vendor/adodb/adodb-php/session/old/adodb-session-clob.php', '21.12', 0),
('294fea38ab5a98ee5907f0cb750fc52f', './vendor_bundled/vendor/adodb/adodb-php/session/old/adodb-session.php', '21.12', 0),
('4d0872dca97c054eea02d76ccd98420d', './vendor_bundled/vendor/adodb/adodb-php/session/old/crypt.inc.php', '21.12', 0),
('d8ed23776233ce76633265c20f1af176', './vendor_bundled/vendor/adodb/adodb-php/toexport.inc.php', '21.12', 0),
('2c011688c0b5f963e2847ff91f665527', './vendor_bundled/vendor/adodb/adodb-php/tohtml.inc.php', '21.12', 0),
('9f03100ab5ce18e0049c25c6c4916802', './vendor_bundled/vendor/afarkas/html5shiv/dist/html5shiv-printshiv.min.js', '21.12', 0),
('f4d9dea8e0ae8455500862bbb874d63c', './vendor_bundled/vendor/afarkas/html5shiv/dist/html5shiv.js', '21.12', 0),
('40bd440d29b3a9371b0c63fec41ee64f', './vendor_bundled/vendor/afarkas/html5shiv/dist/html5shiv.min.js', '21.12', 0),
('00fa8121ea05470b6a3efe154de02bc4', './vendor_bundled/vendor/ahand/mobileesp/PHP/mdetect.php', '21.12', 0),
('ccf40dff895f66d35001fcd71cb151a0', './vendor_bundled/vendor/autoload.php', '21.12', 0),
('6e95dd2494216f769895aad08ee15f79', './vendor_bundled/vendor/avianey/jqdoublescroll/jquery.doubleScroll.js', '21.12', 0),
('d59da0c3cbb6c638add30e0a4a6a81e1', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/BitArray.php', '21.12', 0),
('a3021ba4be3958c04563788bbb23f7bf', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/BitMatrix.php', '21.12', 0),
('c3b0c27e367ca617b373e367fc149b8e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/BitUtils.php', '21.12', 0),
('9e6de556e1e675c2900b9f2d8db3797d', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/CharacterSetEci.php', '21.12', 0),
('73b949abf8f24460e05afbe2105ff5c6', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/EcBlock.php', '21.12', 0),
('f53c873371e1c7df48c246a002851251', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/EcBlocks.php', '21.12', 0),
('7d44c8045fe6154647f9e6773e66c8e9', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/ErrorCorrectionLevel.php', '21.12', 0),
('787a29902b96c4338c3ed53e17818d9a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/FormatInformation.php', '21.12', 0),
('0128f5e4a4a706bb181f61e444098c30', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/Mode.php', '21.12', 0),
('6db969f0ea944932ea0a84f8d1cd61ad', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/ReedSolomonCodec.php', '21.12', 0),
('73a706cf6e1f9d420869ace65bf8acb1', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/Version.php', '21.12', 0),
('3c5a6dfe954ac9f959b50456121ad24f', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/BlockPair.php', '21.12', 0),
('94af6d1105f978a8f0501bdd6e3e06a9', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/ByteMatrix.php', '21.12', 0),
('402622af2fa543a1013c26f5ff35587e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/Encoder.php', '21.12', 0),
('a47086b0734afddc79f3549ad16f8422', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/MaskUtil.php', '21.12', 0),
('31a90c1cd414ca30999a66785de4a063', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/MatrixUtil.php', '21.12', 0),
('a44246d0cadae0e864785e42bb13bc01', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/QrCode.php', '21.12', 0),
('95af4f72c439481f267bd83903de015a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/ExceptionInterface.php', '21.12', 0),
('cc835a75527e12e061471f1ac8329871', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/InvalidArgumentException.php', '21.12', 0),
('a1aae0ca514fe724c15b6e4eb4a7602e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/OutOfBoundsException.php', '21.12', 0),
('b57f73d9f31bc095d867048d5eab7b45', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/RuntimeException.php', '21.12', 0),
('27c830cf0faf2c1a3347c0971ae6e04a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/UnexpectedValueException.php', '21.12', 0),
('cac33a1c7f390301341235cc09bfdc81', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/WriterException.php', '21.12', 0),
('3f8400219939201b60d03d9e01b2b997', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Alpha.php', '21.12', 0),
('da10aa15f9032ae3287bf1013cf4b7f5', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Cmyk.php', '21.12', 0),
('615eb72e3f50e7067ba50333ae4e9a31', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/ColorInterface.php', '21.12', 0),
('2d1024af0da19a81353cbcb93c4fb19c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Gray.php', '21.12', 0),
('4268ee1d388e8ee0b68cbe4e1405e46c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Rgb.php', '21.12', 0),
('dd2e3ea122f8147c0f93ca9096568abc', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/CompositeEye.php', '21.12', 0),
('cda648eb7233f0691c31961532a55909', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/EyeInterface.php', '21.12', 0),
('8aefd1cc9e1721e0658c19a069202102', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/ModuleEye.php', '21.12', 0),
('772bab04440f2fba69f8e077d14606c0', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/SimpleCircleEye.php', '21.12', 0),
('6c78cee3c14c8289039d7efb01a3b881', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/SquareEye.php', '21.12', 0),
('cbd38bfd7fce6bfc9d1d05a6ffceb71e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/EpsImageBackEnd.php', '21.12', 0),
('0b50b4c3d3a3a3f701c9ce604d8b01a8', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/ImageBackEndInterface.php', '21.12', 0),
('a089ebbe42b4e7072bdfbd0e2d88108f', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/ImagickImageBackEnd.php', '21.12', 0),
('d1014f20ba8a97241c50fc7fe7b3a8d2', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/SvgImageBackEnd.php', '21.12', 0),
('bdafa6f94eaf35a90b7aca759eff792a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/TransformationMatrix.php', '21.12', 0),
('c833b7ccb8d20f7c662e5a008b191c9c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/ImageRenderer.php', '21.12', 0),
('875f563b86dcb874b06931cef0fa6230', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/DotsModule.php', '21.12', 0),
('ae6b54daccd1cdca65569fac667f80f8', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/EdgeIterator/Edge.php', '21.12', 0),
('7b591429247e49c3f60c69b17d1e2b7b', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/EdgeIterator/EdgeIterator.php', '21.12', 0),
('b77e71695dfd80270b8a17702119e899', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/ModuleInterface.php', '21.12', 0),
('c05caece47dc31cdc6f1aca44f2f4cb7', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/RoundnessModule.php', '21.12', 0),
('1cb7d8140d6394d57aa6127ae05add83', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/SquareModule.php', '21.12', 0),
('5e10828fcdec1c0288d3a1c39ce37a22', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Close.php', '21.12', 0),
('bf2bed55211f29703706b37c48be9802', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Curve.php', '21.12', 0),
('a4fa9d3936ee0033c371b4876365040e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/EllipticArc.php', '21.12', 0),
('657dae52b5f9ae78d390b69718007fcd', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Line.php', '21.12', 0),
('03678e8b9a101e3823eff2eab4fd0f5b', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Move.php', '21.12', 0),
('27c16fc46a247b4e75589a836b20482b', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/OperationInterface.php', '21.12', 0),
('0a955a22b9c18417e71550886a5b96c5', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Path.php', '21.12', 0),
('6708a8261d9d9bb389b7328cb340d934', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/PlainTextRenderer.php', '21.12', 0),
('94500859bceef7245aeb21fe9fb8916c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererInterface.php', '21.12', 0),
('17d6762d731feab5786c44e39146b883', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/EyeFill.php', '21.12', 0),
('abaee43a0d4ccfbc1d0e531e81e465dd', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/Fill.php', '21.12', 0),
('c926cffebc01d109ea6ab404c5dcf329', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/Gradient.php', '21.12', 0),
('749cce0005f9aba2ade726f0c151c343', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/GradientType.php', '21.12', 0),
('c0d626499703513bff1e7751a7a5f3c8', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/RendererStyle.php', '21.12', 0),
('217cce9ee1b4aeade8abc8e4794a7fcc', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Writer.php', '21.12', 0),
('30bcab9c086559aad11d39876ecebcec', './vendor_bundled/vendor/bower-asset/fontawesome/css/all.css', '21.12', 0),
('ecd507b3125edc4d2a03aa6ae5d07da9', './vendor_bundled/vendor/bower-asset/fontawesome/css/all.min.css', '21.12', 0),
('2109e5b8cbf032b14e3834092af66306', './vendor_bundled/vendor/bower-asset/fontawesome/css/brands.css', '21.12', 0),
('2c213c9e855a714f04273ad8ddfec94a', './vendor_bundled/vendor/bower-asset/fontawesome/css/brands.min.css', '21.12', 0),
('24a6fa7bd20a9b9d95334c5747c3fc06', './vendor_bundled/vendor/bower-asset/fontawesome/css/fontawesome.css', '21.12', 0),
('a227f005fa7ae066c1068ac4b963514c', './vendor_bundled/vendor/bower-asset/fontawesome/css/fontawesome.min.css', '21.12', 0),
('60e052ee86bc6e1e2fd5c7927517a6a9', './vendor_bundled/vendor/bower-asset/fontawesome/css/regular.css', '21.12', 0),
('49c10bd7921f287bbd5b1180cb008e10', './vendor_bundled/vendor/bower-asset/fontawesome/css/regular.min.css', '21.12', 0),
('fd62ae25e6b0c3dd7446e29886f19e71', './vendor_bundled/vendor/bower-asset/fontawesome/css/solid.css', '21.12', 0),
('685a6b10be9f3db25acf78c5e7ba7379', './vendor_bundled/vendor/bower-asset/fontawesome/css/solid.min.css', '21.12', 0),
('39d0217c6a09db9151f1d042ea3a00b5', './vendor_bundled/vendor/bower-asset/fontawesome/css/svg-with-js.css', '21.12', 0),
('19cf47f65b95a2cbd2b4dd6a4988d373', './vendor_bundled/vendor/bower-asset/fontawesome/css/svg-with-js.min.css', '21.12', 0),
('6ba89750869a4b522e655726a15ed165', './vendor_bundled/vendor/bower-asset/fontawesome/css/v4-shims.css', '21.12', 0),
('a034d3c71bee546f625877d7932917f8', './vendor_bundled/vendor/bower-asset/fontawesome/css/v4-shims.min.css', '21.12', 0),
('40170a907ada3b3d54ed903ea3dd2e81', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-common-types/attribution.js', '21.12', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/attribution.js', '21.12', 0),
('30bcab9c086559aad11d39876ecebcec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/all.css', '21.12', 0),
('ecd507b3125edc4d2a03aa6ae5d07da9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/all.min.css', '21.12', 0),
('2109e5b8cbf032b14e3834092af66306', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/brands.css', '21.12', 0),
('2c213c9e855a714f04273ad8ddfec94a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/brands.min.css', '21.12', 0),
('24a6fa7bd20a9b9d95334c5747c3fc06', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/fontawesome.css', '21.12', 0),
('a227f005fa7ae066c1068ac4b963514c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/fontawesome.min.css', '21.12', 0),
('60e052ee86bc6e1e2fd5c7927517a6a9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/regular.css', '21.12', 0),
('49c10bd7921f287bbd5b1180cb008e10', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/regular.min.css', '21.12', 0),
('fd62ae25e6b0c3dd7446e29886f19e71', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/solid.css', '21.12', 0),
('685a6b10be9f3db25acf78c5e7ba7379', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/solid.min.css', '21.12', 0),
('39d0217c6a09db9151f1d042ea3a00b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/svg-with-js.css', '21.12', 0),
('19cf47f65b95a2cbd2b4dd6a4988d373', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/svg-with-js.min.css', '21.12', 0),
('6ba89750869a4b522e655726a15ed165', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/v4-shims.css', '21.12', 0),
('a034d3c71bee546f625877d7932917f8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/v4-shims.min.css', '21.12', 0),
('194e3c150b4f413e14580fc7d77bf7cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/all.js', '21.12', 0),
('96a9af0c577c9e60248c2fa3d3597e68', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/all.min.js', '21.12', 0),
('ea5a12f91eb4e22bc7016c4244f12e2f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/brands.js', '21.12', 0),
('d4d4a6d8a186618d6f2f457f527591f0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/brands.min.js', '21.12', 0),
('1f88f026bb89dfaa162643f4f06eddc0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/conflict-detection.js', '21.12', 0),
('35c9bafd67052858e7d68aca3a3ee8ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/conflict-detection.min.js', '21.12', 0),
('0d3ecc868f631131fe2a721e50d7f79c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/fontawesome.js', '21.12', 0),
('2272f69ea5bafa3f88ba33ee1db14b78', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/fontawesome.min.js', '21.12', 0),
('d10b6f4866e0e1e17fbbbd321e2c2d20', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/regular.js', '21.12', 0),
('23a234113676631d075cec2f97654096', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/regular.min.js', '21.12', 0),
('1d7ecf51e3bcfe5a19219e09e0c48619', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/solid.js', '21.12', 0),
('292db35eb345bf41d13022d9a9c42ca6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/solid.min.js', '21.12', 0),
('c0ea274430b4a0969ac4b9d25d12e7ee', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/v4-shims.js', '21.12', 0),
('5aec9c45548b29e5e5525bedd3b539bb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/v4-shims.min.js', '21.12', 0),
('750a15ededf664c2b06ab92abd35d88a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/attribution.js', '21.12', 0),
('5ced866ab3e161cb8b1e1a11f7b9b1f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/index.es.js', '21.12', 0),
('cefec9ed44c8b0fbb7655f14a6db910c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/index.js', '21.12', 0),
('632ee5338e9d7dfe152a1089587fcc08', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/styles.css', '21.12', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/attribution.js', '21.12', 0),
('fa5669d1c2027a91adfdd0c7bec04c68', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/fa500px.js', '21.12', 0),
('3fdb320f10f3ee070b8437b2b3cacf95', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAccessibleIcon.js', '21.12', 0),
('2b6ea11a02e7f0ea7ae6a97d280fea80', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAccusoft.js', '21.12', 0),
('8354fa8cced99710bfd20af5e74a60f2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAcquisitionsIncorporated.js', '21.12', 0),
('cc9a1d59ee98499096799e75f6d84a6f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAdn.js', '21.12', 0),
('f1da066ad0bfec0797484a1b2847516c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAdobe.js', '21.12', 0),
('03515bfb198925494424d7cb743833b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAdversal.js', '21.12', 0),
('e736a50f996d46859912cb3b0270e72a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAffiliatetheme.js', '21.12', 0),
('5e11d56dde590bbe42cd5c7a9163f392', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAirbnb.js', '21.12', 0),
('8122ff33df62848d6f0818418b6988bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAlgolia.js', '21.12', 0),
('0a4d35a34a787d627e949c95f48b772f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAlipay.js', '21.12', 0),
('7fb7ddc4856703fc0ec04486bd091d09', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAmazon.js', '21.12', 0),
('b761ef00d40a86fa5a3c25d89dd74f99', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAmazonPay.js', '21.12', 0),
('d228a8b67264ae423a3eb33611c2c016', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAmilia.js', '21.12', 0),
('4d0ac0565f58c4c05aa29a40a6234bad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAndroid.js', '21.12', 0),
('270e231938cbf7185b427b16852a6911', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAngellist.js', '21.12', 0),
('327ad4f5375459c6a0905c98ae1979e8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAngrycreative.js', '21.12', 0),
('8d1824e3099d37d5dfdc16a40025c7ae', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAngular.js', '21.12', 0),
('38f4adf7bf039844c82cf9abeec1108f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAppStore.js', '21.12', 0),
('0889f8d1f89b5433b14d73abc4c9d5c3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAppStoreIos.js', '21.12', 0),
('243b57607de8c547ab4f7a0ab09c042d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faApper.js', '21.12', 0),
('3f178d04bf5736b670bf5bd526e64876', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faApple.js', '21.12', 0),
('c7031ae2d6b433a93be523cf4ebc36d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faApplePay.js', '21.12', 0),
('f773833bd1f281d32025cf458c2c59cc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faArtstation.js', '21.12', 0),
('4de0489ee09fd40e5327c3c9f299a8d1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAsymmetrik.js', '21.12', 0),
('bf3043cc7dba1c219fa35d74bafdca5e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAtlassian.js', '21.12', 0),
('ae1fd4eeee64bdf9138f8d866245a643', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAudible.js', '21.12', 0),
('1e3b7c49417e202caed6cf51876649ab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAutoprefixer.js', '21.12', 0),
('e2606f1cc3f1bc22d7e7bf730ed303fc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAvianex.js', '21.12', 0),
('6e1fdb162b5ba5fd48702cda5e97ed7f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAviato.js', '21.12', 0),
('d5a8b1c33e45a7ff20aeaa2fe3bbeec9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAws.js', '21.12', 0),
('4054ba189a40103ea7b825f0575519a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBandcamp.js', '21.12', 0),
('fbf23e4e99a036e9bd8b56fbbd2664ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBattleNet.js', '21.12', 0),
('e271a13ddd9f8fdad03118dac6c4fc6e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBehance.js', '21.12', 0),
('b143ecbf551381a503c92789de6b8d41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBehanceSquare.js', '21.12', 0),
('e940728884f8a8e572f68e9b998630bb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBimobject.js', '21.12', 0),
('830cf8c4e4f101ba3e561866650976c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBitbucket.js', '21.12', 0),
('55fccea6b99f37488057968f359cafb5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBitcoin.js', '21.12', 0),
('269422b64d98a87a5a515e4cd5bb41dd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBity.js', '21.12', 0),
('01fd5e92b6cec23c4244d1baf700fd58', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBlackTie.js', '21.12', 0),
('4a7eb6ba99b3b79a8eac0bd0c295c2c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBlackberry.js', '21.12', 0),
('03004bedc086a74e8dc0b1d1dadaade7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBlogger.js', '21.12', 0),
('a2cfde66c30bbd1c044284503c8b64cf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBloggerB.js', '21.12', 0),
('e25bdf8573aa6ce5312dcbb1afbe5981', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBluetooth.js', '21.12', 0),
('d0a7ecf70c6797a14f86d33ba285b406', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBluetoothB.js', '21.12', 0),
('4d2d022a2a38acd9b7ae0dbc9fcd0384', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBootstrap.js', '21.12', 0),
('d7efdab0a54d652619a4dbe9aa3767b2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBtc.js', '21.12', 0),
('e786be0d05411cd3f7c21860069ef636', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuffer.js', '21.12', 0),
('2b1c43cfc9741c9c32dae34996bd7ac6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuromobelexperte.js', '21.12', 0),
('e6b61a827f99c225bb85513a2e4169ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuyNLarge.js', '21.12', 0),
('59032b209abb2fe45d2213d2cd8df330', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuysellads.js', '21.12', 0),
('9ab68d645c5752470954f8fc54340cd5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCanadianMapleLeaf.js', '21.12', 0),
('be61a7319657db6ddd4f70efcdbda872', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcAmazonPay.js', '21.12', 0),
('12431bac80ab36cb92b712342e832757', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcAmex.js', '21.12', 0),
('eb52ba88b0d44b69b7dbe761c8d6478d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcApplePay.js', '21.12', 0),
('e095b64cfc77796a980baba5fa2de921', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcDinersClub.js', '21.12', 0),
('29cbc70195b961a8629bc153b9069a4b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcDiscover.js', '21.12', 0),
('7d1583a72ca0cff0d16091ebed9c6f51', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcJcb.js', '21.12', 0),
('763a120410c1d43b1b056f6f027f117d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcMastercard.js', '21.12', 0),
('6bc6961b3a9eaa297596ec2b196196a4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcPaypal.js', '21.12', 0),
('95abcd4fa515b8becd63234478447abe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcStripe.js', '21.12', 0),
('c356f34de079f7fe99714f292c383fd8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcVisa.js', '21.12', 0),
('68a8b9f6cded567b77ac39e94d9af950', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCentercode.js', '21.12', 0),
('a2ff9b0ceef879d67cd17a446ad7fbe5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCentos.js', '21.12', 0),
('46d665e63b59612e88f05244875ad400', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faChrome.js', '21.12', 0),
('9d4339236a43b4d71c04c0db4295e57e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faChromecast.js', '21.12', 0),
('bba3c01529c790cc48e44ff647acc363', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudflare.js', '21.12', 0),
('019ecd47eef0abd64e7032747b72e7a8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudscale.js', '21.12', 0),
('3613afbf0b8b1d22d0faf87b5eccff79', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudsmith.js', '21.12', 0),
('72bafd517ad4381bf775e7db4a795128', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudversify.js', '21.12', 0),
('085136af104ee774e30059a58487026a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCodepen.js', '21.12', 0),
('8431b9e3be05d73e7c71c32b72273b8a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCodiepie.js', '21.12', 0),
('0af4697ab33cdb7afcebee8ba705a0c3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faConfluence.js', '21.12', 0),
('dabc5ac043d0380b96e3c98a43c04a1d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faConnectdevelop.js', '21.12', 0),
('1be3467e8d2332c92cfe5f2253993b2e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faContao.js', '21.12', 0),
('3b301f4cd0ae0d6eabf01812115aa3c4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCottonBureau.js', '21.12', 0),
('f543127e65501eb4df3d9cf92694fcb8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCpanel.js', '21.12', 0),
('6b9bfa5a8f94ae1f2490c2ddc3e5bd08', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommons.js', '21.12', 0),
('20ef2deddade2b88f2e115f7591fa394', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsBy.js', '21.12', 0),
('b1c1e839d06fa3858368b745eb90f80b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNc.js', '21.12', 0),
('e4562200164f29e98a26432fa992cde0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNcEu.js', '21.12', 0),
('827667c136042de16ef632ebf26187ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNcJp.js', '21.12', 0),
('59d7b35864f96abb1122de7d5e06b8cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNd.js', '21.12', 0),
('5b542c29f7df033926574eee375aa611', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsPd.js', '21.12', 0),
('cf803e40ecba6edfdd6ed05feafcb755', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsPdAlt.js', '21.12', 0),
('89d7bb7ac557009da281ecc915cb235e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsRemix.js', '21.12', 0),
('54e972143710facdb907ec22234aad83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsSa.js', '21.12', 0),
('71cc43f42c6c4f13c3ce5033edeecc57', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsSampling.js', '21.12', 0),
('0554fd95d29d62efb26f6e16af04afaf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsSamplingPlus.js', '21.12', 0),
('dbc1fcb6048f81bd7e8d23d77fa23d28', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsShare.js', '21.12', 0),
('4eb5c1555a9248acdac908d203894013', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsZero.js', '21.12', 0),
('c0174bb29919992a6a59318bbbf9e7ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCriticalRole.js', '21.12', 0),
('84a1bf5750246600005fe9a7e13b4656', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCss3.js', '21.12', 0),
('e3e8ab9d5ddbc1cd8a5966249f191575', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCss3Alt.js', '21.12', 0),
('01718ffa01f4718c278f0704ce9491ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCuttlefish.js', '21.12', 0),
('902f755ffb7f5c04743e0e9997b40580', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDAndD.js', '21.12', 0),
('c03f9a96b1f3a2f4b47273d5b9b8236d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDAndDBeyond.js', '21.12', 0),
('0406323f9dcaf2776f904e38f85ca52f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDailymotion.js', '21.12', 0),
('368fc934b993b16c3c3a39684985fec9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDashcube.js', '21.12', 0),
('e36c7273696c8f9705268669751ebdc2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeezer.js', '21.12', 0),
('cc487a485fbde10aab9b805e7a40af8f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDelicious.js', '21.12', 0),
('d67685d312bc5cf9e2a40f5b1e36ae87', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeploydog.js', '21.12', 0),
('ff2045d2968d319c35cfa83f93151f3b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeskpro.js', '21.12', 0),
('287eab055e5827a605119b30af9d1336', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDev.js', '21.12', 0),
('ef85a530a164978071cd8baa50fa4332', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeviantart.js', '21.12', 0),
('5e8c226f88566d9f9842928d5df5603e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDhl.js', '21.12', 0),
('4cd634e46b08cc9e99d0f88ee0692ef1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDiaspora.js', '21.12', 0),
('5abbd4d5cef6c43026327ad1ad10871b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDigg.js', '21.12', 0),
('ee02a257b296ce608b077489ef560ff9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDigitalOcean.js', '21.12', 0),
('c54158332162f99c1ccf403baf824d1b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDiscord.js', '21.12', 0),
('95789134e853c2736e435d92d8c44e58', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDiscourse.js', '21.12', 0),
('b99dbac7efa88b30e41c56f9144e9658', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDochub.js', '21.12', 0),
('fba7387ef6e7482a34a9759e4be2db00', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDocker.js', '21.12', 0),
('348da4b41317a01515e13787eb7b3ded', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDraft2digital.js', '21.12', 0),
('9c106b01ea55d157e3f74ce270196cad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDribbble.js', '21.12', 0),
('7ec9d08416fbbabbb4a4f0c65a77e53b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDribbbleSquare.js', '21.12', 0),
('a89458290c547e410a5a435dcfdbbc8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDropbox.js', '21.12', 0),
('4bcdb95e6bc2758ae72243d927358acb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDrupal.js', '21.12', 0),
('b2a3a0d2aa9fc6a05baf7352e0e82509', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDyalog.js', '21.12', 0),
('bddba6ab450c8db8de99b27c46a54dd7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEarlybirds.js', '21.12', 0),
('9197cd1bfa712ed6050eb93f773f065c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEbay.js', '21.12', 0),
('116bd7085965fb077887c5b4868509aa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEdge.js', '21.12', 0),
('bf2873819aecc8fa6fb8ff46c33096a8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEdgeLegacy.js', '21.12', 0),
('2189273a31a4a2485f6dddfb28bca1bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faElementor.js', '21.12', 0),
('55afb691c836794b8dbcbe9855826267', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEllo.js', '21.12', 0),
('b4d10b18f5cbadd800e5bc4f9b9a004f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEmber.js', '21.12', 0),
('4948fa023a9881882520e619d6bc6bc2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEmpire.js', '21.12', 0),
('73dfc366a948ebd1db2b7e8f4b43ca8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEnvira.js', '21.12', 0),
('d565e4206a4bdf16467b200c98e56277', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faErlang.js', '21.12', 0),
('e3bdd00a951744a0d4106a3c0322c762', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEthereum.js', '21.12', 0),
('5db24334b52c53b721f2ce9ad2705344', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEtsy.js', '21.12', 0),
('85378d6670f30ba506ab32cc7b38f157', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEvernote.js', '21.12', 0),
('c0878268bd5612f407162ba39dd05681', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faExpeditedssl.js', '21.12', 0),
('38fa8cad4ff6dab84118e388a78bb267', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebook.js', '21.12', 0),
('0f78ae7c36b7049424777e434c01d2c2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebookF.js', '21.12', 0),
('bd5c46d1939523a8e8ed912791159194', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebookMessenger.js', '21.12', 0),
('791b9de16037565de43be9191937891d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebookSquare.js', '21.12', 0),
('7081e9f2b2220f5abe264f68b810755d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFantasyFlightGames.js', '21.12', 0),
('7b9cce8cbc4a6930e86325b4e83451b4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFedex.js', '21.12', 0),
('79fdc43ad3e3322260f0e6f9d920f131', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFedora.js', '21.12', 0),
('10034461c5f1206d66a78a9659729273', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFigma.js', '21.12', 0),
('aa6754d230b83bbe125b21a837fb5463', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirefox.js', '21.12', 0),
('6efb12a3fe74bbfe1ed76c1324638d5a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirefoxBrowser.js', '21.12', 0),
('9d00a0de8ca57f7362aa1375c5bd2126', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirstOrder.js', '21.12', 0),
('11ec9331dfce8dff401c18592c293690', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirstOrderAlt.js', '21.12', 0),
('c9e3c5cccc8111851f4abf83c9c3341a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirstdraft.js', '21.12', 0),
('1aa1b470c4a403a3c447d91074f76f9d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFlickr.js', '21.12', 0),
('7c698b767faf081dce3a449f01b09b05', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFlipboard.js', '21.12', 0),
('1291ffac97f2de3f41835924621f4f9d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFly.js', '21.12', 0),
('4606422f1d4c914479e3d3fb369517b7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesome.js', '21.12', 0),
('03edb8fe3d1002b3479307491c2d21e6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesomeAlt.js', '21.12', 0),
('c150b4ad2facc1558525df381b975ec2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesomeFlag.js', '21.12', 0),
('832edd0290435015150ad2321fbd411b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesomeLogoFull.js', '21.12', 0),
('edbc8b4a9d67c75d1d3ef69e215c1a71', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFonticons.js', '21.12', 0),
('5534e041f41a54787c264421cf859068', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFonticonsFi.js', '21.12', 0),
('9dea4f238b9cdea48b7308f8937ee21a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFortAwesome.js', '21.12', 0),
('714e1e9480179551bfc6ea66a97cb5e6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFortAwesomeAlt.js', '21.12', 0),
('ec2c528d3b19958c0dfe2ad7e2b80d90', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faForumbee.js', '21.12', 0),
('d3dc3c1a66d6d0f8abadfb09aa4f7e6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFoursquare.js', '21.12', 0),
('4ac56c953581d2c9be09d271d1812072', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFreeCodeCamp.js', '21.12', 0),
('588e1986e81d7d2ef45087530b223214', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFreebsd.js', '21.12', 0),
('7a804bbf0ffebdcf0c8124a8e6561fb5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFulcrum.js', '21.12', 0),
('b909c93b2791e4a621f27ba36de540d9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGalacticRepublic.js', '21.12', 0),
('d1b4cec69804b5de32e3fd304f6e804e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGalacticSenate.js', '21.12', 0),
('3279b3c7c1def4a043da772bfd648120', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGetPocket.js', '21.12', 0),
('e5d94297425890a5134f18a8cf1bef5d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGg.js', '21.12', 0),
('cea533fd2b2c4aefd6975473d0b44828', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGgCircle.js', '21.12', 0),
('c672846dbbc66d2d832c59de57d84a9c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGit.js', '21.12', 0),
('4caa984cc0c118d84b44a669a6876c48', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitAlt.js', '21.12', 0),
('6e5c8d260f98cb1b5c4320f91ab0e677', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitSquare.js', '21.12', 0),
('cf5a4b8f2cd8fd41d72f2c18774840a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGithub.js', '21.12', 0),
('52ccf898300342fbab845fdd24ac13c2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGithubAlt.js', '21.12', 0),
('df49c9f9e3df3ae95a624d544ede4063', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGithubSquare.js', '21.12', 0),
('b6a9b8d8fabbd3d06b263a83840c25f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitkraken.js', '21.12', 0),
('3e7be9fd3070b8acccce6f7a366f0ac1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitlab.js', '21.12', 0),
('a9209c0499470d4496f640ed5ef87924', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitter.js', '21.12', 0),
('377681e66a6e8cd122f8956c2d98444e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGlide.js', '21.12', 0),
('f3855ffc520c78b2ddb0cf1a06d146c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGlideG.js', '21.12', 0),
('3d2daa84462f77377e8c5c466c2988a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGofore.js', '21.12', 0),
('a333f28c0a3e775c1a2d5c7385fcb84f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoodreads.js', '21.12', 0),
('818edad2b5943151c5349bfbbc6a3114', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoodreadsG.js', '21.12', 0),
('5debfcdd6ce27729b1dfb13667bb726b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoogle.js', '21.12', 0),
('7388178e1e40e376cf6e62ccaba0aacf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoogleDrive.js', '21.12', 0),
('a17534720c5ff4f49eaac866d65cd6a6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePay.js', '21.12', 0),
('9834b525c696d6cb20a42852fd9e7226', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlay.js', '21.12', 0),
('d02c4667cc244786fb323630df4a2c21', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlus.js', '21.12', 0),
('ce8f5620d0e3316bd73d53774a295891', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlusG.js', '21.12', 0),
('c5fa960932e02606a0053103c3257b62', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlusSquare.js', '21.12', 0),
('a84b943689c11e64d5cf72c79fed38d3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoogleWallet.js', '21.12', 0),
('4c2237602fbdc04b11a826a3dffe35f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGratipay.js', '21.12', 0),
('7e0c6bba676915ea3b54a87061f735ad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGrav.js', '21.12', 0),
('3402acb7167102d00468656a6797daea', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGripfire.js', '21.12', 0),
('4432f88c8151322f43d7192a7e6f83df', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGrunt.js', '21.12', 0),
('02fd805a74ba65af7d56577ac585ea77', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGuilded.js', '21.12', 0),
('12389d9954316bf92a8a5b9ab9abc3fe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGulp.js', '21.12', 0),
('c150c938259f62b03c68214ea5dd38b7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHackerNews.js', '21.12', 0),
('f0611b3bad98631d79cac65a35ba9c0e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHackerNewsSquare.js', '21.12', 0),
('8007e93c607c7124500360e28d2d2588', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHackerrank.js', '21.12', 0),
('7bd54ce8f47d1ff38f06f5a9d419a494', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHips.js', '21.12', 0),
('5f022034b659bb4e5944dcbe7a49f907', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHireAHelper.js', '21.12', 0),
('edc26954906cf7c2576278750a13cd21', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHive.js', '21.12', 0),
('c9fcd700502c2fbd6695d688bfa3c418', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHooli.js', '21.12', 0),
('defca7cfa87147110573bb39f8c98877', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHornbill.js', '21.12', 0),
('1c99086d58b3f5aec55a6898d844ddc6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHotjar.js', '21.12', 0),
('b596e1c39e2b35cf3a9a2b34462d91e1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHouzz.js', '21.12', 0),
('1304dad3b7fa35e8592617951ca171cb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHtml5.js', '21.12', 0),
('086fdfe68bd902c872ec12f987d5522d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHubspot.js', '21.12', 0),
('bd6733c13c46227bc31d86a6ff371c20', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faIdeal.js', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('88376f723649d2ec3ab5d929f012caa8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faImdb.js', '21.12', 0),
('35d69ac887def0f6cdc0b0d418cb71c8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInnosoft.js', '21.12', 0),
('ada62cff953999b802b3755126391ad4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInstagram.js', '21.12', 0),
('5d472ec330584ab729a02249e1a857ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInstagramSquare.js', '21.12', 0),
('d854f4019c525e55ce9c00560b9d324a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInstalod.js', '21.12', 0),
('c67e13cf200f52377bda76ffd53c969b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faIntercom.js', '21.12', 0),
('d1fe95d7fde69fa5c204b74820102296', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInternetExplorer.js', '21.12', 0),
('f599e9b3c683e90a1ec37e35d79d2984', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInvision.js', '21.12', 0),
('b25224cb92e59f89d402a6363b4ce278', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faIoxhost.js', '21.12', 0),
('a03020482e905269c763770bc3c47b4e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faItchIo.js', '21.12', 0),
('db8914acd7b06fa2e06e8e7e67a251b8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faItunes.js', '21.12', 0),
('11f7dda8c98665cbc9a3580407bdf516', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faItunesNote.js', '21.12', 0),
('61a1d502628217d1565f57ff342aeffd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJava.js', '21.12', 0),
('4a9abba0f789180b1fabc807184db8a5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJediOrder.js', '21.12', 0),
('a5ce95161d4811069d7ccb3c90883d60', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJenkins.js', '21.12', 0),
('9ded6bbc3dcb90314fc1a12acf53ca57', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJira.js', '21.12', 0),
('65ecbcdadd28fdbfe3ec3bb2c8c39ab7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJoget.js', '21.12', 0),
('03fd85011b06a4c65a6e687dab646653', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJoomla.js', '21.12', 0),
('0ac18f7cca89dc9b244d516f6d4c1c59', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJs.js', '21.12', 0),
('0660b552e85172dc330cbe9133ff77b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJsSquare.js', '21.12', 0),
('f59c7066c2053a12f15d43a48006b4d7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJsfiddle.js', '21.12', 0),
('e4c4fc2b54d37b29e450081e99cae77c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKaggle.js', '21.12', 0),
('de247b8b36cda461e082fbfd91f2dbc1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKeybase.js', '21.12', 0),
('fdf5ff1aee9d26709496f464c1aad964', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKeycdn.js', '21.12', 0),
('9130fcba70a5ecc9888651630b5b8170', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKickstarter.js', '21.12', 0),
('1fd4327417c88e027bcec804b4f1bd58', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKickstarterK.js', '21.12', 0),
('82cd3924ae376fb66de0d1cec1461c6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKorvue.js', '21.12', 0),
('08b1a73dde5932ec010c9d12c02928ce', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLaravel.js', '21.12', 0),
('95a301bf37eabd30bfce484eedbf729c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLastfm.js', '21.12', 0),
('069763116cd68692e65f9236e3069ae9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLastfmSquare.js', '21.12', 0),
('a53946883c7469e3b472868189f8bcfb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLeanpub.js', '21.12', 0),
('162d2e18eeae824a49d25ffee07a5253', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLess.js', '21.12', 0),
('67e31b6af8885dcecddd57b1c4623249', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLine.js', '21.12', 0),
('9dd2d64a862102241426453cc017bff6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinkedin.js', '21.12', 0),
('c7e4197984cb973db30787f8d8d2101a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinkedinIn.js', '21.12', 0),
('53118e88dad9d0e7284796a2662436e0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinode.js', '21.12', 0),
('f57627b333e3b0f63d0e2d77efef5c45', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinux.js', '21.12', 0),
('29d8e0be3000e853f4a96628b69cff8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLyft.js', '21.12', 0),
('fd13e68c4b31dba9094b38bfe477a028', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMagento.js', '21.12', 0),
('567813c955da380fa31eaaaa500d5201', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMailchimp.js', '21.12', 0),
('b71c85ae226360fe810675e20b10d5e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMandalorian.js', '21.12', 0),
('4d1eba7d198771be154bb9b81a165ef8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMarkdown.js', '21.12', 0),
('ba64377b9ca1aca653f5d47202e283a5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMastodon.js', '21.12', 0),
('fd3869e30b127333be3671b2255456e2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMaxcdn.js', '21.12', 0),
('6afd6f47c9a0edd4f154484a34d146d7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMdb.js', '21.12', 0),
('c2e79a3ec9158affe2e9435b1c4fa04f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMedapps.js', '21.12', 0),
('135789114b3834bad4a84a6914a4272f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMedium.js', '21.12', 0),
('f5afe136c4bc2cc8c4cf4bdad23fe683', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMediumM.js', '21.12', 0),
('103e592284757f9f81f0b7f39f1a415c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMedrt.js', '21.12', 0),
('6d4111032faf5a4f5478a607842241c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMeetup.js', '21.12', 0),
('84fb64708cd1b5319e3a457a2baf5645', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMegaport.js', '21.12', 0),
('578a8ee221c5dd3a3d429198856209c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMendeley.js', '21.12', 0),
('92d1313863dc0efd8324b944036af67f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMicroblog.js', '21.12', 0),
('7cbbca306088f88a5c9dc9d65cf8a8e3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMicrosoft.js', '21.12', 0),
('6ada5970a68449d7af05e39003505873', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMix.js', '21.12', 0),
('ea8e82eb5571266f91e3f2ff058d5f84', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMixcloud.js', '21.12', 0),
('be3c97a4fd1fe3060357a39563157057', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMixer.js', '21.12', 0),
('02d1bd0c7632872a3647728fc89492ab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMizuni.js', '21.12', 0),
('3e8aebfe900e386b171ad20897cf933b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faModx.js', '21.12', 0),
('1bd1fdbc3ce50c6a759379f4d43cea37', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMonero.js', '21.12', 0),
('2cc47b7c76a7f1b39a014bd347795aa1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNapster.js', '21.12', 0),
('6e3a5429a360072ac595e670d2e002a2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNeos.js', '21.12', 0),
('8cfbead6b9ff8f923a68f4939a73cb5b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNimblr.js', '21.12', 0),
('bc44cbaf82c9b8140c3f4ea751f73ee3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNintendoSwitch.js', '21.12', 0),
('f73ce7758c7a187b306b49b7da1a7ab6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNode.js', '21.12', 0),
('4b4e12469267c7bd10978b7b27b22fe1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNodeJs.js', '21.12', 0),
('9cb95171d0259e0b618ae9d55cb0887b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNpm.js', '21.12', 0),
('5490c3aefe35836bf30eafc0a8999413', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNs8.js', '21.12', 0),
('1c8b26235984b80adf22e6e1b3d47a1f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNutritionix.js', '21.12', 0),
('9fa42b058deb7a54d4c2966f24ecf579', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOctopusDeploy.js', '21.12', 0),
('92f32e025a25fe73e7027faedaa051a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOdnoklassniki.js', '21.12', 0),
('747216e761774e83efac8842caef6510', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOdnoklassnikiSquare.js', '21.12', 0),
('7300a6f7f8acb799ad82f30d661f94c5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOldRepublic.js', '21.12', 0),
('4671d58f5e301d15d4adbb01d6094a9f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOpencart.js', '21.12', 0),
('b3dd798eaed4fe13163719472eb892dd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOpenid.js', '21.12', 0),
('1c05f752f2c6cae8d3a59489839fff41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOpera.js', '21.12', 0),
('0571ff5800c6e7ae364d463da8caa0f8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOptinMonster.js', '21.12', 0),
('c1442615c9f25cf2dc1715bf0f52b026', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOrcid.js', '21.12', 0),
('29540a734bea6ee3a4bc29fac388a3cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOsi.js', '21.12', 0),
('dba0612775cbd7893885ce2234f531af', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPage4.js', '21.12', 0),
('7709f70f58b32e82ccf6f37f11305333', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPagelines.js', '21.12', 0),
('05f0005124a2fffc7f6832722a70cad1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPalfed.js', '21.12', 0),
('be758e97bfb01d2e7ea9df4fecc58fa1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPatreon.js', '21.12', 0),
('72ca70c671067085db8ddd79430e025c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPaypal.js', '21.12', 0),
('0ce1d9f3622cc5b94d1367db7dfe7c30', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPennyArcade.js', '21.12', 0),
('abfa5a6582efc6455d7838de5bd300f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPerbyte.js', '21.12', 0),
('e63816a3d2d620f6d1f80eeb0a8016ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPeriscope.js', '21.12', 0),
('2f953ba1cf26bc59e56f73fe68274f9b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhabricator.js', '21.12', 0),
('b670fbd77c8fef94bdab15a7f0712a5a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhoenixFramework.js', '21.12', 0),
('ad4747f3e5e14c9416e3c24eb86d5f20', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhoenixSquadron.js', '21.12', 0),
('5c4536e34def0608e872b39b2d8c8fab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhp.js', '21.12', 0),
('182f57565280e97e11018f1ffabfec3e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiper.js', '21.12', 0),
('1ea208f74d5685d199871aeebd077e8e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperAlt.js', '21.12', 0),
('62eadbc908f365e4e1e0ec50de293025', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperHat.js', '21.12', 0),
('45dbb87f1f621e59806a70d617205dc1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperPp.js', '21.12', 0),
('e81cdbcf37a87c19aa1920cb3ab83da4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperSquare.js', '21.12', 0),
('b7df593e9f7da0d4800a81ddf4d79e66', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPinterest.js', '21.12', 0),
('63713b27650b2a16b28ff2d0e27088c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPinterestP.js', '21.12', 0),
('975f71060b96592737f49eddf0098f6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPinterestSquare.js', '21.12', 0),
('1faddd4c89057f37e11646b8eec21b0b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPlaystation.js', '21.12', 0),
('2403d6651042eee8dec7efcda567dcad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faProductHunt.js', '21.12', 0),
('9b4b177279a9c782b0d9944b645173ed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPushed.js', '21.12', 0),
('e3f5cf76bf40f9adbb9e14b89973c8cc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPython.js', '21.12', 0),
('2945cb8e1bbbd57d85a9b20b153fbb6c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faQq.js', '21.12', 0),
('36a0736625669b5990482d6bbe847890', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faQuinscape.js', '21.12', 0),
('e63ed1e8f56561b11ab104db1dcf3a47', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faQuora.js', '21.12', 0),
('739dc6ff93183847b9934b84e5dbeb28', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRProject.js', '21.12', 0),
('dc94520a2daf135e6dbd6dadf9a70069', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRaspberryPi.js', '21.12', 0),
('1820a539ef39259cc274672ec05e693c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRavelry.js', '21.12', 0),
('bf6aaff542f18e101abbe500d9d03150', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReact.js', '21.12', 0),
('c71f4f027d1750c03d811fbd4f6bd46c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReacteurope.js', '21.12', 0),
('17a3cd8ea90e08021ba426443048e769', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReadme.js', '21.12', 0),
('c8478f8733d289caecf711900ed5e399', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRebel.js', '21.12', 0),
('eb434bb7a54cdba84be3f6e2b4777494', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedRiver.js', '21.12', 0),
('5bea48ce0ee873f93f5f0749b69de8c2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReddit.js', '21.12', 0),
('7293bbb1e5e955c8b91617afc2e6a0d3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedditAlien.js', '21.12', 0),
('cc55b6c3742e38237ae2a31bf02b3270', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedditSquare.js', '21.12', 0),
('306b44cfc99c3fabe4edecc671880a3d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedhat.js', '21.12', 0),
('885e629155a7bcc126ef8c6612524ee6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRenren.js', '21.12', 0),
('f0ea85b5b360753b34b2d8f4a9876a90', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReplyd.js', '21.12', 0),
('720cc324230609fb9f09c564544e38ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faResearchgate.js', '21.12', 0),
('a41e3dc8c39a1ad0b23b654a3938b40e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faResolving.js', '21.12', 0),
('ec74168bfeaacbd9851c8cea93bd8148', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRev.js', '21.12', 0),
('e2f34b9ab84b0d76c64145d12020c07b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRocketchat.js', '21.12', 0),
('bd82484b8d2c444ff08eb255e78da3dc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRockrms.js', '21.12', 0),
('b979ad40c43613396ffc49e3f9c71d89', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRust.js', '21.12', 0),
('691077f4cae986dbfcd54dc36f48a312', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSafari.js', '21.12', 0),
('42c2cd860fe10708a255aa0491747112', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSalesforce.js', '21.12', 0),
('3706eb11037e92f38a00a7095bdf3a1e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSass.js', '21.12', 0),
('5c1f2ebd64c41425033a5abf038e5e10', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSchlix.js', '21.12', 0),
('044cbc2e4bd1086560b8ae4d6031aa83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faScribd.js', '21.12', 0),
('73ec0ea59e405b1ecf050a3efdb919ea', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSearchengin.js', '21.12', 0),
('4891733896653837d3c4e8e99f93dc70', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSellcast.js', '21.12', 0),
('0112928e8c8fe098eb26175e841c632c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSellsy.js', '21.12', 0),
('9a12fae2ce56cd49a4e64df283bce612', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faServicestack.js', '21.12', 0),
('bc227bf5ef4dcbf0b5a66d98ee3693eb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faShirtsinbulk.js', '21.12', 0),
('cd37ded98d7cc33f07eacb4b2469456f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faShopify.js', '21.12', 0),
('50c979ae97aef6be65eced5fdeb51e6f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faShopware.js', '21.12', 0),
('256df34a8c5d67d18cd0d28755228062', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSimplybuilt.js', '21.12', 0),
('fbe54b73c70feaebff85b2bf02e49942', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSistrix.js', '21.12', 0),
('01efbc465c31eea5567ec472fa9c1bd2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSith.js', '21.12', 0),
('294f2c5a7605904493305ad43927029c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSketch.js', '21.12', 0),
('edb19b25aa8f3edb216bb218bc7793a9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSkyatlas.js', '21.12', 0),
('9c9646aa9991d7b17f15c9d4c8e1714e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSkype.js', '21.12', 0),
('0d6e04f2640911aee61f4788dea04b6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSlack.js', '21.12', 0),
('1427706d2df05e3e03f384e5bae3bf87', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSlackHash.js', '21.12', 0),
('a564a3e176528f6be689b7c7dbd63b15', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSlideshare.js', '21.12', 0),
('20f90f1fccfc38816ade89a6ac2157f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSnapchat.js', '21.12', 0),
('b0705104137c59487faae4e51bdbd849', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSnapchatGhost.js', '21.12', 0),
('53fbd8a089483711628d10391bd651b4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSnapchatSquare.js', '21.12', 0),
('c53816f55147d730389cbba59157b719', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSoundcloud.js', '21.12', 0),
('1977716d00ebdcb5170b8bdba7fdbbbe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSourcetree.js', '21.12', 0),
('1b6a0b27a78ec9ce04ae556f91c27276', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSpeakap.js', '21.12', 0),
('2b423cf5d58424df716e0cf1ab48f167', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSpeakerDeck.js', '21.12', 0),
('1a52f840969307dc21337c3cff923e34', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSpotify.js', '21.12', 0),
('1b1986881c4443ae38439f5596fb7377', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSquarespace.js', '21.12', 0),
('08f1d47966998223f6e9b24c7d6f4516', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStackExchange.js', '21.12', 0),
('fbc056ca106adc6708ca6ed55e6548fd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStackOverflow.js', '21.12', 0),
('baeaa352674b5d33406345787fb15c0e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStackpath.js', '21.12', 0),
('e10f50c7d54aaca32332b218f9537168', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStaylinked.js', '21.12', 0),
('9d07d84d8c164609b6fe2fd8766a2381', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSteam.js', '21.12', 0),
('029b846822362eaaa91831c9a9e6646e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSteamSquare.js', '21.12', 0),
('d404539220f7a2317b46e3293ed1667f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSteamSymbol.js', '21.12', 0),
('d42996dc1b0b6f975091b1a40b838ebc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStickerMule.js', '21.12', 0),
('ef762e6b1187c29adabbe37fcc5707f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStrava.js', '21.12', 0),
('cc4898b22a2d83efdc0f301ebadea500', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStripe.js', '21.12', 0),
('9386a8ee3f0fa68b7ba5890c6a2fb660', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStripeS.js', '21.12', 0),
('5d5da6efd5386568d3927f404f628fbb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStudiovinari.js', '21.12', 0),
('933aa1e305a6517a5d70aa2cbcca83f0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStumbleupon.js', '21.12', 0),
('cdec1133e09dad7e77408588e8926303', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStumbleuponCircle.js', '21.12', 0),
('ae1a878cbce3af2c656a2af0d7cab886', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSuperpowers.js', '21.12', 0),
('1ab0c69388ec39a248b8e809e855513d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSupple.js', '21.12', 0),
('47808c17f8a15e642d62486bf791a763', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSuse.js', '21.12', 0),
('a179ab42606b60b9edaf5ac5a12d8cc2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSwift.js', '21.12', 0),
('16adc82d8c908da6ffdb4efe1b3e2e65', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSymfony.js', '21.12', 0),
('200496667f4435bcde6efc8889cceca9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTeamspeak.js', '21.12', 0),
('dde2a4e48bb75e47b4a55934681c8f3b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTelegram.js', '21.12', 0),
('9a23638d5126729f10bca1232fa51e0f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTelegramPlane.js', '21.12', 0),
('380339330a212d57ed37aa36edaf104f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTencentWeibo.js', '21.12', 0),
('b8bc9c8dce1208726fe376a4bad0fbf0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTheRedYeti.js', '21.12', 0),
('544d82b4f9c0fe8b99467dbc42612f36', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faThemeco.js', '21.12', 0),
('4c627ffa00736f9f7d9d697400e6b0e2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faThemeisle.js', '21.12', 0),
('dd27b5b72c68bc0471a6fa350d6f6058', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faThinkPeaks.js', '21.12', 0),
('77246050df42fe483f9fee6f0cb3af57', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTiktok.js', '21.12', 0),
('fde59d60100f1fefe7e7535291d50e61', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTradeFederation.js', '21.12', 0),
('f229270f952cb5f0687b0e069db68555', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTrello.js', '21.12', 0),
('f93033f3da7f0fc2d6774fa43ca37b41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTripadvisor.js', '21.12', 0),
('6b77f7c77f97df45ef0c4837074d45fc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTumblr.js', '21.12', 0),
('637cc65fe3211e4c890a9337bb471db9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTumblrSquare.js', '21.12', 0),
('d61790d21576ccf08fbef1f2f6320ce5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTwitch.js', '21.12', 0),
('ed0a69c205297646f5d6b8a76d6db550', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTwitter.js', '21.12', 0),
('a8871ceb3eb0297e048b09769691f5b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTwitterSquare.js', '21.12', 0),
('0f24a4a5d190df410d36898fb031c2e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTypo3.js', '21.12', 0),
('98ae82a7b3027707d9d537a2b7c8f128', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUber.js', '21.12', 0),
('a055442df972e0321bc3ab87677b4c1f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUbuntu.js', '21.12', 0),
('fe091a58ad1db59f745dfc808710158f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUikit.js', '21.12', 0),
('197b3c17feecde918ebf474e34bcb4d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUmbraco.js', '21.12', 0),
('de06687d854e62440db13d763fbfe41f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUncharted.js', '21.12', 0),
('35037f577936e15fa815099e765d5ee5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUniregistry.js', '21.12', 0),
('085fbb67377d023a866e1bb3165e8a9f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUnity.js', '21.12', 0),
('ea19d092052037b7e1398fc22081c92b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUnsplash.js', '21.12', 0),
('f3df0e183c5e1e4aabba4aeea39e87f6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUntappd.js', '21.12', 0),
('c3b2aaae1c01ac8ac133fd6f6b3b6d39', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUps.js', '21.12', 0),
('199899231b36a766e6e35c7a932bc2d2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUsb.js', '21.12', 0),
('7edaf8c30b7321b6c4cb30f4fc1c6f5d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUsps.js', '21.12', 0),
('84deed27ed51017fe1d9e0931c8d9fed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUssunnah.js', '21.12', 0),
('359b50a8714b058cd98e3ade6668392f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVaadin.js', '21.12', 0),
('861e538c5127b66053fff16ab1c3ee7b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViacoin.js', '21.12', 0),
('f9f81e37dc390648d3144a4af25f1872', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViadeo.js', '21.12', 0),
('baf075d7c2cb650eb1ad896f908d62f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViadeoSquare.js', '21.12', 0),
('60265669816647b370d7afd8a9554661', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViber.js', '21.12', 0),
('289159e6f5bea4a28656a9a3c6194450', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVimeo.js', '21.12', 0),
('3f11fd781336d1d31063df12ce0c318a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVimeoSquare.js', '21.12', 0),
('1181a1b128893cbea4aea5b7fa0f65b2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVimeoV.js', '21.12', 0),
('ccaa65a00e9730bf63019bed2ea93d72', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVine.js', '21.12', 0),
('3e09b7478514647c2d78f83839b2a9b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVk.js', '21.12', 0),
('3981c1e58125c20ac548876c22c6b3cb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVnv.js', '21.12', 0),
('cab9fb9b5b0e9db3c79f894ea39d9cb2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVuejs.js', '21.12', 0),
('80e1a92c11b6065699cd8e0efeb8fd53', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWatchmanMonitoring.js', '21.12', 0),
('3df53f1a08c5b475d7329d6ea0a6bca9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWaze.js', '21.12', 0),
('97e1a57a2c16f5d78d4ccbd1e4ececf6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWeebly.js', '21.12', 0),
('5be4b594bbb26a66eaf1923990939d5d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWeibo.js', '21.12', 0),
('e504cb001537b88dc617e30a7d2c7511', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWeixin.js', '21.12', 0),
('a37e5beeb0a4673b7520e4900cfec873', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWhatsapp.js', '21.12', 0),
('a798b260c5dae4fa92c65208cfb037d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWhatsappSquare.js', '21.12', 0),
('a7b27dc32288511f69bf6917da4ac068', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWhmcs.js', '21.12', 0),
('10d5b59f96b613b3af5b8db020ed661e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWikipediaW.js', '21.12', 0),
('3976380f068cc12d154e6df6a38a4851', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWindows.js', '21.12', 0),
('6438ab925b124f1785d41135ac3b0c46', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWix.js', '21.12', 0),
('3ee9c6c77da5d154744b923b99c79102', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWizardsOfTheCoast.js', '21.12', 0),
('2a2ee39ecc97cf5e19e06b346b1ac02a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWodu.js', '21.12', 0),
('f81415765dd9e25ce2d6cca1c458c13b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWolfPackBattalion.js', '21.12', 0),
('3fd21fbe2b76abfcf51376c92e28e8a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWordpress.js', '21.12', 0),
('9ed9343ee33da37e8f0ef72b412b836e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWordpressSimple.js', '21.12', 0),
('e0e78449d17fd0e6e7f98c84ab409352', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpbeginner.js', '21.12', 0),
('ea7346702eb002cb853947dc86e7bda6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpexplorer.js', '21.12', 0),
('f560f83201180b4a7e95857d385bf444', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpforms.js', '21.12', 0),
('10081c4c4997e3fa850657c7c5a27480', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpressr.js', '21.12', 0),
('5cf2d555a2c4e11f5c0043daaf145a15', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faXbox.js', '21.12', 0),
('fc7752020ce75063b869f2cdaf111901', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faXing.js', '21.12', 0),
('f67e1bb644d9bb10d6c510d1bbb106d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faXingSquare.js', '21.12', 0),
('b09273c829ff5796ad3ad923bbc10b05', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYCombinator.js', '21.12', 0),
('74b49b9f4d45ad86ce8c9754cc6f5484', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYahoo.js', '21.12', 0),
('35a617eafbb257941509e9b746e61ac5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYammer.js', '21.12', 0),
('1a98f74f6f5aa09bbf0c64f2b201e82c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYandex.js', '21.12', 0),
('82caa70365825ab42f8dc11182c51ae9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYandexInternational.js', '21.12', 0),
('165d77ca4652a7db12cc125a50f858a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYarn.js', '21.12', 0),
('b7e32265c2c2bbbf59c70e429f1e80b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYelp.js', '21.12', 0),
('256b2d5be2438f1299446c225d93be88', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYoast.js', '21.12', 0),
('e1747a4c575ff54551c08bea7dcccb12', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYoutube.js', '21.12', 0),
('bbcaa40f041106b343575c0a2465bfe0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYoutubeSquare.js', '21.12', 0),
('d19d48db60f4de6ecb1b13c033e5215e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faZhihu.js', '21.12', 0),
('e497d8434e47cd83dec718167f03fbc3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/index.es.js', '21.12', 0),
('6aa24e31450f4333a26cc2db58778719', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/index.js', '21.12', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/attribution.js', '21.12', 0),
('466c44c1b290935750cd9600a32df38f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faAddressBook.js', '21.12', 0),
('90e108cc7afe97ddee044f5530319179', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faAddressCard.js', '21.12', 0),
('87880a38343ff4b4d9a6dc2f1cb79d83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faAngry.js', '21.12', 0),
('8e2c836eebce13e42fe845e7be5c719b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleDown.js', '21.12', 0),
('453cebfad8491278c105e12600e9ef22', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleLeft.js', '21.12', 0),
('eb05306a42564d4d20edd8a71ef74d41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleRight.js', '21.12', 0),
('1c05febf33595d4c195251e3bfddbe08', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleUp.js', '21.12', 0),
('32bca4be5113caa1752e76022034025a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBell.js', '21.12', 0),
('f75c38f2dbdf9cd27c5da3c1e3cea6f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBellSlash.js', '21.12', 0),
('c447c141d00c2b083c10154452962a42', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBookmark.js', '21.12', 0),
('c6485f53c4bd6a6f2ddee016984a91c0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBuilding.js', '21.12', 0),
('52ba6dd0ea270d13412c112be77f4105', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendar.js', '21.12', 0),
('60775fa99f7908a3e5799757a4fd6c45', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarAlt.js', '21.12', 0),
('671e042b8772a009b1659086355ff2cb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarCheck.js', '21.12', 0),
('7747e80faee31b35b4447aab8e235dc5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarMinus.js', '21.12', 0),
('5faa91db9e2bb6f39a4667ca562f0c44', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarPlus.js', '21.12', 0),
('98519d99b8f60eae76c741a4502810bd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarTimes.js', '21.12', 0),
('2de5b81176c926eefbf5348ac946ce65', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareDown.js', '21.12', 0),
('8f01ef89435a1e47c7c074b60529fe2a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareLeft.js', '21.12', 0),
('9da9b37df339387d45db63034fd05640', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareRight.js', '21.12', 0),
('8ab07ff59713b02c5d8a03b33fbf27ed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareUp.js', '21.12', 0),
('52df47d2cf6d018143bf023470585a60', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faChartBar.js', '21.12', 0),
('19a2f1efd99e4919b3a61dec1e0c7c00', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCheckCircle.js', '21.12', 0),
('c967e452ec187c8ad99493c473d1657b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCheckSquare.js', '21.12', 0),
('7d50cd8773a37dedef6c6ea5c87d77da', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCircle.js', '21.12', 0),
('19aec6bc0067a36e814f8fdb337f60e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClipboard.js', '21.12', 0),
('b019f90d416e5602fd78b1992ce99357', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClock.js', '21.12', 0),
('a7bb0fb9da17aa21c74dbe8dff756011', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClone.js', '21.12', 0),
('d1d5d5c0c645caf94ccd0fd6fa696349', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClosedCaptioning.js', '21.12', 0),
('c4a48031d059b4c876aca73239f930bd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faComment.js', '21.12', 0),
('137e19af5bdd6316ee96dfc46a014160', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCommentAlt.js', '21.12', 0),
('0040d1a4cdbb7a58bcbc26b79a22a77e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCommentDots.js', '21.12', 0),
('711b3535b4e042558f63b76f3378eedc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faComments.js', '21.12', 0),
('ba25485efba6dbf1e7dbb82e49af11b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCompass.js', '21.12', 0),
('ee21fbc099f0056b5ef06cd1ee47a972', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCopy.js', '21.12', 0),
('88b068598bd4552a969606652e8ddb61', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCopyright.js', '21.12', 0),
('132883920bab6d50540e0e5b266feecd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCreditCard.js', '21.12', 0),
('36aa0f31ce7fe4013fe16c2adfad2c62', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faDizzy.js', '21.12', 0),
('9da37766ea6c9480da9640ce3764957f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faDotCircle.js', '21.12', 0),
('b7798ccd42434f0cdc18db195a496084', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEdit.js', '21.12', 0),
('6f6220a9e6693b2204e449579d696ef4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEnvelope.js', '21.12', 0),
('1e98522be1d2b239cf0b62499d02aea6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEnvelopeOpen.js', '21.12', 0),
('f6e833986233de85acc9612f6bcf8086', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEye.js', '21.12', 0),
('06670399056f5eae0851ed3155055685', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEyeSlash.js', '21.12', 0),
('b740bb0a4b7b1f6c9fd56456ed531d8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFile.js', '21.12', 0),
('1c7f05624c02cbeca30bd0398f1c77d2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileAlt.js', '21.12', 0),
('3811c8b8f6437b3b74d2944011568abf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileArchive.js', '21.12', 0),
('f71d3160f7fbdfd1685b399b394d982d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileAudio.js', '21.12', 0),
('c5397e99de1fd59471b1b1c1c968b9f6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileCode.js', '21.12', 0),
('53c90de4bdc40250e55081d66a318c02', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileExcel.js', '21.12', 0),
('019b6f41570607eb700df03b001701ba', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileImage.js', '21.12', 0),
('378a1e43cd5757c242f8692504d03975', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFilePdf.js', '21.12', 0),
('edbb10de8771c256e1aa6e4f6b5f9986', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFilePowerpoint.js', '21.12', 0),
('4ea2b0a681edf5424e342d03e58b67a8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileVideo.js', '21.12', 0),
('fb08043230d536d6b698d3690210dc84', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileWord.js', '21.12', 0),
('ad1ced2c65ff5f5e9802c6a81476efe8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFlag.js', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('b42bdce5021c00a6b5880f724bfd224f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFlushed.js', '21.12', 0),
('c05f5cd7a69896a6acb6dccc8fe0101f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFolder.js', '21.12', 0),
('cd3044d9facb321fce3290669eee2e76', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFolderOpen.js', '21.12', 0),
('331b28ee0030939f33584a78bffd7ea0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFontAwesomeLogoFull.js', '21.12', 0),
('a6af14b86e2f8577cc5cec6343ce8e8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFrown.js', '21.12', 0),
('adfb52dd0227cf64136aae70ccf4e34f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFrownOpen.js', '21.12', 0),
('407f05e0e32a5c5211a81152fb5b9136', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFutbol.js', '21.12', 0),
('a83c8eb3592079e0b923a560d6e08113', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGem.js', '21.12', 0),
('bc1349edfc688d8770540516966c206e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrimace.js', '21.12', 0),
('bfb7dac612067790b1e0af085de50cf7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrin.js', '21.12', 0),
('f6a070f3bb0fad875b7e8a52036849d6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinAlt.js', '21.12', 0),
('080fb6f624f4fac5bd3cafa93768d104', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinBeam.js', '21.12', 0),
('9ce13954cdf93b44aef9e703fc90f1b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinBeamSweat.js', '21.12', 0),
('6f682f62943803fb11b958e573c618f8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinHearts.js', '21.12', 0),
('2c3f00884af30580e77a21bc38140eac', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinSquint.js', '21.12', 0),
('adbc11c46bd2c35e26dad1aa0a8a1300', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinSquintTears.js', '21.12', 0),
('54fb912d7b9eae623f4438fed7b5ff70', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinStars.js', '21.12', 0),
('cdc204e8af1ae4581a0c5e11c5705b5f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinTears.js', '21.12', 0),
('8b6cfa235a80a7eb7c140f1811700b9e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinTongue.js', '21.12', 0),
('32ead6d04b8b446a5e9e7292f8e3e53a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinTongueSquint.js', '21.12', 0),
('5cf07a654a92f394a7712b1ce8952635', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinTongueWink.js', '21.12', 0),
('77c7984587fea30640ef2008dedf04f1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinWink.js', '21.12', 0),
('7441a07ae3edfc5578e480890f23b4fe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandLizard.js', '21.12', 0),
('ee18afab331439b0d1e5cdefdbff7dd7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPaper.js', '21.12', 0),
('0f7aab19233d6ebef71aa4ab23c7075c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPeace.js', '21.12', 0),
('1c797f6df88979a6b618875fbc6ff0f3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPointDown.js', '21.12', 0),
('4b9ca0fe99fd9ba05bdba942575c00c1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPointLeft.js', '21.12', 0),
('b2a2cbd54524b1bb3866f13aef19440c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPointRight.js', '21.12', 0),
('c31edeffe0cab688502993321c1d17b9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPointUp.js', '21.12', 0),
('784a8f16724d036a3c6d8b897c718128', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandPointer.js', '21.12', 0),
('0440dee9846b4ac9158b5d6a34d7f491', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandRock.js', '21.12', 0),
('b53ad90d75832607eaa4c40ff8e5bf9b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandScissors.js', '21.12', 0),
('b30095fc1419e23a5408279acd173ffa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandSpock.js', '21.12', 0),
('3fbd2392c1d4aff588f43522ee079c99', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHandshake.js', '21.12', 0),
('f328c1095104b6c706f8e83e1f477d4a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHdd.js', '21.12', 0),
('db1e7ae717191f61a5adbfd758ef3b32', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHeart.js', '21.12', 0),
('6e2357241eeb38bda52b86a32613ba8a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHospital.js', '21.12', 0),
('29a0684143693f7af96cad2320b07965', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faHourglass.js', '21.12', 0),
('ce020f33c5c30bbfc71936049b7ddfaf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faIdBadge.js', '21.12', 0),
('598c4872c427a5a901885f57d7dd3117', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faIdCard.js', '21.12', 0),
('1656b5c525e873f1280f06d84e5652f2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faImage.js', '21.12', 0),
('20dde4468dd321986bf8f8cbb80dbf33', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faImages.js', '21.12', 0),
('681eb05f85fa6ffdaf20c6e9c258113b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faKeyboard.js', '21.12', 0),
('22bece60b461af7414115f37c09529f2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faKiss.js', '21.12', 0),
('71a4037ebe714a3807429307f4d863b9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faKissBeam.js', '21.12', 0),
('43f904c97d23f14c75899fd1a086c436', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faKissWinkHeart.js', '21.12', 0),
('684c0bce7ddc366363327e7ffabe9012', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLaugh.js', '21.12', 0),
('3bcbaa89694a71a58e462b6eb83c087c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLaughBeam.js', '21.12', 0),
('a4c0713fceeefbde2d15b359afabbcb2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLaughSquint.js', '21.12', 0),
('6d1f34263bd5229aa605c790138ac867', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLaughWink.js', '21.12', 0),
('2a2091a19f14c276e41b645845a81cff', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLemon.js', '21.12', 0),
('edc90dacf8711a1aa3769974d84e48d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLifeRing.js', '21.12', 0),
('0456928460ac31c9f1c596ada1b9c85b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faLightbulb.js', '21.12', 0),
('852f672e423c9161e4ef956d04936c15', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faListAlt.js', '21.12', 0),
('886995998dc6dfb84211b12528297f5c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMap.js', '21.12', 0),
('c2484100a5b5cab4b86c746ab5c511b0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMeh.js', '21.12', 0),
('f0c2b166b8dc505423ff8cc8282e2844', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMehBlank.js', '21.12', 0),
('e10b86f24cfd388added7ade44c2bf88', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMehRollingEyes.js', '21.12', 0),
('725ecd659616b3d1ac339b5918e65f26', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMinusSquare.js', '21.12', 0),
('c553889636338cf824550ce80ac09137', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMoneyBillAlt.js', '21.12', 0),
('695558707fa70cd31551b72b780488d4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faMoon.js', '21.12', 0),
('263829623dc3465dbe37004499d258c7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faNewspaper.js', '21.12', 0),
('912b72aa93191ff67d20f4ebbca3f12d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faObjectGroup.js', '21.12', 0),
('7d888261aa8c5c5e9189158c55f99cbc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faObjectUngroup.js', '21.12', 0),
('73557d98bb2cbf6e9d251b118bc8aa39', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faPaperPlane.js', '21.12', 0),
('69cdbbfa3c9b5cb098668a46b88c2172', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faPauseCircle.js', '21.12', 0),
('25da1a2bbe02b16400b8227b2074ad13', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faPlayCircle.js', '21.12', 0),
('feecbd21621f826ec96285e3222a8190', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faPlusSquare.js', '21.12', 0),
('c5b96903dccee592b358cf5b1a4d54a4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faQuestionCircle.js', '21.12', 0),
('d06751037fe0aab6a6aab7bceac0f902', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faRegistered.js', '21.12', 0),
('1550307b7ab58cac1f338a700f5439d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSadCry.js', '21.12', 0),
('417fbdd59358b8104d905d6b52212bdc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSadTear.js', '21.12', 0),
('a57e813f4e27012996f3c27ff58be2fb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSave.js', '21.12', 0),
('c4ae31fc52dd98490e2c4ec17d474f41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faShareSquare.js', '21.12', 0),
('3976298d8f6502973cd99e233dfcae07', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSmile.js', '21.12', 0),
('5363fe5ade8ff7e9db93e32489c72d45', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSmileBeam.js', '21.12', 0),
('cbba546206995918545adbecdfa79af6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSmileWink.js', '21.12', 0),
('7141c74497196f5fa09182faa116fb7d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSnowflake.js', '21.12', 0),
('9285fc07a990cdcb6ee84728be499dba', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSquare.js', '21.12', 0),
('78967ef31394c8bd933bf4253bd92960', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faStar.js', '21.12', 0),
('2933f96be58d0e3af6d36637cf1a3b72', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faStarHalf.js', '21.12', 0),
('ee631d0bec475d47c7401a6ec916e096', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faStickyNote.js', '21.12', 0),
('36a9b8fea55fb1ef27bf8bb1a303bd63', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faStopCircle.js', '21.12', 0),
('f502452c75c1b2fc785dfbec0f4896e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSun.js', '21.12', 0),
('b174823d0df7d4dc0c0f941ac479069e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faSurprise.js', '21.12', 0),
('45321523ca673f3e1e70b32c35e71159', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faThumbsDown.js', '21.12', 0),
('43228d5e7bf513c7ee23accc2f87cc06', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faThumbsUp.js', '21.12', 0),
('703aa180b78132af5a5e5ed6a902c80a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faTimesCircle.js', '21.12', 0),
('c9fe4011bb4c0e99f080eedfcb1c6992', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faTired.js', '21.12', 0),
('ed1c3f6d81ff9d08093e99770c78edbd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faTrashAlt.js', '21.12', 0),
('c55b6bc9d4ec5b295e11be2d6e1e20ae', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faUser.js', '21.12', 0),
('874040583bf9b5b1f2455d5c7402e8ce', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faUserCircle.js', '21.12', 0),
('c43c478be51dcf2d0c069bdcd6a6e6c8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faWindowClose.js', '21.12', 0),
('7e0ee234a25b3e801b4ae65472a8f5d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faWindowMaximize.js', '21.12', 0),
('67d3282f9f9afb90ad0fef515ac05bc1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faWindowMinimize.js', '21.12', 0),
('2d4eed042e89ab3226ae0b416f3c4f1b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faWindowRestore.js', '21.12', 0),
('43d41a0a632943eb97fcfade6420775b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/index.es.js', '21.12', 0),
('796b5d97437aadf26b64092bfbad37e5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/index.js', '21.12', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/attribution.js', '21.12', 0),
('34b2ee5f6124e1eded7c176c523e8958', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAd.js', '21.12', 0),
('b42c769a86364b7a3c038ad68a321ae7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAddressBook.js', '21.12', 0),
('99495e94f2b4ad493dc596a975b38495', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAddressCard.js', '21.12', 0),
('198ef7333690c7d2be2eb78425a26035', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAdjust.js', '21.12', 0),
('d6999873bf76653ac6fc6bcd8860b807', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAirFreshener.js', '21.12', 0),
('5c401965dbd494bf50caef56d7e8b3ac', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAlignCenter.js', '21.12', 0),
('ca4328fdb362dd78b499a18d24c0186d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAlignJustify.js', '21.12', 0),
('4a5deca35be12a44736bdd35ba42fb5b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAlignLeft.js', '21.12', 0),
('c3e11a84fd0f8f3e1f26eb8b9a7eb05c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAlignRight.js', '21.12', 0),
('ef72f9d67d099bac5d4d5ff788420b70', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAllergies.js', '21.12', 0),
('ef185ebdde9e715d9222dd54dfd57669', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAmbulance.js', '21.12', 0),
('b8a7c63103fa26fa85c9d5566cf006ab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAmericanSignLanguageInterpreting.js', '21.12', 0),
('24989fcce6ad68063d97df913a2f6f47', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAnchor.js', '21.12', 0),
('0dcf55de847b14885da47bd33b50dc82', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleDoubleDown.js', '21.12', 0),
('4c4a654466c772ad84b9b9020f004a61', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleDoubleLeft.js', '21.12', 0),
('fa15228a397edb7dccba626122f01a01', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleDoubleRight.js', '21.12', 0),
('056a81b807799de588442babb5a605a4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleDoubleUp.js', '21.12', 0),
('ba50912229d1982ce699e99c65d77c9b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleDown.js', '21.12', 0),
('f8e3df8d3be0f1462894e9505918c327', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleLeft.js', '21.12', 0),
('88b03ea995f1ce737e66d8e1cce7a91f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleRight.js', '21.12', 0),
('625c83e62bfd425aa31082515216014d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngleUp.js', '21.12', 0),
('3dadf83021a802d9e5d0381b8c417ce2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAngry.js', '21.12', 0),
('61e248b96cdc08bc0452d9050aab5766', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAnkh.js', '21.12', 0),
('6c16c4ef42d23472c1ffbf3cb6d5f8f1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAppleAlt.js', '21.12', 0),
('3ea3366bf3ee93dadf73f593bae306a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArchive.js', '21.12', 0),
('44373217c77e2b0bb521b2cc0c84a2d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArchway.js', '21.12', 0),
('b0bb1e59d4f86cfcbc40546fb5f51338', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowAltCircleDown.js', '21.12', 0),
('1d2b78b2a60374df20649c7e8d59dd42', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowAltCircleLeft.js', '21.12', 0),
('71ab98da1e0645ed88aed7191520b085', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowAltCircleRight.js', '21.12', 0),
('f16d96649a8e50f32642eff4dc267112', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowAltCircleUp.js', '21.12', 0),
('a7145d0f6ef12f16edfd9d3252dac9e3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowCircleDown.js', '21.12', 0),
('85691508f00690bfaf8e8b4bc47442ea', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowCircleLeft.js', '21.12', 0),
('c980fe51401323d1ee0d3499b2694dbe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowCircleRight.js', '21.12', 0),
('38c7d7556a296dd6fcac5936d138c0fc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowCircleUp.js', '21.12', 0),
('5455f5a5f909bb3344d9cdcf0ca80050', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowDown.js', '21.12', 0),
('592cadcb1411886ee05b9b46a28e63ca', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowLeft.js', '21.12', 0),
('db746b14a7b670b95da305f7d3735318', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowRight.js', '21.12', 0),
('6b6a311a3444fa14f5760fd070ae7749', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowUp.js', '21.12', 0),
('09c24fc8f4dd43f7ecf995d52c74a8c7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowsAlt.js', '21.12', 0),
('376eb0632f4429804ca23a97df26a69a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowsAltH.js', '21.12', 0),
('ad92f1b6898a0c467e0f7d08b4a38a39', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faArrowsAltV.js', '21.12', 0),
('c5559744728465c680b36a5583e10990', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAssistiveListeningSystems.js', '21.12', 0),
('8b6e716f2b6dd982060c2ba5bd1756d3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAsterisk.js', '21.12', 0),
('4ec0aa4b8c2500ccb0e66176c221cf9e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAt.js', '21.12', 0),
('cc14a191fd62bd953549f1b8bcc960d6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAtlas.js', '21.12', 0),
('a13db30912b34c007993b54ad2c89aae', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAtom.js', '21.12', 0),
('163a7d6aee1f09b1773278942f26e2c9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAudioDescription.js', '21.12', 0),
('616d8ca9a19edfe47cf4487441e7f571', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faAward.js', '21.12', 0),
('1692f6ef9adac5f5ee5d3db26aeba8f9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBaby.js', '21.12', 0),
('f89b30c58d34c7f704d6e4aa9a2e6be6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBabyCarriage.js', '21.12', 0),
('cfdee5bfd7deb86b62edab1d0c9c2912', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBackspace.js', '21.12', 0),
('c3c60575cef93a9e16472204abcd8fbe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBackward.js', '21.12', 0),
('27e47ea17c3da862df4170ea844f83cc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBacon.js', '21.12', 0),
('a6d171a42d8d90934ad85a384113d5a6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBacteria.js', '21.12', 0),
('e76ca8e279440bd86321735229b08432', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBacterium.js', '21.12', 0),
('0dc129b176900aa751ab3a933a0cf4cf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBahai.js', '21.12', 0),
('b358a1020fdd03a89beeb93a227d3ec4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBalanceScale.js', '21.12', 0),
('eb1463a7c9592a75dd61d39d6495acda', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBalanceScaleLeft.js', '21.12', 0),
('dc515b65fb5af11a0c81804dbcabed8f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBalanceScaleRight.js', '21.12', 0),
('6f0d0616c6f63ab01bbf125482e9bcc5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBan.js', '21.12', 0),
('10e6fb23efc260592a8542241f1b3722', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBandAid.js', '21.12', 0),
('2accdf92f3f25be2de453e5cf8740d8e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBarcode.js', '21.12', 0),
('6d80e7da9bfd22cc281916dad48f6d62', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBars.js', '21.12', 0),
('43586e464daa0e4ee1a47fd62825c816', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBaseballBall.js', '21.12', 0),
('7071bc6b54162dc0a96ba41d105f813f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBasketballBall.js', '21.12', 0),
('81d8b2cd3b7c8787633dfbbdd7801374', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBath.js', '21.12', 0),
('89a7ce8fc27cb154bed846acc4e83106', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBatteryEmpty.js', '21.12', 0),
('57d4b226ad2ab5946cd0f02394722746', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBatteryFull.js', '21.12', 0),
('a28170daca2702938d1fd061ce3fa881', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBatteryHalf.js', '21.12', 0),
('383df41f1d90d1c6680f4c17a95d0b1b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBatteryQuarter.js', '21.12', 0),
('caa1c64d72c9c9dd3430ef6adffbf184', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBatteryThreeQuarters.js', '21.12', 0),
('929ea72153a760a1d5f4ccf0bd5fa450', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBed.js', '21.12', 0),
('15ae82c51c843c64426215a24aef47cf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBeer.js', '21.12', 0),
('cc94b5a5528d7c1b82c557a3ab87b013', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBell.js', '21.12', 0),
('057cc50810b0b16f27c5d9e0cf6cfbe1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBellSlash.js', '21.12', 0),
('5e9703e2e1000d4d1c54e8b24e6af9bc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBezierCurve.js', '21.12', 0),
('bc5d03c954f8b27f7fb8145cf97fe7c1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBible.js', '21.12', 0),
('43ee06eed56d524348e89d14c8242b53', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBicycle.js', '21.12', 0),
('73779fb3687b2f2da86c188de051fc60', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBiking.js', '21.12', 0),
('72bc92e1b86222fb98b86bc8d9dd3280', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBinoculars.js', '21.12', 0),
('2ab37d3e88d6c09fa5f2c853fc4a6fb5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBiohazard.js', '21.12', 0),
('a7cd9cb978099e8afce5e386ca470dfe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBirthdayCake.js', '21.12', 0),
('4dabca2b995454049aa74aeff36aecbf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBlender.js', '21.12', 0),
('44c7fd76a8c89c8aefa855ae68e9b49f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBlenderPhone.js', '21.12', 0),
('2798b5b4e2ef6cf476de2073dd2475f1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBlind.js', '21.12', 0),
('53b61e2b2ba0bcafb3f2714914fbb2ac', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBlog.js', '21.12', 0),
('55f8b2a1cf4836eb58f2c18eeea57144', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBold.js', '21.12', 0),
('44ad6f3d539f208b26a11a8f1bd490da', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBolt.js', '21.12', 0),
('f0ea041c8a6aaa5af0c7a95df804daf7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBomb.js', '21.12', 0),
('3da36f90a4ce4a75eb8fc4ec6d59d388', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBone.js', '21.12', 0),
('73109a6684e52649fe71d939b24a2ebb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBong.js', '21.12', 0),
('019a8678767c200754c1f0c86f75be41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBook.js', '21.12', 0),
('ab4698c07e0f03295aa9fd2251776a79', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBookDead.js', '21.12', 0),
('41a6eddcf6b6dfca67fa67e7c17abb8a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBookMedical.js', '21.12', 0),
('b4923d0c360f5cca6568abdaa6b7d4f3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBookOpen.js', '21.12', 0),
('8376f03572cf947e696f94690c2c363b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBookReader.js', '21.12', 0),
('a76d6fa7707e2e48a6def48d5d49125d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBookmark.js', '21.12', 0),
('13ab5fd4f075238f986636c6dbbbcf0c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBorderAll.js', '21.12', 0),
('3add9bc37c1dda378b3bdf20cc51f7ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBorderNone.js', '21.12', 0),
('89ad1ec27d0cf96db507d340a8cf1a1e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBorderStyle.js', '21.12', 0),
('767e47d02f2ba552deba4b1215ce0cec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBowlingBall.js', '21.12', 0),
('150c1423a67bf90d1808b99c13c75783', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBox.js', '21.12', 0),
('e1e1262f7434789b33ee7cb018310e4b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBoxOpen.js', '21.12', 0),
('49bf6a5c45d3e2957b3216ea4a6eb988', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBoxTissue.js', '21.12', 0),
('ca58eec1da702b0ded6d372174578b84', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBoxes.js', '21.12', 0),
('93fc250a4425f6339b6ce5ab7a4c7954', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBraille.js', '21.12', 0),
('eaa41f04522a7cbd331604ef52cbc6f7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBrain.js', '21.12', 0),
('79926f1e906ab71c7ac538e1afd147c1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBreadSlice.js', '21.12', 0),
('bddf2b9df3177799b58fead80ffd480c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBriefcase.js', '21.12', 0),
('a055b1c7a7c360ff8b98c051fa8ad12d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBriefcaseMedical.js', '21.12', 0),
('d3ab606e4ef6c90ce4e9624395ae7737', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBroadcastTower.js', '21.12', 0),
('9a5fe304df8ee9cd6f657ab58f2d4e25', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBroom.js', '21.12', 0),
('2a397edadd2ebc149fd300af6541aae4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBrush.js', '21.12', 0),
('96de4193303a5f34b0537566d987d0ce', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBug.js', '21.12', 0),
('a720f6d994069a796253776afe0b2dd0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBuilding.js', '21.12', 0),
('6b31b39d64dc502640f88dc5cedcd1ff', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBullhorn.js', '21.12', 0),
('5a33eb09bf8ebcad3ad3bd7fa35a4b7f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBullseye.js', '21.12', 0),
('bc5f1008056ab949f9293df8933e76b4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBurn.js', '21.12', 0),
('e0fce7a1f140d8f756affedd0b315978', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBus.js', '21.12', 0),
('b38c019ae0bda36a5c2568c44e37076e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBusAlt.js', '21.12', 0),
('471a720c64123d9509ef14ed55371712', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faBusinessTime.js', '21.12', 0),
('1efe13ad054911d0f4b0bc9cff1e7735', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalculator.js', '21.12', 0),
('f2d743b4d54a1c9f50763a957af83e1e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendar.js', '21.12', 0),
('68084f964f78f5723d03198c1164b6bb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarAlt.js', '21.12', 0),
('8de0ef8b361946c3cbc1c8b9f40a517b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarCheck.js', '21.12', 0),
('98eeb9894846d5b5bcc80e2fdd35cf8a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarDay.js', '21.12', 0),
('a193a51c08660cd1a26fe489abfacf0a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarMinus.js', '21.12', 0),
('d4d4f73747b246a2cedbb456ebb3e8e5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarPlus.js', '21.12', 0),
('2d33a8be765e7c5242045c68ab8b2135', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarTimes.js', '21.12', 0),
('a4df117240adf0eb6bb9c3e2a320fbfe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCalendarWeek.js', '21.12', 0),
('588ec9b5007ffa2392d8b695a8b63c4a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCamera.js', '21.12', 0),
('2eae4223668745199b430156a499f829', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCameraRetro.js', '21.12', 0),
('0b5e95dcdae12e1e3869b870cd900fb2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCampground.js', '21.12', 0),
('d60a748409ddcbc4166b0863f32677d1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCandyCane.js', '21.12', 0),
('0485f6f134a7acae67616feb73314d3e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCannabis.js', '21.12', 0),
('5b961637c89f34ad7c0810620a2452bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCapsules.js', '21.12', 0),
('ca5c6b7369c1811e23b514a923936d15', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCar.js', '21.12', 0),
('1c39a97295b23188b885b97887f94495', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCarAlt.js', '21.12', 0),
('7e06df42ff0aab07c9027f477f60868c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCarBattery.js', '21.12', 0),
('16c536628e32b862d0609c6b29609ca1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCarCrash.js', '21.12', 0),
('6264e4b341a7035a6fc450fb7b105553', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCarSide.js', '21.12', 0),
('ba8dfe19be761fd3d8d1776eba331f41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaravan.js', '21.12', 0),
('b714910d0b15f9d11aaeec17257a03a6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretDown.js', '21.12', 0),
('c023c6bbbdc303185c4b71d864ed99e6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretLeft.js', '21.12', 0),
('bd0ce686b48a847e724f1a5755962994', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretRight.js', '21.12', 0),
('1ba3f2bb020ad6abcc849dff76c80b49', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretSquareDown.js', '21.12', 0),
('7f1fb6f790d491bcb97be0ec7802f6af', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretSquareLeft.js', '21.12', 0),
('1c1b738de60ee82a635457d143a8ba61', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretSquareRight.js', '21.12', 0),
('682f4c89e046fdb2f9816686181c198a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretSquareUp.js', '21.12', 0),
('6f0d48eee03b8c62f7b2893f9cc6bc5b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCaretUp.js', '21.12', 0),
('bf13843cbf46d3b1c69284a6266f3d52', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCarrot.js', '21.12', 0),
('1b243c42d533fbac3c1cee2a3080be11', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCartArrowDown.js', '21.12', 0),
('7f9fbb2200ec219c2bb23e242cadb41f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCartPlus.js', '21.12', 0),
('53c3ac06d7f4326926655470f3e6446e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCashRegister.js', '21.12', 0),
('7d37c57c671f69136d1336a48ea48800', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCat.js', '21.12', 0),
('4cf198865382db886780cf2b01cf2966', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCertificate.js', '21.12', 0),
('c7f84a8ee809a924855c6a2bf8bd958b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChair.js', '21.12', 0),
('5e86d56396539b338849f847c7152524', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChalkboard.js', '21.12', 0),
('f0a1281ade38698ccbfb56f991b92464', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChalkboardTeacher.js', '21.12', 0),
('5e135091da7647dd59b6d244e61f27fa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChargingStation.js', '21.12', 0),
('76af1a65f021a134174241169d7723ce', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChartArea.js', '21.12', 0),
('4d04ce399456fce7965692798bd795e8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChartBar.js', '21.12', 0),
('fa637128541893618819465222db33c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChartLine.js', '21.12', 0),
('95e98510fb54c068c74766b16fb809fb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChartPie.js', '21.12', 0),
('627bfdb2a33919d9eda2b86e4ed47feb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCheck.js', '21.12', 0),
('8b7d4f84a8437b3f6758affdff55aef4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCheckCircle.js', '21.12', 0),
('bdf1f24bc05aba450ffb191ee88180ea', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCheckDouble.js', '21.12', 0),
('c0827bf55dda1cbefa4f54bcf0b34065', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCheckSquare.js', '21.12', 0),
('f346616f9c76b4bd2a871bd7f06cb473', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCheese.js', '21.12', 0),
('b8668a9af3ca8f8af2afc4af90cff70c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChess.js', '21.12', 0),
('3c8039997e88154fe1915548c178c9e1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessBishop.js', '21.12', 0),
('c3b1daa0c3348979a44c19ee7f8374fa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessBoard.js', '21.12', 0),
('067b1338903a85bc4d7fe93b90c9b628', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessKing.js', '21.12', 0),
('7b245f72fd3c7e04aff3fde3176729c8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessKnight.js', '21.12', 0),
('9abd7771714753d46ff8a214e6b2a295', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessPawn.js', '21.12', 0),
('08812aec8b9b0a50804e420963ea5abe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessQueen.js', '21.12', 0),
('666924ccc0cb156c04a7a731429229b3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChessRook.js', '21.12', 0),
('a1dec396e8cb2f14d3c4596954a4bcb0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronCircleDown.js', '21.12', 0),
('c6e1020600242063f5abe3bb7284025e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronCircleLeft.js', '21.12', 0),
('172af443e3edd20d53f2af5ed860629b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronCircleRight.js', '21.12', 0),
('d98598c410e1d5c9af92f8e5525e0cdf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronCircleUp.js', '21.12', 0),
('0d7c58261765418aa5c0cec8c937cb33', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronDown.js', '21.12', 0),
('2de379be1c694c306e91741139f22f66', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronLeft.js', '21.12', 0),
('c1181b808be72a0c5e6058ed402207f1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronRight.js', '21.12', 0),
('69c08516a8932faec12260625d665a0d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChevronUp.js', '21.12', 0),
('c369205b44e155747e495622bc2ce3d5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChild.js', '21.12', 0),
('bfd1138332ff901a5732f5d62b3c8e7a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faChurch.js', '21.12', 0),
('828c401b10b9415870a64437f1483cf3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCircle.js', '21.12', 0),
('85cef61532dc08c1eb90b93f891cc723', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCircleNotch.js', '21.12', 0),
('5e8f9b44991a70c8735d7c105f45784a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCity.js', '21.12', 0),
('2d4dd267b5faa13e15e0ef6cf9650d84', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClinicMedical.js', '21.12', 0),
('10b9db7ac22940c68a97fab2cd8b400f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClipboard.js', '21.12', 0),
('b0c646bfac7c24779bb42f3f622ac261', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClipboardCheck.js', '21.12', 0),
('da6e17ced7378d304b399eff53038e92', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClipboardList.js', '21.12', 0),
('b9b8d262eb6c0b2d6fbcb67fdad44bf8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClock.js', '21.12', 0),
('bba3c6196a1a1f31a82b473a9a20715c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClone.js', '21.12', 0),
('f7c642f1d436f06f80eef5bfe48f4304', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faClosedCaptioning.js', '21.12', 0),
('f0a4ec03c17becd3a0f7a4d2fb752721', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloud.js', '21.12', 0),
('eef0ac67f705b8bb972e7ea05a5f34f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudDownloadAlt.js', '21.12', 0),
('04a9ca1a261d7bd9080634a8d4e98897', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudMeatball.js', '21.12', 0),
('da2a46c14f238e6a4d679918ad2d23c7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudMoon.js', '21.12', 0),
('d2b37a7e26caef7a112e8c3d94d9170f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudMoonRain.js', '21.12', 0),
('86efae9c4905c6df015f55615b530af0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudRain.js', '21.12', 0),
('04ba1a8fe94dee2a9479a407d05c77a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudShowersHeavy.js', '21.12', 0),
('b7168d3cd865fb2ccd13893bf3d5fe83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudSun.js', '21.12', 0),
('abc4f49fef3e19b742527d3587462643', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudSunRain.js', '21.12', 0),
('efe955801084a5c876bb2505d0114b8a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCloudUploadAlt.js', '21.12', 0),
('595a255c27a7a9825230175b309e6b53', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCocktail.js', '21.12', 0),
('92779f02b02c0fe85d11c4d26bb0790d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCode.js', '21.12', 0),
('b137cf9fd20d30194106e2c276ae803f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCodeBranch.js', '21.12', 0),
('ddb1c1d9d081d8e4ddc74ae1f14967bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCoffee.js', '21.12', 0);
INSERT INTO `tiki_secdb` VALUES
('2d3ad0090acdec067eba7792d18ba5c1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCog.js', '21.12', 0),
('b055a11102ab0c0aada195fc2de09eda', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCogs.js', '21.12', 0),
('7b6490faeeec128632250e37ed11aed1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCoins.js', '21.12', 0),
('5a35453524b451f45dac4c45efdcb4fa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faColumns.js', '21.12', 0),
('cf59cb5310002d8e201f9163807993b4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faComment.js', '21.12', 0),
('ef2765c88d9fb01dcbe73022334a0cff', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCommentAlt.js', '21.12', 0),
('50fc6323dd14be42bdb823094e204eeb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCommentDollar.js', '21.12', 0),
('bb44aa34b346ecf112c0c7df7d30062b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCommentDots.js', '21.12', 0),
('91ebd8ee60bf141f1673614b61a5c6d5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCommentMedical.js', '21.12', 0),
('636b64706b1f59c348a8261d203d90c0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCommentSlash.js', '21.12', 0),
('5aad62062569c915e631e346dbbb688b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faComments.js', '21.12', 0),
('8d9bb59aca85f60f625bc9c12721e274', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCommentsDollar.js', '21.12', 0),
('a9f0343ff2e56f770b28797eae82357f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCompactDisc.js', '21.12', 0),
('c669ede156205b755c9dbb972ca3e463', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCompass.js', '21.12', 0),
('1e5bd76ce81608fae5bd69ac966af2e2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCompress.js', '21.12', 0),
('c4879c957ee7668531b695c3496f0fa6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCompressAlt.js', '21.12', 0),
('573fab1000fa933381d057adf9e9a265', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCompressArrowsAlt.js', '21.12', 0),
('68181f623bed31c0c4d41326cba1711c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faConciergeBell.js', '21.12', 0),
('2a1f94834cbf5e3d7b27944e39bdaebb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCookie.js', '21.12', 0),
('5baf75f82155b91fe0ee54906d07b3e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCookieBite.js', '21.12', 0),
('a406f72ede34a42f4d16700eb1ae49d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCopy.js', '21.12', 0),
('d0f043fca2e775fd178fe34df228d060', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCopyright.js', '21.12', 0),
('f108eab56dade3b0e67e206d448576e3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCouch.js', '21.12', 0),
('9a76d1718d0dbb7e1bfbaae078c522ca', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCreditCard.js', '21.12', 0),
('3b198b2d65b94d3f60b310857f568bed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCrop.js', '21.12', 0),
('d6e5e35f21bc1a13459b932aec70641d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCropAlt.js', '21.12', 0),
('95a0aabab2753036c3a4fd88929f4fa6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCross.js', '21.12', 0),
('f3b3845fa2592fef1fc97b2bf92db051', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCrosshairs.js', '21.12', 0),
('204b9b01a3d0024bda865aad19b619ce', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCrow.js', '21.12', 0),
('ac1c6e17711422fb07a37b2f9f62e5f1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCrown.js', '21.12', 0),
('dac4d07909520acd89fbf2a25066aae0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCrutch.js', '21.12', 0),
('f697d268f2559feda1baae16f9f9fc67', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCube.js', '21.12', 0),
('1f2af9d80b54286fd3a512d5e71c8651', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCubes.js', '21.12', 0),
('77c243e364b020c20ae184c57743f0e7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faCut.js', '21.12', 0),
('f6ea99de5d0769fbae0bea82338db9f3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDatabase.js', '21.12', 0),
('26bc4250818f6a1c874b4e4fa81dd227', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDeaf.js', '21.12', 0),
('0eba2b4d5b930b26473b8908e14370cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDemocrat.js', '21.12', 0),
('6e65d6f52ee0b63dc52180c2ba1b0241', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDesktop.js', '21.12', 0),
('bc7da12804dc8a242af1364a1f3ef263', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDharmachakra.js', '21.12', 0),
('7e9d3d6b36d866054cdcf21150d67b63', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiagnoses.js', '21.12', 0),
('714b251d39f1c98b55ae6d434c3e86a9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDice.js', '21.12', 0),
('2075b18dec7ec1fbacfd1af97f973443', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceD20.js', '21.12', 0),
('27a0b813602f68f5de14f657c246b9ca', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceD6.js', '21.12', 0),
('1011e247bc6351bb52cf2a4ed6110e5f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceFive.js', '21.12', 0),
('09cc8f2d93b13a518ae2e1101a039003', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceFour.js', '21.12', 0),
('9ab5c94312d014c4d7847bb42a52dbaa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceOne.js', '21.12', 0),
('382b296f9883de5e5a521983b825f562', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceSix.js', '21.12', 0),
('96e2e3ca3eb092255276fec756c5f4d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceThree.js', '21.12', 0),
('59e11ae1d43a26611cd2377aa3ee888d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDiceTwo.js', '21.12', 0),
('8c7556b8bec76ba0647b1187893d8f06', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDigitalTachograph.js', '21.12', 0),
('bea98664a071f714ca9d377aee161ffb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDirections.js', '21.12', 0),
('b5fd9b6b893e7e7383741a09d3038797', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDisease.js', '21.12', 0),
('2c1d1aa634f7db714e0ef7b0fe8dedbf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDivide.js', '21.12', 0),
('cfd28f44e7d2e5c424b313d187f62d19', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDizzy.js', '21.12', 0),
('077e5e3e1da27fdc6077a427955fc9b7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDna.js', '21.12', 0),
('8ba254b7b16b5bd8184fbeb661a98c76', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDog.js', '21.12', 0),
('c703791ea9fa411a6e8345d416c086ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDollarSign.js', '21.12', 0),
('834d67e7b9465d94359606b91b35d962', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDolly.js', '21.12', 0),
('d6237283c7d3bee8af6df0a4cf13743e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDollyFlatbed.js', '21.12', 0),
('8bac10232eaf152ccaaa4cbd1ce8306f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDonate.js', '21.12', 0),
('74fdb1266ab977358e6a1be7ce4fd162', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDoorClosed.js', '21.12', 0),
('0d7c1a8cc878144623dfcb3f7ad76f41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDoorOpen.js', '21.12', 0),
('c2d357c1df1ed9b1dbec93e87d15d38d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDotCircle.js', '21.12', 0),
('55ba7f1876028295ef5629b1792b93bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDove.js', '21.12', 0),
('b650c7e4636c6f5066e0790d8d0a801e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDownload.js', '21.12', 0),
('6be9f8b92cc4bde87f6abd025edd9d09', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDraftingCompass.js', '21.12', 0),
('d2eeafff6fe1651af195a6fbcc4b5cc9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDragon.js', '21.12', 0),
('31edc521fb65edf903d6267cb74527bd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDrawPolygon.js', '21.12', 0),
('429334ca760f9bb09f31281ea953cc83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDrum.js', '21.12', 0),
('fdfcad275c6d3feadaa8dfc0080bd2de', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDrumSteelpan.js', '21.12', 0),
('b10a3932e72d4d0a8344f51be4acc6fa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDrumstickBite.js', '21.12', 0),
('dd86ec0cb0fa4a89181e80087c3dfc4f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDumbbell.js', '21.12', 0),
('14036066c0ee69f3d07e57eb89e7c740', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDumpster.js', '21.12', 0),
('1a337ddc38e9a9559a3cf032861bb0df', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDumpsterFire.js', '21.12', 0),
('4967578a6f4d5caec8e0f35d43fd8a5c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faDungeon.js', '21.12', 0),
('f1e30575d843d825a8e15566df190f39', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEdit.js', '21.12', 0),
('96edc7331c266f3f411f0eed2a368220', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEgg.js', '21.12', 0),
('e4b325c6ed2582bb139c24dffad7b1e1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEject.js', '21.12', 0),
('47f7977c7435da366565a67938918ddc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEllipsisH.js', '21.12', 0),
('c209b792f59a5a52941d9746ba135c72', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEllipsisV.js', '21.12', 0),
('e36c7be679fc185f47a8b592e656f0b8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEnvelope.js', '21.12', 0),
('64823f9a899b2aa6887a218747a14fb6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEnvelopeOpen.js', '21.12', 0),
('2ac7f33bb2ae676f493d814a945306ae', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEnvelopeOpenText.js', '21.12', 0),
('fdff674f7316a7a1a1040c18d7d4cf5e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEnvelopeSquare.js', '21.12', 0),
('16d9081588a68f7f192269407658a6e2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-solid-svg-icons/faEquals.js', '21.12', 0),
('0ee52f88342604c3061b5372d61425b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@f