<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
class Search_GlobalSource_FileAttachmentSource implements Search_GlobalSource_Interface
{
    private $relationlib;
    private $attributelib;
    private $fileSource;

    public function __construct(Search_ContentSource_Interface $source)
    {
        $this->relationlib = TikiLib::lib('relation');
        $this->attributelib = TikiLib::lib('attribute');
        $this->fileSource = $source;
    }

    public function getProvidedFields(): array
    {
        return ['attachment_contents', 'attachments', 'primary_image'];
    }

    public function getProvidedFieldTypes(): array
    {
        return [
            'attachment_contents' => 'plaintext',
            'attachments' => 'multivalue',
            'primary_image' => 'identifier'
        ];
    }

    public function getGlobalFields(): array
    {
        return [
            'attachment_contents' => false,
        ];
    }

    public function getData($objectType, $objectId, Search_Type_Factory_Interface $typeFactory, array $data = [])
    {
        $relations = $this->relationlib->get_relations_from($objectType, $objectId, 'tiki.file.attach');
        $attributes = $this->attributelib->get_attributes($objectType, $objectId);

        $textual = [];
        $files = [];

        foreach ($relations as $rel) {
            if ($rel['type'] == 'file' && ! empty($rel['itemId'])) {
                $files[] = $rel['itemId'];
                if ($data = $this->fileSource->getDocument($rel['itemId'], $typeFactory)) {
                    foreach ($this->fileSource->getGlobalFields() as $name => $keep) {
                        if (isset($data[$name])) {
                            $textual[] = $data[$name]->getValue();
                        }
                    }
                } else {
                    error_log("File " . $rel['itemId'] . ", referenced from " . $objectType . $objectId . " no longer exists.");
                }
            }
        }

        return [
            'attachments' => $typeFactory->multivalue($files),
            'attachment_contents' => $typeFactory->plaintext(implode(' ', $textual)),
            'primary_image' => $typeFactory->identifier(isset($attributes['tiki.object.image']) ? $attributes['tiki.object.image'] : ''),
        ];
    }
}
