<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.

use SteveGrunwell\PHPUnit_Markup_Assertions\MarkupAssertionsTrait;
use Tiki\Smarty\SmartyTiki;

require_once(__DIR__ . '/../../smarty_tiki/function.toolbars.php');

/**
 * Test class for smarty_function_toolbars().
 * Generated by PHPUnit on 2010-08-05 at 10:04:14.
 */
class FunctionToolbarsTest extends TikiTestCase
{
    use MarkupAssertionsTrait;

    private SmartyTiki $smarty;

    protected function setUp(): void
    {
        global $prefs, $iconset, $toolbarDialogIndex;

        TikiLib::lib('cache')->empty_cache();
        $prefs['wysiwyg_htmltowiki'] = 'y';
        // needed to mimic that the pipeline on gitlab does
        // i need to update my local testing environment to match that more closely
        unset($_SESSION['tiki_cookie_jar']);
        include_once 'lib/setup/cookies.php';

        $iconset = TikiLib::lib('iconset')->getIconsetForTheme('default', '');
        $toolbarDialogIndex = 0;

        $this->smarty = TikiLib::lib('smarty');
    }

    public function testFunctionToolbarsDefault(): void
    {
        //To find out more, check the file /tiki/lib/test/smarty_tiki/fixtures/FunctionToolbarsDefault.html content structure

        $params = [
            '_wysiwyg'     => 'n',
            'area_id'      => 'editwiki',
            'comments'     => 'n',
            'is_html'      => 0,
            'switcheditor' => 'n',
            'section'      => 'wiki page',
        ];

        $render = smarty_function_toolbars($params, $this->smarty->getEmptyInternalTemplate());
        $render = str_replace('vendor_bundled/vendor/phpunit/phpunit/', '', $render);
        // results comes back with absolute paths when run from here
        $tikipath = str_replace('lib/test/smarty_tiki', '', dirname(__FILE__));
        $render = str_replace($tikipath, '', $render);

        //must contain div with class .helptool-admin float-end
        $this->assertContainsSelector('div>div.helptool-admin.float-end', $render);
        //div with class .helptool-admin float-end must contain link only
        $this->assertContainsSelector('div>div.helptool-admin.float-end a.toolbar', $render);
        $this->assertNotContainsSelector('div>div.helptool-admin.float-end span.toolbar', $render);

        //must contain elements with class .toolbar-list
        $this->assertContainsSelector('div>span.toolbar-list', $render);
        $this->assertContainsSelector('div>span.toolbar-list a.toolbar', $render);
        $this->assertNotContainsSelector('div>span.toolbar-list span.toolbar', $render);

        //all link must contain css class .toolbar
        $this->assertContainsSelector('a.toolbar', $render);
    }

    public function testFunctionToolbarsWysiwyg(): void
    {
        $this->markTestSkipped("This test is way too fragile. A better strategy is required.");

        $params = [
            '_wysiwyg'     => 'y',
            'area_id'      => 'editwiki',
            'comments'     => 'n',
            'is_html'      => 0,
            'switcheditor' => 'n',
            'section'      => 'wiki page',
        ];

        $expectedResults = [
            [['Bold', 'Italic', 'Underline', 'Strike', '-', 'TextColor', '-', 'tikiimage', 'tikilink', 'externallink', 'Unlink', '-', 'Undo', 'Redo', '-', 'Find', 'Replace', '-', 'RemoveFormat', 'SpecialChar', '-', 'tikihelp', 'autosave',],],
            [['Format', 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'JustifyLeft', 'JustifyCenter', '-', 'BulletedList', 'NumberedList', '-', 'PageBreak', 'HorizontalRule', '-', 'tikitable', '-', 'Source', 'ShowBlocks', '-', 'Maximize',],],
        ];
        /** @var HeaderLib $headerlib */
        //$headerlib = $this->createMock('HeaderLib');
        $headerlib = TikiLib::lib('header');

        // clean out the leftover js additions from previous tests
        $headerlib->__construct();

        $result = smarty_function_toolbars($params, $this->smarty->getEmptyInternalTemplate());

        // when the full test set is run perms work differently and the Source tool is added
        // can't work out why so ignore that one if it's missing FIXME?

        if (! in_array('Source', $result[1][0])) {
            unset($expectedResults[1][0][array_search('Source', $expectedResults[1][0])]);
            $expectedResults[1][0] = array_values($expectedResults[1][0]);
        }

        $this->assertEquals($expectedResults, $result);

        $finalJs = $headerlib->js;

        $this->assertNotEmpty($finalJs);
    }
}
