<?php
/**
 * DomainData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Elastic Email REST API
 *
 * This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://app.elasticemail.com/marketing/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: support@elasticemail.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace ElasticEmail\Model;

use \ArrayAccess;
use \ElasticEmail\ObjectSerializer;

/**
 * DomainData Class Doc Comment
 *
 * @category Class
 * @description Domain data, with information about domain records.
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DomainData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DomainData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'validation_log' => 'string',
        'domain' => 'string',
        'default_domain' => 'bool',
        'spf' => 'bool',
        'dkim' => 'bool',
        'mx' => 'bool',
        'dmarc' => 'bool',
        'is_rewrite_domain_valid' => 'bool',
        'verify' => 'bool',
        'type' => '\ElasticEmail\Model\TrackingType',
        'tracking_status' => '\ElasticEmail\Model\TrackingValidationStatus',
        'certificate_status' => '\ElasticEmail\Model\CertificateValidationStatus',
        'certificate_validation_error' => 'string',
        'tracking_type_user_request' => '\ElasticEmail\Model\TrackingType',
        'verp' => 'bool',
        'custom_bounces_domain' => 'string',
        'is_custom_bounces_domain_default' => 'bool',
        'is_marked_for_deletion' => 'bool',
        'ownership' => '\ElasticEmail\Model\DomainOwner'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'validation_log' => 'string',
        'domain' => 'string',
        'default_domain' => 'boolean',
        'spf' => 'boolean',
        'dkim' => 'boolean',
        'mx' => 'boolean',
        'dmarc' => 'boolean',
        'is_rewrite_domain_valid' => 'boolean',
        'verify' => 'boolean',
        'type' => null,
        'tracking_status' => null,
        'certificate_status' => null,
        'certificate_validation_error' => 'string',
        'tracking_type_user_request' => null,
        'verp' => 'boolean',
        'custom_bounces_domain' => 'string',
        'is_custom_bounces_domain_default' => 'boolean',
        'is_marked_for_deletion' => 'boolean',
        'ownership' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'validation_log' => false,
        'domain' => false,
        'default_domain' => false,
        'spf' => false,
        'dkim' => false,
        'mx' => false,
        'dmarc' => false,
        'is_rewrite_domain_valid' => false,
        'verify' => false,
        'type' => false,
        'tracking_status' => false,
        'certificate_status' => false,
        'certificate_validation_error' => false,
        'tracking_type_user_request' => false,
        'verp' => false,
        'custom_bounces_domain' => false,
        'is_custom_bounces_domain_default' => false,
        'is_marked_for_deletion' => false,
        'ownership' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'validation_log' => 'ValidationLog',
        'domain' => 'Domain',
        'default_domain' => 'DefaultDomain',
        'spf' => 'Spf',
        'dkim' => 'Dkim',
        'mx' => 'MX',
        'dmarc' => 'DMARC',
        'is_rewrite_domain_valid' => 'IsRewriteDomainValid',
        'verify' => 'Verify',
        'type' => 'Type',
        'tracking_status' => 'TrackingStatus',
        'certificate_status' => 'CertificateStatus',
        'certificate_validation_error' => 'CertificateValidationError',
        'tracking_type_user_request' => 'TrackingTypeUserRequest',
        'verp' => 'VERP',
        'custom_bounces_domain' => 'CustomBouncesDomain',
        'is_custom_bounces_domain_default' => 'IsCustomBouncesDomainDefault',
        'is_marked_for_deletion' => 'IsMarkedForDeletion',
        'ownership' => 'Ownership'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'validation_log' => 'setValidationLog',
        'domain' => 'setDomain',
        'default_domain' => 'setDefaultDomain',
        'spf' => 'setSpf',
        'dkim' => 'setDkim',
        'mx' => 'setMx',
        'dmarc' => 'setDmarc',
        'is_rewrite_domain_valid' => 'setIsRewriteDomainValid',
        'verify' => 'setVerify',
        'type' => 'setType',
        'tracking_status' => 'setTrackingStatus',
        'certificate_status' => 'setCertificateStatus',
        'certificate_validation_error' => 'setCertificateValidationError',
        'tracking_type_user_request' => 'setTrackingTypeUserRequest',
        'verp' => 'setVerp',
        'custom_bounces_domain' => 'setCustomBouncesDomain',
        'is_custom_bounces_domain_default' => 'setIsCustomBouncesDomainDefault',
        'is_marked_for_deletion' => 'setIsMarkedForDeletion',
        'ownership' => 'setOwnership'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'validation_log' => 'getValidationLog',
        'domain' => 'getDomain',
        'default_domain' => 'getDefaultDomain',
        'spf' => 'getSpf',
        'dkim' => 'getDkim',
        'mx' => 'getMx',
        'dmarc' => 'getDmarc',
        'is_rewrite_domain_valid' => 'getIsRewriteDomainValid',
        'verify' => 'getVerify',
        'type' => 'getType',
        'tracking_status' => 'getTrackingStatus',
        'certificate_status' => 'getCertificateStatus',
        'certificate_validation_error' => 'getCertificateValidationError',
        'tracking_type_user_request' => 'getTrackingTypeUserRequest',
        'verp' => 'getVerp',
        'custom_bounces_domain' => 'getCustomBouncesDomain',
        'is_custom_bounces_domain_default' => 'getIsCustomBouncesDomainDefault',
        'is_marked_for_deletion' => 'getIsMarkedForDeletion',
        'ownership' => 'getOwnership'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('validation_log', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('default_domain', $data ?? [], null);
        $this->setIfExists('spf', $data ?? [], null);
        $this->setIfExists('dkim', $data ?? [], null);
        $this->setIfExists('mx', $data ?? [], null);
        $this->setIfExists('dmarc', $data ?? [], null);
        $this->setIfExists('is_rewrite_domain_valid', $data ?? [], null);
        $this->setIfExists('verify', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('tracking_status', $data ?? [], null);
        $this->setIfExists('certificate_status', $data ?? [], null);
        $this->setIfExists('certificate_validation_error', $data ?? [], null);
        $this->setIfExists('tracking_type_user_request', $data ?? [], null);
        $this->setIfExists('verp', $data ?? [], null);
        $this->setIfExists('custom_bounces_domain', $data ?? [], null);
        $this->setIfExists('is_custom_bounces_domain_default', $data ?? [], null);
        $this->setIfExists('is_marked_for_deletion', $data ?? [], null);
        $this->setIfExists('ownership', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets validation_log
     *
     * @return string|null
     */
    public function getValidationLog()
    {
        return $this->container['validation_log'];
    }

    /**
     * Sets validation_log
     *
     * @param string|null $validation_log Domain validation results - when domain has been running through validation process
     *
     * @return self
     */
    public function setValidationLog($validation_log)
    {
        if (is_null($validation_log)) {
            throw new \InvalidArgumentException('non-nullable validation_log cannot be null');
        }
        $this->container['validation_log'] = $validation_log;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string|null $domain Name of selected domain.
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets default_domain
     *
     * @return bool|null
     */
    public function getDefaultDomain()
    {
        return $this->container['default_domain'];
    }

    /**
     * Sets default_domain
     *
     * @param bool|null $default_domain True, if domain is used as default. Otherwise, false,
     *
     * @return self
     */
    public function setDefaultDomain($default_domain)
    {
        if (is_null($default_domain)) {
            throw new \InvalidArgumentException('non-nullable default_domain cannot be null');
        }
        $this->container['default_domain'] = $default_domain;

        return $this;
    }

    /**
     * Gets spf
     *
     * @return bool|null
     */
    public function getSpf()
    {
        return $this->container['spf'];
    }

    /**
     * Sets spf
     *
     * @param bool|null $spf True, if SPF record is verified
     *
     * @return self
     */
    public function setSpf($spf)
    {
        if (is_null($spf)) {
            throw new \InvalidArgumentException('non-nullable spf cannot be null');
        }
        $this->container['spf'] = $spf;

        return $this;
    }

    /**
     * Gets dkim
     *
     * @return bool|null
     */
    public function getDkim()
    {
        return $this->container['dkim'];
    }

    /**
     * Sets dkim
     *
     * @param bool|null $dkim True, if DKIM record is verified
     *
     * @return self
     */
    public function setDkim($dkim)
    {
        if (is_null($dkim)) {
            throw new \InvalidArgumentException('non-nullable dkim cannot be null');
        }
        $this->container['dkim'] = $dkim;

        return $this;
    }

    /**
     * Gets mx
     *
     * @return bool|null
     */
    public function getMx()
    {
        return $this->container['mx'];
    }

    /**
     * Sets mx
     *
     * @param bool|null $mx True, if MX record is verified
     *
     * @return self
     */
    public function setMx($mx)
    {
        if (is_null($mx)) {
            throw new \InvalidArgumentException('non-nullable mx cannot be null');
        }
        $this->container['mx'] = $mx;

        return $this;
    }

    /**
     * Gets dmarc
     *
     * @return bool|null
     */
    public function getDmarc()
    {
        return $this->container['dmarc'];
    }

    /**
     * Sets dmarc
     *
     * @param bool|null $dmarc dmarc
     *
     * @return self
     */
    public function setDmarc($dmarc)
    {
        if (is_null($dmarc)) {
            throw new \InvalidArgumentException('non-nullable dmarc cannot be null');
        }
        $this->container['dmarc'] = $dmarc;

        return $this;
    }

    /**
     * Gets is_rewrite_domain_valid
     *
     * @return bool|null
     */
    public function getIsRewriteDomainValid()
    {
        return $this->container['is_rewrite_domain_valid'];
    }

    /**
     * Sets is_rewrite_domain_valid
     *
     * @param bool|null $is_rewrite_domain_valid True, if tracking CNAME record is verified
     *
     * @return self
     */
    public function setIsRewriteDomainValid($is_rewrite_domain_valid)
    {
        if (is_null($is_rewrite_domain_valid)) {
            throw new \InvalidArgumentException('non-nullable is_rewrite_domain_valid cannot be null');
        }
        $this->container['is_rewrite_domain_valid'] = $is_rewrite_domain_valid;

        return $this;
    }

    /**
     * Gets verify
     *
     * @return bool|null
     */
    public function getVerify()
    {
        return $this->container['verify'];
    }

    /**
     * Sets verify
     *
     * @param bool|null $verify True, if DKIM, SPF, or tracking are still to be verified
     *
     * @return self
     */
    public function setVerify($verify)
    {
        if (is_null($verify)) {
            throw new \InvalidArgumentException('non-nullable verify cannot be null');
        }
        $this->container['verify'] = $verify;

        return $this;
    }

    /**
     * Gets type
     *
     * @return \ElasticEmail\Model\TrackingType|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param \ElasticEmail\Model\TrackingType|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets tracking_status
     *
     * @return \ElasticEmail\Model\TrackingValidationStatus|null
     */
    public function getTrackingStatus()
    {
        return $this->container['tracking_status'];
    }

    /**
     * Sets tracking_status
     *
     * @param \ElasticEmail\Model\TrackingValidationStatus|null $tracking_status tracking_status
     *
     * @return self
     */
    public function setTrackingStatus($tracking_status)
    {
        if (is_null($tracking_status)) {
            throw new \InvalidArgumentException('non-nullable tracking_status cannot be null');
        }
        $this->container['tracking_status'] = $tracking_status;

        return $this;
    }

    /**
     * Gets certificate_status
     *
     * @return \ElasticEmail\Model\CertificateValidationStatus|null
     */
    public function getCertificateStatus()
    {
        return $this->container['certificate_status'];
    }

    /**
     * Sets certificate_status
     *
     * @param \ElasticEmail\Model\CertificateValidationStatus|null $certificate_status certificate_status
     *
     * @return self
     */
    public function setCertificateStatus($certificate_status)
    {
        if (is_null($certificate_status)) {
            throw new \InvalidArgumentException('non-nullable certificate_status cannot be null');
        }
        $this->container['certificate_status'] = $certificate_status;

        return $this;
    }

    /**
     * Gets certificate_validation_error
     *
     * @return string|null
     */
    public function getCertificateValidationError()
    {
        return $this->container['certificate_validation_error'];
    }

    /**
     * Sets certificate_validation_error
     *
     * @param string|null $certificate_validation_error certificate_validation_error
     *
     * @return self
     */
    public function setCertificateValidationError($certificate_validation_error)
    {
        if (is_null($certificate_validation_error)) {
            throw new \InvalidArgumentException('non-nullable certificate_validation_error cannot be null');
        }
        $this->container['certificate_validation_error'] = $certificate_validation_error;

        return $this;
    }

    /**
     * Gets tracking_type_user_request
     *
     * @return \ElasticEmail\Model\TrackingType|null
     */
    public function getTrackingTypeUserRequest()
    {
        return $this->container['tracking_type_user_request'];
    }

    /**
     * Sets tracking_type_user_request
     *
     * @param \ElasticEmail\Model\TrackingType|null $tracking_type_user_request tracking_type_user_request
     *
     * @return self
     */
    public function setTrackingTypeUserRequest($tracking_type_user_request)
    {
        if (is_null($tracking_type_user_request)) {
            throw new \InvalidArgumentException('non-nullable tracking_type_user_request cannot be null');
        }
        $this->container['tracking_type_user_request'] = $tracking_type_user_request;

        return $this;
    }

    /**
     * Gets verp
     *
     * @return bool|null
     */
    public function getVerp()
    {
        return $this->container['verp'];
    }

    /**
     * Sets verp
     *
     * @param bool|null $verp verp
     *
     * @return self
     */
    public function setVerp($verp)
    {
        if (is_null($verp)) {
            throw new \InvalidArgumentException('non-nullable verp cannot be null');
        }
        $this->container['verp'] = $verp;

        return $this;
    }

    /**
     * Gets custom_bounces_domain
     *
     * @return string|null
     */
    public function getCustomBouncesDomain()
    {
        return $this->container['custom_bounces_domain'];
    }

    /**
     * Sets custom_bounces_domain
     *
     * @param string|null $custom_bounces_domain custom_bounces_domain
     *
     * @return self
     */
    public function setCustomBouncesDomain($custom_bounces_domain)
    {
        if (is_null($custom_bounces_domain)) {
            throw new \InvalidArgumentException('non-nullable custom_bounces_domain cannot be null');
        }
        $this->container['custom_bounces_domain'] = $custom_bounces_domain;

        return $this;
    }

    /**
     * Gets is_custom_bounces_domain_default
     *
     * @return bool|null
     */
    public function getIsCustomBouncesDomainDefault()
    {
        return $this->container['is_custom_bounces_domain_default'];
    }

    /**
     * Sets is_custom_bounces_domain_default
     *
     * @param bool|null $is_custom_bounces_domain_default is_custom_bounces_domain_default
     *
     * @return self
     */
    public function setIsCustomBouncesDomainDefault($is_custom_bounces_domain_default)
    {
        if (is_null($is_custom_bounces_domain_default)) {
            throw new \InvalidArgumentException('non-nullable is_custom_bounces_domain_default cannot be null');
        }
        $this->container['is_custom_bounces_domain_default'] = $is_custom_bounces_domain_default;

        return $this;
    }

    /**
     * Gets is_marked_for_deletion
     *
     * @return bool|null
     */
    public function getIsMarkedForDeletion()
    {
        return $this->container['is_marked_for_deletion'];
    }

    /**
     * Sets is_marked_for_deletion
     *
     * @param bool|null $is_marked_for_deletion is_marked_for_deletion
     *
     * @return self
     */
    public function setIsMarkedForDeletion($is_marked_for_deletion)
    {
        if (is_null($is_marked_for_deletion)) {
            throw new \InvalidArgumentException('non-nullable is_marked_for_deletion cannot be null');
        }
        $this->container['is_marked_for_deletion'] = $is_marked_for_deletion;

        return $this;
    }

    /**
     * Gets ownership
     *
     * @return \ElasticEmail\Model\DomainOwner|null
     */
    public function getOwnership()
    {
        return $this->container['ownership'];
    }

    /**
     * Sets ownership
     *
     * @param \ElasticEmail\Model\DomainOwner|null $ownership ownership
     *
     * @return self
     */
    public function setOwnership($ownership)
    {
        if (is_null($ownership)) {
            throw new \InvalidArgumentException('non-nullable ownership cannot be null');
        }
        $this->container['ownership'] = $ownership;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


