<?php
/**
 * RecipientEvent
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Elastic Email REST API
 *
 * This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://app.elasticemail.com/marketing/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: support@elasticemail.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace ElasticEmail\Model;

use \ArrayAccess;
use \ElasticEmail\ObjectSerializer;

/**
 * RecipientEvent Class Doc Comment
 *
 * @category Class
 * @description Detailed information about message recipient
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RecipientEvent implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RecipientEvent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_id' => 'string',
        'msg_id' => 'string',
        'from_email' => 'string',
        'to' => 'string',
        'subject' => 'string',
        'event_type' => '\ElasticEmail\Model\EventType',
        'event_date' => '\DateTime',
        'channel_name' => 'string',
        'message_category' => '\ElasticEmail\Model\MessageCategory',
        'next_try_on' => '\DateTime',
        'message' => 'string',
        'ip_address' => 'string',
        'pool_name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_id' => 'string',
        'msg_id' => 'string',
        'from_email' => 'string',
        'to' => 'string',
        'subject' => 'string',
        'event_type' => null,
        'event_date' => 'date-time',
        'channel_name' => 'string',
        'message_category' => null,
        'next_try_on' => 'date-time',
        'message' => 'string',
        'ip_address' => 'string',
        'pool_name' => 'string'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'transaction_id' => false,
        'msg_id' => false,
        'from_email' => false,
        'to' => false,
        'subject' => false,
        'event_type' => false,
        'event_date' => false,
        'channel_name' => false,
        'message_category' => false,
        'next_try_on' => true,
        'message' => false,
        'ip_address' => false,
        'pool_name' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'TransactionID',
        'msg_id' => 'MsgID',
        'from_email' => 'FromEmail',
        'to' => 'To',
        'subject' => 'Subject',
        'event_type' => 'EventType',
        'event_date' => 'EventDate',
        'channel_name' => 'ChannelName',
        'message_category' => 'MessageCategory',
        'next_try_on' => 'NextTryOn',
        'message' => 'Message',
        'ip_address' => 'IPAddress',
        'pool_name' => 'PoolName'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'msg_id' => 'setMsgId',
        'from_email' => 'setFromEmail',
        'to' => 'setTo',
        'subject' => 'setSubject',
        'event_type' => 'setEventType',
        'event_date' => 'setEventDate',
        'channel_name' => 'setChannelName',
        'message_category' => 'setMessageCategory',
        'next_try_on' => 'setNextTryOn',
        'message' => 'setMessage',
        'ip_address' => 'setIpAddress',
        'pool_name' => 'setPoolName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'msg_id' => 'getMsgId',
        'from_email' => 'getFromEmail',
        'to' => 'getTo',
        'subject' => 'getSubject',
        'event_type' => 'getEventType',
        'event_date' => 'getEventDate',
        'channel_name' => 'getChannelName',
        'message_category' => 'getMessageCategory',
        'next_try_on' => 'getNextTryOn',
        'message' => 'getMessage',
        'ip_address' => 'getIpAddress',
        'pool_name' => 'getPoolName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('msg_id', $data ?? [], null);
        $this->setIfExists('from_email', $data ?? [], null);
        $this->setIfExists('to', $data ?? [], null);
        $this->setIfExists('subject', $data ?? [], null);
        $this->setIfExists('event_type', $data ?? [], null);
        $this->setIfExists('event_date', $data ?? [], null);
        $this->setIfExists('channel_name', $data ?? [], null);
        $this->setIfExists('message_category', $data ?? [], null);
        $this->setIfExists('next_try_on', $data ?? [], null);
        $this->setIfExists('message', $data ?? [], null);
        $this->setIfExists('ip_address', $data ?? [], null);
        $this->setIfExists('pool_name', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id ID number of transaction
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            throw new \InvalidArgumentException('non-nullable transaction_id cannot be null');
        }
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets msg_id
     *
     * @return string|null
     */
    public function getMsgId()
    {
        return $this->container['msg_id'];
    }

    /**
     * Sets msg_id
     *
     * @param string|null $msg_id ID number of selected message.
     *
     * @return self
     */
    public function setMsgId($msg_id)
    {
        if (is_null($msg_id)) {
            throw new \InvalidArgumentException('non-nullable msg_id cannot be null');
        }
        $this->container['msg_id'] = $msg_id;

        return $this;
    }

    /**
     * Gets from_email
     *
     * @return string|null
     */
    public function getFromEmail()
    {
        return $this->container['from_email'];
    }

    /**
     * Sets from_email
     *
     * @param string|null $from_email Default From: email address.
     *
     * @return self
     */
    public function setFromEmail($from_email)
    {
        if (is_null($from_email)) {
            throw new \InvalidArgumentException('non-nullable from_email cannot be null');
        }
        $this->container['from_email'] = $from_email;

        return $this;
    }

    /**
     * Gets to
     *
     * @return string|null
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     *
     * @param string|null $to Ending date for search in YYYY-MM-DDThh:mm:ss format.
     *
     * @return self
     */
    public function setTo($to)
    {
        if (is_null($to)) {
            throw new \InvalidArgumentException('non-nullable to cannot be null');
        }
        $this->container['to'] = $to;

        return $this;
    }

    /**
     * Gets subject
     *
     * @return string|null
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     *
     * @param string|null $subject Default subject of email.
     *
     * @return self
     */
    public function setSubject($subject)
    {
        if (is_null($subject)) {
            throw new \InvalidArgumentException('non-nullable subject cannot be null');
        }
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets event_type
     *
     * @return \ElasticEmail\Model\EventType|null
     */
    public function getEventType()
    {
        return $this->container['event_type'];
    }

    /**
     * Sets event_type
     *
     * @param \ElasticEmail\Model\EventType|null $event_type event_type
     *
     * @return self
     */
    public function setEventType($event_type)
    {
        if (is_null($event_type)) {
            throw new \InvalidArgumentException('non-nullable event_type cannot be null');
        }
        $this->container['event_type'] = $event_type;

        return $this;
    }

    /**
     * Gets event_date
     *
     * @return \DateTime|null
     */
    public function getEventDate()
    {
        return $this->container['event_date'];
    }

    /**
     * Sets event_date
     *
     * @param \DateTime|null $event_date Creation date
     *
     * @return self
     */
    public function setEventDate($event_date)
    {
        if (is_null($event_date)) {
            throw new \InvalidArgumentException('non-nullable event_date cannot be null');
        }
        $this->container['event_date'] = $event_date;

        return $this;
    }

    /**
     * Gets channel_name
     *
     * @return string|null
     */
    public function getChannelName()
    {
        return $this->container['channel_name'];
    }

    /**
     * Sets channel_name
     *
     * @param string|null $channel_name Name of selected channel.
     *
     * @return self
     */
    public function setChannelName($channel_name)
    {
        if (is_null($channel_name)) {
            throw new \InvalidArgumentException('non-nullable channel_name cannot be null');
        }
        $this->container['channel_name'] = $channel_name;

        return $this;
    }

    /**
     * Gets message_category
     *
     * @return \ElasticEmail\Model\MessageCategory|null
     */
    public function getMessageCategory()
    {
        return $this->container['message_category'];
    }

    /**
     * Sets message_category
     *
     * @param \ElasticEmail\Model\MessageCategory|null $message_category message_category
     *
     * @return self
     */
    public function setMessageCategory($message_category)
    {
        if (is_null($message_category)) {
            throw new \InvalidArgumentException('non-nullable message_category cannot be null');
        }
        $this->container['message_category'] = $message_category;

        return $this;
    }

    /**
     * Gets next_try_on
     *
     * @return \DateTime|null
     */
    public function getNextTryOn()
    {
        return $this->container['next_try_on'];
    }

    /**
     * Sets next_try_on
     *
     * @param \DateTime|null $next_try_on Date of next try
     *
     * @return self
     */
    public function setNextTryOn($next_try_on)
    {
        if (is_null($next_try_on)) {
            array_push($this->openAPINullablesSetToNull, 'next_try_on');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('next_try_on', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['next_try_on'] = $next_try_on;

        return $this;
    }

    /**
     * Gets message
     *
     * @return string|null
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     *
     * @param string|null $message Content of message, HTML encoded
     *
     * @return self
     */
    public function setMessage($message)
    {
        if (is_null($message)) {
            throw new \InvalidArgumentException('non-nullable message cannot be null');
        }
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets ip_address
     *
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->container['ip_address'];
    }

    /**
     * Sets ip_address
     *
     * @param string|null $ip_address IP which this email was sent through
     *
     * @return self
     */
    public function setIpAddress($ip_address)
    {
        if (is_null($ip_address)) {
            throw new \InvalidArgumentException('non-nullable ip_address cannot be null');
        }
        $this->container['ip_address'] = $ip_address;

        return $this;
    }

    /**
     * Gets pool_name
     *
     * @return string|null
     */
    public function getPoolName()
    {
        return $this->container['pool_name'];
    }

    /**
     * Sets pool_name
     *
     * @param string|null $pool_name Name of an IP pool this email was sent through
     *
     * @return self
     */
    public function setPoolName($pool_name)
    {
        if (is_null($pool_name)) {
            throw new \InvalidArgumentException('non-nullable pool_name cannot be null');
        }
        $this->container['pool_name'] = $pool_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


