<?php

namespace garethp\ews\API\Message;

/**
 * Class representing ConvertIdType
 *
 * Converts the passed source ids into the destination format. Change keys are not
 *  returned.
 * XSD Type: ConvertIdType
 */
class ConvertIdType extends BaseRequestType
{

    /**
     * @var string
     */
    protected $destinationFormat = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfAlternateIdsType
     */
    protected $sourceIds = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDestinationFormat()
    {
        return $this->destinationFormat;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConvertIdType
     */
    public function setDestinationFormat($value)
    {
        $this->destinationFormat = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\NonEmptyArrayOfAlternateIdsType
     */
    public function getSourceIds()
    {
        return $this->sourceIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\NonEmptyArrayOfAlternateIdsType
     * @return ConvertIdType
     */
    public function setSourceIds(\garethp\ews\API\Type\NonEmptyArrayOfAlternateIdsType $value)
    {
        $this->sourceIds = $value;
        return $this;
    }
}
