<?php

namespace garethp\ews\API\Message;

use garethp\ews\API\Type\IndexedPageViewType;

/**
 * Class representing FindFolderType
 *
 *
 * XSD Type: FindFolderType
 */
class FindFolderType extends BaseRequestType
{

    /**
     * @var string
     */
    protected $traversal = null;

    /**
     * @var \garethp\ews\API\Type\FolderResponseShapeType
     */
    protected $folderShape = null;

    /**
     * @var \garethp\ews\API\Type\IndexedPageViewType
     */
    protected $indexedPageFolderView = null;

    /**
     * @var \garethp\ews\API\Type\FractionalPageViewType
     */
    protected $fractionalPageFolderView = null;

    /**
     * @var \garethp\ews\API\Type\RestrictionType
     */
    protected $restriction = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     */
    protected $parentFolderIds = null;

    public function setIndexedPage(\garethp\ews\API\Type\IndexedPageViewType $page)
    {
        $this->indexedPageFolderView = $page;
        return $this;
    }

    public static function buildFromArray($array, $strict = false)
    {
        return parent::buildFromArray($array, true);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getTraversal()
    {
        return $this->traversal;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindFolderType
     */
    public function setTraversal($value)
    {
        $this->traversal = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FolderResponseShapeType
     */
    public function getFolderShape()
    {
        return $this->folderShape;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FolderResponseShapeType
     * @return FindFolderType
     */
    public function setFolderShape(\garethp\ews\API\Type\FolderResponseShapeType $value)
    {
        $this->folderShape = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\IndexedPageViewType
     */
    public function getIndexedPageFolderView()
    {
        return $this->indexedPageFolderView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\IndexedPageViewType
     * @return FindFolderType
     */
    public function setIndexedPageFolderView(\garethp\ews\API\Type\IndexedPageViewType $value)
    {
        $this->indexedPageFolderView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FractionalPageViewType
     */
    public function getFractionalPageFolderView()
    {
        return $this->fractionalPageFolderView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FractionalPageViewType
     * @return FindFolderType
     */
    public function setFractionalPageFolderView(\garethp\ews\API\Type\FractionalPageViewType $value)
    {
        $this->fractionalPageFolderView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\RestrictionType
     */
    public function getRestriction()
    {
        return $this->restriction;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\RestrictionType
     * @return FindFolderType
     */
    public function setRestriction(\garethp\ews\API\Type\RestrictionType $value)
    {
        $this->restriction = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     */
    public function getParentFolderIds()
    {
        return $this->parentFolderIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     * @return FindFolderType
     */
    public function setParentFolderIds(\garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType $value)
    {
        $this->parentFolderIds = $value;
        return $this;
    }
}
