<?php

namespace garethp\ews\API\Message;

/**
 * Class representing FindMailboxStatisticsByKeywordsType
 *
 * Request type for the FindMailboxStatisticsByKeywords web method.
 * XSD Type: FindMailboxStatisticsByKeywordsType
 */
class FindMailboxStatisticsByKeywordsType extends BaseRequestType
{

    /**
     * @var \garethp\ews\API\Type\UserMailboxType[]
     */
    protected $mailboxes = null;

    /**
     * @var string[]
     */
    protected $keywords = null;

    /**
     * @var string
     */
    protected $language = null;

    /**
     * @var string[]
     */
    protected $senders = null;

    /**
     * @var string[]
     */
    protected $recipients = null;

    /**
     * @var \DateTime
     */
    protected $fromDate = null;

    /**
     * @var \DateTime
     */
    protected $toDate = null;

    /**
     * @var string[]
     */
    protected $messageTypes = null;

    /**
     * @var boolean
     */
    protected $searchDumpster = null;

    /**
     * @var boolean
     */
    protected $includePersonalArchive = null;

    /**
     * @var boolean
     */
    protected $includeUnsearchableItems = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\UserMailboxType
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function addMailboxes(\garethp\ews\API\Type\UserMailboxType $value)
    {
        if ($this->mailboxes === null) {
                        $this->mailboxes = array();
        }

        if (!is_array($this->mailboxes)) {
            $this->mailboxes = array($this->mailboxes);
        }

        $this->mailboxes[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\UserMailboxType[]
     */
    public function getMailboxes()
    {
        return $this->mailboxes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\UserMailboxType[]|\garethp\ews\API\Type\UserMailboxType
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setMailboxes(array|\garethp\ews\API\Type\UserMailboxType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->mailboxes = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function addKeywords($value)
    {
        if ($this->keywords === null) {
                        $this->keywords = array();
        }

        if (!is_array($this->keywords)) {
            $this->keywords = array($this->keywords);
        }

        $this->keywords[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getKeywords()
    {
        return $this->keywords;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setKeywords(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->keywords = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setLanguage($value)
    {
        $this->language = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function addSenders($value)
    {
        if ($this->senders === null) {
                        $this->senders = array();
        }

        if (!is_array($this->senders)) {
            $this->senders = array($this->senders);
        }

        $this->senders[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getSenders()
    {
        return $this->senders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setSenders(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->senders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function addRecipients($value)
    {
        if ($this->recipients === null) {
                        $this->recipients = array();
        }

        if (!is_array($this->recipients)) {
            $this->recipients = array($this->recipients);
        }

        $this->recipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getRecipients()
    {
        return $this->recipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setRecipients(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setFromDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->fromDate = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getToDate()
    {
        return $this->toDate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setToDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->toDate = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function addMessageTypes($value)
    {
        if ($this->messageTypes === null) {
                        $this->messageTypes = array();
        }

        if (!is_array($this->messageTypes)) {
            $this->messageTypes = array($this->messageTypes);
        }

        $this->messageTypes[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getMessageTypes()
    {
        return $this->messageTypes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setMessageTypes(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->messageTypes = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isSearchDumpster()
    {
        return ((bool) $this->searchDumpster);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getSearchDumpster()
    {
        return $this->searchDumpster;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setSearchDumpster($value)
    {
        $this->searchDumpster = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludePersonalArchive()
    {
        return ((bool) $this->includePersonalArchive);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludePersonalArchive()
    {
        return $this->includePersonalArchive;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setIncludePersonalArchive($value)
    {
        $this->includePersonalArchive = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludeUnsearchableItems()
    {
        return ((bool) $this->includeUnsearchableItems);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludeUnsearchableItems()
    {
        return $this->includeUnsearchableItems;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return FindMailboxStatisticsByKeywordsType
     */
    public function setIncludeUnsearchableItems($value)
    {
        $this->includeUnsearchableItems = $value;
        return $this;
    }
}
