<?php

namespace garethp\ews\API\Message;

/**
 * Class representing FindMessageTrackingReportRequestType
 *
 *
 * XSD Type: FindMessageTrackingReportRequestType
 */
class FindMessageTrackingReportRequestType extends BaseRequestType
{

    /**
     * @var string
     */
    protected $scope = null;

    /**
     * @var string
     */
    protected $domain = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $sender = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $purportedSender = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $recipient = null;

    /**
     * @var string
     */
    protected $subject = null;

    /**
     * @var \DateTime
     */
    protected $startDateTime = null;

    /**
     * @var \DateTime
     */
    protected $endDateTime = null;

    /**
     * @var string
     */
    protected $messageId = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $federatedDeliveryMailbox = null;

    /**
     * @var string
     */
    protected $diagnosticsLevel = null;

    /**
     * @var string
     */
    protected $serverHint = null;

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $properties = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportRequestType
     */
    public function setScope($value)
    {
        $this->scope = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportRequestType
     */
    public function setDomain($value)
    {
        $this->domain = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\EmailAddressType
     */
    public function getSender()
    {
        return $this->sender;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\EmailAddressType
     * @return FindMessageTrackingReportRequestType
     */
    public function setSender(\garethp\ews\API\Type\EmailAddressType $value)
    {
        $this->sender = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\EmailAddressType
     */
    public function getPurportedSender()
    {
        return $this->purportedSender;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\EmailAddressType
     * @return FindMessageTrackingReportRequestType
     */
    public function setPurportedSender(\garethp\ews\API\Type\EmailAddressType $value)
    {
        $this->purportedSender = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\EmailAddressType
     */
    public function getRecipient()
    {
        return $this->recipient;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\EmailAddressType
     * @return FindMessageTrackingReportRequestType
     */
    public function setRecipient(\garethp\ews\API\Type\EmailAddressType $value)
    {
        $this->recipient = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportRequestType
     */
    public function setSubject($value)
    {
        $this->subject = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getStartDateTime()
    {
        return $this->startDateTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return FindMessageTrackingReportRequestType
     */
    public function setStartDateTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->startDateTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getEndDateTime()
    {
        return $this->endDateTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return FindMessageTrackingReportRequestType
     */
    public function setEndDateTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->endDateTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMessageId()
    {
        return $this->messageId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportRequestType
     */
    public function setMessageId($value)
    {
        $this->messageId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\EmailAddressType
     */
    public function getFederatedDeliveryMailbox()
    {
        return $this->federatedDeliveryMailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\EmailAddressType
     * @return FindMessageTrackingReportRequestType
     */
    public function setFederatedDeliveryMailbox(\garethp\ews\API\Type\EmailAddressType $value)
    {
        $this->federatedDeliveryMailbox = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDiagnosticsLevel()
    {
        return $this->diagnosticsLevel;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportRequestType
     */
    public function setDiagnosticsLevel($value)
    {
        $this->diagnosticsLevel = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getServerHint()
    {
        return $this->serverHint;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindMessageTrackingReportRequestType
     */
    public function setServerHint($value)
    {
        $this->serverHint = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\TrackingPropertyType
     * @return FindMessageTrackingReportRequestType
     */
    public function addProperties(\garethp\ews\API\Type\TrackingPropertyType $value)
    {
        if ($this->properties === null) {
                        $this->properties = array();
        }

        if (!is_array($this->properties)) {
            $this->properties = array($this->properties);
        }

        $this->properties[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TrackingPropertyType[]
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\TrackingPropertyType[]|\garethp\ews\API\Type\TrackingPropertyType
     * @return FindMessageTrackingReportRequestType
     */
    public function setProperties(array|\garethp\ews\API\Type\TrackingPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->properties = $value;
        return $this;
    }
}
