<?php

namespace garethp\ews\API\Message;

use garethp\ews\API\Message;

/**
 * Class representing FreeBusyResponseType
 *
 *
 * XSD Type: FreeBusyResponseType
 */
class FreeBusyResponseType extends Message
{

    /**
     * @var \garethp\ews\API\Message\ResponseMessageType
     */
    protected $responseMessage = null;

    /**
     * @var \garethp\ews\API\Type\FreeBusyViewType
     */
    protected $freeBusyView = null;

    /**
     * @autogenerated This method is safe to replace
     * @return ResponseMessageType
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseMessageType
     * @return FreeBusyResponseType
     */
    public function setResponseMessage(ResponseMessageType $value)
    {
        $this->responseMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FreeBusyViewType
     */
    public function getFreeBusyView()
    {
        return $this->freeBusyView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FreeBusyViewType
     * @return FreeBusyResponseType
     */
    public function setFreeBusyView(\garethp\ews\API\Type\FreeBusyViewType $value)
    {
        $this->freeBusyView = $value;
        return $this;
    }
}
