<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetRoomListsResponseMessageType
 *
 *
 * XSD Type: GetRoomListsResponseMessageType
 */
class GetRoomListsResponseMessageType extends ResponseMessageType
{

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $roomLists = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\EmailAddressType
     * @return GetRoomListsResponseMessageType
     */
    public function addRoomLists(\garethp\ews\API\Type\EmailAddressType $value)
    {
        if ($this->roomLists === null) {
                        $this->roomLists = array();
        }

        if (!is_array($this->roomLists)) {
            $this->roomLists = array($this->roomLists);
        }

        $this->roomLists[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\EmailAddressType[]
     */
    public function getRoomLists()
    {
        return $this->roomLists;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\EmailAddressType[]|\garethp\ews\API\Type\EmailAddressType
     * @return GetRoomListsResponseMessageType
     */
    public function setRoomLists(array|\garethp\ews\API\Type\EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->roomLists = $value;
        return $this;
    }
}
