<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetSharingMetadataType
 *
 *
 * XSD Type: GetSharingMetadataType
 */
class GetSharingMetadataType extends BaseRequestType
{

    /**
     * @var \garethp\ews\API\Type\FolderIdType
     */
    protected $idOfFolderToShare = null;

    /**
     * @var string
     */
    protected $senderSmtpAddress = null;

    /**
     * @var string[]
     */
    protected $recipients = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FolderIdType
     */
    public function getIdOfFolderToShare()
    {
        return $this->idOfFolderToShare;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FolderIdType
     * @return GetSharingMetadataType
     */
    public function setIdOfFolderToShare(\garethp\ews\API\Type\FolderIdType $value)
    {
        $this->idOfFolderToShare = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSenderSmtpAddress()
    {
        return $this->senderSmtpAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return GetSharingMetadataType
     */
    public function setSenderSmtpAddress($value)
    {
        $this->senderSmtpAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return GetSharingMetadataType
     */
    public function addRecipients($value)
    {
        if ($this->recipients === null) {
                        $this->recipients = array();
        }

        if (!is_array($this->recipients)) {
            $this->recipients = array($this->recipients);
        }

        $this->recipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getRecipients()
    {
        return $this->recipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return GetSharingMetadataType
     */
    public function setRecipients(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recipients = $value;
        return $this;
    }
}
