<?php

namespace garethp\ews\API\Message;

use garethp\ews\API\Message;

/**
 * Class representing GetUserAvailabilityResponseType
 *
 *
 * XSD Type: GetUserAvailabilityResponseType
 */
class GetUserAvailabilityResponseType extends Message
{

    /**
     * @var \garethp\ews\API\Message\FreeBusyResponseType[]
     */
    protected $freeBusyResponseArray = null;

    /**
     * @var \garethp\ews\API\Message\SuggestionsResponseType
     */
    protected $suggestionsResponse = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value FreeBusyResponseType
     * @return GetUserAvailabilityResponseType
     */
    public function addFreeBusyResponseArray(FreeBusyResponseType $value)
    {
        if ($this->freeBusyResponseArray === null) {
                        $this->freeBusyResponseArray = array();
        }

        if (!is_array($this->freeBusyResponseArray)) {
            $this->freeBusyResponseArray = array($this->freeBusyResponseArray);
        }

        $this->freeBusyResponseArray[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FreeBusyResponseType[]
     */
    public function getFreeBusyResponseArray()
    {
        return $this->freeBusyResponseArray;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FreeBusyResponseType[]|FreeBusyResponseType
     * @return GetUserAvailabilityResponseType
     */
    public function setFreeBusyResponseArray(array|FreeBusyResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->freeBusyResponseArray = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SuggestionsResponseType
     */
    public function getSuggestionsResponse()
    {
        return $this->suggestionsResponse;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SuggestionsResponseType
     * @return GetUserAvailabilityResponseType
     */
    public function setSuggestionsResponse(SuggestionsResponseType $value)
    {
        $this->suggestionsResponse = $value;
        return $this;
    }
}
