<?php

namespace garethp\ews\API\Message;

/**
 * Class representing SyncFolderItemsResponseMessageType
 *
 *
 * XSD Type: SyncFolderItemsResponseMessageType
 */
class SyncFolderItemsResponseMessageType extends ResponseMessageType
{

    /**
     * @var string
     */
    protected $syncState = null;

    /**
     * @var boolean
     */
    protected $includesLastItemInRange = null;

    /**
     * @var \garethp\ews\API\Type\SyncFolderItemsChangesType
     */
    protected $changes = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSyncState()
    {
        return $this->syncState;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SyncFolderItemsResponseMessageType
     */
    public function setSyncState($value)
    {
        $this->syncState = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludesLastItemInRange()
    {
        return ((bool) $this->includesLastItemInRange);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludesLastItemInRange()
    {
        return $this->includesLastItemInRange;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return SyncFolderItemsResponseMessageType
     */
    public function setIncludesLastItemInRange($value)
    {
        $this->includesLastItemInRange = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\SyncFolderItemsChangesType
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\SyncFolderItemsChangesType
     * @return SyncFolderItemsResponseMessageType
     */
    public function setChanges(\garethp\ews\API\Type\SyncFolderItemsChangesType $value)
    {
        $this->changes = $value;
        return $this;
    }
}
