<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ArrayOfRuleOperationsType
 *
 * Represents an array of rule operations to be performed
 * XSD Type: ArrayOfRuleOperationsType
 */
class ArrayOfRuleOperationsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\CreateRuleOperationType[]
     */
    protected $createRuleOperation = null;

    /**
     * @var \garethp\ews\API\Type\SetRuleOperationType[]
     */
    protected $setRuleOperation = null;

    /**
     * @var \garethp\ews\API\Type\DeleteRuleOperationType[]
     */
    protected $deleteRuleOperation = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value CreateRuleOperationType
     * @return ArrayOfRuleOperationsType
     */
    public function addCreateRuleOperation(CreateRuleOperationType $value)
    {
        if ($this->createRuleOperation === null) {
                        $this->createRuleOperation = array();
        }

        if (!is_array($this->createRuleOperation)) {
            $this->createRuleOperation = array($this->createRuleOperation);
        }

        $this->createRuleOperation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CreateRuleOperationType[]
     */
    public function getCreateRuleOperation()
    {
        return $this->createRuleOperation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CreateRuleOperationType[]|CreateRuleOperationType
     * @return ArrayOfRuleOperationsType
     */
    public function setCreateRuleOperation(array|CreateRuleOperationType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->createRuleOperation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SetRuleOperationType
     * @return ArrayOfRuleOperationsType
     */
    public function addSetRuleOperation(SetRuleOperationType $value)
    {
        if ($this->setRuleOperation === null) {
                        $this->setRuleOperation = array();
        }

        if (!is_array($this->setRuleOperation)) {
            $this->setRuleOperation = array($this->setRuleOperation);
        }

        $this->setRuleOperation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SetRuleOperationType[]
     */
    public function getSetRuleOperation()
    {
        return $this->setRuleOperation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SetRuleOperationType[]|SetRuleOperationType
     * @return ArrayOfRuleOperationsType
     */
    public function setSetRuleOperation(array|SetRuleOperationType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->setRuleOperation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DeleteRuleOperationType
     * @return ArrayOfRuleOperationsType
     */
    public function addDeleteRuleOperation(DeleteRuleOperationType $value)
    {
        if ($this->deleteRuleOperation === null) {
                        $this->deleteRuleOperation = array();
        }

        if (!is_array($this->deleteRuleOperation)) {
            $this->deleteRuleOperation = array($this->deleteRuleOperation);
        }

        $this->deleteRuleOperation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DeleteRuleOperationType[]
     */
    public function getDeleteRuleOperation()
    {
        return $this->deleteRuleOperation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DeleteRuleOperationType[]|DeleteRuleOperationType
     * @return ArrayOfRuleOperationsType
     */
    public function setDeleteRuleOperation(array|DeleteRuleOperationType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->deleteRuleOperation = $value;
        return $this;
    }
}
