<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing AttachmentResponseShapeType
 *
 *
 * XSD Type: AttachmentResponseShapeType
 */
class AttachmentResponseShapeType extends Type
{

    /**
     * @var boolean
     */
    protected $includeMimeContent = null;

    /**
     * @var string
     */
    protected $bodyType = null;

    /**
     * @var boolean
     */
    protected $filterHtmlContent = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfPathsToElementType
     */
    protected $additionalProperties = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludeMimeContent()
    {
        return ((bool) $this->includeMimeContent);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludeMimeContent()
    {
        return $this->includeMimeContent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return AttachmentResponseShapeType
     */
    public function setIncludeMimeContent($value)
    {
        $this->includeMimeContent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBodyType()
    {
        return $this->bodyType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AttachmentResponseShapeType
     */
    public function setBodyType($value)
    {
        $this->bodyType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isFilterHtmlContent()
    {
        return ((bool) $this->filterHtmlContent);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getFilterHtmlContent()
    {
        return $this->filterHtmlContent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return AttachmentResponseShapeType
     */
    public function setFilterHtmlContent($value)
    {
        $this->filterHtmlContent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NonEmptyArrayOfPathsToElementType
     */
    public function getAdditionalProperties()
    {
        return $this->additionalProperties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NonEmptyArrayOfPathsToElementType
     * @return AttachmentResponseShapeType
     */
    public function setAdditionalProperties(NonEmptyArrayOfPathsToElementType $value)
    {
        $this->additionalProperties = $value;
        return $this;
    }
}
