<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing BasePermissionType
 *
 * A permission on a folder
 * XSD Type: BasePermissionType
 */
class BasePermissionType extends Type
{

    /**
     * @var \garethp\ews\API\Type\UserIdType
     */
    protected $userId = null;

    /**
     * @var boolean
     */
    protected $canCreateItems = null;

    /**
     * @var boolean
     */
    protected $canCreateSubFolders = null;

    /**
     * @var boolean
     */
    protected $isFolderOwner = null;

    /**
     * @var boolean
     */
    protected $isFolderVisible = null;

    /**
     * @var boolean
     */
    protected $isFolderContact = null;

    /**
     * @var string
     */
    protected $editItems = null;

    /**
     * @var string
     */
    protected $deleteItems = null;

    /**
     * @autogenerated This method is safe to replace
     * @return UserIdType
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value UserIdType
     * @return BasePermissionType
     */
    public function setUserId(UserIdType $value)
    {
        $this->userId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isCanCreateItems()
    {
        return ((bool) $this->canCreateItems);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getCanCreateItems()
    {
        return $this->canCreateItems;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return BasePermissionType
     */
    public function setCanCreateItems($value)
    {
        $this->canCreateItems = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isCanCreateSubFolders()
    {
        return ((bool) $this->canCreateSubFolders);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getCanCreateSubFolders()
    {
        return $this->canCreateSubFolders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return BasePermissionType
     */
    public function setCanCreateSubFolders($value)
    {
        $this->canCreateSubFolders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isFolderOwner()
    {
        return ((bool) $this->isFolderOwner);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsFolderOwner()
    {
        return $this->isFolderOwner;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return BasePermissionType
     */
    public function setIsFolderOwner($value)
    {
        $this->isFolderOwner = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isFolderVisible()
    {
        return ((bool) $this->isFolderVisible);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsFolderVisible()
    {
        return $this->isFolderVisible;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return BasePermissionType
     */
    public function setIsFolderVisible($value)
    {
        $this->isFolderVisible = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isFolderContact()
    {
        return ((bool) $this->isFolderContact);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsFolderContact()
    {
        return $this->isFolderContact;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return BasePermissionType
     */
    public function setIsFolderContact($value)
    {
        $this->isFolderContact = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getEditItems()
    {
        return $this->editItems;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return BasePermissionType
     */
    public function setEditItems($value)
    {
        $this->editItems = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDeleteItems()
    {
        return $this->deleteItems;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return BasePermissionType
     */
    public function setDeleteItems($value)
    {
        $this->deleteItems = $value;
        return $this;
    }
}
