<?php

namespace garethp\ews\API\Type;

/**
 * Class representing CalendarViewType
 *
 *
 * XSD Type: CalendarViewType
 */
class CalendarViewType extends BasePagingType
{

    /**
     * @var \DateTime
     */
    protected $startDate = null;

    /**
     * @var \DateTime
     */
    protected $endDate = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return CalendarViewType
     */
    public function setStartDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->startDate = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return CalendarViewType
     */
    public function setEndDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->endDate = $value;
        return $this;
    }
}
