<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ConversationActionType
 *
 *
 * XSD Type: ConversationActionType
 */
class ConversationActionType extends Type
{

    /**
     * @var string
     */
    protected $action = null;

    /**
     * @var \garethp\ews\API\Type\ItemIdType
     */
    protected $conversationId = null;

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $contextFolderId = null;

    /**
     * @var \DateTime
     */
    protected $conversationLastSyncTime = null;

    /**
     * @var boolean
     */
    protected $processRightAway = null;

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $destinationFolderId = null;

    /**
     * @var string[]
     */
    protected $categories = null;

    /**
     * @var boolean
     */
    protected $enableAlwaysDelete = null;

    /**
     * @var boolean
     */
    protected $isRead = null;

    /**
     * @var string
     */
    protected $deleteType = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationActionType
     */
    public function setAction($value)
    {
        $this->action = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return ConversationActionType
     */
    public function setConversationId(ItemIdType $value)
    {
        $this->conversationId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TargetFolderIdType
     */
    public function getContextFolderId()
    {
        return $this->contextFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TargetFolderIdType
     * @return ConversationActionType
     */
    public function setContextFolderId(TargetFolderIdType $value)
    {
        $this->contextFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getConversationLastSyncTime()
    {
        return $this->conversationLastSyncTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return ConversationActionType
     */
    public function setConversationLastSyncTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->conversationLastSyncTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isProcessRightAway()
    {
        return ((bool) $this->processRightAway);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getProcessRightAway()
    {
        return $this->processRightAway;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ConversationActionType
     */
    public function setProcessRightAway($value)
    {
        $this->processRightAway = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TargetFolderIdType
     */
    public function getDestinationFolderId()
    {
        return $this->destinationFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TargetFolderIdType
     * @return ConversationActionType
     */
    public function setDestinationFolderId(TargetFolderIdType $value)
    {
        $this->destinationFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationActionType
     */
    public function addCategories($value)
    {
        if ($this->categories === null) {
                        $this->categories = array();
        }

        if (!is_array($this->categories)) {
            $this->categories = array($this->categories);
        }

        $this->categories[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationActionType
     */
    public function setCategories(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->categories = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isEnableAlwaysDelete()
    {
        return ((bool) $this->enableAlwaysDelete);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getEnableAlwaysDelete()
    {
        return $this->enableAlwaysDelete;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ConversationActionType
     */
    public function setEnableAlwaysDelete($value)
    {
        $this->enableAlwaysDelete = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isRead()
    {
        return ((bool) $this->isRead);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsRead()
    {
        return $this->isRead;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ConversationActionType
     */
    public function setIsRead($value)
    {
        $this->isRead = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDeleteType()
    {
        return $this->deleteType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationActionType
     */
    public function setDeleteType($value)
    {
        $this->deleteType = $value;
        return $this;
    }
}
