<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing DurationType
 *
 *
 * XSD Type: Duration
 */
class DurationType extends Type
{

    /**
     * @var \DateTime
     */
    protected $startTime = null;

    /**
     * @var \DateTime
     */
    protected $endTime = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->startTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return DurationType
     */
    public function setStartTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->startTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return DurationType
     */
    public function setEndTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->endTime = $value;
        return $this;
    }
}
