<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing InvalidRecipientType
 *
 *
 * XSD Type: InvalidRecipientType
 */
class InvalidRecipientType extends Type
{

    /**
     * @var string
     */
    protected $smtpAddress = null;

    /**
     * @var string
     */
    protected $responseCode = null;

    /**
     * @var string
     */
    protected $messageText = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSmtpAddress()
    {
        return $this->smtpAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return InvalidRecipientType
     */
    public function setSmtpAddress($value)
    {
        $this->smtpAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return InvalidRecipientType
     */
    public function setResponseCode($value)
    {
        $this->responseCode = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMessageText()
    {
        return $this->messageText;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return InvalidRecipientType
     */
    public function setMessageText($value)
    {
        $this->messageText = $value;
        return $this;
    }
}
